/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.gson.FieldNamingPolicy;
import com.google.maps.GeoApiContext;
import com.google.maps.PendingResult;
import com.google.maps.internal.ApiResponse;
import com.google.maps.internal.ExceptionsAllowedToRetry;
import com.google.maps.internal.OkHttpPendingResult;
import com.google.maps.internal.RateLimitExecutorService;
import com.squareup.okhttp.Dispatcher;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import java.net.Proxy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpRequestHandler
implements GeoApiContext.RequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger((String)OkHttpRequestHandler.class.getName());
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final OkHttpClient client = new OkHttpClient();
    private final RateLimitExecutorService rateLimitExecutorService = new RateLimitExecutorService();

    public OkHttpRequestHandler() {
        this.client.setDispatcher(new Dispatcher((ExecutorService)this.rateLimitExecutorService));
    }

    @Override
    public <T, R extends ApiResponse<T>> PendingResult<T> handle(String hostName, String url, String userAgent, Class<R> clazz, FieldNamingPolicy fieldNamingPolicy, long errorTimeout, Integer maxRetries, ExceptionsAllowedToRetry exceptionsAllowedToRetry) {
        Request req = new Request.Builder().get().header("User-Agent", userAgent).url(hostName + url).build();
        LOG.info("Request: {}", (Object)(hostName + url));
        return new OkHttpPendingResult(req, this.client, clazz, fieldNamingPolicy, errorTimeout, maxRetries, exceptionsAllowedToRetry);
    }

    @Override
    public <T, R extends ApiResponse<T>> PendingResult<T> handlePost(String hostName, String url, String payload, String userAgent, Class<R> clazz, FieldNamingPolicy fieldNamingPolicy, long errorTimeout, Integer maxRetries, ExceptionsAllowedToRetry exceptionsAllowedToRetry) {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)payload);
        Request req = new Request.Builder().post(body).header("User-Agent", userAgent).url(hostName + url).build();
        return new OkHttpPendingResult(req, this.client, clazz, fieldNamingPolicy, errorTimeout, maxRetries, exceptionsAllowedToRetry);
    }

    @Override
    public void setConnectTimeout(long timeout, TimeUnit unit) {
        this.client.setConnectTimeout(timeout, unit);
    }

    @Override
    public void setReadTimeout(long timeout, TimeUnit unit) {
        this.client.setReadTimeout(timeout, unit);
    }

    @Override
    public void setWriteTimeout(long timeout, TimeUnit unit) {
        this.client.setWriteTimeout(timeout, unit);
    }

    @Override
    public void setQueriesPerSecond(int maxQps) {
        this.rateLimitExecutorService.setQueriesPerSecond(maxQps);
    }

    @Override
    public void setQueriesPerSecond(int maxQps, int minimumInterval) {
        this.rateLimitExecutorService.setQueriesPerSecond(maxQps, minimumInterval);
    }

    @Override
    public void setProxy(Proxy proxy) {
        this.client.setProxy(proxy);
    }
}

