/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.maps.DirectionsApi;
import com.google.maps.DistanceMatrixApi;
import com.google.maps.GeoApiContext;
import com.google.maps.PendingResultBase;
import com.google.maps.internal.StringJoin;
import com.google.maps.model.DistanceMatrix;
import com.google.maps.model.LatLng;
import com.google.maps.model.TravelMode;
import com.google.maps.model.Unit;
import org.joda.time.ReadableInstant;

public class DistanceMatrixApiRequest
extends PendingResultBase<DistanceMatrix, DistanceMatrixApiRequest, DistanceMatrixApi.Response> {
    public DistanceMatrixApiRequest(GeoApiContext context) {
        super(context, DistanceMatrixApi.Response.class, "/maps/api/distancematrix/json");
    }

    @Override
    protected void validateRequest() {
        if (!this.params().containsKey("origins")) {
            throw new IllegalArgumentException("Request must contain 'origins'");
        }
        if (!this.params().containsKey("destinations")) {
            throw new IllegalArgumentException("Request must contain 'destinations'");
        }
    }

    public DistanceMatrixApiRequest origins(String ... origins) {
        return (DistanceMatrixApiRequest)this.param("origins", StringJoin.join('|', origins));
    }

    public DistanceMatrixApiRequest origins(LatLng ... points) {
        return (DistanceMatrixApiRequest)this.param("origins", StringJoin.join('|', points));
    }

    public DistanceMatrixApiRequest destinations(String ... destinations) {
        return (DistanceMatrixApiRequest)this.param("destinations", StringJoin.join('|', destinations));
    }

    public DistanceMatrixApiRequest destinations(LatLng ... points) {
        return (DistanceMatrixApiRequest)this.param("destinations", StringJoin.join('|', points));
    }

    public DistanceMatrixApiRequest mode(TravelMode mode) {
        if (TravelMode.DRIVING.equals(mode) || TravelMode.WALKING.equals(mode) || TravelMode.BICYCLING.equals(mode)) {
            return (DistanceMatrixApiRequest)this.param("mode", mode);
        }
        throw new IllegalArgumentException("Distance Matrix API travel modes must be Driving, Walking or Bicycling");
    }

    public DistanceMatrixApiRequest avoid(DirectionsApi.RouteRestriction restriction) {
        return (DistanceMatrixApiRequest)this.param("avoid", restriction);
    }

    public DistanceMatrixApiRequest units(Unit unit) {
        return (DistanceMatrixApiRequest)this.param("units", unit);
    }

    public DistanceMatrixApiRequest departureTime(ReadableInstant departureTime) {
        return (DistanceMatrixApiRequest)this.param("departure_time", Long.toString(departureTime.getMillis() / 1000L));
    }
}

