/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.internal;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.maps.PendingResult;
import com.google.maps.errors.ApiException;
import com.google.maps.errors.OverQueryLimitException;
import com.google.maps.internal.AddressComponentTypeAdapter;
import com.google.maps.internal.AddressTypeAdapter;
import com.google.maps.internal.ApiResponse;
import com.google.maps.internal.DateTimeAdapter;
import com.google.maps.internal.DistanceAdapter;
import com.google.maps.internal.DurationAdapter;
import com.google.maps.internal.TravelModeAdapter;
import com.google.maps.model.AddressComponentType;
import com.google.maps.model.AddressType;
import com.google.maps.model.Distance;
import com.google.maps.model.Duration;
import com.google.maps.model.TravelMode;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Logger;
import org.joda.time.DateTime;

public class OkHttpPendingResult<T, R extends ApiResponse<T>>
implements PendingResult<T>,
Callback {
    private final Request request;
    private final OkHttpClient client;
    private final Class<R> responseClass;
    private final FieldNamingPolicy fieldNamingPolicy;
    private Call call;
    private PendingResult.Callback<T> callback;
    private long errorTimeOut;
    private int retryCounter = 0;
    private long cumulativeSleepTime = 0L;
    private static Logger log = Logger.getLogger(OkHttpPendingResult.class.getName());
    private static final List<Integer> RETRY_ERROR_CODES = Arrays.asList(500, 503, 504);

    public OkHttpPendingResult(Request request, OkHttpClient client, Class<R> responseClass, FieldNamingPolicy fieldNamingPolicy, long errorTimeOut) {
        this.request = request;
        this.client = client;
        this.responseClass = responseClass;
        this.fieldNamingPolicy = fieldNamingPolicy;
        this.errorTimeOut = errorTimeOut;
        this.call = client.newCall(request);
    }

    @Override
    public void setCallback(PendingResult.Callback<T> callback) {
        this.callback = callback;
        this.call.enqueue((Callback)this);
    }

    @Override
    public T await() throws Exception {
        if (this.retryCounter > 0) {
            double delaySecs = 0.5 * Math.pow(1.5, this.retryCounter - 1);
            long delayMillis = (long)(delaySecs * (Math.random() + 0.5) * 1000.0);
            log.config(String.format("Sleeping between errors for %dms (retry #%d, already slept %dms)", delayMillis, this.retryCounter, this.cumulativeSleepTime));
            this.cumulativeSleepTime += delayMillis;
            try {
                Thread.sleep(delayMillis);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        final ArrayBlockingQueue waiter = new ArrayBlockingQueue(1);
        final OkHttpPendingResult parent = this;
        this.call.enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                waiter.add(new QueuedResponse(parent, e));
            }

            public void onResponse(Response response) throws IOException {
                waiter.add(new QueuedResponse(parent, response));
            }
        });
        QueuedResponse r = (QueuedResponse)waiter.take();
        if (r.response != null) {
            return this.parseResponse(r.request, r.response);
        }
        throw r.e;
    }

    @Override
    public T awaitIgnoreError() {
        try {
            return this.await();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void cancel() {
        this.call.cancel();
    }

    public void onFailure(Request request, IOException ioe) {
        if (this.callback != null) {
            this.callback.onFailure(ioe);
        }
    }

    public void onResponse(Response response) throws IOException {
        if (this.callback != null) {
            try {
                this.callback.onResult(this.parseResponse(this, response));
            }
            catch (Exception e) {
                this.callback.onFailure(e);
            }
        }
    }

    private T parseResponse(OkHttpPendingResult<T, R> request, Response response) throws Exception {
        if (RETRY_ERROR_CODES.contains(response.code()) && this.cumulativeSleepTime < this.errorTimeOut) {
            return super.retry();
        }
        if (!response.isSuccessful()) {
            throw new IOException(String.format("Server Error: %d %s", response.code(), response.message()));
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(AddressComponentType.class, (Object)new AddressComponentTypeAdapter()).registerTypeAdapter(AddressType.class, (Object)new AddressTypeAdapter()).registerTypeAdapter(DateTime.class, (Object)new DateTimeAdapter()).registerTypeAdapter(Distance.class, (Object)new DistanceAdapter()).registerTypeAdapter(Duration.class, (Object)new DurationAdapter()).registerTypeAdapter(TravelMode.class, (Object)new TravelModeAdapter()).setFieldNamingPolicy(this.fieldNamingPolicy).create();
        InputStream in = response.body().byteStream();
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.IGNORE);
        InputStreamReader reader = new InputStreamReader(in, decoder);
        ApiResponse resp = (ApiResponse)gson.fromJson((Reader)reader, this.responseClass);
        if (resp.successful()) {
            return resp.getResult();
        }
        ApiException e = resp.getError();
        if (e instanceof OverQueryLimitException && this.cumulativeSleepTime < this.errorTimeOut) {
            return super.retry();
        }
        throw e;
    }

    private T retry() throws Exception {
        ++this.retryCounter;
        int n = this.retryCounter;
        log.info(new StringBuilder(36).append("Retrying request. Retry #").append(n).toString());
        this.call = this.client.newCall(this.request);
        return this.await();
    }

    private class QueuedResponse {
        public final OkHttpPendingResult<T, R> request;
        public final Response response;
        public final Exception e;

        public QueuedResponse(OkHttpPendingResult<T, R> request, Response response) {
            this.request = request;
            this.response = response;
            this.e = null;
        }

        public QueuedResponse(OkHttpPendingResult<T, R> request, Exception e) {
            this.request = request;
            this.response = null;
            this.e = e;
        }
    }
}

