/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class RateLimitExecutorService
implements ExecutorService {
    private static final Logger log = Logger.getLogger(RateLimitExecutorService.class.getName());
    private final ExecutorService delegate = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), RateLimitExecutorService.threadFactory("Rate Limited Dispatcher", true));
    private final Thread delayThread;
    private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();

    public RateLimitExecutorService(final int queriesPerSecond, final int minimumDelay) {
        this.delayThread = new Thread(new Runnable(){
            private List<DateTime> sentTimes;
            private DateTime lastSentTime;
            {
                this.sentTimes = new ArrayList<DateTime>(queriesPerSecond);
                this.lastSentTime = new DateTime(0L);
            }

            @Override
            public void run() {
                try {
                    while (!RateLimitExecutorService.this.delegate.isShutdown()) {
                        long delay;
                        Runnable r = (Runnable)RateLimitExecutorService.this.queue.take();
                        long requiredSeparationDelay = this.lastSentTime.plusMillis(minimumDelay).getMillis() - System.currentTimeMillis();
                        if (requiredSeparationDelay > 0L) {
                            Thread.sleep(requiredSeparationDelay);
                        }
                        DateTime oneSecondAgo = new DateTime().minusSeconds(1);
                        while (this.sentTimes.size() > 0 && this.sentTimes.get(0).compareTo((ReadableInstant)oneSecondAgo) < 0) {
                            this.sentTimes.remove(0);
                        }
                        long l = delay = this.sentTimes.size() > 0 ? this.sentTimes.get(0).plusSeconds(1).getMillis() - System.currentTimeMillis() : 0L;
                        if (this.sentTimes.size() < queriesPerSecond || delay <= 0L) {
                            RateLimitExecutorService.this.delegate.execute(r);
                            this.lastSentTime = new DateTime();
                            this.sentTimes.add(this.lastSentTime);
                            continue;
                        }
                        RateLimitExecutorService.this.queue.add(r);
                        Thread.sleep(delay);
                    }
                }
                catch (InterruptedException ie) {
                    log.log(Level.INFO, "Interupted", ie);
                }
            }
        });
        this.delayThread.setDaemon(true);
        this.delayThread.start();
    }

    private static ThreadFactory threadFactory(final String name, final boolean daemon) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread result = new Thread(runnable, name);
                result.setDaemon(daemon);
                return result;
            }
        };
    }

    @Override
    public void execute(Runnable runnable) {
        this.queue.add(runnable);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.awaitTermination(l, timeUnit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> tCallable) {
        return this.delegate.submit(tCallable);
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        return this.delegate.submit(runnable, t);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.delegate.submit(runnable);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables) throws InterruptedException {
        return this.delegate.invokeAll(callables);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables, long l, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.invokeAll(callables, l, timeUnit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> callables) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(callables);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> callables, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(callables, l, timeUnit);
    }
}

