/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.model;

import com.google.maps.internal.StringJoin;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum LocationType implements StringJoin.UrlValue
{
    ROOFTOP,
    RANGE_INTERPOLATED,
    GEOMETRIC_CENTER,
    APPROXIMATE,
    UNKNOWN;

    private static Logger log;

    @Override
    public String toUrlValue() {
        if (this == UNKNOWN) {
            throw new UnsupportedOperationException("Shouldn't use LocationType.UNKNOWN in a request.");
        }
        return this.toString();
    }

    public LocationType lookup(String locationType) {
        if (locationType.equalsIgnoreCase(ROOFTOP.toString())) {
            return ROOFTOP;
        }
        if (locationType.equalsIgnoreCase(RANGE_INTERPOLATED.toString())) {
            return RANGE_INTERPOLATED;
        }
        if (locationType.equalsIgnoreCase(GEOMETRIC_CENTER.toString())) {
            return GEOMETRIC_CENTER;
        }
        if (locationType.equalsIgnoreCase(APPROXIMATE.toString())) {
            return APPROXIMATE;
        }
        log.log(Level.WARNING, "Unknown location type '%s'", locationType);
        return UNKNOWN;
    }

    static {
        log = Logger.getLogger(LocationType.class.getName());
    }
}

