/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.model;

import com.google.maps.internal.StringJoin;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum TravelMode implements StringJoin.UrlValue
{
    DRIVING("driving"),
    WALKING("walking"),
    BICYCLING("bicycling"),
    TRANSIT("transit"),
    UNKNOWN("unknown");

    private static Logger log;
    private final String mode;

    private TravelMode(String mode) {
        this.mode = mode;
    }

    public String toString() {
        return this.mode;
    }

    public static TravelMode lookup(String travelMode) {
        if (travelMode.equalsIgnoreCase(DRIVING.toString())) {
            return DRIVING;
        }
        if (travelMode.equalsIgnoreCase(WALKING.toString())) {
            return WALKING;
        }
        if (travelMode.equalsIgnoreCase(BICYCLING.toString())) {
            return BICYCLING;
        }
        if (travelMode.equalsIgnoreCase(TRANSIT.toString())) {
            return TRANSIT;
        }
        log.log(Level.WARNING, "Unknown Travel Mode '%s'", travelMode);
        return UNKNOWN;
    }

    @Override
    public String toUrlValue() {
        if (this == UNKNOWN) {
            throw new UnsupportedOperationException("Shouldn't use TravelMode.UNKNOWN in a request.");
        }
        return this.mode;
    }

    static {
        log = Logger.getLogger(TravelMode.class.getName());
    }
}

