/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.gson.FieldNamingPolicy;
import com.google.maps.GeoApiContext;
import com.google.maps.PendingResultBase;
import com.google.maps.errors.ApiException;
import com.google.maps.internal.ApiConfig;
import com.google.maps.internal.ApiResponse;
import com.google.maps.model.LatLng;
import com.google.maps.model.PlaceDetails;
import com.google.maps.model.PlacesSearchResponse;
import com.google.maps.model.PlacesSearchResult;

public class TextSearchRequest
extends PendingResultBase<PlacesSearchResponse, TextSearchRequest, Response> {
    static final ApiConfig API_CONFIG = new ApiConfig("/maps/api/place/textsearch/json").fieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);

    protected TextSearchRequest(GeoApiContext context) {
        super(context, API_CONFIG, Response.class);
    }

    public TextSearchRequest query(String query) {
        return (TextSearchRequest)this.param("query", query);
    }

    public TextSearchRequest location(LatLng location) {
        return (TextSearchRequest)this.param("location", location);
    }

    public TextSearchRequest radius(int radius) {
        if (radius > 50000) {
            throw new IllegalArgumentException("The maximum allowed radius is 50,000 meters.");
        }
        return (TextSearchRequest)this.param("radius", String.valueOf(radius));
    }

    public TextSearchRequest minPrice(PlaceDetails.PriceLevel priceLevel) {
        return (TextSearchRequest)this.param("minprice", priceLevel);
    }

    public TextSearchRequest maxPrice(PlaceDetails.PriceLevel priceLevel) {
        return (TextSearchRequest)this.param("maxprice", priceLevel);
    }

    public TextSearchRequest openNow(boolean openNow) {
        return (TextSearchRequest)this.param("opennow", String.valueOf(openNow));
    }

    public TextSearchRequest pageToken(String nextPageToken) {
        return (TextSearchRequest)this.param("pagetoken", nextPageToken);
    }

    @Override
    protected void validateRequest() {
        if (!this.params().containsKey("query") && !this.params().containsKey("pagetoken")) {
            throw new IllegalArgumentException("Request must contain 'query' or a 'pageToken'.");
        }
        if (this.params().containsKey("location") && !this.params().containsKey("radius")) {
            throw new IllegalArgumentException("Request must contain 'radius' parameter when it contains a 'location' parameter.");
        }
    }

    public static class Response
    implements ApiResponse<PlacesSearchResponse> {
        public String status;
        public String[] htmlAttributions;
        public PlacesSearchResult[] results;
        public String nextPageToken;
        public String errorMessage;

        @Override
        public boolean successful() {
            return "OK".equals(this.status) || "ZERO_RESULTS".equals(this.status);
        }

        @Override
        public PlacesSearchResponse getResult() {
            PlacesSearchResponse result = new PlacesSearchResponse();
            result.htmlAttributions = this.htmlAttributions;
            result.results = this.results;
            result.nextPageToken = this.nextPageToken;
            return result;
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.status, this.errorMessage);
        }
    }
}

