/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.maps.DistanceMatrixApiRequest;
import com.google.maps.GeoApiContext;
import com.google.maps.errors.ApiException;
import com.google.maps.internal.ApiConfig;
import com.google.maps.internal.ApiResponse;
import com.google.maps.model.DistanceMatrix;
import com.google.maps.model.DistanceMatrixRow;

public class DistanceMatrixApi {
    static final ApiConfig API_CONFIG = new ApiConfig("/maps/api/distancematrix/json");

    private DistanceMatrixApi() {
    }

    public static DistanceMatrixApiRequest newRequest(GeoApiContext context) {
        return new DistanceMatrixApiRequest(context);
    }

    public static DistanceMatrixApiRequest getDistanceMatrix(GeoApiContext context, String[] origins, String[] destinations) {
        return DistanceMatrixApi.newRequest(context).origins(origins).destinations(destinations);
    }

    static class Response
    implements ApiResponse<DistanceMatrix> {
        public String status;
        public String errorMessage;
        public String[] originAddresses;
        public String[] destinationAddresses;
        public DistanceMatrixRow[] rows;

        Response() {
        }

        @Override
        public boolean successful() {
            return "OK".equals(this.status);
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.status, this.errorMessage);
        }

        @Override
        public DistanceMatrix getResult() {
            return new DistanceMatrix(this.originAddresses, this.destinationAddresses, this.rows);
        }
    }
}

