/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.gson.FieldNamingPolicy;
import com.google.maps.OkHttpRequestHandler;
import com.google.maps.PendingResult;
import com.google.maps.errors.ApiException;
import com.google.maps.errors.OverQueryLimitException;
import com.google.maps.internal.ApiConfig;
import com.google.maps.internal.ApiResponse;
import com.google.maps.internal.ExceptionsAllowedToRetry;
import com.google.maps.internal.UrlSigner;
import com.google.maps.metrics.NoOpRequestMetricsReporter;
import com.google.maps.metrics.RequestMetrics;
import com.google.maps.metrics.RequestMetricsReporter;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GeoApiContext
implements Closeable {
    private static final String VERSION = "2.0.0";
    private static final String USER_AGENT = "GoogleGeoApiClientJava/2.0.0";
    private static final int DEFAULT_BACKOFF_TIMEOUT_MILLIS = 60000;
    private final RequestHandler requestHandler;
    private final String apiKey;
    private final String baseUrlOverride;
    private final String channel;
    private final String clientId;
    private final long errorTimeout;
    private final ExceptionsAllowedToRetry exceptionsAllowedToRetry;
    private final Integer maxRetries;
    private final UrlSigner urlSigner;
    private final RequestMetricsReporter requestMetricsReporter;
    private final Map<String, String> defaultHeaders = new HashMap<String, String>();

    GeoApiContext(RequestHandler requestHandler, String apiKey, String baseUrlOverride, String channel, String clientId, long errorTimeout, ExceptionsAllowedToRetry exceptionsAllowedToRetry, Integer maxRetries, UrlSigner urlSigner, RequestMetricsReporter requestMetricsReporter) {
        this.requestHandler = requestHandler;
        this.apiKey = apiKey;
        this.baseUrlOverride = baseUrlOverride;
        this.channel = channel;
        this.clientId = clientId;
        this.errorTimeout = errorTimeout;
        this.exceptionsAllowedToRetry = exceptionsAllowedToRetry;
        this.maxRetries = maxRetries;
        this.urlSigner = urlSigner;
        this.requestMetricsReporter = requestMetricsReporter;
        this.defaultHeaders.put("User-Agent", USER_AGENT);
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }

    public void shutdown() {
        this.requestHandler.shutdown();
    }

    private Map<String, String> addDefaultHeaders(Map<String, String> headers) {
        HashMap<String, String> newHeaders = new HashMap<String, String>(headers);
        for (Map.Entry<String, String> entry : this.defaultHeaders.entrySet()) {
            if (newHeaders.containsKey(entry.getKey())) continue;
            newHeaders.put(entry.getKey(), entry.getValue());
        }
        return newHeaders;
    }

    <T, R extends ApiResponse<T>> PendingResult<T> get(ApiConfig config, Class<? extends R> clazz, Map<String, String> headers, Map<String, List<String>> params) {
        if (this.channel != null && !this.channel.isEmpty() && !params.containsKey("channel")) {
            params.put("channel", Collections.singletonList(this.channel));
        }
        StringBuilder query = new StringBuilder();
        for (Map.Entry<String, List<String>> param : params.entrySet()) {
            List<String> values = param.getValue();
            for (String value : values) {
                query.append('&').append(param.getKey()).append("=");
                try {
                    query.append(URLEncoder.encode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return this.getWithPath(clazz, config.fieldNamingPolicy, config.hostName, config.path, config.supportsClientId, query.toString(), this.requestMetricsReporter.newRequest(config.path), headers);
    }

    <T, R extends ApiResponse<T>> PendingResult<T> get(ApiConfig config, Class<? extends R> clazz, Map<String, List<String>> params) {
        return this.get(config, clazz, Collections.emptyMap(), params);
    }

    <T, R extends ApiResponse<T>> PendingResult<T> get(ApiConfig config, Class<? extends R> clazz, Map<String, String> headers, String ... params) {
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("Params must be matching key/value pairs.");
        }
        StringBuilder query = new StringBuilder();
        boolean channelSet = false;
        for (int i = 0; i < params.length; i += 2) {
            if (params[i].equals("channel")) {
                channelSet = true;
            }
            query.append('&').append(params[i]).append('=');
            try {
                query.append(URLEncoder.encode(params[i + 1], "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        if (!channelSet && this.channel != null && !this.channel.isEmpty()) {
            query.append("&channel=").append(this.channel);
        }
        Map<String, String> allHeaders = this.addDefaultHeaders(headers);
        return this.getWithPath(clazz, config.fieldNamingPolicy, config.hostName, config.path, config.supportsClientId, query.toString(), this.requestMetricsReporter.newRequest(config.path), allHeaders);
    }

    <T, R extends ApiResponse<T>> PendingResult<T> get(ApiConfig config, Class<? extends R> clazz, String ... params) {
        return this.get(config, clazz, Collections.emptyMap(), params);
    }

    <T, R extends ApiResponse<T>> PendingResult<T> post(ApiConfig config, Class<? extends R> clazz, Map<String, String> headers, Map<String, List<String>> params) {
        this.checkContext(config.supportsClientId);
        StringBuilder url = new StringBuilder(config.path);
        if (config.supportsClientId && this.clientId != null) {
            url.append("?client=").append(this.clientId);
        } else {
            url.append("?key=").append(this.apiKey);
        }
        if (config.supportsClientId && this.urlSigner != null) {
            String signature = this.urlSigner.getSignature(url.toString());
            url.append("&signature=").append(signature);
        }
        String hostName = config.hostName;
        if (this.baseUrlOverride != null) {
            hostName = this.baseUrlOverride;
        }
        Map<String, String> allHeaders = this.addDefaultHeaders(headers);
        return this.requestHandler.handlePost(hostName, url.toString(), params.get("_payload").get(0), allHeaders, clazz, config.fieldNamingPolicy, this.errorTimeout, this.maxRetries, this.exceptionsAllowedToRetry, this.requestMetricsReporter.newRequest(config.path));
    }

    <T, R extends ApiResponse<T>> PendingResult<T> post(ApiConfig config, Class<? extends R> clazz, Map<String, List<String>> params) {
        return this.post(config, clazz, Collections.emptyMap(), params);
    }

    private <T, R extends ApiResponse<T>> PendingResult<T> getWithPath(Class<R> clazz, FieldNamingPolicy fieldNamingPolicy, String hostName, String path, boolean canUseClientId, String encodedPath, RequestMetrics metrics, Map<String, String> headers) {
        this.checkContext(canUseClientId);
        if (!encodedPath.startsWith("&")) {
            throw new IllegalArgumentException("encodedPath must start with &");
        }
        StringBuilder url = new StringBuilder(path);
        if (canUseClientId && this.clientId != null) {
            url.append("?client=").append(this.clientId);
        } else {
            url.append("?key=").append(this.apiKey);
        }
        url.append(encodedPath);
        if (canUseClientId && this.urlSigner != null) {
            String signature = this.urlSigner.getSignature(url.toString());
            url.append("&signature=").append(signature);
        }
        if (this.baseUrlOverride != null) {
            hostName = this.baseUrlOverride;
        }
        Map<String, String> allHeaders = this.addDefaultHeaders(headers);
        return this.requestHandler.handle(hostName, url.toString(), allHeaders, clazz, fieldNamingPolicy, this.errorTimeout, this.maxRetries, this.exceptionsAllowedToRetry, metrics);
    }

    private void checkContext(boolean canUseClientId) {
        if (this.urlSigner == null && this.apiKey == null) {
            throw new IllegalStateException("Must provide either API key or Maps for Work credentials.");
        }
        if (!canUseClientId && this.apiKey == null) {
            throw new IllegalStateException("API does not support client ID & secret - you must provide a key");
        }
        if (this.urlSigner == null && !this.apiKey.startsWith("AIza")) {
            throw new IllegalStateException("Invalid API key.");
        }
    }

    public static class Builder {
        private RequestHandler.Builder builder;
        private String apiKey;
        private String baseUrlOverride;
        private String channel;
        private String clientId;
        private long errorTimeout = 60000L;
        private ExceptionsAllowedToRetry exceptionsAllowedToRetry = new ExceptionsAllowedToRetry();
        private Integer maxRetries;
        private UrlSigner urlSigner;
        private RequestMetricsReporter requestMetricsReporter = new NoOpRequestMetricsReporter();

        public Builder() {
            this.requestHandlerBuilder(new OkHttpRequestHandler.Builder());
        }

        public Builder(RequestHandler.Builder builder) {
            this.requestHandlerBuilder(builder);
        }

        public Builder requestHandlerBuilder(RequestHandler.Builder builder) {
            this.builder = builder;
            this.exceptionsAllowedToRetry.add(OverQueryLimitException.class);
            return this;
        }

        Builder baseUrlOverride(String baseUrl) {
            this.baseUrlOverride = baseUrl;
            return this;
        }

        @Deprecated
        Builder baseUrlForTesting(String baseUrl) {
            return this.baseUrlOverride(baseUrl);
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder enterpriseCredentials(String clientId, String cryptographicSecret) {
            this.clientId = clientId;
            try {
                this.urlSigner = new UrlSigner(cryptographicSecret);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
            return this;
        }

        public Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public Builder connectTimeout(long timeout, TimeUnit unit) {
            this.builder.connectTimeout(timeout, unit);
            return this;
        }

        public Builder readTimeout(long timeout, TimeUnit unit) {
            this.builder.readTimeout(timeout, unit);
            return this;
        }

        public Builder writeTimeout(long timeout, TimeUnit unit) {
            this.builder.writeTimeout(timeout, unit);
            return this;
        }

        public Builder retryTimeout(long timeout, TimeUnit unit) {
            this.errorTimeout = unit.toMillis(timeout);
            return this;
        }

        public Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder disableRetries() {
            this.maxRetries(0);
            this.retryTimeout(0L, TimeUnit.MILLISECONDS);
            return this;
        }

        public Builder queryRateLimit(int maxQps) {
            this.builder.queriesPerSecond(maxQps);
            return this;
        }

        public Builder setIfExceptionIsAllowedToRetry(Class<? extends ApiException> exception, boolean allowedToRetry) {
            if (allowedToRetry) {
                this.exceptionsAllowedToRetry.add(exception);
            } else {
                this.exceptionsAllowedToRetry.remove(exception);
            }
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.builder.proxy(proxy == null ? Proxy.NO_PROXY : proxy);
            return this;
        }

        public Builder proxyAuthentication(String proxyUserName, String proxyUserPassword) {
            this.builder.proxyAuthentication(proxyUserName, proxyUserPassword);
            return this;
        }

        public Builder requestMetricsReporter(RequestMetricsReporter requestMetricsReporter) {
            this.requestMetricsReporter = requestMetricsReporter;
            return this;
        }

        public GeoApiContext build() {
            return new GeoApiContext(this.builder.build(), this.apiKey, this.baseUrlOverride, this.channel, this.clientId, this.errorTimeout, this.exceptionsAllowedToRetry, this.maxRetries, this.urlSigner, this.requestMetricsReporter);
        }
    }

    public static interface RequestHandler {
        public <T, R extends ApiResponse<T>> PendingResult<T> handle(String var1, String var2, Map<String, String> var3, Class<R> var4, FieldNamingPolicy var5, long var6, Integer var8, ExceptionsAllowedToRetry var9, RequestMetrics var10);

        public <T, R extends ApiResponse<T>> PendingResult<T> handlePost(String var1, String var2, String var3, Map<String, String> var4, Class<R> var5, FieldNamingPolicy var6, long var7, Integer var9, ExceptionsAllowedToRetry var10, RequestMetrics var11);

        public void shutdown();

        public static interface Builder {
            public Builder connectTimeout(long var1, TimeUnit var3);

            public Builder readTimeout(long var1, TimeUnit var3);

            public Builder writeTimeout(long var1, TimeUnit var3);

            public Builder queriesPerSecond(int var1);

            public Builder proxy(Proxy var1);

            public Builder proxyAuthentication(String var1, String var2);

            public RequestHandler build();
        }
    }
}

