/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android;

import com.google.maps.android.PackageManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Context {
    private Class<?> contextClass;
    private Object contextInstance;
    private PackageManager packageManager;

    Context(@NotNull Class<?> contextClass) {
        this.contextClass = contextClass;
    }

    @Nullable
    public static Context getApplicationContext() {
        try {
            Class<?> contextClass = Class.forName("android.content.Context");
            return new Context(contextClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Nullable
    public String getPackageName() {
        try {
            Method method = this.contextClass.getMethod("getPackageName", new Class[0]);
            return (String)method.invoke(this.getContextInstance(), new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public PackageManager getPackageManager() {
        if (this.packageManager != null) {
            return this.packageManager;
        }
        try {
            Class<?> pmClass = Class.forName("android.content.pm.PackageManager");
            Method method = this.contextClass.getMethod("getPackageManager", new Class[0]);
            Object pm = method.invoke(this.getContextInstance(), new Object[0]);
            this.packageManager = new PackageManager(pmClass, pm);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return this.packageManager;
    }

    @Nullable
    private Object getContextInstance() {
        if (this.contextInstance != null) {
            return this.contextInstance;
        }
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Method method = activityThreadClass.getMethod("currentApplication", new Class[0]);
            this.contextInstance = method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return this.contextInstance;
    }
}

