/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.gson.FieldNamingPolicy;
import com.google.maps.GeoApiContext;
import com.google.maps.PendingResultBase;
import com.google.maps.RoadsApi;
import com.google.maps.internal.ApiConfig;
import com.google.maps.internal.StringJoin;
import com.google.maps.model.LatLng;
import com.google.maps.model.SnappedSpeedLimitResult;

public class SpeedLimitsApiRequest
extends PendingResultBase<SnappedSpeedLimitResult, SpeedLimitsApiRequest, RoadsApi.SpeedLimitsResponse> {
    private static final ApiConfig SPEEDS_API_CONFIG = new ApiConfig("/v1/speedLimits").hostName("https://roads.googleapis.com").supportsClientId(false).fieldNamingPolicy(FieldNamingPolicy.IDENTITY);

    public SpeedLimitsApiRequest(GeoApiContext context) {
        super(context, SPEEDS_API_CONFIG, RoadsApi.SpeedLimitsResponse.class);
    }

    @Override
    protected void validateRequest() {
        if (!this.params().containsKey("path") && !this.params().containsKey("placeId")) {
            throw new IllegalArgumentException("Request must contain either 'path' or 'placeId'");
        }
    }

    public SpeedLimitsApiRequest path(LatLng ... path) {
        return (SpeedLimitsApiRequest)this.param("path", StringJoin.join('|', path));
    }

    public SpeedLimitsApiRequest placeIds(String ... placeIds) {
        for (String placeId : placeIds) {
            this.paramAddToList("placeId", placeId);
        }
        return this;
    }
}

