/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android;

import com.google.maps.android.Context;
import com.google.maps.android.PackageInfo;
import com.google.maps.android.PackageManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CertificateHelper {
    @Nullable
    public static String getSigningCertificateSha1Fingerprint(@NotNull Context context) {
        PackageManager pm = context.getPackageManager();
        if (pm == null) {
            return null;
        }
        PackageInfo packageInfo = pm.getPackageInfo(context.getPackageName(), 64);
        if (packageInfo == null) {
            return null;
        }
        Object signingSignature = packageInfo.signingSignature();
        if (signingSignature == null) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            Class<?> signatureClass = Class.forName("android.content.pm.Signature");
            Method toByteArrayMethod = signatureClass.getMethod("toByteArray", new Class[0]);
            byte[] byteArray = (byte[])toByteArrayMethod.invoke(signingSignature, new Object[0]);
            byte[] digest = md.digest(byteArray);
            return CertificateHelper.bytesToHex(digest);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException | NoSuchAlgorithmException e) {
            return null;
        }
    }

    private static String bytesToHex(byte[] byteArray) {
        StringBuilder sb = new StringBuilder();
        for (byte b : byteArray) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }
}

