/*
 * Decompiled with CFR 0.152.
 */
package com.google.modernstorage.photopicker;

import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.CallSuper;
import androidx.core.os.BuildCompat;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@BuildCompat.PrereleaseSdkCheck
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00132\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001:\u0003\u0012\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0017J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\f\u001a\u00020\u0007H\u0002J&\u0010\r\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/google/modernstorage/photopicker/PhotoPicker;", "Landroidx/activity/result/contract/ActivityResultContract;", "Lcom/google/modernstorage/photopicker/PhotoPicker$Args;", "", "Landroid/net/Uri;", "()V", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "input", "getClipDataUris", "intent", "getSynchronousResult", "Landroidx/activity/result/contract/ActivityResultContract$SynchronousResult;", "parseResult", "resultCode", "", "Args", "Companion", "Type", "photopicker_release"})
public final class PhotoPicker
extends ActivityResultContract<Args, List<? extends Uri>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String INTENT_PICK_IMAGES = "android.provider.action.PICK_IMAGES";
    @NotNull
    private static final String EXTRA_PICK_IMAGES_MAX = "android.provider.extra.PICK_IMAGES_MAX";

    @CallSuper
    @NotNull
    public Intent createIntent(@NotNull Context context, @NotNull Args input) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (Companion.isPhotoPickerAvailable()) {
            Intent intent = new Intent(INTENT_PICK_IMAGES);
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$createIntent_u24lambda_u2d0 = intent;
            boolean bl3 = false;
            if (input.getMaxItems() > 1) {
                $this$createIntent_u24lambda_u2d0.putExtra(EXTRA_PICK_IMAGES_MAX, input.getMaxItems());
            }
            if (input.getType() == Type.IMAGES_ONLY) {
                $this$createIntent_u24lambda_u2d0.setType("image/*");
            } else if (input.getType() == Type.VIDEO_ONLY) {
                $this$createIntent_u24lambda_u2d0.setType("video/*");
            }
            Intent intent2 = intent;
            return intent2;
        }
        Intent intent = new Intent("android.intent.action.OPEN_DOCUMENT");
        boolean bl = false;
        boolean bl4 = false;
        Intent $this$createIntent_u24lambda_u2d1 = intent;
        boolean bl5 = false;
        $this$createIntent_u24lambda_u2d1.setType("*/*");
        if (input.getMaxItems() > 1) {
            $this$createIntent_u24lambda_u2d1.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
        }
        Type type = input.getType();
        int n = WhenMappings.$EnumSwitchMapping$0[type.ordinal()];
        switch (n) {
            case 1: {
                String[] stringArray = new String[]{"image/*"};
                $this$createIntent_u24lambda_u2d1.putExtra("android.intent.extra.MIME_TYPES", stringArray);
                break;
            }
            case 2: {
                String[] stringArray = new String[]{"video/*"};
                $this$createIntent_u24lambda_u2d1.putExtra("android.intent.extra.MIME_TYPES", stringArray);
                break;
            }
            case 3: {
                String[] stringArray = new String[]{"image/*", "video/*"};
                $this$createIntent_u24lambda_u2d1.putExtra("android.intent.extra.MIME_TYPES", stringArray);
            }
        }
        Intent intent3 = intent;
        return intent3;
    }

    @Nullable
    public ActivityResultContract.SynchronousResult<List<Uri>> getSynchronousResult(@NotNull Context context, @NotNull Args input) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return null;
    }

    @NotNull
    public List<Uri> parseResult(int resultCode, @Nullable Intent intent) {
        return resultCode != -1 || intent == null ? CollectionsKt.emptyList() : this.getClipDataUris(intent);
    }

    private final List<Uri> getClipDataUris(Intent intent) {
        int n;
        int n2;
        ClipData clipData;
        LinkedHashSet<Uri> resultSet = new LinkedHashSet<Uri>();
        if (intent.getData() != null) {
            Uri uri = intent.getData();
            Intrinsics.checkNotNull((Object)uri);
            resultSet.add(uri);
        }
        if ((clipData = intent.getClipData()) == null && resultSet.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (clipData != null && (n2 = 0) < (n = clipData.getItemCount())) {
            do {
                int i;
                Uri uri;
                if ((uri = clipData.getItemAt(i = n2++).getUri()) == null) continue;
                resultSet.add(uri);
            } while (n2 < n);
        }
        return new ArrayList(resultSet);
    }

    @JvmStatic
    public static final boolean isPhotoPickerAvailable() {
        return Companion.isPhotoPickerAvailable();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/google/modernstorage/photopicker/PhotoPicker$Companion;", "", "()V", "EXTRA_PICK_IMAGES_MAX", "", "INTENT_PICK_IMAGES", "isPhotoPickerAvailable", "", "photopicker_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isPhotoPickerAvailable() {
            return BuildCompat.isAtLeastT();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/google/modernstorage/photopicker/PhotoPicker$Type;", "", "(Ljava/lang/String;I)V", "IMAGES_ONLY", "VIDEO_ONLY", "IMAGES_AND_VIDEO", "photopicker_release"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type IMAGES_ONLY = new Type();
        public static final /* enum */ Type VIDEO_ONLY = new Type();
        public static final /* enum */ Type IMAGES_AND_VIDEO = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.IMAGES_ONLY, Type.VIDEO_ONLY, Type.IMAGES_AND_VIDEO};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/google/modernstorage/photopicker/PhotoPicker$Args;", "", "type", "Lcom/google/modernstorage/photopicker/PhotoPicker$Type;", "maxItems", "", "(Lcom/google/modernstorage/photopicker/PhotoPicker$Type;I)V", "getMaxItems", "()I", "getType", "()Lcom/google/modernstorage/photopicker/PhotoPicker$Type;", "photopicker_release"})
    public static final class Args {
        @NotNull
        private final Type type;
        private final int maxItems;

        public Args(@NotNull Type type, int maxItems) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.type = type;
            this.maxItems = maxItems;
        }

        @NotNull
        public final Type getType() {
            return this.type;
        }

        public final int getMaxItems() {
            return this.maxItems;
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            nArray[Type.IMAGES_ONLY.ordinal()] = 1;
            nArray[Type.VIDEO_ONLY.ordinal()] = 2;
            nArray[Type.IMAGES_AND_VIDEO.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

