/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics.contrib;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import com.google.monitoring.metrics.Metric;
import com.google.monitoring.metrics.MetricPoint;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

abstract class AbstractMetricSubject<T, S extends AbstractMetricSubject<T, S>>
extends Subject<S, Metric<T>> {
    protected final Set<ImmutableList<String>> expectedNondefaultLabelTuples = new HashSet<ImmutableList<String>>();
    protected final Function<MetricPoint<T>, String> metricPointConverter = metricPoint -> String.format("%s => %s", Joiner.on((char)':').join((Iterable)metricPoint.labelValues()), this.getMessageRepresentation(metricPoint.value()));
    private final Metric<T> actual;

    And<S> andChainer() {
        return new And<AbstractMetricSubject>(this);
    }

    protected AbstractMetricSubject(FailureMetadata metadata, Metric<T> actual) {
        super(metadata, Preconditions.checkNotNull(actual));
        this.actual = actual;
    }

    public String actualCustomStringRepresentation() {
        return this.actual.getMetricSchema().name();
    }

    public And<S> hasValueForLabels(T value, String ... labels) {
        MetricPoint<T> metricPoint = this.findMetricPointForLabels((ImmutableList<String>)ImmutableList.copyOf((Object[])labels));
        if (metricPoint == null) {
            this.failWithBadResults("has a value for labels", Joiner.on((char)':').join((Object[])labels), "has labeled values", Lists.transform((List)Ordering.natural().sortedCopy((Iterable)this.actual.getTimestampedValues()), this.metricPointConverter));
        }
        if (!metricPoint.value().equals(value)) {
            this.failWithBadResults(String.format("has a value of %s for labels", this.getMessageRepresentation(value)), Joiner.on((char)':').join((Object[])labels), "has a value of", this.getMessageRepresentation(metricPoint.value()));
        }
        this.expectedNondefaultLabelTuples.add((ImmutableList<String>)ImmutableList.copyOf((Object[])labels));
        return this.andChainer();
    }

    public And<S> hasAnyValueForLabels(String ... labels) {
        MetricPoint<T> metricPoint = this.findMetricPointForLabels((ImmutableList<String>)ImmutableList.copyOf((Object[])labels));
        if (metricPoint == null) {
            this.failWithBadResults("has a value for labels", Joiner.on((char)':').join((Object[])labels), "has labeled values", Lists.transform((List)Ordering.natural().sortedCopy((Iterable)this.actual.getTimestampedValues()), this.metricPointConverter));
        }
        if (this.hasDefaultValue(metricPoint)) {
            this.failWithBadResults("has a non-default value for labels", Joiner.on((char)':').join((Object[])labels), "has a value of", this.getMessageRepresentation(metricPoint.value()));
        }
        this.expectedNondefaultLabelTuples.add((ImmutableList<String>)ImmutableList.copyOf((Object[])labels));
        return this.andChainer();
    }

    protected And<S> doesNotHaveAnyValueForLabels(String ... labels) {
        MetricPoint<T> metricPoint = this.findMetricPointForLabels((ImmutableList<String>)ImmutableList.copyOf((Object[])labels));
        if (metricPoint != null) {
            this.failWithBadResults("has no value for labels", Joiner.on((char)':').join((Object[])labels), "has a value of", this.getMessageRepresentation(metricPoint.value()));
        }
        return this.andChainer();
    }

    public And<S> hasNoOtherValues() {
        for (MetricPoint metricPoint : this.actual.getTimestampedValues()) {
            if (this.expectedNondefaultLabelTuples.contains(metricPoint.labelValues())) continue;
            if (!this.hasDefaultValue(metricPoint)) {
                this.failWithBadResults("has", "no other nondefault values", "has labeled values", Lists.transform((List)Ordering.natural().sortedCopy((Iterable)this.actual.getTimestampedValues()), this.metricPointConverter));
            }
            return this.andChainer();
        }
        return this.andChainer();
    }

    @Nullable
    private MetricPoint<T> findMetricPointForLabels(ImmutableList<String> labels) {
        if (this.actual.getMetricSchema().labels().size() != labels.size()) {
            return null;
        }
        for (MetricPoint metricPoint : this.actual.getTimestampedValues()) {
            if (!metricPoint.labelValues().equals(labels)) continue;
            return metricPoint;
        }
        return null;
    }

    protected String getMessageRepresentation(T value) {
        return String.valueOf(value);
    }

    protected abstract boolean hasDefaultValue(MetricPoint<T> var1);

    public static class And<S extends AbstractMetricSubject<?, S>> {
        private final S subject;

        And(S subject) {
            this.subject = subject;
        }

        public S and() {
            return this.subject;
        }
    }
}

