/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics.contrib;

import com.google.common.base.Joiner;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Truth;
import com.google.monitoring.metrics.Distribution;
import com.google.monitoring.metrics.ImmutableDistribution;
import com.google.monitoring.metrics.Metric;
import com.google.monitoring.metrics.MetricPoint;
import com.google.monitoring.metrics.MutableDistribution;
import com.google.monitoring.metrics.contrib.AbstractMetricSubject;
import java.util.Map;
import javax.annotation.Nullable;

public final class DistributionMetricSubject
extends AbstractMetricSubject<Distribution, DistributionMetricSubject> {
    private final Metric<Distribution> actual;

    public static DistributionMetricSubject assertThat(@Nullable Metric<Distribution> metric) {
        return (DistributionMetricSubject)Truth.assertAbout(DistributionMetricSubject::new).that(metric);
    }

    private DistributionMetricSubject(FailureMetadata metadata, Metric<Distribution> actual) {
        super(metadata, actual);
        this.actual = actual;
    }

    @Override
    protected boolean hasDefaultValue(MetricPoint<Distribution> metricPoint) {
        return ((Distribution)metricPoint.value()).count() == 0L;
    }

    @Override
    protected String getMessageRepresentation(Distribution distribution) {
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        for (Map.Entry entry : distribution.intervalCounts().asMapOfRanges().entrySet()) {
            if ((Long)entry.getValue() == 0L) continue;
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            if (((Range)entry.getKey()).hasLowerBound()) {
                sb.append(((Range)entry.getKey()).lowerBoundType() == BoundType.CLOSED ? (char)'[' : '(');
                sb.append(((Range)entry.getKey()).lowerEndpoint());
            }
            sb.append("..");
            if (((Range)entry.getKey()).hasUpperBound()) {
                sb.append(((Range)entry.getKey()).upperEndpoint());
                sb.append(((Range)entry.getKey()).upperBoundType() == BoundType.CLOSED ? (char)']' : ')');
            }
            sb.append('=');
            sb.append(entry.getValue());
        }
        sb.append('}');
        return sb.toString();
    }

    public AbstractMetricSubject.And<DistributionMetricSubject> hasDataSetForLabels(ImmutableSet<? extends Number> dataSet, String ... labels) {
        ImmutableList metricPoints = this.actual.getTimestampedValues();
        if (metricPoints.isEmpty()) {
            this.failWithBadResults("has a distribution for labels", Joiner.on((char)':').join((Object[])labels), "has", "no values");
        }
        MutableDistribution targetDistribution = new MutableDistribution(((Distribution)((MetricPoint)metricPoints.get(0)).value()).distributionFitter());
        dataSet.forEach(data -> targetDistribution.add(data.doubleValue()));
        return this.hasValueForLabels(ImmutableDistribution.copyOf((Distribution)targetDistribution), labels);
    }
}

