/*
 * Decompiled with CFR 0.152.
 */
package com.google.mu.protobuf.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.mu.protobuf.util.MoreValues;
import com.google.mu.protobuf.util.StructBuilder;
import com.google.mu.util.stream.BiCollector;
import com.google.protobuf.ListValue;
import com.google.protobuf.Struct;
import com.google.protobuf.StructOrBuilder;
import com.google.protobuf.Value;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;

@CheckReturnValue
public final class MoreStructs {
    public static Struct struct(String name, boolean value) {
        return MoreStructs.struct(name, MoreValues.valueOf(value));
    }

    public static Struct struct(String name, double value) {
        return MoreStructs.struct(name, MoreValues.valueOf(value));
    }

    public static Struct struct(String name, String value) {
        return MoreStructs.struct(name, MoreValues.valueOf(value));
    }

    public static Struct struct(String name, Struct value) {
        return MoreStructs.struct(name, MoreValues.valueOf(value));
    }

    public static Struct struct(String name, Value value) {
        return Struct.newBuilder().putFields(name, value).build();
    }

    public static Struct struct(String name, ListValue value) {
        return MoreStructs.struct(name, MoreValues.valueOf(value));
    }

    public static <T> Collector<T, ?, Struct> toStruct(Function<? super T, ? extends CharSequence> keyFunction, Function<? super T, Value> valueFunction) {
        Preconditions.checkNotNull(keyFunction);
        Preconditions.checkNotNull(valueFunction);
        return Collector.of(StructBuilder::new, (builder, input) -> builder.add(((CharSequence)keyFunction.apply(input)).toString(), (Value)valueFunction.apply(input)), StructBuilder::addAllFields, StructBuilder::build, new Collector.Characteristics[0]);
    }

    public static BiCollector<CharSequence, Value, Struct> toStruct() {
        return MoreStructs::toStruct;
    }

    public static Collector<Struct, ?, Struct> flatteningToStruct() {
        return Collector.of(StructBuilder::new, StructBuilder::addAllFields, StructBuilder::addAllFields, StructBuilder::build, new Collector.Characteristics[0]);
    }

    public static Map<String, Object> asMap(StructOrBuilder struct) {
        return Maps.transformValues((Map)struct.getFieldsMap(), MoreValues::fromValue);
    }

    private MoreStructs() {
    }
}

