/*
 * Decompiled with CFR 0.152.
 */
package com.google.mu.protobuf.util;

import com.google.common.collect.Lists;
import com.google.common.math.DoubleMath;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.mu.protobuf.util.MoreStructs;
import com.google.protobuf.ListValue;
import com.google.protobuf.ListValueOrBuilder;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.StructOrBuilder;
import com.google.protobuf.Value;
import com.google.protobuf.ValueOrBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collector;
import javax.annotation.Nullable;

@CheckReturnValue
public final class MoreValues {
    public static final Value NULL = Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
    public static final Value TRUE = Value.newBuilder().setBoolValue(true).build();
    public static final Value FALSE = Value.newBuilder().setBoolValue(false).build();

    public static Value nullableValueOf(@Nullable String string) {
        return string == null ? NULL : MoreValues.valueOf(string);
    }

    public static ListValue listValueOf(double ... values) {
        return Arrays.stream(values).mapToObj(MoreValues::valueOf).collect(MoreValues.toListValue());
    }

    public static ListValue listValueOf(String ... values) {
        return Arrays.stream(values).map(MoreValues::nullableValueOf).collect(MoreValues.toListValue());
    }

    public static ListValue listValueOf(Struct ... values) {
        return Arrays.stream(values).map(MoreValues::nullableValueOf).collect(MoreValues.toListValue());
    }

    public static Collector<Value, ?, ListValue> toListValue() {
        return Collector.of(ListValue::newBuilder, ListValue.Builder::addValues, (a, b) -> a.addAllValues((Iterable)b.getValuesList()), ListValue.Builder::build, new Collector.Characteristics[0]);
    }

    @Nullable
    public static Object fromValue(ValueOrBuilder value) {
        switch (value.getKindCase()) {
            case NULL_VALUE: {
                return null;
            }
            case BOOL_VALUE: {
                return value.getBoolValue();
            }
            case STRING_VALUE: {
                return value.getStringValue();
            }
            case NUMBER_VALUE: {
                double v = value.getNumberValue();
                if (v >= -9.223372036854776E18 && v <= 9.223372036854776E18 && DoubleMath.isMathematicalInteger((double)v)) {
                    if (v >= -2.147483648E9 && v <= 2.147483647E9) {
                        return (int)v;
                    }
                    return (long)v;
                }
                return v;
            }
            case LIST_VALUE: {
                return MoreValues.asList((ListValueOrBuilder)value.getListValue());
            }
            case STRUCT_VALUE: {
                return MoreStructs.asMap((StructOrBuilder)value.getStructValue());
            }
        }
        throw new AssertionError((Object)("Unsupported value: " + value));
    }

    public static List<Object> asList(ListValueOrBuilder listValue) {
        return Lists.transform((List)listValue.getValuesList(), MoreValues::fromValue);
    }

    static Value valueOf(double n) {
        return Value.newBuilder().setNumberValue(n).build();
    }

    static Value valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    static Value valueOf(String s) {
        return Value.newBuilder().setStringValue(s).build();
    }

    static Value valueOf(Struct v) {
        return Value.newBuilder().setStructValue(v).build();
    }

    static Value valueOf(ListValue v) {
        return Value.newBuilder().setListValue(v).build();
    }

    private static Value nullableValueOf(@Nullable Struct struct) {
        return struct == null ? NULL : MoreValues.valueOf(struct);
    }

    private MoreValues() {
    }
}

