/*
 * Decompiled with CFR 0.152.
 */
package com.google.mu.protobuf.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.mu.protobuf.util.MoreValues;
import com.google.mu.util.stream.BiStream;
import com.google.protobuf.ListValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.util.LinkedHashMap;
import java.util.Map;

@CanIgnoreReturnValue
public final class StructBuilder {
    private final LinkedHashMap<String, Value> fields = new LinkedHashMap();

    public StructBuilder add(String name, boolean value) {
        return this.add(name, MoreValues.valueOf(value));
    }

    public StructBuilder add(String name, double value) {
        return this.add(name, MoreValues.valueOf(value));
    }

    public StructBuilder add(String name, String value) {
        return this.add(name, MoreValues.valueOf(value));
    }

    public StructBuilder add(String name, ListValue value) {
        return this.add(name, MoreValues.valueOf(value));
    }

    public StructBuilder add(String name, Iterable<Value> values) {
        ListValue.Builder listValue = ListValue.newBuilder();
        for (Value v : values) {
            listValue.addValues(v);
        }
        return this.add(name, listValue.build());
    }

    public StructBuilder add(String name, Map<String, Value> map) {
        return this.add(name, ((StructBuilder)BiStream.from(map).collect((Object)new StructBuilder(), StructBuilder::add)).build());
    }

    public StructBuilder add(String name, Struct struct) {
        return this.add(name, MoreValues.valueOf(struct));
    }

    public StructBuilder add(String name, StructBuilder struct) {
        Preconditions.checkArgument((this != struct ? 1 : 0) != 0, (Object)"Cannot add this builder to itself.");
        return this.add(name, struct.build());
    }

    public StructBuilder add(String name, Value value) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        Preconditions.checkArgument((this.fields.putIfAbsent(name, value) == null ? 1 : 0) != 0, (String)"Field %s already present", (Object)name);
        return this;
    }

    public StructBuilder addAll(Map<String, Value> map) {
        BiStream.from(map).forEachOrdered(this::add);
        return this;
    }

    public StructBuilder addAll(Multimap<String, Value> multimap) {
        BiStream.from((Map)multimap.asMap()).forEachOrdered(this::add);
        return this;
    }

    public StructBuilder addAll(Table<String, String, Value> table) {
        BiStream.from((Map)table.rowMap()).forEachOrdered(this::add);
        return this;
    }

    public StructBuilder addAllFields(Struct that) {
        BiStream.from((Map)that.getFieldsMap()).forEachOrdered(this::add);
        return this;
    }

    public StructBuilder addAllFields(StructBuilder that) {
        Preconditions.checkArgument((this != that ? 1 : 0) != 0, (Object)"Cannot add this builder to itself.");
        BiStream.from(that.fields).forEachOrdered(this::add);
        return this;
    }

    @CheckReturnValue
    public Struct build() {
        Struct.Builder struct = Struct.newBuilder();
        for (Map.Entry<String, Value> field : this.fields.entrySet()) {
            struct.putFields(field.getKey(), field.getValue());
        }
        return struct.build();
    }

    public String toString() {
        return this.build().toString();
    }
}

