/*
 * Decompiled with CFR 0.152.
 */
package com.google.myanmartools;

import com.google.myanmartools.Rule;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Phase {
    private final ArrayList<Rule> phaseRules = new ArrayList();
    private String info = "";
    private boolean debugMode = false;

    Phase() {
    }

    void setInfo(String newInfo) {
        this.info = newInfo;
    }

    void setDebugMode(boolean newMode) {
        this.debugMode = newMode;
    }

    void addRule(Rule newRule) {
        this.phaseRules.add(newRule);
        newRule.setInfo("" + this.phaseRules.size());
    }

    String printPhase() {
        StringBuilder sb = new StringBuilder();
        sb.append("  Phase ").append(this.info).append(" has ").append(this.phaseRules.size()).append(" rules\n");
        for (Rule rule : this.phaseRules) {
            sb.append(rule.printRule());
        }
        return sb.toString();
    }

    String runPhase(Phase phase, String inString) {
        StringBuilder outString = new StringBuilder();
        String midString = inString;
        boolean startOfString = true;
        boolean changed = false;
        if (this.debugMode) {
            System.out.println("Phase " + this.info + ", input= " + inString + "  (" + inString.length() + ")");
        }
        Matcher[] matchers = new Matcher[this.phaseRules.size()];
        for (int ruleIndex = 0; ruleIndex < this.phaseRules.size(); ++ruleIndex) {
            Pattern pattern = this.phaseRules.get((int)ruleIndex).pattern;
            matchers[ruleIndex] = pattern.matcher("");
        }
        while (midString.length() > 0) {
            boolean foundRule = false;
            for (int ruleIndex = 0; ruleIndex < this.phaseRules.size(); ++ruleIndex) {
                Rule rule = this.phaseRules.get(ruleIndex);
                if (rule.matchOnStart && !startOfString) continue;
                Matcher m = matchers[ruleIndex];
                m.reset(midString);
                if (!m.find()) continue;
                if (this.debugMode) {
                    System.out.println("  Matched rule " + rule.info + " = " + rule.pattern + " --> " + rule.substitution);
                    System.out.println("    m.group(0):  " + m.group(0) + " (" + m.group(0).length() + ")");
                }
                foundRule = true;
                int rightPartSize = midString.length() - m.group(0).length();
                midString = m.replaceFirst(rule.substitution);
                changed = true;
                if (rule.revisitPosition >= 0) continue;
                int newStart = midString.length() - rightPartSize;
                outString.append(midString, 0, newStart);
                midString = midString.substring(newStart);
            }
            if (!foundRule) {
                outString.append(midString.charAt(0));
                midString = midString.substring(1);
            }
            startOfString = false;
        }
        if (this.debugMode && changed) {
            System.out.println("  Return changed result = " + outString + "  (" + outString.length() + ")");
        }
        return outString.toString();
    }
}

