/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.jdo.auth.oauth2;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import com.google.api.client.extensions.jdo.auth.oauth2.JdoPersistedCredential;
import com.google.common.base.Preconditions;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;

public class JdoCredentialStore
implements CredentialStore {
    private final PersistenceManagerFactory persistenceManagerFactory;

    public JdoCredentialStore(PersistenceManagerFactory persistenceManagerFactory) {
        this.persistenceManagerFactory = (PersistenceManagerFactory)Preconditions.checkNotNull((Object)persistenceManagerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String userId, Credential credential) {
        PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
        try {
            JdoPersistedCredential persistedCredential = new JdoPersistedCredential(userId, credential);
            persistenceManager.makePersistent((Object)persistedCredential);
        }
        finally {
            persistenceManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String userId, Credential credential) {
        PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
        try {
            JdoPersistedCredential persistedCredential = new JdoPersistedCredential(userId, credential);
            persistenceManager.deletePersistent((Object)persistedCredential);
        }
        finally {
            persistenceManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(String userId, Credential credential) {
        PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
        try {
            JdoPersistedCredential persistedCredential = (JdoPersistedCredential)persistenceManager.getObjectById(JdoPersistedCredential.class, (Object)userId);
            persistedCredential.load(credential);
            boolean bl = true;
            return bl;
        }
        catch (JDOObjectNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            persistenceManager.close();
        }
    }
}

