/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2;

import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.AuthorizationCodeTokenRequest;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import com.google.api.client.auth.oauth2.CredentialStoreRefreshListener;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Clock;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;

public class AuthorizationCodeFlow {
    private final Credential.AccessMethod method;
    private final HttpTransport transport;
    private final JsonFactory jsonFactory;
    private final String tokenServerEncodedUrl;
    private final HttpExecuteInterceptor clientAuthentication;
    private final String clientId;
    private final String authorizationServerEncodedUrl;
    private final CredentialStore credentialStore;
    private final HttpRequestInitializer requestInitializer;
    private final Clock clock;
    private String scopes;

    protected AuthorizationCodeFlow(Credential.AccessMethod method, HttpTransport transport, JsonFactory jsonFactory, GenericUrl tokenServerUrl, HttpExecuteInterceptor clientAuthentication, String clientId, String authorizationServerEncodedUrl, CredentialStore credentialStore, HttpRequestInitializer requestInitializer, String scopes) {
        this(method, transport, jsonFactory, tokenServerUrl, clientAuthentication, clientId, authorizationServerEncodedUrl, credentialStore, requestInitializer, scopes, Clock.SYSTEM);
    }

    protected AuthorizationCodeFlow(Credential.AccessMethod method, HttpTransport transport, JsonFactory jsonFactory, GenericUrl tokenServerUrl, HttpExecuteInterceptor clientAuthentication, String clientId, String authorizationServerEncodedUrl, CredentialStore credentialStore, HttpRequestInitializer requestInitializer, String scopes, Clock clock) {
        this.method = (Credential.AccessMethod)Preconditions.checkNotNull((Object)method);
        this.transport = (HttpTransport)Preconditions.checkNotNull((Object)transport);
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
        this.tokenServerEncodedUrl = ((GenericUrl)Preconditions.checkNotNull((Object)tokenServerUrl)).build();
        this.clientAuthentication = clientAuthentication;
        this.clientId = (String)Preconditions.checkNotNull((Object)clientId);
        this.authorizationServerEncodedUrl = (String)Preconditions.checkNotNull((Object)authorizationServerEncodedUrl);
        this.requestInitializer = requestInitializer;
        this.credentialStore = credentialStore;
        this.scopes = scopes;
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
    }

    public AuthorizationCodeRequestUrl newAuthorizationUrl() {
        return new AuthorizationCodeRequestUrl(this.authorizationServerEncodedUrl, this.clientId).setScopes(this.scopes);
    }

    public AuthorizationCodeTokenRequest newTokenRequest(String authorizationCode) {
        return new AuthorizationCodeTokenRequest(this.transport, this.jsonFactory, new GenericUrl(this.tokenServerEncodedUrl), authorizationCode).setClientAuthentication(this.clientAuthentication).setRequestInitializer(this.requestInitializer).setScopes(this.scopes);
    }

    public Credential createAndStoreCredential(TokenResponse response, String userId) throws IOException {
        Credential credential = this.newCredential(userId).setFromTokenResponse(response);
        if (this.credentialStore != null) {
            this.credentialStore.store(userId, credential);
        }
        return credential;
    }

    public Credential loadCredential(String userId) throws IOException {
        if (this.credentialStore == null) {
            return null;
        }
        Credential credential = this.newCredential(userId);
        if (!this.credentialStore.load(userId, credential)) {
            return null;
        }
        return credential;
    }

    private Credential newCredential(String userId) {
        Credential.Builder builder = new Credential.Builder(this.method).setTransport(this.transport).setJsonFactory(this.jsonFactory).setTokenServerEncodedUrl(this.tokenServerEncodedUrl).setClientAuthentication(this.clientAuthentication).setRequestInitializer(this.requestInitializer).setClock(this.clock);
        if (this.credentialStore != null) {
            builder.addRefreshListener(new CredentialStoreRefreshListener(userId, this.credentialStore));
        }
        return builder.build();
    }

    public final Credential.AccessMethod getMethod() {
        return this.method;
    }

    public final HttpTransport getTransport() {
        return this.transport;
    }

    public final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public final String getTokenServerEncodedUrl() {
        return this.tokenServerEncodedUrl;
    }

    public final HttpExecuteInterceptor getClientAuthentication() {
        return this.clientAuthentication;
    }

    public final String getClientId() {
        return this.clientId;
    }

    public final String getAuthorizationServerEncodedUrl() {
        return this.authorizationServerEncodedUrl;
    }

    public final CredentialStore getCredentialStore() {
        return this.credentialStore;
    }

    public final HttpRequestInitializer getRequestInitializer() {
        return this.requestInitializer;
    }

    public final String getScopes() {
        return this.scopes;
    }

    public final Clock getClock() {
        return this.clock;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final Credential.AccessMethod method;
        private final HttpTransport transport;
        private final JsonFactory jsonFactory;
        private final GenericUrl tokenServerUrl;
        private final HttpExecuteInterceptor clientAuthentication;
        private final String clientId;
        private final String authorizationServerEncodedUrl;
        private CredentialStore credentialStore;
        private HttpRequestInitializer requestInitializer;
        private String scopes;
        private Clock clock = Clock.SYSTEM;

        public Builder(Credential.AccessMethod method, HttpTransport transport, JsonFactory jsonFactory, GenericUrl tokenServerUrl, HttpExecuteInterceptor clientAuthentication, String clientId, String authorizationServerEncodedUrl) {
            this.method = (Credential.AccessMethod)Preconditions.checkNotNull((Object)method);
            this.transport = (HttpTransport)Preconditions.checkNotNull((Object)transport);
            this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
            this.tokenServerUrl = (GenericUrl)Preconditions.checkNotNull((Object)tokenServerUrl);
            this.clientAuthentication = clientAuthentication;
            this.clientId = (String)Preconditions.checkNotNull((Object)clientId);
            this.authorizationServerEncodedUrl = (String)Preconditions.checkNotNull((Object)authorizationServerEncodedUrl);
        }

        public AuthorizationCodeFlow build() {
            return new AuthorizationCodeFlow(this.method, this.transport, this.jsonFactory, this.tokenServerUrl, this.clientAuthentication, this.clientId, this.authorizationServerEncodedUrl, this.credentialStore, this.requestInitializer, this.scopes, this.clock);
        }

        public final Credential.AccessMethod getMethod() {
            return this.method;
        }

        public final HttpTransport getTransport() {
            return this.transport;
        }

        public final JsonFactory getJsonFactory() {
            return this.jsonFactory;
        }

        public final GenericUrl getTokenServerUrl() {
            return this.tokenServerUrl;
        }

        public final HttpExecuteInterceptor getClientAuthentication() {
            return this.clientAuthentication;
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final String getAuthorizationServerEncodedUrl() {
            return this.authorizationServerEncodedUrl;
        }

        public final CredentialStore getCredentialStore() {
            return this.credentialStore;
        }

        public final Clock getClock() {
            return this.clock;
        }

        public Builder setClock(Clock clock) {
            this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
            return this;
        }

        public Builder setCredentialStore(CredentialStore credentialStore) {
            this.credentialStore = credentialStore;
            return this;
        }

        public final HttpRequestInitializer getRequestInitializer() {
            return this.requestInitializer;
        }

        public Builder setRequestInitializer(HttpRequestInitializer requestInitializer) {
            this.requestInitializer = requestInitializer;
            return this;
        }

        public Builder setScopes(Iterable<String> scopes) {
            this.scopes = scopes == null ? null : Joiner.on((char)' ').join(scopes);
            return this;
        }

        public Builder setScopes(String ... scopes) {
            return this.setScopes(scopes == null ? null : Arrays.asList(scopes));
        }

        public final String getScopes() {
            return this.scopes;
        }
    }
}

