/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2.draft10;

import com.google.api.client.auth.oauth2.draft10.AccessTokenRequest;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

@Deprecated
public class AccessProtectedResource
implements HttpExecuteInterceptor,
HttpRequestInitializer,
HttpUnsuccessfulResponseHandler {
    static final String HEADER_PREFIX = "OAuth ";
    static final Logger LOGGER = Logger.getLogger(AccessProtectedResource.class.getName());
    private static final EnumSet<HttpMethod> ALLOWED_METHODS = EnumSet.of(HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE);
    private final Lock tokenLock = new ReentrantLock();
    private String accessToken;
    private final Method method;
    private final HttpTransport transport;
    private final JsonFactory jsonFactory;
    private final String authorizationServerUrl;
    private final String clientId;
    private final String clientSecret;
    private final String refreshToken;

    public AccessProtectedResource(String accessToken, Method method) {
        this.accessToken = accessToken;
        this.method = (Method)((Object)Preconditions.checkNotNull((Object)((Object)method)));
        this.transport = null;
        this.jsonFactory = null;
        this.authorizationServerUrl = null;
        this.clientId = null;
        this.clientSecret = null;
        this.refreshToken = null;
    }

    public AccessProtectedResource(String accessToken, Method method, HttpTransport transport, JsonFactory jsonFactory, String authorizationServerUrl, String clientId, String clientSecret, String refreshToken) {
        this.accessToken = accessToken;
        this.method = (Method)((Object)Preconditions.checkNotNull((Object)((Object)method)));
        this.transport = (HttpTransport)Preconditions.checkNotNull((Object)transport);
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
        this.authorizationServerUrl = (String)Preconditions.checkNotNull((Object)authorizationServerUrl);
        this.clientId = (String)Preconditions.checkNotNull((Object)clientId);
        this.clientSecret = (String)Preconditions.checkNotNull((Object)clientSecret);
        this.refreshToken = refreshToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getAccessToken() {
        this.tokenLock.lock();
        try {
            String string = this.accessToken;
            return string;
        }
        finally {
            this.tokenLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAccessToken(String accessToken) {
        this.tokenLock.lock();
        try {
            this.accessToken = accessToken;
            this.onAccessToken(accessToken);
        }
        finally {
            this.tokenLock.unlock();
        }
    }

    public final Method getMethod() {
        return this.method;
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public String getAuthorizationServerUrl() {
        return this.authorizationServerUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean refreshToken() throws IOException {
        this.tokenLock.lock();
        try {
            boolean bl = this.executeRefreshToken();
            return bl;
        }
        finally {
            this.tokenLock.unlock();
        }
    }

    public final void initialize(HttpRequest request) throws IOException {
        request.setInterceptor((HttpExecuteInterceptor)this);
        request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)this);
    }

    public void intercept(HttpRequest request) throws IOException {
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            return;
        }
        switch (this.method) {
            case AUTHORIZATION_HEADER: {
                request.getHeaders().setAuthorization(HEADER_PREFIX + accessToken);
                break;
            }
            case QUERY_PARAMETER: {
                request.getUrl().set("oauth_token", (Object)accessToken);
                break;
            }
            case FORM_ENCODED_BODY: {
                Preconditions.checkArgument((boolean)ALLOWED_METHODS.contains(request.getMethod()), (String)"expected one of these HTTP methods: %s", (Object[])new Object[]{ALLOWED_METHODS});
                Map data = Data.mapOf((Object)UrlEncodedContent.getContent((HttpRequest)request).getData());
                data.put("oauth_token", accessToken);
            }
        }
    }

    private String getAccessTokenFromRequest(HttpRequest request) {
        switch (this.method) {
            case AUTHORIZATION_HEADER: {
                String header = request.getHeaders().getAuthorization();
                if (header != null && header.startsWith(HEADER_PREFIX)) {
                    return header.substring(HEADER_PREFIX.length());
                }
                return null;
            }
            case QUERY_PARAMETER: {
                Object param = request.getUrl().get((Object)"oauth_token");
                return param == null ? null : param.toString();
            }
        }
        Map data = Data.mapOf((Object)UrlEncodedContent.getContent((HttpRequest)request).getData());
        Object bodyParam = data.get("oauth_token");
        return bodyParam == null ? null : bodyParam.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleResponse(HttpRequest request, HttpResponse response, boolean retrySupported) {
        if (response.getStatusCode() == 401) {
            this.tokenLock.lock();
            try {
                boolean bl = !Objects.equal((Object)this.accessToken, (Object)this.getAccessTokenFromRequest(request)) || this.refreshToken();
                this.tokenLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        this.tokenLock.unlock();
                        throw throwable;
                    }
                    catch (HttpResponseException e) {
                        LOGGER.severe(e.getMessage());
                    }
                }
                catch (IOException exception) {
                    LOGGER.severe(exception.toString());
                }
            }
        }
        return false;
    }

    protected boolean executeRefreshToken() throws IOException {
        if (this.refreshToken != null) {
            AccessTokenRequest.RefreshTokenGrant request = new AccessTokenRequest.RefreshTokenGrant(this.transport, this.jsonFactory, this.authorizationServerUrl, this.clientId, this.clientSecret, this.refreshToken);
            return this.executeAccessTokenRequest(request);
        }
        return false;
    }

    protected final boolean executeAccessTokenRequest(AccessTokenRequest request) throws IOException {
        String newAccessToken;
        try {
            newAccessToken = request.execute().accessToken;
        }
        catch (HttpResponseException e) {
            newAccessToken = null;
        }
        this.setAccessToken(newAccessToken);
        return newAccessToken != null;
    }

    protected void onAccessToken(String accessToken) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        AUTHORIZATION_HEADER,
        QUERY_PARAMETER,
        FORM_ENCODED_BODY;

    }
}

