/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2;

import com.google.api.client.auth.oauth2.AuthorizationCodeTokenRequest;
import com.google.api.client.auth.oauth2.TokenRequest;
import com.google.api.client.auth.oauth2.TokenRequestTest;
import com.google.api.client.auth.openidconnect.IdTokenResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import junit.framework.TestCase;

public class AuthorizationCodeTokenRequestTest
extends TestCase {
    private static final String CODE = "i1WsRn1uB1";
    private static final String REDIRECT_URI = "https://client.example.com/rd";

    public void testConstructor() {
        this.check(new AuthorizationCodeTokenRequest((HttpTransport)TokenRequestTest.TRANSPORT, (JsonFactory)TokenRequestTest.JSON_FACTORY, TokenRequestTest.AUTHORIZATION_SERVER_URL, CODE).setRedirectUri(REDIRECT_URI));
    }

    private void check(AuthorizationCodeTokenRequest request) {
        TokenRequestTest.check((TokenRequest)request, "authorization_code");
        AuthorizationCodeTokenRequestTest.assertEquals((String)CODE, (String)request.getCode());
        AuthorizationCodeTokenRequestTest.assertEquals((String)REDIRECT_URI, (String)request.getRedirectUri());
    }

    public void testSetResponseClass() {
        AuthorizationCodeTokenRequest request = new AuthorizationCodeTokenRequest((HttpTransport)TokenRequestTest.TRANSPORT, (JsonFactory)TokenRequestTest.JSON_FACTORY, TokenRequestTest.AUTHORIZATION_SERVER_URL, CODE).setResponseClass(IdTokenResponse.class);
        AuthorizationCodeTokenRequestTest.assertEquals(IdTokenResponse.class, (Object)request.getResponseClass());
    }
}

