/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.openidconnect;

import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.json.webtoken.JsonWebSignature;
import java.util.Arrays;
import junit.framework.TestCase;

public class IdTokenTest
extends TestCase {
    public void testValidateIssuer() {
        IdToken token = new IdToken(new JsonWebSignature.Header(), new IdToken.Payload(), new byte[0], new byte[0]);
        token.getPayload().setIssuer("issuer");
        IdTokenTest.assertTrue((boolean)token.verifyIssuer("issuer"));
        IdTokenTest.assertFalse((boolean)token.verifyIssuer("not"));
    }

    public void testValidateIssuedAtTime() {
        IdToken token = new IdToken(new JsonWebSignature.Header(), new IdToken.Payload(), new byte[0], new byte[0]);
        token.getPayload().setIssuedAtTimeSeconds(Long.valueOf(123L));
        IdTokenTest.assertTrue((boolean)token.verifyIssuedAtTime(123000L, 1L));
        IdTokenTest.assertTrue((boolean)token.verifyIssuedAtTime(122000L, 1L));
        IdTokenTest.assertFalse((boolean)token.verifyIssuedAtTime(121999L, 1L));
    }

    public void testValidateExpirationTime() {
        IdToken token = new IdToken(new JsonWebSignature.Header(), new IdToken.Payload(), new byte[0], new byte[0]);
        token.getPayload().setExpirationTimeSeconds(Long.valueOf(123L));
        IdTokenTest.assertTrue((boolean)token.verifyExpirationTime(123000L, 1L));
        IdTokenTest.assertTrue((boolean)token.verifyExpirationTime(124000L, 1L));
        IdTokenTest.assertFalse((boolean)token.verifyExpirationTime(124001L, 1L));
    }

    public void testValidateAudience() {
        IdToken token = new IdToken(new JsonWebSignature.Header(), new IdToken.Payload(), new byte[0], new byte[0]);
        token.getPayload().setAudience((Object)"cid");
        IdTokenTest.assertTrue((boolean)token.verifyAudience(Arrays.asList("cid")));
        IdTokenTest.assertFalse((boolean)token.verifyAudience(Arrays.asList("cid2")));
        token.getPayload().setAudience(Arrays.asList("cid"));
        IdTokenTest.assertTrue((boolean)token.verifyAudience(Arrays.asList("cid")));
        IdTokenTest.assertFalse((boolean)token.verifyAudience(Arrays.asList("cid2")));
        token.getPayload().setAudience(Arrays.asList("cid", "cid2"));
        IdTokenTest.assertTrue((boolean)token.verifyAudience(Arrays.asList("cid", "cid2")));
        IdTokenTest.assertFalse((boolean)token.verifyAudience(Arrays.asList("cid")));
        IdTokenTest.assertFalse((boolean)token.verifyAudience(Arrays.asList("cid2")));
        IdTokenTest.assertFalse((boolean)token.verifyAudience(Arrays.asList("cid", "cid3")));
    }

    public void testValidateNoAudienceSet() {
        IdToken token = new IdToken(new JsonWebSignature.Header(), new IdToken.Payload(), new byte[0], new byte[0]);
        IdTokenTest.assertFalse((boolean)token.verifyAudience(Arrays.asList("cid")));
    }

    public void testValidateTime() {
        IdToken token = new IdToken(new JsonWebSignature.Header(), new IdToken.Payload(), new byte[0], new byte[0]);
        token.getPayload().setExpirationTimeSeconds(Long.valueOf(123L)).setIssuedAtTimeSeconds(Long.valueOf(123L));
        IdTokenTest.assertTrue((boolean)token.verifyTime(123000L, 1L));
        IdTokenTest.assertTrue((boolean)token.verifyTime(122000L, 1L));
        IdTokenTest.assertFalse((boolean)token.verifyTime(121999L, 1L));
        IdTokenTest.assertTrue((boolean)token.verifyTime(123000L, 1L));
        IdTokenTest.assertTrue((boolean)token.verifyTime(124000L, 1L));
        IdTokenTest.assertFalse((boolean)token.verifyTime(124001L, 1L));
    }

    public void testConstructor() {
        try {
            new IdToken(new JsonWebSignature.Header(), new IdToken.Payload(), null, new byte[0]);
            IdTokenTest.fail((String)("expected " + NullPointerException.class));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new IdToken(new JsonWebSignature.Header(), new IdToken.Payload(), new byte[0], null);
            IdTokenTest.fail((String)("expected " + NullPointerException.class));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

