/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2;

import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.testing.http.HttpTesting;
import com.google.api.client.testing.http.MockHttpTransport;
import java.util.Map;
import junit.framework.TestCase;

public class ClientParametersAuthenticationTest
extends TestCase {
    private static final String CLIENT_ID = "s6BhdRkqt3";
    private static final String CLIENT_SECRET = "7Fjfp0ZBr1KtDRbnfVdmIw";

    public void test() throws Exception {
        HttpRequest request = new MockHttpTransport().createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        ClientParametersAuthentication auth = new ClientParametersAuthentication(CLIENT_ID, CLIENT_SECRET);
        ClientParametersAuthenticationTest.assertEquals((String)CLIENT_ID, (String)auth.getClientId());
        ClientParametersAuthenticationTest.assertEquals((String)CLIENT_SECRET, (String)auth.getClientSecret());
        auth.intercept(request);
        UrlEncodedContent content = (UrlEncodedContent)request.getContent();
        Map data = (Map)content.getData();
        ClientParametersAuthenticationTest.assertEquals((Object)CLIENT_ID, data.get("client_id"));
        ClientParametersAuthenticationTest.assertEquals((Object)CLIENT_SECRET, data.get("client_secret"));
    }

    public void test_noSecret() throws Exception {
        HttpRequest request = new MockHttpTransport().createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        ClientParametersAuthentication auth = new ClientParametersAuthentication(CLIENT_ID, null);
        ClientParametersAuthenticationTest.assertEquals((String)CLIENT_ID, (String)auth.getClientId());
        ClientParametersAuthenticationTest.assertNull((Object)auth.getClientSecret());
        auth.intercept(request);
        UrlEncodedContent content = (UrlEncodedContent)request.getContent();
        Map data = (Map)content.getData();
        ClientParametersAuthenticationTest.assertEquals((Object)CLIENT_ID, data.get("client_id"));
        ClientParametersAuthenticationTest.assertNull(data.get("client_secret"));
    }
}

