/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.openidconnect;

import com.google.api.client.auth.openidconnect.Environment;
import com.google.api.client.auth.openidconnect.HttpTransportFactory;
import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.auth.openidconnect.IdTokenVerifier;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.util.Clock;
import com.google.api.client.util.Lists;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Assert;

public class IdTokenVerifierTest
extends TestCase {
    private static final String CLIENT_ID = "myclientid";
    private static final String CLIENT_ID2 = "myclientid2";
    private static final List<String> TRUSTED_CLIENT_IDS = Arrays.asList("myclientid", "myclientid2");
    private static final String ISSUER = "issuer.example.com";
    private static final String ISSUER2 = "issuer.example.com2";
    private static final String ISSUER3 = "issuer.example.com3";
    private static final String ES256_TOKEN = "eyJhbGciOiJFUzI1NiIsInR5cCI6IkpXVCIsImtpZCI6Im1wZjBEQSJ9.eyJhdWQiOiIvcHJvamVjdHMvNjUyNTYyNzc2Nzk4L2FwcHMvY2xvdWQtc2FtcGxlcy10ZXN0cy1waHAtaWFwIiwiZW1haWwiOiJjaGluZ29yQGdvb2dsZS5jb20iLCJleHAiOjE1ODQwNDc2MTcsImdvb2dsZSI6eyJhY2Nlc3NfbGV2ZWxzIjpbImFjY2Vzc1BvbGljaWVzLzUxODU1MTI4MDkyNC9hY2Nlc3NMZXZlbHMvcmVjZW50U2VjdXJlQ29ubmVjdERhdGEiLCJhY2Nlc3NQb2xpY2llcy81MTg1NTEyODA5MjQvYWNjZXNzTGV2ZWxzL3Rlc3ROb09wIiwiYWNjZXNzUG9saWNpZXMvNTE4NTUxMjgwOTI0L2FjY2Vzc0xldmVscy9ldmFwb3JhdGlvblFhRGF0YUZ1bGx5VHJ1c3RlZCJdfSwiaGQiOiJnb29nbGUuY29tIiwiaWF0IjoxNTg0MDQ3MDE3LCJpc3MiOiJodHRwczovL2Nsb3VkLmdvb2dsZS5jb20vaWFwIiwic3ViIjoiYWNjb3VudHMuZ29vZ2xlLmNvbToxMTIxODE3MTI3NzEyMDE5NzI4OTEifQ.yKNtdFY5EKkRboYNexBdfugzLhC3VuGyFcuFYA8kgpxMqfyxa41zkML68hYKrWu2kOBTUW95UnbGpsIi_u1fiA";
    private static final String FEDERATED_SIGNON_RS256_TOKEN = "eyJhbGciOiJSUzI1NiIsImtpZCI6ImY5ZDk3YjRjYWU5MGJjZDc2YWViMjAwMjZmNmI3NzBjYWMyMjE3ODMiLCJ0eXAiOiJKV1QifQ.eyJhdWQiOiJodHRwczovL2V4YW1wbGUuY29tL3BhdGgiLCJhenAiOiJpbnRlZ3JhdGlvbi10ZXN0c0BjaGluZ29yLXRlc3QuaWFtLmdzZXJ2aWNlYWNjb3VudC5jb20iLCJlbWFpbCI6ImludGVncmF0aW9uLXRlc3RzQGNoaW5nb3ItdGVzdC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbSIsImVtYWlsX3ZlcmlmaWVkIjp0cnVlLCJleHAiOjE1ODc2Mjk4ODgsImlhdCI6MTU4NzYyNjI4OCwiaXNzIjoiaHR0cHM6Ly9hY2NvdW50cy5nb29nbGUuY29tIiwic3ViIjoiMTA0MDI5MjkyODUzMDk5OTc4MjkzIn0.Pj4KsJh7riU7ZIbPMcHcHWhasWEcbVjGP4yx_5E0iOpeDalTdri97E-o0dSSkuVX2FeBIgGUg_TNNgJ3YY97T737jT5DUYwdv6M51dDlLmmNqlu_P6toGCSRC8-Beu5gGmqS2Y82TmpHH9Vhoh5PsK7_rVHk8U6VrrVVKKTWm_IzTFhqX1oYKPdvfyaNLsXPbCt_NFE0C3DNmFkgVhRJu7LtzQQN-ghaqd3Ga3i6KH222OEI_PU4BUTvEiNOqRGoMlT_YOsyFN3XwqQ6jQGWhhkArL1z3CG2BVQjHTKpgVsRyy_H6WTZiju2Q-XWobgH-UPSZbyymV8-cFT9XKEtZQ";
    private static final String LEGACY_FEDERATED_SIGNON_CERT_URL = "https://www.googleapis.com/oauth2/v1/certs";
    private static final String SERVICE_ACCOUNT_RS256_TOKEN = "eyJhbGciOiJSUzI1NiIsImtpZCI6IjYwODNkZDU5ODE2NzNmNjYxZmRlOWRhZTY0NmI2ZjAzODBhMDE0NWMiLCJ0eXAiOiJKV1QifQ.eyJhdWQiOiIzMjU1NTk0MDU1OS5hcHBzLmdvb2dsZXVzZXJjb250ZW50LmNvbSIsImF6cCI6ImludGVncmF0aW9uLXRlc3RzQGNoaW5nb3ItdGVzdC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbSIsImVtYWlsIjoiaW50ZWdyYXRpb24tdGVzdHNAY2hpbmdvci10ZXN0LmlhbS5nc2VydmljZWFjY291bnQuY29tIiwiZW1haWxfdmVyaWZpZWQiOnRydWUsImV4cCI6MTY4NjAwMjIyMywiaWF0IjoxNjg1OTk4NjIzLCJpc3MiOiJodHRwczovL2FjY291bnRzLmdvb2dsZS5jb20iLCJzdWIiOiIxMDQwMjkyOTI4NTMwOTk5NzgyOTMifQ.0sJwjljZk38dJck4swTZTkqg6A_cBJE3JKpwH3CBVuU5MdUyKxuQz7GTs9akUn9426dtdsZvY_CPrbE-erkUKq-Es5aayNFNa4MdSKfaHbXGs5wopBQ-rnSjE3kAOPdD527a-NvbujBQ-069qupbms9p003Dgj2ph4AeAxR5vukn7hjGQNCnsouaVUzEqa6dB1JTQb895YPF6UOcjVDZf6S00Dot2vKFRvY2jWQ2AxnGjyZnzjyOg8lnXQWeLTFj_oqJc7xYmcxN1QCkXgcJfoThTRzvFokB7Qryi0m14rjPzOgQAQSGNniSnEGY5A5ZwKTdYIwZxCrDcZmrKfz7vQ";
    private static final String SERVICE_ACCOUNT_RS256_TOKEN_BAD_SIGNATURE = "eyJhbGciOiJSUzI1NiIsImtpZCI6IjE3MjdiNmI0OTQwMmI5Y2Y5NWJlNGU4ZmQzOGFhN2U3YzExNjQ0YjEiLCJ0eXAiOiJKV1QifQ.eyJhdWQiOiJodHRwczovL2Nsb3VkdGFza3MuZ29vZ2xlYXBpcy5jb20vdjIvcHJvamVjdHMvZ2Nsb3VkLWRldmVsL2xvY2F0aW9ucyIsImF6cCI6InN0aW0tdGVzdEBzdGVsbGFyLWRheS0yNTQyMjIuaWFtLmdzZXJ2aWNlYWNjb3VudC5jb20iLCJlbWFpbCI6InN0aW0tdGVzdEBzdGVsbGFyLWRheS0yNTQyMjIuaWFtLmdzZXJ2aWNlYWNjb3VudC5jb20iLCJlbWFpbF92ZXJpZmllZCI6dHJ1ZSwiZXhwIjoxNjYwODgwNjczLCJpYXQiOjE2NjA4NzcwNzMsImlzcyI6Imh0dHBzOi8vYWNjb3VudHMuZ29vZ2xlLmNvbSIsInN1YiI6IjExMjgxMDY3Mjk2MzcyODM2NjQwNiJ9.Q2tG-hN6UHecbzaCIlg58K9msp58nLZWs03CBGO_D6F3cI4LKQEUzsbcztZqmNGWd0ld4zkrKzIP9cQosa_xold4hEzSX_ORRHYQLimLYaQmP3rKqWPMsbIupPdpnGqBDzAYjc7Pw9pQBzuZJj8e3FEG6a5tblDfMcgeklXZIkwzN7ypWCbFDoDP2STSYJYZ-LQIB0-Zlex7dm2KhyB8QSkMQK60YvpXz4L1OtwG7spk3yUCWxul6hYF76klST0iS6DH03YdaDpt4gRXkTUKyTRfB10h-WhCAKKRzmT6d_IT9ApIyqPhimkgkBHhLNyjK8lgAJdk9CLriSEOgVpruy";
    private static final String SERVICE_ACCOUNT_CERT_URL = "https://www.googleapis.com/oauth2/v3/certs";
    private static final List<String> ALL_TOKENS = Arrays.asList("eyJhbGciOiJFUzI1NiIsInR5cCI6IkpXVCIsImtpZCI6Im1wZjBEQSJ9.eyJhdWQiOiIvcHJvamVjdHMvNjUyNTYyNzc2Nzk4L2FwcHMvY2xvdWQtc2FtcGxlcy10ZXN0cy1waHAtaWFwIiwiZW1haWwiOiJjaGluZ29yQGdvb2dsZS5jb20iLCJleHAiOjE1ODQwNDc2MTcsImdvb2dsZSI6eyJhY2Nlc3NfbGV2ZWxzIjpbImFjY2Vzc1BvbGljaWVzLzUxODU1MTI4MDkyNC9hY2Nlc3NMZXZlbHMvcmVjZW50U2VjdXJlQ29ubmVjdERhdGEiLCJhY2Nlc3NQb2xpY2llcy81MTg1NTEyODA5MjQvYWNjZXNzTGV2ZWxzL3Rlc3ROb09wIiwiYWNjZXNzUG9saWNpZXMvNTE4NTUxMjgwOTI0L2FjY2Vzc0xldmVscy9ldmFwb3JhdGlvblFhRGF0YUZ1bGx5VHJ1c3RlZCJdfSwiaGQiOiJnb29nbGUuY29tIiwiaWF0IjoxNTg0MDQ3MDE3LCJpc3MiOiJodHRwczovL2Nsb3VkLmdvb2dsZS5jb20vaWFwIiwic3ViIjoiYWNjb3VudHMuZ29vZ2xlLmNvbToxMTIxODE3MTI3NzEyMDE5NzI4OTEifQ.yKNtdFY5EKkRboYNexBdfugzLhC3VuGyFcuFYA8kgpxMqfyxa41zkML68hYKrWu2kOBTUW95UnbGpsIi_u1fiA", "eyJhbGciOiJSUzI1NiIsImtpZCI6ImY5ZDk3YjRjYWU5MGJjZDc2YWViMjAwMjZmNmI3NzBjYWMyMjE3ODMiLCJ0eXAiOiJKV1QifQ.eyJhdWQiOiJodHRwczovL2V4YW1wbGUuY29tL3BhdGgiLCJhenAiOiJpbnRlZ3JhdGlvbi10ZXN0c0BjaGluZ29yLXRlc3QuaWFtLmdzZXJ2aWNlYWNjb3VudC5jb20iLCJlbWFpbCI6ImludGVncmF0aW9uLXRlc3RzQGNoaW5nb3ItdGVzdC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbSIsImVtYWlsX3ZlcmlmaWVkIjp0cnVlLCJleHAiOjE1ODc2Mjk4ODgsImlhdCI6MTU4NzYyNjI4OCwiaXNzIjoiaHR0cHM6Ly9hY2NvdW50cy5nb29nbGUuY29tIiwic3ViIjoiMTA0MDI5MjkyODUzMDk5OTc4MjkzIn0.Pj4KsJh7riU7ZIbPMcHcHWhasWEcbVjGP4yx_5E0iOpeDalTdri97E-o0dSSkuVX2FeBIgGUg_TNNgJ3YY97T737jT5DUYwdv6M51dDlLmmNqlu_P6toGCSRC8-Beu5gGmqS2Y82TmpHH9Vhoh5PsK7_rVHk8U6VrrVVKKTWm_IzTFhqX1oYKPdvfyaNLsXPbCt_NFE0C3DNmFkgVhRJu7LtzQQN-ghaqd3Ga3i6KH222OEI_PU4BUTvEiNOqRGoMlT_YOsyFN3XwqQ6jQGWhhkArL1z3CG2BVQjHTKpgVsRyy_H6WTZiju2Q-XWobgH-UPSZbyymV8-cFT9XKEtZQ", "eyJhbGciOiJSUzI1NiIsImtpZCI6IjYwODNkZDU5ODE2NzNmNjYxZmRlOWRhZTY0NmI2ZjAzODBhMDE0NWMiLCJ0eXAiOiJKV1QifQ.eyJhdWQiOiIzMjU1NTk0MDU1OS5hcHBzLmdvb2dsZXVzZXJjb250ZW50LmNvbSIsImF6cCI6ImludGVncmF0aW9uLXRlc3RzQGNoaW5nb3ItdGVzdC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbSIsImVtYWlsIjoiaW50ZWdyYXRpb24tdGVzdHNAY2hpbmdvci10ZXN0LmlhbS5nc2VydmljZWFjY291bnQuY29tIiwiZW1haWxfdmVyaWZpZWQiOnRydWUsImV4cCI6MTY4NjAwMjIyMywiaWF0IjoxNjg1OTk4NjIzLCJpc3MiOiJodHRwczovL2FjY291bnRzLmdvb2dsZS5jb20iLCJzdWIiOiIxMDQwMjkyOTI4NTMwOTk5NzgyOTMifQ.0sJwjljZk38dJck4swTZTkqg6A_cBJE3JKpwH3CBVuU5MdUyKxuQz7GTs9akUn9426dtdsZvY_CPrbE-erkUKq-Es5aayNFNa4MdSKfaHbXGs5wopBQ-rnSjE3kAOPdD527a-NvbujBQ-069qupbms9p003Dgj2ph4AeAxR5vukn7hjGQNCnsouaVUzEqa6dB1JTQb895YPF6UOcjVDZf6S00Dot2vKFRvY2jWQ2AxnGjyZnzjyOg8lnXQWeLTFj_oqJc7xYmcxN1QCkXgcJfoThTRzvFokB7Qryi0m14rjPzOgQAQSGNniSnEGY5A5ZwKTdYIwZxCrDcZmrKfz7vQ");
    static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
    static final MockClock FIXED_CLOCK = new MockClock(1584047020000L);

    private static IdToken newIdToken(String issuer, String audience) {
        IdToken.Payload payload = new IdToken.Payload();
        payload.setIssuer(issuer);
        payload.setAudience((Object)audience);
        payload.setExpirationTimeSeconds(Long.valueOf(2000L));
        payload.setIssuedAtTimeSeconds(Long.valueOf(1000L));
        return new IdToken(new JsonWebSignature.Header(), payload, new byte[0], new byte[0]);
    }

    public void testBuilder() throws Exception {
        IdTokenVerifier.Builder builder = new IdTokenVerifier.Builder().setIssuer(ISSUER).setAudience(TRUSTED_CLIENT_IDS);
        IdTokenVerifierTest.assertEquals((Object)Clock.SYSTEM, (Object)builder.getClock());
        IdTokenVerifierTest.assertEquals((String)ISSUER, (String)builder.getIssuer());
        IdTokenVerifierTest.assertEquals(Collections.singleton(ISSUER), (Object)builder.getIssuers());
        IdTokenVerifierTest.assertEquals(TRUSTED_CLIENT_IDS, (Object)builder.getAudience());
        MockClock clock = new MockClock();
        builder.setClock((Clock)clock);
        IdTokenVerifierTest.assertEquals((Object)clock, (Object)builder.getClock());
        IdTokenVerifier verifier = builder.build();
        IdTokenVerifierTest.assertEquals((Object)clock, (Object)verifier.getClock());
        IdTokenVerifierTest.assertEquals((String)ISSUER, (String)verifier.getIssuer());
        IdTokenVerifierTest.assertEquals(Collections.singleton(ISSUER), (Object)builder.getIssuers());
        IdTokenVerifierTest.assertEquals(TRUSTED_CLIENT_IDS, (Object)Lists.newArrayList((Iterable)verifier.getAudience()));
    }

    public void testVerifyPayload() throws Exception {
        MockClock clock = new MockClock();
        MockEnvironment testEnvironment = new MockEnvironment();
        testEnvironment.setVariable("OAUTH_CLIENT_SKIP_SIGNATURE", "true");
        IdTokenVerifier verifier = new IdTokenVerifier.Builder().setIssuers(Arrays.asList(ISSUER, ISSUER3)).setAudience(Arrays.asList(CLIENT_ID)).setClock((Clock)clock).setEnvironment((Environment)testEnvironment).build();
        IdTokenVerifier verifierFlexible = new IdTokenVerifier.Builder().setClock((Clock)clock).setEnvironment((Environment)testEnvironment).build();
        clock.timeMillis = 1500000L;
        IdToken idToken = IdTokenVerifierTest.newIdToken(ISSUER, CLIENT_ID);
        IdTokenVerifierTest.assertTrue((boolean)verifier.verify(idToken));
        IdTokenVerifierTest.assertTrue((boolean)verifier.verifyPayload(idToken));
        IdTokenVerifierTest.assertTrue((boolean)verifierFlexible.verify(IdTokenVerifierTest.newIdToken(ISSUER2, CLIENT_ID)));
        IdTokenVerifierTest.assertTrue((boolean)verifierFlexible.verifyPayload(IdTokenVerifierTest.newIdToken(ISSUER2, CLIENT_ID)));
        IdTokenVerifierTest.assertFalse((boolean)verifier.verify(IdTokenVerifierTest.newIdToken(ISSUER2, CLIENT_ID)));
        IdTokenVerifierTest.assertFalse((boolean)verifier.verifyPayload(IdTokenVerifierTest.newIdToken(ISSUER2, CLIENT_ID)));
        IdTokenVerifierTest.assertTrue((boolean)verifier.verify(IdTokenVerifierTest.newIdToken(ISSUER3, CLIENT_ID)));
        IdTokenVerifierTest.assertTrue((boolean)verifier.verifyPayload(IdTokenVerifierTest.newIdToken(ISSUER3, CLIENT_ID)));
        IdTokenVerifierTest.assertTrue((boolean)verifierFlexible.verify(IdTokenVerifierTest.newIdToken(ISSUER, CLIENT_ID2)));
        IdTokenVerifierTest.assertTrue((boolean)verifierFlexible.verifyPayload(IdTokenVerifierTest.newIdToken(ISSUER, CLIENT_ID2)));
        IdTokenVerifierTest.assertFalse((boolean)verifier.verify(IdTokenVerifierTest.newIdToken(ISSUER, CLIENT_ID2)));
        IdTokenVerifierTest.assertFalse((boolean)verifier.verifyPayload(IdTokenVerifierTest.newIdToken(ISSUER, CLIENT_ID2)));
        clock.timeMillis = 700000L;
        IdTokenVerifierTest.assertTrue((boolean)verifier.verify(idToken));
        IdTokenVerifierTest.assertTrue((boolean)verifier.verifyPayload(idToken));
        clock.timeMillis = 2300000L;
        IdTokenVerifierTest.assertTrue((boolean)verifier.verify(idToken));
        IdTokenVerifierTest.assertTrue((boolean)verifier.verifyPayload(idToken));
        clock.timeMillis = 699999L;
        IdTokenVerifierTest.assertFalse((boolean)verifier.verify(idToken));
        IdTokenVerifierTest.assertFalse((boolean)verifier.verifyPayload(idToken));
        clock.timeMillis = 2300001L;
        IdTokenVerifierTest.assertFalse((boolean)verifier.verify(idToken));
        IdTokenVerifierTest.assertFalse((boolean)verifier.verifyPayload(idToken));
    }

    public void testEmptyIssuersFails() throws Exception {
        IdTokenVerifier.Builder builder = new IdTokenVerifier.Builder();
        try {
            builder.setIssuers(Collections.emptyList());
            IdTokenVerifierTest.fail((String)"Exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBuilderSetNullIssuers() throws Exception {
        IdTokenVerifier.Builder builder = new IdTokenVerifier.Builder();
        IdTokenVerifier verifier = builder.build();
        IdTokenVerifierTest.assertNull((Object)builder.getIssuers());
        IdTokenVerifierTest.assertNull((Object)builder.getIssuer());
        IdTokenVerifierTest.assertNull((Object)verifier.getIssuers());
        IdTokenVerifierTest.assertNull((Object)verifier.getIssuer());
        builder.setIssuers(null);
        verifier = builder.build();
        IdTokenVerifierTest.assertNull((Object)builder.getIssuers());
        IdTokenVerifierTest.assertNull((Object)builder.getIssuer());
        IdTokenVerifierTest.assertNull((Object)verifier.getIssuers());
        IdTokenVerifierTest.assertNull((Object)verifier.getIssuer());
        builder.setIssuer(null);
        verifier = builder.build();
        IdTokenVerifierTest.assertNull((Object)builder.getIssuers());
        IdTokenVerifierTest.assertNull((Object)builder.getIssuer());
        IdTokenVerifierTest.assertNull((Object)verifier.getIssuers());
        IdTokenVerifierTest.assertNull((Object)verifier.getIssuer());
    }

    public void testMissingAudience() throws IOException {
        IdToken idToken = IdTokenVerifierTest.newIdToken(ISSUER, null);
        MockClock clock = new MockClock();
        clock.timeMillis = 1500000L;
        IdTokenVerifier verifier = new IdTokenVerifier.Builder().setIssuers(Arrays.asList(ISSUER, ISSUER3)).setAudience(Collections.emptyList()).setClock((Clock)clock).build();
        IdTokenVerifierTest.assertFalse((boolean)verifier.verify(idToken));
    }

    public void testPublicKeyStoreIntermittentError() throws Exception {
        MockLowLevelHttpRequest failedRequest = new MockLowLevelHttpRequest(){

            public LowLevelHttpResponse execute() throws IOException {
                throw new IOException("test io exception");
            }
        };
        MockLowLevelHttpRequest badRequest = new MockLowLevelHttpRequest(){

            public LowLevelHttpResponse execute() throws IOException {
                MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                response.setStatusCode(404);
                response.setContentType("application/json");
                response.setContent("");
                return response;
            }
        };
        MockLowLevelHttpRequest emptyRequest = new MockLowLevelHttpRequest(){

            public LowLevelHttpResponse execute() throws IOException {
                MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                response.setStatusCode(200);
                response.setContentType("application/json");
                response.setContent("{\"keys\":[]}");
                return response;
            }
        };
        MockLowLevelHttpRequest goodRequest = new MockLowLevelHttpRequest(){

            public LowLevelHttpResponse execute() throws IOException {
                MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                response.setStatusCode(200);
                response.setContentType("application/json");
                response.setContent(IdTokenVerifierTest.readResourceAsString("iap_keys.json"));
                return response;
            }
        };
        HttpTransportFactory httpTransportFactory = IdTokenVerifierTest.mockTransport(new LowLevelHttpRequest[]{failedRequest, badRequest, badRequest, badRequest, emptyRequest, goodRequest});
        IdTokenVerifier tokenVerifier = new IdTokenVerifier.Builder().setClock((Clock)FIXED_CLOCK).setHttpTransportFactory(httpTransportFactory).build();
        try {
            tokenVerifier.verifySignature(IdToken.parse((JsonFactory)JSON_FACTORY, (String)ES256_TOKEN));
            IdTokenVerifierTest.fail((String)"Should have failed verification");
        }
        catch (IOException ex) {
            IdTokenVerifierTest.assertTrue((boolean)ex.getMessage().contains("Error fetching public key"));
        }
        try {
            tokenVerifier.verifySignature(IdToken.parse((JsonFactory)JSON_FACTORY, (String)ES256_TOKEN));
            IdTokenVerifierTest.fail((String)"Should have failed verification");
        }
        catch (IOException ex) {
            IdTokenVerifierTest.assertTrue((boolean)ex.getMessage().contains("Error fetching public key"));
        }
        try {
            tokenVerifier.verifySignature(IdToken.parse((JsonFactory)JSON_FACTORY, (String)ES256_TOKEN));
            IdTokenVerifierTest.fail((String)"Should have failed verification");
        }
        catch (IOException ex) {
            IdTokenVerifierTest.assertTrue((boolean)ex.getCause().getMessage().contains("No valid public key returned"));
        }
        Assert.assertTrue((boolean)tokenVerifier.verifySignature(IdToken.parse((JsonFactory)JSON_FACTORY, (String)ES256_TOKEN)));
    }

    public void testVerifyEs256Token() throws IOException {
        HttpTransportFactory httpTransportFactory = IdTokenVerifierTest.mockTransport("https://www.gstatic.com/iap/verify/public_key-jwk", IdTokenVerifierTest.readResourceAsString("iap_keys.json"));
        IdTokenVerifier tokenVerifier = new IdTokenVerifier.Builder().setClock((Clock)FIXED_CLOCK).setHttpTransportFactory(httpTransportFactory).build();
        IdTokenVerifierTest.assertTrue((boolean)tokenVerifier.verify(IdToken.parse((JsonFactory)JSON_FACTORY, (String)ES256_TOKEN)));
    }

    public void testVerifyRs256Token() throws IOException {
        HttpTransportFactory httpTransportFactory = IdTokenVerifierTest.mockTransport(SERVICE_ACCOUNT_CERT_URL, IdTokenVerifierTest.readResourceAsString("federated_keys.json"));
        MockClock clock = new MockClock(1587625988000L);
        IdTokenVerifier tokenVerifier = new IdTokenVerifier.Builder().setClock((Clock)clock).setHttpTransportFactory(httpTransportFactory).build();
        IdTokenVerifierTest.assertTrue((boolean)tokenVerifier.verify(IdToken.parse((JsonFactory)JSON_FACTORY, (String)FEDERATED_SIGNON_RS256_TOKEN)));
    }

    public void testVerifyRs256TokenWithLegacyCertificateUrlFormat() throws IOException, IdTokenVerifier.VerificationException {
        HttpTransportFactory httpTransportFactory = IdTokenVerifierTest.mockTransport(LEGACY_FEDERATED_SIGNON_CERT_URL, IdTokenVerifierTest.readResourceAsString("legacy_federated_keys.json"));
        MockClock clock = new MockClock(1587626288000L);
        IdTokenVerifier tokenVerifier = new IdTokenVerifier.Builder().setCertificatesLocation(LEGACY_FEDERATED_SIGNON_CERT_URL).setClock((Clock)clock).setHttpTransportFactory(httpTransportFactory).build();
        IdTokenVerifierTest.assertTrue((boolean)tokenVerifier.verify(IdToken.parse((JsonFactory)JSON_FACTORY, (String)FEDERATED_SIGNON_RS256_TOKEN)));
    }

    private IdTokenVerifier generateTokenVerifier(long mockClockTime) throws IOException {
        MockClock clock = new MockClock(mockClockTime);
        HttpTransportFactory transportFactory = IdTokenVerifierTest.mockTransport(SERVICE_ACCOUNT_CERT_URL, IdTokenVerifierTest.readResourceAsString("certs.json"));
        return new IdTokenVerifier.Builder().setClock((Clock)clock).setCertificatesLocation(SERVICE_ACCOUNT_CERT_URL).setHttpTransportFactory(transportFactory).build();
    }

    public void testVerifyServiceAccountRs256Token() throws IOException {
        IdTokenVerifier tokenVerifier = this.generateTokenVerifier(1686002000000L);
        IdTokenVerifierTest.assertTrue((boolean)tokenVerifier.verify(IdToken.parse((JsonFactory)JSON_FACTORY, (String)SERVICE_ACCOUNT_RS256_TOKEN)));
        IdTokenVerifierTest.assertFalse((boolean)tokenVerifier.verify(IdToken.parse((JsonFactory)JSON_FACTORY, (String)SERVICE_ACCOUNT_RS256_TOKEN_BAD_SIGNATURE)));
        tokenVerifier = this.generateTokenVerifier(1660880973000L);
        IdTokenVerifierTest.assertTrue((boolean)tokenVerifier.verifyPayload(IdToken.parse((JsonFactory)JSON_FACTORY, (String)SERVICE_ACCOUNT_RS256_TOKEN_BAD_SIGNATURE)));
    }

    static String readResourceAsString(String resourceName) throws IOException {
        InputStream inputStream = IdTokenVerifierTest.class.getClassLoader().getResourceAsStream(resourceName);
        try (InputStreamReader reader = new InputStreamReader(inputStream);){
            String string = CharStreams.toString((Readable)reader);
            return string;
        }
    }

    static HttpTransportFactory mockTransport(LowLevelHttpRequest ... requests) {
        LowLevelHttpRequest firstRequest = requests[0];
        final ArrayDeque<LowLevelHttpRequest> requestQueue = new ArrayDeque<LowLevelHttpRequest>();
        for (LowLevelHttpRequest request : requests) {
            requestQueue.add(request);
        }
        return new HttpTransportFactory(){

            public HttpTransport create() {
                return new MockHttpTransport(){

                    public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                        return (LowLevelHttpRequest)requestQueue.poll();
                    }
                };
            }
        };
    }

    static HttpTransportFactory mockTransport(String url, String certificates) {
        final String certificatesContent = certificates;
        final String certificatesUrl = url;
        return new HttpTransportFactory(){

            public HttpTransport create() {
                return new MockHttpTransport(){

                    public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                        TestCase.assertEquals((String)certificatesUrl, (String)url);
                        return new MockLowLevelHttpRequest(){

                            public LowLevelHttpResponse execute() throws IOException {
                                MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                                response.setStatusCode(200);
                                response.setContentType("application/json");
                                response.setContent(certificatesContent);
                                return response;
                            }
                        };
                    }
                };
            }
        };
    }

    class MockEnvironment
    extends Environment {
        private final Map<String, String> variables = new HashMap<String, String>();

        MockEnvironment() {
        }

        public String getVariable(String name) {
            return this.variables.get(name);
        }

        public void setVariable(String name, String value) {
            this.variables.put(name, value);
        }
    }

    static class DefaultHttpTransportFactory
    implements HttpTransportFactory {
        DefaultHttpTransportFactory() {
        }

        public HttpTransport create() {
            return new NetHttpTransport();
        }
    }

    static class MockClock
    implements Clock {
        long timeMillis;

        public MockClock() {
        }

        public MockClock(long timeMillis) {
            this.timeMillis = timeMillis;
        }

        public long currentTimeMillis() {
            return this.timeMillis;
        }
    }
}

