/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.2
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.google.ortools.constraintsolver;

/**
 *  A Demon is the base element of a propagation queue. It is the main<br>
 *    object responsible for implementing the actual propagation<br>
 *    of the constraint and pruning the inconsistent values in the domains<br>
 *    of the variables. The main concept is that demons are listeners that are<br>
 *    attached to the variables and listen to their modifications.<br>
 *  There are two methods:<br>
 *   - Run() is the actual method called when the demon is processed.<br>
 *   - priority() returns its priority. Standard priorities are slow, normal<br>
 *     or fast. "immediate" is reserved for variables and is treated separately.
 */
public class Demon extends BaseObject {
  private transient long swigCPtr;

  protected Demon(long cPtr, boolean cMemoryOwn) {
    super(mainJNI.Demon_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(Demon obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        mainJNI.delete_Demon(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
   *  This is the main callback of the demon.
   */
  public void run(Solver s) {
    mainJNI.Demon_run(swigCPtr, this, Solver.getCPtr(s), s);
  }

  /**
   *  This method returns the priority of the demon. Usually a demon is<br>
   *  fast, slow or normal. Immediate demons are reserved for internal<br>
   *  use to maintain variables.
   */
  public int priority() {
    return mainJNI.Demon_priority(swigCPtr, this);
  }

  public String toString() {
    return mainJNI.Demon_toString(swigCPtr, this);
  }

  /**
   *  This method inhibits the demon in the search tree below the<br>
   *  current position.
   */
  public void inhibit(Solver s) {
    mainJNI.Demon_inhibit(swigCPtr, this, Solver.getCPtr(s), s);
  }

  /**
   *  This method un-inhibits the demon that was previously inhibited.
   */
  public void desinhibit(Solver s) {
    mainJNI.Demon_desinhibit(swigCPtr, this, Solver.getCPtr(s), s);
  }

}
