/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.2
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.google.ortools.constraintsolver;

import com.google.ortools.constraintsolver.ConstraintSolverParameters;
import com.google.ortools.constraintsolver.RegularLimitParameters;

// Used to wrap DisplayCallback (std::function<std::string()>)
// see https://docs.oracle.com/javase/8/docs/api/java/util/function/Supplier.html
import java.util.function.Supplier;
// Used to wrap std::function<bool()>
// see https://docs.oracle.com/javase/8/docs/api/java/util/function/BooleanSupplier.html
import java.util.function.BooleanSupplier;

// Used to wrap IndexEvaluator1 (std::function<int64_t(int64_t)>)
// see https://docs.oracle.com/javase/8/docs/api/java/util/function/LongUnaryOperator.html
import java.util.function.LongUnaryOperator;
// Used to wrap IndexEvaluator2 (std::function<int64_t(int64_t, int64_t)>)
// see https://docs.oracle.com/javase/8/docs/api/java/util/function/LongBinaryOperator.html
import java.util.function.LongBinaryOperator;
// Used to wrap IndexEvaluator3 (std::function<int64_t(int64_t, int64_t, int64_t)>)
// note: Java does not provide TernaryOperator so we provide it.
import com.google.ortools.constraintsolver.LongTernaryOperator;
// Used to wrap std::function<int64_t(int, int)>
// note: Java does not provide it, so we provide it.
import com.google.ortools.constraintsolver.IntIntToLongFunction;

// Used to wrap IndexFilter1 (std::function<bool(int64_t)>)
// see https://docs.oracle.com/javase/8/docs/api/java/util/function/LongPredicate.html
import java.util.function.LongPredicate;

// Used to wrap std::function<bool(int64_t, int64_t, int64_t)>
// note: Java does not provide TernaryPredicate so we provide it
import com.google.ortools.constraintsolver.LongTernaryPredicate;

// Used to wrap std::function<void(Solver*)>
// see https://docs.oracle.com/javase/8/docs/api/java/util/function/Consumer.html
import java.util.function.Consumer;

// Used to wrap ObjectiveWatcher (std::function<void(int64_t)>)
// see https://docs.oracle.com/javase/8/docs/api/java/util/function/LongConsumer.html
import java.util.function.LongConsumer;

// Used to wrap Closure (std::function<void()>)
// see https://docs.oracle.com/javase/8/docs/api/java/lang/Runnable.html
import java.lang.Runnable;

/**
 *  Solver Class<br>
 * <br>
 *  A solver represents the main computation engine. It implements the entire<br>
 *  range of Constraint Programming protocols:<br>
 *    - Reversibility<br>
 *    - Propagation<br>
 *    - Search<br>
 * <br>
 *  Usually, Constraint Programming code consists of<br>
 *    - the creation of the Solver,<br>
 *    - the creation of the decision variables of the model,<br>
 *    - the creation of the constraints of the model and their addition to the<br>
 *      solver() through the AddConstraint() method,<br>
 *    - the creation of the main DecisionBuilder class,<br>
 *    - the launch of the solve() method with the decision builder.<br>
 * <br>
 *  For the time being, Solver is neither MT_SAFE nor MT_HOT.
 */
public class Solver {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected Solver(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(Solver obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        mainJNI.delete_Solver(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
   * This exceptions signal that a failure has been raised in the C++ world.
   */
  public static class FailException extends Exception {
    public FailException() {
      super();
    }

    public FailException(String message) {
      super(message);
    }
  }

  public IntVar[] makeIntVarArray(int count, long min, long max) {
    IntVar[] array = new IntVar[count];
    for (int i = 0; i < count; ++i) {
      array[i] = makeIntVar(min, max);
    }
    return array;
  }

  public IntVar[] makeIntVarArray(int count, long min, long max, String name) {
    IntVar[] array = new IntVar[count];
    for (int i = 0; i < count; ++i) {
      String var_name = name + i;
      array[i] = makeIntVar(min, max, var_name);
    }
    return array;
  }

  public IntVar[] makeBoolVarArray(int count) {
    IntVar[] array = new IntVar[count];
    for (int i = 0; i < count; ++i) {
      array[i] = makeBoolVar();
    }
    return array;
  }

  public IntVar[] makeBoolVarArray(int count, String name) {
    IntVar[] array = new IntVar[count];
    for (int i = 0; i < count; ++i) {
      String var_name = name + i;
      array[i] = makeBoolVar(var_name);
    }
    return array;
  }

  public IntervalVar[] makeFixedDurationIntervalVarArray(int count,
                                                         long start_min,
                                                         long start_max,
                                                         long duration,
                                                         boolean optional) {
    IntervalVar[] array = new IntervalVar[count];
    for (int i = 0; i < count; ++i) {
      array[i] = makeFixedDurationIntervalVar(start_min,
                                              start_max,
                                              duration,
                                              optional,
                                              "");
    }
    return array;
  }

  public IntervalVar[] makeFixedDurationIntervalVarArray(int count,
                                                         long start_min,
                                                         long start_max,
                                                         long duration,
                                                         boolean optional,
                                                         String name) {
    IntervalVar[] array = new IntervalVar[count];
    for (int i = 0; i < count; ++i) {
      array[i] = makeFixedDurationIntervalVar(start_min,
                                              start_max,
                                              duration,
                                              optional,
                                              name + i);
    }
    return array;
  }

  /**
   *  Holds semantic information stating that the 'expression' has been<br>
   *  cast into 'variable' using the Var() method, and that<br>
   *  'maintainer' is responsible for maintaining the equality between<br>
   *  'variable' and 'expression'.
   */
  static public class IntegerCastInfo {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    protected IntegerCastInfo(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    protected static long getCPtr(IntegerCastInfo obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    @SuppressWarnings("deprecation")
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          mainJNI.delete_Solver_IntegerCastInfo(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
    public IntegerCastInfo() {
      this(mainJNI.new_Solver_IntegerCastInfo__SWIG_0(), true);
    }
  
    public IntegerCastInfo(IntVar v, IntExpr e, Constraint c) {
      this(mainJNI.new_Solver_IntegerCastInfo__SWIG_1(IntVar.getCPtr(v), v, IntExpr.getCPtr(e), e, Constraint.getCPtr(c), c), true);
    }
  
    public void setVariable(IntVar value) {
      mainJNI.Solver_IntegerCastInfo_variable_set(swigCPtr, this, IntVar.getCPtr(value), value);
    }
  
    public IntVar getVariable() {
      long cPtr = mainJNI.Solver_IntegerCastInfo_variable_get(swigCPtr, this);
      return (cPtr == 0) ? null : new IntVar(cPtr, false);
    }
  
    public void setExpression(IntExpr value) {
      mainJNI.Solver_IntegerCastInfo_expression_set(swigCPtr, this, IntExpr.getCPtr(value), value);
    }
  
    public IntExpr getExpression() {
      long cPtr = mainJNI.Solver_IntegerCastInfo_expression_get(swigCPtr, this);
      return (cPtr == 0) ? null : new IntExpr(cPtr, false);
    }
  
    public void setMaintainer(Constraint value) {
      mainJNI.Solver_IntegerCastInfo_maintainer_set(swigCPtr, this, Constraint.getCPtr(value), value);
    }
  
    public Constraint getMaintainer() {
      long cPtr = mainJNI.Solver_IntegerCastInfo_maintainer_get(swigCPtr, this);
      return (cPtr == 0) ? null : new Constraint(cPtr, false);
    }
  
  }

  /**
   *  Solver API
   */
  public Solver(String name) {
    this(mainJNI.new_Solver__SWIG_0(name), true);
  }

  public Solver(String name, com.google.ortools.constraintsolver.ConstraintSolverParameters parameters) {
    this(mainJNI.new_Solver__SWIG_1(name, parameters.toByteArray()), true);
  }

  /**
   *  Stored Parameters.
   */
  public com.google.ortools.constraintsolver.ConstraintSolverParameters parameters() {
  byte[] buf = mainJNI.Solver_parameters(swigCPtr, this);
  if (buf == null || buf.length == 0) {
    return null;
  }
  try {
    return com.google.ortools.constraintsolver.ConstraintSolverParameters.parseFrom(buf);
  } catch (com.google.protobuf.InvalidProtocolBufferException e) {
    throw new RuntimeException(
        "Unable to parse com.google.ortools.constraintsolver.ConstraintSolverParameters protocol message.");
  }
}

  /**
   *  Create a ConstraintSolverParameters proto with all the default values.
   */
  public static com.google.ortools.constraintsolver.ConstraintSolverParameters defaultSolverParameters() {
  byte[] buf = mainJNI.Solver_defaultSolverParameters();
  if (buf == null || buf.length == 0) {
    return null;
  }
  try {
    return com.google.ortools.constraintsolver.ConstraintSolverParameters.parseFrom(buf);
  } catch (com.google.protobuf.InvalidProtocolBufferException e) {
    throw new RuntimeException(
        "Unable to parse com.google.ortools.constraintsolver.ConstraintSolverParameters protocol message.");
  }
}

  /**
   *  Adds the constraint 'c' to the model.<br>
   * <br>
   *  After calling this method, and until there is a backtrack that undoes the<br>
   *  addition, any assignment of variables to values must satisfy the given<br>
   *  constraint in order to be considered feasible. There are two fairly<br>
   *  different use cases:<br>
   * <br>
   *  - the most common use case is modeling: the given constraint is really<br>
   *  part of the problem that the user is trying to solve. In this use case,<br>
   *  AddConstraint is called outside of search (i.e., with <tt>state() ==<br>
   *  OUTSIDE_SEARCH</tt>). Most users should only use AddConstraint in this<br>
   *  way. In this case, the constraint will belong to the model forever: it<br>
   *  cannot not be removed by backtracking.<br>
   * <br>
   *  - a rarer use case is that 'c' is not a real constraint of the model. It<br>
   *  may be a constraint generated by a branching decision (a constraint whose<br>
   *  goal is to restrict the search space), a symmetry breaking constraint (a<br>
   *  constraint that does restrict the search space, but in a way that cannot<br>
   *  have an impact on the quality of the solutions in the subtree), or an<br>
   *  inferred constraint that, while having no semantic value to the model (it<br>
   *  does not restrict the set of solutions), is worth having because we<br>
   *  believe it may strengthen the propagation. In these cases, it happens<br>
   *  that the constraint is added during the search (i.e., with state() ==<br>
   *  IN_SEARCH or state() == IN_ROOT_NODE). When a constraint is<br>
   *  added during a search, it applies only to the subtree of the search tree<br>
   *  rooted at the current node, and will be automatically removed by<br>
   *  backtracking.<br>
   * <br>
   *  This method does not take ownership of the constraint. If the constraint<br>
   *  has been created by any factory method (Solver::MakeXXX), it will<br>
   *  automatically be deleted. However, power users who implement their own<br>
   *  constraints should do: solver.AddConstraint(solver.RevAlloc(new<br>
   *  MyConstraint(...));
   */
  public void addConstraint(Constraint c) {
    mainJNI.Solver_addConstraint(swigCPtr, this, Constraint.getCPtr(c), c);
  }

  /**
   *  Adds 'constraint' to the solver and marks it as a cast constraint, that<br>
   *  is, a constraint created calling Var() on an expression. This is used<br>
   *  internally.
   */
  public void addCastConstraint(CastConstraint constraint, IntVar target_var, IntExpr expr) {
    mainJNI.Solver_addCastConstraint(swigCPtr, this, CastConstraint.getCPtr(constraint), constraint, IntVar.getCPtr(target_var), target_var, IntExpr.getCPtr(expr), expr);
  }

  /**
   *  <br>
   *  Solves the problem using the given DecisionBuilder and returns true if a<br>
   *  solution was found and accepted.<br>
   * <br>
   *  These methods are the ones most users should use to search for a solution.<br>
   *  Note that the definition of 'solution' is subtle. A solution here is<br>
   *  defined as a leaf of the search tree with respect to the given decision<br>
   *  builder for which there is no failure. What this means is that, contrary<br>
   *  to intuition, a solution may not have all variables of the model bound.<br>
   *  It is the responsibility of the decision builder to keep returning<br>
   *  decisions until all variables are indeed bound. The most extreme<br>
   *  counterexample is calling Solve with a trivial decision builder whose<br>
   *  Next() method always returns nullptr. In this case, Solve immediately<br>
   *  returns 'true', since not assigning any variable to any value is a<br>
   *  solution, unless the root node propagation discovers that the model is<br>
   *  infeasible.<br>
   * <br>
   *  This function must be called either from outside of search,<br>
   *  or from within the Next() method of a decision builder.<br>
   * <br>
   *  Solve will terminate whenever any of the following event arise:<br>
   * A search monitor asks the solver to terminate the search by calling<br>
   *    solver()-&gt;FinishCurrentSearch().<br>
   * A solution is found that is accepted by all search monitors, and none of<br>
   *    the search monitors decides to search for another one.<br>
   * <br>
   *  Upon search termination, there will be a series of backtracks all the way<br>
   *  to the top level. This means that a user cannot expect to inspect the<br>
   *  solution by querying variables after a call to Solve(): all the<br>
   *  information will be lost. In order to do something with the solution, the<br>
   *  user must either:<br>
   * <br>
   * Use a search monitor that can process such a leaf. See, in particular,<br>
   *      the SolutionCollector class.<br>
   * Do not use Solve. Instead, use the more fine-grained approach using<br>
   *      methods NewSearch(...), NextSolution(), and EndSearch().<br>
   * <br>
   *  @param db The decision builder that will generate the search tree.<br>
   *  @param monitors A vector of search monitors that will be notified of<br>
   *  various events during the search. In their reaction to these events, such<br>
   *  monitors may influence the search.
   */
  public boolean solve(DecisionBuilder db, SearchMonitor[] monitors) {
    return mainJNI.Solver_solve__SWIG_0(swigCPtr, this, DecisionBuilder.getCPtr(db), db, monitors);
  }

  public boolean solve(DecisionBuilder db) {
    return mainJNI.Solver_solve__SWIG_1(swigCPtr, this, DecisionBuilder.getCPtr(db), db);
  }

  public boolean solve(DecisionBuilder db, SearchMonitor m1) {
    return mainJNI.Solver_solve__SWIG_2(swigCPtr, this, DecisionBuilder.getCPtr(db), db, SearchMonitor.getCPtr(m1), m1);
  }

  public boolean solve(DecisionBuilder db, SearchMonitor m1, SearchMonitor m2) {
    return mainJNI.Solver_solve__SWIG_3(swigCPtr, this, DecisionBuilder.getCPtr(db), db, SearchMonitor.getCPtr(m1), m1, SearchMonitor.getCPtr(m2), m2);
  }

  public boolean solve(DecisionBuilder db, SearchMonitor m1, SearchMonitor m2, SearchMonitor m3) {
    return mainJNI.Solver_solve__SWIG_4(swigCPtr, this, DecisionBuilder.getCPtr(db), db, SearchMonitor.getCPtr(m1), m1, SearchMonitor.getCPtr(m2), m2, SearchMonitor.getCPtr(m3), m3);
  }

  public boolean solve(DecisionBuilder db, SearchMonitor m1, SearchMonitor m2, SearchMonitor m3, SearchMonitor m4) {
    return mainJNI.Solver_solve__SWIG_5(swigCPtr, this, DecisionBuilder.getCPtr(db), db, SearchMonitor.getCPtr(m1), m1, SearchMonitor.getCPtr(m2), m2, SearchMonitor.getCPtr(m3), m3, SearchMonitor.getCPtr(m4), m4);
  }

  /**
   *  <br>
   *  <br>
   *  Decomposed search.<br>
   *  The code for a top level search should look like<br>
   *  solver-&gt;NewSearch(db);<br>
   *  while (solver-&gt;NextSolution()) {<br>
   * .. use the current solution<br>
   *  }<br>
   *  solver()-&gt;EndSearch();
   */
  public void newSearch(DecisionBuilder db, SearchMonitor[] monitors) {
    mainJNI.Solver_newSearch__SWIG_0(swigCPtr, this, DecisionBuilder.getCPtr(db), db, monitors);
  }

  public void newSearch(DecisionBuilder db) {
    mainJNI.Solver_newSearch__SWIG_1(swigCPtr, this, DecisionBuilder.getCPtr(db), db);
  }

  public void newSearch(DecisionBuilder db, SearchMonitor m1) {
    mainJNI.Solver_newSearch__SWIG_2(swigCPtr, this, DecisionBuilder.getCPtr(db), db, SearchMonitor.getCPtr(m1), m1);
  }

  public void newSearch(DecisionBuilder db, SearchMonitor m1, SearchMonitor m2) {
    mainJNI.Solver_newSearch__SWIG_3(swigCPtr, this, DecisionBuilder.getCPtr(db), db, SearchMonitor.getCPtr(m1), m1, SearchMonitor.getCPtr(m2), m2);
  }

  public void newSearch(DecisionBuilder db, SearchMonitor m1, SearchMonitor m2, SearchMonitor m3) {
    mainJNI.Solver_newSearch__SWIG_4(swigCPtr, this, DecisionBuilder.getCPtr(db), db, SearchMonitor.getCPtr(m1), m1, SearchMonitor.getCPtr(m2), m2, SearchMonitor.getCPtr(m3), m3);
  }

  public void newSearch(DecisionBuilder db, SearchMonitor m1, SearchMonitor m2, SearchMonitor m3, SearchMonitor m4) {
    mainJNI.Solver_newSearch__SWIG_5(swigCPtr, this, DecisionBuilder.getCPtr(db), db, SearchMonitor.getCPtr(m1), m1, SearchMonitor.getCPtr(m2), m2, SearchMonitor.getCPtr(m3), m3, SearchMonitor.getCPtr(m4), m4);
  }

  public boolean nextSolution() {
    return mainJNI.Solver_nextSolution(swigCPtr, this);
  }

  public void restartSearch() {
    mainJNI.Solver_restartSearch(swigCPtr, this);
  }

  public void endSearch() {
    mainJNI.Solver_endSearch(swigCPtr, this);
  }

  /**
   *  <br>
   *  SolveAndCommit using a decision builder and up to three<br>
   *    search monitors, usually one for the objective, one for the limits<br>
   *    and one to collect solutions.<br>
   * <br>
   *  The difference between a SolveAndCommit() and a Solve() method<br>
   *  call is the fact that SolveAndCommit will not backtrack all<br>
   *  modifications at the end of the search. This method is only<br>
   *  usable during the Next() method of a decision builder.
   */
  public boolean solveAndCommit(DecisionBuilder db, SearchMonitor[] monitors) {
    return mainJNI.Solver_solveAndCommit__SWIG_0(swigCPtr, this, DecisionBuilder.getCPtr(db), db, monitors);
  }

  public boolean solveAndCommit(DecisionBuilder db) {
    return mainJNI.Solver_solveAndCommit__SWIG_1(swigCPtr, this, DecisionBuilder.getCPtr(db), db);
  }

  public boolean solveAndCommit(DecisionBuilder db, SearchMonitor m1) {
    return mainJNI.Solver_solveAndCommit__SWIG_2(swigCPtr, this, DecisionBuilder.getCPtr(db), db, SearchMonitor.getCPtr(m1), m1);
  }

  public boolean solveAndCommit(DecisionBuilder db, SearchMonitor m1, SearchMonitor m2) {
    return mainJNI.Solver_solveAndCommit__SWIG_3(swigCPtr, this, DecisionBuilder.getCPtr(db), db, SearchMonitor.getCPtr(m1), m1, SearchMonitor.getCPtr(m2), m2);
  }

  public boolean solveAndCommit(DecisionBuilder db, SearchMonitor m1, SearchMonitor m2, SearchMonitor m3) {
    return mainJNI.Solver_solveAndCommit__SWIG_4(swigCPtr, this, DecisionBuilder.getCPtr(db), db, SearchMonitor.getCPtr(m1), m1, SearchMonitor.getCPtr(m2), m2, SearchMonitor.getCPtr(m3), m3);
  }

  /**
   *  Checks whether the given assignment satisfies all relevant constraints.
   */
  public boolean checkAssignment(Assignment solution) {
    return mainJNI.Solver_checkAssignment(swigCPtr, this, Assignment.getCPtr(solution), solution);
  }

  /**
   *  Checks whether adding this constraint will lead to an immediate<br>
   *  failure. It will return false if the model is already inconsistent, or if<br>
   *  adding the constraint makes it inconsistent.
   */
  public boolean checkConstraint(Constraint ct) {
    return mainJNI.Solver_checkConstraint(swigCPtr, this, Constraint.getCPtr(ct), ct);
  }

  /**
   *  State of the solver.
   */
  public int state() {
    return mainJNI.Solver_state(swigCPtr, this);
  }

  /**
   *  Abandon the current branch in the search tree. A backtrack will follow.
   */
  public void fail() {
    mainJNI.Solver_fail(swigCPtr, this);
  }

  /**
   *  misc debug string.
   */
  public String toString() {
    return mainJNI.Solver_toString(swigCPtr, this);
  }

  /**
   *  Current memory usage in bytes
   */
  public static long memoryUsage() {
    return mainJNI.Solver_memoryUsage();
  }

  /**
   *  DEPRECATED: Use Now() instead.<br>
   *  Time elapsed, in ms since the creation of the solver.
   */
  public long wallTime() {
    return mainJNI.Solver_wallTime(swigCPtr, this);
  }

  /**
   *  The number of branches explored since the creation of the solver.
   */
  public long branches() {
    return mainJNI.Solver_branches(swigCPtr, this);
  }

  /**
   *  The number of solutions found since the start of the search.
   */
  public long solutions() {
    return mainJNI.Solver_solutions(swigCPtr, this);
  }

  /**
   *  The number of unchecked solutions found by local search.
   */
  public long unchecked_solutions() {
    return mainJNI.Solver_unchecked_solutions(swigCPtr, this);
  }

  /**
   *  The number of demons executed during search for a given priority.
   */
  public long demon_runs(int p) {
    return mainJNI.Solver_demon_runs(swigCPtr, this, p);
  }

  /**
   *  The number of failures encountered since the creation of the solver.
   */
  public long failures() {
    return mainJNI.Solver_failures(swigCPtr, this);
  }

  /**
   *  The number of neighbors created.
   */
  public long neighbors() {
    return mainJNI.Solver_neighbors(swigCPtr, this);
  }

  /**
   *  The number of filtered neighbors (neighbors accepted by filters).
   */
  public long filteredNeighbors() {
    return mainJNI.Solver_filteredNeighbors(swigCPtr, this);
  }

  /**
   *  The number of accepted neighbors.
   */
  public long acceptedNeighbors() {
    return mainJNI.Solver_acceptedNeighbors(swigCPtr, this);
  }

  /**
   *  The stamp indicates how many moves in the search tree we have performed.<br>
   *  It is useful to detect if we need to update same lazy structures.
   */
  public long stamp() {
    return mainJNI.Solver_stamp(swigCPtr, this);
  }

  /**
   *  The fail_stamp() is incremented after each backtrack.
   */
  public long fail_stamp() {
    return mainJNI.Solver_fail_stamp(swigCPtr, this);
  }

  /**
   *  The direction of optimization, getter and setter.
   */
  public int optimization_direction() {
    return mainJNI.Solver_optimization_direction(swigCPtr, this);
  }

  public void set_optimization_direction(int direction) {
    mainJNI.Solver_set_optimization_direction(swigCPtr, this, direction);
  }

  /**
   *  MakeIntVar will create the best range based int var for the bounds given.
   */
  public IntVar makeIntVar(long min, long max, String name) {
    long cPtr = mainJNI.Solver_makeIntVar__SWIG_0(swigCPtr, this, min, max, name);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  MakeIntVar will create a variable with the given sparse domain.
   */
  public IntVar makeIntVar(long[] values, String name) {
    long cPtr = mainJNI.Solver_makeIntVar__SWIG_1(swigCPtr, this, values, name);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  MakeIntVar will create a variable with the given sparse domain.
   */
  public IntVar makeIntVar(int[] values, String name) {
    long cPtr = mainJNI.Solver_makeIntVar__SWIG_2(swigCPtr, this, values, name);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  MakeIntVar will create the best range based int var for the bounds given.
   */
  public IntVar makeIntVar(long min, long max) {
    long cPtr = mainJNI.Solver_makeIntVar__SWIG_3(swigCPtr, this, min, max);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  MakeIntVar will create a variable with the given sparse domain.
   */
  public IntVar makeIntVar(long[] values) {
    long cPtr = mainJNI.Solver_makeIntVar__SWIG_4(swigCPtr, this, values);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  MakeIntVar will create a variable with the given sparse domain.
   */
  public IntVar makeIntVar(int[] values) {
    long cPtr = mainJNI.Solver_makeIntVar__SWIG_5(swigCPtr, this, values);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  MakeBoolVar will create a variable with a {0, 1} domain.
   */
  public IntVar makeBoolVar(String name) {
    long cPtr = mainJNI.Solver_makeBoolVar__SWIG_0(swigCPtr, this, name);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  MakeBoolVar will create a variable with a {0, 1} domain.
   */
  public IntVar makeBoolVar() {
    long cPtr = mainJNI.Solver_makeBoolVar__SWIG_1(swigCPtr, this);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  IntConst will create a constant expression.
   */
  public IntVar makeIntConst(long val, String name) {
    long cPtr = mainJNI.Solver_makeIntConst__SWIG_0(swigCPtr, this, val, name);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  IntConst will create a constant expression.
   */
  public IntVar makeIntConst(long val) {
    long cPtr = mainJNI.Solver_makeIntConst__SWIG_1(swigCPtr, this, val);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  left + right.
   */
  public IntExpr makeSum(IntExpr left, IntExpr right) {
    long cPtr = mainJNI.Solver_makeSum__SWIG_0(swigCPtr, this, IntExpr.getCPtr(left), left, IntExpr.getCPtr(right), right);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  expr + value.
   */
  public IntExpr makeSum(IntExpr expr, long value) {
    long cPtr = mainJNI.Solver_makeSum__SWIG_1(swigCPtr, this, IntExpr.getCPtr(expr), expr, value);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  sum of all vars.
   */
  public IntExpr makeSum(IntVar[] vars) {
    long cPtr = mainJNI.Solver_makeSum__SWIG_2(swigCPtr, this, vars);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  scalar product
   */
  public IntExpr makeScalProd(IntVar[] vars, long[] coefs) {
    long cPtr = mainJNI.Solver_makeScalProd__SWIG_0(swigCPtr, this, vars, coefs);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  scalar product
   */
  public IntExpr makeScalProd(IntVar[] vars, int[] coefs) {
    long cPtr = mainJNI.Solver_makeScalProd__SWIG_1(swigCPtr, this, vars, coefs);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  left - right
   */
  public IntExpr makeDifference(IntExpr left, IntExpr right) {
    long cPtr = mainJNI.Solver_makeDifference__SWIG_0(swigCPtr, this, IntExpr.getCPtr(left), left, IntExpr.getCPtr(right), right);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  value - expr
   */
  public IntExpr makeDifference(long value, IntExpr expr) {
    long cPtr = mainJNI.Solver_makeDifference__SWIG_1(swigCPtr, this, value, IntExpr.getCPtr(expr), expr);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  -expr
   */
  public IntExpr makeOpposite(IntExpr expr) {
    long cPtr = mainJNI.Solver_makeOpposite(swigCPtr, this, IntExpr.getCPtr(expr), expr);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  left * right
   */
  public IntExpr makeProd(IntExpr left, IntExpr right) {
    long cPtr = mainJNI.Solver_makeProd__SWIG_0(swigCPtr, this, IntExpr.getCPtr(left), left, IntExpr.getCPtr(right), right);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  expr * value
   */
  public IntExpr makeProd(IntExpr expr, long value) {
    long cPtr = mainJNI.Solver_makeProd__SWIG_1(swigCPtr, this, IntExpr.getCPtr(expr), expr, value);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  expr / value (integer division)
   */
  public IntExpr makeDiv(IntExpr expr, long value) {
    long cPtr = mainJNI.Solver_makeDiv__SWIG_0(swigCPtr, this, IntExpr.getCPtr(expr), expr, value);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  numerator / denominator (integer division). Terms need to be positive.
   */
  public IntExpr makeDiv(IntExpr numerator, IntExpr denominator) {
    long cPtr = mainJNI.Solver_makeDiv__SWIG_1(swigCPtr, this, IntExpr.getCPtr(numerator), numerator, IntExpr.getCPtr(denominator), denominator);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  |expr|
   */
  public IntExpr makeAbs(IntExpr expr) {
    long cPtr = mainJNI.Solver_makeAbs(swigCPtr, this, IntExpr.getCPtr(expr), expr);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  expr * expr
   */
  public IntExpr makeSquare(IntExpr expr) {
    long cPtr = mainJNI.Solver_makeSquare(swigCPtr, this, IntExpr.getCPtr(expr), expr);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  expr ^ n (n &gt; 0)
   */
  public IntExpr makePower(IntExpr expr, long n) {
    long cPtr = mainJNI.Solver_makePower(swigCPtr, this, IntExpr.getCPtr(expr), expr, n);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  values[index]
   */
  public IntExpr makeElement(long[] values, IntVar index) {
    long cPtr = mainJNI.Solver_makeElement__SWIG_0(swigCPtr, this, values, IntVar.getCPtr(index), index);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  values[index]
   */
  public IntExpr makeElement(int[] values, IntVar index) {
    long cPtr = mainJNI.Solver_makeElement__SWIG_1(swigCPtr, this, values, IntVar.getCPtr(index), index);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  Function-based element. The constraint takes ownership of the<br>
   *  callback. The callback must be able to cope with any possible<br>
   *  value in the domain of 'index' (potentially negative ones too).
   */
  public IntExpr makeElement(LongUnaryOperator values, IntVar index) {
    long cPtr = mainJNI.Solver_makeElement__SWIG_2(swigCPtr, this, values, IntVar.getCPtr(index), index);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  Function based element. The constraint takes ownership of the<br>
   *  callback.  The callback must be monotonic. It must be able to<br>
   *  cope with any possible value in the domain of 'index'<br>
   *  (potentially negative ones too). Furtermore, monotonicity is not<br>
   *  checked. Thus giving a non-monotonic function, or specifying an<br>
   *  incorrect increasing parameter will result in undefined behavior.
   */
  public IntExpr makeMonotonicElement(LongUnaryOperator values, boolean increasing, IntVar index) {
    long cPtr = mainJNI.Solver_makeMonotonicElement(swigCPtr, this, values, increasing, IntVar.getCPtr(index), index);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  2D version of function-based element expression, values(expr1, expr2).
   */
  public IntExpr makeElement(LongBinaryOperator values, IntVar index1, IntVar index2) {
    long cPtr = mainJNI.Solver_makeElement__SWIG_3(swigCPtr, this, values, IntVar.getCPtr(index1), index1, IntVar.getCPtr(index2), index2);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  vars[expr]
   */
  public IntExpr makeElement(IntVar[] vars, IntVar index) {
    long cPtr = mainJNI.Solver_makeElement__SWIG_4(swigCPtr, this, vars, IntVar.getCPtr(index), index);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  Returns the expression expr such that vars[expr] == value.<br>
   *  It assumes that vars are all different.
   */
  public IntExpr makeIndexExpression(IntVar[] vars, long value) {
    long cPtr = mainJNI.Solver_makeIndexExpression(swigCPtr, this, vars, value);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  Special cases with arrays of size two.
   */
  public Constraint makeIfThenElseCt(IntVar condition, IntExpr then_expr, IntExpr else_expr, IntVar target_var) {
    long cPtr = mainJNI.Solver_makeIfThenElseCt(swigCPtr, this, IntVar.getCPtr(condition), condition, IntExpr.getCPtr(then_expr), then_expr, IntExpr.getCPtr(else_expr), else_expr, IntVar.getCPtr(target_var), target_var);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  std::min(vars)
   */
  public IntExpr makeMin(IntVar[] vars) {
    long cPtr = mainJNI.Solver_makeMin__SWIG_0(swigCPtr, this, vars);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  std::min (left, right)
   */
  public IntExpr makeMin(IntExpr left, IntExpr right) {
    long cPtr = mainJNI.Solver_makeMin__SWIG_1(swigCPtr, this, IntExpr.getCPtr(left), left, IntExpr.getCPtr(right), right);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  std::min(expr, value)
   */
  public IntExpr makeMin(IntExpr expr, long value) {
    long cPtr = mainJNI.Solver_makeMin__SWIG_2(swigCPtr, this, IntExpr.getCPtr(expr), expr, value);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  std::min(expr, value)
   */
  public IntExpr makeMin(IntExpr expr, int value) {
    long cPtr = mainJNI.Solver_makeMin__SWIG_3(swigCPtr, this, IntExpr.getCPtr(expr), expr, value);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  std::max(vars)
   */
  public IntExpr makeMax(IntVar[] vars) {
    long cPtr = mainJNI.Solver_makeMax__SWIG_0(swigCPtr, this, vars);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  std::max(left, right)
   */
  public IntExpr makeMax(IntExpr left, IntExpr right) {
    long cPtr = mainJNI.Solver_makeMax__SWIG_1(swigCPtr, this, IntExpr.getCPtr(left), left, IntExpr.getCPtr(right), right);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  std::max(expr, value)
   */
  public IntExpr makeMax(IntExpr expr, long value) {
    long cPtr = mainJNI.Solver_makeMax__SWIG_2(swigCPtr, this, IntExpr.getCPtr(expr), expr, value);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  std::max(expr, value)
   */
  public IntExpr makeMax(IntExpr expr, int value) {
    long cPtr = mainJNI.Solver_makeMax__SWIG_3(swigCPtr, this, IntExpr.getCPtr(expr), expr, value);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  Convex piecewise function.
   */
  public IntExpr makeConvexPiecewiseExpr(IntExpr expr, long early_cost, long early_date, long late_date, long late_cost) {
    long cPtr = mainJNI.Solver_makeConvexPiecewiseExpr(swigCPtr, this, IntExpr.getCPtr(expr), expr, early_cost, early_date, late_date, late_cost);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  Semi continuous Expression (x &lt;= 0 -&gt; f(x) = 0; x &gt; 0 -&gt; f(x) = ax + b)<br>
   *  a &gt;= 0 and b &gt;= 0
   */
  public IntExpr makeSemiContinuousExpr(IntExpr expr, long fixed_charge, long step) {
    long cPtr = mainJNI.Solver_makeSemiContinuousExpr(swigCPtr, this, IntExpr.getCPtr(expr), expr, fixed_charge, step);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  General piecewise-linear function expression, built from f(x) where f is<br>
   *  piecewise-linear. The resulting expression is f(expr).<br>
   *  expressions.<br>
   *  Modulo expression x % mod (with the python convention for modulo).
   */
  public IntExpr makeModulo(IntExpr x, long mod) {
    long cPtr = mainJNI.Solver_makeModulo__SWIG_0(swigCPtr, this, IntExpr.getCPtr(x), x, mod);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  Modulo expression x % mod (with the python convention for modulo).
   */
  public IntExpr makeModulo(IntExpr x, IntExpr mod) {
    long cPtr = mainJNI.Solver_makeModulo__SWIG_1(swigCPtr, this, IntExpr.getCPtr(x), x, IntExpr.getCPtr(mod), mod);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  Conditional Expr condition ? expr : unperformed_value
   */
  public IntExpr makeConditionalExpression(IntVar condition, IntExpr expr, long unperformed_value) {
    long cPtr = mainJNI.Solver_makeConditionalExpression(swigCPtr, this, IntVar.getCPtr(condition), condition, IntExpr.getCPtr(expr), expr, unperformed_value);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  This constraint always succeeds.
   */
  public Constraint makeTrueConstraint() {
    long cPtr = mainJNI.Solver_makeTrueConstraint(swigCPtr, this);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This constraint always fails.
   */
  public Constraint makeFalseConstraint() {
    long cPtr = mainJNI.Solver_makeFalseConstraint__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeFalseConstraint(String explanation) {
    long cPtr = mainJNI.Solver_makeFalseConstraint__SWIG_1(swigCPtr, this, explanation);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  boolvar == (var == value)
   */
  public Constraint makeIsEqualCstCt(IntExpr var, long value, IntVar boolvar) {
    long cPtr = mainJNI.Solver_makeIsEqualCstCt(swigCPtr, this, IntExpr.getCPtr(var), var, value, IntVar.getCPtr(boolvar), boolvar);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  status var of (var == value)
   */
  public IntVar makeIsEqualCstVar(IntExpr var, long value) {
    long cPtr = mainJNI.Solver_makeIsEqualCstVar(swigCPtr, this, IntExpr.getCPtr(var), var, value);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  b == (v1 == v2)
   */
  public Constraint makeIsEqualVar(IntExpr v1, IntExpr v2, IntVar b) {
    long cPtr = mainJNI.Solver_makeIsEqualVar__SWIG_0(swigCPtr, this, IntExpr.getCPtr(v1), v1, IntExpr.getCPtr(v2), v2, IntVar.getCPtr(b), b);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  status var of (v1 == v2)
   */
  public IntVar makeIsEqualVar(IntExpr v1, IntExpr v2) {
    long cPtr = mainJNI.Solver_makeIsEqualVar__SWIG_1(swigCPtr, this, IntExpr.getCPtr(v1), v1, IntExpr.getCPtr(v2), v2);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  left == right
   */
  public Constraint makeEquality(IntExpr left, IntExpr right) {
    long cPtr = mainJNI.Solver_makeEquality__SWIG_0(swigCPtr, this, IntExpr.getCPtr(left), left, IntExpr.getCPtr(right), right);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  expr == value
   */
  public Constraint makeEquality(IntExpr expr, long value) {
    long cPtr = mainJNI.Solver_makeEquality__SWIG_1(swigCPtr, this, IntExpr.getCPtr(expr), expr, value);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  expr == value
   */
  public Constraint makeEquality(IntExpr expr, int value) {
    long cPtr = mainJNI.Solver_makeEquality__SWIG_2(swigCPtr, this, IntExpr.getCPtr(expr), expr, value);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  boolvar == (var != value)
   */
  public Constraint makeIsDifferentCstCt(IntExpr var, long value, IntVar boolvar) {
    long cPtr = mainJNI.Solver_makeIsDifferentCstCt__SWIG_0(swigCPtr, this, IntExpr.getCPtr(var), var, value, IntVar.getCPtr(boolvar), boolvar);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  status var of (var != value)
   */
  public IntVar makeIsDifferentCstVar(IntExpr var, long value) {
    long cPtr = mainJNI.Solver_makeIsDifferentCstVar__SWIG_0(swigCPtr, this, IntExpr.getCPtr(var), var, value);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  status var of (v1 != v2)
   */
  public IntVar makeIsDifferentCstVar(IntExpr v1, IntExpr v2) {
    long cPtr = mainJNI.Solver_makeIsDifferentCstVar__SWIG_1(swigCPtr, this, IntExpr.getCPtr(v1), v1, IntExpr.getCPtr(v2), v2);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  b == (v1 != v2)
   */
  public Constraint makeIsDifferentCstCt(IntExpr v1, IntExpr v2, IntVar b) {
    long cPtr = mainJNI.Solver_makeIsDifferentCstCt__SWIG_1(swigCPtr, this, IntExpr.getCPtr(v1), v1, IntExpr.getCPtr(v2), v2, IntVar.getCPtr(b), b);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  left != right
   */
  public Constraint makeNonEquality(IntExpr left, IntExpr right) {
    long cPtr = mainJNI.Solver_makeNonEquality__SWIG_0(swigCPtr, this, IntExpr.getCPtr(left), left, IntExpr.getCPtr(right), right);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  expr != value
   */
  public Constraint makeNonEquality(IntExpr expr, long value) {
    long cPtr = mainJNI.Solver_makeNonEquality__SWIG_1(swigCPtr, this, IntExpr.getCPtr(expr), expr, value);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  expr != value
   */
  public Constraint makeNonEquality(IntExpr expr, int value) {
    long cPtr = mainJNI.Solver_makeNonEquality__SWIG_2(swigCPtr, this, IntExpr.getCPtr(expr), expr, value);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  boolvar == (var &lt;= value)
   */
  public Constraint makeIsLessOrEqualCstCt(IntExpr var, long value, IntVar boolvar) {
    long cPtr = mainJNI.Solver_makeIsLessOrEqualCstCt(swigCPtr, this, IntExpr.getCPtr(var), var, value, IntVar.getCPtr(boolvar), boolvar);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  status var of (var &lt;= value)
   */
  public IntVar makeIsLessOrEqualCstVar(IntExpr var, long value) {
    long cPtr = mainJNI.Solver_makeIsLessOrEqualCstVar(swigCPtr, this, IntExpr.getCPtr(var), var, value);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  status var of (left &lt;= right)
   */
  public IntVar makeIsLessOrEqualVar(IntExpr left, IntExpr right) {
    long cPtr = mainJNI.Solver_makeIsLessOrEqualVar(swigCPtr, this, IntExpr.getCPtr(left), left, IntExpr.getCPtr(right), right);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  b == (left &lt;= right)
   */
  public Constraint makeIsLessOrEqualCt(IntExpr left, IntExpr right, IntVar b) {
    long cPtr = mainJNI.Solver_makeIsLessOrEqualCt(swigCPtr, this, IntExpr.getCPtr(left), left, IntExpr.getCPtr(right), right, IntVar.getCPtr(b), b);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  left &lt;= right
   */
  public Constraint makeLessOrEqual(IntExpr left, IntExpr right) {
    long cPtr = mainJNI.Solver_makeLessOrEqual__SWIG_0(swigCPtr, this, IntExpr.getCPtr(left), left, IntExpr.getCPtr(right), right);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  expr &lt;= value
   */
  public Constraint makeLessOrEqual(IntExpr expr, long value) {
    long cPtr = mainJNI.Solver_makeLessOrEqual__SWIG_1(swigCPtr, this, IntExpr.getCPtr(expr), expr, value);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  expr &lt;= value
   */
  public Constraint makeLessOrEqual(IntExpr expr, int value) {
    long cPtr = mainJNI.Solver_makeLessOrEqual__SWIG_2(swigCPtr, this, IntExpr.getCPtr(expr), expr, value);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  boolvar == (var &gt;= value)
   */
  public Constraint makeIsGreaterOrEqualCstCt(IntExpr var, long value, IntVar boolvar) {
    long cPtr = mainJNI.Solver_makeIsGreaterOrEqualCstCt(swigCPtr, this, IntExpr.getCPtr(var), var, value, IntVar.getCPtr(boolvar), boolvar);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  status var of (var &gt;= value)
   */
  public IntVar makeIsGreaterOrEqualCstVar(IntExpr var, long value) {
    long cPtr = mainJNI.Solver_makeIsGreaterOrEqualCstVar(swigCPtr, this, IntExpr.getCPtr(var), var, value);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  status var of (left &gt;= right)
   */
  public IntVar makeIsGreaterOrEqualVar(IntExpr left, IntExpr right) {
    long cPtr = mainJNI.Solver_makeIsGreaterOrEqualVar(swigCPtr, this, IntExpr.getCPtr(left), left, IntExpr.getCPtr(right), right);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  b == (left &gt;= right)
   */
  public Constraint makeIsGreaterOrEqualCt(IntExpr left, IntExpr right, IntVar b) {
    long cPtr = mainJNI.Solver_makeIsGreaterOrEqualCt(swigCPtr, this, IntExpr.getCPtr(left), left, IntExpr.getCPtr(right), right, IntVar.getCPtr(b), b);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  left &gt;= right
   */
  public Constraint makeGreaterOrEqual(IntExpr left, IntExpr right) {
    long cPtr = mainJNI.Solver_makeGreaterOrEqual__SWIG_0(swigCPtr, this, IntExpr.getCPtr(left), left, IntExpr.getCPtr(right), right);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  expr &gt;= value
   */
  public Constraint makeGreaterOrEqual(IntExpr expr, long value) {
    long cPtr = mainJNI.Solver_makeGreaterOrEqual__SWIG_1(swigCPtr, this, IntExpr.getCPtr(expr), expr, value);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  expr &gt;= value
   */
  public Constraint makeGreaterOrEqual(IntExpr expr, int value) {
    long cPtr = mainJNI.Solver_makeGreaterOrEqual__SWIG_2(swigCPtr, this, IntExpr.getCPtr(expr), expr, value);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  b == (v &gt; c)
   */
  public Constraint makeIsGreaterCstCt(IntExpr v, long c, IntVar b) {
    long cPtr = mainJNI.Solver_makeIsGreaterCstCt(swigCPtr, this, IntExpr.getCPtr(v), v, c, IntVar.getCPtr(b), b);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  status var of (var &gt; value)
   */
  public IntVar makeIsGreaterCstVar(IntExpr var, long value) {
    long cPtr = mainJNI.Solver_makeIsGreaterCstVar(swigCPtr, this, IntExpr.getCPtr(var), var, value);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  status var of (left &gt; right)
   */
  public IntVar makeIsGreaterVar(IntExpr left, IntExpr right) {
    long cPtr = mainJNI.Solver_makeIsGreaterVar(swigCPtr, this, IntExpr.getCPtr(left), left, IntExpr.getCPtr(right), right);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  b == (left &gt; right)
   */
  public Constraint makeIsGreaterCt(IntExpr left, IntExpr right, IntVar b) {
    long cPtr = mainJNI.Solver_makeIsGreaterCt(swigCPtr, this, IntExpr.getCPtr(left), left, IntExpr.getCPtr(right), right, IntVar.getCPtr(b), b);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  left &gt; right
   */
  public Constraint makeGreater(IntExpr left, IntExpr right) {
    long cPtr = mainJNI.Solver_makeGreater__SWIG_0(swigCPtr, this, IntExpr.getCPtr(left), left, IntExpr.getCPtr(right), right);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  expr &gt; value
   */
  public Constraint makeGreater(IntExpr expr, long value) {
    long cPtr = mainJNI.Solver_makeGreater__SWIG_1(swigCPtr, this, IntExpr.getCPtr(expr), expr, value);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  expr &gt; value
   */
  public Constraint makeGreater(IntExpr expr, int value) {
    long cPtr = mainJNI.Solver_makeGreater__SWIG_2(swigCPtr, this, IntExpr.getCPtr(expr), expr, value);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  b == (v &lt; c)
   */
  public Constraint makeIsLessCstCt(IntExpr v, long c, IntVar b) {
    long cPtr = mainJNI.Solver_makeIsLessCstCt(swigCPtr, this, IntExpr.getCPtr(v), v, c, IntVar.getCPtr(b), b);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  status var of (var &lt; value)
   */
  public IntVar makeIsLessCstVar(IntExpr var, long value) {
    long cPtr = mainJNI.Solver_makeIsLessCstVar(swigCPtr, this, IntExpr.getCPtr(var), var, value);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  status var of (left &lt; right)
   */
  public IntVar makeIsLessVar(IntExpr left, IntExpr right) {
    long cPtr = mainJNI.Solver_makeIsLessVar(swigCPtr, this, IntExpr.getCPtr(left), left, IntExpr.getCPtr(right), right);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  b == (left &lt; right)
   */
  public Constraint makeIsLessCt(IntExpr left, IntExpr right, IntVar b) {
    long cPtr = mainJNI.Solver_makeIsLessCt(swigCPtr, this, IntExpr.getCPtr(left), left, IntExpr.getCPtr(right), right, IntVar.getCPtr(b), b);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  left &lt; right
   */
  public Constraint makeLess(IntExpr left, IntExpr right) {
    long cPtr = mainJNI.Solver_makeLess__SWIG_0(swigCPtr, this, IntExpr.getCPtr(left), left, IntExpr.getCPtr(right), right);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  expr &lt; value
   */
  public Constraint makeLess(IntExpr expr, long value) {
    long cPtr = mainJNI.Solver_makeLess__SWIG_1(swigCPtr, this, IntExpr.getCPtr(expr), expr, value);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  expr &lt; value
   */
  public Constraint makeLess(IntExpr expr, int value) {
    long cPtr = mainJNI.Solver_makeLess__SWIG_2(swigCPtr, this, IntExpr.getCPtr(expr), expr, value);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Variation on arrays.
   */
  public Constraint makeSumLessOrEqual(IntVar[] vars, long cst) {
    long cPtr = mainJNI.Solver_makeSumLessOrEqual(swigCPtr, this, vars, cst);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeSumGreaterOrEqual(IntVar[] vars, long cst) {
    long cPtr = mainJNI.Solver_makeSumGreaterOrEqual(swigCPtr, this, vars, cst);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeSumEquality(IntVar[] vars, long cst) {
    long cPtr = mainJNI.Solver_makeSumEquality__SWIG_0(swigCPtr, this, vars, cst);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeSumEquality(IntVar[] vars, IntVar var) {
    long cPtr = mainJNI.Solver_makeSumEquality__SWIG_1(swigCPtr, this, vars, IntVar.getCPtr(var), var);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeScalProdEquality(IntVar[] vars, long[] coefficients, long cst) {
    long cPtr = mainJNI.Solver_makeScalProdEquality__SWIG_0(swigCPtr, this, vars, coefficients, cst);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeScalProdEquality(IntVar[] vars, int[] coefficients, long cst) {
    long cPtr = mainJNI.Solver_makeScalProdEquality__SWIG_1(swigCPtr, this, vars, coefficients, cst);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeScalProdEquality(IntVar[] vars, long[] coefficients, IntVar target) {
    long cPtr = mainJNI.Solver_makeScalProdEquality__SWIG_2(swigCPtr, this, vars, coefficients, IntVar.getCPtr(target), target);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeScalProdEquality(IntVar[] vars, int[] coefficients, IntVar target) {
    long cPtr = mainJNI.Solver_makeScalProdEquality__SWIG_3(swigCPtr, this, vars, coefficients, IntVar.getCPtr(target), target);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeScalProdGreaterOrEqual(IntVar[] vars, long[] coeffs, long cst) {
    long cPtr = mainJNI.Solver_makeScalProdGreaterOrEqual__SWIG_0(swigCPtr, this, vars, coeffs, cst);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeScalProdGreaterOrEqual(IntVar[] vars, int[] coeffs, long cst) {
    long cPtr = mainJNI.Solver_makeScalProdGreaterOrEqual__SWIG_1(swigCPtr, this, vars, coeffs, cst);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeScalProdLessOrEqual(IntVar[] vars, long[] coefficients, long cst) {
    long cPtr = mainJNI.Solver_makeScalProdLessOrEqual__SWIG_0(swigCPtr, this, vars, coefficients, cst);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeScalProdLessOrEqual(IntVar[] vars, int[] coefficients, long cst) {
    long cPtr = mainJNI.Solver_makeScalProdLessOrEqual__SWIG_1(swigCPtr, this, vars, coefficients, cst);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeMinEquality(IntVar[] vars, IntVar min_var) {
    long cPtr = mainJNI.Solver_makeMinEquality(swigCPtr, this, vars, IntVar.getCPtr(min_var), min_var);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeMaxEquality(IntVar[] vars, IntVar max_var) {
    long cPtr = mainJNI.Solver_makeMaxEquality(swigCPtr, this, vars, IntVar.getCPtr(max_var), max_var);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeElementEquality(long[] vals, IntVar index, IntVar target) {
    long cPtr = mainJNI.Solver_makeElementEquality__SWIG_0(swigCPtr, this, vals, IntVar.getCPtr(index), index, IntVar.getCPtr(target), target);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeElementEquality(int[] vals, IntVar index, IntVar target) {
    long cPtr = mainJNI.Solver_makeElementEquality__SWIG_1(swigCPtr, this, vals, IntVar.getCPtr(index), index, IntVar.getCPtr(target), target);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeElementEquality(IntVar[] vars, IntVar index, IntVar target) {
    long cPtr = mainJNI.Solver_makeElementEquality__SWIG_2(swigCPtr, this, vars, IntVar.getCPtr(index), index, IntVar.getCPtr(target), target);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeElementEquality(IntVar[] vars, IntVar index, long target) {
    long cPtr = mainJNI.Solver_makeElementEquality__SWIG_3(swigCPtr, this, vars, IntVar.getCPtr(index), index, target);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Creates the constraint abs(var) == abs_var.
   */
  public Constraint makeAbsEquality(IntVar var, IntVar abs_var) {
    long cPtr = mainJNI.Solver_makeAbsEquality(swigCPtr, this, IntVar.getCPtr(var), var, IntVar.getCPtr(abs_var), abs_var);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This constraint is a special case of the element constraint with<br>
   *  an array of integer variables, where the variables are all<br>
   *  different and the index variable is constrained such that<br>
   *  vars[index] == target.
   */
  public Constraint makeIndexOfConstraint(IntVar[] vars, IntVar index, long target) {
    long cPtr = mainJNI.Solver_makeIndexOfConstraint(swigCPtr, this, vars, IntVar.getCPtr(index), index, target);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This method is a specialized case of the MakeConstraintDemon<br>
   *  method to call the InitiatePropagate of the constraint 'ct'.
   */
  public Demon makeConstraintInitialPropagateCallback(Constraint ct) {
    long cPtr = mainJNI.Solver_makeConstraintInitialPropagateCallback(swigCPtr, this, Constraint.getCPtr(ct), ct);
    return (cPtr == 0) ? null : new Demon(cPtr, false);
  }

  /**
   *  This method is a specialized case of the MakeConstraintDemon<br>
   *  method to call the InitiatePropagate of the constraint 'ct' with<br>
   *  low priority.
   */
  public Demon makeDelayedConstraintInitialPropagateCallback(Constraint ct) {
    long cPtr = mainJNI.Solver_makeDelayedConstraintInitialPropagateCallback(swigCPtr, this, Constraint.getCPtr(ct), ct);
    return (cPtr == 0) ? null : new Demon(cPtr, false);
  }

  /**
   *  Creates a demon from a closure.
   */
  public Demon makeClosureDemon(Runnable closure) {
    long cPtr = mainJNI.Solver_makeClosureDemon(swigCPtr, this, closure);
    return (cPtr == 0) ? null : new Demon(cPtr, false);
  }

  /**
   *  (l &lt;= expr &lt;= u)
   */
  public Constraint makeBetweenCt(IntExpr expr, long l, long u) {
    long cPtr = mainJNI.Solver_makeBetweenCt(swigCPtr, this, IntExpr.getCPtr(expr), expr, l, u);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  (expr &lt; l || expr &gt; u)<br>
   *  This constraint is lazy as it will not make holes in the domain of<br>
   *  variables. It will propagate only when expr-&gt;Min() &gt;= l<br>
   *  or expr-&gt;Max() &lt;= u.
   */
  public Constraint makeNotBetweenCt(IntExpr expr, long l, long u) {
    long cPtr = mainJNI.Solver_makeNotBetweenCt(swigCPtr, this, IntExpr.getCPtr(expr), expr, l, u);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  b == (l &lt;= expr &lt;= u)
   */
  public Constraint makeIsBetweenCt(IntExpr expr, long l, long u, IntVar b) {
    long cPtr = mainJNI.Solver_makeIsBetweenCt(swigCPtr, this, IntExpr.getCPtr(expr), expr, l, u, IntVar.getCPtr(b), b);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public IntVar makeIsBetweenVar(IntExpr v, long l, long u) {
    long cPtr = mainJNI.Solver_makeIsBetweenVar(swigCPtr, this, IntExpr.getCPtr(v), v, l, u);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  expr in set. Propagation is lazy, i.e. this constraint does not<br>
   *  creates holes in the domain of the variable.
   */
  public Constraint makeMemberCt(IntExpr expr, long[] values) {
    long cPtr = mainJNI.Solver_makeMemberCt__SWIG_0(swigCPtr, this, IntExpr.getCPtr(expr), expr, values);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeMemberCt(IntExpr expr, int[] values) {
    long cPtr = mainJNI.Solver_makeMemberCt__SWIG_1(swigCPtr, this, IntExpr.getCPtr(expr), expr, values);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  expr not in set.
   */
  public Constraint makeNotMemberCt(IntExpr expr, long[] values) {
    long cPtr = mainJNI.Solver_makeNotMemberCt__SWIG_0(swigCPtr, this, IntExpr.getCPtr(expr), expr, values);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeNotMemberCt(IntExpr expr, int[] values) {
    long cPtr = mainJNI.Solver_makeNotMemberCt__SWIG_1(swigCPtr, this, IntExpr.getCPtr(expr), expr, values);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  expr should not be in the list of forbidden intervals [start[i]..end[i]].
   */
  public Constraint makeNotMemberCt(IntExpr expr, long[] starts, long[] ends) {
    long cPtr = mainJNI.Solver_makeNotMemberCt__SWIG_2(swigCPtr, this, IntExpr.getCPtr(expr), expr, starts, ends);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  expr should not be in the list of forbidden intervals [start[i]..end[i]].
   */
  public Constraint makeNotMemberCt(IntExpr expr, int[] starts, int[] ends) {
    long cPtr = mainJNI.Solver_makeNotMemberCt__SWIG_3(swigCPtr, this, IntExpr.getCPtr(expr), expr, starts, ends);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  boolvar == (expr in set)
   */
  public Constraint makeIsMemberCt(IntExpr expr, long[] values, IntVar boolvar) {
    long cPtr = mainJNI.Solver_makeIsMemberCt__SWIG_0(swigCPtr, this, IntExpr.getCPtr(expr), expr, values, IntVar.getCPtr(boolvar), boolvar);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeIsMemberCt(IntExpr expr, int[] values, IntVar boolvar) {
    long cPtr = mainJNI.Solver_makeIsMemberCt__SWIG_1(swigCPtr, this, IntExpr.getCPtr(expr), expr, values, IntVar.getCPtr(boolvar), boolvar);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public IntVar makeIsMemberVar(IntExpr expr, long[] values) {
    long cPtr = mainJNI.Solver_makeIsMemberVar__SWIG_0(swigCPtr, this, IntExpr.getCPtr(expr), expr, values);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  public IntVar makeIsMemberVar(IntExpr expr, int[] values) {
    long cPtr = mainJNI.Solver_makeIsMemberVar__SWIG_1(swigCPtr, this, IntExpr.getCPtr(expr), expr, values);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  |{i | vars[i] == value}| == max_count
   */
  public Constraint makeCount(IntVar[] vars, long value, long max_count) {
    long cPtr = mainJNI.Solver_makeCount__SWIG_0(swigCPtr, this, vars, value, max_count);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  |{i | vars[i] == value}| == max_count
   */
  public Constraint makeCount(IntVar[] vars, long value, IntVar max_count) {
    long cPtr = mainJNI.Solver_makeCount__SWIG_1(swigCPtr, this, vars, value, IntVar.getCPtr(max_count), max_count);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Aggregated version of count:  |{i | v[i] == values[j]}| == cards[j]
   */
  public Constraint makeDistribute(IntVar[] vars, long[] values, IntVar[] cards) {
    long cPtr = mainJNI.Solver_makeDistribute__SWIG_0(swigCPtr, this, vars, values, cards);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Aggregated version of count:  |{i | v[i] == values[j]}| == cards[j]
   */
  public Constraint makeDistribute(IntVar[] vars, int[] values, IntVar[] cards) {
    long cPtr = mainJNI.Solver_makeDistribute__SWIG_1(swigCPtr, this, vars, values, cards);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Aggregated version of count:  |{i | v[i] == j}| == cards[j]
   */
  public Constraint makeDistribute(IntVar[] vars, IntVar[] cards) {
    long cPtr = mainJNI.Solver_makeDistribute__SWIG_2(swigCPtr, this, vars, cards);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Aggregated version of count with bounded cardinalities:<br>
   *  forall j in 0 .. card_size - 1: card_min &lt;= |{i | v[i] == j}| &lt;= card_max
   */
  public Constraint makeDistribute(IntVar[] vars, long card_min, long card_max, long card_size) {
    long cPtr = mainJNI.Solver_makeDistribute__SWIG_3(swigCPtr, this, vars, card_min, card_max, card_size);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Aggregated version of count with bounded cardinalities:<br>
   *  forall j in 0 .. card_size - 1:<br>
   *     card_min[j] &lt;= |{i | v[i] == j}| &lt;= card_max[j]
   */
  public Constraint makeDistribute(IntVar[] vars, long[] card_min, long[] card_max) {
    long cPtr = mainJNI.Solver_makeDistribute__SWIG_4(swigCPtr, this, vars, card_min, card_max);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Aggregated version of count with bounded cardinalities:<br>
   *  forall j in 0 .. card_size - 1:<br>
   *     card_min[j] &lt;= |{i | v[i] == j}| &lt;= card_max[j]
   */
  public Constraint makeDistribute(IntVar[] vars, int[] card_min, int[] card_max) {
    long cPtr = mainJNI.Solver_makeDistribute__SWIG_5(swigCPtr, this, vars, card_min, card_max);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Aggregated version of count with bounded cardinalities:<br>
   *  forall j in 0 .. card_size - 1:<br>
   *     card_min[j] &lt;= |{i | v[i] == values[j]}| &lt;= card_max[j]
   */
  public Constraint makeDistribute(IntVar[] vars, long[] values, long[] card_min, long[] card_max) {
    long cPtr = mainJNI.Solver_makeDistribute__SWIG_6(swigCPtr, this, vars, values, card_min, card_max);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Aggregated version of count with bounded cardinalities:<br>
   *  forall j in 0 .. card_size - 1:<br>
   *     card_min[j] &lt;= |{i | v[i] == values[j]}| &lt;= card_max[j]
   */
  public Constraint makeDistribute(IntVar[] vars, int[] values, int[] card_min, int[] card_max) {
    long cPtr = mainJNI.Solver_makeDistribute__SWIG_7(swigCPtr, this, vars, values, card_min, card_max);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Deviation constraint:<br>
   *  sum_i |n * vars[i] - total_sum| &lt;= deviation_var and<br>
   *  sum_i vars[i] == total_sum<br>
   *  n = #vars
   */
  public Constraint makeDeviation(IntVar[] vars, IntVar deviation_var, long total_sum) {
    long cPtr = mainJNI.Solver_makeDeviation(swigCPtr, this, vars, IntVar.getCPtr(deviation_var), deviation_var, total_sum);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  All variables are pairwise different. This corresponds to the<br>
   *  stronger version of the propagation algorithm.
   */
  public Constraint makeAllDifferent(IntVar[] vars) {
    long cPtr = mainJNI.Solver_makeAllDifferent__SWIG_0(swigCPtr, this, vars);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  All variables are pairwise different.  If 'stronger_propagation'<br>
   *  is true, stronger, and potentially slower propagation will<br>
   *  occur. This API will be deprecated in the future.
   */
  public Constraint makeAllDifferent(IntVar[] vars, boolean stronger_propagation) {
    long cPtr = mainJNI.Solver_makeAllDifferent__SWIG_1(swigCPtr, this, vars, stronger_propagation);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  All variables are pairwise different, unless they are assigned to<br>
   *  the escape value.
   */
  public Constraint makeAllDifferentExcept(IntVar[] vars, long escape_value) {
    long cPtr = mainJNI.Solver_makeAllDifferentExcept(swigCPtr, this, vars, escape_value);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Creates a constraint binding the arrays of variables "vars" and<br>
   *  "sorted_vars": sorted_vars[0] must be equal to the minimum of all<br>
   *  variables in vars, and so on: the value of sorted_vars[i] must be<br>
   *  equal to the i-th value of variables invars.<br>
   * <br>
   *  This constraint propagates in both directions: from "vars" to<br>
   *  "sorted_vars" and vice-versa.<br>
   * <br>
   *  Behind the scenes, this constraint maintains that:<br>
   *    - sorted is always increasing.<br>
   *    - whatever the values of vars, there exists a permutation that<br>
   *      injects its values into the sorted variables.<br>
   * <br>
   *  For more info, please have a look at:<br>
   *    https://mpi-inf.mpg.de/~mehlhorn/ftp/Mehlhorn-Thiel.pdf
   */
  public Constraint makeSortingConstraint(IntVar[] vars, IntVar[] sorted) {
    long cPtr = mainJNI.Solver_makeSortingConstraint(swigCPtr, this, vars, sorted);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Creates a constraint that enforces that left is lexicographically less<br>
   *  than right.
   */
  public Constraint makeLexicalLess(IntVar[] left, IntVar[] right) {
    long cPtr = mainJNI.Solver_makeLexicalLess(swigCPtr, this, left, right);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Creates a constraint that enforces that left is lexicographically less<br>
   *  than or equal to right.
   */
  public Constraint makeLexicalLessOrEqual(IntVar[] left, IntVar[] right) {
    long cPtr = mainJNI.Solver_makeLexicalLessOrEqual(swigCPtr, this, left, right);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Creates a constraint that enforces that 'left' and 'right' both<br>
   *  represent permutations of [0..left.size()-1], and that 'right' is<br>
   *  the inverse permutation of 'left', i.e. for all i in<br>
   *  [0..left.size()-1], right[left[i]] = i.
   */
  public Constraint makeInversePermutationConstraint(IntVar[] left, IntVar[] right) {
    long cPtr = mainJNI.Solver_makeInversePermutationConstraint(swigCPtr, this, left, right);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Creates a constraint that binds the index variable to the index of the<br>
   *  first variable with the maximum value.
   */
  public Constraint makeIndexOfFirstMaxValueConstraint(IntVar index, IntVar[] vars) {
    long cPtr = mainJNI.Solver_makeIndexOfFirstMaxValueConstraint(swigCPtr, this, IntVar.getCPtr(index), index, vars);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Creates a constraint that binds the index variable to the index of the<br>
   *  first variable with the minimum value.
   */
  public Constraint makeIndexOfFirstMinValueConstraint(IntVar index, IntVar[] vars) {
    long cPtr = mainJNI.Solver_makeIndexOfFirstMinValueConstraint(swigCPtr, this, IntVar.getCPtr(index), index, vars);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Creates a constraint that states that all variables in the first<br>
   *  vector are different from all variables in the second<br>
   *  group. Thus the set of values in the first vector does not<br>
   *  intersect with the set of values in the second vector.
   */
  public Constraint makeNullIntersect(IntVar[] first_vars, IntVar[] second_vars) {
    long cPtr = mainJNI.Solver_makeNullIntersect(swigCPtr, this, first_vars, second_vars);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Creates a constraint that states that all variables in the first<br>
   *  vector are different from all variables from the second group,<br>
   *  unless they are assigned to the escape value. Thus the set of<br>
   *  values in the first vector minus the escape value does not<br>
   *  intersect with the set of values in the second vector.
   */
  public Constraint makeNullIntersectExcept(IntVar[] first_vars, IntVar[] second_vars, long escape_value) {
    long cPtr = mainJNI.Solver_makeNullIntersectExcept(swigCPtr, this, first_vars, second_vars, escape_value);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Prevent cycles. The "nexts" variables represent the next in the chain.<br>
   *  "active" variables indicate if the corresponding next variable is active;<br>
   *  this could be useful to model unperformed nodes in a routing problem.<br>
   *  A callback can be added to specify sink values (by default sink values<br>
   *  are values &gt;= vars.size()). Ownership of the callback is passed to the<br>
   *  constraint.<br>
   *  If assume_paths is either not specified or true, the constraint assumes<br>
   *  the "nexts" variables represent paths (and performs a faster propagation);<br>
   *  otherwise the constraint assumes they represent a forest.
   */
  public Constraint makeNoCycle(IntVar[] nexts, IntVar[] active, LongPredicate sink_handler) {
    long cPtr = mainJNI.Solver_makeNoCycle__SWIG_0(swigCPtr, this, nexts, active, sink_handler);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Prevent cycles. The "nexts" variables represent the next in the chain.<br>
   *  "active" variables indicate if the corresponding next variable is active;<br>
   *  this could be useful to model unperformed nodes in a routing problem.<br>
   *  A callback can be added to specify sink values (by default sink values<br>
   *  are values &gt;= vars.size()). Ownership of the callback is passed to the<br>
   *  constraint.<br>
   *  If assume_paths is either not specified or true, the constraint assumes<br>
   *  the "nexts" variables represent paths (and performs a faster propagation);<br>
   *  otherwise the constraint assumes they represent a forest.
   */
  public Constraint makeNoCycle(IntVar[] nexts, IntVar[] active) {
    long cPtr = mainJNI.Solver_makeNoCycle__SWIG_1(swigCPtr, this, nexts, active);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeNoCycle(IntVar[] nexts, IntVar[] active, LongPredicate sink_handler, boolean assume_paths) {
    long cPtr = mainJNI.Solver_makeNoCycle__SWIG_2(swigCPtr, this, nexts, active, sink_handler, assume_paths);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Force the "nexts" variable to create a complete Hamiltonian path.
   */
  public Constraint makeCircuit(IntVar[] nexts) {
    long cPtr = mainJNI.Solver_makeCircuit(swigCPtr, this, nexts);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Force the "nexts" variable to create a complete Hamiltonian path<br>
   *  for those that do not loop upon themselves.
   */
  public Constraint makeSubCircuit(IntVar[] nexts) {
    long cPtr = mainJNI.Solver_makeSubCircuit(swigCPtr, this, nexts);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Creates a constraint which accumulates values along a path such that:<br>
   *  cumuls[next[i]] = cumuls[i] + transits[i].<br>
   *  Active variables indicate if the corresponding next variable is active;<br>
   *  this could be useful to model unperformed nodes in a routing problem.
   */
  public Constraint makePathCumul(IntVar[] nexts, IntVar[] active, IntVar[] cumuls, IntVar[] transits) {
    long cPtr = mainJNI.Solver_makePathCumul__SWIG_0(swigCPtr, this, nexts, active, cumuls, transits);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Delayed version of the same constraint: propagation on the nexts variables<br>
   *  is delayed until all constraints have propagated.
   */
  public Constraint makeDelayedPathCumul(IntVar[] nexts, IntVar[] active, IntVar[] cumuls, IntVar[] transits) {
    long cPtr = mainJNI.Solver_makeDelayedPathCumul(swigCPtr, this, nexts, active, cumuls, transits);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Creates a constraint which accumulates values along a path such that:<br>
   *  cumuls[next[i]] = cumuls[i] + transit_evaluator(i, next[i]).<br>
   *  Active variables indicate if the corresponding next variable is active;<br>
   *  this could be useful to model unperformed nodes in a routing problem.<br>
   *  Ownership of transit_evaluator is taken and it must be a repeatable<br>
   *  callback.
   */
  public Constraint makePathCumul(IntVar[] nexts, IntVar[] active, IntVar[] cumuls, LongBinaryOperator transit_evaluator) {
    long cPtr = mainJNI.Solver_makePathCumul__SWIG_1(swigCPtr, this, nexts, active, cumuls, transit_evaluator);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Creates a constraint which accumulates values along a path such that:<br>
   *  cumuls[next[i]] = cumuls[i] + transit_evaluator(i, next[i]) + slacks[i].<br>
   *  Active variables indicate if the corresponding next variable is active;<br>
   *  this could be useful to model unperformed nodes in a routing problem.<br>
   *  Ownership of transit_evaluator is taken and it must be a repeatable<br>
   *  callback.
   */
  public Constraint makePathCumul(IntVar[] nexts, IntVar[] active, IntVar[] cumuls, IntVar[] slacks, LongBinaryOperator transit_evaluator) {
    long cPtr = mainJNI.Solver_makePathCumul__SWIG_2(swigCPtr, this, nexts, active, cumuls, slacks, transit_evaluator);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  Constraint enforcing that status[i] is true iff there's a path defined on<br>
   *  next variables from sources[i] to sinks[i].<br>
   *  Check whether more propagation is needed.
   */
  public Constraint makePathConnected(IntVar[] nexts, long[] sources, long[] sinks, IntVar[] status) {
    long cPtr = mainJNI.Solver_makePathConnected(swigCPtr, this, nexts, sources, sinks, status);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This constraint maps the domain of 'var' onto the array of<br>
   *  variables 'actives'. That is<br>
   *  for all i in [0 .. size - 1]: actives[i] == 1 &lt;=&gt; var-&gt;Contains(i);
   */
  public Constraint makeMapDomain(IntVar var, IntVar[] actives) {
    long cPtr = mainJNI.Solver_makeMapDomain(swigCPtr, this, IntVar.getCPtr(var), var, actives);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This method creates a constraint where the graph of the relation<br>
   *  between the variables is given in extension. There are 'arity'<br>
   *  variables involved in the relation and the graph is given by a<br>
   *  integer tuple set.
   */
  public Constraint makeAllowedAssignment(IntVar[] vars, IntTupleSet tuples) {
    long cPtr = mainJNI.Solver_makeAllowedAssignment(swigCPtr, this, vars, IntTupleSet.getCPtr(tuples), tuples);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This constraint create a finite automaton that will check the<br>
   *  sequence of variables vars. It uses a transition table called<br>
   *  'transition_table'. Each transition is a triple<br>
   *     (current_state, variable_value, new_state).<br>
   *  The initial state is given, and the set of accepted states is decribed<br>
   *  by 'final_states'. These states are hidden inside the constraint.<br>
   *  Only the transitions (i.e. the variables) are visible.
   */
  public Constraint makeTransitionConstraint(IntVar[] vars, IntTupleSet transition_table, long initial_state, long[] final_states) {
    long cPtr = mainJNI.Solver_makeTransitionConstraint__SWIG_0(swigCPtr, this, vars, IntTupleSet.getCPtr(transition_table), transition_table, initial_state, final_states);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This constraint create a finite automaton that will check the<br>
   *  sequence of variables vars. It uses a transition table called<br>
   *  'transition_table'. Each transition is a triple<br>
   *     (current_state, variable_value, new_state).<br>
   *  The initial state is given, and the set of accepted states is decribed<br>
   *  by 'final_states'. These states are hidden inside the constraint.<br>
   *  Only the transitions (i.e. the variables) are visible.
   */
  public Constraint makeTransitionConstraint(IntVar[] vars, IntTupleSet transition_table, long initial_state, int[] final_states) {
    long cPtr = mainJNI.Solver_makeTransitionConstraint__SWIG_1(swigCPtr, this, vars, IntTupleSet.getCPtr(transition_table), transition_table, initial_state, final_states);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This constraint states that all the boxes must not overlap.<br>
   *  The coordinates of box i are:<br>
   *    (x_vars[i], y_vars[i]),<br>
   *    (x_vars[i], y_vars[i] + y_size[i]),<br>
   *    (x_vars[i] + x_size[i], y_vars[i]),<br>
   *    (x_vars[i] + x_size[i], y_vars[i] + y_size[i]).<br>
   *  The sizes must be non-negative. Boxes with a zero dimension can be<br>
   *  pushed like any box.
   */
  public Constraint makeNonOverlappingBoxesConstraint(IntVar[] x_vars, IntVar[] y_vars, IntVar[] x_size, IntVar[] y_size) {
    long cPtr = mainJNI.Solver_makeNonOverlappingBoxesConstraint__SWIG_0(swigCPtr, this, x_vars, y_vars, x_size, y_size);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeNonOverlappingBoxesConstraint(IntVar[] x_vars, IntVar[] y_vars, long[] x_size, long[] y_size) {
    long cPtr = mainJNI.Solver_makeNonOverlappingBoxesConstraint__SWIG_1(swigCPtr, this, x_vars, y_vars, x_size, y_size);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeNonOverlappingBoxesConstraint(IntVar[] x_vars, IntVar[] y_vars, int[] x_size, int[] y_size) {
    long cPtr = mainJNI.Solver_makeNonOverlappingBoxesConstraint__SWIG_2(swigCPtr, this, x_vars, y_vars, x_size, y_size);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This constraint states that all the boxes must not overlap.<br>
   *  The coordinates of box i are:<br>
   *    (x_vars[i], y_vars[i]),<br>
   *    (x_vars[i], y_vars[i] + y_size[i]),<br>
   *    (x_vars[i] + x_size[i], y_vars[i]),<br>
   *    (x_vars[i] + x_size[i], y_vars[i] + y_size[i]).<br>
   *  The sizes must be positive.<br>
   *  Boxes with a zero dimension can be placed anywhere.
   */
  public Constraint makeNonOverlappingNonStrictBoxesConstraint(IntVar[] x_vars, IntVar[] y_vars, IntVar[] x_size, IntVar[] y_size) {
    long cPtr = mainJNI.Solver_makeNonOverlappingNonStrictBoxesConstraint__SWIG_0(swigCPtr, this, x_vars, y_vars, x_size, y_size);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeNonOverlappingNonStrictBoxesConstraint(IntVar[] x_vars, IntVar[] y_vars, long[] x_size, long[] y_size) {
    long cPtr = mainJNI.Solver_makeNonOverlappingNonStrictBoxesConstraint__SWIG_1(swigCPtr, this, x_vars, y_vars, x_size, y_size);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  public Constraint makeNonOverlappingNonStrictBoxesConstraint(IntVar[] x_vars, IntVar[] y_vars, int[] x_size, int[] y_size) {
    long cPtr = mainJNI.Solver_makeNonOverlappingNonStrictBoxesConstraint__SWIG_2(swigCPtr, this, x_vars, y_vars, x_size, y_size);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This constraint packs all variables onto 'number_of_bins'<br>
   *  variables.  For any given variable, a value of 'number_of_bins'<br>
   *  indicates that the variable is not assigned to any bin.<br>
   *  Dimensions, i.e., cumulative constraints on this packing, can be<br>
   *  added directly from the pack class.
   */
  public Pack makePack(IntVar[] vars, int number_of_bins) {
    long cPtr = mainJNI.Solver_makePack(swigCPtr, this, vars, number_of_bins);
    return (cPtr == 0) ? null : new Pack(cPtr, false);
  }

  /**
   *  Creates an interval var with a fixed duration. The duration must<br>
   *  be greater than 0. If optional is true, then the interval can be<br>
   *  performed or unperformed. If optional is false, then the interval<br>
   *  is always performed.
   */
  public IntervalVar makeFixedDurationIntervalVar(long start_min, long start_max, long duration, boolean optional, String name) {
    long cPtr = mainJNI.Solver_makeFixedDurationIntervalVar__SWIG_0(swigCPtr, this, start_min, start_max, duration, optional, name);
    return (cPtr == 0) ? null : new IntervalVar(cPtr, false);
  }

  /**
   *  Creates a performed interval var with a fixed duration. The duration must<br>
   *  be greater than 0.
   */
  public IntervalVar makeFixedDurationIntervalVar(IntVar start_variable, long duration, String name) {
    long cPtr = mainJNI.Solver_makeFixedDurationIntervalVar__SWIG_1(swigCPtr, this, IntVar.getCPtr(start_variable), start_variable, duration, name);
    return (cPtr == 0) ? null : new IntervalVar(cPtr, false);
  }

  /**
   *  Creates an interval var with a fixed duration, and performed_variable.<br>
   *  The duration must be greater than 0.
   */
  public IntervalVar makeFixedDurationIntervalVar(IntVar start_variable, long duration, IntVar performed_variable, String name) {
    long cPtr = mainJNI.Solver_makeFixedDurationIntervalVar__SWIG_2(swigCPtr, this, IntVar.getCPtr(start_variable), start_variable, duration, IntVar.getCPtr(performed_variable), performed_variable, name);
    return (cPtr == 0) ? null : new IntervalVar(cPtr, false);
  }

  /**
   *  Creates a fixed and performed interval.
   */
  public IntervalVar makeFixedInterval(long start, long duration, String name) {
    long cPtr = mainJNI.Solver_makeFixedInterval(swigCPtr, this, start, duration, name);
    return (cPtr == 0) ? null : new IntervalVar(cPtr, false);
  }

  /**
   *  Creates an interval var by specifying the bounds on start,<br>
   *  duration, and end.
   */
  public IntervalVar makeIntervalVar(long start_min, long start_max, long duration_min, long duration_max, long end_min, long end_max, boolean optional, String name) {
    long cPtr = mainJNI.Solver_makeIntervalVar(swigCPtr, this, start_min, start_max, duration_min, duration_max, end_min, end_max, optional, name);
    return (cPtr == 0) ? null : new IntervalVar(cPtr, false);
  }

  /**
   *  Creates an interval var that is the mirror image of the given one, that<br>
   *  is, the interval var obtained by reversing the axis.
   */
  public IntervalVar makeMirrorInterval(IntervalVar interval_var) {
    long cPtr = mainJNI.Solver_makeMirrorInterval(swigCPtr, this, IntervalVar.getCPtr(interval_var), interval_var);
    return (cPtr == 0) ? null : new IntervalVar(cPtr, false);
  }

  /**
   *  Creates an interval var with a fixed duration whose start is<br>
   *  synchronized with the start of another interval, with a given<br>
   *  offset. The performed status is also in sync with the performed<br>
   *  status of the given interval variable.
   */
  public IntervalVar makeFixedDurationStartSyncedOnStartIntervalVar(IntervalVar interval_var, long duration, long offset) {
    long cPtr = mainJNI.Solver_makeFixedDurationStartSyncedOnStartIntervalVar(swigCPtr, this, IntervalVar.getCPtr(interval_var), interval_var, duration, offset);
    return (cPtr == 0) ? null : new IntervalVar(cPtr, false);
  }

  /**
   *  Creates an interval var with a fixed duration whose start is<br>
   *  synchronized with the end of another interval, with a given<br>
   *  offset. The performed status is also in sync with the performed<br>
   *  status of the given interval variable.
   */
  public IntervalVar makeFixedDurationStartSyncedOnEndIntervalVar(IntervalVar interval_var, long duration, long offset) {
    long cPtr = mainJNI.Solver_makeFixedDurationStartSyncedOnEndIntervalVar(swigCPtr, this, IntervalVar.getCPtr(interval_var), interval_var, duration, offset);
    return (cPtr == 0) ? null : new IntervalVar(cPtr, false);
  }

  /**
   *  Creates an interval var with a fixed duration whose end is<br>
   *  synchronized with the start of another interval, with a given<br>
   *  offset. The performed status is also in sync with the performed<br>
   *  status of the given interval variable.
   */
  public IntervalVar makeFixedDurationEndSyncedOnStartIntervalVar(IntervalVar interval_var, long duration, long offset) {
    long cPtr = mainJNI.Solver_makeFixedDurationEndSyncedOnStartIntervalVar(swigCPtr, this, IntervalVar.getCPtr(interval_var), interval_var, duration, offset);
    return (cPtr == 0) ? null : new IntervalVar(cPtr, false);
  }

  /**
   *  Creates an interval var with a fixed duration whose end is<br>
   *  synchronized with the end of another interval, with a given<br>
   *  offset. The performed status is also in sync with the performed<br>
   *  status of the given interval variable.
   */
  public IntervalVar makeFixedDurationEndSyncedOnEndIntervalVar(IntervalVar interval_var, long duration, long offset) {
    long cPtr = mainJNI.Solver_makeFixedDurationEndSyncedOnEndIntervalVar(swigCPtr, this, IntervalVar.getCPtr(interval_var), interval_var, duration, offset);
    return (cPtr == 0) ? null : new IntervalVar(cPtr, false);
  }

  /**
   *  Creates and returns an interval variable that wraps around the given one,<br>
   *  relaxing the min start and end. Relaxing means making unbounded when<br>
   *  optional. If the variable is non-optional, this method returns<br>
   *  interval_var.<br>
   * <br>
   *  More precisely, such an interval variable behaves as follows:<br>
   * When the underlying must be performed, the returned interval variable<br>
   *      behaves exactly as the underlying;<br>
   * When the underlying may or may not be performed, the returned interval<br>
   *      variable behaves like the underlying, except that it is unbounded on<br>
   *      the min side;<br>
   * When the underlying cannot be performed, the returned interval variable<br>
   *      is of duration 0 and must be performed in an interval unbounded on<br>
   *      both sides.<br>
   * <br>
   *  This is very useful to implement propagators that may only modify<br>
   *  the start max or end max.
   */
  public IntervalVar makeIntervalRelaxedMin(IntervalVar interval_var) {
    long cPtr = mainJNI.Solver_makeIntervalRelaxedMin(swigCPtr, this, IntervalVar.getCPtr(interval_var), interval_var);
    return (cPtr == 0) ? null : new IntervalVar(cPtr, false);
  }

  /**
   *  Creates and returns an interval variable that wraps around the given one,<br>
   *  relaxing the max start and end. Relaxing means making unbounded when<br>
   *  optional. If the variable is non optional, this method returns<br>
   *  interval_var.<br>
   * <br>
   *  More precisely, such an interval variable behaves as follows:<br>
   * When the underlying must be performed, the returned interval variable<br>
   *      behaves exactly as the underlying;<br>
   * When the underlying may or may not be performed, the returned interval<br>
   *      variable behaves like the underlying, except that it is unbounded on<br>
   *      the max side;<br>
   * When the underlying cannot be performed, the returned interval variable<br>
   *      is of duration 0 and must be performed in an interval unbounded on<br>
   *      both sides.<br>
   * <br>
   *  This is very useful for implementing propagators that may only modify<br>
   *  the start min or end min.
   */
  public IntervalVar makeIntervalRelaxedMax(IntervalVar interval_var) {
    long cPtr = mainJNI.Solver_makeIntervalRelaxedMax(swigCPtr, this, IntervalVar.getCPtr(interval_var), interval_var);
    return (cPtr == 0) ? null : new IntervalVar(cPtr, false);
  }

  /**
   *  This method creates a relation between an interval var and a<br>
   *  date.
   */
  public Constraint makeIntervalVarRelation(IntervalVar t, int r, long d) {
    long cPtr = mainJNI.Solver_makeIntervalVarRelation__SWIG_0(swigCPtr, this, IntervalVar.getCPtr(t), t, r, d);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This method creates a relation between two interval vars.
   */
  public Constraint makeIntervalVarRelation(IntervalVar t1, int r, IntervalVar t2) {
    long cPtr = mainJNI.Solver_makeIntervalVarRelation__SWIG_1(swigCPtr, this, IntervalVar.getCPtr(t1), t1, r, IntervalVar.getCPtr(t2), t2);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This method creates a relation between two interval vars.<br>
   *  The given delay is added to the second interval.<br>
   *  i.e.: t1 STARTS_AFTER_END of t2 with a delay of 2<br>
   *  means t1 will start at least two units of time after the end of t2.
   */
  public Constraint makeIntervalVarRelationWithDelay(IntervalVar t1, int r, IntervalVar t2, long delay) {
    long cPtr = mainJNI.Solver_makeIntervalVarRelationWithDelay(swigCPtr, this, IntervalVar.getCPtr(t1), t1, r, IntervalVar.getCPtr(t2), t2, delay);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This constraint implements a temporal disjunction between two<br>
   *  interval vars t1 and t2. 'alt' indicates which alternative was<br>
   *  chosen (alt == 0 is equivalent to t1 before t2).
   */
  public Constraint makeTemporalDisjunction(IntervalVar t1, IntervalVar t2, IntVar alt) {
    long cPtr = mainJNI.Solver_makeTemporalDisjunction__SWIG_0(swigCPtr, this, IntervalVar.getCPtr(t1), t1, IntervalVar.getCPtr(t2), t2, IntVar.getCPtr(alt), alt);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This constraint implements a temporal disjunction between two<br>
   *  interval vars.
   */
  public Constraint makeTemporalDisjunction(IntervalVar t1, IntervalVar t2) {
    long cPtr = mainJNI.Solver_makeTemporalDisjunction__SWIG_1(swigCPtr, this, IntervalVar.getCPtr(t1), t1, IntervalVar.getCPtr(t2), t2);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This constraint forces all interval vars into an non-overlapping<br>
   *  sequence. Intervals with zero duration can be scheduled anywhere.
   */
  public DisjunctiveConstraint makeDisjunctiveConstraint(IntervalVar[] intervals, String name) {
    long cPtr = mainJNI.Solver_makeDisjunctiveConstraint(swigCPtr, this, intervals, name);
    return (cPtr == 0) ? null : new DisjunctiveConstraint(cPtr, false);
  }

  /**
   *  This constraint forces all interval vars into an non-overlapping<br>
   *  sequence. Intervals with zero durations cannot overlap with over<br>
   *  intervals.
   */
  public DisjunctiveConstraint makeStrictDisjunctiveConstraint(IntervalVar[] intervals, String name) {
    long cPtr = mainJNI.Solver_makeStrictDisjunctiveConstraint(swigCPtr, this, intervals, name);
    return (cPtr == 0) ? null : new DisjunctiveConstraint(cPtr, false);
  }

  /**
   *  This constraint forces that, for any integer t, the sum of the demands<br>
   *  corresponding to an interval containing t does not exceed the given<br>
   *  capacity.<br>
   * <br>
   *  Intervals and demands should be vectors of equal size.<br>
   * <br>
   *  Demands should only contain non-negative values. Zero values are<br>
   *  supported, and the corresponding intervals are filtered out, as they<br>
   *  neither impact nor are impacted by this constraint.
   */
  public Constraint makeCumulative(IntervalVar[] intervals, long[] demands, long capacity, String name) {
    long cPtr = mainJNI.Solver_makeCumulative__SWIG_0(swigCPtr, this, intervals, demands, capacity, name);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This constraint forces that, for any integer t, the sum of the demands<br>
   *  corresponding to an interval containing t does not exceed the given<br>
   *  capacity.<br>
   * <br>
   *  Intervals and demands should be vectors of equal size.<br>
   * <br>
   *  Demands should only contain non-negative values. Zero values are<br>
   *  supported, and the corresponding intervals are filtered out, as they<br>
   *  neither impact nor are impacted by this constraint.
   */
  public Constraint makeCumulative(IntervalVar[] intervals, int[] demands, long capacity, String name) {
    long cPtr = mainJNI.Solver_makeCumulative__SWIG_1(swigCPtr, this, intervals, demands, capacity, name);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This constraint forces that, for any integer t, the sum of the demands<br>
   *  corresponding to an interval containing t does not exceed the given<br>
   *  capacity.<br>
   * <br>
   *  Intervals and demands should be vectors of equal size.<br>
   * <br>
   *  Demands should only contain non-negative values. Zero values are<br>
   *  supported, and the corresponding intervals are filtered out, as they<br>
   *  neither impact nor are impacted by this constraint.
   */
  public Constraint makeCumulative(IntervalVar[] intervals, long[] demands, IntVar capacity, String name) {
    long cPtr = mainJNI.Solver_makeCumulative__SWIG_2(swigCPtr, this, intervals, demands, IntVar.getCPtr(capacity), capacity, name);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This constraint enforces that, for any integer t, the sum of the demands<br>
   *  corresponding to an interval containing t does not exceed the given<br>
   *  capacity.<br>
   * <br>
   *  Intervals and demands should be vectors of equal size.<br>
   * <br>
   *  Demands should only contain non-negative values. Zero values are<br>
   *  supported, and the corresponding intervals are filtered out, as they<br>
   *  neither impact nor are impacted by this constraint.
   */
  public Constraint makeCumulative(IntervalVar[] intervals, int[] demands, IntVar capacity, String name) {
    long cPtr = mainJNI.Solver_makeCumulative__SWIG_3(swigCPtr, this, intervals, demands, IntVar.getCPtr(capacity), capacity, name);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This constraint enforces that, for any integer t, the sum of demands<br>
   *  corresponding to an interval containing t does not exceed the given<br>
   *  capacity.<br>
   * <br>
   *  Intervals and demands should be vectors of equal size.<br>
   * <br>
   *  Demands should be positive.
   */
  public Constraint makeCumulative(IntervalVar[] intervals, IntVar[] demands, long capacity, String name) {
    long cPtr = mainJNI.Solver_makeCumulative__SWIG_4(swigCPtr, this, intervals, demands, capacity, name);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This constraint enforces that, for any integer t, the sum of demands<br>
   *  corresponding to an interval containing t does not exceed the given<br>
   *  capacity.<br>
   * <br>
   *  Intervals and demands should be vectors of equal size.<br>
   * <br>
   *  Demands should be positive.
   */
  public Constraint makeCumulative(IntervalVar[] intervals, IntVar[] demands, IntVar capacity, String name) {
    long cPtr = mainJNI.Solver_makeCumulative__SWIG_5(swigCPtr, this, intervals, demands, IntVar.getCPtr(capacity), capacity, name);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This constraint states that the target_var is the convex hull of<br>
   *  the intervals. If none of the interval variables is performed,<br>
   *  then the target var is unperformed too. Also, if the target<br>
   *  variable is unperformed, then all the intervals variables are<br>
   *  unperformed too.
   */
  public Constraint makeCover(IntervalVar[] vars, IntervalVar target_var) {
    long cPtr = mainJNI.Solver_makeCover(swigCPtr, this, vars, IntervalVar.getCPtr(target_var), target_var);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This constraints states that the two interval variables are equal.
   */
  public Constraint makeEquality(IntervalVar var1, IntervalVar var2) {
    long cPtr = mainJNI.Solver_makeEquality__SWIG_3(swigCPtr, this, IntervalVar.getCPtr(var1), var1, IntervalVar.getCPtr(var2), var2);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  /**
   *  This method creates an empty assignment.
   */
  public Assignment makeAssignment() {
    long cPtr = mainJNI.Solver_makeAssignment__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new Assignment(cPtr, false);
  }

  /**
   *  This method creates an assignment which is a copy of 'a'.
   */
  public Assignment makeAssignment(Assignment a) {
    long cPtr = mainJNI.Solver_makeAssignment__SWIG_1(swigCPtr, this, Assignment.getCPtr(a), a);
    return (cPtr == 0) ? null : new Assignment(cPtr, false);
  }

  /**
   *  Collect the first solution of the search.
   */
  public SolutionCollector makeFirstSolutionCollector(Assignment assignment) {
    long cPtr = mainJNI.Solver_makeFirstSolutionCollector__SWIG_0(swigCPtr, this, Assignment.getCPtr(assignment), assignment);
    return (cPtr == 0) ? null : new SolutionCollector(cPtr, false);
  }

  /**
   *  Collect the first solution of the search. The variables will need to<br>
   *  be added later.
   */
  public SolutionCollector makeFirstSolutionCollector() {
    long cPtr = mainJNI.Solver_makeFirstSolutionCollector__SWIG_1(swigCPtr, this);
    return (cPtr == 0) ? null : new SolutionCollector(cPtr, false);
  }

  /**
   *  Collect the last solution of the search.
   */
  public SolutionCollector makeLastSolutionCollector(Assignment assignment) {
    long cPtr = mainJNI.Solver_makeLastSolutionCollector__SWIG_0(swigCPtr, this, Assignment.getCPtr(assignment), assignment);
    return (cPtr == 0) ? null : new SolutionCollector(cPtr, false);
  }

  /**
   *  Collect the last solution of the search. The variables will need to<br>
   *  be added later.
   */
  public SolutionCollector makeLastSolutionCollector() {
    long cPtr = mainJNI.Solver_makeLastSolutionCollector__SWIG_1(swigCPtr, this);
    return (cPtr == 0) ? null : new SolutionCollector(cPtr, false);
  }

  /**
   *  Collect the solution corresponding to the optimal value of the objective<br>
   *  of 'assignment'; if 'assignment' does not have an objective no solution is<br>
   *  collected. This collector only collects one solution corresponding to the<br>
   *  best objective value (the first one found).
   */
  public SolutionCollector makeBestValueSolutionCollector(Assignment assignment, boolean maximize) {
    long cPtr = mainJNI.Solver_makeBestValueSolutionCollector__SWIG_0(swigCPtr, this, Assignment.getCPtr(assignment), assignment, maximize);
    return (cPtr == 0) ? null : new SolutionCollector(cPtr, false);
  }

  /**
   *  Collect the solution corresponding to the optimal value of the<br>
   *  objective of 'assignment'; if 'assignment' does not have an objective no<br>
   *  solution is collected. This collector only collects one solution<br>
   *  corresponding to the best objective value (the first one<br>
   *  found). The variables will need to be added later.
   */
  public SolutionCollector makeBestValueSolutionCollector(boolean maximize) {
    long cPtr = mainJNI.Solver_makeBestValueSolutionCollector__SWIG_1(swigCPtr, this, maximize);
    return (cPtr == 0) ? null : new SolutionCollector(cPtr, false);
  }

  /**
   *  Same as MakeBestValueSolutionCollector but collects the best<br>
   *  solution_count solutions. Collected solutions are sorted in increasing<br>
   *  optimality order (the best solution is the last one).
   */
  public SolutionCollector makeNBestValueSolutionCollector(Assignment assignment, int solution_count, boolean maximize) {
    long cPtr = mainJNI.Solver_makeNBestValueSolutionCollector__SWIG_0(swigCPtr, this, Assignment.getCPtr(assignment), assignment, solution_count, maximize);
    return (cPtr == 0) ? null : new SolutionCollector(cPtr, false);
  }

  public SolutionCollector makeNBestValueSolutionCollector(int solution_count, boolean maximize) {
    long cPtr = mainJNI.Solver_makeNBestValueSolutionCollector__SWIG_1(swigCPtr, this, solution_count, maximize);
    return (cPtr == 0) ? null : new SolutionCollector(cPtr, false);
  }

  /**
   *  Collect all solutions of the search.
   */
  public SolutionCollector makeAllSolutionCollector(Assignment assignment) {
    long cPtr = mainJNI.Solver_makeAllSolutionCollector__SWIG_0(swigCPtr, this, Assignment.getCPtr(assignment), assignment);
    return (cPtr == 0) ? null : new SolutionCollector(cPtr, false);
  }

  /**
   *  Collect all solutions of the search. The variables will need to<br>
   *  be added later.
   */
  public SolutionCollector makeAllSolutionCollector() {
    long cPtr = mainJNI.Solver_makeAllSolutionCollector__SWIG_1(swigCPtr, this);
    return (cPtr == 0) ? null : new SolutionCollector(cPtr, false);
  }

  /**
   *  Creates a minimization objective.
   */
  public OptimizeVar makeMinimize(IntVar v, long step) {
    long cPtr = mainJNI.Solver_makeMinimize(swigCPtr, this, IntVar.getCPtr(v), v, step);
    return (cPtr == 0) ? null : new OptimizeVar(cPtr, false);
  }

  /**
   *  Creates a maximization objective.
   */
  public OptimizeVar makeMaximize(IntVar v, long step) {
    long cPtr = mainJNI.Solver_makeMaximize(swigCPtr, this, IntVar.getCPtr(v), v, step);
    return (cPtr == 0) ? null : new OptimizeVar(cPtr, false);
  }

  /**
   *  Creates a objective with a given sense (true = maximization).
   */
  public OptimizeVar makeOptimize(boolean maximize, IntVar v, long step) {
    long cPtr = mainJNI.Solver_makeOptimize(swigCPtr, this, maximize, IntVar.getCPtr(v), v, step);
    return (cPtr == 0) ? null : new OptimizeVar(cPtr, false);
  }

  /**
   *  Creates a minimization weighted objective. The actual objective is<br>
   *  scalar_prod(sub_objectives, weights).
   */
  public OptimizeVar makeWeightedMinimize(IntVar[] sub_objectives, long[] weights, long step) {
    long cPtr = mainJNI.Solver_makeWeightedMinimize__SWIG_0(swigCPtr, this, sub_objectives, weights, step);
    return (cPtr == 0) ? null : new OptimizeVar(cPtr, false);
  }

  /**
   *  Creates a minimization weighted objective. The actual objective is<br>
   *  scalar_prod(sub_objectives, weights).
   */
  public OptimizeVar makeWeightedMinimize(IntVar[] sub_objectives, int[] weights, long step) {
    long cPtr = mainJNI.Solver_makeWeightedMinimize__SWIG_1(swigCPtr, this, sub_objectives, weights, step);
    return (cPtr == 0) ? null : new OptimizeVar(cPtr, false);
  }

  /**
   *  Creates a maximization weigthed objective.
   */
  public OptimizeVar makeWeightedMaximize(IntVar[] sub_objectives, long[] weights, long step) {
    long cPtr = mainJNI.Solver_makeWeightedMaximize__SWIG_0(swigCPtr, this, sub_objectives, weights, step);
    return (cPtr == 0) ? null : new OptimizeVar(cPtr, false);
  }

  /**
   *  Creates a maximization weigthed objective.
   */
  public OptimizeVar makeWeightedMaximize(IntVar[] sub_objectives, int[] weights, long step) {
    long cPtr = mainJNI.Solver_makeWeightedMaximize__SWIG_1(swigCPtr, this, sub_objectives, weights, step);
    return (cPtr == 0) ? null : new OptimizeVar(cPtr, false);
  }

  /**
   *  Creates a weighted objective with a given sense (true = maximization).
   */
  public OptimizeVar makeWeightedOptimize(boolean maximize, IntVar[] sub_objectives, long[] weights, long step) {
    long cPtr = mainJNI.Solver_makeWeightedOptimize__SWIG_0(swigCPtr, this, maximize, sub_objectives, weights, step);
    return (cPtr == 0) ? null : new OptimizeVar(cPtr, false);
  }

  /**
   *  Creates a weighted objective with a given sense (true = maximization).
   */
  public OptimizeVar makeWeightedOptimize(boolean maximize, IntVar[] sub_objectives, int[] weights, long step) {
    long cPtr = mainJNI.Solver_makeWeightedOptimize__SWIG_1(swigCPtr, this, maximize, sub_objectives, weights, step);
    return (cPtr == 0) ? null : new OptimizeVar(cPtr, false);
  }

  /**
   *  MetaHeuristics which try to get the search out of local optima.<br>
   *  Creates a Tabu Search monitor.<br>
   *  In the context of local search the behavior is similar to MakeOptimize(),<br>
   *  creating an objective in a given sense. The behavior differs once a local<br>
   *  optimum is reached: thereafter solutions which degrade the value of the<br>
   *  objective are allowed if they are not "tabu". A solution is "tabu" if it<br>
   *  doesn't respect the following rules:<br>
   *  - improving the best solution found so far<br>
   *  - variables in the "keep" list must keep their value, variables in the<br>
   *  "forbid" list must not take the value they have in the list.<br>
   *  Variables with new values enter the tabu lists after each new solution<br>
   *  found and leave the lists after a given number of iterations (called<br>
   *  tenure). Only the variables passed to the method can enter the lists.<br>
   *  The tabu criterion is softened by the tabu factor which gives the number<br>
   *  of "tabu" violations which is tolerated; a factor of 1 means no violations<br>
   *  allowed; a factor of 0 means all violations are allowed.
   */
  public SearchMonitor makeTabuSearch(boolean maximize, IntVar v, long step, IntVar[] vars, long keep_tenure, long forbid_tenure, double tabu_factor) {
    long cPtr = mainJNI.Solver_makeTabuSearch(swigCPtr, this, maximize, IntVar.getCPtr(v), v, step, vars, keep_tenure, forbid_tenure, tabu_factor);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  /**
   *  Creates a Tabu Search based on the vars |vars|.<br>
   *  A solution is "tabu" if all the vars in |vars| keep their value.
   */
  public SearchMonitor makeGenericTabuSearch(boolean maximize, IntVar v, long step, IntVar[] tabu_vars, long forbid_tenure) {
    long cPtr = mainJNI.Solver_makeGenericTabuSearch(swigCPtr, this, maximize, IntVar.getCPtr(v), v, step, tabu_vars, forbid_tenure);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  /**
   *  Creates a Simulated Annealing monitor.
   */
  public SearchMonitor makeSimulatedAnnealing(boolean maximize, IntVar v, long step, long initial_temperature) {
    long cPtr = mainJNI.Solver_makeSimulatedAnnealing(swigCPtr, this, maximize, IntVar.getCPtr(v), v, step, initial_temperature);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  /**
   *  Creates a Guided Local Search monitor.<br>
   *  Description here: http://en.wikipedia.org/wiki/Guided_Local_Search
   */
  public SearchMonitor makeGuidedLocalSearch(boolean maximize, IntVar objective, LongBinaryOperator objective_function, long step, IntVar[] vars, double penalty_factor) {
    long cPtr = mainJNI.Solver_makeGuidedLocalSearch__SWIG_0(swigCPtr, this, maximize, IntVar.getCPtr(objective), objective, objective_function, step, vars, penalty_factor);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  public SearchMonitor makeGuidedLocalSearch(boolean maximize, IntVar objective, LongTernaryOperator objective_function, long step, IntVar[] vars, IntVar[] secondary_vars, double penalty_factor) {
    long cPtr = mainJNI.Solver_makeGuidedLocalSearch__SWIG_1(swigCPtr, this, maximize, IntVar.getCPtr(objective), objective, objective_function, step, vars, secondary_vars, penalty_factor);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  /**
   *  This search monitor will restart the search periodically.<br>
   *  At the iteration n, it will restart after scale_factor * Luby(n) failures<br>
   *  where Luby is the Luby Strategy (i.e. 1 1 2 1 1 2 4 1 1 2 1 1 2 4 8...).
   */
  public SearchMonitor makeLubyRestart(int scale_factor) {
    long cPtr = mainJNI.Solver_makeLubyRestart(swigCPtr, this, scale_factor);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  /**
   *  This search monitor will restart the search periodically after 'frequency'<br>
   *  failures.
   */
  public SearchMonitor makeConstantRestart(int frequency) {
    long cPtr = mainJNI.Solver_makeConstantRestart(swigCPtr, this, frequency);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  /**
   *  Creates a search limit that constrains the running time.
   */
  public RegularLimit makeTimeLimit(SWIGTYPE_p_absl__Duration time) {
    long cPtr = mainJNI.Solver_makeTimeLimit__SWIG_0(swigCPtr, this, SWIGTYPE_p_absl__Duration.getCPtr(time));
    return (cPtr == 0) ? null : new RegularLimit(cPtr, false);
  }

  public RegularLimit makeTimeLimit(long time_in_ms) {
    long cPtr = mainJNI.Solver_makeTimeLimit__SWIG_1(swigCPtr, this, time_in_ms);
    return (cPtr == 0) ? null : new RegularLimit(cPtr, false);
  }

  /**
   *  Creates a search limit that constrains the number of branches<br>
   *  explored in the search tree.
   */
  public RegularLimit makeBranchesLimit(long branches) {
    long cPtr = mainJNI.Solver_makeBranchesLimit(swigCPtr, this, branches);
    return (cPtr == 0) ? null : new RegularLimit(cPtr, false);
  }

  /**
   *  Creates a search limit that constrains the number of failures<br>
   *  that can happen when exploring the search tree.
   */
  public RegularLimit makeFailuresLimit(long failures) {
    long cPtr = mainJNI.Solver_makeFailuresLimit(swigCPtr, this, failures);
    return (cPtr == 0) ? null : new RegularLimit(cPtr, false);
  }

  /**
   *  Creates a search limit that constrains the number of solutions found<br>
   *  during the search.
   */
  public RegularLimit makeSolutionsLimit(long solutions) {
    long cPtr = mainJNI.Solver_makeSolutionsLimit(swigCPtr, this, solutions);
    return (cPtr == 0) ? null : new RegularLimit(cPtr, false);
  }

  /**
   *  Limits the search with the 'time', 'branches', 'failures' and<br>
   *  'solutions' limits. 'smart_time_check' reduces the calls to the wall
   */
  public RegularLimit makeLimit(SWIGTYPE_p_absl__Duration time, long branches, long failures, long solutions, boolean smart_time_check, boolean cumulative) {
    long cPtr = mainJNI.Solver_makeLimit__SWIG_0(swigCPtr, this, SWIGTYPE_p_absl__Duration.getCPtr(time), branches, failures, solutions, smart_time_check, cumulative);
    return (cPtr == 0) ? null : new RegularLimit(cPtr, false);
  }

  /**
   *  Limits the search with the 'time', 'branches', 'failures' and<br>
   *  'solutions' limits. 'smart_time_check' reduces the calls to the wall
   */
  public RegularLimit makeLimit(SWIGTYPE_p_absl__Duration time, long branches, long failures, long solutions, boolean smart_time_check) {
    long cPtr = mainJNI.Solver_makeLimit__SWIG_1(swigCPtr, this, SWIGTYPE_p_absl__Duration.getCPtr(time), branches, failures, solutions, smart_time_check);
    return (cPtr == 0) ? null : new RegularLimit(cPtr, false);
  }

  /**
   *  Limits the search with the 'time', 'branches', 'failures' and<br>
   *  'solutions' limits. 'smart_time_check' reduces the calls to the wall
   */
  public RegularLimit makeLimit(SWIGTYPE_p_absl__Duration time, long branches, long failures, long solutions) {
    long cPtr = mainJNI.Solver_makeLimit__SWIG_2(swigCPtr, this, SWIGTYPE_p_absl__Duration.getCPtr(time), branches, failures, solutions);
    return (cPtr == 0) ? null : new RegularLimit(cPtr, false);
  }

  /**
   *  Creates a search limit from its protobuf description
   */
  public RegularLimit makeLimit(com.google.ortools.constraintsolver.RegularLimitParameters proto) {
    long cPtr = mainJNI.Solver_makeLimit__SWIG_3(swigCPtr, this, proto.toByteArray());
    return (cPtr == 0) ? null : new RegularLimit(cPtr, false);
  }

  public RegularLimit makeLimit(long time, long branches, long failures, long solutions, boolean smart_time_check, boolean cumulative) {
    long cPtr = mainJNI.Solver_makeLimit__SWIG_4(swigCPtr, this, time, branches, failures, solutions, smart_time_check, cumulative);
    return (cPtr == 0) ? null : new RegularLimit(cPtr, false);
  }

  public RegularLimit makeLimit(long time, long branches, long failures, long solutions, boolean smart_time_check) {
    long cPtr = mainJNI.Solver_makeLimit__SWIG_5(swigCPtr, this, time, branches, failures, solutions, smart_time_check);
    return (cPtr == 0) ? null : new RegularLimit(cPtr, false);
  }

  public RegularLimit makeLimit(long time, long branches, long failures, long solutions) {
    long cPtr = mainJNI.Solver_makeLimit__SWIG_6(swigCPtr, this, time, branches, failures, solutions);
    return (cPtr == 0) ? null : new RegularLimit(cPtr, false);
  }

  /**
   *  Creates a regular limit proto containing default values.
   */
  public com.google.ortools.constraintsolver.RegularLimitParameters makeDefaultRegularLimitParameters() {
  byte[] buf = mainJNI.Solver_makeDefaultRegularLimitParameters(swigCPtr, this);
  if (buf == null || buf.length == 0) {
    return null;
  }
  try {
    return com.google.ortools.constraintsolver.RegularLimitParameters.parseFrom(buf);
  } catch (com.google.protobuf.InvalidProtocolBufferException e) {
    throw new RuntimeException(
        "Unable to parse com.google.ortools.constraintsolver.RegularLimitParameters protocol message.");
  }
}

  /**
   *  Creates a search limit that is reached when either of the underlying limit<br>
   *  is reached. That is, the returned limit is more stringent than both<br>
   *  argument limits.
   */
  public SearchLimit makeLimit(SearchLimit limit_1, SearchLimit limit_2) {
    long cPtr = mainJNI.Solver_makeLimit__SWIG_7(swigCPtr, this, SearchLimit.getCPtr(limit_1), limit_1, SearchLimit.getCPtr(limit_2), limit_2);
    return (cPtr == 0) ? null : new SearchLimit(cPtr, false);
  }

  /**
   *  Limits the search based on the improvements of 'objective_var'. Stops the<br>
   *  search when the improvement rate gets lower than a threshold value. This<br>
   *  threshold value is computed based on the improvement rate during the first<br>
   *  phase of the search.
   */
  public ImprovementSearchLimit MakeImprovementLimit(IntVar objective_var, boolean maximize, double objective_scaling_factor, double objective_offset, double improvement_rate_coefficient, int improvement_rate_solutions_distance) {
    long cPtr = mainJNI.Solver_MakeImprovementLimit(swigCPtr, this, IntVar.getCPtr(objective_var), objective_var, maximize, objective_scaling_factor, objective_offset, improvement_rate_coefficient, improvement_rate_solutions_distance);
    return (cPtr == 0) ? null : new ImprovementSearchLimit(cPtr, false);
  }

  /**
   *  Callback-based search limit. Search stops when limiter returns true; if<br>
   *  this happens at a leaf the corresponding solution will be rejected.
   */
  public SearchLimit makeCustomLimit(BooleanSupplier limiter) {
    long cPtr = mainJNI.Solver_makeCustomLimit(swigCPtr, this, limiter);
    return (cPtr == 0) ? null : new SearchLimit(cPtr, false);
  }

  /**
   *  The SearchMonitors below will display a periodic search log<br>
   *  on LOG(INFO) every branch_period branches explored.
   */
  public SearchMonitor makeSearchLog(int branch_period) {
    long cPtr = mainJNI.Solver_makeSearchLog__SWIG_0(swigCPtr, this, branch_period);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  /**
   *  At each solution, this monitor also display the var value.
   */
  public SearchMonitor makeSearchLog(int branch_period, IntVar var) {
    long cPtr = mainJNI.Solver_makeSearchLog__SWIG_1(swigCPtr, this, branch_period, IntVar.getCPtr(var), var);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  /**
   *  At each solution, this monitor will also display result of <br>
   * <code>display_callback</code>.
   */
  public SearchMonitor makeSearchLog(int branch_period, Supplier<String> display_callback) {
    long cPtr = mainJNI.Solver_makeSearchLog__SWIG_2(swigCPtr, this, branch_period, display_callback);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  /**
   *  At each solution, this monitor will display the 'var' value and the<br>
   *  result of <code>display_callback</code>.
   */
  public SearchMonitor makeSearchLog(int branch_period, IntVar var, Supplier<String> display_callback) {
    long cPtr = mainJNI.Solver_makeSearchLog__SWIG_3(swigCPtr, this, branch_period, IntVar.getCPtr(var), var, display_callback);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  /**
   *  OptimizeVar Search Logs<br>
   *  At each solution, this monitor will also display the 'opt_var' value.
   */
  public SearchMonitor makeSearchLog(int branch_period, OptimizeVar opt_var) {
    long cPtr = mainJNI.Solver_makeSearchLog__SWIG_4(swigCPtr, this, branch_period, OptimizeVar.getCPtr(opt_var), opt_var);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  /**
   *  Creates a search monitor that will also print the result of the<br>
   *  display callback.
   */
  public SearchMonitor makeSearchLog(int branch_period, OptimizeVar opt_var, Supplier<String> display_callback) {
    long cPtr = mainJNI.Solver_makeSearchLog__SWIG_5(swigCPtr, this, branch_period, OptimizeVar.getCPtr(opt_var), opt_var, display_callback);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  /**
   *  Creates a search monitor that will trace precisely the behavior of the<br>
   *  search. Use this only for low level debugging.
   */
  public SearchMonitor makeSearchTrace(String prefix) {
    long cPtr = mainJNI.Solver_makeSearchTrace(swigCPtr, this, prefix);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  /**
   *  ----- Callback-based search monitors -----
   */
  public SearchMonitor makeEnterSearchCallback(Runnable callback) {
    long cPtr = mainJNI.Solver_makeEnterSearchCallback(swigCPtr, this, callback);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  public SearchMonitor makeExitSearchCallback(Runnable callback) {
    long cPtr = mainJNI.Solver_makeExitSearchCallback(swigCPtr, this, callback);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  public SearchMonitor makeAtSolutionCallback(Runnable callback) {
    long cPtr = mainJNI.Solver_makeAtSolutionCallback(swigCPtr, this, callback);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  /**
   *  Prints the model.
   */
  public ModelVisitor makePrintModelVisitor() {
    long cPtr = mainJNI.Solver_makePrintModelVisitor(swigCPtr, this);
    return (cPtr == 0) ? null : new ModelVisitor(cPtr, false);
  }

  /**
   *  Displays some nice statistics on the model.
   */
  public ModelVisitor makeStatisticsModelVisitor() {
    long cPtr = mainJNI.Solver_makeStatisticsModelVisitor(swigCPtr, this);
    return (cPtr == 0) ? null : new ModelVisitor(cPtr, false);
  }

  /**
   *  Symmetry Breaking.
   */
  public SearchMonitor makeSymmetryManager(SymmetryBreaker[] visitors) {
    long cPtr = mainJNI.Solver_makeSymmetryManager__SWIG_0(swigCPtr, this, visitors);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  public SearchMonitor makeSymmetryManager(SymmetryBreaker v1) {
    long cPtr = mainJNI.Solver_makeSymmetryManager__SWIG_1(swigCPtr, this, SymmetryBreaker.getCPtr(v1), v1);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  public SearchMonitor makeSymmetryManager(SymmetryBreaker v1, SymmetryBreaker v2) {
    long cPtr = mainJNI.Solver_makeSymmetryManager__SWIG_2(swigCPtr, this, SymmetryBreaker.getCPtr(v1), v1, SymmetryBreaker.getCPtr(v2), v2);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  public SearchMonitor makeSymmetryManager(SymmetryBreaker v1, SymmetryBreaker v2, SymmetryBreaker v3) {
    long cPtr = mainJNI.Solver_makeSymmetryManager__SWIG_3(swigCPtr, this, SymmetryBreaker.getCPtr(v1), v1, SymmetryBreaker.getCPtr(v2), v2, SymmetryBreaker.getCPtr(v3), v3);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  public SearchMonitor makeSymmetryManager(SymmetryBreaker v1, SymmetryBreaker v2, SymmetryBreaker v3, SymmetryBreaker v4) {
    long cPtr = mainJNI.Solver_makeSymmetryManager__SWIG_4(swigCPtr, this, SymmetryBreaker.getCPtr(v1), v1, SymmetryBreaker.getCPtr(v2), v2, SymmetryBreaker.getCPtr(v3), v3, SymmetryBreaker.getCPtr(v4), v4);
    return (cPtr == 0) ? null : new SearchMonitor(cPtr, false);
  }

  /**
   *  Decisions.
   */
  public Decision makeAssignVariableValue(IntVar var, long val) {
    long cPtr = mainJNI.Solver_makeAssignVariableValue(swigCPtr, this, IntVar.getCPtr(var), var, val);
    return (cPtr == 0) ? null : new Decision(cPtr, false);
  }

  public Decision makeVariableLessOrEqualValue(IntVar var, long value) {
    long cPtr = mainJNI.Solver_makeVariableLessOrEqualValue(swigCPtr, this, IntVar.getCPtr(var), var, value);
    return (cPtr == 0) ? null : new Decision(cPtr, false);
  }

  public Decision makeVariableGreaterOrEqualValue(IntVar var, long value) {
    long cPtr = mainJNI.Solver_makeVariableGreaterOrEqualValue(swigCPtr, this, IntVar.getCPtr(var), var, value);
    return (cPtr == 0) ? null : new Decision(cPtr, false);
  }

  public Decision makeSplitVariableDomain(IntVar var, long val, boolean start_with_lower_half) {
    long cPtr = mainJNI.Solver_makeSplitVariableDomain(swigCPtr, this, IntVar.getCPtr(var), var, val, start_with_lower_half);
    return (cPtr == 0) ? null : new Decision(cPtr, false);
  }

  public Decision makeAssignVariableValueOrFail(IntVar var, long value) {
    long cPtr = mainJNI.Solver_makeAssignVariableValueOrFail(swigCPtr, this, IntVar.getCPtr(var), var, value);
    return (cPtr == 0) ? null : new Decision(cPtr, false);
  }

  public Decision MakeAssignVariableValueOrDoNothing(IntVar var, long value) {
    long cPtr = mainJNI.Solver_MakeAssignVariableValueOrDoNothing(swigCPtr, this, IntVar.getCPtr(var), var, value);
    return (cPtr == 0) ? null : new Decision(cPtr, false);
  }

  public Decision makeAssignVariablesValues(IntVar[] vars, long[] values) {
    long cPtr = mainJNI.Solver_makeAssignVariablesValues(swigCPtr, this, vars, values);
    return (cPtr == 0) ? null : new Decision(cPtr, false);
  }

  public Decision makeFailDecision() {
    long cPtr = mainJNI.Solver_makeFailDecision(swigCPtr, this);
    return (cPtr == 0) ? null : new Decision(cPtr, false);
  }

  public Decision makeDecision(Consumer<Solver> apply, Consumer<Solver> refute) {
    long cPtr = mainJNI.Solver_makeDecision(swigCPtr, this, apply, refute);
    return (cPtr == 0) ? null : new Decision(cPtr, false);
  }

  /**
   *  Creates a decision builder which sequentially composes decision builders.<br>
   *  At each leaf of a decision builder, the next decision builder is therefore<br>
   *  called. For instance, Compose(db1, db2) will result in the following tree:<br>
   *           d1 tree              |<br>
   *   |   \             |<br>
   *          db1 leaves            |<br>
   *     |     \           |<br>
   *   db2 tree db2 tree db2 tree   |
   */
  public DecisionBuilder compose(DecisionBuilder db1, DecisionBuilder db2) {
    long cPtr = mainJNI.Solver_compose__SWIG_0(swigCPtr, this, DecisionBuilder.getCPtr(db1), db1, DecisionBuilder.getCPtr(db2), db2);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder compose(DecisionBuilder db1, DecisionBuilder db2, DecisionBuilder db3) {
    long cPtr = mainJNI.Solver_compose__SWIG_1(swigCPtr, this, DecisionBuilder.getCPtr(db1), db1, DecisionBuilder.getCPtr(db2), db2, DecisionBuilder.getCPtr(db3), db3);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder compose(DecisionBuilder db1, DecisionBuilder db2, DecisionBuilder db3, DecisionBuilder db4) {
    long cPtr = mainJNI.Solver_compose__SWIG_2(swigCPtr, this, DecisionBuilder.getCPtr(db1), db1, DecisionBuilder.getCPtr(db2), db2, DecisionBuilder.getCPtr(db3), db3, DecisionBuilder.getCPtr(db4), db4);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder compose(DecisionBuilder[] dbs) {
    long cPtr = mainJNI.Solver_compose__SWIG_3(swigCPtr, this, dbs);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  /**
   *  Creates a decision builder which will create a search tree where each<br>
   *  decision builder is called from the top of the search tree. For instance<br>
   *  the decision builder Try(db1, db2) will entirely explore the search tree<br>
   *  of db1 then the one of db2, resulting in the following search tree:<br>
   *         Tree root            |<br>
   *       \            |<br>
   *   db1 tree     db2 tree      |<br>
   * <br>
   *  This is very handy to try a decision builder which partially explores the<br>
   *  search space and if it fails to try another decision builder.<br>
   * <br>
   *  "Try"-builders "recursively". For instance, Try(a,b,c,d) will give a tree<br>
   *  unbalanced to the right, whereas Try(Try(a,b), Try(b,c)) will give a<br>
   *  balanced tree. Investigate if we should only provide the binary version<br>
   *  and/or if we should balance automatically.
   */
  public DecisionBuilder tryDecisions(DecisionBuilder db1, DecisionBuilder db2) {
    long cPtr = mainJNI.Solver_tryDecisions__SWIG_0(swigCPtr, this, DecisionBuilder.getCPtr(db1), db1, DecisionBuilder.getCPtr(db2), db2);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder tryDecisions(DecisionBuilder db1, DecisionBuilder db2, DecisionBuilder db3) {
    long cPtr = mainJNI.Solver_tryDecisions__SWIG_1(swigCPtr, this, DecisionBuilder.getCPtr(db1), db1, DecisionBuilder.getCPtr(db2), db2, DecisionBuilder.getCPtr(db3), db3);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder tryDecisions(DecisionBuilder db1, DecisionBuilder db2, DecisionBuilder db3, DecisionBuilder db4) {
    long cPtr = mainJNI.Solver_tryDecisions__SWIG_2(swigCPtr, this, DecisionBuilder.getCPtr(db1), db1, DecisionBuilder.getCPtr(db2), db2, DecisionBuilder.getCPtr(db3), db3, DecisionBuilder.getCPtr(db4), db4);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder tryDecisions(DecisionBuilder[] dbs) {
    long cPtr = mainJNI.Solver_tryDecisions__SWIG_3(swigCPtr, this, dbs);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  /**
   *  Phases on IntVar arrays.<br>
   *  for all other functions that have several homonyms in this .h).
   */
  public DecisionBuilder makePhase(IntVar[] vars, int var_str, int val_str) {
    long cPtr = mainJNI.Solver_makePhase__SWIG_0(swigCPtr, this, vars, var_str, val_str);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makePhase(IntVar[] vars, LongUnaryOperator var_evaluator, int val_str) {
    long cPtr = mainJNI.Solver_makePhase__SWIG_1(swigCPtr, this, vars, var_evaluator, val_str);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makePhase(IntVar[] vars, int var_str, LongBinaryOperator value_evaluator) {
    long cPtr = mainJNI.Solver_makePhase__SWIG_2(swigCPtr, this, vars, var_str, value_evaluator);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  /**
   *  var_val1_val2_comparator(var, val1, val2) is true iff assigning value<br>
   *  "val1" to variable "var" is better than assigning value "val2".
   */
  public DecisionBuilder makePhase(IntVar[] vars, int var_str, LongTernaryPredicate var_val1_val2_comparator) {
    long cPtr = mainJNI.Solver_makePhase__SWIG_3(swigCPtr, this, vars, var_str, var_val1_val2_comparator);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makePhase(IntVar[] vars, LongUnaryOperator var_evaluator, LongBinaryOperator value_evaluator) {
    long cPtr = mainJNI.Solver_makePhase__SWIG_4(swigCPtr, this, vars, var_evaluator, value_evaluator);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makePhase(IntVar[] vars, int var_str, LongBinaryOperator value_evaluator, LongUnaryOperator tie_breaker) {
    long cPtr = mainJNI.Solver_makePhase__SWIG_5(swigCPtr, this, vars, var_str, value_evaluator, tie_breaker);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makePhase(IntVar[] vars, LongUnaryOperator var_evaluator, LongBinaryOperator value_evaluator, LongUnaryOperator tie_breaker) {
    long cPtr = mainJNI.Solver_makePhase__SWIG_6(swigCPtr, this, vars, var_evaluator, value_evaluator, tie_breaker);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makeDefaultPhase(IntVar[] vars) {
    long cPtr = mainJNI.Solver_makeDefaultPhase__SWIG_0(swigCPtr, this, vars);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makeDefaultPhase(IntVar[] vars, DefaultPhaseParameters parameters) {
    long cPtr = mainJNI.Solver_makeDefaultPhase__SWIG_1(swigCPtr, this, vars, DefaultPhaseParameters.getCPtr(parameters), parameters);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  /**
   *  Shortcuts for small arrays.
   */
  public DecisionBuilder makePhase(IntVar v0, int var_str, int val_str) {
    long cPtr = mainJNI.Solver_makePhase__SWIG_7(swigCPtr, this, IntVar.getCPtr(v0), v0, var_str, val_str);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makePhase(IntVar v0, IntVar v1, int var_str, int val_str) {
    long cPtr = mainJNI.Solver_makePhase__SWIG_8(swigCPtr, this, IntVar.getCPtr(v0), v0, IntVar.getCPtr(v1), v1, var_str, val_str);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makePhase(IntVar v0, IntVar v1, IntVar v2, int var_str, int val_str) {
    long cPtr = mainJNI.Solver_makePhase__SWIG_9(swigCPtr, this, IntVar.getCPtr(v0), v0, IntVar.getCPtr(v1), v1, IntVar.getCPtr(v2), v2, var_str, val_str);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makePhase(IntVar v0, IntVar v1, IntVar v2, IntVar v3, int var_str, int val_str) {
    long cPtr = mainJNI.Solver_makePhase__SWIG_10(swigCPtr, this, IntVar.getCPtr(v0), v0, IntVar.getCPtr(v1), v1, IntVar.getCPtr(v2), v2, IntVar.getCPtr(v3), v3, var_str, val_str);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  /**
   *  Returns a decision that tries to schedule a task at a given time.<br>
   *  On the Apply branch, it will set that interval var as performed and set<br>
   *  its start to 'est'. On the Refute branch, it will just update the<br>
   *  'marker' to 'est' + 1. This decision is used in the<br>
   *  INTERVAL_SET_TIMES_FORWARD strategy.
   */
  public Decision makeScheduleOrPostpone(IntervalVar var, long est, int[] marker) {
    long cPtr = mainJNI.Solver_makeScheduleOrPostpone(swigCPtr, this, IntervalVar.getCPtr(var), var, est, marker);
    return (cPtr == 0) ? null : new Decision(cPtr, false);
  }

  /**
   *  Returns a decision that tries to schedule a task at a given time.<br>
   *  On the Apply branch, it will set that interval var as performed and set<br>
   *  its end to 'est'. On the Refute branch, it will just update the<br>
   *  'marker' to 'est' - 1. This decision is used in the<br>
   *  INTERVAL_SET_TIMES_BACKWARD strategy.
   */
  public Decision makeScheduleOrExpedite(IntervalVar var, long est, int[] marker) {
    long cPtr = mainJNI.Solver_makeScheduleOrExpedite(swigCPtr, this, IntervalVar.getCPtr(var), var, est, marker);
    return (cPtr == 0) ? null : new Decision(cPtr, false);
  }

  /**
   *  Returns a decision that tries to rank first the ith interval var<br>
   *  in the sequence variable.
   */
  public Decision makeRankFirstInterval(SequenceVar sequence, int index) {
    long cPtr = mainJNI.Solver_makeRankFirstInterval(swigCPtr, this, SequenceVar.getCPtr(sequence), sequence, index);
    return (cPtr == 0) ? null : new Decision(cPtr, false);
  }

  /**
   *  Returns a decision that tries to rank last the ith interval var<br>
   *  in the sequence variable.
   */
  public Decision makeRankLastInterval(SequenceVar sequence, int index) {
    long cPtr = mainJNI.Solver_makeRankLastInterval(swigCPtr, this, SequenceVar.getCPtr(sequence), sequence, index);
    return (cPtr == 0) ? null : new Decision(cPtr, false);
  }

  /**
   *  Returns a decision builder which assigns values to variables which<br>
   *  minimize the values returned by the evaluator. The arguments passed to the<br>
   *  evaluator callback are the indices of the variables in vars and the values<br>
   *  of these variables. Ownership of the callback is passed to the decision<br>
   *  builder.
   */
  public DecisionBuilder makePhase(IntVar[] vars, LongBinaryOperator eval, int str) {
    long cPtr = mainJNI.Solver_makePhase__SWIG_11(swigCPtr, this, vars, eval, str);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  /**
   *  Returns a decision builder which assigns values to variables<br>
   *  which minimize the values returned by the evaluator. In case of<br>
   *  tie breaks, the second callback is used to choose the best index<br>
   *  in the array of equivalent pairs with equivalent evaluations. The<br>
   *  arguments passed to the evaluator callback are the indices of the<br>
   *  variables in vars and the values of these variables. Ownership of<br>
   *  the callback is passed to the decision builder.
   */
  public DecisionBuilder makePhase(IntVar[] vars, LongBinaryOperator eval, LongUnaryOperator tie_breaker, int str) {
    long cPtr = mainJNI.Solver_makePhase__SWIG_12(swigCPtr, this, vars, eval, tie_breaker, str);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  /**
   *  Scheduling phases.
   */
  public DecisionBuilder makePhase(IntervalVar[] intervals, int str) {
    long cPtr = mainJNI.Solver_makePhase__SWIG_13(swigCPtr, this, intervals, str);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makePhase(SequenceVar[] sequences, int str) {
    long cPtr = mainJNI.Solver_makePhase__SWIG_14(swigCPtr, this, sequences, str);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  /**
   *  Returns a decision builder for which the left-most leaf corresponds<br>
   *  to assignment, the rest of the tree being explored using 'db'.
   */
  public DecisionBuilder makeDecisionBuilderFromAssignment(Assignment assignment, DecisionBuilder db, IntVar[] vars) {
    long cPtr = mainJNI.Solver_makeDecisionBuilderFromAssignment(swigCPtr, this, Assignment.getCPtr(assignment), assignment, DecisionBuilder.getCPtr(db), db, vars);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  /**
   *  Returns a decision builder that will add the given constraint to<br>
   *  the model.
   */
  public DecisionBuilder makeConstraintAdder(Constraint ct) {
    long cPtr = mainJNI.Solver_makeConstraintAdder(swigCPtr, this, Constraint.getCPtr(ct), ct);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  /**
   *  SolveOnce will collapse a search tree described by a decision<br>
   *  builder 'db' and a set of monitors and wrap it into a single point.<br>
   *  If there are no solutions to this nested tree, then SolveOnce will<br>
   *  fail. If there is a solution, it will find it and returns nullptr.
   */
  public DecisionBuilder makeSolveOnce(DecisionBuilder db) {
    long cPtr = mainJNI.Solver_makeSolveOnce__SWIG_0(swigCPtr, this, DecisionBuilder.getCPtr(db), db);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makeSolveOnce(DecisionBuilder db, SearchMonitor monitor1) {
    long cPtr = mainJNI.Solver_makeSolveOnce__SWIG_1(swigCPtr, this, DecisionBuilder.getCPtr(db), db, SearchMonitor.getCPtr(monitor1), monitor1);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makeSolveOnce(DecisionBuilder db, SearchMonitor monitor1, SearchMonitor monitor2) {
    long cPtr = mainJNI.Solver_makeSolveOnce__SWIG_2(swigCPtr, this, DecisionBuilder.getCPtr(db), db, SearchMonitor.getCPtr(monitor1), monitor1, SearchMonitor.getCPtr(monitor2), monitor2);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makeSolveOnce(DecisionBuilder db, SearchMonitor monitor1, SearchMonitor monitor2, SearchMonitor monitor3) {
    long cPtr = mainJNI.Solver_makeSolveOnce__SWIG_3(swigCPtr, this, DecisionBuilder.getCPtr(db), db, SearchMonitor.getCPtr(monitor1), monitor1, SearchMonitor.getCPtr(monitor2), monitor2, SearchMonitor.getCPtr(monitor3), monitor3);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makeSolveOnce(DecisionBuilder db, SearchMonitor monitor1, SearchMonitor monitor2, SearchMonitor monitor3, SearchMonitor monitor4) {
    long cPtr = mainJNI.Solver_makeSolveOnce__SWIG_4(swigCPtr, this, DecisionBuilder.getCPtr(db), db, SearchMonitor.getCPtr(monitor1), monitor1, SearchMonitor.getCPtr(monitor2), monitor2, SearchMonitor.getCPtr(monitor3), monitor3, SearchMonitor.getCPtr(monitor4), monitor4);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makeSolveOnce(DecisionBuilder db, SearchMonitor[] monitors) {
    long cPtr = mainJNI.Solver_makeSolveOnce__SWIG_5(swigCPtr, this, DecisionBuilder.getCPtr(db), db, monitors);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  /**
   *  NestedOptimize will collapse a search tree described by a<br>
   *  decision builder 'db' and a set of monitors and wrap it into a<br>
   *  single point. If there are no solutions to this nested tree, then<br>
   *  NestedOptimize will fail. If there are solutions, it will find<br>
   *  the best as described by the mandatory objective in the solution<br>
   *  as well as the optimization direction, instantiate all variables<br>
   *  to this solution, and return nullptr.
   */
  public DecisionBuilder makeNestedOptimize(DecisionBuilder db, Assignment solution, boolean maximize, long step) {
    long cPtr = mainJNI.Solver_makeNestedOptimize__SWIG_0(swigCPtr, this, DecisionBuilder.getCPtr(db), db, Assignment.getCPtr(solution), solution, maximize, step);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makeNestedOptimize(DecisionBuilder db, Assignment solution, boolean maximize, long step, SearchMonitor monitor1) {
    long cPtr = mainJNI.Solver_makeNestedOptimize__SWIG_1(swigCPtr, this, DecisionBuilder.getCPtr(db), db, Assignment.getCPtr(solution), solution, maximize, step, SearchMonitor.getCPtr(monitor1), monitor1);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makeNestedOptimize(DecisionBuilder db, Assignment solution, boolean maximize, long step, SearchMonitor monitor1, SearchMonitor monitor2) {
    long cPtr = mainJNI.Solver_makeNestedOptimize__SWIG_2(swigCPtr, this, DecisionBuilder.getCPtr(db), db, Assignment.getCPtr(solution), solution, maximize, step, SearchMonitor.getCPtr(monitor1), monitor1, SearchMonitor.getCPtr(monitor2), monitor2);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makeNestedOptimize(DecisionBuilder db, Assignment solution, boolean maximize, long step, SearchMonitor monitor1, SearchMonitor monitor2, SearchMonitor monitor3) {
    long cPtr = mainJNI.Solver_makeNestedOptimize__SWIG_3(swigCPtr, this, DecisionBuilder.getCPtr(db), db, Assignment.getCPtr(solution), solution, maximize, step, SearchMonitor.getCPtr(monitor1), monitor1, SearchMonitor.getCPtr(monitor2), monitor2, SearchMonitor.getCPtr(monitor3), monitor3);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makeNestedOptimize(DecisionBuilder db, Assignment solution, boolean maximize, long step, SearchMonitor monitor1, SearchMonitor monitor2, SearchMonitor monitor3, SearchMonitor monitor4) {
    long cPtr = mainJNI.Solver_makeNestedOptimize__SWIG_4(swigCPtr, this, DecisionBuilder.getCPtr(db), db, Assignment.getCPtr(solution), solution, maximize, step, SearchMonitor.getCPtr(monitor1), monitor1, SearchMonitor.getCPtr(monitor2), monitor2, SearchMonitor.getCPtr(monitor3), monitor3, SearchMonitor.getCPtr(monitor4), monitor4);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makeNestedOptimize(DecisionBuilder db, Assignment solution, boolean maximize, long step, SearchMonitor[] monitors) {
    long cPtr = mainJNI.Solver_makeNestedOptimize__SWIG_5(swigCPtr, this, DecisionBuilder.getCPtr(db), db, Assignment.getCPtr(solution), solution, maximize, step, monitors);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  /**
   *  Returns a DecisionBuilder which restores an Assignment<br>
   *  (calls void Assignment::Restore())
   */
  public DecisionBuilder makeRestoreAssignment(Assignment assignment) {
    long cPtr = mainJNI.Solver_makeRestoreAssignment(swigCPtr, this, Assignment.getCPtr(assignment), assignment);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  /**
   *  Returns a DecisionBuilder which stores an Assignment<br>
   *  (calls void Assignment::Store())
   */
  public DecisionBuilder makeStoreAssignment(Assignment assignment) {
    long cPtr = mainJNI.Solver_makeStoreAssignment(swigCPtr, this, Assignment.getCPtr(assignment), assignment);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  /**
   *  Local Search Operators.
   */
  public LocalSearchOperator makeOperator(IntVar[] vars, int op) {
    long cPtr = mainJNI.Solver_makeOperator__SWIG_0(swigCPtr, this, vars, op);
    return (cPtr == 0) ? null : new LocalSearchOperator(cPtr, false);
  }

  public LocalSearchOperator makeOperator(IntVar[] vars, IntVar[] secondary_vars, int op) {
    long cPtr = mainJNI.Solver_makeOperator__SWIG_1(swigCPtr, this, vars, secondary_vars, op);
    return (cPtr == 0) ? null : new LocalSearchOperator(cPtr, false);
  }

  public LocalSearchOperator makeOperator(IntVar[] vars, LongTernaryOperator evaluator, int op) {
    long cPtr = mainJNI.Solver_makeOperator__SWIG_2(swigCPtr, this, vars, evaluator, op);
    return (cPtr == 0) ? null : new LocalSearchOperator(cPtr, false);
  }

  public LocalSearchOperator makeOperator(IntVar[] vars, IntVar[] secondary_vars, LongTernaryOperator evaluator, int op) {
    long cPtr = mainJNI.Solver_makeOperator__SWIG_3(swigCPtr, this, vars, secondary_vars, evaluator, op);
    return (cPtr == 0) ? null : new LocalSearchOperator(cPtr, false);
  }

  /**
   *  Creates a large neighborhood search operator which creates fragments (set<br>
   *  of relaxed variables) with up to number_of_variables random variables<br>
   *  (sampling with replacement is performed meaning that at most<br>
   *  number_of_variables variables are selected). Warning: this operator will<br>
   *  always return neighbors; using it without a search limit will result in a<br>
   *  non-ending search.<br>
   *  Optionally a random seed can be specified.
   */
  public LocalSearchOperator makeRandomLnsOperator(IntVar[] vars, int number_of_variables) {
    long cPtr = mainJNI.Solver_makeRandomLnsOperator__SWIG_0(swigCPtr, this, vars, number_of_variables);
    return (cPtr == 0) ? null : new LocalSearchOperator(cPtr, false);
  }

  public LocalSearchOperator makeRandomLnsOperator(IntVar[] vars, int number_of_variables, int seed) {
    long cPtr = mainJNI.Solver_makeRandomLnsOperator__SWIG_1(swigCPtr, this, vars, number_of_variables, seed);
    return (cPtr == 0) ? null : new LocalSearchOperator(cPtr, false);
  }

  /**
   *  Creates a local search operator that tries to move the assignment of some<br>
   *  variables toward a target. The target is given as an Assignment. This<br>
   *  operator generates neighbors in which the only difference compared to the<br>
   *  current state is that one variable that belongs to the target assignment<br>
   *  is set to its target value.
   */
  public LocalSearchOperator makeMoveTowardTargetOperator(Assignment target) {
    long cPtr = mainJNI.Solver_makeMoveTowardTargetOperator__SWIG_0(swigCPtr, this, Assignment.getCPtr(target), target);
    return (cPtr == 0) ? null : new LocalSearchOperator(cPtr, false);
  }

  /**
   *  Creates a local search operator that tries to move the assignment of some<br>
   *  variables toward a target. The target is given either as two vectors: a<br>
   *  vector of variables and a vector of associated target values. The two<br>
   *  vectors should be of the same length. This operator generates neighbors in<br>
   *  which the only difference compared to the current state is that one<br>
   *  variable that belongs to the given vector is set to its target value.
   */
  public LocalSearchOperator makeMoveTowardTargetOperator(IntVar[] variables, long[] target_values) {
    long cPtr = mainJNI.Solver_makeMoveTowardTargetOperator__SWIG_1(swigCPtr, this, variables, target_values);
    return (cPtr == 0) ? null : new LocalSearchOperator(cPtr, false);
  }

  /**
   *  Creates a local search operator which concatenates a vector of operators.<br>
   *  Each operator from the vector is called sequentially. By default, when a<br>
   *  neighbor is found the neighborhood exploration restarts from the last<br>
   *  active operator (the one which produced the neighbor).<br>
   *  This can be overridden by setting restart to true to force the exploration<br>
   *  to start from the first operator in the vector.<br>
   * <br>
   *  The default behavior can also be overridden using an evaluation callback<br>
   *  to set the order in which the operators are explored (the callback is<br>
   *  called in LocalSearchOperator::Start()). The first argument of the<br>
   *  callback is the index of the operator which produced the last move, the<br>
   *  second argument is the index of the operator to be evaluated. Ownership of<br>
   *  the callback is taken by ConcatenateOperators.<br>
   * <br>
   *  Example:<br>
   * <br>
   *   const int kPriorities = {10, 100, 10, 0};<br>
   *   int64_t Evaluate(int active_operator, int current_operator) {<br>
   *     return kPriorities[current_operator];<br>
   *   }<br>
   * <br>
   *   LocalSearchOperator* concat =<br>
   *     solver.ConcatenateOperators(operators,<br>
   *                                 NewPermanentCallback(&amp;Evaluate));<br>
   * <br>
   *  The elements of the vector operators will be sorted by increasing priority<br>
   *  and explored in that order (tie-breaks are handled by keeping the relative<br>
   *  operator order in the vector). This would result in the following order:<br>
   *  operators[3], operators[0], operators[2], operators[1].
   */
  public LocalSearchOperator concatenateOperators(LocalSearchOperator[] ops) {
    long cPtr = mainJNI.Solver_concatenateOperators__SWIG_0(swigCPtr, this, ops);
    return (cPtr == 0) ? null : new LocalSearchOperator(cPtr, false);
  }

  public LocalSearchOperator concatenateOperators(LocalSearchOperator[] ops, boolean restart) {
    long cPtr = mainJNI.Solver_concatenateOperators__SWIG_1(swigCPtr, this, ops, restart);
    return (cPtr == 0) ? null : new LocalSearchOperator(cPtr, false);
  }

  public LocalSearchOperator concatenateOperators(LocalSearchOperator[] ops, IntIntToLongFunction evaluator) {
    long cPtr = mainJNI.Solver_concatenateOperators__SWIG_2(swigCPtr, this, ops, evaluator);
    return (cPtr == 0) ? null : new LocalSearchOperator(cPtr, false);
  }

  /**
   *  Randomized version of local search concatenator; calls a random operator<br>
   *  at each call to MakeNextNeighbor().
   */
  public LocalSearchOperator randomConcatenateOperators(LocalSearchOperator[] ops) {
    long cPtr = mainJNI.Solver_randomConcatenateOperators__SWIG_0(swigCPtr, this, ops);
    return (cPtr == 0) ? null : new LocalSearchOperator(cPtr, false);
  }

  /**
   *  Randomized version of local search concatenator; calls a random operator<br>
   *  at each call to MakeNextNeighbor(). The provided seed is used to<br>
   *  initialize the random number generator.
   */
  public LocalSearchOperator randomConcatenateOperators(LocalSearchOperator[] ops, int seed) {
    long cPtr = mainJNI.Solver_randomConcatenateOperators__SWIG_1(swigCPtr, this, ops, seed);
    return (cPtr == 0) ? null : new LocalSearchOperator(cPtr, false);
  }

  /**
   *  Creates a local search operator which concatenates a vector of operators.<br>
   *  Uses Multi-Armed Bandit approach for choosing the next operator to use.<br>
   *  Sorts operators based on Upper Confidence Bound Algorithm which evaluates<br>
   *  each operator as sum of average improvement and exploration function.<br>
   * <br>
   *  Updates the order of operators when accepts a neighbor with objective<br>
   *  improvement.
   */
  public LocalSearchOperator MultiArmedBanditConcatenateOperators(LocalSearchOperator[] ops, double memory_coefficient, double exploration_coefficient, boolean maximize) {
    long cPtr = mainJNI.Solver_MultiArmedBanditConcatenateOperators(swigCPtr, this, ops, memory_coefficient, exploration_coefficient, maximize);
    return (cPtr == 0) ? null : new LocalSearchOperator(cPtr, false);
  }

  /**
   *  Creates a local search operator that wraps another local search<br>
   *  operator and limits the number of neighbors explored (i.e., calls<br>
   *  to MakeNextNeighbor from the current solution (between two calls<br>
   *  to Start()). When this limit is reached, MakeNextNeighbor()<br>
   *  returns false. The counter is cleared when Start() is called.
   */
  public LocalSearchOperator makeNeighborhoodLimit(LocalSearchOperator op, long limit) {
    long cPtr = mainJNI.Solver_makeNeighborhoodLimit(swigCPtr, this, LocalSearchOperator.getCPtr(op), op, limit);
    return (cPtr == 0) ? null : new LocalSearchOperator(cPtr, false);
  }

  /**
   *  Local Search decision builders factories.<br>
   *  Local search is used to improve a given solution. This initial solution<br>
   *  can be specified either by an Assignment or by a DecisionBulder, and the<br>
   *  corresponding variables, the initial solution being the first solution<br>
   *  found by the DecisionBuilder.<br>
   *  The LocalSearchPhaseParameters parameter holds the actual definition of<br>
   *  the local search phase:<br>
   *  - a local search operator used to explore the neighborhood of the current<br>
   *    solution,<br>
   *  - a decision builder to instantiate unbound variables once a neighbor has<br>
   *    been defined; in the case of LNS-based operators instantiates fragment<br>
   *    variables; search monitors can be added to this sub-search by wrapping<br>
   *    the decision builder with MakeSolveOnce.<br>
   *  - a search limit specifying how long local search looks for neighbors<br>
   *    before accepting one; the last neighbor is always taken and in the case<br>
   *    of a greedy search, this corresponds to the best local neighbor;<br>
   *    first-accept (which is the default behavior) can be modeled using a<br>
   *    solution found limit of 1,<br>
   *  - a vector of local search filters used to speed up the search by pruning<br>
   *    unfeasible neighbors.<br>
   *  Metaheuristics can be added by defining specialized search monitors;<br>
   *  currently down/up-hill climbing is available through OptimizeVar, as well<br>
   *  as Guided Local Search, Tabu Search and Simulated Annealing.
   */
  public DecisionBuilder makeLocalSearchPhase(Assignment assignment, LocalSearchPhaseParameters parameters) {
    long cPtr = mainJNI.Solver_makeLocalSearchPhase__SWIG_0(swigCPtr, this, Assignment.getCPtr(assignment), assignment, LocalSearchPhaseParameters.getCPtr(parameters), parameters);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makeLocalSearchPhase(IntVar[] vars, DecisionBuilder first_solution, LocalSearchPhaseParameters parameters) {
    long cPtr = mainJNI.Solver_makeLocalSearchPhase__SWIG_1(swigCPtr, this, vars, DecisionBuilder.getCPtr(first_solution), first_solution, LocalSearchPhaseParameters.getCPtr(parameters), parameters);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  /**
   *  Variant with a sub_decison_builder specific to the first solution.
   */
  public DecisionBuilder makeLocalSearchPhase(IntVar[] vars, DecisionBuilder first_solution, DecisionBuilder first_solution_sub_decision_builder, LocalSearchPhaseParameters parameters) {
    long cPtr = mainJNI.Solver_makeLocalSearchPhase__SWIG_2(swigCPtr, this, vars, DecisionBuilder.getCPtr(first_solution), first_solution, DecisionBuilder.getCPtr(first_solution_sub_decision_builder), first_solution_sub_decision_builder, LocalSearchPhaseParameters.getCPtr(parameters), parameters);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  public DecisionBuilder makeLocalSearchPhase(SequenceVar[] vars, DecisionBuilder first_solution, LocalSearchPhaseParameters parameters) {
    long cPtr = mainJNI.Solver_makeLocalSearchPhase__SWIG_3(swigCPtr, this, vars, DecisionBuilder.getCPtr(first_solution), first_solution, LocalSearchPhaseParameters.getCPtr(parameters), parameters);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  /**
   *  Solution Pool.
   */
  public SolutionPool makeDefaultSolutionPool() {
    long cPtr = mainJNI.Solver_makeDefaultSolutionPool(swigCPtr, this);
    return (cPtr == 0) ? null : new SolutionPool(cPtr, false);
  }

  /**
   *  Local Search Phase Parameters
   */
  public LocalSearchPhaseParameters makeLocalSearchPhaseParameters(IntVar objective, LocalSearchOperator ls_operator, DecisionBuilder sub_decision_builder) {
    long cPtr = mainJNI.Solver_makeLocalSearchPhaseParameters__SWIG_0(swigCPtr, this, IntVar.getCPtr(objective), objective, LocalSearchOperator.getCPtr(ls_operator), ls_operator, DecisionBuilder.getCPtr(sub_decision_builder), sub_decision_builder);
    return (cPtr == 0) ? null : new LocalSearchPhaseParameters(cPtr, false);
  }

  public LocalSearchPhaseParameters makeLocalSearchPhaseParameters(IntVar objective, LocalSearchOperator ls_operator, DecisionBuilder sub_decision_builder, RegularLimit limit) {
    long cPtr = mainJNI.Solver_makeLocalSearchPhaseParameters__SWIG_1(swigCPtr, this, IntVar.getCPtr(objective), objective, LocalSearchOperator.getCPtr(ls_operator), ls_operator, DecisionBuilder.getCPtr(sub_decision_builder), sub_decision_builder, RegularLimit.getCPtr(limit), limit);
    return (cPtr == 0) ? null : new LocalSearchPhaseParameters(cPtr, false);
  }

  public LocalSearchPhaseParameters makeLocalSearchPhaseParameters(IntVar objective, LocalSearchOperator ls_operator, DecisionBuilder sub_decision_builder, RegularLimit limit, LocalSearchFilterManager filter_manager) {
    long cPtr = mainJNI.Solver_makeLocalSearchPhaseParameters__SWIG_2(swigCPtr, this, IntVar.getCPtr(objective), objective, LocalSearchOperator.getCPtr(ls_operator), ls_operator, DecisionBuilder.getCPtr(sub_decision_builder), sub_decision_builder, RegularLimit.getCPtr(limit), limit, LocalSearchFilterManager.getCPtr(filter_manager), filter_manager);
    return (cPtr == 0) ? null : new LocalSearchPhaseParameters(cPtr, false);
  }

  public LocalSearchPhaseParameters makeLocalSearchPhaseParameters(IntVar objective, SolutionPool pool, LocalSearchOperator ls_operator, DecisionBuilder sub_decision_builder) {
    long cPtr = mainJNI.Solver_makeLocalSearchPhaseParameters__SWIG_3(swigCPtr, this, IntVar.getCPtr(objective), objective, SolutionPool.getCPtr(pool), pool, LocalSearchOperator.getCPtr(ls_operator), ls_operator, DecisionBuilder.getCPtr(sub_decision_builder), sub_decision_builder);
    return (cPtr == 0) ? null : new LocalSearchPhaseParameters(cPtr, false);
  }

  public LocalSearchPhaseParameters makeLocalSearchPhaseParameters(IntVar objective, SolutionPool pool, LocalSearchOperator ls_operator, DecisionBuilder sub_decision_builder, RegularLimit limit) {
    long cPtr = mainJNI.Solver_makeLocalSearchPhaseParameters__SWIG_4(swigCPtr, this, IntVar.getCPtr(objective), objective, SolutionPool.getCPtr(pool), pool, LocalSearchOperator.getCPtr(ls_operator), ls_operator, DecisionBuilder.getCPtr(sub_decision_builder), sub_decision_builder, RegularLimit.getCPtr(limit), limit);
    return (cPtr == 0) ? null : new LocalSearchPhaseParameters(cPtr, false);
  }

  public LocalSearchPhaseParameters makeLocalSearchPhaseParameters(IntVar objective, SolutionPool pool, LocalSearchOperator ls_operator, DecisionBuilder sub_decision_builder, RegularLimit limit, LocalSearchFilterManager filter_manager) {
    long cPtr = mainJNI.Solver_makeLocalSearchPhaseParameters__SWIG_5(swigCPtr, this, IntVar.getCPtr(objective), objective, SolutionPool.getCPtr(pool), pool, LocalSearchOperator.getCPtr(ls_operator), ls_operator, DecisionBuilder.getCPtr(sub_decision_builder), sub_decision_builder, RegularLimit.getCPtr(limit), limit, LocalSearchFilterManager.getCPtr(filter_manager), filter_manager);
    return (cPtr == 0) ? null : new LocalSearchPhaseParameters(cPtr, false);
  }

  /**
   *  Local Search Filters
   */
  public LocalSearchFilter MakeAcceptFilter() {
    long cPtr = mainJNI.Solver_MakeAcceptFilter(swigCPtr, this);
    return (cPtr == 0) ? null : new LocalSearchFilter(cPtr, false);
  }

  public LocalSearchFilter MakeRejectFilter() {
    long cPtr = mainJNI.Solver_MakeRejectFilter(swigCPtr, this);
    return (cPtr == 0) ? null : new LocalSearchFilter(cPtr, false);
  }

  public LocalSearchFilter makeVariableDomainFilter() {
    long cPtr = mainJNI.Solver_makeVariableDomainFilter(swigCPtr, this);
    return (cPtr == 0) ? null : new LocalSearchFilter(cPtr, false);
  }

  public IntVarLocalSearchFilter makeSumObjectiveFilter(IntVar[] vars, LongBinaryOperator values, int filter_enum) {
    long cPtr = mainJNI.Solver_makeSumObjectiveFilter__SWIG_0(swigCPtr, this, vars, values, filter_enum);
    return (cPtr == 0) ? null : new IntVarLocalSearchFilter(cPtr, false);
  }

  public IntVarLocalSearchFilter makeSumObjectiveFilter(IntVar[] vars, IntVar[] secondary_vars, LongTernaryOperator values, int filter_enum) {
    long cPtr = mainJNI.Solver_makeSumObjectiveFilter__SWIG_1(swigCPtr, this, vars, secondary_vars, values, filter_enum);
    return (cPtr == 0) ? null : new IntVarLocalSearchFilter(cPtr, false);
  }

  /**
   *  Performs PeriodicCheck on the top-level search; for instance, can be<br>
   *  called from a nested solve to check top-level limits.
   */
  public void topPeriodicCheck() {
    mainJNI.Solver_topPeriodicCheck(swigCPtr, this);
  }

  /**
   *  Returns a percentage representing the propress of the search before<br>
   *  reaching the limits of the top-level search (can be called from a nested<br>
   *  solve).
   */
  public int topProgressPercent() {
    return mainJNI.Solver_topProgressPercent(swigCPtr, this);
  }

  /**
   *  The PushState and PopState methods manipulates the states<br>
   *  of the reversible objects. They are visible only because they<br>
   *  are useful to write unitary tests.
   */
  public void pushState() {
    mainJNI.Solver_pushState(swigCPtr, this);
  }

  public void popState() {
    mainJNI.Solver_popState(swigCPtr, this);
  }

  /**
   *  Gets the search depth of the current active search. Returns -1 if<br>
   *  there is no active search opened.
   */
  public int searchDepth() {
    return mainJNI.Solver_searchDepth(swigCPtr, this);
  }

  /**
   *  Gets the search left depth of the current active search. Returns -1 if<br>
   *  there is no active search opened.
   */
  public int searchLeftDepth() {
    return mainJNI.Solver_searchLeftDepth(swigCPtr, this);
  }

  /**
   *  Gets the number of nested searches. It returns 0 outside search,<br>
   *  1 during the top level search, 2 or more in case of nested searches.
   */
  public int solveDepth() {
    return mainJNI.Solver_solveDepth(swigCPtr, this);
  }

  /**
   *  Returns a random value between 0 and 'size' - 1;
   */
  public long rand64(long size) {
    return mainJNI.Solver_rand64(swigCPtr, this, size);
  }

  /**
   *  Returns a random value between 0 and 'size' - 1;
   */
  public int rand32(int size) {
    return mainJNI.Solver_rand32(swigCPtr, this, size);
  }

  /**
   *  Reseed the solver random generator.
   */
  public void reSeed(int seed) {
    mainJNI.Solver_reSeed(swigCPtr, this, seed);
  }

  /**
   *  Exports the profiling information in a human readable overview.<br>
   *  The parameter profile_level used to create the solver must be<br>
   *  set to true.
   */
  public void exportProfilingOverview(String filename) {
    mainJNI.Solver_exportProfilingOverview(swigCPtr, this, filename);
  }

  /**
   *  Returns local search profiling information in a human readable format.
   */
  public String localSearchProfile() {
    return mainJNI.Solver_localSearchProfile(swigCPtr, this);
  }

  /**
   *  Returns true whether the current search has been<br>
   *  created using a Solve() call instead of a NewSearch one. It<br>
   *  returns false if the solver is not in search at all.
   */
  public boolean currentlyInSolve() {
    return mainJNI.Solver_currentlyInSolve(swigCPtr, this);
  }

  /**
   *  Counts the number of constraints that have been added<br>
   *  to the solver before the search.
   */
  public int constraints() {
    return mainJNI.Solver_constraints(swigCPtr, this);
  }

  /**
   *  Accepts the given model visitor.
   */
  public void accept(ModelVisitor visitor) {
    mainJNI.Solver_accept(swigCPtr, this, ModelVisitor.getCPtr(visitor), visitor);
  }

  public Decision balancing_decision() {
    long cPtr = mainJNI.Solver_balancing_decision(swigCPtr, this);
    return (cPtr == 0) ? null : new Decision(cPtr, false);
  }

  /**
   *  Internal
   */
  public void clear_fail_intercept() {
    mainJNI.Solver_clear_fail_intercept(swigCPtr, this);
  }

  /**
   *  enabled for metaheuristics.<br>
   *  Disables/enables fast local search.
   */
  public void SetUseFastLocalSearch(boolean use_fast_local_search) {
    mainJNI.Solver_SetUseFastLocalSearch(swigCPtr, this, use_fast_local_search);
  }

  /**
   *  Returns true if fast local search is enabled.
   */
  public boolean UseFastLocalSearch() {
    return mainJNI.Solver_UseFastLocalSearch(swigCPtr, this);
  }

  /**
   *  Returns whether the object has been named or not.
   */
  public boolean hasName(PropagationBaseObject object) {
    return mainJNI.Solver_hasName(swigCPtr, this, PropagationBaseObject.getCPtr(object), object);
  }

  /**
   *  Adds a new demon and wraps it inside a DemonProfiler if necessary.
   */
  public Demon registerDemon(Demon demon) {
    long cPtr = mainJNI.Solver_registerDemon(swigCPtr, this, Demon.getCPtr(demon), demon);
    return (cPtr == 0) ? null : new Demon(cPtr, false);
  }

  /**
   *  Registers a new IntExpr and wraps it inside a TraceIntExpr if necessary.
   */
  public IntExpr registerIntExpr(IntExpr expr) {
    long cPtr = mainJNI.Solver_registerIntExpr(swigCPtr, this, IntExpr.getCPtr(expr), expr);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  Registers a new IntVar and wraps it inside a TraceIntVar if necessary.
   */
  public IntVar registerIntVar(IntVar var) {
    long cPtr = mainJNI.Solver_registerIntVar(swigCPtr, this, IntVar.getCPtr(var), var);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  Registers a new IntervalVar and wraps it inside a TraceIntervalVar<br>
   *  if necessary.
   */
  public IntervalVar registerIntervalVar(IntervalVar var) {
    long cPtr = mainJNI.Solver_registerIntervalVar(swigCPtr, this, IntervalVar.getCPtr(var), var);
    return (cPtr == 0) ? null : new IntervalVar(cPtr, false);
  }

  /**
   *  Returns the cache of the model.
   */
  public ModelCache cache() {
    long cPtr = mainJNI.Solver_cache(swigCPtr, this);
    return (cPtr == 0) ? null : new ModelCache(cPtr, false);
  }

  /**
   *  Returns whether we are instrumenting demons.
   */
  public boolean instrumentsDemons() {
    return mainJNI.Solver_instrumentsDemons(swigCPtr, this);
  }

  /**
   *  Returns whether we are profiling the solver.
   */
  public boolean isProfilingEnabled() {
    return mainJNI.Solver_isProfilingEnabled(swigCPtr, this);
  }

  /**
   *  Returns whether we are profiling local search.
   */
  public boolean isLocalSearchProfilingEnabled() {
    return mainJNI.Solver_isLocalSearchProfilingEnabled(swigCPtr, this);
  }

  /**
   *  Returns whether we are tracing variables.
   */
  public boolean instrumentsVariables() {
    return mainJNI.Solver_instrumentsVariables(swigCPtr, this);
  }

  /**
   *  Returns whether all variables should be named.
   */
  public boolean nameAllVariables() {
    return mainJNI.Solver_nameAllVariables(swigCPtr, this);
  }

  /**
   *  Returns the name of the model.
   */
  public String model_name() {
    return mainJNI.Solver_model_name(swigCPtr, this);
  }

  /**
   *  Returns the propagation monitor.
   */
  public PropagationMonitor getPropagationMonitor() {
    long cPtr = mainJNI.Solver_getPropagationMonitor(swigCPtr, this);
    return (cPtr == 0) ? null : new PropagationMonitor(cPtr, false);
  }

  /**
   *  Adds the propagation monitor to the solver. This is called internally when<br>
   *  a propagation monitor is passed to the Solve() or NewSearch() method.
   */
  public void addPropagationMonitor(PropagationMonitor monitor) {
    mainJNI.Solver_addPropagationMonitor(swigCPtr, this, PropagationMonitor.getCPtr(monitor), monitor);
  }

  /**
   *  Returns the local search monitor.
   */
  public LocalSearchMonitor getLocalSearchMonitor() {
    long cPtr = mainJNI.Solver_getLocalSearchMonitor(swigCPtr, this);
    return (cPtr == 0) ? null : new LocalSearchMonitor(cPtr, false);
  }

  /**
   *  Adds the local search monitor to the solver. This is called internally<br>
   *  when a propagation monitor is passed to the Solve() or NewSearch() method.
   */
  public void addLocalSearchMonitor(LocalSearchMonitor monitor) {
    mainJNI.Solver_addLocalSearchMonitor(swigCPtr, this, LocalSearchMonitor.getCPtr(monitor), monitor);
  }

  /**
   *  Returns (or creates) an assignment representing the state of local search.
   */
  public Assignment GetOrCreateLocalSearchState() {
    long cPtr = mainJNI.Solver_GetOrCreateLocalSearchState(swigCPtr, this);
    return (cPtr == 0) ? null : new Assignment(cPtr, false);
  }

  /**
   *  Clears the local search state.
   */
  public void ClearLocalSearchState() {
    mainJNI.Solver_ClearLocalSearchState(swigCPtr, this);
  }

  /**
   *  Unsafe temporary vector. It is used to avoid leaks in operations<br>
   *  that need storage and that may fail. See IntVar::SetValues() for<br>
   *  instance. It is not locked; do not use in a multi-threaded or reentrant<br>
   *  setup.
   */
  public void setTmpVector(long[] value) {
    mainJNI.Solver_tmpVector_set(swigCPtr, this, value);
  }

  /**
   *  Unsafe temporary vector. It is used to avoid leaks in operations<br>
   *  that need storage and that may fail. See IntVar::SetValues() for<br>
   *  instance. It is not locked; do not use in a multi-threaded or reentrant<br>
   *  setup.
   */
  public long[] getTmpVector() {
  return mainJNI.Solver_tmpVector_get(swigCPtr, this);
}

  /**
   *  Internal. If the variables is the result of expr-&gt;Var(), this<br>
   *  method returns expr, nullptr otherwise.
   */
  public IntExpr castExpression(IntVar var) {
    long cPtr = mainJNI.Solver_castExpression(swigCPtr, this, IntVar.getCPtr(var), var);
    return (cPtr == 0) ? null : new IntExpr(cPtr, false);
  }

  /**
   *  Tells the solver to kill or restart the current search.
   */
  public void finishCurrentSearch() {
    mainJNI.Solver_finishCurrentSearch(swigCPtr, this);
  }

  public void restartCurrentSearch() {
    mainJNI.Solver_restartCurrentSearch(swigCPtr, this);
  }

  /**
   *  These methods are only useful for the SWIG wrappers, which need a way<br>
   *  to externally cause the Solver to fail.
   */
  public void shouldFail() {
    mainJNI.Solver_shouldFail(swigCPtr, this);
  }

  public void checkFail() {
    mainJNI.Solver_checkFail(swigCPtr, this);
  }

  /**
   *  Number of priorities for demons.
   */
  public final static int kNumPriorities = mainJNI.Solver_kNumPriorities_get();
  // IntVarStrategy 
  /**
   *  This enum describes the strategy used to select the next branching<br>
   *  variable at each node during the search.
   */

  /**
   *  The default behavior is CHOOSE_FIRST_UNBOUND.
   */
  public final static int INT_VAR_DEFAULT = mainJNI.Solver_INT_VAR_DEFAULT_get();
  /**
   *  The simple selection is CHOOSE_FIRST_UNBOUND.
   */
  public final static int INT_VAR_SIMPLE = mainJNI.Solver_INT_VAR_SIMPLE_get();
  /**
   *  Select the first unbound variable.<br>
   *  Variables are considered in the order of the vector of IntVars used<br>
   *  to create the selector.
   */
  public final static int CHOOSE_FIRST_UNBOUND = mainJNI.Solver_CHOOSE_FIRST_UNBOUND_get();
  /**
   *  Randomly select one of the remaining unbound variables.
   */
  public final static int CHOOSE_RANDOM = mainJNI.Solver_CHOOSE_RANDOM_get();
  /**
   *  Among unbound variables, select the variable with the smallest size,<br>
   *  i.e., the smallest number of possible values.<br>
   *  In case of a tie, the selected variables is the one with the lowest min<br>
   *  value.<br>
   *  In case of a tie, the first one is selected, first being defined by the<br>
   *  order in the vector of IntVars used to create the selector.
   */
  public final static int CHOOSE_MIN_SIZE_LOWEST_MIN = mainJNI.Solver_CHOOSE_MIN_SIZE_LOWEST_MIN_get();
  /**
   *  Among unbound variables, select the variable with the smallest size,<br>
   *  i.e., the smallest number of possible values.<br>
   *  In case of a tie, the selected variable is the one with the highest min<br>
   *  value.<br>
   *  In case of a tie, the first one is selected, first being defined by the<br>
   *  order in the vector of IntVars used to create the selector.
   */
  public final static int CHOOSE_MIN_SIZE_HIGHEST_MIN = mainJNI.Solver_CHOOSE_MIN_SIZE_HIGHEST_MIN_get();
  /**
   *  Among unbound variables, select the variable with the smallest size,<br>
   *  i.e., the smallest number of possible values.<br>
   *  In case of a tie, the selected variables is the one with the lowest max<br>
   *  value.<br>
   *  In case of a tie, the first one is selected, first being defined by the<br>
   *  order in the vector of IntVars used to create the selector.
   */
  public final static int CHOOSE_MIN_SIZE_LOWEST_MAX = mainJNI.Solver_CHOOSE_MIN_SIZE_LOWEST_MAX_get();
  /**
   *  Among unbound variables, select the variable with the smallest size,<br>
   *  i.e., the smallest number of possible values.<br>
   *  In case of a tie, the selected variable is the one with the highest max<br>
   *  value.<br>
   *  In case of a tie, the first one is selected, first being defined by the<br>
   *  order in the vector of IntVars used to create the selector.
   */
  public final static int CHOOSE_MIN_SIZE_HIGHEST_MAX = mainJNI.Solver_CHOOSE_MIN_SIZE_HIGHEST_MAX_get();
  /**
   *  Among unbound variables, select the variable with the smallest minimal<br>
   *  value.<br>
   *  In case of a tie, the first one is selected, "first" defined by the<br>
   *  order in the vector of IntVars used to create the selector.
   */
  public final static int CHOOSE_LOWEST_MIN = mainJNI.Solver_CHOOSE_LOWEST_MIN_get();
  /**
   *  Among unbound variables, select the variable with the highest maximal<br>
   *  value.<br>
   *  In case of a tie, the first one is selected, first being defined by the<br>
   *  order in the vector of IntVars used to create the selector.
   */
  public final static int CHOOSE_HIGHEST_MAX = mainJNI.Solver_CHOOSE_HIGHEST_MAX_get();
  /**
   *  Among unbound variables, select the variable with the smallest size.<br>
   *  In case of a tie, the first one is selected, first being defined by the<br>
   *  order in the vector of IntVars used to create the selector.
   */
  public final static int CHOOSE_MIN_SIZE = mainJNI.Solver_CHOOSE_MIN_SIZE_get();
  /**
   *  Among unbound variables, select the variable with the highest size.<br>
   *  In case of a tie, the first one is selected, first being defined by the<br>
   *  order in the vector of IntVars used to create the selector.
   */
  public final static int CHOOSE_MAX_SIZE = mainJNI.Solver_CHOOSE_MAX_SIZE_get();
  /**
   *  Among unbound variables, select the variable with the largest<br>
   *  gap between the first and the second values of the domain.
   */
  public final static int CHOOSE_MAX_REGRET_ON_MIN = mainJNI.Solver_CHOOSE_MAX_REGRET_ON_MIN_get();
  /**
   *  Selects the next unbound variable on a path, the path being defined by<br>
   *  the variables: var[i] corresponds to the index of the next of i.
   */
  public final static int CHOOSE_PATH = mainJNI.Solver_CHOOSE_PATH_get();

  // IntValueStrategy 
  /**
   *  This enum describes the strategy used to select the next variable value to<br>
   *  set.
   */

  /**
   *  The default behavior is ASSIGN_MIN_VALUE.
   */
  public final static int INT_VALUE_DEFAULT = mainJNI.Solver_INT_VALUE_DEFAULT_get();
  /**
   *  The simple selection is ASSIGN_MIN_VALUE.
   */
  public final static int INT_VALUE_SIMPLE = mainJNI.Solver_INT_VALUE_SIMPLE_get();
  /**
   *  Selects the min value of the selected variable.
   */
  public final static int ASSIGN_MIN_VALUE = mainJNI.Solver_ASSIGN_MIN_VALUE_get();
  /**
   *  Selects the max value of the selected variable.
   */
  public final static int ASSIGN_MAX_VALUE = mainJNI.Solver_ASSIGN_MAX_VALUE_get();
  /**
   *  Selects randomly one of the possible values of the selected variable.
   */
  public final static int ASSIGN_RANDOM_VALUE = mainJNI.Solver_ASSIGN_RANDOM_VALUE_get();
  /**
   *  Selects the first possible value which is the closest to the center<br>
   *  of the domain of the selected variable.<br>
   *  The center is defined as (min + max) / 2.
   */
  public final static int ASSIGN_CENTER_VALUE = mainJNI.Solver_ASSIGN_CENTER_VALUE_get();
  /**
   *  Split the domain in two around the center, and choose the lower<br>
   *  part first.
   */
  public final static int SPLIT_LOWER_HALF = mainJNI.Solver_SPLIT_LOWER_HALF_get();
  /**
   *  Split the domain in two around the center, and choose the lower<br>
   *  part first.
   */
  public final static int SPLIT_UPPER_HALF = mainJNI.Solver_SPLIT_UPPER_HALF_get();

  // EvaluatorStrategy 
  /**
   *  This enum is used by Solver::MakePhase to specify how to select variables<br>
   *  and values during the search.<br>
   *  In Solver::MakePhase(const std::vector&lt;IntVar*&gt;&amp;, IntVarStrategy,<br>
   *  IntValueStrategy), variables are selected first, and then the associated<br>
   *  value.<br>
   *  In Solver::MakePhase(const std::vector&lt;IntVar*&gt;&amp; vars, IndexEvaluator2,<br>
   *  EvaluatorStrategy), the selection is done scanning every pair<br>
   *  &lt;variable, possible value&gt;. The next selected pair is then the best among<br>
   *  all possibilities, i.e. the pair with the smallest evaluation.<br>
   *  As this is costly, two options are offered: static or dynamic evaluation.
   */

  /**
   *  Pairs are compared at the first call of the selector, and results are<br>
   *  cached. Next calls to the selector use the previous computation, and so<br>
   *  are not up-to-date, e.g. some &lt;variable, value&gt; pairs may not be<br>
   *  possible anymore due to propagation since the first to call.
   */
  public final static int CHOOSE_STATIC_GLOBAL_BEST = mainJNI.Solver_CHOOSE_STATIC_GLOBAL_BEST_get();
  /**
   *  Pairs are compared each time a variable is selected. That way all pairs<br>
   *  are relevant and evaluation is accurate.<br>
   *  This strategy runs in O(number-of-pairs) at each variable selection,<br>
   *  versus O(1) in the static version.
   */
  public final static int CHOOSE_DYNAMIC_GLOBAL_BEST = mainJNI.Solver_CHOOSE_DYNAMIC_GLOBAL_BEST_get();

  // SequenceStrategy 
  /**
   *  Used for scheduling. Not yet implemented.
   */

  public final static int SEQUENCE_DEFAULT = mainJNI.Solver_SEQUENCE_DEFAULT_get();
  public final static int SEQUENCE_SIMPLE = mainJNI.Solver_SEQUENCE_SIMPLE_get();
  public final static int CHOOSE_MIN_SLACK_RANK_FORWARD = mainJNI.Solver_CHOOSE_MIN_SLACK_RANK_FORWARD_get();
  public final static int CHOOSE_RANDOM_RANK_FORWARD = mainJNI.Solver_CHOOSE_RANDOM_RANK_FORWARD_get();

  // IntervalStrategy 
  /**
   *  This enum describes the straregy used to select the next interval variable<br>
   *  and its value to be fixed.
   */

  /**
   *  The default is INTERVAL_SET_TIMES_FORWARD.
   */
  public final static int INTERVAL_DEFAULT = mainJNI.Solver_INTERVAL_DEFAULT_get();
  /**
   *  The simple is INTERVAL_SET_TIMES_FORWARD.
   */
  public final static int INTERVAL_SIMPLE = mainJNI.Solver_INTERVAL_SIMPLE_get();
  /**
   *  Selects the variable with the lowest starting time of all variables,<br>
   *  and fixes its starting time to this lowest value.
   */
  public final static int INTERVAL_SET_TIMES_FORWARD = mainJNI.Solver_INTERVAL_SET_TIMES_FORWARD_get();
  /**
   *  Selects the variable with the highest ending time of all variables,<br>
   *  and fixes the ending time to this highest values.
   */
  public final static int INTERVAL_SET_TIMES_BACKWARD = mainJNI.Solver_INTERVAL_SET_TIMES_BACKWARD_get();

  // LocalSearchOperators 
  /**
   *  This enum is used in Solver::MakeOperator to specify the neighborhood to<br>
   *  create.
   */

  /**
   *  Operator which reverses a sub-chain of a path. It is called TwoOpt<br>
   *  because it breaks two arcs on the path; resulting paths are called<br>
   *  two-optimal.<br>
   *  Possible neighbors for the path 1 -&gt; 2 -&gt; 3 -&gt; 4 -&gt; 5<br>
   *  (where (1, 5) are first and last nodes of the path and can therefore not<br>
   *  be moved):<br>
   *    1 -&gt; [3 -&gt; 2] -&gt; 4  -&gt; 5<br>
   *    1 -&gt; [4 -&gt; 3  -&gt; 2] -&gt; 5<br>
   *    1 -&gt;  2 -&gt; [4 -&gt; 3] -&gt; 5
   */
  public final static int TWOOPT = mainJNI.Solver_TWOOPT_get();
  /**
   *  Relocate: OROPT and RELOCATE.<br>
   *  Operator which moves a sub-chain of a path to another position; the<br>
   *  specified chain length is the fixed length of the chains being moved.<br>
   *  When this length is 1, the operator simply moves a node to another<br>
   *  position.<br>
   *  Possible neighbors for the path 1 -&gt; 2 -&gt; 3 -&gt; 4 -&gt; 5, for a chain<br>
   *  length of 2 (where (1, 5) are first and last nodes of the path and can<br>
   *  therefore not be moved):<br>
   *    1 -&gt;  4 -&gt; [2 -&gt; 3] -&gt; 5<br>
   *    1 -&gt; [3 -&gt; 4] -&gt; 2  -&gt; 5<br>
   * <br>
   *  Using Relocate with chain lengths of 1, 2 and 3 together is equivalent<br>
   *  to the OrOpt operator on a path. The OrOpt operator is a limited<br>
   *   version of 3Opt (breaks 3 arcs on a path).
   */
  public final static int OROPT = mainJNI.Solver_OROPT_get();
  /**
   *  Relocate neighborhood with length of 1 (see OROPT comment).
   */
  public final static int RELOCATE = mainJNI.Solver_RELOCATE_get();
  /**
   *  Operator which exchanges the positions of two nodes.<br>
   *  Possible neighbors for the path 1 -&gt; 2 -&gt; 3 -&gt; 4 -&gt; 5<br>
   *  (where (1, 5) are first and last nodes of the path and can therefore not<br>
   *  be moved):<br>
   *    1 -&gt; [3] -&gt; [2] -&gt;  4  -&gt; 5<br>
   *    1 -&gt; [4] -&gt;  3  -&gt; [2] -&gt; 5<br>
   *    1 -&gt;  2  -&gt; [4] -&gt; [3] -&gt; 5
   */
  public final static int EXCHANGE = mainJNI.Solver_EXCHANGE_get();
  /**
   *  Operator which cross exchanges the starting chains of 2 paths, including<br>
   *  exchanging the whole paths.<br>
   *  First and last nodes are not moved.<br>
   *  Possible neighbors for the paths 1 -&gt; 2 -&gt; 3 -&gt; 4 -&gt; 5 and 6 -&gt; 7 -&gt; 8<br>
   *  (where (1, 5) and (6, 8) are first and last nodes of the paths and can<br>
   *  therefore not be moved):<br>
   *    1 -&gt; [7] -&gt; 3 -&gt; 4 -&gt; 5  6 -&gt; [2] -&gt; 8<br>
   *    1 -&gt; [7] -&gt; 4 -&gt; 5       6 -&gt; [2 -&gt; 3] -&gt; 8<br>
   *    1 -&gt; [7] -&gt; 5            6 -&gt; [2 -&gt; 3 -&gt; 4] -&gt; 8
   */
  public final static int CROSS = mainJNI.Solver_CROSS_get();
  /**
   *  Operator which inserts an inactive node into a path.<br>
   *  Possible neighbors for the path 1 -&gt; 2 -&gt; 3 -&gt; 4 with 5 inactive<br>
   *  (where 1 and 4 are first and last nodes of the path) are:<br>
   *    1 -&gt; [5] -&gt;  2  -&gt;  3  -&gt; 4<br>
   *    1 -&gt;  2  -&gt; [5] -&gt;  3  -&gt; 4<br>
   *    1 -&gt;  2  -&gt;  3  -&gt; [5] -&gt; 4
   */
  public final static int MAKEACTIVE = mainJNI.Solver_MAKEACTIVE_get();
  /**
   *  Operator which makes path nodes inactive.<br>
   *  Possible neighbors for the path 1 -&gt; 2 -&gt; 3 -&gt; 4 (where 1 and 4 are<br>
   *  first and last nodes of the path) are:<br>
   *    1 -&gt; 3 -&gt; 4 with 2 inactive<br>
   *    1 -&gt; 2 -&gt; 4 with 3 inactive
   */
  public final static int MAKEINACTIVE = mainJNI.Solver_MAKEINACTIVE_get();
  /**
   *  Operator which makes a "chain" of path nodes inactive.<br>
   *  Possible neighbors for the path 1 -&gt; 2 -&gt; 3 -&gt; 4 (where 1 and 4 are<br>
   *  first and last nodes of the path) are:<br>
   *    1 -&gt; 3 -&gt; 4 with 2 inactive<br>
   *    1 -&gt; 2 -&gt; 4 with 3 inactive<br>
   *    1 -&gt; 4 with 2 and 3 inactive
   */
  public final static int MAKECHAININACTIVE = mainJNI.Solver_MAKECHAININACTIVE_get();
  /**
   *  Operator which replaces an active node by an inactive one.<br>
   *  Possible neighbors for the path 1 -&gt; 2 -&gt; 3 -&gt; 4 with 5 inactive<br>
   *  (where 1 and 4 are first and last nodes of the path) are:<br>
   *    1 -&gt; [5] -&gt;  3  -&gt; 4 with 2 inactive<br>
   *    1 -&gt;  2  -&gt; [5] -&gt; 4 with 3 inactive
   */
  public final static int SWAPACTIVE = mainJNI.Solver_SWAPACTIVE_get();
  /**
   *  Operator which makes an inactive node active and an active one inactive.<br>
   *  It is similar to SwapActiveOperator except that it tries to insert the<br>
   *  inactive node in all possible positions instead of just the position of<br>
   *  the node made inactive.<br>
   *  Possible neighbors for the path 1 -&gt; 2 -&gt; 3 -&gt; 4 with 5 inactive<br>
   *  (where 1 and 4 are first and last nodes of the path) are:<br>
   *    1 -&gt; [5] -&gt;  3  -&gt; 4 with 2 inactive<br>
   *    1 -&gt;  3  -&gt; [5] -&gt; 4 with 2 inactive<br>
   *    1 -&gt; [5] -&gt;  2  -&gt; 4 with 3 inactive<br>
   *    1 -&gt;  2  -&gt; [5] -&gt; 4 with 3 inactive
   */
  public final static int EXTENDEDSWAPACTIVE = mainJNI.Solver_EXTENDEDSWAPACTIVE_get();
  /**
   *  Operator which relaxes two sub-chains of three consecutive arcs each.<br>
   *  Each sub-chain is defined by a start node and the next three arcs. Those<br>
   *  six arcs are relaxed to build a new neighbor.<br>
   *  PATHLNS explores all possible pairs of starting nodes and so defines<br>
   *  n^2 neighbors, n being the number of nodes.<br>
   *  Note that the two sub-chains can be part of the same path; they even may<br>
   *  overlap.
   */
  public final static int PATHLNS = mainJNI.Solver_PATHLNS_get();
  /**
   *  Operator which relaxes one entire path and all inactive nodes, thus<br>
   *  defining num_paths neighbors.
   */
  public final static int FULLPATHLNS = mainJNI.Solver_FULLPATHLNS_get();
  /**
   *  Operator which relaxes all inactive nodes and one sub-chain of six<br>
   *  consecutive arcs. That way the path can be improved by inserting<br>
   *  inactive nodes or swapping arcs.
   */
  public final static int UNACTIVELNS = mainJNI.Solver_UNACTIVELNS_get();
  /**
   *  Operator which defines one neighbor per variable. Each neighbor tries to<br>
   *  increment by one the value of the corresponding variable. When a new<br>
   *  solution is found the neighborhood is rebuilt from scratch, i.e., tries<br>
   *  to increment values in the variable order.<br>
   *  Consider for instance variables x and y. x is incremented one by one to<br>
   *  its max, and when it is not possible to increment x anymore, y is<br>
   *  incremented once. If this is a solution, then next neighbor tries to<br>
   *  increment x.
   */
  public final static int INCREMENT = mainJNI.Solver_INCREMENT_get();
  /**
   *  Operator which defines a neighborhood to decrement values.<br>
   *  The behavior is the same as INCREMENT, except values are decremented<br>
   *  instead of incremented.
   */
  public final static int DECREMENT = mainJNI.Solver_DECREMENT_get();
  /**
   *  Operator which defines one neighbor per variable. Each neighbor relaxes<br>
   *  one variable.<br>
   *  When a new solution is found the neighborhood is rebuilt from scratch.<br>
   *  Consider for instance variables x and y. First x is relaxed and the<br>
   *  solver is looking for the best possible solution (with only x relaxed).<br>
   *  Then y is relaxed, and the solver is looking for a new solution.<br>
   *  If a new solution is found, then the next variable to be relaxed is x.
   */
  public final static int SIMPLELNS = mainJNI.Solver_SIMPLELNS_get();

  // EvaluatorLocalSearchOperators 
  /**
   *  This enum is used in Solver::MakeOperator associated with an evaluator<br>
   *  to specify the neighborhood to create.
   */

  /**
   *  Lin-Kernighan local search.<br>
   *  While the accumulated local gain is positive, perform a 2opt or a 3opt<br>
   *  move followed by a series of 2opt moves. Return a neighbor for which the<br>
   *  global gain is positive.
   */
  public final static int LK = mainJNI.Solver_LK_get();
  /**
   *  Sliding TSP operator.<br>
   *  Uses an exact dynamic programming algorithm to solve the TSP<br>
   *  corresponding to path sub-chains.<br>
   *  For a subchain 1 -&gt; 2 -&gt; 3 -&gt; 4 -&gt; 5 -&gt; 6, solves the TSP on<br>
   *  nodes A, 2, 3, 4, 5, where A is a merger of nodes 1 and 6 such that<br>
   *  cost(A,i) = cost(1,i) and cost(i,A) = cost(i,6).
   */
  public final static int TSPOPT = mainJNI.Solver_TSPOPT_get();
  /**
   *  TSP-base LNS.<br>
   *  Randomly merge consecutive nodes until n "meta"-nodes remain and solve<br>
   *  the corresponding TSP.<br>
   *  This is an "unlimited" neighborhood which must be stopped by search<br>
   *  limits. To force diversification, the operator iteratively forces each<br>
   *  node to serve as base of a meta-node.
   */
  public final static int TSPLNS = mainJNI.Solver_TSPLNS_get();

  // LocalSearchFilterBound 
  /**
   *  This enum is used in Solver::MakeLocalSearchObjectiveFilter. It specifies<br>
   *  the behavior of the objective filter to create. The goal is to define<br>
   *  under which condition a move is accepted based on the current objective<br>
   *  value.
   */

  /**
   *  Move is accepted when the current objective value &gt;= objective.Min.
   */
  public final static int GE = mainJNI.Solver_GE_get();
  /**
   *  Move is accepted when the current objective value &lt;= objective.Max.
   */
  public final static int LE = mainJNI.Solver_LE_get();
  /**
   *  Move is accepted when the current objective value is in the interval<br>
   *  objective.Min .. objective.Max.
   */
  public final static int EQ = mainJNI.Solver_EQ_get();

  // DemonPriority 
  /**
   *  This enum represents the three possible priorities for a demon in the<br>
   *  Solver queue.<br>
   *  Note: this is for advanced users only.
   */

  /**
   *  DELAYED_PRIORITY is the lowest priority: Demons will be processed after<br>
   *  VAR_PRIORITY and NORMAL_PRIORITY demons.
   */
  public final static int DELAYED_PRIORITY = mainJNI.Solver_DELAYED_PRIORITY_get();
  /**
   *  VAR_PRIORITY is between DELAYED_PRIORITY and NORMAL_PRIORITY.
   */
  public final static int VAR_PRIORITY = mainJNI.Solver_VAR_PRIORITY_get();
  /**
   *  NORMAL_PRIORITY is the highest priority: Demons will be processed first.
   */
  public final static int NORMAL_PRIORITY = mainJNI.Solver_NORMAL_PRIORITY_get();

  // BinaryIntervalRelation 
  /**
   *  This enum is used in Solver::MakeIntervalVarRelation to specify the<br>
   *  temporal relation between the two intervals t1 and t2.
   */

  /**
   *  t1 ends after t2 end, i.e. End(t1) &gt;= End(t2) + delay.
   */
  public final static int ENDS_AFTER_END = mainJNI.Solver_ENDS_AFTER_END_get();
  /**
   *  t1 ends after t2 start, i.e. End(t1) &gt;= Start(t2) + delay.
   */
  public final static int ENDS_AFTER_START = mainJNI.Solver_ENDS_AFTER_START_get();
  /**
   *  t1 ends at t2 end, i.e. End(t1) == End(t2) + delay.
   */
  public final static int ENDS_AT_END = mainJNI.Solver_ENDS_AT_END_get();
  /**
   *  t1 ends at t2 start, i.e. End(t1) == Start(t2) + delay.
   */
  public final static int ENDS_AT_START = mainJNI.Solver_ENDS_AT_START_get();
  /**
   *  t1 starts after t2 end, i.e. Start(t1) &gt;= End(t2) + delay.
   */
  public final static int STARTS_AFTER_END = mainJNI.Solver_STARTS_AFTER_END_get();
  /**
   *  t1 starts after t2 start, i.e. Start(t1) &gt;= Start(t2) + delay.
   */
  public final static int STARTS_AFTER_START = mainJNI.Solver_STARTS_AFTER_START_get();
  /**
   *  t1 starts at t2 end, i.e. Start(t1) == End(t2) + delay.
   */
  public final static int STARTS_AT_END = mainJNI.Solver_STARTS_AT_END_get();
  /**
   *  t1 starts at t2 start, i.e. Start(t1) == Start(t2) + delay.
   */
  public final static int STARTS_AT_START = mainJNI.Solver_STARTS_AT_START_get();
  /**
   *  STARTS_AT_START and ENDS_AT_END at the same time.<br>
   *  t1 starts at t2 start, i.e. Start(t1) == Start(t2) + delay.<br>
   *  t1 ends at t2 end, i.e. End(t1) == End(t2).
   */
  public final static int STAYS_IN_SYNC = mainJNI.Solver_STAYS_IN_SYNC_get();

  // UnaryIntervalRelation 
  /**
   *  This enum is used in Solver::MakeIntervalVarRelation to specify the<br>
   *  temporal relation between an interval t and an integer d.
   */

  /**
   *  t ends after d, i.e. End(t) &gt;= d.
   */
  public final static int ENDS_AFTER = mainJNI.Solver_ENDS_AFTER_get();
  /**
   *  t ends at d, i.e. End(t) == d.
   */
  public final static int ENDS_AT = mainJNI.Solver_ENDS_AT_get();
  /**
   *  t ends before d, i.e. End(t) &lt;= d.
   */
  public final static int ENDS_BEFORE = mainJNI.Solver_ENDS_BEFORE_get();
  /**
   *  t starts after d, i.e. Start(t) &gt;= d.
   */
  public final static int STARTS_AFTER = mainJNI.Solver_STARTS_AFTER_get();
  /**
   *  t starts at d, i.e. Start(t) == d.
   */
  public final static int STARTS_AT = mainJNI.Solver_STARTS_AT_get();
  /**
   *  t starts before d, i.e. Start(t) &lt;= d.
   */
  public final static int STARTS_BEFORE = mainJNI.Solver_STARTS_BEFORE_get();
  /**
   *  STARTS_BEFORE and ENDS_AFTER at the same time, i.e. d is in t.<br>
   *  t starts before d, i.e. Start(t) &lt;= d.<br>
   *  t ends after d, i.e. End(t) &gt;= d.
   */
  public final static int CROSS_DATE = mainJNI.Solver_CROSS_DATE_get();
  /**
   *  STARTS_AFTER or ENDS_BEFORE, i.e. d is not in t.<br>
   *  t starts after d, i.e. Start(t) &gt;= d.<br>
   *  t ends before d, i.e. End(t) &lt;= d.
   */
  public final static int AVOID_DATE = mainJNI.Solver_AVOID_DATE_get();

  // DecisionModification 
  /**
   *  The Solver is responsible for creating the search tree. Thanks to the<br>
   *  DecisionBuilder, it creates a new decision with two branches at each node:<br>
   *  left and right.<br>
   *  The DecisionModification enum is used to specify how the branch selector<br>
   *  should behave.
   */

  /**
   *  Keeps the default behavior, i.e. apply left branch first, and then right<br>
   *  branch in case of backtracking.
   */
  public final static int NO_CHANGE = mainJNI.Solver_NO_CHANGE_get();
  /**
   *  Right branches are ignored. This is used to make the code faster when<br>
   *  backtrack makes no sense or is not useful.<br>
   *  This is faster as there is no need to create one new node per decision.
   */
  public final static int KEEP_LEFT = mainJNI.Solver_KEEP_LEFT_get();
  /**
   *  Left branches are ignored. This is used to make the code faster when<br>
   *  backtrack makes no sense or is not useful.<br>
   *  This is faster as there is no need to create one new node per decision.
   */
  public final static int KEEP_RIGHT = mainJNI.Solver_KEEP_RIGHT_get();
  /**
   *  Backtracks to the previous decisions, i.e. left and right branches are<br>
   *  not applied.
   */
  public final static int KILL_BOTH = mainJNI.Solver_KILL_BOTH_get();
  /**
   *  Applies right branch first. Left branch will be applied in case of<br>
   *  backtracking.
   */
  public final static int SWITCH_BRANCHES = mainJNI.Solver_SWITCH_BRANCHES_get();

  // MarkerType 
  /**
   *  This enum is used internally in private methods Solver::PushState and<br>
   *  Solver::PopState to tag states in the search tree.
   */

  public final static int SENTINEL = mainJNI.Solver_SENTINEL_get();
  public final static int SIMPLE_MARKER = mainJNI.Solver_SIMPLE_MARKER_get();
  public final static int CHOICE_POINT = mainJNI.Solver_CHOICE_POINT_get();
  public final static int REVERSIBLE_ACTION = mainJNI.Solver_REVERSIBLE_ACTION_get();

  // SolverState 
  /**
   *  This enum represents the state of the solver w.r.t. the search.
   */

  /**
   *  Before search, after search.
   */
  public final static int OUTSIDE_SEARCH = mainJNI.Solver_OUTSIDE_SEARCH_get();
  /**
   *  Executing the root node.
   */
  public final static int IN_ROOT_NODE = mainJNI.Solver_IN_ROOT_NODE_get();
  /**
   *  Executing the search code.
   */
  public final static int IN_SEARCH = mainJNI.Solver_IN_SEARCH_get();
  /**
   *  After successful NextSolution and before EndSearch.
   */
  public final static int AT_SOLUTION = mainJNI.Solver_AT_SOLUTION_get();
  /**
   *  After failed NextSolution and before EndSearch.
   */
  public final static int NO_MORE_SOLUTIONS = mainJNI.Solver_NO_MORE_SOLUTIONS_get();
  /**
   *  After search, the model is infeasible.
   */
  public final static int PROBLEM_INFEASIBLE = mainJNI.Solver_PROBLEM_INFEASIBLE_get();

  // OptimizationDirection 
  /**
   *  Optimization directions.
   */

  public final static int NOT_SET = mainJNI.Solver_NOT_SET_get();
  public final static int MAXIMIZATION = mainJNI.Solver_MAXIMIZATION_get();
  public final static int MINIMIZATION = mainJNI.Solver_MINIMIZATION_get();

}
