// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: ortools/sat/sat_parameters.proto

package com.google.ortools.sat;

/**
 * <pre>
 * Contains the definitions for all the sat algorithm parameters and their
 * default values.
 * NEXT TAG: 194
 * </pre>
 *
 * Protobuf type {@code operations_research.sat.SatParameters}
 */
public final class SatParameters extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:operations_research.sat.SatParameters)
    SatParametersOrBuilder {
private static final long serialVersionUID = 0L;
  // Use SatParameters.newBuilder() to construct.
  private SatParameters(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private SatParameters() {
    name_ = "";
    preferredVariableOrder_ = 0;
    initialPolarity_ = 1;
    usePhaseSaving_ = true;
    polarityRephaseIncrement_ = 1000;
    minimizationAlgorithm_ = 2;
    binaryMinimizationAlgorithm_ = 1;
    subsumptionDuringConflictAnalysis_ = true;
    clauseCleanupPeriod_ = 10000;
    clauseCleanupRatio_ = 0.5D;
    clauseCleanupProtection_ = 0;
    clauseCleanupLbdBound_ = 5;
    clauseCleanupOrdering_ = 0;
    pbCleanupIncrement_ = 200;
    pbCleanupRatio_ = 0.5D;
    minimizeWithPropagationRestartPeriod_ = 10;
    minimizeWithPropagationNumDecisions_ = 1000;
    variableActivityDecay_ = 0.8D;
    maxVariableActivityValue_ = 1e+100D;
    glucoseMaxDecay_ = 0.95D;
    glucoseDecayIncrement_ = 0.01D;
    glucoseDecayIncrementPeriod_ = 5000;
    clauseActivityDecay_ = 0.999D;
    maxClauseActivityValue_ = 1e+20D;
    restartAlgorithms_ = java.util.Collections.emptyList();
    defaultRestartAlgorithms_ = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART";
    restartPeriod_ = 50;
    restartRunningWindowSize_ = 50;
    restartDlAverageRatio_ = 1D;
    restartLbdAverageRatio_ = 1D;
    blockingRestartWindowSize_ = 5000;
    blockingRestartMultiplier_ = 1.4D;
    maxTimeInSeconds_ = Double.POSITIVE_INFINITY;
    maxDeterministicTime_ = Double.POSITIVE_INFINITY;
    maxNumberOfConflicts_ = 9223372036854775807L;
    maxMemoryInMb_ = 10000L;
    treatBinaryClausesSeparately_ = true;
    randomSeed_ = 1;
    logSubsolverStatistics_ = true;
    logPrefix_ = "";
    logToStdout_ = true;
    countAssumptionLevelsInLbd_ = true;
    presolveBveThreshold_ = 500;
    presolveBveClauseWeight_ = 3;
    presolveProbingDeterministicTimeLimit_ = 30D;
    presolveBlockedClause_ = true;
    presolveUseBva_ = true;
    presolveBvaThreshold_ = 1;
    maxPresolveIterations_ = 3;
    cpModelPresolve_ = true;
    cpModelProbingLevel_ = 2;
    cpModelUseSatPresolve_ = true;
    expandElementConstraints_ = true;
    expandAutomatonConstraints_ = true;
    expandTableConstraints_ = true;
    expandReservoirConstraints_ = true;
    mergeNoOverlapWorkLimit_ = 1000000000000D;
    mergeAtMostOneWorkLimit_ = 100000000D;
    presolveSubstitutionLevel_ = 1;
    useOptimizationHints_ = true;
    minimizeCore_ = true;
    findMultipleCores_ = true;
    coverOptimization_ = true;
    maxSatAssumptionOrder_ = 0;
    maxSatStratification_ = 1;
    usePrecedencesInDisjunctiveConstraint_ = true;
    useDisjunctiveConstraintInCumulativeConstraint_ = true;
    linearizationLevel_ = 1;
    booleanEncodingLevel_ = 1;
    maxDomainSizeWhenEncodingEqNeqConstraints_ = 16;
    maxNumCuts_ = 10000;
    addCgCuts_ = true;
    addMirCuts_ = true;
    addZeroHalfCuts_ = true;
    addCliqueCuts_ = true;
    maxAllDiffCutSize_ = 7;
    addLinMaxCuts_ = true;
    maxIntegerRoundingScaling_ = 600;
    addLpConstraintsLazily_ = true;
    minOrthogonalityForLpConstraints_ = 0.05D;
    maxCutRoundsAtLevelZero_ = 1;
    maxConsecutiveInactiveCount_ = 100;
    cutMaxActiveCountValue_ = 10000000000D;
    cutActiveCountDecay_ = 0.8D;
    cutCleanupTarget_ = 1000;
    newConstraintsBatchSize_ = 50;
    searchBranching_ = 0;
    hintConflictLimit_ = 10;
    exploitIntegerLpSolution_ = true;
    exploitAllLpSolution_ = true;
    exploitObjective_ = true;
    pseudoCostReliabilityThreshold_ = 100L;
    binarySearchNumConflicts_ = -1;
    instantiateAllVariables_ = true;
    autoDetectGreaterThanAtLeastOneOf_ = true;
    interleaveBatchSize_ = 1;
    shareObjectiveBounds_ = true;
    shareLevelZeroBounds_ = true;
    lnsExpandIntervalsInConstraintGraph_ = true;
    solutionPoolSize_ = 3;
    useRinsLns_ = true;
    useFeasibilityPump_ = true;
    fpRounding_ = 2;
    useOptionalVariables_ = true;
    useExactLpReason_ = true;
    catchSigintSignal_ = true;
    useImpliedBounds_ = true;
    convertIntervals_ = true;
    symmetryLevel_ = 2;
    mipMaxBound_ = 10000000D;
    mipVarScaling_ = 1D;
    mipAutomaticallyScaleVariables_ = true;
    mipWantedPrecision_ = 1e-06D;
    mipMaxActivityExponent_ = 53;
    mipCheckPrecision_ = 0.0001D;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new SatParameters();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private SatParameters(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    int mutable_bitField1_ = 0;
    int mutable_bitField2_ = 0;
    int mutable_bitField3_ = 0;
    int mutable_bitField4_ = 0;
    int mutable_bitField5_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8: {
            int rawValue = input.readEnum();
              @SuppressWarnings("deprecation")
            com.google.ortools.sat.SatParameters.VariableOrder value = com.google.ortools.sat.SatParameters.VariableOrder.valueOf(rawValue);
            if (value == null) {
              unknownFields.mergeVarintField(1, rawValue);
            } else {
              bitField0_ |= 0x00000002;
              preferredVariableOrder_ = rawValue;
            }
            break;
          }
          case 16: {
            int rawValue = input.readEnum();
              @SuppressWarnings("deprecation")
            com.google.ortools.sat.SatParameters.Polarity value = com.google.ortools.sat.SatParameters.Polarity.valueOf(rawValue);
            if (value == null) {
              unknownFields.mergeVarintField(2, rawValue);
            } else {
              bitField0_ |= 0x00000004;
              initialPolarity_ = rawValue;
            }
            break;
          }
          case 32: {
            int rawValue = input.readEnum();
              @SuppressWarnings("deprecation")
            com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm value = com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm.valueOf(rawValue);
            if (value == null) {
              unknownFields.mergeVarintField(4, rawValue);
            } else {
              bitField0_ |= 0x00000400;
              minimizationAlgorithm_ = rawValue;
            }
            break;
          }
          case 88: {
            bitField0_ |= 0x00002000;
            clauseCleanupPeriod_ = input.readInt32();
            break;
          }
          case 104: {
            bitField0_ |= 0x00004000;
            clauseCleanupTarget_ = input.readInt32();
            break;
          }
          case 121: {
            bitField0_ |= 0x00800000;
            variableActivityDecay_ = input.readDouble();
            break;
          }
          case 129: {
            bitField0_ |= 0x01000000;
            maxVariableActivityValue_ = input.readDouble();
            break;
          }
          case 137: {
            bitField0_ |= 0x10000000;
            clauseActivityDecay_ = input.readDouble();
            break;
          }
          case 145: {
            bitField0_ |= 0x20000000;
            maxClauseActivityValue_ = input.readDouble();
            break;
          }
          case 177: {
            bitField0_ |= 0x02000000;
            glucoseMaxDecay_ = input.readDouble();
            break;
          }
          case 185: {
            bitField0_ |= 0x04000000;
            glucoseDecayIncrement_ = input.readDouble();
            break;
          }
          case 192: {
            bitField0_ |= 0x08000000;
            glucoseDecayIncrementPeriod_ = input.readInt32();
            break;
          }
          case 240: {
            bitField0_ |= 0x80000000;
            restartPeriod_ = input.readInt32();
            break;
          }
          case 248: {
            bitField1_ |= 0x00008000;
            randomSeed_ = input.readInt32();
            break;
          }
          case 257: {
            bitField0_ |= 0x00000040;
            randomBranchesRatio_ = input.readDouble();
            break;
          }
          case 264: {
            bitField1_ |= 0x00004000;
            treatBinaryClausesSeparately_ = input.readBool();
            break;
          }
          case 272: {
            int rawValue = input.readEnum();
              @SuppressWarnings("deprecation")
            com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm value = com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm.valueOf(rawValue);
            if (value == null) {
              unknownFields.mergeVarintField(34, rawValue);
            } else {
              bitField0_ |= 0x00000800;
              binaryMinimizationAlgorithm_ = rawValue;
            }
            break;
          }
          case 280: {
            bitField2_ |= 0x00040000;
            useOptimizationHints_ = input.readBool();
            break;
          }
          case 289: {
            bitField1_ |= 0x00000100;
            maxTimeInSeconds_ = input.readDouble();
            break;
          }
          case 296: {
            bitField1_ |= 0x00000400;
            maxNumberOfConflicts_ = input.readInt64();
            break;
          }
          case 320: {
            bitField1_ |= 0x00000800;
            maxMemoryInMb_ = input.readInt64();
            break;
          }
          case 328: {
            bitField1_ |= 0x00080000;
            logSearchProgress_ = input.readBool();
            break;
          }
          case 344: {
            bitField1_ |= 0x01000000;
            usePbResolution_ = input.readBool();
            break;
          }
          case 352: {
            bitField0_ |= 0x00000008;
            usePhaseSaving_ = input.readBool();
            break;
          }
          case 361: {
            bitField0_ |= 0x00000020;
            randomPolarityRatio_ = input.readDouble();
            break;
          }
          case 368: {
            bitField0_ |= 0x00080000;
            pbCleanupIncrement_ = input.readInt32();
            break;
          }
          case 377: {
            bitField0_ |= 0x00100000;
            pbCleanupRatio_ = input.readDouble();
            break;
          }
          case 384: {
            bitField1_ |= 0x02000000;
            minimizeReductionDuringPbResolution_ = input.readBool();
            break;
          }
          case 392: {
            bitField1_ |= 0x04000000;
            countAssumptionLevelsInLbd_ = input.readBool();
            break;
          }
          case 400: {
            bitField2_ |= 0x00080000;
            minimizeCore_ = input.readBool();
            break;
          }
          case 408: {
            int rawValue = input.readEnum();
              @SuppressWarnings("deprecation")
            com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder value = com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder.valueOf(rawValue);
            if (value == null) {
              unknownFields.mergeVarintField(51, rawValue);
            } else {
              bitField2_ |= 0x00400000;
              maxSatAssumptionOrder_ = rawValue;
            }
            break;
          }
          case 416: {
            bitField2_ |= 0x00800000;
            maxSatReverseAssumptionOrder_ = input.readBool();
            break;
          }
          case 424: {
            int rawValue = input.readEnum();
              @SuppressWarnings("deprecation")
            com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm value = com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm.valueOf(rawValue);
            if (value == null) {
              unknownFields.mergeVarintField(53, rawValue);
            } else {
              bitField2_ |= 0x01000000;
              maxSatStratification_ = rawValue;
            }
            break;
          }
          case 432: {
            bitField1_ |= 0x08000000;
            presolveBveThreshold_ = input.readInt32();
            break;
          }
          case 440: {
            bitField1_ |= 0x10000000;
            presolveBveClauseWeight_ = input.readInt32();
            break;
          }
          case 448: {
            bitField0_ |= 0x00001000;
            subsumptionDuringConflictAnalysis_ = input.readBool();
            break;
          }
          case 457: {
            bitField1_ |= 0x20000000;
            presolveProbingDeterministicTimeLimit_ = input.readDouble();
            break;
          }
          case 464: {
            int rawValue = input.readEnum();
              @SuppressWarnings("deprecation")
            com.google.ortools.sat.SatParameters.ClauseProtection value = com.google.ortools.sat.SatParameters.ClauseProtection.valueOf(rawValue);
            if (value == null) {
              unknownFields.mergeVarintField(58, rawValue);
            } else {
              bitField0_ |= 0x00010000;
              clauseCleanupProtection_ = rawValue;
            }
            break;
          }
          case 472: {
            bitField0_ |= 0x00020000;
            clauseCleanupLbdBound_ = input.readInt32();
            break;
          }
          case 480: {
            int rawValue = input.readEnum();
              @SuppressWarnings("deprecation")
            com.google.ortools.sat.SatParameters.ClauseOrdering value = com.google.ortools.sat.SatParameters.ClauseOrdering.valueOf(rawValue);
            if (value == null) {
              unknownFields.mergeVarintField(60, rawValue);
            } else {
              bitField0_ |= 0x00040000;
              clauseCleanupOrdering_ = rawValue;
            }
            break;
          }
          case 488: {
            int rawValue = input.readEnum();
            @SuppressWarnings("deprecation")
            com.google.ortools.sat.SatParameters.RestartAlgorithm value = com.google.ortools.sat.SatParameters.RestartAlgorithm.valueOf(rawValue);
            if (value == null) {
              unknownFields.mergeVarintField(61, rawValue);
            } else {
              if (!((mutable_bitField0_ & 0x40000000) != 0)) {
                restartAlgorithms_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x40000000;
              }
              restartAlgorithms_.add(rawValue);
            }
            break;
          }
          case 490: {
            int length = input.readRawVarint32();
            int oldLimit = input.pushLimit(length);
            while(input.getBytesUntilLimit() > 0) {
              int rawValue = input.readEnum();
              @SuppressWarnings("deprecation")
              com.google.ortools.sat.SatParameters.RestartAlgorithm value = com.google.ortools.sat.SatParameters.RestartAlgorithm.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(61, rawValue);
              } else {
                if (!((mutable_bitField0_ & 0x40000000) != 0)) {
                  restartAlgorithms_ = new java.util.ArrayList<java.lang.Integer>();
                  mutable_bitField0_ |= 0x40000000;
                }
                restartAlgorithms_.add(rawValue);
              }
            }
            input.popLimit(oldLimit);
            break;
          }
          case 496: {
            bitField1_ |= 0x00000001;
            restartRunningWindowSize_ = input.readInt32();
            break;
          }
          case 505: {
            bitField1_ |= 0x00000002;
            restartDlAverageRatio_ = input.readDouble();
            break;
          }
          case 512: {
            bitField1_ |= 0x00000008;
            useBlockingRestart_ = input.readBool();
            break;
          }
          case 520: {
            bitField1_ |= 0x00000010;
            blockingRestartWindowSize_ = input.readInt32();
            break;
          }
          case 529: {
            bitField1_ |= 0x00000020;
            blockingRestartMultiplier_ = input.readDouble();
            break;
          }
          case 537: {
            bitField1_ |= 0x00000200;
            maxDeterministicTime_ = input.readDouble();
            break;
          }
          case 544: {
            bitField1_ |= 0x00000040;
            numConflictsBeforeStrategyChanges_ = input.readInt32();
            break;
          }
          case 553: {
            bitField1_ |= 0x00000080;
            strategyChangeIncreaseRatio_ = input.readDouble();
            break;
          }
          case 562: {
            com.google.protobuf.ByteString bs = input.readBytes();
            bitField0_ |= 0x40000000;
            defaultRestartAlgorithms_ = bs;
            break;
          }
          case 569: {
            bitField1_ |= 0x00000004;
            restartLbdAverageRatio_ = input.readDouble();
            break;
          }
          case 576: {
            bitField1_ |= 0x80000000;
            presolveUseBva_ = input.readBool();
            break;
          }
          case 584: {
            bitField2_ |= 0x00000001;
            presolveBvaThreshold_ = input.readInt32();
            break;
          }
          case 592: {
            bitField2_ |= 0x02000000;
            usePrecedencesInDisjunctiveConstraint_ = input.readBool();
            break;
          }
          case 600: {
            bitField0_ |= 0x00000080;
            useErwaHeuristic_ = input.readBool();
            break;
          }
          case 609: {
            bitField0_ |= 0x00000100;
            initialVariablesActivity_ = input.readDouble();
            break;
          }
          case 616: {
            bitField0_ |= 0x00000200;
            alsoBumpVariablesInConflictReasons_ = input.readBool();
            break;
          }
          case 624: {
            bitField2_ |= 0x04000000;
            useOverloadCheckerInCumulativeConstraint_ = input.readBool();
            break;
          }
          case 632: {
            bitField2_ |= 0x08000000;
            useTimetableEdgeFindingInCumulativeConstraint_ = input.readBool();
            break;
          }
          case 640: {
            bitField2_ |= 0x10000000;
            useDisjunctiveConstraintInCumulativeConstraint_ = input.readBool();
            break;
          }
          case 656: {
            int rawValue = input.readEnum();
              @SuppressWarnings("deprecation")
            com.google.ortools.sat.SatParameters.SearchBranching value = com.google.ortools.sat.SatParameters.SearchBranching.valueOf(rawValue);
            if (value == null) {
              unknownFields.mergeVarintField(82, rawValue);
            } else {
              bitField3_ |= 0x00040000;
              searchBranching_ = rawValue;
            }
            break;
          }
          case 664: {
            bitField3_ |= 0x40000000;
            optimizeWithCore_ = input.readBool();
            break;
          }
          case 672: {
            bitField2_ |= 0x00100000;
            findMultipleCores_ = input.readBool();
            break;
          }
          case 680: {
            bitField4_ |= 0x00000002;
            optimizeWithMaxHs_ = input.readBool();
            break;
          }
          case 688: {
            bitField2_ |= 0x00000004;
            cpModelPresolve_ = input.readBool();
            break;
          }
          case 696: {
            bitField4_ |= 0x00000004;
            enumerateAllSolutions_ = input.readBool();
            break;
          }
          case 704: {
            bitField1_ |= 0x40000000;
            presolveBlockedClause_ = input.readBool();
            break;
          }
          case 712: {
            bitField2_ |= 0x00200000;
            coverOptimization_ = input.readBool();
            break;
          }
          case 720: {
            bitField2_ |= 0x20000000;
            linearizationLevel_ = input.readInt32();
            break;
          }
          case 728: {
            bitField3_ |= 0x00000001;
            maxNumCuts_ = input.readInt32();
            break;
          }
          case 736: {
            bitField3_ |= 0x00000002;
            onlyAddCutsAtLevelZero_ = input.readBool();
            break;
          }
          case 744: {
            bitField2_ |= 0x00000040;
            cpModelUseSatPresolve_ = input.readBool();
            break;
          }
          case 752: {
            bitField3_ |= 0x00400000;
            exploitIntegerLpSolution_ = input.readBool();
            break;
          }
          case 760: {
            bitField4_ |= 0x00000040;
            autoDetectGreaterThanAtLeastOneOf_ = input.readBool();
            break;
          }
          case 768: {
            bitField0_ |= 0x00200000;
            minimizeWithPropagationRestartPeriod_ = input.readInt32();
            break;
          }
          case 776: {
            bitField0_ |= 0x00400000;
            minimizeWithPropagationNumDecisions_ = input.readInt32();
            break;
          }
          case 784: {
            bitField4_ |= 0x00000080;
            stopAfterFirstSolution_ = input.readBool();
            break;
          }
          case 792: {
            bitField4_ |= 0x00000001;
            binarySearchNumConflicts_ = input.readInt32();
            break;
          }
          case 800: {
            bitField4_ |= 0x00000200;
            numSearchWorkers_ = input.readInt32();
            break;
          }
          case 808: {
            bitField4_ |= 0x00008000;
            useLnsOnly_ = input.readBool();
            break;
          }
          case 824: {
            bitField4_ |= 0x01000000;
            randomizeSearch_ = input.readBool();
            break;
          }
          case 832: {
            bitField4_ |= 0x02000000;
            searchRandomizationTolerance_ = input.readInt64();
            break;
          }
          case 840: {
            bitField4_ |= 0x00010000;
            lnsFocusOnDecisionVariables_ = input.readBool();
            break;
          }
          case 848: {
            bitField4_ |= 0x00000020;
            instantiateAllVariables_ = input.readBool();
            break;
          }
          case 856: {
            bitField2_ |= 0x40000000;
            booleanEncodingLevel_ = input.readInt32();
            break;
          }
          case 864: {
            bitField4_ |= 0x04000000;
            useOptionalVariables_ = input.readBool();
            break;
          }
          case 872: {
            bitField4_ |= 0x08000000;
            useExactLpReason_ = input.readBool();
            break;
          }
          case 880: {
            bitField2_ |= 0x00000020;
            cpModelProbingLevel_ = input.readInt32();
            break;
          }
          case 888: {
            bitField3_ |= 0x00000004;
            addKnapsackCuts_ = input.readBool();
            break;
          }
          case 896: {
            bitField3_ |= 0x00000400;
            addLpConstraintsLazily_ = input.readBool();
            break;
          }
          case 904: {
            bitField4_ |= 0x00002000;
            shareObjectiveBounds_ = input.readBool();
            break;
          }
          case 912: {
            bitField4_ |= 0x00004000;
            shareLevelZeroBounds_ = input.readBool();
            break;
          }
          case 921: {
            bitField3_ |= 0x00000800;
            minOrthogonalityForLpConstraints_ = input.readDouble();
            break;
          }
          case 928: {
            bitField3_ |= 0x00800000;
            exploitAllLpSolution_ = input.readBool();
            break;
          }
          case 936: {
            bitField3_ |= 0x00000008;
            addCgCuts_ = input.readBool();
            break;
          }
          case 952: {
            bitField3_ |= 0x00000200;
            maxIntegerRoundingScaling_ = input.readInt32();
            break;
          }
          case 960: {
            bitField3_ |= 0x00000010;
            addMirCuts_ = input.readBool();
            break;
          }
          case 968: {
            bitField3_ |= 0x00002000;
            maxConsecutiveInactiveCount_ = input.readInt32();
            break;
          }
          case 976: {
            bitField3_ |= 0x00020000;
            newConstraintsBatchSize_ = input.readInt32();
            break;
          }
          case 984: {
            bitField3_ |= 0x20000000;
            pseudoCostReliabilityThreshold_ = input.readInt64();
            break;
          }
          case 993: {
            bitField5_ |= 0x00000008;
            mipMaxBound_ = input.readDouble();
            break;
          }
          case 1001: {
            bitField5_ |= 0x00000010;
            mipVarScaling_ = input.readDouble();
            break;
          }
          case 1009: {
            bitField5_ |= 0x00000040;
            mipWantedPrecision_ = input.readDouble();
            break;
          }
          case 1016: {
            bitField5_ |= 0x00000080;
            mipMaxActivityExponent_ = input.readInt32();
            break;
          }
          case 1025: {
            bitField5_ |= 0x00000100;
            mipCheckPrecision_ = input.readDouble();
            break;
          }
          case 1032: {
            bitField4_ |= 0x00080000;
            useRinsLns_ = input.readBool();
            break;
          }
          case 1040: {
            bitField3_ |= 0x01000000;
            exploitBestSolution_ = input.readBool();
            break;
          }
          case 1048: {
            bitField3_ |= 0x04000000;
            exploitObjective_ = input.readBool();
            break;
          }
          case 1056: {
            bitField4_ |= 0x00000010;
            fillTightenedDomainsInResponse_ = input.readBool();
            break;
          }
          case 1064: {
            bitField4_ |= 0x20000000;
            useCombinedNoOverlap_ = input.readBool();
            break;
          }
          case 1072: {
            bitField4_ |= 0x00000800;
            interleaveBatchSize_ = input.readInt32();
            break;
          }
          case 1080: {
            bitField4_ |= 0x40000000;
            catchSigintSignal_ = input.readBool();
            break;
          }
          case 1088: {
            bitField4_ |= 0x00000400;
            interleaveSearch_ = input.readBool();
            break;
          }
          case 1096: {
            bitField4_ |= 0x00800000;
            diversifyLnsParams_ = input.readBool();
            break;
          }
          case 1104: {
            bitField2_ |= 0x00000002;
            maxPresolveIterations_ = input.readInt32();
            break;
          }
          case 1112: {
            bitField4_ |= 0x10000000;
            useBranchingInLp_ = input.readBool();
            break;
          }
          case 1120: {
            bitField2_ |= 0x00000100;
            expandElementConstraints_ = input.readBool();
            break;
          }
          case 1128: {
            bitField4_ |= 0x00001000;
            reduceMemoryUsageInInterleaveMode_ = input.readBool();
            break;
          }
          case 1136: {
            bitField3_ |= 0x08000000;
            probingPeriodAtRoot_ = input.readInt64();
            break;
          }
          case 1144: {
            bitField2_ |= 0x00000200;
            expandAutomatonConstraints_ = input.readBool();
            break;
          }
          case 1152: {
            bitField4_ |= 0x80000000;
            useImpliedBounds_ = input.readBool();
            break;
          }
          case 1161: {
            bitField2_ |= 0x00004000;
            mergeNoOverlapWorkLimit_ = input.readDouble();
            break;
          }
          case 1169: {
            bitField2_ |= 0x00008000;
            mergeAtMostOneWorkLimit_ = input.readDouble();
            break;
          }
          case 1176: {
            bitField2_ |= 0x00010000;
            presolveSubstitutionLevel_ = input.readInt32();
            break;
          }
          case 1184: {
            bitField3_ |= 0x00000080;
            maxAllDiffCutSize_ = input.readInt32();
            break;
          }
          case 1192: {
            bitField4_ |= 0x00000100;
            stopAfterPresolve_ = input.readBool();
            break;
          }
          case 1200: {
            bitField4_ |= 0x00400000;
            useRelaxationLns_ = input.readBool();
            break;
          }
          case 1208: {
            bitField2_ |= 0x00000010;
            cpModelMaxNumPresolveOperations_ = input.readInt32();
            break;
          }
          case 1216: {
            bitField3_ |= 0x00000100;
            addLinMaxCuts_ = input.readBool();
            break;
          }
          case 1224: {
            bitField3_ |= 0x00080000;
            hintConflictLimit_ = input.readInt32();
            break;
          }
          case 1232: {
            bitField3_ |= 0x00001000;
            maxCutRoundsAtLevelZero_ = input.readInt32();
            break;
          }
          case 1241: {
            bitField3_ |= 0x00004000;
            cutMaxActiveCountValue_ = input.readDouble();
            break;
          }
          case 1249: {
            bitField3_ |= 0x00008000;
            cutActiveCountDecay_ = input.readDouble();
            break;
          }
          case 1256: {
            bitField3_ |= 0x00010000;
            cutCleanupTarget_ = input.readInt32();
            break;
          }
          case 1264: {
            bitField2_ |= 0x00000400;
            expandTableConstraints_ = input.readBool();
            break;
          }
          case 1273: {
            bitField1_ |= 0x00001000;
            absoluteGapLimit_ = input.readDouble();
            break;
          }
          case 1281: {
            bitField1_ |= 0x00002000;
            relativeGapLimit_ = input.readDouble();
            break;
          }
          case 1288: {
            bitField3_ |= 0x02000000;
            exploitRelaxationSolution_ = input.readBool();
            break;
          }
          case 1296: {
            bitField2_ |= 0x00000008;
            cpModelPostsolveWithFullSolver_ = input.readBool();
            break;
          }
          case 1304: {
            bitField2_ |= 0x00000080;
            useSatInprocessing_ = input.readBool();
            break;
          }
          case 1312: {
            bitField4_ |= 0x00100000;
            useFeasibilityPump_ = input.readBool();
            break;
          }
          case 1320: {
            int rawValue = input.readEnum();
              @SuppressWarnings("deprecation")
            com.google.ortools.sat.SatParameters.FPRoundingMethod value = com.google.ortools.sat.SatParameters.FPRoundingMethod.valueOf(rawValue);
            if (value == null) {
              unknownFields.mergeVarintField(165, rawValue);
            } else {
              bitField4_ |= 0x00200000;
              fpRounding_ = rawValue;
            }
            break;
          }
          case 1328: {
            bitField5_ |= 0x00000020;
            mipAutomaticallyScaleVariables_ = input.readBool();
            break;
          }
          case 1336: {
            bitField3_ |= 0x00100000;
            repairHint_ = input.readBool();
            break;
          }
          case 1344: {
            bitField0_ |= 0x00000010;
            polarityRephaseIncrement_ = input.readInt32();
            break;
          }
          case 1352: {
            bitField3_ |= 0x00000020;
            addZeroHalfCuts_ = input.readBool();
            break;
          }
          case 1360: {
            bitField2_ |= 0x00000800;
            expandAlldiffConstraints_ = input.readBool();
            break;
          }
          case 1370: {
            com.google.protobuf.ByteString bs = input.readBytes();
            bitField0_ |= 0x00000001;
            name_ = bs;
            break;
          }
          case 1376: {
            bitField3_ |= 0x00000040;
            addCliqueCuts_ = input.readBool();
            break;
          }
          case 1384: {
            bitField4_ |= 0x00000008;
            keepAllFeasibleSolutionsInPresolve_ = input.readBool();
            break;
          }
          case 1392: {
            bitField2_ |= 0x00020000;
            presolveExtractIntegerEnforcement_ = input.readBool();
            break;
          }
          case 1400: {
            bitField5_ |= 0x00000001;
            polishLpSolution_ = input.readBool();
            break;
          }
          case 1408: {
            bitField3_ |= 0x10000000;
            useProbingSearch_ = input.readBool();
            break;
          }
          case 1416: {
            bitField5_ |= 0x00000002;
            convertIntervals_ = input.readBool();
            break;
          }
          case 1424: {
            bitField1_ |= 0x00010000;
            permuteVariableRandomly_ = input.readBool();
            break;
          }
          case 1432: {
            bitField1_ |= 0x00020000;
            permutePresolveConstraintOrder_ = input.readBool();
            break;
          }
          case 1440: {
            bitField1_ |= 0x00040000;
            useAbslRandom_ = input.readBool();
            break;
          }
          case 1448: {
            bitField2_ |= 0x00002000;
            disableConstraintExpansion_ = input.readBool();
            break;
          }
          case 1456: {
            bitField2_ |= 0x00001000;
            expandReservoirConstraints_ = input.readBool();
            break;
          }
          case 1464: {
            bitField5_ |= 0x00000004;
            symmetryLevel_ = input.readInt32();
            break;
          }
          case 1472: {
            bitField4_ |= 0x00020000;
            lnsExpandIntervalsInConstraintGraph_ = input.readBool();
            break;
          }
          case 1482: {
            com.google.protobuf.ByteString bs = input.readBytes();
            bitField1_ |= 0x00200000;
            logPrefix_ = bs;
            break;
          }
          case 1488: {
            bitField1_ |= 0x00400000;
            logToStdout_ = input.readBool();
            break;
          }
          case 1496: {
            bitField1_ |= 0x00800000;
            logToResponse_ = input.readBool();
            break;
          }
          case 1504: {
            bitField3_ |= 0x80000000;
            optimizeWithLbTreeSearch_ = input.readBool();
            break;
          }
          case 1512: {
            bitField1_ |= 0x00100000;
            logSubsolverStatistics_ = input.readBool();
            break;
          }
          case 1521: {
            bitField0_ |= 0x00008000;
            clauseCleanupRatio_ = input.readDouble();
            break;
          }
          case 1528: {
            bitField2_ |= 0x80000000;
            maxDomainSizeWhenEncodingEqNeqConstraints_ = input.readInt32();
            break;
          }
          case 1536: {
            bitField3_ |= 0x00200000;
            fixVariablesToTheirHintedValue_ = input.readBool();
            break;
          }
          case 1544: {
            bitField4_ |= 0x00040000;
            solutionPoolSize_ = input.readInt32();
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x40000000) != 0)) {
        restartAlgorithms_ = java.util.Collections.unmodifiableList(restartAlgorithms_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ortools.sat.SatParametersOuterClass.internal_static_operations_research_sat_SatParameters_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ortools.sat.SatParametersOuterClass.internal_static_operations_research_sat_SatParameters_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ortools.sat.SatParameters.class, com.google.ortools.sat.SatParameters.Builder.class);
  }

  /**
   * <pre>
   * Variables without activity (i.e. at the beginning of the search) will be
   * tried in this preferred order.
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.VariableOrder}
   */
  public enum VariableOrder
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * As specified by the problem.
     * </pre>
     *
     * <code>IN_ORDER = 0;</code>
     */
    IN_ORDER(0),
    /**
     * <code>IN_REVERSE_ORDER = 1;</code>
     */
    IN_REVERSE_ORDER(1),
    /**
     * <code>IN_RANDOM_ORDER = 2;</code>
     */
    IN_RANDOM_ORDER(2),
    ;

    /**
     * <pre>
     * As specified by the problem.
     * </pre>
     *
     * <code>IN_ORDER = 0;</code>
     */
    public static final int IN_ORDER_VALUE = 0;
    /**
     * <code>IN_REVERSE_ORDER = 1;</code>
     */
    public static final int IN_REVERSE_ORDER_VALUE = 1;
    /**
     * <code>IN_RANDOM_ORDER = 2;</code>
     */
    public static final int IN_RANDOM_ORDER_VALUE = 2;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VariableOrder valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static VariableOrder forNumber(int value) {
      switch (value) {
        case 0: return IN_ORDER;
        case 1: return IN_REVERSE_ORDER;
        case 2: return IN_RANDOM_ORDER;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<VariableOrder>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        VariableOrder> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<VariableOrder>() {
            public VariableOrder findValueByNumber(int number) {
              return VariableOrder.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(0);
    }

    private static final VariableOrder[] VALUES = values();

    public static VariableOrder valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private VariableOrder(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.VariableOrder)
  }

  /**
   * <pre>
   * Specifies the initial polarity (true/false) when the solver branches on a
   * variable. This can be modified later by the user, or the phase saving
   * heuristic.
   * Note(user): POLARITY_FALSE is usually a good choice because of the
   * "natural" way to express a linear boolean problem.
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.Polarity}
   */
  public enum Polarity
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>POLARITY_TRUE = 0;</code>
     */
    POLARITY_TRUE(0),
    /**
     * <code>POLARITY_FALSE = 1;</code>
     */
    POLARITY_FALSE(1),
    /**
     * <code>POLARITY_RANDOM = 2;</code>
     */
    POLARITY_RANDOM(2),
    /**
     * <pre>
     * Choose the sign that tends to satisfy the most constraints. This is
     * computed using a weighted sum: if a literal l appears in a constraint of
     * the form: ... + coeff * l +... &lt;= rhs with positive coefficients and
     * rhs, then -sign(l) * coeff / rhs is added to the weight of l.variable().
     * </pre>
     *
     * <code>POLARITY_WEIGHTED_SIGN = 3;</code>
     */
    POLARITY_WEIGHTED_SIGN(3),
    /**
     * <pre>
     * The opposite choice of POLARITY_WEIGHTED_SIGN.
     * </pre>
     *
     * <code>POLARITY_REVERSE_WEIGHTED_SIGN = 4;</code>
     */
    POLARITY_REVERSE_WEIGHTED_SIGN(4),
    ;

    /**
     * <code>POLARITY_TRUE = 0;</code>
     */
    public static final int POLARITY_TRUE_VALUE = 0;
    /**
     * <code>POLARITY_FALSE = 1;</code>
     */
    public static final int POLARITY_FALSE_VALUE = 1;
    /**
     * <code>POLARITY_RANDOM = 2;</code>
     */
    public static final int POLARITY_RANDOM_VALUE = 2;
    /**
     * <pre>
     * Choose the sign that tends to satisfy the most constraints. This is
     * computed using a weighted sum: if a literal l appears in a constraint of
     * the form: ... + coeff * l +... &lt;= rhs with positive coefficients and
     * rhs, then -sign(l) * coeff / rhs is added to the weight of l.variable().
     * </pre>
     *
     * <code>POLARITY_WEIGHTED_SIGN = 3;</code>
     */
    public static final int POLARITY_WEIGHTED_SIGN_VALUE = 3;
    /**
     * <pre>
     * The opposite choice of POLARITY_WEIGHTED_SIGN.
     * </pre>
     *
     * <code>POLARITY_REVERSE_WEIGHTED_SIGN = 4;</code>
     */
    public static final int POLARITY_REVERSE_WEIGHTED_SIGN_VALUE = 4;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Polarity valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Polarity forNumber(int value) {
      switch (value) {
        case 0: return POLARITY_TRUE;
        case 1: return POLARITY_FALSE;
        case 2: return POLARITY_RANDOM;
        case 3: return POLARITY_WEIGHTED_SIGN;
        case 4: return POLARITY_REVERSE_WEIGHTED_SIGN;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Polarity>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        Polarity> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Polarity>() {
            public Polarity findValueByNumber(int number) {
              return Polarity.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(1);
    }

    private static final Polarity[] VALUES = values();

    public static Polarity valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Polarity(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.Polarity)
  }

  /**
   * <pre>
   * Do we try to minimize conflicts (greedily) when creating them.
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.ConflictMinimizationAlgorithm}
   */
  public enum ConflictMinimizationAlgorithm
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>NONE = 0;</code>
     */
    NONE(0),
    /**
     * <code>SIMPLE = 1;</code>
     */
    SIMPLE(1),
    /**
     * <code>RECURSIVE = 2;</code>
     */
    RECURSIVE(2),
    /**
     * <code>EXPERIMENTAL = 3;</code>
     */
    EXPERIMENTAL(3),
    ;

    /**
     * <code>NONE = 0;</code>
     */
    public static final int NONE_VALUE = 0;
    /**
     * <code>SIMPLE = 1;</code>
     */
    public static final int SIMPLE_VALUE = 1;
    /**
     * <code>RECURSIVE = 2;</code>
     */
    public static final int RECURSIVE_VALUE = 2;
    /**
     * <code>EXPERIMENTAL = 3;</code>
     */
    public static final int EXPERIMENTAL_VALUE = 3;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConflictMinimizationAlgorithm valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ConflictMinimizationAlgorithm forNumber(int value) {
      switch (value) {
        case 0: return NONE;
        case 1: return SIMPLE;
        case 2: return RECURSIVE;
        case 3: return EXPERIMENTAL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConflictMinimizationAlgorithm>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ConflictMinimizationAlgorithm> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ConflictMinimizationAlgorithm>() {
            public ConflictMinimizationAlgorithm findValueByNumber(int number) {
              return ConflictMinimizationAlgorithm.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(2);
    }

    private static final ConflictMinimizationAlgorithm[] VALUES = values();

    public static ConflictMinimizationAlgorithm valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConflictMinimizationAlgorithm(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.ConflictMinimizationAlgorithm)
  }

  /**
   * <pre>
   * Whether to expoit the binary clause to minimize learned clauses further.
   * This will have an effect only if treat_binary_clauses_separately is true.
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.BinaryMinizationAlgorithm}
   */
  public enum BinaryMinizationAlgorithm
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>NO_BINARY_MINIMIZATION = 0;</code>
     */
    NO_BINARY_MINIMIZATION(0),
    /**
     * <code>BINARY_MINIMIZATION_FIRST = 1;</code>
     */
    BINARY_MINIMIZATION_FIRST(1),
    /**
     * <code>BINARY_MINIMIZATION_FIRST_WITH_TRANSITIVE_REDUCTION = 4;</code>
     */
    BINARY_MINIMIZATION_FIRST_WITH_TRANSITIVE_REDUCTION(4),
    /**
     * <code>BINARY_MINIMIZATION_WITH_REACHABILITY = 2;</code>
     */
    BINARY_MINIMIZATION_WITH_REACHABILITY(2),
    /**
     * <code>EXPERIMENTAL_BINARY_MINIMIZATION = 3;</code>
     */
    EXPERIMENTAL_BINARY_MINIMIZATION(3),
    ;

    /**
     * <code>NO_BINARY_MINIMIZATION = 0;</code>
     */
    public static final int NO_BINARY_MINIMIZATION_VALUE = 0;
    /**
     * <code>BINARY_MINIMIZATION_FIRST = 1;</code>
     */
    public static final int BINARY_MINIMIZATION_FIRST_VALUE = 1;
    /**
     * <code>BINARY_MINIMIZATION_FIRST_WITH_TRANSITIVE_REDUCTION = 4;</code>
     */
    public static final int BINARY_MINIMIZATION_FIRST_WITH_TRANSITIVE_REDUCTION_VALUE = 4;
    /**
     * <code>BINARY_MINIMIZATION_WITH_REACHABILITY = 2;</code>
     */
    public static final int BINARY_MINIMIZATION_WITH_REACHABILITY_VALUE = 2;
    /**
     * <code>EXPERIMENTAL_BINARY_MINIMIZATION = 3;</code>
     */
    public static final int EXPERIMENTAL_BINARY_MINIMIZATION_VALUE = 3;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BinaryMinizationAlgorithm valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static BinaryMinizationAlgorithm forNumber(int value) {
      switch (value) {
        case 0: return NO_BINARY_MINIMIZATION;
        case 1: return BINARY_MINIMIZATION_FIRST;
        case 4: return BINARY_MINIMIZATION_FIRST_WITH_TRANSITIVE_REDUCTION;
        case 2: return BINARY_MINIMIZATION_WITH_REACHABILITY;
        case 3: return EXPERIMENTAL_BINARY_MINIMIZATION;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<BinaryMinizationAlgorithm>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        BinaryMinizationAlgorithm> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<BinaryMinizationAlgorithm>() {
            public BinaryMinizationAlgorithm findValueByNumber(int number) {
              return BinaryMinizationAlgorithm.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(3);
    }

    private static final BinaryMinizationAlgorithm[] VALUES = values();

    public static BinaryMinizationAlgorithm valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private BinaryMinizationAlgorithm(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.BinaryMinizationAlgorithm)
  }

  /**
   * <pre>
   * Each time a clause activity is bumped, the clause has a chance to be
   * protected during the next cleanup phase. Note that clauses used as a reason
   * are always protected.
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.ClauseProtection}
   */
  public enum ClauseProtection
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * No protection.
     * </pre>
     *
     * <code>PROTECTION_NONE = 0;</code>
     */
    PROTECTION_NONE(0),
    /**
     * <pre>
     * Protect all clauses whose activity is bumped.
     * </pre>
     *
     * <code>PROTECTION_ALWAYS = 1;</code>
     */
    PROTECTION_ALWAYS(1),
    /**
     * <pre>
     * Only protect clause with a better LBD.
     * </pre>
     *
     * <code>PROTECTION_LBD = 2;</code>
     */
    PROTECTION_LBD(2),
    ;

    /**
     * <pre>
     * No protection.
     * </pre>
     *
     * <code>PROTECTION_NONE = 0;</code>
     */
    public static final int PROTECTION_NONE_VALUE = 0;
    /**
     * <pre>
     * Protect all clauses whose activity is bumped.
     * </pre>
     *
     * <code>PROTECTION_ALWAYS = 1;</code>
     */
    public static final int PROTECTION_ALWAYS_VALUE = 1;
    /**
     * <pre>
     * Only protect clause with a better LBD.
     * </pre>
     *
     * <code>PROTECTION_LBD = 2;</code>
     */
    public static final int PROTECTION_LBD_VALUE = 2;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ClauseProtection valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ClauseProtection forNumber(int value) {
      switch (value) {
        case 0: return PROTECTION_NONE;
        case 1: return PROTECTION_ALWAYS;
        case 2: return PROTECTION_LBD;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ClauseProtection>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ClauseProtection> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ClauseProtection>() {
            public ClauseProtection findValueByNumber(int number) {
              return ClauseProtection.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(4);
    }

    private static final ClauseProtection[] VALUES = values();

    public static ClauseProtection valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ClauseProtection(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.ClauseProtection)
  }

  /**
   * <pre>
   * The clauses that will be kept during a cleanup are the ones that come
   * first under this order. We always keep or exclude ties together.
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.ClauseOrdering}
   */
  public enum ClauseOrdering
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Order clause by decreasing activity, then by increasing LBD.
     * </pre>
     *
     * <code>CLAUSE_ACTIVITY = 0;</code>
     */
    CLAUSE_ACTIVITY(0),
    /**
     * <pre>
     * Order clause by increasing LBD, then by decreasing activity.
     * </pre>
     *
     * <code>CLAUSE_LBD = 1;</code>
     */
    CLAUSE_LBD(1),
    ;

    /**
     * <pre>
     * Order clause by decreasing activity, then by increasing LBD.
     * </pre>
     *
     * <code>CLAUSE_ACTIVITY = 0;</code>
     */
    public static final int CLAUSE_ACTIVITY_VALUE = 0;
    /**
     * <pre>
     * Order clause by increasing LBD, then by decreasing activity.
     * </pre>
     *
     * <code>CLAUSE_LBD = 1;</code>
     */
    public static final int CLAUSE_LBD_VALUE = 1;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ClauseOrdering valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ClauseOrdering forNumber(int value) {
      switch (value) {
        case 0: return CLAUSE_ACTIVITY;
        case 1: return CLAUSE_LBD;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ClauseOrdering>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ClauseOrdering> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ClauseOrdering>() {
            public ClauseOrdering findValueByNumber(int number) {
              return ClauseOrdering.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(5);
    }

    private static final ClauseOrdering[] VALUES = values();

    public static ClauseOrdering valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ClauseOrdering(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.ClauseOrdering)
  }

  /**
   * <pre>
   * Restart algorithms.
   * A reference for the more advanced ones is:
   * Gilles Audemard, Laurent Simon, "Refining Restarts Strategies for SAT
   * and UNSAT", Principles and Practice of Constraint Programming Lecture
   * Notes in Computer Science 2012, pp 118-126
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.RestartAlgorithm}
   */
  public enum RestartAlgorithm
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>NO_RESTART = 0;</code>
     */
    NO_RESTART(0),
    /**
     * <pre>
     * Just follow a Luby sequence times restart_period.
     * </pre>
     *
     * <code>LUBY_RESTART = 1;</code>
     */
    LUBY_RESTART(1),
    /**
     * <pre>
     * Moving average restart based on the decision level of conflicts.
     * </pre>
     *
     * <code>DL_MOVING_AVERAGE_RESTART = 2;</code>
     */
    DL_MOVING_AVERAGE_RESTART(2),
    /**
     * <pre>
     * Moving average restart based on the LBD of conflicts.
     * </pre>
     *
     * <code>LBD_MOVING_AVERAGE_RESTART = 3;</code>
     */
    LBD_MOVING_AVERAGE_RESTART(3),
    /**
     * <pre>
     * Fixed period restart every restart period.
     * </pre>
     *
     * <code>FIXED_RESTART = 4;</code>
     */
    FIXED_RESTART(4),
    ;

    /**
     * <code>NO_RESTART = 0;</code>
     */
    public static final int NO_RESTART_VALUE = 0;
    /**
     * <pre>
     * Just follow a Luby sequence times restart_period.
     * </pre>
     *
     * <code>LUBY_RESTART = 1;</code>
     */
    public static final int LUBY_RESTART_VALUE = 1;
    /**
     * <pre>
     * Moving average restart based on the decision level of conflicts.
     * </pre>
     *
     * <code>DL_MOVING_AVERAGE_RESTART = 2;</code>
     */
    public static final int DL_MOVING_AVERAGE_RESTART_VALUE = 2;
    /**
     * <pre>
     * Moving average restart based on the LBD of conflicts.
     * </pre>
     *
     * <code>LBD_MOVING_AVERAGE_RESTART = 3;</code>
     */
    public static final int LBD_MOVING_AVERAGE_RESTART_VALUE = 3;
    /**
     * <pre>
     * Fixed period restart every restart period.
     * </pre>
     *
     * <code>FIXED_RESTART = 4;</code>
     */
    public static final int FIXED_RESTART_VALUE = 4;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RestartAlgorithm valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RestartAlgorithm forNumber(int value) {
      switch (value) {
        case 0: return NO_RESTART;
        case 1: return LUBY_RESTART;
        case 2: return DL_MOVING_AVERAGE_RESTART;
        case 3: return LBD_MOVING_AVERAGE_RESTART;
        case 4: return FIXED_RESTART;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RestartAlgorithm>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        RestartAlgorithm> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<RestartAlgorithm>() {
            public RestartAlgorithm findValueByNumber(int number) {
              return RestartAlgorithm.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(6);
    }

    private static final RestartAlgorithm[] VALUES = values();

    public static RestartAlgorithm valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RestartAlgorithm(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.RestartAlgorithm)
  }

  /**
   * <pre>
   * In what order do we add the assumptions in a core-based max-sat algorithm
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.MaxSatAssumptionOrder}
   */
  public enum MaxSatAssumptionOrder
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>DEFAULT_ASSUMPTION_ORDER = 0;</code>
     */
    DEFAULT_ASSUMPTION_ORDER(0),
    /**
     * <code>ORDER_ASSUMPTION_BY_DEPTH = 1;</code>
     */
    ORDER_ASSUMPTION_BY_DEPTH(1),
    /**
     * <code>ORDER_ASSUMPTION_BY_WEIGHT = 2;</code>
     */
    ORDER_ASSUMPTION_BY_WEIGHT(2),
    ;

    /**
     * <code>DEFAULT_ASSUMPTION_ORDER = 0;</code>
     */
    public static final int DEFAULT_ASSUMPTION_ORDER_VALUE = 0;
    /**
     * <code>ORDER_ASSUMPTION_BY_DEPTH = 1;</code>
     */
    public static final int ORDER_ASSUMPTION_BY_DEPTH_VALUE = 1;
    /**
     * <code>ORDER_ASSUMPTION_BY_WEIGHT = 2;</code>
     */
    public static final int ORDER_ASSUMPTION_BY_WEIGHT_VALUE = 2;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MaxSatAssumptionOrder valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MaxSatAssumptionOrder forNumber(int value) {
      switch (value) {
        case 0: return DEFAULT_ASSUMPTION_ORDER;
        case 1: return ORDER_ASSUMPTION_BY_DEPTH;
        case 2: return ORDER_ASSUMPTION_BY_WEIGHT;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MaxSatAssumptionOrder>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        MaxSatAssumptionOrder> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<MaxSatAssumptionOrder>() {
            public MaxSatAssumptionOrder findValueByNumber(int number) {
              return MaxSatAssumptionOrder.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(7);
    }

    private static final MaxSatAssumptionOrder[] VALUES = values();

    public static MaxSatAssumptionOrder valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MaxSatAssumptionOrder(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.MaxSatAssumptionOrder)
  }

  /**
   * <pre>
   * What stratification algorithm we use in the presence of weight.
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.MaxSatStratificationAlgorithm}
   */
  public enum MaxSatStratificationAlgorithm
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * No stratification of the problem.
     * </pre>
     *
     * <code>STRATIFICATION_NONE = 0;</code>
     */
    STRATIFICATION_NONE(0),
    /**
     * <pre>
     * Start with literals with the highest weight, and when SAT, add the
     * literals with the next highest weight and so on.
     * </pre>
     *
     * <code>STRATIFICATION_DESCENT = 1;</code>
     */
    STRATIFICATION_DESCENT(1),
    /**
     * <pre>
     * Start with all literals. Each time a core is found with a given minimum
     * weight, do not consider literals with a lower weight for the next core
     * computation. If the subproblem is SAT, do like in STRATIFICATION_DESCENT
     * and just add the literals with the next highest weight.
     * </pre>
     *
     * <code>STRATIFICATION_ASCENT = 2;</code>
     */
    STRATIFICATION_ASCENT(2),
    ;

    /**
     * <pre>
     * No stratification of the problem.
     * </pre>
     *
     * <code>STRATIFICATION_NONE = 0;</code>
     */
    public static final int STRATIFICATION_NONE_VALUE = 0;
    /**
     * <pre>
     * Start with literals with the highest weight, and when SAT, add the
     * literals with the next highest weight and so on.
     * </pre>
     *
     * <code>STRATIFICATION_DESCENT = 1;</code>
     */
    public static final int STRATIFICATION_DESCENT_VALUE = 1;
    /**
     * <pre>
     * Start with all literals. Each time a core is found with a given minimum
     * weight, do not consider literals with a lower weight for the next core
     * computation. If the subproblem is SAT, do like in STRATIFICATION_DESCENT
     * and just add the literals with the next highest weight.
     * </pre>
     *
     * <code>STRATIFICATION_ASCENT = 2;</code>
     */
    public static final int STRATIFICATION_ASCENT_VALUE = 2;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MaxSatStratificationAlgorithm valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MaxSatStratificationAlgorithm forNumber(int value) {
      switch (value) {
        case 0: return STRATIFICATION_NONE;
        case 1: return STRATIFICATION_DESCENT;
        case 2: return STRATIFICATION_ASCENT;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MaxSatStratificationAlgorithm>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        MaxSatStratificationAlgorithm> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<MaxSatStratificationAlgorithm>() {
            public MaxSatStratificationAlgorithm findValueByNumber(int number) {
              return MaxSatStratificationAlgorithm.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(8);
    }

    private static final MaxSatStratificationAlgorithm[] VALUES = values();

    public static MaxSatStratificationAlgorithm valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MaxSatStratificationAlgorithm(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.MaxSatStratificationAlgorithm)
  }

  /**
   * <pre>
   * The search branching will be used to decide how to branch on unfixed nodes.
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.SearchBranching}
   */
  public enum SearchBranching
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Try to fix all literals using the underlying SAT solver's heuristics,
     * then generate and fix literals until integer variables are fixed.
     * </pre>
     *
     * <code>AUTOMATIC_SEARCH = 0;</code>
     */
    AUTOMATIC_SEARCH(0),
    /**
     * <pre>
     * If used then all decisions taken by the solver are made using a fixed
     * order as specified in the API or in the CpModelProto search_strategy
     * field.
     * </pre>
     *
     * <code>FIXED_SEARCH = 1;</code>
     */
    FIXED_SEARCH(1),
    /**
     * <pre>
     * If used, the solver will use various generic heuristics in turn.
     * </pre>
     *
     * <code>PORTFOLIO_SEARCH = 2;</code>
     */
    PORTFOLIO_SEARCH(2),
    /**
     * <pre>
     * If used, the solver will use heuristics from the LP relaxation. This
     * exploit the reduced costs of the variables in the relaxation.
     * TODO(user): Maybe rename REDUCED_COST_SEARCH?
     * </pre>
     *
     * <code>LP_SEARCH = 3;</code>
     */
    LP_SEARCH(3),
    /**
     * <pre>
     * If used, the solver uses the pseudo costs for branching. Pseudo costs
     * are computed using the historical change in objective bounds when some
     * decision are taken.
     * </pre>
     *
     * <code>PSEUDO_COST_SEARCH = 4;</code>
     */
    PSEUDO_COST_SEARCH(4),
    /**
     * <pre>
     * Mainly exposed here for testing. This quickly tries a lot of randomized
     * heuristics with a low conflict limit. It usually provides a good first
     * solution.
     * </pre>
     *
     * <code>PORTFOLIO_WITH_QUICK_RESTART_SEARCH = 5;</code>
     */
    PORTFOLIO_WITH_QUICK_RESTART_SEARCH(5),
    /**
     * <pre>
     * Mainly used internally. This is like FIXED_SEARCH, except we follow the
     * solution_hint field of the CpModelProto rather than using the information
     * provided in the search_strategy.
     * </pre>
     *
     * <code>HINT_SEARCH = 6;</code>
     */
    HINT_SEARCH(6),
    ;

    /**
     * <pre>
     * Try to fix all literals using the underlying SAT solver's heuristics,
     * then generate and fix literals until integer variables are fixed.
     * </pre>
     *
     * <code>AUTOMATIC_SEARCH = 0;</code>
     */
    public static final int AUTOMATIC_SEARCH_VALUE = 0;
    /**
     * <pre>
     * If used then all decisions taken by the solver are made using a fixed
     * order as specified in the API or in the CpModelProto search_strategy
     * field.
     * </pre>
     *
     * <code>FIXED_SEARCH = 1;</code>
     */
    public static final int FIXED_SEARCH_VALUE = 1;
    /**
     * <pre>
     * If used, the solver will use various generic heuristics in turn.
     * </pre>
     *
     * <code>PORTFOLIO_SEARCH = 2;</code>
     */
    public static final int PORTFOLIO_SEARCH_VALUE = 2;
    /**
     * <pre>
     * If used, the solver will use heuristics from the LP relaxation. This
     * exploit the reduced costs of the variables in the relaxation.
     * TODO(user): Maybe rename REDUCED_COST_SEARCH?
     * </pre>
     *
     * <code>LP_SEARCH = 3;</code>
     */
    public static final int LP_SEARCH_VALUE = 3;
    /**
     * <pre>
     * If used, the solver uses the pseudo costs for branching. Pseudo costs
     * are computed using the historical change in objective bounds when some
     * decision are taken.
     * </pre>
     *
     * <code>PSEUDO_COST_SEARCH = 4;</code>
     */
    public static final int PSEUDO_COST_SEARCH_VALUE = 4;
    /**
     * <pre>
     * Mainly exposed here for testing. This quickly tries a lot of randomized
     * heuristics with a low conflict limit. It usually provides a good first
     * solution.
     * </pre>
     *
     * <code>PORTFOLIO_WITH_QUICK_RESTART_SEARCH = 5;</code>
     */
    public static final int PORTFOLIO_WITH_QUICK_RESTART_SEARCH_VALUE = 5;
    /**
     * <pre>
     * Mainly used internally. This is like FIXED_SEARCH, except we follow the
     * solution_hint field of the CpModelProto rather than using the information
     * provided in the search_strategy.
     * </pre>
     *
     * <code>HINT_SEARCH = 6;</code>
     */
    public static final int HINT_SEARCH_VALUE = 6;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SearchBranching valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SearchBranching forNumber(int value) {
      switch (value) {
        case 0: return AUTOMATIC_SEARCH;
        case 1: return FIXED_SEARCH;
        case 2: return PORTFOLIO_SEARCH;
        case 3: return LP_SEARCH;
        case 4: return PSEUDO_COST_SEARCH;
        case 5: return PORTFOLIO_WITH_QUICK_RESTART_SEARCH;
        case 6: return HINT_SEARCH;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SearchBranching>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        SearchBranching> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<SearchBranching>() {
            public SearchBranching findValueByNumber(int number) {
              return SearchBranching.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(9);
    }

    private static final SearchBranching[] VALUES = values();

    public static SearchBranching valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SearchBranching(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.SearchBranching)
  }

  /**
   * <pre>
   * Rounding method to use for feasibility pump.
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.FPRoundingMethod}
   */
  public enum FPRoundingMethod
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Rounds to the nearest integer value.
     * </pre>
     *
     * <code>NEAREST_INTEGER = 0;</code>
     */
    NEAREST_INTEGER(0),
    /**
     * <pre>
     * Counts the number of linear constraints restricting the variable in the
     * increasing values (up locks) and decreasing values (down locks). Rounds
     * the variable in the direction of lesser locks.
     * </pre>
     *
     * <code>LOCK_BASED = 1;</code>
     */
    LOCK_BASED(1),
    /**
     * <pre>
     * Similar to lock based rounding except this only considers locks of active
     * constraints from the last lp solve.
     * </pre>
     *
     * <code>ACTIVE_LOCK_BASED = 3;</code>
     */
    ACTIVE_LOCK_BASED(3),
    /**
     * <pre>
     * This is expensive rounding algorithm. We round variables one by one and
     * propagate the bounds in between. If none of the rounded values fall in
     * the continuous domain specified by lower and upper bound, we use the
     * current lower/upper bound (whichever one is closest) instead of rounding
     * the fractional lp solution value. If both the rounded values are in the
     * domain, we round to nearest integer.
     * </pre>
     *
     * <code>PROPAGATION_ASSISTED = 2;</code>
     */
    PROPAGATION_ASSISTED(2),
    ;

    /**
     * <pre>
     * Rounds to the nearest integer value.
     * </pre>
     *
     * <code>NEAREST_INTEGER = 0;</code>
     */
    public static final int NEAREST_INTEGER_VALUE = 0;
    /**
     * <pre>
     * Counts the number of linear constraints restricting the variable in the
     * increasing values (up locks) and decreasing values (down locks). Rounds
     * the variable in the direction of lesser locks.
     * </pre>
     *
     * <code>LOCK_BASED = 1;</code>
     */
    public static final int LOCK_BASED_VALUE = 1;
    /**
     * <pre>
     * Similar to lock based rounding except this only considers locks of active
     * constraints from the last lp solve.
     * </pre>
     *
     * <code>ACTIVE_LOCK_BASED = 3;</code>
     */
    public static final int ACTIVE_LOCK_BASED_VALUE = 3;
    /**
     * <pre>
     * This is expensive rounding algorithm. We round variables one by one and
     * propagate the bounds in between. If none of the rounded values fall in
     * the continuous domain specified by lower and upper bound, we use the
     * current lower/upper bound (whichever one is closest) instead of rounding
     * the fractional lp solution value. If both the rounded values are in the
     * domain, we round to nearest integer.
     * </pre>
     *
     * <code>PROPAGATION_ASSISTED = 2;</code>
     */
    public static final int PROPAGATION_ASSISTED_VALUE = 2;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FPRoundingMethod valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static FPRoundingMethod forNumber(int value) {
      switch (value) {
        case 0: return NEAREST_INTEGER;
        case 1: return LOCK_BASED;
        case 3: return ACTIVE_LOCK_BASED;
        case 2: return PROPAGATION_ASSISTED;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<FPRoundingMethod>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        FPRoundingMethod> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<FPRoundingMethod>() {
            public FPRoundingMethod findValueByNumber(int number) {
              return FPRoundingMethod.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(10);
    }

    private static final FPRoundingMethod[] VALUES = values();

    public static FPRoundingMethod valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private FPRoundingMethod(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.FPRoundingMethod)
  }

  private int bitField0_;
  private int bitField1_;
  private int bitField2_;
  private int bitField3_;
  private int bitField4_;
  private int bitField5_;
  public static final int NAME_FIELD_NUMBER = 171;
  private volatile java.lang.Object name_;
  /**
   * <pre>
   * In some context, like in a portfolio of search, it makes sense to name a
   * given parameters set for logging purpose.
   * </pre>
   *
   * <code>optional string name = 171 [default = ""];</code>
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * In some context, like in a portfolio of search, it makes sense to name a
   * given parameters set for logging purpose.
   * </pre>
   *
   * <code>optional string name = 171 [default = ""];</code>
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (bs.isValidUtf8()) {
        name_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * In some context, like in a portfolio of search, it makes sense to name a
   * given parameters set for logging purpose.
   * </pre>
   *
   * <code>optional string name = 171 [default = ""];</code>
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREFERRED_VARIABLE_ORDER_FIELD_NUMBER = 1;
  private int preferredVariableOrder_;
  /**
   * <code>optional .operations_research.sat.SatParameters.VariableOrder preferred_variable_order = 1 [default = IN_ORDER];</code>
   * @return Whether the preferredVariableOrder field is set.
   */
  @java.lang.Override public boolean hasPreferredVariableOrder() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <code>optional .operations_research.sat.SatParameters.VariableOrder preferred_variable_order = 1 [default = IN_ORDER];</code>
   * @return The preferredVariableOrder.
   */
  @java.lang.Override public com.google.ortools.sat.SatParameters.VariableOrder getPreferredVariableOrder() {
    @SuppressWarnings("deprecation")
    com.google.ortools.sat.SatParameters.VariableOrder result = com.google.ortools.sat.SatParameters.VariableOrder.valueOf(preferredVariableOrder_);
    return result == null ? com.google.ortools.sat.SatParameters.VariableOrder.IN_ORDER : result;
  }

  public static final int INITIAL_POLARITY_FIELD_NUMBER = 2;
  private int initialPolarity_;
  /**
   * <code>optional .operations_research.sat.SatParameters.Polarity initial_polarity = 2 [default = POLARITY_FALSE];</code>
   * @return Whether the initialPolarity field is set.
   */
  @java.lang.Override public boolean hasInitialPolarity() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <code>optional .operations_research.sat.SatParameters.Polarity initial_polarity = 2 [default = POLARITY_FALSE];</code>
   * @return The initialPolarity.
   */
  @java.lang.Override public com.google.ortools.sat.SatParameters.Polarity getInitialPolarity() {
    @SuppressWarnings("deprecation")
    com.google.ortools.sat.SatParameters.Polarity result = com.google.ortools.sat.SatParameters.Polarity.valueOf(initialPolarity_);
    return result == null ? com.google.ortools.sat.SatParameters.Polarity.POLARITY_FALSE : result;
  }

  public static final int USE_PHASE_SAVING_FIELD_NUMBER = 44;
  private boolean usePhaseSaving_;
  /**
   * <pre>
   * If this is true, then the polarity of a variable will be the last value it
   * was assigned to, or its default polarity if it was never assigned since the
   * call to ResetDecisionHeuristic().
   * Actually, we use a newer version where we follow the last value in the
   * longest non-conflicting partial assignment in the current phase.
   * This is called 'literal phase saving'. For details see 'A Lightweight
   * Component Caching Scheme for Satisfiability Solvers' K. Pipatsrisawat and
   * A.Darwiche, In 10th International Conference on Theory and Applications of
   * Satisfiability Testing, 2007.
   * </pre>
   *
   * <code>optional bool use_phase_saving = 44 [default = true];</code>
   * @return Whether the usePhaseSaving field is set.
   */
  @java.lang.Override
  public boolean hasUsePhaseSaving() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * If this is true, then the polarity of a variable will be the last value it
   * was assigned to, or its default polarity if it was never assigned since the
   * call to ResetDecisionHeuristic().
   * Actually, we use a newer version where we follow the last value in the
   * longest non-conflicting partial assignment in the current phase.
   * This is called 'literal phase saving'. For details see 'A Lightweight
   * Component Caching Scheme for Satisfiability Solvers' K. Pipatsrisawat and
   * A.Darwiche, In 10th International Conference on Theory and Applications of
   * Satisfiability Testing, 2007.
   * </pre>
   *
   * <code>optional bool use_phase_saving = 44 [default = true];</code>
   * @return The usePhaseSaving.
   */
  @java.lang.Override
  public boolean getUsePhaseSaving() {
    return usePhaseSaving_;
  }

  public static final int POLARITY_REPHASE_INCREMENT_FIELD_NUMBER = 168;
  private int polarityRephaseIncrement_;
  /**
   * <pre>
   * If non-zero, then we change the polarity heuristic after that many number
   * of conflicts in an arithmetically increasing fashion. So x the first time,
   * 2 * x the second time, etc...
   * </pre>
   *
   * <code>optional int32 polarity_rephase_increment = 168 [default = 1000];</code>
   * @return Whether the polarityRephaseIncrement field is set.
   */
  @java.lang.Override
  public boolean hasPolarityRephaseIncrement() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * If non-zero, then we change the polarity heuristic after that many number
   * of conflicts in an arithmetically increasing fashion. So x the first time,
   * 2 * x the second time, etc...
   * </pre>
   *
   * <code>optional int32 polarity_rephase_increment = 168 [default = 1000];</code>
   * @return The polarityRephaseIncrement.
   */
  @java.lang.Override
  public int getPolarityRephaseIncrement() {
    return polarityRephaseIncrement_;
  }

  public static final int RANDOM_POLARITY_RATIO_FIELD_NUMBER = 45;
  private double randomPolarityRatio_;
  /**
   * <pre>
   * The proportion of polarity chosen at random. Note that this take
   * precedence over the phase saving heuristic. This is different from
   * initial_polarity:POLARITY_RANDOM because it will select a new random
   * polarity each time the variable is branched upon instead of selecting one
   * initially and then always taking this choice.
   * </pre>
   *
   * <code>optional double random_polarity_ratio = 45 [default = 0];</code>
   * @return Whether the randomPolarityRatio field is set.
   */
  @java.lang.Override
  public boolean hasRandomPolarityRatio() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   * <pre>
   * The proportion of polarity chosen at random. Note that this take
   * precedence over the phase saving heuristic. This is different from
   * initial_polarity:POLARITY_RANDOM because it will select a new random
   * polarity each time the variable is branched upon instead of selecting one
   * initially and then always taking this choice.
   * </pre>
   *
   * <code>optional double random_polarity_ratio = 45 [default = 0];</code>
   * @return The randomPolarityRatio.
   */
  @java.lang.Override
  public double getRandomPolarityRatio() {
    return randomPolarityRatio_;
  }

  public static final int RANDOM_BRANCHES_RATIO_FIELD_NUMBER = 32;
  private double randomBranchesRatio_;
  /**
   * <pre>
   * A number between 0 and 1 that indicates the proportion of branching
   * variables that are selected randomly instead of choosing the first variable
   * from the given variable_ordering strategy.
   * </pre>
   *
   * <code>optional double random_branches_ratio = 32 [default = 0];</code>
   * @return Whether the randomBranchesRatio field is set.
   */
  @java.lang.Override
  public boolean hasRandomBranchesRatio() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   * <pre>
   * A number between 0 and 1 that indicates the proportion of branching
   * variables that are selected randomly instead of choosing the first variable
   * from the given variable_ordering strategy.
   * </pre>
   *
   * <code>optional double random_branches_ratio = 32 [default = 0];</code>
   * @return The randomBranchesRatio.
   */
  @java.lang.Override
  public double getRandomBranchesRatio() {
    return randomBranchesRatio_;
  }

  public static final int USE_ERWA_HEURISTIC_FIELD_NUMBER = 75;
  private boolean useErwaHeuristic_;
  /**
   * <pre>
   * Whether we use the ERWA (Exponential Recency Weighted Average) heuristic as
   * described in "Learning Rate Based Branching Heuristic for SAT solvers",
   * J.H.Liang, V. Ganesh, P. Poupart, K.Czarnecki, SAT 2016.
   * </pre>
   *
   * <code>optional bool use_erwa_heuristic = 75 [default = false];</code>
   * @return Whether the useErwaHeuristic field is set.
   */
  @java.lang.Override
  public boolean hasUseErwaHeuristic() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   * <pre>
   * Whether we use the ERWA (Exponential Recency Weighted Average) heuristic as
   * described in "Learning Rate Based Branching Heuristic for SAT solvers",
   * J.H.Liang, V. Ganesh, P. Poupart, K.Czarnecki, SAT 2016.
   * </pre>
   *
   * <code>optional bool use_erwa_heuristic = 75 [default = false];</code>
   * @return The useErwaHeuristic.
   */
  @java.lang.Override
  public boolean getUseErwaHeuristic() {
    return useErwaHeuristic_;
  }

  public static final int INITIAL_VARIABLES_ACTIVITY_FIELD_NUMBER = 76;
  private double initialVariablesActivity_;
  /**
   * <pre>
   * The initial value of the variables activity. A non-zero value only make
   * sense when use_erwa_heuristic is true. Experiments with a value of 1e-2
   * together with the ERWA heuristic showed slighthly better result than simply
   * using zero. The idea is that when the "learning rate" of a variable becomes
   * lower than this value, then we prefer to branch on never explored before
   * variables. This is not in the ERWA paper.
   * </pre>
   *
   * <code>optional double initial_variables_activity = 76 [default = 0];</code>
   * @return Whether the initialVariablesActivity field is set.
   */
  @java.lang.Override
  public boolean hasInitialVariablesActivity() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   * <pre>
   * The initial value of the variables activity. A non-zero value only make
   * sense when use_erwa_heuristic is true. Experiments with a value of 1e-2
   * together with the ERWA heuristic showed slighthly better result than simply
   * using zero. The idea is that when the "learning rate" of a variable becomes
   * lower than this value, then we prefer to branch on never explored before
   * variables. This is not in the ERWA paper.
   * </pre>
   *
   * <code>optional double initial_variables_activity = 76 [default = 0];</code>
   * @return The initialVariablesActivity.
   */
  @java.lang.Override
  public double getInitialVariablesActivity() {
    return initialVariablesActivity_;
  }

  public static final int ALSO_BUMP_VARIABLES_IN_CONFLICT_REASONS_FIELD_NUMBER = 77;
  private boolean alsoBumpVariablesInConflictReasons_;
  /**
   * <pre>
   * When this is true, then the variables that appear in any of the reason of
   * the variables in a conflict have their activity bumped. This is addition to
   * the variables in the conflict, and the one that were used during conflict
   * resolution.
   * </pre>
   *
   * <code>optional bool also_bump_variables_in_conflict_reasons = 77 [default = false];</code>
   * @return Whether the alsoBumpVariablesInConflictReasons field is set.
   */
  @java.lang.Override
  public boolean hasAlsoBumpVariablesInConflictReasons() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   * <pre>
   * When this is true, then the variables that appear in any of the reason of
   * the variables in a conflict have their activity bumped. This is addition to
   * the variables in the conflict, and the one that were used during conflict
   * resolution.
   * </pre>
   *
   * <code>optional bool also_bump_variables_in_conflict_reasons = 77 [default = false];</code>
   * @return The alsoBumpVariablesInConflictReasons.
   */
  @java.lang.Override
  public boolean getAlsoBumpVariablesInConflictReasons() {
    return alsoBumpVariablesInConflictReasons_;
  }

  public static final int MINIMIZATION_ALGORITHM_FIELD_NUMBER = 4;
  private int minimizationAlgorithm_;
  /**
   * <code>optional .operations_research.sat.SatParameters.ConflictMinimizationAlgorithm minimization_algorithm = 4 [default = RECURSIVE];</code>
   * @return Whether the minimizationAlgorithm field is set.
   */
  @java.lang.Override public boolean hasMinimizationAlgorithm() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   * <code>optional .operations_research.sat.SatParameters.ConflictMinimizationAlgorithm minimization_algorithm = 4 [default = RECURSIVE];</code>
   * @return The minimizationAlgorithm.
   */
  @java.lang.Override public com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm getMinimizationAlgorithm() {
    @SuppressWarnings("deprecation")
    com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm result = com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm.valueOf(minimizationAlgorithm_);
    return result == null ? com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm.RECURSIVE : result;
  }

  public static final int BINARY_MINIMIZATION_ALGORITHM_FIELD_NUMBER = 34;
  private int binaryMinimizationAlgorithm_;
  /**
   * <code>optional .operations_research.sat.SatParameters.BinaryMinizationAlgorithm binary_minimization_algorithm = 34 [default = BINARY_MINIMIZATION_FIRST];</code>
   * @return Whether the binaryMinimizationAlgorithm field is set.
   */
  @java.lang.Override public boolean hasBinaryMinimizationAlgorithm() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   * <code>optional .operations_research.sat.SatParameters.BinaryMinizationAlgorithm binary_minimization_algorithm = 34 [default = BINARY_MINIMIZATION_FIRST];</code>
   * @return The binaryMinimizationAlgorithm.
   */
  @java.lang.Override public com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm getBinaryMinimizationAlgorithm() {
    @SuppressWarnings("deprecation")
    com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm result = com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm.valueOf(binaryMinimizationAlgorithm_);
    return result == null ? com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm.BINARY_MINIMIZATION_FIRST : result;
  }

  public static final int SUBSUMPTION_DURING_CONFLICT_ANALYSIS_FIELD_NUMBER = 56;
  private boolean subsumptionDuringConflictAnalysis_;
  /**
   * <pre>
   * At a really low cost, during the 1-UIP conflict computation, it is easy to
   * detect if some of the involved reasons are subsumed by the current
   * conflict. When this is true, such clauses are detached and later removed
   * from the problem.
   * </pre>
   *
   * <code>optional bool subsumption_during_conflict_analysis = 56 [default = true];</code>
   * @return Whether the subsumptionDuringConflictAnalysis field is set.
   */
  @java.lang.Override
  public boolean hasSubsumptionDuringConflictAnalysis() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   * <pre>
   * At a really low cost, during the 1-UIP conflict computation, it is easy to
   * detect if some of the involved reasons are subsumed by the current
   * conflict. When this is true, such clauses are detached and later removed
   * from the problem.
   * </pre>
   *
   * <code>optional bool subsumption_during_conflict_analysis = 56 [default = true];</code>
   * @return The subsumptionDuringConflictAnalysis.
   */
  @java.lang.Override
  public boolean getSubsumptionDuringConflictAnalysis() {
    return subsumptionDuringConflictAnalysis_;
  }

  public static final int CLAUSE_CLEANUP_PERIOD_FIELD_NUMBER = 11;
  private int clauseCleanupPeriod_;
  /**
   * <pre>
   * Trigger a cleanup when this number of "deletable" clauses is learned.
   * </pre>
   *
   * <code>optional int32 clause_cleanup_period = 11 [default = 10000];</code>
   * @return Whether the clauseCleanupPeriod field is set.
   */
  @java.lang.Override
  public boolean hasClauseCleanupPeriod() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   * <pre>
   * Trigger a cleanup when this number of "deletable" clauses is learned.
   * </pre>
   *
   * <code>optional int32 clause_cleanup_period = 11 [default = 10000];</code>
   * @return The clauseCleanupPeriod.
   */
  @java.lang.Override
  public int getClauseCleanupPeriod() {
    return clauseCleanupPeriod_;
  }

  public static final int CLAUSE_CLEANUP_TARGET_FIELD_NUMBER = 13;
  private int clauseCleanupTarget_;
  /**
   * <pre>
   * During a cleanup, we will always keep that number of "deletable" clauses.
   * Note that this doesn't include the "protected" clauses.
   * </pre>
   *
   * <code>optional int32 clause_cleanup_target = 13 [default = 0];</code>
   * @return Whether the clauseCleanupTarget field is set.
   */
  @java.lang.Override
  public boolean hasClauseCleanupTarget() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   * <pre>
   * During a cleanup, we will always keep that number of "deletable" clauses.
   * Note that this doesn't include the "protected" clauses.
   * </pre>
   *
   * <code>optional int32 clause_cleanup_target = 13 [default = 0];</code>
   * @return The clauseCleanupTarget.
   */
  @java.lang.Override
  public int getClauseCleanupTarget() {
    return clauseCleanupTarget_;
  }

  public static final int CLAUSE_CLEANUP_RATIO_FIELD_NUMBER = 190;
  private double clauseCleanupRatio_;
  /**
   * <pre>
   * During a cleanup, if clause_cleanup_target is 0, we will delete the
   * clause_cleanup_ratio of "deletable" clauses instead of aiming for a fixed
   * target of clauses to keep.
   * </pre>
   *
   * <code>optional double clause_cleanup_ratio = 190 [default = 0.5];</code>
   * @return Whether the clauseCleanupRatio field is set.
   */
  @java.lang.Override
  public boolean hasClauseCleanupRatio() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   * <pre>
   * During a cleanup, if clause_cleanup_target is 0, we will delete the
   * clause_cleanup_ratio of "deletable" clauses instead of aiming for a fixed
   * target of clauses to keep.
   * </pre>
   *
   * <code>optional double clause_cleanup_ratio = 190 [default = 0.5];</code>
   * @return The clauseCleanupRatio.
   */
  @java.lang.Override
  public double getClauseCleanupRatio() {
    return clauseCleanupRatio_;
  }

  public static final int CLAUSE_CLEANUP_PROTECTION_FIELD_NUMBER = 58;
  private int clauseCleanupProtection_;
  /**
   * <code>optional .operations_research.sat.SatParameters.ClauseProtection clause_cleanup_protection = 58 [default = PROTECTION_NONE];</code>
   * @return Whether the clauseCleanupProtection field is set.
   */
  @java.lang.Override public boolean hasClauseCleanupProtection() {
    return ((bitField0_ & 0x00010000) != 0);
  }
  /**
   * <code>optional .operations_research.sat.SatParameters.ClauseProtection clause_cleanup_protection = 58 [default = PROTECTION_NONE];</code>
   * @return The clauseCleanupProtection.
   */
  @java.lang.Override public com.google.ortools.sat.SatParameters.ClauseProtection getClauseCleanupProtection() {
    @SuppressWarnings("deprecation")
    com.google.ortools.sat.SatParameters.ClauseProtection result = com.google.ortools.sat.SatParameters.ClauseProtection.valueOf(clauseCleanupProtection_);
    return result == null ? com.google.ortools.sat.SatParameters.ClauseProtection.PROTECTION_NONE : result;
  }

  public static final int CLAUSE_CLEANUP_LBD_BOUND_FIELD_NUMBER = 59;
  private int clauseCleanupLbdBound_;
  /**
   * <pre>
   * All the clauses with a LBD (literal blocks distance) lower or equal to this
   * parameters will always be kept.
   * </pre>
   *
   * <code>optional int32 clause_cleanup_lbd_bound = 59 [default = 5];</code>
   * @return Whether the clauseCleanupLbdBound field is set.
   */
  @java.lang.Override
  public boolean hasClauseCleanupLbdBound() {
    return ((bitField0_ & 0x00020000) != 0);
  }
  /**
   * <pre>
   * All the clauses with a LBD (literal blocks distance) lower or equal to this
   * parameters will always be kept.
   * </pre>
   *
   * <code>optional int32 clause_cleanup_lbd_bound = 59 [default = 5];</code>
   * @return The clauseCleanupLbdBound.
   */
  @java.lang.Override
  public int getClauseCleanupLbdBound() {
    return clauseCleanupLbdBound_;
  }

  public static final int CLAUSE_CLEANUP_ORDERING_FIELD_NUMBER = 60;
  private int clauseCleanupOrdering_;
  /**
   * <code>optional .operations_research.sat.SatParameters.ClauseOrdering clause_cleanup_ordering = 60 [default = CLAUSE_ACTIVITY];</code>
   * @return Whether the clauseCleanupOrdering field is set.
   */
  @java.lang.Override public boolean hasClauseCleanupOrdering() {
    return ((bitField0_ & 0x00040000) != 0);
  }
  /**
   * <code>optional .operations_research.sat.SatParameters.ClauseOrdering clause_cleanup_ordering = 60 [default = CLAUSE_ACTIVITY];</code>
   * @return The clauseCleanupOrdering.
   */
  @java.lang.Override public com.google.ortools.sat.SatParameters.ClauseOrdering getClauseCleanupOrdering() {
    @SuppressWarnings("deprecation")
    com.google.ortools.sat.SatParameters.ClauseOrdering result = com.google.ortools.sat.SatParameters.ClauseOrdering.valueOf(clauseCleanupOrdering_);
    return result == null ? com.google.ortools.sat.SatParameters.ClauseOrdering.CLAUSE_ACTIVITY : result;
  }

  public static final int PB_CLEANUP_INCREMENT_FIELD_NUMBER = 46;
  private int pbCleanupIncrement_;
  /**
   * <pre>
   * Same as for the clauses, but for the learned pseudo-Boolean constraints.
   * </pre>
   *
   * <code>optional int32 pb_cleanup_increment = 46 [default = 200];</code>
   * @return Whether the pbCleanupIncrement field is set.
   */
  @java.lang.Override
  public boolean hasPbCleanupIncrement() {
    return ((bitField0_ & 0x00080000) != 0);
  }
  /**
   * <pre>
   * Same as for the clauses, but for the learned pseudo-Boolean constraints.
   * </pre>
   *
   * <code>optional int32 pb_cleanup_increment = 46 [default = 200];</code>
   * @return The pbCleanupIncrement.
   */
  @java.lang.Override
  public int getPbCleanupIncrement() {
    return pbCleanupIncrement_;
  }

  public static final int PB_CLEANUP_RATIO_FIELD_NUMBER = 47;
  private double pbCleanupRatio_;
  /**
   * <code>optional double pb_cleanup_ratio = 47 [default = 0.5];</code>
   * @return Whether the pbCleanupRatio field is set.
   */
  @java.lang.Override
  public boolean hasPbCleanupRatio() {
    return ((bitField0_ & 0x00100000) != 0);
  }
  /**
   * <code>optional double pb_cleanup_ratio = 47 [default = 0.5];</code>
   * @return The pbCleanupRatio.
   */
  @java.lang.Override
  public double getPbCleanupRatio() {
    return pbCleanupRatio_;
  }

  public static final int MINIMIZE_WITH_PROPAGATION_RESTART_PERIOD_FIELD_NUMBER = 96;
  private int minimizeWithPropagationRestartPeriod_;
  /**
   * <pre>
   * Parameters for an heuristic similar to the one descibed in "An effective
   * learnt clause minimization approach for CDCL Sat Solvers",
   * https://www.ijcai.org/proceedings/2017/0098.pdf
   * For now, we have a somewhat simpler implementation where every x restart we
   * spend y decisions on clause minimization. The minimization technique is the
   * same as the one used to minimize core in max-sat. We also minimize problem
   * clauses and not just the learned clause that we keep forever like in the
   * paper.
   * Changing these parameters or the kind of clause we minimize seems to have
   * a big impact on the overall perf on our benchmarks. So this technique seems
   * definitely useful, but it is hard to tune properly.
   * </pre>
   *
   * <code>optional int32 minimize_with_propagation_restart_period = 96 [default = 10];</code>
   * @return Whether the minimizeWithPropagationRestartPeriod field is set.
   */
  @java.lang.Override
  public boolean hasMinimizeWithPropagationRestartPeriod() {
    return ((bitField0_ & 0x00200000) != 0);
  }
  /**
   * <pre>
   * Parameters for an heuristic similar to the one descibed in "An effective
   * learnt clause minimization approach for CDCL Sat Solvers",
   * https://www.ijcai.org/proceedings/2017/0098.pdf
   * For now, we have a somewhat simpler implementation where every x restart we
   * spend y decisions on clause minimization. The minimization technique is the
   * same as the one used to minimize core in max-sat. We also minimize problem
   * clauses and not just the learned clause that we keep forever like in the
   * paper.
   * Changing these parameters or the kind of clause we minimize seems to have
   * a big impact on the overall perf on our benchmarks. So this technique seems
   * definitely useful, but it is hard to tune properly.
   * </pre>
   *
   * <code>optional int32 minimize_with_propagation_restart_period = 96 [default = 10];</code>
   * @return The minimizeWithPropagationRestartPeriod.
   */
  @java.lang.Override
  public int getMinimizeWithPropagationRestartPeriod() {
    return minimizeWithPropagationRestartPeriod_;
  }

  public static final int MINIMIZE_WITH_PROPAGATION_NUM_DECISIONS_FIELD_NUMBER = 97;
  private int minimizeWithPropagationNumDecisions_;
  /**
   * <code>optional int32 minimize_with_propagation_num_decisions = 97 [default = 1000];</code>
   * @return Whether the minimizeWithPropagationNumDecisions field is set.
   */
  @java.lang.Override
  public boolean hasMinimizeWithPropagationNumDecisions() {
    return ((bitField0_ & 0x00400000) != 0);
  }
  /**
   * <code>optional int32 minimize_with_propagation_num_decisions = 97 [default = 1000];</code>
   * @return The minimizeWithPropagationNumDecisions.
   */
  @java.lang.Override
  public int getMinimizeWithPropagationNumDecisions() {
    return minimizeWithPropagationNumDecisions_;
  }

  public static final int VARIABLE_ACTIVITY_DECAY_FIELD_NUMBER = 15;
  private double variableActivityDecay_;
  /**
   * <pre>
   * Each time a conflict is found, the activities of some variables are
   * increased by one. Then, the activity of all variables are multiplied by
   * variable_activity_decay.
   * To implement this efficiently, the activity of all the variables is not
   * decayed at each conflict. Instead, the activity increment is multiplied by
   * 1 / decay. When an activity reach max_variable_activity_value, all the
   * activity are multiplied by 1 / max_variable_activity_value.
   * </pre>
   *
   * <code>optional double variable_activity_decay = 15 [default = 0.8];</code>
   * @return Whether the variableActivityDecay field is set.
   */
  @java.lang.Override
  public boolean hasVariableActivityDecay() {
    return ((bitField0_ & 0x00800000) != 0);
  }
  /**
   * <pre>
   * Each time a conflict is found, the activities of some variables are
   * increased by one. Then, the activity of all variables are multiplied by
   * variable_activity_decay.
   * To implement this efficiently, the activity of all the variables is not
   * decayed at each conflict. Instead, the activity increment is multiplied by
   * 1 / decay. When an activity reach max_variable_activity_value, all the
   * activity are multiplied by 1 / max_variable_activity_value.
   * </pre>
   *
   * <code>optional double variable_activity_decay = 15 [default = 0.8];</code>
   * @return The variableActivityDecay.
   */
  @java.lang.Override
  public double getVariableActivityDecay() {
    return variableActivityDecay_;
  }

  public static final int MAX_VARIABLE_ACTIVITY_VALUE_FIELD_NUMBER = 16;
  private double maxVariableActivityValue_;
  /**
   * <code>optional double max_variable_activity_value = 16 [default = 1e+100];</code>
   * @return Whether the maxVariableActivityValue field is set.
   */
  @java.lang.Override
  public boolean hasMaxVariableActivityValue() {
    return ((bitField0_ & 0x01000000) != 0);
  }
  /**
   * <code>optional double max_variable_activity_value = 16 [default = 1e+100];</code>
   * @return The maxVariableActivityValue.
   */
  @java.lang.Override
  public double getMaxVariableActivityValue() {
    return maxVariableActivityValue_;
  }

  public static final int GLUCOSE_MAX_DECAY_FIELD_NUMBER = 22;
  private double glucoseMaxDecay_;
  /**
   * <pre>
   * The activity starts at 0.8 and increment by 0.01 every 5000 conflicts until
   * 0.95. This "hack" seems to work well and comes from:
   * Glucose 2.3 in the SAT 2013 Competition - SAT Competition 2013
   * http://edacc4.informatik.uni-ulm.de/SC13/solver-description-download/136
   * </pre>
   *
   * <code>optional double glucose_max_decay = 22 [default = 0.95];</code>
   * @return Whether the glucoseMaxDecay field is set.
   */
  @java.lang.Override
  public boolean hasGlucoseMaxDecay() {
    return ((bitField0_ & 0x02000000) != 0);
  }
  /**
   * <pre>
   * The activity starts at 0.8 and increment by 0.01 every 5000 conflicts until
   * 0.95. This "hack" seems to work well and comes from:
   * Glucose 2.3 in the SAT 2013 Competition - SAT Competition 2013
   * http://edacc4.informatik.uni-ulm.de/SC13/solver-description-download/136
   * </pre>
   *
   * <code>optional double glucose_max_decay = 22 [default = 0.95];</code>
   * @return The glucoseMaxDecay.
   */
  @java.lang.Override
  public double getGlucoseMaxDecay() {
    return glucoseMaxDecay_;
  }

  public static final int GLUCOSE_DECAY_INCREMENT_FIELD_NUMBER = 23;
  private double glucoseDecayIncrement_;
  /**
   * <code>optional double glucose_decay_increment = 23 [default = 0.01];</code>
   * @return Whether the glucoseDecayIncrement field is set.
   */
  @java.lang.Override
  public boolean hasGlucoseDecayIncrement() {
    return ((bitField0_ & 0x04000000) != 0);
  }
  /**
   * <code>optional double glucose_decay_increment = 23 [default = 0.01];</code>
   * @return The glucoseDecayIncrement.
   */
  @java.lang.Override
  public double getGlucoseDecayIncrement() {
    return glucoseDecayIncrement_;
  }

  public static final int GLUCOSE_DECAY_INCREMENT_PERIOD_FIELD_NUMBER = 24;
  private int glucoseDecayIncrementPeriod_;
  /**
   * <code>optional int32 glucose_decay_increment_period = 24 [default = 5000];</code>
   * @return Whether the glucoseDecayIncrementPeriod field is set.
   */
  @java.lang.Override
  public boolean hasGlucoseDecayIncrementPeriod() {
    return ((bitField0_ & 0x08000000) != 0);
  }
  /**
   * <code>optional int32 glucose_decay_increment_period = 24 [default = 5000];</code>
   * @return The glucoseDecayIncrementPeriod.
   */
  @java.lang.Override
  public int getGlucoseDecayIncrementPeriod() {
    return glucoseDecayIncrementPeriod_;
  }

  public static final int CLAUSE_ACTIVITY_DECAY_FIELD_NUMBER = 17;
  private double clauseActivityDecay_;
  /**
   * <pre>
   * Clause activity parameters (same effect as the one on the variables).
   * </pre>
   *
   * <code>optional double clause_activity_decay = 17 [default = 0.999];</code>
   * @return Whether the clauseActivityDecay field is set.
   */
  @java.lang.Override
  public boolean hasClauseActivityDecay() {
    return ((bitField0_ & 0x10000000) != 0);
  }
  /**
   * <pre>
   * Clause activity parameters (same effect as the one on the variables).
   * </pre>
   *
   * <code>optional double clause_activity_decay = 17 [default = 0.999];</code>
   * @return The clauseActivityDecay.
   */
  @java.lang.Override
  public double getClauseActivityDecay() {
    return clauseActivityDecay_;
  }

  public static final int MAX_CLAUSE_ACTIVITY_VALUE_FIELD_NUMBER = 18;
  private double maxClauseActivityValue_;
  /**
   * <code>optional double max_clause_activity_value = 18 [default = 1e+20];</code>
   * @return Whether the maxClauseActivityValue field is set.
   */
  @java.lang.Override
  public boolean hasMaxClauseActivityValue() {
    return ((bitField0_ & 0x20000000) != 0);
  }
  /**
   * <code>optional double max_clause_activity_value = 18 [default = 1e+20];</code>
   * @return The maxClauseActivityValue.
   */
  @java.lang.Override
  public double getMaxClauseActivityValue() {
    return maxClauseActivityValue_;
  }

  public static final int RESTART_ALGORITHMS_FIELD_NUMBER = 61;
  private java.util.List<java.lang.Integer> restartAlgorithms_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
      java.lang.Integer, com.google.ortools.sat.SatParameters.RestartAlgorithm> restartAlgorithms_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.ortools.sat.SatParameters.RestartAlgorithm>() {
            public com.google.ortools.sat.SatParameters.RestartAlgorithm convert(java.lang.Integer from) {
              @SuppressWarnings("deprecation")
              com.google.ortools.sat.SatParameters.RestartAlgorithm result = com.google.ortools.sat.SatParameters.RestartAlgorithm.valueOf(from);
              return result == null ? com.google.ortools.sat.SatParameters.RestartAlgorithm.NO_RESTART : result;
            }
          };
  /**
   * <pre>
   * The restart strategies will change each time the strategy_counter is
   * increased. The current strategy will simply be the one at index
   * strategy_counter modulo the number of strategy. Note that if this list
   * includes a NO_RESTART, nothing will change when it is reached because the
   * strategy_counter will only increment after a restart.
   * The idea of switching of search strategy tailored for SAT/UNSAT comes from
   * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
   * But more generally, it seems REALLY beneficial to try different strategy.
   * </pre>
   *
   * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
   * @return A list containing the restartAlgorithms.
   */
  @java.lang.Override
  public java.util.List<com.google.ortools.sat.SatParameters.RestartAlgorithm> getRestartAlgorithmsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.ortools.sat.SatParameters.RestartAlgorithm>(restartAlgorithms_, restartAlgorithms_converter_);
  }
  /**
   * <pre>
   * The restart strategies will change each time the strategy_counter is
   * increased. The current strategy will simply be the one at index
   * strategy_counter modulo the number of strategy. Note that if this list
   * includes a NO_RESTART, nothing will change when it is reached because the
   * strategy_counter will only increment after a restart.
   * The idea of switching of search strategy tailored for SAT/UNSAT comes from
   * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
   * But more generally, it seems REALLY beneficial to try different strategy.
   * </pre>
   *
   * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
   * @return The count of restartAlgorithms.
   */
  @java.lang.Override
  public int getRestartAlgorithmsCount() {
    return restartAlgorithms_.size();
  }
  /**
   * <pre>
   * The restart strategies will change each time the strategy_counter is
   * increased. The current strategy will simply be the one at index
   * strategy_counter modulo the number of strategy. Note that if this list
   * includes a NO_RESTART, nothing will change when it is reached because the
   * strategy_counter will only increment after a restart.
   * The idea of switching of search strategy tailored for SAT/UNSAT comes from
   * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
   * But more generally, it seems REALLY beneficial to try different strategy.
   * </pre>
   *
   * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
   * @param index The index of the element to return.
   * @return The restartAlgorithms at the given index.
   */
  @java.lang.Override
  public com.google.ortools.sat.SatParameters.RestartAlgorithm getRestartAlgorithms(int index) {
    return restartAlgorithms_converter_.convert(restartAlgorithms_.get(index));
  }

  public static final int DEFAULT_RESTART_ALGORITHMS_FIELD_NUMBER = 70;
  private volatile java.lang.Object defaultRestartAlgorithms_;
  /**
   * <code>optional string default_restart_algorithms = 70 [default = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART"];</code>
   * @return Whether the defaultRestartAlgorithms field is set.
   */
  @java.lang.Override
  public boolean hasDefaultRestartAlgorithms() {
    return ((bitField0_ & 0x40000000) != 0);
  }
  /**
   * <code>optional string default_restart_algorithms = 70 [default = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART"];</code>
   * @return The defaultRestartAlgorithms.
   */
  @java.lang.Override
  public java.lang.String getDefaultRestartAlgorithms() {
    java.lang.Object ref = defaultRestartAlgorithms_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (bs.isValidUtf8()) {
        defaultRestartAlgorithms_ = s;
      }
      return s;
    }
  }
  /**
   * <code>optional string default_restart_algorithms = 70 [default = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART"];</code>
   * @return The bytes for defaultRestartAlgorithms.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getDefaultRestartAlgorithmsBytes() {
    java.lang.Object ref = defaultRestartAlgorithms_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      defaultRestartAlgorithms_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESTART_PERIOD_FIELD_NUMBER = 30;
  private int restartPeriod_;
  /**
   * <pre>
   * Restart period for the FIXED_RESTART strategy. This is also the multiplier
   * used by the LUBY_RESTART strategy.
   * </pre>
   *
   * <code>optional int32 restart_period = 30 [default = 50];</code>
   * @return Whether the restartPeriod field is set.
   */
  @java.lang.Override
  public boolean hasRestartPeriod() {
    return ((bitField0_ & 0x80000000) != 0);
  }
  /**
   * <pre>
   * Restart period for the FIXED_RESTART strategy. This is also the multiplier
   * used by the LUBY_RESTART strategy.
   * </pre>
   *
   * <code>optional int32 restart_period = 30 [default = 50];</code>
   * @return The restartPeriod.
   */
  @java.lang.Override
  public int getRestartPeriod() {
    return restartPeriod_;
  }

  public static final int RESTART_RUNNING_WINDOW_SIZE_FIELD_NUMBER = 62;
  private int restartRunningWindowSize_;
  /**
   * <pre>
   * Size of the window for the moving average restarts.
   * </pre>
   *
   * <code>optional int32 restart_running_window_size = 62 [default = 50];</code>
   * @return Whether the restartRunningWindowSize field is set.
   */
  @java.lang.Override
  public boolean hasRestartRunningWindowSize() {
    return ((bitField1_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Size of the window for the moving average restarts.
   * </pre>
   *
   * <code>optional int32 restart_running_window_size = 62 [default = 50];</code>
   * @return The restartRunningWindowSize.
   */
  @java.lang.Override
  public int getRestartRunningWindowSize() {
    return restartRunningWindowSize_;
  }

  public static final int RESTART_DL_AVERAGE_RATIO_FIELD_NUMBER = 63;
  private double restartDlAverageRatio_;
  /**
   * <pre>
   * In the moving average restart algorithms, a restart is triggered if the
   * window average times this ratio is greater that the global average.
   * </pre>
   *
   * <code>optional double restart_dl_average_ratio = 63 [default = 1];</code>
   * @return Whether the restartDlAverageRatio field is set.
   */
  @java.lang.Override
  public boolean hasRestartDlAverageRatio() {
    return ((bitField1_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * In the moving average restart algorithms, a restart is triggered if the
   * window average times this ratio is greater that the global average.
   * </pre>
   *
   * <code>optional double restart_dl_average_ratio = 63 [default = 1];</code>
   * @return The restartDlAverageRatio.
   */
  @java.lang.Override
  public double getRestartDlAverageRatio() {
    return restartDlAverageRatio_;
  }

  public static final int RESTART_LBD_AVERAGE_RATIO_FIELD_NUMBER = 71;
  private double restartLbdAverageRatio_;
  /**
   * <code>optional double restart_lbd_average_ratio = 71 [default = 1];</code>
   * @return Whether the restartLbdAverageRatio field is set.
   */
  @java.lang.Override
  public boolean hasRestartLbdAverageRatio() {
    return ((bitField1_ & 0x00000004) != 0);
  }
  /**
   * <code>optional double restart_lbd_average_ratio = 71 [default = 1];</code>
   * @return The restartLbdAverageRatio.
   */
  @java.lang.Override
  public double getRestartLbdAverageRatio() {
    return restartLbdAverageRatio_;
  }

  public static final int USE_BLOCKING_RESTART_FIELD_NUMBER = 64;
  private boolean useBlockingRestart_;
  /**
   * <pre>
   * Block a moving restart algorithm if the trail size of the current conflict
   * is greater than the multiplier times the moving average of the trail size
   * at the previous conflicts.
   * </pre>
   *
   * <code>optional bool use_blocking_restart = 64 [default = false];</code>
   * @return Whether the useBlockingRestart field is set.
   */
  @java.lang.Override
  public boolean hasUseBlockingRestart() {
    return ((bitField1_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * Block a moving restart algorithm if the trail size of the current conflict
   * is greater than the multiplier times the moving average of the trail size
   * at the previous conflicts.
   * </pre>
   *
   * <code>optional bool use_blocking_restart = 64 [default = false];</code>
   * @return The useBlockingRestart.
   */
  @java.lang.Override
  public boolean getUseBlockingRestart() {
    return useBlockingRestart_;
  }

  public static final int BLOCKING_RESTART_WINDOW_SIZE_FIELD_NUMBER = 65;
  private int blockingRestartWindowSize_;
  /**
   * <code>optional int32 blocking_restart_window_size = 65 [default = 5000];</code>
   * @return Whether the blockingRestartWindowSize field is set.
   */
  @java.lang.Override
  public boolean hasBlockingRestartWindowSize() {
    return ((bitField1_ & 0x00000010) != 0);
  }
  /**
   * <code>optional int32 blocking_restart_window_size = 65 [default = 5000];</code>
   * @return The blockingRestartWindowSize.
   */
  @java.lang.Override
  public int getBlockingRestartWindowSize() {
    return blockingRestartWindowSize_;
  }

  public static final int BLOCKING_RESTART_MULTIPLIER_FIELD_NUMBER = 66;
  private double blockingRestartMultiplier_;
  /**
   * <code>optional double blocking_restart_multiplier = 66 [default = 1.4];</code>
   * @return Whether the blockingRestartMultiplier field is set.
   */
  @java.lang.Override
  public boolean hasBlockingRestartMultiplier() {
    return ((bitField1_ & 0x00000020) != 0);
  }
  /**
   * <code>optional double blocking_restart_multiplier = 66 [default = 1.4];</code>
   * @return The blockingRestartMultiplier.
   */
  @java.lang.Override
  public double getBlockingRestartMultiplier() {
    return blockingRestartMultiplier_;
  }

  public static final int NUM_CONFLICTS_BEFORE_STRATEGY_CHANGES_FIELD_NUMBER = 68;
  private int numConflictsBeforeStrategyChanges_;
  /**
   * <pre>
   * After each restart, if the number of conflict since the last strategy
   * change is greater that this, then we increment a "strategy_counter" that
   * can be use to change the search strategy used by the following restarts.
   * </pre>
   *
   * <code>optional int32 num_conflicts_before_strategy_changes = 68 [default = 0];</code>
   * @return Whether the numConflictsBeforeStrategyChanges field is set.
   */
  @java.lang.Override
  public boolean hasNumConflictsBeforeStrategyChanges() {
    return ((bitField1_ & 0x00000040) != 0);
  }
  /**
   * <pre>
   * After each restart, if the number of conflict since the last strategy
   * change is greater that this, then we increment a "strategy_counter" that
   * can be use to change the search strategy used by the following restarts.
   * </pre>
   *
   * <code>optional int32 num_conflicts_before_strategy_changes = 68 [default = 0];</code>
   * @return The numConflictsBeforeStrategyChanges.
   */
  @java.lang.Override
  public int getNumConflictsBeforeStrategyChanges() {
    return numConflictsBeforeStrategyChanges_;
  }

  public static final int STRATEGY_CHANGE_INCREASE_RATIO_FIELD_NUMBER = 69;
  private double strategyChangeIncreaseRatio_;
  /**
   * <pre>
   * The parameter num_conflicts_before_strategy_changes is increased by that
   * much after each strategy change.
   * </pre>
   *
   * <code>optional double strategy_change_increase_ratio = 69 [default = 0];</code>
   * @return Whether the strategyChangeIncreaseRatio field is set.
   */
  @java.lang.Override
  public boolean hasStrategyChangeIncreaseRatio() {
    return ((bitField1_ & 0x00000080) != 0);
  }
  /**
   * <pre>
   * The parameter num_conflicts_before_strategy_changes is increased by that
   * much after each strategy change.
   * </pre>
   *
   * <code>optional double strategy_change_increase_ratio = 69 [default = 0];</code>
   * @return The strategyChangeIncreaseRatio.
   */
  @java.lang.Override
  public double getStrategyChangeIncreaseRatio() {
    return strategyChangeIncreaseRatio_;
  }

  public static final int MAX_TIME_IN_SECONDS_FIELD_NUMBER = 36;
  private double maxTimeInSeconds_;
  /**
   * <pre>
   * Maximum time allowed in seconds to solve a problem.
   * The counter will starts at the beginning of the Solve() call.
   * </pre>
   *
   * <code>optional double max_time_in_seconds = 36 [default = inf];</code>
   * @return Whether the maxTimeInSeconds field is set.
   */
  @java.lang.Override
  public boolean hasMaxTimeInSeconds() {
    return ((bitField1_ & 0x00000100) != 0);
  }
  /**
   * <pre>
   * Maximum time allowed in seconds to solve a problem.
   * The counter will starts at the beginning of the Solve() call.
   * </pre>
   *
   * <code>optional double max_time_in_seconds = 36 [default = inf];</code>
   * @return The maxTimeInSeconds.
   */
  @java.lang.Override
  public double getMaxTimeInSeconds() {
    return maxTimeInSeconds_;
  }

  public static final int MAX_DETERMINISTIC_TIME_FIELD_NUMBER = 67;
  private double maxDeterministicTime_;
  /**
   * <pre>
   * Maximum time allowed in deterministic time to solve a problem.
   * The deterministic time should be correlated with the real time used by the
   * solver, the time unit being as close as possible to a second.
   * </pre>
   *
   * <code>optional double max_deterministic_time = 67 [default = inf];</code>
   * @return Whether the maxDeterministicTime field is set.
   */
  @java.lang.Override
  public boolean hasMaxDeterministicTime() {
    return ((bitField1_ & 0x00000200) != 0);
  }
  /**
   * <pre>
   * Maximum time allowed in deterministic time to solve a problem.
   * The deterministic time should be correlated with the real time used by the
   * solver, the time unit being as close as possible to a second.
   * </pre>
   *
   * <code>optional double max_deterministic_time = 67 [default = inf];</code>
   * @return The maxDeterministicTime.
   */
  @java.lang.Override
  public double getMaxDeterministicTime() {
    return maxDeterministicTime_;
  }

  public static final int MAX_NUMBER_OF_CONFLICTS_FIELD_NUMBER = 37;
  private long maxNumberOfConflicts_;
  /**
   * <pre>
   * Maximum number of conflicts allowed to solve a problem.
   * TODO(user,user): Maybe change the way the conflict limit is enforced?
   * currently it is enforced on each independent internal SAT solve, rather
   * than on the overall number of conflicts across all solves. So in the
   * context of an optimization problem, this is not really usable directly by a
   * client.
   * </pre>
   *
   * <code>optional int64 max_number_of_conflicts = 37 [default = 9223372036854775807];</code>
   * @return Whether the maxNumberOfConflicts field is set.
   */
  @java.lang.Override
  public boolean hasMaxNumberOfConflicts() {
    return ((bitField1_ & 0x00000400) != 0);
  }
  /**
   * <pre>
   * Maximum number of conflicts allowed to solve a problem.
   * TODO(user,user): Maybe change the way the conflict limit is enforced?
   * currently it is enforced on each independent internal SAT solve, rather
   * than on the overall number of conflicts across all solves. So in the
   * context of an optimization problem, this is not really usable directly by a
   * client.
   * </pre>
   *
   * <code>optional int64 max_number_of_conflicts = 37 [default = 9223372036854775807];</code>
   * @return The maxNumberOfConflicts.
   */
  @java.lang.Override
  public long getMaxNumberOfConflicts() {
    return maxNumberOfConflicts_;
  }

  public static final int MAX_MEMORY_IN_MB_FIELD_NUMBER = 40;
  private long maxMemoryInMb_;
  /**
   * <pre>
   * Maximum memory allowed for the whole thread containing the solver. The
   * solver will abort as soon as it detects that this limit is crossed. As a
   * result, this limit is approximative, but usually the solver will not go too
   * much over.
   * </pre>
   *
   * <code>optional int64 max_memory_in_mb = 40 [default = 10000];</code>
   * @return Whether the maxMemoryInMb field is set.
   */
  @java.lang.Override
  public boolean hasMaxMemoryInMb() {
    return ((bitField1_ & 0x00000800) != 0);
  }
  /**
   * <pre>
   * Maximum memory allowed for the whole thread containing the solver. The
   * solver will abort as soon as it detects that this limit is crossed. As a
   * result, this limit is approximative, but usually the solver will not go too
   * much over.
   * </pre>
   *
   * <code>optional int64 max_memory_in_mb = 40 [default = 10000];</code>
   * @return The maxMemoryInMb.
   */
  @java.lang.Override
  public long getMaxMemoryInMb() {
    return maxMemoryInMb_;
  }

  public static final int ABSOLUTE_GAP_LIMIT_FIELD_NUMBER = 159;
  private double absoluteGapLimit_;
  /**
   * <pre>
   * Stop the search when the gap between the best feasible objective (O) and
   * our best objective bound (B) is smaller than a limit.
   * The exact definition is:
   * - Absolute: abs(O - B)
   * - Relative: abs(O - B) / max(1, abs(O)).
   * Important: The relative gap depends on the objective offset! If you
   * artificially shift the objective, you will get widely different value of
   * the relative gap.
   * Note that if the gap is reached, the search status will be OPTIMAL. But
   * one can check the best objective bound to see the actual gap.
   * </pre>
   *
   * <code>optional double absolute_gap_limit = 159 [default = 0];</code>
   * @return Whether the absoluteGapLimit field is set.
   */
  @java.lang.Override
  public boolean hasAbsoluteGapLimit() {
    return ((bitField1_ & 0x00001000) != 0);
  }
  /**
   * <pre>
   * Stop the search when the gap between the best feasible objective (O) and
   * our best objective bound (B) is smaller than a limit.
   * The exact definition is:
   * - Absolute: abs(O - B)
   * - Relative: abs(O - B) / max(1, abs(O)).
   * Important: The relative gap depends on the objective offset! If you
   * artificially shift the objective, you will get widely different value of
   * the relative gap.
   * Note that if the gap is reached, the search status will be OPTIMAL. But
   * one can check the best objective bound to see the actual gap.
   * </pre>
   *
   * <code>optional double absolute_gap_limit = 159 [default = 0];</code>
   * @return The absoluteGapLimit.
   */
  @java.lang.Override
  public double getAbsoluteGapLimit() {
    return absoluteGapLimit_;
  }

  public static final int RELATIVE_GAP_LIMIT_FIELD_NUMBER = 160;
  private double relativeGapLimit_;
  /**
   * <code>optional double relative_gap_limit = 160 [default = 0];</code>
   * @return Whether the relativeGapLimit field is set.
   */
  @java.lang.Override
  public boolean hasRelativeGapLimit() {
    return ((bitField1_ & 0x00002000) != 0);
  }
  /**
   * <code>optional double relative_gap_limit = 160 [default = 0];</code>
   * @return The relativeGapLimit.
   */
  @java.lang.Override
  public double getRelativeGapLimit() {
    return relativeGapLimit_;
  }

  public static final int TREAT_BINARY_CLAUSES_SEPARATELY_FIELD_NUMBER = 33;
  private boolean treatBinaryClausesSeparately_;
  /**
   * <pre>
   * If true, the binary clauses are treated separately from the others. This
   * should be faster and uses less memory. However it changes the propagation
   * order.
   * </pre>
   *
   * <code>optional bool treat_binary_clauses_separately = 33 [default = true];</code>
   * @return Whether the treatBinaryClausesSeparately field is set.
   */
  @java.lang.Override
  public boolean hasTreatBinaryClausesSeparately() {
    return ((bitField1_ & 0x00004000) != 0);
  }
  /**
   * <pre>
   * If true, the binary clauses are treated separately from the others. This
   * should be faster and uses less memory. However it changes the propagation
   * order.
   * </pre>
   *
   * <code>optional bool treat_binary_clauses_separately = 33 [default = true];</code>
   * @return The treatBinaryClausesSeparately.
   */
  @java.lang.Override
  public boolean getTreatBinaryClausesSeparately() {
    return treatBinaryClausesSeparately_;
  }

  public static final int RANDOM_SEED_FIELD_NUMBER = 31;
  private int randomSeed_;
  /**
   * <pre>
   * At the beginning of each solve, the random number generator used in some
   * part of the solver is reinitialized to this seed. If you change the random
   * seed, the solver may make different choices during the solving process.
   * For some problems, the running time may vary a lot depending on small
   * change in the solving algorithm. Running the solver with different seeds
   * enables to have more robust benchmarks when evaluating new features.
   * </pre>
   *
   * <code>optional int32 random_seed = 31 [default = 1];</code>
   * @return Whether the randomSeed field is set.
   */
  @java.lang.Override
  public boolean hasRandomSeed() {
    return ((bitField1_ & 0x00008000) != 0);
  }
  /**
   * <pre>
   * At the beginning of each solve, the random number generator used in some
   * part of the solver is reinitialized to this seed. If you change the random
   * seed, the solver may make different choices during the solving process.
   * For some problems, the running time may vary a lot depending on small
   * change in the solving algorithm. Running the solver with different seeds
   * enables to have more robust benchmarks when evaluating new features.
   * </pre>
   *
   * <code>optional int32 random_seed = 31 [default = 1];</code>
   * @return The randomSeed.
   */
  @java.lang.Override
  public int getRandomSeed() {
    return randomSeed_;
  }

  public static final int PERMUTE_VARIABLE_RANDOMLY_FIELD_NUMBER = 178;
  private boolean permuteVariableRandomly_;
  /**
   * <pre>
   * This is mainly here to test the solver variability. Note that in tests, if
   * not explicitly set to false, all 3 options will be set to true so that
   * clients do not rely on the solver returning a specific solution if they are
   * many equivalent optimal solutions.
   * </pre>
   *
   * <code>optional bool permute_variable_randomly = 178 [default = false];</code>
   * @return Whether the permuteVariableRandomly field is set.
   */
  @java.lang.Override
  public boolean hasPermuteVariableRandomly() {
    return ((bitField1_ & 0x00010000) != 0);
  }
  /**
   * <pre>
   * This is mainly here to test the solver variability. Note that in tests, if
   * not explicitly set to false, all 3 options will be set to true so that
   * clients do not rely on the solver returning a specific solution if they are
   * many equivalent optimal solutions.
   * </pre>
   *
   * <code>optional bool permute_variable_randomly = 178 [default = false];</code>
   * @return The permuteVariableRandomly.
   */
  @java.lang.Override
  public boolean getPermuteVariableRandomly() {
    return permuteVariableRandomly_;
  }

  public static final int PERMUTE_PRESOLVE_CONSTRAINT_ORDER_FIELD_NUMBER = 179;
  private boolean permutePresolveConstraintOrder_;
  /**
   * <code>optional bool permute_presolve_constraint_order = 179 [default = false];</code>
   * @return Whether the permutePresolveConstraintOrder field is set.
   */
  @java.lang.Override
  public boolean hasPermutePresolveConstraintOrder() {
    return ((bitField1_ & 0x00020000) != 0);
  }
  /**
   * <code>optional bool permute_presolve_constraint_order = 179 [default = false];</code>
   * @return The permutePresolveConstraintOrder.
   */
  @java.lang.Override
  public boolean getPermutePresolveConstraintOrder() {
    return permutePresolveConstraintOrder_;
  }

  public static final int USE_ABSL_RANDOM_FIELD_NUMBER = 180;
  private boolean useAbslRandom_;
  /**
   * <code>optional bool use_absl_random = 180 [default = false];</code>
   * @return Whether the useAbslRandom field is set.
   */
  @java.lang.Override
  public boolean hasUseAbslRandom() {
    return ((bitField1_ & 0x00040000) != 0);
  }
  /**
   * <code>optional bool use_absl_random = 180 [default = false];</code>
   * @return The useAbslRandom.
   */
  @java.lang.Override
  public boolean getUseAbslRandom() {
    return useAbslRandom_;
  }

  public static final int LOG_SEARCH_PROGRESS_FIELD_NUMBER = 41;
  private boolean logSearchProgress_;
  /**
   * <pre>
   * Whether the solver should log the search progress. By default, it logs to
   * LOG(INFO). This can be overwritten by the log_destination parameter.
   * </pre>
   *
   * <code>optional bool log_search_progress = 41 [default = false];</code>
   * @return Whether the logSearchProgress field is set.
   */
  @java.lang.Override
  public boolean hasLogSearchProgress() {
    return ((bitField1_ & 0x00080000) != 0);
  }
  /**
   * <pre>
   * Whether the solver should log the search progress. By default, it logs to
   * LOG(INFO). This can be overwritten by the log_destination parameter.
   * </pre>
   *
   * <code>optional bool log_search_progress = 41 [default = false];</code>
   * @return The logSearchProgress.
   */
  @java.lang.Override
  public boolean getLogSearchProgress() {
    return logSearchProgress_;
  }

  public static final int LOG_SUBSOLVER_STATISTICS_FIELD_NUMBER = 189;
  private boolean logSubsolverStatistics_;
  /**
   * <pre>
   * Whether the solver should display per sub-solver search statistics.
   * This is only useful is log_search_progress is set to true, and if the
   * number of search workers is &gt; 1.
   * </pre>
   *
   * <code>optional bool log_subsolver_statistics = 189 [default = true];</code>
   * @return Whether the logSubsolverStatistics field is set.
   */
  @java.lang.Override
  public boolean hasLogSubsolverStatistics() {
    return ((bitField1_ & 0x00100000) != 0);
  }
  /**
   * <pre>
   * Whether the solver should display per sub-solver search statistics.
   * This is only useful is log_search_progress is set to true, and if the
   * number of search workers is &gt; 1.
   * </pre>
   *
   * <code>optional bool log_subsolver_statistics = 189 [default = true];</code>
   * @return The logSubsolverStatistics.
   */
  @java.lang.Override
  public boolean getLogSubsolverStatistics() {
    return logSubsolverStatistics_;
  }

  public static final int LOG_PREFIX_FIELD_NUMBER = 185;
  private volatile java.lang.Object logPrefix_;
  /**
   * <pre>
   * Add a prefix to all logs.
   * </pre>
   *
   * <code>optional string log_prefix = 185 [default = ""];</code>
   * @return Whether the logPrefix field is set.
   */
  @java.lang.Override
  public boolean hasLogPrefix() {
    return ((bitField1_ & 0x00200000) != 0);
  }
  /**
   * <pre>
   * Add a prefix to all logs.
   * </pre>
   *
   * <code>optional string log_prefix = 185 [default = ""];</code>
   * @return The logPrefix.
   */
  @java.lang.Override
  public java.lang.String getLogPrefix() {
    java.lang.Object ref = logPrefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (bs.isValidUtf8()) {
        logPrefix_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * Add a prefix to all logs.
   * </pre>
   *
   * <code>optional string log_prefix = 185 [default = ""];</code>
   * @return The bytes for logPrefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getLogPrefixBytes() {
    java.lang.Object ref = logPrefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      logPrefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOG_TO_STDOUT_FIELD_NUMBER = 186;
  private boolean logToStdout_;
  /**
   * <pre>
   * Log to stdout.
   * </pre>
   *
   * <code>optional bool log_to_stdout = 186 [default = true];</code>
   * @return Whether the logToStdout field is set.
   */
  @java.lang.Override
  public boolean hasLogToStdout() {
    return ((bitField1_ & 0x00400000) != 0);
  }
  /**
   * <pre>
   * Log to stdout.
   * </pre>
   *
   * <code>optional bool log_to_stdout = 186 [default = true];</code>
   * @return The logToStdout.
   */
  @java.lang.Override
  public boolean getLogToStdout() {
    return logToStdout_;
  }

  public static final int LOG_TO_RESPONSE_FIELD_NUMBER = 187;
  private boolean logToResponse_;
  /**
   * <pre>
   * Log to response proto.
   * </pre>
   *
   * <code>optional bool log_to_response = 187 [default = false];</code>
   * @return Whether the logToResponse field is set.
   */
  @java.lang.Override
  public boolean hasLogToResponse() {
    return ((bitField1_ & 0x00800000) != 0);
  }
  /**
   * <pre>
   * Log to response proto.
   * </pre>
   *
   * <code>optional bool log_to_response = 187 [default = false];</code>
   * @return The logToResponse.
   */
  @java.lang.Override
  public boolean getLogToResponse() {
    return logToResponse_;
  }

  public static final int USE_PB_RESOLUTION_FIELD_NUMBER = 43;
  private boolean usePbResolution_;
  /**
   * <pre>
   * Whether to use pseudo-Boolean resolution to analyze a conflict. Note that
   * this option only make sense if your problem is modelized using
   * pseudo-Boolean constraints. If you only have clauses, this shouldn't change
   * anything (except slow the solver down).
   * </pre>
   *
   * <code>optional bool use_pb_resolution = 43 [default = false];</code>
   * @return Whether the usePbResolution field is set.
   */
  @java.lang.Override
  public boolean hasUsePbResolution() {
    return ((bitField1_ & 0x01000000) != 0);
  }
  /**
   * <pre>
   * Whether to use pseudo-Boolean resolution to analyze a conflict. Note that
   * this option only make sense if your problem is modelized using
   * pseudo-Boolean constraints. If you only have clauses, this shouldn't change
   * anything (except slow the solver down).
   * </pre>
   *
   * <code>optional bool use_pb_resolution = 43 [default = false];</code>
   * @return The usePbResolution.
   */
  @java.lang.Override
  public boolean getUsePbResolution() {
    return usePbResolution_;
  }

  public static final int MINIMIZE_REDUCTION_DURING_PB_RESOLUTION_FIELD_NUMBER = 48;
  private boolean minimizeReductionDuringPbResolution_;
  /**
   * <pre>
   * A different algorithm during PB resolution. It minimizes the number of
   * calls to ReduceCoefficients() which can be time consuming. However, the
   * search space will be different and if the coefficients are large, this may
   * lead to integer overflows that could otherwise be prevented.
   * </pre>
   *
   * <code>optional bool minimize_reduction_during_pb_resolution = 48 [default = false];</code>
   * @return Whether the minimizeReductionDuringPbResolution field is set.
   */
  @java.lang.Override
  public boolean hasMinimizeReductionDuringPbResolution() {
    return ((bitField1_ & 0x02000000) != 0);
  }
  /**
   * <pre>
   * A different algorithm during PB resolution. It minimizes the number of
   * calls to ReduceCoefficients() which can be time consuming. However, the
   * search space will be different and if the coefficients are large, this may
   * lead to integer overflows that could otherwise be prevented.
   * </pre>
   *
   * <code>optional bool minimize_reduction_during_pb_resolution = 48 [default = false];</code>
   * @return The minimizeReductionDuringPbResolution.
   */
  @java.lang.Override
  public boolean getMinimizeReductionDuringPbResolution() {
    return minimizeReductionDuringPbResolution_;
  }

  public static final int COUNT_ASSUMPTION_LEVELS_IN_LBD_FIELD_NUMBER = 49;
  private boolean countAssumptionLevelsInLbd_;
  /**
   * <pre>
   * Whether or not the assumption levels are taken into account during the LBD
   * computation. According to the reference below, not counting them improves
   * the solver in some situation. Note that this only impact solves under
   * assumptions.
   * Gilles Audemard, Jean-Marie Lagniez, Laurent Simon, "Improving Glucose for
   * Incremental SAT Solving with Assumptions: Application to MUS Extraction"
   * Theory and Applications of Satisfiability Testing - SAT 2013, Lecture Notes
   * in Computer Science Volume 7962, 2013, pp 309-317.
   * </pre>
   *
   * <code>optional bool count_assumption_levels_in_lbd = 49 [default = true];</code>
   * @return Whether the countAssumptionLevelsInLbd field is set.
   */
  @java.lang.Override
  public boolean hasCountAssumptionLevelsInLbd() {
    return ((bitField1_ & 0x04000000) != 0);
  }
  /**
   * <pre>
   * Whether or not the assumption levels are taken into account during the LBD
   * computation. According to the reference below, not counting them improves
   * the solver in some situation. Note that this only impact solves under
   * assumptions.
   * Gilles Audemard, Jean-Marie Lagniez, Laurent Simon, "Improving Glucose for
   * Incremental SAT Solving with Assumptions: Application to MUS Extraction"
   * Theory and Applications of Satisfiability Testing - SAT 2013, Lecture Notes
   * in Computer Science Volume 7962, 2013, pp 309-317.
   * </pre>
   *
   * <code>optional bool count_assumption_levels_in_lbd = 49 [default = true];</code>
   * @return The countAssumptionLevelsInLbd.
   */
  @java.lang.Override
  public boolean getCountAssumptionLevelsInLbd() {
    return countAssumptionLevelsInLbd_;
  }

  public static final int PRESOLVE_BVE_THRESHOLD_FIELD_NUMBER = 54;
  private int presolveBveThreshold_;
  /**
   * <pre>
   * During presolve, only try to perform the bounded variable elimination (BVE)
   * of a variable x if the number of occurrences of x times the number of
   * occurrences of not(x) is not greater than this parameter.
   * </pre>
   *
   * <code>optional int32 presolve_bve_threshold = 54 [default = 500];</code>
   * @return Whether the presolveBveThreshold field is set.
   */
  @java.lang.Override
  public boolean hasPresolveBveThreshold() {
    return ((bitField1_ & 0x08000000) != 0);
  }
  /**
   * <pre>
   * During presolve, only try to perform the bounded variable elimination (BVE)
   * of a variable x if the number of occurrences of x times the number of
   * occurrences of not(x) is not greater than this parameter.
   * </pre>
   *
   * <code>optional int32 presolve_bve_threshold = 54 [default = 500];</code>
   * @return The presolveBveThreshold.
   */
  @java.lang.Override
  public int getPresolveBveThreshold() {
    return presolveBveThreshold_;
  }

  public static final int PRESOLVE_BVE_CLAUSE_WEIGHT_FIELD_NUMBER = 55;
  private int presolveBveClauseWeight_;
  /**
   * <pre>
   * During presolve, we apply BVE only if this weight times the number of
   * clauses plus the number of clause literals is not increased.
   * </pre>
   *
   * <code>optional int32 presolve_bve_clause_weight = 55 [default = 3];</code>
   * @return Whether the presolveBveClauseWeight field is set.
   */
  @java.lang.Override
  public boolean hasPresolveBveClauseWeight() {
    return ((bitField1_ & 0x10000000) != 0);
  }
  /**
   * <pre>
   * During presolve, we apply BVE only if this weight times the number of
   * clauses plus the number of clause literals is not increased.
   * </pre>
   *
   * <code>optional int32 presolve_bve_clause_weight = 55 [default = 3];</code>
   * @return The presolveBveClauseWeight.
   */
  @java.lang.Override
  public int getPresolveBveClauseWeight() {
    return presolveBveClauseWeight_;
  }

  public static final int PRESOLVE_PROBING_DETERMINISTIC_TIME_LIMIT_FIELD_NUMBER = 57;
  private double presolveProbingDeterministicTimeLimit_;
  /**
   * <pre>
   * The maximum "deterministic" time limit to spend in probing. A value of
   * zero will disable the probing.
   * </pre>
   *
   * <code>optional double presolve_probing_deterministic_time_limit = 57 [default = 30];</code>
   * @return Whether the presolveProbingDeterministicTimeLimit field is set.
   */
  @java.lang.Override
  public boolean hasPresolveProbingDeterministicTimeLimit() {
    return ((bitField1_ & 0x20000000) != 0);
  }
  /**
   * <pre>
   * The maximum "deterministic" time limit to spend in probing. A value of
   * zero will disable the probing.
   * </pre>
   *
   * <code>optional double presolve_probing_deterministic_time_limit = 57 [default = 30];</code>
   * @return The presolveProbingDeterministicTimeLimit.
   */
  @java.lang.Override
  public double getPresolveProbingDeterministicTimeLimit() {
    return presolveProbingDeterministicTimeLimit_;
  }

  public static final int PRESOLVE_BLOCKED_CLAUSE_FIELD_NUMBER = 88;
  private boolean presolveBlockedClause_;
  /**
   * <pre>
   * Whether we use an heuristic to detect some basic case of blocked clause
   * in the SAT presolve.
   * </pre>
   *
   * <code>optional bool presolve_blocked_clause = 88 [default = true];</code>
   * @return Whether the presolveBlockedClause field is set.
   */
  @java.lang.Override
  public boolean hasPresolveBlockedClause() {
    return ((bitField1_ & 0x40000000) != 0);
  }
  /**
   * <pre>
   * Whether we use an heuristic to detect some basic case of blocked clause
   * in the SAT presolve.
   * </pre>
   *
   * <code>optional bool presolve_blocked_clause = 88 [default = true];</code>
   * @return The presolveBlockedClause.
   */
  @java.lang.Override
  public boolean getPresolveBlockedClause() {
    return presolveBlockedClause_;
  }

  public static final int PRESOLVE_USE_BVA_FIELD_NUMBER = 72;
  private boolean presolveUseBva_;
  /**
   * <pre>
   * Whether or not we use Bounded Variable Addition (BVA) in the presolve.
   * </pre>
   *
   * <code>optional bool presolve_use_bva = 72 [default = true];</code>
   * @return Whether the presolveUseBva field is set.
   */
  @java.lang.Override
  public boolean hasPresolveUseBva() {
    return ((bitField1_ & 0x80000000) != 0);
  }
  /**
   * <pre>
   * Whether or not we use Bounded Variable Addition (BVA) in the presolve.
   * </pre>
   *
   * <code>optional bool presolve_use_bva = 72 [default = true];</code>
   * @return The presolveUseBva.
   */
  @java.lang.Override
  public boolean getPresolveUseBva() {
    return presolveUseBva_;
  }

  public static final int PRESOLVE_BVA_THRESHOLD_FIELD_NUMBER = 73;
  private int presolveBvaThreshold_;
  /**
   * <pre>
   * Apply Bounded Variable Addition (BVA) if the number of clauses is reduced
   * by stricly more than this threshold. The algorithm described in the paper
   * uses 0, but quick experiments showed that 1 is a good value. It may not be
   * worth it to add a new variable just to remove one clause.
   * </pre>
   *
   * <code>optional int32 presolve_bva_threshold = 73 [default = 1];</code>
   * @return Whether the presolveBvaThreshold field is set.
   */
  @java.lang.Override
  public boolean hasPresolveBvaThreshold() {
    return ((bitField2_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Apply Bounded Variable Addition (BVA) if the number of clauses is reduced
   * by stricly more than this threshold. The algorithm described in the paper
   * uses 0, but quick experiments showed that 1 is a good value. It may not be
   * worth it to add a new variable just to remove one clause.
   * </pre>
   *
   * <code>optional int32 presolve_bva_threshold = 73 [default = 1];</code>
   * @return The presolveBvaThreshold.
   */
  @java.lang.Override
  public int getPresolveBvaThreshold() {
    return presolveBvaThreshold_;
  }

  public static final int MAX_PRESOLVE_ITERATIONS_FIELD_NUMBER = 138;
  private int maxPresolveIterations_;
  /**
   * <pre>
   * In case of large reduction in a presolve iteration, we perform multiple
   * presolve iterations. This parameter controls the maximum number of such
   * presolve iterations.
   * </pre>
   *
   * <code>optional int32 max_presolve_iterations = 138 [default = 3];</code>
   * @return Whether the maxPresolveIterations field is set.
   */
  @java.lang.Override
  public boolean hasMaxPresolveIterations() {
    return ((bitField2_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * In case of large reduction in a presolve iteration, we perform multiple
   * presolve iterations. This parameter controls the maximum number of such
   * presolve iterations.
   * </pre>
   *
   * <code>optional int32 max_presolve_iterations = 138 [default = 3];</code>
   * @return The maxPresolveIterations.
   */
  @java.lang.Override
  public int getMaxPresolveIterations() {
    return maxPresolveIterations_;
  }

  public static final int CP_MODEL_PRESOLVE_FIELD_NUMBER = 86;
  private boolean cpModelPresolve_;
  /**
   * <pre>
   * Whether we presolve the cp_model before solving it.
   * </pre>
   *
   * <code>optional bool cp_model_presolve = 86 [default = true];</code>
   * @return Whether the cpModelPresolve field is set.
   */
  @java.lang.Override
  public boolean hasCpModelPresolve() {
    return ((bitField2_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * Whether we presolve the cp_model before solving it.
   * </pre>
   *
   * <code>optional bool cp_model_presolve = 86 [default = true];</code>
   * @return The cpModelPresolve.
   */
  @java.lang.Override
  public boolean getCpModelPresolve() {
    return cpModelPresolve_;
  }

  public static final int CP_MODEL_POSTSOLVE_WITH_FULL_SOLVER_FIELD_NUMBER = 162;
  private boolean cpModelPostsolveWithFullSolver_;
  /**
   * <pre>
   * Advanced usage. We have two different postsolve code. The default one
   * should be better and it allows for a more powerful presolve, but some
   * rarely used features like not fully assigning all variables require the
   * other one.
   * </pre>
   *
   * <code>optional bool cp_model_postsolve_with_full_solver = 162 [default = false];</code>
   * @return Whether the cpModelPostsolveWithFullSolver field is set.
   */
  @java.lang.Override
  public boolean hasCpModelPostsolveWithFullSolver() {
    return ((bitField2_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * Advanced usage. We have two different postsolve code. The default one
   * should be better and it allows for a more powerful presolve, but some
   * rarely used features like not fully assigning all variables require the
   * other one.
   * </pre>
   *
   * <code>optional bool cp_model_postsolve_with_full_solver = 162 [default = false];</code>
   * @return The cpModelPostsolveWithFullSolver.
   */
  @java.lang.Override
  public boolean getCpModelPostsolveWithFullSolver() {
    return cpModelPostsolveWithFullSolver_;
  }

  public static final int CP_MODEL_MAX_NUM_PRESOLVE_OPERATIONS_FIELD_NUMBER = 151;
  private int cpModelMaxNumPresolveOperations_;
  /**
   * <pre>
   * If positive, try to stop just after that many presolve rules have been
   * applied. This is mainly useful for debugging presolve.
   * </pre>
   *
   * <code>optional int32 cp_model_max_num_presolve_operations = 151 [default = 0];</code>
   * @return Whether the cpModelMaxNumPresolveOperations field is set.
   */
  @java.lang.Override
  public boolean hasCpModelMaxNumPresolveOperations() {
    return ((bitField2_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * If positive, try to stop just after that many presolve rules have been
   * applied. This is mainly useful for debugging presolve.
   * </pre>
   *
   * <code>optional int32 cp_model_max_num_presolve_operations = 151 [default = 0];</code>
   * @return The cpModelMaxNumPresolveOperations.
   */
  @java.lang.Override
  public int getCpModelMaxNumPresolveOperations() {
    return cpModelMaxNumPresolveOperations_;
  }

  public static final int CP_MODEL_PROBING_LEVEL_FIELD_NUMBER = 110;
  private int cpModelProbingLevel_;
  /**
   * <pre>
   * How much effort do we spend on probing. 0 disables it completely.
   * </pre>
   *
   * <code>optional int32 cp_model_probing_level = 110 [default = 2];</code>
   * @return Whether the cpModelProbingLevel field is set.
   */
  @java.lang.Override
  public boolean hasCpModelProbingLevel() {
    return ((bitField2_ & 0x00000020) != 0);
  }
  /**
   * <pre>
   * How much effort do we spend on probing. 0 disables it completely.
   * </pre>
   *
   * <code>optional int32 cp_model_probing_level = 110 [default = 2];</code>
   * @return The cpModelProbingLevel.
   */
  @java.lang.Override
  public int getCpModelProbingLevel() {
    return cpModelProbingLevel_;
  }

  public static final int CP_MODEL_USE_SAT_PRESOLVE_FIELD_NUMBER = 93;
  private boolean cpModelUseSatPresolve_;
  /**
   * <pre>
   * Whether we also use the sat presolve when cp_model_presolve is true.
   * </pre>
   *
   * <code>optional bool cp_model_use_sat_presolve = 93 [default = true];</code>
   * @return Whether the cpModelUseSatPresolve field is set.
   */
  @java.lang.Override
  public boolean hasCpModelUseSatPresolve() {
    return ((bitField2_ & 0x00000040) != 0);
  }
  /**
   * <pre>
   * Whether we also use the sat presolve when cp_model_presolve is true.
   * </pre>
   *
   * <code>optional bool cp_model_use_sat_presolve = 93 [default = true];</code>
   * @return The cpModelUseSatPresolve.
   */
  @java.lang.Override
  public boolean getCpModelUseSatPresolve() {
    return cpModelUseSatPresolve_;
  }

  public static final int USE_SAT_INPROCESSING_FIELD_NUMBER = 163;
  private boolean useSatInprocessing_;
  /**
   * <code>optional bool use_sat_inprocessing = 163 [default = false];</code>
   * @return Whether the useSatInprocessing field is set.
   */
  @java.lang.Override
  public boolean hasUseSatInprocessing() {
    return ((bitField2_ & 0x00000080) != 0);
  }
  /**
   * <code>optional bool use_sat_inprocessing = 163 [default = false];</code>
   * @return The useSatInprocessing.
   */
  @java.lang.Override
  public boolean getUseSatInprocessing() {
    return useSatInprocessing_;
  }

  public static final int EXPAND_ELEMENT_CONSTRAINTS_FIELD_NUMBER = 140;
  private boolean expandElementConstraints_;
  /**
   * <pre>
   * If true, the element constraints are expanded into many
   * linear constraints of the form (index == i) =&gt; (element[i] == target).
   * </pre>
   *
   * <code>optional bool expand_element_constraints = 140 [default = true];</code>
   * @return Whether the expandElementConstraints field is set.
   */
  @java.lang.Override
  public boolean hasExpandElementConstraints() {
    return ((bitField2_ & 0x00000100) != 0);
  }
  /**
   * <pre>
   * If true, the element constraints are expanded into many
   * linear constraints of the form (index == i) =&gt; (element[i] == target).
   * </pre>
   *
   * <code>optional bool expand_element_constraints = 140 [default = true];</code>
   * @return The expandElementConstraints.
   */
  @java.lang.Override
  public boolean getExpandElementConstraints() {
    return expandElementConstraints_;
  }

  public static final int EXPAND_AUTOMATON_CONSTRAINTS_FIELD_NUMBER = 143;
  private boolean expandAutomatonConstraints_;
  /**
   * <pre>
   * If true, the automaton constraints are expanded.
   * </pre>
   *
   * <code>optional bool expand_automaton_constraints = 143 [default = true];</code>
   * @return Whether the expandAutomatonConstraints field is set.
   */
  @java.lang.Override
  public boolean hasExpandAutomatonConstraints() {
    return ((bitField2_ & 0x00000200) != 0);
  }
  /**
   * <pre>
   * If true, the automaton constraints are expanded.
   * </pre>
   *
   * <code>optional bool expand_automaton_constraints = 143 [default = true];</code>
   * @return The expandAutomatonConstraints.
   */
  @java.lang.Override
  public boolean getExpandAutomatonConstraints() {
    return expandAutomatonConstraints_;
  }

  public static final int EXPAND_TABLE_CONSTRAINTS_FIELD_NUMBER = 158;
  private boolean expandTableConstraints_;
  /**
   * <pre>
   * If true, the positive table constraints are expanded.
   * Note that currently, negative table constraints are always expanded.
   * </pre>
   *
   * <code>optional bool expand_table_constraints = 158 [default = true];</code>
   * @return Whether the expandTableConstraints field is set.
   */
  @java.lang.Override
  public boolean hasExpandTableConstraints() {
    return ((bitField2_ & 0x00000400) != 0);
  }
  /**
   * <pre>
   * If true, the positive table constraints are expanded.
   * Note that currently, negative table constraints are always expanded.
   * </pre>
   *
   * <code>optional bool expand_table_constraints = 158 [default = true];</code>
   * @return The expandTableConstraints.
   */
  @java.lang.Override
  public boolean getExpandTableConstraints() {
    return expandTableConstraints_;
  }

  public static final int EXPAND_ALLDIFF_CONSTRAINTS_FIELD_NUMBER = 170;
  private boolean expandAlldiffConstraints_;
  /**
   * <pre>
   * If true, expand all_different constraints that are not permutations.
   * Permutations (#Variables = #Values) are always expanded.
   * </pre>
   *
   * <code>optional bool expand_alldiff_constraints = 170 [default = false];</code>
   * @return Whether the expandAlldiffConstraints field is set.
   */
  @java.lang.Override
  public boolean hasExpandAlldiffConstraints() {
    return ((bitField2_ & 0x00000800) != 0);
  }
  /**
   * <pre>
   * If true, expand all_different constraints that are not permutations.
   * Permutations (#Variables = #Values) are always expanded.
   * </pre>
   *
   * <code>optional bool expand_alldiff_constraints = 170 [default = false];</code>
   * @return The expandAlldiffConstraints.
   */
  @java.lang.Override
  public boolean getExpandAlldiffConstraints() {
    return expandAlldiffConstraints_;
  }

  public static final int EXPAND_RESERVOIR_CONSTRAINTS_FIELD_NUMBER = 182;
  private boolean expandReservoirConstraints_;
  /**
   * <pre>
   * If true, expand the reservoir constraints by creating booleans for all
   * possible precedences between event and encoding the constraint.
   * </pre>
   *
   * <code>optional bool expand_reservoir_constraints = 182 [default = true];</code>
   * @return Whether the expandReservoirConstraints field is set.
   */
  @java.lang.Override
  public boolean hasExpandReservoirConstraints() {
    return ((bitField2_ & 0x00001000) != 0);
  }
  /**
   * <pre>
   * If true, expand the reservoir constraints by creating booleans for all
   * possible precedences between event and encoding the constraint.
   * </pre>
   *
   * <code>optional bool expand_reservoir_constraints = 182 [default = true];</code>
   * @return The expandReservoirConstraints.
   */
  @java.lang.Override
  public boolean getExpandReservoirConstraints() {
    return expandReservoirConstraints_;
  }

  public static final int DISABLE_CONSTRAINT_EXPANSION_FIELD_NUMBER = 181;
  private boolean disableConstraintExpansion_;
  /**
   * <pre>
   * If true, it disable all constraint expansion.
   * This should only be used to test the presolve of expanded constraints.
   * </pre>
   *
   * <code>optional bool disable_constraint_expansion = 181 [default = false];</code>
   * @return Whether the disableConstraintExpansion field is set.
   */
  @java.lang.Override
  public boolean hasDisableConstraintExpansion() {
    return ((bitField2_ & 0x00002000) != 0);
  }
  /**
   * <pre>
   * If true, it disable all constraint expansion.
   * This should only be used to test the presolve of expanded constraints.
   * </pre>
   *
   * <code>optional bool disable_constraint_expansion = 181 [default = false];</code>
   * @return The disableConstraintExpansion.
   */
  @java.lang.Override
  public boolean getDisableConstraintExpansion() {
    return disableConstraintExpansion_;
  }

  public static final int MERGE_NO_OVERLAP_WORK_LIMIT_FIELD_NUMBER = 145;
  private double mergeNoOverlapWorkLimit_;
  /**
   * <pre>
   * During presolve, we use a maximum clique heuristic to merge together
   * no-overlap constraints or at most one constraints. This code can be slow,
   * so we have a limit in place on the number of explored nodes in the
   * underlying graph. The internal limit is an int64, but we use double here to
   * simplify manual input.
   * </pre>
   *
   * <code>optional double merge_no_overlap_work_limit = 145 [default = 1000000000000];</code>
   * @return Whether the mergeNoOverlapWorkLimit field is set.
   */
  @java.lang.Override
  public boolean hasMergeNoOverlapWorkLimit() {
    return ((bitField2_ & 0x00004000) != 0);
  }
  /**
   * <pre>
   * During presolve, we use a maximum clique heuristic to merge together
   * no-overlap constraints or at most one constraints. This code can be slow,
   * so we have a limit in place on the number of explored nodes in the
   * underlying graph. The internal limit is an int64, but we use double here to
   * simplify manual input.
   * </pre>
   *
   * <code>optional double merge_no_overlap_work_limit = 145 [default = 1000000000000];</code>
   * @return The mergeNoOverlapWorkLimit.
   */
  @java.lang.Override
  public double getMergeNoOverlapWorkLimit() {
    return mergeNoOverlapWorkLimit_;
  }

  public static final int MERGE_AT_MOST_ONE_WORK_LIMIT_FIELD_NUMBER = 146;
  private double mergeAtMostOneWorkLimit_;
  /**
   * <code>optional double merge_at_most_one_work_limit = 146 [default = 100000000];</code>
   * @return Whether the mergeAtMostOneWorkLimit field is set.
   */
  @java.lang.Override
  public boolean hasMergeAtMostOneWorkLimit() {
    return ((bitField2_ & 0x00008000) != 0);
  }
  /**
   * <code>optional double merge_at_most_one_work_limit = 146 [default = 100000000];</code>
   * @return The mergeAtMostOneWorkLimit.
   */
  @java.lang.Override
  public double getMergeAtMostOneWorkLimit() {
    return mergeAtMostOneWorkLimit_;
  }

  public static final int PRESOLVE_SUBSTITUTION_LEVEL_FIELD_NUMBER = 147;
  private int presolveSubstitutionLevel_;
  /**
   * <pre>
   * How much substitution (also called free variable aggregation in MIP
   * litterature) should we perform at presolve. This currently only concerns
   * variable appearing only in linear constraints. For now the value 0 turns it
   * off and any positive value performs substitution.
   * </pre>
   *
   * <code>optional int32 presolve_substitution_level = 147 [default = 1];</code>
   * @return Whether the presolveSubstitutionLevel field is set.
   */
  @java.lang.Override
  public boolean hasPresolveSubstitutionLevel() {
    return ((bitField2_ & 0x00010000) != 0);
  }
  /**
   * <pre>
   * How much substitution (also called free variable aggregation in MIP
   * litterature) should we perform at presolve. This currently only concerns
   * variable appearing only in linear constraints. For now the value 0 turns it
   * off and any positive value performs substitution.
   * </pre>
   *
   * <code>optional int32 presolve_substitution_level = 147 [default = 1];</code>
   * @return The presolveSubstitutionLevel.
   */
  @java.lang.Override
  public int getPresolveSubstitutionLevel() {
    return presolveSubstitutionLevel_;
  }

  public static final int PRESOLVE_EXTRACT_INTEGER_ENFORCEMENT_FIELD_NUMBER = 174;
  private boolean presolveExtractIntegerEnforcement_;
  /**
   * <pre>
   * If true, we will extract from linear constraints, enforcement literals of
   * the form "integer variable at bound =&gt; simplified constraint". This should
   * always be beneficial except that we don't always handle them as efficiently
   * as we could for now. This causes problem on manna81.mps (LP relaxation not
   * as tight it seems) and on neos-3354841-apure.mps.gz (too many literals
   * created this way).
   * </pre>
   *
   * <code>optional bool presolve_extract_integer_enforcement = 174 [default = false];</code>
   * @return Whether the presolveExtractIntegerEnforcement field is set.
   */
  @java.lang.Override
  public boolean hasPresolveExtractIntegerEnforcement() {
    return ((bitField2_ & 0x00020000) != 0);
  }
  /**
   * <pre>
   * If true, we will extract from linear constraints, enforcement literals of
   * the form "integer variable at bound =&gt; simplified constraint". This should
   * always be beneficial except that we don't always handle them as efficiently
   * as we could for now. This causes problem on manna81.mps (LP relaxation not
   * as tight it seems) and on neos-3354841-apure.mps.gz (too many literals
   * created this way).
   * </pre>
   *
   * <code>optional bool presolve_extract_integer_enforcement = 174 [default = false];</code>
   * @return The presolveExtractIntegerEnforcement.
   */
  @java.lang.Override
  public boolean getPresolveExtractIntegerEnforcement() {
    return presolveExtractIntegerEnforcement_;
  }

  public static final int USE_OPTIMIZATION_HINTS_FIELD_NUMBER = 35;
  private boolean useOptimizationHints_;
  /**
   * <pre>
   * For an optimization problem, whether we follow some hints in order to find
   * a better first solution. For a variable with hint, the solver will always
   * try to follow the hint. It will revert to the variable_branching default
   * otherwise.
   * </pre>
   *
   * <code>optional bool use_optimization_hints = 35 [default = true];</code>
   * @return Whether the useOptimizationHints field is set.
   */
  @java.lang.Override
  public boolean hasUseOptimizationHints() {
    return ((bitField2_ & 0x00040000) != 0);
  }
  /**
   * <pre>
   * For an optimization problem, whether we follow some hints in order to find
   * a better first solution. For a variable with hint, the solver will always
   * try to follow the hint. It will revert to the variable_branching default
   * otherwise.
   * </pre>
   *
   * <code>optional bool use_optimization_hints = 35 [default = true];</code>
   * @return The useOptimizationHints.
   */
  @java.lang.Override
  public boolean getUseOptimizationHints() {
    return useOptimizationHints_;
  }

  public static final int MINIMIZE_CORE_FIELD_NUMBER = 50;
  private boolean minimizeCore_;
  /**
   * <pre>
   * Whether we use a simple heuristic to try to minimize an UNSAT core.
   * </pre>
   *
   * <code>optional bool minimize_core = 50 [default = true];</code>
   * @return Whether the minimizeCore field is set.
   */
  @java.lang.Override
  public boolean hasMinimizeCore() {
    return ((bitField2_ & 0x00080000) != 0);
  }
  /**
   * <pre>
   * Whether we use a simple heuristic to try to minimize an UNSAT core.
   * </pre>
   *
   * <code>optional bool minimize_core = 50 [default = true];</code>
   * @return The minimizeCore.
   */
  @java.lang.Override
  public boolean getMinimizeCore() {
    return minimizeCore_;
  }

  public static final int FIND_MULTIPLE_CORES_FIELD_NUMBER = 84;
  private boolean findMultipleCores_;
  /**
   * <pre>
   * Whether we try to find more independent cores for a given set of
   * assumptions in the core based max-SAT algorithms.
   * </pre>
   *
   * <code>optional bool find_multiple_cores = 84 [default = true];</code>
   * @return Whether the findMultipleCores field is set.
   */
  @java.lang.Override
  public boolean hasFindMultipleCores() {
    return ((bitField2_ & 0x00100000) != 0);
  }
  /**
   * <pre>
   * Whether we try to find more independent cores for a given set of
   * assumptions in the core based max-SAT algorithms.
   * </pre>
   *
   * <code>optional bool find_multiple_cores = 84 [default = true];</code>
   * @return The findMultipleCores.
   */
  @java.lang.Override
  public boolean getFindMultipleCores() {
    return findMultipleCores_;
  }

  public static final int COVER_OPTIMIZATION_FIELD_NUMBER = 89;
  private boolean coverOptimization_;
  /**
   * <pre>
   * If true, when the max-sat algo find a core, we compute the minimal number
   * of literals in the core that needs to be true to have a feasible solution.
   * </pre>
   *
   * <code>optional bool cover_optimization = 89 [default = true];</code>
   * @return Whether the coverOptimization field is set.
   */
  @java.lang.Override
  public boolean hasCoverOptimization() {
    return ((bitField2_ & 0x00200000) != 0);
  }
  /**
   * <pre>
   * If true, when the max-sat algo find a core, we compute the minimal number
   * of literals in the core that needs to be true to have a feasible solution.
   * </pre>
   *
   * <code>optional bool cover_optimization = 89 [default = true];</code>
   * @return The coverOptimization.
   */
  @java.lang.Override
  public boolean getCoverOptimization() {
    return coverOptimization_;
  }

  public static final int MAX_SAT_ASSUMPTION_ORDER_FIELD_NUMBER = 51;
  private int maxSatAssumptionOrder_;
  /**
   * <code>optional .operations_research.sat.SatParameters.MaxSatAssumptionOrder max_sat_assumption_order = 51 [default = DEFAULT_ASSUMPTION_ORDER];</code>
   * @return Whether the maxSatAssumptionOrder field is set.
   */
  @java.lang.Override public boolean hasMaxSatAssumptionOrder() {
    return ((bitField2_ & 0x00400000) != 0);
  }
  /**
   * <code>optional .operations_research.sat.SatParameters.MaxSatAssumptionOrder max_sat_assumption_order = 51 [default = DEFAULT_ASSUMPTION_ORDER];</code>
   * @return The maxSatAssumptionOrder.
   */
  @java.lang.Override public com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder getMaxSatAssumptionOrder() {
    @SuppressWarnings("deprecation")
    com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder result = com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder.valueOf(maxSatAssumptionOrder_);
    return result == null ? com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder.DEFAULT_ASSUMPTION_ORDER : result;
  }

  public static final int MAX_SAT_REVERSE_ASSUMPTION_ORDER_FIELD_NUMBER = 52;
  private boolean maxSatReverseAssumptionOrder_;
  /**
   * <pre>
   * If true, adds the assumption in the reverse order of the one defined by
   * max_sat_assumption_order.
   * </pre>
   *
   * <code>optional bool max_sat_reverse_assumption_order = 52 [default = false];</code>
   * @return Whether the maxSatReverseAssumptionOrder field is set.
   */
  @java.lang.Override
  public boolean hasMaxSatReverseAssumptionOrder() {
    return ((bitField2_ & 0x00800000) != 0);
  }
  /**
   * <pre>
   * If true, adds the assumption in the reverse order of the one defined by
   * max_sat_assumption_order.
   * </pre>
   *
   * <code>optional bool max_sat_reverse_assumption_order = 52 [default = false];</code>
   * @return The maxSatReverseAssumptionOrder.
   */
  @java.lang.Override
  public boolean getMaxSatReverseAssumptionOrder() {
    return maxSatReverseAssumptionOrder_;
  }

  public static final int MAX_SAT_STRATIFICATION_FIELD_NUMBER = 53;
  private int maxSatStratification_;
  /**
   * <code>optional .operations_research.sat.SatParameters.MaxSatStratificationAlgorithm max_sat_stratification = 53 [default = STRATIFICATION_DESCENT];</code>
   * @return Whether the maxSatStratification field is set.
   */
  @java.lang.Override public boolean hasMaxSatStratification() {
    return ((bitField2_ & 0x01000000) != 0);
  }
  /**
   * <code>optional .operations_research.sat.SatParameters.MaxSatStratificationAlgorithm max_sat_stratification = 53 [default = STRATIFICATION_DESCENT];</code>
   * @return The maxSatStratification.
   */
  @java.lang.Override public com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm getMaxSatStratification() {
    @SuppressWarnings("deprecation")
    com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm result = com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm.valueOf(maxSatStratification_);
    return result == null ? com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm.STRATIFICATION_DESCENT : result;
  }

  public static final int USE_PRECEDENCES_IN_DISJUNCTIVE_CONSTRAINT_FIELD_NUMBER = 74;
  private boolean usePrecedencesInDisjunctiveConstraint_;
  /**
   * <pre>
   * When this is true, then a disjunctive constraint will try to use the
   * precedence relations between time intervals to propagate their bounds
   * further. For instance if task A and B are both before C and task A and B
   * are in disjunction, then we can deduce that task C must start after
   * duration(A) + duration(B) instead of simply max(duration(A), duration(B)),
   * provided that the start time for all task was currently zero.
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_precedences_in_disjunctive_constraint = 74 [default = true];</code>
   * @return Whether the usePrecedencesInDisjunctiveConstraint field is set.
   */
  @java.lang.Override
  public boolean hasUsePrecedencesInDisjunctiveConstraint() {
    return ((bitField2_ & 0x02000000) != 0);
  }
  /**
   * <pre>
   * When this is true, then a disjunctive constraint will try to use the
   * precedence relations between time intervals to propagate their bounds
   * further. For instance if task A and B are both before C and task A and B
   * are in disjunction, then we can deduce that task C must start after
   * duration(A) + duration(B) instead of simply max(duration(A), duration(B)),
   * provided that the start time for all task was currently zero.
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_precedences_in_disjunctive_constraint = 74 [default = true];</code>
   * @return The usePrecedencesInDisjunctiveConstraint.
   */
  @java.lang.Override
  public boolean getUsePrecedencesInDisjunctiveConstraint() {
    return usePrecedencesInDisjunctiveConstraint_;
  }

  public static final int USE_OVERLOAD_CHECKER_IN_CUMULATIVE_CONSTRAINT_FIELD_NUMBER = 78;
  private boolean useOverloadCheckerInCumulativeConstraint_;
  /**
   * <pre>
   * When this is true, the cumulative constraint is reinforced with overload
   * checking, i.e., an additional level of reasoning based on energy. This
   * additional level supplements the default level of reasoning as well as
   * timetable edge finding.
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_overload_checker_in_cumulative_constraint = 78 [default = false];</code>
   * @return Whether the useOverloadCheckerInCumulativeConstraint field is set.
   */
  @java.lang.Override
  public boolean hasUseOverloadCheckerInCumulativeConstraint() {
    return ((bitField2_ & 0x04000000) != 0);
  }
  /**
   * <pre>
   * When this is true, the cumulative constraint is reinforced with overload
   * checking, i.e., an additional level of reasoning based on energy. This
   * additional level supplements the default level of reasoning as well as
   * timetable edge finding.
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_overload_checker_in_cumulative_constraint = 78 [default = false];</code>
   * @return The useOverloadCheckerInCumulativeConstraint.
   */
  @java.lang.Override
  public boolean getUseOverloadCheckerInCumulativeConstraint() {
    return useOverloadCheckerInCumulativeConstraint_;
  }

  public static final int USE_TIMETABLE_EDGE_FINDING_IN_CUMULATIVE_CONSTRAINT_FIELD_NUMBER = 79;
  private boolean useTimetableEdgeFindingInCumulativeConstraint_;
  /**
   * <pre>
   * When this is true, the cumulative constraint is reinforced with timetable
   * edge finding, i.e., an additional level of reasoning based on the
   * conjunction of energy and mandatory parts. This additional level
   * supplements the default level of reasoning as well as overload_checker.
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_timetable_edge_finding_in_cumulative_constraint = 79 [default = false];</code>
   * @return Whether the useTimetableEdgeFindingInCumulativeConstraint field is set.
   */
  @java.lang.Override
  public boolean hasUseTimetableEdgeFindingInCumulativeConstraint() {
    return ((bitField2_ & 0x08000000) != 0);
  }
  /**
   * <pre>
   * When this is true, the cumulative constraint is reinforced with timetable
   * edge finding, i.e., an additional level of reasoning based on the
   * conjunction of energy and mandatory parts. This additional level
   * supplements the default level of reasoning as well as overload_checker.
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_timetable_edge_finding_in_cumulative_constraint = 79 [default = false];</code>
   * @return The useTimetableEdgeFindingInCumulativeConstraint.
   */
  @java.lang.Override
  public boolean getUseTimetableEdgeFindingInCumulativeConstraint() {
    return useTimetableEdgeFindingInCumulativeConstraint_;
  }

  public static final int USE_DISJUNCTIVE_CONSTRAINT_IN_CUMULATIVE_CONSTRAINT_FIELD_NUMBER = 80;
  private boolean useDisjunctiveConstraintInCumulativeConstraint_;
  /**
   * <pre>
   * When this is true, the cumulative constraint is reinforced with propagators
   * from the disjunctive constraint to improve the inference on a set of tasks
   * that are disjunctive at the root of the problem. This additional level
   * supplements the default level of reasoning.
   * Propagators of the cumulative constraint will not be used at all if all the
   * tasks are disjunctive at root node.
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_disjunctive_constraint_in_cumulative_constraint = 80 [default = true];</code>
   * @return Whether the useDisjunctiveConstraintInCumulativeConstraint field is set.
   */
  @java.lang.Override
  public boolean hasUseDisjunctiveConstraintInCumulativeConstraint() {
    return ((bitField2_ & 0x10000000) != 0);
  }
  /**
   * <pre>
   * When this is true, the cumulative constraint is reinforced with propagators
   * from the disjunctive constraint to improve the inference on a set of tasks
   * that are disjunctive at the root of the problem. This additional level
   * supplements the default level of reasoning.
   * Propagators of the cumulative constraint will not be used at all if all the
   * tasks are disjunctive at root node.
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_disjunctive_constraint_in_cumulative_constraint = 80 [default = true];</code>
   * @return The useDisjunctiveConstraintInCumulativeConstraint.
   */
  @java.lang.Override
  public boolean getUseDisjunctiveConstraintInCumulativeConstraint() {
    return useDisjunctiveConstraintInCumulativeConstraint_;
  }

  public static final int LINEARIZATION_LEVEL_FIELD_NUMBER = 90;
  private int linearizationLevel_;
  /**
   * <pre>
   * A non-negative level indicating the type of constraints we consider in the
   * LP relaxation. At level zero, no LP relaxation is used. At level 1, only
   * the linear constraint and full encoding are added. At level 2, we also add
   * all the Boolean constraints.
   * </pre>
   *
   * <code>optional int32 linearization_level = 90 [default = 1];</code>
   * @return Whether the linearizationLevel field is set.
   */
  @java.lang.Override
  public boolean hasLinearizationLevel() {
    return ((bitField2_ & 0x20000000) != 0);
  }
  /**
   * <pre>
   * A non-negative level indicating the type of constraints we consider in the
   * LP relaxation. At level zero, no LP relaxation is used. At level 1, only
   * the linear constraint and full encoding are added. At level 2, we also add
   * all the Boolean constraints.
   * </pre>
   *
   * <code>optional int32 linearization_level = 90 [default = 1];</code>
   * @return The linearizationLevel.
   */
  @java.lang.Override
  public int getLinearizationLevel() {
    return linearizationLevel_;
  }

  public static final int BOOLEAN_ENCODING_LEVEL_FIELD_NUMBER = 107;
  private int booleanEncodingLevel_;
  /**
   * <pre>
   * A non-negative level indicating how much we should try to fully encode
   * Integer variables as Boolean.
   * </pre>
   *
   * <code>optional int32 boolean_encoding_level = 107 [default = 1];</code>
   * @return Whether the booleanEncodingLevel field is set.
   */
  @java.lang.Override
  public boolean hasBooleanEncodingLevel() {
    return ((bitField2_ & 0x40000000) != 0);
  }
  /**
   * <pre>
   * A non-negative level indicating how much we should try to fully encode
   * Integer variables as Boolean.
   * </pre>
   *
   * <code>optional int32 boolean_encoding_level = 107 [default = 1];</code>
   * @return The booleanEncodingLevel.
   */
  @java.lang.Override
  public int getBooleanEncodingLevel() {
    return booleanEncodingLevel_;
  }

  public static final int MAX_DOMAIN_SIZE_WHEN_ENCODING_EQ_NEQ_CONSTRAINTS_FIELD_NUMBER = 191;
  private int maxDomainSizeWhenEncodingEqNeqConstraints_;
  /**
   * <pre>
   * When loading a*x + b*y ==/!= c when x and y are both fully encoded.
   * The solver may decide to replace the linear equation by a set of clauses.
   * This is triggered if the sizes of the domains of x and y are below the
   * threshold.
   * </pre>
   *
   * <code>optional int32 max_domain_size_when_encoding_eq_neq_constraints = 191 [default = 16];</code>
   * @return Whether the maxDomainSizeWhenEncodingEqNeqConstraints field is set.
   */
  @java.lang.Override
  public boolean hasMaxDomainSizeWhenEncodingEqNeqConstraints() {
    return ((bitField2_ & 0x80000000) != 0);
  }
  /**
   * <pre>
   * When loading a*x + b*y ==/!= c when x and y are both fully encoded.
   * The solver may decide to replace the linear equation by a set of clauses.
   * This is triggered if the sizes of the domains of x and y are below the
   * threshold.
   * </pre>
   *
   * <code>optional int32 max_domain_size_when_encoding_eq_neq_constraints = 191 [default = 16];</code>
   * @return The maxDomainSizeWhenEncodingEqNeqConstraints.
   */
  @java.lang.Override
  public int getMaxDomainSizeWhenEncodingEqNeqConstraints() {
    return maxDomainSizeWhenEncodingEqNeqConstraints_;
  }

  public static final int MAX_NUM_CUTS_FIELD_NUMBER = 91;
  private int maxNumCuts_;
  /**
   * <pre>
   * The limit on the number of cuts in our cut pool. When this is reached we do
   * not generate cuts anymore.
   * TODO(user): We should probably remove this parameters, and just always
   * generate cuts but only keep the best n or something.
   * </pre>
   *
   * <code>optional int32 max_num_cuts = 91 [default = 10000];</code>
   * @return Whether the maxNumCuts field is set.
   */
  @java.lang.Override
  public boolean hasMaxNumCuts() {
    return ((bitField3_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * The limit on the number of cuts in our cut pool. When this is reached we do
   * not generate cuts anymore.
   * TODO(user): We should probably remove this parameters, and just always
   * generate cuts but only keep the best n or something.
   * </pre>
   *
   * <code>optional int32 max_num_cuts = 91 [default = 10000];</code>
   * @return The maxNumCuts.
   */
  @java.lang.Override
  public int getMaxNumCuts() {
    return maxNumCuts_;
  }

  public static final int ONLY_ADD_CUTS_AT_LEVEL_ZERO_FIELD_NUMBER = 92;
  private boolean onlyAddCutsAtLevelZero_;
  /**
   * <pre>
   * For the cut that can be generated at any level, this control if we only
   * try to generate them at the root node.
   * </pre>
   *
   * <code>optional bool only_add_cuts_at_level_zero = 92 [default = false];</code>
   * @return Whether the onlyAddCutsAtLevelZero field is set.
   */
  @java.lang.Override
  public boolean hasOnlyAddCutsAtLevelZero() {
    return ((bitField3_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * For the cut that can be generated at any level, this control if we only
   * try to generate them at the root node.
   * </pre>
   *
   * <code>optional bool only_add_cuts_at_level_zero = 92 [default = false];</code>
   * @return The onlyAddCutsAtLevelZero.
   */
  @java.lang.Override
  public boolean getOnlyAddCutsAtLevelZero() {
    return onlyAddCutsAtLevelZero_;
  }

  public static final int ADD_KNAPSACK_CUTS_FIELD_NUMBER = 111;
  private boolean addKnapsackCuts_;
  /**
   * <pre>
   * Whether we generate knapsack cuts. Note that in our setting where all
   * variables are integer and bounded on both side, such a cut could be applied
   * to any constraint.
   * </pre>
   *
   * <code>optional bool add_knapsack_cuts = 111 [default = false];</code>
   * @return Whether the addKnapsackCuts field is set.
   */
  @java.lang.Override
  public boolean hasAddKnapsackCuts() {
    return ((bitField3_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * Whether we generate knapsack cuts. Note that in our setting where all
   * variables are integer and bounded on both side, such a cut could be applied
   * to any constraint.
   * </pre>
   *
   * <code>optional bool add_knapsack_cuts = 111 [default = false];</code>
   * @return The addKnapsackCuts.
   */
  @java.lang.Override
  public boolean getAddKnapsackCuts() {
    return addKnapsackCuts_;
  }

  public static final int ADD_CG_CUTS_FIELD_NUMBER = 117;
  private boolean addCgCuts_;
  /**
   * <pre>
   * Whether we generate and add Chvatal-Gomory cuts to the LP at root node.
   * Note that for now, this is not heavily tuned.
   * </pre>
   *
   * <code>optional bool add_cg_cuts = 117 [default = true];</code>
   * @return Whether the addCgCuts field is set.
   */
  @java.lang.Override
  public boolean hasAddCgCuts() {
    return ((bitField3_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * Whether we generate and add Chvatal-Gomory cuts to the LP at root node.
   * Note that for now, this is not heavily tuned.
   * </pre>
   *
   * <code>optional bool add_cg_cuts = 117 [default = true];</code>
   * @return The addCgCuts.
   */
  @java.lang.Override
  public boolean getAddCgCuts() {
    return addCgCuts_;
  }

  public static final int ADD_MIR_CUTS_FIELD_NUMBER = 120;
  private boolean addMirCuts_;
  /**
   * <pre>
   * Whether we generate MIR cuts at root node.
   * Note that for now, this is not heavily tuned.
   * </pre>
   *
   * <code>optional bool add_mir_cuts = 120 [default = true];</code>
   * @return Whether the addMirCuts field is set.
   */
  @java.lang.Override
  public boolean hasAddMirCuts() {
    return ((bitField3_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * Whether we generate MIR cuts at root node.
   * Note that for now, this is not heavily tuned.
   * </pre>
   *
   * <code>optional bool add_mir_cuts = 120 [default = true];</code>
   * @return The addMirCuts.
   */
  @java.lang.Override
  public boolean getAddMirCuts() {
    return addMirCuts_;
  }

  public static final int ADD_ZERO_HALF_CUTS_FIELD_NUMBER = 169;
  private boolean addZeroHalfCuts_;
  /**
   * <pre>
   * Whether we generate Zero-Half cuts at root node.
   * Note that for now, this is not heavily tuned.
   * </pre>
   *
   * <code>optional bool add_zero_half_cuts = 169 [default = true];</code>
   * @return Whether the addZeroHalfCuts field is set.
   */
  @java.lang.Override
  public boolean hasAddZeroHalfCuts() {
    return ((bitField3_ & 0x00000020) != 0);
  }
  /**
   * <pre>
   * Whether we generate Zero-Half cuts at root node.
   * Note that for now, this is not heavily tuned.
   * </pre>
   *
   * <code>optional bool add_zero_half_cuts = 169 [default = true];</code>
   * @return The addZeroHalfCuts.
   */
  @java.lang.Override
  public boolean getAddZeroHalfCuts() {
    return addZeroHalfCuts_;
  }

  public static final int ADD_CLIQUE_CUTS_FIELD_NUMBER = 172;
  private boolean addCliqueCuts_;
  /**
   * <pre>
   * Whether we generate clique cuts from the binary implication graph. Note
   * that as the search goes on, this graph will contains new binary clauses
   * learned by the SAT engine.
   * </pre>
   *
   * <code>optional bool add_clique_cuts = 172 [default = true];</code>
   * @return Whether the addCliqueCuts field is set.
   */
  @java.lang.Override
  public boolean hasAddCliqueCuts() {
    return ((bitField3_ & 0x00000040) != 0);
  }
  /**
   * <pre>
   * Whether we generate clique cuts from the binary implication graph. Note
   * that as the search goes on, this graph will contains new binary clauses
   * learned by the SAT engine.
   * </pre>
   *
   * <code>optional bool add_clique_cuts = 172 [default = true];</code>
   * @return The addCliqueCuts.
   */
  @java.lang.Override
  public boolean getAddCliqueCuts() {
    return addCliqueCuts_;
  }

  public static final int MAX_ALL_DIFF_CUT_SIZE_FIELD_NUMBER = 148;
  private int maxAllDiffCutSize_;
  /**
   * <pre>
   * Cut generator for all diffs can add too many cuts for large all_diff
   * constraints. This parameter restricts the large all_diff constraints to
   * have a cut generator.
   * </pre>
   *
   * <code>optional int32 max_all_diff_cut_size = 148 [default = 7];</code>
   * @return Whether the maxAllDiffCutSize field is set.
   */
  @java.lang.Override
  public boolean hasMaxAllDiffCutSize() {
    return ((bitField3_ & 0x00000080) != 0);
  }
  /**
   * <pre>
   * Cut generator for all diffs can add too many cuts for large all_diff
   * constraints. This parameter restricts the large all_diff constraints to
   * have a cut generator.
   * </pre>
   *
   * <code>optional int32 max_all_diff_cut_size = 148 [default = 7];</code>
   * @return The maxAllDiffCutSize.
   */
  @java.lang.Override
  public int getMaxAllDiffCutSize() {
    return maxAllDiffCutSize_;
  }

  public static final int ADD_LIN_MAX_CUTS_FIELD_NUMBER = 152;
  private boolean addLinMaxCuts_;
  /**
   * <pre>
   * For the lin max constraints, generates the cuts described in "Strong
   * mixed-integer programming formulations for trained neural networks" by Ross
   * Anderson et. (https://arxiv.org/pdf/1811.01988.pdf)
   * </pre>
   *
   * <code>optional bool add_lin_max_cuts = 152 [default = true];</code>
   * @return Whether the addLinMaxCuts field is set.
   */
  @java.lang.Override
  public boolean hasAddLinMaxCuts() {
    return ((bitField3_ & 0x00000100) != 0);
  }
  /**
   * <pre>
   * For the lin max constraints, generates the cuts described in "Strong
   * mixed-integer programming formulations for trained neural networks" by Ross
   * Anderson et. (https://arxiv.org/pdf/1811.01988.pdf)
   * </pre>
   *
   * <code>optional bool add_lin_max_cuts = 152 [default = true];</code>
   * @return The addLinMaxCuts.
   */
  @java.lang.Override
  public boolean getAddLinMaxCuts() {
    return addLinMaxCuts_;
  }

  public static final int MAX_INTEGER_ROUNDING_SCALING_FIELD_NUMBER = 119;
  private int maxIntegerRoundingScaling_;
  /**
   * <pre>
   * In the integer rounding procedure used for MIR and Gomory cut, the maximum
   * "scaling" we use (must be positive). The lower this is, the lower the
   * integer coefficients of the cut will be. Note that cut generated by lower
   * values are not necessarily worse than cut generated by larger value. There
   * is no strict dominance relationship.
   * Setting this to 2 result in the "strong fractional rouding" of Letchford
   * and Lodi.
   * </pre>
   *
   * <code>optional int32 max_integer_rounding_scaling = 119 [default = 600];</code>
   * @return Whether the maxIntegerRoundingScaling field is set.
   */
  @java.lang.Override
  public boolean hasMaxIntegerRoundingScaling() {
    return ((bitField3_ & 0x00000200) != 0);
  }
  /**
   * <pre>
   * In the integer rounding procedure used for MIR and Gomory cut, the maximum
   * "scaling" we use (must be positive). The lower this is, the lower the
   * integer coefficients of the cut will be. Note that cut generated by lower
   * values are not necessarily worse than cut generated by larger value. There
   * is no strict dominance relationship.
   * Setting this to 2 result in the "strong fractional rouding" of Letchford
   * and Lodi.
   * </pre>
   *
   * <code>optional int32 max_integer_rounding_scaling = 119 [default = 600];</code>
   * @return The maxIntegerRoundingScaling.
   */
  @java.lang.Override
  public int getMaxIntegerRoundingScaling() {
    return maxIntegerRoundingScaling_;
  }

  public static final int ADD_LP_CONSTRAINTS_LAZILY_FIELD_NUMBER = 112;
  private boolean addLpConstraintsLazily_;
  /**
   * <pre>
   * If true, we start by an empty LP, and only add constraints not satisfied
   * by the current LP solution batch by batch. A constraint that is only added
   * like this is known as a "lazy" constraint in the literature, except that we
   * currently consider all constraints as lazy here.
   * </pre>
   *
   * <code>optional bool add_lp_constraints_lazily = 112 [default = true];</code>
   * @return Whether the addLpConstraintsLazily field is set.
   */
  @java.lang.Override
  public boolean hasAddLpConstraintsLazily() {
    return ((bitField3_ & 0x00000400) != 0);
  }
  /**
   * <pre>
   * If true, we start by an empty LP, and only add constraints not satisfied
   * by the current LP solution batch by batch. A constraint that is only added
   * like this is known as a "lazy" constraint in the literature, except that we
   * currently consider all constraints as lazy here.
   * </pre>
   *
   * <code>optional bool add_lp_constraints_lazily = 112 [default = true];</code>
   * @return The addLpConstraintsLazily.
   */
  @java.lang.Override
  public boolean getAddLpConstraintsLazily() {
    return addLpConstraintsLazily_;
  }

  public static final int MIN_ORTHOGONALITY_FOR_LP_CONSTRAINTS_FIELD_NUMBER = 115;
  private double minOrthogonalityForLpConstraints_;
  /**
   * <pre>
   * While adding constraints, skip the constraints which have orthogonality
   * less than 'min_orthogonality_for_lp_constraints' with already added
   * constraints during current call. Orthogonality is defined as 1 -
   * cosine(vector angle between constraints). A value of zero disable this
   * feature.
   * </pre>
   *
   * <code>optional double min_orthogonality_for_lp_constraints = 115 [default = 0.05];</code>
   * @return Whether the minOrthogonalityForLpConstraints field is set.
   */
  @java.lang.Override
  public boolean hasMinOrthogonalityForLpConstraints() {
    return ((bitField3_ & 0x00000800) != 0);
  }
  /**
   * <pre>
   * While adding constraints, skip the constraints which have orthogonality
   * less than 'min_orthogonality_for_lp_constraints' with already added
   * constraints during current call. Orthogonality is defined as 1 -
   * cosine(vector angle between constraints). A value of zero disable this
   * feature.
   * </pre>
   *
   * <code>optional double min_orthogonality_for_lp_constraints = 115 [default = 0.05];</code>
   * @return The minOrthogonalityForLpConstraints.
   */
  @java.lang.Override
  public double getMinOrthogonalityForLpConstraints() {
    return minOrthogonalityForLpConstraints_;
  }

  public static final int MAX_CUT_ROUNDS_AT_LEVEL_ZERO_FIELD_NUMBER = 154;
  private int maxCutRoundsAtLevelZero_;
  /**
   * <pre>
   * Max number of time we perform cut generation and resolve the LP at level 0.
   * </pre>
   *
   * <code>optional int32 max_cut_rounds_at_level_zero = 154 [default = 1];</code>
   * @return Whether the maxCutRoundsAtLevelZero field is set.
   */
  @java.lang.Override
  public boolean hasMaxCutRoundsAtLevelZero() {
    return ((bitField3_ & 0x00001000) != 0);
  }
  /**
   * <pre>
   * Max number of time we perform cut generation and resolve the LP at level 0.
   * </pre>
   *
   * <code>optional int32 max_cut_rounds_at_level_zero = 154 [default = 1];</code>
   * @return The maxCutRoundsAtLevelZero.
   */
  @java.lang.Override
  public int getMaxCutRoundsAtLevelZero() {
    return maxCutRoundsAtLevelZero_;
  }

  public static final int MAX_CONSECUTIVE_INACTIVE_COUNT_FIELD_NUMBER = 121;
  private int maxConsecutiveInactiveCount_;
  /**
   * <pre>
   * If a constraint/cut in LP is not active for that many consecutive OPTIMAL
   * solves, remove it from the LP. Note that it might be added again later if
   * it become violated by the current LP solution.
   * </pre>
   *
   * <code>optional int32 max_consecutive_inactive_count = 121 [default = 100];</code>
   * @return Whether the maxConsecutiveInactiveCount field is set.
   */
  @java.lang.Override
  public boolean hasMaxConsecutiveInactiveCount() {
    return ((bitField3_ & 0x00002000) != 0);
  }
  /**
   * <pre>
   * If a constraint/cut in LP is not active for that many consecutive OPTIMAL
   * solves, remove it from the LP. Note that it might be added again later if
   * it become violated by the current LP solution.
   * </pre>
   *
   * <code>optional int32 max_consecutive_inactive_count = 121 [default = 100];</code>
   * @return The maxConsecutiveInactiveCount.
   */
  @java.lang.Override
  public int getMaxConsecutiveInactiveCount() {
    return maxConsecutiveInactiveCount_;
  }

  public static final int CUT_MAX_ACTIVE_COUNT_VALUE_FIELD_NUMBER = 155;
  private double cutMaxActiveCountValue_;
  /**
   * <pre>
   * These parameters are similar to sat clause management activity parameters.
   * They are effective only if the number of generated cuts exceed the storage
   * limit. Default values are based on a few experiments on miplib instances.
   * </pre>
   *
   * <code>optional double cut_max_active_count_value = 155 [default = 10000000000];</code>
   * @return Whether the cutMaxActiveCountValue field is set.
   */
  @java.lang.Override
  public boolean hasCutMaxActiveCountValue() {
    return ((bitField3_ & 0x00004000) != 0);
  }
  /**
   * <pre>
   * These parameters are similar to sat clause management activity parameters.
   * They are effective only if the number of generated cuts exceed the storage
   * limit. Default values are based on a few experiments on miplib instances.
   * </pre>
   *
   * <code>optional double cut_max_active_count_value = 155 [default = 10000000000];</code>
   * @return The cutMaxActiveCountValue.
   */
  @java.lang.Override
  public double getCutMaxActiveCountValue() {
    return cutMaxActiveCountValue_;
  }

  public static final int CUT_ACTIVE_COUNT_DECAY_FIELD_NUMBER = 156;
  private double cutActiveCountDecay_;
  /**
   * <code>optional double cut_active_count_decay = 156 [default = 0.8];</code>
   * @return Whether the cutActiveCountDecay field is set.
   */
  @java.lang.Override
  public boolean hasCutActiveCountDecay() {
    return ((bitField3_ & 0x00008000) != 0);
  }
  /**
   * <code>optional double cut_active_count_decay = 156 [default = 0.8];</code>
   * @return The cutActiveCountDecay.
   */
  @java.lang.Override
  public double getCutActiveCountDecay() {
    return cutActiveCountDecay_;
  }

  public static final int CUT_CLEANUP_TARGET_FIELD_NUMBER = 157;
  private int cutCleanupTarget_;
  /**
   * <pre>
   * Target number of constraints to remove during cleanup.
   * </pre>
   *
   * <code>optional int32 cut_cleanup_target = 157 [default = 1000];</code>
   * @return Whether the cutCleanupTarget field is set.
   */
  @java.lang.Override
  public boolean hasCutCleanupTarget() {
    return ((bitField3_ & 0x00010000) != 0);
  }
  /**
   * <pre>
   * Target number of constraints to remove during cleanup.
   * </pre>
   *
   * <code>optional int32 cut_cleanup_target = 157 [default = 1000];</code>
   * @return The cutCleanupTarget.
   */
  @java.lang.Override
  public int getCutCleanupTarget() {
    return cutCleanupTarget_;
  }

  public static final int NEW_CONSTRAINTS_BATCH_SIZE_FIELD_NUMBER = 122;
  private int newConstraintsBatchSize_;
  /**
   * <pre>
   * Add that many lazy constraints (or cuts) at once in the LP. Note that at
   * the beginning of the solve, we do add more than this.
   * </pre>
   *
   * <code>optional int32 new_constraints_batch_size = 122 [default = 50];</code>
   * @return Whether the newConstraintsBatchSize field is set.
   */
  @java.lang.Override
  public boolean hasNewConstraintsBatchSize() {
    return ((bitField3_ & 0x00020000) != 0);
  }
  /**
   * <pre>
   * Add that many lazy constraints (or cuts) at once in the LP. Note that at
   * the beginning of the solve, we do add more than this.
   * </pre>
   *
   * <code>optional int32 new_constraints_batch_size = 122 [default = 50];</code>
   * @return The newConstraintsBatchSize.
   */
  @java.lang.Override
  public int getNewConstraintsBatchSize() {
    return newConstraintsBatchSize_;
  }

  public static final int SEARCH_BRANCHING_FIELD_NUMBER = 82;
  private int searchBranching_;
  /**
   * <code>optional .operations_research.sat.SatParameters.SearchBranching search_branching = 82 [default = AUTOMATIC_SEARCH];</code>
   * @return Whether the searchBranching field is set.
   */
  @java.lang.Override public boolean hasSearchBranching() {
    return ((bitField3_ & 0x00040000) != 0);
  }
  /**
   * <code>optional .operations_research.sat.SatParameters.SearchBranching search_branching = 82 [default = AUTOMATIC_SEARCH];</code>
   * @return The searchBranching.
   */
  @java.lang.Override public com.google.ortools.sat.SatParameters.SearchBranching getSearchBranching() {
    @SuppressWarnings("deprecation")
    com.google.ortools.sat.SatParameters.SearchBranching result = com.google.ortools.sat.SatParameters.SearchBranching.valueOf(searchBranching_);
    return result == null ? com.google.ortools.sat.SatParameters.SearchBranching.AUTOMATIC_SEARCH : result;
  }

  public static final int HINT_CONFLICT_LIMIT_FIELD_NUMBER = 153;
  private int hintConflictLimit_;
  /**
   * <pre>
   * Conflict limit used in the phase that exploit the solution hint.
   * </pre>
   *
   * <code>optional int32 hint_conflict_limit = 153 [default = 10];</code>
   * @return Whether the hintConflictLimit field is set.
   */
  @java.lang.Override
  public boolean hasHintConflictLimit() {
    return ((bitField3_ & 0x00080000) != 0);
  }
  /**
   * <pre>
   * Conflict limit used in the phase that exploit the solution hint.
   * </pre>
   *
   * <code>optional int32 hint_conflict_limit = 153 [default = 10];</code>
   * @return The hintConflictLimit.
   */
  @java.lang.Override
  public int getHintConflictLimit() {
    return hintConflictLimit_;
  }

  public static final int REPAIR_HINT_FIELD_NUMBER = 167;
  private boolean repairHint_;
  /**
   * <pre>
   * If true, the solver tries to repair the solution given in the hint. This
   * search terminates after the 'hint_conflict_limit' is reached and the solver
   * switches to regular search. If false, then  we do a FIXED_SEARCH using the
   * hint until the hint_conflict_limit is reached.
   * </pre>
   *
   * <code>optional bool repair_hint = 167 [default = false];</code>
   * @return Whether the repairHint field is set.
   */
  @java.lang.Override
  public boolean hasRepairHint() {
    return ((bitField3_ & 0x00100000) != 0);
  }
  /**
   * <pre>
   * If true, the solver tries to repair the solution given in the hint. This
   * search terminates after the 'hint_conflict_limit' is reached and the solver
   * switches to regular search. If false, then  we do a FIXED_SEARCH using the
   * hint until the hint_conflict_limit is reached.
   * </pre>
   *
   * <code>optional bool repair_hint = 167 [default = false];</code>
   * @return The repairHint.
   */
  @java.lang.Override
  public boolean getRepairHint() {
    return repairHint_;
  }

  public static final int FIX_VARIABLES_TO_THEIR_HINTED_VALUE_FIELD_NUMBER = 192;
  private boolean fixVariablesToTheirHintedValue_;
  /**
   * <pre>
   * If true, variables appearing in the solution hints will be fixed to their
   * hinted value.
   * </pre>
   *
   * <code>optional bool fix_variables_to_their_hinted_value = 192 [default = false];</code>
   * @return Whether the fixVariablesToTheirHintedValue field is set.
   */
  @java.lang.Override
  public boolean hasFixVariablesToTheirHintedValue() {
    return ((bitField3_ & 0x00200000) != 0);
  }
  /**
   * <pre>
   * If true, variables appearing in the solution hints will be fixed to their
   * hinted value.
   * </pre>
   *
   * <code>optional bool fix_variables_to_their_hinted_value = 192 [default = false];</code>
   * @return The fixVariablesToTheirHintedValue.
   */
  @java.lang.Override
  public boolean getFixVariablesToTheirHintedValue() {
    return fixVariablesToTheirHintedValue_;
  }

  public static final int EXPLOIT_INTEGER_LP_SOLUTION_FIELD_NUMBER = 94;
  private boolean exploitIntegerLpSolution_;
  /**
   * <pre>
   * If true and the Lp relaxation of the problem has an integer optimal
   * solution, try to exploit it. Note that since the LP relaxation may not
   * contain all the constraints, such a solution is not necessarily a solution
   * of the full problem.
   * </pre>
   *
   * <code>optional bool exploit_integer_lp_solution = 94 [default = true];</code>
   * @return Whether the exploitIntegerLpSolution field is set.
   */
  @java.lang.Override
  public boolean hasExploitIntegerLpSolution() {
    return ((bitField3_ & 0x00400000) != 0);
  }
  /**
   * <pre>
   * If true and the Lp relaxation of the problem has an integer optimal
   * solution, try to exploit it. Note that since the LP relaxation may not
   * contain all the constraints, such a solution is not necessarily a solution
   * of the full problem.
   * </pre>
   *
   * <code>optional bool exploit_integer_lp_solution = 94 [default = true];</code>
   * @return The exploitIntegerLpSolution.
   */
  @java.lang.Override
  public boolean getExploitIntegerLpSolution() {
    return exploitIntegerLpSolution_;
  }

  public static final int EXPLOIT_ALL_LP_SOLUTION_FIELD_NUMBER = 116;
  private boolean exploitAllLpSolution_;
  /**
   * <pre>
   * If true and the Lp relaxation of the problem has a solution, try to exploit
   * it. This is same as above except in this case the lp solution might not be
   * an integer solution.
   * </pre>
   *
   * <code>optional bool exploit_all_lp_solution = 116 [default = true];</code>
   * @return Whether the exploitAllLpSolution field is set.
   */
  @java.lang.Override
  public boolean hasExploitAllLpSolution() {
    return ((bitField3_ & 0x00800000) != 0);
  }
  /**
   * <pre>
   * If true and the Lp relaxation of the problem has a solution, try to exploit
   * it. This is same as above except in this case the lp solution might not be
   * an integer solution.
   * </pre>
   *
   * <code>optional bool exploit_all_lp_solution = 116 [default = true];</code>
   * @return The exploitAllLpSolution.
   */
  @java.lang.Override
  public boolean getExploitAllLpSolution() {
    return exploitAllLpSolution_;
  }

  public static final int EXPLOIT_BEST_SOLUTION_FIELD_NUMBER = 130;
  private boolean exploitBestSolution_;
  /**
   * <pre>
   * When branching on a variable, follow the last best solution value.
   * </pre>
   *
   * <code>optional bool exploit_best_solution = 130 [default = false];</code>
   * @return Whether the exploitBestSolution field is set.
   */
  @java.lang.Override
  public boolean hasExploitBestSolution() {
    return ((bitField3_ & 0x01000000) != 0);
  }
  /**
   * <pre>
   * When branching on a variable, follow the last best solution value.
   * </pre>
   *
   * <code>optional bool exploit_best_solution = 130 [default = false];</code>
   * @return The exploitBestSolution.
   */
  @java.lang.Override
  public boolean getExploitBestSolution() {
    return exploitBestSolution_;
  }

  public static final int EXPLOIT_RELAXATION_SOLUTION_FIELD_NUMBER = 161;
  private boolean exploitRelaxationSolution_;
  /**
   * <pre>
   * When branching on a variable, follow the last best relaxation solution
   * value. We use the relaxation with the tightest bound on the objective as
   * the best relaxation solution.
   * </pre>
   *
   * <code>optional bool exploit_relaxation_solution = 161 [default = false];</code>
   * @return Whether the exploitRelaxationSolution field is set.
   */
  @java.lang.Override
  public boolean hasExploitRelaxationSolution() {
    return ((bitField3_ & 0x02000000) != 0);
  }
  /**
   * <pre>
   * When branching on a variable, follow the last best relaxation solution
   * value. We use the relaxation with the tightest bound on the objective as
   * the best relaxation solution.
   * </pre>
   *
   * <code>optional bool exploit_relaxation_solution = 161 [default = false];</code>
   * @return The exploitRelaxationSolution.
   */
  @java.lang.Override
  public boolean getExploitRelaxationSolution() {
    return exploitRelaxationSolution_;
  }

  public static final int EXPLOIT_OBJECTIVE_FIELD_NUMBER = 131;
  private boolean exploitObjective_;
  /**
   * <pre>
   * When branching an a variable that directly affect the objective,
   * branch on the value that lead to the best objective first.
   * </pre>
   *
   * <code>optional bool exploit_objective = 131 [default = true];</code>
   * @return Whether the exploitObjective field is set.
   */
  @java.lang.Override
  public boolean hasExploitObjective() {
    return ((bitField3_ & 0x04000000) != 0);
  }
  /**
   * <pre>
   * When branching an a variable that directly affect the objective,
   * branch on the value that lead to the best objective first.
   * </pre>
   *
   * <code>optional bool exploit_objective = 131 [default = true];</code>
   * @return The exploitObjective.
   */
  @java.lang.Override
  public boolean getExploitObjective() {
    return exploitObjective_;
  }

  public static final int PROBING_PERIOD_AT_ROOT_FIELD_NUMBER = 142;
  private long probingPeriodAtRoot_;
  /**
   * <pre>
   * If set at zero (the default), it is disabled. Otherwise the solver attempts
   * probing at every 'probing_period' root node. Period of 1 enables probing at
   * every root node.
   * </pre>
   *
   * <code>optional int64 probing_period_at_root = 142 [default = 0];</code>
   * @return Whether the probingPeriodAtRoot field is set.
   */
  @java.lang.Override
  public boolean hasProbingPeriodAtRoot() {
    return ((bitField3_ & 0x08000000) != 0);
  }
  /**
   * <pre>
   * If set at zero (the default), it is disabled. Otherwise the solver attempts
   * probing at every 'probing_period' root node. Period of 1 enables probing at
   * every root node.
   * </pre>
   *
   * <code>optional int64 probing_period_at_root = 142 [default = 0];</code>
   * @return The probingPeriodAtRoot.
   */
  @java.lang.Override
  public long getProbingPeriodAtRoot() {
    return probingPeriodAtRoot_;
  }

  public static final int USE_PROBING_SEARCH_FIELD_NUMBER = 176;
  private boolean useProbingSearch_;
  /**
   * <pre>
   * If true, search will continuously probe Boolean variables, and integer
   * variable bounds.
   * </pre>
   *
   * <code>optional bool use_probing_search = 176 [default = false];</code>
   * @return Whether the useProbingSearch field is set.
   */
  @java.lang.Override
  public boolean hasUseProbingSearch() {
    return ((bitField3_ & 0x10000000) != 0);
  }
  /**
   * <pre>
   * If true, search will continuously probe Boolean variables, and integer
   * variable bounds.
   * </pre>
   *
   * <code>optional bool use_probing_search = 176 [default = false];</code>
   * @return The useProbingSearch.
   */
  @java.lang.Override
  public boolean getUseProbingSearch() {
    return useProbingSearch_;
  }

  public static final int PSEUDO_COST_RELIABILITY_THRESHOLD_FIELD_NUMBER = 123;
  private long pseudoCostReliabilityThreshold_;
  /**
   * <pre>
   * The solver ignores the pseudo costs of variables with number of recordings
   * less than this threshold.
   * </pre>
   *
   * <code>optional int64 pseudo_cost_reliability_threshold = 123 [default = 100];</code>
   * @return Whether the pseudoCostReliabilityThreshold field is set.
   */
  @java.lang.Override
  public boolean hasPseudoCostReliabilityThreshold() {
    return ((bitField3_ & 0x20000000) != 0);
  }
  /**
   * <pre>
   * The solver ignores the pseudo costs of variables with number of recordings
   * less than this threshold.
   * </pre>
   *
   * <code>optional int64 pseudo_cost_reliability_threshold = 123 [default = 100];</code>
   * @return The pseudoCostReliabilityThreshold.
   */
  @java.lang.Override
  public long getPseudoCostReliabilityThreshold() {
    return pseudoCostReliabilityThreshold_;
  }

  public static final int OPTIMIZE_WITH_CORE_FIELD_NUMBER = 83;
  private boolean optimizeWithCore_;
  /**
   * <pre>
   * The default optimization method is a simple "linear scan", each time trying
   * to find a better solution than the previous one. If this is true, then we
   * use a core-based approach (like in max-SAT) when we try to increase the
   * lower bound instead.
   * </pre>
   *
   * <code>optional bool optimize_with_core = 83 [default = false];</code>
   * @return Whether the optimizeWithCore field is set.
   */
  @java.lang.Override
  public boolean hasOptimizeWithCore() {
    return ((bitField3_ & 0x40000000) != 0);
  }
  /**
   * <pre>
   * The default optimization method is a simple "linear scan", each time trying
   * to find a better solution than the previous one. If this is true, then we
   * use a core-based approach (like in max-SAT) when we try to increase the
   * lower bound instead.
   * </pre>
   *
   * <code>optional bool optimize_with_core = 83 [default = false];</code>
   * @return The optimizeWithCore.
   */
  @java.lang.Override
  public boolean getOptimizeWithCore() {
    return optimizeWithCore_;
  }

  public static final int OPTIMIZE_WITH_LB_TREE_SEARCH_FIELD_NUMBER = 188;
  private boolean optimizeWithLbTreeSearch_;
  /**
   * <pre>
   * Do a more conventional tree search (by opposition to SAT based one) where
   * we keep all the explored node in a tree. This is meant to be used in a
   * portfolio and focus on improving the objective lower bound. Keeping the
   * whole tree allow us to report a better objective lower bound coming from
   * the worst open node in the tree.
   * </pre>
   *
   * <code>optional bool optimize_with_lb_tree_search = 188 [default = false];</code>
   * @return Whether the optimizeWithLbTreeSearch field is set.
   */
  @java.lang.Override
  public boolean hasOptimizeWithLbTreeSearch() {
    return ((bitField3_ & 0x80000000) != 0);
  }
  /**
   * <pre>
   * Do a more conventional tree search (by opposition to SAT based one) where
   * we keep all the explored node in a tree. This is meant to be used in a
   * portfolio and focus on improving the objective lower bound. Keeping the
   * whole tree allow us to report a better objective lower bound coming from
   * the worst open node in the tree.
   * </pre>
   *
   * <code>optional bool optimize_with_lb_tree_search = 188 [default = false];</code>
   * @return The optimizeWithLbTreeSearch.
   */
  @java.lang.Override
  public boolean getOptimizeWithLbTreeSearch() {
    return optimizeWithLbTreeSearch_;
  }

  public static final int BINARY_SEARCH_NUM_CONFLICTS_FIELD_NUMBER = 99;
  private int binarySearchNumConflicts_;
  /**
   * <pre>
   * If non-negative, perform a binary search on the objective variable in order
   * to find an [min, max] interval outside of which the solver proved unsat/sat
   * under this amount of conflict. This can quickly reduce the objective domain
   * on some problems.
   * </pre>
   *
   * <code>optional int32 binary_search_num_conflicts = 99 [default = -1];</code>
   * @return Whether the binarySearchNumConflicts field is set.
   */
  @java.lang.Override
  public boolean hasBinarySearchNumConflicts() {
    return ((bitField4_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * If non-negative, perform a binary search on the objective variable in order
   * to find an [min, max] interval outside of which the solver proved unsat/sat
   * under this amount of conflict. This can quickly reduce the objective domain
   * on some problems.
   * </pre>
   *
   * <code>optional int32 binary_search_num_conflicts = 99 [default = -1];</code>
   * @return The binarySearchNumConflicts.
   */
  @java.lang.Override
  public int getBinarySearchNumConflicts() {
    return binarySearchNumConflicts_;
  }

  public static final int OPTIMIZE_WITH_MAX_HS_FIELD_NUMBER = 85;
  private boolean optimizeWithMaxHs_;
  /**
   * <pre>
   * This has no effect if optimize_with_core is false. If true, use a different
   * core-based algorithm similar to the max-HS algo for max-SAT. This is a
   * hybrid MIP/CP approach and it uses a MIP solver in addition to the CP/SAT
   * one. This is also related to the PhD work of tobyodavies&#64;
   * "Automatic Logic-Based Benders Decomposition with MiniZinc"
   * http://aaai.org/ocs/index.php/AAAI/AAAI17/paper/view/14489
   * </pre>
   *
   * <code>optional bool optimize_with_max_hs = 85 [default = false];</code>
   * @return Whether the optimizeWithMaxHs field is set.
   */
  @java.lang.Override
  public boolean hasOptimizeWithMaxHs() {
    return ((bitField4_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * This has no effect if optimize_with_core is false. If true, use a different
   * core-based algorithm similar to the max-HS algo for max-SAT. This is a
   * hybrid MIP/CP approach and it uses a MIP solver in addition to the CP/SAT
   * one. This is also related to the PhD work of tobyodavies&#64;
   * "Automatic Logic-Based Benders Decomposition with MiniZinc"
   * http://aaai.org/ocs/index.php/AAAI/AAAI17/paper/view/14489
   * </pre>
   *
   * <code>optional bool optimize_with_max_hs = 85 [default = false];</code>
   * @return The optimizeWithMaxHs.
   */
  @java.lang.Override
  public boolean getOptimizeWithMaxHs() {
    return optimizeWithMaxHs_;
  }

  public static final int ENUMERATE_ALL_SOLUTIONS_FIELD_NUMBER = 87;
  private boolean enumerateAllSolutions_;
  /**
   * <pre>
   * Whether we enumerate all solutions of a problem without objective. Note
   * that setting this to true automatically disable some presolve reduction
   * that can remove feasible solution. That is it has the same effect as
   * setting keep_all_feasible_solutions_in_presolve.
   * TODO(user): Do not do that and let the user choose what behavior is best by
   * setting keep_all_feasible_solutions_in_presolve ?
   * </pre>
   *
   * <code>optional bool enumerate_all_solutions = 87 [default = false];</code>
   * @return Whether the enumerateAllSolutions field is set.
   */
  @java.lang.Override
  public boolean hasEnumerateAllSolutions() {
    return ((bitField4_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * Whether we enumerate all solutions of a problem without objective. Note
   * that setting this to true automatically disable some presolve reduction
   * that can remove feasible solution. That is it has the same effect as
   * setting keep_all_feasible_solutions_in_presolve.
   * TODO(user): Do not do that and let the user choose what behavior is best by
   * setting keep_all_feasible_solutions_in_presolve ?
   * </pre>
   *
   * <code>optional bool enumerate_all_solutions = 87 [default = false];</code>
   * @return The enumerateAllSolutions.
   */
  @java.lang.Override
  public boolean getEnumerateAllSolutions() {
    return enumerateAllSolutions_;
  }

  public static final int KEEP_ALL_FEASIBLE_SOLUTIONS_IN_PRESOLVE_FIELD_NUMBER = 173;
  private boolean keepAllFeasibleSolutionsInPresolve_;
  /**
   * <pre>
   * If true, we disable the presolve reductions that remove feasible solutions
   * from the search space. Such solution are usually dominated by a "better"
   * solution that is kept, but depending on the situation, we might want to
   * keep all solutions.
   * A trivial example is when a variable is unused. If this is true, then the
   * presolve will not fix it to an arbitrary value and it will stay in the
   * search space.
   * </pre>
   *
   * <code>optional bool keep_all_feasible_solutions_in_presolve = 173 [default = false];</code>
   * @return Whether the keepAllFeasibleSolutionsInPresolve field is set.
   */
  @java.lang.Override
  public boolean hasKeepAllFeasibleSolutionsInPresolve() {
    return ((bitField4_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * If true, we disable the presolve reductions that remove feasible solutions
   * from the search space. Such solution are usually dominated by a "better"
   * solution that is kept, but depending on the situation, we might want to
   * keep all solutions.
   * A trivial example is when a variable is unused. If this is true, then the
   * presolve will not fix it to an arbitrary value and it will stay in the
   * search space.
   * </pre>
   *
   * <code>optional bool keep_all_feasible_solutions_in_presolve = 173 [default = false];</code>
   * @return The keepAllFeasibleSolutionsInPresolve.
   */
  @java.lang.Override
  public boolean getKeepAllFeasibleSolutionsInPresolve() {
    return keepAllFeasibleSolutionsInPresolve_;
  }

  public static final int FILL_TIGHTENED_DOMAINS_IN_RESPONSE_FIELD_NUMBER = 132;
  private boolean fillTightenedDomainsInResponse_;
  /**
   * <pre>
   * If true, add information about the derived variable domains to the
   * CpSolverResponse. It is an option because it makes the response slighly
   * bigger and there is a bit more work involved during the postsolve to
   * construct it, but it should still have a low overhead. See the
   * tightened_variables field in CpSolverResponse for more details.
   * </pre>
   *
   * <code>optional bool fill_tightened_domains_in_response = 132 [default = false];</code>
   * @return Whether the fillTightenedDomainsInResponse field is set.
   */
  @java.lang.Override
  public boolean hasFillTightenedDomainsInResponse() {
    return ((bitField4_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * If true, add information about the derived variable domains to the
   * CpSolverResponse. It is an option because it makes the response slighly
   * bigger and there is a bit more work involved during the postsolve to
   * construct it, but it should still have a low overhead. See the
   * tightened_variables field in CpSolverResponse for more details.
   * </pre>
   *
   * <code>optional bool fill_tightened_domains_in_response = 132 [default = false];</code>
   * @return The fillTightenedDomainsInResponse.
   */
  @java.lang.Override
  public boolean getFillTightenedDomainsInResponse() {
    return fillTightenedDomainsInResponse_;
  }

  public static final int INSTANTIATE_ALL_VARIABLES_FIELD_NUMBER = 106;
  private boolean instantiateAllVariables_;
  /**
   * <pre>
   * If true, the solver will add a default integer branching strategy to the
   * already defined search strategy. If not, some variable might still not be
   * fixed at the end of the search. For now we assume these variable can just
   * be set to their lower bound.
   * </pre>
   *
   * <code>optional bool instantiate_all_variables = 106 [default = true];</code>
   * @return Whether the instantiateAllVariables field is set.
   */
  @java.lang.Override
  public boolean hasInstantiateAllVariables() {
    return ((bitField4_ & 0x00000020) != 0);
  }
  /**
   * <pre>
   * If true, the solver will add a default integer branching strategy to the
   * already defined search strategy. If not, some variable might still not be
   * fixed at the end of the search. For now we assume these variable can just
   * be set to their lower bound.
   * </pre>
   *
   * <code>optional bool instantiate_all_variables = 106 [default = true];</code>
   * @return The instantiateAllVariables.
   */
  @java.lang.Override
  public boolean getInstantiateAllVariables() {
    return instantiateAllVariables_;
  }

  public static final int AUTO_DETECT_GREATER_THAN_AT_LEAST_ONE_OF_FIELD_NUMBER = 95;
  private boolean autoDetectGreaterThanAtLeastOneOf_;
  /**
   * <pre>
   * If true, then the precedences propagator try to detect for each variable if
   * it has a set of "optional incoming arc" for which at least one of them is
   * present. This is usually useful to have but can be slow on model with a lot
   * of precedence.
   * </pre>
   *
   * <code>optional bool auto_detect_greater_than_at_least_one_of = 95 [default = true];</code>
   * @return Whether the autoDetectGreaterThanAtLeastOneOf field is set.
   */
  @java.lang.Override
  public boolean hasAutoDetectGreaterThanAtLeastOneOf() {
    return ((bitField4_ & 0x00000040) != 0);
  }
  /**
   * <pre>
   * If true, then the precedences propagator try to detect for each variable if
   * it has a set of "optional incoming arc" for which at least one of them is
   * present. This is usually useful to have but can be slow on model with a lot
   * of precedence.
   * </pre>
   *
   * <code>optional bool auto_detect_greater_than_at_least_one_of = 95 [default = true];</code>
   * @return The autoDetectGreaterThanAtLeastOneOf.
   */
  @java.lang.Override
  public boolean getAutoDetectGreaterThanAtLeastOneOf() {
    return autoDetectGreaterThanAtLeastOneOf_;
  }

  public static final int STOP_AFTER_FIRST_SOLUTION_FIELD_NUMBER = 98;
  private boolean stopAfterFirstSolution_;
  /**
   * <pre>
   * For an optimization problem, stop the solver as soon as we have a solution.
   * </pre>
   *
   * <code>optional bool stop_after_first_solution = 98 [default = false];</code>
   * @return Whether the stopAfterFirstSolution field is set.
   */
  @java.lang.Override
  public boolean hasStopAfterFirstSolution() {
    return ((bitField4_ & 0x00000080) != 0);
  }
  /**
   * <pre>
   * For an optimization problem, stop the solver as soon as we have a solution.
   * </pre>
   *
   * <code>optional bool stop_after_first_solution = 98 [default = false];</code>
   * @return The stopAfterFirstSolution.
   */
  @java.lang.Override
  public boolean getStopAfterFirstSolution() {
    return stopAfterFirstSolution_;
  }

  public static final int STOP_AFTER_PRESOLVE_FIELD_NUMBER = 149;
  private boolean stopAfterPresolve_;
  /**
   * <pre>
   * Mainly used when improving the presolver. When true, stops the solver after
   * the presolve is complete.
   * </pre>
   *
   * <code>optional bool stop_after_presolve = 149 [default = false];</code>
   * @return Whether the stopAfterPresolve field is set.
   */
  @java.lang.Override
  public boolean hasStopAfterPresolve() {
    return ((bitField4_ & 0x00000100) != 0);
  }
  /**
   * <pre>
   * Mainly used when improving the presolver. When true, stops the solver after
   * the presolve is complete.
   * </pre>
   *
   * <code>optional bool stop_after_presolve = 149 [default = false];</code>
   * @return The stopAfterPresolve.
   */
  @java.lang.Override
  public boolean getStopAfterPresolve() {
    return stopAfterPresolve_;
  }

  public static final int NUM_SEARCH_WORKERS_FIELD_NUMBER = 100;
  private int numSearchWorkers_;
  /**
   * <pre>
   * Specify the number of parallel workers to use during search.
   * A value of 0 means the solver will try to use all cores on the machine.
   * A number of 1 means no parallelism.
   * As of 2020-04-10, if you're using SAT via MPSolver (to solve integer
   * programs) this field is overridden with a value of 8, if the field is not
   * set *explicitly*. Thus, always set this field explicitly or via
   * MPSolver::SetNumThreads().
   * </pre>
   *
   * <code>optional int32 num_search_workers = 100 [default = 0];</code>
   * @return Whether the numSearchWorkers field is set.
   */
  @java.lang.Override
  public boolean hasNumSearchWorkers() {
    return ((bitField4_ & 0x00000200) != 0);
  }
  /**
   * <pre>
   * Specify the number of parallel workers to use during search.
   * A value of 0 means the solver will try to use all cores on the machine.
   * A number of 1 means no parallelism.
   * As of 2020-04-10, if you're using SAT via MPSolver (to solve integer
   * programs) this field is overridden with a value of 8, if the field is not
   * set *explicitly*. Thus, always set this field explicitly or via
   * MPSolver::SetNumThreads().
   * </pre>
   *
   * <code>optional int32 num_search_workers = 100 [default = 0];</code>
   * @return The numSearchWorkers.
   */
  @java.lang.Override
  public int getNumSearchWorkers() {
    return numSearchWorkers_;
  }

  public static final int INTERLEAVE_SEARCH_FIELD_NUMBER = 136;
  private boolean interleaveSearch_;
  /**
   * <pre>
   * Experimental. If this is true, then we interleave all our major search
   * strategy and distribute the work amongst num_search_workers.
   * The search is deterministic (independently of num_search_workers!), and we
   * schedule and wait for interleave_batch_size task to be completed before
   * synchronizing and scheduling the next batch of tasks.
   * </pre>
   *
   * <code>optional bool interleave_search = 136 [default = false];</code>
   * @return Whether the interleaveSearch field is set.
   */
  @java.lang.Override
  public boolean hasInterleaveSearch() {
    return ((bitField4_ & 0x00000400) != 0);
  }
  /**
   * <pre>
   * Experimental. If this is true, then we interleave all our major search
   * strategy and distribute the work amongst num_search_workers.
   * The search is deterministic (independently of num_search_workers!), and we
   * schedule and wait for interleave_batch_size task to be completed before
   * synchronizing and scheduling the next batch of tasks.
   * </pre>
   *
   * <code>optional bool interleave_search = 136 [default = false];</code>
   * @return The interleaveSearch.
   */
  @java.lang.Override
  public boolean getInterleaveSearch() {
    return interleaveSearch_;
  }

  public static final int INTERLEAVE_BATCH_SIZE_FIELD_NUMBER = 134;
  private int interleaveBatchSize_;
  /**
   * <code>optional int32 interleave_batch_size = 134 [default = 1];</code>
   * @return Whether the interleaveBatchSize field is set.
   */
  @java.lang.Override
  public boolean hasInterleaveBatchSize() {
    return ((bitField4_ & 0x00000800) != 0);
  }
  /**
   * <code>optional int32 interleave_batch_size = 134 [default = 1];</code>
   * @return The interleaveBatchSize.
   */
  @java.lang.Override
  public int getInterleaveBatchSize() {
    return interleaveBatchSize_;
  }

  public static final int REDUCE_MEMORY_USAGE_IN_INTERLEAVE_MODE_FIELD_NUMBER = 141;
  private boolean reduceMemoryUsageInInterleaveMode_;
  /**
   * <pre>
   * Temporary parameter until the memory usage is more optimized.
   * </pre>
   *
   * <code>optional bool reduce_memory_usage_in_interleave_mode = 141 [default = false];</code>
   * @return Whether the reduceMemoryUsageInInterleaveMode field is set.
   */
  @java.lang.Override
  public boolean hasReduceMemoryUsageInInterleaveMode() {
    return ((bitField4_ & 0x00001000) != 0);
  }
  /**
   * <pre>
   * Temporary parameter until the memory usage is more optimized.
   * </pre>
   *
   * <code>optional bool reduce_memory_usage_in_interleave_mode = 141 [default = false];</code>
   * @return The reduceMemoryUsageInInterleaveMode.
   */
  @java.lang.Override
  public boolean getReduceMemoryUsageInInterleaveMode() {
    return reduceMemoryUsageInInterleaveMode_;
  }

  public static final int SHARE_OBJECTIVE_BOUNDS_FIELD_NUMBER = 113;
  private boolean shareObjectiveBounds_;
  /**
   * <pre>
   * Allows objective sharing between workers.
   * </pre>
   *
   * <code>optional bool share_objective_bounds = 113 [default = true];</code>
   * @return Whether the shareObjectiveBounds field is set.
   */
  @java.lang.Override
  public boolean hasShareObjectiveBounds() {
    return ((bitField4_ & 0x00002000) != 0);
  }
  /**
   * <pre>
   * Allows objective sharing between workers.
   * </pre>
   *
   * <code>optional bool share_objective_bounds = 113 [default = true];</code>
   * @return The shareObjectiveBounds.
   */
  @java.lang.Override
  public boolean getShareObjectiveBounds() {
    return shareObjectiveBounds_;
  }

  public static final int SHARE_LEVEL_ZERO_BOUNDS_FIELD_NUMBER = 114;
  private boolean shareLevelZeroBounds_;
  /**
   * <pre>
   * Allows sharing of the bounds of modified variables at level 0.
   * </pre>
   *
   * <code>optional bool share_level_zero_bounds = 114 [default = true];</code>
   * @return Whether the shareLevelZeroBounds field is set.
   */
  @java.lang.Override
  public boolean hasShareLevelZeroBounds() {
    return ((bitField4_ & 0x00004000) != 0);
  }
  /**
   * <pre>
   * Allows sharing of the bounds of modified variables at level 0.
   * </pre>
   *
   * <code>optional bool share_level_zero_bounds = 114 [default = true];</code>
   * @return The shareLevelZeroBounds.
   */
  @java.lang.Override
  public boolean getShareLevelZeroBounds() {
    return shareLevelZeroBounds_;
  }

  public static final int USE_LNS_ONLY_FIELD_NUMBER = 101;
  private boolean useLnsOnly_;
  /**
   * <pre>
   * LNS parameters.
   * </pre>
   *
   * <code>optional bool use_lns_only = 101 [default = false];</code>
   * @return Whether the useLnsOnly field is set.
   */
  @java.lang.Override
  public boolean hasUseLnsOnly() {
    return ((bitField4_ & 0x00008000) != 0);
  }
  /**
   * <pre>
   * LNS parameters.
   * </pre>
   *
   * <code>optional bool use_lns_only = 101 [default = false];</code>
   * @return The useLnsOnly.
   */
  @java.lang.Override
  public boolean getUseLnsOnly() {
    return useLnsOnly_;
  }

  public static final int LNS_FOCUS_ON_DECISION_VARIABLES_FIELD_NUMBER = 105;
  private boolean lnsFocusOnDecisionVariables_;
  /**
   * <code>optional bool lns_focus_on_decision_variables = 105 [default = false];</code>
   * @return Whether the lnsFocusOnDecisionVariables field is set.
   */
  @java.lang.Override
  public boolean hasLnsFocusOnDecisionVariables() {
    return ((bitField4_ & 0x00010000) != 0);
  }
  /**
   * <code>optional bool lns_focus_on_decision_variables = 105 [default = false];</code>
   * @return The lnsFocusOnDecisionVariables.
   */
  @java.lang.Override
  public boolean getLnsFocusOnDecisionVariables() {
    return lnsFocusOnDecisionVariables_;
  }

  public static final int LNS_EXPAND_INTERVALS_IN_CONSTRAINT_GRAPH_FIELD_NUMBER = 184;
  private boolean lnsExpandIntervalsInConstraintGraph_;
  /**
   * <code>optional bool lns_expand_intervals_in_constraint_graph = 184 [default = true];</code>
   * @return Whether the lnsExpandIntervalsInConstraintGraph field is set.
   */
  @java.lang.Override
  public boolean hasLnsExpandIntervalsInConstraintGraph() {
    return ((bitField4_ & 0x00020000) != 0);
  }
  /**
   * <code>optional bool lns_expand_intervals_in_constraint_graph = 184 [default = true];</code>
   * @return The lnsExpandIntervalsInConstraintGraph.
   */
  @java.lang.Override
  public boolean getLnsExpandIntervalsInConstraintGraph() {
    return lnsExpandIntervalsInConstraintGraph_;
  }

  public static final int SOLUTION_POOL_SIZE_FIELD_NUMBER = 193;
  private int solutionPoolSize_;
  /**
   * <pre>
   * Size of the top-n different solutions kept by the solver.
   * Currently this only impact the "base" solution chosen for a LNS fragment.
   * </pre>
   *
   * <code>optional int32 solution_pool_size = 193 [default = 3];</code>
   * @return Whether the solutionPoolSize field is set.
   */
  @java.lang.Override
  public boolean hasSolutionPoolSize() {
    return ((bitField4_ & 0x00040000) != 0);
  }
  /**
   * <pre>
   * Size of the top-n different solutions kept by the solver.
   * Currently this only impact the "base" solution chosen for a LNS fragment.
   * </pre>
   *
   * <code>optional int32 solution_pool_size = 193 [default = 3];</code>
   * @return The solutionPoolSize.
   */
  @java.lang.Override
  public int getSolutionPoolSize() {
    return solutionPoolSize_;
  }

  public static final int USE_RINS_LNS_FIELD_NUMBER = 129;
  private boolean useRinsLns_;
  /**
   * <pre>
   * Turns on relaxation induced neighborhood generator.
   * </pre>
   *
   * <code>optional bool use_rins_lns = 129 [default = true];</code>
   * @return Whether the useRinsLns field is set.
   */
  @java.lang.Override
  public boolean hasUseRinsLns() {
    return ((bitField4_ & 0x00080000) != 0);
  }
  /**
   * <pre>
   * Turns on relaxation induced neighborhood generator.
   * </pre>
   *
   * <code>optional bool use_rins_lns = 129 [default = true];</code>
   * @return The useRinsLns.
   */
  @java.lang.Override
  public boolean getUseRinsLns() {
    return useRinsLns_;
  }

  public static final int USE_FEASIBILITY_PUMP_FIELD_NUMBER = 164;
  private boolean useFeasibilityPump_;
  /**
   * <pre>
   * Adds a feasibility pump subsolver along with lns subsolvers.
   * </pre>
   *
   * <code>optional bool use_feasibility_pump = 164 [default = true];</code>
   * @return Whether the useFeasibilityPump field is set.
   */
  @java.lang.Override
  public boolean hasUseFeasibilityPump() {
    return ((bitField4_ & 0x00100000) != 0);
  }
  /**
   * <pre>
   * Adds a feasibility pump subsolver along with lns subsolvers.
   * </pre>
   *
   * <code>optional bool use_feasibility_pump = 164 [default = true];</code>
   * @return The useFeasibilityPump.
   */
  @java.lang.Override
  public boolean getUseFeasibilityPump() {
    return useFeasibilityPump_;
  }

  public static final int FP_ROUNDING_FIELD_NUMBER = 165;
  private int fpRounding_;
  /**
   * <code>optional .operations_research.sat.SatParameters.FPRoundingMethod fp_rounding = 165 [default = PROPAGATION_ASSISTED];</code>
   * @return Whether the fpRounding field is set.
   */
  @java.lang.Override public boolean hasFpRounding() {
    return ((bitField4_ & 0x00200000) != 0);
  }
  /**
   * <code>optional .operations_research.sat.SatParameters.FPRoundingMethod fp_rounding = 165 [default = PROPAGATION_ASSISTED];</code>
   * @return The fpRounding.
   */
  @java.lang.Override public com.google.ortools.sat.SatParameters.FPRoundingMethod getFpRounding() {
    @SuppressWarnings("deprecation")
    com.google.ortools.sat.SatParameters.FPRoundingMethod result = com.google.ortools.sat.SatParameters.FPRoundingMethod.valueOf(fpRounding_);
    return result == null ? com.google.ortools.sat.SatParameters.FPRoundingMethod.PROPAGATION_ASSISTED : result;
  }

  public static final int USE_RELAXATION_LNS_FIELD_NUMBER = 150;
  private boolean useRelaxationLns_;
  /**
   * <pre>
   * Turns on a lns worker which solves relaxed version of the original problem
   * by removing constraints from the problem in order to get better bounds.
   * </pre>
   *
   * <code>optional bool use_relaxation_lns = 150 [default = false];</code>
   * @return Whether the useRelaxationLns field is set.
   */
  @java.lang.Override
  public boolean hasUseRelaxationLns() {
    return ((bitField4_ & 0x00400000) != 0);
  }
  /**
   * <pre>
   * Turns on a lns worker which solves relaxed version of the original problem
   * by removing constraints from the problem in order to get better bounds.
   * </pre>
   *
   * <code>optional bool use_relaxation_lns = 150 [default = false];</code>
   * @return The useRelaxationLns.
   */
  @java.lang.Override
  public boolean getUseRelaxationLns() {
    return useRelaxationLns_;
  }

  public static final int DIVERSIFY_LNS_PARAMS_FIELD_NUMBER = 137;
  private boolean diversifyLnsParams_;
  /**
   * <pre>
   * If true, registers more lns subsolvers with different parameters.
   * </pre>
   *
   * <code>optional bool diversify_lns_params = 137 [default = false];</code>
   * @return Whether the diversifyLnsParams field is set.
   */
  @java.lang.Override
  public boolean hasDiversifyLnsParams() {
    return ((bitField4_ & 0x00800000) != 0);
  }
  /**
   * <pre>
   * If true, registers more lns subsolvers with different parameters.
   * </pre>
   *
   * <code>optional bool diversify_lns_params = 137 [default = false];</code>
   * @return The diversifyLnsParams.
   */
  @java.lang.Override
  public boolean getDiversifyLnsParams() {
    return diversifyLnsParams_;
  }

  public static final int RANDOMIZE_SEARCH_FIELD_NUMBER = 103;
  private boolean randomizeSearch_;
  /**
   * <pre>
   * Randomize fixed search.
   * </pre>
   *
   * <code>optional bool randomize_search = 103 [default = false];</code>
   * @return Whether the randomizeSearch field is set.
   */
  @java.lang.Override
  public boolean hasRandomizeSearch() {
    return ((bitField4_ & 0x01000000) != 0);
  }
  /**
   * <pre>
   * Randomize fixed search.
   * </pre>
   *
   * <code>optional bool randomize_search = 103 [default = false];</code>
   * @return The randomizeSearch.
   */
  @java.lang.Override
  public boolean getRandomizeSearch() {
    return randomizeSearch_;
  }

  public static final int SEARCH_RANDOMIZATION_TOLERANCE_FIELD_NUMBER = 104;
  private long searchRandomizationTolerance_;
  /**
   * <pre>
   * Search randomization will collect equivalent 'max valued' variables, and
   * pick one randomly. For instance, if the variable strategy is CHOOSE_FIRST,
   * all unassigned variables are equivalent. If the variable strategy is
   * CHOOSE_LOWEST_MIN, and `lm` is the current lowest min of all unassigned
   * variables, then the set of max valued variables will be all unassigned
   * variables where
   *    lm &lt;= variable min &lt;= lm + search_randomization_tolerance
   * </pre>
   *
   * <code>optional int64 search_randomization_tolerance = 104 [default = 0];</code>
   * @return Whether the searchRandomizationTolerance field is set.
   */
  @java.lang.Override
  public boolean hasSearchRandomizationTolerance() {
    return ((bitField4_ & 0x02000000) != 0);
  }
  /**
   * <pre>
   * Search randomization will collect equivalent 'max valued' variables, and
   * pick one randomly. For instance, if the variable strategy is CHOOSE_FIRST,
   * all unassigned variables are equivalent. If the variable strategy is
   * CHOOSE_LOWEST_MIN, and `lm` is the current lowest min of all unassigned
   * variables, then the set of max valued variables will be all unassigned
   * variables where
   *    lm &lt;= variable min &lt;= lm + search_randomization_tolerance
   * </pre>
   *
   * <code>optional int64 search_randomization_tolerance = 104 [default = 0];</code>
   * @return The searchRandomizationTolerance.
   */
  @java.lang.Override
  public long getSearchRandomizationTolerance() {
    return searchRandomizationTolerance_;
  }

  public static final int USE_OPTIONAL_VARIABLES_FIELD_NUMBER = 108;
  private boolean useOptionalVariables_;
  /**
   * <pre>
   * If true, we automatically detect variables whose constraint are always
   * enforced by the same literal and we mark them as optional. This allows
   * to propagate them as if they were present in some situation.
   * </pre>
   *
   * <code>optional bool use_optional_variables = 108 [default = true];</code>
   * @return Whether the useOptionalVariables field is set.
   */
  @java.lang.Override
  public boolean hasUseOptionalVariables() {
    return ((bitField4_ & 0x04000000) != 0);
  }
  /**
   * <pre>
   * If true, we automatically detect variables whose constraint are always
   * enforced by the same literal and we mark them as optional. This allows
   * to propagate them as if they were present in some situation.
   * </pre>
   *
   * <code>optional bool use_optional_variables = 108 [default = true];</code>
   * @return The useOptionalVariables.
   */
  @java.lang.Override
  public boolean getUseOptionalVariables() {
    return useOptionalVariables_;
  }

  public static final int USE_EXACT_LP_REASON_FIELD_NUMBER = 109;
  private boolean useExactLpReason_;
  /**
   * <pre>
   * The solver usually exploit the LP relaxation of a model. If this option is
   * true, then whatever is infered by the LP will be used like an heuristic to
   * compute EXACT propagation on the IP. So with this option, there is no
   * numerical imprecision issues.
   * </pre>
   *
   * <code>optional bool use_exact_lp_reason = 109 [default = true];</code>
   * @return Whether the useExactLpReason field is set.
   */
  @java.lang.Override
  public boolean hasUseExactLpReason() {
    return ((bitField4_ & 0x08000000) != 0);
  }
  /**
   * <pre>
   * The solver usually exploit the LP relaxation of a model. If this option is
   * true, then whatever is infered by the LP will be used like an heuristic to
   * compute EXACT propagation on the IP. So with this option, there is no
   * numerical imprecision issues.
   * </pre>
   *
   * <code>optional bool use_exact_lp_reason = 109 [default = true];</code>
   * @return The useExactLpReason.
   */
  @java.lang.Override
  public boolean getUseExactLpReason() {
    return useExactLpReason_;
  }

  public static final int USE_BRANCHING_IN_LP_FIELD_NUMBER = 139;
  private boolean useBranchingInLp_;
  /**
   * <pre>
   * If true, the solver attemts to generate more info inside lp propagator by
   * branching on some variables if certain criteria are met during the search
   * tree exploration.
   * </pre>
   *
   * <code>optional bool use_branching_in_lp = 139 [default = false];</code>
   * @return Whether the useBranchingInLp field is set.
   */
  @java.lang.Override
  public boolean hasUseBranchingInLp() {
    return ((bitField4_ & 0x10000000) != 0);
  }
  /**
   * <pre>
   * If true, the solver attemts to generate more info inside lp propagator by
   * branching on some variables if certain criteria are met during the search
   * tree exploration.
   * </pre>
   *
   * <code>optional bool use_branching_in_lp = 139 [default = false];</code>
   * @return The useBranchingInLp.
   */
  @java.lang.Override
  public boolean getUseBranchingInLp() {
    return useBranchingInLp_;
  }

  public static final int USE_COMBINED_NO_OVERLAP_FIELD_NUMBER = 133;
  private boolean useCombinedNoOverlap_;
  /**
   * <pre>
   * This can be beneficial if there is a lot of no-overlap constraints but a
   * relatively low number of different intervals in the problem. Like 1000
   * intervals, but 1M intervals in the no-overlap constraints covering them.
   * </pre>
   *
   * <code>optional bool use_combined_no_overlap = 133 [default = false];</code>
   * @return Whether the useCombinedNoOverlap field is set.
   */
  @java.lang.Override
  public boolean hasUseCombinedNoOverlap() {
    return ((bitField4_ & 0x20000000) != 0);
  }
  /**
   * <pre>
   * This can be beneficial if there is a lot of no-overlap constraints but a
   * relatively low number of different intervals in the problem. Like 1000
   * intervals, but 1M intervals in the no-overlap constraints covering them.
   * </pre>
   *
   * <code>optional bool use_combined_no_overlap = 133 [default = false];</code>
   * @return The useCombinedNoOverlap.
   */
  @java.lang.Override
  public boolean getUseCombinedNoOverlap() {
    return useCombinedNoOverlap_;
  }

  public static final int CATCH_SIGINT_SIGNAL_FIELD_NUMBER = 135;
  private boolean catchSigintSignal_;
  /**
   * <pre>
   * Indicates if the CP-SAT layer should catch Control-C (SIGINT) signals
   * when calling solve. If set, catching the SIGINT signal will terminate the
   * search gracefully, as if a time limit was reached.
   * </pre>
   *
   * <code>optional bool catch_sigint_signal = 135 [default = true];</code>
   * @return Whether the catchSigintSignal field is set.
   */
  @java.lang.Override
  public boolean hasCatchSigintSignal() {
    return ((bitField4_ & 0x40000000) != 0);
  }
  /**
   * <pre>
   * Indicates if the CP-SAT layer should catch Control-C (SIGINT) signals
   * when calling solve. If set, catching the SIGINT signal will terminate the
   * search gracefully, as if a time limit was reached.
   * </pre>
   *
   * <code>optional bool catch_sigint_signal = 135 [default = true];</code>
   * @return The catchSigintSignal.
   */
  @java.lang.Override
  public boolean getCatchSigintSignal() {
    return catchSigintSignal_;
  }

  public static final int USE_IMPLIED_BOUNDS_FIELD_NUMBER = 144;
  private boolean useImpliedBounds_;
  /**
   * <pre>
   * Stores and exploits "implied-bounds" in the solver. That is, relations of
   * the form literal =&gt; (var &gt;= bound). This is currently used to derive
   * stronger cuts.
   * </pre>
   *
   * <code>optional bool use_implied_bounds = 144 [default = true];</code>
   * @return Whether the useImpliedBounds field is set.
   */
  @java.lang.Override
  public boolean hasUseImpliedBounds() {
    return ((bitField4_ & 0x80000000) != 0);
  }
  /**
   * <pre>
   * Stores and exploits "implied-bounds" in the solver. That is, relations of
   * the form literal =&gt; (var &gt;= bound). This is currently used to derive
   * stronger cuts.
   * </pre>
   *
   * <code>optional bool use_implied_bounds = 144 [default = true];</code>
   * @return The useImpliedBounds.
   */
  @java.lang.Override
  public boolean getUseImpliedBounds() {
    return useImpliedBounds_;
  }

  public static final int POLISH_LP_SOLUTION_FIELD_NUMBER = 175;
  private boolean polishLpSolution_;
  /**
   * <pre>
   * Whether we try to do a few degenerate iteration at the end of an LP solve
   * to minimize the fractionality of the integer variable in the basis. This
   * helps on some problems, but not so much on others. It also cost of bit of
   * time to do such polish step.
   * </pre>
   *
   * <code>optional bool polish_lp_solution = 175 [default = false];</code>
   * @return Whether the polishLpSolution field is set.
   */
  @java.lang.Override
  public boolean hasPolishLpSolution() {
    return ((bitField5_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Whether we try to do a few degenerate iteration at the end of an LP solve
   * to minimize the fractionality of the integer variable in the basis. This
   * helps on some problems, but not so much on others. It also cost of bit of
   * time to do such polish step.
   * </pre>
   *
   * <code>optional bool polish_lp_solution = 175 [default = false];</code>
   * @return The polishLpSolution.
   */
  @java.lang.Override
  public boolean getPolishLpSolution() {
    return polishLpSolution_;
  }

  public static final int CONVERT_INTERVALS_FIELD_NUMBER = 177;
  private boolean convertIntervals_;
  /**
   * <pre>
   * Temporary flag util the feature is more mature. This convert intervals to
   * the newer proto format that support affine start/var/end instead of just
   * variables.
   * </pre>
   *
   * <code>optional bool convert_intervals = 177 [default = true];</code>
   * @return Whether the convertIntervals field is set.
   */
  @java.lang.Override
  public boolean hasConvertIntervals() {
    return ((bitField5_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * Temporary flag util the feature is more mature. This convert intervals to
   * the newer proto format that support affine start/var/end instead of just
   * variables.
   * </pre>
   *
   * <code>optional bool convert_intervals = 177 [default = true];</code>
   * @return The convertIntervals.
   */
  @java.lang.Override
  public boolean getConvertIntervals() {
    return convertIntervals_;
  }

  public static final int SYMMETRY_LEVEL_FIELD_NUMBER = 183;
  private int symmetryLevel_;
  /**
   * <pre>
   * Whether we try to automatically detect the symmetries in a model and
   * exploit them. Currently, at level 1 we detect them in presolve and try
   * to fix Booleans. At level 2, we also do some form of dynamic symmetry
   * breaking during search.
   * </pre>
   *
   * <code>optional int32 symmetry_level = 183 [default = 2];</code>
   * @return Whether the symmetryLevel field is set.
   */
  @java.lang.Override
  public boolean hasSymmetryLevel() {
    return ((bitField5_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * Whether we try to automatically detect the symmetries in a model and
   * exploit them. Currently, at level 1 we detect them in presolve and try
   * to fix Booleans. At level 2, we also do some form of dynamic symmetry
   * breaking during search.
   * </pre>
   *
   * <code>optional int32 symmetry_level = 183 [default = 2];</code>
   * @return The symmetryLevel.
   */
  @java.lang.Override
  public int getSymmetryLevel() {
    return symmetryLevel_;
  }

  public static final int MIP_MAX_BOUND_FIELD_NUMBER = 124;
  private double mipMaxBound_;
  /**
   * <pre>
   * We need to bound the maximum magnitude of the variables for CP-SAT, and
   * that is the bound we use. If the MIP model expect larger variable value in
   * the solution, then the converted model will likely not be relevant.
   * </pre>
   *
   * <code>optional double mip_max_bound = 124 [default = 10000000];</code>
   * @return Whether the mipMaxBound field is set.
   */
  @java.lang.Override
  public boolean hasMipMaxBound() {
    return ((bitField5_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * We need to bound the maximum magnitude of the variables for CP-SAT, and
   * that is the bound we use. If the MIP model expect larger variable value in
   * the solution, then the converted model will likely not be relevant.
   * </pre>
   *
   * <code>optional double mip_max_bound = 124 [default = 10000000];</code>
   * @return The mipMaxBound.
   */
  @java.lang.Override
  public double getMipMaxBound() {
    return mipMaxBound_;
  }

  public static final int MIP_VAR_SCALING_FIELD_NUMBER = 125;
  private double mipVarScaling_;
  /**
   * <pre>
   * All continuous variable of the problem will be multiplied by this factor.
   * By default, we don't do any variable scaling and rely on the MIP model to
   * specify continuous variable domain with the wanted precision.
   * </pre>
   *
   * <code>optional double mip_var_scaling = 125 [default = 1];</code>
   * @return Whether the mipVarScaling field is set.
   */
  @java.lang.Override
  public boolean hasMipVarScaling() {
    return ((bitField5_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * All continuous variable of the problem will be multiplied by this factor.
   * By default, we don't do any variable scaling and rely on the MIP model to
   * specify continuous variable domain with the wanted precision.
   * </pre>
   *
   * <code>optional double mip_var_scaling = 125 [default = 1];</code>
   * @return The mipVarScaling.
   */
  @java.lang.Override
  public double getMipVarScaling() {
    return mipVarScaling_;
  }

  public static final int MIP_AUTOMATICALLY_SCALE_VARIABLES_FIELD_NUMBER = 166;
  private boolean mipAutomaticallyScaleVariables_;
  /**
   * <pre>
   * If true, some continuous variable might be automatically scaled. For now,
   * this is only the case where we detect that a variable is actually an
   * integer multiple of a constant. For instance, variables of the form k * 0.5
   * are quite frequent, and if we detect this, we will scale such variable
   * domain by 2 to make it implied integer.
   * </pre>
   *
   * <code>optional bool mip_automatically_scale_variables = 166 [default = true];</code>
   * @return Whether the mipAutomaticallyScaleVariables field is set.
   */
  @java.lang.Override
  public boolean hasMipAutomaticallyScaleVariables() {
    return ((bitField5_ & 0x00000020) != 0);
  }
  /**
   * <pre>
   * If true, some continuous variable might be automatically scaled. For now,
   * this is only the case where we detect that a variable is actually an
   * integer multiple of a constant. For instance, variables of the form k * 0.5
   * are quite frequent, and if we detect this, we will scale such variable
   * domain by 2 to make it implied integer.
   * </pre>
   *
   * <code>optional bool mip_automatically_scale_variables = 166 [default = true];</code>
   * @return The mipAutomaticallyScaleVariables.
   */
  @java.lang.Override
  public boolean getMipAutomaticallyScaleVariables() {
    return mipAutomaticallyScaleVariables_;
  }

  public static final int MIP_WANTED_PRECISION_FIELD_NUMBER = 126;
  private double mipWantedPrecision_;
  /**
   * <pre>
   * When scaling constraint with double coefficients to integer coefficients,
   * we will multiply by a power of 2 and round the coefficients. We will choose
   * the lowest power such that we have no potential overflow and the worst case
   * constraint activity error do not exceed this threshold relative to the
   * constraint bounds.
   * We also use this to decide by how much we relax the constraint bounds so
   * that we can have a feasible integer solution of constraints involving
   * continuous variable. This is required for instance when you have an == rhs
   * constraint as in many situation you cannot have a perfect equality with
   * integer variables and coefficients.
   * </pre>
   *
   * <code>optional double mip_wanted_precision = 126 [default = 1e-06];</code>
   * @return Whether the mipWantedPrecision field is set.
   */
  @java.lang.Override
  public boolean hasMipWantedPrecision() {
    return ((bitField5_ & 0x00000040) != 0);
  }
  /**
   * <pre>
   * When scaling constraint with double coefficients to integer coefficients,
   * we will multiply by a power of 2 and round the coefficients. We will choose
   * the lowest power such that we have no potential overflow and the worst case
   * constraint activity error do not exceed this threshold relative to the
   * constraint bounds.
   * We also use this to decide by how much we relax the constraint bounds so
   * that we can have a feasible integer solution of constraints involving
   * continuous variable. This is required for instance when you have an == rhs
   * constraint as in many situation you cannot have a perfect equality with
   * integer variables and coefficients.
   * </pre>
   *
   * <code>optional double mip_wanted_precision = 126 [default = 1e-06];</code>
   * @return The mipWantedPrecision.
   */
  @java.lang.Override
  public double getMipWantedPrecision() {
    return mipWantedPrecision_;
  }

  public static final int MIP_MAX_ACTIVITY_EXPONENT_FIELD_NUMBER = 127;
  private int mipMaxActivityExponent_;
  /**
   * <pre>
   * To avoid integer overflow, we always force the maximum possible constraint
   * activity (and objective value) according to the initial variable domain to
   * be smaller than 2 to this given power. Because of this, we cannot always
   * reach the "mip_wanted_precision" parameter above.
   * This can go as high as 62, but some internal algo currently abort early if
   * they might run into integer overflow, so it is better to keep it a bit
   * lower than this.
   * </pre>
   *
   * <code>optional int32 mip_max_activity_exponent = 127 [default = 53];</code>
   * @return Whether the mipMaxActivityExponent field is set.
   */
  @java.lang.Override
  public boolean hasMipMaxActivityExponent() {
    return ((bitField5_ & 0x00000080) != 0);
  }
  /**
   * <pre>
   * To avoid integer overflow, we always force the maximum possible constraint
   * activity (and objective value) according to the initial variable domain to
   * be smaller than 2 to this given power. Because of this, we cannot always
   * reach the "mip_wanted_precision" parameter above.
   * This can go as high as 62, but some internal algo currently abort early if
   * they might run into integer overflow, so it is better to keep it a bit
   * lower than this.
   * </pre>
   *
   * <code>optional int32 mip_max_activity_exponent = 127 [default = 53];</code>
   * @return The mipMaxActivityExponent.
   */
  @java.lang.Override
  public int getMipMaxActivityExponent() {
    return mipMaxActivityExponent_;
  }

  public static final int MIP_CHECK_PRECISION_FIELD_NUMBER = 128;
  private double mipCheckPrecision_;
  /**
   * <pre>
   * As explained in mip_precision and mip_max_activity_exponent, we cannot
   * always reach the wanted precision during scaling. We use this threshold to
   * enphasize in the logs when the precision seems bad.
   * </pre>
   *
   * <code>optional double mip_check_precision = 128 [default = 0.0001];</code>
   * @return Whether the mipCheckPrecision field is set.
   */
  @java.lang.Override
  public boolean hasMipCheckPrecision() {
    return ((bitField5_ & 0x00000100) != 0);
  }
  /**
   * <pre>
   * As explained in mip_precision and mip_max_activity_exponent, we cannot
   * always reach the wanted precision during scaling. We use this threshold to
   * enphasize in the logs when the precision seems bad.
   * </pre>
   *
   * <code>optional double mip_check_precision = 128 [default = 0.0001];</code>
   * @return The mipCheckPrecision.
   */
  @java.lang.Override
  public double getMipCheckPrecision() {
    return mipCheckPrecision_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeEnum(1, preferredVariableOrder_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeEnum(2, initialPolarity_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeEnum(4, minimizationAlgorithm_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeInt32(11, clauseCleanupPeriod_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeInt32(13, clauseCleanupTarget_);
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      output.writeDouble(15, variableActivityDecay_);
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      output.writeDouble(16, maxVariableActivityValue_);
    }
    if (((bitField0_ & 0x10000000) != 0)) {
      output.writeDouble(17, clauseActivityDecay_);
    }
    if (((bitField0_ & 0x20000000) != 0)) {
      output.writeDouble(18, maxClauseActivityValue_);
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      output.writeDouble(22, glucoseMaxDecay_);
    }
    if (((bitField0_ & 0x04000000) != 0)) {
      output.writeDouble(23, glucoseDecayIncrement_);
    }
    if (((bitField0_ & 0x08000000) != 0)) {
      output.writeInt32(24, glucoseDecayIncrementPeriod_);
    }
    if (((bitField0_ & 0x80000000) != 0)) {
      output.writeInt32(30, restartPeriod_);
    }
    if (((bitField1_ & 0x00008000) != 0)) {
      output.writeInt32(31, randomSeed_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeDouble(32, randomBranchesRatio_);
    }
    if (((bitField1_ & 0x00004000) != 0)) {
      output.writeBool(33, treatBinaryClausesSeparately_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeEnum(34, binaryMinimizationAlgorithm_);
    }
    if (((bitField2_ & 0x00040000) != 0)) {
      output.writeBool(35, useOptimizationHints_);
    }
    if (((bitField1_ & 0x00000100) != 0)) {
      output.writeDouble(36, maxTimeInSeconds_);
    }
    if (((bitField1_ & 0x00000400) != 0)) {
      output.writeInt64(37, maxNumberOfConflicts_);
    }
    if (((bitField1_ & 0x00000800) != 0)) {
      output.writeInt64(40, maxMemoryInMb_);
    }
    if (((bitField1_ & 0x00080000) != 0)) {
      output.writeBool(41, logSearchProgress_);
    }
    if (((bitField1_ & 0x01000000) != 0)) {
      output.writeBool(43, usePbResolution_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeBool(44, usePhaseSaving_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeDouble(45, randomPolarityRatio_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      output.writeInt32(46, pbCleanupIncrement_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      output.writeDouble(47, pbCleanupRatio_);
    }
    if (((bitField1_ & 0x02000000) != 0)) {
      output.writeBool(48, minimizeReductionDuringPbResolution_);
    }
    if (((bitField1_ & 0x04000000) != 0)) {
      output.writeBool(49, countAssumptionLevelsInLbd_);
    }
    if (((bitField2_ & 0x00080000) != 0)) {
      output.writeBool(50, minimizeCore_);
    }
    if (((bitField2_ & 0x00400000) != 0)) {
      output.writeEnum(51, maxSatAssumptionOrder_);
    }
    if (((bitField2_ & 0x00800000) != 0)) {
      output.writeBool(52, maxSatReverseAssumptionOrder_);
    }
    if (((bitField2_ & 0x01000000) != 0)) {
      output.writeEnum(53, maxSatStratification_);
    }
    if (((bitField1_ & 0x08000000) != 0)) {
      output.writeInt32(54, presolveBveThreshold_);
    }
    if (((bitField1_ & 0x10000000) != 0)) {
      output.writeInt32(55, presolveBveClauseWeight_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeBool(56, subsumptionDuringConflictAnalysis_);
    }
    if (((bitField1_ & 0x20000000) != 0)) {
      output.writeDouble(57, presolveProbingDeterministicTimeLimit_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      output.writeEnum(58, clauseCleanupProtection_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      output.writeInt32(59, clauseCleanupLbdBound_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      output.writeEnum(60, clauseCleanupOrdering_);
    }
    for (int i = 0; i < restartAlgorithms_.size(); i++) {
      output.writeEnum(61, restartAlgorithms_.get(i));
    }
    if (((bitField1_ & 0x00000001) != 0)) {
      output.writeInt32(62, restartRunningWindowSize_);
    }
    if (((bitField1_ & 0x00000002) != 0)) {
      output.writeDouble(63, restartDlAverageRatio_);
    }
    if (((bitField1_ & 0x00000008) != 0)) {
      output.writeBool(64, useBlockingRestart_);
    }
    if (((bitField1_ & 0x00000010) != 0)) {
      output.writeInt32(65, blockingRestartWindowSize_);
    }
    if (((bitField1_ & 0x00000020) != 0)) {
      output.writeDouble(66, blockingRestartMultiplier_);
    }
    if (((bitField1_ & 0x00000200) != 0)) {
      output.writeDouble(67, maxDeterministicTime_);
    }
    if (((bitField1_ & 0x00000040) != 0)) {
      output.writeInt32(68, numConflictsBeforeStrategyChanges_);
    }
    if (((bitField1_ & 0x00000080) != 0)) {
      output.writeDouble(69, strategyChangeIncreaseRatio_);
    }
    if (((bitField0_ & 0x40000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 70, defaultRestartAlgorithms_);
    }
    if (((bitField1_ & 0x00000004) != 0)) {
      output.writeDouble(71, restartLbdAverageRatio_);
    }
    if (((bitField1_ & 0x80000000) != 0)) {
      output.writeBool(72, presolveUseBva_);
    }
    if (((bitField2_ & 0x00000001) != 0)) {
      output.writeInt32(73, presolveBvaThreshold_);
    }
    if (((bitField2_ & 0x02000000) != 0)) {
      output.writeBool(74, usePrecedencesInDisjunctiveConstraint_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeBool(75, useErwaHeuristic_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeDouble(76, initialVariablesActivity_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeBool(77, alsoBumpVariablesInConflictReasons_);
    }
    if (((bitField2_ & 0x04000000) != 0)) {
      output.writeBool(78, useOverloadCheckerInCumulativeConstraint_);
    }
    if (((bitField2_ & 0x08000000) != 0)) {
      output.writeBool(79, useTimetableEdgeFindingInCumulativeConstraint_);
    }
    if (((bitField2_ & 0x10000000) != 0)) {
      output.writeBool(80, useDisjunctiveConstraintInCumulativeConstraint_);
    }
    if (((bitField3_ & 0x00040000) != 0)) {
      output.writeEnum(82, searchBranching_);
    }
    if (((bitField3_ & 0x40000000) != 0)) {
      output.writeBool(83, optimizeWithCore_);
    }
    if (((bitField2_ & 0x00100000) != 0)) {
      output.writeBool(84, findMultipleCores_);
    }
    if (((bitField4_ & 0x00000002) != 0)) {
      output.writeBool(85, optimizeWithMaxHs_);
    }
    if (((bitField2_ & 0x00000004) != 0)) {
      output.writeBool(86, cpModelPresolve_);
    }
    if (((bitField4_ & 0x00000004) != 0)) {
      output.writeBool(87, enumerateAllSolutions_);
    }
    if (((bitField1_ & 0x40000000) != 0)) {
      output.writeBool(88, presolveBlockedClause_);
    }
    if (((bitField2_ & 0x00200000) != 0)) {
      output.writeBool(89, coverOptimization_);
    }
    if (((bitField2_ & 0x20000000) != 0)) {
      output.writeInt32(90, linearizationLevel_);
    }
    if (((bitField3_ & 0x00000001) != 0)) {
      output.writeInt32(91, maxNumCuts_);
    }
    if (((bitField3_ & 0x00000002) != 0)) {
      output.writeBool(92, onlyAddCutsAtLevelZero_);
    }
    if (((bitField2_ & 0x00000040) != 0)) {
      output.writeBool(93, cpModelUseSatPresolve_);
    }
    if (((bitField3_ & 0x00400000) != 0)) {
      output.writeBool(94, exploitIntegerLpSolution_);
    }
    if (((bitField4_ & 0x00000040) != 0)) {
      output.writeBool(95, autoDetectGreaterThanAtLeastOneOf_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      output.writeInt32(96, minimizeWithPropagationRestartPeriod_);
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      output.writeInt32(97, minimizeWithPropagationNumDecisions_);
    }
    if (((bitField4_ & 0x00000080) != 0)) {
      output.writeBool(98, stopAfterFirstSolution_);
    }
    if (((bitField4_ & 0x00000001) != 0)) {
      output.writeInt32(99, binarySearchNumConflicts_);
    }
    if (((bitField4_ & 0x00000200) != 0)) {
      output.writeInt32(100, numSearchWorkers_);
    }
    if (((bitField4_ & 0x00008000) != 0)) {
      output.writeBool(101, useLnsOnly_);
    }
    if (((bitField4_ & 0x01000000) != 0)) {
      output.writeBool(103, randomizeSearch_);
    }
    if (((bitField4_ & 0x02000000) != 0)) {
      output.writeInt64(104, searchRandomizationTolerance_);
    }
    if (((bitField4_ & 0x00010000) != 0)) {
      output.writeBool(105, lnsFocusOnDecisionVariables_);
    }
    if (((bitField4_ & 0x00000020) != 0)) {
      output.writeBool(106, instantiateAllVariables_);
    }
    if (((bitField2_ & 0x40000000) != 0)) {
      output.writeInt32(107, booleanEncodingLevel_);
    }
    if (((bitField4_ & 0x04000000) != 0)) {
      output.writeBool(108, useOptionalVariables_);
    }
    if (((bitField4_ & 0x08000000) != 0)) {
      output.writeBool(109, useExactLpReason_);
    }
    if (((bitField2_ & 0x00000020) != 0)) {
      output.writeInt32(110, cpModelProbingLevel_);
    }
    if (((bitField3_ & 0x00000004) != 0)) {
      output.writeBool(111, addKnapsackCuts_);
    }
    if (((bitField3_ & 0x00000400) != 0)) {
      output.writeBool(112, addLpConstraintsLazily_);
    }
    if (((bitField4_ & 0x00002000) != 0)) {
      output.writeBool(113, shareObjectiveBounds_);
    }
    if (((bitField4_ & 0x00004000) != 0)) {
      output.writeBool(114, shareLevelZeroBounds_);
    }
    if (((bitField3_ & 0x00000800) != 0)) {
      output.writeDouble(115, minOrthogonalityForLpConstraints_);
    }
    if (((bitField3_ & 0x00800000) != 0)) {
      output.writeBool(116, exploitAllLpSolution_);
    }
    if (((bitField3_ & 0x00000008) != 0)) {
      output.writeBool(117, addCgCuts_);
    }
    if (((bitField3_ & 0x00000200) != 0)) {
      output.writeInt32(119, maxIntegerRoundingScaling_);
    }
    if (((bitField3_ & 0x00000010) != 0)) {
      output.writeBool(120, addMirCuts_);
    }
    if (((bitField3_ & 0x00002000) != 0)) {
      output.writeInt32(121, maxConsecutiveInactiveCount_);
    }
    if (((bitField3_ & 0x00020000) != 0)) {
      output.writeInt32(122, newConstraintsBatchSize_);
    }
    if (((bitField3_ & 0x20000000) != 0)) {
      output.writeInt64(123, pseudoCostReliabilityThreshold_);
    }
    if (((bitField5_ & 0x00000008) != 0)) {
      output.writeDouble(124, mipMaxBound_);
    }
    if (((bitField5_ & 0x00000010) != 0)) {
      output.writeDouble(125, mipVarScaling_);
    }
    if (((bitField5_ & 0x00000040) != 0)) {
      output.writeDouble(126, mipWantedPrecision_);
    }
    if (((bitField5_ & 0x00000080) != 0)) {
      output.writeInt32(127, mipMaxActivityExponent_);
    }
    if (((bitField5_ & 0x00000100) != 0)) {
      output.writeDouble(128, mipCheckPrecision_);
    }
    if (((bitField4_ & 0x00080000) != 0)) {
      output.writeBool(129, useRinsLns_);
    }
    if (((bitField3_ & 0x01000000) != 0)) {
      output.writeBool(130, exploitBestSolution_);
    }
    if (((bitField3_ & 0x04000000) != 0)) {
      output.writeBool(131, exploitObjective_);
    }
    if (((bitField4_ & 0x00000010) != 0)) {
      output.writeBool(132, fillTightenedDomainsInResponse_);
    }
    if (((bitField4_ & 0x20000000) != 0)) {
      output.writeBool(133, useCombinedNoOverlap_);
    }
    if (((bitField4_ & 0x00000800) != 0)) {
      output.writeInt32(134, interleaveBatchSize_);
    }
    if (((bitField4_ & 0x40000000) != 0)) {
      output.writeBool(135, catchSigintSignal_);
    }
    if (((bitField4_ & 0x00000400) != 0)) {
      output.writeBool(136, interleaveSearch_);
    }
    if (((bitField4_ & 0x00800000) != 0)) {
      output.writeBool(137, diversifyLnsParams_);
    }
    if (((bitField2_ & 0x00000002) != 0)) {
      output.writeInt32(138, maxPresolveIterations_);
    }
    if (((bitField4_ & 0x10000000) != 0)) {
      output.writeBool(139, useBranchingInLp_);
    }
    if (((bitField2_ & 0x00000100) != 0)) {
      output.writeBool(140, expandElementConstraints_);
    }
    if (((bitField4_ & 0x00001000) != 0)) {
      output.writeBool(141, reduceMemoryUsageInInterleaveMode_);
    }
    if (((bitField3_ & 0x08000000) != 0)) {
      output.writeInt64(142, probingPeriodAtRoot_);
    }
    if (((bitField2_ & 0x00000200) != 0)) {
      output.writeBool(143, expandAutomatonConstraints_);
    }
    if (((bitField4_ & 0x80000000) != 0)) {
      output.writeBool(144, useImpliedBounds_);
    }
    if (((bitField2_ & 0x00004000) != 0)) {
      output.writeDouble(145, mergeNoOverlapWorkLimit_);
    }
    if (((bitField2_ & 0x00008000) != 0)) {
      output.writeDouble(146, mergeAtMostOneWorkLimit_);
    }
    if (((bitField2_ & 0x00010000) != 0)) {
      output.writeInt32(147, presolveSubstitutionLevel_);
    }
    if (((bitField3_ & 0x00000080) != 0)) {
      output.writeInt32(148, maxAllDiffCutSize_);
    }
    if (((bitField4_ & 0x00000100) != 0)) {
      output.writeBool(149, stopAfterPresolve_);
    }
    if (((bitField4_ & 0x00400000) != 0)) {
      output.writeBool(150, useRelaxationLns_);
    }
    if (((bitField2_ & 0x00000010) != 0)) {
      output.writeInt32(151, cpModelMaxNumPresolveOperations_);
    }
    if (((bitField3_ & 0x00000100) != 0)) {
      output.writeBool(152, addLinMaxCuts_);
    }
    if (((bitField3_ & 0x00080000) != 0)) {
      output.writeInt32(153, hintConflictLimit_);
    }
    if (((bitField3_ & 0x00001000) != 0)) {
      output.writeInt32(154, maxCutRoundsAtLevelZero_);
    }
    if (((bitField3_ & 0x00004000) != 0)) {
      output.writeDouble(155, cutMaxActiveCountValue_);
    }
    if (((bitField3_ & 0x00008000) != 0)) {
      output.writeDouble(156, cutActiveCountDecay_);
    }
    if (((bitField3_ & 0x00010000) != 0)) {
      output.writeInt32(157, cutCleanupTarget_);
    }
    if (((bitField2_ & 0x00000400) != 0)) {
      output.writeBool(158, expandTableConstraints_);
    }
    if (((bitField1_ & 0x00001000) != 0)) {
      output.writeDouble(159, absoluteGapLimit_);
    }
    if (((bitField1_ & 0x00002000) != 0)) {
      output.writeDouble(160, relativeGapLimit_);
    }
    if (((bitField3_ & 0x02000000) != 0)) {
      output.writeBool(161, exploitRelaxationSolution_);
    }
    if (((bitField2_ & 0x00000008) != 0)) {
      output.writeBool(162, cpModelPostsolveWithFullSolver_);
    }
    if (((bitField2_ & 0x00000080) != 0)) {
      output.writeBool(163, useSatInprocessing_);
    }
    if (((bitField4_ & 0x00100000) != 0)) {
      output.writeBool(164, useFeasibilityPump_);
    }
    if (((bitField4_ & 0x00200000) != 0)) {
      output.writeEnum(165, fpRounding_);
    }
    if (((bitField5_ & 0x00000020) != 0)) {
      output.writeBool(166, mipAutomaticallyScaleVariables_);
    }
    if (((bitField3_ & 0x00100000) != 0)) {
      output.writeBool(167, repairHint_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeInt32(168, polarityRephaseIncrement_);
    }
    if (((bitField3_ & 0x00000020) != 0)) {
      output.writeBool(169, addZeroHalfCuts_);
    }
    if (((bitField2_ & 0x00000800) != 0)) {
      output.writeBool(170, expandAlldiffConstraints_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 171, name_);
    }
    if (((bitField3_ & 0x00000040) != 0)) {
      output.writeBool(172, addCliqueCuts_);
    }
    if (((bitField4_ & 0x00000008) != 0)) {
      output.writeBool(173, keepAllFeasibleSolutionsInPresolve_);
    }
    if (((bitField2_ & 0x00020000) != 0)) {
      output.writeBool(174, presolveExtractIntegerEnforcement_);
    }
    if (((bitField5_ & 0x00000001) != 0)) {
      output.writeBool(175, polishLpSolution_);
    }
    if (((bitField3_ & 0x10000000) != 0)) {
      output.writeBool(176, useProbingSearch_);
    }
    if (((bitField5_ & 0x00000002) != 0)) {
      output.writeBool(177, convertIntervals_);
    }
    if (((bitField1_ & 0x00010000) != 0)) {
      output.writeBool(178, permuteVariableRandomly_);
    }
    if (((bitField1_ & 0x00020000) != 0)) {
      output.writeBool(179, permutePresolveConstraintOrder_);
    }
    if (((bitField1_ & 0x00040000) != 0)) {
      output.writeBool(180, useAbslRandom_);
    }
    if (((bitField2_ & 0x00002000) != 0)) {
      output.writeBool(181, disableConstraintExpansion_);
    }
    if (((bitField2_ & 0x00001000) != 0)) {
      output.writeBool(182, expandReservoirConstraints_);
    }
    if (((bitField5_ & 0x00000004) != 0)) {
      output.writeInt32(183, symmetryLevel_);
    }
    if (((bitField4_ & 0x00020000) != 0)) {
      output.writeBool(184, lnsExpandIntervalsInConstraintGraph_);
    }
    if (((bitField1_ & 0x00200000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 185, logPrefix_);
    }
    if (((bitField1_ & 0x00400000) != 0)) {
      output.writeBool(186, logToStdout_);
    }
    if (((bitField1_ & 0x00800000) != 0)) {
      output.writeBool(187, logToResponse_);
    }
    if (((bitField3_ & 0x80000000) != 0)) {
      output.writeBool(188, optimizeWithLbTreeSearch_);
    }
    if (((bitField1_ & 0x00100000) != 0)) {
      output.writeBool(189, logSubsolverStatistics_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeDouble(190, clauseCleanupRatio_);
    }
    if (((bitField2_ & 0x80000000) != 0)) {
      output.writeInt32(191, maxDomainSizeWhenEncodingEqNeqConstraints_);
    }
    if (((bitField3_ & 0x00200000) != 0)) {
      output.writeBool(192, fixVariablesToTheirHintedValue_);
    }
    if (((bitField4_ & 0x00040000) != 0)) {
      output.writeInt32(193, solutionPoolSize_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(1, preferredVariableOrder_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(2, initialPolarity_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(4, minimizationAlgorithm_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(11, clauseCleanupPeriod_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(13, clauseCleanupTarget_);
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(15, variableActivityDecay_);
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(16, maxVariableActivityValue_);
    }
    if (((bitField0_ & 0x10000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(17, clauseActivityDecay_);
    }
    if (((bitField0_ & 0x20000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(18, maxClauseActivityValue_);
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(22, glucoseMaxDecay_);
    }
    if (((bitField0_ & 0x04000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(23, glucoseDecayIncrement_);
    }
    if (((bitField0_ & 0x08000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(24, glucoseDecayIncrementPeriod_);
    }
    if (((bitField0_ & 0x80000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(30, restartPeriod_);
    }
    if (((bitField1_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(31, randomSeed_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(32, randomBranchesRatio_);
    }
    if (((bitField1_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(33, treatBinaryClausesSeparately_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(34, binaryMinimizationAlgorithm_);
    }
    if (((bitField2_ & 0x00040000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(35, useOptimizationHints_);
    }
    if (((bitField1_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(36, maxTimeInSeconds_);
    }
    if (((bitField1_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(37, maxNumberOfConflicts_);
    }
    if (((bitField1_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(40, maxMemoryInMb_);
    }
    if (((bitField1_ & 0x00080000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(41, logSearchProgress_);
    }
    if (((bitField1_ & 0x01000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(43, usePbResolution_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(44, usePhaseSaving_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(45, randomPolarityRatio_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(46, pbCleanupIncrement_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(47, pbCleanupRatio_);
    }
    if (((bitField1_ & 0x02000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(48, minimizeReductionDuringPbResolution_);
    }
    if (((bitField1_ & 0x04000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(49, countAssumptionLevelsInLbd_);
    }
    if (((bitField2_ & 0x00080000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(50, minimizeCore_);
    }
    if (((bitField2_ & 0x00400000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(51, maxSatAssumptionOrder_);
    }
    if (((bitField2_ & 0x00800000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(52, maxSatReverseAssumptionOrder_);
    }
    if (((bitField2_ & 0x01000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(53, maxSatStratification_);
    }
    if (((bitField1_ & 0x08000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(54, presolveBveThreshold_);
    }
    if (((bitField1_ & 0x10000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(55, presolveBveClauseWeight_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(56, subsumptionDuringConflictAnalysis_);
    }
    if (((bitField1_ & 0x20000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(57, presolveProbingDeterministicTimeLimit_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(58, clauseCleanupProtection_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(59, clauseCleanupLbdBound_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(60, clauseCleanupOrdering_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < restartAlgorithms_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeEnumSizeNoTag(restartAlgorithms_.get(i));
      }
      size += dataSize;
      size += 2 * restartAlgorithms_.size();
    }
    if (((bitField1_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(62, restartRunningWindowSize_);
    }
    if (((bitField1_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(63, restartDlAverageRatio_);
    }
    if (((bitField1_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(64, useBlockingRestart_);
    }
    if (((bitField1_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(65, blockingRestartWindowSize_);
    }
    if (((bitField1_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(66, blockingRestartMultiplier_);
    }
    if (((bitField1_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(67, maxDeterministicTime_);
    }
    if (((bitField1_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(68, numConflictsBeforeStrategyChanges_);
    }
    if (((bitField1_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(69, strategyChangeIncreaseRatio_);
    }
    if (((bitField0_ & 0x40000000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(70, defaultRestartAlgorithms_);
    }
    if (((bitField1_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(71, restartLbdAverageRatio_);
    }
    if (((bitField1_ & 0x80000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(72, presolveUseBva_);
    }
    if (((bitField2_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(73, presolveBvaThreshold_);
    }
    if (((bitField2_ & 0x02000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(74, usePrecedencesInDisjunctiveConstraint_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(75, useErwaHeuristic_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(76, initialVariablesActivity_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(77, alsoBumpVariablesInConflictReasons_);
    }
    if (((bitField2_ & 0x04000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(78, useOverloadCheckerInCumulativeConstraint_);
    }
    if (((bitField2_ & 0x08000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(79, useTimetableEdgeFindingInCumulativeConstraint_);
    }
    if (((bitField2_ & 0x10000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(80, useDisjunctiveConstraintInCumulativeConstraint_);
    }
    if (((bitField3_ & 0x00040000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(82, searchBranching_);
    }
    if (((bitField3_ & 0x40000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(83, optimizeWithCore_);
    }
    if (((bitField2_ & 0x00100000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(84, findMultipleCores_);
    }
    if (((bitField4_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(85, optimizeWithMaxHs_);
    }
    if (((bitField2_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(86, cpModelPresolve_);
    }
    if (((bitField4_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(87, enumerateAllSolutions_);
    }
    if (((bitField1_ & 0x40000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(88, presolveBlockedClause_);
    }
    if (((bitField2_ & 0x00200000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(89, coverOptimization_);
    }
    if (((bitField2_ & 0x20000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(90, linearizationLevel_);
    }
    if (((bitField3_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(91, maxNumCuts_);
    }
    if (((bitField3_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(92, onlyAddCutsAtLevelZero_);
    }
    if (((bitField2_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(93, cpModelUseSatPresolve_);
    }
    if (((bitField3_ & 0x00400000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(94, exploitIntegerLpSolution_);
    }
    if (((bitField4_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(95, autoDetectGreaterThanAtLeastOneOf_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(96, minimizeWithPropagationRestartPeriod_);
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(97, minimizeWithPropagationNumDecisions_);
    }
    if (((bitField4_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(98, stopAfterFirstSolution_);
    }
    if (((bitField4_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(99, binarySearchNumConflicts_);
    }
    if (((bitField4_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(100, numSearchWorkers_);
    }
    if (((bitField4_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(101, useLnsOnly_);
    }
    if (((bitField4_ & 0x01000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(103, randomizeSearch_);
    }
    if (((bitField4_ & 0x02000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(104, searchRandomizationTolerance_);
    }
    if (((bitField4_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(105, lnsFocusOnDecisionVariables_);
    }
    if (((bitField4_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(106, instantiateAllVariables_);
    }
    if (((bitField2_ & 0x40000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(107, booleanEncodingLevel_);
    }
    if (((bitField4_ & 0x04000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(108, useOptionalVariables_);
    }
    if (((bitField4_ & 0x08000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(109, useExactLpReason_);
    }
    if (((bitField2_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(110, cpModelProbingLevel_);
    }
    if (((bitField3_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(111, addKnapsackCuts_);
    }
    if (((bitField3_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(112, addLpConstraintsLazily_);
    }
    if (((bitField4_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(113, shareObjectiveBounds_);
    }
    if (((bitField4_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(114, shareLevelZeroBounds_);
    }
    if (((bitField3_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(115, minOrthogonalityForLpConstraints_);
    }
    if (((bitField3_ & 0x00800000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(116, exploitAllLpSolution_);
    }
    if (((bitField3_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(117, addCgCuts_);
    }
    if (((bitField3_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(119, maxIntegerRoundingScaling_);
    }
    if (((bitField3_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(120, addMirCuts_);
    }
    if (((bitField3_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(121, maxConsecutiveInactiveCount_);
    }
    if (((bitField3_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(122, newConstraintsBatchSize_);
    }
    if (((bitField3_ & 0x20000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(123, pseudoCostReliabilityThreshold_);
    }
    if (((bitField5_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(124, mipMaxBound_);
    }
    if (((bitField5_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(125, mipVarScaling_);
    }
    if (((bitField5_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(126, mipWantedPrecision_);
    }
    if (((bitField5_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(127, mipMaxActivityExponent_);
    }
    if (((bitField5_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(128, mipCheckPrecision_);
    }
    if (((bitField4_ & 0x00080000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(129, useRinsLns_);
    }
    if (((bitField3_ & 0x01000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(130, exploitBestSolution_);
    }
    if (((bitField3_ & 0x04000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(131, exploitObjective_);
    }
    if (((bitField4_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(132, fillTightenedDomainsInResponse_);
    }
    if (((bitField4_ & 0x20000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(133, useCombinedNoOverlap_);
    }
    if (((bitField4_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(134, interleaveBatchSize_);
    }
    if (((bitField4_ & 0x40000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(135, catchSigintSignal_);
    }
    if (((bitField4_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(136, interleaveSearch_);
    }
    if (((bitField4_ & 0x00800000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(137, diversifyLnsParams_);
    }
    if (((bitField2_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(138, maxPresolveIterations_);
    }
    if (((bitField4_ & 0x10000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(139, useBranchingInLp_);
    }
    if (((bitField2_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(140, expandElementConstraints_);
    }
    if (((bitField4_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(141, reduceMemoryUsageInInterleaveMode_);
    }
    if (((bitField3_ & 0x08000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(142, probingPeriodAtRoot_);
    }
    if (((bitField2_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(143, expandAutomatonConstraints_);
    }
    if (((bitField4_ & 0x80000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(144, useImpliedBounds_);
    }
    if (((bitField2_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(145, mergeNoOverlapWorkLimit_);
    }
    if (((bitField2_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(146, mergeAtMostOneWorkLimit_);
    }
    if (((bitField2_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(147, presolveSubstitutionLevel_);
    }
    if (((bitField3_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(148, maxAllDiffCutSize_);
    }
    if (((bitField4_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(149, stopAfterPresolve_);
    }
    if (((bitField4_ & 0x00400000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(150, useRelaxationLns_);
    }
    if (((bitField2_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(151, cpModelMaxNumPresolveOperations_);
    }
    if (((bitField3_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(152, addLinMaxCuts_);
    }
    if (((bitField3_ & 0x00080000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(153, hintConflictLimit_);
    }
    if (((bitField3_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(154, maxCutRoundsAtLevelZero_);
    }
    if (((bitField3_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(155, cutMaxActiveCountValue_);
    }
    if (((bitField3_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(156, cutActiveCountDecay_);
    }
    if (((bitField3_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(157, cutCleanupTarget_);
    }
    if (((bitField2_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(158, expandTableConstraints_);
    }
    if (((bitField1_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(159, absoluteGapLimit_);
    }
    if (((bitField1_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(160, relativeGapLimit_);
    }
    if (((bitField3_ & 0x02000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(161, exploitRelaxationSolution_);
    }
    if (((bitField2_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(162, cpModelPostsolveWithFullSolver_);
    }
    if (((bitField2_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(163, useSatInprocessing_);
    }
    if (((bitField4_ & 0x00100000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(164, useFeasibilityPump_);
    }
    if (((bitField4_ & 0x00200000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(165, fpRounding_);
    }
    if (((bitField5_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(166, mipAutomaticallyScaleVariables_);
    }
    if (((bitField3_ & 0x00100000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(167, repairHint_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(168, polarityRephaseIncrement_);
    }
    if (((bitField3_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(169, addZeroHalfCuts_);
    }
    if (((bitField2_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(170, expandAlldiffConstraints_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(171, name_);
    }
    if (((bitField3_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(172, addCliqueCuts_);
    }
    if (((bitField4_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(173, keepAllFeasibleSolutionsInPresolve_);
    }
    if (((bitField2_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(174, presolveExtractIntegerEnforcement_);
    }
    if (((bitField5_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(175, polishLpSolution_);
    }
    if (((bitField3_ & 0x10000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(176, useProbingSearch_);
    }
    if (((bitField5_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(177, convertIntervals_);
    }
    if (((bitField1_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(178, permuteVariableRandomly_);
    }
    if (((bitField1_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(179, permutePresolveConstraintOrder_);
    }
    if (((bitField1_ & 0x00040000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(180, useAbslRandom_);
    }
    if (((bitField2_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(181, disableConstraintExpansion_);
    }
    if (((bitField2_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(182, expandReservoirConstraints_);
    }
    if (((bitField5_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(183, symmetryLevel_);
    }
    if (((bitField4_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(184, lnsExpandIntervalsInConstraintGraph_);
    }
    if (((bitField1_ & 0x00200000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(185, logPrefix_);
    }
    if (((bitField1_ & 0x00400000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(186, logToStdout_);
    }
    if (((bitField1_ & 0x00800000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(187, logToResponse_);
    }
    if (((bitField3_ & 0x80000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(188, optimizeWithLbTreeSearch_);
    }
    if (((bitField1_ & 0x00100000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(189, logSubsolverStatistics_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(190, clauseCleanupRatio_);
    }
    if (((bitField2_ & 0x80000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(191, maxDomainSizeWhenEncodingEqNeqConstraints_);
    }
    if (((bitField3_ & 0x00200000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(192, fixVariablesToTheirHintedValue_);
    }
    if (((bitField4_ & 0x00040000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(193, solutionPoolSize_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ortools.sat.SatParameters)) {
      return super.equals(obj);
    }
    com.google.ortools.sat.SatParameters other = (com.google.ortools.sat.SatParameters) obj;

    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName()
          .equals(other.getName())) return false;
    }
    if (hasPreferredVariableOrder() != other.hasPreferredVariableOrder()) return false;
    if (hasPreferredVariableOrder()) {
      if (preferredVariableOrder_ != other.preferredVariableOrder_) return false;
    }
    if (hasInitialPolarity() != other.hasInitialPolarity()) return false;
    if (hasInitialPolarity()) {
      if (initialPolarity_ != other.initialPolarity_) return false;
    }
    if (hasUsePhaseSaving() != other.hasUsePhaseSaving()) return false;
    if (hasUsePhaseSaving()) {
      if (getUsePhaseSaving()
          != other.getUsePhaseSaving()) return false;
    }
    if (hasPolarityRephaseIncrement() != other.hasPolarityRephaseIncrement()) return false;
    if (hasPolarityRephaseIncrement()) {
      if (getPolarityRephaseIncrement()
          != other.getPolarityRephaseIncrement()) return false;
    }
    if (hasRandomPolarityRatio() != other.hasRandomPolarityRatio()) return false;
    if (hasRandomPolarityRatio()) {
      if (java.lang.Double.doubleToLongBits(getRandomPolarityRatio())
          != java.lang.Double.doubleToLongBits(
              other.getRandomPolarityRatio())) return false;
    }
    if (hasRandomBranchesRatio() != other.hasRandomBranchesRatio()) return false;
    if (hasRandomBranchesRatio()) {
      if (java.lang.Double.doubleToLongBits(getRandomBranchesRatio())
          != java.lang.Double.doubleToLongBits(
              other.getRandomBranchesRatio())) return false;
    }
    if (hasUseErwaHeuristic() != other.hasUseErwaHeuristic()) return false;
    if (hasUseErwaHeuristic()) {
      if (getUseErwaHeuristic()
          != other.getUseErwaHeuristic()) return false;
    }
    if (hasInitialVariablesActivity() != other.hasInitialVariablesActivity()) return false;
    if (hasInitialVariablesActivity()) {
      if (java.lang.Double.doubleToLongBits(getInitialVariablesActivity())
          != java.lang.Double.doubleToLongBits(
              other.getInitialVariablesActivity())) return false;
    }
    if (hasAlsoBumpVariablesInConflictReasons() != other.hasAlsoBumpVariablesInConflictReasons()) return false;
    if (hasAlsoBumpVariablesInConflictReasons()) {
      if (getAlsoBumpVariablesInConflictReasons()
          != other.getAlsoBumpVariablesInConflictReasons()) return false;
    }
    if (hasMinimizationAlgorithm() != other.hasMinimizationAlgorithm()) return false;
    if (hasMinimizationAlgorithm()) {
      if (minimizationAlgorithm_ != other.minimizationAlgorithm_) return false;
    }
    if (hasBinaryMinimizationAlgorithm() != other.hasBinaryMinimizationAlgorithm()) return false;
    if (hasBinaryMinimizationAlgorithm()) {
      if (binaryMinimizationAlgorithm_ != other.binaryMinimizationAlgorithm_) return false;
    }
    if (hasSubsumptionDuringConflictAnalysis() != other.hasSubsumptionDuringConflictAnalysis()) return false;
    if (hasSubsumptionDuringConflictAnalysis()) {
      if (getSubsumptionDuringConflictAnalysis()
          != other.getSubsumptionDuringConflictAnalysis()) return false;
    }
    if (hasClauseCleanupPeriod() != other.hasClauseCleanupPeriod()) return false;
    if (hasClauseCleanupPeriod()) {
      if (getClauseCleanupPeriod()
          != other.getClauseCleanupPeriod()) return false;
    }
    if (hasClauseCleanupTarget() != other.hasClauseCleanupTarget()) return false;
    if (hasClauseCleanupTarget()) {
      if (getClauseCleanupTarget()
          != other.getClauseCleanupTarget()) return false;
    }
    if (hasClauseCleanupRatio() != other.hasClauseCleanupRatio()) return false;
    if (hasClauseCleanupRatio()) {
      if (java.lang.Double.doubleToLongBits(getClauseCleanupRatio())
          != java.lang.Double.doubleToLongBits(
              other.getClauseCleanupRatio())) return false;
    }
    if (hasClauseCleanupProtection() != other.hasClauseCleanupProtection()) return false;
    if (hasClauseCleanupProtection()) {
      if (clauseCleanupProtection_ != other.clauseCleanupProtection_) return false;
    }
    if (hasClauseCleanupLbdBound() != other.hasClauseCleanupLbdBound()) return false;
    if (hasClauseCleanupLbdBound()) {
      if (getClauseCleanupLbdBound()
          != other.getClauseCleanupLbdBound()) return false;
    }
    if (hasClauseCleanupOrdering() != other.hasClauseCleanupOrdering()) return false;
    if (hasClauseCleanupOrdering()) {
      if (clauseCleanupOrdering_ != other.clauseCleanupOrdering_) return false;
    }
    if (hasPbCleanupIncrement() != other.hasPbCleanupIncrement()) return false;
    if (hasPbCleanupIncrement()) {
      if (getPbCleanupIncrement()
          != other.getPbCleanupIncrement()) return false;
    }
    if (hasPbCleanupRatio() != other.hasPbCleanupRatio()) return false;
    if (hasPbCleanupRatio()) {
      if (java.lang.Double.doubleToLongBits(getPbCleanupRatio())
          != java.lang.Double.doubleToLongBits(
              other.getPbCleanupRatio())) return false;
    }
    if (hasMinimizeWithPropagationRestartPeriod() != other.hasMinimizeWithPropagationRestartPeriod()) return false;
    if (hasMinimizeWithPropagationRestartPeriod()) {
      if (getMinimizeWithPropagationRestartPeriod()
          != other.getMinimizeWithPropagationRestartPeriod()) return false;
    }
    if (hasMinimizeWithPropagationNumDecisions() != other.hasMinimizeWithPropagationNumDecisions()) return false;
    if (hasMinimizeWithPropagationNumDecisions()) {
      if (getMinimizeWithPropagationNumDecisions()
          != other.getMinimizeWithPropagationNumDecisions()) return false;
    }
    if (hasVariableActivityDecay() != other.hasVariableActivityDecay()) return false;
    if (hasVariableActivityDecay()) {
      if (java.lang.Double.doubleToLongBits(getVariableActivityDecay())
          != java.lang.Double.doubleToLongBits(
              other.getVariableActivityDecay())) return false;
    }
    if (hasMaxVariableActivityValue() != other.hasMaxVariableActivityValue()) return false;
    if (hasMaxVariableActivityValue()) {
      if (java.lang.Double.doubleToLongBits(getMaxVariableActivityValue())
          != java.lang.Double.doubleToLongBits(
              other.getMaxVariableActivityValue())) return false;
    }
    if (hasGlucoseMaxDecay() != other.hasGlucoseMaxDecay()) return false;
    if (hasGlucoseMaxDecay()) {
      if (java.lang.Double.doubleToLongBits(getGlucoseMaxDecay())
          != java.lang.Double.doubleToLongBits(
              other.getGlucoseMaxDecay())) return false;
    }
    if (hasGlucoseDecayIncrement() != other.hasGlucoseDecayIncrement()) return false;
    if (hasGlucoseDecayIncrement()) {
      if (java.lang.Double.doubleToLongBits(getGlucoseDecayIncrement())
          != java.lang.Double.doubleToLongBits(
              other.getGlucoseDecayIncrement())) return false;
    }
    if (hasGlucoseDecayIncrementPeriod() != other.hasGlucoseDecayIncrementPeriod()) return false;
    if (hasGlucoseDecayIncrementPeriod()) {
      if (getGlucoseDecayIncrementPeriod()
          != other.getGlucoseDecayIncrementPeriod()) return false;
    }
    if (hasClauseActivityDecay() != other.hasClauseActivityDecay()) return false;
    if (hasClauseActivityDecay()) {
      if (java.lang.Double.doubleToLongBits(getClauseActivityDecay())
          != java.lang.Double.doubleToLongBits(
              other.getClauseActivityDecay())) return false;
    }
    if (hasMaxClauseActivityValue() != other.hasMaxClauseActivityValue()) return false;
    if (hasMaxClauseActivityValue()) {
      if (java.lang.Double.doubleToLongBits(getMaxClauseActivityValue())
          != java.lang.Double.doubleToLongBits(
              other.getMaxClauseActivityValue())) return false;
    }
    if (!restartAlgorithms_.equals(other.restartAlgorithms_)) return false;
    if (hasDefaultRestartAlgorithms() != other.hasDefaultRestartAlgorithms()) return false;
    if (hasDefaultRestartAlgorithms()) {
      if (!getDefaultRestartAlgorithms()
          .equals(other.getDefaultRestartAlgorithms())) return false;
    }
    if (hasRestartPeriod() != other.hasRestartPeriod()) return false;
    if (hasRestartPeriod()) {
      if (getRestartPeriod()
          != other.getRestartPeriod()) return false;
    }
    if (hasRestartRunningWindowSize() != other.hasRestartRunningWindowSize()) return false;
    if (hasRestartRunningWindowSize()) {
      if (getRestartRunningWindowSize()
          != other.getRestartRunningWindowSize()) return false;
    }
    if (hasRestartDlAverageRatio() != other.hasRestartDlAverageRatio()) return false;
    if (hasRestartDlAverageRatio()) {
      if (java.lang.Double.doubleToLongBits(getRestartDlAverageRatio())
          != java.lang.Double.doubleToLongBits(
              other.getRestartDlAverageRatio())) return false;
    }
    if (hasRestartLbdAverageRatio() != other.hasRestartLbdAverageRatio()) return false;
    if (hasRestartLbdAverageRatio()) {
      if (java.lang.Double.doubleToLongBits(getRestartLbdAverageRatio())
          != java.lang.Double.doubleToLongBits(
              other.getRestartLbdAverageRatio())) return false;
    }
    if (hasUseBlockingRestart() != other.hasUseBlockingRestart()) return false;
    if (hasUseBlockingRestart()) {
      if (getUseBlockingRestart()
          != other.getUseBlockingRestart()) return false;
    }
    if (hasBlockingRestartWindowSize() != other.hasBlockingRestartWindowSize()) return false;
    if (hasBlockingRestartWindowSize()) {
      if (getBlockingRestartWindowSize()
          != other.getBlockingRestartWindowSize()) return false;
    }
    if (hasBlockingRestartMultiplier() != other.hasBlockingRestartMultiplier()) return false;
    if (hasBlockingRestartMultiplier()) {
      if (java.lang.Double.doubleToLongBits(getBlockingRestartMultiplier())
          != java.lang.Double.doubleToLongBits(
              other.getBlockingRestartMultiplier())) return false;
    }
    if (hasNumConflictsBeforeStrategyChanges() != other.hasNumConflictsBeforeStrategyChanges()) return false;
    if (hasNumConflictsBeforeStrategyChanges()) {
      if (getNumConflictsBeforeStrategyChanges()
          != other.getNumConflictsBeforeStrategyChanges()) return false;
    }
    if (hasStrategyChangeIncreaseRatio() != other.hasStrategyChangeIncreaseRatio()) return false;
    if (hasStrategyChangeIncreaseRatio()) {
      if (java.lang.Double.doubleToLongBits(getStrategyChangeIncreaseRatio())
          != java.lang.Double.doubleToLongBits(
              other.getStrategyChangeIncreaseRatio())) return false;
    }
    if (hasMaxTimeInSeconds() != other.hasMaxTimeInSeconds()) return false;
    if (hasMaxTimeInSeconds()) {
      if (java.lang.Double.doubleToLongBits(getMaxTimeInSeconds())
          != java.lang.Double.doubleToLongBits(
              other.getMaxTimeInSeconds())) return false;
    }
    if (hasMaxDeterministicTime() != other.hasMaxDeterministicTime()) return false;
    if (hasMaxDeterministicTime()) {
      if (java.lang.Double.doubleToLongBits(getMaxDeterministicTime())
          != java.lang.Double.doubleToLongBits(
              other.getMaxDeterministicTime())) return false;
    }
    if (hasMaxNumberOfConflicts() != other.hasMaxNumberOfConflicts()) return false;
    if (hasMaxNumberOfConflicts()) {
      if (getMaxNumberOfConflicts()
          != other.getMaxNumberOfConflicts()) return false;
    }
    if (hasMaxMemoryInMb() != other.hasMaxMemoryInMb()) return false;
    if (hasMaxMemoryInMb()) {
      if (getMaxMemoryInMb()
          != other.getMaxMemoryInMb()) return false;
    }
    if (hasAbsoluteGapLimit() != other.hasAbsoluteGapLimit()) return false;
    if (hasAbsoluteGapLimit()) {
      if (java.lang.Double.doubleToLongBits(getAbsoluteGapLimit())
          != java.lang.Double.doubleToLongBits(
              other.getAbsoluteGapLimit())) return false;
    }
    if (hasRelativeGapLimit() != other.hasRelativeGapLimit()) return false;
    if (hasRelativeGapLimit()) {
      if (java.lang.Double.doubleToLongBits(getRelativeGapLimit())
          != java.lang.Double.doubleToLongBits(
              other.getRelativeGapLimit())) return false;
    }
    if (hasTreatBinaryClausesSeparately() != other.hasTreatBinaryClausesSeparately()) return false;
    if (hasTreatBinaryClausesSeparately()) {
      if (getTreatBinaryClausesSeparately()
          != other.getTreatBinaryClausesSeparately()) return false;
    }
    if (hasRandomSeed() != other.hasRandomSeed()) return false;
    if (hasRandomSeed()) {
      if (getRandomSeed()
          != other.getRandomSeed()) return false;
    }
    if (hasPermuteVariableRandomly() != other.hasPermuteVariableRandomly()) return false;
    if (hasPermuteVariableRandomly()) {
      if (getPermuteVariableRandomly()
          != other.getPermuteVariableRandomly()) return false;
    }
    if (hasPermutePresolveConstraintOrder() != other.hasPermutePresolveConstraintOrder()) return false;
    if (hasPermutePresolveConstraintOrder()) {
      if (getPermutePresolveConstraintOrder()
          != other.getPermutePresolveConstraintOrder()) return false;
    }
    if (hasUseAbslRandom() != other.hasUseAbslRandom()) return false;
    if (hasUseAbslRandom()) {
      if (getUseAbslRandom()
          != other.getUseAbslRandom()) return false;
    }
    if (hasLogSearchProgress() != other.hasLogSearchProgress()) return false;
    if (hasLogSearchProgress()) {
      if (getLogSearchProgress()
          != other.getLogSearchProgress()) return false;
    }
    if (hasLogSubsolverStatistics() != other.hasLogSubsolverStatistics()) return false;
    if (hasLogSubsolverStatistics()) {
      if (getLogSubsolverStatistics()
          != other.getLogSubsolverStatistics()) return false;
    }
    if (hasLogPrefix() != other.hasLogPrefix()) return false;
    if (hasLogPrefix()) {
      if (!getLogPrefix()
          .equals(other.getLogPrefix())) return false;
    }
    if (hasLogToStdout() != other.hasLogToStdout()) return false;
    if (hasLogToStdout()) {
      if (getLogToStdout()
          != other.getLogToStdout()) return false;
    }
    if (hasLogToResponse() != other.hasLogToResponse()) return false;
    if (hasLogToResponse()) {
      if (getLogToResponse()
          != other.getLogToResponse()) return false;
    }
    if (hasUsePbResolution() != other.hasUsePbResolution()) return false;
    if (hasUsePbResolution()) {
      if (getUsePbResolution()
          != other.getUsePbResolution()) return false;
    }
    if (hasMinimizeReductionDuringPbResolution() != other.hasMinimizeReductionDuringPbResolution()) return false;
    if (hasMinimizeReductionDuringPbResolution()) {
      if (getMinimizeReductionDuringPbResolution()
          != other.getMinimizeReductionDuringPbResolution()) return false;
    }
    if (hasCountAssumptionLevelsInLbd() != other.hasCountAssumptionLevelsInLbd()) return false;
    if (hasCountAssumptionLevelsInLbd()) {
      if (getCountAssumptionLevelsInLbd()
          != other.getCountAssumptionLevelsInLbd()) return false;
    }
    if (hasPresolveBveThreshold() != other.hasPresolveBveThreshold()) return false;
    if (hasPresolveBveThreshold()) {
      if (getPresolveBveThreshold()
          != other.getPresolveBveThreshold()) return false;
    }
    if (hasPresolveBveClauseWeight() != other.hasPresolveBveClauseWeight()) return false;
    if (hasPresolveBveClauseWeight()) {
      if (getPresolveBveClauseWeight()
          != other.getPresolveBveClauseWeight()) return false;
    }
    if (hasPresolveProbingDeterministicTimeLimit() != other.hasPresolveProbingDeterministicTimeLimit()) return false;
    if (hasPresolveProbingDeterministicTimeLimit()) {
      if (java.lang.Double.doubleToLongBits(getPresolveProbingDeterministicTimeLimit())
          != java.lang.Double.doubleToLongBits(
              other.getPresolveProbingDeterministicTimeLimit())) return false;
    }
    if (hasPresolveBlockedClause() != other.hasPresolveBlockedClause()) return false;
    if (hasPresolveBlockedClause()) {
      if (getPresolveBlockedClause()
          != other.getPresolveBlockedClause()) return false;
    }
    if (hasPresolveUseBva() != other.hasPresolveUseBva()) return false;
    if (hasPresolveUseBva()) {
      if (getPresolveUseBva()
          != other.getPresolveUseBva()) return false;
    }
    if (hasPresolveBvaThreshold() != other.hasPresolveBvaThreshold()) return false;
    if (hasPresolveBvaThreshold()) {
      if (getPresolveBvaThreshold()
          != other.getPresolveBvaThreshold()) return false;
    }
    if (hasMaxPresolveIterations() != other.hasMaxPresolveIterations()) return false;
    if (hasMaxPresolveIterations()) {
      if (getMaxPresolveIterations()
          != other.getMaxPresolveIterations()) return false;
    }
    if (hasCpModelPresolve() != other.hasCpModelPresolve()) return false;
    if (hasCpModelPresolve()) {
      if (getCpModelPresolve()
          != other.getCpModelPresolve()) return false;
    }
    if (hasCpModelPostsolveWithFullSolver() != other.hasCpModelPostsolveWithFullSolver()) return false;
    if (hasCpModelPostsolveWithFullSolver()) {
      if (getCpModelPostsolveWithFullSolver()
          != other.getCpModelPostsolveWithFullSolver()) return false;
    }
    if (hasCpModelMaxNumPresolveOperations() != other.hasCpModelMaxNumPresolveOperations()) return false;
    if (hasCpModelMaxNumPresolveOperations()) {
      if (getCpModelMaxNumPresolveOperations()
          != other.getCpModelMaxNumPresolveOperations()) return false;
    }
    if (hasCpModelProbingLevel() != other.hasCpModelProbingLevel()) return false;
    if (hasCpModelProbingLevel()) {
      if (getCpModelProbingLevel()
          != other.getCpModelProbingLevel()) return false;
    }
    if (hasCpModelUseSatPresolve() != other.hasCpModelUseSatPresolve()) return false;
    if (hasCpModelUseSatPresolve()) {
      if (getCpModelUseSatPresolve()
          != other.getCpModelUseSatPresolve()) return false;
    }
    if (hasUseSatInprocessing() != other.hasUseSatInprocessing()) return false;
    if (hasUseSatInprocessing()) {
      if (getUseSatInprocessing()
          != other.getUseSatInprocessing()) return false;
    }
    if (hasExpandElementConstraints() != other.hasExpandElementConstraints()) return false;
    if (hasExpandElementConstraints()) {
      if (getExpandElementConstraints()
          != other.getExpandElementConstraints()) return false;
    }
    if (hasExpandAutomatonConstraints() != other.hasExpandAutomatonConstraints()) return false;
    if (hasExpandAutomatonConstraints()) {
      if (getExpandAutomatonConstraints()
          != other.getExpandAutomatonConstraints()) return false;
    }
    if (hasExpandTableConstraints() != other.hasExpandTableConstraints()) return false;
    if (hasExpandTableConstraints()) {
      if (getExpandTableConstraints()
          != other.getExpandTableConstraints()) return false;
    }
    if (hasExpandAlldiffConstraints() != other.hasExpandAlldiffConstraints()) return false;
    if (hasExpandAlldiffConstraints()) {
      if (getExpandAlldiffConstraints()
          != other.getExpandAlldiffConstraints()) return false;
    }
    if (hasExpandReservoirConstraints() != other.hasExpandReservoirConstraints()) return false;
    if (hasExpandReservoirConstraints()) {
      if (getExpandReservoirConstraints()
          != other.getExpandReservoirConstraints()) return false;
    }
    if (hasDisableConstraintExpansion() != other.hasDisableConstraintExpansion()) return false;
    if (hasDisableConstraintExpansion()) {
      if (getDisableConstraintExpansion()
          != other.getDisableConstraintExpansion()) return false;
    }
    if (hasMergeNoOverlapWorkLimit() != other.hasMergeNoOverlapWorkLimit()) return false;
    if (hasMergeNoOverlapWorkLimit()) {
      if (java.lang.Double.doubleToLongBits(getMergeNoOverlapWorkLimit())
          != java.lang.Double.doubleToLongBits(
              other.getMergeNoOverlapWorkLimit())) return false;
    }
    if (hasMergeAtMostOneWorkLimit() != other.hasMergeAtMostOneWorkLimit()) return false;
    if (hasMergeAtMostOneWorkLimit()) {
      if (java.lang.Double.doubleToLongBits(getMergeAtMostOneWorkLimit())
          != java.lang.Double.doubleToLongBits(
              other.getMergeAtMostOneWorkLimit())) return false;
    }
    if (hasPresolveSubstitutionLevel() != other.hasPresolveSubstitutionLevel()) return false;
    if (hasPresolveSubstitutionLevel()) {
      if (getPresolveSubstitutionLevel()
          != other.getPresolveSubstitutionLevel()) return false;
    }
    if (hasPresolveExtractIntegerEnforcement() != other.hasPresolveExtractIntegerEnforcement()) return false;
    if (hasPresolveExtractIntegerEnforcement()) {
      if (getPresolveExtractIntegerEnforcement()
          != other.getPresolveExtractIntegerEnforcement()) return false;
    }
    if (hasUseOptimizationHints() != other.hasUseOptimizationHints()) return false;
    if (hasUseOptimizationHints()) {
      if (getUseOptimizationHints()
          != other.getUseOptimizationHints()) return false;
    }
    if (hasMinimizeCore() != other.hasMinimizeCore()) return false;
    if (hasMinimizeCore()) {
      if (getMinimizeCore()
          != other.getMinimizeCore()) return false;
    }
    if (hasFindMultipleCores() != other.hasFindMultipleCores()) return false;
    if (hasFindMultipleCores()) {
      if (getFindMultipleCores()
          != other.getFindMultipleCores()) return false;
    }
    if (hasCoverOptimization() != other.hasCoverOptimization()) return false;
    if (hasCoverOptimization()) {
      if (getCoverOptimization()
          != other.getCoverOptimization()) return false;
    }
    if (hasMaxSatAssumptionOrder() != other.hasMaxSatAssumptionOrder()) return false;
    if (hasMaxSatAssumptionOrder()) {
      if (maxSatAssumptionOrder_ != other.maxSatAssumptionOrder_) return false;
    }
    if (hasMaxSatReverseAssumptionOrder() != other.hasMaxSatReverseAssumptionOrder()) return false;
    if (hasMaxSatReverseAssumptionOrder()) {
      if (getMaxSatReverseAssumptionOrder()
          != other.getMaxSatReverseAssumptionOrder()) return false;
    }
    if (hasMaxSatStratification() != other.hasMaxSatStratification()) return false;
    if (hasMaxSatStratification()) {
      if (maxSatStratification_ != other.maxSatStratification_) return false;
    }
    if (hasUsePrecedencesInDisjunctiveConstraint() != other.hasUsePrecedencesInDisjunctiveConstraint()) return false;
    if (hasUsePrecedencesInDisjunctiveConstraint()) {
      if (getUsePrecedencesInDisjunctiveConstraint()
          != other.getUsePrecedencesInDisjunctiveConstraint()) return false;
    }
    if (hasUseOverloadCheckerInCumulativeConstraint() != other.hasUseOverloadCheckerInCumulativeConstraint()) return false;
    if (hasUseOverloadCheckerInCumulativeConstraint()) {
      if (getUseOverloadCheckerInCumulativeConstraint()
          != other.getUseOverloadCheckerInCumulativeConstraint()) return false;
    }
    if (hasUseTimetableEdgeFindingInCumulativeConstraint() != other.hasUseTimetableEdgeFindingInCumulativeConstraint()) return false;
    if (hasUseTimetableEdgeFindingInCumulativeConstraint()) {
      if (getUseTimetableEdgeFindingInCumulativeConstraint()
          != other.getUseTimetableEdgeFindingInCumulativeConstraint()) return false;
    }
    if (hasUseDisjunctiveConstraintInCumulativeConstraint() != other.hasUseDisjunctiveConstraintInCumulativeConstraint()) return false;
    if (hasUseDisjunctiveConstraintInCumulativeConstraint()) {
      if (getUseDisjunctiveConstraintInCumulativeConstraint()
          != other.getUseDisjunctiveConstraintInCumulativeConstraint()) return false;
    }
    if (hasLinearizationLevel() != other.hasLinearizationLevel()) return false;
    if (hasLinearizationLevel()) {
      if (getLinearizationLevel()
          != other.getLinearizationLevel()) return false;
    }
    if (hasBooleanEncodingLevel() != other.hasBooleanEncodingLevel()) return false;
    if (hasBooleanEncodingLevel()) {
      if (getBooleanEncodingLevel()
          != other.getBooleanEncodingLevel()) return false;
    }
    if (hasMaxDomainSizeWhenEncodingEqNeqConstraints() != other.hasMaxDomainSizeWhenEncodingEqNeqConstraints()) return false;
    if (hasMaxDomainSizeWhenEncodingEqNeqConstraints()) {
      if (getMaxDomainSizeWhenEncodingEqNeqConstraints()
          != other.getMaxDomainSizeWhenEncodingEqNeqConstraints()) return false;
    }
    if (hasMaxNumCuts() != other.hasMaxNumCuts()) return false;
    if (hasMaxNumCuts()) {
      if (getMaxNumCuts()
          != other.getMaxNumCuts()) return false;
    }
    if (hasOnlyAddCutsAtLevelZero() != other.hasOnlyAddCutsAtLevelZero()) return false;
    if (hasOnlyAddCutsAtLevelZero()) {
      if (getOnlyAddCutsAtLevelZero()
          != other.getOnlyAddCutsAtLevelZero()) return false;
    }
    if (hasAddKnapsackCuts() != other.hasAddKnapsackCuts()) return false;
    if (hasAddKnapsackCuts()) {
      if (getAddKnapsackCuts()
          != other.getAddKnapsackCuts()) return false;
    }
    if (hasAddCgCuts() != other.hasAddCgCuts()) return false;
    if (hasAddCgCuts()) {
      if (getAddCgCuts()
          != other.getAddCgCuts()) return false;
    }
    if (hasAddMirCuts() != other.hasAddMirCuts()) return false;
    if (hasAddMirCuts()) {
      if (getAddMirCuts()
          != other.getAddMirCuts()) return false;
    }
    if (hasAddZeroHalfCuts() != other.hasAddZeroHalfCuts()) return false;
    if (hasAddZeroHalfCuts()) {
      if (getAddZeroHalfCuts()
          != other.getAddZeroHalfCuts()) return false;
    }
    if (hasAddCliqueCuts() != other.hasAddCliqueCuts()) return false;
    if (hasAddCliqueCuts()) {
      if (getAddCliqueCuts()
          != other.getAddCliqueCuts()) return false;
    }
    if (hasMaxAllDiffCutSize() != other.hasMaxAllDiffCutSize()) return false;
    if (hasMaxAllDiffCutSize()) {
      if (getMaxAllDiffCutSize()
          != other.getMaxAllDiffCutSize()) return false;
    }
    if (hasAddLinMaxCuts() != other.hasAddLinMaxCuts()) return false;
    if (hasAddLinMaxCuts()) {
      if (getAddLinMaxCuts()
          != other.getAddLinMaxCuts()) return false;
    }
    if (hasMaxIntegerRoundingScaling() != other.hasMaxIntegerRoundingScaling()) return false;
    if (hasMaxIntegerRoundingScaling()) {
      if (getMaxIntegerRoundingScaling()
          != other.getMaxIntegerRoundingScaling()) return false;
    }
    if (hasAddLpConstraintsLazily() != other.hasAddLpConstraintsLazily()) return false;
    if (hasAddLpConstraintsLazily()) {
      if (getAddLpConstraintsLazily()
          != other.getAddLpConstraintsLazily()) return false;
    }
    if (hasMinOrthogonalityForLpConstraints() != other.hasMinOrthogonalityForLpConstraints()) return false;
    if (hasMinOrthogonalityForLpConstraints()) {
      if (java.lang.Double.doubleToLongBits(getMinOrthogonalityForLpConstraints())
          != java.lang.Double.doubleToLongBits(
              other.getMinOrthogonalityForLpConstraints())) return false;
    }
    if (hasMaxCutRoundsAtLevelZero() != other.hasMaxCutRoundsAtLevelZero()) return false;
    if (hasMaxCutRoundsAtLevelZero()) {
      if (getMaxCutRoundsAtLevelZero()
          != other.getMaxCutRoundsAtLevelZero()) return false;
    }
    if (hasMaxConsecutiveInactiveCount() != other.hasMaxConsecutiveInactiveCount()) return false;
    if (hasMaxConsecutiveInactiveCount()) {
      if (getMaxConsecutiveInactiveCount()
          != other.getMaxConsecutiveInactiveCount()) return false;
    }
    if (hasCutMaxActiveCountValue() != other.hasCutMaxActiveCountValue()) return false;
    if (hasCutMaxActiveCountValue()) {
      if (java.lang.Double.doubleToLongBits(getCutMaxActiveCountValue())
          != java.lang.Double.doubleToLongBits(
              other.getCutMaxActiveCountValue())) return false;
    }
    if (hasCutActiveCountDecay() != other.hasCutActiveCountDecay()) return false;
    if (hasCutActiveCountDecay()) {
      if (java.lang.Double.doubleToLongBits(getCutActiveCountDecay())
          != java.lang.Double.doubleToLongBits(
              other.getCutActiveCountDecay())) return false;
    }
    if (hasCutCleanupTarget() != other.hasCutCleanupTarget()) return false;
    if (hasCutCleanupTarget()) {
      if (getCutCleanupTarget()
          != other.getCutCleanupTarget()) return false;
    }
    if (hasNewConstraintsBatchSize() != other.hasNewConstraintsBatchSize()) return false;
    if (hasNewConstraintsBatchSize()) {
      if (getNewConstraintsBatchSize()
          != other.getNewConstraintsBatchSize()) return false;
    }
    if (hasSearchBranching() != other.hasSearchBranching()) return false;
    if (hasSearchBranching()) {
      if (searchBranching_ != other.searchBranching_) return false;
    }
    if (hasHintConflictLimit() != other.hasHintConflictLimit()) return false;
    if (hasHintConflictLimit()) {
      if (getHintConflictLimit()
          != other.getHintConflictLimit()) return false;
    }
    if (hasRepairHint() != other.hasRepairHint()) return false;
    if (hasRepairHint()) {
      if (getRepairHint()
          != other.getRepairHint()) return false;
    }
    if (hasFixVariablesToTheirHintedValue() != other.hasFixVariablesToTheirHintedValue()) return false;
    if (hasFixVariablesToTheirHintedValue()) {
      if (getFixVariablesToTheirHintedValue()
          != other.getFixVariablesToTheirHintedValue()) return false;
    }
    if (hasExploitIntegerLpSolution() != other.hasExploitIntegerLpSolution()) return false;
    if (hasExploitIntegerLpSolution()) {
      if (getExploitIntegerLpSolution()
          != other.getExploitIntegerLpSolution()) return false;
    }
    if (hasExploitAllLpSolution() != other.hasExploitAllLpSolution()) return false;
    if (hasExploitAllLpSolution()) {
      if (getExploitAllLpSolution()
          != other.getExploitAllLpSolution()) return false;
    }
    if (hasExploitBestSolution() != other.hasExploitBestSolution()) return false;
    if (hasExploitBestSolution()) {
      if (getExploitBestSolution()
          != other.getExploitBestSolution()) return false;
    }
    if (hasExploitRelaxationSolution() != other.hasExploitRelaxationSolution()) return false;
    if (hasExploitRelaxationSolution()) {
      if (getExploitRelaxationSolution()
          != other.getExploitRelaxationSolution()) return false;
    }
    if (hasExploitObjective() != other.hasExploitObjective()) return false;
    if (hasExploitObjective()) {
      if (getExploitObjective()
          != other.getExploitObjective()) return false;
    }
    if (hasProbingPeriodAtRoot() != other.hasProbingPeriodAtRoot()) return false;
    if (hasProbingPeriodAtRoot()) {
      if (getProbingPeriodAtRoot()
          != other.getProbingPeriodAtRoot()) return false;
    }
    if (hasUseProbingSearch() != other.hasUseProbingSearch()) return false;
    if (hasUseProbingSearch()) {
      if (getUseProbingSearch()
          != other.getUseProbingSearch()) return false;
    }
    if (hasPseudoCostReliabilityThreshold() != other.hasPseudoCostReliabilityThreshold()) return false;
    if (hasPseudoCostReliabilityThreshold()) {
      if (getPseudoCostReliabilityThreshold()
          != other.getPseudoCostReliabilityThreshold()) return false;
    }
    if (hasOptimizeWithCore() != other.hasOptimizeWithCore()) return false;
    if (hasOptimizeWithCore()) {
      if (getOptimizeWithCore()
          != other.getOptimizeWithCore()) return false;
    }
    if (hasOptimizeWithLbTreeSearch() != other.hasOptimizeWithLbTreeSearch()) return false;
    if (hasOptimizeWithLbTreeSearch()) {
      if (getOptimizeWithLbTreeSearch()
          != other.getOptimizeWithLbTreeSearch()) return false;
    }
    if (hasBinarySearchNumConflicts() != other.hasBinarySearchNumConflicts()) return false;
    if (hasBinarySearchNumConflicts()) {
      if (getBinarySearchNumConflicts()
          != other.getBinarySearchNumConflicts()) return false;
    }
    if (hasOptimizeWithMaxHs() != other.hasOptimizeWithMaxHs()) return false;
    if (hasOptimizeWithMaxHs()) {
      if (getOptimizeWithMaxHs()
          != other.getOptimizeWithMaxHs()) return false;
    }
    if (hasEnumerateAllSolutions() != other.hasEnumerateAllSolutions()) return false;
    if (hasEnumerateAllSolutions()) {
      if (getEnumerateAllSolutions()
          != other.getEnumerateAllSolutions()) return false;
    }
    if (hasKeepAllFeasibleSolutionsInPresolve() != other.hasKeepAllFeasibleSolutionsInPresolve()) return false;
    if (hasKeepAllFeasibleSolutionsInPresolve()) {
      if (getKeepAllFeasibleSolutionsInPresolve()
          != other.getKeepAllFeasibleSolutionsInPresolve()) return false;
    }
    if (hasFillTightenedDomainsInResponse() != other.hasFillTightenedDomainsInResponse()) return false;
    if (hasFillTightenedDomainsInResponse()) {
      if (getFillTightenedDomainsInResponse()
          != other.getFillTightenedDomainsInResponse()) return false;
    }
    if (hasInstantiateAllVariables() != other.hasInstantiateAllVariables()) return false;
    if (hasInstantiateAllVariables()) {
      if (getInstantiateAllVariables()
          != other.getInstantiateAllVariables()) return false;
    }
    if (hasAutoDetectGreaterThanAtLeastOneOf() != other.hasAutoDetectGreaterThanAtLeastOneOf()) return false;
    if (hasAutoDetectGreaterThanAtLeastOneOf()) {
      if (getAutoDetectGreaterThanAtLeastOneOf()
          != other.getAutoDetectGreaterThanAtLeastOneOf()) return false;
    }
    if (hasStopAfterFirstSolution() != other.hasStopAfterFirstSolution()) return false;
    if (hasStopAfterFirstSolution()) {
      if (getStopAfterFirstSolution()
          != other.getStopAfterFirstSolution()) return false;
    }
    if (hasStopAfterPresolve() != other.hasStopAfterPresolve()) return false;
    if (hasStopAfterPresolve()) {
      if (getStopAfterPresolve()
          != other.getStopAfterPresolve()) return false;
    }
    if (hasNumSearchWorkers() != other.hasNumSearchWorkers()) return false;
    if (hasNumSearchWorkers()) {
      if (getNumSearchWorkers()
          != other.getNumSearchWorkers()) return false;
    }
    if (hasInterleaveSearch() != other.hasInterleaveSearch()) return false;
    if (hasInterleaveSearch()) {
      if (getInterleaveSearch()
          != other.getInterleaveSearch()) return false;
    }
    if (hasInterleaveBatchSize() != other.hasInterleaveBatchSize()) return false;
    if (hasInterleaveBatchSize()) {
      if (getInterleaveBatchSize()
          != other.getInterleaveBatchSize()) return false;
    }
    if (hasReduceMemoryUsageInInterleaveMode() != other.hasReduceMemoryUsageInInterleaveMode()) return false;
    if (hasReduceMemoryUsageInInterleaveMode()) {
      if (getReduceMemoryUsageInInterleaveMode()
          != other.getReduceMemoryUsageInInterleaveMode()) return false;
    }
    if (hasShareObjectiveBounds() != other.hasShareObjectiveBounds()) return false;
    if (hasShareObjectiveBounds()) {
      if (getShareObjectiveBounds()
          != other.getShareObjectiveBounds()) return false;
    }
    if (hasShareLevelZeroBounds() != other.hasShareLevelZeroBounds()) return false;
    if (hasShareLevelZeroBounds()) {
      if (getShareLevelZeroBounds()
          != other.getShareLevelZeroBounds()) return false;
    }
    if (hasUseLnsOnly() != other.hasUseLnsOnly()) return false;
    if (hasUseLnsOnly()) {
      if (getUseLnsOnly()
          != other.getUseLnsOnly()) return false;
    }
    if (hasLnsFocusOnDecisionVariables() != other.hasLnsFocusOnDecisionVariables()) return false;
    if (hasLnsFocusOnDecisionVariables()) {
      if (getLnsFocusOnDecisionVariables()
          != other.getLnsFocusOnDecisionVariables()) return false;
    }
    if (hasLnsExpandIntervalsInConstraintGraph() != other.hasLnsExpandIntervalsInConstraintGraph()) return false;
    if (hasLnsExpandIntervalsInConstraintGraph()) {
      if (getLnsExpandIntervalsInConstraintGraph()
          != other.getLnsExpandIntervalsInConstraintGraph()) return false;
    }
    if (hasSolutionPoolSize() != other.hasSolutionPoolSize()) return false;
    if (hasSolutionPoolSize()) {
      if (getSolutionPoolSize()
          != other.getSolutionPoolSize()) return false;
    }
    if (hasUseRinsLns() != other.hasUseRinsLns()) return false;
    if (hasUseRinsLns()) {
      if (getUseRinsLns()
          != other.getUseRinsLns()) return false;
    }
    if (hasUseFeasibilityPump() != other.hasUseFeasibilityPump()) return false;
    if (hasUseFeasibilityPump()) {
      if (getUseFeasibilityPump()
          != other.getUseFeasibilityPump()) return false;
    }
    if (hasFpRounding() != other.hasFpRounding()) return false;
    if (hasFpRounding()) {
      if (fpRounding_ != other.fpRounding_) return false;
    }
    if (hasUseRelaxationLns() != other.hasUseRelaxationLns()) return false;
    if (hasUseRelaxationLns()) {
      if (getUseRelaxationLns()
          != other.getUseRelaxationLns()) return false;
    }
    if (hasDiversifyLnsParams() != other.hasDiversifyLnsParams()) return false;
    if (hasDiversifyLnsParams()) {
      if (getDiversifyLnsParams()
          != other.getDiversifyLnsParams()) return false;
    }
    if (hasRandomizeSearch() != other.hasRandomizeSearch()) return false;
    if (hasRandomizeSearch()) {
      if (getRandomizeSearch()
          != other.getRandomizeSearch()) return false;
    }
    if (hasSearchRandomizationTolerance() != other.hasSearchRandomizationTolerance()) return false;
    if (hasSearchRandomizationTolerance()) {
      if (getSearchRandomizationTolerance()
          != other.getSearchRandomizationTolerance()) return false;
    }
    if (hasUseOptionalVariables() != other.hasUseOptionalVariables()) return false;
    if (hasUseOptionalVariables()) {
      if (getUseOptionalVariables()
          != other.getUseOptionalVariables()) return false;
    }
    if (hasUseExactLpReason() != other.hasUseExactLpReason()) return false;
    if (hasUseExactLpReason()) {
      if (getUseExactLpReason()
          != other.getUseExactLpReason()) return false;
    }
    if (hasUseBranchingInLp() != other.hasUseBranchingInLp()) return false;
    if (hasUseBranchingInLp()) {
      if (getUseBranchingInLp()
          != other.getUseBranchingInLp()) return false;
    }
    if (hasUseCombinedNoOverlap() != other.hasUseCombinedNoOverlap()) return false;
    if (hasUseCombinedNoOverlap()) {
      if (getUseCombinedNoOverlap()
          != other.getUseCombinedNoOverlap()) return false;
    }
    if (hasCatchSigintSignal() != other.hasCatchSigintSignal()) return false;
    if (hasCatchSigintSignal()) {
      if (getCatchSigintSignal()
          != other.getCatchSigintSignal()) return false;
    }
    if (hasUseImpliedBounds() != other.hasUseImpliedBounds()) return false;
    if (hasUseImpliedBounds()) {
      if (getUseImpliedBounds()
          != other.getUseImpliedBounds()) return false;
    }
    if (hasPolishLpSolution() != other.hasPolishLpSolution()) return false;
    if (hasPolishLpSolution()) {
      if (getPolishLpSolution()
          != other.getPolishLpSolution()) return false;
    }
    if (hasConvertIntervals() != other.hasConvertIntervals()) return false;
    if (hasConvertIntervals()) {
      if (getConvertIntervals()
          != other.getConvertIntervals()) return false;
    }
    if (hasSymmetryLevel() != other.hasSymmetryLevel()) return false;
    if (hasSymmetryLevel()) {
      if (getSymmetryLevel()
          != other.getSymmetryLevel()) return false;
    }
    if (hasMipMaxBound() != other.hasMipMaxBound()) return false;
    if (hasMipMaxBound()) {
      if (java.lang.Double.doubleToLongBits(getMipMaxBound())
          != java.lang.Double.doubleToLongBits(
              other.getMipMaxBound())) return false;
    }
    if (hasMipVarScaling() != other.hasMipVarScaling()) return false;
    if (hasMipVarScaling()) {
      if (java.lang.Double.doubleToLongBits(getMipVarScaling())
          != java.lang.Double.doubleToLongBits(
              other.getMipVarScaling())) return false;
    }
    if (hasMipAutomaticallyScaleVariables() != other.hasMipAutomaticallyScaleVariables()) return false;
    if (hasMipAutomaticallyScaleVariables()) {
      if (getMipAutomaticallyScaleVariables()
          != other.getMipAutomaticallyScaleVariables()) return false;
    }
    if (hasMipWantedPrecision() != other.hasMipWantedPrecision()) return false;
    if (hasMipWantedPrecision()) {
      if (java.lang.Double.doubleToLongBits(getMipWantedPrecision())
          != java.lang.Double.doubleToLongBits(
              other.getMipWantedPrecision())) return false;
    }
    if (hasMipMaxActivityExponent() != other.hasMipMaxActivityExponent()) return false;
    if (hasMipMaxActivityExponent()) {
      if (getMipMaxActivityExponent()
          != other.getMipMaxActivityExponent()) return false;
    }
    if (hasMipCheckPrecision() != other.hasMipCheckPrecision()) return false;
    if (hasMipCheckPrecision()) {
      if (java.lang.Double.doubleToLongBits(getMipCheckPrecision())
          != java.lang.Double.doubleToLongBits(
              other.getMipCheckPrecision())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasPreferredVariableOrder()) {
      hash = (37 * hash) + PREFERRED_VARIABLE_ORDER_FIELD_NUMBER;
      hash = (53 * hash) + preferredVariableOrder_;
    }
    if (hasInitialPolarity()) {
      hash = (37 * hash) + INITIAL_POLARITY_FIELD_NUMBER;
      hash = (53 * hash) + initialPolarity_;
    }
    if (hasUsePhaseSaving()) {
      hash = (37 * hash) + USE_PHASE_SAVING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUsePhaseSaving());
    }
    if (hasPolarityRephaseIncrement()) {
      hash = (37 * hash) + POLARITY_REPHASE_INCREMENT_FIELD_NUMBER;
      hash = (53 * hash) + getPolarityRephaseIncrement();
    }
    if (hasRandomPolarityRatio()) {
      hash = (37 * hash) + RANDOM_POLARITY_RATIO_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getRandomPolarityRatio()));
    }
    if (hasRandomBranchesRatio()) {
      hash = (37 * hash) + RANDOM_BRANCHES_RATIO_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getRandomBranchesRatio()));
    }
    if (hasUseErwaHeuristic()) {
      hash = (37 * hash) + USE_ERWA_HEURISTIC_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseErwaHeuristic());
    }
    if (hasInitialVariablesActivity()) {
      hash = (37 * hash) + INITIAL_VARIABLES_ACTIVITY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getInitialVariablesActivity()));
    }
    if (hasAlsoBumpVariablesInConflictReasons()) {
      hash = (37 * hash) + ALSO_BUMP_VARIABLES_IN_CONFLICT_REASONS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAlsoBumpVariablesInConflictReasons());
    }
    if (hasMinimizationAlgorithm()) {
      hash = (37 * hash) + MINIMIZATION_ALGORITHM_FIELD_NUMBER;
      hash = (53 * hash) + minimizationAlgorithm_;
    }
    if (hasBinaryMinimizationAlgorithm()) {
      hash = (37 * hash) + BINARY_MINIMIZATION_ALGORITHM_FIELD_NUMBER;
      hash = (53 * hash) + binaryMinimizationAlgorithm_;
    }
    if (hasSubsumptionDuringConflictAnalysis()) {
      hash = (37 * hash) + SUBSUMPTION_DURING_CONFLICT_ANALYSIS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getSubsumptionDuringConflictAnalysis());
    }
    if (hasClauseCleanupPeriod()) {
      hash = (37 * hash) + CLAUSE_CLEANUP_PERIOD_FIELD_NUMBER;
      hash = (53 * hash) + getClauseCleanupPeriod();
    }
    if (hasClauseCleanupTarget()) {
      hash = (37 * hash) + CLAUSE_CLEANUP_TARGET_FIELD_NUMBER;
      hash = (53 * hash) + getClauseCleanupTarget();
    }
    if (hasClauseCleanupRatio()) {
      hash = (37 * hash) + CLAUSE_CLEANUP_RATIO_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getClauseCleanupRatio()));
    }
    if (hasClauseCleanupProtection()) {
      hash = (37 * hash) + CLAUSE_CLEANUP_PROTECTION_FIELD_NUMBER;
      hash = (53 * hash) + clauseCleanupProtection_;
    }
    if (hasClauseCleanupLbdBound()) {
      hash = (37 * hash) + CLAUSE_CLEANUP_LBD_BOUND_FIELD_NUMBER;
      hash = (53 * hash) + getClauseCleanupLbdBound();
    }
    if (hasClauseCleanupOrdering()) {
      hash = (37 * hash) + CLAUSE_CLEANUP_ORDERING_FIELD_NUMBER;
      hash = (53 * hash) + clauseCleanupOrdering_;
    }
    if (hasPbCleanupIncrement()) {
      hash = (37 * hash) + PB_CLEANUP_INCREMENT_FIELD_NUMBER;
      hash = (53 * hash) + getPbCleanupIncrement();
    }
    if (hasPbCleanupRatio()) {
      hash = (37 * hash) + PB_CLEANUP_RATIO_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getPbCleanupRatio()));
    }
    if (hasMinimizeWithPropagationRestartPeriod()) {
      hash = (37 * hash) + MINIMIZE_WITH_PROPAGATION_RESTART_PERIOD_FIELD_NUMBER;
      hash = (53 * hash) + getMinimizeWithPropagationRestartPeriod();
    }
    if (hasMinimizeWithPropagationNumDecisions()) {
      hash = (37 * hash) + MINIMIZE_WITH_PROPAGATION_NUM_DECISIONS_FIELD_NUMBER;
      hash = (53 * hash) + getMinimizeWithPropagationNumDecisions();
    }
    if (hasVariableActivityDecay()) {
      hash = (37 * hash) + VARIABLE_ACTIVITY_DECAY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getVariableActivityDecay()));
    }
    if (hasMaxVariableActivityValue()) {
      hash = (37 * hash) + MAX_VARIABLE_ACTIVITY_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMaxVariableActivityValue()));
    }
    if (hasGlucoseMaxDecay()) {
      hash = (37 * hash) + GLUCOSE_MAX_DECAY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getGlucoseMaxDecay()));
    }
    if (hasGlucoseDecayIncrement()) {
      hash = (37 * hash) + GLUCOSE_DECAY_INCREMENT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getGlucoseDecayIncrement()));
    }
    if (hasGlucoseDecayIncrementPeriod()) {
      hash = (37 * hash) + GLUCOSE_DECAY_INCREMENT_PERIOD_FIELD_NUMBER;
      hash = (53 * hash) + getGlucoseDecayIncrementPeriod();
    }
    if (hasClauseActivityDecay()) {
      hash = (37 * hash) + CLAUSE_ACTIVITY_DECAY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getClauseActivityDecay()));
    }
    if (hasMaxClauseActivityValue()) {
      hash = (37 * hash) + MAX_CLAUSE_ACTIVITY_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMaxClauseActivityValue()));
    }
    if (getRestartAlgorithmsCount() > 0) {
      hash = (37 * hash) + RESTART_ALGORITHMS_FIELD_NUMBER;
      hash = (53 * hash) + restartAlgorithms_.hashCode();
    }
    if (hasDefaultRestartAlgorithms()) {
      hash = (37 * hash) + DEFAULT_RESTART_ALGORITHMS_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultRestartAlgorithms().hashCode();
    }
    if (hasRestartPeriod()) {
      hash = (37 * hash) + RESTART_PERIOD_FIELD_NUMBER;
      hash = (53 * hash) + getRestartPeriod();
    }
    if (hasRestartRunningWindowSize()) {
      hash = (37 * hash) + RESTART_RUNNING_WINDOW_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getRestartRunningWindowSize();
    }
    if (hasRestartDlAverageRatio()) {
      hash = (37 * hash) + RESTART_DL_AVERAGE_RATIO_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getRestartDlAverageRatio()));
    }
    if (hasRestartLbdAverageRatio()) {
      hash = (37 * hash) + RESTART_LBD_AVERAGE_RATIO_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getRestartLbdAverageRatio()));
    }
    if (hasUseBlockingRestart()) {
      hash = (37 * hash) + USE_BLOCKING_RESTART_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseBlockingRestart());
    }
    if (hasBlockingRestartWindowSize()) {
      hash = (37 * hash) + BLOCKING_RESTART_WINDOW_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getBlockingRestartWindowSize();
    }
    if (hasBlockingRestartMultiplier()) {
      hash = (37 * hash) + BLOCKING_RESTART_MULTIPLIER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getBlockingRestartMultiplier()));
    }
    if (hasNumConflictsBeforeStrategyChanges()) {
      hash = (37 * hash) + NUM_CONFLICTS_BEFORE_STRATEGY_CHANGES_FIELD_NUMBER;
      hash = (53 * hash) + getNumConflictsBeforeStrategyChanges();
    }
    if (hasStrategyChangeIncreaseRatio()) {
      hash = (37 * hash) + STRATEGY_CHANGE_INCREASE_RATIO_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getStrategyChangeIncreaseRatio()));
    }
    if (hasMaxTimeInSeconds()) {
      hash = (37 * hash) + MAX_TIME_IN_SECONDS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMaxTimeInSeconds()));
    }
    if (hasMaxDeterministicTime()) {
      hash = (37 * hash) + MAX_DETERMINISTIC_TIME_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMaxDeterministicTime()));
    }
    if (hasMaxNumberOfConflicts()) {
      hash = (37 * hash) + MAX_NUMBER_OF_CONFLICTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getMaxNumberOfConflicts());
    }
    if (hasMaxMemoryInMb()) {
      hash = (37 * hash) + MAX_MEMORY_IN_MB_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getMaxMemoryInMb());
    }
    if (hasAbsoluteGapLimit()) {
      hash = (37 * hash) + ABSOLUTE_GAP_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getAbsoluteGapLimit()));
    }
    if (hasRelativeGapLimit()) {
      hash = (37 * hash) + RELATIVE_GAP_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getRelativeGapLimit()));
    }
    if (hasTreatBinaryClausesSeparately()) {
      hash = (37 * hash) + TREAT_BINARY_CLAUSES_SEPARATELY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getTreatBinaryClausesSeparately());
    }
    if (hasRandomSeed()) {
      hash = (37 * hash) + RANDOM_SEED_FIELD_NUMBER;
      hash = (53 * hash) + getRandomSeed();
    }
    if (hasPermuteVariableRandomly()) {
      hash = (37 * hash) + PERMUTE_VARIABLE_RANDOMLY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getPermuteVariableRandomly());
    }
    if (hasPermutePresolveConstraintOrder()) {
      hash = (37 * hash) + PERMUTE_PRESOLVE_CONSTRAINT_ORDER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getPermutePresolveConstraintOrder());
    }
    if (hasUseAbslRandom()) {
      hash = (37 * hash) + USE_ABSL_RANDOM_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseAbslRandom());
    }
    if (hasLogSearchProgress()) {
      hash = (37 * hash) + LOG_SEARCH_PROGRESS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getLogSearchProgress());
    }
    if (hasLogSubsolverStatistics()) {
      hash = (37 * hash) + LOG_SUBSOLVER_STATISTICS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getLogSubsolverStatistics());
    }
    if (hasLogPrefix()) {
      hash = (37 * hash) + LOG_PREFIX_FIELD_NUMBER;
      hash = (53 * hash) + getLogPrefix().hashCode();
    }
    if (hasLogToStdout()) {
      hash = (37 * hash) + LOG_TO_STDOUT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getLogToStdout());
    }
    if (hasLogToResponse()) {
      hash = (37 * hash) + LOG_TO_RESPONSE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getLogToResponse());
    }
    if (hasUsePbResolution()) {
      hash = (37 * hash) + USE_PB_RESOLUTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUsePbResolution());
    }
    if (hasMinimizeReductionDuringPbResolution()) {
      hash = (37 * hash) + MINIMIZE_REDUCTION_DURING_PB_RESOLUTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getMinimizeReductionDuringPbResolution());
    }
    if (hasCountAssumptionLevelsInLbd()) {
      hash = (37 * hash) + COUNT_ASSUMPTION_LEVELS_IN_LBD_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getCountAssumptionLevelsInLbd());
    }
    if (hasPresolveBveThreshold()) {
      hash = (37 * hash) + PRESOLVE_BVE_THRESHOLD_FIELD_NUMBER;
      hash = (53 * hash) + getPresolveBveThreshold();
    }
    if (hasPresolveBveClauseWeight()) {
      hash = (37 * hash) + PRESOLVE_BVE_CLAUSE_WEIGHT_FIELD_NUMBER;
      hash = (53 * hash) + getPresolveBveClauseWeight();
    }
    if (hasPresolveProbingDeterministicTimeLimit()) {
      hash = (37 * hash) + PRESOLVE_PROBING_DETERMINISTIC_TIME_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getPresolveProbingDeterministicTimeLimit()));
    }
    if (hasPresolveBlockedClause()) {
      hash = (37 * hash) + PRESOLVE_BLOCKED_CLAUSE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getPresolveBlockedClause());
    }
    if (hasPresolveUseBva()) {
      hash = (37 * hash) + PRESOLVE_USE_BVA_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getPresolveUseBva());
    }
    if (hasPresolveBvaThreshold()) {
      hash = (37 * hash) + PRESOLVE_BVA_THRESHOLD_FIELD_NUMBER;
      hash = (53 * hash) + getPresolveBvaThreshold();
    }
    if (hasMaxPresolveIterations()) {
      hash = (37 * hash) + MAX_PRESOLVE_ITERATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxPresolveIterations();
    }
    if (hasCpModelPresolve()) {
      hash = (37 * hash) + CP_MODEL_PRESOLVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getCpModelPresolve());
    }
    if (hasCpModelPostsolveWithFullSolver()) {
      hash = (37 * hash) + CP_MODEL_POSTSOLVE_WITH_FULL_SOLVER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getCpModelPostsolveWithFullSolver());
    }
    if (hasCpModelMaxNumPresolveOperations()) {
      hash = (37 * hash) + CP_MODEL_MAX_NUM_PRESOLVE_OPERATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getCpModelMaxNumPresolveOperations();
    }
    if (hasCpModelProbingLevel()) {
      hash = (37 * hash) + CP_MODEL_PROBING_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + getCpModelProbingLevel();
    }
    if (hasCpModelUseSatPresolve()) {
      hash = (37 * hash) + CP_MODEL_USE_SAT_PRESOLVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getCpModelUseSatPresolve());
    }
    if (hasUseSatInprocessing()) {
      hash = (37 * hash) + USE_SAT_INPROCESSING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseSatInprocessing());
    }
    if (hasExpandElementConstraints()) {
      hash = (37 * hash) + EXPAND_ELEMENT_CONSTRAINTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getExpandElementConstraints());
    }
    if (hasExpandAutomatonConstraints()) {
      hash = (37 * hash) + EXPAND_AUTOMATON_CONSTRAINTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getExpandAutomatonConstraints());
    }
    if (hasExpandTableConstraints()) {
      hash = (37 * hash) + EXPAND_TABLE_CONSTRAINTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getExpandTableConstraints());
    }
    if (hasExpandAlldiffConstraints()) {
      hash = (37 * hash) + EXPAND_ALLDIFF_CONSTRAINTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getExpandAlldiffConstraints());
    }
    if (hasExpandReservoirConstraints()) {
      hash = (37 * hash) + EXPAND_RESERVOIR_CONSTRAINTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getExpandReservoirConstraints());
    }
    if (hasDisableConstraintExpansion()) {
      hash = (37 * hash) + DISABLE_CONSTRAINT_EXPANSION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getDisableConstraintExpansion());
    }
    if (hasMergeNoOverlapWorkLimit()) {
      hash = (37 * hash) + MERGE_NO_OVERLAP_WORK_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMergeNoOverlapWorkLimit()));
    }
    if (hasMergeAtMostOneWorkLimit()) {
      hash = (37 * hash) + MERGE_AT_MOST_ONE_WORK_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMergeAtMostOneWorkLimit()));
    }
    if (hasPresolveSubstitutionLevel()) {
      hash = (37 * hash) + PRESOLVE_SUBSTITUTION_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + getPresolveSubstitutionLevel();
    }
    if (hasPresolveExtractIntegerEnforcement()) {
      hash = (37 * hash) + PRESOLVE_EXTRACT_INTEGER_ENFORCEMENT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getPresolveExtractIntegerEnforcement());
    }
    if (hasUseOptimizationHints()) {
      hash = (37 * hash) + USE_OPTIMIZATION_HINTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseOptimizationHints());
    }
    if (hasMinimizeCore()) {
      hash = (37 * hash) + MINIMIZE_CORE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getMinimizeCore());
    }
    if (hasFindMultipleCores()) {
      hash = (37 * hash) + FIND_MULTIPLE_CORES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getFindMultipleCores());
    }
    if (hasCoverOptimization()) {
      hash = (37 * hash) + COVER_OPTIMIZATION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getCoverOptimization());
    }
    if (hasMaxSatAssumptionOrder()) {
      hash = (37 * hash) + MAX_SAT_ASSUMPTION_ORDER_FIELD_NUMBER;
      hash = (53 * hash) + maxSatAssumptionOrder_;
    }
    if (hasMaxSatReverseAssumptionOrder()) {
      hash = (37 * hash) + MAX_SAT_REVERSE_ASSUMPTION_ORDER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getMaxSatReverseAssumptionOrder());
    }
    if (hasMaxSatStratification()) {
      hash = (37 * hash) + MAX_SAT_STRATIFICATION_FIELD_NUMBER;
      hash = (53 * hash) + maxSatStratification_;
    }
    if (hasUsePrecedencesInDisjunctiveConstraint()) {
      hash = (37 * hash) + USE_PRECEDENCES_IN_DISJUNCTIVE_CONSTRAINT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUsePrecedencesInDisjunctiveConstraint());
    }
    if (hasUseOverloadCheckerInCumulativeConstraint()) {
      hash = (37 * hash) + USE_OVERLOAD_CHECKER_IN_CUMULATIVE_CONSTRAINT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseOverloadCheckerInCumulativeConstraint());
    }
    if (hasUseTimetableEdgeFindingInCumulativeConstraint()) {
      hash = (37 * hash) + USE_TIMETABLE_EDGE_FINDING_IN_CUMULATIVE_CONSTRAINT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseTimetableEdgeFindingInCumulativeConstraint());
    }
    if (hasUseDisjunctiveConstraintInCumulativeConstraint()) {
      hash = (37 * hash) + USE_DISJUNCTIVE_CONSTRAINT_IN_CUMULATIVE_CONSTRAINT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseDisjunctiveConstraintInCumulativeConstraint());
    }
    if (hasLinearizationLevel()) {
      hash = (37 * hash) + LINEARIZATION_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + getLinearizationLevel();
    }
    if (hasBooleanEncodingLevel()) {
      hash = (37 * hash) + BOOLEAN_ENCODING_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + getBooleanEncodingLevel();
    }
    if (hasMaxDomainSizeWhenEncodingEqNeqConstraints()) {
      hash = (37 * hash) + MAX_DOMAIN_SIZE_WHEN_ENCODING_EQ_NEQ_CONSTRAINTS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxDomainSizeWhenEncodingEqNeqConstraints();
    }
    if (hasMaxNumCuts()) {
      hash = (37 * hash) + MAX_NUM_CUTS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxNumCuts();
    }
    if (hasOnlyAddCutsAtLevelZero()) {
      hash = (37 * hash) + ONLY_ADD_CUTS_AT_LEVEL_ZERO_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getOnlyAddCutsAtLevelZero());
    }
    if (hasAddKnapsackCuts()) {
      hash = (37 * hash) + ADD_KNAPSACK_CUTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAddKnapsackCuts());
    }
    if (hasAddCgCuts()) {
      hash = (37 * hash) + ADD_CG_CUTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAddCgCuts());
    }
    if (hasAddMirCuts()) {
      hash = (37 * hash) + ADD_MIR_CUTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAddMirCuts());
    }
    if (hasAddZeroHalfCuts()) {
      hash = (37 * hash) + ADD_ZERO_HALF_CUTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAddZeroHalfCuts());
    }
    if (hasAddCliqueCuts()) {
      hash = (37 * hash) + ADD_CLIQUE_CUTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAddCliqueCuts());
    }
    if (hasMaxAllDiffCutSize()) {
      hash = (37 * hash) + MAX_ALL_DIFF_CUT_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getMaxAllDiffCutSize();
    }
    if (hasAddLinMaxCuts()) {
      hash = (37 * hash) + ADD_LIN_MAX_CUTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAddLinMaxCuts());
    }
    if (hasMaxIntegerRoundingScaling()) {
      hash = (37 * hash) + MAX_INTEGER_ROUNDING_SCALING_FIELD_NUMBER;
      hash = (53 * hash) + getMaxIntegerRoundingScaling();
    }
    if (hasAddLpConstraintsLazily()) {
      hash = (37 * hash) + ADD_LP_CONSTRAINTS_LAZILY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAddLpConstraintsLazily());
    }
    if (hasMinOrthogonalityForLpConstraints()) {
      hash = (37 * hash) + MIN_ORTHOGONALITY_FOR_LP_CONSTRAINTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMinOrthogonalityForLpConstraints()));
    }
    if (hasMaxCutRoundsAtLevelZero()) {
      hash = (37 * hash) + MAX_CUT_ROUNDS_AT_LEVEL_ZERO_FIELD_NUMBER;
      hash = (53 * hash) + getMaxCutRoundsAtLevelZero();
    }
    if (hasMaxConsecutiveInactiveCount()) {
      hash = (37 * hash) + MAX_CONSECUTIVE_INACTIVE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getMaxConsecutiveInactiveCount();
    }
    if (hasCutMaxActiveCountValue()) {
      hash = (37 * hash) + CUT_MAX_ACTIVE_COUNT_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getCutMaxActiveCountValue()));
    }
    if (hasCutActiveCountDecay()) {
      hash = (37 * hash) + CUT_ACTIVE_COUNT_DECAY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getCutActiveCountDecay()));
    }
    if (hasCutCleanupTarget()) {
      hash = (37 * hash) + CUT_CLEANUP_TARGET_FIELD_NUMBER;
      hash = (53 * hash) + getCutCleanupTarget();
    }
    if (hasNewConstraintsBatchSize()) {
      hash = (37 * hash) + NEW_CONSTRAINTS_BATCH_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getNewConstraintsBatchSize();
    }
    if (hasSearchBranching()) {
      hash = (37 * hash) + SEARCH_BRANCHING_FIELD_NUMBER;
      hash = (53 * hash) + searchBranching_;
    }
    if (hasHintConflictLimit()) {
      hash = (37 * hash) + HINT_CONFLICT_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + getHintConflictLimit();
    }
    if (hasRepairHint()) {
      hash = (37 * hash) + REPAIR_HINT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getRepairHint());
    }
    if (hasFixVariablesToTheirHintedValue()) {
      hash = (37 * hash) + FIX_VARIABLES_TO_THEIR_HINTED_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getFixVariablesToTheirHintedValue());
    }
    if (hasExploitIntegerLpSolution()) {
      hash = (37 * hash) + EXPLOIT_INTEGER_LP_SOLUTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getExploitIntegerLpSolution());
    }
    if (hasExploitAllLpSolution()) {
      hash = (37 * hash) + EXPLOIT_ALL_LP_SOLUTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getExploitAllLpSolution());
    }
    if (hasExploitBestSolution()) {
      hash = (37 * hash) + EXPLOIT_BEST_SOLUTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getExploitBestSolution());
    }
    if (hasExploitRelaxationSolution()) {
      hash = (37 * hash) + EXPLOIT_RELAXATION_SOLUTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getExploitRelaxationSolution());
    }
    if (hasExploitObjective()) {
      hash = (37 * hash) + EXPLOIT_OBJECTIVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getExploitObjective());
    }
    if (hasProbingPeriodAtRoot()) {
      hash = (37 * hash) + PROBING_PERIOD_AT_ROOT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getProbingPeriodAtRoot());
    }
    if (hasUseProbingSearch()) {
      hash = (37 * hash) + USE_PROBING_SEARCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseProbingSearch());
    }
    if (hasPseudoCostReliabilityThreshold()) {
      hash = (37 * hash) + PSEUDO_COST_RELIABILITY_THRESHOLD_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getPseudoCostReliabilityThreshold());
    }
    if (hasOptimizeWithCore()) {
      hash = (37 * hash) + OPTIMIZE_WITH_CORE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getOptimizeWithCore());
    }
    if (hasOptimizeWithLbTreeSearch()) {
      hash = (37 * hash) + OPTIMIZE_WITH_LB_TREE_SEARCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getOptimizeWithLbTreeSearch());
    }
    if (hasBinarySearchNumConflicts()) {
      hash = (37 * hash) + BINARY_SEARCH_NUM_CONFLICTS_FIELD_NUMBER;
      hash = (53 * hash) + getBinarySearchNumConflicts();
    }
    if (hasOptimizeWithMaxHs()) {
      hash = (37 * hash) + OPTIMIZE_WITH_MAX_HS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getOptimizeWithMaxHs());
    }
    if (hasEnumerateAllSolutions()) {
      hash = (37 * hash) + ENUMERATE_ALL_SOLUTIONS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getEnumerateAllSolutions());
    }
    if (hasKeepAllFeasibleSolutionsInPresolve()) {
      hash = (37 * hash) + KEEP_ALL_FEASIBLE_SOLUTIONS_IN_PRESOLVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getKeepAllFeasibleSolutionsInPresolve());
    }
    if (hasFillTightenedDomainsInResponse()) {
      hash = (37 * hash) + FILL_TIGHTENED_DOMAINS_IN_RESPONSE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getFillTightenedDomainsInResponse());
    }
    if (hasInstantiateAllVariables()) {
      hash = (37 * hash) + INSTANTIATE_ALL_VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getInstantiateAllVariables());
    }
    if (hasAutoDetectGreaterThanAtLeastOneOf()) {
      hash = (37 * hash) + AUTO_DETECT_GREATER_THAN_AT_LEAST_ONE_OF_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAutoDetectGreaterThanAtLeastOneOf());
    }
    if (hasStopAfterFirstSolution()) {
      hash = (37 * hash) + STOP_AFTER_FIRST_SOLUTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getStopAfterFirstSolution());
    }
    if (hasStopAfterPresolve()) {
      hash = (37 * hash) + STOP_AFTER_PRESOLVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getStopAfterPresolve());
    }
    if (hasNumSearchWorkers()) {
      hash = (37 * hash) + NUM_SEARCH_WORKERS_FIELD_NUMBER;
      hash = (53 * hash) + getNumSearchWorkers();
    }
    if (hasInterleaveSearch()) {
      hash = (37 * hash) + INTERLEAVE_SEARCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getInterleaveSearch());
    }
    if (hasInterleaveBatchSize()) {
      hash = (37 * hash) + INTERLEAVE_BATCH_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getInterleaveBatchSize();
    }
    if (hasReduceMemoryUsageInInterleaveMode()) {
      hash = (37 * hash) + REDUCE_MEMORY_USAGE_IN_INTERLEAVE_MODE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getReduceMemoryUsageInInterleaveMode());
    }
    if (hasShareObjectiveBounds()) {
      hash = (37 * hash) + SHARE_OBJECTIVE_BOUNDS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getShareObjectiveBounds());
    }
    if (hasShareLevelZeroBounds()) {
      hash = (37 * hash) + SHARE_LEVEL_ZERO_BOUNDS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getShareLevelZeroBounds());
    }
    if (hasUseLnsOnly()) {
      hash = (37 * hash) + USE_LNS_ONLY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseLnsOnly());
    }
    if (hasLnsFocusOnDecisionVariables()) {
      hash = (37 * hash) + LNS_FOCUS_ON_DECISION_VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getLnsFocusOnDecisionVariables());
    }
    if (hasLnsExpandIntervalsInConstraintGraph()) {
      hash = (37 * hash) + LNS_EXPAND_INTERVALS_IN_CONSTRAINT_GRAPH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getLnsExpandIntervalsInConstraintGraph());
    }
    if (hasSolutionPoolSize()) {
      hash = (37 * hash) + SOLUTION_POOL_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getSolutionPoolSize();
    }
    if (hasUseRinsLns()) {
      hash = (37 * hash) + USE_RINS_LNS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseRinsLns());
    }
    if (hasUseFeasibilityPump()) {
      hash = (37 * hash) + USE_FEASIBILITY_PUMP_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseFeasibilityPump());
    }
    if (hasFpRounding()) {
      hash = (37 * hash) + FP_ROUNDING_FIELD_NUMBER;
      hash = (53 * hash) + fpRounding_;
    }
    if (hasUseRelaxationLns()) {
      hash = (37 * hash) + USE_RELAXATION_LNS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseRelaxationLns());
    }
    if (hasDiversifyLnsParams()) {
      hash = (37 * hash) + DIVERSIFY_LNS_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getDiversifyLnsParams());
    }
    if (hasRandomizeSearch()) {
      hash = (37 * hash) + RANDOMIZE_SEARCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getRandomizeSearch());
    }
    if (hasSearchRandomizationTolerance()) {
      hash = (37 * hash) + SEARCH_RANDOMIZATION_TOLERANCE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getSearchRandomizationTolerance());
    }
    if (hasUseOptionalVariables()) {
      hash = (37 * hash) + USE_OPTIONAL_VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseOptionalVariables());
    }
    if (hasUseExactLpReason()) {
      hash = (37 * hash) + USE_EXACT_LP_REASON_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseExactLpReason());
    }
    if (hasUseBranchingInLp()) {
      hash = (37 * hash) + USE_BRANCHING_IN_LP_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseBranchingInLp());
    }
    if (hasUseCombinedNoOverlap()) {
      hash = (37 * hash) + USE_COMBINED_NO_OVERLAP_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseCombinedNoOverlap());
    }
    if (hasCatchSigintSignal()) {
      hash = (37 * hash) + CATCH_SIGINT_SIGNAL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getCatchSigintSignal());
    }
    if (hasUseImpliedBounds()) {
      hash = (37 * hash) + USE_IMPLIED_BOUNDS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseImpliedBounds());
    }
    if (hasPolishLpSolution()) {
      hash = (37 * hash) + POLISH_LP_SOLUTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getPolishLpSolution());
    }
    if (hasConvertIntervals()) {
      hash = (37 * hash) + CONVERT_INTERVALS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getConvertIntervals());
    }
    if (hasSymmetryLevel()) {
      hash = (37 * hash) + SYMMETRY_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + getSymmetryLevel();
    }
    if (hasMipMaxBound()) {
      hash = (37 * hash) + MIP_MAX_BOUND_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMipMaxBound()));
    }
    if (hasMipVarScaling()) {
      hash = (37 * hash) + MIP_VAR_SCALING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMipVarScaling()));
    }
    if (hasMipAutomaticallyScaleVariables()) {
      hash = (37 * hash) + MIP_AUTOMATICALLY_SCALE_VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getMipAutomaticallyScaleVariables());
    }
    if (hasMipWantedPrecision()) {
      hash = (37 * hash) + MIP_WANTED_PRECISION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMipWantedPrecision()));
    }
    if (hasMipMaxActivityExponent()) {
      hash = (37 * hash) + MIP_MAX_ACTIVITY_EXPONENT_FIELD_NUMBER;
      hash = (53 * hash) + getMipMaxActivityExponent();
    }
    if (hasMipCheckPrecision()) {
      hash = (37 * hash) + MIP_CHECK_PRECISION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMipCheckPrecision()));
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ortools.sat.SatParameters parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.sat.SatParameters parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.sat.SatParameters parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.sat.SatParameters parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.sat.SatParameters parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.sat.SatParameters parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.sat.SatParameters parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.sat.SatParameters parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ortools.sat.SatParameters parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.ortools.sat.SatParameters parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ortools.sat.SatParameters parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.sat.SatParameters parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ortools.sat.SatParameters prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Contains the definitions for all the sat algorithm parameters and their
   * default values.
   * NEXT TAG: 194
   * </pre>
   *
   * Protobuf type {@code operations_research.sat.SatParameters}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:operations_research.sat.SatParameters)
      com.google.ortools.sat.SatParametersOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParametersOuterClass.internal_static_operations_research_sat_SatParameters_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ortools.sat.SatParametersOuterClass.internal_static_operations_research_sat_SatParameters_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ortools.sat.SatParameters.class, com.google.ortools.sat.SatParameters.Builder.class);
    }

    // Construct using com.google.ortools.sat.SatParameters.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";
      bitField0_ = (bitField0_ & ~0x00000001);
      preferredVariableOrder_ = 0;
      bitField0_ = (bitField0_ & ~0x00000002);
      initialPolarity_ = 1;
      bitField0_ = (bitField0_ & ~0x00000004);
      usePhaseSaving_ = true;
      bitField0_ = (bitField0_ & ~0x00000008);
      polarityRephaseIncrement_ = 1000;
      bitField0_ = (bitField0_ & ~0x00000010);
      randomPolarityRatio_ = 0D;
      bitField0_ = (bitField0_ & ~0x00000020);
      randomBranchesRatio_ = 0D;
      bitField0_ = (bitField0_ & ~0x00000040);
      useErwaHeuristic_ = false;
      bitField0_ = (bitField0_ & ~0x00000080);
      initialVariablesActivity_ = 0D;
      bitField0_ = (bitField0_ & ~0x00000100);
      alsoBumpVariablesInConflictReasons_ = false;
      bitField0_ = (bitField0_ & ~0x00000200);
      minimizationAlgorithm_ = 2;
      bitField0_ = (bitField0_ & ~0x00000400);
      binaryMinimizationAlgorithm_ = 1;
      bitField0_ = (bitField0_ & ~0x00000800);
      subsumptionDuringConflictAnalysis_ = true;
      bitField0_ = (bitField0_ & ~0x00001000);
      clauseCleanupPeriod_ = 10000;
      bitField0_ = (bitField0_ & ~0x00002000);
      clauseCleanupTarget_ = 0;
      bitField0_ = (bitField0_ & ~0x00004000);
      clauseCleanupRatio_ = 0.5D;
      bitField0_ = (bitField0_ & ~0x00008000);
      clauseCleanupProtection_ = 0;
      bitField0_ = (bitField0_ & ~0x00010000);
      clauseCleanupLbdBound_ = 5;
      bitField0_ = (bitField0_ & ~0x00020000);
      clauseCleanupOrdering_ = 0;
      bitField0_ = (bitField0_ & ~0x00040000);
      pbCleanupIncrement_ = 200;
      bitField0_ = (bitField0_ & ~0x00080000);
      pbCleanupRatio_ = 0.5D;
      bitField0_ = (bitField0_ & ~0x00100000);
      minimizeWithPropagationRestartPeriod_ = 10;
      bitField0_ = (bitField0_ & ~0x00200000);
      minimizeWithPropagationNumDecisions_ = 1000;
      bitField0_ = (bitField0_ & ~0x00400000);
      variableActivityDecay_ = 0.8D;
      bitField0_ = (bitField0_ & ~0x00800000);
      maxVariableActivityValue_ = 1e+100D;
      bitField0_ = (bitField0_ & ~0x01000000);
      glucoseMaxDecay_ = 0.95D;
      bitField0_ = (bitField0_ & ~0x02000000);
      glucoseDecayIncrement_ = 0.01D;
      bitField0_ = (bitField0_ & ~0x04000000);
      glucoseDecayIncrementPeriod_ = 5000;
      bitField0_ = (bitField0_ & ~0x08000000);
      clauseActivityDecay_ = 0.999D;
      bitField0_ = (bitField0_ & ~0x10000000);
      maxClauseActivityValue_ = 1e+20D;
      bitField0_ = (bitField0_ & ~0x20000000);
      restartAlgorithms_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x40000000);
      defaultRestartAlgorithms_ = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART";
      bitField0_ = (bitField0_ & ~0x80000000);
      restartPeriod_ = 50;
      bitField1_ = (bitField1_ & ~0x00000001);
      restartRunningWindowSize_ = 50;
      bitField1_ = (bitField1_ & ~0x00000002);
      restartDlAverageRatio_ = 1D;
      bitField1_ = (bitField1_ & ~0x00000004);
      restartLbdAverageRatio_ = 1D;
      bitField1_ = (bitField1_ & ~0x00000008);
      useBlockingRestart_ = false;
      bitField1_ = (bitField1_ & ~0x00000010);
      blockingRestartWindowSize_ = 5000;
      bitField1_ = (bitField1_ & ~0x00000020);
      blockingRestartMultiplier_ = 1.4D;
      bitField1_ = (bitField1_ & ~0x00000040);
      numConflictsBeforeStrategyChanges_ = 0;
      bitField1_ = (bitField1_ & ~0x00000080);
      strategyChangeIncreaseRatio_ = 0D;
      bitField1_ = (bitField1_ & ~0x00000100);
      maxTimeInSeconds_ = Double.POSITIVE_INFINITY;
      bitField1_ = (bitField1_ & ~0x00000200);
      maxDeterministicTime_ = Double.POSITIVE_INFINITY;
      bitField1_ = (bitField1_ & ~0x00000400);
      maxNumberOfConflicts_ = 9223372036854775807L;
      bitField1_ = (bitField1_ & ~0x00000800);
      maxMemoryInMb_ = 10000L;
      bitField1_ = (bitField1_ & ~0x00001000);
      absoluteGapLimit_ = 0D;
      bitField1_ = (bitField1_ & ~0x00002000);
      relativeGapLimit_ = 0D;
      bitField1_ = (bitField1_ & ~0x00004000);
      treatBinaryClausesSeparately_ = true;
      bitField1_ = (bitField1_ & ~0x00008000);
      randomSeed_ = 1;
      bitField1_ = (bitField1_ & ~0x00010000);
      permuteVariableRandomly_ = false;
      bitField1_ = (bitField1_ & ~0x00020000);
      permutePresolveConstraintOrder_ = false;
      bitField1_ = (bitField1_ & ~0x00040000);
      useAbslRandom_ = false;
      bitField1_ = (bitField1_ & ~0x00080000);
      logSearchProgress_ = false;
      bitField1_ = (bitField1_ & ~0x00100000);
      logSubsolverStatistics_ = true;
      bitField1_ = (bitField1_ & ~0x00200000);
      logPrefix_ = "";
      bitField1_ = (bitField1_ & ~0x00400000);
      logToStdout_ = true;
      bitField1_ = (bitField1_ & ~0x00800000);
      logToResponse_ = false;
      bitField1_ = (bitField1_ & ~0x01000000);
      usePbResolution_ = false;
      bitField1_ = (bitField1_ & ~0x02000000);
      minimizeReductionDuringPbResolution_ = false;
      bitField1_ = (bitField1_ & ~0x04000000);
      countAssumptionLevelsInLbd_ = true;
      bitField1_ = (bitField1_ & ~0x08000000);
      presolveBveThreshold_ = 500;
      bitField1_ = (bitField1_ & ~0x10000000);
      presolveBveClauseWeight_ = 3;
      bitField1_ = (bitField1_ & ~0x20000000);
      presolveProbingDeterministicTimeLimit_ = 30D;
      bitField1_ = (bitField1_ & ~0x40000000);
      presolveBlockedClause_ = true;
      bitField1_ = (bitField1_ & ~0x80000000);
      presolveUseBva_ = true;
      bitField2_ = (bitField2_ & ~0x00000001);
      presolveBvaThreshold_ = 1;
      bitField2_ = (bitField2_ & ~0x00000002);
      maxPresolveIterations_ = 3;
      bitField2_ = (bitField2_ & ~0x00000004);
      cpModelPresolve_ = true;
      bitField2_ = (bitField2_ & ~0x00000008);
      cpModelPostsolveWithFullSolver_ = false;
      bitField2_ = (bitField2_ & ~0x00000010);
      cpModelMaxNumPresolveOperations_ = 0;
      bitField2_ = (bitField2_ & ~0x00000020);
      cpModelProbingLevel_ = 2;
      bitField2_ = (bitField2_ & ~0x00000040);
      cpModelUseSatPresolve_ = true;
      bitField2_ = (bitField2_ & ~0x00000080);
      useSatInprocessing_ = false;
      bitField2_ = (bitField2_ & ~0x00000100);
      expandElementConstraints_ = true;
      bitField2_ = (bitField2_ & ~0x00000200);
      expandAutomatonConstraints_ = true;
      bitField2_ = (bitField2_ & ~0x00000400);
      expandTableConstraints_ = true;
      bitField2_ = (bitField2_ & ~0x00000800);
      expandAlldiffConstraints_ = false;
      bitField2_ = (bitField2_ & ~0x00001000);
      expandReservoirConstraints_ = true;
      bitField2_ = (bitField2_ & ~0x00002000);
      disableConstraintExpansion_ = false;
      bitField2_ = (bitField2_ & ~0x00004000);
      mergeNoOverlapWorkLimit_ = 1000000000000D;
      bitField2_ = (bitField2_ & ~0x00008000);
      mergeAtMostOneWorkLimit_ = 100000000D;
      bitField2_ = (bitField2_ & ~0x00010000);
      presolveSubstitutionLevel_ = 1;
      bitField2_ = (bitField2_ & ~0x00020000);
      presolveExtractIntegerEnforcement_ = false;
      bitField2_ = (bitField2_ & ~0x00040000);
      useOptimizationHints_ = true;
      bitField2_ = (bitField2_ & ~0x00080000);
      minimizeCore_ = true;
      bitField2_ = (bitField2_ & ~0x00100000);
      findMultipleCores_ = true;
      bitField2_ = (bitField2_ & ~0x00200000);
      coverOptimization_ = true;
      bitField2_ = (bitField2_ & ~0x00400000);
      maxSatAssumptionOrder_ = 0;
      bitField2_ = (bitField2_ & ~0x00800000);
      maxSatReverseAssumptionOrder_ = false;
      bitField2_ = (bitField2_ & ~0x01000000);
      maxSatStratification_ = 1;
      bitField2_ = (bitField2_ & ~0x02000000);
      usePrecedencesInDisjunctiveConstraint_ = true;
      bitField2_ = (bitField2_ & ~0x04000000);
      useOverloadCheckerInCumulativeConstraint_ = false;
      bitField2_ = (bitField2_ & ~0x08000000);
      useTimetableEdgeFindingInCumulativeConstraint_ = false;
      bitField2_ = (bitField2_ & ~0x10000000);
      useDisjunctiveConstraintInCumulativeConstraint_ = true;
      bitField2_ = (bitField2_ & ~0x20000000);
      linearizationLevel_ = 1;
      bitField2_ = (bitField2_ & ~0x40000000);
      booleanEncodingLevel_ = 1;
      bitField2_ = (bitField2_ & ~0x80000000);
      maxDomainSizeWhenEncodingEqNeqConstraints_ = 16;
      bitField3_ = (bitField3_ & ~0x00000001);
      maxNumCuts_ = 10000;
      bitField3_ = (bitField3_ & ~0x00000002);
      onlyAddCutsAtLevelZero_ = false;
      bitField3_ = (bitField3_ & ~0x00000004);
      addKnapsackCuts_ = false;
      bitField3_ = (bitField3_ & ~0x00000008);
      addCgCuts_ = true;
      bitField3_ = (bitField3_ & ~0x00000010);
      addMirCuts_ = true;
      bitField3_ = (bitField3_ & ~0x00000020);
      addZeroHalfCuts_ = true;
      bitField3_ = (bitField3_ & ~0x00000040);
      addCliqueCuts_ = true;
      bitField3_ = (bitField3_ & ~0x00000080);
      maxAllDiffCutSize_ = 7;
      bitField3_ = (bitField3_ & ~0x00000100);
      addLinMaxCuts_ = true;
      bitField3_ = (bitField3_ & ~0x00000200);
      maxIntegerRoundingScaling_ = 600;
      bitField3_ = (bitField3_ & ~0x00000400);
      addLpConstraintsLazily_ = true;
      bitField3_ = (bitField3_ & ~0x00000800);
      minOrthogonalityForLpConstraints_ = 0.05D;
      bitField3_ = (bitField3_ & ~0x00001000);
      maxCutRoundsAtLevelZero_ = 1;
      bitField3_ = (bitField3_ & ~0x00002000);
      maxConsecutiveInactiveCount_ = 100;
      bitField3_ = (bitField3_ & ~0x00004000);
      cutMaxActiveCountValue_ = 10000000000D;
      bitField3_ = (bitField3_ & ~0x00008000);
      cutActiveCountDecay_ = 0.8D;
      bitField3_ = (bitField3_ & ~0x00010000);
      cutCleanupTarget_ = 1000;
      bitField3_ = (bitField3_ & ~0x00020000);
      newConstraintsBatchSize_ = 50;
      bitField3_ = (bitField3_ & ~0x00040000);
      searchBranching_ = 0;
      bitField3_ = (bitField3_ & ~0x00080000);
      hintConflictLimit_ = 10;
      bitField3_ = (bitField3_ & ~0x00100000);
      repairHint_ = false;
      bitField3_ = (bitField3_ & ~0x00200000);
      fixVariablesToTheirHintedValue_ = false;
      bitField3_ = (bitField3_ & ~0x00400000);
      exploitIntegerLpSolution_ = true;
      bitField3_ = (bitField3_ & ~0x00800000);
      exploitAllLpSolution_ = true;
      bitField3_ = (bitField3_ & ~0x01000000);
      exploitBestSolution_ = false;
      bitField3_ = (bitField3_ & ~0x02000000);
      exploitRelaxationSolution_ = false;
      bitField3_ = (bitField3_ & ~0x04000000);
      exploitObjective_ = true;
      bitField3_ = (bitField3_ & ~0x08000000);
      probingPeriodAtRoot_ = 0L;
      bitField3_ = (bitField3_ & ~0x10000000);
      useProbingSearch_ = false;
      bitField3_ = (bitField3_ & ~0x20000000);
      pseudoCostReliabilityThreshold_ = 100L;
      bitField3_ = (bitField3_ & ~0x40000000);
      optimizeWithCore_ = false;
      bitField3_ = (bitField3_ & ~0x80000000);
      optimizeWithLbTreeSearch_ = false;
      bitField4_ = (bitField4_ & ~0x00000001);
      binarySearchNumConflicts_ = -1;
      bitField4_ = (bitField4_ & ~0x00000002);
      optimizeWithMaxHs_ = false;
      bitField4_ = (bitField4_ & ~0x00000004);
      enumerateAllSolutions_ = false;
      bitField4_ = (bitField4_ & ~0x00000008);
      keepAllFeasibleSolutionsInPresolve_ = false;
      bitField4_ = (bitField4_ & ~0x00000010);
      fillTightenedDomainsInResponse_ = false;
      bitField4_ = (bitField4_ & ~0x00000020);
      instantiateAllVariables_ = true;
      bitField4_ = (bitField4_ & ~0x00000040);
      autoDetectGreaterThanAtLeastOneOf_ = true;
      bitField4_ = (bitField4_ & ~0x00000080);
      stopAfterFirstSolution_ = false;
      bitField4_ = (bitField4_ & ~0x00000100);
      stopAfterPresolve_ = false;
      bitField4_ = (bitField4_ & ~0x00000200);
      numSearchWorkers_ = 0;
      bitField4_ = (bitField4_ & ~0x00000400);
      interleaveSearch_ = false;
      bitField4_ = (bitField4_ & ~0x00000800);
      interleaveBatchSize_ = 1;
      bitField4_ = (bitField4_ & ~0x00001000);
      reduceMemoryUsageInInterleaveMode_ = false;
      bitField4_ = (bitField4_ & ~0x00002000);
      shareObjectiveBounds_ = true;
      bitField4_ = (bitField4_ & ~0x00004000);
      shareLevelZeroBounds_ = true;
      bitField4_ = (bitField4_ & ~0x00008000);
      useLnsOnly_ = false;
      bitField4_ = (bitField4_ & ~0x00010000);
      lnsFocusOnDecisionVariables_ = false;
      bitField4_ = (bitField4_ & ~0x00020000);
      lnsExpandIntervalsInConstraintGraph_ = true;
      bitField4_ = (bitField4_ & ~0x00040000);
      solutionPoolSize_ = 3;
      bitField4_ = (bitField4_ & ~0x00080000);
      useRinsLns_ = true;
      bitField4_ = (bitField4_ & ~0x00100000);
      useFeasibilityPump_ = true;
      bitField4_ = (bitField4_ & ~0x00200000);
      fpRounding_ = 2;
      bitField4_ = (bitField4_ & ~0x00400000);
      useRelaxationLns_ = false;
      bitField4_ = (bitField4_ & ~0x00800000);
      diversifyLnsParams_ = false;
      bitField4_ = (bitField4_ & ~0x01000000);
      randomizeSearch_ = false;
      bitField4_ = (bitField4_ & ~0x02000000);
      searchRandomizationTolerance_ = 0L;
      bitField4_ = (bitField4_ & ~0x04000000);
      useOptionalVariables_ = true;
      bitField4_ = (bitField4_ & ~0x08000000);
      useExactLpReason_ = true;
      bitField4_ = (bitField4_ & ~0x10000000);
      useBranchingInLp_ = false;
      bitField4_ = (bitField4_ & ~0x20000000);
      useCombinedNoOverlap_ = false;
      bitField4_ = (bitField4_ & ~0x40000000);
      catchSigintSignal_ = true;
      bitField4_ = (bitField4_ & ~0x80000000);
      useImpliedBounds_ = true;
      bitField5_ = (bitField5_ & ~0x00000001);
      polishLpSolution_ = false;
      bitField5_ = (bitField5_ & ~0x00000002);
      convertIntervals_ = true;
      bitField5_ = (bitField5_ & ~0x00000004);
      symmetryLevel_ = 2;
      bitField5_ = (bitField5_ & ~0x00000008);
      mipMaxBound_ = 10000000D;
      bitField5_ = (bitField5_ & ~0x00000010);
      mipVarScaling_ = 1D;
      bitField5_ = (bitField5_ & ~0x00000020);
      mipAutomaticallyScaleVariables_ = true;
      bitField5_ = (bitField5_ & ~0x00000040);
      mipWantedPrecision_ = 1e-06D;
      bitField5_ = (bitField5_ & ~0x00000080);
      mipMaxActivityExponent_ = 53;
      bitField5_ = (bitField5_ & ~0x00000100);
      mipCheckPrecision_ = 0.0001D;
      bitField5_ = (bitField5_ & ~0x00000200);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ortools.sat.SatParametersOuterClass.internal_static_operations_research_sat_SatParameters_descriptor;
    }

    @java.lang.Override
    public com.google.ortools.sat.SatParameters getDefaultInstanceForType() {
      return com.google.ortools.sat.SatParameters.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ortools.sat.SatParameters build() {
      com.google.ortools.sat.SatParameters result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ortools.sat.SatParameters buildPartial() {
      com.google.ortools.sat.SatParameters result = new com.google.ortools.sat.SatParameters(this);
      int from_bitField0_ = bitField0_;
      int from_bitField1_ = bitField1_;
      int from_bitField2_ = bitField2_;
      int from_bitField3_ = bitField3_;
      int from_bitField4_ = bitField4_;
      int from_bitField5_ = bitField5_;
      int to_bitField0_ = 0;
      int to_bitField1_ = 0;
      int to_bitField2_ = 0;
      int to_bitField3_ = 0;
      int to_bitField4_ = 0;
      int to_bitField5_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        to_bitField0_ |= 0x00000001;
      }
      result.name_ = name_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        to_bitField0_ |= 0x00000002;
      }
      result.preferredVariableOrder_ = preferredVariableOrder_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        to_bitField0_ |= 0x00000004;
      }
      result.initialPolarity_ = initialPolarity_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        to_bitField0_ |= 0x00000008;
      }
      result.usePhaseSaving_ = usePhaseSaving_;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        to_bitField0_ |= 0x00000010;
      }
      result.polarityRephaseIncrement_ = polarityRephaseIncrement_;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.randomPolarityRatio_ = randomPolarityRatio_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.randomBranchesRatio_ = randomBranchesRatio_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.useErwaHeuristic_ = useErwaHeuristic_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.initialVariablesActivity_ = initialVariablesActivity_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.alsoBumpVariablesInConflictReasons_ = alsoBumpVariablesInConflictReasons_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        to_bitField0_ |= 0x00000400;
      }
      result.minimizationAlgorithm_ = minimizationAlgorithm_;
      if (((from_bitField0_ & 0x00000800) != 0)) {
        to_bitField0_ |= 0x00000800;
      }
      result.binaryMinimizationAlgorithm_ = binaryMinimizationAlgorithm_;
      if (((from_bitField0_ & 0x00001000) != 0)) {
        to_bitField0_ |= 0x00001000;
      }
      result.subsumptionDuringConflictAnalysis_ = subsumptionDuringConflictAnalysis_;
      if (((from_bitField0_ & 0x00002000) != 0)) {
        to_bitField0_ |= 0x00002000;
      }
      result.clauseCleanupPeriod_ = clauseCleanupPeriod_;
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.clauseCleanupTarget_ = clauseCleanupTarget_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        to_bitField0_ |= 0x00008000;
      }
      result.clauseCleanupRatio_ = clauseCleanupRatio_;
      if (((from_bitField0_ & 0x00010000) != 0)) {
        to_bitField0_ |= 0x00010000;
      }
      result.clauseCleanupProtection_ = clauseCleanupProtection_;
      if (((from_bitField0_ & 0x00020000) != 0)) {
        to_bitField0_ |= 0x00020000;
      }
      result.clauseCleanupLbdBound_ = clauseCleanupLbdBound_;
      if (((from_bitField0_ & 0x00040000) != 0)) {
        to_bitField0_ |= 0x00040000;
      }
      result.clauseCleanupOrdering_ = clauseCleanupOrdering_;
      if (((from_bitField0_ & 0x00080000) != 0)) {
        to_bitField0_ |= 0x00080000;
      }
      result.pbCleanupIncrement_ = pbCleanupIncrement_;
      if (((from_bitField0_ & 0x00100000) != 0)) {
        to_bitField0_ |= 0x00100000;
      }
      result.pbCleanupRatio_ = pbCleanupRatio_;
      if (((from_bitField0_ & 0x00200000) != 0)) {
        to_bitField0_ |= 0x00200000;
      }
      result.minimizeWithPropagationRestartPeriod_ = minimizeWithPropagationRestartPeriod_;
      if (((from_bitField0_ & 0x00400000) != 0)) {
        to_bitField0_ |= 0x00400000;
      }
      result.minimizeWithPropagationNumDecisions_ = minimizeWithPropagationNumDecisions_;
      if (((from_bitField0_ & 0x00800000) != 0)) {
        to_bitField0_ |= 0x00800000;
      }
      result.variableActivityDecay_ = variableActivityDecay_;
      if (((from_bitField0_ & 0x01000000) != 0)) {
        to_bitField0_ |= 0x01000000;
      }
      result.maxVariableActivityValue_ = maxVariableActivityValue_;
      if (((from_bitField0_ & 0x02000000) != 0)) {
        to_bitField0_ |= 0x02000000;
      }
      result.glucoseMaxDecay_ = glucoseMaxDecay_;
      if (((from_bitField0_ & 0x04000000) != 0)) {
        to_bitField0_ |= 0x04000000;
      }
      result.glucoseDecayIncrement_ = glucoseDecayIncrement_;
      if (((from_bitField0_ & 0x08000000) != 0)) {
        to_bitField0_ |= 0x08000000;
      }
      result.glucoseDecayIncrementPeriod_ = glucoseDecayIncrementPeriod_;
      if (((from_bitField0_ & 0x10000000) != 0)) {
        to_bitField0_ |= 0x10000000;
      }
      result.clauseActivityDecay_ = clauseActivityDecay_;
      if (((from_bitField0_ & 0x20000000) != 0)) {
        to_bitField0_ |= 0x20000000;
      }
      result.maxClauseActivityValue_ = maxClauseActivityValue_;
      if (((bitField0_ & 0x40000000) != 0)) {
        restartAlgorithms_ = java.util.Collections.unmodifiableList(restartAlgorithms_);
        bitField0_ = (bitField0_ & ~0x40000000);
      }
      result.restartAlgorithms_ = restartAlgorithms_;
      if (((from_bitField0_ & 0x80000000) != 0)) {
        to_bitField0_ |= 0x40000000;
      }
      result.defaultRestartAlgorithms_ = defaultRestartAlgorithms_;
      if (((from_bitField1_ & 0x00000001) != 0)) {
        to_bitField0_ |= 0x80000000;
      }
      result.restartPeriod_ = restartPeriod_;
      if (((from_bitField1_ & 0x00000002) != 0)) {
        to_bitField1_ |= 0x00000001;
      }
      result.restartRunningWindowSize_ = restartRunningWindowSize_;
      if (((from_bitField1_ & 0x00000004) != 0)) {
        to_bitField1_ |= 0x00000002;
      }
      result.restartDlAverageRatio_ = restartDlAverageRatio_;
      if (((from_bitField1_ & 0x00000008) != 0)) {
        to_bitField1_ |= 0x00000004;
      }
      result.restartLbdAverageRatio_ = restartLbdAverageRatio_;
      if (((from_bitField1_ & 0x00000010) != 0)) {
        result.useBlockingRestart_ = useBlockingRestart_;
        to_bitField1_ |= 0x00000008;
      }
      if (((from_bitField1_ & 0x00000020) != 0)) {
        to_bitField1_ |= 0x00000010;
      }
      result.blockingRestartWindowSize_ = blockingRestartWindowSize_;
      if (((from_bitField1_ & 0x00000040) != 0)) {
        to_bitField1_ |= 0x00000020;
      }
      result.blockingRestartMultiplier_ = blockingRestartMultiplier_;
      if (((from_bitField1_ & 0x00000080) != 0)) {
        result.numConflictsBeforeStrategyChanges_ = numConflictsBeforeStrategyChanges_;
        to_bitField1_ |= 0x00000040;
      }
      if (((from_bitField1_ & 0x00000100) != 0)) {
        result.strategyChangeIncreaseRatio_ = strategyChangeIncreaseRatio_;
        to_bitField1_ |= 0x00000080;
      }
      if (((from_bitField1_ & 0x00000200) != 0)) {
        to_bitField1_ |= 0x00000100;
      }
      result.maxTimeInSeconds_ = maxTimeInSeconds_;
      if (((from_bitField1_ & 0x00000400) != 0)) {
        to_bitField1_ |= 0x00000200;
      }
      result.maxDeterministicTime_ = maxDeterministicTime_;
      if (((from_bitField1_ & 0x00000800) != 0)) {
        to_bitField1_ |= 0x00000400;
      }
      result.maxNumberOfConflicts_ = maxNumberOfConflicts_;
      if (((from_bitField1_ & 0x00001000) != 0)) {
        to_bitField1_ |= 0x00000800;
      }
      result.maxMemoryInMb_ = maxMemoryInMb_;
      if (((from_bitField1_ & 0x00002000) != 0)) {
        result.absoluteGapLimit_ = absoluteGapLimit_;
        to_bitField1_ |= 0x00001000;
      }
      if (((from_bitField1_ & 0x00004000) != 0)) {
        result.relativeGapLimit_ = relativeGapLimit_;
        to_bitField1_ |= 0x00002000;
      }
      if (((from_bitField1_ & 0x00008000) != 0)) {
        to_bitField1_ |= 0x00004000;
      }
      result.treatBinaryClausesSeparately_ = treatBinaryClausesSeparately_;
      if (((from_bitField1_ & 0x00010000) != 0)) {
        to_bitField1_ |= 0x00008000;
      }
      result.randomSeed_ = randomSeed_;
      if (((from_bitField1_ & 0x00020000) != 0)) {
        result.permuteVariableRandomly_ = permuteVariableRandomly_;
        to_bitField1_ |= 0x00010000;
      }
      if (((from_bitField1_ & 0x00040000) != 0)) {
        result.permutePresolveConstraintOrder_ = permutePresolveConstraintOrder_;
        to_bitField1_ |= 0x00020000;
      }
      if (((from_bitField1_ & 0x00080000) != 0)) {
        result.useAbslRandom_ = useAbslRandom_;
        to_bitField1_ |= 0x00040000;
      }
      if (((from_bitField1_ & 0x00100000) != 0)) {
        result.logSearchProgress_ = logSearchProgress_;
        to_bitField1_ |= 0x00080000;
      }
      if (((from_bitField1_ & 0x00200000) != 0)) {
        to_bitField1_ |= 0x00100000;
      }
      result.logSubsolverStatistics_ = logSubsolverStatistics_;
      if (((from_bitField1_ & 0x00400000) != 0)) {
        to_bitField1_ |= 0x00200000;
      }
      result.logPrefix_ = logPrefix_;
      if (((from_bitField1_ & 0x00800000) != 0)) {
        to_bitField1_ |= 0x00400000;
      }
      result.logToStdout_ = logToStdout_;
      if (((from_bitField1_ & 0x01000000) != 0)) {
        result.logToResponse_ = logToResponse_;
        to_bitField1_ |= 0x00800000;
      }
      if (((from_bitField1_ & 0x02000000) != 0)) {
        result.usePbResolution_ = usePbResolution_;
        to_bitField1_ |= 0x01000000;
      }
      if (((from_bitField1_ & 0x04000000) != 0)) {
        result.minimizeReductionDuringPbResolution_ = minimizeReductionDuringPbResolution_;
        to_bitField1_ |= 0x02000000;
      }
      if (((from_bitField1_ & 0x08000000) != 0)) {
        to_bitField1_ |= 0x04000000;
      }
      result.countAssumptionLevelsInLbd_ = countAssumptionLevelsInLbd_;
      if (((from_bitField1_ & 0x10000000) != 0)) {
        to_bitField1_ |= 0x08000000;
      }
      result.presolveBveThreshold_ = presolveBveThreshold_;
      if (((from_bitField1_ & 0x20000000) != 0)) {
        to_bitField1_ |= 0x10000000;
      }
      result.presolveBveClauseWeight_ = presolveBveClauseWeight_;
      if (((from_bitField1_ & 0x40000000) != 0)) {
        to_bitField1_ |= 0x20000000;
      }
      result.presolveProbingDeterministicTimeLimit_ = presolveProbingDeterministicTimeLimit_;
      if (((from_bitField1_ & 0x80000000) != 0)) {
        to_bitField1_ |= 0x40000000;
      }
      result.presolveBlockedClause_ = presolveBlockedClause_;
      if (((from_bitField2_ & 0x00000001) != 0)) {
        to_bitField1_ |= 0x80000000;
      }
      result.presolveUseBva_ = presolveUseBva_;
      if (((from_bitField2_ & 0x00000002) != 0)) {
        to_bitField2_ |= 0x00000001;
      }
      result.presolveBvaThreshold_ = presolveBvaThreshold_;
      if (((from_bitField2_ & 0x00000004) != 0)) {
        to_bitField2_ |= 0x00000002;
      }
      result.maxPresolveIterations_ = maxPresolveIterations_;
      if (((from_bitField2_ & 0x00000008) != 0)) {
        to_bitField2_ |= 0x00000004;
      }
      result.cpModelPresolve_ = cpModelPresolve_;
      if (((from_bitField2_ & 0x00000010) != 0)) {
        result.cpModelPostsolveWithFullSolver_ = cpModelPostsolveWithFullSolver_;
        to_bitField2_ |= 0x00000008;
      }
      if (((from_bitField2_ & 0x00000020) != 0)) {
        result.cpModelMaxNumPresolveOperations_ = cpModelMaxNumPresolveOperations_;
        to_bitField2_ |= 0x00000010;
      }
      if (((from_bitField2_ & 0x00000040) != 0)) {
        to_bitField2_ |= 0x00000020;
      }
      result.cpModelProbingLevel_ = cpModelProbingLevel_;
      if (((from_bitField2_ & 0x00000080) != 0)) {
        to_bitField2_ |= 0x00000040;
      }
      result.cpModelUseSatPresolve_ = cpModelUseSatPresolve_;
      if (((from_bitField2_ & 0x00000100) != 0)) {
        result.useSatInprocessing_ = useSatInprocessing_;
        to_bitField2_ |= 0x00000080;
      }
      if (((from_bitField2_ & 0x00000200) != 0)) {
        to_bitField2_ |= 0x00000100;
      }
      result.expandElementConstraints_ = expandElementConstraints_;
      if (((from_bitField2_ & 0x00000400) != 0)) {
        to_bitField2_ |= 0x00000200;
      }
      result.expandAutomatonConstraints_ = expandAutomatonConstraints_;
      if (((from_bitField2_ & 0x00000800) != 0)) {
        to_bitField2_ |= 0x00000400;
      }
      result.expandTableConstraints_ = expandTableConstraints_;
      if (((from_bitField2_ & 0x00001000) != 0)) {
        result.expandAlldiffConstraints_ = expandAlldiffConstraints_;
        to_bitField2_ |= 0x00000800;
      }
      if (((from_bitField2_ & 0x00002000) != 0)) {
        to_bitField2_ |= 0x00001000;
      }
      result.expandReservoirConstraints_ = expandReservoirConstraints_;
      if (((from_bitField2_ & 0x00004000) != 0)) {
        result.disableConstraintExpansion_ = disableConstraintExpansion_;
        to_bitField2_ |= 0x00002000;
      }
      if (((from_bitField2_ & 0x00008000) != 0)) {
        to_bitField2_ |= 0x00004000;
      }
      result.mergeNoOverlapWorkLimit_ = mergeNoOverlapWorkLimit_;
      if (((from_bitField2_ & 0x00010000) != 0)) {
        to_bitField2_ |= 0x00008000;
      }
      result.mergeAtMostOneWorkLimit_ = mergeAtMostOneWorkLimit_;
      if (((from_bitField2_ & 0x00020000) != 0)) {
        to_bitField2_ |= 0x00010000;
      }
      result.presolveSubstitutionLevel_ = presolveSubstitutionLevel_;
      if (((from_bitField2_ & 0x00040000) != 0)) {
        result.presolveExtractIntegerEnforcement_ = presolveExtractIntegerEnforcement_;
        to_bitField2_ |= 0x00020000;
      }
      if (((from_bitField2_ & 0x00080000) != 0)) {
        to_bitField2_ |= 0x00040000;
      }
      result.useOptimizationHints_ = useOptimizationHints_;
      if (((from_bitField2_ & 0x00100000) != 0)) {
        to_bitField2_ |= 0x00080000;
      }
      result.minimizeCore_ = minimizeCore_;
      if (((from_bitField2_ & 0x00200000) != 0)) {
        to_bitField2_ |= 0x00100000;
      }
      result.findMultipleCores_ = findMultipleCores_;
      if (((from_bitField2_ & 0x00400000) != 0)) {
        to_bitField2_ |= 0x00200000;
      }
      result.coverOptimization_ = coverOptimization_;
      if (((from_bitField2_ & 0x00800000) != 0)) {
        to_bitField2_ |= 0x00400000;
      }
      result.maxSatAssumptionOrder_ = maxSatAssumptionOrder_;
      if (((from_bitField2_ & 0x01000000) != 0)) {
        result.maxSatReverseAssumptionOrder_ = maxSatReverseAssumptionOrder_;
        to_bitField2_ |= 0x00800000;
      }
      if (((from_bitField2_ & 0x02000000) != 0)) {
        to_bitField2_ |= 0x01000000;
      }
      result.maxSatStratification_ = maxSatStratification_;
      if (((from_bitField2_ & 0x04000000) != 0)) {
        to_bitField2_ |= 0x02000000;
      }
      result.usePrecedencesInDisjunctiveConstraint_ = usePrecedencesInDisjunctiveConstraint_;
      if (((from_bitField2_ & 0x08000000) != 0)) {
        result.useOverloadCheckerInCumulativeConstraint_ = useOverloadCheckerInCumulativeConstraint_;
        to_bitField2_ |= 0x04000000;
      }
      if (((from_bitField2_ & 0x10000000) != 0)) {
        result.useTimetableEdgeFindingInCumulativeConstraint_ = useTimetableEdgeFindingInCumulativeConstraint_;
        to_bitField2_ |= 0x08000000;
      }
      if (((from_bitField2_ & 0x20000000) != 0)) {
        to_bitField2_ |= 0x10000000;
      }
      result.useDisjunctiveConstraintInCumulativeConstraint_ = useDisjunctiveConstraintInCumulativeConstraint_;
      if (((from_bitField2_ & 0x40000000) != 0)) {
        to_bitField2_ |= 0x20000000;
      }
      result.linearizationLevel_ = linearizationLevel_;
      if (((from_bitField2_ & 0x80000000) != 0)) {
        to_bitField2_ |= 0x40000000;
      }
      result.booleanEncodingLevel_ = booleanEncodingLevel_;
      if (((from_bitField3_ & 0x00000001) != 0)) {
        to_bitField2_ |= 0x80000000;
      }
      result.maxDomainSizeWhenEncodingEqNeqConstraints_ = maxDomainSizeWhenEncodingEqNeqConstraints_;
      if (((from_bitField3_ & 0x00000002) != 0)) {
        to_bitField3_ |= 0x00000001;
      }
      result.maxNumCuts_ = maxNumCuts_;
      if (((from_bitField3_ & 0x00000004) != 0)) {
        result.onlyAddCutsAtLevelZero_ = onlyAddCutsAtLevelZero_;
        to_bitField3_ |= 0x00000002;
      }
      if (((from_bitField3_ & 0x00000008) != 0)) {
        result.addKnapsackCuts_ = addKnapsackCuts_;
        to_bitField3_ |= 0x00000004;
      }
      if (((from_bitField3_ & 0x00000010) != 0)) {
        to_bitField3_ |= 0x00000008;
      }
      result.addCgCuts_ = addCgCuts_;
      if (((from_bitField3_ & 0x00000020) != 0)) {
        to_bitField3_ |= 0x00000010;
      }
      result.addMirCuts_ = addMirCuts_;
      if (((from_bitField3_ & 0x00000040) != 0)) {
        to_bitField3_ |= 0x00000020;
      }
      result.addZeroHalfCuts_ = addZeroHalfCuts_;
      if (((from_bitField3_ & 0x00000080) != 0)) {
        to_bitField3_ |= 0x00000040;
      }
      result.addCliqueCuts_ = addCliqueCuts_;
      if (((from_bitField3_ & 0x00000100) != 0)) {
        to_bitField3_ |= 0x00000080;
      }
      result.maxAllDiffCutSize_ = maxAllDiffCutSize_;
      if (((from_bitField3_ & 0x00000200) != 0)) {
        to_bitField3_ |= 0x00000100;
      }
      result.addLinMaxCuts_ = addLinMaxCuts_;
      if (((from_bitField3_ & 0x00000400) != 0)) {
        to_bitField3_ |= 0x00000200;
      }
      result.maxIntegerRoundingScaling_ = maxIntegerRoundingScaling_;
      if (((from_bitField3_ & 0x00000800) != 0)) {
        to_bitField3_ |= 0x00000400;
      }
      result.addLpConstraintsLazily_ = addLpConstraintsLazily_;
      if (((from_bitField3_ & 0x00001000) != 0)) {
        to_bitField3_ |= 0x00000800;
      }
      result.minOrthogonalityForLpConstraints_ = minOrthogonalityForLpConstraints_;
      if (((from_bitField3_ & 0x00002000) != 0)) {
        to_bitField3_ |= 0x00001000;
      }
      result.maxCutRoundsAtLevelZero_ = maxCutRoundsAtLevelZero_;
      if (((from_bitField3_ & 0x00004000) != 0)) {
        to_bitField3_ |= 0x00002000;
      }
      result.maxConsecutiveInactiveCount_ = maxConsecutiveInactiveCount_;
      if (((from_bitField3_ & 0x00008000) != 0)) {
        to_bitField3_ |= 0x00004000;
      }
      result.cutMaxActiveCountValue_ = cutMaxActiveCountValue_;
      if (((from_bitField3_ & 0x00010000) != 0)) {
        to_bitField3_ |= 0x00008000;
      }
      result.cutActiveCountDecay_ = cutActiveCountDecay_;
      if (((from_bitField3_ & 0x00020000) != 0)) {
        to_bitField3_ |= 0x00010000;
      }
      result.cutCleanupTarget_ = cutCleanupTarget_;
      if (((from_bitField3_ & 0x00040000) != 0)) {
        to_bitField3_ |= 0x00020000;
      }
      result.newConstraintsBatchSize_ = newConstraintsBatchSize_;
      if (((from_bitField3_ & 0x00080000) != 0)) {
        to_bitField3_ |= 0x00040000;
      }
      result.searchBranching_ = searchBranching_;
      if (((from_bitField3_ & 0x00100000) != 0)) {
        to_bitField3_ |= 0x00080000;
      }
      result.hintConflictLimit_ = hintConflictLimit_;
      if (((from_bitField3_ & 0x00200000) != 0)) {
        result.repairHint_ = repairHint_;
        to_bitField3_ |= 0x00100000;
      }
      if (((from_bitField3_ & 0x00400000) != 0)) {
        result.fixVariablesToTheirHintedValue_ = fixVariablesToTheirHintedValue_;
        to_bitField3_ |= 0x00200000;
      }
      if (((from_bitField3_ & 0x00800000) != 0)) {
        to_bitField3_ |= 0x00400000;
      }
      result.exploitIntegerLpSolution_ = exploitIntegerLpSolution_;
      if (((from_bitField3_ & 0x01000000) != 0)) {
        to_bitField3_ |= 0x00800000;
      }
      result.exploitAllLpSolution_ = exploitAllLpSolution_;
      if (((from_bitField3_ & 0x02000000) != 0)) {
        result.exploitBestSolution_ = exploitBestSolution_;
        to_bitField3_ |= 0x01000000;
      }
      if (((from_bitField3_ & 0x04000000) != 0)) {
        result.exploitRelaxationSolution_ = exploitRelaxationSolution_;
        to_bitField3_ |= 0x02000000;
      }
      if (((from_bitField3_ & 0x08000000) != 0)) {
        to_bitField3_ |= 0x04000000;
      }
      result.exploitObjective_ = exploitObjective_;
      if (((from_bitField3_ & 0x10000000) != 0)) {
        result.probingPeriodAtRoot_ = probingPeriodAtRoot_;
        to_bitField3_ |= 0x08000000;
      }
      if (((from_bitField3_ & 0x20000000) != 0)) {
        result.useProbingSearch_ = useProbingSearch_;
        to_bitField3_ |= 0x10000000;
      }
      if (((from_bitField3_ & 0x40000000) != 0)) {
        to_bitField3_ |= 0x20000000;
      }
      result.pseudoCostReliabilityThreshold_ = pseudoCostReliabilityThreshold_;
      if (((from_bitField3_ & 0x80000000) != 0)) {
        result.optimizeWithCore_ = optimizeWithCore_;
        to_bitField3_ |= 0x40000000;
      }
      if (((from_bitField4_ & 0x00000001) != 0)) {
        result.optimizeWithLbTreeSearch_ = optimizeWithLbTreeSearch_;
        to_bitField3_ |= 0x80000000;
      }
      if (((from_bitField4_ & 0x00000002) != 0)) {
        to_bitField4_ |= 0x00000001;
      }
      result.binarySearchNumConflicts_ = binarySearchNumConflicts_;
      if (((from_bitField4_ & 0x00000004) != 0)) {
        result.optimizeWithMaxHs_ = optimizeWithMaxHs_;
        to_bitField4_ |= 0x00000002;
      }
      if (((from_bitField4_ & 0x00000008) != 0)) {
        result.enumerateAllSolutions_ = enumerateAllSolutions_;
        to_bitField4_ |= 0x00000004;
      }
      if (((from_bitField4_ & 0x00000010) != 0)) {
        result.keepAllFeasibleSolutionsInPresolve_ = keepAllFeasibleSolutionsInPresolve_;
        to_bitField4_ |= 0x00000008;
      }
      if (((from_bitField4_ & 0x00000020) != 0)) {
        result.fillTightenedDomainsInResponse_ = fillTightenedDomainsInResponse_;
        to_bitField4_ |= 0x00000010;
      }
      if (((from_bitField4_ & 0x00000040) != 0)) {
        to_bitField4_ |= 0x00000020;
      }
      result.instantiateAllVariables_ = instantiateAllVariables_;
      if (((from_bitField4_ & 0x00000080) != 0)) {
        to_bitField4_ |= 0x00000040;
      }
      result.autoDetectGreaterThanAtLeastOneOf_ = autoDetectGreaterThanAtLeastOneOf_;
      if (((from_bitField4_ & 0x00000100) != 0)) {
        result.stopAfterFirstSolution_ = stopAfterFirstSolution_;
        to_bitField4_ |= 0x00000080;
      }
      if (((from_bitField4_ & 0x00000200) != 0)) {
        result.stopAfterPresolve_ = stopAfterPresolve_;
        to_bitField4_ |= 0x00000100;
      }
      if (((from_bitField4_ & 0x00000400) != 0)) {
        result.numSearchWorkers_ = numSearchWorkers_;
        to_bitField4_ |= 0x00000200;
      }
      if (((from_bitField4_ & 0x00000800) != 0)) {
        result.interleaveSearch_ = interleaveSearch_;
        to_bitField4_ |= 0x00000400;
      }
      if (((from_bitField4_ & 0x00001000) != 0)) {
        to_bitField4_ |= 0x00000800;
      }
      result.interleaveBatchSize_ = interleaveBatchSize_;
      if (((from_bitField4_ & 0x00002000) != 0)) {
        result.reduceMemoryUsageInInterleaveMode_ = reduceMemoryUsageInInterleaveMode_;
        to_bitField4_ |= 0x00001000;
      }
      if (((from_bitField4_ & 0x00004000) != 0)) {
        to_bitField4_ |= 0x00002000;
      }
      result.shareObjectiveBounds_ = shareObjectiveBounds_;
      if (((from_bitField4_ & 0x00008000) != 0)) {
        to_bitField4_ |= 0x00004000;
      }
      result.shareLevelZeroBounds_ = shareLevelZeroBounds_;
      if (((from_bitField4_ & 0x00010000) != 0)) {
        result.useLnsOnly_ = useLnsOnly_;
        to_bitField4_ |= 0x00008000;
      }
      if (((from_bitField4_ & 0x00020000) != 0)) {
        result.lnsFocusOnDecisionVariables_ = lnsFocusOnDecisionVariables_;
        to_bitField4_ |= 0x00010000;
      }
      if (((from_bitField4_ & 0x00040000) != 0)) {
        to_bitField4_ |= 0x00020000;
      }
      result.lnsExpandIntervalsInConstraintGraph_ = lnsExpandIntervalsInConstraintGraph_;
      if (((from_bitField4_ & 0x00080000) != 0)) {
        to_bitField4_ |= 0x00040000;
      }
      result.solutionPoolSize_ = solutionPoolSize_;
      if (((from_bitField4_ & 0x00100000) != 0)) {
        to_bitField4_ |= 0x00080000;
      }
      result.useRinsLns_ = useRinsLns_;
      if (((from_bitField4_ & 0x00200000) != 0)) {
        to_bitField4_ |= 0x00100000;
      }
      result.useFeasibilityPump_ = useFeasibilityPump_;
      if (((from_bitField4_ & 0x00400000) != 0)) {
        to_bitField4_ |= 0x00200000;
      }
      result.fpRounding_ = fpRounding_;
      if (((from_bitField4_ & 0x00800000) != 0)) {
        result.useRelaxationLns_ = useRelaxationLns_;
        to_bitField4_ |= 0x00400000;
      }
      if (((from_bitField4_ & 0x01000000) != 0)) {
        result.diversifyLnsParams_ = diversifyLnsParams_;
        to_bitField4_ |= 0x00800000;
      }
      if (((from_bitField4_ & 0x02000000) != 0)) {
        result.randomizeSearch_ = randomizeSearch_;
        to_bitField4_ |= 0x01000000;
      }
      if (((from_bitField4_ & 0x04000000) != 0)) {
        result.searchRandomizationTolerance_ = searchRandomizationTolerance_;
        to_bitField4_ |= 0x02000000;
      }
      if (((from_bitField4_ & 0x08000000) != 0)) {
        to_bitField4_ |= 0x04000000;
      }
      result.useOptionalVariables_ = useOptionalVariables_;
      if (((from_bitField4_ & 0x10000000) != 0)) {
        to_bitField4_ |= 0x08000000;
      }
      result.useExactLpReason_ = useExactLpReason_;
      if (((from_bitField4_ & 0x20000000) != 0)) {
        result.useBranchingInLp_ = useBranchingInLp_;
        to_bitField4_ |= 0x10000000;
      }
      if (((from_bitField4_ & 0x40000000) != 0)) {
        result.useCombinedNoOverlap_ = useCombinedNoOverlap_;
        to_bitField4_ |= 0x20000000;
      }
      if (((from_bitField4_ & 0x80000000) != 0)) {
        to_bitField4_ |= 0x40000000;
      }
      result.catchSigintSignal_ = catchSigintSignal_;
      if (((from_bitField5_ & 0x00000001) != 0)) {
        to_bitField4_ |= 0x80000000;
      }
      result.useImpliedBounds_ = useImpliedBounds_;
      if (((from_bitField5_ & 0x00000002) != 0)) {
        result.polishLpSolution_ = polishLpSolution_;
        to_bitField5_ |= 0x00000001;
      }
      if (((from_bitField5_ & 0x00000004) != 0)) {
        to_bitField5_ |= 0x00000002;
      }
      result.convertIntervals_ = convertIntervals_;
      if (((from_bitField5_ & 0x00000008) != 0)) {
        to_bitField5_ |= 0x00000004;
      }
      result.symmetryLevel_ = symmetryLevel_;
      if (((from_bitField5_ & 0x00000010) != 0)) {
        to_bitField5_ |= 0x00000008;
      }
      result.mipMaxBound_ = mipMaxBound_;
      if (((from_bitField5_ & 0x00000020) != 0)) {
        to_bitField5_ |= 0x00000010;
      }
      result.mipVarScaling_ = mipVarScaling_;
      if (((from_bitField5_ & 0x00000040) != 0)) {
        to_bitField5_ |= 0x00000020;
      }
      result.mipAutomaticallyScaleVariables_ = mipAutomaticallyScaleVariables_;
      if (((from_bitField5_ & 0x00000080) != 0)) {
        to_bitField5_ |= 0x00000040;
      }
      result.mipWantedPrecision_ = mipWantedPrecision_;
      if (((from_bitField5_ & 0x00000100) != 0)) {
        to_bitField5_ |= 0x00000080;
      }
      result.mipMaxActivityExponent_ = mipMaxActivityExponent_;
      if (((from_bitField5_ & 0x00000200) != 0)) {
        to_bitField5_ |= 0x00000100;
      }
      result.mipCheckPrecision_ = mipCheckPrecision_;
      result.bitField0_ = to_bitField0_;
      result.bitField1_ = to_bitField1_;
      result.bitField2_ = to_bitField2_;
      result.bitField3_ = to_bitField3_;
      result.bitField4_ = to_bitField4_;
      result.bitField5_ = to_bitField5_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ortools.sat.SatParameters) {
        return mergeFrom((com.google.ortools.sat.SatParameters)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ortools.sat.SatParameters other) {
      if (other == com.google.ortools.sat.SatParameters.getDefaultInstance()) return this;
      if (other.hasName()) {
        bitField0_ |= 0x00000001;
        name_ = other.name_;
        onChanged();
      }
      if (other.hasPreferredVariableOrder()) {
        setPreferredVariableOrder(other.getPreferredVariableOrder());
      }
      if (other.hasInitialPolarity()) {
        setInitialPolarity(other.getInitialPolarity());
      }
      if (other.hasUsePhaseSaving()) {
        setUsePhaseSaving(other.getUsePhaseSaving());
      }
      if (other.hasPolarityRephaseIncrement()) {
        setPolarityRephaseIncrement(other.getPolarityRephaseIncrement());
      }
      if (other.hasRandomPolarityRatio()) {
        setRandomPolarityRatio(other.getRandomPolarityRatio());
      }
      if (other.hasRandomBranchesRatio()) {
        setRandomBranchesRatio(other.getRandomBranchesRatio());
      }
      if (other.hasUseErwaHeuristic()) {
        setUseErwaHeuristic(other.getUseErwaHeuristic());
      }
      if (other.hasInitialVariablesActivity()) {
        setInitialVariablesActivity(other.getInitialVariablesActivity());
      }
      if (other.hasAlsoBumpVariablesInConflictReasons()) {
        setAlsoBumpVariablesInConflictReasons(other.getAlsoBumpVariablesInConflictReasons());
      }
      if (other.hasMinimizationAlgorithm()) {
        setMinimizationAlgorithm(other.getMinimizationAlgorithm());
      }
      if (other.hasBinaryMinimizationAlgorithm()) {
        setBinaryMinimizationAlgorithm(other.getBinaryMinimizationAlgorithm());
      }
      if (other.hasSubsumptionDuringConflictAnalysis()) {
        setSubsumptionDuringConflictAnalysis(other.getSubsumptionDuringConflictAnalysis());
      }
      if (other.hasClauseCleanupPeriod()) {
        setClauseCleanupPeriod(other.getClauseCleanupPeriod());
      }
      if (other.hasClauseCleanupTarget()) {
        setClauseCleanupTarget(other.getClauseCleanupTarget());
      }
      if (other.hasClauseCleanupRatio()) {
        setClauseCleanupRatio(other.getClauseCleanupRatio());
      }
      if (other.hasClauseCleanupProtection()) {
        setClauseCleanupProtection(other.getClauseCleanupProtection());
      }
      if (other.hasClauseCleanupLbdBound()) {
        setClauseCleanupLbdBound(other.getClauseCleanupLbdBound());
      }
      if (other.hasClauseCleanupOrdering()) {
        setClauseCleanupOrdering(other.getClauseCleanupOrdering());
      }
      if (other.hasPbCleanupIncrement()) {
        setPbCleanupIncrement(other.getPbCleanupIncrement());
      }
      if (other.hasPbCleanupRatio()) {
        setPbCleanupRatio(other.getPbCleanupRatio());
      }
      if (other.hasMinimizeWithPropagationRestartPeriod()) {
        setMinimizeWithPropagationRestartPeriod(other.getMinimizeWithPropagationRestartPeriod());
      }
      if (other.hasMinimizeWithPropagationNumDecisions()) {
        setMinimizeWithPropagationNumDecisions(other.getMinimizeWithPropagationNumDecisions());
      }
      if (other.hasVariableActivityDecay()) {
        setVariableActivityDecay(other.getVariableActivityDecay());
      }
      if (other.hasMaxVariableActivityValue()) {
        setMaxVariableActivityValue(other.getMaxVariableActivityValue());
      }
      if (other.hasGlucoseMaxDecay()) {
        setGlucoseMaxDecay(other.getGlucoseMaxDecay());
      }
      if (other.hasGlucoseDecayIncrement()) {
        setGlucoseDecayIncrement(other.getGlucoseDecayIncrement());
      }
      if (other.hasGlucoseDecayIncrementPeriod()) {
        setGlucoseDecayIncrementPeriod(other.getGlucoseDecayIncrementPeriod());
      }
      if (other.hasClauseActivityDecay()) {
        setClauseActivityDecay(other.getClauseActivityDecay());
      }
      if (other.hasMaxClauseActivityValue()) {
        setMaxClauseActivityValue(other.getMaxClauseActivityValue());
      }
      if (!other.restartAlgorithms_.isEmpty()) {
        if (restartAlgorithms_.isEmpty()) {
          restartAlgorithms_ = other.restartAlgorithms_;
          bitField0_ = (bitField0_ & ~0x40000000);
        } else {
          ensureRestartAlgorithmsIsMutable();
          restartAlgorithms_.addAll(other.restartAlgorithms_);
        }
        onChanged();
      }
      if (other.hasDefaultRestartAlgorithms()) {
        bitField0_ |= 0x80000000;
        defaultRestartAlgorithms_ = other.defaultRestartAlgorithms_;
        onChanged();
      }
      if (other.hasRestartPeriod()) {
        setRestartPeriod(other.getRestartPeriod());
      }
      if (other.hasRestartRunningWindowSize()) {
        setRestartRunningWindowSize(other.getRestartRunningWindowSize());
      }
      if (other.hasRestartDlAverageRatio()) {
        setRestartDlAverageRatio(other.getRestartDlAverageRatio());
      }
      if (other.hasRestartLbdAverageRatio()) {
        setRestartLbdAverageRatio(other.getRestartLbdAverageRatio());
      }
      if (other.hasUseBlockingRestart()) {
        setUseBlockingRestart(other.getUseBlockingRestart());
      }
      if (other.hasBlockingRestartWindowSize()) {
        setBlockingRestartWindowSize(other.getBlockingRestartWindowSize());
      }
      if (other.hasBlockingRestartMultiplier()) {
        setBlockingRestartMultiplier(other.getBlockingRestartMultiplier());
      }
      if (other.hasNumConflictsBeforeStrategyChanges()) {
        setNumConflictsBeforeStrategyChanges(other.getNumConflictsBeforeStrategyChanges());
      }
      if (other.hasStrategyChangeIncreaseRatio()) {
        setStrategyChangeIncreaseRatio(other.getStrategyChangeIncreaseRatio());
      }
      if (other.hasMaxTimeInSeconds()) {
        setMaxTimeInSeconds(other.getMaxTimeInSeconds());
      }
      if (other.hasMaxDeterministicTime()) {
        setMaxDeterministicTime(other.getMaxDeterministicTime());
      }
      if (other.hasMaxNumberOfConflicts()) {
        setMaxNumberOfConflicts(other.getMaxNumberOfConflicts());
      }
      if (other.hasMaxMemoryInMb()) {
        setMaxMemoryInMb(other.getMaxMemoryInMb());
      }
      if (other.hasAbsoluteGapLimit()) {
        setAbsoluteGapLimit(other.getAbsoluteGapLimit());
      }
      if (other.hasRelativeGapLimit()) {
        setRelativeGapLimit(other.getRelativeGapLimit());
      }
      if (other.hasTreatBinaryClausesSeparately()) {
        setTreatBinaryClausesSeparately(other.getTreatBinaryClausesSeparately());
      }
      if (other.hasRandomSeed()) {
        setRandomSeed(other.getRandomSeed());
      }
      if (other.hasPermuteVariableRandomly()) {
        setPermuteVariableRandomly(other.getPermuteVariableRandomly());
      }
      if (other.hasPermutePresolveConstraintOrder()) {
        setPermutePresolveConstraintOrder(other.getPermutePresolveConstraintOrder());
      }
      if (other.hasUseAbslRandom()) {
        setUseAbslRandom(other.getUseAbslRandom());
      }
      if (other.hasLogSearchProgress()) {
        setLogSearchProgress(other.getLogSearchProgress());
      }
      if (other.hasLogSubsolverStatistics()) {
        setLogSubsolverStatistics(other.getLogSubsolverStatistics());
      }
      if (other.hasLogPrefix()) {
        bitField1_ |= 0x00400000;
        logPrefix_ = other.logPrefix_;
        onChanged();
      }
      if (other.hasLogToStdout()) {
        setLogToStdout(other.getLogToStdout());
      }
      if (other.hasLogToResponse()) {
        setLogToResponse(other.getLogToResponse());
      }
      if (other.hasUsePbResolution()) {
        setUsePbResolution(other.getUsePbResolution());
      }
      if (other.hasMinimizeReductionDuringPbResolution()) {
        setMinimizeReductionDuringPbResolution(other.getMinimizeReductionDuringPbResolution());
      }
      if (other.hasCountAssumptionLevelsInLbd()) {
        setCountAssumptionLevelsInLbd(other.getCountAssumptionLevelsInLbd());
      }
      if (other.hasPresolveBveThreshold()) {
        setPresolveBveThreshold(other.getPresolveBveThreshold());
      }
      if (other.hasPresolveBveClauseWeight()) {
        setPresolveBveClauseWeight(other.getPresolveBveClauseWeight());
      }
      if (other.hasPresolveProbingDeterministicTimeLimit()) {
        setPresolveProbingDeterministicTimeLimit(other.getPresolveProbingDeterministicTimeLimit());
      }
      if (other.hasPresolveBlockedClause()) {
        setPresolveBlockedClause(other.getPresolveBlockedClause());
      }
      if (other.hasPresolveUseBva()) {
        setPresolveUseBva(other.getPresolveUseBva());
      }
      if (other.hasPresolveBvaThreshold()) {
        setPresolveBvaThreshold(other.getPresolveBvaThreshold());
      }
      if (other.hasMaxPresolveIterations()) {
        setMaxPresolveIterations(other.getMaxPresolveIterations());
      }
      if (other.hasCpModelPresolve()) {
        setCpModelPresolve(other.getCpModelPresolve());
      }
      if (other.hasCpModelPostsolveWithFullSolver()) {
        setCpModelPostsolveWithFullSolver(other.getCpModelPostsolveWithFullSolver());
      }
      if (other.hasCpModelMaxNumPresolveOperations()) {
        setCpModelMaxNumPresolveOperations(other.getCpModelMaxNumPresolveOperations());
      }
      if (other.hasCpModelProbingLevel()) {
        setCpModelProbingLevel(other.getCpModelProbingLevel());
      }
      if (other.hasCpModelUseSatPresolve()) {
        setCpModelUseSatPresolve(other.getCpModelUseSatPresolve());
      }
      if (other.hasUseSatInprocessing()) {
        setUseSatInprocessing(other.getUseSatInprocessing());
      }
      if (other.hasExpandElementConstraints()) {
        setExpandElementConstraints(other.getExpandElementConstraints());
      }
      if (other.hasExpandAutomatonConstraints()) {
        setExpandAutomatonConstraints(other.getExpandAutomatonConstraints());
      }
      if (other.hasExpandTableConstraints()) {
        setExpandTableConstraints(other.getExpandTableConstraints());
      }
      if (other.hasExpandAlldiffConstraints()) {
        setExpandAlldiffConstraints(other.getExpandAlldiffConstraints());
      }
      if (other.hasExpandReservoirConstraints()) {
        setExpandReservoirConstraints(other.getExpandReservoirConstraints());
      }
      if (other.hasDisableConstraintExpansion()) {
        setDisableConstraintExpansion(other.getDisableConstraintExpansion());
      }
      if (other.hasMergeNoOverlapWorkLimit()) {
        setMergeNoOverlapWorkLimit(other.getMergeNoOverlapWorkLimit());
      }
      if (other.hasMergeAtMostOneWorkLimit()) {
        setMergeAtMostOneWorkLimit(other.getMergeAtMostOneWorkLimit());
      }
      if (other.hasPresolveSubstitutionLevel()) {
        setPresolveSubstitutionLevel(other.getPresolveSubstitutionLevel());
      }
      if (other.hasPresolveExtractIntegerEnforcement()) {
        setPresolveExtractIntegerEnforcement(other.getPresolveExtractIntegerEnforcement());
      }
      if (other.hasUseOptimizationHints()) {
        setUseOptimizationHints(other.getUseOptimizationHints());
      }
      if (other.hasMinimizeCore()) {
        setMinimizeCore(other.getMinimizeCore());
      }
      if (other.hasFindMultipleCores()) {
        setFindMultipleCores(other.getFindMultipleCores());
      }
      if (other.hasCoverOptimization()) {
        setCoverOptimization(other.getCoverOptimization());
      }
      if (other.hasMaxSatAssumptionOrder()) {
        setMaxSatAssumptionOrder(other.getMaxSatAssumptionOrder());
      }
      if (other.hasMaxSatReverseAssumptionOrder()) {
        setMaxSatReverseAssumptionOrder(other.getMaxSatReverseAssumptionOrder());
      }
      if (other.hasMaxSatStratification()) {
        setMaxSatStratification(other.getMaxSatStratification());
      }
      if (other.hasUsePrecedencesInDisjunctiveConstraint()) {
        setUsePrecedencesInDisjunctiveConstraint(other.getUsePrecedencesInDisjunctiveConstraint());
      }
      if (other.hasUseOverloadCheckerInCumulativeConstraint()) {
        setUseOverloadCheckerInCumulativeConstraint(other.getUseOverloadCheckerInCumulativeConstraint());
      }
      if (other.hasUseTimetableEdgeFindingInCumulativeConstraint()) {
        setUseTimetableEdgeFindingInCumulativeConstraint(other.getUseTimetableEdgeFindingInCumulativeConstraint());
      }
      if (other.hasUseDisjunctiveConstraintInCumulativeConstraint()) {
        setUseDisjunctiveConstraintInCumulativeConstraint(other.getUseDisjunctiveConstraintInCumulativeConstraint());
      }
      if (other.hasLinearizationLevel()) {
        setLinearizationLevel(other.getLinearizationLevel());
      }
      if (other.hasBooleanEncodingLevel()) {
        setBooleanEncodingLevel(other.getBooleanEncodingLevel());
      }
      if (other.hasMaxDomainSizeWhenEncodingEqNeqConstraints()) {
        setMaxDomainSizeWhenEncodingEqNeqConstraints(other.getMaxDomainSizeWhenEncodingEqNeqConstraints());
      }
      if (other.hasMaxNumCuts()) {
        setMaxNumCuts(other.getMaxNumCuts());
      }
      if (other.hasOnlyAddCutsAtLevelZero()) {
        setOnlyAddCutsAtLevelZero(other.getOnlyAddCutsAtLevelZero());
      }
      if (other.hasAddKnapsackCuts()) {
        setAddKnapsackCuts(other.getAddKnapsackCuts());
      }
      if (other.hasAddCgCuts()) {
        setAddCgCuts(other.getAddCgCuts());
      }
      if (other.hasAddMirCuts()) {
        setAddMirCuts(other.getAddMirCuts());
      }
      if (other.hasAddZeroHalfCuts()) {
        setAddZeroHalfCuts(other.getAddZeroHalfCuts());
      }
      if (other.hasAddCliqueCuts()) {
        setAddCliqueCuts(other.getAddCliqueCuts());
      }
      if (other.hasMaxAllDiffCutSize()) {
        setMaxAllDiffCutSize(other.getMaxAllDiffCutSize());
      }
      if (other.hasAddLinMaxCuts()) {
        setAddLinMaxCuts(other.getAddLinMaxCuts());
      }
      if (other.hasMaxIntegerRoundingScaling()) {
        setMaxIntegerRoundingScaling(other.getMaxIntegerRoundingScaling());
      }
      if (other.hasAddLpConstraintsLazily()) {
        setAddLpConstraintsLazily(other.getAddLpConstraintsLazily());
      }
      if (other.hasMinOrthogonalityForLpConstraints()) {
        setMinOrthogonalityForLpConstraints(other.getMinOrthogonalityForLpConstraints());
      }
      if (other.hasMaxCutRoundsAtLevelZero()) {
        setMaxCutRoundsAtLevelZero(other.getMaxCutRoundsAtLevelZero());
      }
      if (other.hasMaxConsecutiveInactiveCount()) {
        setMaxConsecutiveInactiveCount(other.getMaxConsecutiveInactiveCount());
      }
      if (other.hasCutMaxActiveCountValue()) {
        setCutMaxActiveCountValue(other.getCutMaxActiveCountValue());
      }
      if (other.hasCutActiveCountDecay()) {
        setCutActiveCountDecay(other.getCutActiveCountDecay());
      }
      if (other.hasCutCleanupTarget()) {
        setCutCleanupTarget(other.getCutCleanupTarget());
      }
      if (other.hasNewConstraintsBatchSize()) {
        setNewConstraintsBatchSize(other.getNewConstraintsBatchSize());
      }
      if (other.hasSearchBranching()) {
        setSearchBranching(other.getSearchBranching());
      }
      if (other.hasHintConflictLimit()) {
        setHintConflictLimit(other.getHintConflictLimit());
      }
      if (other.hasRepairHint()) {
        setRepairHint(other.getRepairHint());
      }
      if (other.hasFixVariablesToTheirHintedValue()) {
        setFixVariablesToTheirHintedValue(other.getFixVariablesToTheirHintedValue());
      }
      if (other.hasExploitIntegerLpSolution()) {
        setExploitIntegerLpSolution(other.getExploitIntegerLpSolution());
      }
      if (other.hasExploitAllLpSolution()) {
        setExploitAllLpSolution(other.getExploitAllLpSolution());
      }
      if (other.hasExploitBestSolution()) {
        setExploitBestSolution(other.getExploitBestSolution());
      }
      if (other.hasExploitRelaxationSolution()) {
        setExploitRelaxationSolution(other.getExploitRelaxationSolution());
      }
      if (other.hasExploitObjective()) {
        setExploitObjective(other.getExploitObjective());
      }
      if (other.hasProbingPeriodAtRoot()) {
        setProbingPeriodAtRoot(other.getProbingPeriodAtRoot());
      }
      if (other.hasUseProbingSearch()) {
        setUseProbingSearch(other.getUseProbingSearch());
      }
      if (other.hasPseudoCostReliabilityThreshold()) {
        setPseudoCostReliabilityThreshold(other.getPseudoCostReliabilityThreshold());
      }
      if (other.hasOptimizeWithCore()) {
        setOptimizeWithCore(other.getOptimizeWithCore());
      }
      if (other.hasOptimizeWithLbTreeSearch()) {
        setOptimizeWithLbTreeSearch(other.getOptimizeWithLbTreeSearch());
      }
      if (other.hasBinarySearchNumConflicts()) {
        setBinarySearchNumConflicts(other.getBinarySearchNumConflicts());
      }
      if (other.hasOptimizeWithMaxHs()) {
        setOptimizeWithMaxHs(other.getOptimizeWithMaxHs());
      }
      if (other.hasEnumerateAllSolutions()) {
        setEnumerateAllSolutions(other.getEnumerateAllSolutions());
      }
      if (other.hasKeepAllFeasibleSolutionsInPresolve()) {
        setKeepAllFeasibleSolutionsInPresolve(other.getKeepAllFeasibleSolutionsInPresolve());
      }
      if (other.hasFillTightenedDomainsInResponse()) {
        setFillTightenedDomainsInResponse(other.getFillTightenedDomainsInResponse());
      }
      if (other.hasInstantiateAllVariables()) {
        setInstantiateAllVariables(other.getInstantiateAllVariables());
      }
      if (other.hasAutoDetectGreaterThanAtLeastOneOf()) {
        setAutoDetectGreaterThanAtLeastOneOf(other.getAutoDetectGreaterThanAtLeastOneOf());
      }
      if (other.hasStopAfterFirstSolution()) {
        setStopAfterFirstSolution(other.getStopAfterFirstSolution());
      }
      if (other.hasStopAfterPresolve()) {
        setStopAfterPresolve(other.getStopAfterPresolve());
      }
      if (other.hasNumSearchWorkers()) {
        setNumSearchWorkers(other.getNumSearchWorkers());
      }
      if (other.hasInterleaveSearch()) {
        setInterleaveSearch(other.getInterleaveSearch());
      }
      if (other.hasInterleaveBatchSize()) {
        setInterleaveBatchSize(other.getInterleaveBatchSize());
      }
      if (other.hasReduceMemoryUsageInInterleaveMode()) {
        setReduceMemoryUsageInInterleaveMode(other.getReduceMemoryUsageInInterleaveMode());
      }
      if (other.hasShareObjectiveBounds()) {
        setShareObjectiveBounds(other.getShareObjectiveBounds());
      }
      if (other.hasShareLevelZeroBounds()) {
        setShareLevelZeroBounds(other.getShareLevelZeroBounds());
      }
      if (other.hasUseLnsOnly()) {
        setUseLnsOnly(other.getUseLnsOnly());
      }
      if (other.hasLnsFocusOnDecisionVariables()) {
        setLnsFocusOnDecisionVariables(other.getLnsFocusOnDecisionVariables());
      }
      if (other.hasLnsExpandIntervalsInConstraintGraph()) {
        setLnsExpandIntervalsInConstraintGraph(other.getLnsExpandIntervalsInConstraintGraph());
      }
      if (other.hasSolutionPoolSize()) {
        setSolutionPoolSize(other.getSolutionPoolSize());
      }
      if (other.hasUseRinsLns()) {
        setUseRinsLns(other.getUseRinsLns());
      }
      if (other.hasUseFeasibilityPump()) {
        setUseFeasibilityPump(other.getUseFeasibilityPump());
      }
      if (other.hasFpRounding()) {
        setFpRounding(other.getFpRounding());
      }
      if (other.hasUseRelaxationLns()) {
        setUseRelaxationLns(other.getUseRelaxationLns());
      }
      if (other.hasDiversifyLnsParams()) {
        setDiversifyLnsParams(other.getDiversifyLnsParams());
      }
      if (other.hasRandomizeSearch()) {
        setRandomizeSearch(other.getRandomizeSearch());
      }
      if (other.hasSearchRandomizationTolerance()) {
        setSearchRandomizationTolerance(other.getSearchRandomizationTolerance());
      }
      if (other.hasUseOptionalVariables()) {
        setUseOptionalVariables(other.getUseOptionalVariables());
      }
      if (other.hasUseExactLpReason()) {
        setUseExactLpReason(other.getUseExactLpReason());
      }
      if (other.hasUseBranchingInLp()) {
        setUseBranchingInLp(other.getUseBranchingInLp());
      }
      if (other.hasUseCombinedNoOverlap()) {
        setUseCombinedNoOverlap(other.getUseCombinedNoOverlap());
      }
      if (other.hasCatchSigintSignal()) {
        setCatchSigintSignal(other.getCatchSigintSignal());
      }
      if (other.hasUseImpliedBounds()) {
        setUseImpliedBounds(other.getUseImpliedBounds());
      }
      if (other.hasPolishLpSolution()) {
        setPolishLpSolution(other.getPolishLpSolution());
      }
      if (other.hasConvertIntervals()) {
        setConvertIntervals(other.getConvertIntervals());
      }
      if (other.hasSymmetryLevel()) {
        setSymmetryLevel(other.getSymmetryLevel());
      }
      if (other.hasMipMaxBound()) {
        setMipMaxBound(other.getMipMaxBound());
      }
      if (other.hasMipVarScaling()) {
        setMipVarScaling(other.getMipVarScaling());
      }
      if (other.hasMipAutomaticallyScaleVariables()) {
        setMipAutomaticallyScaleVariables(other.getMipAutomaticallyScaleVariables());
      }
      if (other.hasMipWantedPrecision()) {
        setMipWantedPrecision(other.getMipWantedPrecision());
      }
      if (other.hasMipMaxActivityExponent()) {
        setMipMaxActivityExponent(other.getMipMaxActivityExponent());
      }
      if (other.hasMipCheckPrecision()) {
        setMipCheckPrecision(other.getMipCheckPrecision());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.ortools.sat.SatParameters parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.ortools.sat.SatParameters) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;
    private int bitField1_;
    private int bitField2_;
    private int bitField3_;
    private int bitField4_;
    private int bitField5_;

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * In some context, like in a portfolio of search, it makes sense to name a
     * given parameters set for logging purpose.
     * </pre>
     *
     * <code>optional string name = 171 [default = ""];</code>
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * In some context, like in a portfolio of search, it makes sense to name a
     * given parameters set for logging purpose.
     * </pre>
     *
     * <code>optional string name = 171 [default = ""];</code>
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * In some context, like in a portfolio of search, it makes sense to name a
     * given parameters set for logging purpose.
     * </pre>
     *
     * <code>optional string name = 171 [default = ""];</code>
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * In some context, like in a portfolio of search, it makes sense to name a
     * given parameters set for logging purpose.
     * </pre>
     *
     * <code>optional string name = 171 [default = ""];</code>
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
      name_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * In some context, like in a portfolio of search, it makes sense to name a
     * given parameters set for logging purpose.
     * </pre>
     *
     * <code>optional string name = 171 [default = ""];</code>
     * @return This builder for chaining.
     */
    public Builder clearName() {
      bitField0_ = (bitField0_ & ~0x00000001);
      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * In some context, like in a portfolio of search, it makes sense to name a
     * given parameters set for logging purpose.
     * </pre>
     *
     * <code>optional string name = 171 [default = ""];</code>
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
      name_ = value;
      onChanged();
      return this;
    }

    private int preferredVariableOrder_ = 0;
    /**
     * <code>optional .operations_research.sat.SatParameters.VariableOrder preferred_variable_order = 1 [default = IN_ORDER];</code>
     * @return Whether the preferredVariableOrder field is set.
     */
    @java.lang.Override public boolean hasPreferredVariableOrder() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.VariableOrder preferred_variable_order = 1 [default = IN_ORDER];</code>
     * @return The preferredVariableOrder.
     */
    @java.lang.Override
    public com.google.ortools.sat.SatParameters.VariableOrder getPreferredVariableOrder() {
      @SuppressWarnings("deprecation")
      com.google.ortools.sat.SatParameters.VariableOrder result = com.google.ortools.sat.SatParameters.VariableOrder.valueOf(preferredVariableOrder_);
      return result == null ? com.google.ortools.sat.SatParameters.VariableOrder.IN_ORDER : result;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.VariableOrder preferred_variable_order = 1 [default = IN_ORDER];</code>
     * @param value The preferredVariableOrder to set.
     * @return This builder for chaining.
     */
    public Builder setPreferredVariableOrder(com.google.ortools.sat.SatParameters.VariableOrder value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      preferredVariableOrder_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.VariableOrder preferred_variable_order = 1 [default = IN_ORDER];</code>
     * @return This builder for chaining.
     */
    public Builder clearPreferredVariableOrder() {
      bitField0_ = (bitField0_ & ~0x00000002);
      preferredVariableOrder_ = 0;
      onChanged();
      return this;
    }

    private int initialPolarity_ = 1;
    /**
     * <code>optional .operations_research.sat.SatParameters.Polarity initial_polarity = 2 [default = POLARITY_FALSE];</code>
     * @return Whether the initialPolarity field is set.
     */
    @java.lang.Override public boolean hasInitialPolarity() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.Polarity initial_polarity = 2 [default = POLARITY_FALSE];</code>
     * @return The initialPolarity.
     */
    @java.lang.Override
    public com.google.ortools.sat.SatParameters.Polarity getInitialPolarity() {
      @SuppressWarnings("deprecation")
      com.google.ortools.sat.SatParameters.Polarity result = com.google.ortools.sat.SatParameters.Polarity.valueOf(initialPolarity_);
      return result == null ? com.google.ortools.sat.SatParameters.Polarity.POLARITY_FALSE : result;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.Polarity initial_polarity = 2 [default = POLARITY_FALSE];</code>
     * @param value The initialPolarity to set.
     * @return This builder for chaining.
     */
    public Builder setInitialPolarity(com.google.ortools.sat.SatParameters.Polarity value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      initialPolarity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.Polarity initial_polarity = 2 [default = POLARITY_FALSE];</code>
     * @return This builder for chaining.
     */
    public Builder clearInitialPolarity() {
      bitField0_ = (bitField0_ & ~0x00000004);
      initialPolarity_ = 1;
      onChanged();
      return this;
    }

    private boolean usePhaseSaving_ = true;
    /**
     * <pre>
     * If this is true, then the polarity of a variable will be the last value it
     * was assigned to, or its default polarity if it was never assigned since the
     * call to ResetDecisionHeuristic().
     * Actually, we use a newer version where we follow the last value in the
     * longest non-conflicting partial assignment in the current phase.
     * This is called 'literal phase saving'. For details see 'A Lightweight
     * Component Caching Scheme for Satisfiability Solvers' K. Pipatsrisawat and
     * A.Darwiche, In 10th International Conference on Theory and Applications of
     * Satisfiability Testing, 2007.
     * </pre>
     *
     * <code>optional bool use_phase_saving = 44 [default = true];</code>
     * @return Whether the usePhaseSaving field is set.
     */
    @java.lang.Override
    public boolean hasUsePhaseSaving() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * If this is true, then the polarity of a variable will be the last value it
     * was assigned to, or its default polarity if it was never assigned since the
     * call to ResetDecisionHeuristic().
     * Actually, we use a newer version where we follow the last value in the
     * longest non-conflicting partial assignment in the current phase.
     * This is called 'literal phase saving'. For details see 'A Lightweight
     * Component Caching Scheme for Satisfiability Solvers' K. Pipatsrisawat and
     * A.Darwiche, In 10th International Conference on Theory and Applications of
     * Satisfiability Testing, 2007.
     * </pre>
     *
     * <code>optional bool use_phase_saving = 44 [default = true];</code>
     * @return The usePhaseSaving.
     */
    @java.lang.Override
    public boolean getUsePhaseSaving() {
      return usePhaseSaving_;
    }
    /**
     * <pre>
     * If this is true, then the polarity of a variable will be the last value it
     * was assigned to, or its default polarity if it was never assigned since the
     * call to ResetDecisionHeuristic().
     * Actually, we use a newer version where we follow the last value in the
     * longest non-conflicting partial assignment in the current phase.
     * This is called 'literal phase saving'. For details see 'A Lightweight
     * Component Caching Scheme for Satisfiability Solvers' K. Pipatsrisawat and
     * A.Darwiche, In 10th International Conference on Theory and Applications of
     * Satisfiability Testing, 2007.
     * </pre>
     *
     * <code>optional bool use_phase_saving = 44 [default = true];</code>
     * @param value The usePhaseSaving to set.
     * @return This builder for chaining.
     */
    public Builder setUsePhaseSaving(boolean value) {
      bitField0_ |= 0x00000008;
      usePhaseSaving_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If this is true, then the polarity of a variable will be the last value it
     * was assigned to, or its default polarity if it was never assigned since the
     * call to ResetDecisionHeuristic().
     * Actually, we use a newer version where we follow the last value in the
     * longest non-conflicting partial assignment in the current phase.
     * This is called 'literal phase saving'. For details see 'A Lightweight
     * Component Caching Scheme for Satisfiability Solvers' K. Pipatsrisawat and
     * A.Darwiche, In 10th International Conference on Theory and Applications of
     * Satisfiability Testing, 2007.
     * </pre>
     *
     * <code>optional bool use_phase_saving = 44 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearUsePhaseSaving() {
      bitField0_ = (bitField0_ & ~0x00000008);
      usePhaseSaving_ = true;
      onChanged();
      return this;
    }

    private int polarityRephaseIncrement_ = 1000;
    /**
     * <pre>
     * If non-zero, then we change the polarity heuristic after that many number
     * of conflicts in an arithmetically increasing fashion. So x the first time,
     * 2 * x the second time, etc...
     * </pre>
     *
     * <code>optional int32 polarity_rephase_increment = 168 [default = 1000];</code>
     * @return Whether the polarityRephaseIncrement field is set.
     */
    @java.lang.Override
    public boolean hasPolarityRephaseIncrement() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * If non-zero, then we change the polarity heuristic after that many number
     * of conflicts in an arithmetically increasing fashion. So x the first time,
     * 2 * x the second time, etc...
     * </pre>
     *
     * <code>optional int32 polarity_rephase_increment = 168 [default = 1000];</code>
     * @return The polarityRephaseIncrement.
     */
    @java.lang.Override
    public int getPolarityRephaseIncrement() {
      return polarityRephaseIncrement_;
    }
    /**
     * <pre>
     * If non-zero, then we change the polarity heuristic after that many number
     * of conflicts in an arithmetically increasing fashion. So x the first time,
     * 2 * x the second time, etc...
     * </pre>
     *
     * <code>optional int32 polarity_rephase_increment = 168 [default = 1000];</code>
     * @param value The polarityRephaseIncrement to set.
     * @return This builder for chaining.
     */
    public Builder setPolarityRephaseIncrement(int value) {
      bitField0_ |= 0x00000010;
      polarityRephaseIncrement_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-zero, then we change the polarity heuristic after that many number
     * of conflicts in an arithmetically increasing fashion. So x the first time,
     * 2 * x the second time, etc...
     * </pre>
     *
     * <code>optional int32 polarity_rephase_increment = 168 [default = 1000];</code>
     * @return This builder for chaining.
     */
    public Builder clearPolarityRephaseIncrement() {
      bitField0_ = (bitField0_ & ~0x00000010);
      polarityRephaseIncrement_ = 1000;
      onChanged();
      return this;
    }

    private double randomPolarityRatio_ ;
    /**
     * <pre>
     * The proportion of polarity chosen at random. Note that this take
     * precedence over the phase saving heuristic. This is different from
     * initial_polarity:POLARITY_RANDOM because it will select a new random
     * polarity each time the variable is branched upon instead of selecting one
     * initially and then always taking this choice.
     * </pre>
     *
     * <code>optional double random_polarity_ratio = 45 [default = 0];</code>
     * @return Whether the randomPolarityRatio field is set.
     */
    @java.lang.Override
    public boolean hasRandomPolarityRatio() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * The proportion of polarity chosen at random. Note that this take
     * precedence over the phase saving heuristic. This is different from
     * initial_polarity:POLARITY_RANDOM because it will select a new random
     * polarity each time the variable is branched upon instead of selecting one
     * initially and then always taking this choice.
     * </pre>
     *
     * <code>optional double random_polarity_ratio = 45 [default = 0];</code>
     * @return The randomPolarityRatio.
     */
    @java.lang.Override
    public double getRandomPolarityRatio() {
      return randomPolarityRatio_;
    }
    /**
     * <pre>
     * The proportion of polarity chosen at random. Note that this take
     * precedence over the phase saving heuristic. This is different from
     * initial_polarity:POLARITY_RANDOM because it will select a new random
     * polarity each time the variable is branched upon instead of selecting one
     * initially and then always taking this choice.
     * </pre>
     *
     * <code>optional double random_polarity_ratio = 45 [default = 0];</code>
     * @param value The randomPolarityRatio to set.
     * @return This builder for chaining.
     */
    public Builder setRandomPolarityRatio(double value) {
      bitField0_ |= 0x00000020;
      randomPolarityRatio_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The proportion of polarity chosen at random. Note that this take
     * precedence over the phase saving heuristic. This is different from
     * initial_polarity:POLARITY_RANDOM because it will select a new random
     * polarity each time the variable is branched upon instead of selecting one
     * initially and then always taking this choice.
     * </pre>
     *
     * <code>optional double random_polarity_ratio = 45 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearRandomPolarityRatio() {
      bitField0_ = (bitField0_ & ~0x00000020);
      randomPolarityRatio_ = 0D;
      onChanged();
      return this;
    }

    private double randomBranchesRatio_ ;
    /**
     * <pre>
     * A number between 0 and 1 that indicates the proportion of branching
     * variables that are selected randomly instead of choosing the first variable
     * from the given variable_ordering strategy.
     * </pre>
     *
     * <code>optional double random_branches_ratio = 32 [default = 0];</code>
     * @return Whether the randomBranchesRatio field is set.
     */
    @java.lang.Override
    public boolean hasRandomBranchesRatio() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * A number between 0 and 1 that indicates the proportion of branching
     * variables that are selected randomly instead of choosing the first variable
     * from the given variable_ordering strategy.
     * </pre>
     *
     * <code>optional double random_branches_ratio = 32 [default = 0];</code>
     * @return The randomBranchesRatio.
     */
    @java.lang.Override
    public double getRandomBranchesRatio() {
      return randomBranchesRatio_;
    }
    /**
     * <pre>
     * A number between 0 and 1 that indicates the proportion of branching
     * variables that are selected randomly instead of choosing the first variable
     * from the given variable_ordering strategy.
     * </pre>
     *
     * <code>optional double random_branches_ratio = 32 [default = 0];</code>
     * @param value The randomBranchesRatio to set.
     * @return This builder for chaining.
     */
    public Builder setRandomBranchesRatio(double value) {
      bitField0_ |= 0x00000040;
      randomBranchesRatio_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A number between 0 and 1 that indicates the proportion of branching
     * variables that are selected randomly instead of choosing the first variable
     * from the given variable_ordering strategy.
     * </pre>
     *
     * <code>optional double random_branches_ratio = 32 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearRandomBranchesRatio() {
      bitField0_ = (bitField0_ & ~0x00000040);
      randomBranchesRatio_ = 0D;
      onChanged();
      return this;
    }

    private boolean useErwaHeuristic_ ;
    /**
     * <pre>
     * Whether we use the ERWA (Exponential Recency Weighted Average) heuristic as
     * described in "Learning Rate Based Branching Heuristic for SAT solvers",
     * J.H.Liang, V. Ganesh, P. Poupart, K.Czarnecki, SAT 2016.
     * </pre>
     *
     * <code>optional bool use_erwa_heuristic = 75 [default = false];</code>
     * @return Whether the useErwaHeuristic field is set.
     */
    @java.lang.Override
    public boolean hasUseErwaHeuristic() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     * <pre>
     * Whether we use the ERWA (Exponential Recency Weighted Average) heuristic as
     * described in "Learning Rate Based Branching Heuristic for SAT solvers",
     * J.H.Liang, V. Ganesh, P. Poupart, K.Czarnecki, SAT 2016.
     * </pre>
     *
     * <code>optional bool use_erwa_heuristic = 75 [default = false];</code>
     * @return The useErwaHeuristic.
     */
    @java.lang.Override
    public boolean getUseErwaHeuristic() {
      return useErwaHeuristic_;
    }
    /**
     * <pre>
     * Whether we use the ERWA (Exponential Recency Weighted Average) heuristic as
     * described in "Learning Rate Based Branching Heuristic for SAT solvers",
     * J.H.Liang, V. Ganesh, P. Poupart, K.Czarnecki, SAT 2016.
     * </pre>
     *
     * <code>optional bool use_erwa_heuristic = 75 [default = false];</code>
     * @param value The useErwaHeuristic to set.
     * @return This builder for chaining.
     */
    public Builder setUseErwaHeuristic(boolean value) {
      bitField0_ |= 0x00000080;
      useErwaHeuristic_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we use the ERWA (Exponential Recency Weighted Average) heuristic as
     * described in "Learning Rate Based Branching Heuristic for SAT solvers",
     * J.H.Liang, V. Ganesh, P. Poupart, K.Czarnecki, SAT 2016.
     * </pre>
     *
     * <code>optional bool use_erwa_heuristic = 75 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseErwaHeuristic() {
      bitField0_ = (bitField0_ & ~0x00000080);
      useErwaHeuristic_ = false;
      onChanged();
      return this;
    }

    private double initialVariablesActivity_ ;
    /**
     * <pre>
     * The initial value of the variables activity. A non-zero value only make
     * sense when use_erwa_heuristic is true. Experiments with a value of 1e-2
     * together with the ERWA heuristic showed slighthly better result than simply
     * using zero. The idea is that when the "learning rate" of a variable becomes
     * lower than this value, then we prefer to branch on never explored before
     * variables. This is not in the ERWA paper.
     * </pre>
     *
     * <code>optional double initial_variables_activity = 76 [default = 0];</code>
     * @return Whether the initialVariablesActivity field is set.
     */
    @java.lang.Override
    public boolean hasInitialVariablesActivity() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     * <pre>
     * The initial value of the variables activity. A non-zero value only make
     * sense when use_erwa_heuristic is true. Experiments with a value of 1e-2
     * together with the ERWA heuristic showed slighthly better result than simply
     * using zero. The idea is that when the "learning rate" of a variable becomes
     * lower than this value, then we prefer to branch on never explored before
     * variables. This is not in the ERWA paper.
     * </pre>
     *
     * <code>optional double initial_variables_activity = 76 [default = 0];</code>
     * @return The initialVariablesActivity.
     */
    @java.lang.Override
    public double getInitialVariablesActivity() {
      return initialVariablesActivity_;
    }
    /**
     * <pre>
     * The initial value of the variables activity. A non-zero value only make
     * sense when use_erwa_heuristic is true. Experiments with a value of 1e-2
     * together with the ERWA heuristic showed slighthly better result than simply
     * using zero. The idea is that when the "learning rate" of a variable becomes
     * lower than this value, then we prefer to branch on never explored before
     * variables. This is not in the ERWA paper.
     * </pre>
     *
     * <code>optional double initial_variables_activity = 76 [default = 0];</code>
     * @param value The initialVariablesActivity to set.
     * @return This builder for chaining.
     */
    public Builder setInitialVariablesActivity(double value) {
      bitField0_ |= 0x00000100;
      initialVariablesActivity_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The initial value of the variables activity. A non-zero value only make
     * sense when use_erwa_heuristic is true. Experiments with a value of 1e-2
     * together with the ERWA heuristic showed slighthly better result than simply
     * using zero. The idea is that when the "learning rate" of a variable becomes
     * lower than this value, then we prefer to branch on never explored before
     * variables. This is not in the ERWA paper.
     * </pre>
     *
     * <code>optional double initial_variables_activity = 76 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearInitialVariablesActivity() {
      bitField0_ = (bitField0_ & ~0x00000100);
      initialVariablesActivity_ = 0D;
      onChanged();
      return this;
    }

    private boolean alsoBumpVariablesInConflictReasons_ ;
    /**
     * <pre>
     * When this is true, then the variables that appear in any of the reason of
     * the variables in a conflict have their activity bumped. This is addition to
     * the variables in the conflict, and the one that were used during conflict
     * resolution.
     * </pre>
     *
     * <code>optional bool also_bump_variables_in_conflict_reasons = 77 [default = false];</code>
     * @return Whether the alsoBumpVariablesInConflictReasons field is set.
     */
    @java.lang.Override
    public boolean hasAlsoBumpVariablesInConflictReasons() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     * <pre>
     * When this is true, then the variables that appear in any of the reason of
     * the variables in a conflict have their activity bumped. This is addition to
     * the variables in the conflict, and the one that were used during conflict
     * resolution.
     * </pre>
     *
     * <code>optional bool also_bump_variables_in_conflict_reasons = 77 [default = false];</code>
     * @return The alsoBumpVariablesInConflictReasons.
     */
    @java.lang.Override
    public boolean getAlsoBumpVariablesInConflictReasons() {
      return alsoBumpVariablesInConflictReasons_;
    }
    /**
     * <pre>
     * When this is true, then the variables that appear in any of the reason of
     * the variables in a conflict have their activity bumped. This is addition to
     * the variables in the conflict, and the one that were used during conflict
     * resolution.
     * </pre>
     *
     * <code>optional bool also_bump_variables_in_conflict_reasons = 77 [default = false];</code>
     * @param value The alsoBumpVariablesInConflictReasons to set.
     * @return This builder for chaining.
     */
    public Builder setAlsoBumpVariablesInConflictReasons(boolean value) {
      bitField0_ |= 0x00000200;
      alsoBumpVariablesInConflictReasons_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * When this is true, then the variables that appear in any of the reason of
     * the variables in a conflict have their activity bumped. This is addition to
     * the variables in the conflict, and the one that were used during conflict
     * resolution.
     * </pre>
     *
     * <code>optional bool also_bump_variables_in_conflict_reasons = 77 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearAlsoBumpVariablesInConflictReasons() {
      bitField0_ = (bitField0_ & ~0x00000200);
      alsoBumpVariablesInConflictReasons_ = false;
      onChanged();
      return this;
    }

    private int minimizationAlgorithm_ = 2;
    /**
     * <code>optional .operations_research.sat.SatParameters.ConflictMinimizationAlgorithm minimization_algorithm = 4 [default = RECURSIVE];</code>
     * @return Whether the minimizationAlgorithm field is set.
     */
    @java.lang.Override public boolean hasMinimizationAlgorithm() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.ConflictMinimizationAlgorithm minimization_algorithm = 4 [default = RECURSIVE];</code>
     * @return The minimizationAlgorithm.
     */
    @java.lang.Override
    public com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm getMinimizationAlgorithm() {
      @SuppressWarnings("deprecation")
      com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm result = com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm.valueOf(minimizationAlgorithm_);
      return result == null ? com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm.RECURSIVE : result;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.ConflictMinimizationAlgorithm minimization_algorithm = 4 [default = RECURSIVE];</code>
     * @param value The minimizationAlgorithm to set.
     * @return This builder for chaining.
     */
    public Builder setMinimizationAlgorithm(com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000400;
      minimizationAlgorithm_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.ConflictMinimizationAlgorithm minimization_algorithm = 4 [default = RECURSIVE];</code>
     * @return This builder for chaining.
     */
    public Builder clearMinimizationAlgorithm() {
      bitField0_ = (bitField0_ & ~0x00000400);
      minimizationAlgorithm_ = 2;
      onChanged();
      return this;
    }

    private int binaryMinimizationAlgorithm_ = 1;
    /**
     * <code>optional .operations_research.sat.SatParameters.BinaryMinizationAlgorithm binary_minimization_algorithm = 34 [default = BINARY_MINIMIZATION_FIRST];</code>
     * @return Whether the binaryMinimizationAlgorithm field is set.
     */
    @java.lang.Override public boolean hasBinaryMinimizationAlgorithm() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.BinaryMinizationAlgorithm binary_minimization_algorithm = 34 [default = BINARY_MINIMIZATION_FIRST];</code>
     * @return The binaryMinimizationAlgorithm.
     */
    @java.lang.Override
    public com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm getBinaryMinimizationAlgorithm() {
      @SuppressWarnings("deprecation")
      com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm result = com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm.valueOf(binaryMinimizationAlgorithm_);
      return result == null ? com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm.BINARY_MINIMIZATION_FIRST : result;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.BinaryMinizationAlgorithm binary_minimization_algorithm = 34 [default = BINARY_MINIMIZATION_FIRST];</code>
     * @param value The binaryMinimizationAlgorithm to set.
     * @return This builder for chaining.
     */
    public Builder setBinaryMinimizationAlgorithm(com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      binaryMinimizationAlgorithm_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.BinaryMinizationAlgorithm binary_minimization_algorithm = 34 [default = BINARY_MINIMIZATION_FIRST];</code>
     * @return This builder for chaining.
     */
    public Builder clearBinaryMinimizationAlgorithm() {
      bitField0_ = (bitField0_ & ~0x00000800);
      binaryMinimizationAlgorithm_ = 1;
      onChanged();
      return this;
    }

    private boolean subsumptionDuringConflictAnalysis_ = true;
    /**
     * <pre>
     * At a really low cost, during the 1-UIP conflict computation, it is easy to
     * detect if some of the involved reasons are subsumed by the current
     * conflict. When this is true, such clauses are detached and later removed
     * from the problem.
     * </pre>
     *
     * <code>optional bool subsumption_during_conflict_analysis = 56 [default = true];</code>
     * @return Whether the subsumptionDuringConflictAnalysis field is set.
     */
    @java.lang.Override
    public boolean hasSubsumptionDuringConflictAnalysis() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     * <pre>
     * At a really low cost, during the 1-UIP conflict computation, it is easy to
     * detect if some of the involved reasons are subsumed by the current
     * conflict. When this is true, such clauses are detached and later removed
     * from the problem.
     * </pre>
     *
     * <code>optional bool subsumption_during_conflict_analysis = 56 [default = true];</code>
     * @return The subsumptionDuringConflictAnalysis.
     */
    @java.lang.Override
    public boolean getSubsumptionDuringConflictAnalysis() {
      return subsumptionDuringConflictAnalysis_;
    }
    /**
     * <pre>
     * At a really low cost, during the 1-UIP conflict computation, it is easy to
     * detect if some of the involved reasons are subsumed by the current
     * conflict. When this is true, such clauses are detached and later removed
     * from the problem.
     * </pre>
     *
     * <code>optional bool subsumption_during_conflict_analysis = 56 [default = true];</code>
     * @param value The subsumptionDuringConflictAnalysis to set.
     * @return This builder for chaining.
     */
    public Builder setSubsumptionDuringConflictAnalysis(boolean value) {
      bitField0_ |= 0x00001000;
      subsumptionDuringConflictAnalysis_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * At a really low cost, during the 1-UIP conflict computation, it is easy to
     * detect if some of the involved reasons are subsumed by the current
     * conflict. When this is true, such clauses are detached and later removed
     * from the problem.
     * </pre>
     *
     * <code>optional bool subsumption_during_conflict_analysis = 56 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearSubsumptionDuringConflictAnalysis() {
      bitField0_ = (bitField0_ & ~0x00001000);
      subsumptionDuringConflictAnalysis_ = true;
      onChanged();
      return this;
    }

    private int clauseCleanupPeriod_ = 10000;
    /**
     * <pre>
     * Trigger a cleanup when this number of "deletable" clauses is learned.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_period = 11 [default = 10000];</code>
     * @return Whether the clauseCleanupPeriod field is set.
     */
    @java.lang.Override
    public boolean hasClauseCleanupPeriod() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     * <pre>
     * Trigger a cleanup when this number of "deletable" clauses is learned.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_period = 11 [default = 10000];</code>
     * @return The clauseCleanupPeriod.
     */
    @java.lang.Override
    public int getClauseCleanupPeriod() {
      return clauseCleanupPeriod_;
    }
    /**
     * <pre>
     * Trigger a cleanup when this number of "deletable" clauses is learned.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_period = 11 [default = 10000];</code>
     * @param value The clauseCleanupPeriod to set.
     * @return This builder for chaining.
     */
    public Builder setClauseCleanupPeriod(int value) {
      bitField0_ |= 0x00002000;
      clauseCleanupPeriod_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Trigger a cleanup when this number of "deletable" clauses is learned.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_period = 11 [default = 10000];</code>
     * @return This builder for chaining.
     */
    public Builder clearClauseCleanupPeriod() {
      bitField0_ = (bitField0_ & ~0x00002000);
      clauseCleanupPeriod_ = 10000;
      onChanged();
      return this;
    }

    private int clauseCleanupTarget_ ;
    /**
     * <pre>
     * During a cleanup, we will always keep that number of "deletable" clauses.
     * Note that this doesn't include the "protected" clauses.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_target = 13 [default = 0];</code>
     * @return Whether the clauseCleanupTarget field is set.
     */
    @java.lang.Override
    public boolean hasClauseCleanupTarget() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     * <pre>
     * During a cleanup, we will always keep that number of "deletable" clauses.
     * Note that this doesn't include the "protected" clauses.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_target = 13 [default = 0];</code>
     * @return The clauseCleanupTarget.
     */
    @java.lang.Override
    public int getClauseCleanupTarget() {
      return clauseCleanupTarget_;
    }
    /**
     * <pre>
     * During a cleanup, we will always keep that number of "deletable" clauses.
     * Note that this doesn't include the "protected" clauses.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_target = 13 [default = 0];</code>
     * @param value The clauseCleanupTarget to set.
     * @return This builder for chaining.
     */
    public Builder setClauseCleanupTarget(int value) {
      bitField0_ |= 0x00004000;
      clauseCleanupTarget_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * During a cleanup, we will always keep that number of "deletable" clauses.
     * Note that this doesn't include the "protected" clauses.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_target = 13 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearClauseCleanupTarget() {
      bitField0_ = (bitField0_ & ~0x00004000);
      clauseCleanupTarget_ = 0;
      onChanged();
      return this;
    }

    private double clauseCleanupRatio_ = 0.5D;
    /**
     * <pre>
     * During a cleanup, if clause_cleanup_target is 0, we will delete the
     * clause_cleanup_ratio of "deletable" clauses instead of aiming for a fixed
     * target of clauses to keep.
     * </pre>
     *
     * <code>optional double clause_cleanup_ratio = 190 [default = 0.5];</code>
     * @return Whether the clauseCleanupRatio field is set.
     */
    @java.lang.Override
    public boolean hasClauseCleanupRatio() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     * <pre>
     * During a cleanup, if clause_cleanup_target is 0, we will delete the
     * clause_cleanup_ratio of "deletable" clauses instead of aiming for a fixed
     * target of clauses to keep.
     * </pre>
     *
     * <code>optional double clause_cleanup_ratio = 190 [default = 0.5];</code>
     * @return The clauseCleanupRatio.
     */
    @java.lang.Override
    public double getClauseCleanupRatio() {
      return clauseCleanupRatio_;
    }
    /**
     * <pre>
     * During a cleanup, if clause_cleanup_target is 0, we will delete the
     * clause_cleanup_ratio of "deletable" clauses instead of aiming for a fixed
     * target of clauses to keep.
     * </pre>
     *
     * <code>optional double clause_cleanup_ratio = 190 [default = 0.5];</code>
     * @param value The clauseCleanupRatio to set.
     * @return This builder for chaining.
     */
    public Builder setClauseCleanupRatio(double value) {
      bitField0_ |= 0x00008000;
      clauseCleanupRatio_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * During a cleanup, if clause_cleanup_target is 0, we will delete the
     * clause_cleanup_ratio of "deletable" clauses instead of aiming for a fixed
     * target of clauses to keep.
     * </pre>
     *
     * <code>optional double clause_cleanup_ratio = 190 [default = 0.5];</code>
     * @return This builder for chaining.
     */
    public Builder clearClauseCleanupRatio() {
      bitField0_ = (bitField0_ & ~0x00008000);
      clauseCleanupRatio_ = 0.5D;
      onChanged();
      return this;
    }

    private int clauseCleanupProtection_ = 0;
    /**
     * <code>optional .operations_research.sat.SatParameters.ClauseProtection clause_cleanup_protection = 58 [default = PROTECTION_NONE];</code>
     * @return Whether the clauseCleanupProtection field is set.
     */
    @java.lang.Override public boolean hasClauseCleanupProtection() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.ClauseProtection clause_cleanup_protection = 58 [default = PROTECTION_NONE];</code>
     * @return The clauseCleanupProtection.
     */
    @java.lang.Override
    public com.google.ortools.sat.SatParameters.ClauseProtection getClauseCleanupProtection() {
      @SuppressWarnings("deprecation")
      com.google.ortools.sat.SatParameters.ClauseProtection result = com.google.ortools.sat.SatParameters.ClauseProtection.valueOf(clauseCleanupProtection_);
      return result == null ? com.google.ortools.sat.SatParameters.ClauseProtection.PROTECTION_NONE : result;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.ClauseProtection clause_cleanup_protection = 58 [default = PROTECTION_NONE];</code>
     * @param value The clauseCleanupProtection to set.
     * @return This builder for chaining.
     */
    public Builder setClauseCleanupProtection(com.google.ortools.sat.SatParameters.ClauseProtection value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00010000;
      clauseCleanupProtection_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.ClauseProtection clause_cleanup_protection = 58 [default = PROTECTION_NONE];</code>
     * @return This builder for chaining.
     */
    public Builder clearClauseCleanupProtection() {
      bitField0_ = (bitField0_ & ~0x00010000);
      clauseCleanupProtection_ = 0;
      onChanged();
      return this;
    }

    private int clauseCleanupLbdBound_ = 5;
    /**
     * <pre>
     * All the clauses with a LBD (literal blocks distance) lower or equal to this
     * parameters will always be kept.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_lbd_bound = 59 [default = 5];</code>
     * @return Whether the clauseCleanupLbdBound field is set.
     */
    @java.lang.Override
    public boolean hasClauseCleanupLbdBound() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     * <pre>
     * All the clauses with a LBD (literal blocks distance) lower or equal to this
     * parameters will always be kept.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_lbd_bound = 59 [default = 5];</code>
     * @return The clauseCleanupLbdBound.
     */
    @java.lang.Override
    public int getClauseCleanupLbdBound() {
      return clauseCleanupLbdBound_;
    }
    /**
     * <pre>
     * All the clauses with a LBD (literal blocks distance) lower or equal to this
     * parameters will always be kept.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_lbd_bound = 59 [default = 5];</code>
     * @param value The clauseCleanupLbdBound to set.
     * @return This builder for chaining.
     */
    public Builder setClauseCleanupLbdBound(int value) {
      bitField0_ |= 0x00020000;
      clauseCleanupLbdBound_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * All the clauses with a LBD (literal blocks distance) lower or equal to this
     * parameters will always be kept.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_lbd_bound = 59 [default = 5];</code>
     * @return This builder for chaining.
     */
    public Builder clearClauseCleanupLbdBound() {
      bitField0_ = (bitField0_ & ~0x00020000);
      clauseCleanupLbdBound_ = 5;
      onChanged();
      return this;
    }

    private int clauseCleanupOrdering_ = 0;
    /**
     * <code>optional .operations_research.sat.SatParameters.ClauseOrdering clause_cleanup_ordering = 60 [default = CLAUSE_ACTIVITY];</code>
     * @return Whether the clauseCleanupOrdering field is set.
     */
    @java.lang.Override public boolean hasClauseCleanupOrdering() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.ClauseOrdering clause_cleanup_ordering = 60 [default = CLAUSE_ACTIVITY];</code>
     * @return The clauseCleanupOrdering.
     */
    @java.lang.Override
    public com.google.ortools.sat.SatParameters.ClauseOrdering getClauseCleanupOrdering() {
      @SuppressWarnings("deprecation")
      com.google.ortools.sat.SatParameters.ClauseOrdering result = com.google.ortools.sat.SatParameters.ClauseOrdering.valueOf(clauseCleanupOrdering_);
      return result == null ? com.google.ortools.sat.SatParameters.ClauseOrdering.CLAUSE_ACTIVITY : result;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.ClauseOrdering clause_cleanup_ordering = 60 [default = CLAUSE_ACTIVITY];</code>
     * @param value The clauseCleanupOrdering to set.
     * @return This builder for chaining.
     */
    public Builder setClauseCleanupOrdering(com.google.ortools.sat.SatParameters.ClauseOrdering value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00040000;
      clauseCleanupOrdering_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.ClauseOrdering clause_cleanup_ordering = 60 [default = CLAUSE_ACTIVITY];</code>
     * @return This builder for chaining.
     */
    public Builder clearClauseCleanupOrdering() {
      bitField0_ = (bitField0_ & ~0x00040000);
      clauseCleanupOrdering_ = 0;
      onChanged();
      return this;
    }

    private int pbCleanupIncrement_ = 200;
    /**
     * <pre>
     * Same as for the clauses, but for the learned pseudo-Boolean constraints.
     * </pre>
     *
     * <code>optional int32 pb_cleanup_increment = 46 [default = 200];</code>
     * @return Whether the pbCleanupIncrement field is set.
     */
    @java.lang.Override
    public boolean hasPbCleanupIncrement() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     * <pre>
     * Same as for the clauses, but for the learned pseudo-Boolean constraints.
     * </pre>
     *
     * <code>optional int32 pb_cleanup_increment = 46 [default = 200];</code>
     * @return The pbCleanupIncrement.
     */
    @java.lang.Override
    public int getPbCleanupIncrement() {
      return pbCleanupIncrement_;
    }
    /**
     * <pre>
     * Same as for the clauses, but for the learned pseudo-Boolean constraints.
     * </pre>
     *
     * <code>optional int32 pb_cleanup_increment = 46 [default = 200];</code>
     * @param value The pbCleanupIncrement to set.
     * @return This builder for chaining.
     */
    public Builder setPbCleanupIncrement(int value) {
      bitField0_ |= 0x00080000;
      pbCleanupIncrement_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Same as for the clauses, but for the learned pseudo-Boolean constraints.
     * </pre>
     *
     * <code>optional int32 pb_cleanup_increment = 46 [default = 200];</code>
     * @return This builder for chaining.
     */
    public Builder clearPbCleanupIncrement() {
      bitField0_ = (bitField0_ & ~0x00080000);
      pbCleanupIncrement_ = 200;
      onChanged();
      return this;
    }

    private double pbCleanupRatio_ = 0.5D;
    /**
     * <code>optional double pb_cleanup_ratio = 47 [default = 0.5];</code>
     * @return Whether the pbCleanupRatio field is set.
     */
    @java.lang.Override
    public boolean hasPbCleanupRatio() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     * <code>optional double pb_cleanup_ratio = 47 [default = 0.5];</code>
     * @return The pbCleanupRatio.
     */
    @java.lang.Override
    public double getPbCleanupRatio() {
      return pbCleanupRatio_;
    }
    /**
     * <code>optional double pb_cleanup_ratio = 47 [default = 0.5];</code>
     * @param value The pbCleanupRatio to set.
     * @return This builder for chaining.
     */
    public Builder setPbCleanupRatio(double value) {
      bitField0_ |= 0x00100000;
      pbCleanupRatio_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional double pb_cleanup_ratio = 47 [default = 0.5];</code>
     * @return This builder for chaining.
     */
    public Builder clearPbCleanupRatio() {
      bitField0_ = (bitField0_ & ~0x00100000);
      pbCleanupRatio_ = 0.5D;
      onChanged();
      return this;
    }

    private int minimizeWithPropagationRestartPeriod_ = 10;
    /**
     * <pre>
     * Parameters for an heuristic similar to the one descibed in "An effective
     * learnt clause minimization approach for CDCL Sat Solvers",
     * https://www.ijcai.org/proceedings/2017/0098.pdf
     * For now, we have a somewhat simpler implementation where every x restart we
     * spend y decisions on clause minimization. The minimization technique is the
     * same as the one used to minimize core in max-sat. We also minimize problem
     * clauses and not just the learned clause that we keep forever like in the
     * paper.
     * Changing these parameters or the kind of clause we minimize seems to have
     * a big impact on the overall perf on our benchmarks. So this technique seems
     * definitely useful, but it is hard to tune properly.
     * </pre>
     *
     * <code>optional int32 minimize_with_propagation_restart_period = 96 [default = 10];</code>
     * @return Whether the minimizeWithPropagationRestartPeriod field is set.
     */
    @java.lang.Override
    public boolean hasMinimizeWithPropagationRestartPeriod() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     * <pre>
     * Parameters for an heuristic similar to the one descibed in "An effective
     * learnt clause minimization approach for CDCL Sat Solvers",
     * https://www.ijcai.org/proceedings/2017/0098.pdf
     * For now, we have a somewhat simpler implementation where every x restart we
     * spend y decisions on clause minimization. The minimization technique is the
     * same as the one used to minimize core in max-sat. We also minimize problem
     * clauses and not just the learned clause that we keep forever like in the
     * paper.
     * Changing these parameters or the kind of clause we minimize seems to have
     * a big impact on the overall perf on our benchmarks. So this technique seems
     * definitely useful, but it is hard to tune properly.
     * </pre>
     *
     * <code>optional int32 minimize_with_propagation_restart_period = 96 [default = 10];</code>
     * @return The minimizeWithPropagationRestartPeriod.
     */
    @java.lang.Override
    public int getMinimizeWithPropagationRestartPeriod() {
      return minimizeWithPropagationRestartPeriod_;
    }
    /**
     * <pre>
     * Parameters for an heuristic similar to the one descibed in "An effective
     * learnt clause minimization approach for CDCL Sat Solvers",
     * https://www.ijcai.org/proceedings/2017/0098.pdf
     * For now, we have a somewhat simpler implementation where every x restart we
     * spend y decisions on clause minimization. The minimization technique is the
     * same as the one used to minimize core in max-sat. We also minimize problem
     * clauses and not just the learned clause that we keep forever like in the
     * paper.
     * Changing these parameters or the kind of clause we minimize seems to have
     * a big impact on the overall perf on our benchmarks. So this technique seems
     * definitely useful, but it is hard to tune properly.
     * </pre>
     *
     * <code>optional int32 minimize_with_propagation_restart_period = 96 [default = 10];</code>
     * @param value The minimizeWithPropagationRestartPeriod to set.
     * @return This builder for chaining.
     */
    public Builder setMinimizeWithPropagationRestartPeriod(int value) {
      bitField0_ |= 0x00200000;
      minimizeWithPropagationRestartPeriod_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Parameters for an heuristic similar to the one descibed in "An effective
     * learnt clause minimization approach for CDCL Sat Solvers",
     * https://www.ijcai.org/proceedings/2017/0098.pdf
     * For now, we have a somewhat simpler implementation where every x restart we
     * spend y decisions on clause minimization. The minimization technique is the
     * same as the one used to minimize core in max-sat. We also minimize problem
     * clauses and not just the learned clause that we keep forever like in the
     * paper.
     * Changing these parameters or the kind of clause we minimize seems to have
     * a big impact on the overall perf on our benchmarks. So this technique seems
     * definitely useful, but it is hard to tune properly.
     * </pre>
     *
     * <code>optional int32 minimize_with_propagation_restart_period = 96 [default = 10];</code>
     * @return This builder for chaining.
     */
    public Builder clearMinimizeWithPropagationRestartPeriod() {
      bitField0_ = (bitField0_ & ~0x00200000);
      minimizeWithPropagationRestartPeriod_ = 10;
      onChanged();
      return this;
    }

    private int minimizeWithPropagationNumDecisions_ = 1000;
    /**
     * <code>optional int32 minimize_with_propagation_num_decisions = 97 [default = 1000];</code>
     * @return Whether the minimizeWithPropagationNumDecisions field is set.
     */
    @java.lang.Override
    public boolean hasMinimizeWithPropagationNumDecisions() {
      return ((bitField0_ & 0x00400000) != 0);
    }
    /**
     * <code>optional int32 minimize_with_propagation_num_decisions = 97 [default = 1000];</code>
     * @return The minimizeWithPropagationNumDecisions.
     */
    @java.lang.Override
    public int getMinimizeWithPropagationNumDecisions() {
      return minimizeWithPropagationNumDecisions_;
    }
    /**
     * <code>optional int32 minimize_with_propagation_num_decisions = 97 [default = 1000];</code>
     * @param value The minimizeWithPropagationNumDecisions to set.
     * @return This builder for chaining.
     */
    public Builder setMinimizeWithPropagationNumDecisions(int value) {
      bitField0_ |= 0x00400000;
      minimizeWithPropagationNumDecisions_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional int32 minimize_with_propagation_num_decisions = 97 [default = 1000];</code>
     * @return This builder for chaining.
     */
    public Builder clearMinimizeWithPropagationNumDecisions() {
      bitField0_ = (bitField0_ & ~0x00400000);
      minimizeWithPropagationNumDecisions_ = 1000;
      onChanged();
      return this;
    }

    private double variableActivityDecay_ = 0.8D;
    /**
     * <pre>
     * Each time a conflict is found, the activities of some variables are
     * increased by one. Then, the activity of all variables are multiplied by
     * variable_activity_decay.
     * To implement this efficiently, the activity of all the variables is not
     * decayed at each conflict. Instead, the activity increment is multiplied by
     * 1 / decay. When an activity reach max_variable_activity_value, all the
     * activity are multiplied by 1 / max_variable_activity_value.
     * </pre>
     *
     * <code>optional double variable_activity_decay = 15 [default = 0.8];</code>
     * @return Whether the variableActivityDecay field is set.
     */
    @java.lang.Override
    public boolean hasVariableActivityDecay() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     * <pre>
     * Each time a conflict is found, the activities of some variables are
     * increased by one. Then, the activity of all variables are multiplied by
     * variable_activity_decay.
     * To implement this efficiently, the activity of all the variables is not
     * decayed at each conflict. Instead, the activity increment is multiplied by
     * 1 / decay. When an activity reach max_variable_activity_value, all the
     * activity are multiplied by 1 / max_variable_activity_value.
     * </pre>
     *
     * <code>optional double variable_activity_decay = 15 [default = 0.8];</code>
     * @return The variableActivityDecay.
     */
    @java.lang.Override
    public double getVariableActivityDecay() {
      return variableActivityDecay_;
    }
    /**
     * <pre>
     * Each time a conflict is found, the activities of some variables are
     * increased by one. Then, the activity of all variables are multiplied by
     * variable_activity_decay.
     * To implement this efficiently, the activity of all the variables is not
     * decayed at each conflict. Instead, the activity increment is multiplied by
     * 1 / decay. When an activity reach max_variable_activity_value, all the
     * activity are multiplied by 1 / max_variable_activity_value.
     * </pre>
     *
     * <code>optional double variable_activity_decay = 15 [default = 0.8];</code>
     * @param value The variableActivityDecay to set.
     * @return This builder for chaining.
     */
    public Builder setVariableActivityDecay(double value) {
      bitField0_ |= 0x00800000;
      variableActivityDecay_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Each time a conflict is found, the activities of some variables are
     * increased by one. Then, the activity of all variables are multiplied by
     * variable_activity_decay.
     * To implement this efficiently, the activity of all the variables is not
     * decayed at each conflict. Instead, the activity increment is multiplied by
     * 1 / decay. When an activity reach max_variable_activity_value, all the
     * activity are multiplied by 1 / max_variable_activity_value.
     * </pre>
     *
     * <code>optional double variable_activity_decay = 15 [default = 0.8];</code>
     * @return This builder for chaining.
     */
    public Builder clearVariableActivityDecay() {
      bitField0_ = (bitField0_ & ~0x00800000);
      variableActivityDecay_ = 0.8D;
      onChanged();
      return this;
    }

    private double maxVariableActivityValue_ = 1e+100D;
    /**
     * <code>optional double max_variable_activity_value = 16 [default = 1e+100];</code>
     * @return Whether the maxVariableActivityValue field is set.
     */
    @java.lang.Override
    public boolean hasMaxVariableActivityValue() {
      return ((bitField0_ & 0x01000000) != 0);
    }
    /**
     * <code>optional double max_variable_activity_value = 16 [default = 1e+100];</code>
     * @return The maxVariableActivityValue.
     */
    @java.lang.Override
    public double getMaxVariableActivityValue() {
      return maxVariableActivityValue_;
    }
    /**
     * <code>optional double max_variable_activity_value = 16 [default = 1e+100];</code>
     * @param value The maxVariableActivityValue to set.
     * @return This builder for chaining.
     */
    public Builder setMaxVariableActivityValue(double value) {
      bitField0_ |= 0x01000000;
      maxVariableActivityValue_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional double max_variable_activity_value = 16 [default = 1e+100];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxVariableActivityValue() {
      bitField0_ = (bitField0_ & ~0x01000000);
      maxVariableActivityValue_ = 1e+100D;
      onChanged();
      return this;
    }

    private double glucoseMaxDecay_ = 0.95D;
    /**
     * <pre>
     * The activity starts at 0.8 and increment by 0.01 every 5000 conflicts until
     * 0.95. This "hack" seems to work well and comes from:
     * Glucose 2.3 in the SAT 2013 Competition - SAT Competition 2013
     * http://edacc4.informatik.uni-ulm.de/SC13/solver-description-download/136
     * </pre>
     *
     * <code>optional double glucose_max_decay = 22 [default = 0.95];</code>
     * @return Whether the glucoseMaxDecay field is set.
     */
    @java.lang.Override
    public boolean hasGlucoseMaxDecay() {
      return ((bitField0_ & 0x02000000) != 0);
    }
    /**
     * <pre>
     * The activity starts at 0.8 and increment by 0.01 every 5000 conflicts until
     * 0.95. This "hack" seems to work well and comes from:
     * Glucose 2.3 in the SAT 2013 Competition - SAT Competition 2013
     * http://edacc4.informatik.uni-ulm.de/SC13/solver-description-download/136
     * </pre>
     *
     * <code>optional double glucose_max_decay = 22 [default = 0.95];</code>
     * @return The glucoseMaxDecay.
     */
    @java.lang.Override
    public double getGlucoseMaxDecay() {
      return glucoseMaxDecay_;
    }
    /**
     * <pre>
     * The activity starts at 0.8 and increment by 0.01 every 5000 conflicts until
     * 0.95. This "hack" seems to work well and comes from:
     * Glucose 2.3 in the SAT 2013 Competition - SAT Competition 2013
     * http://edacc4.informatik.uni-ulm.de/SC13/solver-description-download/136
     * </pre>
     *
     * <code>optional double glucose_max_decay = 22 [default = 0.95];</code>
     * @param value The glucoseMaxDecay to set.
     * @return This builder for chaining.
     */
    public Builder setGlucoseMaxDecay(double value) {
      bitField0_ |= 0x02000000;
      glucoseMaxDecay_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The activity starts at 0.8 and increment by 0.01 every 5000 conflicts until
     * 0.95. This "hack" seems to work well and comes from:
     * Glucose 2.3 in the SAT 2013 Competition - SAT Competition 2013
     * http://edacc4.informatik.uni-ulm.de/SC13/solver-description-download/136
     * </pre>
     *
     * <code>optional double glucose_max_decay = 22 [default = 0.95];</code>
     * @return This builder for chaining.
     */
    public Builder clearGlucoseMaxDecay() {
      bitField0_ = (bitField0_ & ~0x02000000);
      glucoseMaxDecay_ = 0.95D;
      onChanged();
      return this;
    }

    private double glucoseDecayIncrement_ = 0.01D;
    /**
     * <code>optional double glucose_decay_increment = 23 [default = 0.01];</code>
     * @return Whether the glucoseDecayIncrement field is set.
     */
    @java.lang.Override
    public boolean hasGlucoseDecayIncrement() {
      return ((bitField0_ & 0x04000000) != 0);
    }
    /**
     * <code>optional double glucose_decay_increment = 23 [default = 0.01];</code>
     * @return The glucoseDecayIncrement.
     */
    @java.lang.Override
    public double getGlucoseDecayIncrement() {
      return glucoseDecayIncrement_;
    }
    /**
     * <code>optional double glucose_decay_increment = 23 [default = 0.01];</code>
     * @param value The glucoseDecayIncrement to set.
     * @return This builder for chaining.
     */
    public Builder setGlucoseDecayIncrement(double value) {
      bitField0_ |= 0x04000000;
      glucoseDecayIncrement_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional double glucose_decay_increment = 23 [default = 0.01];</code>
     * @return This builder for chaining.
     */
    public Builder clearGlucoseDecayIncrement() {
      bitField0_ = (bitField0_ & ~0x04000000);
      glucoseDecayIncrement_ = 0.01D;
      onChanged();
      return this;
    }

    private int glucoseDecayIncrementPeriod_ = 5000;
    /**
     * <code>optional int32 glucose_decay_increment_period = 24 [default = 5000];</code>
     * @return Whether the glucoseDecayIncrementPeriod field is set.
     */
    @java.lang.Override
    public boolean hasGlucoseDecayIncrementPeriod() {
      return ((bitField0_ & 0x08000000) != 0);
    }
    /**
     * <code>optional int32 glucose_decay_increment_period = 24 [default = 5000];</code>
     * @return The glucoseDecayIncrementPeriod.
     */
    @java.lang.Override
    public int getGlucoseDecayIncrementPeriod() {
      return glucoseDecayIncrementPeriod_;
    }
    /**
     * <code>optional int32 glucose_decay_increment_period = 24 [default = 5000];</code>
     * @param value The glucoseDecayIncrementPeriod to set.
     * @return This builder for chaining.
     */
    public Builder setGlucoseDecayIncrementPeriod(int value) {
      bitField0_ |= 0x08000000;
      glucoseDecayIncrementPeriod_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional int32 glucose_decay_increment_period = 24 [default = 5000];</code>
     * @return This builder for chaining.
     */
    public Builder clearGlucoseDecayIncrementPeriod() {
      bitField0_ = (bitField0_ & ~0x08000000);
      glucoseDecayIncrementPeriod_ = 5000;
      onChanged();
      return this;
    }

    private double clauseActivityDecay_ = 0.999D;
    /**
     * <pre>
     * Clause activity parameters (same effect as the one on the variables).
     * </pre>
     *
     * <code>optional double clause_activity_decay = 17 [default = 0.999];</code>
     * @return Whether the clauseActivityDecay field is set.
     */
    @java.lang.Override
    public boolean hasClauseActivityDecay() {
      return ((bitField0_ & 0x10000000) != 0);
    }
    /**
     * <pre>
     * Clause activity parameters (same effect as the one on the variables).
     * </pre>
     *
     * <code>optional double clause_activity_decay = 17 [default = 0.999];</code>
     * @return The clauseActivityDecay.
     */
    @java.lang.Override
    public double getClauseActivityDecay() {
      return clauseActivityDecay_;
    }
    /**
     * <pre>
     * Clause activity parameters (same effect as the one on the variables).
     * </pre>
     *
     * <code>optional double clause_activity_decay = 17 [default = 0.999];</code>
     * @param value The clauseActivityDecay to set.
     * @return This builder for chaining.
     */
    public Builder setClauseActivityDecay(double value) {
      bitField0_ |= 0x10000000;
      clauseActivityDecay_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Clause activity parameters (same effect as the one on the variables).
     * </pre>
     *
     * <code>optional double clause_activity_decay = 17 [default = 0.999];</code>
     * @return This builder for chaining.
     */
    public Builder clearClauseActivityDecay() {
      bitField0_ = (bitField0_ & ~0x10000000);
      clauseActivityDecay_ = 0.999D;
      onChanged();
      return this;
    }

    private double maxClauseActivityValue_ = 1e+20D;
    /**
     * <code>optional double max_clause_activity_value = 18 [default = 1e+20];</code>
     * @return Whether the maxClauseActivityValue field is set.
     */
    @java.lang.Override
    public boolean hasMaxClauseActivityValue() {
      return ((bitField0_ & 0x20000000) != 0);
    }
    /**
     * <code>optional double max_clause_activity_value = 18 [default = 1e+20];</code>
     * @return The maxClauseActivityValue.
     */
    @java.lang.Override
    public double getMaxClauseActivityValue() {
      return maxClauseActivityValue_;
    }
    /**
     * <code>optional double max_clause_activity_value = 18 [default = 1e+20];</code>
     * @param value The maxClauseActivityValue to set.
     * @return This builder for chaining.
     */
    public Builder setMaxClauseActivityValue(double value) {
      bitField0_ |= 0x20000000;
      maxClauseActivityValue_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional double max_clause_activity_value = 18 [default = 1e+20];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxClauseActivityValue() {
      bitField0_ = (bitField0_ & ~0x20000000);
      maxClauseActivityValue_ = 1e+20D;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> restartAlgorithms_ =
      java.util.Collections.emptyList();
    private void ensureRestartAlgorithmsIsMutable() {
      if (!((bitField0_ & 0x40000000) != 0)) {
        restartAlgorithms_ = new java.util.ArrayList<java.lang.Integer>(restartAlgorithms_);
        bitField0_ |= 0x40000000;
      }
    }
    /**
     * <pre>
     * The restart strategies will change each time the strategy_counter is
     * increased. The current strategy will simply be the one at index
     * strategy_counter modulo the number of strategy. Note that if this list
     * includes a NO_RESTART, nothing will change when it is reached because the
     * strategy_counter will only increment after a restart.
     * The idea of switching of search strategy tailored for SAT/UNSAT comes from
     * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
     * But more generally, it seems REALLY beneficial to try different strategy.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
     * @return A list containing the restartAlgorithms.
     */
    public java.util.List<com.google.ortools.sat.SatParameters.RestartAlgorithm> getRestartAlgorithmsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.ortools.sat.SatParameters.RestartAlgorithm>(restartAlgorithms_, restartAlgorithms_converter_);
    }
    /**
     * <pre>
     * The restart strategies will change each time the strategy_counter is
     * increased. The current strategy will simply be the one at index
     * strategy_counter modulo the number of strategy. Note that if this list
     * includes a NO_RESTART, nothing will change when it is reached because the
     * strategy_counter will only increment after a restart.
     * The idea of switching of search strategy tailored for SAT/UNSAT comes from
     * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
     * But more generally, it seems REALLY beneficial to try different strategy.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
     * @return The count of restartAlgorithms.
     */
    public int getRestartAlgorithmsCount() {
      return restartAlgorithms_.size();
    }
    /**
     * <pre>
     * The restart strategies will change each time the strategy_counter is
     * increased. The current strategy will simply be the one at index
     * strategy_counter modulo the number of strategy. Note that if this list
     * includes a NO_RESTART, nothing will change when it is reached because the
     * strategy_counter will only increment after a restart.
     * The idea of switching of search strategy tailored for SAT/UNSAT comes from
     * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
     * But more generally, it seems REALLY beneficial to try different strategy.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
     * @param index The index of the element to return.
     * @return The restartAlgorithms at the given index.
     */
    public com.google.ortools.sat.SatParameters.RestartAlgorithm getRestartAlgorithms(int index) {
      return restartAlgorithms_converter_.convert(restartAlgorithms_.get(index));
    }
    /**
     * <pre>
     * The restart strategies will change each time the strategy_counter is
     * increased. The current strategy will simply be the one at index
     * strategy_counter modulo the number of strategy. Note that if this list
     * includes a NO_RESTART, nothing will change when it is reached because the
     * strategy_counter will only increment after a restart.
     * The idea of switching of search strategy tailored for SAT/UNSAT comes from
     * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
     * But more generally, it seems REALLY beneficial to try different strategy.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
     * @param index The index to set the value at.
     * @param value The restartAlgorithms to set.
     * @return This builder for chaining.
     */
    public Builder setRestartAlgorithms(
        int index, com.google.ortools.sat.SatParameters.RestartAlgorithm value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRestartAlgorithmsIsMutable();
      restartAlgorithms_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The restart strategies will change each time the strategy_counter is
     * increased. The current strategy will simply be the one at index
     * strategy_counter modulo the number of strategy. Note that if this list
     * includes a NO_RESTART, nothing will change when it is reached because the
     * strategy_counter will only increment after a restart.
     * The idea of switching of search strategy tailored for SAT/UNSAT comes from
     * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
     * But more generally, it seems REALLY beneficial to try different strategy.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
     * @param value The restartAlgorithms to add.
     * @return This builder for chaining.
     */
    public Builder addRestartAlgorithms(com.google.ortools.sat.SatParameters.RestartAlgorithm value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRestartAlgorithmsIsMutable();
      restartAlgorithms_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The restart strategies will change each time the strategy_counter is
     * increased. The current strategy will simply be the one at index
     * strategy_counter modulo the number of strategy. Note that if this list
     * includes a NO_RESTART, nothing will change when it is reached because the
     * strategy_counter will only increment after a restart.
     * The idea of switching of search strategy tailored for SAT/UNSAT comes from
     * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
     * But more generally, it seems REALLY beneficial to try different strategy.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
     * @param values The restartAlgorithms to add.
     * @return This builder for chaining.
     */
    public Builder addAllRestartAlgorithms(
        java.lang.Iterable<? extends com.google.ortools.sat.SatParameters.RestartAlgorithm> values) {
      ensureRestartAlgorithmsIsMutable();
      for (com.google.ortools.sat.SatParameters.RestartAlgorithm value : values) {
        restartAlgorithms_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The restart strategies will change each time the strategy_counter is
     * increased. The current strategy will simply be the one at index
     * strategy_counter modulo the number of strategy. Note that if this list
     * includes a NO_RESTART, nothing will change when it is reached because the
     * strategy_counter will only increment after a restart.
     * The idea of switching of search strategy tailored for SAT/UNSAT comes from
     * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
     * But more generally, it seems REALLY beneficial to try different strategy.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
     * @return This builder for chaining.
     */
    public Builder clearRestartAlgorithms() {
      restartAlgorithms_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x40000000);
      onChanged();
      return this;
    }

    private java.lang.Object defaultRestartAlgorithms_ = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART";
    /**
     * <code>optional string default_restart_algorithms = 70 [default = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART"];</code>
     * @return Whether the defaultRestartAlgorithms field is set.
     */
    public boolean hasDefaultRestartAlgorithms() {
      return ((bitField0_ & 0x80000000) != 0);
    }
    /**
     * <code>optional string default_restart_algorithms = 70 [default = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART"];</code>
     * @return The defaultRestartAlgorithms.
     */
    public java.lang.String getDefaultRestartAlgorithms() {
      java.lang.Object ref = defaultRestartAlgorithms_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          defaultRestartAlgorithms_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <code>optional string default_restart_algorithms = 70 [default = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART"];</code>
     * @return The bytes for defaultRestartAlgorithms.
     */
    public com.google.protobuf.ByteString
        getDefaultRestartAlgorithmsBytes() {
      java.lang.Object ref = defaultRestartAlgorithms_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        defaultRestartAlgorithms_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <code>optional string default_restart_algorithms = 70 [default = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART"];</code>
     * @param value The defaultRestartAlgorithms to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultRestartAlgorithms(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x80000000;
      defaultRestartAlgorithms_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional string default_restart_algorithms = 70 [default = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART"];</code>
     * @return This builder for chaining.
     */
    public Builder clearDefaultRestartAlgorithms() {
      bitField0_ = (bitField0_ & ~0x80000000);
      defaultRestartAlgorithms_ = getDefaultInstance().getDefaultRestartAlgorithms();
      onChanged();
      return this;
    }
    /**
     * <code>optional string default_restart_algorithms = 70 [default = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART"];</code>
     * @param value The bytes for defaultRestartAlgorithms to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultRestartAlgorithmsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x80000000;
      defaultRestartAlgorithms_ = value;
      onChanged();
      return this;
    }

    private int restartPeriod_ = 50;
    /**
     * <pre>
     * Restart period for the FIXED_RESTART strategy. This is also the multiplier
     * used by the LUBY_RESTART strategy.
     * </pre>
     *
     * <code>optional int32 restart_period = 30 [default = 50];</code>
     * @return Whether the restartPeriod field is set.
     */
    @java.lang.Override
    public boolean hasRestartPeriod() {
      return ((bitField1_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Restart period for the FIXED_RESTART strategy. This is also the multiplier
     * used by the LUBY_RESTART strategy.
     * </pre>
     *
     * <code>optional int32 restart_period = 30 [default = 50];</code>
     * @return The restartPeriod.
     */
    @java.lang.Override
    public int getRestartPeriod() {
      return restartPeriod_;
    }
    /**
     * <pre>
     * Restart period for the FIXED_RESTART strategy. This is also the multiplier
     * used by the LUBY_RESTART strategy.
     * </pre>
     *
     * <code>optional int32 restart_period = 30 [default = 50];</code>
     * @param value The restartPeriod to set.
     * @return This builder for chaining.
     */
    public Builder setRestartPeriod(int value) {
      bitField1_ |= 0x00000001;
      restartPeriod_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Restart period for the FIXED_RESTART strategy. This is also the multiplier
     * used by the LUBY_RESTART strategy.
     * </pre>
     *
     * <code>optional int32 restart_period = 30 [default = 50];</code>
     * @return This builder for chaining.
     */
    public Builder clearRestartPeriod() {
      bitField1_ = (bitField1_ & ~0x00000001);
      restartPeriod_ = 50;
      onChanged();
      return this;
    }

    private int restartRunningWindowSize_ = 50;
    /**
     * <pre>
     * Size of the window for the moving average restarts.
     * </pre>
     *
     * <code>optional int32 restart_running_window_size = 62 [default = 50];</code>
     * @return Whether the restartRunningWindowSize field is set.
     */
    @java.lang.Override
    public boolean hasRestartRunningWindowSize() {
      return ((bitField1_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Size of the window for the moving average restarts.
     * </pre>
     *
     * <code>optional int32 restart_running_window_size = 62 [default = 50];</code>
     * @return The restartRunningWindowSize.
     */
    @java.lang.Override
    public int getRestartRunningWindowSize() {
      return restartRunningWindowSize_;
    }
    /**
     * <pre>
     * Size of the window for the moving average restarts.
     * </pre>
     *
     * <code>optional int32 restart_running_window_size = 62 [default = 50];</code>
     * @param value The restartRunningWindowSize to set.
     * @return This builder for chaining.
     */
    public Builder setRestartRunningWindowSize(int value) {
      bitField1_ |= 0x00000002;
      restartRunningWindowSize_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Size of the window for the moving average restarts.
     * </pre>
     *
     * <code>optional int32 restart_running_window_size = 62 [default = 50];</code>
     * @return This builder for chaining.
     */
    public Builder clearRestartRunningWindowSize() {
      bitField1_ = (bitField1_ & ~0x00000002);
      restartRunningWindowSize_ = 50;
      onChanged();
      return this;
    }

    private double restartDlAverageRatio_ = 1D;
    /**
     * <pre>
     * In the moving average restart algorithms, a restart is triggered if the
     * window average times this ratio is greater that the global average.
     * </pre>
     *
     * <code>optional double restart_dl_average_ratio = 63 [default = 1];</code>
     * @return Whether the restartDlAverageRatio field is set.
     */
    @java.lang.Override
    public boolean hasRestartDlAverageRatio() {
      return ((bitField1_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * In the moving average restart algorithms, a restart is triggered if the
     * window average times this ratio is greater that the global average.
     * </pre>
     *
     * <code>optional double restart_dl_average_ratio = 63 [default = 1];</code>
     * @return The restartDlAverageRatio.
     */
    @java.lang.Override
    public double getRestartDlAverageRatio() {
      return restartDlAverageRatio_;
    }
    /**
     * <pre>
     * In the moving average restart algorithms, a restart is triggered if the
     * window average times this ratio is greater that the global average.
     * </pre>
     *
     * <code>optional double restart_dl_average_ratio = 63 [default = 1];</code>
     * @param value The restartDlAverageRatio to set.
     * @return This builder for chaining.
     */
    public Builder setRestartDlAverageRatio(double value) {
      bitField1_ |= 0x00000004;
      restartDlAverageRatio_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * In the moving average restart algorithms, a restart is triggered if the
     * window average times this ratio is greater that the global average.
     * </pre>
     *
     * <code>optional double restart_dl_average_ratio = 63 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearRestartDlAverageRatio() {
      bitField1_ = (bitField1_ & ~0x00000004);
      restartDlAverageRatio_ = 1D;
      onChanged();
      return this;
    }

    private double restartLbdAverageRatio_ = 1D;
    /**
     * <code>optional double restart_lbd_average_ratio = 71 [default = 1];</code>
     * @return Whether the restartLbdAverageRatio field is set.
     */
    @java.lang.Override
    public boolean hasRestartLbdAverageRatio() {
      return ((bitField1_ & 0x00000008) != 0);
    }
    /**
     * <code>optional double restart_lbd_average_ratio = 71 [default = 1];</code>
     * @return The restartLbdAverageRatio.
     */
    @java.lang.Override
    public double getRestartLbdAverageRatio() {
      return restartLbdAverageRatio_;
    }
    /**
     * <code>optional double restart_lbd_average_ratio = 71 [default = 1];</code>
     * @param value The restartLbdAverageRatio to set.
     * @return This builder for chaining.
     */
    public Builder setRestartLbdAverageRatio(double value) {
      bitField1_ |= 0x00000008;
      restartLbdAverageRatio_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional double restart_lbd_average_ratio = 71 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearRestartLbdAverageRatio() {
      bitField1_ = (bitField1_ & ~0x00000008);
      restartLbdAverageRatio_ = 1D;
      onChanged();
      return this;
    }

    private boolean useBlockingRestart_ ;
    /**
     * <pre>
     * Block a moving restart algorithm if the trail size of the current conflict
     * is greater than the multiplier times the moving average of the trail size
     * at the previous conflicts.
     * </pre>
     *
     * <code>optional bool use_blocking_restart = 64 [default = false];</code>
     * @return Whether the useBlockingRestart field is set.
     */
    @java.lang.Override
    public boolean hasUseBlockingRestart() {
      return ((bitField1_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * Block a moving restart algorithm if the trail size of the current conflict
     * is greater than the multiplier times the moving average of the trail size
     * at the previous conflicts.
     * </pre>
     *
     * <code>optional bool use_blocking_restart = 64 [default = false];</code>
     * @return The useBlockingRestart.
     */
    @java.lang.Override
    public boolean getUseBlockingRestart() {
      return useBlockingRestart_;
    }
    /**
     * <pre>
     * Block a moving restart algorithm if the trail size of the current conflict
     * is greater than the multiplier times the moving average of the trail size
     * at the previous conflicts.
     * </pre>
     *
     * <code>optional bool use_blocking_restart = 64 [default = false];</code>
     * @param value The useBlockingRestart to set.
     * @return This builder for chaining.
     */
    public Builder setUseBlockingRestart(boolean value) {
      bitField1_ |= 0x00000010;
      useBlockingRestart_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Block a moving restart algorithm if the trail size of the current conflict
     * is greater than the multiplier times the moving average of the trail size
     * at the previous conflicts.
     * </pre>
     *
     * <code>optional bool use_blocking_restart = 64 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseBlockingRestart() {
      bitField1_ = (bitField1_ & ~0x00000010);
      useBlockingRestart_ = false;
      onChanged();
      return this;
    }

    private int blockingRestartWindowSize_ = 5000;
    /**
     * <code>optional int32 blocking_restart_window_size = 65 [default = 5000];</code>
     * @return Whether the blockingRestartWindowSize field is set.
     */
    @java.lang.Override
    public boolean hasBlockingRestartWindowSize() {
      return ((bitField1_ & 0x00000020) != 0);
    }
    /**
     * <code>optional int32 blocking_restart_window_size = 65 [default = 5000];</code>
     * @return The blockingRestartWindowSize.
     */
    @java.lang.Override
    public int getBlockingRestartWindowSize() {
      return blockingRestartWindowSize_;
    }
    /**
     * <code>optional int32 blocking_restart_window_size = 65 [default = 5000];</code>
     * @param value The blockingRestartWindowSize to set.
     * @return This builder for chaining.
     */
    public Builder setBlockingRestartWindowSize(int value) {
      bitField1_ |= 0x00000020;
      blockingRestartWindowSize_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional int32 blocking_restart_window_size = 65 [default = 5000];</code>
     * @return This builder for chaining.
     */
    public Builder clearBlockingRestartWindowSize() {
      bitField1_ = (bitField1_ & ~0x00000020);
      blockingRestartWindowSize_ = 5000;
      onChanged();
      return this;
    }

    private double blockingRestartMultiplier_ = 1.4D;
    /**
     * <code>optional double blocking_restart_multiplier = 66 [default = 1.4];</code>
     * @return Whether the blockingRestartMultiplier field is set.
     */
    @java.lang.Override
    public boolean hasBlockingRestartMultiplier() {
      return ((bitField1_ & 0x00000040) != 0);
    }
    /**
     * <code>optional double blocking_restart_multiplier = 66 [default = 1.4];</code>
     * @return The blockingRestartMultiplier.
     */
    @java.lang.Override
    public double getBlockingRestartMultiplier() {
      return blockingRestartMultiplier_;
    }
    /**
     * <code>optional double blocking_restart_multiplier = 66 [default = 1.4];</code>
     * @param value The blockingRestartMultiplier to set.
     * @return This builder for chaining.
     */
    public Builder setBlockingRestartMultiplier(double value) {
      bitField1_ |= 0x00000040;
      blockingRestartMultiplier_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional double blocking_restart_multiplier = 66 [default = 1.4];</code>
     * @return This builder for chaining.
     */
    public Builder clearBlockingRestartMultiplier() {
      bitField1_ = (bitField1_ & ~0x00000040);
      blockingRestartMultiplier_ = 1.4D;
      onChanged();
      return this;
    }

    private int numConflictsBeforeStrategyChanges_ ;
    /**
     * <pre>
     * After each restart, if the number of conflict since the last strategy
     * change is greater that this, then we increment a "strategy_counter" that
     * can be use to change the search strategy used by the following restarts.
     * </pre>
     *
     * <code>optional int32 num_conflicts_before_strategy_changes = 68 [default = 0];</code>
     * @return Whether the numConflictsBeforeStrategyChanges field is set.
     */
    @java.lang.Override
    public boolean hasNumConflictsBeforeStrategyChanges() {
      return ((bitField1_ & 0x00000080) != 0);
    }
    /**
     * <pre>
     * After each restart, if the number of conflict since the last strategy
     * change is greater that this, then we increment a "strategy_counter" that
     * can be use to change the search strategy used by the following restarts.
     * </pre>
     *
     * <code>optional int32 num_conflicts_before_strategy_changes = 68 [default = 0];</code>
     * @return The numConflictsBeforeStrategyChanges.
     */
    @java.lang.Override
    public int getNumConflictsBeforeStrategyChanges() {
      return numConflictsBeforeStrategyChanges_;
    }
    /**
     * <pre>
     * After each restart, if the number of conflict since the last strategy
     * change is greater that this, then we increment a "strategy_counter" that
     * can be use to change the search strategy used by the following restarts.
     * </pre>
     *
     * <code>optional int32 num_conflicts_before_strategy_changes = 68 [default = 0];</code>
     * @param value The numConflictsBeforeStrategyChanges to set.
     * @return This builder for chaining.
     */
    public Builder setNumConflictsBeforeStrategyChanges(int value) {
      bitField1_ |= 0x00000080;
      numConflictsBeforeStrategyChanges_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * After each restart, if the number of conflict since the last strategy
     * change is greater that this, then we increment a "strategy_counter" that
     * can be use to change the search strategy used by the following restarts.
     * </pre>
     *
     * <code>optional int32 num_conflicts_before_strategy_changes = 68 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearNumConflictsBeforeStrategyChanges() {
      bitField1_ = (bitField1_ & ~0x00000080);
      numConflictsBeforeStrategyChanges_ = 0;
      onChanged();
      return this;
    }

    private double strategyChangeIncreaseRatio_ ;
    /**
     * <pre>
     * The parameter num_conflicts_before_strategy_changes is increased by that
     * much after each strategy change.
     * </pre>
     *
     * <code>optional double strategy_change_increase_ratio = 69 [default = 0];</code>
     * @return Whether the strategyChangeIncreaseRatio field is set.
     */
    @java.lang.Override
    public boolean hasStrategyChangeIncreaseRatio() {
      return ((bitField1_ & 0x00000100) != 0);
    }
    /**
     * <pre>
     * The parameter num_conflicts_before_strategy_changes is increased by that
     * much after each strategy change.
     * </pre>
     *
     * <code>optional double strategy_change_increase_ratio = 69 [default = 0];</code>
     * @return The strategyChangeIncreaseRatio.
     */
    @java.lang.Override
    public double getStrategyChangeIncreaseRatio() {
      return strategyChangeIncreaseRatio_;
    }
    /**
     * <pre>
     * The parameter num_conflicts_before_strategy_changes is increased by that
     * much after each strategy change.
     * </pre>
     *
     * <code>optional double strategy_change_increase_ratio = 69 [default = 0];</code>
     * @param value The strategyChangeIncreaseRatio to set.
     * @return This builder for chaining.
     */
    public Builder setStrategyChangeIncreaseRatio(double value) {
      bitField1_ |= 0x00000100;
      strategyChangeIncreaseRatio_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The parameter num_conflicts_before_strategy_changes is increased by that
     * much after each strategy change.
     * </pre>
     *
     * <code>optional double strategy_change_increase_ratio = 69 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearStrategyChangeIncreaseRatio() {
      bitField1_ = (bitField1_ & ~0x00000100);
      strategyChangeIncreaseRatio_ = 0D;
      onChanged();
      return this;
    }

    private double maxTimeInSeconds_ = Double.POSITIVE_INFINITY;
    /**
     * <pre>
     * Maximum time allowed in seconds to solve a problem.
     * The counter will starts at the beginning of the Solve() call.
     * </pre>
     *
     * <code>optional double max_time_in_seconds = 36 [default = inf];</code>
     * @return Whether the maxTimeInSeconds field is set.
     */
    @java.lang.Override
    public boolean hasMaxTimeInSeconds() {
      return ((bitField1_ & 0x00000200) != 0);
    }
    /**
     * <pre>
     * Maximum time allowed in seconds to solve a problem.
     * The counter will starts at the beginning of the Solve() call.
     * </pre>
     *
     * <code>optional double max_time_in_seconds = 36 [default = inf];</code>
     * @return The maxTimeInSeconds.
     */
    @java.lang.Override
    public double getMaxTimeInSeconds() {
      return maxTimeInSeconds_;
    }
    /**
     * <pre>
     * Maximum time allowed in seconds to solve a problem.
     * The counter will starts at the beginning of the Solve() call.
     * </pre>
     *
     * <code>optional double max_time_in_seconds = 36 [default = inf];</code>
     * @param value The maxTimeInSeconds to set.
     * @return This builder for chaining.
     */
    public Builder setMaxTimeInSeconds(double value) {
      bitField1_ |= 0x00000200;
      maxTimeInSeconds_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Maximum time allowed in seconds to solve a problem.
     * The counter will starts at the beginning of the Solve() call.
     * </pre>
     *
     * <code>optional double max_time_in_seconds = 36 [default = inf];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxTimeInSeconds() {
      bitField1_ = (bitField1_ & ~0x00000200);
      maxTimeInSeconds_ = Double.POSITIVE_INFINITY;
      onChanged();
      return this;
    }

    private double maxDeterministicTime_ = Double.POSITIVE_INFINITY;
    /**
     * <pre>
     * Maximum time allowed in deterministic time to solve a problem.
     * The deterministic time should be correlated with the real time used by the
     * solver, the time unit being as close as possible to a second.
     * </pre>
     *
     * <code>optional double max_deterministic_time = 67 [default = inf];</code>
     * @return Whether the maxDeterministicTime field is set.
     */
    @java.lang.Override
    public boolean hasMaxDeterministicTime() {
      return ((bitField1_ & 0x00000400) != 0);
    }
    /**
     * <pre>
     * Maximum time allowed in deterministic time to solve a problem.
     * The deterministic time should be correlated with the real time used by the
     * solver, the time unit being as close as possible to a second.
     * </pre>
     *
     * <code>optional double max_deterministic_time = 67 [default = inf];</code>
     * @return The maxDeterministicTime.
     */
    @java.lang.Override
    public double getMaxDeterministicTime() {
      return maxDeterministicTime_;
    }
    /**
     * <pre>
     * Maximum time allowed in deterministic time to solve a problem.
     * The deterministic time should be correlated with the real time used by the
     * solver, the time unit being as close as possible to a second.
     * </pre>
     *
     * <code>optional double max_deterministic_time = 67 [default = inf];</code>
     * @param value The maxDeterministicTime to set.
     * @return This builder for chaining.
     */
    public Builder setMaxDeterministicTime(double value) {
      bitField1_ |= 0x00000400;
      maxDeterministicTime_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Maximum time allowed in deterministic time to solve a problem.
     * The deterministic time should be correlated with the real time used by the
     * solver, the time unit being as close as possible to a second.
     * </pre>
     *
     * <code>optional double max_deterministic_time = 67 [default = inf];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxDeterministicTime() {
      bitField1_ = (bitField1_ & ~0x00000400);
      maxDeterministicTime_ = Double.POSITIVE_INFINITY;
      onChanged();
      return this;
    }

    private long maxNumberOfConflicts_ = 9223372036854775807L;
    /**
     * <pre>
     * Maximum number of conflicts allowed to solve a problem.
     * TODO(user,user): Maybe change the way the conflict limit is enforced?
     * currently it is enforced on each independent internal SAT solve, rather
     * than on the overall number of conflicts across all solves. So in the
     * context of an optimization problem, this is not really usable directly by a
     * client.
     * </pre>
     *
     * <code>optional int64 max_number_of_conflicts = 37 [default = 9223372036854775807];</code>
     * @return Whether the maxNumberOfConflicts field is set.
     */
    @java.lang.Override
    public boolean hasMaxNumberOfConflicts() {
      return ((bitField1_ & 0x00000800) != 0);
    }
    /**
     * <pre>
     * Maximum number of conflicts allowed to solve a problem.
     * TODO(user,user): Maybe change the way the conflict limit is enforced?
     * currently it is enforced on each independent internal SAT solve, rather
     * than on the overall number of conflicts across all solves. So in the
     * context of an optimization problem, this is not really usable directly by a
     * client.
     * </pre>
     *
     * <code>optional int64 max_number_of_conflicts = 37 [default = 9223372036854775807];</code>
     * @return The maxNumberOfConflicts.
     */
    @java.lang.Override
    public long getMaxNumberOfConflicts() {
      return maxNumberOfConflicts_;
    }
    /**
     * <pre>
     * Maximum number of conflicts allowed to solve a problem.
     * TODO(user,user): Maybe change the way the conflict limit is enforced?
     * currently it is enforced on each independent internal SAT solve, rather
     * than on the overall number of conflicts across all solves. So in the
     * context of an optimization problem, this is not really usable directly by a
     * client.
     * </pre>
     *
     * <code>optional int64 max_number_of_conflicts = 37 [default = 9223372036854775807];</code>
     * @param value The maxNumberOfConflicts to set.
     * @return This builder for chaining.
     */
    public Builder setMaxNumberOfConflicts(long value) {
      bitField1_ |= 0x00000800;
      maxNumberOfConflicts_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Maximum number of conflicts allowed to solve a problem.
     * TODO(user,user): Maybe change the way the conflict limit is enforced?
     * currently it is enforced on each independent internal SAT solve, rather
     * than on the overall number of conflicts across all solves. So in the
     * context of an optimization problem, this is not really usable directly by a
     * client.
     * </pre>
     *
     * <code>optional int64 max_number_of_conflicts = 37 [default = 9223372036854775807];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxNumberOfConflicts() {
      bitField1_ = (bitField1_ & ~0x00000800);
      maxNumberOfConflicts_ = 9223372036854775807L;
      onChanged();
      return this;
    }

    private long maxMemoryInMb_ = 10000L;
    /**
     * <pre>
     * Maximum memory allowed for the whole thread containing the solver. The
     * solver will abort as soon as it detects that this limit is crossed. As a
     * result, this limit is approximative, but usually the solver will not go too
     * much over.
     * </pre>
     *
     * <code>optional int64 max_memory_in_mb = 40 [default = 10000];</code>
     * @return Whether the maxMemoryInMb field is set.
     */
    @java.lang.Override
    public boolean hasMaxMemoryInMb() {
      return ((bitField1_ & 0x00001000) != 0);
    }
    /**
     * <pre>
     * Maximum memory allowed for the whole thread containing the solver. The
     * solver will abort as soon as it detects that this limit is crossed. As a
     * result, this limit is approximative, but usually the solver will not go too
     * much over.
     * </pre>
     *
     * <code>optional int64 max_memory_in_mb = 40 [default = 10000];</code>
     * @return The maxMemoryInMb.
     */
    @java.lang.Override
    public long getMaxMemoryInMb() {
      return maxMemoryInMb_;
    }
    /**
     * <pre>
     * Maximum memory allowed for the whole thread containing the solver. The
     * solver will abort as soon as it detects that this limit is crossed. As a
     * result, this limit is approximative, but usually the solver will not go too
     * much over.
     * </pre>
     *
     * <code>optional int64 max_memory_in_mb = 40 [default = 10000];</code>
     * @param value The maxMemoryInMb to set.
     * @return This builder for chaining.
     */
    public Builder setMaxMemoryInMb(long value) {
      bitField1_ |= 0x00001000;
      maxMemoryInMb_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Maximum memory allowed for the whole thread containing the solver. The
     * solver will abort as soon as it detects that this limit is crossed. As a
     * result, this limit is approximative, but usually the solver will not go too
     * much over.
     * </pre>
     *
     * <code>optional int64 max_memory_in_mb = 40 [default = 10000];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxMemoryInMb() {
      bitField1_ = (bitField1_ & ~0x00001000);
      maxMemoryInMb_ = 10000L;
      onChanged();
      return this;
    }

    private double absoluteGapLimit_ ;
    /**
     * <pre>
     * Stop the search when the gap between the best feasible objective (O) and
     * our best objective bound (B) is smaller than a limit.
     * The exact definition is:
     * - Absolute: abs(O - B)
     * - Relative: abs(O - B) / max(1, abs(O)).
     * Important: The relative gap depends on the objective offset! If you
     * artificially shift the objective, you will get widely different value of
     * the relative gap.
     * Note that if the gap is reached, the search status will be OPTIMAL. But
     * one can check the best objective bound to see the actual gap.
     * </pre>
     *
     * <code>optional double absolute_gap_limit = 159 [default = 0];</code>
     * @return Whether the absoluteGapLimit field is set.
     */
    @java.lang.Override
    public boolean hasAbsoluteGapLimit() {
      return ((bitField1_ & 0x00002000) != 0);
    }
    /**
     * <pre>
     * Stop the search when the gap between the best feasible objective (O) and
     * our best objective bound (B) is smaller than a limit.
     * The exact definition is:
     * - Absolute: abs(O - B)
     * - Relative: abs(O - B) / max(1, abs(O)).
     * Important: The relative gap depends on the objective offset! If you
     * artificially shift the objective, you will get widely different value of
     * the relative gap.
     * Note that if the gap is reached, the search status will be OPTIMAL. But
     * one can check the best objective bound to see the actual gap.
     * </pre>
     *
     * <code>optional double absolute_gap_limit = 159 [default = 0];</code>
     * @return The absoluteGapLimit.
     */
    @java.lang.Override
    public double getAbsoluteGapLimit() {
      return absoluteGapLimit_;
    }
    /**
     * <pre>
     * Stop the search when the gap between the best feasible objective (O) and
     * our best objective bound (B) is smaller than a limit.
     * The exact definition is:
     * - Absolute: abs(O - B)
     * - Relative: abs(O - B) / max(1, abs(O)).
     * Important: The relative gap depends on the objective offset! If you
     * artificially shift the objective, you will get widely different value of
     * the relative gap.
     * Note that if the gap is reached, the search status will be OPTIMAL. But
     * one can check the best objective bound to see the actual gap.
     * </pre>
     *
     * <code>optional double absolute_gap_limit = 159 [default = 0];</code>
     * @param value The absoluteGapLimit to set.
     * @return This builder for chaining.
     */
    public Builder setAbsoluteGapLimit(double value) {
      bitField1_ |= 0x00002000;
      absoluteGapLimit_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Stop the search when the gap between the best feasible objective (O) and
     * our best objective bound (B) is smaller than a limit.
     * The exact definition is:
     * - Absolute: abs(O - B)
     * - Relative: abs(O - B) / max(1, abs(O)).
     * Important: The relative gap depends on the objective offset! If you
     * artificially shift the objective, you will get widely different value of
     * the relative gap.
     * Note that if the gap is reached, the search status will be OPTIMAL. But
     * one can check the best objective bound to see the actual gap.
     * </pre>
     *
     * <code>optional double absolute_gap_limit = 159 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearAbsoluteGapLimit() {
      bitField1_ = (bitField1_ & ~0x00002000);
      absoluteGapLimit_ = 0D;
      onChanged();
      return this;
    }

    private double relativeGapLimit_ ;
    /**
     * <code>optional double relative_gap_limit = 160 [default = 0];</code>
     * @return Whether the relativeGapLimit field is set.
     */
    @java.lang.Override
    public boolean hasRelativeGapLimit() {
      return ((bitField1_ & 0x00004000) != 0);
    }
    /**
     * <code>optional double relative_gap_limit = 160 [default = 0];</code>
     * @return The relativeGapLimit.
     */
    @java.lang.Override
    public double getRelativeGapLimit() {
      return relativeGapLimit_;
    }
    /**
     * <code>optional double relative_gap_limit = 160 [default = 0];</code>
     * @param value The relativeGapLimit to set.
     * @return This builder for chaining.
     */
    public Builder setRelativeGapLimit(double value) {
      bitField1_ |= 0x00004000;
      relativeGapLimit_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional double relative_gap_limit = 160 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearRelativeGapLimit() {
      bitField1_ = (bitField1_ & ~0x00004000);
      relativeGapLimit_ = 0D;
      onChanged();
      return this;
    }

    private boolean treatBinaryClausesSeparately_ = true;
    /**
     * <pre>
     * If true, the binary clauses are treated separately from the others. This
     * should be faster and uses less memory. However it changes the propagation
     * order.
     * </pre>
     *
     * <code>optional bool treat_binary_clauses_separately = 33 [default = true];</code>
     * @return Whether the treatBinaryClausesSeparately field is set.
     */
    @java.lang.Override
    public boolean hasTreatBinaryClausesSeparately() {
      return ((bitField1_ & 0x00008000) != 0);
    }
    /**
     * <pre>
     * If true, the binary clauses are treated separately from the others. This
     * should be faster and uses less memory. However it changes the propagation
     * order.
     * </pre>
     *
     * <code>optional bool treat_binary_clauses_separately = 33 [default = true];</code>
     * @return The treatBinaryClausesSeparately.
     */
    @java.lang.Override
    public boolean getTreatBinaryClausesSeparately() {
      return treatBinaryClausesSeparately_;
    }
    /**
     * <pre>
     * If true, the binary clauses are treated separately from the others. This
     * should be faster and uses less memory. However it changes the propagation
     * order.
     * </pre>
     *
     * <code>optional bool treat_binary_clauses_separately = 33 [default = true];</code>
     * @param value The treatBinaryClausesSeparately to set.
     * @return This builder for chaining.
     */
    public Builder setTreatBinaryClausesSeparately(boolean value) {
      bitField1_ |= 0x00008000;
      treatBinaryClausesSeparately_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, the binary clauses are treated separately from the others. This
     * should be faster and uses less memory. However it changes the propagation
     * order.
     * </pre>
     *
     * <code>optional bool treat_binary_clauses_separately = 33 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearTreatBinaryClausesSeparately() {
      bitField1_ = (bitField1_ & ~0x00008000);
      treatBinaryClausesSeparately_ = true;
      onChanged();
      return this;
    }

    private int randomSeed_ = 1;
    /**
     * <pre>
     * At the beginning of each solve, the random number generator used in some
     * part of the solver is reinitialized to this seed. If you change the random
     * seed, the solver may make different choices during the solving process.
     * For some problems, the running time may vary a lot depending on small
     * change in the solving algorithm. Running the solver with different seeds
     * enables to have more robust benchmarks when evaluating new features.
     * </pre>
     *
     * <code>optional int32 random_seed = 31 [default = 1];</code>
     * @return Whether the randomSeed field is set.
     */
    @java.lang.Override
    public boolean hasRandomSeed() {
      return ((bitField1_ & 0x00010000) != 0);
    }
    /**
     * <pre>
     * At the beginning of each solve, the random number generator used in some
     * part of the solver is reinitialized to this seed. If you change the random
     * seed, the solver may make different choices during the solving process.
     * For some problems, the running time may vary a lot depending on small
     * change in the solving algorithm. Running the solver with different seeds
     * enables to have more robust benchmarks when evaluating new features.
     * </pre>
     *
     * <code>optional int32 random_seed = 31 [default = 1];</code>
     * @return The randomSeed.
     */
    @java.lang.Override
    public int getRandomSeed() {
      return randomSeed_;
    }
    /**
     * <pre>
     * At the beginning of each solve, the random number generator used in some
     * part of the solver is reinitialized to this seed. If you change the random
     * seed, the solver may make different choices during the solving process.
     * For some problems, the running time may vary a lot depending on small
     * change in the solving algorithm. Running the solver with different seeds
     * enables to have more robust benchmarks when evaluating new features.
     * </pre>
     *
     * <code>optional int32 random_seed = 31 [default = 1];</code>
     * @param value The randomSeed to set.
     * @return This builder for chaining.
     */
    public Builder setRandomSeed(int value) {
      bitField1_ |= 0x00010000;
      randomSeed_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * At the beginning of each solve, the random number generator used in some
     * part of the solver is reinitialized to this seed. If you change the random
     * seed, the solver may make different choices during the solving process.
     * For some problems, the running time may vary a lot depending on small
     * change in the solving algorithm. Running the solver with different seeds
     * enables to have more robust benchmarks when evaluating new features.
     * </pre>
     *
     * <code>optional int32 random_seed = 31 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearRandomSeed() {
      bitField1_ = (bitField1_ & ~0x00010000);
      randomSeed_ = 1;
      onChanged();
      return this;
    }

    private boolean permuteVariableRandomly_ ;
    /**
     * <pre>
     * This is mainly here to test the solver variability. Note that in tests, if
     * not explicitly set to false, all 3 options will be set to true so that
     * clients do not rely on the solver returning a specific solution if they are
     * many equivalent optimal solutions.
     * </pre>
     *
     * <code>optional bool permute_variable_randomly = 178 [default = false];</code>
     * @return Whether the permuteVariableRandomly field is set.
     */
    @java.lang.Override
    public boolean hasPermuteVariableRandomly() {
      return ((bitField1_ & 0x00020000) != 0);
    }
    /**
     * <pre>
     * This is mainly here to test the solver variability. Note that in tests, if
     * not explicitly set to false, all 3 options will be set to true so that
     * clients do not rely on the solver returning a specific solution if they are
     * many equivalent optimal solutions.
     * </pre>
     *
     * <code>optional bool permute_variable_randomly = 178 [default = false];</code>
     * @return The permuteVariableRandomly.
     */
    @java.lang.Override
    public boolean getPermuteVariableRandomly() {
      return permuteVariableRandomly_;
    }
    /**
     * <pre>
     * This is mainly here to test the solver variability. Note that in tests, if
     * not explicitly set to false, all 3 options will be set to true so that
     * clients do not rely on the solver returning a specific solution if they are
     * many equivalent optimal solutions.
     * </pre>
     *
     * <code>optional bool permute_variable_randomly = 178 [default = false];</code>
     * @param value The permuteVariableRandomly to set.
     * @return This builder for chaining.
     */
    public Builder setPermuteVariableRandomly(boolean value) {
      bitField1_ |= 0x00020000;
      permuteVariableRandomly_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * This is mainly here to test the solver variability. Note that in tests, if
     * not explicitly set to false, all 3 options will be set to true so that
     * clients do not rely on the solver returning a specific solution if they are
     * many equivalent optimal solutions.
     * </pre>
     *
     * <code>optional bool permute_variable_randomly = 178 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearPermuteVariableRandomly() {
      bitField1_ = (bitField1_ & ~0x00020000);
      permuteVariableRandomly_ = false;
      onChanged();
      return this;
    }

    private boolean permutePresolveConstraintOrder_ ;
    /**
     * <code>optional bool permute_presolve_constraint_order = 179 [default = false];</code>
     * @return Whether the permutePresolveConstraintOrder field is set.
     */
    @java.lang.Override
    public boolean hasPermutePresolveConstraintOrder() {
      return ((bitField1_ & 0x00040000) != 0);
    }
    /**
     * <code>optional bool permute_presolve_constraint_order = 179 [default = false];</code>
     * @return The permutePresolveConstraintOrder.
     */
    @java.lang.Override
    public boolean getPermutePresolveConstraintOrder() {
      return permutePresolveConstraintOrder_;
    }
    /**
     * <code>optional bool permute_presolve_constraint_order = 179 [default = false];</code>
     * @param value The permutePresolveConstraintOrder to set.
     * @return This builder for chaining.
     */
    public Builder setPermutePresolveConstraintOrder(boolean value) {
      bitField1_ |= 0x00040000;
      permutePresolveConstraintOrder_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional bool permute_presolve_constraint_order = 179 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearPermutePresolveConstraintOrder() {
      bitField1_ = (bitField1_ & ~0x00040000);
      permutePresolveConstraintOrder_ = false;
      onChanged();
      return this;
    }

    private boolean useAbslRandom_ ;
    /**
     * <code>optional bool use_absl_random = 180 [default = false];</code>
     * @return Whether the useAbslRandom field is set.
     */
    @java.lang.Override
    public boolean hasUseAbslRandom() {
      return ((bitField1_ & 0x00080000) != 0);
    }
    /**
     * <code>optional bool use_absl_random = 180 [default = false];</code>
     * @return The useAbslRandom.
     */
    @java.lang.Override
    public boolean getUseAbslRandom() {
      return useAbslRandom_;
    }
    /**
     * <code>optional bool use_absl_random = 180 [default = false];</code>
     * @param value The useAbslRandom to set.
     * @return This builder for chaining.
     */
    public Builder setUseAbslRandom(boolean value) {
      bitField1_ |= 0x00080000;
      useAbslRandom_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional bool use_absl_random = 180 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseAbslRandom() {
      bitField1_ = (bitField1_ & ~0x00080000);
      useAbslRandom_ = false;
      onChanged();
      return this;
    }

    private boolean logSearchProgress_ ;
    /**
     * <pre>
     * Whether the solver should log the search progress. By default, it logs to
     * LOG(INFO). This can be overwritten by the log_destination parameter.
     * </pre>
     *
     * <code>optional bool log_search_progress = 41 [default = false];</code>
     * @return Whether the logSearchProgress field is set.
     */
    @java.lang.Override
    public boolean hasLogSearchProgress() {
      return ((bitField1_ & 0x00100000) != 0);
    }
    /**
     * <pre>
     * Whether the solver should log the search progress. By default, it logs to
     * LOG(INFO). This can be overwritten by the log_destination parameter.
     * </pre>
     *
     * <code>optional bool log_search_progress = 41 [default = false];</code>
     * @return The logSearchProgress.
     */
    @java.lang.Override
    public boolean getLogSearchProgress() {
      return logSearchProgress_;
    }
    /**
     * <pre>
     * Whether the solver should log the search progress. By default, it logs to
     * LOG(INFO). This can be overwritten by the log_destination parameter.
     * </pre>
     *
     * <code>optional bool log_search_progress = 41 [default = false];</code>
     * @param value The logSearchProgress to set.
     * @return This builder for chaining.
     */
    public Builder setLogSearchProgress(boolean value) {
      bitField1_ |= 0x00100000;
      logSearchProgress_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether the solver should log the search progress. By default, it logs to
     * LOG(INFO). This can be overwritten by the log_destination parameter.
     * </pre>
     *
     * <code>optional bool log_search_progress = 41 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearLogSearchProgress() {
      bitField1_ = (bitField1_ & ~0x00100000);
      logSearchProgress_ = false;
      onChanged();
      return this;
    }

    private boolean logSubsolverStatistics_ = true;
    /**
     * <pre>
     * Whether the solver should display per sub-solver search statistics.
     * This is only useful is log_search_progress is set to true, and if the
     * number of search workers is &gt; 1.
     * </pre>
     *
     * <code>optional bool log_subsolver_statistics = 189 [default = true];</code>
     * @return Whether the logSubsolverStatistics field is set.
     */
    @java.lang.Override
    public boolean hasLogSubsolverStatistics() {
      return ((bitField1_ & 0x00200000) != 0);
    }
    /**
     * <pre>
     * Whether the solver should display per sub-solver search statistics.
     * This is only useful is log_search_progress is set to true, and if the
     * number of search workers is &gt; 1.
     * </pre>
     *
     * <code>optional bool log_subsolver_statistics = 189 [default = true];</code>
     * @return The logSubsolverStatistics.
     */
    @java.lang.Override
    public boolean getLogSubsolverStatistics() {
      return logSubsolverStatistics_;
    }
    /**
     * <pre>
     * Whether the solver should display per sub-solver search statistics.
     * This is only useful is log_search_progress is set to true, and if the
     * number of search workers is &gt; 1.
     * </pre>
     *
     * <code>optional bool log_subsolver_statistics = 189 [default = true];</code>
     * @param value The logSubsolverStatistics to set.
     * @return This builder for chaining.
     */
    public Builder setLogSubsolverStatistics(boolean value) {
      bitField1_ |= 0x00200000;
      logSubsolverStatistics_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether the solver should display per sub-solver search statistics.
     * This is only useful is log_search_progress is set to true, and if the
     * number of search workers is &gt; 1.
     * </pre>
     *
     * <code>optional bool log_subsolver_statistics = 189 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearLogSubsolverStatistics() {
      bitField1_ = (bitField1_ & ~0x00200000);
      logSubsolverStatistics_ = true;
      onChanged();
      return this;
    }

    private java.lang.Object logPrefix_ = "";
    /**
     * <pre>
     * Add a prefix to all logs.
     * </pre>
     *
     * <code>optional string log_prefix = 185 [default = ""];</code>
     * @return Whether the logPrefix field is set.
     */
    public boolean hasLogPrefix() {
      return ((bitField1_ & 0x00400000) != 0);
    }
    /**
     * <pre>
     * Add a prefix to all logs.
     * </pre>
     *
     * <code>optional string log_prefix = 185 [default = ""];</code>
     * @return The logPrefix.
     */
    public java.lang.String getLogPrefix() {
      java.lang.Object ref = logPrefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          logPrefix_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Add a prefix to all logs.
     * </pre>
     *
     * <code>optional string log_prefix = 185 [default = ""];</code>
     * @return The bytes for logPrefix.
     */
    public com.google.protobuf.ByteString
        getLogPrefixBytes() {
      java.lang.Object ref = logPrefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        logPrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Add a prefix to all logs.
     * </pre>
     *
     * <code>optional string log_prefix = 185 [default = ""];</code>
     * @param value The logPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setLogPrefix(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField1_ |= 0x00400000;
      logPrefix_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Add a prefix to all logs.
     * </pre>
     *
     * <code>optional string log_prefix = 185 [default = ""];</code>
     * @return This builder for chaining.
     */
    public Builder clearLogPrefix() {
      bitField1_ = (bitField1_ & ~0x00400000);
      logPrefix_ = getDefaultInstance().getLogPrefix();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Add a prefix to all logs.
     * </pre>
     *
     * <code>optional string log_prefix = 185 [default = ""];</code>
     * @param value The bytes for logPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setLogPrefixBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField1_ |= 0x00400000;
      logPrefix_ = value;
      onChanged();
      return this;
    }

    private boolean logToStdout_ = true;
    /**
     * <pre>
     * Log to stdout.
     * </pre>
     *
     * <code>optional bool log_to_stdout = 186 [default = true];</code>
     * @return Whether the logToStdout field is set.
     */
    @java.lang.Override
    public boolean hasLogToStdout() {
      return ((bitField1_ & 0x00800000) != 0);
    }
    /**
     * <pre>
     * Log to stdout.
     * </pre>
     *
     * <code>optional bool log_to_stdout = 186 [default = true];</code>
     * @return The logToStdout.
     */
    @java.lang.Override
    public boolean getLogToStdout() {
      return logToStdout_;
    }
    /**
     * <pre>
     * Log to stdout.
     * </pre>
     *
     * <code>optional bool log_to_stdout = 186 [default = true];</code>
     * @param value The logToStdout to set.
     * @return This builder for chaining.
     */
    public Builder setLogToStdout(boolean value) {
      bitField1_ |= 0x00800000;
      logToStdout_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Log to stdout.
     * </pre>
     *
     * <code>optional bool log_to_stdout = 186 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearLogToStdout() {
      bitField1_ = (bitField1_ & ~0x00800000);
      logToStdout_ = true;
      onChanged();
      return this;
    }

    private boolean logToResponse_ ;
    /**
     * <pre>
     * Log to response proto.
     * </pre>
     *
     * <code>optional bool log_to_response = 187 [default = false];</code>
     * @return Whether the logToResponse field is set.
     */
    @java.lang.Override
    public boolean hasLogToResponse() {
      return ((bitField1_ & 0x01000000) != 0);
    }
    /**
     * <pre>
     * Log to response proto.
     * </pre>
     *
     * <code>optional bool log_to_response = 187 [default = false];</code>
     * @return The logToResponse.
     */
    @java.lang.Override
    public boolean getLogToResponse() {
      return logToResponse_;
    }
    /**
     * <pre>
     * Log to response proto.
     * </pre>
     *
     * <code>optional bool log_to_response = 187 [default = false];</code>
     * @param value The logToResponse to set.
     * @return This builder for chaining.
     */
    public Builder setLogToResponse(boolean value) {
      bitField1_ |= 0x01000000;
      logToResponse_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Log to response proto.
     * </pre>
     *
     * <code>optional bool log_to_response = 187 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearLogToResponse() {
      bitField1_ = (bitField1_ & ~0x01000000);
      logToResponse_ = false;
      onChanged();
      return this;
    }

    private boolean usePbResolution_ ;
    /**
     * <pre>
     * Whether to use pseudo-Boolean resolution to analyze a conflict. Note that
     * this option only make sense if your problem is modelized using
     * pseudo-Boolean constraints. If you only have clauses, this shouldn't change
     * anything (except slow the solver down).
     * </pre>
     *
     * <code>optional bool use_pb_resolution = 43 [default = false];</code>
     * @return Whether the usePbResolution field is set.
     */
    @java.lang.Override
    public boolean hasUsePbResolution() {
      return ((bitField1_ & 0x02000000) != 0);
    }
    /**
     * <pre>
     * Whether to use pseudo-Boolean resolution to analyze a conflict. Note that
     * this option only make sense if your problem is modelized using
     * pseudo-Boolean constraints. If you only have clauses, this shouldn't change
     * anything (except slow the solver down).
     * </pre>
     *
     * <code>optional bool use_pb_resolution = 43 [default = false];</code>
     * @return The usePbResolution.
     */
    @java.lang.Override
    public boolean getUsePbResolution() {
      return usePbResolution_;
    }
    /**
     * <pre>
     * Whether to use pseudo-Boolean resolution to analyze a conflict. Note that
     * this option only make sense if your problem is modelized using
     * pseudo-Boolean constraints. If you only have clauses, this shouldn't change
     * anything (except slow the solver down).
     * </pre>
     *
     * <code>optional bool use_pb_resolution = 43 [default = false];</code>
     * @param value The usePbResolution to set.
     * @return This builder for chaining.
     */
    public Builder setUsePbResolution(boolean value) {
      bitField1_ |= 0x02000000;
      usePbResolution_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether to use pseudo-Boolean resolution to analyze a conflict. Note that
     * this option only make sense if your problem is modelized using
     * pseudo-Boolean constraints. If you only have clauses, this shouldn't change
     * anything (except slow the solver down).
     * </pre>
     *
     * <code>optional bool use_pb_resolution = 43 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUsePbResolution() {
      bitField1_ = (bitField1_ & ~0x02000000);
      usePbResolution_ = false;
      onChanged();
      return this;
    }

    private boolean minimizeReductionDuringPbResolution_ ;
    /**
     * <pre>
     * A different algorithm during PB resolution. It minimizes the number of
     * calls to ReduceCoefficients() which can be time consuming. However, the
     * search space will be different and if the coefficients are large, this may
     * lead to integer overflows that could otherwise be prevented.
     * </pre>
     *
     * <code>optional bool minimize_reduction_during_pb_resolution = 48 [default = false];</code>
     * @return Whether the minimizeReductionDuringPbResolution field is set.
     */
    @java.lang.Override
    public boolean hasMinimizeReductionDuringPbResolution() {
      return ((bitField1_ & 0x04000000) != 0);
    }
    /**
     * <pre>
     * A different algorithm during PB resolution. It minimizes the number of
     * calls to ReduceCoefficients() which can be time consuming. However, the
     * search space will be different and if the coefficients are large, this may
     * lead to integer overflows that could otherwise be prevented.
     * </pre>
     *
     * <code>optional bool minimize_reduction_during_pb_resolution = 48 [default = false];</code>
     * @return The minimizeReductionDuringPbResolution.
     */
    @java.lang.Override
    public boolean getMinimizeReductionDuringPbResolution() {
      return minimizeReductionDuringPbResolution_;
    }
    /**
     * <pre>
     * A different algorithm during PB resolution. It minimizes the number of
     * calls to ReduceCoefficients() which can be time consuming. However, the
     * search space will be different and if the coefficients are large, this may
     * lead to integer overflows that could otherwise be prevented.
     * </pre>
     *
     * <code>optional bool minimize_reduction_during_pb_resolution = 48 [default = false];</code>
     * @param value The minimizeReductionDuringPbResolution to set.
     * @return This builder for chaining.
     */
    public Builder setMinimizeReductionDuringPbResolution(boolean value) {
      bitField1_ |= 0x04000000;
      minimizeReductionDuringPbResolution_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A different algorithm during PB resolution. It minimizes the number of
     * calls to ReduceCoefficients() which can be time consuming. However, the
     * search space will be different and if the coefficients are large, this may
     * lead to integer overflows that could otherwise be prevented.
     * </pre>
     *
     * <code>optional bool minimize_reduction_during_pb_resolution = 48 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearMinimizeReductionDuringPbResolution() {
      bitField1_ = (bitField1_ & ~0x04000000);
      minimizeReductionDuringPbResolution_ = false;
      onChanged();
      return this;
    }

    private boolean countAssumptionLevelsInLbd_ = true;
    /**
     * <pre>
     * Whether or not the assumption levels are taken into account during the LBD
     * computation. According to the reference below, not counting them improves
     * the solver in some situation. Note that this only impact solves under
     * assumptions.
     * Gilles Audemard, Jean-Marie Lagniez, Laurent Simon, "Improving Glucose for
     * Incremental SAT Solving with Assumptions: Application to MUS Extraction"
     * Theory and Applications of Satisfiability Testing - SAT 2013, Lecture Notes
     * in Computer Science Volume 7962, 2013, pp 309-317.
     * </pre>
     *
     * <code>optional bool count_assumption_levels_in_lbd = 49 [default = true];</code>
     * @return Whether the countAssumptionLevelsInLbd field is set.
     */
    @java.lang.Override
    public boolean hasCountAssumptionLevelsInLbd() {
      return ((bitField1_ & 0x08000000) != 0);
    }
    /**
     * <pre>
     * Whether or not the assumption levels are taken into account during the LBD
     * computation. According to the reference below, not counting them improves
     * the solver in some situation. Note that this only impact solves under
     * assumptions.
     * Gilles Audemard, Jean-Marie Lagniez, Laurent Simon, "Improving Glucose for
     * Incremental SAT Solving with Assumptions: Application to MUS Extraction"
     * Theory and Applications of Satisfiability Testing - SAT 2013, Lecture Notes
     * in Computer Science Volume 7962, 2013, pp 309-317.
     * </pre>
     *
     * <code>optional bool count_assumption_levels_in_lbd = 49 [default = true];</code>
     * @return The countAssumptionLevelsInLbd.
     */
    @java.lang.Override
    public boolean getCountAssumptionLevelsInLbd() {
      return countAssumptionLevelsInLbd_;
    }
    /**
     * <pre>
     * Whether or not the assumption levels are taken into account during the LBD
     * computation. According to the reference below, not counting them improves
     * the solver in some situation. Note that this only impact solves under
     * assumptions.
     * Gilles Audemard, Jean-Marie Lagniez, Laurent Simon, "Improving Glucose for
     * Incremental SAT Solving with Assumptions: Application to MUS Extraction"
     * Theory and Applications of Satisfiability Testing - SAT 2013, Lecture Notes
     * in Computer Science Volume 7962, 2013, pp 309-317.
     * </pre>
     *
     * <code>optional bool count_assumption_levels_in_lbd = 49 [default = true];</code>
     * @param value The countAssumptionLevelsInLbd to set.
     * @return This builder for chaining.
     */
    public Builder setCountAssumptionLevelsInLbd(boolean value) {
      bitField1_ |= 0x08000000;
      countAssumptionLevelsInLbd_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether or not the assumption levels are taken into account during the LBD
     * computation. According to the reference below, not counting them improves
     * the solver in some situation. Note that this only impact solves under
     * assumptions.
     * Gilles Audemard, Jean-Marie Lagniez, Laurent Simon, "Improving Glucose for
     * Incremental SAT Solving with Assumptions: Application to MUS Extraction"
     * Theory and Applications of Satisfiability Testing - SAT 2013, Lecture Notes
     * in Computer Science Volume 7962, 2013, pp 309-317.
     * </pre>
     *
     * <code>optional bool count_assumption_levels_in_lbd = 49 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearCountAssumptionLevelsInLbd() {
      bitField1_ = (bitField1_ & ~0x08000000);
      countAssumptionLevelsInLbd_ = true;
      onChanged();
      return this;
    }

    private int presolveBveThreshold_ = 500;
    /**
     * <pre>
     * During presolve, only try to perform the bounded variable elimination (BVE)
     * of a variable x if the number of occurrences of x times the number of
     * occurrences of not(x) is not greater than this parameter.
     * </pre>
     *
     * <code>optional int32 presolve_bve_threshold = 54 [default = 500];</code>
     * @return Whether the presolveBveThreshold field is set.
     */
    @java.lang.Override
    public boolean hasPresolveBveThreshold() {
      return ((bitField1_ & 0x10000000) != 0);
    }
    /**
     * <pre>
     * During presolve, only try to perform the bounded variable elimination (BVE)
     * of a variable x if the number of occurrences of x times the number of
     * occurrences of not(x) is not greater than this parameter.
     * </pre>
     *
     * <code>optional int32 presolve_bve_threshold = 54 [default = 500];</code>
     * @return The presolveBveThreshold.
     */
    @java.lang.Override
    public int getPresolveBveThreshold() {
      return presolveBveThreshold_;
    }
    /**
     * <pre>
     * During presolve, only try to perform the bounded variable elimination (BVE)
     * of a variable x if the number of occurrences of x times the number of
     * occurrences of not(x) is not greater than this parameter.
     * </pre>
     *
     * <code>optional int32 presolve_bve_threshold = 54 [default = 500];</code>
     * @param value The presolveBveThreshold to set.
     * @return This builder for chaining.
     */
    public Builder setPresolveBveThreshold(int value) {
      bitField1_ |= 0x10000000;
      presolveBveThreshold_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * During presolve, only try to perform the bounded variable elimination (BVE)
     * of a variable x if the number of occurrences of x times the number of
     * occurrences of not(x) is not greater than this parameter.
     * </pre>
     *
     * <code>optional int32 presolve_bve_threshold = 54 [default = 500];</code>
     * @return This builder for chaining.
     */
    public Builder clearPresolveBveThreshold() {
      bitField1_ = (bitField1_ & ~0x10000000);
      presolveBveThreshold_ = 500;
      onChanged();
      return this;
    }

    private int presolveBveClauseWeight_ = 3;
    /**
     * <pre>
     * During presolve, we apply BVE only if this weight times the number of
     * clauses plus the number of clause literals is not increased.
     * </pre>
     *
     * <code>optional int32 presolve_bve_clause_weight = 55 [default = 3];</code>
     * @return Whether the presolveBveClauseWeight field is set.
     */
    @java.lang.Override
    public boolean hasPresolveBveClauseWeight() {
      return ((bitField1_ & 0x20000000) != 0);
    }
    /**
     * <pre>
     * During presolve, we apply BVE only if this weight times the number of
     * clauses plus the number of clause literals is not increased.
     * </pre>
     *
     * <code>optional int32 presolve_bve_clause_weight = 55 [default = 3];</code>
     * @return The presolveBveClauseWeight.
     */
    @java.lang.Override
    public int getPresolveBveClauseWeight() {
      return presolveBveClauseWeight_;
    }
    /**
     * <pre>
     * During presolve, we apply BVE only if this weight times the number of
     * clauses plus the number of clause literals is not increased.
     * </pre>
     *
     * <code>optional int32 presolve_bve_clause_weight = 55 [default = 3];</code>
     * @param value The presolveBveClauseWeight to set.
     * @return This builder for chaining.
     */
    public Builder setPresolveBveClauseWeight(int value) {
      bitField1_ |= 0x20000000;
      presolveBveClauseWeight_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * During presolve, we apply BVE only if this weight times the number of
     * clauses plus the number of clause literals is not increased.
     * </pre>
     *
     * <code>optional int32 presolve_bve_clause_weight = 55 [default = 3];</code>
     * @return This builder for chaining.
     */
    public Builder clearPresolveBveClauseWeight() {
      bitField1_ = (bitField1_ & ~0x20000000);
      presolveBveClauseWeight_ = 3;
      onChanged();
      return this;
    }

    private double presolveProbingDeterministicTimeLimit_ = 30D;
    /**
     * <pre>
     * The maximum "deterministic" time limit to spend in probing. A value of
     * zero will disable the probing.
     * </pre>
     *
     * <code>optional double presolve_probing_deterministic_time_limit = 57 [default = 30];</code>
     * @return Whether the presolveProbingDeterministicTimeLimit field is set.
     */
    @java.lang.Override
    public boolean hasPresolveProbingDeterministicTimeLimit() {
      return ((bitField1_ & 0x40000000) != 0);
    }
    /**
     * <pre>
     * The maximum "deterministic" time limit to spend in probing. A value of
     * zero will disable the probing.
     * </pre>
     *
     * <code>optional double presolve_probing_deterministic_time_limit = 57 [default = 30];</code>
     * @return The presolveProbingDeterministicTimeLimit.
     */
    @java.lang.Override
    public double getPresolveProbingDeterministicTimeLimit() {
      return presolveProbingDeterministicTimeLimit_;
    }
    /**
     * <pre>
     * The maximum "deterministic" time limit to spend in probing. A value of
     * zero will disable the probing.
     * </pre>
     *
     * <code>optional double presolve_probing_deterministic_time_limit = 57 [default = 30];</code>
     * @param value The presolveProbingDeterministicTimeLimit to set.
     * @return This builder for chaining.
     */
    public Builder setPresolveProbingDeterministicTimeLimit(double value) {
      bitField1_ |= 0x40000000;
      presolveProbingDeterministicTimeLimit_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The maximum "deterministic" time limit to spend in probing. A value of
     * zero will disable the probing.
     * </pre>
     *
     * <code>optional double presolve_probing_deterministic_time_limit = 57 [default = 30];</code>
     * @return This builder for chaining.
     */
    public Builder clearPresolveProbingDeterministicTimeLimit() {
      bitField1_ = (bitField1_ & ~0x40000000);
      presolveProbingDeterministicTimeLimit_ = 30D;
      onChanged();
      return this;
    }

    private boolean presolveBlockedClause_ = true;
    /**
     * <pre>
     * Whether we use an heuristic to detect some basic case of blocked clause
     * in the SAT presolve.
     * </pre>
     *
     * <code>optional bool presolve_blocked_clause = 88 [default = true];</code>
     * @return Whether the presolveBlockedClause field is set.
     */
    @java.lang.Override
    public boolean hasPresolveBlockedClause() {
      return ((bitField1_ & 0x80000000) != 0);
    }
    /**
     * <pre>
     * Whether we use an heuristic to detect some basic case of blocked clause
     * in the SAT presolve.
     * </pre>
     *
     * <code>optional bool presolve_blocked_clause = 88 [default = true];</code>
     * @return The presolveBlockedClause.
     */
    @java.lang.Override
    public boolean getPresolveBlockedClause() {
      return presolveBlockedClause_;
    }
    /**
     * <pre>
     * Whether we use an heuristic to detect some basic case of blocked clause
     * in the SAT presolve.
     * </pre>
     *
     * <code>optional bool presolve_blocked_clause = 88 [default = true];</code>
     * @param value The presolveBlockedClause to set.
     * @return This builder for chaining.
     */
    public Builder setPresolveBlockedClause(boolean value) {
      bitField1_ |= 0x80000000;
      presolveBlockedClause_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we use an heuristic to detect some basic case of blocked clause
     * in the SAT presolve.
     * </pre>
     *
     * <code>optional bool presolve_blocked_clause = 88 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearPresolveBlockedClause() {
      bitField1_ = (bitField1_ & ~0x80000000);
      presolveBlockedClause_ = true;
      onChanged();
      return this;
    }

    private boolean presolveUseBva_ = true;
    /**
     * <pre>
     * Whether or not we use Bounded Variable Addition (BVA) in the presolve.
     * </pre>
     *
     * <code>optional bool presolve_use_bva = 72 [default = true];</code>
     * @return Whether the presolveUseBva field is set.
     */
    @java.lang.Override
    public boolean hasPresolveUseBva() {
      return ((bitField2_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Whether or not we use Bounded Variable Addition (BVA) in the presolve.
     * </pre>
     *
     * <code>optional bool presolve_use_bva = 72 [default = true];</code>
     * @return The presolveUseBva.
     */
    @java.lang.Override
    public boolean getPresolveUseBva() {
      return presolveUseBva_;
    }
    /**
     * <pre>
     * Whether or not we use Bounded Variable Addition (BVA) in the presolve.
     * </pre>
     *
     * <code>optional bool presolve_use_bva = 72 [default = true];</code>
     * @param value The presolveUseBva to set.
     * @return This builder for chaining.
     */
    public Builder setPresolveUseBva(boolean value) {
      bitField2_ |= 0x00000001;
      presolveUseBva_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether or not we use Bounded Variable Addition (BVA) in the presolve.
     * </pre>
     *
     * <code>optional bool presolve_use_bva = 72 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearPresolveUseBva() {
      bitField2_ = (bitField2_ & ~0x00000001);
      presolveUseBva_ = true;
      onChanged();
      return this;
    }

    private int presolveBvaThreshold_ = 1;
    /**
     * <pre>
     * Apply Bounded Variable Addition (BVA) if the number of clauses is reduced
     * by stricly more than this threshold. The algorithm described in the paper
     * uses 0, but quick experiments showed that 1 is a good value. It may not be
     * worth it to add a new variable just to remove one clause.
     * </pre>
     *
     * <code>optional int32 presolve_bva_threshold = 73 [default = 1];</code>
     * @return Whether the presolveBvaThreshold field is set.
     */
    @java.lang.Override
    public boolean hasPresolveBvaThreshold() {
      return ((bitField2_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Apply Bounded Variable Addition (BVA) if the number of clauses is reduced
     * by stricly more than this threshold. The algorithm described in the paper
     * uses 0, but quick experiments showed that 1 is a good value. It may not be
     * worth it to add a new variable just to remove one clause.
     * </pre>
     *
     * <code>optional int32 presolve_bva_threshold = 73 [default = 1];</code>
     * @return The presolveBvaThreshold.
     */
    @java.lang.Override
    public int getPresolveBvaThreshold() {
      return presolveBvaThreshold_;
    }
    /**
     * <pre>
     * Apply Bounded Variable Addition (BVA) if the number of clauses is reduced
     * by stricly more than this threshold. The algorithm described in the paper
     * uses 0, but quick experiments showed that 1 is a good value. It may not be
     * worth it to add a new variable just to remove one clause.
     * </pre>
     *
     * <code>optional int32 presolve_bva_threshold = 73 [default = 1];</code>
     * @param value The presolveBvaThreshold to set.
     * @return This builder for chaining.
     */
    public Builder setPresolveBvaThreshold(int value) {
      bitField2_ |= 0x00000002;
      presolveBvaThreshold_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Apply Bounded Variable Addition (BVA) if the number of clauses is reduced
     * by stricly more than this threshold. The algorithm described in the paper
     * uses 0, but quick experiments showed that 1 is a good value. It may not be
     * worth it to add a new variable just to remove one clause.
     * </pre>
     *
     * <code>optional int32 presolve_bva_threshold = 73 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearPresolveBvaThreshold() {
      bitField2_ = (bitField2_ & ~0x00000002);
      presolveBvaThreshold_ = 1;
      onChanged();
      return this;
    }

    private int maxPresolveIterations_ = 3;
    /**
     * <pre>
     * In case of large reduction in a presolve iteration, we perform multiple
     * presolve iterations. This parameter controls the maximum number of such
     * presolve iterations.
     * </pre>
     *
     * <code>optional int32 max_presolve_iterations = 138 [default = 3];</code>
     * @return Whether the maxPresolveIterations field is set.
     */
    @java.lang.Override
    public boolean hasMaxPresolveIterations() {
      return ((bitField2_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * In case of large reduction in a presolve iteration, we perform multiple
     * presolve iterations. This parameter controls the maximum number of such
     * presolve iterations.
     * </pre>
     *
     * <code>optional int32 max_presolve_iterations = 138 [default = 3];</code>
     * @return The maxPresolveIterations.
     */
    @java.lang.Override
    public int getMaxPresolveIterations() {
      return maxPresolveIterations_;
    }
    /**
     * <pre>
     * In case of large reduction in a presolve iteration, we perform multiple
     * presolve iterations. This parameter controls the maximum number of such
     * presolve iterations.
     * </pre>
     *
     * <code>optional int32 max_presolve_iterations = 138 [default = 3];</code>
     * @param value The maxPresolveIterations to set.
     * @return This builder for chaining.
     */
    public Builder setMaxPresolveIterations(int value) {
      bitField2_ |= 0x00000004;
      maxPresolveIterations_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * In case of large reduction in a presolve iteration, we perform multiple
     * presolve iterations. This parameter controls the maximum number of such
     * presolve iterations.
     * </pre>
     *
     * <code>optional int32 max_presolve_iterations = 138 [default = 3];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxPresolveIterations() {
      bitField2_ = (bitField2_ & ~0x00000004);
      maxPresolveIterations_ = 3;
      onChanged();
      return this;
    }

    private boolean cpModelPresolve_ = true;
    /**
     * <pre>
     * Whether we presolve the cp_model before solving it.
     * </pre>
     *
     * <code>optional bool cp_model_presolve = 86 [default = true];</code>
     * @return Whether the cpModelPresolve field is set.
     */
    @java.lang.Override
    public boolean hasCpModelPresolve() {
      return ((bitField2_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * Whether we presolve the cp_model before solving it.
     * </pre>
     *
     * <code>optional bool cp_model_presolve = 86 [default = true];</code>
     * @return The cpModelPresolve.
     */
    @java.lang.Override
    public boolean getCpModelPresolve() {
      return cpModelPresolve_;
    }
    /**
     * <pre>
     * Whether we presolve the cp_model before solving it.
     * </pre>
     *
     * <code>optional bool cp_model_presolve = 86 [default = true];</code>
     * @param value The cpModelPresolve to set.
     * @return This builder for chaining.
     */
    public Builder setCpModelPresolve(boolean value) {
      bitField2_ |= 0x00000008;
      cpModelPresolve_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we presolve the cp_model before solving it.
     * </pre>
     *
     * <code>optional bool cp_model_presolve = 86 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearCpModelPresolve() {
      bitField2_ = (bitField2_ & ~0x00000008);
      cpModelPresolve_ = true;
      onChanged();
      return this;
    }

    private boolean cpModelPostsolveWithFullSolver_ ;
    /**
     * <pre>
     * Advanced usage. We have two different postsolve code. The default one
     * should be better and it allows for a more powerful presolve, but some
     * rarely used features like not fully assigning all variables require the
     * other one.
     * </pre>
     *
     * <code>optional bool cp_model_postsolve_with_full_solver = 162 [default = false];</code>
     * @return Whether the cpModelPostsolveWithFullSolver field is set.
     */
    @java.lang.Override
    public boolean hasCpModelPostsolveWithFullSolver() {
      return ((bitField2_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * Advanced usage. We have two different postsolve code. The default one
     * should be better and it allows for a more powerful presolve, but some
     * rarely used features like not fully assigning all variables require the
     * other one.
     * </pre>
     *
     * <code>optional bool cp_model_postsolve_with_full_solver = 162 [default = false];</code>
     * @return The cpModelPostsolveWithFullSolver.
     */
    @java.lang.Override
    public boolean getCpModelPostsolveWithFullSolver() {
      return cpModelPostsolveWithFullSolver_;
    }
    /**
     * <pre>
     * Advanced usage. We have two different postsolve code. The default one
     * should be better and it allows for a more powerful presolve, but some
     * rarely used features like not fully assigning all variables require the
     * other one.
     * </pre>
     *
     * <code>optional bool cp_model_postsolve_with_full_solver = 162 [default = false];</code>
     * @param value The cpModelPostsolveWithFullSolver to set.
     * @return This builder for chaining.
     */
    public Builder setCpModelPostsolveWithFullSolver(boolean value) {
      bitField2_ |= 0x00000010;
      cpModelPostsolveWithFullSolver_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Advanced usage. We have two different postsolve code. The default one
     * should be better and it allows for a more powerful presolve, but some
     * rarely used features like not fully assigning all variables require the
     * other one.
     * </pre>
     *
     * <code>optional bool cp_model_postsolve_with_full_solver = 162 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearCpModelPostsolveWithFullSolver() {
      bitField2_ = (bitField2_ & ~0x00000010);
      cpModelPostsolveWithFullSolver_ = false;
      onChanged();
      return this;
    }

    private int cpModelMaxNumPresolveOperations_ ;
    /**
     * <pre>
     * If positive, try to stop just after that many presolve rules have been
     * applied. This is mainly useful for debugging presolve.
     * </pre>
     *
     * <code>optional int32 cp_model_max_num_presolve_operations = 151 [default = 0];</code>
     * @return Whether the cpModelMaxNumPresolveOperations field is set.
     */
    @java.lang.Override
    public boolean hasCpModelMaxNumPresolveOperations() {
      return ((bitField2_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * If positive, try to stop just after that many presolve rules have been
     * applied. This is mainly useful for debugging presolve.
     * </pre>
     *
     * <code>optional int32 cp_model_max_num_presolve_operations = 151 [default = 0];</code>
     * @return The cpModelMaxNumPresolveOperations.
     */
    @java.lang.Override
    public int getCpModelMaxNumPresolveOperations() {
      return cpModelMaxNumPresolveOperations_;
    }
    /**
     * <pre>
     * If positive, try to stop just after that many presolve rules have been
     * applied. This is mainly useful for debugging presolve.
     * </pre>
     *
     * <code>optional int32 cp_model_max_num_presolve_operations = 151 [default = 0];</code>
     * @param value The cpModelMaxNumPresolveOperations to set.
     * @return This builder for chaining.
     */
    public Builder setCpModelMaxNumPresolveOperations(int value) {
      bitField2_ |= 0x00000020;
      cpModelMaxNumPresolveOperations_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If positive, try to stop just after that many presolve rules have been
     * applied. This is mainly useful for debugging presolve.
     * </pre>
     *
     * <code>optional int32 cp_model_max_num_presolve_operations = 151 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearCpModelMaxNumPresolveOperations() {
      bitField2_ = (bitField2_ & ~0x00000020);
      cpModelMaxNumPresolveOperations_ = 0;
      onChanged();
      return this;
    }

    private int cpModelProbingLevel_ = 2;
    /**
     * <pre>
     * How much effort do we spend on probing. 0 disables it completely.
     * </pre>
     *
     * <code>optional int32 cp_model_probing_level = 110 [default = 2];</code>
     * @return Whether the cpModelProbingLevel field is set.
     */
    @java.lang.Override
    public boolean hasCpModelProbingLevel() {
      return ((bitField2_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * How much effort do we spend on probing. 0 disables it completely.
     * </pre>
     *
     * <code>optional int32 cp_model_probing_level = 110 [default = 2];</code>
     * @return The cpModelProbingLevel.
     */
    @java.lang.Override
    public int getCpModelProbingLevel() {
      return cpModelProbingLevel_;
    }
    /**
     * <pre>
     * How much effort do we spend on probing. 0 disables it completely.
     * </pre>
     *
     * <code>optional int32 cp_model_probing_level = 110 [default = 2];</code>
     * @param value The cpModelProbingLevel to set.
     * @return This builder for chaining.
     */
    public Builder setCpModelProbingLevel(int value) {
      bitField2_ |= 0x00000040;
      cpModelProbingLevel_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * How much effort do we spend on probing. 0 disables it completely.
     * </pre>
     *
     * <code>optional int32 cp_model_probing_level = 110 [default = 2];</code>
     * @return This builder for chaining.
     */
    public Builder clearCpModelProbingLevel() {
      bitField2_ = (bitField2_ & ~0x00000040);
      cpModelProbingLevel_ = 2;
      onChanged();
      return this;
    }

    private boolean cpModelUseSatPresolve_ = true;
    /**
     * <pre>
     * Whether we also use the sat presolve when cp_model_presolve is true.
     * </pre>
     *
     * <code>optional bool cp_model_use_sat_presolve = 93 [default = true];</code>
     * @return Whether the cpModelUseSatPresolve field is set.
     */
    @java.lang.Override
    public boolean hasCpModelUseSatPresolve() {
      return ((bitField2_ & 0x00000080) != 0);
    }
    /**
     * <pre>
     * Whether we also use the sat presolve when cp_model_presolve is true.
     * </pre>
     *
     * <code>optional bool cp_model_use_sat_presolve = 93 [default = true];</code>
     * @return The cpModelUseSatPresolve.
     */
    @java.lang.Override
    public boolean getCpModelUseSatPresolve() {
      return cpModelUseSatPresolve_;
    }
    /**
     * <pre>
     * Whether we also use the sat presolve when cp_model_presolve is true.
     * </pre>
     *
     * <code>optional bool cp_model_use_sat_presolve = 93 [default = true];</code>
     * @param value The cpModelUseSatPresolve to set.
     * @return This builder for chaining.
     */
    public Builder setCpModelUseSatPresolve(boolean value) {
      bitField2_ |= 0x00000080;
      cpModelUseSatPresolve_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we also use the sat presolve when cp_model_presolve is true.
     * </pre>
     *
     * <code>optional bool cp_model_use_sat_presolve = 93 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearCpModelUseSatPresolve() {
      bitField2_ = (bitField2_ & ~0x00000080);
      cpModelUseSatPresolve_ = true;
      onChanged();
      return this;
    }

    private boolean useSatInprocessing_ ;
    /**
     * <code>optional bool use_sat_inprocessing = 163 [default = false];</code>
     * @return Whether the useSatInprocessing field is set.
     */
    @java.lang.Override
    public boolean hasUseSatInprocessing() {
      return ((bitField2_ & 0x00000100) != 0);
    }
    /**
     * <code>optional bool use_sat_inprocessing = 163 [default = false];</code>
     * @return The useSatInprocessing.
     */
    @java.lang.Override
    public boolean getUseSatInprocessing() {
      return useSatInprocessing_;
    }
    /**
     * <code>optional bool use_sat_inprocessing = 163 [default = false];</code>
     * @param value The useSatInprocessing to set.
     * @return This builder for chaining.
     */
    public Builder setUseSatInprocessing(boolean value) {
      bitField2_ |= 0x00000100;
      useSatInprocessing_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional bool use_sat_inprocessing = 163 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseSatInprocessing() {
      bitField2_ = (bitField2_ & ~0x00000100);
      useSatInprocessing_ = false;
      onChanged();
      return this;
    }

    private boolean expandElementConstraints_ = true;
    /**
     * <pre>
     * If true, the element constraints are expanded into many
     * linear constraints of the form (index == i) =&gt; (element[i] == target).
     * </pre>
     *
     * <code>optional bool expand_element_constraints = 140 [default = true];</code>
     * @return Whether the expandElementConstraints field is set.
     */
    @java.lang.Override
    public boolean hasExpandElementConstraints() {
      return ((bitField2_ & 0x00000200) != 0);
    }
    /**
     * <pre>
     * If true, the element constraints are expanded into many
     * linear constraints of the form (index == i) =&gt; (element[i] == target).
     * </pre>
     *
     * <code>optional bool expand_element_constraints = 140 [default = true];</code>
     * @return The expandElementConstraints.
     */
    @java.lang.Override
    public boolean getExpandElementConstraints() {
      return expandElementConstraints_;
    }
    /**
     * <pre>
     * If true, the element constraints are expanded into many
     * linear constraints of the form (index == i) =&gt; (element[i] == target).
     * </pre>
     *
     * <code>optional bool expand_element_constraints = 140 [default = true];</code>
     * @param value The expandElementConstraints to set.
     * @return This builder for chaining.
     */
    public Builder setExpandElementConstraints(boolean value) {
      bitField2_ |= 0x00000200;
      expandElementConstraints_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, the element constraints are expanded into many
     * linear constraints of the form (index == i) =&gt; (element[i] == target).
     * </pre>
     *
     * <code>optional bool expand_element_constraints = 140 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearExpandElementConstraints() {
      bitField2_ = (bitField2_ & ~0x00000200);
      expandElementConstraints_ = true;
      onChanged();
      return this;
    }

    private boolean expandAutomatonConstraints_ = true;
    /**
     * <pre>
     * If true, the automaton constraints are expanded.
     * </pre>
     *
     * <code>optional bool expand_automaton_constraints = 143 [default = true];</code>
     * @return Whether the expandAutomatonConstraints field is set.
     */
    @java.lang.Override
    public boolean hasExpandAutomatonConstraints() {
      return ((bitField2_ & 0x00000400) != 0);
    }
    /**
     * <pre>
     * If true, the automaton constraints are expanded.
     * </pre>
     *
     * <code>optional bool expand_automaton_constraints = 143 [default = true];</code>
     * @return The expandAutomatonConstraints.
     */
    @java.lang.Override
    public boolean getExpandAutomatonConstraints() {
      return expandAutomatonConstraints_;
    }
    /**
     * <pre>
     * If true, the automaton constraints are expanded.
     * </pre>
     *
     * <code>optional bool expand_automaton_constraints = 143 [default = true];</code>
     * @param value The expandAutomatonConstraints to set.
     * @return This builder for chaining.
     */
    public Builder setExpandAutomatonConstraints(boolean value) {
      bitField2_ |= 0x00000400;
      expandAutomatonConstraints_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, the automaton constraints are expanded.
     * </pre>
     *
     * <code>optional bool expand_automaton_constraints = 143 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearExpandAutomatonConstraints() {
      bitField2_ = (bitField2_ & ~0x00000400);
      expandAutomatonConstraints_ = true;
      onChanged();
      return this;
    }

    private boolean expandTableConstraints_ = true;
    /**
     * <pre>
     * If true, the positive table constraints are expanded.
     * Note that currently, negative table constraints are always expanded.
     * </pre>
     *
     * <code>optional bool expand_table_constraints = 158 [default = true];</code>
     * @return Whether the expandTableConstraints field is set.
     */
    @java.lang.Override
    public boolean hasExpandTableConstraints() {
      return ((bitField2_ & 0x00000800) != 0);
    }
    /**
     * <pre>
     * If true, the positive table constraints are expanded.
     * Note that currently, negative table constraints are always expanded.
     * </pre>
     *
     * <code>optional bool expand_table_constraints = 158 [default = true];</code>
     * @return The expandTableConstraints.
     */
    @java.lang.Override
    public boolean getExpandTableConstraints() {
      return expandTableConstraints_;
    }
    /**
     * <pre>
     * If true, the positive table constraints are expanded.
     * Note that currently, negative table constraints are always expanded.
     * </pre>
     *
     * <code>optional bool expand_table_constraints = 158 [default = true];</code>
     * @param value The expandTableConstraints to set.
     * @return This builder for chaining.
     */
    public Builder setExpandTableConstraints(boolean value) {
      bitField2_ |= 0x00000800;
      expandTableConstraints_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, the positive table constraints are expanded.
     * Note that currently, negative table constraints are always expanded.
     * </pre>
     *
     * <code>optional bool expand_table_constraints = 158 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearExpandTableConstraints() {
      bitField2_ = (bitField2_ & ~0x00000800);
      expandTableConstraints_ = true;
      onChanged();
      return this;
    }

    private boolean expandAlldiffConstraints_ ;
    /**
     * <pre>
     * If true, expand all_different constraints that are not permutations.
     * Permutations (#Variables = #Values) are always expanded.
     * </pre>
     *
     * <code>optional bool expand_alldiff_constraints = 170 [default = false];</code>
     * @return Whether the expandAlldiffConstraints field is set.
     */
    @java.lang.Override
    public boolean hasExpandAlldiffConstraints() {
      return ((bitField2_ & 0x00001000) != 0);
    }
    /**
     * <pre>
     * If true, expand all_different constraints that are not permutations.
     * Permutations (#Variables = #Values) are always expanded.
     * </pre>
     *
     * <code>optional bool expand_alldiff_constraints = 170 [default = false];</code>
     * @return The expandAlldiffConstraints.
     */
    @java.lang.Override
    public boolean getExpandAlldiffConstraints() {
      return expandAlldiffConstraints_;
    }
    /**
     * <pre>
     * If true, expand all_different constraints that are not permutations.
     * Permutations (#Variables = #Values) are always expanded.
     * </pre>
     *
     * <code>optional bool expand_alldiff_constraints = 170 [default = false];</code>
     * @param value The expandAlldiffConstraints to set.
     * @return This builder for chaining.
     */
    public Builder setExpandAlldiffConstraints(boolean value) {
      bitField2_ |= 0x00001000;
      expandAlldiffConstraints_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, expand all_different constraints that are not permutations.
     * Permutations (#Variables = #Values) are always expanded.
     * </pre>
     *
     * <code>optional bool expand_alldiff_constraints = 170 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearExpandAlldiffConstraints() {
      bitField2_ = (bitField2_ & ~0x00001000);
      expandAlldiffConstraints_ = false;
      onChanged();
      return this;
    }

    private boolean expandReservoirConstraints_ = true;
    /**
     * <pre>
     * If true, expand the reservoir constraints by creating booleans for all
     * possible precedences between event and encoding the constraint.
     * </pre>
     *
     * <code>optional bool expand_reservoir_constraints = 182 [default = true];</code>
     * @return Whether the expandReservoirConstraints field is set.
     */
    @java.lang.Override
    public boolean hasExpandReservoirConstraints() {
      return ((bitField2_ & 0x00002000) != 0);
    }
    /**
     * <pre>
     * If true, expand the reservoir constraints by creating booleans for all
     * possible precedences between event and encoding the constraint.
     * </pre>
     *
     * <code>optional bool expand_reservoir_constraints = 182 [default = true];</code>
     * @return The expandReservoirConstraints.
     */
    @java.lang.Override
    public boolean getExpandReservoirConstraints() {
      return expandReservoirConstraints_;
    }
    /**
     * <pre>
     * If true, expand the reservoir constraints by creating booleans for all
     * possible precedences between event and encoding the constraint.
     * </pre>
     *
     * <code>optional bool expand_reservoir_constraints = 182 [default = true];</code>
     * @param value The expandReservoirConstraints to set.
     * @return This builder for chaining.
     */
    public Builder setExpandReservoirConstraints(boolean value) {
      bitField2_ |= 0x00002000;
      expandReservoirConstraints_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, expand the reservoir constraints by creating booleans for all
     * possible precedences between event and encoding the constraint.
     * </pre>
     *
     * <code>optional bool expand_reservoir_constraints = 182 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearExpandReservoirConstraints() {
      bitField2_ = (bitField2_ & ~0x00002000);
      expandReservoirConstraints_ = true;
      onChanged();
      return this;
    }

    private boolean disableConstraintExpansion_ ;
    /**
     * <pre>
     * If true, it disable all constraint expansion.
     * This should only be used to test the presolve of expanded constraints.
     * </pre>
     *
     * <code>optional bool disable_constraint_expansion = 181 [default = false];</code>
     * @return Whether the disableConstraintExpansion field is set.
     */
    @java.lang.Override
    public boolean hasDisableConstraintExpansion() {
      return ((bitField2_ & 0x00004000) != 0);
    }
    /**
     * <pre>
     * If true, it disable all constraint expansion.
     * This should only be used to test the presolve of expanded constraints.
     * </pre>
     *
     * <code>optional bool disable_constraint_expansion = 181 [default = false];</code>
     * @return The disableConstraintExpansion.
     */
    @java.lang.Override
    public boolean getDisableConstraintExpansion() {
      return disableConstraintExpansion_;
    }
    /**
     * <pre>
     * If true, it disable all constraint expansion.
     * This should only be used to test the presolve of expanded constraints.
     * </pre>
     *
     * <code>optional bool disable_constraint_expansion = 181 [default = false];</code>
     * @param value The disableConstraintExpansion to set.
     * @return This builder for chaining.
     */
    public Builder setDisableConstraintExpansion(boolean value) {
      bitField2_ |= 0x00004000;
      disableConstraintExpansion_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, it disable all constraint expansion.
     * This should only be used to test the presolve of expanded constraints.
     * </pre>
     *
     * <code>optional bool disable_constraint_expansion = 181 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearDisableConstraintExpansion() {
      bitField2_ = (bitField2_ & ~0x00004000);
      disableConstraintExpansion_ = false;
      onChanged();
      return this;
    }

    private double mergeNoOverlapWorkLimit_ = 1000000000000D;
    /**
     * <pre>
     * During presolve, we use a maximum clique heuristic to merge together
     * no-overlap constraints or at most one constraints. This code can be slow,
     * so we have a limit in place on the number of explored nodes in the
     * underlying graph. The internal limit is an int64, but we use double here to
     * simplify manual input.
     * </pre>
     *
     * <code>optional double merge_no_overlap_work_limit = 145 [default = 1000000000000];</code>
     * @return Whether the mergeNoOverlapWorkLimit field is set.
     */
    @java.lang.Override
    public boolean hasMergeNoOverlapWorkLimit() {
      return ((bitField2_ & 0x00008000) != 0);
    }
    /**
     * <pre>
     * During presolve, we use a maximum clique heuristic to merge together
     * no-overlap constraints or at most one constraints. This code can be slow,
     * so we have a limit in place on the number of explored nodes in the
     * underlying graph. The internal limit is an int64, but we use double here to
     * simplify manual input.
     * </pre>
     *
     * <code>optional double merge_no_overlap_work_limit = 145 [default = 1000000000000];</code>
     * @return The mergeNoOverlapWorkLimit.
     */
    @java.lang.Override
    public double getMergeNoOverlapWorkLimit() {
      return mergeNoOverlapWorkLimit_;
    }
    /**
     * <pre>
     * During presolve, we use a maximum clique heuristic to merge together
     * no-overlap constraints or at most one constraints. This code can be slow,
     * so we have a limit in place on the number of explored nodes in the
     * underlying graph. The internal limit is an int64, but we use double here to
     * simplify manual input.
     * </pre>
     *
     * <code>optional double merge_no_overlap_work_limit = 145 [default = 1000000000000];</code>
     * @param value The mergeNoOverlapWorkLimit to set.
     * @return This builder for chaining.
     */
    public Builder setMergeNoOverlapWorkLimit(double value) {
      bitField2_ |= 0x00008000;
      mergeNoOverlapWorkLimit_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * During presolve, we use a maximum clique heuristic to merge together
     * no-overlap constraints or at most one constraints. This code can be slow,
     * so we have a limit in place on the number of explored nodes in the
     * underlying graph. The internal limit is an int64, but we use double here to
     * simplify manual input.
     * </pre>
     *
     * <code>optional double merge_no_overlap_work_limit = 145 [default = 1000000000000];</code>
     * @return This builder for chaining.
     */
    public Builder clearMergeNoOverlapWorkLimit() {
      bitField2_ = (bitField2_ & ~0x00008000);
      mergeNoOverlapWorkLimit_ = 1000000000000D;
      onChanged();
      return this;
    }

    private double mergeAtMostOneWorkLimit_ = 100000000D;
    /**
     * <code>optional double merge_at_most_one_work_limit = 146 [default = 100000000];</code>
     * @return Whether the mergeAtMostOneWorkLimit field is set.
     */
    @java.lang.Override
    public boolean hasMergeAtMostOneWorkLimit() {
      return ((bitField2_ & 0x00010000) != 0);
    }
    /**
     * <code>optional double merge_at_most_one_work_limit = 146 [default = 100000000];</code>
     * @return The mergeAtMostOneWorkLimit.
     */
    @java.lang.Override
    public double getMergeAtMostOneWorkLimit() {
      return mergeAtMostOneWorkLimit_;
    }
    /**
     * <code>optional double merge_at_most_one_work_limit = 146 [default = 100000000];</code>
     * @param value The mergeAtMostOneWorkLimit to set.
     * @return This builder for chaining.
     */
    public Builder setMergeAtMostOneWorkLimit(double value) {
      bitField2_ |= 0x00010000;
      mergeAtMostOneWorkLimit_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional double merge_at_most_one_work_limit = 146 [default = 100000000];</code>
     * @return This builder for chaining.
     */
    public Builder clearMergeAtMostOneWorkLimit() {
      bitField2_ = (bitField2_ & ~0x00010000);
      mergeAtMostOneWorkLimit_ = 100000000D;
      onChanged();
      return this;
    }

    private int presolveSubstitutionLevel_ = 1;
    /**
     * <pre>
     * How much substitution (also called free variable aggregation in MIP
     * litterature) should we perform at presolve. This currently only concerns
     * variable appearing only in linear constraints. For now the value 0 turns it
     * off and any positive value performs substitution.
     * </pre>
     *
     * <code>optional int32 presolve_substitution_level = 147 [default = 1];</code>
     * @return Whether the presolveSubstitutionLevel field is set.
     */
    @java.lang.Override
    public boolean hasPresolveSubstitutionLevel() {
      return ((bitField2_ & 0x00020000) != 0);
    }
    /**
     * <pre>
     * How much substitution (also called free variable aggregation in MIP
     * litterature) should we perform at presolve. This currently only concerns
     * variable appearing only in linear constraints. For now the value 0 turns it
     * off and any positive value performs substitution.
     * </pre>
     *
     * <code>optional int32 presolve_substitution_level = 147 [default = 1];</code>
     * @return The presolveSubstitutionLevel.
     */
    @java.lang.Override
    public int getPresolveSubstitutionLevel() {
      return presolveSubstitutionLevel_;
    }
    /**
     * <pre>
     * How much substitution (also called free variable aggregation in MIP
     * litterature) should we perform at presolve. This currently only concerns
     * variable appearing only in linear constraints. For now the value 0 turns it
     * off and any positive value performs substitution.
     * </pre>
     *
     * <code>optional int32 presolve_substitution_level = 147 [default = 1];</code>
     * @param value The presolveSubstitutionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setPresolveSubstitutionLevel(int value) {
      bitField2_ |= 0x00020000;
      presolveSubstitutionLevel_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * How much substitution (also called free variable aggregation in MIP
     * litterature) should we perform at presolve. This currently only concerns
     * variable appearing only in linear constraints. For now the value 0 turns it
     * off and any positive value performs substitution.
     * </pre>
     *
     * <code>optional int32 presolve_substitution_level = 147 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearPresolveSubstitutionLevel() {
      bitField2_ = (bitField2_ & ~0x00020000);
      presolveSubstitutionLevel_ = 1;
      onChanged();
      return this;
    }

    private boolean presolveExtractIntegerEnforcement_ ;
    /**
     * <pre>
     * If true, we will extract from linear constraints, enforcement literals of
     * the form "integer variable at bound =&gt; simplified constraint". This should
     * always be beneficial except that we don't always handle them as efficiently
     * as we could for now. This causes problem on manna81.mps (LP relaxation not
     * as tight it seems) and on neos-3354841-apure.mps.gz (too many literals
     * created this way).
     * </pre>
     *
     * <code>optional bool presolve_extract_integer_enforcement = 174 [default = false];</code>
     * @return Whether the presolveExtractIntegerEnforcement field is set.
     */
    @java.lang.Override
    public boolean hasPresolveExtractIntegerEnforcement() {
      return ((bitField2_ & 0x00040000) != 0);
    }
    /**
     * <pre>
     * If true, we will extract from linear constraints, enforcement literals of
     * the form "integer variable at bound =&gt; simplified constraint". This should
     * always be beneficial except that we don't always handle them as efficiently
     * as we could for now. This causes problem on manna81.mps (LP relaxation not
     * as tight it seems) and on neos-3354841-apure.mps.gz (too many literals
     * created this way).
     * </pre>
     *
     * <code>optional bool presolve_extract_integer_enforcement = 174 [default = false];</code>
     * @return The presolveExtractIntegerEnforcement.
     */
    @java.lang.Override
    public boolean getPresolveExtractIntegerEnforcement() {
      return presolveExtractIntegerEnforcement_;
    }
    /**
     * <pre>
     * If true, we will extract from linear constraints, enforcement literals of
     * the form "integer variable at bound =&gt; simplified constraint". This should
     * always be beneficial except that we don't always handle them as efficiently
     * as we could for now. This causes problem on manna81.mps (LP relaxation not
     * as tight it seems) and on neos-3354841-apure.mps.gz (too many literals
     * created this way).
     * </pre>
     *
     * <code>optional bool presolve_extract_integer_enforcement = 174 [default = false];</code>
     * @param value The presolveExtractIntegerEnforcement to set.
     * @return This builder for chaining.
     */
    public Builder setPresolveExtractIntegerEnforcement(boolean value) {
      bitField2_ |= 0x00040000;
      presolveExtractIntegerEnforcement_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, we will extract from linear constraints, enforcement literals of
     * the form "integer variable at bound =&gt; simplified constraint". This should
     * always be beneficial except that we don't always handle them as efficiently
     * as we could for now. This causes problem on manna81.mps (LP relaxation not
     * as tight it seems) and on neos-3354841-apure.mps.gz (too many literals
     * created this way).
     * </pre>
     *
     * <code>optional bool presolve_extract_integer_enforcement = 174 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearPresolveExtractIntegerEnforcement() {
      bitField2_ = (bitField2_ & ~0x00040000);
      presolveExtractIntegerEnforcement_ = false;
      onChanged();
      return this;
    }

    private boolean useOptimizationHints_ = true;
    /**
     * <pre>
     * For an optimization problem, whether we follow some hints in order to find
     * a better first solution. For a variable with hint, the solver will always
     * try to follow the hint. It will revert to the variable_branching default
     * otherwise.
     * </pre>
     *
     * <code>optional bool use_optimization_hints = 35 [default = true];</code>
     * @return Whether the useOptimizationHints field is set.
     */
    @java.lang.Override
    public boolean hasUseOptimizationHints() {
      return ((bitField2_ & 0x00080000) != 0);
    }
    /**
     * <pre>
     * For an optimization problem, whether we follow some hints in order to find
     * a better first solution. For a variable with hint, the solver will always
     * try to follow the hint. It will revert to the variable_branching default
     * otherwise.
     * </pre>
     *
     * <code>optional bool use_optimization_hints = 35 [default = true];</code>
     * @return The useOptimizationHints.
     */
    @java.lang.Override
    public boolean getUseOptimizationHints() {
      return useOptimizationHints_;
    }
    /**
     * <pre>
     * For an optimization problem, whether we follow some hints in order to find
     * a better first solution. For a variable with hint, the solver will always
     * try to follow the hint. It will revert to the variable_branching default
     * otherwise.
     * </pre>
     *
     * <code>optional bool use_optimization_hints = 35 [default = true];</code>
     * @param value The useOptimizationHints to set.
     * @return This builder for chaining.
     */
    public Builder setUseOptimizationHints(boolean value) {
      bitField2_ |= 0x00080000;
      useOptimizationHints_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * For an optimization problem, whether we follow some hints in order to find
     * a better first solution. For a variable with hint, the solver will always
     * try to follow the hint. It will revert to the variable_branching default
     * otherwise.
     * </pre>
     *
     * <code>optional bool use_optimization_hints = 35 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseOptimizationHints() {
      bitField2_ = (bitField2_ & ~0x00080000);
      useOptimizationHints_ = true;
      onChanged();
      return this;
    }

    private boolean minimizeCore_ = true;
    /**
     * <pre>
     * Whether we use a simple heuristic to try to minimize an UNSAT core.
     * </pre>
     *
     * <code>optional bool minimize_core = 50 [default = true];</code>
     * @return Whether the minimizeCore field is set.
     */
    @java.lang.Override
    public boolean hasMinimizeCore() {
      return ((bitField2_ & 0x00100000) != 0);
    }
    /**
     * <pre>
     * Whether we use a simple heuristic to try to minimize an UNSAT core.
     * </pre>
     *
     * <code>optional bool minimize_core = 50 [default = true];</code>
     * @return The minimizeCore.
     */
    @java.lang.Override
    public boolean getMinimizeCore() {
      return minimizeCore_;
    }
    /**
     * <pre>
     * Whether we use a simple heuristic to try to minimize an UNSAT core.
     * </pre>
     *
     * <code>optional bool minimize_core = 50 [default = true];</code>
     * @param value The minimizeCore to set.
     * @return This builder for chaining.
     */
    public Builder setMinimizeCore(boolean value) {
      bitField2_ |= 0x00100000;
      minimizeCore_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we use a simple heuristic to try to minimize an UNSAT core.
     * </pre>
     *
     * <code>optional bool minimize_core = 50 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearMinimizeCore() {
      bitField2_ = (bitField2_ & ~0x00100000);
      minimizeCore_ = true;
      onChanged();
      return this;
    }

    private boolean findMultipleCores_ = true;
    /**
     * <pre>
     * Whether we try to find more independent cores for a given set of
     * assumptions in the core based max-SAT algorithms.
     * </pre>
     *
     * <code>optional bool find_multiple_cores = 84 [default = true];</code>
     * @return Whether the findMultipleCores field is set.
     */
    @java.lang.Override
    public boolean hasFindMultipleCores() {
      return ((bitField2_ & 0x00200000) != 0);
    }
    /**
     * <pre>
     * Whether we try to find more independent cores for a given set of
     * assumptions in the core based max-SAT algorithms.
     * </pre>
     *
     * <code>optional bool find_multiple_cores = 84 [default = true];</code>
     * @return The findMultipleCores.
     */
    @java.lang.Override
    public boolean getFindMultipleCores() {
      return findMultipleCores_;
    }
    /**
     * <pre>
     * Whether we try to find more independent cores for a given set of
     * assumptions in the core based max-SAT algorithms.
     * </pre>
     *
     * <code>optional bool find_multiple_cores = 84 [default = true];</code>
     * @param value The findMultipleCores to set.
     * @return This builder for chaining.
     */
    public Builder setFindMultipleCores(boolean value) {
      bitField2_ |= 0x00200000;
      findMultipleCores_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we try to find more independent cores for a given set of
     * assumptions in the core based max-SAT algorithms.
     * </pre>
     *
     * <code>optional bool find_multiple_cores = 84 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearFindMultipleCores() {
      bitField2_ = (bitField2_ & ~0x00200000);
      findMultipleCores_ = true;
      onChanged();
      return this;
    }

    private boolean coverOptimization_ = true;
    /**
     * <pre>
     * If true, when the max-sat algo find a core, we compute the minimal number
     * of literals in the core that needs to be true to have a feasible solution.
     * </pre>
     *
     * <code>optional bool cover_optimization = 89 [default = true];</code>
     * @return Whether the coverOptimization field is set.
     */
    @java.lang.Override
    public boolean hasCoverOptimization() {
      return ((bitField2_ & 0x00400000) != 0);
    }
    /**
     * <pre>
     * If true, when the max-sat algo find a core, we compute the minimal number
     * of literals in the core that needs to be true to have a feasible solution.
     * </pre>
     *
     * <code>optional bool cover_optimization = 89 [default = true];</code>
     * @return The coverOptimization.
     */
    @java.lang.Override
    public boolean getCoverOptimization() {
      return coverOptimization_;
    }
    /**
     * <pre>
     * If true, when the max-sat algo find a core, we compute the minimal number
     * of literals in the core that needs to be true to have a feasible solution.
     * </pre>
     *
     * <code>optional bool cover_optimization = 89 [default = true];</code>
     * @param value The coverOptimization to set.
     * @return This builder for chaining.
     */
    public Builder setCoverOptimization(boolean value) {
      bitField2_ |= 0x00400000;
      coverOptimization_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, when the max-sat algo find a core, we compute the minimal number
     * of literals in the core that needs to be true to have a feasible solution.
     * </pre>
     *
     * <code>optional bool cover_optimization = 89 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearCoverOptimization() {
      bitField2_ = (bitField2_ & ~0x00400000);
      coverOptimization_ = true;
      onChanged();
      return this;
    }

    private int maxSatAssumptionOrder_ = 0;
    /**
     * <code>optional .operations_research.sat.SatParameters.MaxSatAssumptionOrder max_sat_assumption_order = 51 [default = DEFAULT_ASSUMPTION_ORDER];</code>
     * @return Whether the maxSatAssumptionOrder field is set.
     */
    @java.lang.Override public boolean hasMaxSatAssumptionOrder() {
      return ((bitField2_ & 0x00800000) != 0);
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.MaxSatAssumptionOrder max_sat_assumption_order = 51 [default = DEFAULT_ASSUMPTION_ORDER];</code>
     * @return The maxSatAssumptionOrder.
     */
    @java.lang.Override
    public com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder getMaxSatAssumptionOrder() {
      @SuppressWarnings("deprecation")
      com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder result = com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder.valueOf(maxSatAssumptionOrder_);
      return result == null ? com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder.DEFAULT_ASSUMPTION_ORDER : result;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.MaxSatAssumptionOrder max_sat_assumption_order = 51 [default = DEFAULT_ASSUMPTION_ORDER];</code>
     * @param value The maxSatAssumptionOrder to set.
     * @return This builder for chaining.
     */
    public Builder setMaxSatAssumptionOrder(com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField2_ |= 0x00800000;
      maxSatAssumptionOrder_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.MaxSatAssumptionOrder max_sat_assumption_order = 51 [default = DEFAULT_ASSUMPTION_ORDER];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxSatAssumptionOrder() {
      bitField2_ = (bitField2_ & ~0x00800000);
      maxSatAssumptionOrder_ = 0;
      onChanged();
      return this;
    }

    private boolean maxSatReverseAssumptionOrder_ ;
    /**
     * <pre>
     * If true, adds the assumption in the reverse order of the one defined by
     * max_sat_assumption_order.
     * </pre>
     *
     * <code>optional bool max_sat_reverse_assumption_order = 52 [default = false];</code>
     * @return Whether the maxSatReverseAssumptionOrder field is set.
     */
    @java.lang.Override
    public boolean hasMaxSatReverseAssumptionOrder() {
      return ((bitField2_ & 0x01000000) != 0);
    }
    /**
     * <pre>
     * If true, adds the assumption in the reverse order of the one defined by
     * max_sat_assumption_order.
     * </pre>
     *
     * <code>optional bool max_sat_reverse_assumption_order = 52 [default = false];</code>
     * @return The maxSatReverseAssumptionOrder.
     */
    @java.lang.Override
    public boolean getMaxSatReverseAssumptionOrder() {
      return maxSatReverseAssumptionOrder_;
    }
    /**
     * <pre>
     * If true, adds the assumption in the reverse order of the one defined by
     * max_sat_assumption_order.
     * </pre>
     *
     * <code>optional bool max_sat_reverse_assumption_order = 52 [default = false];</code>
     * @param value The maxSatReverseAssumptionOrder to set.
     * @return This builder for chaining.
     */
    public Builder setMaxSatReverseAssumptionOrder(boolean value) {
      bitField2_ |= 0x01000000;
      maxSatReverseAssumptionOrder_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, adds the assumption in the reverse order of the one defined by
     * max_sat_assumption_order.
     * </pre>
     *
     * <code>optional bool max_sat_reverse_assumption_order = 52 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxSatReverseAssumptionOrder() {
      bitField2_ = (bitField2_ & ~0x01000000);
      maxSatReverseAssumptionOrder_ = false;
      onChanged();
      return this;
    }

    private int maxSatStratification_ = 1;
    /**
     * <code>optional .operations_research.sat.SatParameters.MaxSatStratificationAlgorithm max_sat_stratification = 53 [default = STRATIFICATION_DESCENT];</code>
     * @return Whether the maxSatStratification field is set.
     */
    @java.lang.Override public boolean hasMaxSatStratification() {
      return ((bitField2_ & 0x02000000) != 0);
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.MaxSatStratificationAlgorithm max_sat_stratification = 53 [default = STRATIFICATION_DESCENT];</code>
     * @return The maxSatStratification.
     */
    @java.lang.Override
    public com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm getMaxSatStratification() {
      @SuppressWarnings("deprecation")
      com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm result = com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm.valueOf(maxSatStratification_);
      return result == null ? com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm.STRATIFICATION_DESCENT : result;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.MaxSatStratificationAlgorithm max_sat_stratification = 53 [default = STRATIFICATION_DESCENT];</code>
     * @param value The maxSatStratification to set.
     * @return This builder for chaining.
     */
    public Builder setMaxSatStratification(com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField2_ |= 0x02000000;
      maxSatStratification_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.MaxSatStratificationAlgorithm max_sat_stratification = 53 [default = STRATIFICATION_DESCENT];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxSatStratification() {
      bitField2_ = (bitField2_ & ~0x02000000);
      maxSatStratification_ = 1;
      onChanged();
      return this;
    }

    private boolean usePrecedencesInDisjunctiveConstraint_ = true;
    /**
     * <pre>
     * When this is true, then a disjunctive constraint will try to use the
     * precedence relations between time intervals to propagate their bounds
     * further. For instance if task A and B are both before C and task A and B
     * are in disjunction, then we can deduce that task C must start after
     * duration(A) + duration(B) instead of simply max(duration(A), duration(B)),
     * provided that the start time for all task was currently zero.
     * This always result in better propagation, but it is usually slow, so
     * depending on the problem, turning this off may lead to a faster solution.
     * </pre>
     *
     * <code>optional bool use_precedences_in_disjunctive_constraint = 74 [default = true];</code>
     * @return Whether the usePrecedencesInDisjunctiveConstraint field is set.
     */
    @java.lang.Override
    public boolean hasUsePrecedencesInDisjunctiveConstraint() {
      return ((bitField2_ & 0x04000000) != 0);
    }
    /**
     * <pre>
     * When this is true, then a disjunctive constraint will try to use the
     * precedence relations between time intervals to propagate their bounds
     * further. For instance if task A and B are both before C and task A and B
     * are in disjunction, then we can deduce that task C must start after
     * duration(A) + duration(B) instead of simply max(duration(A), duration(B)),
     * provided that the start time for all task was currently zero.
     * This always result in better propagation, but it is usually slow, so
     * depending on the problem, turning this off may lead to a faster solution.
     * </pre>
     *
     * <code>optional bool use_precedences_in_disjunctive_constraint = 74 [default = true];</code>
     * @return The usePrecedencesInDisjunctiveConstraint.
     */
    @java.lang.Override
    public boolean getUsePrecedencesInDisjunctiveConstraint() {
      return usePrecedencesInDisjunctiveConstraint_;
    }
    /**
     * <pre>
     * When this is true, then a disjunctive constraint will try to use the
     * precedence relations between time intervals to propagate their bounds
     * further. For instance if task A and B are both before C and task A and B
     * are in disjunction, then we can deduce that task C must start after
     * duration(A) + duration(B) instead of simply max(duration(A), duration(B)),
     * provided that the start time for all task was currently zero.
     * This always result in better propagation, but it is usually slow, so
     * depending on the problem, turning this off may lead to a faster solution.
     * </pre>
     *
     * <code>optional bool use_precedences_in_disjunctive_constraint = 74 [default = true];</code>
     * @param value The usePrecedencesInDisjunctiveConstraint to set.
     * @return This builder for chaining.
     */
    public Builder setUsePrecedencesInDisjunctiveConstraint(boolean value) {
      bitField2_ |= 0x04000000;
      usePrecedencesInDisjunctiveConstraint_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * When this is true, then a disjunctive constraint will try to use the
     * precedence relations between time intervals to propagate their bounds
     * further. For instance if task A and B are both before C and task A and B
     * are in disjunction, then we can deduce that task C must start after
     * duration(A) + duration(B) instead of simply max(duration(A), duration(B)),
     * provided that the start time for all task was currently zero.
     * This always result in better propagation, but it is usually slow, so
     * depending on the problem, turning this off may lead to a faster solution.
     * </pre>
     *
     * <code>optional bool use_precedences_in_disjunctive_constraint = 74 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearUsePrecedencesInDisjunctiveConstraint() {
      bitField2_ = (bitField2_ & ~0x04000000);
      usePrecedencesInDisjunctiveConstraint_ = true;
      onChanged();
      return this;
    }

    private boolean useOverloadCheckerInCumulativeConstraint_ ;
    /**
     * <pre>
     * When this is true, the cumulative constraint is reinforced with overload
     * checking, i.e., an additional level of reasoning based on energy. This
     * additional level supplements the default level of reasoning as well as
     * timetable edge finding.
     * This always result in better propagation, but it is usually slow, so
     * depending on the problem, turning this off may lead to a faster solution.
     * </pre>
     *
     * <code>optional bool use_overload_checker_in_cumulative_constraint = 78 [default = false];</code>
     * @return Whether the useOverloadCheckerInCumulativeConstraint field is set.
     */
    @java.lang.Override
    public boolean hasUseOverloadCheckerInCumulativeConstraint() {
      return ((bitField2_ & 0x08000000) != 0);
    }
    /**
     * <pre>
     * When this is true, the cumulative constraint is reinforced with overload
     * checking, i.e., an additional level of reasoning based on energy. This
     * additional level supplements the default level of reasoning as well as
     * timetable edge finding.
     * This always result in better propagation, but it is usually slow, so
     * depending on the problem, turning this off may lead to a faster solution.
     * </pre>
     *
     * <code>optional bool use_overload_checker_in_cumulative_constraint = 78 [default = false];</code>
     * @return The useOverloadCheckerInCumulativeConstraint.
     */
    @java.lang.Override
    public boolean getUseOverloadCheckerInCumulativeConstraint() {
      return useOverloadCheckerInCumulativeConstraint_;
    }
    /**
     * <pre>
     * When this is true, the cumulative constraint is reinforced with overload
     * checking, i.e., an additional level of reasoning based on energy. This
     * additional level supplements the default level of reasoning as well as
     * timetable edge finding.
     * This always result in better propagation, but it is usually slow, so
     * depending on the problem, turning this off may lead to a faster solution.
     * </pre>
     *
     * <code>optional bool use_overload_checker_in_cumulative_constraint = 78 [default = false];</code>
     * @param value The useOverloadCheckerInCumulativeConstraint to set.
     * @return This builder for chaining.
     */
    public Builder setUseOverloadCheckerInCumulativeConstraint(boolean value) {
      bitField2_ |= 0x08000000;
      useOverloadCheckerInCumulativeConstraint_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * When this is true, the cumulative constraint is reinforced with overload
     * checking, i.e., an additional level of reasoning based on energy. This
     * additional level supplements the default level of reasoning as well as
     * timetable edge finding.
     * This always result in better propagation, but it is usually slow, so
     * depending on the problem, turning this off may lead to a faster solution.
     * </pre>
     *
     * <code>optional bool use_overload_checker_in_cumulative_constraint = 78 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseOverloadCheckerInCumulativeConstraint() {
      bitField2_ = (bitField2_ & ~0x08000000);
      useOverloadCheckerInCumulativeConstraint_ = false;
      onChanged();
      return this;
    }

    private boolean useTimetableEdgeFindingInCumulativeConstraint_ ;
    /**
     * <pre>
     * When this is true, the cumulative constraint is reinforced with timetable
     * edge finding, i.e., an additional level of reasoning based on the
     * conjunction of energy and mandatory parts. This additional level
     * supplements the default level of reasoning as well as overload_checker.
     * This always result in better propagation, but it is usually slow, so
     * depending on the problem, turning this off may lead to a faster solution.
     * </pre>
     *
     * <code>optional bool use_timetable_edge_finding_in_cumulative_constraint = 79 [default = false];</code>
     * @return Whether the useTimetableEdgeFindingInCumulativeConstraint field is set.
     */
    @java.lang.Override
    public boolean hasUseTimetableEdgeFindingInCumulativeConstraint() {
      return ((bitField2_ & 0x10000000) != 0);
    }
    /**
     * <pre>
     * When this is true, the cumulative constraint is reinforced with timetable
     * edge finding, i.e., an additional level of reasoning based on the
     * conjunction of energy and mandatory parts. This additional level
     * supplements the default level of reasoning as well as overload_checker.
     * This always result in better propagation, but it is usually slow, so
     * depending on the problem, turning this off may lead to a faster solution.
     * </pre>
     *
     * <code>optional bool use_timetable_edge_finding_in_cumulative_constraint = 79 [default = false];</code>
     * @return The useTimetableEdgeFindingInCumulativeConstraint.
     */
    @java.lang.Override
    public boolean getUseTimetableEdgeFindingInCumulativeConstraint() {
      return useTimetableEdgeFindingInCumulativeConstraint_;
    }
    /**
     * <pre>
     * When this is true, the cumulative constraint is reinforced with timetable
     * edge finding, i.e., an additional level of reasoning based on the
     * conjunction of energy and mandatory parts. This additional level
     * supplements the default level of reasoning as well as overload_checker.
     * This always result in better propagation, but it is usually slow, so
     * depending on the problem, turning this off may lead to a faster solution.
     * </pre>
     *
     * <code>optional bool use_timetable_edge_finding_in_cumulative_constraint = 79 [default = false];</code>
     * @param value The useTimetableEdgeFindingInCumulativeConstraint to set.
     * @return This builder for chaining.
     */
    public Builder setUseTimetableEdgeFindingInCumulativeConstraint(boolean value) {
      bitField2_ |= 0x10000000;
      useTimetableEdgeFindingInCumulativeConstraint_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * When this is true, the cumulative constraint is reinforced with timetable
     * edge finding, i.e., an additional level of reasoning based on the
     * conjunction of energy and mandatory parts. This additional level
     * supplements the default level of reasoning as well as overload_checker.
     * This always result in better propagation, but it is usually slow, so
     * depending on the problem, turning this off may lead to a faster solution.
     * </pre>
     *
     * <code>optional bool use_timetable_edge_finding_in_cumulative_constraint = 79 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseTimetableEdgeFindingInCumulativeConstraint() {
      bitField2_ = (bitField2_ & ~0x10000000);
      useTimetableEdgeFindingInCumulativeConstraint_ = false;
      onChanged();
      return this;
    }

    private boolean useDisjunctiveConstraintInCumulativeConstraint_ = true;
    /**
     * <pre>
     * When this is true, the cumulative constraint is reinforced with propagators
     * from the disjunctive constraint to improve the inference on a set of tasks
     * that are disjunctive at the root of the problem. This additional level
     * supplements the default level of reasoning.
     * Propagators of the cumulative constraint will not be used at all if all the
     * tasks are disjunctive at root node.
     * This always result in better propagation, but it is usually slow, so
     * depending on the problem, turning this off may lead to a faster solution.
     * </pre>
     *
     * <code>optional bool use_disjunctive_constraint_in_cumulative_constraint = 80 [default = true];</code>
     * @return Whether the useDisjunctiveConstraintInCumulativeConstraint field is set.
     */
    @java.lang.Override
    public boolean hasUseDisjunctiveConstraintInCumulativeConstraint() {
      return ((bitField2_ & 0x20000000) != 0);
    }
    /**
     * <pre>
     * When this is true, the cumulative constraint is reinforced with propagators
     * from the disjunctive constraint to improve the inference on a set of tasks
     * that are disjunctive at the root of the problem. This additional level
     * supplements the default level of reasoning.
     * Propagators of the cumulative constraint will not be used at all if all the
     * tasks are disjunctive at root node.
     * This always result in better propagation, but it is usually slow, so
     * depending on the problem, turning this off may lead to a faster solution.
     * </pre>
     *
     * <code>optional bool use_disjunctive_constraint_in_cumulative_constraint = 80 [default = true];</code>
     * @return The useDisjunctiveConstraintInCumulativeConstraint.
     */
    @java.lang.Override
    public boolean getUseDisjunctiveConstraintInCumulativeConstraint() {
      return useDisjunctiveConstraintInCumulativeConstraint_;
    }
    /**
     * <pre>
     * When this is true, the cumulative constraint is reinforced with propagators
     * from the disjunctive constraint to improve the inference on a set of tasks
     * that are disjunctive at the root of the problem. This additional level
     * supplements the default level of reasoning.
     * Propagators of the cumulative constraint will not be used at all if all the
     * tasks are disjunctive at root node.
     * This always result in better propagation, but it is usually slow, so
     * depending on the problem, turning this off may lead to a faster solution.
     * </pre>
     *
     * <code>optional bool use_disjunctive_constraint_in_cumulative_constraint = 80 [default = true];</code>
     * @param value The useDisjunctiveConstraintInCumulativeConstraint to set.
     * @return This builder for chaining.
     */
    public Builder setUseDisjunctiveConstraintInCumulativeConstraint(boolean value) {
      bitField2_ |= 0x20000000;
      useDisjunctiveConstraintInCumulativeConstraint_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * When this is true, the cumulative constraint is reinforced with propagators
     * from the disjunctive constraint to improve the inference on a set of tasks
     * that are disjunctive at the root of the problem. This additional level
     * supplements the default level of reasoning.
     * Propagators of the cumulative constraint will not be used at all if all the
     * tasks are disjunctive at root node.
     * This always result in better propagation, but it is usually slow, so
     * depending on the problem, turning this off may lead to a faster solution.
     * </pre>
     *
     * <code>optional bool use_disjunctive_constraint_in_cumulative_constraint = 80 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseDisjunctiveConstraintInCumulativeConstraint() {
      bitField2_ = (bitField2_ & ~0x20000000);
      useDisjunctiveConstraintInCumulativeConstraint_ = true;
      onChanged();
      return this;
    }

    private int linearizationLevel_ = 1;
    /**
     * <pre>
     * A non-negative level indicating the type of constraints we consider in the
     * LP relaxation. At level zero, no LP relaxation is used. At level 1, only
     * the linear constraint and full encoding are added. At level 2, we also add
     * all the Boolean constraints.
     * </pre>
     *
     * <code>optional int32 linearization_level = 90 [default = 1];</code>
     * @return Whether the linearizationLevel field is set.
     */
    @java.lang.Override
    public boolean hasLinearizationLevel() {
      return ((bitField2_ & 0x40000000) != 0);
    }
    /**
     * <pre>
     * A non-negative level indicating the type of constraints we consider in the
     * LP relaxation. At level zero, no LP relaxation is used. At level 1, only
     * the linear constraint and full encoding are added. At level 2, we also add
     * all the Boolean constraints.
     * </pre>
     *
     * <code>optional int32 linearization_level = 90 [default = 1];</code>
     * @return The linearizationLevel.
     */
    @java.lang.Override
    public int getLinearizationLevel() {
      return linearizationLevel_;
    }
    /**
     * <pre>
     * A non-negative level indicating the type of constraints we consider in the
     * LP relaxation. At level zero, no LP relaxation is used. At level 1, only
     * the linear constraint and full encoding are added. At level 2, we also add
     * all the Boolean constraints.
     * </pre>
     *
     * <code>optional int32 linearization_level = 90 [default = 1];</code>
     * @param value The linearizationLevel to set.
     * @return This builder for chaining.
     */
    public Builder setLinearizationLevel(int value) {
      bitField2_ |= 0x40000000;
      linearizationLevel_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A non-negative level indicating the type of constraints we consider in the
     * LP relaxation. At level zero, no LP relaxation is used. At level 1, only
     * the linear constraint and full encoding are added. At level 2, we also add
     * all the Boolean constraints.
     * </pre>
     *
     * <code>optional int32 linearization_level = 90 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearLinearizationLevel() {
      bitField2_ = (bitField2_ & ~0x40000000);
      linearizationLevel_ = 1;
      onChanged();
      return this;
    }

    private int booleanEncodingLevel_ = 1;
    /**
     * <pre>
     * A non-negative level indicating how much we should try to fully encode
     * Integer variables as Boolean.
     * </pre>
     *
     * <code>optional int32 boolean_encoding_level = 107 [default = 1];</code>
     * @return Whether the booleanEncodingLevel field is set.
     */
    @java.lang.Override
    public boolean hasBooleanEncodingLevel() {
      return ((bitField2_ & 0x80000000) != 0);
    }
    /**
     * <pre>
     * A non-negative level indicating how much we should try to fully encode
     * Integer variables as Boolean.
     * </pre>
     *
     * <code>optional int32 boolean_encoding_level = 107 [default = 1];</code>
     * @return The booleanEncodingLevel.
     */
    @java.lang.Override
    public int getBooleanEncodingLevel() {
      return booleanEncodingLevel_;
    }
    /**
     * <pre>
     * A non-negative level indicating how much we should try to fully encode
     * Integer variables as Boolean.
     * </pre>
     *
     * <code>optional int32 boolean_encoding_level = 107 [default = 1];</code>
     * @param value The booleanEncodingLevel to set.
     * @return This builder for chaining.
     */
    public Builder setBooleanEncodingLevel(int value) {
      bitField2_ |= 0x80000000;
      booleanEncodingLevel_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A non-negative level indicating how much we should try to fully encode
     * Integer variables as Boolean.
     * </pre>
     *
     * <code>optional int32 boolean_encoding_level = 107 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearBooleanEncodingLevel() {
      bitField2_ = (bitField2_ & ~0x80000000);
      booleanEncodingLevel_ = 1;
      onChanged();
      return this;
    }

    private int maxDomainSizeWhenEncodingEqNeqConstraints_ = 16;
    /**
     * <pre>
     * When loading a*x + b*y ==/!= c when x and y are both fully encoded.
     * The solver may decide to replace the linear equation by a set of clauses.
     * This is triggered if the sizes of the domains of x and y are below the
     * threshold.
     * </pre>
     *
     * <code>optional int32 max_domain_size_when_encoding_eq_neq_constraints = 191 [default = 16];</code>
     * @return Whether the maxDomainSizeWhenEncodingEqNeqConstraints field is set.
     */
    @java.lang.Override
    public boolean hasMaxDomainSizeWhenEncodingEqNeqConstraints() {
      return ((bitField3_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * When loading a*x + b*y ==/!= c when x and y are both fully encoded.
     * The solver may decide to replace the linear equation by a set of clauses.
     * This is triggered if the sizes of the domains of x and y are below the
     * threshold.
     * </pre>
     *
     * <code>optional int32 max_domain_size_when_encoding_eq_neq_constraints = 191 [default = 16];</code>
     * @return The maxDomainSizeWhenEncodingEqNeqConstraints.
     */
    @java.lang.Override
    public int getMaxDomainSizeWhenEncodingEqNeqConstraints() {
      return maxDomainSizeWhenEncodingEqNeqConstraints_;
    }
    /**
     * <pre>
     * When loading a*x + b*y ==/!= c when x and y are both fully encoded.
     * The solver may decide to replace the linear equation by a set of clauses.
     * This is triggered if the sizes of the domains of x and y are below the
     * threshold.
     * </pre>
     *
     * <code>optional int32 max_domain_size_when_encoding_eq_neq_constraints = 191 [default = 16];</code>
     * @param value The maxDomainSizeWhenEncodingEqNeqConstraints to set.
     * @return This builder for chaining.
     */
    public Builder setMaxDomainSizeWhenEncodingEqNeqConstraints(int value) {
      bitField3_ |= 0x00000001;
      maxDomainSizeWhenEncodingEqNeqConstraints_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * When loading a*x + b*y ==/!= c when x and y are both fully encoded.
     * The solver may decide to replace the linear equation by a set of clauses.
     * This is triggered if the sizes of the domains of x and y are below the
     * threshold.
     * </pre>
     *
     * <code>optional int32 max_domain_size_when_encoding_eq_neq_constraints = 191 [default = 16];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxDomainSizeWhenEncodingEqNeqConstraints() {
      bitField3_ = (bitField3_ & ~0x00000001);
      maxDomainSizeWhenEncodingEqNeqConstraints_ = 16;
      onChanged();
      return this;
    }

    private int maxNumCuts_ = 10000;
    /**
     * <pre>
     * The limit on the number of cuts in our cut pool. When this is reached we do
     * not generate cuts anymore.
     * TODO(user): We should probably remove this parameters, and just always
     * generate cuts but only keep the best n or something.
     * </pre>
     *
     * <code>optional int32 max_num_cuts = 91 [default = 10000];</code>
     * @return Whether the maxNumCuts field is set.
     */
    @java.lang.Override
    public boolean hasMaxNumCuts() {
      return ((bitField3_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * The limit on the number of cuts in our cut pool. When this is reached we do
     * not generate cuts anymore.
     * TODO(user): We should probably remove this parameters, and just always
     * generate cuts but only keep the best n or something.
     * </pre>
     *
     * <code>optional int32 max_num_cuts = 91 [default = 10000];</code>
     * @return The maxNumCuts.
     */
    @java.lang.Override
    public int getMaxNumCuts() {
      return maxNumCuts_;
    }
    /**
     * <pre>
     * The limit on the number of cuts in our cut pool. When this is reached we do
     * not generate cuts anymore.
     * TODO(user): We should probably remove this parameters, and just always
     * generate cuts but only keep the best n or something.
     * </pre>
     *
     * <code>optional int32 max_num_cuts = 91 [default = 10000];</code>
     * @param value The maxNumCuts to set.
     * @return This builder for chaining.
     */
    public Builder setMaxNumCuts(int value) {
      bitField3_ |= 0x00000002;
      maxNumCuts_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The limit on the number of cuts in our cut pool. When this is reached we do
     * not generate cuts anymore.
     * TODO(user): We should probably remove this parameters, and just always
     * generate cuts but only keep the best n or something.
     * </pre>
     *
     * <code>optional int32 max_num_cuts = 91 [default = 10000];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxNumCuts() {
      bitField3_ = (bitField3_ & ~0x00000002);
      maxNumCuts_ = 10000;
      onChanged();
      return this;
    }

    private boolean onlyAddCutsAtLevelZero_ ;
    /**
     * <pre>
     * For the cut that can be generated at any level, this control if we only
     * try to generate them at the root node.
     * </pre>
     *
     * <code>optional bool only_add_cuts_at_level_zero = 92 [default = false];</code>
     * @return Whether the onlyAddCutsAtLevelZero field is set.
     */
    @java.lang.Override
    public boolean hasOnlyAddCutsAtLevelZero() {
      return ((bitField3_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * For the cut that can be generated at any level, this control if we only
     * try to generate them at the root node.
     * </pre>
     *
     * <code>optional bool only_add_cuts_at_level_zero = 92 [default = false];</code>
     * @return The onlyAddCutsAtLevelZero.
     */
    @java.lang.Override
    public boolean getOnlyAddCutsAtLevelZero() {
      return onlyAddCutsAtLevelZero_;
    }
    /**
     * <pre>
     * For the cut that can be generated at any level, this control if we only
     * try to generate them at the root node.
     * </pre>
     *
     * <code>optional bool only_add_cuts_at_level_zero = 92 [default = false];</code>
     * @param value The onlyAddCutsAtLevelZero to set.
     * @return This builder for chaining.
     */
    public Builder setOnlyAddCutsAtLevelZero(boolean value) {
      bitField3_ |= 0x00000004;
      onlyAddCutsAtLevelZero_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * For the cut that can be generated at any level, this control if we only
     * try to generate them at the root node.
     * </pre>
     *
     * <code>optional bool only_add_cuts_at_level_zero = 92 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearOnlyAddCutsAtLevelZero() {
      bitField3_ = (bitField3_ & ~0x00000004);
      onlyAddCutsAtLevelZero_ = false;
      onChanged();
      return this;
    }

    private boolean addKnapsackCuts_ ;
    /**
     * <pre>
     * Whether we generate knapsack cuts. Note that in our setting where all
     * variables are integer and bounded on both side, such a cut could be applied
     * to any constraint.
     * </pre>
     *
     * <code>optional bool add_knapsack_cuts = 111 [default = false];</code>
     * @return Whether the addKnapsackCuts field is set.
     */
    @java.lang.Override
    public boolean hasAddKnapsackCuts() {
      return ((bitField3_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * Whether we generate knapsack cuts. Note that in our setting where all
     * variables are integer and bounded on both side, such a cut could be applied
     * to any constraint.
     * </pre>
     *
     * <code>optional bool add_knapsack_cuts = 111 [default = false];</code>
     * @return The addKnapsackCuts.
     */
    @java.lang.Override
    public boolean getAddKnapsackCuts() {
      return addKnapsackCuts_;
    }
    /**
     * <pre>
     * Whether we generate knapsack cuts. Note that in our setting where all
     * variables are integer and bounded on both side, such a cut could be applied
     * to any constraint.
     * </pre>
     *
     * <code>optional bool add_knapsack_cuts = 111 [default = false];</code>
     * @param value The addKnapsackCuts to set.
     * @return This builder for chaining.
     */
    public Builder setAddKnapsackCuts(boolean value) {
      bitField3_ |= 0x00000008;
      addKnapsackCuts_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we generate knapsack cuts. Note that in our setting where all
     * variables are integer and bounded on both side, such a cut could be applied
     * to any constraint.
     * </pre>
     *
     * <code>optional bool add_knapsack_cuts = 111 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearAddKnapsackCuts() {
      bitField3_ = (bitField3_ & ~0x00000008);
      addKnapsackCuts_ = false;
      onChanged();
      return this;
    }

    private boolean addCgCuts_ = true;
    /**
     * <pre>
     * Whether we generate and add Chvatal-Gomory cuts to the LP at root node.
     * Note that for now, this is not heavily tuned.
     * </pre>
     *
     * <code>optional bool add_cg_cuts = 117 [default = true];</code>
     * @return Whether the addCgCuts field is set.
     */
    @java.lang.Override
    public boolean hasAddCgCuts() {
      return ((bitField3_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * Whether we generate and add Chvatal-Gomory cuts to the LP at root node.
     * Note that for now, this is not heavily tuned.
     * </pre>
     *
     * <code>optional bool add_cg_cuts = 117 [default = true];</code>
     * @return The addCgCuts.
     */
    @java.lang.Override
    public boolean getAddCgCuts() {
      return addCgCuts_;
    }
    /**
     * <pre>
     * Whether we generate and add Chvatal-Gomory cuts to the LP at root node.
     * Note that for now, this is not heavily tuned.
     * </pre>
     *
     * <code>optional bool add_cg_cuts = 117 [default = true];</code>
     * @param value The addCgCuts to set.
     * @return This builder for chaining.
     */
    public Builder setAddCgCuts(boolean value) {
      bitField3_ |= 0x00000010;
      addCgCuts_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we generate and add Chvatal-Gomory cuts to the LP at root node.
     * Note that for now, this is not heavily tuned.
     * </pre>
     *
     * <code>optional bool add_cg_cuts = 117 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearAddCgCuts() {
      bitField3_ = (bitField3_ & ~0x00000010);
      addCgCuts_ = true;
      onChanged();
      return this;
    }

    private boolean addMirCuts_ = true;
    /**
     * <pre>
     * Whether we generate MIR cuts at root node.
     * Note that for now, this is not heavily tuned.
     * </pre>
     *
     * <code>optional bool add_mir_cuts = 120 [default = true];</code>
     * @return Whether the addMirCuts field is set.
     */
    @java.lang.Override
    public boolean hasAddMirCuts() {
      return ((bitField3_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * Whether we generate MIR cuts at root node.
     * Note that for now, this is not heavily tuned.
     * </pre>
     *
     * <code>optional bool add_mir_cuts = 120 [default = true];</code>
     * @return The addMirCuts.
     */
    @java.lang.Override
    public boolean getAddMirCuts() {
      return addMirCuts_;
    }
    /**
     * <pre>
     * Whether we generate MIR cuts at root node.
     * Note that for now, this is not heavily tuned.
     * </pre>
     *
     * <code>optional bool add_mir_cuts = 120 [default = true];</code>
     * @param value The addMirCuts to set.
     * @return This builder for chaining.
     */
    public Builder setAddMirCuts(boolean value) {
      bitField3_ |= 0x00000020;
      addMirCuts_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we generate MIR cuts at root node.
     * Note that for now, this is not heavily tuned.
     * </pre>
     *
     * <code>optional bool add_mir_cuts = 120 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearAddMirCuts() {
      bitField3_ = (bitField3_ & ~0x00000020);
      addMirCuts_ = true;
      onChanged();
      return this;
    }

    private boolean addZeroHalfCuts_ = true;
    /**
     * <pre>
     * Whether we generate Zero-Half cuts at root node.
     * Note that for now, this is not heavily tuned.
     * </pre>
     *
     * <code>optional bool add_zero_half_cuts = 169 [default = true];</code>
     * @return Whether the addZeroHalfCuts field is set.
     */
    @java.lang.Override
    public boolean hasAddZeroHalfCuts() {
      return ((bitField3_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * Whether we generate Zero-Half cuts at root node.
     * Note that for now, this is not heavily tuned.
     * </pre>
     *
     * <code>optional bool add_zero_half_cuts = 169 [default = true];</code>
     * @return The addZeroHalfCuts.
     */
    @java.lang.Override
    public boolean getAddZeroHalfCuts() {
      return addZeroHalfCuts_;
    }
    /**
     * <pre>
     * Whether we generate Zero-Half cuts at root node.
     * Note that for now, this is not heavily tuned.
     * </pre>
     *
     * <code>optional bool add_zero_half_cuts = 169 [default = true];</code>
     * @param value The addZeroHalfCuts to set.
     * @return This builder for chaining.
     */
    public Builder setAddZeroHalfCuts(boolean value) {
      bitField3_ |= 0x00000040;
      addZeroHalfCuts_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we generate Zero-Half cuts at root node.
     * Note that for now, this is not heavily tuned.
     * </pre>
     *
     * <code>optional bool add_zero_half_cuts = 169 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearAddZeroHalfCuts() {
      bitField3_ = (bitField3_ & ~0x00000040);
      addZeroHalfCuts_ = true;
      onChanged();
      return this;
    }

    private boolean addCliqueCuts_ = true;
    /**
     * <pre>
     * Whether we generate clique cuts from the binary implication graph. Note
     * that as the search goes on, this graph will contains new binary clauses
     * learned by the SAT engine.
     * </pre>
     *
     * <code>optional bool add_clique_cuts = 172 [default = true];</code>
     * @return Whether the addCliqueCuts field is set.
     */
    @java.lang.Override
    public boolean hasAddCliqueCuts() {
      return ((bitField3_ & 0x00000080) != 0);
    }
    /**
     * <pre>
     * Whether we generate clique cuts from the binary implication graph. Note
     * that as the search goes on, this graph will contains new binary clauses
     * learned by the SAT engine.
     * </pre>
     *
     * <code>optional bool add_clique_cuts = 172 [default = true];</code>
     * @return The addCliqueCuts.
     */
    @java.lang.Override
    public boolean getAddCliqueCuts() {
      return addCliqueCuts_;
    }
    /**
     * <pre>
     * Whether we generate clique cuts from the binary implication graph. Note
     * that as the search goes on, this graph will contains new binary clauses
     * learned by the SAT engine.
     * </pre>
     *
     * <code>optional bool add_clique_cuts = 172 [default = true];</code>
     * @param value The addCliqueCuts to set.
     * @return This builder for chaining.
     */
    public Builder setAddCliqueCuts(boolean value) {
      bitField3_ |= 0x00000080;
      addCliqueCuts_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we generate clique cuts from the binary implication graph. Note
     * that as the search goes on, this graph will contains new binary clauses
     * learned by the SAT engine.
     * </pre>
     *
     * <code>optional bool add_clique_cuts = 172 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearAddCliqueCuts() {
      bitField3_ = (bitField3_ & ~0x00000080);
      addCliqueCuts_ = true;
      onChanged();
      return this;
    }

    private int maxAllDiffCutSize_ = 7;
    /**
     * <pre>
     * Cut generator for all diffs can add too many cuts for large all_diff
     * constraints. This parameter restricts the large all_diff constraints to
     * have a cut generator.
     * </pre>
     *
     * <code>optional int32 max_all_diff_cut_size = 148 [default = 7];</code>
     * @return Whether the maxAllDiffCutSize field is set.
     */
    @java.lang.Override
    public boolean hasMaxAllDiffCutSize() {
      return ((bitField3_ & 0x00000100) != 0);
    }
    /**
     * <pre>
     * Cut generator for all diffs can add too many cuts for large all_diff
     * constraints. This parameter restricts the large all_diff constraints to
     * have a cut generator.
     * </pre>
     *
     * <code>optional int32 max_all_diff_cut_size = 148 [default = 7];</code>
     * @return The maxAllDiffCutSize.
     */
    @java.lang.Override
    public int getMaxAllDiffCutSize() {
      return maxAllDiffCutSize_;
    }
    /**
     * <pre>
     * Cut generator for all diffs can add too many cuts for large all_diff
     * constraints. This parameter restricts the large all_diff constraints to
     * have a cut generator.
     * </pre>
     *
     * <code>optional int32 max_all_diff_cut_size = 148 [default = 7];</code>
     * @param value The maxAllDiffCutSize to set.
     * @return This builder for chaining.
     */
    public Builder setMaxAllDiffCutSize(int value) {
      bitField3_ |= 0x00000100;
      maxAllDiffCutSize_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Cut generator for all diffs can add too many cuts for large all_diff
     * constraints. This parameter restricts the large all_diff constraints to
     * have a cut generator.
     * </pre>
     *
     * <code>optional int32 max_all_diff_cut_size = 148 [default = 7];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxAllDiffCutSize() {
      bitField3_ = (bitField3_ & ~0x00000100);
      maxAllDiffCutSize_ = 7;
      onChanged();
      return this;
    }

    private boolean addLinMaxCuts_ = true;
    /**
     * <pre>
     * For the lin max constraints, generates the cuts described in "Strong
     * mixed-integer programming formulations for trained neural networks" by Ross
     * Anderson et. (https://arxiv.org/pdf/1811.01988.pdf)
     * </pre>
     *
     * <code>optional bool add_lin_max_cuts = 152 [default = true];</code>
     * @return Whether the addLinMaxCuts field is set.
     */
    @java.lang.Override
    public boolean hasAddLinMaxCuts() {
      return ((bitField3_ & 0x00000200) != 0);
    }
    /**
     * <pre>
     * For the lin max constraints, generates the cuts described in "Strong
     * mixed-integer programming formulations for trained neural networks" by Ross
     * Anderson et. (https://arxiv.org/pdf/1811.01988.pdf)
     * </pre>
     *
     * <code>optional bool add_lin_max_cuts = 152 [default = true];</code>
     * @return The addLinMaxCuts.
     */
    @java.lang.Override
    public boolean getAddLinMaxCuts() {
      return addLinMaxCuts_;
    }
    /**
     * <pre>
     * For the lin max constraints, generates the cuts described in "Strong
     * mixed-integer programming formulations for trained neural networks" by Ross
     * Anderson et. (https://arxiv.org/pdf/1811.01988.pdf)
     * </pre>
     *
     * <code>optional bool add_lin_max_cuts = 152 [default = true];</code>
     * @param value The addLinMaxCuts to set.
     * @return This builder for chaining.
     */
    public Builder setAddLinMaxCuts(boolean value) {
      bitField3_ |= 0x00000200;
      addLinMaxCuts_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * For the lin max constraints, generates the cuts described in "Strong
     * mixed-integer programming formulations for trained neural networks" by Ross
     * Anderson et. (https://arxiv.org/pdf/1811.01988.pdf)
     * </pre>
     *
     * <code>optional bool add_lin_max_cuts = 152 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearAddLinMaxCuts() {
      bitField3_ = (bitField3_ & ~0x00000200);
      addLinMaxCuts_ = true;
      onChanged();
      return this;
    }

    private int maxIntegerRoundingScaling_ = 600;
    /**
     * <pre>
     * In the integer rounding procedure used for MIR and Gomory cut, the maximum
     * "scaling" we use (must be positive). The lower this is, the lower the
     * integer coefficients of the cut will be. Note that cut generated by lower
     * values are not necessarily worse than cut generated by larger value. There
     * is no strict dominance relationship.
     * Setting this to 2 result in the "strong fractional rouding" of Letchford
     * and Lodi.
     * </pre>
     *
     * <code>optional int32 max_integer_rounding_scaling = 119 [default = 600];</code>
     * @return Whether the maxIntegerRoundingScaling field is set.
     */
    @java.lang.Override
    public boolean hasMaxIntegerRoundingScaling() {
      return ((bitField3_ & 0x00000400) != 0);
    }
    /**
     * <pre>
     * In the integer rounding procedure used for MIR and Gomory cut, the maximum
     * "scaling" we use (must be positive). The lower this is, the lower the
     * integer coefficients of the cut will be. Note that cut generated by lower
     * values are not necessarily worse than cut generated by larger value. There
     * is no strict dominance relationship.
     * Setting this to 2 result in the "strong fractional rouding" of Letchford
     * and Lodi.
     * </pre>
     *
     * <code>optional int32 max_integer_rounding_scaling = 119 [default = 600];</code>
     * @return The maxIntegerRoundingScaling.
     */
    @java.lang.Override
    public int getMaxIntegerRoundingScaling() {
      return maxIntegerRoundingScaling_;
    }
    /**
     * <pre>
     * In the integer rounding procedure used for MIR and Gomory cut, the maximum
     * "scaling" we use (must be positive). The lower this is, the lower the
     * integer coefficients of the cut will be. Note that cut generated by lower
     * values are not necessarily worse than cut generated by larger value. There
     * is no strict dominance relationship.
     * Setting this to 2 result in the "strong fractional rouding" of Letchford
     * and Lodi.
     * </pre>
     *
     * <code>optional int32 max_integer_rounding_scaling = 119 [default = 600];</code>
     * @param value The maxIntegerRoundingScaling to set.
     * @return This builder for chaining.
     */
    public Builder setMaxIntegerRoundingScaling(int value) {
      bitField3_ |= 0x00000400;
      maxIntegerRoundingScaling_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * In the integer rounding procedure used for MIR and Gomory cut, the maximum
     * "scaling" we use (must be positive). The lower this is, the lower the
     * integer coefficients of the cut will be. Note that cut generated by lower
     * values are not necessarily worse than cut generated by larger value. There
     * is no strict dominance relationship.
     * Setting this to 2 result in the "strong fractional rouding" of Letchford
     * and Lodi.
     * </pre>
     *
     * <code>optional int32 max_integer_rounding_scaling = 119 [default = 600];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxIntegerRoundingScaling() {
      bitField3_ = (bitField3_ & ~0x00000400);
      maxIntegerRoundingScaling_ = 600;
      onChanged();
      return this;
    }

    private boolean addLpConstraintsLazily_ = true;
    /**
     * <pre>
     * If true, we start by an empty LP, and only add constraints not satisfied
     * by the current LP solution batch by batch. A constraint that is only added
     * like this is known as a "lazy" constraint in the literature, except that we
     * currently consider all constraints as lazy here.
     * </pre>
     *
     * <code>optional bool add_lp_constraints_lazily = 112 [default = true];</code>
     * @return Whether the addLpConstraintsLazily field is set.
     */
    @java.lang.Override
    public boolean hasAddLpConstraintsLazily() {
      return ((bitField3_ & 0x00000800) != 0);
    }
    /**
     * <pre>
     * If true, we start by an empty LP, and only add constraints not satisfied
     * by the current LP solution batch by batch. A constraint that is only added
     * like this is known as a "lazy" constraint in the literature, except that we
     * currently consider all constraints as lazy here.
     * </pre>
     *
     * <code>optional bool add_lp_constraints_lazily = 112 [default = true];</code>
     * @return The addLpConstraintsLazily.
     */
    @java.lang.Override
    public boolean getAddLpConstraintsLazily() {
      return addLpConstraintsLazily_;
    }
    /**
     * <pre>
     * If true, we start by an empty LP, and only add constraints not satisfied
     * by the current LP solution batch by batch. A constraint that is only added
     * like this is known as a "lazy" constraint in the literature, except that we
     * currently consider all constraints as lazy here.
     * </pre>
     *
     * <code>optional bool add_lp_constraints_lazily = 112 [default = true];</code>
     * @param value The addLpConstraintsLazily to set.
     * @return This builder for chaining.
     */
    public Builder setAddLpConstraintsLazily(boolean value) {
      bitField3_ |= 0x00000800;
      addLpConstraintsLazily_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, we start by an empty LP, and only add constraints not satisfied
     * by the current LP solution batch by batch. A constraint that is only added
     * like this is known as a "lazy" constraint in the literature, except that we
     * currently consider all constraints as lazy here.
     * </pre>
     *
     * <code>optional bool add_lp_constraints_lazily = 112 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearAddLpConstraintsLazily() {
      bitField3_ = (bitField3_ & ~0x00000800);
      addLpConstraintsLazily_ = true;
      onChanged();
      return this;
    }

    private double minOrthogonalityForLpConstraints_ = 0.05D;
    /**
     * <pre>
     * While adding constraints, skip the constraints which have orthogonality
     * less than 'min_orthogonality_for_lp_constraints' with already added
     * constraints during current call. Orthogonality is defined as 1 -
     * cosine(vector angle between constraints). A value of zero disable this
     * feature.
     * </pre>
     *
     * <code>optional double min_orthogonality_for_lp_constraints = 115 [default = 0.05];</code>
     * @return Whether the minOrthogonalityForLpConstraints field is set.
     */
    @java.lang.Override
    public boolean hasMinOrthogonalityForLpConstraints() {
      return ((bitField3_ & 0x00001000) != 0);
    }
    /**
     * <pre>
     * While adding constraints, skip the constraints which have orthogonality
     * less than 'min_orthogonality_for_lp_constraints' with already added
     * constraints during current call. Orthogonality is defined as 1 -
     * cosine(vector angle between constraints). A value of zero disable this
     * feature.
     * </pre>
     *
     * <code>optional double min_orthogonality_for_lp_constraints = 115 [default = 0.05];</code>
     * @return The minOrthogonalityForLpConstraints.
     */
    @java.lang.Override
    public double getMinOrthogonalityForLpConstraints() {
      return minOrthogonalityForLpConstraints_;
    }
    /**
     * <pre>
     * While adding constraints, skip the constraints which have orthogonality
     * less than 'min_orthogonality_for_lp_constraints' with already added
     * constraints during current call. Orthogonality is defined as 1 -
     * cosine(vector angle between constraints). A value of zero disable this
     * feature.
     * </pre>
     *
     * <code>optional double min_orthogonality_for_lp_constraints = 115 [default = 0.05];</code>
     * @param value The minOrthogonalityForLpConstraints to set.
     * @return This builder for chaining.
     */
    public Builder setMinOrthogonalityForLpConstraints(double value) {
      bitField3_ |= 0x00001000;
      minOrthogonalityForLpConstraints_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * While adding constraints, skip the constraints which have orthogonality
     * less than 'min_orthogonality_for_lp_constraints' with already added
     * constraints during current call. Orthogonality is defined as 1 -
     * cosine(vector angle between constraints). A value of zero disable this
     * feature.
     * </pre>
     *
     * <code>optional double min_orthogonality_for_lp_constraints = 115 [default = 0.05];</code>
     * @return This builder for chaining.
     */
    public Builder clearMinOrthogonalityForLpConstraints() {
      bitField3_ = (bitField3_ & ~0x00001000);
      minOrthogonalityForLpConstraints_ = 0.05D;
      onChanged();
      return this;
    }

    private int maxCutRoundsAtLevelZero_ = 1;
    /**
     * <pre>
     * Max number of time we perform cut generation and resolve the LP at level 0.
     * </pre>
     *
     * <code>optional int32 max_cut_rounds_at_level_zero = 154 [default = 1];</code>
     * @return Whether the maxCutRoundsAtLevelZero field is set.
     */
    @java.lang.Override
    public boolean hasMaxCutRoundsAtLevelZero() {
      return ((bitField3_ & 0x00002000) != 0);
    }
    /**
     * <pre>
     * Max number of time we perform cut generation and resolve the LP at level 0.
     * </pre>
     *
     * <code>optional int32 max_cut_rounds_at_level_zero = 154 [default = 1];</code>
     * @return The maxCutRoundsAtLevelZero.
     */
    @java.lang.Override
    public int getMaxCutRoundsAtLevelZero() {
      return maxCutRoundsAtLevelZero_;
    }
    /**
     * <pre>
     * Max number of time we perform cut generation and resolve the LP at level 0.
     * </pre>
     *
     * <code>optional int32 max_cut_rounds_at_level_zero = 154 [default = 1];</code>
     * @param value The maxCutRoundsAtLevelZero to set.
     * @return This builder for chaining.
     */
    public Builder setMaxCutRoundsAtLevelZero(int value) {
      bitField3_ |= 0x00002000;
      maxCutRoundsAtLevelZero_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Max number of time we perform cut generation and resolve the LP at level 0.
     * </pre>
     *
     * <code>optional int32 max_cut_rounds_at_level_zero = 154 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxCutRoundsAtLevelZero() {
      bitField3_ = (bitField3_ & ~0x00002000);
      maxCutRoundsAtLevelZero_ = 1;
      onChanged();
      return this;
    }

    private int maxConsecutiveInactiveCount_ = 100;
    /**
     * <pre>
     * If a constraint/cut in LP is not active for that many consecutive OPTIMAL
     * solves, remove it from the LP. Note that it might be added again later if
     * it become violated by the current LP solution.
     * </pre>
     *
     * <code>optional int32 max_consecutive_inactive_count = 121 [default = 100];</code>
     * @return Whether the maxConsecutiveInactiveCount field is set.
     */
    @java.lang.Override
    public boolean hasMaxConsecutiveInactiveCount() {
      return ((bitField3_ & 0x00004000) != 0);
    }
    /**
     * <pre>
     * If a constraint/cut in LP is not active for that many consecutive OPTIMAL
     * solves, remove it from the LP. Note that it might be added again later if
     * it become violated by the current LP solution.
     * </pre>
     *
     * <code>optional int32 max_consecutive_inactive_count = 121 [default = 100];</code>
     * @return The maxConsecutiveInactiveCount.
     */
    @java.lang.Override
    public int getMaxConsecutiveInactiveCount() {
      return maxConsecutiveInactiveCount_;
    }
    /**
     * <pre>
     * If a constraint/cut in LP is not active for that many consecutive OPTIMAL
     * solves, remove it from the LP. Note that it might be added again later if
     * it become violated by the current LP solution.
     * </pre>
     *
     * <code>optional int32 max_consecutive_inactive_count = 121 [default = 100];</code>
     * @param value The maxConsecutiveInactiveCount to set.
     * @return This builder for chaining.
     */
    public Builder setMaxConsecutiveInactiveCount(int value) {
      bitField3_ |= 0x00004000;
      maxConsecutiveInactiveCount_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If a constraint/cut in LP is not active for that many consecutive OPTIMAL
     * solves, remove it from the LP. Note that it might be added again later if
     * it become violated by the current LP solution.
     * </pre>
     *
     * <code>optional int32 max_consecutive_inactive_count = 121 [default = 100];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxConsecutiveInactiveCount() {
      bitField3_ = (bitField3_ & ~0x00004000);
      maxConsecutiveInactiveCount_ = 100;
      onChanged();
      return this;
    }

    private double cutMaxActiveCountValue_ = 10000000000D;
    /**
     * <pre>
     * These parameters are similar to sat clause management activity parameters.
     * They are effective only if the number of generated cuts exceed the storage
     * limit. Default values are based on a few experiments on miplib instances.
     * </pre>
     *
     * <code>optional double cut_max_active_count_value = 155 [default = 10000000000];</code>
     * @return Whether the cutMaxActiveCountValue field is set.
     */
    @java.lang.Override
    public boolean hasCutMaxActiveCountValue() {
      return ((bitField3_ & 0x00008000) != 0);
    }
    /**
     * <pre>
     * These parameters are similar to sat clause management activity parameters.
     * They are effective only if the number of generated cuts exceed the storage
     * limit. Default values are based on a few experiments on miplib instances.
     * </pre>
     *
     * <code>optional double cut_max_active_count_value = 155 [default = 10000000000];</code>
     * @return The cutMaxActiveCountValue.
     */
    @java.lang.Override
    public double getCutMaxActiveCountValue() {
      return cutMaxActiveCountValue_;
    }
    /**
     * <pre>
     * These parameters are similar to sat clause management activity parameters.
     * They are effective only if the number of generated cuts exceed the storage
     * limit. Default values are based on a few experiments on miplib instances.
     * </pre>
     *
     * <code>optional double cut_max_active_count_value = 155 [default = 10000000000];</code>
     * @param value The cutMaxActiveCountValue to set.
     * @return This builder for chaining.
     */
    public Builder setCutMaxActiveCountValue(double value) {
      bitField3_ |= 0x00008000;
      cutMaxActiveCountValue_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * These parameters are similar to sat clause management activity parameters.
     * They are effective only if the number of generated cuts exceed the storage
     * limit. Default values are based on a few experiments on miplib instances.
     * </pre>
     *
     * <code>optional double cut_max_active_count_value = 155 [default = 10000000000];</code>
     * @return This builder for chaining.
     */
    public Builder clearCutMaxActiveCountValue() {
      bitField3_ = (bitField3_ & ~0x00008000);
      cutMaxActiveCountValue_ = 10000000000D;
      onChanged();
      return this;
    }

    private double cutActiveCountDecay_ = 0.8D;
    /**
     * <code>optional double cut_active_count_decay = 156 [default = 0.8];</code>
     * @return Whether the cutActiveCountDecay field is set.
     */
    @java.lang.Override
    public boolean hasCutActiveCountDecay() {
      return ((bitField3_ & 0x00010000) != 0);
    }
    /**
     * <code>optional double cut_active_count_decay = 156 [default = 0.8];</code>
     * @return The cutActiveCountDecay.
     */
    @java.lang.Override
    public double getCutActiveCountDecay() {
      return cutActiveCountDecay_;
    }
    /**
     * <code>optional double cut_active_count_decay = 156 [default = 0.8];</code>
     * @param value The cutActiveCountDecay to set.
     * @return This builder for chaining.
     */
    public Builder setCutActiveCountDecay(double value) {
      bitField3_ |= 0x00010000;
      cutActiveCountDecay_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional double cut_active_count_decay = 156 [default = 0.8];</code>
     * @return This builder for chaining.
     */
    public Builder clearCutActiveCountDecay() {
      bitField3_ = (bitField3_ & ~0x00010000);
      cutActiveCountDecay_ = 0.8D;
      onChanged();
      return this;
    }

    private int cutCleanupTarget_ = 1000;
    /**
     * <pre>
     * Target number of constraints to remove during cleanup.
     * </pre>
     *
     * <code>optional int32 cut_cleanup_target = 157 [default = 1000];</code>
     * @return Whether the cutCleanupTarget field is set.
     */
    @java.lang.Override
    public boolean hasCutCleanupTarget() {
      return ((bitField3_ & 0x00020000) != 0);
    }
    /**
     * <pre>
     * Target number of constraints to remove during cleanup.
     * </pre>
     *
     * <code>optional int32 cut_cleanup_target = 157 [default = 1000];</code>
     * @return The cutCleanupTarget.
     */
    @java.lang.Override
    public int getCutCleanupTarget() {
      return cutCleanupTarget_;
    }
    /**
     * <pre>
     * Target number of constraints to remove during cleanup.
     * </pre>
     *
     * <code>optional int32 cut_cleanup_target = 157 [default = 1000];</code>
     * @param value The cutCleanupTarget to set.
     * @return This builder for chaining.
     */
    public Builder setCutCleanupTarget(int value) {
      bitField3_ |= 0x00020000;
      cutCleanupTarget_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Target number of constraints to remove during cleanup.
     * </pre>
     *
     * <code>optional int32 cut_cleanup_target = 157 [default = 1000];</code>
     * @return This builder for chaining.
     */
    public Builder clearCutCleanupTarget() {
      bitField3_ = (bitField3_ & ~0x00020000);
      cutCleanupTarget_ = 1000;
      onChanged();
      return this;
    }

    private int newConstraintsBatchSize_ = 50;
    /**
     * <pre>
     * Add that many lazy constraints (or cuts) at once in the LP. Note that at
     * the beginning of the solve, we do add more than this.
     * </pre>
     *
     * <code>optional int32 new_constraints_batch_size = 122 [default = 50];</code>
     * @return Whether the newConstraintsBatchSize field is set.
     */
    @java.lang.Override
    public boolean hasNewConstraintsBatchSize() {
      return ((bitField3_ & 0x00040000) != 0);
    }
    /**
     * <pre>
     * Add that many lazy constraints (or cuts) at once in the LP. Note that at
     * the beginning of the solve, we do add more than this.
     * </pre>
     *
     * <code>optional int32 new_constraints_batch_size = 122 [default = 50];</code>
     * @return The newConstraintsBatchSize.
     */
    @java.lang.Override
    public int getNewConstraintsBatchSize() {
      return newConstraintsBatchSize_;
    }
    /**
     * <pre>
     * Add that many lazy constraints (or cuts) at once in the LP. Note that at
     * the beginning of the solve, we do add more than this.
     * </pre>
     *
     * <code>optional int32 new_constraints_batch_size = 122 [default = 50];</code>
     * @param value The newConstraintsBatchSize to set.
     * @return This builder for chaining.
     */
    public Builder setNewConstraintsBatchSize(int value) {
      bitField3_ |= 0x00040000;
      newConstraintsBatchSize_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Add that many lazy constraints (or cuts) at once in the LP. Note that at
     * the beginning of the solve, we do add more than this.
     * </pre>
     *
     * <code>optional int32 new_constraints_batch_size = 122 [default = 50];</code>
     * @return This builder for chaining.
     */
    public Builder clearNewConstraintsBatchSize() {
      bitField3_ = (bitField3_ & ~0x00040000);
      newConstraintsBatchSize_ = 50;
      onChanged();
      return this;
    }

    private int searchBranching_ = 0;
    /**
     * <code>optional .operations_research.sat.SatParameters.SearchBranching search_branching = 82 [default = AUTOMATIC_SEARCH];</code>
     * @return Whether the searchBranching field is set.
     */
    @java.lang.Override public boolean hasSearchBranching() {
      return ((bitField3_ & 0x00080000) != 0);
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.SearchBranching search_branching = 82 [default = AUTOMATIC_SEARCH];</code>
     * @return The searchBranching.
     */
    @java.lang.Override
    public com.google.ortools.sat.SatParameters.SearchBranching getSearchBranching() {
      @SuppressWarnings("deprecation")
      com.google.ortools.sat.SatParameters.SearchBranching result = com.google.ortools.sat.SatParameters.SearchBranching.valueOf(searchBranching_);
      return result == null ? com.google.ortools.sat.SatParameters.SearchBranching.AUTOMATIC_SEARCH : result;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.SearchBranching search_branching = 82 [default = AUTOMATIC_SEARCH];</code>
     * @param value The searchBranching to set.
     * @return This builder for chaining.
     */
    public Builder setSearchBranching(com.google.ortools.sat.SatParameters.SearchBranching value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField3_ |= 0x00080000;
      searchBranching_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.SearchBranching search_branching = 82 [default = AUTOMATIC_SEARCH];</code>
     * @return This builder for chaining.
     */
    public Builder clearSearchBranching() {
      bitField3_ = (bitField3_ & ~0x00080000);
      searchBranching_ = 0;
      onChanged();
      return this;
    }

    private int hintConflictLimit_ = 10;
    /**
     * <pre>
     * Conflict limit used in the phase that exploit the solution hint.
     * </pre>
     *
     * <code>optional int32 hint_conflict_limit = 153 [default = 10];</code>
     * @return Whether the hintConflictLimit field is set.
     */
    @java.lang.Override
    public boolean hasHintConflictLimit() {
      return ((bitField3_ & 0x00100000) != 0);
    }
    /**
     * <pre>
     * Conflict limit used in the phase that exploit the solution hint.
     * </pre>
     *
     * <code>optional int32 hint_conflict_limit = 153 [default = 10];</code>
     * @return The hintConflictLimit.
     */
    @java.lang.Override
    public int getHintConflictLimit() {
      return hintConflictLimit_;
    }
    /**
     * <pre>
     * Conflict limit used in the phase that exploit the solution hint.
     * </pre>
     *
     * <code>optional int32 hint_conflict_limit = 153 [default = 10];</code>
     * @param value The hintConflictLimit to set.
     * @return This builder for chaining.
     */
    public Builder setHintConflictLimit(int value) {
      bitField3_ |= 0x00100000;
      hintConflictLimit_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Conflict limit used in the phase that exploit the solution hint.
     * </pre>
     *
     * <code>optional int32 hint_conflict_limit = 153 [default = 10];</code>
     * @return This builder for chaining.
     */
    public Builder clearHintConflictLimit() {
      bitField3_ = (bitField3_ & ~0x00100000);
      hintConflictLimit_ = 10;
      onChanged();
      return this;
    }

    private boolean repairHint_ ;
    /**
     * <pre>
     * If true, the solver tries to repair the solution given in the hint. This
     * search terminates after the 'hint_conflict_limit' is reached and the solver
     * switches to regular search. If false, then  we do a FIXED_SEARCH using the
     * hint until the hint_conflict_limit is reached.
     * </pre>
     *
     * <code>optional bool repair_hint = 167 [default = false];</code>
     * @return Whether the repairHint field is set.
     */
    @java.lang.Override
    public boolean hasRepairHint() {
      return ((bitField3_ & 0x00200000) != 0);
    }
    /**
     * <pre>
     * If true, the solver tries to repair the solution given in the hint. This
     * search terminates after the 'hint_conflict_limit' is reached and the solver
     * switches to regular search. If false, then  we do a FIXED_SEARCH using the
     * hint until the hint_conflict_limit is reached.
     * </pre>
     *
     * <code>optional bool repair_hint = 167 [default = false];</code>
     * @return The repairHint.
     */
    @java.lang.Override
    public boolean getRepairHint() {
      return repairHint_;
    }
    /**
     * <pre>
     * If true, the solver tries to repair the solution given in the hint. This
     * search terminates after the 'hint_conflict_limit' is reached and the solver
     * switches to regular search. If false, then  we do a FIXED_SEARCH using the
     * hint until the hint_conflict_limit is reached.
     * </pre>
     *
     * <code>optional bool repair_hint = 167 [default = false];</code>
     * @param value The repairHint to set.
     * @return This builder for chaining.
     */
    public Builder setRepairHint(boolean value) {
      bitField3_ |= 0x00200000;
      repairHint_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, the solver tries to repair the solution given in the hint. This
     * search terminates after the 'hint_conflict_limit' is reached and the solver
     * switches to regular search. If false, then  we do a FIXED_SEARCH using the
     * hint until the hint_conflict_limit is reached.
     * </pre>
     *
     * <code>optional bool repair_hint = 167 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearRepairHint() {
      bitField3_ = (bitField3_ & ~0x00200000);
      repairHint_ = false;
      onChanged();
      return this;
    }

    private boolean fixVariablesToTheirHintedValue_ ;
    /**
     * <pre>
     * If true, variables appearing in the solution hints will be fixed to their
     * hinted value.
     * </pre>
     *
     * <code>optional bool fix_variables_to_their_hinted_value = 192 [default = false];</code>
     * @return Whether the fixVariablesToTheirHintedValue field is set.
     */
    @java.lang.Override
    public boolean hasFixVariablesToTheirHintedValue() {
      return ((bitField3_ & 0x00400000) != 0);
    }
    /**
     * <pre>
     * If true, variables appearing in the solution hints will be fixed to their
     * hinted value.
     * </pre>
     *
     * <code>optional bool fix_variables_to_their_hinted_value = 192 [default = false];</code>
     * @return The fixVariablesToTheirHintedValue.
     */
    @java.lang.Override
    public boolean getFixVariablesToTheirHintedValue() {
      return fixVariablesToTheirHintedValue_;
    }
    /**
     * <pre>
     * If true, variables appearing in the solution hints will be fixed to their
     * hinted value.
     * </pre>
     *
     * <code>optional bool fix_variables_to_their_hinted_value = 192 [default = false];</code>
     * @param value The fixVariablesToTheirHintedValue to set.
     * @return This builder for chaining.
     */
    public Builder setFixVariablesToTheirHintedValue(boolean value) {
      bitField3_ |= 0x00400000;
      fixVariablesToTheirHintedValue_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, variables appearing in the solution hints will be fixed to their
     * hinted value.
     * </pre>
     *
     * <code>optional bool fix_variables_to_their_hinted_value = 192 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearFixVariablesToTheirHintedValue() {
      bitField3_ = (bitField3_ & ~0x00400000);
      fixVariablesToTheirHintedValue_ = false;
      onChanged();
      return this;
    }

    private boolean exploitIntegerLpSolution_ = true;
    /**
     * <pre>
     * If true and the Lp relaxation of the problem has an integer optimal
     * solution, try to exploit it. Note that since the LP relaxation may not
     * contain all the constraints, such a solution is not necessarily a solution
     * of the full problem.
     * </pre>
     *
     * <code>optional bool exploit_integer_lp_solution = 94 [default = true];</code>
     * @return Whether the exploitIntegerLpSolution field is set.
     */
    @java.lang.Override
    public boolean hasExploitIntegerLpSolution() {
      return ((bitField3_ & 0x00800000) != 0);
    }
    /**
     * <pre>
     * If true and the Lp relaxation of the problem has an integer optimal
     * solution, try to exploit it. Note that since the LP relaxation may not
     * contain all the constraints, such a solution is not necessarily a solution
     * of the full problem.
     * </pre>
     *
     * <code>optional bool exploit_integer_lp_solution = 94 [default = true];</code>
     * @return The exploitIntegerLpSolution.
     */
    @java.lang.Override
    public boolean getExploitIntegerLpSolution() {
      return exploitIntegerLpSolution_;
    }
    /**
     * <pre>
     * If true and the Lp relaxation of the problem has an integer optimal
     * solution, try to exploit it. Note that since the LP relaxation may not
     * contain all the constraints, such a solution is not necessarily a solution
     * of the full problem.
     * </pre>
     *
     * <code>optional bool exploit_integer_lp_solution = 94 [default = true];</code>
     * @param value The exploitIntegerLpSolution to set.
     * @return This builder for chaining.
     */
    public Builder setExploitIntegerLpSolution(boolean value) {
      bitField3_ |= 0x00800000;
      exploitIntegerLpSolution_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true and the Lp relaxation of the problem has an integer optimal
     * solution, try to exploit it. Note that since the LP relaxation may not
     * contain all the constraints, such a solution is not necessarily a solution
     * of the full problem.
     * </pre>
     *
     * <code>optional bool exploit_integer_lp_solution = 94 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearExploitIntegerLpSolution() {
      bitField3_ = (bitField3_ & ~0x00800000);
      exploitIntegerLpSolution_ = true;
      onChanged();
      return this;
    }

    private boolean exploitAllLpSolution_ = true;
    /**
     * <pre>
     * If true and the Lp relaxation of the problem has a solution, try to exploit
     * it. This is same as above except in this case the lp solution might not be
     * an integer solution.
     * </pre>
     *
     * <code>optional bool exploit_all_lp_solution = 116 [default = true];</code>
     * @return Whether the exploitAllLpSolution field is set.
     */
    @java.lang.Override
    public boolean hasExploitAllLpSolution() {
      return ((bitField3_ & 0x01000000) != 0);
    }
    /**
     * <pre>
     * If true and the Lp relaxation of the problem has a solution, try to exploit
     * it. This is same as above except in this case the lp solution might not be
     * an integer solution.
     * </pre>
     *
     * <code>optional bool exploit_all_lp_solution = 116 [default = true];</code>
     * @return The exploitAllLpSolution.
     */
    @java.lang.Override
    public boolean getExploitAllLpSolution() {
      return exploitAllLpSolution_;
    }
    /**
     * <pre>
     * If true and the Lp relaxation of the problem has a solution, try to exploit
     * it. This is same as above except in this case the lp solution might not be
     * an integer solution.
     * </pre>
     *
     * <code>optional bool exploit_all_lp_solution = 116 [default = true];</code>
     * @param value The exploitAllLpSolution to set.
     * @return This builder for chaining.
     */
    public Builder setExploitAllLpSolution(boolean value) {
      bitField3_ |= 0x01000000;
      exploitAllLpSolution_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true and the Lp relaxation of the problem has a solution, try to exploit
     * it. This is same as above except in this case the lp solution might not be
     * an integer solution.
     * </pre>
     *
     * <code>optional bool exploit_all_lp_solution = 116 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearExploitAllLpSolution() {
      bitField3_ = (bitField3_ & ~0x01000000);
      exploitAllLpSolution_ = true;
      onChanged();
      return this;
    }

    private boolean exploitBestSolution_ ;
    /**
     * <pre>
     * When branching on a variable, follow the last best solution value.
     * </pre>
     *
     * <code>optional bool exploit_best_solution = 130 [default = false];</code>
     * @return Whether the exploitBestSolution field is set.
     */
    @java.lang.Override
    public boolean hasExploitBestSolution() {
      return ((bitField3_ & 0x02000000) != 0);
    }
    /**
     * <pre>
     * When branching on a variable, follow the last best solution value.
     * </pre>
     *
     * <code>optional bool exploit_best_solution = 130 [default = false];</code>
     * @return The exploitBestSolution.
     */
    @java.lang.Override
    public boolean getExploitBestSolution() {
      return exploitBestSolution_;
    }
    /**
     * <pre>
     * When branching on a variable, follow the last best solution value.
     * </pre>
     *
     * <code>optional bool exploit_best_solution = 130 [default = false];</code>
     * @param value The exploitBestSolution to set.
     * @return This builder for chaining.
     */
    public Builder setExploitBestSolution(boolean value) {
      bitField3_ |= 0x02000000;
      exploitBestSolution_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * When branching on a variable, follow the last best solution value.
     * </pre>
     *
     * <code>optional bool exploit_best_solution = 130 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearExploitBestSolution() {
      bitField3_ = (bitField3_ & ~0x02000000);
      exploitBestSolution_ = false;
      onChanged();
      return this;
    }

    private boolean exploitRelaxationSolution_ ;
    /**
     * <pre>
     * When branching on a variable, follow the last best relaxation solution
     * value. We use the relaxation with the tightest bound on the objective as
     * the best relaxation solution.
     * </pre>
     *
     * <code>optional bool exploit_relaxation_solution = 161 [default = false];</code>
     * @return Whether the exploitRelaxationSolution field is set.
     */
    @java.lang.Override
    public boolean hasExploitRelaxationSolution() {
      return ((bitField3_ & 0x04000000) != 0);
    }
    /**
     * <pre>
     * When branching on a variable, follow the last best relaxation solution
     * value. We use the relaxation with the tightest bound on the objective as
     * the best relaxation solution.
     * </pre>
     *
     * <code>optional bool exploit_relaxation_solution = 161 [default = false];</code>
     * @return The exploitRelaxationSolution.
     */
    @java.lang.Override
    public boolean getExploitRelaxationSolution() {
      return exploitRelaxationSolution_;
    }
    /**
     * <pre>
     * When branching on a variable, follow the last best relaxation solution
     * value. We use the relaxation with the tightest bound on the objective as
     * the best relaxation solution.
     * </pre>
     *
     * <code>optional bool exploit_relaxation_solution = 161 [default = false];</code>
     * @param value The exploitRelaxationSolution to set.
     * @return This builder for chaining.
     */
    public Builder setExploitRelaxationSolution(boolean value) {
      bitField3_ |= 0x04000000;
      exploitRelaxationSolution_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * When branching on a variable, follow the last best relaxation solution
     * value. We use the relaxation with the tightest bound on the objective as
     * the best relaxation solution.
     * </pre>
     *
     * <code>optional bool exploit_relaxation_solution = 161 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearExploitRelaxationSolution() {
      bitField3_ = (bitField3_ & ~0x04000000);
      exploitRelaxationSolution_ = false;
      onChanged();
      return this;
    }

    private boolean exploitObjective_ = true;
    /**
     * <pre>
     * When branching an a variable that directly affect the objective,
     * branch on the value that lead to the best objective first.
     * </pre>
     *
     * <code>optional bool exploit_objective = 131 [default = true];</code>
     * @return Whether the exploitObjective field is set.
     */
    @java.lang.Override
    public boolean hasExploitObjective() {
      return ((bitField3_ & 0x08000000) != 0);
    }
    /**
     * <pre>
     * When branching an a variable that directly affect the objective,
     * branch on the value that lead to the best objective first.
     * </pre>
     *
     * <code>optional bool exploit_objective = 131 [default = true];</code>
     * @return The exploitObjective.
     */
    @java.lang.Override
    public boolean getExploitObjective() {
      return exploitObjective_;
    }
    /**
     * <pre>
     * When branching an a variable that directly affect the objective,
     * branch on the value that lead to the best objective first.
     * </pre>
     *
     * <code>optional bool exploit_objective = 131 [default = true];</code>
     * @param value The exploitObjective to set.
     * @return This builder for chaining.
     */
    public Builder setExploitObjective(boolean value) {
      bitField3_ |= 0x08000000;
      exploitObjective_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * When branching an a variable that directly affect the objective,
     * branch on the value that lead to the best objective first.
     * </pre>
     *
     * <code>optional bool exploit_objective = 131 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearExploitObjective() {
      bitField3_ = (bitField3_ & ~0x08000000);
      exploitObjective_ = true;
      onChanged();
      return this;
    }

    private long probingPeriodAtRoot_ ;
    /**
     * <pre>
     * If set at zero (the default), it is disabled. Otherwise the solver attempts
     * probing at every 'probing_period' root node. Period of 1 enables probing at
     * every root node.
     * </pre>
     *
     * <code>optional int64 probing_period_at_root = 142 [default = 0];</code>
     * @return Whether the probingPeriodAtRoot field is set.
     */
    @java.lang.Override
    public boolean hasProbingPeriodAtRoot() {
      return ((bitField3_ & 0x10000000) != 0);
    }
    /**
     * <pre>
     * If set at zero (the default), it is disabled. Otherwise the solver attempts
     * probing at every 'probing_period' root node. Period of 1 enables probing at
     * every root node.
     * </pre>
     *
     * <code>optional int64 probing_period_at_root = 142 [default = 0];</code>
     * @return The probingPeriodAtRoot.
     */
    @java.lang.Override
    public long getProbingPeriodAtRoot() {
      return probingPeriodAtRoot_;
    }
    /**
     * <pre>
     * If set at zero (the default), it is disabled. Otherwise the solver attempts
     * probing at every 'probing_period' root node. Period of 1 enables probing at
     * every root node.
     * </pre>
     *
     * <code>optional int64 probing_period_at_root = 142 [default = 0];</code>
     * @param value The probingPeriodAtRoot to set.
     * @return This builder for chaining.
     */
    public Builder setProbingPeriodAtRoot(long value) {
      bitField3_ |= 0x10000000;
      probingPeriodAtRoot_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If set at zero (the default), it is disabled. Otherwise the solver attempts
     * probing at every 'probing_period' root node. Period of 1 enables probing at
     * every root node.
     * </pre>
     *
     * <code>optional int64 probing_period_at_root = 142 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearProbingPeriodAtRoot() {
      bitField3_ = (bitField3_ & ~0x10000000);
      probingPeriodAtRoot_ = 0L;
      onChanged();
      return this;
    }

    private boolean useProbingSearch_ ;
    /**
     * <pre>
     * If true, search will continuously probe Boolean variables, and integer
     * variable bounds.
     * </pre>
     *
     * <code>optional bool use_probing_search = 176 [default = false];</code>
     * @return Whether the useProbingSearch field is set.
     */
    @java.lang.Override
    public boolean hasUseProbingSearch() {
      return ((bitField3_ & 0x20000000) != 0);
    }
    /**
     * <pre>
     * If true, search will continuously probe Boolean variables, and integer
     * variable bounds.
     * </pre>
     *
     * <code>optional bool use_probing_search = 176 [default = false];</code>
     * @return The useProbingSearch.
     */
    @java.lang.Override
    public boolean getUseProbingSearch() {
      return useProbingSearch_;
    }
    /**
     * <pre>
     * If true, search will continuously probe Boolean variables, and integer
     * variable bounds.
     * </pre>
     *
     * <code>optional bool use_probing_search = 176 [default = false];</code>
     * @param value The useProbingSearch to set.
     * @return This builder for chaining.
     */
    public Builder setUseProbingSearch(boolean value) {
      bitField3_ |= 0x20000000;
      useProbingSearch_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, search will continuously probe Boolean variables, and integer
     * variable bounds.
     * </pre>
     *
     * <code>optional bool use_probing_search = 176 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseProbingSearch() {
      bitField3_ = (bitField3_ & ~0x20000000);
      useProbingSearch_ = false;
      onChanged();
      return this;
    }

    private long pseudoCostReliabilityThreshold_ = 100L;
    /**
     * <pre>
     * The solver ignores the pseudo costs of variables with number of recordings
     * less than this threshold.
     * </pre>
     *
     * <code>optional int64 pseudo_cost_reliability_threshold = 123 [default = 100];</code>
     * @return Whether the pseudoCostReliabilityThreshold field is set.
     */
    @java.lang.Override
    public boolean hasPseudoCostReliabilityThreshold() {
      return ((bitField3_ & 0x40000000) != 0);
    }
    /**
     * <pre>
     * The solver ignores the pseudo costs of variables with number of recordings
     * less than this threshold.
     * </pre>
     *
     * <code>optional int64 pseudo_cost_reliability_threshold = 123 [default = 100];</code>
     * @return The pseudoCostReliabilityThreshold.
     */
    @java.lang.Override
    public long getPseudoCostReliabilityThreshold() {
      return pseudoCostReliabilityThreshold_;
    }
    /**
     * <pre>
     * The solver ignores the pseudo costs of variables with number of recordings
     * less than this threshold.
     * </pre>
     *
     * <code>optional int64 pseudo_cost_reliability_threshold = 123 [default = 100];</code>
     * @param value The pseudoCostReliabilityThreshold to set.
     * @return This builder for chaining.
     */
    public Builder setPseudoCostReliabilityThreshold(long value) {
      bitField3_ |= 0x40000000;
      pseudoCostReliabilityThreshold_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The solver ignores the pseudo costs of variables with number of recordings
     * less than this threshold.
     * </pre>
     *
     * <code>optional int64 pseudo_cost_reliability_threshold = 123 [default = 100];</code>
     * @return This builder for chaining.
     */
    public Builder clearPseudoCostReliabilityThreshold() {
      bitField3_ = (bitField3_ & ~0x40000000);
      pseudoCostReliabilityThreshold_ = 100L;
      onChanged();
      return this;
    }

    private boolean optimizeWithCore_ ;
    /**
     * <pre>
     * The default optimization method is a simple "linear scan", each time trying
     * to find a better solution than the previous one. If this is true, then we
     * use a core-based approach (like in max-SAT) when we try to increase the
     * lower bound instead.
     * </pre>
     *
     * <code>optional bool optimize_with_core = 83 [default = false];</code>
     * @return Whether the optimizeWithCore field is set.
     */
    @java.lang.Override
    public boolean hasOptimizeWithCore() {
      return ((bitField3_ & 0x80000000) != 0);
    }
    /**
     * <pre>
     * The default optimization method is a simple "linear scan", each time trying
     * to find a better solution than the previous one. If this is true, then we
     * use a core-based approach (like in max-SAT) when we try to increase the
     * lower bound instead.
     * </pre>
     *
     * <code>optional bool optimize_with_core = 83 [default = false];</code>
     * @return The optimizeWithCore.
     */
    @java.lang.Override
    public boolean getOptimizeWithCore() {
      return optimizeWithCore_;
    }
    /**
     * <pre>
     * The default optimization method is a simple "linear scan", each time trying
     * to find a better solution than the previous one. If this is true, then we
     * use a core-based approach (like in max-SAT) when we try to increase the
     * lower bound instead.
     * </pre>
     *
     * <code>optional bool optimize_with_core = 83 [default = false];</code>
     * @param value The optimizeWithCore to set.
     * @return This builder for chaining.
     */
    public Builder setOptimizeWithCore(boolean value) {
      bitField3_ |= 0x80000000;
      optimizeWithCore_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The default optimization method is a simple "linear scan", each time trying
     * to find a better solution than the previous one. If this is true, then we
     * use a core-based approach (like in max-SAT) when we try to increase the
     * lower bound instead.
     * </pre>
     *
     * <code>optional bool optimize_with_core = 83 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearOptimizeWithCore() {
      bitField3_ = (bitField3_ & ~0x80000000);
      optimizeWithCore_ = false;
      onChanged();
      return this;
    }

    private boolean optimizeWithLbTreeSearch_ ;
    /**
     * <pre>
     * Do a more conventional tree search (by opposition to SAT based one) where
     * we keep all the explored node in a tree. This is meant to be used in a
     * portfolio and focus on improving the objective lower bound. Keeping the
     * whole tree allow us to report a better objective lower bound coming from
     * the worst open node in the tree.
     * </pre>
     *
     * <code>optional bool optimize_with_lb_tree_search = 188 [default = false];</code>
     * @return Whether the optimizeWithLbTreeSearch field is set.
     */
    @java.lang.Override
    public boolean hasOptimizeWithLbTreeSearch() {
      return ((bitField4_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Do a more conventional tree search (by opposition to SAT based one) where
     * we keep all the explored node in a tree. This is meant to be used in a
     * portfolio and focus on improving the objective lower bound. Keeping the
     * whole tree allow us to report a better objective lower bound coming from
     * the worst open node in the tree.
     * </pre>
     *
     * <code>optional bool optimize_with_lb_tree_search = 188 [default = false];</code>
     * @return The optimizeWithLbTreeSearch.
     */
    @java.lang.Override
    public boolean getOptimizeWithLbTreeSearch() {
      return optimizeWithLbTreeSearch_;
    }
    /**
     * <pre>
     * Do a more conventional tree search (by opposition to SAT based one) where
     * we keep all the explored node in a tree. This is meant to be used in a
     * portfolio and focus on improving the objective lower bound. Keeping the
     * whole tree allow us to report a better objective lower bound coming from
     * the worst open node in the tree.
     * </pre>
     *
     * <code>optional bool optimize_with_lb_tree_search = 188 [default = false];</code>
     * @param value The optimizeWithLbTreeSearch to set.
     * @return This builder for chaining.
     */
    public Builder setOptimizeWithLbTreeSearch(boolean value) {
      bitField4_ |= 0x00000001;
      optimizeWithLbTreeSearch_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Do a more conventional tree search (by opposition to SAT based one) where
     * we keep all the explored node in a tree. This is meant to be used in a
     * portfolio and focus on improving the objective lower bound. Keeping the
     * whole tree allow us to report a better objective lower bound coming from
     * the worst open node in the tree.
     * </pre>
     *
     * <code>optional bool optimize_with_lb_tree_search = 188 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearOptimizeWithLbTreeSearch() {
      bitField4_ = (bitField4_ & ~0x00000001);
      optimizeWithLbTreeSearch_ = false;
      onChanged();
      return this;
    }

    private int binarySearchNumConflicts_ = -1;
    /**
     * <pre>
     * If non-negative, perform a binary search on the objective variable in order
     * to find an [min, max] interval outside of which the solver proved unsat/sat
     * under this amount of conflict. This can quickly reduce the objective domain
     * on some problems.
     * </pre>
     *
     * <code>optional int32 binary_search_num_conflicts = 99 [default = -1];</code>
     * @return Whether the binarySearchNumConflicts field is set.
     */
    @java.lang.Override
    public boolean hasBinarySearchNumConflicts() {
      return ((bitField4_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * If non-negative, perform a binary search on the objective variable in order
     * to find an [min, max] interval outside of which the solver proved unsat/sat
     * under this amount of conflict. This can quickly reduce the objective domain
     * on some problems.
     * </pre>
     *
     * <code>optional int32 binary_search_num_conflicts = 99 [default = -1];</code>
     * @return The binarySearchNumConflicts.
     */
    @java.lang.Override
    public int getBinarySearchNumConflicts() {
      return binarySearchNumConflicts_;
    }
    /**
     * <pre>
     * If non-negative, perform a binary search on the objective variable in order
     * to find an [min, max] interval outside of which the solver proved unsat/sat
     * under this amount of conflict. This can quickly reduce the objective domain
     * on some problems.
     * </pre>
     *
     * <code>optional int32 binary_search_num_conflicts = 99 [default = -1];</code>
     * @param value The binarySearchNumConflicts to set.
     * @return This builder for chaining.
     */
    public Builder setBinarySearchNumConflicts(int value) {
      bitField4_ |= 0x00000002;
      binarySearchNumConflicts_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-negative, perform a binary search on the objective variable in order
     * to find an [min, max] interval outside of which the solver proved unsat/sat
     * under this amount of conflict. This can quickly reduce the objective domain
     * on some problems.
     * </pre>
     *
     * <code>optional int32 binary_search_num_conflicts = 99 [default = -1];</code>
     * @return This builder for chaining.
     */
    public Builder clearBinarySearchNumConflicts() {
      bitField4_ = (bitField4_ & ~0x00000002);
      binarySearchNumConflicts_ = -1;
      onChanged();
      return this;
    }

    private boolean optimizeWithMaxHs_ ;
    /**
     * <pre>
     * This has no effect if optimize_with_core is false. If true, use a different
     * core-based algorithm similar to the max-HS algo for max-SAT. This is a
     * hybrid MIP/CP approach and it uses a MIP solver in addition to the CP/SAT
     * one. This is also related to the PhD work of tobyodavies&#64;
     * "Automatic Logic-Based Benders Decomposition with MiniZinc"
     * http://aaai.org/ocs/index.php/AAAI/AAAI17/paper/view/14489
     * </pre>
     *
     * <code>optional bool optimize_with_max_hs = 85 [default = false];</code>
     * @return Whether the optimizeWithMaxHs field is set.
     */
    @java.lang.Override
    public boolean hasOptimizeWithMaxHs() {
      return ((bitField4_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * This has no effect if optimize_with_core is false. If true, use a different
     * core-based algorithm similar to the max-HS algo for max-SAT. This is a
     * hybrid MIP/CP approach and it uses a MIP solver in addition to the CP/SAT
     * one. This is also related to the PhD work of tobyodavies&#64;
     * "Automatic Logic-Based Benders Decomposition with MiniZinc"
     * http://aaai.org/ocs/index.php/AAAI/AAAI17/paper/view/14489
     * </pre>
     *
     * <code>optional bool optimize_with_max_hs = 85 [default = false];</code>
     * @return The optimizeWithMaxHs.
     */
    @java.lang.Override
    public boolean getOptimizeWithMaxHs() {
      return optimizeWithMaxHs_;
    }
    /**
     * <pre>
     * This has no effect if optimize_with_core is false. If true, use a different
     * core-based algorithm similar to the max-HS algo for max-SAT. This is a
     * hybrid MIP/CP approach and it uses a MIP solver in addition to the CP/SAT
     * one. This is also related to the PhD work of tobyodavies&#64;
     * "Automatic Logic-Based Benders Decomposition with MiniZinc"
     * http://aaai.org/ocs/index.php/AAAI/AAAI17/paper/view/14489
     * </pre>
     *
     * <code>optional bool optimize_with_max_hs = 85 [default = false];</code>
     * @param value The optimizeWithMaxHs to set.
     * @return This builder for chaining.
     */
    public Builder setOptimizeWithMaxHs(boolean value) {
      bitField4_ |= 0x00000004;
      optimizeWithMaxHs_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * This has no effect if optimize_with_core is false. If true, use a different
     * core-based algorithm similar to the max-HS algo for max-SAT. This is a
     * hybrid MIP/CP approach and it uses a MIP solver in addition to the CP/SAT
     * one. This is also related to the PhD work of tobyodavies&#64;
     * "Automatic Logic-Based Benders Decomposition with MiniZinc"
     * http://aaai.org/ocs/index.php/AAAI/AAAI17/paper/view/14489
     * </pre>
     *
     * <code>optional bool optimize_with_max_hs = 85 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearOptimizeWithMaxHs() {
      bitField4_ = (bitField4_ & ~0x00000004);
      optimizeWithMaxHs_ = false;
      onChanged();
      return this;
    }

    private boolean enumerateAllSolutions_ ;
    /**
     * <pre>
     * Whether we enumerate all solutions of a problem without objective. Note
     * that setting this to true automatically disable some presolve reduction
     * that can remove feasible solution. That is it has the same effect as
     * setting keep_all_feasible_solutions_in_presolve.
     * TODO(user): Do not do that and let the user choose what behavior is best by
     * setting keep_all_feasible_solutions_in_presolve ?
     * </pre>
     *
     * <code>optional bool enumerate_all_solutions = 87 [default = false];</code>
     * @return Whether the enumerateAllSolutions field is set.
     */
    @java.lang.Override
    public boolean hasEnumerateAllSolutions() {
      return ((bitField4_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * Whether we enumerate all solutions of a problem without objective. Note
     * that setting this to true automatically disable some presolve reduction
     * that can remove feasible solution. That is it has the same effect as
     * setting keep_all_feasible_solutions_in_presolve.
     * TODO(user): Do not do that and let the user choose what behavior is best by
     * setting keep_all_feasible_solutions_in_presolve ?
     * </pre>
     *
     * <code>optional bool enumerate_all_solutions = 87 [default = false];</code>
     * @return The enumerateAllSolutions.
     */
    @java.lang.Override
    public boolean getEnumerateAllSolutions() {
      return enumerateAllSolutions_;
    }
    /**
     * <pre>
     * Whether we enumerate all solutions of a problem without objective. Note
     * that setting this to true automatically disable some presolve reduction
     * that can remove feasible solution. That is it has the same effect as
     * setting keep_all_feasible_solutions_in_presolve.
     * TODO(user): Do not do that and let the user choose what behavior is best by
     * setting keep_all_feasible_solutions_in_presolve ?
     * </pre>
     *
     * <code>optional bool enumerate_all_solutions = 87 [default = false];</code>
     * @param value The enumerateAllSolutions to set.
     * @return This builder for chaining.
     */
    public Builder setEnumerateAllSolutions(boolean value) {
      bitField4_ |= 0x00000008;
      enumerateAllSolutions_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we enumerate all solutions of a problem without objective. Note
     * that setting this to true automatically disable some presolve reduction
     * that can remove feasible solution. That is it has the same effect as
     * setting keep_all_feasible_solutions_in_presolve.
     * TODO(user): Do not do that and let the user choose what behavior is best by
     * setting keep_all_feasible_solutions_in_presolve ?
     * </pre>
     *
     * <code>optional bool enumerate_all_solutions = 87 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearEnumerateAllSolutions() {
      bitField4_ = (bitField4_ & ~0x00000008);
      enumerateAllSolutions_ = false;
      onChanged();
      return this;
    }

    private boolean keepAllFeasibleSolutionsInPresolve_ ;
    /**
     * <pre>
     * If true, we disable the presolve reductions that remove feasible solutions
     * from the search space. Such solution are usually dominated by a "better"
     * solution that is kept, but depending on the situation, we might want to
     * keep all solutions.
     * A trivial example is when a variable is unused. If this is true, then the
     * presolve will not fix it to an arbitrary value and it will stay in the
     * search space.
     * </pre>
     *
     * <code>optional bool keep_all_feasible_solutions_in_presolve = 173 [default = false];</code>
     * @return Whether the keepAllFeasibleSolutionsInPresolve field is set.
     */
    @java.lang.Override
    public boolean hasKeepAllFeasibleSolutionsInPresolve() {
      return ((bitField4_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * If true, we disable the presolve reductions that remove feasible solutions
     * from the search space. Such solution are usually dominated by a "better"
     * solution that is kept, but depending on the situation, we might want to
     * keep all solutions.
     * A trivial example is when a variable is unused. If this is true, then the
     * presolve will not fix it to an arbitrary value and it will stay in the
     * search space.
     * </pre>
     *
     * <code>optional bool keep_all_feasible_solutions_in_presolve = 173 [default = false];</code>
     * @return The keepAllFeasibleSolutionsInPresolve.
     */
    @java.lang.Override
    public boolean getKeepAllFeasibleSolutionsInPresolve() {
      return keepAllFeasibleSolutionsInPresolve_;
    }
    /**
     * <pre>
     * If true, we disable the presolve reductions that remove feasible solutions
     * from the search space. Such solution are usually dominated by a "better"
     * solution that is kept, but depending on the situation, we might want to
     * keep all solutions.
     * A trivial example is when a variable is unused. If this is true, then the
     * presolve will not fix it to an arbitrary value and it will stay in the
     * search space.
     * </pre>
     *
     * <code>optional bool keep_all_feasible_solutions_in_presolve = 173 [default = false];</code>
     * @param value The keepAllFeasibleSolutionsInPresolve to set.
     * @return This builder for chaining.
     */
    public Builder setKeepAllFeasibleSolutionsInPresolve(boolean value) {
      bitField4_ |= 0x00000010;
      keepAllFeasibleSolutionsInPresolve_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, we disable the presolve reductions that remove feasible solutions
     * from the search space. Such solution are usually dominated by a "better"
     * solution that is kept, but depending on the situation, we might want to
     * keep all solutions.
     * A trivial example is when a variable is unused. If this is true, then the
     * presolve will not fix it to an arbitrary value and it will stay in the
     * search space.
     * </pre>
     *
     * <code>optional bool keep_all_feasible_solutions_in_presolve = 173 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearKeepAllFeasibleSolutionsInPresolve() {
      bitField4_ = (bitField4_ & ~0x00000010);
      keepAllFeasibleSolutionsInPresolve_ = false;
      onChanged();
      return this;
    }

    private boolean fillTightenedDomainsInResponse_ ;
    /**
     * <pre>
     * If true, add information about the derived variable domains to the
     * CpSolverResponse. It is an option because it makes the response slighly
     * bigger and there is a bit more work involved during the postsolve to
     * construct it, but it should still have a low overhead. See the
     * tightened_variables field in CpSolverResponse for more details.
     * </pre>
     *
     * <code>optional bool fill_tightened_domains_in_response = 132 [default = false];</code>
     * @return Whether the fillTightenedDomainsInResponse field is set.
     */
    @java.lang.Override
    public boolean hasFillTightenedDomainsInResponse() {
      return ((bitField4_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * If true, add information about the derived variable domains to the
     * CpSolverResponse. It is an option because it makes the response slighly
     * bigger and there is a bit more work involved during the postsolve to
     * construct it, but it should still have a low overhead. See the
     * tightened_variables field in CpSolverResponse for more details.
     * </pre>
     *
     * <code>optional bool fill_tightened_domains_in_response = 132 [default = false];</code>
     * @return The fillTightenedDomainsInResponse.
     */
    @java.lang.Override
    public boolean getFillTightenedDomainsInResponse() {
      return fillTightenedDomainsInResponse_;
    }
    /**
     * <pre>
     * If true, add information about the derived variable domains to the
     * CpSolverResponse. It is an option because it makes the response slighly
     * bigger and there is a bit more work involved during the postsolve to
     * construct it, but it should still have a low overhead. See the
     * tightened_variables field in CpSolverResponse for more details.
     * </pre>
     *
     * <code>optional bool fill_tightened_domains_in_response = 132 [default = false];</code>
     * @param value The fillTightenedDomainsInResponse to set.
     * @return This builder for chaining.
     */
    public Builder setFillTightenedDomainsInResponse(boolean value) {
      bitField4_ |= 0x00000020;
      fillTightenedDomainsInResponse_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, add information about the derived variable domains to the
     * CpSolverResponse. It is an option because it makes the response slighly
     * bigger and there is a bit more work involved during the postsolve to
     * construct it, but it should still have a low overhead. See the
     * tightened_variables field in CpSolverResponse for more details.
     * </pre>
     *
     * <code>optional bool fill_tightened_domains_in_response = 132 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearFillTightenedDomainsInResponse() {
      bitField4_ = (bitField4_ & ~0x00000020);
      fillTightenedDomainsInResponse_ = false;
      onChanged();
      return this;
    }

    private boolean instantiateAllVariables_ = true;
    /**
     * <pre>
     * If true, the solver will add a default integer branching strategy to the
     * already defined search strategy. If not, some variable might still not be
     * fixed at the end of the search. For now we assume these variable can just
     * be set to their lower bound.
     * </pre>
     *
     * <code>optional bool instantiate_all_variables = 106 [default = true];</code>
     * @return Whether the instantiateAllVariables field is set.
     */
    @java.lang.Override
    public boolean hasInstantiateAllVariables() {
      return ((bitField4_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * If true, the solver will add a default integer branching strategy to the
     * already defined search strategy. If not, some variable might still not be
     * fixed at the end of the search. For now we assume these variable can just
     * be set to their lower bound.
     * </pre>
     *
     * <code>optional bool instantiate_all_variables = 106 [default = true];</code>
     * @return The instantiateAllVariables.
     */
    @java.lang.Override
    public boolean getInstantiateAllVariables() {
      return instantiateAllVariables_;
    }
    /**
     * <pre>
     * If true, the solver will add a default integer branching strategy to the
     * already defined search strategy. If not, some variable might still not be
     * fixed at the end of the search. For now we assume these variable can just
     * be set to their lower bound.
     * </pre>
     *
     * <code>optional bool instantiate_all_variables = 106 [default = true];</code>
     * @param value The instantiateAllVariables to set.
     * @return This builder for chaining.
     */
    public Builder setInstantiateAllVariables(boolean value) {
      bitField4_ |= 0x00000040;
      instantiateAllVariables_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, the solver will add a default integer branching strategy to the
     * already defined search strategy. If not, some variable might still not be
     * fixed at the end of the search. For now we assume these variable can just
     * be set to their lower bound.
     * </pre>
     *
     * <code>optional bool instantiate_all_variables = 106 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearInstantiateAllVariables() {
      bitField4_ = (bitField4_ & ~0x00000040);
      instantiateAllVariables_ = true;
      onChanged();
      return this;
    }

    private boolean autoDetectGreaterThanAtLeastOneOf_ = true;
    /**
     * <pre>
     * If true, then the precedences propagator try to detect for each variable if
     * it has a set of "optional incoming arc" for which at least one of them is
     * present. This is usually useful to have but can be slow on model with a lot
     * of precedence.
     * </pre>
     *
     * <code>optional bool auto_detect_greater_than_at_least_one_of = 95 [default = true];</code>
     * @return Whether the autoDetectGreaterThanAtLeastOneOf field is set.
     */
    @java.lang.Override
    public boolean hasAutoDetectGreaterThanAtLeastOneOf() {
      return ((bitField4_ & 0x00000080) != 0);
    }
    /**
     * <pre>
     * If true, then the precedences propagator try to detect for each variable if
     * it has a set of "optional incoming arc" for which at least one of them is
     * present. This is usually useful to have but can be slow on model with a lot
     * of precedence.
     * </pre>
     *
     * <code>optional bool auto_detect_greater_than_at_least_one_of = 95 [default = true];</code>
     * @return The autoDetectGreaterThanAtLeastOneOf.
     */
    @java.lang.Override
    public boolean getAutoDetectGreaterThanAtLeastOneOf() {
      return autoDetectGreaterThanAtLeastOneOf_;
    }
    /**
     * <pre>
     * If true, then the precedences propagator try to detect for each variable if
     * it has a set of "optional incoming arc" for which at least one of them is
     * present. This is usually useful to have but can be slow on model with a lot
     * of precedence.
     * </pre>
     *
     * <code>optional bool auto_detect_greater_than_at_least_one_of = 95 [default = true];</code>
     * @param value The autoDetectGreaterThanAtLeastOneOf to set.
     * @return This builder for chaining.
     */
    public Builder setAutoDetectGreaterThanAtLeastOneOf(boolean value) {
      bitField4_ |= 0x00000080;
      autoDetectGreaterThanAtLeastOneOf_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, then the precedences propagator try to detect for each variable if
     * it has a set of "optional incoming arc" for which at least one of them is
     * present. This is usually useful to have but can be slow on model with a lot
     * of precedence.
     * </pre>
     *
     * <code>optional bool auto_detect_greater_than_at_least_one_of = 95 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearAutoDetectGreaterThanAtLeastOneOf() {
      bitField4_ = (bitField4_ & ~0x00000080);
      autoDetectGreaterThanAtLeastOneOf_ = true;
      onChanged();
      return this;
    }

    private boolean stopAfterFirstSolution_ ;
    /**
     * <pre>
     * For an optimization problem, stop the solver as soon as we have a solution.
     * </pre>
     *
     * <code>optional bool stop_after_first_solution = 98 [default = false];</code>
     * @return Whether the stopAfterFirstSolution field is set.
     */
    @java.lang.Override
    public boolean hasStopAfterFirstSolution() {
      return ((bitField4_ & 0x00000100) != 0);
    }
    /**
     * <pre>
     * For an optimization problem, stop the solver as soon as we have a solution.
     * </pre>
     *
     * <code>optional bool stop_after_first_solution = 98 [default = false];</code>
     * @return The stopAfterFirstSolution.
     */
    @java.lang.Override
    public boolean getStopAfterFirstSolution() {
      return stopAfterFirstSolution_;
    }
    /**
     * <pre>
     * For an optimization problem, stop the solver as soon as we have a solution.
     * </pre>
     *
     * <code>optional bool stop_after_first_solution = 98 [default = false];</code>
     * @param value The stopAfterFirstSolution to set.
     * @return This builder for chaining.
     */
    public Builder setStopAfterFirstSolution(boolean value) {
      bitField4_ |= 0x00000100;
      stopAfterFirstSolution_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * For an optimization problem, stop the solver as soon as we have a solution.
     * </pre>
     *
     * <code>optional bool stop_after_first_solution = 98 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearStopAfterFirstSolution() {
      bitField4_ = (bitField4_ & ~0x00000100);
      stopAfterFirstSolution_ = false;
      onChanged();
      return this;
    }

    private boolean stopAfterPresolve_ ;
    /**
     * <pre>
     * Mainly used when improving the presolver. When true, stops the solver after
     * the presolve is complete.
     * </pre>
     *
     * <code>optional bool stop_after_presolve = 149 [default = false];</code>
     * @return Whether the stopAfterPresolve field is set.
     */
    @java.lang.Override
    public boolean hasStopAfterPresolve() {
      return ((bitField4_ & 0x00000200) != 0);
    }
    /**
     * <pre>
     * Mainly used when improving the presolver. When true, stops the solver after
     * the presolve is complete.
     * </pre>
     *
     * <code>optional bool stop_after_presolve = 149 [default = false];</code>
     * @return The stopAfterPresolve.
     */
    @java.lang.Override
    public boolean getStopAfterPresolve() {
      return stopAfterPresolve_;
    }
    /**
     * <pre>
     * Mainly used when improving the presolver. When true, stops the solver after
     * the presolve is complete.
     * </pre>
     *
     * <code>optional bool stop_after_presolve = 149 [default = false];</code>
     * @param value The stopAfterPresolve to set.
     * @return This builder for chaining.
     */
    public Builder setStopAfterPresolve(boolean value) {
      bitField4_ |= 0x00000200;
      stopAfterPresolve_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Mainly used when improving the presolver. When true, stops the solver after
     * the presolve is complete.
     * </pre>
     *
     * <code>optional bool stop_after_presolve = 149 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearStopAfterPresolve() {
      bitField4_ = (bitField4_ & ~0x00000200);
      stopAfterPresolve_ = false;
      onChanged();
      return this;
    }

    private int numSearchWorkers_ ;
    /**
     * <pre>
     * Specify the number of parallel workers to use during search.
     * A value of 0 means the solver will try to use all cores on the machine.
     * A number of 1 means no parallelism.
     * As of 2020-04-10, if you're using SAT via MPSolver (to solve integer
     * programs) this field is overridden with a value of 8, if the field is not
     * set *explicitly*. Thus, always set this field explicitly or via
     * MPSolver::SetNumThreads().
     * </pre>
     *
     * <code>optional int32 num_search_workers = 100 [default = 0];</code>
     * @return Whether the numSearchWorkers field is set.
     */
    @java.lang.Override
    public boolean hasNumSearchWorkers() {
      return ((bitField4_ & 0x00000400) != 0);
    }
    /**
     * <pre>
     * Specify the number of parallel workers to use during search.
     * A value of 0 means the solver will try to use all cores on the machine.
     * A number of 1 means no parallelism.
     * As of 2020-04-10, if you're using SAT via MPSolver (to solve integer
     * programs) this field is overridden with a value of 8, if the field is not
     * set *explicitly*. Thus, always set this field explicitly or via
     * MPSolver::SetNumThreads().
     * </pre>
     *
     * <code>optional int32 num_search_workers = 100 [default = 0];</code>
     * @return The numSearchWorkers.
     */
    @java.lang.Override
    public int getNumSearchWorkers() {
      return numSearchWorkers_;
    }
    /**
     * <pre>
     * Specify the number of parallel workers to use during search.
     * A value of 0 means the solver will try to use all cores on the machine.
     * A number of 1 means no parallelism.
     * As of 2020-04-10, if you're using SAT via MPSolver (to solve integer
     * programs) this field is overridden with a value of 8, if the field is not
     * set *explicitly*. Thus, always set this field explicitly or via
     * MPSolver::SetNumThreads().
     * </pre>
     *
     * <code>optional int32 num_search_workers = 100 [default = 0];</code>
     * @param value The numSearchWorkers to set.
     * @return This builder for chaining.
     */
    public Builder setNumSearchWorkers(int value) {
      bitField4_ |= 0x00000400;
      numSearchWorkers_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specify the number of parallel workers to use during search.
     * A value of 0 means the solver will try to use all cores on the machine.
     * A number of 1 means no parallelism.
     * As of 2020-04-10, if you're using SAT via MPSolver (to solve integer
     * programs) this field is overridden with a value of 8, if the field is not
     * set *explicitly*. Thus, always set this field explicitly or via
     * MPSolver::SetNumThreads().
     * </pre>
     *
     * <code>optional int32 num_search_workers = 100 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearNumSearchWorkers() {
      bitField4_ = (bitField4_ & ~0x00000400);
      numSearchWorkers_ = 0;
      onChanged();
      return this;
    }

    private boolean interleaveSearch_ ;
    /**
     * <pre>
     * Experimental. If this is true, then we interleave all our major search
     * strategy and distribute the work amongst num_search_workers.
     * The search is deterministic (independently of num_search_workers!), and we
     * schedule and wait for interleave_batch_size task to be completed before
     * synchronizing and scheduling the next batch of tasks.
     * </pre>
     *
     * <code>optional bool interleave_search = 136 [default = false];</code>
     * @return Whether the interleaveSearch field is set.
     */
    @java.lang.Override
    public boolean hasInterleaveSearch() {
      return ((bitField4_ & 0x00000800) != 0);
    }
    /**
     * <pre>
     * Experimental. If this is true, then we interleave all our major search
     * strategy and distribute the work amongst num_search_workers.
     * The search is deterministic (independently of num_search_workers!), and we
     * schedule and wait for interleave_batch_size task to be completed before
     * synchronizing and scheduling the next batch of tasks.
     * </pre>
     *
     * <code>optional bool interleave_search = 136 [default = false];</code>
     * @return The interleaveSearch.
     */
    @java.lang.Override
    public boolean getInterleaveSearch() {
      return interleaveSearch_;
    }
    /**
     * <pre>
     * Experimental. If this is true, then we interleave all our major search
     * strategy and distribute the work amongst num_search_workers.
     * The search is deterministic (independently of num_search_workers!), and we
     * schedule and wait for interleave_batch_size task to be completed before
     * synchronizing and scheduling the next batch of tasks.
     * </pre>
     *
     * <code>optional bool interleave_search = 136 [default = false];</code>
     * @param value The interleaveSearch to set.
     * @return This builder for chaining.
     */
    public Builder setInterleaveSearch(boolean value) {
      bitField4_ |= 0x00000800;
      interleaveSearch_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Experimental. If this is true, then we interleave all our major search
     * strategy and distribute the work amongst num_search_workers.
     * The search is deterministic (independently of num_search_workers!), and we
     * schedule and wait for interleave_batch_size task to be completed before
     * synchronizing and scheduling the next batch of tasks.
     * </pre>
     *
     * <code>optional bool interleave_search = 136 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearInterleaveSearch() {
      bitField4_ = (bitField4_ & ~0x00000800);
      interleaveSearch_ = false;
      onChanged();
      return this;
    }

    private int interleaveBatchSize_ = 1;
    /**
     * <code>optional int32 interleave_batch_size = 134 [default = 1];</code>
     * @return Whether the interleaveBatchSize field is set.
     */
    @java.lang.Override
    public boolean hasInterleaveBatchSize() {
      return ((bitField4_ & 0x00001000) != 0);
    }
    /**
     * <code>optional int32 interleave_batch_size = 134 [default = 1];</code>
     * @return The interleaveBatchSize.
     */
    @java.lang.Override
    public int getInterleaveBatchSize() {
      return interleaveBatchSize_;
    }
    /**
     * <code>optional int32 interleave_batch_size = 134 [default = 1];</code>
     * @param value The interleaveBatchSize to set.
     * @return This builder for chaining.
     */
    public Builder setInterleaveBatchSize(int value) {
      bitField4_ |= 0x00001000;
      interleaveBatchSize_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional int32 interleave_batch_size = 134 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearInterleaveBatchSize() {
      bitField4_ = (bitField4_ & ~0x00001000);
      interleaveBatchSize_ = 1;
      onChanged();
      return this;
    }

    private boolean reduceMemoryUsageInInterleaveMode_ ;
    /**
     * <pre>
     * Temporary parameter until the memory usage is more optimized.
     * </pre>
     *
     * <code>optional bool reduce_memory_usage_in_interleave_mode = 141 [default = false];</code>
     * @return Whether the reduceMemoryUsageInInterleaveMode field is set.
     */
    @java.lang.Override
    public boolean hasReduceMemoryUsageInInterleaveMode() {
      return ((bitField4_ & 0x00002000) != 0);
    }
    /**
     * <pre>
     * Temporary parameter until the memory usage is more optimized.
     * </pre>
     *
     * <code>optional bool reduce_memory_usage_in_interleave_mode = 141 [default = false];</code>
     * @return The reduceMemoryUsageInInterleaveMode.
     */
    @java.lang.Override
    public boolean getReduceMemoryUsageInInterleaveMode() {
      return reduceMemoryUsageInInterleaveMode_;
    }
    /**
     * <pre>
     * Temporary parameter until the memory usage is more optimized.
     * </pre>
     *
     * <code>optional bool reduce_memory_usage_in_interleave_mode = 141 [default = false];</code>
     * @param value The reduceMemoryUsageInInterleaveMode to set.
     * @return This builder for chaining.
     */
    public Builder setReduceMemoryUsageInInterleaveMode(boolean value) {
      bitField4_ |= 0x00002000;
      reduceMemoryUsageInInterleaveMode_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Temporary parameter until the memory usage is more optimized.
     * </pre>
     *
     * <code>optional bool reduce_memory_usage_in_interleave_mode = 141 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearReduceMemoryUsageInInterleaveMode() {
      bitField4_ = (bitField4_ & ~0x00002000);
      reduceMemoryUsageInInterleaveMode_ = false;
      onChanged();
      return this;
    }

    private boolean shareObjectiveBounds_ = true;
    /**
     * <pre>
     * Allows objective sharing between workers.
     * </pre>
     *
     * <code>optional bool share_objective_bounds = 113 [default = true];</code>
     * @return Whether the shareObjectiveBounds field is set.
     */
    @java.lang.Override
    public boolean hasShareObjectiveBounds() {
      return ((bitField4_ & 0x00004000) != 0);
    }
    /**
     * <pre>
     * Allows objective sharing between workers.
     * </pre>
     *
     * <code>optional bool share_objective_bounds = 113 [default = true];</code>
     * @return The shareObjectiveBounds.
     */
    @java.lang.Override
    public boolean getShareObjectiveBounds() {
      return shareObjectiveBounds_;
    }
    /**
     * <pre>
     * Allows objective sharing between workers.
     * </pre>
     *
     * <code>optional bool share_objective_bounds = 113 [default = true];</code>
     * @param value The shareObjectiveBounds to set.
     * @return This builder for chaining.
     */
    public Builder setShareObjectiveBounds(boolean value) {
      bitField4_ |= 0x00004000;
      shareObjectiveBounds_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Allows objective sharing between workers.
     * </pre>
     *
     * <code>optional bool share_objective_bounds = 113 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearShareObjectiveBounds() {
      bitField4_ = (bitField4_ & ~0x00004000);
      shareObjectiveBounds_ = true;
      onChanged();
      return this;
    }

    private boolean shareLevelZeroBounds_ = true;
    /**
     * <pre>
     * Allows sharing of the bounds of modified variables at level 0.
     * </pre>
     *
     * <code>optional bool share_level_zero_bounds = 114 [default = true];</code>
     * @return Whether the shareLevelZeroBounds field is set.
     */
    @java.lang.Override
    public boolean hasShareLevelZeroBounds() {
      return ((bitField4_ & 0x00008000) != 0);
    }
    /**
     * <pre>
     * Allows sharing of the bounds of modified variables at level 0.
     * </pre>
     *
     * <code>optional bool share_level_zero_bounds = 114 [default = true];</code>
     * @return The shareLevelZeroBounds.
     */
    @java.lang.Override
    public boolean getShareLevelZeroBounds() {
      return shareLevelZeroBounds_;
    }
    /**
     * <pre>
     * Allows sharing of the bounds of modified variables at level 0.
     * </pre>
     *
     * <code>optional bool share_level_zero_bounds = 114 [default = true];</code>
     * @param value The shareLevelZeroBounds to set.
     * @return This builder for chaining.
     */
    public Builder setShareLevelZeroBounds(boolean value) {
      bitField4_ |= 0x00008000;
      shareLevelZeroBounds_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Allows sharing of the bounds of modified variables at level 0.
     * </pre>
     *
     * <code>optional bool share_level_zero_bounds = 114 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearShareLevelZeroBounds() {
      bitField4_ = (bitField4_ & ~0x00008000);
      shareLevelZeroBounds_ = true;
      onChanged();
      return this;
    }

    private boolean useLnsOnly_ ;
    /**
     * <pre>
     * LNS parameters.
     * </pre>
     *
     * <code>optional bool use_lns_only = 101 [default = false];</code>
     * @return Whether the useLnsOnly field is set.
     */
    @java.lang.Override
    public boolean hasUseLnsOnly() {
      return ((bitField4_ & 0x00010000) != 0);
    }
    /**
     * <pre>
     * LNS parameters.
     * </pre>
     *
     * <code>optional bool use_lns_only = 101 [default = false];</code>
     * @return The useLnsOnly.
     */
    @java.lang.Override
    public boolean getUseLnsOnly() {
      return useLnsOnly_;
    }
    /**
     * <pre>
     * LNS parameters.
     * </pre>
     *
     * <code>optional bool use_lns_only = 101 [default = false];</code>
     * @param value The useLnsOnly to set.
     * @return This builder for chaining.
     */
    public Builder setUseLnsOnly(boolean value) {
      bitField4_ |= 0x00010000;
      useLnsOnly_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * LNS parameters.
     * </pre>
     *
     * <code>optional bool use_lns_only = 101 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseLnsOnly() {
      bitField4_ = (bitField4_ & ~0x00010000);
      useLnsOnly_ = false;
      onChanged();
      return this;
    }

    private boolean lnsFocusOnDecisionVariables_ ;
    /**
     * <code>optional bool lns_focus_on_decision_variables = 105 [default = false];</code>
     * @return Whether the lnsFocusOnDecisionVariables field is set.
     */
    @java.lang.Override
    public boolean hasLnsFocusOnDecisionVariables() {
      return ((bitField4_ & 0x00020000) != 0);
    }
    /**
     * <code>optional bool lns_focus_on_decision_variables = 105 [default = false];</code>
     * @return The lnsFocusOnDecisionVariables.
     */
    @java.lang.Override
    public boolean getLnsFocusOnDecisionVariables() {
      return lnsFocusOnDecisionVariables_;
    }
    /**
     * <code>optional bool lns_focus_on_decision_variables = 105 [default = false];</code>
     * @param value The lnsFocusOnDecisionVariables to set.
     * @return This builder for chaining.
     */
    public Builder setLnsFocusOnDecisionVariables(boolean value) {
      bitField4_ |= 0x00020000;
      lnsFocusOnDecisionVariables_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional bool lns_focus_on_decision_variables = 105 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearLnsFocusOnDecisionVariables() {
      bitField4_ = (bitField4_ & ~0x00020000);
      lnsFocusOnDecisionVariables_ = false;
      onChanged();
      return this;
    }

    private boolean lnsExpandIntervalsInConstraintGraph_ = true;
    /**
     * <code>optional bool lns_expand_intervals_in_constraint_graph = 184 [default = true];</code>
     * @return Whether the lnsExpandIntervalsInConstraintGraph field is set.
     */
    @java.lang.Override
    public boolean hasLnsExpandIntervalsInConstraintGraph() {
      return ((bitField4_ & 0x00040000) != 0);
    }
    /**
     * <code>optional bool lns_expand_intervals_in_constraint_graph = 184 [default = true];</code>
     * @return The lnsExpandIntervalsInConstraintGraph.
     */
    @java.lang.Override
    public boolean getLnsExpandIntervalsInConstraintGraph() {
      return lnsExpandIntervalsInConstraintGraph_;
    }
    /**
     * <code>optional bool lns_expand_intervals_in_constraint_graph = 184 [default = true];</code>
     * @param value The lnsExpandIntervalsInConstraintGraph to set.
     * @return This builder for chaining.
     */
    public Builder setLnsExpandIntervalsInConstraintGraph(boolean value) {
      bitField4_ |= 0x00040000;
      lnsExpandIntervalsInConstraintGraph_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional bool lns_expand_intervals_in_constraint_graph = 184 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearLnsExpandIntervalsInConstraintGraph() {
      bitField4_ = (bitField4_ & ~0x00040000);
      lnsExpandIntervalsInConstraintGraph_ = true;
      onChanged();
      return this;
    }

    private int solutionPoolSize_ = 3;
    /**
     * <pre>
     * Size of the top-n different solutions kept by the solver.
     * Currently this only impact the "base" solution chosen for a LNS fragment.
     * </pre>
     *
     * <code>optional int32 solution_pool_size = 193 [default = 3];</code>
     * @return Whether the solutionPoolSize field is set.
     */
    @java.lang.Override
    public boolean hasSolutionPoolSize() {
      return ((bitField4_ & 0x00080000) != 0);
    }
    /**
     * <pre>
     * Size of the top-n different solutions kept by the solver.
     * Currently this only impact the "base" solution chosen for a LNS fragment.
     * </pre>
     *
     * <code>optional int32 solution_pool_size = 193 [default = 3];</code>
     * @return The solutionPoolSize.
     */
    @java.lang.Override
    public int getSolutionPoolSize() {
      return solutionPoolSize_;
    }
    /**
     * <pre>
     * Size of the top-n different solutions kept by the solver.
     * Currently this only impact the "base" solution chosen for a LNS fragment.
     * </pre>
     *
     * <code>optional int32 solution_pool_size = 193 [default = 3];</code>
     * @param value The solutionPoolSize to set.
     * @return This builder for chaining.
     */
    public Builder setSolutionPoolSize(int value) {
      bitField4_ |= 0x00080000;
      solutionPoolSize_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Size of the top-n different solutions kept by the solver.
     * Currently this only impact the "base" solution chosen for a LNS fragment.
     * </pre>
     *
     * <code>optional int32 solution_pool_size = 193 [default = 3];</code>
     * @return This builder for chaining.
     */
    public Builder clearSolutionPoolSize() {
      bitField4_ = (bitField4_ & ~0x00080000);
      solutionPoolSize_ = 3;
      onChanged();
      return this;
    }

    private boolean useRinsLns_ = true;
    /**
     * <pre>
     * Turns on relaxation induced neighborhood generator.
     * </pre>
     *
     * <code>optional bool use_rins_lns = 129 [default = true];</code>
     * @return Whether the useRinsLns field is set.
     */
    @java.lang.Override
    public boolean hasUseRinsLns() {
      return ((bitField4_ & 0x00100000) != 0);
    }
    /**
     * <pre>
     * Turns on relaxation induced neighborhood generator.
     * </pre>
     *
     * <code>optional bool use_rins_lns = 129 [default = true];</code>
     * @return The useRinsLns.
     */
    @java.lang.Override
    public boolean getUseRinsLns() {
      return useRinsLns_;
    }
    /**
     * <pre>
     * Turns on relaxation induced neighborhood generator.
     * </pre>
     *
     * <code>optional bool use_rins_lns = 129 [default = true];</code>
     * @param value The useRinsLns to set.
     * @return This builder for chaining.
     */
    public Builder setUseRinsLns(boolean value) {
      bitField4_ |= 0x00100000;
      useRinsLns_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Turns on relaxation induced neighborhood generator.
     * </pre>
     *
     * <code>optional bool use_rins_lns = 129 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseRinsLns() {
      bitField4_ = (bitField4_ & ~0x00100000);
      useRinsLns_ = true;
      onChanged();
      return this;
    }

    private boolean useFeasibilityPump_ = true;
    /**
     * <pre>
     * Adds a feasibility pump subsolver along with lns subsolvers.
     * </pre>
     *
     * <code>optional bool use_feasibility_pump = 164 [default = true];</code>
     * @return Whether the useFeasibilityPump field is set.
     */
    @java.lang.Override
    public boolean hasUseFeasibilityPump() {
      return ((bitField4_ & 0x00200000) != 0);
    }
    /**
     * <pre>
     * Adds a feasibility pump subsolver along with lns subsolvers.
     * </pre>
     *
     * <code>optional bool use_feasibility_pump = 164 [default = true];</code>
     * @return The useFeasibilityPump.
     */
    @java.lang.Override
    public boolean getUseFeasibilityPump() {
      return useFeasibilityPump_;
    }
    /**
     * <pre>
     * Adds a feasibility pump subsolver along with lns subsolvers.
     * </pre>
     *
     * <code>optional bool use_feasibility_pump = 164 [default = true];</code>
     * @param value The useFeasibilityPump to set.
     * @return This builder for chaining.
     */
    public Builder setUseFeasibilityPump(boolean value) {
      bitField4_ |= 0x00200000;
      useFeasibilityPump_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Adds a feasibility pump subsolver along with lns subsolvers.
     * </pre>
     *
     * <code>optional bool use_feasibility_pump = 164 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseFeasibilityPump() {
      bitField4_ = (bitField4_ & ~0x00200000);
      useFeasibilityPump_ = true;
      onChanged();
      return this;
    }

    private int fpRounding_ = 2;
    /**
     * <code>optional .operations_research.sat.SatParameters.FPRoundingMethod fp_rounding = 165 [default = PROPAGATION_ASSISTED];</code>
     * @return Whether the fpRounding field is set.
     */
    @java.lang.Override public boolean hasFpRounding() {
      return ((bitField4_ & 0x00400000) != 0);
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.FPRoundingMethod fp_rounding = 165 [default = PROPAGATION_ASSISTED];</code>
     * @return The fpRounding.
     */
    @java.lang.Override
    public com.google.ortools.sat.SatParameters.FPRoundingMethod getFpRounding() {
      @SuppressWarnings("deprecation")
      com.google.ortools.sat.SatParameters.FPRoundingMethod result = com.google.ortools.sat.SatParameters.FPRoundingMethod.valueOf(fpRounding_);
      return result == null ? com.google.ortools.sat.SatParameters.FPRoundingMethod.PROPAGATION_ASSISTED : result;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.FPRoundingMethod fp_rounding = 165 [default = PROPAGATION_ASSISTED];</code>
     * @param value The fpRounding to set.
     * @return This builder for chaining.
     */
    public Builder setFpRounding(com.google.ortools.sat.SatParameters.FPRoundingMethod value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField4_ |= 0x00400000;
      fpRounding_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.FPRoundingMethod fp_rounding = 165 [default = PROPAGATION_ASSISTED];</code>
     * @return This builder for chaining.
     */
    public Builder clearFpRounding() {
      bitField4_ = (bitField4_ & ~0x00400000);
      fpRounding_ = 2;
      onChanged();
      return this;
    }

    private boolean useRelaxationLns_ ;
    /**
     * <pre>
     * Turns on a lns worker which solves relaxed version of the original problem
     * by removing constraints from the problem in order to get better bounds.
     * </pre>
     *
     * <code>optional bool use_relaxation_lns = 150 [default = false];</code>
     * @return Whether the useRelaxationLns field is set.
     */
    @java.lang.Override
    public boolean hasUseRelaxationLns() {
      return ((bitField4_ & 0x00800000) != 0);
    }
    /**
     * <pre>
     * Turns on a lns worker which solves relaxed version of the original problem
     * by removing constraints from the problem in order to get better bounds.
     * </pre>
     *
     * <code>optional bool use_relaxation_lns = 150 [default = false];</code>
     * @return The useRelaxationLns.
     */
    @java.lang.Override
    public boolean getUseRelaxationLns() {
      return useRelaxationLns_;
    }
    /**
     * <pre>
     * Turns on a lns worker which solves relaxed version of the original problem
     * by removing constraints from the problem in order to get better bounds.
     * </pre>
     *
     * <code>optional bool use_relaxation_lns = 150 [default = false];</code>
     * @param value The useRelaxationLns to set.
     * @return This builder for chaining.
     */
    public Builder setUseRelaxationLns(boolean value) {
      bitField4_ |= 0x00800000;
      useRelaxationLns_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Turns on a lns worker which solves relaxed version of the original problem
     * by removing constraints from the problem in order to get better bounds.
     * </pre>
     *
     * <code>optional bool use_relaxation_lns = 150 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseRelaxationLns() {
      bitField4_ = (bitField4_ & ~0x00800000);
      useRelaxationLns_ = false;
      onChanged();
      return this;
    }

    private boolean diversifyLnsParams_ ;
    /**
     * <pre>
     * If true, registers more lns subsolvers with different parameters.
     * </pre>
     *
     * <code>optional bool diversify_lns_params = 137 [default = false];</code>
     * @return Whether the diversifyLnsParams field is set.
     */
    @java.lang.Override
    public boolean hasDiversifyLnsParams() {
      return ((bitField4_ & 0x01000000) != 0);
    }
    /**
     * <pre>
     * If true, registers more lns subsolvers with different parameters.
     * </pre>
     *
     * <code>optional bool diversify_lns_params = 137 [default = false];</code>
     * @return The diversifyLnsParams.
     */
    @java.lang.Override
    public boolean getDiversifyLnsParams() {
      return diversifyLnsParams_;
    }
    /**
     * <pre>
     * If true, registers more lns subsolvers with different parameters.
     * </pre>
     *
     * <code>optional bool diversify_lns_params = 137 [default = false];</code>
     * @param value The diversifyLnsParams to set.
     * @return This builder for chaining.
     */
    public Builder setDiversifyLnsParams(boolean value) {
      bitField4_ |= 0x01000000;
      diversifyLnsParams_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, registers more lns subsolvers with different parameters.
     * </pre>
     *
     * <code>optional bool diversify_lns_params = 137 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearDiversifyLnsParams() {
      bitField4_ = (bitField4_ & ~0x01000000);
      diversifyLnsParams_ = false;
      onChanged();
      return this;
    }

    private boolean randomizeSearch_ ;
    /**
     * <pre>
     * Randomize fixed search.
     * </pre>
     *
     * <code>optional bool randomize_search = 103 [default = false];</code>
     * @return Whether the randomizeSearch field is set.
     */
    @java.lang.Override
    public boolean hasRandomizeSearch() {
      return ((bitField4_ & 0x02000000) != 0);
    }
    /**
     * <pre>
     * Randomize fixed search.
     * </pre>
     *
     * <code>optional bool randomize_search = 103 [default = false];</code>
     * @return The randomizeSearch.
     */
    @java.lang.Override
    public boolean getRandomizeSearch() {
      return randomizeSearch_;
    }
    /**
     * <pre>
     * Randomize fixed search.
     * </pre>
     *
     * <code>optional bool randomize_search = 103 [default = false];</code>
     * @param value The randomizeSearch to set.
     * @return This builder for chaining.
     */
    public Builder setRandomizeSearch(boolean value) {
      bitField4_ |= 0x02000000;
      randomizeSearch_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Randomize fixed search.
     * </pre>
     *
     * <code>optional bool randomize_search = 103 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearRandomizeSearch() {
      bitField4_ = (bitField4_ & ~0x02000000);
      randomizeSearch_ = false;
      onChanged();
      return this;
    }

    private long searchRandomizationTolerance_ ;
    /**
     * <pre>
     * Search randomization will collect equivalent 'max valued' variables, and
     * pick one randomly. For instance, if the variable strategy is CHOOSE_FIRST,
     * all unassigned variables are equivalent. If the variable strategy is
     * CHOOSE_LOWEST_MIN, and `lm` is the current lowest min of all unassigned
     * variables, then the set of max valued variables will be all unassigned
     * variables where
     *    lm &lt;= variable min &lt;= lm + search_randomization_tolerance
     * </pre>
     *
     * <code>optional int64 search_randomization_tolerance = 104 [default = 0];</code>
     * @return Whether the searchRandomizationTolerance field is set.
     */
    @java.lang.Override
    public boolean hasSearchRandomizationTolerance() {
      return ((bitField4_ & 0x04000000) != 0);
    }
    /**
     * <pre>
     * Search randomization will collect equivalent 'max valued' variables, and
     * pick one randomly. For instance, if the variable strategy is CHOOSE_FIRST,
     * all unassigned variables are equivalent. If the variable strategy is
     * CHOOSE_LOWEST_MIN, and `lm` is the current lowest min of all unassigned
     * variables, then the set of max valued variables will be all unassigned
     * variables where
     *    lm &lt;= variable min &lt;= lm + search_randomization_tolerance
     * </pre>
     *
     * <code>optional int64 search_randomization_tolerance = 104 [default = 0];</code>
     * @return The searchRandomizationTolerance.
     */
    @java.lang.Override
    public long getSearchRandomizationTolerance() {
      return searchRandomizationTolerance_;
    }
    /**
     * <pre>
     * Search randomization will collect equivalent 'max valued' variables, and
     * pick one randomly. For instance, if the variable strategy is CHOOSE_FIRST,
     * all unassigned variables are equivalent. If the variable strategy is
     * CHOOSE_LOWEST_MIN, and `lm` is the current lowest min of all unassigned
     * variables, then the set of max valued variables will be all unassigned
     * variables where
     *    lm &lt;= variable min &lt;= lm + search_randomization_tolerance
     * </pre>
     *
     * <code>optional int64 search_randomization_tolerance = 104 [default = 0];</code>
     * @param value The searchRandomizationTolerance to set.
     * @return This builder for chaining.
     */
    public Builder setSearchRandomizationTolerance(long value) {
      bitField4_ |= 0x04000000;
      searchRandomizationTolerance_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Search randomization will collect equivalent 'max valued' variables, and
     * pick one randomly. For instance, if the variable strategy is CHOOSE_FIRST,
     * all unassigned variables are equivalent. If the variable strategy is
     * CHOOSE_LOWEST_MIN, and `lm` is the current lowest min of all unassigned
     * variables, then the set of max valued variables will be all unassigned
     * variables where
     *    lm &lt;= variable min &lt;= lm + search_randomization_tolerance
     * </pre>
     *
     * <code>optional int64 search_randomization_tolerance = 104 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearSearchRandomizationTolerance() {
      bitField4_ = (bitField4_ & ~0x04000000);
      searchRandomizationTolerance_ = 0L;
      onChanged();
      return this;
    }

    private boolean useOptionalVariables_ = true;
    /**
     * <pre>
     * If true, we automatically detect variables whose constraint are always
     * enforced by the same literal and we mark them as optional. This allows
     * to propagate them as if they were present in some situation.
     * </pre>
     *
     * <code>optional bool use_optional_variables = 108 [default = true];</code>
     * @return Whether the useOptionalVariables field is set.
     */
    @java.lang.Override
    public boolean hasUseOptionalVariables() {
      return ((bitField4_ & 0x08000000) != 0);
    }
    /**
     * <pre>
     * If true, we automatically detect variables whose constraint are always
     * enforced by the same literal and we mark them as optional. This allows
     * to propagate them as if they were present in some situation.
     * </pre>
     *
     * <code>optional bool use_optional_variables = 108 [default = true];</code>
     * @return The useOptionalVariables.
     */
    @java.lang.Override
    public boolean getUseOptionalVariables() {
      return useOptionalVariables_;
    }
    /**
     * <pre>
     * If true, we automatically detect variables whose constraint are always
     * enforced by the same literal and we mark them as optional. This allows
     * to propagate them as if they were present in some situation.
     * </pre>
     *
     * <code>optional bool use_optional_variables = 108 [default = true];</code>
     * @param value The useOptionalVariables to set.
     * @return This builder for chaining.
     */
    public Builder setUseOptionalVariables(boolean value) {
      bitField4_ |= 0x08000000;
      useOptionalVariables_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, we automatically detect variables whose constraint are always
     * enforced by the same literal and we mark them as optional. This allows
     * to propagate them as if they were present in some situation.
     * </pre>
     *
     * <code>optional bool use_optional_variables = 108 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseOptionalVariables() {
      bitField4_ = (bitField4_ & ~0x08000000);
      useOptionalVariables_ = true;
      onChanged();
      return this;
    }

    private boolean useExactLpReason_ = true;
    /**
     * <pre>
     * The solver usually exploit the LP relaxation of a model. If this option is
     * true, then whatever is infered by the LP will be used like an heuristic to
     * compute EXACT propagation on the IP. So with this option, there is no
     * numerical imprecision issues.
     * </pre>
     *
     * <code>optional bool use_exact_lp_reason = 109 [default = true];</code>
     * @return Whether the useExactLpReason field is set.
     */
    @java.lang.Override
    public boolean hasUseExactLpReason() {
      return ((bitField4_ & 0x10000000) != 0);
    }
    /**
     * <pre>
     * The solver usually exploit the LP relaxation of a model. If this option is
     * true, then whatever is infered by the LP will be used like an heuristic to
     * compute EXACT propagation on the IP. So with this option, there is no
     * numerical imprecision issues.
     * </pre>
     *
     * <code>optional bool use_exact_lp_reason = 109 [default = true];</code>
     * @return The useExactLpReason.
     */
    @java.lang.Override
    public boolean getUseExactLpReason() {
      return useExactLpReason_;
    }
    /**
     * <pre>
     * The solver usually exploit the LP relaxation of a model. If this option is
     * true, then whatever is infered by the LP will be used like an heuristic to
     * compute EXACT propagation on the IP. So with this option, there is no
     * numerical imprecision issues.
     * </pre>
     *
     * <code>optional bool use_exact_lp_reason = 109 [default = true];</code>
     * @param value The useExactLpReason to set.
     * @return This builder for chaining.
     */
    public Builder setUseExactLpReason(boolean value) {
      bitField4_ |= 0x10000000;
      useExactLpReason_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The solver usually exploit the LP relaxation of a model. If this option is
     * true, then whatever is infered by the LP will be used like an heuristic to
     * compute EXACT propagation on the IP. So with this option, there is no
     * numerical imprecision issues.
     * </pre>
     *
     * <code>optional bool use_exact_lp_reason = 109 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseExactLpReason() {
      bitField4_ = (bitField4_ & ~0x10000000);
      useExactLpReason_ = true;
      onChanged();
      return this;
    }

    private boolean useBranchingInLp_ ;
    /**
     * <pre>
     * If true, the solver attemts to generate more info inside lp propagator by
     * branching on some variables if certain criteria are met during the search
     * tree exploration.
     * </pre>
     *
     * <code>optional bool use_branching_in_lp = 139 [default = false];</code>
     * @return Whether the useBranchingInLp field is set.
     */
    @java.lang.Override
    public boolean hasUseBranchingInLp() {
      return ((bitField4_ & 0x20000000) != 0);
    }
    /**
     * <pre>
     * If true, the solver attemts to generate more info inside lp propagator by
     * branching on some variables if certain criteria are met during the search
     * tree exploration.
     * </pre>
     *
     * <code>optional bool use_branching_in_lp = 139 [default = false];</code>
     * @return The useBranchingInLp.
     */
    @java.lang.Override
    public boolean getUseBranchingInLp() {
      return useBranchingInLp_;
    }
    /**
     * <pre>
     * If true, the solver attemts to generate more info inside lp propagator by
     * branching on some variables if certain criteria are met during the search
     * tree exploration.
     * </pre>
     *
     * <code>optional bool use_branching_in_lp = 139 [default = false];</code>
     * @param value The useBranchingInLp to set.
     * @return This builder for chaining.
     */
    public Builder setUseBranchingInLp(boolean value) {
      bitField4_ |= 0x20000000;
      useBranchingInLp_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, the solver attemts to generate more info inside lp propagator by
     * branching on some variables if certain criteria are met during the search
     * tree exploration.
     * </pre>
     *
     * <code>optional bool use_branching_in_lp = 139 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseBranchingInLp() {
      bitField4_ = (bitField4_ & ~0x20000000);
      useBranchingInLp_ = false;
      onChanged();
      return this;
    }

    private boolean useCombinedNoOverlap_ ;
    /**
     * <pre>
     * This can be beneficial if there is a lot of no-overlap constraints but a
     * relatively low number of different intervals in the problem. Like 1000
     * intervals, but 1M intervals in the no-overlap constraints covering them.
     * </pre>
     *
     * <code>optional bool use_combined_no_overlap = 133 [default = false];</code>
     * @return Whether the useCombinedNoOverlap field is set.
     */
    @java.lang.Override
    public boolean hasUseCombinedNoOverlap() {
      return ((bitField4_ & 0x40000000) != 0);
    }
    /**
     * <pre>
     * This can be beneficial if there is a lot of no-overlap constraints but a
     * relatively low number of different intervals in the problem. Like 1000
     * intervals, but 1M intervals in the no-overlap constraints covering them.
     * </pre>
     *
     * <code>optional bool use_combined_no_overlap = 133 [default = false];</code>
     * @return The useCombinedNoOverlap.
     */
    @java.lang.Override
    public boolean getUseCombinedNoOverlap() {
      return useCombinedNoOverlap_;
    }
    /**
     * <pre>
     * This can be beneficial if there is a lot of no-overlap constraints but a
     * relatively low number of different intervals in the problem. Like 1000
     * intervals, but 1M intervals in the no-overlap constraints covering them.
     * </pre>
     *
     * <code>optional bool use_combined_no_overlap = 133 [default = false];</code>
     * @param value The useCombinedNoOverlap to set.
     * @return This builder for chaining.
     */
    public Builder setUseCombinedNoOverlap(boolean value) {
      bitField4_ |= 0x40000000;
      useCombinedNoOverlap_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * This can be beneficial if there is a lot of no-overlap constraints but a
     * relatively low number of different intervals in the problem. Like 1000
     * intervals, but 1M intervals in the no-overlap constraints covering them.
     * </pre>
     *
     * <code>optional bool use_combined_no_overlap = 133 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseCombinedNoOverlap() {
      bitField4_ = (bitField4_ & ~0x40000000);
      useCombinedNoOverlap_ = false;
      onChanged();
      return this;
    }

    private boolean catchSigintSignal_ = true;
    /**
     * <pre>
     * Indicates if the CP-SAT layer should catch Control-C (SIGINT) signals
     * when calling solve. If set, catching the SIGINT signal will terminate the
     * search gracefully, as if a time limit was reached.
     * </pre>
     *
     * <code>optional bool catch_sigint_signal = 135 [default = true];</code>
     * @return Whether the catchSigintSignal field is set.
     */
    @java.lang.Override
    public boolean hasCatchSigintSignal() {
      return ((bitField4_ & 0x80000000) != 0);
    }
    /**
     * <pre>
     * Indicates if the CP-SAT layer should catch Control-C (SIGINT) signals
     * when calling solve. If set, catching the SIGINT signal will terminate the
     * search gracefully, as if a time limit was reached.
     * </pre>
     *
     * <code>optional bool catch_sigint_signal = 135 [default = true];</code>
     * @return The catchSigintSignal.
     */
    @java.lang.Override
    public boolean getCatchSigintSignal() {
      return catchSigintSignal_;
    }
    /**
     * <pre>
     * Indicates if the CP-SAT layer should catch Control-C (SIGINT) signals
     * when calling solve. If set, catching the SIGINT signal will terminate the
     * search gracefully, as if a time limit was reached.
     * </pre>
     *
     * <code>optional bool catch_sigint_signal = 135 [default = true];</code>
     * @param value The catchSigintSignal to set.
     * @return This builder for chaining.
     */
    public Builder setCatchSigintSignal(boolean value) {
      bitField4_ |= 0x80000000;
      catchSigintSignal_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Indicates if the CP-SAT layer should catch Control-C (SIGINT) signals
     * when calling solve. If set, catching the SIGINT signal will terminate the
     * search gracefully, as if a time limit was reached.
     * </pre>
     *
     * <code>optional bool catch_sigint_signal = 135 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearCatchSigintSignal() {
      bitField4_ = (bitField4_ & ~0x80000000);
      catchSigintSignal_ = true;
      onChanged();
      return this;
    }

    private boolean useImpliedBounds_ = true;
    /**
     * <pre>
     * Stores and exploits "implied-bounds" in the solver. That is, relations of
     * the form literal =&gt; (var &gt;= bound). This is currently used to derive
     * stronger cuts.
     * </pre>
     *
     * <code>optional bool use_implied_bounds = 144 [default = true];</code>
     * @return Whether the useImpliedBounds field is set.
     */
    @java.lang.Override
    public boolean hasUseImpliedBounds() {
      return ((bitField5_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Stores and exploits "implied-bounds" in the solver. That is, relations of
     * the form literal =&gt; (var &gt;= bound). This is currently used to derive
     * stronger cuts.
     * </pre>
     *
     * <code>optional bool use_implied_bounds = 144 [default = true];</code>
     * @return The useImpliedBounds.
     */
    @java.lang.Override
    public boolean getUseImpliedBounds() {
      return useImpliedBounds_;
    }
    /**
     * <pre>
     * Stores and exploits "implied-bounds" in the solver. That is, relations of
     * the form literal =&gt; (var &gt;= bound). This is currently used to derive
     * stronger cuts.
     * </pre>
     *
     * <code>optional bool use_implied_bounds = 144 [default = true];</code>
     * @param value The useImpliedBounds to set.
     * @return This builder for chaining.
     */
    public Builder setUseImpliedBounds(boolean value) {
      bitField5_ |= 0x00000001;
      useImpliedBounds_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Stores and exploits "implied-bounds" in the solver. That is, relations of
     * the form literal =&gt; (var &gt;= bound). This is currently used to derive
     * stronger cuts.
     * </pre>
     *
     * <code>optional bool use_implied_bounds = 144 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseImpliedBounds() {
      bitField5_ = (bitField5_ & ~0x00000001);
      useImpliedBounds_ = true;
      onChanged();
      return this;
    }

    private boolean polishLpSolution_ ;
    /**
     * <pre>
     * Whether we try to do a few degenerate iteration at the end of an LP solve
     * to minimize the fractionality of the integer variable in the basis. This
     * helps on some problems, but not so much on others. It also cost of bit of
     * time to do such polish step.
     * </pre>
     *
     * <code>optional bool polish_lp_solution = 175 [default = false];</code>
     * @return Whether the polishLpSolution field is set.
     */
    @java.lang.Override
    public boolean hasPolishLpSolution() {
      return ((bitField5_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Whether we try to do a few degenerate iteration at the end of an LP solve
     * to minimize the fractionality of the integer variable in the basis. This
     * helps on some problems, but not so much on others. It also cost of bit of
     * time to do such polish step.
     * </pre>
     *
     * <code>optional bool polish_lp_solution = 175 [default = false];</code>
     * @return The polishLpSolution.
     */
    @java.lang.Override
    public boolean getPolishLpSolution() {
      return polishLpSolution_;
    }
    /**
     * <pre>
     * Whether we try to do a few degenerate iteration at the end of an LP solve
     * to minimize the fractionality of the integer variable in the basis. This
     * helps on some problems, but not so much on others. It also cost of bit of
     * time to do such polish step.
     * </pre>
     *
     * <code>optional bool polish_lp_solution = 175 [default = false];</code>
     * @param value The polishLpSolution to set.
     * @return This builder for chaining.
     */
    public Builder setPolishLpSolution(boolean value) {
      bitField5_ |= 0x00000002;
      polishLpSolution_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we try to do a few degenerate iteration at the end of an LP solve
     * to minimize the fractionality of the integer variable in the basis. This
     * helps on some problems, but not so much on others. It also cost of bit of
     * time to do such polish step.
     * </pre>
     *
     * <code>optional bool polish_lp_solution = 175 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearPolishLpSolution() {
      bitField5_ = (bitField5_ & ~0x00000002);
      polishLpSolution_ = false;
      onChanged();
      return this;
    }

    private boolean convertIntervals_ = true;
    /**
     * <pre>
     * Temporary flag util the feature is more mature. This convert intervals to
     * the newer proto format that support affine start/var/end instead of just
     * variables.
     * </pre>
     *
     * <code>optional bool convert_intervals = 177 [default = true];</code>
     * @return Whether the convertIntervals field is set.
     */
    @java.lang.Override
    public boolean hasConvertIntervals() {
      return ((bitField5_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * Temporary flag util the feature is more mature. This convert intervals to
     * the newer proto format that support affine start/var/end instead of just
     * variables.
     * </pre>
     *
     * <code>optional bool convert_intervals = 177 [default = true];</code>
     * @return The convertIntervals.
     */
    @java.lang.Override
    public boolean getConvertIntervals() {
      return convertIntervals_;
    }
    /**
     * <pre>
     * Temporary flag util the feature is more mature. This convert intervals to
     * the newer proto format that support affine start/var/end instead of just
     * variables.
     * </pre>
     *
     * <code>optional bool convert_intervals = 177 [default = true];</code>
     * @param value The convertIntervals to set.
     * @return This builder for chaining.
     */
    public Builder setConvertIntervals(boolean value) {
      bitField5_ |= 0x00000004;
      convertIntervals_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Temporary flag util the feature is more mature. This convert intervals to
     * the newer proto format that support affine start/var/end instead of just
     * variables.
     * </pre>
     *
     * <code>optional bool convert_intervals = 177 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearConvertIntervals() {
      bitField5_ = (bitField5_ & ~0x00000004);
      convertIntervals_ = true;
      onChanged();
      return this;
    }

    private int symmetryLevel_ = 2;
    /**
     * <pre>
     * Whether we try to automatically detect the symmetries in a model and
     * exploit them. Currently, at level 1 we detect them in presolve and try
     * to fix Booleans. At level 2, we also do some form of dynamic symmetry
     * breaking during search.
     * </pre>
     *
     * <code>optional int32 symmetry_level = 183 [default = 2];</code>
     * @return Whether the symmetryLevel field is set.
     */
    @java.lang.Override
    public boolean hasSymmetryLevel() {
      return ((bitField5_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * Whether we try to automatically detect the symmetries in a model and
     * exploit them. Currently, at level 1 we detect them in presolve and try
     * to fix Booleans. At level 2, we also do some form of dynamic symmetry
     * breaking during search.
     * </pre>
     *
     * <code>optional int32 symmetry_level = 183 [default = 2];</code>
     * @return The symmetryLevel.
     */
    @java.lang.Override
    public int getSymmetryLevel() {
      return symmetryLevel_;
    }
    /**
     * <pre>
     * Whether we try to automatically detect the symmetries in a model and
     * exploit them. Currently, at level 1 we detect them in presolve and try
     * to fix Booleans. At level 2, we also do some form of dynamic symmetry
     * breaking during search.
     * </pre>
     *
     * <code>optional int32 symmetry_level = 183 [default = 2];</code>
     * @param value The symmetryLevel to set.
     * @return This builder for chaining.
     */
    public Builder setSymmetryLevel(int value) {
      bitField5_ |= 0x00000008;
      symmetryLevel_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we try to automatically detect the symmetries in a model and
     * exploit them. Currently, at level 1 we detect them in presolve and try
     * to fix Booleans. At level 2, we also do some form of dynamic symmetry
     * breaking during search.
     * </pre>
     *
     * <code>optional int32 symmetry_level = 183 [default = 2];</code>
     * @return This builder for chaining.
     */
    public Builder clearSymmetryLevel() {
      bitField5_ = (bitField5_ & ~0x00000008);
      symmetryLevel_ = 2;
      onChanged();
      return this;
    }

    private double mipMaxBound_ = 10000000D;
    /**
     * <pre>
     * We need to bound the maximum magnitude of the variables for CP-SAT, and
     * that is the bound we use. If the MIP model expect larger variable value in
     * the solution, then the converted model will likely not be relevant.
     * </pre>
     *
     * <code>optional double mip_max_bound = 124 [default = 10000000];</code>
     * @return Whether the mipMaxBound field is set.
     */
    @java.lang.Override
    public boolean hasMipMaxBound() {
      return ((bitField5_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * We need to bound the maximum magnitude of the variables for CP-SAT, and
     * that is the bound we use. If the MIP model expect larger variable value in
     * the solution, then the converted model will likely not be relevant.
     * </pre>
     *
     * <code>optional double mip_max_bound = 124 [default = 10000000];</code>
     * @return The mipMaxBound.
     */
    @java.lang.Override
    public double getMipMaxBound() {
      return mipMaxBound_;
    }
    /**
     * <pre>
     * We need to bound the maximum magnitude of the variables for CP-SAT, and
     * that is the bound we use. If the MIP model expect larger variable value in
     * the solution, then the converted model will likely not be relevant.
     * </pre>
     *
     * <code>optional double mip_max_bound = 124 [default = 10000000];</code>
     * @param value The mipMaxBound to set.
     * @return This builder for chaining.
     */
    public Builder setMipMaxBound(double value) {
      bitField5_ |= 0x00000010;
      mipMaxBound_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * We need to bound the maximum magnitude of the variables for CP-SAT, and
     * that is the bound we use. If the MIP model expect larger variable value in
     * the solution, then the converted model will likely not be relevant.
     * </pre>
     *
     * <code>optional double mip_max_bound = 124 [default = 10000000];</code>
     * @return This builder for chaining.
     */
    public Builder clearMipMaxBound() {
      bitField5_ = (bitField5_ & ~0x00000010);
      mipMaxBound_ = 10000000D;
      onChanged();
      return this;
    }

    private double mipVarScaling_ = 1D;
    /**
     * <pre>
     * All continuous variable of the problem will be multiplied by this factor.
     * By default, we don't do any variable scaling and rely on the MIP model to
     * specify continuous variable domain with the wanted precision.
     * </pre>
     *
     * <code>optional double mip_var_scaling = 125 [default = 1];</code>
     * @return Whether the mipVarScaling field is set.
     */
    @java.lang.Override
    public boolean hasMipVarScaling() {
      return ((bitField5_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * All continuous variable of the problem will be multiplied by this factor.
     * By default, we don't do any variable scaling and rely on the MIP model to
     * specify continuous variable domain with the wanted precision.
     * </pre>
     *
     * <code>optional double mip_var_scaling = 125 [default = 1];</code>
     * @return The mipVarScaling.
     */
    @java.lang.Override
    public double getMipVarScaling() {
      return mipVarScaling_;
    }
    /**
     * <pre>
     * All continuous variable of the problem will be multiplied by this factor.
     * By default, we don't do any variable scaling and rely on the MIP model to
     * specify continuous variable domain with the wanted precision.
     * </pre>
     *
     * <code>optional double mip_var_scaling = 125 [default = 1];</code>
     * @param value The mipVarScaling to set.
     * @return This builder for chaining.
     */
    public Builder setMipVarScaling(double value) {
      bitField5_ |= 0x00000020;
      mipVarScaling_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * All continuous variable of the problem will be multiplied by this factor.
     * By default, we don't do any variable scaling and rely on the MIP model to
     * specify continuous variable domain with the wanted precision.
     * </pre>
     *
     * <code>optional double mip_var_scaling = 125 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearMipVarScaling() {
      bitField5_ = (bitField5_ & ~0x00000020);
      mipVarScaling_ = 1D;
      onChanged();
      return this;
    }

    private boolean mipAutomaticallyScaleVariables_ = true;
    /**
     * <pre>
     * If true, some continuous variable might be automatically scaled. For now,
     * this is only the case where we detect that a variable is actually an
     * integer multiple of a constant. For instance, variables of the form k * 0.5
     * are quite frequent, and if we detect this, we will scale such variable
     * domain by 2 to make it implied integer.
     * </pre>
     *
     * <code>optional bool mip_automatically_scale_variables = 166 [default = true];</code>
     * @return Whether the mipAutomaticallyScaleVariables field is set.
     */
    @java.lang.Override
    public boolean hasMipAutomaticallyScaleVariables() {
      return ((bitField5_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * If true, some continuous variable might be automatically scaled. For now,
     * this is only the case where we detect that a variable is actually an
     * integer multiple of a constant. For instance, variables of the form k * 0.5
     * are quite frequent, and if we detect this, we will scale such variable
     * domain by 2 to make it implied integer.
     * </pre>
     *
     * <code>optional bool mip_automatically_scale_variables = 166 [default = true];</code>
     * @return The mipAutomaticallyScaleVariables.
     */
    @java.lang.Override
    public boolean getMipAutomaticallyScaleVariables() {
      return mipAutomaticallyScaleVariables_;
    }
    /**
     * <pre>
     * If true, some continuous variable might be automatically scaled. For now,
     * this is only the case where we detect that a variable is actually an
     * integer multiple of a constant. For instance, variables of the form k * 0.5
     * are quite frequent, and if we detect this, we will scale such variable
     * domain by 2 to make it implied integer.
     * </pre>
     *
     * <code>optional bool mip_automatically_scale_variables = 166 [default = true];</code>
     * @param value The mipAutomaticallyScaleVariables to set.
     * @return This builder for chaining.
     */
    public Builder setMipAutomaticallyScaleVariables(boolean value) {
      bitField5_ |= 0x00000040;
      mipAutomaticallyScaleVariables_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, some continuous variable might be automatically scaled. For now,
     * this is only the case where we detect that a variable is actually an
     * integer multiple of a constant. For instance, variables of the form k * 0.5
     * are quite frequent, and if we detect this, we will scale such variable
     * domain by 2 to make it implied integer.
     * </pre>
     *
     * <code>optional bool mip_automatically_scale_variables = 166 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearMipAutomaticallyScaleVariables() {
      bitField5_ = (bitField5_ & ~0x00000040);
      mipAutomaticallyScaleVariables_ = true;
      onChanged();
      return this;
    }

    private double mipWantedPrecision_ = 1e-06D;
    /**
     * <pre>
     * When scaling constraint with double coefficients to integer coefficients,
     * we will multiply by a power of 2 and round the coefficients. We will choose
     * the lowest power such that we have no potential overflow and the worst case
     * constraint activity error do not exceed this threshold relative to the
     * constraint bounds.
     * We also use this to decide by how much we relax the constraint bounds so
     * that we can have a feasible integer solution of constraints involving
     * continuous variable. This is required for instance when you have an == rhs
     * constraint as in many situation you cannot have a perfect equality with
     * integer variables and coefficients.
     * </pre>
     *
     * <code>optional double mip_wanted_precision = 126 [default = 1e-06];</code>
     * @return Whether the mipWantedPrecision field is set.
     */
    @java.lang.Override
    public boolean hasMipWantedPrecision() {
      return ((bitField5_ & 0x00000080) != 0);
    }
    /**
     * <pre>
     * When scaling constraint with double coefficients to integer coefficients,
     * we will multiply by a power of 2 and round the coefficients. We will choose
     * the lowest power such that we have no potential overflow and the worst case
     * constraint activity error do not exceed this threshold relative to the
     * constraint bounds.
     * We also use this to decide by how much we relax the constraint bounds so
     * that we can have a feasible integer solution of constraints involving
     * continuous variable. This is required for instance when you have an == rhs
     * constraint as in many situation you cannot have a perfect equality with
     * integer variables and coefficients.
     * </pre>
     *
     * <code>optional double mip_wanted_precision = 126 [default = 1e-06];</code>
     * @return The mipWantedPrecision.
     */
    @java.lang.Override
    public double getMipWantedPrecision() {
      return mipWantedPrecision_;
    }
    /**
     * <pre>
     * When scaling constraint with double coefficients to integer coefficients,
     * we will multiply by a power of 2 and round the coefficients. We will choose
     * the lowest power such that we have no potential overflow and the worst case
     * constraint activity error do not exceed this threshold relative to the
     * constraint bounds.
     * We also use this to decide by how much we relax the constraint bounds so
     * that we can have a feasible integer solution of constraints involving
     * continuous variable. This is required for instance when you have an == rhs
     * constraint as in many situation you cannot have a perfect equality with
     * integer variables and coefficients.
     * </pre>
     *
     * <code>optional double mip_wanted_precision = 126 [default = 1e-06];</code>
     * @param value The mipWantedPrecision to set.
     * @return This builder for chaining.
     */
    public Builder setMipWantedPrecision(double value) {
      bitField5_ |= 0x00000080;
      mipWantedPrecision_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * When scaling constraint with double coefficients to integer coefficients,
     * we will multiply by a power of 2 and round the coefficients. We will choose
     * the lowest power such that we have no potential overflow and the worst case
     * constraint activity error do not exceed this threshold relative to the
     * constraint bounds.
     * We also use this to decide by how much we relax the constraint bounds so
     * that we can have a feasible integer solution of constraints involving
     * continuous variable. This is required for instance when you have an == rhs
     * constraint as in many situation you cannot have a perfect equality with
     * integer variables and coefficients.
     * </pre>
     *
     * <code>optional double mip_wanted_precision = 126 [default = 1e-06];</code>
     * @return This builder for chaining.
     */
    public Builder clearMipWantedPrecision() {
      bitField5_ = (bitField5_ & ~0x00000080);
      mipWantedPrecision_ = 1e-06D;
      onChanged();
      return this;
    }

    private int mipMaxActivityExponent_ = 53;
    /**
     * <pre>
     * To avoid integer overflow, we always force the maximum possible constraint
     * activity (and objective value) according to the initial variable domain to
     * be smaller than 2 to this given power. Because of this, we cannot always
     * reach the "mip_wanted_precision" parameter above.
     * This can go as high as 62, but some internal algo currently abort early if
     * they might run into integer overflow, so it is better to keep it a bit
     * lower than this.
     * </pre>
     *
     * <code>optional int32 mip_max_activity_exponent = 127 [default = 53];</code>
     * @return Whether the mipMaxActivityExponent field is set.
     */
    @java.lang.Override
    public boolean hasMipMaxActivityExponent() {
      return ((bitField5_ & 0x00000100) != 0);
    }
    /**
     * <pre>
     * To avoid integer overflow, we always force the maximum possible constraint
     * activity (and objective value) according to the initial variable domain to
     * be smaller than 2 to this given power. Because of this, we cannot always
     * reach the "mip_wanted_precision" parameter above.
     * This can go as high as 62, but some internal algo currently abort early if
     * they might run into integer overflow, so it is better to keep it a bit
     * lower than this.
     * </pre>
     *
     * <code>optional int32 mip_max_activity_exponent = 127 [default = 53];</code>
     * @return The mipMaxActivityExponent.
     */
    @java.lang.Override
    public int getMipMaxActivityExponent() {
      return mipMaxActivityExponent_;
    }
    /**
     * <pre>
     * To avoid integer overflow, we always force the maximum possible constraint
     * activity (and objective value) according to the initial variable domain to
     * be smaller than 2 to this given power. Because of this, we cannot always
     * reach the "mip_wanted_precision" parameter above.
     * This can go as high as 62, but some internal algo currently abort early if
     * they might run into integer overflow, so it is better to keep it a bit
     * lower than this.
     * </pre>
     *
     * <code>optional int32 mip_max_activity_exponent = 127 [default = 53];</code>
     * @param value The mipMaxActivityExponent to set.
     * @return This builder for chaining.
     */
    public Builder setMipMaxActivityExponent(int value) {
      bitField5_ |= 0x00000100;
      mipMaxActivityExponent_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * To avoid integer overflow, we always force the maximum possible constraint
     * activity (and objective value) according to the initial variable domain to
     * be smaller than 2 to this given power. Because of this, we cannot always
     * reach the "mip_wanted_precision" parameter above.
     * This can go as high as 62, but some internal algo currently abort early if
     * they might run into integer overflow, so it is better to keep it a bit
     * lower than this.
     * </pre>
     *
     * <code>optional int32 mip_max_activity_exponent = 127 [default = 53];</code>
     * @return This builder for chaining.
     */
    public Builder clearMipMaxActivityExponent() {
      bitField5_ = (bitField5_ & ~0x00000100);
      mipMaxActivityExponent_ = 53;
      onChanged();
      return this;
    }

    private double mipCheckPrecision_ = 0.0001D;
    /**
     * <pre>
     * As explained in mip_precision and mip_max_activity_exponent, we cannot
     * always reach the wanted precision during scaling. We use this threshold to
     * enphasize in the logs when the precision seems bad.
     * </pre>
     *
     * <code>optional double mip_check_precision = 128 [default = 0.0001];</code>
     * @return Whether the mipCheckPrecision field is set.
     */
    @java.lang.Override
    public boolean hasMipCheckPrecision() {
      return ((bitField5_ & 0x00000200) != 0);
    }
    /**
     * <pre>
     * As explained in mip_precision and mip_max_activity_exponent, we cannot
     * always reach the wanted precision during scaling. We use this threshold to
     * enphasize in the logs when the precision seems bad.
     * </pre>
     *
     * <code>optional double mip_check_precision = 128 [default = 0.0001];</code>
     * @return The mipCheckPrecision.
     */
    @java.lang.Override
    public double getMipCheckPrecision() {
      return mipCheckPrecision_;
    }
    /**
     * <pre>
     * As explained in mip_precision and mip_max_activity_exponent, we cannot
     * always reach the wanted precision during scaling. We use this threshold to
     * enphasize in the logs when the precision seems bad.
     * </pre>
     *
     * <code>optional double mip_check_precision = 128 [default = 0.0001];</code>
     * @param value The mipCheckPrecision to set.
     * @return This builder for chaining.
     */
    public Builder setMipCheckPrecision(double value) {
      bitField5_ |= 0x00000200;
      mipCheckPrecision_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * As explained in mip_precision and mip_max_activity_exponent, we cannot
     * always reach the wanted precision during scaling. We use this threshold to
     * enphasize in the logs when the precision seems bad.
     * </pre>
     *
     * <code>optional double mip_check_precision = 128 [default = 0.0001];</code>
     * @return This builder for chaining.
     */
    public Builder clearMipCheckPrecision() {
      bitField5_ = (bitField5_ & ~0x00000200);
      mipCheckPrecision_ = 0.0001D;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:operations_research.sat.SatParameters)
  }

  // @@protoc_insertion_point(class_scope:operations_research.sat.SatParameters)
  private static final com.google.ortools.sat.SatParameters DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ortools.sat.SatParameters();
  }

  public static com.google.ortools.sat.SatParameters getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  @java.lang.Deprecated public static final com.google.protobuf.Parser<SatParameters>
      PARSER = new com.google.protobuf.AbstractParser<SatParameters>() {
    @java.lang.Override
    public SatParameters parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new SatParameters(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<SatParameters> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SatParameters> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ortools.sat.SatParameters getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

