// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: ortools/sat/sat_parameters.proto

package com.google.ortools.sat;

public interface SatParametersOrBuilder extends
    // @@protoc_insertion_point(interface_extends:operations_research.sat.SatParameters)
    com.google.protobuf.MessageOrBuilder {

  /**
   * <pre>
   * In some context, like in a portfolio of search, it makes sense to name a
   * given parameters set for logging purpose.
   * </pre>
   *
   * <code>optional string name = 171 [default = ""];</code>
   * @return Whether the name field is set.
   */
  boolean hasName();
  /**
   * <pre>
   * In some context, like in a portfolio of search, it makes sense to name a
   * given parameters set for logging purpose.
   * </pre>
   *
   * <code>optional string name = 171 [default = ""];</code>
   * @return The name.
   */
  java.lang.String getName();
  /**
   * <pre>
   * In some context, like in a portfolio of search, it makes sense to name a
   * given parameters set for logging purpose.
   * </pre>
   *
   * <code>optional string name = 171 [default = ""];</code>
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString
      getNameBytes();

  /**
   * <code>optional .operations_research.sat.SatParameters.VariableOrder preferred_variable_order = 1 [default = IN_ORDER];</code>
   * @return Whether the preferredVariableOrder field is set.
   */
  boolean hasPreferredVariableOrder();
  /**
   * <code>optional .operations_research.sat.SatParameters.VariableOrder preferred_variable_order = 1 [default = IN_ORDER];</code>
   * @return The preferredVariableOrder.
   */
  com.google.ortools.sat.SatParameters.VariableOrder getPreferredVariableOrder();

  /**
   * <code>optional .operations_research.sat.SatParameters.Polarity initial_polarity = 2 [default = POLARITY_FALSE];</code>
   * @return Whether the initialPolarity field is set.
   */
  boolean hasInitialPolarity();
  /**
   * <code>optional .operations_research.sat.SatParameters.Polarity initial_polarity = 2 [default = POLARITY_FALSE];</code>
   * @return The initialPolarity.
   */
  com.google.ortools.sat.SatParameters.Polarity getInitialPolarity();

  /**
   * <pre>
   * If this is true, then the polarity of a variable will be the last value it
   * was assigned to, or its default polarity if it was never assigned since the
   * call to ResetDecisionHeuristic().
   * Actually, we use a newer version where we follow the last value in the
   * longest non-conflicting partial assignment in the current phase.
   * This is called 'literal phase saving'. For details see 'A Lightweight
   * Component Caching Scheme for Satisfiability Solvers' K. Pipatsrisawat and
   * A.Darwiche, In 10th International Conference on Theory and Applications of
   * Satisfiability Testing, 2007.
   * </pre>
   *
   * <code>optional bool use_phase_saving = 44 [default = true];</code>
   * @return Whether the usePhaseSaving field is set.
   */
  boolean hasUsePhaseSaving();
  /**
   * <pre>
   * If this is true, then the polarity of a variable will be the last value it
   * was assigned to, or its default polarity if it was never assigned since the
   * call to ResetDecisionHeuristic().
   * Actually, we use a newer version where we follow the last value in the
   * longest non-conflicting partial assignment in the current phase.
   * This is called 'literal phase saving'. For details see 'A Lightweight
   * Component Caching Scheme for Satisfiability Solvers' K. Pipatsrisawat and
   * A.Darwiche, In 10th International Conference on Theory and Applications of
   * Satisfiability Testing, 2007.
   * </pre>
   *
   * <code>optional bool use_phase_saving = 44 [default = true];</code>
   * @return The usePhaseSaving.
   */
  boolean getUsePhaseSaving();

  /**
   * <pre>
   * If non-zero, then we change the polarity heuristic after that many number
   * of conflicts in an arithmetically increasing fashion. So x the first time,
   * 2 * x the second time, etc...
   * </pre>
   *
   * <code>optional int32 polarity_rephase_increment = 168 [default = 1000];</code>
   * @return Whether the polarityRephaseIncrement field is set.
   */
  boolean hasPolarityRephaseIncrement();
  /**
   * <pre>
   * If non-zero, then we change the polarity heuristic after that many number
   * of conflicts in an arithmetically increasing fashion. So x the first time,
   * 2 * x the second time, etc...
   * </pre>
   *
   * <code>optional int32 polarity_rephase_increment = 168 [default = 1000];</code>
   * @return The polarityRephaseIncrement.
   */
  int getPolarityRephaseIncrement();

  /**
   * <pre>
   * The proportion of polarity chosen at random. Note that this take
   * precedence over the phase saving heuristic. This is different from
   * initial_polarity:POLARITY_RANDOM because it will select a new random
   * polarity each time the variable is branched upon instead of selecting one
   * initially and then always taking this choice.
   * </pre>
   *
   * <code>optional double random_polarity_ratio = 45 [default = 0];</code>
   * @return Whether the randomPolarityRatio field is set.
   */
  boolean hasRandomPolarityRatio();
  /**
   * <pre>
   * The proportion of polarity chosen at random. Note that this take
   * precedence over the phase saving heuristic. This is different from
   * initial_polarity:POLARITY_RANDOM because it will select a new random
   * polarity each time the variable is branched upon instead of selecting one
   * initially and then always taking this choice.
   * </pre>
   *
   * <code>optional double random_polarity_ratio = 45 [default = 0];</code>
   * @return The randomPolarityRatio.
   */
  double getRandomPolarityRatio();

  /**
   * <pre>
   * A number between 0 and 1 that indicates the proportion of branching
   * variables that are selected randomly instead of choosing the first variable
   * from the given variable_ordering strategy.
   * </pre>
   *
   * <code>optional double random_branches_ratio = 32 [default = 0];</code>
   * @return Whether the randomBranchesRatio field is set.
   */
  boolean hasRandomBranchesRatio();
  /**
   * <pre>
   * A number between 0 and 1 that indicates the proportion of branching
   * variables that are selected randomly instead of choosing the first variable
   * from the given variable_ordering strategy.
   * </pre>
   *
   * <code>optional double random_branches_ratio = 32 [default = 0];</code>
   * @return The randomBranchesRatio.
   */
  double getRandomBranchesRatio();

  /**
   * <pre>
   * Whether we use the ERWA (Exponential Recency Weighted Average) heuristic as
   * described in "Learning Rate Based Branching Heuristic for SAT solvers",
   * J.H.Liang, V. Ganesh, P. Poupart, K.Czarnecki, SAT 2016.
   * </pre>
   *
   * <code>optional bool use_erwa_heuristic = 75 [default = false];</code>
   * @return Whether the useErwaHeuristic field is set.
   */
  boolean hasUseErwaHeuristic();
  /**
   * <pre>
   * Whether we use the ERWA (Exponential Recency Weighted Average) heuristic as
   * described in "Learning Rate Based Branching Heuristic for SAT solvers",
   * J.H.Liang, V. Ganesh, P. Poupart, K.Czarnecki, SAT 2016.
   * </pre>
   *
   * <code>optional bool use_erwa_heuristic = 75 [default = false];</code>
   * @return The useErwaHeuristic.
   */
  boolean getUseErwaHeuristic();

  /**
   * <pre>
   * The initial value of the variables activity. A non-zero value only make
   * sense when use_erwa_heuristic is true. Experiments with a value of 1e-2
   * together with the ERWA heuristic showed slighthly better result than simply
   * using zero. The idea is that when the "learning rate" of a variable becomes
   * lower than this value, then we prefer to branch on never explored before
   * variables. This is not in the ERWA paper.
   * </pre>
   *
   * <code>optional double initial_variables_activity = 76 [default = 0];</code>
   * @return Whether the initialVariablesActivity field is set.
   */
  boolean hasInitialVariablesActivity();
  /**
   * <pre>
   * The initial value of the variables activity. A non-zero value only make
   * sense when use_erwa_heuristic is true. Experiments with a value of 1e-2
   * together with the ERWA heuristic showed slighthly better result than simply
   * using zero. The idea is that when the "learning rate" of a variable becomes
   * lower than this value, then we prefer to branch on never explored before
   * variables. This is not in the ERWA paper.
   * </pre>
   *
   * <code>optional double initial_variables_activity = 76 [default = 0];</code>
   * @return The initialVariablesActivity.
   */
  double getInitialVariablesActivity();

  /**
   * <pre>
   * When this is true, then the variables that appear in any of the reason of
   * the variables in a conflict have their activity bumped. This is addition to
   * the variables in the conflict, and the one that were used during conflict
   * resolution.
   * </pre>
   *
   * <code>optional bool also_bump_variables_in_conflict_reasons = 77 [default = false];</code>
   * @return Whether the alsoBumpVariablesInConflictReasons field is set.
   */
  boolean hasAlsoBumpVariablesInConflictReasons();
  /**
   * <pre>
   * When this is true, then the variables that appear in any of the reason of
   * the variables in a conflict have their activity bumped. This is addition to
   * the variables in the conflict, and the one that were used during conflict
   * resolution.
   * </pre>
   *
   * <code>optional bool also_bump_variables_in_conflict_reasons = 77 [default = false];</code>
   * @return The alsoBumpVariablesInConflictReasons.
   */
  boolean getAlsoBumpVariablesInConflictReasons();

  /**
   * <code>optional .operations_research.sat.SatParameters.ConflictMinimizationAlgorithm minimization_algorithm = 4 [default = RECURSIVE];</code>
   * @return Whether the minimizationAlgorithm field is set.
   */
  boolean hasMinimizationAlgorithm();
  /**
   * <code>optional .operations_research.sat.SatParameters.ConflictMinimizationAlgorithm minimization_algorithm = 4 [default = RECURSIVE];</code>
   * @return The minimizationAlgorithm.
   */
  com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm getMinimizationAlgorithm();

  /**
   * <code>optional .operations_research.sat.SatParameters.BinaryMinizationAlgorithm binary_minimization_algorithm = 34 [default = BINARY_MINIMIZATION_FIRST];</code>
   * @return Whether the binaryMinimizationAlgorithm field is set.
   */
  boolean hasBinaryMinimizationAlgorithm();
  /**
   * <code>optional .operations_research.sat.SatParameters.BinaryMinizationAlgorithm binary_minimization_algorithm = 34 [default = BINARY_MINIMIZATION_FIRST];</code>
   * @return The binaryMinimizationAlgorithm.
   */
  com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm getBinaryMinimizationAlgorithm();

  /**
   * <pre>
   * At a really low cost, during the 1-UIP conflict computation, it is easy to
   * detect if some of the involved reasons are subsumed by the current
   * conflict. When this is true, such clauses are detached and later removed
   * from the problem.
   * </pre>
   *
   * <code>optional bool subsumption_during_conflict_analysis = 56 [default = true];</code>
   * @return Whether the subsumptionDuringConflictAnalysis field is set.
   */
  boolean hasSubsumptionDuringConflictAnalysis();
  /**
   * <pre>
   * At a really low cost, during the 1-UIP conflict computation, it is easy to
   * detect if some of the involved reasons are subsumed by the current
   * conflict. When this is true, such clauses are detached and later removed
   * from the problem.
   * </pre>
   *
   * <code>optional bool subsumption_during_conflict_analysis = 56 [default = true];</code>
   * @return The subsumptionDuringConflictAnalysis.
   */
  boolean getSubsumptionDuringConflictAnalysis();

  /**
   * <pre>
   * Trigger a cleanup when this number of "deletable" clauses is learned.
   * </pre>
   *
   * <code>optional int32 clause_cleanup_period = 11 [default = 10000];</code>
   * @return Whether the clauseCleanupPeriod field is set.
   */
  boolean hasClauseCleanupPeriod();
  /**
   * <pre>
   * Trigger a cleanup when this number of "deletable" clauses is learned.
   * </pre>
   *
   * <code>optional int32 clause_cleanup_period = 11 [default = 10000];</code>
   * @return The clauseCleanupPeriod.
   */
  int getClauseCleanupPeriod();

  /**
   * <pre>
   * During a cleanup, we will always keep that number of "deletable" clauses.
   * Note that this doesn't include the "protected" clauses.
   * </pre>
   *
   * <code>optional int32 clause_cleanup_target = 13 [default = 0];</code>
   * @return Whether the clauseCleanupTarget field is set.
   */
  boolean hasClauseCleanupTarget();
  /**
   * <pre>
   * During a cleanup, we will always keep that number of "deletable" clauses.
   * Note that this doesn't include the "protected" clauses.
   * </pre>
   *
   * <code>optional int32 clause_cleanup_target = 13 [default = 0];</code>
   * @return The clauseCleanupTarget.
   */
  int getClauseCleanupTarget();

  /**
   * <pre>
   * During a cleanup, if clause_cleanup_target is 0, we will delete the
   * clause_cleanup_ratio of "deletable" clauses instead of aiming for a fixed
   * target of clauses to keep.
   * </pre>
   *
   * <code>optional double clause_cleanup_ratio = 190 [default = 0.5];</code>
   * @return Whether the clauseCleanupRatio field is set.
   */
  boolean hasClauseCleanupRatio();
  /**
   * <pre>
   * During a cleanup, if clause_cleanup_target is 0, we will delete the
   * clause_cleanup_ratio of "deletable" clauses instead of aiming for a fixed
   * target of clauses to keep.
   * </pre>
   *
   * <code>optional double clause_cleanup_ratio = 190 [default = 0.5];</code>
   * @return The clauseCleanupRatio.
   */
  double getClauseCleanupRatio();

  /**
   * <code>optional .operations_research.sat.SatParameters.ClauseProtection clause_cleanup_protection = 58 [default = PROTECTION_NONE];</code>
   * @return Whether the clauseCleanupProtection field is set.
   */
  boolean hasClauseCleanupProtection();
  /**
   * <code>optional .operations_research.sat.SatParameters.ClauseProtection clause_cleanup_protection = 58 [default = PROTECTION_NONE];</code>
   * @return The clauseCleanupProtection.
   */
  com.google.ortools.sat.SatParameters.ClauseProtection getClauseCleanupProtection();

  /**
   * <pre>
   * All the clauses with a LBD (literal blocks distance) lower or equal to this
   * parameters will always be kept.
   * </pre>
   *
   * <code>optional int32 clause_cleanup_lbd_bound = 59 [default = 5];</code>
   * @return Whether the clauseCleanupLbdBound field is set.
   */
  boolean hasClauseCleanupLbdBound();
  /**
   * <pre>
   * All the clauses with a LBD (literal blocks distance) lower or equal to this
   * parameters will always be kept.
   * </pre>
   *
   * <code>optional int32 clause_cleanup_lbd_bound = 59 [default = 5];</code>
   * @return The clauseCleanupLbdBound.
   */
  int getClauseCleanupLbdBound();

  /**
   * <code>optional .operations_research.sat.SatParameters.ClauseOrdering clause_cleanup_ordering = 60 [default = CLAUSE_ACTIVITY];</code>
   * @return Whether the clauseCleanupOrdering field is set.
   */
  boolean hasClauseCleanupOrdering();
  /**
   * <code>optional .operations_research.sat.SatParameters.ClauseOrdering clause_cleanup_ordering = 60 [default = CLAUSE_ACTIVITY];</code>
   * @return The clauseCleanupOrdering.
   */
  com.google.ortools.sat.SatParameters.ClauseOrdering getClauseCleanupOrdering();

  /**
   * <pre>
   * Same as for the clauses, but for the learned pseudo-Boolean constraints.
   * </pre>
   *
   * <code>optional int32 pb_cleanup_increment = 46 [default = 200];</code>
   * @return Whether the pbCleanupIncrement field is set.
   */
  boolean hasPbCleanupIncrement();
  /**
   * <pre>
   * Same as for the clauses, but for the learned pseudo-Boolean constraints.
   * </pre>
   *
   * <code>optional int32 pb_cleanup_increment = 46 [default = 200];</code>
   * @return The pbCleanupIncrement.
   */
  int getPbCleanupIncrement();

  /**
   * <code>optional double pb_cleanup_ratio = 47 [default = 0.5];</code>
   * @return Whether the pbCleanupRatio field is set.
   */
  boolean hasPbCleanupRatio();
  /**
   * <code>optional double pb_cleanup_ratio = 47 [default = 0.5];</code>
   * @return The pbCleanupRatio.
   */
  double getPbCleanupRatio();

  /**
   * <pre>
   * Parameters for an heuristic similar to the one descibed in "An effective
   * learnt clause minimization approach for CDCL Sat Solvers",
   * https://www.ijcai.org/proceedings/2017/0098.pdf
   * For now, we have a somewhat simpler implementation where every x restart we
   * spend y decisions on clause minimization. The minimization technique is the
   * same as the one used to minimize core in max-sat. We also minimize problem
   * clauses and not just the learned clause that we keep forever like in the
   * paper.
   * Changing these parameters or the kind of clause we minimize seems to have
   * a big impact on the overall perf on our benchmarks. So this technique seems
   * definitely useful, but it is hard to tune properly.
   * </pre>
   *
   * <code>optional int32 minimize_with_propagation_restart_period = 96 [default = 10];</code>
   * @return Whether the minimizeWithPropagationRestartPeriod field is set.
   */
  boolean hasMinimizeWithPropagationRestartPeriod();
  /**
   * <pre>
   * Parameters for an heuristic similar to the one descibed in "An effective
   * learnt clause minimization approach for CDCL Sat Solvers",
   * https://www.ijcai.org/proceedings/2017/0098.pdf
   * For now, we have a somewhat simpler implementation where every x restart we
   * spend y decisions on clause minimization. The minimization technique is the
   * same as the one used to minimize core in max-sat. We also minimize problem
   * clauses and not just the learned clause that we keep forever like in the
   * paper.
   * Changing these parameters or the kind of clause we minimize seems to have
   * a big impact on the overall perf on our benchmarks. So this technique seems
   * definitely useful, but it is hard to tune properly.
   * </pre>
   *
   * <code>optional int32 minimize_with_propagation_restart_period = 96 [default = 10];</code>
   * @return The minimizeWithPropagationRestartPeriod.
   */
  int getMinimizeWithPropagationRestartPeriod();

  /**
   * <code>optional int32 minimize_with_propagation_num_decisions = 97 [default = 1000];</code>
   * @return Whether the minimizeWithPropagationNumDecisions field is set.
   */
  boolean hasMinimizeWithPropagationNumDecisions();
  /**
   * <code>optional int32 minimize_with_propagation_num_decisions = 97 [default = 1000];</code>
   * @return The minimizeWithPropagationNumDecisions.
   */
  int getMinimizeWithPropagationNumDecisions();

  /**
   * <pre>
   * Each time a conflict is found, the activities of some variables are
   * increased by one. Then, the activity of all variables are multiplied by
   * variable_activity_decay.
   * To implement this efficiently, the activity of all the variables is not
   * decayed at each conflict. Instead, the activity increment is multiplied by
   * 1 / decay. When an activity reach max_variable_activity_value, all the
   * activity are multiplied by 1 / max_variable_activity_value.
   * </pre>
   *
   * <code>optional double variable_activity_decay = 15 [default = 0.8];</code>
   * @return Whether the variableActivityDecay field is set.
   */
  boolean hasVariableActivityDecay();
  /**
   * <pre>
   * Each time a conflict is found, the activities of some variables are
   * increased by one. Then, the activity of all variables are multiplied by
   * variable_activity_decay.
   * To implement this efficiently, the activity of all the variables is not
   * decayed at each conflict. Instead, the activity increment is multiplied by
   * 1 / decay. When an activity reach max_variable_activity_value, all the
   * activity are multiplied by 1 / max_variable_activity_value.
   * </pre>
   *
   * <code>optional double variable_activity_decay = 15 [default = 0.8];</code>
   * @return The variableActivityDecay.
   */
  double getVariableActivityDecay();

  /**
   * <code>optional double max_variable_activity_value = 16 [default = 1e+100];</code>
   * @return Whether the maxVariableActivityValue field is set.
   */
  boolean hasMaxVariableActivityValue();
  /**
   * <code>optional double max_variable_activity_value = 16 [default = 1e+100];</code>
   * @return The maxVariableActivityValue.
   */
  double getMaxVariableActivityValue();

  /**
   * <pre>
   * The activity starts at 0.8 and increment by 0.01 every 5000 conflicts until
   * 0.95. This "hack" seems to work well and comes from:
   * Glucose 2.3 in the SAT 2013 Competition - SAT Competition 2013
   * http://edacc4.informatik.uni-ulm.de/SC13/solver-description-download/136
   * </pre>
   *
   * <code>optional double glucose_max_decay = 22 [default = 0.95];</code>
   * @return Whether the glucoseMaxDecay field is set.
   */
  boolean hasGlucoseMaxDecay();
  /**
   * <pre>
   * The activity starts at 0.8 and increment by 0.01 every 5000 conflicts until
   * 0.95. This "hack" seems to work well and comes from:
   * Glucose 2.3 in the SAT 2013 Competition - SAT Competition 2013
   * http://edacc4.informatik.uni-ulm.de/SC13/solver-description-download/136
   * </pre>
   *
   * <code>optional double glucose_max_decay = 22 [default = 0.95];</code>
   * @return The glucoseMaxDecay.
   */
  double getGlucoseMaxDecay();

  /**
   * <code>optional double glucose_decay_increment = 23 [default = 0.01];</code>
   * @return Whether the glucoseDecayIncrement field is set.
   */
  boolean hasGlucoseDecayIncrement();
  /**
   * <code>optional double glucose_decay_increment = 23 [default = 0.01];</code>
   * @return The glucoseDecayIncrement.
   */
  double getGlucoseDecayIncrement();

  /**
   * <code>optional int32 glucose_decay_increment_period = 24 [default = 5000];</code>
   * @return Whether the glucoseDecayIncrementPeriod field is set.
   */
  boolean hasGlucoseDecayIncrementPeriod();
  /**
   * <code>optional int32 glucose_decay_increment_period = 24 [default = 5000];</code>
   * @return The glucoseDecayIncrementPeriod.
   */
  int getGlucoseDecayIncrementPeriod();

  /**
   * <pre>
   * Clause activity parameters (same effect as the one on the variables).
   * </pre>
   *
   * <code>optional double clause_activity_decay = 17 [default = 0.999];</code>
   * @return Whether the clauseActivityDecay field is set.
   */
  boolean hasClauseActivityDecay();
  /**
   * <pre>
   * Clause activity parameters (same effect as the one on the variables).
   * </pre>
   *
   * <code>optional double clause_activity_decay = 17 [default = 0.999];</code>
   * @return The clauseActivityDecay.
   */
  double getClauseActivityDecay();

  /**
   * <code>optional double max_clause_activity_value = 18 [default = 1e+20];</code>
   * @return Whether the maxClauseActivityValue field is set.
   */
  boolean hasMaxClauseActivityValue();
  /**
   * <code>optional double max_clause_activity_value = 18 [default = 1e+20];</code>
   * @return The maxClauseActivityValue.
   */
  double getMaxClauseActivityValue();

  /**
   * <pre>
   * The restart strategies will change each time the strategy_counter is
   * increased. The current strategy will simply be the one at index
   * strategy_counter modulo the number of strategy. Note that if this list
   * includes a NO_RESTART, nothing will change when it is reached because the
   * strategy_counter will only increment after a restart.
   * The idea of switching of search strategy tailored for SAT/UNSAT comes from
   * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
   * But more generally, it seems REALLY beneficial to try different strategy.
   * </pre>
   *
   * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
   * @return A list containing the restartAlgorithms.
   */
  java.util.List<com.google.ortools.sat.SatParameters.RestartAlgorithm> getRestartAlgorithmsList();
  /**
   * <pre>
   * The restart strategies will change each time the strategy_counter is
   * increased. The current strategy will simply be the one at index
   * strategy_counter modulo the number of strategy. Note that if this list
   * includes a NO_RESTART, nothing will change when it is reached because the
   * strategy_counter will only increment after a restart.
   * The idea of switching of search strategy tailored for SAT/UNSAT comes from
   * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
   * But more generally, it seems REALLY beneficial to try different strategy.
   * </pre>
   *
   * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
   * @return The count of restartAlgorithms.
   */
  int getRestartAlgorithmsCount();
  /**
   * <pre>
   * The restart strategies will change each time the strategy_counter is
   * increased. The current strategy will simply be the one at index
   * strategy_counter modulo the number of strategy. Note that if this list
   * includes a NO_RESTART, nothing will change when it is reached because the
   * strategy_counter will only increment after a restart.
   * The idea of switching of search strategy tailored for SAT/UNSAT comes from
   * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
   * But more generally, it seems REALLY beneficial to try different strategy.
   * </pre>
   *
   * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
   * @param index The index of the element to return.
   * @return The restartAlgorithms at the given index.
   */
  com.google.ortools.sat.SatParameters.RestartAlgorithm getRestartAlgorithms(int index);

  /**
   * <code>optional string default_restart_algorithms = 70 [default = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART"];</code>
   * @return Whether the defaultRestartAlgorithms field is set.
   */
  boolean hasDefaultRestartAlgorithms();
  /**
   * <code>optional string default_restart_algorithms = 70 [default = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART"];</code>
   * @return The defaultRestartAlgorithms.
   */
  java.lang.String getDefaultRestartAlgorithms();
  /**
   * <code>optional string default_restart_algorithms = 70 [default = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART"];</code>
   * @return The bytes for defaultRestartAlgorithms.
   */
  com.google.protobuf.ByteString
      getDefaultRestartAlgorithmsBytes();

  /**
   * <pre>
   * Restart period for the FIXED_RESTART strategy. This is also the multiplier
   * used by the LUBY_RESTART strategy.
   * </pre>
   *
   * <code>optional int32 restart_period = 30 [default = 50];</code>
   * @return Whether the restartPeriod field is set.
   */
  boolean hasRestartPeriod();
  /**
   * <pre>
   * Restart period for the FIXED_RESTART strategy. This is also the multiplier
   * used by the LUBY_RESTART strategy.
   * </pre>
   *
   * <code>optional int32 restart_period = 30 [default = 50];</code>
   * @return The restartPeriod.
   */
  int getRestartPeriod();

  /**
   * <pre>
   * Size of the window for the moving average restarts.
   * </pre>
   *
   * <code>optional int32 restart_running_window_size = 62 [default = 50];</code>
   * @return Whether the restartRunningWindowSize field is set.
   */
  boolean hasRestartRunningWindowSize();
  /**
   * <pre>
   * Size of the window for the moving average restarts.
   * </pre>
   *
   * <code>optional int32 restart_running_window_size = 62 [default = 50];</code>
   * @return The restartRunningWindowSize.
   */
  int getRestartRunningWindowSize();

  /**
   * <pre>
   * In the moving average restart algorithms, a restart is triggered if the
   * window average times this ratio is greater that the global average.
   * </pre>
   *
   * <code>optional double restart_dl_average_ratio = 63 [default = 1];</code>
   * @return Whether the restartDlAverageRatio field is set.
   */
  boolean hasRestartDlAverageRatio();
  /**
   * <pre>
   * In the moving average restart algorithms, a restart is triggered if the
   * window average times this ratio is greater that the global average.
   * </pre>
   *
   * <code>optional double restart_dl_average_ratio = 63 [default = 1];</code>
   * @return The restartDlAverageRatio.
   */
  double getRestartDlAverageRatio();

  /**
   * <code>optional double restart_lbd_average_ratio = 71 [default = 1];</code>
   * @return Whether the restartLbdAverageRatio field is set.
   */
  boolean hasRestartLbdAverageRatio();
  /**
   * <code>optional double restart_lbd_average_ratio = 71 [default = 1];</code>
   * @return The restartLbdAverageRatio.
   */
  double getRestartLbdAverageRatio();

  /**
   * <pre>
   * Block a moving restart algorithm if the trail size of the current conflict
   * is greater than the multiplier times the moving average of the trail size
   * at the previous conflicts.
   * </pre>
   *
   * <code>optional bool use_blocking_restart = 64 [default = false];</code>
   * @return Whether the useBlockingRestart field is set.
   */
  boolean hasUseBlockingRestart();
  /**
   * <pre>
   * Block a moving restart algorithm if the trail size of the current conflict
   * is greater than the multiplier times the moving average of the trail size
   * at the previous conflicts.
   * </pre>
   *
   * <code>optional bool use_blocking_restart = 64 [default = false];</code>
   * @return The useBlockingRestart.
   */
  boolean getUseBlockingRestart();

  /**
   * <code>optional int32 blocking_restart_window_size = 65 [default = 5000];</code>
   * @return Whether the blockingRestartWindowSize field is set.
   */
  boolean hasBlockingRestartWindowSize();
  /**
   * <code>optional int32 blocking_restart_window_size = 65 [default = 5000];</code>
   * @return The blockingRestartWindowSize.
   */
  int getBlockingRestartWindowSize();

  /**
   * <code>optional double blocking_restart_multiplier = 66 [default = 1.4];</code>
   * @return Whether the blockingRestartMultiplier field is set.
   */
  boolean hasBlockingRestartMultiplier();
  /**
   * <code>optional double blocking_restart_multiplier = 66 [default = 1.4];</code>
   * @return The blockingRestartMultiplier.
   */
  double getBlockingRestartMultiplier();

  /**
   * <pre>
   * After each restart, if the number of conflict since the last strategy
   * change is greater that this, then we increment a "strategy_counter" that
   * can be use to change the search strategy used by the following restarts.
   * </pre>
   *
   * <code>optional int32 num_conflicts_before_strategy_changes = 68 [default = 0];</code>
   * @return Whether the numConflictsBeforeStrategyChanges field is set.
   */
  boolean hasNumConflictsBeforeStrategyChanges();
  /**
   * <pre>
   * After each restart, if the number of conflict since the last strategy
   * change is greater that this, then we increment a "strategy_counter" that
   * can be use to change the search strategy used by the following restarts.
   * </pre>
   *
   * <code>optional int32 num_conflicts_before_strategy_changes = 68 [default = 0];</code>
   * @return The numConflictsBeforeStrategyChanges.
   */
  int getNumConflictsBeforeStrategyChanges();

  /**
   * <pre>
   * The parameter num_conflicts_before_strategy_changes is increased by that
   * much after each strategy change.
   * </pre>
   *
   * <code>optional double strategy_change_increase_ratio = 69 [default = 0];</code>
   * @return Whether the strategyChangeIncreaseRatio field is set.
   */
  boolean hasStrategyChangeIncreaseRatio();
  /**
   * <pre>
   * The parameter num_conflicts_before_strategy_changes is increased by that
   * much after each strategy change.
   * </pre>
   *
   * <code>optional double strategy_change_increase_ratio = 69 [default = 0];</code>
   * @return The strategyChangeIncreaseRatio.
   */
  double getStrategyChangeIncreaseRatio();

  /**
   * <pre>
   * Maximum time allowed in seconds to solve a problem.
   * The counter will starts at the beginning of the Solve() call.
   * </pre>
   *
   * <code>optional double max_time_in_seconds = 36 [default = inf];</code>
   * @return Whether the maxTimeInSeconds field is set.
   */
  boolean hasMaxTimeInSeconds();
  /**
   * <pre>
   * Maximum time allowed in seconds to solve a problem.
   * The counter will starts at the beginning of the Solve() call.
   * </pre>
   *
   * <code>optional double max_time_in_seconds = 36 [default = inf];</code>
   * @return The maxTimeInSeconds.
   */
  double getMaxTimeInSeconds();

  /**
   * <pre>
   * Maximum time allowed in deterministic time to solve a problem.
   * The deterministic time should be correlated with the real time used by the
   * solver, the time unit being as close as possible to a second.
   * </pre>
   *
   * <code>optional double max_deterministic_time = 67 [default = inf];</code>
   * @return Whether the maxDeterministicTime field is set.
   */
  boolean hasMaxDeterministicTime();
  /**
   * <pre>
   * Maximum time allowed in deterministic time to solve a problem.
   * The deterministic time should be correlated with the real time used by the
   * solver, the time unit being as close as possible to a second.
   * </pre>
   *
   * <code>optional double max_deterministic_time = 67 [default = inf];</code>
   * @return The maxDeterministicTime.
   */
  double getMaxDeterministicTime();

  /**
   * <pre>
   * Maximum number of conflicts allowed to solve a problem.
   * TODO(user,user): Maybe change the way the conflict limit is enforced?
   * currently it is enforced on each independent internal SAT solve, rather
   * than on the overall number of conflicts across all solves. So in the
   * context of an optimization problem, this is not really usable directly by a
   * client.
   * </pre>
   *
   * <code>optional int64 max_number_of_conflicts = 37 [default = 9223372036854775807];</code>
   * @return Whether the maxNumberOfConflicts field is set.
   */
  boolean hasMaxNumberOfConflicts();
  /**
   * <pre>
   * Maximum number of conflicts allowed to solve a problem.
   * TODO(user,user): Maybe change the way the conflict limit is enforced?
   * currently it is enforced on each independent internal SAT solve, rather
   * than on the overall number of conflicts across all solves. So in the
   * context of an optimization problem, this is not really usable directly by a
   * client.
   * </pre>
   *
   * <code>optional int64 max_number_of_conflicts = 37 [default = 9223372036854775807];</code>
   * @return The maxNumberOfConflicts.
   */
  long getMaxNumberOfConflicts();

  /**
   * <pre>
   * Maximum memory allowed for the whole thread containing the solver. The
   * solver will abort as soon as it detects that this limit is crossed. As a
   * result, this limit is approximative, but usually the solver will not go too
   * much over.
   * </pre>
   *
   * <code>optional int64 max_memory_in_mb = 40 [default = 10000];</code>
   * @return Whether the maxMemoryInMb field is set.
   */
  boolean hasMaxMemoryInMb();
  /**
   * <pre>
   * Maximum memory allowed for the whole thread containing the solver. The
   * solver will abort as soon as it detects that this limit is crossed. As a
   * result, this limit is approximative, but usually the solver will not go too
   * much over.
   * </pre>
   *
   * <code>optional int64 max_memory_in_mb = 40 [default = 10000];</code>
   * @return The maxMemoryInMb.
   */
  long getMaxMemoryInMb();

  /**
   * <pre>
   * Stop the search when the gap between the best feasible objective (O) and
   * our best objective bound (B) is smaller than a limit.
   * The exact definition is:
   * - Absolute: abs(O - B)
   * - Relative: abs(O - B) / max(1, abs(O)).
   * Important: The relative gap depends on the objective offset! If you
   * artificially shift the objective, you will get widely different value of
   * the relative gap.
   * Note that if the gap is reached, the search status will be OPTIMAL. But
   * one can check the best objective bound to see the actual gap.
   * </pre>
   *
   * <code>optional double absolute_gap_limit = 159 [default = 0];</code>
   * @return Whether the absoluteGapLimit field is set.
   */
  boolean hasAbsoluteGapLimit();
  /**
   * <pre>
   * Stop the search when the gap between the best feasible objective (O) and
   * our best objective bound (B) is smaller than a limit.
   * The exact definition is:
   * - Absolute: abs(O - B)
   * - Relative: abs(O - B) / max(1, abs(O)).
   * Important: The relative gap depends on the objective offset! If you
   * artificially shift the objective, you will get widely different value of
   * the relative gap.
   * Note that if the gap is reached, the search status will be OPTIMAL. But
   * one can check the best objective bound to see the actual gap.
   * </pre>
   *
   * <code>optional double absolute_gap_limit = 159 [default = 0];</code>
   * @return The absoluteGapLimit.
   */
  double getAbsoluteGapLimit();

  /**
   * <code>optional double relative_gap_limit = 160 [default = 0];</code>
   * @return Whether the relativeGapLimit field is set.
   */
  boolean hasRelativeGapLimit();
  /**
   * <code>optional double relative_gap_limit = 160 [default = 0];</code>
   * @return The relativeGapLimit.
   */
  double getRelativeGapLimit();

  /**
   * <pre>
   * If true, the binary clauses are treated separately from the others. This
   * should be faster and uses less memory. However it changes the propagation
   * order.
   * </pre>
   *
   * <code>optional bool treat_binary_clauses_separately = 33 [default = true];</code>
   * @return Whether the treatBinaryClausesSeparately field is set.
   */
  boolean hasTreatBinaryClausesSeparately();
  /**
   * <pre>
   * If true, the binary clauses are treated separately from the others. This
   * should be faster and uses less memory. However it changes the propagation
   * order.
   * </pre>
   *
   * <code>optional bool treat_binary_clauses_separately = 33 [default = true];</code>
   * @return The treatBinaryClausesSeparately.
   */
  boolean getTreatBinaryClausesSeparately();

  /**
   * <pre>
   * At the beginning of each solve, the random number generator used in some
   * part of the solver is reinitialized to this seed. If you change the random
   * seed, the solver may make different choices during the solving process.
   * For some problems, the running time may vary a lot depending on small
   * change in the solving algorithm. Running the solver with different seeds
   * enables to have more robust benchmarks when evaluating new features.
   * </pre>
   *
   * <code>optional int32 random_seed = 31 [default = 1];</code>
   * @return Whether the randomSeed field is set.
   */
  boolean hasRandomSeed();
  /**
   * <pre>
   * At the beginning of each solve, the random number generator used in some
   * part of the solver is reinitialized to this seed. If you change the random
   * seed, the solver may make different choices during the solving process.
   * For some problems, the running time may vary a lot depending on small
   * change in the solving algorithm. Running the solver with different seeds
   * enables to have more robust benchmarks when evaluating new features.
   * </pre>
   *
   * <code>optional int32 random_seed = 31 [default = 1];</code>
   * @return The randomSeed.
   */
  int getRandomSeed();

  /**
   * <pre>
   * This is mainly here to test the solver variability. Note that in tests, if
   * not explicitly set to false, all 3 options will be set to true so that
   * clients do not rely on the solver returning a specific solution if they are
   * many equivalent optimal solutions.
   * </pre>
   *
   * <code>optional bool permute_variable_randomly = 178 [default = false];</code>
   * @return Whether the permuteVariableRandomly field is set.
   */
  boolean hasPermuteVariableRandomly();
  /**
   * <pre>
   * This is mainly here to test the solver variability. Note that in tests, if
   * not explicitly set to false, all 3 options will be set to true so that
   * clients do not rely on the solver returning a specific solution if they are
   * many equivalent optimal solutions.
   * </pre>
   *
   * <code>optional bool permute_variable_randomly = 178 [default = false];</code>
   * @return The permuteVariableRandomly.
   */
  boolean getPermuteVariableRandomly();

  /**
   * <code>optional bool permute_presolve_constraint_order = 179 [default = false];</code>
   * @return Whether the permutePresolveConstraintOrder field is set.
   */
  boolean hasPermutePresolveConstraintOrder();
  /**
   * <code>optional bool permute_presolve_constraint_order = 179 [default = false];</code>
   * @return The permutePresolveConstraintOrder.
   */
  boolean getPermutePresolveConstraintOrder();

  /**
   * <code>optional bool use_absl_random = 180 [default = false];</code>
   * @return Whether the useAbslRandom field is set.
   */
  boolean hasUseAbslRandom();
  /**
   * <code>optional bool use_absl_random = 180 [default = false];</code>
   * @return The useAbslRandom.
   */
  boolean getUseAbslRandom();

  /**
   * <pre>
   * Whether the solver should log the search progress. By default, it logs to
   * LOG(INFO). This can be overwritten by the log_destination parameter.
   * </pre>
   *
   * <code>optional bool log_search_progress = 41 [default = false];</code>
   * @return Whether the logSearchProgress field is set.
   */
  boolean hasLogSearchProgress();
  /**
   * <pre>
   * Whether the solver should log the search progress. By default, it logs to
   * LOG(INFO). This can be overwritten by the log_destination parameter.
   * </pre>
   *
   * <code>optional bool log_search_progress = 41 [default = false];</code>
   * @return The logSearchProgress.
   */
  boolean getLogSearchProgress();

  /**
   * <pre>
   * Whether the solver should display per sub-solver search statistics.
   * This is only useful is log_search_progress is set to true, and if the
   * number of search workers is &gt; 1.
   * </pre>
   *
   * <code>optional bool log_subsolver_statistics = 189 [default = true];</code>
   * @return Whether the logSubsolverStatistics field is set.
   */
  boolean hasLogSubsolverStatistics();
  /**
   * <pre>
   * Whether the solver should display per sub-solver search statistics.
   * This is only useful is log_search_progress is set to true, and if the
   * number of search workers is &gt; 1.
   * </pre>
   *
   * <code>optional bool log_subsolver_statistics = 189 [default = true];</code>
   * @return The logSubsolverStatistics.
   */
  boolean getLogSubsolverStatistics();

  /**
   * <pre>
   * Add a prefix to all logs.
   * </pre>
   *
   * <code>optional string log_prefix = 185 [default = ""];</code>
   * @return Whether the logPrefix field is set.
   */
  boolean hasLogPrefix();
  /**
   * <pre>
   * Add a prefix to all logs.
   * </pre>
   *
   * <code>optional string log_prefix = 185 [default = ""];</code>
   * @return The logPrefix.
   */
  java.lang.String getLogPrefix();
  /**
   * <pre>
   * Add a prefix to all logs.
   * </pre>
   *
   * <code>optional string log_prefix = 185 [default = ""];</code>
   * @return The bytes for logPrefix.
   */
  com.google.protobuf.ByteString
      getLogPrefixBytes();

  /**
   * <pre>
   * Log to stdout.
   * </pre>
   *
   * <code>optional bool log_to_stdout = 186 [default = true];</code>
   * @return Whether the logToStdout field is set.
   */
  boolean hasLogToStdout();
  /**
   * <pre>
   * Log to stdout.
   * </pre>
   *
   * <code>optional bool log_to_stdout = 186 [default = true];</code>
   * @return The logToStdout.
   */
  boolean getLogToStdout();

  /**
   * <pre>
   * Log to response proto.
   * </pre>
   *
   * <code>optional bool log_to_response = 187 [default = false];</code>
   * @return Whether the logToResponse field is set.
   */
  boolean hasLogToResponse();
  /**
   * <pre>
   * Log to response proto.
   * </pre>
   *
   * <code>optional bool log_to_response = 187 [default = false];</code>
   * @return The logToResponse.
   */
  boolean getLogToResponse();

  /**
   * <pre>
   * Whether to use pseudo-Boolean resolution to analyze a conflict. Note that
   * this option only make sense if your problem is modelized using
   * pseudo-Boolean constraints. If you only have clauses, this shouldn't change
   * anything (except slow the solver down).
   * </pre>
   *
   * <code>optional bool use_pb_resolution = 43 [default = false];</code>
   * @return Whether the usePbResolution field is set.
   */
  boolean hasUsePbResolution();
  /**
   * <pre>
   * Whether to use pseudo-Boolean resolution to analyze a conflict. Note that
   * this option only make sense if your problem is modelized using
   * pseudo-Boolean constraints. If you only have clauses, this shouldn't change
   * anything (except slow the solver down).
   * </pre>
   *
   * <code>optional bool use_pb_resolution = 43 [default = false];</code>
   * @return The usePbResolution.
   */
  boolean getUsePbResolution();

  /**
   * <pre>
   * A different algorithm during PB resolution. It minimizes the number of
   * calls to ReduceCoefficients() which can be time consuming. However, the
   * search space will be different and if the coefficients are large, this may
   * lead to integer overflows that could otherwise be prevented.
   * </pre>
   *
   * <code>optional bool minimize_reduction_during_pb_resolution = 48 [default = false];</code>
   * @return Whether the minimizeReductionDuringPbResolution field is set.
   */
  boolean hasMinimizeReductionDuringPbResolution();
  /**
   * <pre>
   * A different algorithm during PB resolution. It minimizes the number of
   * calls to ReduceCoefficients() which can be time consuming. However, the
   * search space will be different and if the coefficients are large, this may
   * lead to integer overflows that could otherwise be prevented.
   * </pre>
   *
   * <code>optional bool minimize_reduction_during_pb_resolution = 48 [default = false];</code>
   * @return The minimizeReductionDuringPbResolution.
   */
  boolean getMinimizeReductionDuringPbResolution();

  /**
   * <pre>
   * Whether or not the assumption levels are taken into account during the LBD
   * computation. According to the reference below, not counting them improves
   * the solver in some situation. Note that this only impact solves under
   * assumptions.
   * Gilles Audemard, Jean-Marie Lagniez, Laurent Simon, "Improving Glucose for
   * Incremental SAT Solving with Assumptions: Application to MUS Extraction"
   * Theory and Applications of Satisfiability Testing - SAT 2013, Lecture Notes
   * in Computer Science Volume 7962, 2013, pp 309-317.
   * </pre>
   *
   * <code>optional bool count_assumption_levels_in_lbd = 49 [default = true];</code>
   * @return Whether the countAssumptionLevelsInLbd field is set.
   */
  boolean hasCountAssumptionLevelsInLbd();
  /**
   * <pre>
   * Whether or not the assumption levels are taken into account during the LBD
   * computation. According to the reference below, not counting them improves
   * the solver in some situation. Note that this only impact solves under
   * assumptions.
   * Gilles Audemard, Jean-Marie Lagniez, Laurent Simon, "Improving Glucose for
   * Incremental SAT Solving with Assumptions: Application to MUS Extraction"
   * Theory and Applications of Satisfiability Testing - SAT 2013, Lecture Notes
   * in Computer Science Volume 7962, 2013, pp 309-317.
   * </pre>
   *
   * <code>optional bool count_assumption_levels_in_lbd = 49 [default = true];</code>
   * @return The countAssumptionLevelsInLbd.
   */
  boolean getCountAssumptionLevelsInLbd();

  /**
   * <pre>
   * During presolve, only try to perform the bounded variable elimination (BVE)
   * of a variable x if the number of occurrences of x times the number of
   * occurrences of not(x) is not greater than this parameter.
   * </pre>
   *
   * <code>optional int32 presolve_bve_threshold = 54 [default = 500];</code>
   * @return Whether the presolveBveThreshold field is set.
   */
  boolean hasPresolveBveThreshold();
  /**
   * <pre>
   * During presolve, only try to perform the bounded variable elimination (BVE)
   * of a variable x if the number of occurrences of x times the number of
   * occurrences of not(x) is not greater than this parameter.
   * </pre>
   *
   * <code>optional int32 presolve_bve_threshold = 54 [default = 500];</code>
   * @return The presolveBveThreshold.
   */
  int getPresolveBveThreshold();

  /**
   * <pre>
   * During presolve, we apply BVE only if this weight times the number of
   * clauses plus the number of clause literals is not increased.
   * </pre>
   *
   * <code>optional int32 presolve_bve_clause_weight = 55 [default = 3];</code>
   * @return Whether the presolveBveClauseWeight field is set.
   */
  boolean hasPresolveBveClauseWeight();
  /**
   * <pre>
   * During presolve, we apply BVE only if this weight times the number of
   * clauses plus the number of clause literals is not increased.
   * </pre>
   *
   * <code>optional int32 presolve_bve_clause_weight = 55 [default = 3];</code>
   * @return The presolveBveClauseWeight.
   */
  int getPresolveBveClauseWeight();

  /**
   * <pre>
   * The maximum "deterministic" time limit to spend in probing. A value of
   * zero will disable the probing.
   * </pre>
   *
   * <code>optional double presolve_probing_deterministic_time_limit = 57 [default = 30];</code>
   * @return Whether the presolveProbingDeterministicTimeLimit field is set.
   */
  boolean hasPresolveProbingDeterministicTimeLimit();
  /**
   * <pre>
   * The maximum "deterministic" time limit to spend in probing. A value of
   * zero will disable the probing.
   * </pre>
   *
   * <code>optional double presolve_probing_deterministic_time_limit = 57 [default = 30];</code>
   * @return The presolveProbingDeterministicTimeLimit.
   */
  double getPresolveProbingDeterministicTimeLimit();

  /**
   * <pre>
   * Whether we use an heuristic to detect some basic case of blocked clause
   * in the SAT presolve.
   * </pre>
   *
   * <code>optional bool presolve_blocked_clause = 88 [default = true];</code>
   * @return Whether the presolveBlockedClause field is set.
   */
  boolean hasPresolveBlockedClause();
  /**
   * <pre>
   * Whether we use an heuristic to detect some basic case of blocked clause
   * in the SAT presolve.
   * </pre>
   *
   * <code>optional bool presolve_blocked_clause = 88 [default = true];</code>
   * @return The presolveBlockedClause.
   */
  boolean getPresolveBlockedClause();

  /**
   * <pre>
   * Whether or not we use Bounded Variable Addition (BVA) in the presolve.
   * </pre>
   *
   * <code>optional bool presolve_use_bva = 72 [default = true];</code>
   * @return Whether the presolveUseBva field is set.
   */
  boolean hasPresolveUseBva();
  /**
   * <pre>
   * Whether or not we use Bounded Variable Addition (BVA) in the presolve.
   * </pre>
   *
   * <code>optional bool presolve_use_bva = 72 [default = true];</code>
   * @return The presolveUseBva.
   */
  boolean getPresolveUseBva();

  /**
   * <pre>
   * Apply Bounded Variable Addition (BVA) if the number of clauses is reduced
   * by stricly more than this threshold. The algorithm described in the paper
   * uses 0, but quick experiments showed that 1 is a good value. It may not be
   * worth it to add a new variable just to remove one clause.
   * </pre>
   *
   * <code>optional int32 presolve_bva_threshold = 73 [default = 1];</code>
   * @return Whether the presolveBvaThreshold field is set.
   */
  boolean hasPresolveBvaThreshold();
  /**
   * <pre>
   * Apply Bounded Variable Addition (BVA) if the number of clauses is reduced
   * by stricly more than this threshold. The algorithm described in the paper
   * uses 0, but quick experiments showed that 1 is a good value. It may not be
   * worth it to add a new variable just to remove one clause.
   * </pre>
   *
   * <code>optional int32 presolve_bva_threshold = 73 [default = 1];</code>
   * @return The presolveBvaThreshold.
   */
  int getPresolveBvaThreshold();

  /**
   * <pre>
   * In case of large reduction in a presolve iteration, we perform multiple
   * presolve iterations. This parameter controls the maximum number of such
   * presolve iterations.
   * </pre>
   *
   * <code>optional int32 max_presolve_iterations = 138 [default = 3];</code>
   * @return Whether the maxPresolveIterations field is set.
   */
  boolean hasMaxPresolveIterations();
  /**
   * <pre>
   * In case of large reduction in a presolve iteration, we perform multiple
   * presolve iterations. This parameter controls the maximum number of such
   * presolve iterations.
   * </pre>
   *
   * <code>optional int32 max_presolve_iterations = 138 [default = 3];</code>
   * @return The maxPresolveIterations.
   */
  int getMaxPresolveIterations();

  /**
   * <pre>
   * Whether we presolve the cp_model before solving it.
   * </pre>
   *
   * <code>optional bool cp_model_presolve = 86 [default = true];</code>
   * @return Whether the cpModelPresolve field is set.
   */
  boolean hasCpModelPresolve();
  /**
   * <pre>
   * Whether we presolve the cp_model before solving it.
   * </pre>
   *
   * <code>optional bool cp_model_presolve = 86 [default = true];</code>
   * @return The cpModelPresolve.
   */
  boolean getCpModelPresolve();

  /**
   * <pre>
   * Advanced usage. We have two different postsolve code. The default one
   * should be better and it allows for a more powerful presolve, but some
   * rarely used features like not fully assigning all variables require the
   * other one.
   * </pre>
   *
   * <code>optional bool cp_model_postsolve_with_full_solver = 162 [default = false];</code>
   * @return Whether the cpModelPostsolveWithFullSolver field is set.
   */
  boolean hasCpModelPostsolveWithFullSolver();
  /**
   * <pre>
   * Advanced usage. We have two different postsolve code. The default one
   * should be better and it allows for a more powerful presolve, but some
   * rarely used features like not fully assigning all variables require the
   * other one.
   * </pre>
   *
   * <code>optional bool cp_model_postsolve_with_full_solver = 162 [default = false];</code>
   * @return The cpModelPostsolveWithFullSolver.
   */
  boolean getCpModelPostsolveWithFullSolver();

  /**
   * <pre>
   * If positive, try to stop just after that many presolve rules have been
   * applied. This is mainly useful for debugging presolve.
   * </pre>
   *
   * <code>optional int32 cp_model_max_num_presolve_operations = 151 [default = 0];</code>
   * @return Whether the cpModelMaxNumPresolveOperations field is set.
   */
  boolean hasCpModelMaxNumPresolveOperations();
  /**
   * <pre>
   * If positive, try to stop just after that many presolve rules have been
   * applied. This is mainly useful for debugging presolve.
   * </pre>
   *
   * <code>optional int32 cp_model_max_num_presolve_operations = 151 [default = 0];</code>
   * @return The cpModelMaxNumPresolveOperations.
   */
  int getCpModelMaxNumPresolveOperations();

  /**
   * <pre>
   * How much effort do we spend on probing. 0 disables it completely.
   * </pre>
   *
   * <code>optional int32 cp_model_probing_level = 110 [default = 2];</code>
   * @return Whether the cpModelProbingLevel field is set.
   */
  boolean hasCpModelProbingLevel();
  /**
   * <pre>
   * How much effort do we spend on probing. 0 disables it completely.
   * </pre>
   *
   * <code>optional int32 cp_model_probing_level = 110 [default = 2];</code>
   * @return The cpModelProbingLevel.
   */
  int getCpModelProbingLevel();

  /**
   * <pre>
   * Whether we also use the sat presolve when cp_model_presolve is true.
   * </pre>
   *
   * <code>optional bool cp_model_use_sat_presolve = 93 [default = true];</code>
   * @return Whether the cpModelUseSatPresolve field is set.
   */
  boolean hasCpModelUseSatPresolve();
  /**
   * <pre>
   * Whether we also use the sat presolve when cp_model_presolve is true.
   * </pre>
   *
   * <code>optional bool cp_model_use_sat_presolve = 93 [default = true];</code>
   * @return The cpModelUseSatPresolve.
   */
  boolean getCpModelUseSatPresolve();

  /**
   * <code>optional bool use_sat_inprocessing = 163 [default = false];</code>
   * @return Whether the useSatInprocessing field is set.
   */
  boolean hasUseSatInprocessing();
  /**
   * <code>optional bool use_sat_inprocessing = 163 [default = false];</code>
   * @return The useSatInprocessing.
   */
  boolean getUseSatInprocessing();

  /**
   * <pre>
   * If true, the element constraints are expanded into many
   * linear constraints of the form (index == i) =&gt; (element[i] == target).
   * </pre>
   *
   * <code>optional bool expand_element_constraints = 140 [default = true];</code>
   * @return Whether the expandElementConstraints field is set.
   */
  boolean hasExpandElementConstraints();
  /**
   * <pre>
   * If true, the element constraints are expanded into many
   * linear constraints of the form (index == i) =&gt; (element[i] == target).
   * </pre>
   *
   * <code>optional bool expand_element_constraints = 140 [default = true];</code>
   * @return The expandElementConstraints.
   */
  boolean getExpandElementConstraints();

  /**
   * <pre>
   * If true, the automaton constraints are expanded.
   * </pre>
   *
   * <code>optional bool expand_automaton_constraints = 143 [default = true];</code>
   * @return Whether the expandAutomatonConstraints field is set.
   */
  boolean hasExpandAutomatonConstraints();
  /**
   * <pre>
   * If true, the automaton constraints are expanded.
   * </pre>
   *
   * <code>optional bool expand_automaton_constraints = 143 [default = true];</code>
   * @return The expandAutomatonConstraints.
   */
  boolean getExpandAutomatonConstraints();

  /**
   * <pre>
   * If true, the positive table constraints are expanded.
   * Note that currently, negative table constraints are always expanded.
   * </pre>
   *
   * <code>optional bool expand_table_constraints = 158 [default = true];</code>
   * @return Whether the expandTableConstraints field is set.
   */
  boolean hasExpandTableConstraints();
  /**
   * <pre>
   * If true, the positive table constraints are expanded.
   * Note that currently, negative table constraints are always expanded.
   * </pre>
   *
   * <code>optional bool expand_table_constraints = 158 [default = true];</code>
   * @return The expandTableConstraints.
   */
  boolean getExpandTableConstraints();

  /**
   * <pre>
   * If true, expand all_different constraints that are not permutations.
   * Permutations (#Variables = #Values) are always expanded.
   * </pre>
   *
   * <code>optional bool expand_alldiff_constraints = 170 [default = false];</code>
   * @return Whether the expandAlldiffConstraints field is set.
   */
  boolean hasExpandAlldiffConstraints();
  /**
   * <pre>
   * If true, expand all_different constraints that are not permutations.
   * Permutations (#Variables = #Values) are always expanded.
   * </pre>
   *
   * <code>optional bool expand_alldiff_constraints = 170 [default = false];</code>
   * @return The expandAlldiffConstraints.
   */
  boolean getExpandAlldiffConstraints();

  /**
   * <pre>
   * If true, expand the reservoir constraints by creating booleans for all
   * possible precedences between event and encoding the constraint.
   * </pre>
   *
   * <code>optional bool expand_reservoir_constraints = 182 [default = true];</code>
   * @return Whether the expandReservoirConstraints field is set.
   */
  boolean hasExpandReservoirConstraints();
  /**
   * <pre>
   * If true, expand the reservoir constraints by creating booleans for all
   * possible precedences between event and encoding the constraint.
   * </pre>
   *
   * <code>optional bool expand_reservoir_constraints = 182 [default = true];</code>
   * @return The expandReservoirConstraints.
   */
  boolean getExpandReservoirConstraints();

  /**
   * <pre>
   * If true, it disable all constraint expansion.
   * This should only be used to test the presolve of expanded constraints.
   * </pre>
   *
   * <code>optional bool disable_constraint_expansion = 181 [default = false];</code>
   * @return Whether the disableConstraintExpansion field is set.
   */
  boolean hasDisableConstraintExpansion();
  /**
   * <pre>
   * If true, it disable all constraint expansion.
   * This should only be used to test the presolve of expanded constraints.
   * </pre>
   *
   * <code>optional bool disable_constraint_expansion = 181 [default = false];</code>
   * @return The disableConstraintExpansion.
   */
  boolean getDisableConstraintExpansion();

  /**
   * <pre>
   * During presolve, we use a maximum clique heuristic to merge together
   * no-overlap constraints or at most one constraints. This code can be slow,
   * so we have a limit in place on the number of explored nodes in the
   * underlying graph. The internal limit is an int64, but we use double here to
   * simplify manual input.
   * </pre>
   *
   * <code>optional double merge_no_overlap_work_limit = 145 [default = 1000000000000];</code>
   * @return Whether the mergeNoOverlapWorkLimit field is set.
   */
  boolean hasMergeNoOverlapWorkLimit();
  /**
   * <pre>
   * During presolve, we use a maximum clique heuristic to merge together
   * no-overlap constraints or at most one constraints. This code can be slow,
   * so we have a limit in place on the number of explored nodes in the
   * underlying graph. The internal limit is an int64, but we use double here to
   * simplify manual input.
   * </pre>
   *
   * <code>optional double merge_no_overlap_work_limit = 145 [default = 1000000000000];</code>
   * @return The mergeNoOverlapWorkLimit.
   */
  double getMergeNoOverlapWorkLimit();

  /**
   * <code>optional double merge_at_most_one_work_limit = 146 [default = 100000000];</code>
   * @return Whether the mergeAtMostOneWorkLimit field is set.
   */
  boolean hasMergeAtMostOneWorkLimit();
  /**
   * <code>optional double merge_at_most_one_work_limit = 146 [default = 100000000];</code>
   * @return The mergeAtMostOneWorkLimit.
   */
  double getMergeAtMostOneWorkLimit();

  /**
   * <pre>
   * How much substitution (also called free variable aggregation in MIP
   * litterature) should we perform at presolve. This currently only concerns
   * variable appearing only in linear constraints. For now the value 0 turns it
   * off and any positive value performs substitution.
   * </pre>
   *
   * <code>optional int32 presolve_substitution_level = 147 [default = 1];</code>
   * @return Whether the presolveSubstitutionLevel field is set.
   */
  boolean hasPresolveSubstitutionLevel();
  /**
   * <pre>
   * How much substitution (also called free variable aggregation in MIP
   * litterature) should we perform at presolve. This currently only concerns
   * variable appearing only in linear constraints. For now the value 0 turns it
   * off and any positive value performs substitution.
   * </pre>
   *
   * <code>optional int32 presolve_substitution_level = 147 [default = 1];</code>
   * @return The presolveSubstitutionLevel.
   */
  int getPresolveSubstitutionLevel();

  /**
   * <pre>
   * If true, we will extract from linear constraints, enforcement literals of
   * the form "integer variable at bound =&gt; simplified constraint". This should
   * always be beneficial except that we don't always handle them as efficiently
   * as we could for now. This causes problem on manna81.mps (LP relaxation not
   * as tight it seems) and on neos-3354841-apure.mps.gz (too many literals
   * created this way).
   * </pre>
   *
   * <code>optional bool presolve_extract_integer_enforcement = 174 [default = false];</code>
   * @return Whether the presolveExtractIntegerEnforcement field is set.
   */
  boolean hasPresolveExtractIntegerEnforcement();
  /**
   * <pre>
   * If true, we will extract from linear constraints, enforcement literals of
   * the form "integer variable at bound =&gt; simplified constraint". This should
   * always be beneficial except that we don't always handle them as efficiently
   * as we could for now. This causes problem on manna81.mps (LP relaxation not
   * as tight it seems) and on neos-3354841-apure.mps.gz (too many literals
   * created this way).
   * </pre>
   *
   * <code>optional bool presolve_extract_integer_enforcement = 174 [default = false];</code>
   * @return The presolveExtractIntegerEnforcement.
   */
  boolean getPresolveExtractIntegerEnforcement();

  /**
   * <pre>
   * For an optimization problem, whether we follow some hints in order to find
   * a better first solution. For a variable with hint, the solver will always
   * try to follow the hint. It will revert to the variable_branching default
   * otherwise.
   * </pre>
   *
   * <code>optional bool use_optimization_hints = 35 [default = true];</code>
   * @return Whether the useOptimizationHints field is set.
   */
  boolean hasUseOptimizationHints();
  /**
   * <pre>
   * For an optimization problem, whether we follow some hints in order to find
   * a better first solution. For a variable with hint, the solver will always
   * try to follow the hint. It will revert to the variable_branching default
   * otherwise.
   * </pre>
   *
   * <code>optional bool use_optimization_hints = 35 [default = true];</code>
   * @return The useOptimizationHints.
   */
  boolean getUseOptimizationHints();

  /**
   * <pre>
   * Whether we use a simple heuristic to try to minimize an UNSAT core.
   * </pre>
   *
   * <code>optional bool minimize_core = 50 [default = true];</code>
   * @return Whether the minimizeCore field is set.
   */
  boolean hasMinimizeCore();
  /**
   * <pre>
   * Whether we use a simple heuristic to try to minimize an UNSAT core.
   * </pre>
   *
   * <code>optional bool minimize_core = 50 [default = true];</code>
   * @return The minimizeCore.
   */
  boolean getMinimizeCore();

  /**
   * <pre>
   * Whether we try to find more independent cores for a given set of
   * assumptions in the core based max-SAT algorithms.
   * </pre>
   *
   * <code>optional bool find_multiple_cores = 84 [default = true];</code>
   * @return Whether the findMultipleCores field is set.
   */
  boolean hasFindMultipleCores();
  /**
   * <pre>
   * Whether we try to find more independent cores for a given set of
   * assumptions in the core based max-SAT algorithms.
   * </pre>
   *
   * <code>optional bool find_multiple_cores = 84 [default = true];</code>
   * @return The findMultipleCores.
   */
  boolean getFindMultipleCores();

  /**
   * <pre>
   * If true, when the max-sat algo find a core, we compute the minimal number
   * of literals in the core that needs to be true to have a feasible solution.
   * </pre>
   *
   * <code>optional bool cover_optimization = 89 [default = true];</code>
   * @return Whether the coverOptimization field is set.
   */
  boolean hasCoverOptimization();
  /**
   * <pre>
   * If true, when the max-sat algo find a core, we compute the minimal number
   * of literals in the core that needs to be true to have a feasible solution.
   * </pre>
   *
   * <code>optional bool cover_optimization = 89 [default = true];</code>
   * @return The coverOptimization.
   */
  boolean getCoverOptimization();

  /**
   * <code>optional .operations_research.sat.SatParameters.MaxSatAssumptionOrder max_sat_assumption_order = 51 [default = DEFAULT_ASSUMPTION_ORDER];</code>
   * @return Whether the maxSatAssumptionOrder field is set.
   */
  boolean hasMaxSatAssumptionOrder();
  /**
   * <code>optional .operations_research.sat.SatParameters.MaxSatAssumptionOrder max_sat_assumption_order = 51 [default = DEFAULT_ASSUMPTION_ORDER];</code>
   * @return The maxSatAssumptionOrder.
   */
  com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder getMaxSatAssumptionOrder();

  /**
   * <pre>
   * If true, adds the assumption in the reverse order of the one defined by
   * max_sat_assumption_order.
   * </pre>
   *
   * <code>optional bool max_sat_reverse_assumption_order = 52 [default = false];</code>
   * @return Whether the maxSatReverseAssumptionOrder field is set.
   */
  boolean hasMaxSatReverseAssumptionOrder();
  /**
   * <pre>
   * If true, adds the assumption in the reverse order of the one defined by
   * max_sat_assumption_order.
   * </pre>
   *
   * <code>optional bool max_sat_reverse_assumption_order = 52 [default = false];</code>
   * @return The maxSatReverseAssumptionOrder.
   */
  boolean getMaxSatReverseAssumptionOrder();

  /**
   * <code>optional .operations_research.sat.SatParameters.MaxSatStratificationAlgorithm max_sat_stratification = 53 [default = STRATIFICATION_DESCENT];</code>
   * @return Whether the maxSatStratification field is set.
   */
  boolean hasMaxSatStratification();
  /**
   * <code>optional .operations_research.sat.SatParameters.MaxSatStratificationAlgorithm max_sat_stratification = 53 [default = STRATIFICATION_DESCENT];</code>
   * @return The maxSatStratification.
   */
  com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm getMaxSatStratification();

  /**
   * <pre>
   * When this is true, then a disjunctive constraint will try to use the
   * precedence relations between time intervals to propagate their bounds
   * further. For instance if task A and B are both before C and task A and B
   * are in disjunction, then we can deduce that task C must start after
   * duration(A) + duration(B) instead of simply max(duration(A), duration(B)),
   * provided that the start time for all task was currently zero.
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_precedences_in_disjunctive_constraint = 74 [default = true];</code>
   * @return Whether the usePrecedencesInDisjunctiveConstraint field is set.
   */
  boolean hasUsePrecedencesInDisjunctiveConstraint();
  /**
   * <pre>
   * When this is true, then a disjunctive constraint will try to use the
   * precedence relations between time intervals to propagate their bounds
   * further. For instance if task A and B are both before C and task A and B
   * are in disjunction, then we can deduce that task C must start after
   * duration(A) + duration(B) instead of simply max(duration(A), duration(B)),
   * provided that the start time for all task was currently zero.
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_precedences_in_disjunctive_constraint = 74 [default = true];</code>
   * @return The usePrecedencesInDisjunctiveConstraint.
   */
  boolean getUsePrecedencesInDisjunctiveConstraint();

  /**
   * <pre>
   * When this is true, the cumulative constraint is reinforced with overload
   * checking, i.e., an additional level of reasoning based on energy. This
   * additional level supplements the default level of reasoning as well as
   * timetable edge finding.
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_overload_checker_in_cumulative_constraint = 78 [default = false];</code>
   * @return Whether the useOverloadCheckerInCumulativeConstraint field is set.
   */
  boolean hasUseOverloadCheckerInCumulativeConstraint();
  /**
   * <pre>
   * When this is true, the cumulative constraint is reinforced with overload
   * checking, i.e., an additional level of reasoning based on energy. This
   * additional level supplements the default level of reasoning as well as
   * timetable edge finding.
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_overload_checker_in_cumulative_constraint = 78 [default = false];</code>
   * @return The useOverloadCheckerInCumulativeConstraint.
   */
  boolean getUseOverloadCheckerInCumulativeConstraint();

  /**
   * <pre>
   * When this is true, the cumulative constraint is reinforced with timetable
   * edge finding, i.e., an additional level of reasoning based on the
   * conjunction of energy and mandatory parts. This additional level
   * supplements the default level of reasoning as well as overload_checker.
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_timetable_edge_finding_in_cumulative_constraint = 79 [default = false];</code>
   * @return Whether the useTimetableEdgeFindingInCumulativeConstraint field is set.
   */
  boolean hasUseTimetableEdgeFindingInCumulativeConstraint();
  /**
   * <pre>
   * When this is true, the cumulative constraint is reinforced with timetable
   * edge finding, i.e., an additional level of reasoning based on the
   * conjunction of energy and mandatory parts. This additional level
   * supplements the default level of reasoning as well as overload_checker.
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_timetable_edge_finding_in_cumulative_constraint = 79 [default = false];</code>
   * @return The useTimetableEdgeFindingInCumulativeConstraint.
   */
  boolean getUseTimetableEdgeFindingInCumulativeConstraint();

  /**
   * <pre>
   * When this is true, the cumulative constraint is reinforced with propagators
   * from the disjunctive constraint to improve the inference on a set of tasks
   * that are disjunctive at the root of the problem. This additional level
   * supplements the default level of reasoning.
   * Propagators of the cumulative constraint will not be used at all if all the
   * tasks are disjunctive at root node.
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_disjunctive_constraint_in_cumulative_constraint = 80 [default = true];</code>
   * @return Whether the useDisjunctiveConstraintInCumulativeConstraint field is set.
   */
  boolean hasUseDisjunctiveConstraintInCumulativeConstraint();
  /**
   * <pre>
   * When this is true, the cumulative constraint is reinforced with propagators
   * from the disjunctive constraint to improve the inference on a set of tasks
   * that are disjunctive at the root of the problem. This additional level
   * supplements the default level of reasoning.
   * Propagators of the cumulative constraint will not be used at all if all the
   * tasks are disjunctive at root node.
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_disjunctive_constraint_in_cumulative_constraint = 80 [default = true];</code>
   * @return The useDisjunctiveConstraintInCumulativeConstraint.
   */
  boolean getUseDisjunctiveConstraintInCumulativeConstraint();

  /**
   * <pre>
   * A non-negative level indicating the type of constraints we consider in the
   * LP relaxation. At level zero, no LP relaxation is used. At level 1, only
   * the linear constraint and full encoding are added. At level 2, we also add
   * all the Boolean constraints.
   * </pre>
   *
   * <code>optional int32 linearization_level = 90 [default = 1];</code>
   * @return Whether the linearizationLevel field is set.
   */
  boolean hasLinearizationLevel();
  /**
   * <pre>
   * A non-negative level indicating the type of constraints we consider in the
   * LP relaxation. At level zero, no LP relaxation is used. At level 1, only
   * the linear constraint and full encoding are added. At level 2, we also add
   * all the Boolean constraints.
   * </pre>
   *
   * <code>optional int32 linearization_level = 90 [default = 1];</code>
   * @return The linearizationLevel.
   */
  int getLinearizationLevel();

  /**
   * <pre>
   * A non-negative level indicating how much we should try to fully encode
   * Integer variables as Boolean.
   * </pre>
   *
   * <code>optional int32 boolean_encoding_level = 107 [default = 1];</code>
   * @return Whether the booleanEncodingLevel field is set.
   */
  boolean hasBooleanEncodingLevel();
  /**
   * <pre>
   * A non-negative level indicating how much we should try to fully encode
   * Integer variables as Boolean.
   * </pre>
   *
   * <code>optional int32 boolean_encoding_level = 107 [default = 1];</code>
   * @return The booleanEncodingLevel.
   */
  int getBooleanEncodingLevel();

  /**
   * <pre>
   * When loading a*x + b*y ==/!= c when x and y are both fully encoded.
   * The solver may decide to replace the linear equation by a set of clauses.
   * This is triggered if the sizes of the domains of x and y are below the
   * threshold.
   * </pre>
   *
   * <code>optional int32 max_domain_size_when_encoding_eq_neq_constraints = 191 [default = 16];</code>
   * @return Whether the maxDomainSizeWhenEncodingEqNeqConstraints field is set.
   */
  boolean hasMaxDomainSizeWhenEncodingEqNeqConstraints();
  /**
   * <pre>
   * When loading a*x + b*y ==/!= c when x and y are both fully encoded.
   * The solver may decide to replace the linear equation by a set of clauses.
   * This is triggered if the sizes of the domains of x and y are below the
   * threshold.
   * </pre>
   *
   * <code>optional int32 max_domain_size_when_encoding_eq_neq_constraints = 191 [default = 16];</code>
   * @return The maxDomainSizeWhenEncodingEqNeqConstraints.
   */
  int getMaxDomainSizeWhenEncodingEqNeqConstraints();

  /**
   * <pre>
   * The limit on the number of cuts in our cut pool. When this is reached we do
   * not generate cuts anymore.
   * TODO(user): We should probably remove this parameters, and just always
   * generate cuts but only keep the best n or something.
   * </pre>
   *
   * <code>optional int32 max_num_cuts = 91 [default = 10000];</code>
   * @return Whether the maxNumCuts field is set.
   */
  boolean hasMaxNumCuts();
  /**
   * <pre>
   * The limit on the number of cuts in our cut pool. When this is reached we do
   * not generate cuts anymore.
   * TODO(user): We should probably remove this parameters, and just always
   * generate cuts but only keep the best n or something.
   * </pre>
   *
   * <code>optional int32 max_num_cuts = 91 [default = 10000];</code>
   * @return The maxNumCuts.
   */
  int getMaxNumCuts();

  /**
   * <pre>
   * For the cut that can be generated at any level, this control if we only
   * try to generate them at the root node.
   * </pre>
   *
   * <code>optional bool only_add_cuts_at_level_zero = 92 [default = false];</code>
   * @return Whether the onlyAddCutsAtLevelZero field is set.
   */
  boolean hasOnlyAddCutsAtLevelZero();
  /**
   * <pre>
   * For the cut that can be generated at any level, this control if we only
   * try to generate them at the root node.
   * </pre>
   *
   * <code>optional bool only_add_cuts_at_level_zero = 92 [default = false];</code>
   * @return The onlyAddCutsAtLevelZero.
   */
  boolean getOnlyAddCutsAtLevelZero();

  /**
   * <pre>
   * Whether we generate knapsack cuts. Note that in our setting where all
   * variables are integer and bounded on both side, such a cut could be applied
   * to any constraint.
   * </pre>
   *
   * <code>optional bool add_knapsack_cuts = 111 [default = false];</code>
   * @return Whether the addKnapsackCuts field is set.
   */
  boolean hasAddKnapsackCuts();
  /**
   * <pre>
   * Whether we generate knapsack cuts. Note that in our setting where all
   * variables are integer and bounded on both side, such a cut could be applied
   * to any constraint.
   * </pre>
   *
   * <code>optional bool add_knapsack_cuts = 111 [default = false];</code>
   * @return The addKnapsackCuts.
   */
  boolean getAddKnapsackCuts();

  /**
   * <pre>
   * Whether we generate and add Chvatal-Gomory cuts to the LP at root node.
   * Note that for now, this is not heavily tuned.
   * </pre>
   *
   * <code>optional bool add_cg_cuts = 117 [default = true];</code>
   * @return Whether the addCgCuts field is set.
   */
  boolean hasAddCgCuts();
  /**
   * <pre>
   * Whether we generate and add Chvatal-Gomory cuts to the LP at root node.
   * Note that for now, this is not heavily tuned.
   * </pre>
   *
   * <code>optional bool add_cg_cuts = 117 [default = true];</code>
   * @return The addCgCuts.
   */
  boolean getAddCgCuts();

  /**
   * <pre>
   * Whether we generate MIR cuts at root node.
   * Note that for now, this is not heavily tuned.
   * </pre>
   *
   * <code>optional bool add_mir_cuts = 120 [default = true];</code>
   * @return Whether the addMirCuts field is set.
   */
  boolean hasAddMirCuts();
  /**
   * <pre>
   * Whether we generate MIR cuts at root node.
   * Note that for now, this is not heavily tuned.
   * </pre>
   *
   * <code>optional bool add_mir_cuts = 120 [default = true];</code>
   * @return The addMirCuts.
   */
  boolean getAddMirCuts();

  /**
   * <pre>
   * Whether we generate Zero-Half cuts at root node.
   * Note that for now, this is not heavily tuned.
   * </pre>
   *
   * <code>optional bool add_zero_half_cuts = 169 [default = true];</code>
   * @return Whether the addZeroHalfCuts field is set.
   */
  boolean hasAddZeroHalfCuts();
  /**
   * <pre>
   * Whether we generate Zero-Half cuts at root node.
   * Note that for now, this is not heavily tuned.
   * </pre>
   *
   * <code>optional bool add_zero_half_cuts = 169 [default = true];</code>
   * @return The addZeroHalfCuts.
   */
  boolean getAddZeroHalfCuts();

  /**
   * <pre>
   * Whether we generate clique cuts from the binary implication graph. Note
   * that as the search goes on, this graph will contains new binary clauses
   * learned by the SAT engine.
   * </pre>
   *
   * <code>optional bool add_clique_cuts = 172 [default = true];</code>
   * @return Whether the addCliqueCuts field is set.
   */
  boolean hasAddCliqueCuts();
  /**
   * <pre>
   * Whether we generate clique cuts from the binary implication graph. Note
   * that as the search goes on, this graph will contains new binary clauses
   * learned by the SAT engine.
   * </pre>
   *
   * <code>optional bool add_clique_cuts = 172 [default = true];</code>
   * @return The addCliqueCuts.
   */
  boolean getAddCliqueCuts();

  /**
   * <pre>
   * Cut generator for all diffs can add too many cuts for large all_diff
   * constraints. This parameter restricts the large all_diff constraints to
   * have a cut generator.
   * </pre>
   *
   * <code>optional int32 max_all_diff_cut_size = 148 [default = 7];</code>
   * @return Whether the maxAllDiffCutSize field is set.
   */
  boolean hasMaxAllDiffCutSize();
  /**
   * <pre>
   * Cut generator for all diffs can add too many cuts for large all_diff
   * constraints. This parameter restricts the large all_diff constraints to
   * have a cut generator.
   * </pre>
   *
   * <code>optional int32 max_all_diff_cut_size = 148 [default = 7];</code>
   * @return The maxAllDiffCutSize.
   */
  int getMaxAllDiffCutSize();

  /**
   * <pre>
   * For the lin max constraints, generates the cuts described in "Strong
   * mixed-integer programming formulations for trained neural networks" by Ross
   * Anderson et. (https://arxiv.org/pdf/1811.01988.pdf)
   * </pre>
   *
   * <code>optional bool add_lin_max_cuts = 152 [default = true];</code>
   * @return Whether the addLinMaxCuts field is set.
   */
  boolean hasAddLinMaxCuts();
  /**
   * <pre>
   * For the lin max constraints, generates the cuts described in "Strong
   * mixed-integer programming formulations for trained neural networks" by Ross
   * Anderson et. (https://arxiv.org/pdf/1811.01988.pdf)
   * </pre>
   *
   * <code>optional bool add_lin_max_cuts = 152 [default = true];</code>
   * @return The addLinMaxCuts.
   */
  boolean getAddLinMaxCuts();

  /**
   * <pre>
   * In the integer rounding procedure used for MIR and Gomory cut, the maximum
   * "scaling" we use (must be positive). The lower this is, the lower the
   * integer coefficients of the cut will be. Note that cut generated by lower
   * values are not necessarily worse than cut generated by larger value. There
   * is no strict dominance relationship.
   * Setting this to 2 result in the "strong fractional rouding" of Letchford
   * and Lodi.
   * </pre>
   *
   * <code>optional int32 max_integer_rounding_scaling = 119 [default = 600];</code>
   * @return Whether the maxIntegerRoundingScaling field is set.
   */
  boolean hasMaxIntegerRoundingScaling();
  /**
   * <pre>
   * In the integer rounding procedure used for MIR and Gomory cut, the maximum
   * "scaling" we use (must be positive). The lower this is, the lower the
   * integer coefficients of the cut will be. Note that cut generated by lower
   * values are not necessarily worse than cut generated by larger value. There
   * is no strict dominance relationship.
   * Setting this to 2 result in the "strong fractional rouding" of Letchford
   * and Lodi.
   * </pre>
   *
   * <code>optional int32 max_integer_rounding_scaling = 119 [default = 600];</code>
   * @return The maxIntegerRoundingScaling.
   */
  int getMaxIntegerRoundingScaling();

  /**
   * <pre>
   * If true, we start by an empty LP, and only add constraints not satisfied
   * by the current LP solution batch by batch. A constraint that is only added
   * like this is known as a "lazy" constraint in the literature, except that we
   * currently consider all constraints as lazy here.
   * </pre>
   *
   * <code>optional bool add_lp_constraints_lazily = 112 [default = true];</code>
   * @return Whether the addLpConstraintsLazily field is set.
   */
  boolean hasAddLpConstraintsLazily();
  /**
   * <pre>
   * If true, we start by an empty LP, and only add constraints not satisfied
   * by the current LP solution batch by batch. A constraint that is only added
   * like this is known as a "lazy" constraint in the literature, except that we
   * currently consider all constraints as lazy here.
   * </pre>
   *
   * <code>optional bool add_lp_constraints_lazily = 112 [default = true];</code>
   * @return The addLpConstraintsLazily.
   */
  boolean getAddLpConstraintsLazily();

  /**
   * <pre>
   * While adding constraints, skip the constraints which have orthogonality
   * less than 'min_orthogonality_for_lp_constraints' with already added
   * constraints during current call. Orthogonality is defined as 1 -
   * cosine(vector angle between constraints). A value of zero disable this
   * feature.
   * </pre>
   *
   * <code>optional double min_orthogonality_for_lp_constraints = 115 [default = 0.05];</code>
   * @return Whether the minOrthogonalityForLpConstraints field is set.
   */
  boolean hasMinOrthogonalityForLpConstraints();
  /**
   * <pre>
   * While adding constraints, skip the constraints which have orthogonality
   * less than 'min_orthogonality_for_lp_constraints' with already added
   * constraints during current call. Orthogonality is defined as 1 -
   * cosine(vector angle between constraints). A value of zero disable this
   * feature.
   * </pre>
   *
   * <code>optional double min_orthogonality_for_lp_constraints = 115 [default = 0.05];</code>
   * @return The minOrthogonalityForLpConstraints.
   */
  double getMinOrthogonalityForLpConstraints();

  /**
   * <pre>
   * Max number of time we perform cut generation and resolve the LP at level 0.
   * </pre>
   *
   * <code>optional int32 max_cut_rounds_at_level_zero = 154 [default = 1];</code>
   * @return Whether the maxCutRoundsAtLevelZero field is set.
   */
  boolean hasMaxCutRoundsAtLevelZero();
  /**
   * <pre>
   * Max number of time we perform cut generation and resolve the LP at level 0.
   * </pre>
   *
   * <code>optional int32 max_cut_rounds_at_level_zero = 154 [default = 1];</code>
   * @return The maxCutRoundsAtLevelZero.
   */
  int getMaxCutRoundsAtLevelZero();

  /**
   * <pre>
   * If a constraint/cut in LP is not active for that many consecutive OPTIMAL
   * solves, remove it from the LP. Note that it might be added again later if
   * it become violated by the current LP solution.
   * </pre>
   *
   * <code>optional int32 max_consecutive_inactive_count = 121 [default = 100];</code>
   * @return Whether the maxConsecutiveInactiveCount field is set.
   */
  boolean hasMaxConsecutiveInactiveCount();
  /**
   * <pre>
   * If a constraint/cut in LP is not active for that many consecutive OPTIMAL
   * solves, remove it from the LP. Note that it might be added again later if
   * it become violated by the current LP solution.
   * </pre>
   *
   * <code>optional int32 max_consecutive_inactive_count = 121 [default = 100];</code>
   * @return The maxConsecutiveInactiveCount.
   */
  int getMaxConsecutiveInactiveCount();

  /**
   * <pre>
   * These parameters are similar to sat clause management activity parameters.
   * They are effective only if the number of generated cuts exceed the storage
   * limit. Default values are based on a few experiments on miplib instances.
   * </pre>
   *
   * <code>optional double cut_max_active_count_value = 155 [default = 10000000000];</code>
   * @return Whether the cutMaxActiveCountValue field is set.
   */
  boolean hasCutMaxActiveCountValue();
  /**
   * <pre>
   * These parameters are similar to sat clause management activity parameters.
   * They are effective only if the number of generated cuts exceed the storage
   * limit. Default values are based on a few experiments on miplib instances.
   * </pre>
   *
   * <code>optional double cut_max_active_count_value = 155 [default = 10000000000];</code>
   * @return The cutMaxActiveCountValue.
   */
  double getCutMaxActiveCountValue();

  /**
   * <code>optional double cut_active_count_decay = 156 [default = 0.8];</code>
   * @return Whether the cutActiveCountDecay field is set.
   */
  boolean hasCutActiveCountDecay();
  /**
   * <code>optional double cut_active_count_decay = 156 [default = 0.8];</code>
   * @return The cutActiveCountDecay.
   */
  double getCutActiveCountDecay();

  /**
   * <pre>
   * Target number of constraints to remove during cleanup.
   * </pre>
   *
   * <code>optional int32 cut_cleanup_target = 157 [default = 1000];</code>
   * @return Whether the cutCleanupTarget field is set.
   */
  boolean hasCutCleanupTarget();
  /**
   * <pre>
   * Target number of constraints to remove during cleanup.
   * </pre>
   *
   * <code>optional int32 cut_cleanup_target = 157 [default = 1000];</code>
   * @return The cutCleanupTarget.
   */
  int getCutCleanupTarget();

  /**
   * <pre>
   * Add that many lazy constraints (or cuts) at once in the LP. Note that at
   * the beginning of the solve, we do add more than this.
   * </pre>
   *
   * <code>optional int32 new_constraints_batch_size = 122 [default = 50];</code>
   * @return Whether the newConstraintsBatchSize field is set.
   */
  boolean hasNewConstraintsBatchSize();
  /**
   * <pre>
   * Add that many lazy constraints (or cuts) at once in the LP. Note that at
   * the beginning of the solve, we do add more than this.
   * </pre>
   *
   * <code>optional int32 new_constraints_batch_size = 122 [default = 50];</code>
   * @return The newConstraintsBatchSize.
   */
  int getNewConstraintsBatchSize();

  /**
   * <code>optional .operations_research.sat.SatParameters.SearchBranching search_branching = 82 [default = AUTOMATIC_SEARCH];</code>
   * @return Whether the searchBranching field is set.
   */
  boolean hasSearchBranching();
  /**
   * <code>optional .operations_research.sat.SatParameters.SearchBranching search_branching = 82 [default = AUTOMATIC_SEARCH];</code>
   * @return The searchBranching.
   */
  com.google.ortools.sat.SatParameters.SearchBranching getSearchBranching();

  /**
   * <pre>
   * Conflict limit used in the phase that exploit the solution hint.
   * </pre>
   *
   * <code>optional int32 hint_conflict_limit = 153 [default = 10];</code>
   * @return Whether the hintConflictLimit field is set.
   */
  boolean hasHintConflictLimit();
  /**
   * <pre>
   * Conflict limit used in the phase that exploit the solution hint.
   * </pre>
   *
   * <code>optional int32 hint_conflict_limit = 153 [default = 10];</code>
   * @return The hintConflictLimit.
   */
  int getHintConflictLimit();

  /**
   * <pre>
   * If true, the solver tries to repair the solution given in the hint. This
   * search terminates after the 'hint_conflict_limit' is reached and the solver
   * switches to regular search. If false, then  we do a FIXED_SEARCH using the
   * hint until the hint_conflict_limit is reached.
   * </pre>
   *
   * <code>optional bool repair_hint = 167 [default = false];</code>
   * @return Whether the repairHint field is set.
   */
  boolean hasRepairHint();
  /**
   * <pre>
   * If true, the solver tries to repair the solution given in the hint. This
   * search terminates after the 'hint_conflict_limit' is reached and the solver
   * switches to regular search. If false, then  we do a FIXED_SEARCH using the
   * hint until the hint_conflict_limit is reached.
   * </pre>
   *
   * <code>optional bool repair_hint = 167 [default = false];</code>
   * @return The repairHint.
   */
  boolean getRepairHint();

  /**
   * <pre>
   * If true, variables appearing in the solution hints will be fixed to their
   * hinted value.
   * </pre>
   *
   * <code>optional bool fix_variables_to_their_hinted_value = 192 [default = false];</code>
   * @return Whether the fixVariablesToTheirHintedValue field is set.
   */
  boolean hasFixVariablesToTheirHintedValue();
  /**
   * <pre>
   * If true, variables appearing in the solution hints will be fixed to their
   * hinted value.
   * </pre>
   *
   * <code>optional bool fix_variables_to_their_hinted_value = 192 [default = false];</code>
   * @return The fixVariablesToTheirHintedValue.
   */
  boolean getFixVariablesToTheirHintedValue();

  /**
   * <pre>
   * If true and the Lp relaxation of the problem has an integer optimal
   * solution, try to exploit it. Note that since the LP relaxation may not
   * contain all the constraints, such a solution is not necessarily a solution
   * of the full problem.
   * </pre>
   *
   * <code>optional bool exploit_integer_lp_solution = 94 [default = true];</code>
   * @return Whether the exploitIntegerLpSolution field is set.
   */
  boolean hasExploitIntegerLpSolution();
  /**
   * <pre>
   * If true and the Lp relaxation of the problem has an integer optimal
   * solution, try to exploit it. Note that since the LP relaxation may not
   * contain all the constraints, such a solution is not necessarily a solution
   * of the full problem.
   * </pre>
   *
   * <code>optional bool exploit_integer_lp_solution = 94 [default = true];</code>
   * @return The exploitIntegerLpSolution.
   */
  boolean getExploitIntegerLpSolution();

  /**
   * <pre>
   * If true and the Lp relaxation of the problem has a solution, try to exploit
   * it. This is same as above except in this case the lp solution might not be
   * an integer solution.
   * </pre>
   *
   * <code>optional bool exploit_all_lp_solution = 116 [default = true];</code>
   * @return Whether the exploitAllLpSolution field is set.
   */
  boolean hasExploitAllLpSolution();
  /**
   * <pre>
   * If true and the Lp relaxation of the problem has a solution, try to exploit
   * it. This is same as above except in this case the lp solution might not be
   * an integer solution.
   * </pre>
   *
   * <code>optional bool exploit_all_lp_solution = 116 [default = true];</code>
   * @return The exploitAllLpSolution.
   */
  boolean getExploitAllLpSolution();

  /**
   * <pre>
   * When branching on a variable, follow the last best solution value.
   * </pre>
   *
   * <code>optional bool exploit_best_solution = 130 [default = false];</code>
   * @return Whether the exploitBestSolution field is set.
   */
  boolean hasExploitBestSolution();
  /**
   * <pre>
   * When branching on a variable, follow the last best solution value.
   * </pre>
   *
   * <code>optional bool exploit_best_solution = 130 [default = false];</code>
   * @return The exploitBestSolution.
   */
  boolean getExploitBestSolution();

  /**
   * <pre>
   * When branching on a variable, follow the last best relaxation solution
   * value. We use the relaxation with the tightest bound on the objective as
   * the best relaxation solution.
   * </pre>
   *
   * <code>optional bool exploit_relaxation_solution = 161 [default = false];</code>
   * @return Whether the exploitRelaxationSolution field is set.
   */
  boolean hasExploitRelaxationSolution();
  /**
   * <pre>
   * When branching on a variable, follow the last best relaxation solution
   * value. We use the relaxation with the tightest bound on the objective as
   * the best relaxation solution.
   * </pre>
   *
   * <code>optional bool exploit_relaxation_solution = 161 [default = false];</code>
   * @return The exploitRelaxationSolution.
   */
  boolean getExploitRelaxationSolution();

  /**
   * <pre>
   * When branching an a variable that directly affect the objective,
   * branch on the value that lead to the best objective first.
   * </pre>
   *
   * <code>optional bool exploit_objective = 131 [default = true];</code>
   * @return Whether the exploitObjective field is set.
   */
  boolean hasExploitObjective();
  /**
   * <pre>
   * When branching an a variable that directly affect the objective,
   * branch on the value that lead to the best objective first.
   * </pre>
   *
   * <code>optional bool exploit_objective = 131 [default = true];</code>
   * @return The exploitObjective.
   */
  boolean getExploitObjective();

  /**
   * <pre>
   * If set at zero (the default), it is disabled. Otherwise the solver attempts
   * probing at every 'probing_period' root node. Period of 1 enables probing at
   * every root node.
   * </pre>
   *
   * <code>optional int64 probing_period_at_root = 142 [default = 0];</code>
   * @return Whether the probingPeriodAtRoot field is set.
   */
  boolean hasProbingPeriodAtRoot();
  /**
   * <pre>
   * If set at zero (the default), it is disabled. Otherwise the solver attempts
   * probing at every 'probing_period' root node. Period of 1 enables probing at
   * every root node.
   * </pre>
   *
   * <code>optional int64 probing_period_at_root = 142 [default = 0];</code>
   * @return The probingPeriodAtRoot.
   */
  long getProbingPeriodAtRoot();

  /**
   * <pre>
   * If true, search will continuously probe Boolean variables, and integer
   * variable bounds.
   * </pre>
   *
   * <code>optional bool use_probing_search = 176 [default = false];</code>
   * @return Whether the useProbingSearch field is set.
   */
  boolean hasUseProbingSearch();
  /**
   * <pre>
   * If true, search will continuously probe Boolean variables, and integer
   * variable bounds.
   * </pre>
   *
   * <code>optional bool use_probing_search = 176 [default = false];</code>
   * @return The useProbingSearch.
   */
  boolean getUseProbingSearch();

  /**
   * <pre>
   * The solver ignores the pseudo costs of variables with number of recordings
   * less than this threshold.
   * </pre>
   *
   * <code>optional int64 pseudo_cost_reliability_threshold = 123 [default = 100];</code>
   * @return Whether the pseudoCostReliabilityThreshold field is set.
   */
  boolean hasPseudoCostReliabilityThreshold();
  /**
   * <pre>
   * The solver ignores the pseudo costs of variables with number of recordings
   * less than this threshold.
   * </pre>
   *
   * <code>optional int64 pseudo_cost_reliability_threshold = 123 [default = 100];</code>
   * @return The pseudoCostReliabilityThreshold.
   */
  long getPseudoCostReliabilityThreshold();

  /**
   * <pre>
   * The default optimization method is a simple "linear scan", each time trying
   * to find a better solution than the previous one. If this is true, then we
   * use a core-based approach (like in max-SAT) when we try to increase the
   * lower bound instead.
   * </pre>
   *
   * <code>optional bool optimize_with_core = 83 [default = false];</code>
   * @return Whether the optimizeWithCore field is set.
   */
  boolean hasOptimizeWithCore();
  /**
   * <pre>
   * The default optimization method is a simple "linear scan", each time trying
   * to find a better solution than the previous one. If this is true, then we
   * use a core-based approach (like in max-SAT) when we try to increase the
   * lower bound instead.
   * </pre>
   *
   * <code>optional bool optimize_with_core = 83 [default = false];</code>
   * @return The optimizeWithCore.
   */
  boolean getOptimizeWithCore();

  /**
   * <pre>
   * Do a more conventional tree search (by opposition to SAT based one) where
   * we keep all the explored node in a tree. This is meant to be used in a
   * portfolio and focus on improving the objective lower bound. Keeping the
   * whole tree allow us to report a better objective lower bound coming from
   * the worst open node in the tree.
   * </pre>
   *
   * <code>optional bool optimize_with_lb_tree_search = 188 [default = false];</code>
   * @return Whether the optimizeWithLbTreeSearch field is set.
   */
  boolean hasOptimizeWithLbTreeSearch();
  /**
   * <pre>
   * Do a more conventional tree search (by opposition to SAT based one) where
   * we keep all the explored node in a tree. This is meant to be used in a
   * portfolio and focus on improving the objective lower bound. Keeping the
   * whole tree allow us to report a better objective lower bound coming from
   * the worst open node in the tree.
   * </pre>
   *
   * <code>optional bool optimize_with_lb_tree_search = 188 [default = false];</code>
   * @return The optimizeWithLbTreeSearch.
   */
  boolean getOptimizeWithLbTreeSearch();

  /**
   * <pre>
   * If non-negative, perform a binary search on the objective variable in order
   * to find an [min, max] interval outside of which the solver proved unsat/sat
   * under this amount of conflict. This can quickly reduce the objective domain
   * on some problems.
   * </pre>
   *
   * <code>optional int32 binary_search_num_conflicts = 99 [default = -1];</code>
   * @return Whether the binarySearchNumConflicts field is set.
   */
  boolean hasBinarySearchNumConflicts();
  /**
   * <pre>
   * If non-negative, perform a binary search on the objective variable in order
   * to find an [min, max] interval outside of which the solver proved unsat/sat
   * under this amount of conflict. This can quickly reduce the objective domain
   * on some problems.
   * </pre>
   *
   * <code>optional int32 binary_search_num_conflicts = 99 [default = -1];</code>
   * @return The binarySearchNumConflicts.
   */
  int getBinarySearchNumConflicts();

  /**
   * <pre>
   * This has no effect if optimize_with_core is false. If true, use a different
   * core-based algorithm similar to the max-HS algo for max-SAT. This is a
   * hybrid MIP/CP approach and it uses a MIP solver in addition to the CP/SAT
   * one. This is also related to the PhD work of tobyodavies&#64;
   * "Automatic Logic-Based Benders Decomposition with MiniZinc"
   * http://aaai.org/ocs/index.php/AAAI/AAAI17/paper/view/14489
   * </pre>
   *
   * <code>optional bool optimize_with_max_hs = 85 [default = false];</code>
   * @return Whether the optimizeWithMaxHs field is set.
   */
  boolean hasOptimizeWithMaxHs();
  /**
   * <pre>
   * This has no effect if optimize_with_core is false. If true, use a different
   * core-based algorithm similar to the max-HS algo for max-SAT. This is a
   * hybrid MIP/CP approach and it uses a MIP solver in addition to the CP/SAT
   * one. This is also related to the PhD work of tobyodavies&#64;
   * "Automatic Logic-Based Benders Decomposition with MiniZinc"
   * http://aaai.org/ocs/index.php/AAAI/AAAI17/paper/view/14489
   * </pre>
   *
   * <code>optional bool optimize_with_max_hs = 85 [default = false];</code>
   * @return The optimizeWithMaxHs.
   */
  boolean getOptimizeWithMaxHs();

  /**
   * <pre>
   * Whether we enumerate all solutions of a problem without objective. Note
   * that setting this to true automatically disable some presolve reduction
   * that can remove feasible solution. That is it has the same effect as
   * setting keep_all_feasible_solutions_in_presolve.
   * TODO(user): Do not do that and let the user choose what behavior is best by
   * setting keep_all_feasible_solutions_in_presolve ?
   * </pre>
   *
   * <code>optional bool enumerate_all_solutions = 87 [default = false];</code>
   * @return Whether the enumerateAllSolutions field is set.
   */
  boolean hasEnumerateAllSolutions();
  /**
   * <pre>
   * Whether we enumerate all solutions of a problem without objective. Note
   * that setting this to true automatically disable some presolve reduction
   * that can remove feasible solution. That is it has the same effect as
   * setting keep_all_feasible_solutions_in_presolve.
   * TODO(user): Do not do that and let the user choose what behavior is best by
   * setting keep_all_feasible_solutions_in_presolve ?
   * </pre>
   *
   * <code>optional bool enumerate_all_solutions = 87 [default = false];</code>
   * @return The enumerateAllSolutions.
   */
  boolean getEnumerateAllSolutions();

  /**
   * <pre>
   * If true, we disable the presolve reductions that remove feasible solutions
   * from the search space. Such solution are usually dominated by a "better"
   * solution that is kept, but depending on the situation, we might want to
   * keep all solutions.
   * A trivial example is when a variable is unused. If this is true, then the
   * presolve will not fix it to an arbitrary value and it will stay in the
   * search space.
   * </pre>
   *
   * <code>optional bool keep_all_feasible_solutions_in_presolve = 173 [default = false];</code>
   * @return Whether the keepAllFeasibleSolutionsInPresolve field is set.
   */
  boolean hasKeepAllFeasibleSolutionsInPresolve();
  /**
   * <pre>
   * If true, we disable the presolve reductions that remove feasible solutions
   * from the search space. Such solution are usually dominated by a "better"
   * solution that is kept, but depending on the situation, we might want to
   * keep all solutions.
   * A trivial example is when a variable is unused. If this is true, then the
   * presolve will not fix it to an arbitrary value and it will stay in the
   * search space.
   * </pre>
   *
   * <code>optional bool keep_all_feasible_solutions_in_presolve = 173 [default = false];</code>
   * @return The keepAllFeasibleSolutionsInPresolve.
   */
  boolean getKeepAllFeasibleSolutionsInPresolve();

  /**
   * <pre>
   * If true, add information about the derived variable domains to the
   * CpSolverResponse. It is an option because it makes the response slighly
   * bigger and there is a bit more work involved during the postsolve to
   * construct it, but it should still have a low overhead. See the
   * tightened_variables field in CpSolverResponse for more details.
   * </pre>
   *
   * <code>optional bool fill_tightened_domains_in_response = 132 [default = false];</code>
   * @return Whether the fillTightenedDomainsInResponse field is set.
   */
  boolean hasFillTightenedDomainsInResponse();
  /**
   * <pre>
   * If true, add information about the derived variable domains to the
   * CpSolverResponse. It is an option because it makes the response slighly
   * bigger and there is a bit more work involved during the postsolve to
   * construct it, but it should still have a low overhead. See the
   * tightened_variables field in CpSolverResponse for more details.
   * </pre>
   *
   * <code>optional bool fill_tightened_domains_in_response = 132 [default = false];</code>
   * @return The fillTightenedDomainsInResponse.
   */
  boolean getFillTightenedDomainsInResponse();

  /**
   * <pre>
   * If true, the solver will add a default integer branching strategy to the
   * already defined search strategy. If not, some variable might still not be
   * fixed at the end of the search. For now we assume these variable can just
   * be set to their lower bound.
   * </pre>
   *
   * <code>optional bool instantiate_all_variables = 106 [default = true];</code>
   * @return Whether the instantiateAllVariables field is set.
   */
  boolean hasInstantiateAllVariables();
  /**
   * <pre>
   * If true, the solver will add a default integer branching strategy to the
   * already defined search strategy. If not, some variable might still not be
   * fixed at the end of the search. For now we assume these variable can just
   * be set to their lower bound.
   * </pre>
   *
   * <code>optional bool instantiate_all_variables = 106 [default = true];</code>
   * @return The instantiateAllVariables.
   */
  boolean getInstantiateAllVariables();

  /**
   * <pre>
   * If true, then the precedences propagator try to detect for each variable if
   * it has a set of "optional incoming arc" for which at least one of them is
   * present. This is usually useful to have but can be slow on model with a lot
   * of precedence.
   * </pre>
   *
   * <code>optional bool auto_detect_greater_than_at_least_one_of = 95 [default = true];</code>
   * @return Whether the autoDetectGreaterThanAtLeastOneOf field is set.
   */
  boolean hasAutoDetectGreaterThanAtLeastOneOf();
  /**
   * <pre>
   * If true, then the precedences propagator try to detect for each variable if
   * it has a set of "optional incoming arc" for which at least one of them is
   * present. This is usually useful to have but can be slow on model with a lot
   * of precedence.
   * </pre>
   *
   * <code>optional bool auto_detect_greater_than_at_least_one_of = 95 [default = true];</code>
   * @return The autoDetectGreaterThanAtLeastOneOf.
   */
  boolean getAutoDetectGreaterThanAtLeastOneOf();

  /**
   * <pre>
   * For an optimization problem, stop the solver as soon as we have a solution.
   * </pre>
   *
   * <code>optional bool stop_after_first_solution = 98 [default = false];</code>
   * @return Whether the stopAfterFirstSolution field is set.
   */
  boolean hasStopAfterFirstSolution();
  /**
   * <pre>
   * For an optimization problem, stop the solver as soon as we have a solution.
   * </pre>
   *
   * <code>optional bool stop_after_first_solution = 98 [default = false];</code>
   * @return The stopAfterFirstSolution.
   */
  boolean getStopAfterFirstSolution();

  /**
   * <pre>
   * Mainly used when improving the presolver. When true, stops the solver after
   * the presolve is complete.
   * </pre>
   *
   * <code>optional bool stop_after_presolve = 149 [default = false];</code>
   * @return Whether the stopAfterPresolve field is set.
   */
  boolean hasStopAfterPresolve();
  /**
   * <pre>
   * Mainly used when improving the presolver. When true, stops the solver after
   * the presolve is complete.
   * </pre>
   *
   * <code>optional bool stop_after_presolve = 149 [default = false];</code>
   * @return The stopAfterPresolve.
   */
  boolean getStopAfterPresolve();

  /**
   * <pre>
   * Specify the number of parallel workers to use during search.
   * A value of 0 means the solver will try to use all cores on the machine.
   * A number of 1 means no parallelism.
   * As of 2020-04-10, if you're using SAT via MPSolver (to solve integer
   * programs) this field is overridden with a value of 8, if the field is not
   * set *explicitly*. Thus, always set this field explicitly or via
   * MPSolver::SetNumThreads().
   * </pre>
   *
   * <code>optional int32 num_search_workers = 100 [default = 0];</code>
   * @return Whether the numSearchWorkers field is set.
   */
  boolean hasNumSearchWorkers();
  /**
   * <pre>
   * Specify the number of parallel workers to use during search.
   * A value of 0 means the solver will try to use all cores on the machine.
   * A number of 1 means no parallelism.
   * As of 2020-04-10, if you're using SAT via MPSolver (to solve integer
   * programs) this field is overridden with a value of 8, if the field is not
   * set *explicitly*. Thus, always set this field explicitly or via
   * MPSolver::SetNumThreads().
   * </pre>
   *
   * <code>optional int32 num_search_workers = 100 [default = 0];</code>
   * @return The numSearchWorkers.
   */
  int getNumSearchWorkers();

  /**
   * <pre>
   * Experimental. If this is true, then we interleave all our major search
   * strategy and distribute the work amongst num_search_workers.
   * The search is deterministic (independently of num_search_workers!), and we
   * schedule and wait for interleave_batch_size task to be completed before
   * synchronizing and scheduling the next batch of tasks.
   * </pre>
   *
   * <code>optional bool interleave_search = 136 [default = false];</code>
   * @return Whether the interleaveSearch field is set.
   */
  boolean hasInterleaveSearch();
  /**
   * <pre>
   * Experimental. If this is true, then we interleave all our major search
   * strategy and distribute the work amongst num_search_workers.
   * The search is deterministic (independently of num_search_workers!), and we
   * schedule and wait for interleave_batch_size task to be completed before
   * synchronizing and scheduling the next batch of tasks.
   * </pre>
   *
   * <code>optional bool interleave_search = 136 [default = false];</code>
   * @return The interleaveSearch.
   */
  boolean getInterleaveSearch();

  /**
   * <code>optional int32 interleave_batch_size = 134 [default = 1];</code>
   * @return Whether the interleaveBatchSize field is set.
   */
  boolean hasInterleaveBatchSize();
  /**
   * <code>optional int32 interleave_batch_size = 134 [default = 1];</code>
   * @return The interleaveBatchSize.
   */
  int getInterleaveBatchSize();

  /**
   * <pre>
   * Temporary parameter until the memory usage is more optimized.
   * </pre>
   *
   * <code>optional bool reduce_memory_usage_in_interleave_mode = 141 [default = false];</code>
   * @return Whether the reduceMemoryUsageInInterleaveMode field is set.
   */
  boolean hasReduceMemoryUsageInInterleaveMode();
  /**
   * <pre>
   * Temporary parameter until the memory usage is more optimized.
   * </pre>
   *
   * <code>optional bool reduce_memory_usage_in_interleave_mode = 141 [default = false];</code>
   * @return The reduceMemoryUsageInInterleaveMode.
   */
  boolean getReduceMemoryUsageInInterleaveMode();

  /**
   * <pre>
   * Allows objective sharing between workers.
   * </pre>
   *
   * <code>optional bool share_objective_bounds = 113 [default = true];</code>
   * @return Whether the shareObjectiveBounds field is set.
   */
  boolean hasShareObjectiveBounds();
  /**
   * <pre>
   * Allows objective sharing between workers.
   * </pre>
   *
   * <code>optional bool share_objective_bounds = 113 [default = true];</code>
   * @return The shareObjectiveBounds.
   */
  boolean getShareObjectiveBounds();

  /**
   * <pre>
   * Allows sharing of the bounds of modified variables at level 0.
   * </pre>
   *
   * <code>optional bool share_level_zero_bounds = 114 [default = true];</code>
   * @return Whether the shareLevelZeroBounds field is set.
   */
  boolean hasShareLevelZeroBounds();
  /**
   * <pre>
   * Allows sharing of the bounds of modified variables at level 0.
   * </pre>
   *
   * <code>optional bool share_level_zero_bounds = 114 [default = true];</code>
   * @return The shareLevelZeroBounds.
   */
  boolean getShareLevelZeroBounds();

  /**
   * <pre>
   * LNS parameters.
   * </pre>
   *
   * <code>optional bool use_lns_only = 101 [default = false];</code>
   * @return Whether the useLnsOnly field is set.
   */
  boolean hasUseLnsOnly();
  /**
   * <pre>
   * LNS parameters.
   * </pre>
   *
   * <code>optional bool use_lns_only = 101 [default = false];</code>
   * @return The useLnsOnly.
   */
  boolean getUseLnsOnly();

  /**
   * <code>optional bool lns_focus_on_decision_variables = 105 [default = false];</code>
   * @return Whether the lnsFocusOnDecisionVariables field is set.
   */
  boolean hasLnsFocusOnDecisionVariables();
  /**
   * <code>optional bool lns_focus_on_decision_variables = 105 [default = false];</code>
   * @return The lnsFocusOnDecisionVariables.
   */
  boolean getLnsFocusOnDecisionVariables();

  /**
   * <code>optional bool lns_expand_intervals_in_constraint_graph = 184 [default = true];</code>
   * @return Whether the lnsExpandIntervalsInConstraintGraph field is set.
   */
  boolean hasLnsExpandIntervalsInConstraintGraph();
  /**
   * <code>optional bool lns_expand_intervals_in_constraint_graph = 184 [default = true];</code>
   * @return The lnsExpandIntervalsInConstraintGraph.
   */
  boolean getLnsExpandIntervalsInConstraintGraph();

  /**
   * <pre>
   * Size of the top-n different solutions kept by the solver.
   * Currently this only impact the "base" solution chosen for a LNS fragment.
   * </pre>
   *
   * <code>optional int32 solution_pool_size = 193 [default = 3];</code>
   * @return Whether the solutionPoolSize field is set.
   */
  boolean hasSolutionPoolSize();
  /**
   * <pre>
   * Size of the top-n different solutions kept by the solver.
   * Currently this only impact the "base" solution chosen for a LNS fragment.
   * </pre>
   *
   * <code>optional int32 solution_pool_size = 193 [default = 3];</code>
   * @return The solutionPoolSize.
   */
  int getSolutionPoolSize();

  /**
   * <pre>
   * Turns on relaxation induced neighborhood generator.
   * </pre>
   *
   * <code>optional bool use_rins_lns = 129 [default = true];</code>
   * @return Whether the useRinsLns field is set.
   */
  boolean hasUseRinsLns();
  /**
   * <pre>
   * Turns on relaxation induced neighborhood generator.
   * </pre>
   *
   * <code>optional bool use_rins_lns = 129 [default = true];</code>
   * @return The useRinsLns.
   */
  boolean getUseRinsLns();

  /**
   * <pre>
   * Adds a feasibility pump subsolver along with lns subsolvers.
   * </pre>
   *
   * <code>optional bool use_feasibility_pump = 164 [default = true];</code>
   * @return Whether the useFeasibilityPump field is set.
   */
  boolean hasUseFeasibilityPump();
  /**
   * <pre>
   * Adds a feasibility pump subsolver along with lns subsolvers.
   * </pre>
   *
   * <code>optional bool use_feasibility_pump = 164 [default = true];</code>
   * @return The useFeasibilityPump.
   */
  boolean getUseFeasibilityPump();

  /**
   * <code>optional .operations_research.sat.SatParameters.FPRoundingMethod fp_rounding = 165 [default = PROPAGATION_ASSISTED];</code>
   * @return Whether the fpRounding field is set.
   */
  boolean hasFpRounding();
  /**
   * <code>optional .operations_research.sat.SatParameters.FPRoundingMethod fp_rounding = 165 [default = PROPAGATION_ASSISTED];</code>
   * @return The fpRounding.
   */
  com.google.ortools.sat.SatParameters.FPRoundingMethod getFpRounding();

  /**
   * <pre>
   * Turns on a lns worker which solves relaxed version of the original problem
   * by removing constraints from the problem in order to get better bounds.
   * </pre>
   *
   * <code>optional bool use_relaxation_lns = 150 [default = false];</code>
   * @return Whether the useRelaxationLns field is set.
   */
  boolean hasUseRelaxationLns();
  /**
   * <pre>
   * Turns on a lns worker which solves relaxed version of the original problem
   * by removing constraints from the problem in order to get better bounds.
   * </pre>
   *
   * <code>optional bool use_relaxation_lns = 150 [default = false];</code>
   * @return The useRelaxationLns.
   */
  boolean getUseRelaxationLns();

  /**
   * <pre>
   * If true, registers more lns subsolvers with different parameters.
   * </pre>
   *
   * <code>optional bool diversify_lns_params = 137 [default = false];</code>
   * @return Whether the diversifyLnsParams field is set.
   */
  boolean hasDiversifyLnsParams();
  /**
   * <pre>
   * If true, registers more lns subsolvers with different parameters.
   * </pre>
   *
   * <code>optional bool diversify_lns_params = 137 [default = false];</code>
   * @return The diversifyLnsParams.
   */
  boolean getDiversifyLnsParams();

  /**
   * <pre>
   * Randomize fixed search.
   * </pre>
   *
   * <code>optional bool randomize_search = 103 [default = false];</code>
   * @return Whether the randomizeSearch field is set.
   */
  boolean hasRandomizeSearch();
  /**
   * <pre>
   * Randomize fixed search.
   * </pre>
   *
   * <code>optional bool randomize_search = 103 [default = false];</code>
   * @return The randomizeSearch.
   */
  boolean getRandomizeSearch();

  /**
   * <pre>
   * Search randomization will collect equivalent 'max valued' variables, and
   * pick one randomly. For instance, if the variable strategy is CHOOSE_FIRST,
   * all unassigned variables are equivalent. If the variable strategy is
   * CHOOSE_LOWEST_MIN, and `lm` is the current lowest min of all unassigned
   * variables, then the set of max valued variables will be all unassigned
   * variables where
   *    lm &lt;= variable min &lt;= lm + search_randomization_tolerance
   * </pre>
   *
   * <code>optional int64 search_randomization_tolerance = 104 [default = 0];</code>
   * @return Whether the searchRandomizationTolerance field is set.
   */
  boolean hasSearchRandomizationTolerance();
  /**
   * <pre>
   * Search randomization will collect equivalent 'max valued' variables, and
   * pick one randomly. For instance, if the variable strategy is CHOOSE_FIRST,
   * all unassigned variables are equivalent. If the variable strategy is
   * CHOOSE_LOWEST_MIN, and `lm` is the current lowest min of all unassigned
   * variables, then the set of max valued variables will be all unassigned
   * variables where
   *    lm &lt;= variable min &lt;= lm + search_randomization_tolerance
   * </pre>
   *
   * <code>optional int64 search_randomization_tolerance = 104 [default = 0];</code>
   * @return The searchRandomizationTolerance.
   */
  long getSearchRandomizationTolerance();

  /**
   * <pre>
   * If true, we automatically detect variables whose constraint are always
   * enforced by the same literal and we mark them as optional. This allows
   * to propagate them as if they were present in some situation.
   * </pre>
   *
   * <code>optional bool use_optional_variables = 108 [default = true];</code>
   * @return Whether the useOptionalVariables field is set.
   */
  boolean hasUseOptionalVariables();
  /**
   * <pre>
   * If true, we automatically detect variables whose constraint are always
   * enforced by the same literal and we mark them as optional. This allows
   * to propagate them as if they were present in some situation.
   * </pre>
   *
   * <code>optional bool use_optional_variables = 108 [default = true];</code>
   * @return The useOptionalVariables.
   */
  boolean getUseOptionalVariables();

  /**
   * <pre>
   * The solver usually exploit the LP relaxation of a model. If this option is
   * true, then whatever is infered by the LP will be used like an heuristic to
   * compute EXACT propagation on the IP. So with this option, there is no
   * numerical imprecision issues.
   * </pre>
   *
   * <code>optional bool use_exact_lp_reason = 109 [default = true];</code>
   * @return Whether the useExactLpReason field is set.
   */
  boolean hasUseExactLpReason();
  /**
   * <pre>
   * The solver usually exploit the LP relaxation of a model. If this option is
   * true, then whatever is infered by the LP will be used like an heuristic to
   * compute EXACT propagation on the IP. So with this option, there is no
   * numerical imprecision issues.
   * </pre>
   *
   * <code>optional bool use_exact_lp_reason = 109 [default = true];</code>
   * @return The useExactLpReason.
   */
  boolean getUseExactLpReason();

  /**
   * <pre>
   * If true, the solver attemts to generate more info inside lp propagator by
   * branching on some variables if certain criteria are met during the search
   * tree exploration.
   * </pre>
   *
   * <code>optional bool use_branching_in_lp = 139 [default = false];</code>
   * @return Whether the useBranchingInLp field is set.
   */
  boolean hasUseBranchingInLp();
  /**
   * <pre>
   * If true, the solver attemts to generate more info inside lp propagator by
   * branching on some variables if certain criteria are met during the search
   * tree exploration.
   * </pre>
   *
   * <code>optional bool use_branching_in_lp = 139 [default = false];</code>
   * @return The useBranchingInLp.
   */
  boolean getUseBranchingInLp();

  /**
   * <pre>
   * This can be beneficial if there is a lot of no-overlap constraints but a
   * relatively low number of different intervals in the problem. Like 1000
   * intervals, but 1M intervals in the no-overlap constraints covering them.
   * </pre>
   *
   * <code>optional bool use_combined_no_overlap = 133 [default = false];</code>
   * @return Whether the useCombinedNoOverlap field is set.
   */
  boolean hasUseCombinedNoOverlap();
  /**
   * <pre>
   * This can be beneficial if there is a lot of no-overlap constraints but a
   * relatively low number of different intervals in the problem. Like 1000
   * intervals, but 1M intervals in the no-overlap constraints covering them.
   * </pre>
   *
   * <code>optional bool use_combined_no_overlap = 133 [default = false];</code>
   * @return The useCombinedNoOverlap.
   */
  boolean getUseCombinedNoOverlap();

  /**
   * <pre>
   * Indicates if the CP-SAT layer should catch Control-C (SIGINT) signals
   * when calling solve. If set, catching the SIGINT signal will terminate the
   * search gracefully, as if a time limit was reached.
   * </pre>
   *
   * <code>optional bool catch_sigint_signal = 135 [default = true];</code>
   * @return Whether the catchSigintSignal field is set.
   */
  boolean hasCatchSigintSignal();
  /**
   * <pre>
   * Indicates if the CP-SAT layer should catch Control-C (SIGINT) signals
   * when calling solve. If set, catching the SIGINT signal will terminate the
   * search gracefully, as if a time limit was reached.
   * </pre>
   *
   * <code>optional bool catch_sigint_signal = 135 [default = true];</code>
   * @return The catchSigintSignal.
   */
  boolean getCatchSigintSignal();

  /**
   * <pre>
   * Stores and exploits "implied-bounds" in the solver. That is, relations of
   * the form literal =&gt; (var &gt;= bound). This is currently used to derive
   * stronger cuts.
   * </pre>
   *
   * <code>optional bool use_implied_bounds = 144 [default = true];</code>
   * @return Whether the useImpliedBounds field is set.
   */
  boolean hasUseImpliedBounds();
  /**
   * <pre>
   * Stores and exploits "implied-bounds" in the solver. That is, relations of
   * the form literal =&gt; (var &gt;= bound). This is currently used to derive
   * stronger cuts.
   * </pre>
   *
   * <code>optional bool use_implied_bounds = 144 [default = true];</code>
   * @return The useImpliedBounds.
   */
  boolean getUseImpliedBounds();

  /**
   * <pre>
   * Whether we try to do a few degenerate iteration at the end of an LP solve
   * to minimize the fractionality of the integer variable in the basis. This
   * helps on some problems, but not so much on others. It also cost of bit of
   * time to do such polish step.
   * </pre>
   *
   * <code>optional bool polish_lp_solution = 175 [default = false];</code>
   * @return Whether the polishLpSolution field is set.
   */
  boolean hasPolishLpSolution();
  /**
   * <pre>
   * Whether we try to do a few degenerate iteration at the end of an LP solve
   * to minimize the fractionality of the integer variable in the basis. This
   * helps on some problems, but not so much on others. It also cost of bit of
   * time to do such polish step.
   * </pre>
   *
   * <code>optional bool polish_lp_solution = 175 [default = false];</code>
   * @return The polishLpSolution.
   */
  boolean getPolishLpSolution();

  /**
   * <pre>
   * Temporary flag util the feature is more mature. This convert intervals to
   * the newer proto format that support affine start/var/end instead of just
   * variables.
   * </pre>
   *
   * <code>optional bool convert_intervals = 177 [default = true];</code>
   * @return Whether the convertIntervals field is set.
   */
  boolean hasConvertIntervals();
  /**
   * <pre>
   * Temporary flag util the feature is more mature. This convert intervals to
   * the newer proto format that support affine start/var/end instead of just
   * variables.
   * </pre>
   *
   * <code>optional bool convert_intervals = 177 [default = true];</code>
   * @return The convertIntervals.
   */
  boolean getConvertIntervals();

  /**
   * <pre>
   * Whether we try to automatically detect the symmetries in a model and
   * exploit them. Currently, at level 1 we detect them in presolve and try
   * to fix Booleans. At level 2, we also do some form of dynamic symmetry
   * breaking during search.
   * </pre>
   *
   * <code>optional int32 symmetry_level = 183 [default = 2];</code>
   * @return Whether the symmetryLevel field is set.
   */
  boolean hasSymmetryLevel();
  /**
   * <pre>
   * Whether we try to automatically detect the symmetries in a model and
   * exploit them. Currently, at level 1 we detect them in presolve and try
   * to fix Booleans. At level 2, we also do some form of dynamic symmetry
   * breaking during search.
   * </pre>
   *
   * <code>optional int32 symmetry_level = 183 [default = 2];</code>
   * @return The symmetryLevel.
   */
  int getSymmetryLevel();

  /**
   * <pre>
   * We need to bound the maximum magnitude of the variables for CP-SAT, and
   * that is the bound we use. If the MIP model expect larger variable value in
   * the solution, then the converted model will likely not be relevant.
   * </pre>
   *
   * <code>optional double mip_max_bound = 124 [default = 10000000];</code>
   * @return Whether the mipMaxBound field is set.
   */
  boolean hasMipMaxBound();
  /**
   * <pre>
   * We need to bound the maximum magnitude of the variables for CP-SAT, and
   * that is the bound we use. If the MIP model expect larger variable value in
   * the solution, then the converted model will likely not be relevant.
   * </pre>
   *
   * <code>optional double mip_max_bound = 124 [default = 10000000];</code>
   * @return The mipMaxBound.
   */
  double getMipMaxBound();

  /**
   * <pre>
   * All continuous variable of the problem will be multiplied by this factor.
   * By default, we don't do any variable scaling and rely on the MIP model to
   * specify continuous variable domain with the wanted precision.
   * </pre>
   *
   * <code>optional double mip_var_scaling = 125 [default = 1];</code>
   * @return Whether the mipVarScaling field is set.
   */
  boolean hasMipVarScaling();
  /**
   * <pre>
   * All continuous variable of the problem will be multiplied by this factor.
   * By default, we don't do any variable scaling and rely on the MIP model to
   * specify continuous variable domain with the wanted precision.
   * </pre>
   *
   * <code>optional double mip_var_scaling = 125 [default = 1];</code>
   * @return The mipVarScaling.
   */
  double getMipVarScaling();

  /**
   * <pre>
   * If true, some continuous variable might be automatically scaled. For now,
   * this is only the case where we detect that a variable is actually an
   * integer multiple of a constant. For instance, variables of the form k * 0.5
   * are quite frequent, and if we detect this, we will scale such variable
   * domain by 2 to make it implied integer.
   * </pre>
   *
   * <code>optional bool mip_automatically_scale_variables = 166 [default = true];</code>
   * @return Whether the mipAutomaticallyScaleVariables field is set.
   */
  boolean hasMipAutomaticallyScaleVariables();
  /**
   * <pre>
   * If true, some continuous variable might be automatically scaled. For now,
   * this is only the case where we detect that a variable is actually an
   * integer multiple of a constant. For instance, variables of the form k * 0.5
   * are quite frequent, and if we detect this, we will scale such variable
   * domain by 2 to make it implied integer.
   * </pre>
   *
   * <code>optional bool mip_automatically_scale_variables = 166 [default = true];</code>
   * @return The mipAutomaticallyScaleVariables.
   */
  boolean getMipAutomaticallyScaleVariables();

  /**
   * <pre>
   * When scaling constraint with double coefficients to integer coefficients,
   * we will multiply by a power of 2 and round the coefficients. We will choose
   * the lowest power such that we have no potential overflow and the worst case
   * constraint activity error do not exceed this threshold relative to the
   * constraint bounds.
   * We also use this to decide by how much we relax the constraint bounds so
   * that we can have a feasible integer solution of constraints involving
   * continuous variable. This is required for instance when you have an == rhs
   * constraint as in many situation you cannot have a perfect equality with
   * integer variables and coefficients.
   * </pre>
   *
   * <code>optional double mip_wanted_precision = 126 [default = 1e-06];</code>
   * @return Whether the mipWantedPrecision field is set.
   */
  boolean hasMipWantedPrecision();
  /**
   * <pre>
   * When scaling constraint with double coefficients to integer coefficients,
   * we will multiply by a power of 2 and round the coefficients. We will choose
   * the lowest power such that we have no potential overflow and the worst case
   * constraint activity error do not exceed this threshold relative to the
   * constraint bounds.
   * We also use this to decide by how much we relax the constraint bounds so
   * that we can have a feasible integer solution of constraints involving
   * continuous variable. This is required for instance when you have an == rhs
   * constraint as in many situation you cannot have a perfect equality with
   * integer variables and coefficients.
   * </pre>
   *
   * <code>optional double mip_wanted_precision = 126 [default = 1e-06];</code>
   * @return The mipWantedPrecision.
   */
  double getMipWantedPrecision();

  /**
   * <pre>
   * To avoid integer overflow, we always force the maximum possible constraint
   * activity (and objective value) according to the initial variable domain to
   * be smaller than 2 to this given power. Because of this, we cannot always
   * reach the "mip_wanted_precision" parameter above.
   * This can go as high as 62, but some internal algo currently abort early if
   * they might run into integer overflow, so it is better to keep it a bit
   * lower than this.
   * </pre>
   *
   * <code>optional int32 mip_max_activity_exponent = 127 [default = 53];</code>
   * @return Whether the mipMaxActivityExponent field is set.
   */
  boolean hasMipMaxActivityExponent();
  /**
   * <pre>
   * To avoid integer overflow, we always force the maximum possible constraint
   * activity (and objective value) according to the initial variable domain to
   * be smaller than 2 to this given power. Because of this, we cannot always
   * reach the "mip_wanted_precision" parameter above.
   * This can go as high as 62, but some internal algo currently abort early if
   * they might run into integer overflow, so it is better to keep it a bit
   * lower than this.
   * </pre>
   *
   * <code>optional int32 mip_max_activity_exponent = 127 [default = 53];</code>
   * @return The mipMaxActivityExponent.
   */
  int getMipMaxActivityExponent();

  /**
   * <pre>
   * As explained in mip_precision and mip_max_activity_exponent, we cannot
   * always reach the wanted precision during scaling. We use this threshold to
   * enphasize in the logs when the precision seems bad.
   * </pre>
   *
   * <code>optional double mip_check_precision = 128 [default = 0.0001];</code>
   * @return Whether the mipCheckPrecision field is set.
   */
  boolean hasMipCheckPrecision();
  /**
   * <pre>
   * As explained in mip_precision and mip_max_activity_exponent, we cannot
   * always reach the wanted precision during scaling. We use this threshold to
   * enphasize in the logs when the precision seems bad.
   * </pre>
   *
   * <code>optional double mip_check_precision = 128 [default = 0.0001];</code>
   * @return The mipCheckPrecision.
   */
  double getMipCheckPrecision();
}
