/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.2.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.google.ortools.constraintsolver;

/**
 *  This is the base class for building an Lns operator. An Lns fragment is a<br>
 *  collection of variables which will be relaxed. Fragments are built with<br>
 *  NextFragment(), which returns false if there are no more fragments to build.<br>
 *  Optionally one can override InitFragments, which is called from<br>
 *  LocalSearchOperator::Start to initialize fragment data.<br>
 * <br>
 *  Here's a sample relaxing one variable at a time:<br>
 * <br>
 *  class OneVarLns : public BaseLns {<br>
 *   public:<br>
 *    OneVarLns(const std::vector&lt;IntVar*&gt;&amp; vars) : BaseLns(vars), index_(0) {}<br>
 *    virtual ~OneVarLns() {}<br>
 *    virtual void InitFragments() { index_ = 0; }<br>
 *    virtual bool NextFragment() {<br>
 *      const int size = Size();<br>
 *      if (index_ &lt; size) {<br>
 *        AppendToFragment(index_);<br>
 *        ++index_;<br>
 *        return true;<br>
 *      } else {<br>
 *        return false;<br>
 *      }<br>
 *    }<br>
 * <br>
 *   private:<br>
 *    int index_;<br>
 *  };
 */
public class BaseLns extends IntVarLocalSearchOperator {
  private transient long swigCPtr;

  protected BaseLns(long cPtr, boolean cMemoryOwn) {
    super(mainJNI.BaseLns_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BaseLns obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BaseLns obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        mainJNI.delete_BaseLns(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  protected void swigDirectorDisconnect() {
    swigCMemOwn = false;
    delete();
  }

  public void swigReleaseOwnership() {
    swigCMemOwn = false;
    mainJNI.BaseLns_change_ownership(this, swigCPtr, false);
  }

  public void swigTakeOwnership() {
    swigCMemOwn = true;
    mainJNI.BaseLns_change_ownership(this, swigCPtr, true);
  }

  public BaseLns(IntVar[] vars) {
    this(mainJNI.new_BaseLns(vars), true);
    mainJNI.BaseLns_director_connect(this, swigCPtr, true, true);
  }

  public void initFragments() {
    if (getClass() == BaseLns.class) mainJNI.BaseLns_initFragments(swigCPtr, this); else mainJNI.BaseLns_initFragmentsSwigExplicitBaseLns(swigCPtr, this);
  }

  public boolean nextFragment() {
    return mainJNI.BaseLns_nextFragment(swigCPtr, this);
  }

  public void appendToFragment(int index) {
    mainJNI.BaseLns_appendToFragment(swigCPtr, this, index);
  }

  public int fragmentSize() {
    return mainJNI.BaseLns_fragmentSize(swigCPtr, this);
  }

  public boolean HasFragments() {
    return (getClass() == BaseLns.class) ? mainJNI.BaseLns_HasFragments(swigCPtr, this) : mainJNI.BaseLns_HasFragmentsSwigExplicitBaseLns(swigCPtr, this);
  }

}
