/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.2.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.google.ortools.constraintsolver;

/**
 *  A structure meant to store soft bounds and associated violation constants.<br>
 *  It is 'Simple' because it has one BoundCost per element,<br>
 *  in contrast to 'Multiple'. Design notes:<br>
 *  - it is meant to store model information to be shared through pointers,<br>
 *    so it disallows copy and assign to avoid accidental duplication.<br>
 *  - it keeps soft bounds as an array of structs to help cache,<br>
 *    because code that uses such bounds typically use both bound and cost.<br>
 *  - soft bounds are named pairs, prevents some mistakes.<br>
 *  - using operator[] to access elements is not interesting,<br>
 *    because the structure will be accessed through pointers, moreover having<br>
 *    to type bound_cost reminds the user of the order if they do a copy<br>
 *    assignment of the element.
 */
public class BoundCost {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  public BoundCost(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  public static long getCPtr(BoundCost obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  public static long swigRelease(BoundCost obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        mainJNI.delete_BoundCost(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  public void setBound(long value) {
    mainJNI.BoundCost_bound_set(swigCPtr, this, value);
  }

  public long getBound() {
    return mainJNI.BoundCost_bound_get(swigCPtr, this);
  }

  public void setCost(long value) {
    mainJNI.BoundCost_cost_set(swigCPtr, this, value);
  }

  public long getCost() {
    return mainJNI.BoundCost_cost_get(swigCPtr, this);
  }

  public BoundCost() {
    this(mainJNI.new_BoundCost__SWIG_0(), true);
  }

  public BoundCost(long bound, long cost) {
    this(mainJNI.new_BoundCost__SWIG_1(bound, cost), true);
  }

}
