/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.2.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.google.ortools.constraintsolver;

/**
 *  Base class of all search limits.
 */
public class SearchLimit extends SearchMonitor {
  private transient long swigCPtr;

  protected SearchLimit(long cPtr, boolean cMemoryOwn) {
    super(mainJNI.SearchLimit_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(SearchLimit obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(SearchLimit obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        mainJNI.delete_SearchLimit(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  public void keepAliveDecisionBuilder(DecisionBuilder db) {}

  /**
   *  Returns true if the limit has been crossed.
   */
  public boolean crossed() {
    return mainJNI.SearchLimit_crossed(swigCPtr, this);
  }

  /**
   *  This method is called to check the status of the limit. A return<br>
   *  value of true indicates that we have indeed crossed the limit. In<br>
   *  that case, this method will not be called again and the remaining<br>
   *  search will be discarded.
   */
  public boolean check() {
    return mainJNI.SearchLimit_check(swigCPtr, this);
  }

  /**
   *  Same as Check() but adds the 'offset' value to the current time when time<br>
   *  is considered in the limit.
   */
  public boolean CheckWithOffset(SWIGTYPE_p_absl__Duration offset) {
    return mainJNI.SearchLimit_CheckWithOffset(swigCPtr, this, SWIGTYPE_p_absl__Duration.getCPtr(offset));
  }

  /**
   *  This method is called when the search limit is initialized.
   */
  public void init() {
    mainJNI.SearchLimit_init(swigCPtr, this);
  }

  /**
   *  Copy a limit. Warning: leads to a direct (no check) downcasting of 'limit'<br>
   *  so one needs to be sure both SearchLimits are of the same type.
   */
  public void copy(SearchLimit limit) {
    mainJNI.SearchLimit_copy(swigCPtr, this, SearchLimit.getCPtr(limit), limit);
  }

  /**
   *  Allocates a clone of the limit.
   */
  public SearchLimit makeClone() {
    long cPtr = mainJNI.SearchLimit_makeClone(swigCPtr, this);
    return (cPtr == 0) ? null : new SearchLimit(cPtr, false);
  }

  /**
   *  Internal methods.
   */
  public void enterSearch() {
    mainJNI.SearchLimit_enterSearch(swigCPtr, this);
  }

  public void beginNextDecision(DecisionBuilder b) {
    try {
      mainJNI.SearchLimit_beginNextDecision(swigCPtr, this, DecisionBuilder.getCPtr(b), b);
    } finally {
      keepAliveDecisionBuilder(b);
    }
  }

  public void periodicCheck() {
    mainJNI.SearchLimit_periodicCheck(swigCPtr, this);
  }

  public void refuteDecision(Decision d) {
    mainJNI.SearchLimit_refuteDecision(swigCPtr, this, Decision.getCPtr(d), d);
  }

  public String toString() {
    return mainJNI.SearchLimit_toString(swigCPtr, this);
  }

  public void install() {
    mainJNI.SearchLimit_install(swigCPtr, this);
  }

}
