// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: ortools/linear_solver/linear_solver.proto

// Protobuf Java Version: 4.26.1
package com.google.ortools.linearsolver;

/**
 * <pre>
 * Quadratic constraints of the form lb &lt;= sum a_i x_i + sum b_ij x_i x_j &lt;= ub,
 * where a, b, lb and ub are constants, and x are the model's variables.
 * Quadratic matrices that are Positive Semi-Definite, Second-Order Cones or
 * rotated Second-Order Cones are always accepted. Other forms may or may not be
 * accepted depending on the underlying solver used.
 * See https://scip.zib.de/doc/html/cons__quadratic_8h.php and
 * https://www.gurobi.com/documentation/9.0/refman/constraints.html#subsubsection:QuadraticConstraints
 * </pre>
 *
 * Protobuf type {@code operations_research.MPQuadraticConstraint}
 */
public final class MPQuadraticConstraint extends
    com.google.protobuf.GeneratedMessage implements
    // @@protoc_insertion_point(message_implements:operations_research.MPQuadraticConstraint)
    MPQuadraticConstraintOrBuilder {
private static final long serialVersionUID = 0L;
  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
      com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
      /* major= */ 4,
      /* minor= */ 26,
      /* patch= */ 1,
      /* suffix= */ "",
      MPQuadraticConstraint.class.getName());
  }
  // Use MPQuadraticConstraint.newBuilder() to construct.
  private MPQuadraticConstraint(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }
  private MPQuadraticConstraint() {
    varIndex_ = emptyIntList();
    coefficient_ = emptyDoubleList();
    qvar1Index_ = emptyIntList();
    qvar2Index_ = emptyIntList();
    qcoefficient_ = emptyDoubleList();
    lowerBound_ = Double.NEGATIVE_INFINITY;
    upperBound_ = Double.POSITIVE_INFINITY;
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ortools.linearsolver.LinearSolver.internal_static_operations_research_MPQuadraticConstraint_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ortools.linearsolver.LinearSolver.internal_static_operations_research_MPQuadraticConstraint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ortools.linearsolver.MPQuadraticConstraint.class, com.google.ortools.linearsolver.MPQuadraticConstraint.Builder.class);
  }

  private int bitField0_;
  public static final int VAR_INDEX_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.IntList varIndex_ =
      emptyIntList();
  /**
   * <pre>
   * Sparse representation of linear terms in the quadratic constraint, where
   * term i is var_index[i] * coefficient[i].
   * `var_index` are variable indices w.r.t the "variable" field in
   * MPModelProto, and should be unique.
   * </pre>
   *
   * <code>repeated int32 var_index = 1;</code>
   * @return A list containing the varIndex.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer>
      getVarIndexList() {
    return varIndex_;
  }
  /**
   * <pre>
   * Sparse representation of linear terms in the quadratic constraint, where
   * term i is var_index[i] * coefficient[i].
   * `var_index` are variable indices w.r.t the "variable" field in
   * MPModelProto, and should be unique.
   * </pre>
   *
   * <code>repeated int32 var_index = 1;</code>
   * @return The count of varIndex.
   */
  public int getVarIndexCount() {
    return varIndex_.size();
  }
  /**
   * <pre>
   * Sparse representation of linear terms in the quadratic constraint, where
   * term i is var_index[i] * coefficient[i].
   * `var_index` are variable indices w.r.t the "variable" field in
   * MPModelProto, and should be unique.
   * </pre>
   *
   * <code>repeated int32 var_index = 1;</code>
   * @param index The index of the element to return.
   * @return The varIndex at the given index.
   */
  public int getVarIndex(int index) {
    return varIndex_.getInt(index);
  }

  public static final int COEFFICIENT_FIELD_NUMBER = 2;
  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.DoubleList coefficient_ =
      emptyDoubleList();
  /**
   * <pre>
   * Must be finite.
   * </pre>
   *
   * <code>repeated double coefficient = 2;</code>
   * @return A list containing the coefficient.
   */
  @java.lang.Override
  public java.util.List<java.lang.Double>
      getCoefficientList() {
    return coefficient_;
  }
  /**
   * <pre>
   * Must be finite.
   * </pre>
   *
   * <code>repeated double coefficient = 2;</code>
   * @return The count of coefficient.
   */
  public int getCoefficientCount() {
    return coefficient_.size();
  }
  /**
   * <pre>
   * Must be finite.
   * </pre>
   *
   * <code>repeated double coefficient = 2;</code>
   * @param index The index of the element to return.
   * @return The coefficient at the given index.
   */
  public double getCoefficient(int index) {
    return coefficient_.getDouble(index);
  }

  public static final int QVAR1_INDEX_FIELD_NUMBER = 3;
  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.IntList qvar1Index_ =
      emptyIntList();
  /**
   * <pre>
   * Sparse representation of quadratic terms in the quadratic constraint, where
   * term i is qvar1_index[i] * qvar2_index[i] * qcoefficient[i].
   * `qvar1_index` and `qvar2_index` are variable indices w.r.t the "variable"
   * field in MPModelProto.
   * `qvar1_index`, `qvar2_index` and `coefficients` must have the same size.
   * If the same unordered pair (qvar1_index, qvar2_index) appears several
   * times, the sum of all of the associated coefficients will be applied.
   * </pre>
   *
   * <code>repeated int32 qvar1_index = 3;</code>
   * @return A list containing the qvar1Index.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer>
      getQvar1IndexList() {
    return qvar1Index_;
  }
  /**
   * <pre>
   * Sparse representation of quadratic terms in the quadratic constraint, where
   * term i is qvar1_index[i] * qvar2_index[i] * qcoefficient[i].
   * `qvar1_index` and `qvar2_index` are variable indices w.r.t the "variable"
   * field in MPModelProto.
   * `qvar1_index`, `qvar2_index` and `coefficients` must have the same size.
   * If the same unordered pair (qvar1_index, qvar2_index) appears several
   * times, the sum of all of the associated coefficients will be applied.
   * </pre>
   *
   * <code>repeated int32 qvar1_index = 3;</code>
   * @return The count of qvar1Index.
   */
  public int getQvar1IndexCount() {
    return qvar1Index_.size();
  }
  /**
   * <pre>
   * Sparse representation of quadratic terms in the quadratic constraint, where
   * term i is qvar1_index[i] * qvar2_index[i] * qcoefficient[i].
   * `qvar1_index` and `qvar2_index` are variable indices w.r.t the "variable"
   * field in MPModelProto.
   * `qvar1_index`, `qvar2_index` and `coefficients` must have the same size.
   * If the same unordered pair (qvar1_index, qvar2_index) appears several
   * times, the sum of all of the associated coefficients will be applied.
   * </pre>
   *
   * <code>repeated int32 qvar1_index = 3;</code>
   * @param index The index of the element to return.
   * @return The qvar1Index at the given index.
   */
  public int getQvar1Index(int index) {
    return qvar1Index_.getInt(index);
  }

  public static final int QVAR2_INDEX_FIELD_NUMBER = 4;
  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.IntList qvar2Index_ =
      emptyIntList();
  /**
   * <code>repeated int32 qvar2_index = 4;</code>
   * @return A list containing the qvar2Index.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer>
      getQvar2IndexList() {
    return qvar2Index_;
  }
  /**
   * <code>repeated int32 qvar2_index = 4;</code>
   * @return The count of qvar2Index.
   */
  public int getQvar2IndexCount() {
    return qvar2Index_.size();
  }
  /**
   * <code>repeated int32 qvar2_index = 4;</code>
   * @param index The index of the element to return.
   * @return The qvar2Index at the given index.
   */
  public int getQvar2Index(int index) {
    return qvar2Index_.getInt(index);
  }

  public static final int QCOEFFICIENT_FIELD_NUMBER = 5;
  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.DoubleList qcoefficient_ =
      emptyDoubleList();
  /**
   * <pre>
   * Must be finite.
   * </pre>
   *
   * <code>repeated double qcoefficient = 5;</code>
   * @return A list containing the qcoefficient.
   */
  @java.lang.Override
  public java.util.List<java.lang.Double>
      getQcoefficientList() {
    return qcoefficient_;
  }
  /**
   * <pre>
   * Must be finite.
   * </pre>
   *
   * <code>repeated double qcoefficient = 5;</code>
   * @return The count of qcoefficient.
   */
  public int getQcoefficientCount() {
    return qcoefficient_.size();
  }
  /**
   * <pre>
   * Must be finite.
   * </pre>
   *
   * <code>repeated double qcoefficient = 5;</code>
   * @param index The index of the element to return.
   * @return The qcoefficient at the given index.
   */
  public double getQcoefficient(int index) {
    return qcoefficient_.getDouble(index);
  }

  public static final int LOWER_BOUND_FIELD_NUMBER = 6;
  private double lowerBound_ = Double.NEGATIVE_INFINITY;
  /**
   * <pre>
   * lower_bound must be &lt;= upper_bound.
   * </pre>
   *
   * <code>optional double lower_bound = 6 [default = -inf];</code>
   * @return Whether the lowerBound field is set.
   */
  @java.lang.Override
  public boolean hasLowerBound() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * lower_bound must be &lt;= upper_bound.
   * </pre>
   *
   * <code>optional double lower_bound = 6 [default = -inf];</code>
   * @return The lowerBound.
   */
  @java.lang.Override
  public double getLowerBound() {
    return lowerBound_;
  }

  public static final int UPPER_BOUND_FIELD_NUMBER = 7;
  private double upperBound_ = Double.POSITIVE_INFINITY;
  /**
   * <code>optional double upper_bound = 7 [default = inf];</code>
   * @return Whether the upperBound field is set.
   */
  @java.lang.Override
  public boolean hasUpperBound() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <code>optional double upper_bound = 7 [default = inf];</code>
   * @return The upperBound.
   */
  @java.lang.Override
  public double getUpperBound() {
    return upperBound_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    for (int i = 0; i < varIndex_.size(); i++) {
      output.writeInt32(1, varIndex_.getInt(i));
    }
    for (int i = 0; i < coefficient_.size(); i++) {
      output.writeDouble(2, coefficient_.getDouble(i));
    }
    for (int i = 0; i < qvar1Index_.size(); i++) {
      output.writeInt32(3, qvar1Index_.getInt(i));
    }
    for (int i = 0; i < qvar2Index_.size(); i++) {
      output.writeInt32(4, qvar2Index_.getInt(i));
    }
    for (int i = 0; i < qcoefficient_.size(); i++) {
      output.writeDouble(5, qcoefficient_.getDouble(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeDouble(6, lowerBound_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeDouble(7, upperBound_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < varIndex_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeInt32SizeNoTag(varIndex_.getInt(i));
      }
      size += dataSize;
      size += 1 * getVarIndexList().size();
    }
    {
      int dataSize = 0;
      dataSize = 8 * getCoefficientList().size();
      size += dataSize;
      size += 1 * getCoefficientList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < qvar1Index_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeInt32SizeNoTag(qvar1Index_.getInt(i));
      }
      size += dataSize;
      size += 1 * getQvar1IndexList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < qvar2Index_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeInt32SizeNoTag(qvar2Index_.getInt(i));
      }
      size += dataSize;
      size += 1 * getQvar2IndexList().size();
    }
    {
      int dataSize = 0;
      dataSize = 8 * getQcoefficientList().size();
      size += dataSize;
      size += 1 * getQcoefficientList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(6, lowerBound_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(7, upperBound_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ortools.linearsolver.MPQuadraticConstraint)) {
      return super.equals(obj);
    }
    com.google.ortools.linearsolver.MPQuadraticConstraint other = (com.google.ortools.linearsolver.MPQuadraticConstraint) obj;

    if (!getVarIndexList()
        .equals(other.getVarIndexList())) return false;
    if (!getCoefficientList()
        .equals(other.getCoefficientList())) return false;
    if (!getQvar1IndexList()
        .equals(other.getQvar1IndexList())) return false;
    if (!getQvar2IndexList()
        .equals(other.getQvar2IndexList())) return false;
    if (!getQcoefficientList()
        .equals(other.getQcoefficientList())) return false;
    if (hasLowerBound() != other.hasLowerBound()) return false;
    if (hasLowerBound()) {
      if (java.lang.Double.doubleToLongBits(getLowerBound())
          != java.lang.Double.doubleToLongBits(
              other.getLowerBound())) return false;
    }
    if (hasUpperBound() != other.hasUpperBound()) return false;
    if (hasUpperBound()) {
      if (java.lang.Double.doubleToLongBits(getUpperBound())
          != java.lang.Double.doubleToLongBits(
              other.getUpperBound())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getVarIndexCount() > 0) {
      hash = (37 * hash) + VAR_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getVarIndexList().hashCode();
    }
    if (getCoefficientCount() > 0) {
      hash = (37 * hash) + COEFFICIENT_FIELD_NUMBER;
      hash = (53 * hash) + getCoefficientList().hashCode();
    }
    if (getQvar1IndexCount() > 0) {
      hash = (37 * hash) + QVAR1_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getQvar1IndexList().hashCode();
    }
    if (getQvar2IndexCount() > 0) {
      hash = (37 * hash) + QVAR2_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getQvar2IndexList().hashCode();
    }
    if (getQcoefficientCount() > 0) {
      hash = (37 * hash) + QCOEFFICIENT_FIELD_NUMBER;
      hash = (53 * hash) + getQcoefficientList().hashCode();
    }
    if (hasLowerBound()) {
      hash = (37 * hash) + LOWER_BOUND_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getLowerBound()));
    }
    if (hasUpperBound()) {
      hash = (37 * hash) + UPPER_BOUND_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getUpperBound()));
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ortools.linearsolver.MPQuadraticConstraint parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.linearsolver.MPQuadraticConstraint parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.linearsolver.MPQuadraticConstraint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.linearsolver.MPQuadraticConstraint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.linearsolver.MPQuadraticConstraint parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.linearsolver.MPQuadraticConstraint parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.linearsolver.MPQuadraticConstraint parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.linearsolver.MPQuadraticConstraint parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ortools.linearsolver.MPQuadraticConstraint parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ortools.linearsolver.MPQuadraticConstraint parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ortools.linearsolver.MPQuadraticConstraint parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.linearsolver.MPQuadraticConstraint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ortools.linearsolver.MPQuadraticConstraint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Quadratic constraints of the form lb &lt;= sum a_i x_i + sum b_ij x_i x_j &lt;= ub,
   * where a, b, lb and ub are constants, and x are the model's variables.
   * Quadratic matrices that are Positive Semi-Definite, Second-Order Cones or
   * rotated Second-Order Cones are always accepted. Other forms may or may not be
   * accepted depending on the underlying solver used.
   * See https://scip.zib.de/doc/html/cons__quadratic_8h.php and
   * https://www.gurobi.com/documentation/9.0/refman/constraints.html#subsubsection:QuadraticConstraints
   * </pre>
   *
   * Protobuf type {@code operations_research.MPQuadraticConstraint}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessage.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:operations_research.MPQuadraticConstraint)
      com.google.ortools.linearsolver.MPQuadraticConstraintOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ortools.linearsolver.LinearSolver.internal_static_operations_research_MPQuadraticConstraint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ortools.linearsolver.LinearSolver.internal_static_operations_research_MPQuadraticConstraint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ortools.linearsolver.MPQuadraticConstraint.class, com.google.ortools.linearsolver.MPQuadraticConstraint.Builder.class);
    }

    // Construct using com.google.ortools.linearsolver.MPQuadraticConstraint.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      varIndex_ = emptyIntList();
      coefficient_ = emptyDoubleList();
      qvar1Index_ = emptyIntList();
      qvar2Index_ = emptyIntList();
      qcoefficient_ = emptyDoubleList();
      lowerBound_ = Double.NEGATIVE_INFINITY;
      upperBound_ = Double.POSITIVE_INFINITY;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ortools.linearsolver.LinearSolver.internal_static_operations_research_MPQuadraticConstraint_descriptor;
    }

    @java.lang.Override
    public com.google.ortools.linearsolver.MPQuadraticConstraint getDefaultInstanceForType() {
      return com.google.ortools.linearsolver.MPQuadraticConstraint.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ortools.linearsolver.MPQuadraticConstraint build() {
      com.google.ortools.linearsolver.MPQuadraticConstraint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ortools.linearsolver.MPQuadraticConstraint buildPartial() {
      com.google.ortools.linearsolver.MPQuadraticConstraint result = new com.google.ortools.linearsolver.MPQuadraticConstraint(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.ortools.linearsolver.MPQuadraticConstraint result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        varIndex_.makeImmutable();
        result.varIndex_ = varIndex_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        coefficient_.makeImmutable();
        result.coefficient_ = coefficient_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        qvar1Index_.makeImmutable();
        result.qvar1Index_ = qvar1Index_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        qvar2Index_.makeImmutable();
        result.qvar2Index_ = qvar2Index_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        qcoefficient_.makeImmutable();
        result.qcoefficient_ = qcoefficient_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.lowerBound_ = lowerBound_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.upperBound_ = upperBound_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ortools.linearsolver.MPQuadraticConstraint) {
        return mergeFrom((com.google.ortools.linearsolver.MPQuadraticConstraint)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ortools.linearsolver.MPQuadraticConstraint other) {
      if (other == com.google.ortools.linearsolver.MPQuadraticConstraint.getDefaultInstance()) return this;
      if (!other.varIndex_.isEmpty()) {
        if (varIndex_.isEmpty()) {
          varIndex_ = other.varIndex_;
          varIndex_.makeImmutable();
          bitField0_ |= 0x00000001;
        } else {
          ensureVarIndexIsMutable();
          varIndex_.addAll(other.varIndex_);
        }
        onChanged();
      }
      if (!other.coefficient_.isEmpty()) {
        if (coefficient_.isEmpty()) {
          coefficient_ = other.coefficient_;
          coefficient_.makeImmutable();
          bitField0_ |= 0x00000002;
        } else {
          ensureCoefficientIsMutable();
          coefficient_.addAll(other.coefficient_);
        }
        onChanged();
      }
      if (!other.qvar1Index_.isEmpty()) {
        if (qvar1Index_.isEmpty()) {
          qvar1Index_ = other.qvar1Index_;
          qvar1Index_.makeImmutable();
          bitField0_ |= 0x00000004;
        } else {
          ensureQvar1IndexIsMutable();
          qvar1Index_.addAll(other.qvar1Index_);
        }
        onChanged();
      }
      if (!other.qvar2Index_.isEmpty()) {
        if (qvar2Index_.isEmpty()) {
          qvar2Index_ = other.qvar2Index_;
          qvar2Index_.makeImmutable();
          bitField0_ |= 0x00000008;
        } else {
          ensureQvar2IndexIsMutable();
          qvar2Index_.addAll(other.qvar2Index_);
        }
        onChanged();
      }
      if (!other.qcoefficient_.isEmpty()) {
        if (qcoefficient_.isEmpty()) {
          qcoefficient_ = other.qcoefficient_;
          qcoefficient_.makeImmutable();
          bitField0_ |= 0x00000010;
        } else {
          ensureQcoefficientIsMutable();
          qcoefficient_.addAll(other.qcoefficient_);
        }
        onChanged();
      }
      if (other.hasLowerBound()) {
        setLowerBound(other.getLowerBound());
      }
      if (other.hasUpperBound()) {
        setUpperBound(other.getUpperBound());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {
              int v = input.readInt32();
              ensureVarIndexIsMutable();
              varIndex_.addInt(v);
              break;
            } // case 8
            case 10: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              ensureVarIndexIsMutable();
              while (input.getBytesUntilLimit() > 0) {
                varIndex_.addInt(input.readInt32());
              }
              input.popLimit(limit);
              break;
            } // case 10
            case 17: {
              double v = input.readDouble();
              ensureCoefficientIsMutable();
              coefficient_.addDouble(v);
              break;
            } // case 17
            case 18: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              int alloc = length > 4096 ? 4096 : length;
              ensureCoefficientIsMutable(alloc / 8);
              while (input.getBytesUntilLimit() > 0) {
                coefficient_.addDouble(input.readDouble());
              }
              input.popLimit(limit);
              break;
            } // case 18
            case 24: {
              int v = input.readInt32();
              ensureQvar1IndexIsMutable();
              qvar1Index_.addInt(v);
              break;
            } // case 24
            case 26: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              ensureQvar1IndexIsMutable();
              while (input.getBytesUntilLimit() > 0) {
                qvar1Index_.addInt(input.readInt32());
              }
              input.popLimit(limit);
              break;
            } // case 26
            case 32: {
              int v = input.readInt32();
              ensureQvar2IndexIsMutable();
              qvar2Index_.addInt(v);
              break;
            } // case 32
            case 34: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              ensureQvar2IndexIsMutable();
              while (input.getBytesUntilLimit() > 0) {
                qvar2Index_.addInt(input.readInt32());
              }
              input.popLimit(limit);
              break;
            } // case 34
            case 41: {
              double v = input.readDouble();
              ensureQcoefficientIsMutable();
              qcoefficient_.addDouble(v);
              break;
            } // case 41
            case 42: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              int alloc = length > 4096 ? 4096 : length;
              ensureQcoefficientIsMutable(alloc / 8);
              while (input.getBytesUntilLimit() > 0) {
                qcoefficient_.addDouble(input.readDouble());
              }
              input.popLimit(limit);
              break;
            } // case 42
            case 49: {
              lowerBound_ = input.readDouble();
              bitField0_ |= 0x00000020;
              break;
            } // case 49
            case 57: {
              upperBound_ = input.readDouble();
              bitField0_ |= 0x00000040;
              break;
            } // case 57
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private com.google.protobuf.Internal.IntList varIndex_ = emptyIntList();
    private void ensureVarIndexIsMutable() {
      if (!varIndex_.isModifiable()) {
        varIndex_ = makeMutableCopy(varIndex_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     * <pre>
     * Sparse representation of linear terms in the quadratic constraint, where
     * term i is var_index[i] * coefficient[i].
     * `var_index` are variable indices w.r.t the "variable" field in
     * MPModelProto, and should be unique.
     * </pre>
     *
     * <code>repeated int32 var_index = 1;</code>
     * @return A list containing the varIndex.
     */
    public java.util.List<java.lang.Integer>
        getVarIndexList() {
      varIndex_.makeImmutable();
      return varIndex_;
    }
    /**
     * <pre>
     * Sparse representation of linear terms in the quadratic constraint, where
     * term i is var_index[i] * coefficient[i].
     * `var_index` are variable indices w.r.t the "variable" field in
     * MPModelProto, and should be unique.
     * </pre>
     *
     * <code>repeated int32 var_index = 1;</code>
     * @return The count of varIndex.
     */
    public int getVarIndexCount() {
      return varIndex_.size();
    }
    /**
     * <pre>
     * Sparse representation of linear terms in the quadratic constraint, where
     * term i is var_index[i] * coefficient[i].
     * `var_index` are variable indices w.r.t the "variable" field in
     * MPModelProto, and should be unique.
     * </pre>
     *
     * <code>repeated int32 var_index = 1;</code>
     * @param index The index of the element to return.
     * @return The varIndex at the given index.
     */
    public int getVarIndex(int index) {
      return varIndex_.getInt(index);
    }
    /**
     * <pre>
     * Sparse representation of linear terms in the quadratic constraint, where
     * term i is var_index[i] * coefficient[i].
     * `var_index` are variable indices w.r.t the "variable" field in
     * MPModelProto, and should be unique.
     * </pre>
     *
     * <code>repeated int32 var_index = 1;</code>
     * @param index The index to set the value at.
     * @param value The varIndex to set.
     * @return This builder for chaining.
     */
    public Builder setVarIndex(
        int index, int value) {

      ensureVarIndexIsMutable();
      varIndex_.setInt(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Sparse representation of linear terms in the quadratic constraint, where
     * term i is var_index[i] * coefficient[i].
     * `var_index` are variable indices w.r.t the "variable" field in
     * MPModelProto, and should be unique.
     * </pre>
     *
     * <code>repeated int32 var_index = 1;</code>
     * @param value The varIndex to add.
     * @return This builder for chaining.
     */
    public Builder addVarIndex(int value) {

      ensureVarIndexIsMutable();
      varIndex_.addInt(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Sparse representation of linear terms in the quadratic constraint, where
     * term i is var_index[i] * coefficient[i].
     * `var_index` are variable indices w.r.t the "variable" field in
     * MPModelProto, and should be unique.
     * </pre>
     *
     * <code>repeated int32 var_index = 1;</code>
     * @param values The varIndex to add.
     * @return This builder for chaining.
     */
    public Builder addAllVarIndex(
        java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureVarIndexIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, varIndex_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Sparse representation of linear terms in the quadratic constraint, where
     * term i is var_index[i] * coefficient[i].
     * `var_index` are variable indices w.r.t the "variable" field in
     * MPModelProto, and should be unique.
     * </pre>
     *
     * <code>repeated int32 var_index = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearVarIndex() {
      varIndex_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.DoubleList coefficient_ = emptyDoubleList();
    private void ensureCoefficientIsMutable() {
      if (!coefficient_.isModifiable()) {
        coefficient_ = makeMutableCopy(coefficient_);
      }
      bitField0_ |= 0x00000002;
    }
    private void ensureCoefficientIsMutable(int capacity) {
      if (!coefficient_.isModifiable()) {
        coefficient_ = makeMutableCopy(coefficient_, capacity);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     * <pre>
     * Must be finite.
     * </pre>
     *
     * <code>repeated double coefficient = 2;</code>
     * @return A list containing the coefficient.
     */
    public java.util.List<java.lang.Double>
        getCoefficientList() {
      coefficient_.makeImmutable();
      return coefficient_;
    }
    /**
     * <pre>
     * Must be finite.
     * </pre>
     *
     * <code>repeated double coefficient = 2;</code>
     * @return The count of coefficient.
     */
    public int getCoefficientCount() {
      return coefficient_.size();
    }
    /**
     * <pre>
     * Must be finite.
     * </pre>
     *
     * <code>repeated double coefficient = 2;</code>
     * @param index The index of the element to return.
     * @return The coefficient at the given index.
     */
    public double getCoefficient(int index) {
      return coefficient_.getDouble(index);
    }
    /**
     * <pre>
     * Must be finite.
     * </pre>
     *
     * <code>repeated double coefficient = 2;</code>
     * @param index The index to set the value at.
     * @param value The coefficient to set.
     * @return This builder for chaining.
     */
    public Builder setCoefficient(
        int index, double value) {

      ensureCoefficientIsMutable();
      coefficient_.setDouble(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Must be finite.
     * </pre>
     *
     * <code>repeated double coefficient = 2;</code>
     * @param value The coefficient to add.
     * @return This builder for chaining.
     */
    public Builder addCoefficient(double value) {

      ensureCoefficientIsMutable();
      coefficient_.addDouble(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Must be finite.
     * </pre>
     *
     * <code>repeated double coefficient = 2;</code>
     * @param values The coefficient to add.
     * @return This builder for chaining.
     */
    public Builder addAllCoefficient(
        java.lang.Iterable<? extends java.lang.Double> values) {
      ensureCoefficientIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, coefficient_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Must be finite.
     * </pre>
     *
     * <code>repeated double coefficient = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearCoefficient() {
      coefficient_ = emptyDoubleList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.IntList qvar1Index_ = emptyIntList();
    private void ensureQvar1IndexIsMutable() {
      if (!qvar1Index_.isModifiable()) {
        qvar1Index_ = makeMutableCopy(qvar1Index_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     * <pre>
     * Sparse representation of quadratic terms in the quadratic constraint, where
     * term i is qvar1_index[i] * qvar2_index[i] * qcoefficient[i].
     * `qvar1_index` and `qvar2_index` are variable indices w.r.t the "variable"
     * field in MPModelProto.
     * `qvar1_index`, `qvar2_index` and `coefficients` must have the same size.
     * If the same unordered pair (qvar1_index, qvar2_index) appears several
     * times, the sum of all of the associated coefficients will be applied.
     * </pre>
     *
     * <code>repeated int32 qvar1_index = 3;</code>
     * @return A list containing the qvar1Index.
     */
    public java.util.List<java.lang.Integer>
        getQvar1IndexList() {
      qvar1Index_.makeImmutable();
      return qvar1Index_;
    }
    /**
     * <pre>
     * Sparse representation of quadratic terms in the quadratic constraint, where
     * term i is qvar1_index[i] * qvar2_index[i] * qcoefficient[i].
     * `qvar1_index` and `qvar2_index` are variable indices w.r.t the "variable"
     * field in MPModelProto.
     * `qvar1_index`, `qvar2_index` and `coefficients` must have the same size.
     * If the same unordered pair (qvar1_index, qvar2_index) appears several
     * times, the sum of all of the associated coefficients will be applied.
     * </pre>
     *
     * <code>repeated int32 qvar1_index = 3;</code>
     * @return The count of qvar1Index.
     */
    public int getQvar1IndexCount() {
      return qvar1Index_.size();
    }
    /**
     * <pre>
     * Sparse representation of quadratic terms in the quadratic constraint, where
     * term i is qvar1_index[i] * qvar2_index[i] * qcoefficient[i].
     * `qvar1_index` and `qvar2_index` are variable indices w.r.t the "variable"
     * field in MPModelProto.
     * `qvar1_index`, `qvar2_index` and `coefficients` must have the same size.
     * If the same unordered pair (qvar1_index, qvar2_index) appears several
     * times, the sum of all of the associated coefficients will be applied.
     * </pre>
     *
     * <code>repeated int32 qvar1_index = 3;</code>
     * @param index The index of the element to return.
     * @return The qvar1Index at the given index.
     */
    public int getQvar1Index(int index) {
      return qvar1Index_.getInt(index);
    }
    /**
     * <pre>
     * Sparse representation of quadratic terms in the quadratic constraint, where
     * term i is qvar1_index[i] * qvar2_index[i] * qcoefficient[i].
     * `qvar1_index` and `qvar2_index` are variable indices w.r.t the "variable"
     * field in MPModelProto.
     * `qvar1_index`, `qvar2_index` and `coefficients` must have the same size.
     * If the same unordered pair (qvar1_index, qvar2_index) appears several
     * times, the sum of all of the associated coefficients will be applied.
     * </pre>
     *
     * <code>repeated int32 qvar1_index = 3;</code>
     * @param index The index to set the value at.
     * @param value The qvar1Index to set.
     * @return This builder for chaining.
     */
    public Builder setQvar1Index(
        int index, int value) {

      ensureQvar1IndexIsMutable();
      qvar1Index_.setInt(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Sparse representation of quadratic terms in the quadratic constraint, where
     * term i is qvar1_index[i] * qvar2_index[i] * qcoefficient[i].
     * `qvar1_index` and `qvar2_index` are variable indices w.r.t the "variable"
     * field in MPModelProto.
     * `qvar1_index`, `qvar2_index` and `coefficients` must have the same size.
     * If the same unordered pair (qvar1_index, qvar2_index) appears several
     * times, the sum of all of the associated coefficients will be applied.
     * </pre>
     *
     * <code>repeated int32 qvar1_index = 3;</code>
     * @param value The qvar1Index to add.
     * @return This builder for chaining.
     */
    public Builder addQvar1Index(int value) {

      ensureQvar1IndexIsMutable();
      qvar1Index_.addInt(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Sparse representation of quadratic terms in the quadratic constraint, where
     * term i is qvar1_index[i] * qvar2_index[i] * qcoefficient[i].
     * `qvar1_index` and `qvar2_index` are variable indices w.r.t the "variable"
     * field in MPModelProto.
     * `qvar1_index`, `qvar2_index` and `coefficients` must have the same size.
     * If the same unordered pair (qvar1_index, qvar2_index) appears several
     * times, the sum of all of the associated coefficients will be applied.
     * </pre>
     *
     * <code>repeated int32 qvar1_index = 3;</code>
     * @param values The qvar1Index to add.
     * @return This builder for chaining.
     */
    public Builder addAllQvar1Index(
        java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureQvar1IndexIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, qvar1Index_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Sparse representation of quadratic terms in the quadratic constraint, where
     * term i is qvar1_index[i] * qvar2_index[i] * qcoefficient[i].
     * `qvar1_index` and `qvar2_index` are variable indices w.r.t the "variable"
     * field in MPModelProto.
     * `qvar1_index`, `qvar2_index` and `coefficients` must have the same size.
     * If the same unordered pair (qvar1_index, qvar2_index) appears several
     * times, the sum of all of the associated coefficients will be applied.
     * </pre>
     *
     * <code>repeated int32 qvar1_index = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearQvar1Index() {
      qvar1Index_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.IntList qvar2Index_ = emptyIntList();
    private void ensureQvar2IndexIsMutable() {
      if (!qvar2Index_.isModifiable()) {
        qvar2Index_ = makeMutableCopy(qvar2Index_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     * <code>repeated int32 qvar2_index = 4;</code>
     * @return A list containing the qvar2Index.
     */
    public java.util.List<java.lang.Integer>
        getQvar2IndexList() {
      qvar2Index_.makeImmutable();
      return qvar2Index_;
    }
    /**
     * <code>repeated int32 qvar2_index = 4;</code>
     * @return The count of qvar2Index.
     */
    public int getQvar2IndexCount() {
      return qvar2Index_.size();
    }
    /**
     * <code>repeated int32 qvar2_index = 4;</code>
     * @param index The index of the element to return.
     * @return The qvar2Index at the given index.
     */
    public int getQvar2Index(int index) {
      return qvar2Index_.getInt(index);
    }
    /**
     * <code>repeated int32 qvar2_index = 4;</code>
     * @param index The index to set the value at.
     * @param value The qvar2Index to set.
     * @return This builder for chaining.
     */
    public Builder setQvar2Index(
        int index, int value) {

      ensureQvar2IndexIsMutable();
      qvar2Index_.setInt(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <code>repeated int32 qvar2_index = 4;</code>
     * @param value The qvar2Index to add.
     * @return This builder for chaining.
     */
    public Builder addQvar2Index(int value) {

      ensureQvar2IndexIsMutable();
      qvar2Index_.addInt(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <code>repeated int32 qvar2_index = 4;</code>
     * @param values The qvar2Index to add.
     * @return This builder for chaining.
     */
    public Builder addAllQvar2Index(
        java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureQvar2IndexIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, qvar2Index_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <code>repeated int32 qvar2_index = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearQvar2Index() {
      qvar2Index_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.DoubleList qcoefficient_ = emptyDoubleList();
    private void ensureQcoefficientIsMutable() {
      if (!qcoefficient_.isModifiable()) {
        qcoefficient_ = makeMutableCopy(qcoefficient_);
      }
      bitField0_ |= 0x00000010;
    }
    private void ensureQcoefficientIsMutable(int capacity) {
      if (!qcoefficient_.isModifiable()) {
        qcoefficient_ = makeMutableCopy(qcoefficient_, capacity);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     * <pre>
     * Must be finite.
     * </pre>
     *
     * <code>repeated double qcoefficient = 5;</code>
     * @return A list containing the qcoefficient.
     */
    public java.util.List<java.lang.Double>
        getQcoefficientList() {
      qcoefficient_.makeImmutable();
      return qcoefficient_;
    }
    /**
     * <pre>
     * Must be finite.
     * </pre>
     *
     * <code>repeated double qcoefficient = 5;</code>
     * @return The count of qcoefficient.
     */
    public int getQcoefficientCount() {
      return qcoefficient_.size();
    }
    /**
     * <pre>
     * Must be finite.
     * </pre>
     *
     * <code>repeated double qcoefficient = 5;</code>
     * @param index The index of the element to return.
     * @return The qcoefficient at the given index.
     */
    public double getQcoefficient(int index) {
      return qcoefficient_.getDouble(index);
    }
    /**
     * <pre>
     * Must be finite.
     * </pre>
     *
     * <code>repeated double qcoefficient = 5;</code>
     * @param index The index to set the value at.
     * @param value The qcoefficient to set.
     * @return This builder for chaining.
     */
    public Builder setQcoefficient(
        int index, double value) {

      ensureQcoefficientIsMutable();
      qcoefficient_.setDouble(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Must be finite.
     * </pre>
     *
     * <code>repeated double qcoefficient = 5;</code>
     * @param value The qcoefficient to add.
     * @return This builder for chaining.
     */
    public Builder addQcoefficient(double value) {

      ensureQcoefficientIsMutable();
      qcoefficient_.addDouble(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Must be finite.
     * </pre>
     *
     * <code>repeated double qcoefficient = 5;</code>
     * @param values The qcoefficient to add.
     * @return This builder for chaining.
     */
    public Builder addAllQcoefficient(
        java.lang.Iterable<? extends java.lang.Double> values) {
      ensureQcoefficientIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, qcoefficient_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Must be finite.
     * </pre>
     *
     * <code>repeated double qcoefficient = 5;</code>
     * @return This builder for chaining.
     */
    public Builder clearQcoefficient() {
      qcoefficient_ = emptyDoubleList();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    private double lowerBound_ = Double.NEGATIVE_INFINITY;
    /**
     * <pre>
     * lower_bound must be &lt;= upper_bound.
     * </pre>
     *
     * <code>optional double lower_bound = 6 [default = -inf];</code>
     * @return Whether the lowerBound field is set.
     */
    @java.lang.Override
    public boolean hasLowerBound() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * lower_bound must be &lt;= upper_bound.
     * </pre>
     *
     * <code>optional double lower_bound = 6 [default = -inf];</code>
     * @return The lowerBound.
     */
    @java.lang.Override
    public double getLowerBound() {
      return lowerBound_;
    }
    /**
     * <pre>
     * lower_bound must be &lt;= upper_bound.
     * </pre>
     *
     * <code>optional double lower_bound = 6 [default = -inf];</code>
     * @param value The lowerBound to set.
     * @return This builder for chaining.
     */
    public Builder setLowerBound(double value) {

      lowerBound_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * lower_bound must be &lt;= upper_bound.
     * </pre>
     *
     * <code>optional double lower_bound = 6 [default = -inf];</code>
     * @return This builder for chaining.
     */
    public Builder clearLowerBound() {
      bitField0_ = (bitField0_ & ~0x00000020);
      lowerBound_ = Double.NEGATIVE_INFINITY;
      onChanged();
      return this;
    }

    private double upperBound_ = Double.POSITIVE_INFINITY;
    /**
     * <code>optional double upper_bound = 7 [default = inf];</code>
     * @return Whether the upperBound field is set.
     */
    @java.lang.Override
    public boolean hasUpperBound() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <code>optional double upper_bound = 7 [default = inf];</code>
     * @return The upperBound.
     */
    @java.lang.Override
    public double getUpperBound() {
      return upperBound_;
    }
    /**
     * <code>optional double upper_bound = 7 [default = inf];</code>
     * @param value The upperBound to set.
     * @return This builder for chaining.
     */
    public Builder setUpperBound(double value) {

      upperBound_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <code>optional double upper_bound = 7 [default = inf];</code>
     * @return This builder for chaining.
     */
    public Builder clearUpperBound() {
      bitField0_ = (bitField0_ & ~0x00000040);
      upperBound_ = Double.POSITIVE_INFINITY;
      onChanged();
      return this;
    }

    // @@protoc_insertion_point(builder_scope:operations_research.MPQuadraticConstraint)
  }

  // @@protoc_insertion_point(class_scope:operations_research.MPQuadraticConstraint)
  private static final com.google.ortools.linearsolver.MPQuadraticConstraint DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ortools.linearsolver.MPQuadraticConstraint();
  }

  public static com.google.ortools.linearsolver.MPQuadraticConstraint getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MPQuadraticConstraint>
      PARSER = new com.google.protobuf.AbstractParser<MPQuadraticConstraint>() {
    @java.lang.Override
    public MPQuadraticConstraint parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<MPQuadraticConstraint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MPQuadraticConstraint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ortools.linearsolver.MPQuadraticConstraint getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

