// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: ortools/linear_solver/linear_solver.proto

// Protobuf Java Version: 4.26.1
package com.google.ortools.linearsolver;

/**
 * <pre>
 * Special Ordered Set (SOS) constraints of type 1 or 2.
 * See https://en.wikipedia.org/wiki/Special_ordered_set
 * As of 2019/04, only SCIP and Gurobi support this constraint type.
 * </pre>
 *
 * Protobuf type {@code operations_research.MPSosConstraint}
 */
public final class MPSosConstraint extends
    com.google.protobuf.GeneratedMessage implements
    // @@protoc_insertion_point(message_implements:operations_research.MPSosConstraint)
    MPSosConstraintOrBuilder {
private static final long serialVersionUID = 0L;
  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
      com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
      /* major= */ 4,
      /* minor= */ 26,
      /* patch= */ 1,
      /* suffix= */ "",
      MPSosConstraint.class.getName());
  }
  // Use MPSosConstraint.newBuilder() to construct.
  private MPSosConstraint(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }
  private MPSosConstraint() {
    type_ = 0;
    varIndex_ = emptyIntList();
    weight_ = emptyDoubleList();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ortools.linearsolver.LinearSolver.internal_static_operations_research_MPSosConstraint_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ortools.linearsolver.LinearSolver.internal_static_operations_research_MPSosConstraint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ortools.linearsolver.MPSosConstraint.class, com.google.ortools.linearsolver.MPSosConstraint.Builder.class);
  }

  /**
   * Protobuf enum {@code operations_research.MPSosConstraint.Type}
   */
  public enum Type
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * At most one variable in `var_index` must be non-zero.
     * </pre>
     *
     * <code>SOS1_DEFAULT = 0;</code>
     */
    SOS1_DEFAULT(0),
    /**
     * <pre>
     * At most two consecutive variables from `var_index` can be non-zero (i.e.
     * for some i, var_index[i] and var_index[i+1]). See
     * https://en.wikipedia.org/wiki/Special_ordered_set#Types_of_SOS
     * </pre>
     *
     * <code>SOS2 = 1;</code>
     */
    SOS2(1),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 26,
        /* patch= */ 1,
        /* suffix= */ "",
        Type.class.getName());
    }
    /**
     * <pre>
     * At most one variable in `var_index` must be non-zero.
     * </pre>
     *
     * <code>SOS1_DEFAULT = 0;</code>
     */
    public static final int SOS1_DEFAULT_VALUE = 0;
    /**
     * <pre>
     * At most two consecutive variables from `var_index` can be non-zero (i.e.
     * for some i, var_index[i] and var_index[i+1]). See
     * https://en.wikipedia.org/wiki/Special_ordered_set#Types_of_SOS
     * </pre>
     *
     * <code>SOS2 = 1;</code>
     */
    public static final int SOS2_VALUE = 1;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0: return SOS1_DEFAULT;
        case 1: return SOS2;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        Type> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Type>() {
            public Type findValueByNumber(int number) {
              return Type.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.linearsolver.MPSosConstraint.getDescriptor().getEnumTypes().get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.MPSosConstraint.Type)
  }

  private int bitField0_;
  public static final int TYPE_FIELD_NUMBER = 1;
  private int type_ = 0;
  /**
   * <code>optional .operations_research.MPSosConstraint.Type type = 1 [default = SOS1_DEFAULT];</code>
   * @return Whether the type field is set.
   */
  @java.lang.Override public boolean hasType() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <code>optional .operations_research.MPSosConstraint.Type type = 1 [default = SOS1_DEFAULT];</code>
   * @return The type.
   */
  @java.lang.Override public com.google.ortools.linearsolver.MPSosConstraint.Type getType() {
    com.google.ortools.linearsolver.MPSosConstraint.Type result = com.google.ortools.linearsolver.MPSosConstraint.Type.forNumber(type_);
    return result == null ? com.google.ortools.linearsolver.MPSosConstraint.Type.SOS1_DEFAULT : result;
  }

  public static final int VAR_INDEX_FIELD_NUMBER = 2;
  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.IntList varIndex_ =
      emptyIntList();
  /**
   * <pre>
   * Variable index (w.r.t. the "variable" field of MPModelProto) of the
   * variables in the SOS.
   * </pre>
   *
   * <code>repeated int32 var_index = 2;</code>
   * @return A list containing the varIndex.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer>
      getVarIndexList() {
    return varIndex_;
  }
  /**
   * <pre>
   * Variable index (w.r.t. the "variable" field of MPModelProto) of the
   * variables in the SOS.
   * </pre>
   *
   * <code>repeated int32 var_index = 2;</code>
   * @return The count of varIndex.
   */
  public int getVarIndexCount() {
    return varIndex_.size();
  }
  /**
   * <pre>
   * Variable index (w.r.t. the "variable" field of MPModelProto) of the
   * variables in the SOS.
   * </pre>
   *
   * <code>repeated int32 var_index = 2;</code>
   * @param index The index of the element to return.
   * @return The varIndex at the given index.
   */
  public int getVarIndex(int index) {
    return varIndex_.getInt(index);
  }

  public static final int WEIGHT_FIELD_NUMBER = 3;
  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.DoubleList weight_ =
      emptyDoubleList();
  /**
   * <pre>
   * Optional: SOS weights. If non-empty, must be of the same size as
   * "var_index", and strictly increasing. If empty and required by the
   * underlying solver, the 1..n sequence will be given as weights.
   * SUBTLE: The weights can help the solver make branch-and-bound decisions
   * that fit the underlying optimization model: after each LP relaxation, it
   * will compute the "average weight" of the SOS variables, weighted by value
   * (this is confusing: here we're using the values as weights), and the binary
   * branch decision will be: is the non-zero variable above or below that?
   * (weights are strictly monotonous, so the "cutoff" average weight
   * corresponds to a "cutoff" index in the var_index sequence).
   * </pre>
   *
   * <code>repeated double weight = 3;</code>
   * @return A list containing the weight.
   */
  @java.lang.Override
  public java.util.List<java.lang.Double>
      getWeightList() {
    return weight_;
  }
  /**
   * <pre>
   * Optional: SOS weights. If non-empty, must be of the same size as
   * "var_index", and strictly increasing. If empty and required by the
   * underlying solver, the 1..n sequence will be given as weights.
   * SUBTLE: The weights can help the solver make branch-and-bound decisions
   * that fit the underlying optimization model: after each LP relaxation, it
   * will compute the "average weight" of the SOS variables, weighted by value
   * (this is confusing: here we're using the values as weights), and the binary
   * branch decision will be: is the non-zero variable above or below that?
   * (weights are strictly monotonous, so the "cutoff" average weight
   * corresponds to a "cutoff" index in the var_index sequence).
   * </pre>
   *
   * <code>repeated double weight = 3;</code>
   * @return The count of weight.
   */
  public int getWeightCount() {
    return weight_.size();
  }
  /**
   * <pre>
   * Optional: SOS weights. If non-empty, must be of the same size as
   * "var_index", and strictly increasing. If empty and required by the
   * underlying solver, the 1..n sequence will be given as weights.
   * SUBTLE: The weights can help the solver make branch-and-bound decisions
   * that fit the underlying optimization model: after each LP relaxation, it
   * will compute the "average weight" of the SOS variables, weighted by value
   * (this is confusing: here we're using the values as weights), and the binary
   * branch decision will be: is the non-zero variable above or below that?
   * (weights are strictly monotonous, so the "cutoff" average weight
   * corresponds to a "cutoff" index in the var_index sequence).
   * </pre>
   *
   * <code>repeated double weight = 3;</code>
   * @param index The index of the element to return.
   * @return The weight at the given index.
   */
  public double getWeight(int index) {
    return weight_.getDouble(index);
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeEnum(1, type_);
    }
    for (int i = 0; i < varIndex_.size(); i++) {
      output.writeInt32(2, varIndex_.getInt(i));
    }
    for (int i = 0; i < weight_.size(); i++) {
      output.writeDouble(3, weight_.getDouble(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(1, type_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < varIndex_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeInt32SizeNoTag(varIndex_.getInt(i));
      }
      size += dataSize;
      size += 1 * getVarIndexList().size();
    }
    {
      int dataSize = 0;
      dataSize = 8 * getWeightList().size();
      size += dataSize;
      size += 1 * getWeightList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ortools.linearsolver.MPSosConstraint)) {
      return super.equals(obj);
    }
    com.google.ortools.linearsolver.MPSosConstraint other = (com.google.ortools.linearsolver.MPSosConstraint) obj;

    if (hasType() != other.hasType()) return false;
    if (hasType()) {
      if (type_ != other.type_) return false;
    }
    if (!getVarIndexList()
        .equals(other.getVarIndexList())) return false;
    if (!getWeightList()
        .equals(other.getWeightList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasType()) {
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
    }
    if (getVarIndexCount() > 0) {
      hash = (37 * hash) + VAR_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getVarIndexList().hashCode();
    }
    if (getWeightCount() > 0) {
      hash = (37 * hash) + WEIGHT_FIELD_NUMBER;
      hash = (53 * hash) + getWeightList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ortools.linearsolver.MPSosConstraint parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.linearsolver.MPSosConstraint parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.linearsolver.MPSosConstraint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.linearsolver.MPSosConstraint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.linearsolver.MPSosConstraint parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.linearsolver.MPSosConstraint parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.linearsolver.MPSosConstraint parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.linearsolver.MPSosConstraint parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ortools.linearsolver.MPSosConstraint parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ortools.linearsolver.MPSosConstraint parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ortools.linearsolver.MPSosConstraint parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.linearsolver.MPSosConstraint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ortools.linearsolver.MPSosConstraint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Special Ordered Set (SOS) constraints of type 1 or 2.
   * See https://en.wikipedia.org/wiki/Special_ordered_set
   * As of 2019/04, only SCIP and Gurobi support this constraint type.
   * </pre>
   *
   * Protobuf type {@code operations_research.MPSosConstraint}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessage.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:operations_research.MPSosConstraint)
      com.google.ortools.linearsolver.MPSosConstraintOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ortools.linearsolver.LinearSolver.internal_static_operations_research_MPSosConstraint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ortools.linearsolver.LinearSolver.internal_static_operations_research_MPSosConstraint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ortools.linearsolver.MPSosConstraint.class, com.google.ortools.linearsolver.MPSosConstraint.Builder.class);
    }

    // Construct using com.google.ortools.linearsolver.MPSosConstraint.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      type_ = 0;
      varIndex_ = emptyIntList();
      weight_ = emptyDoubleList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ortools.linearsolver.LinearSolver.internal_static_operations_research_MPSosConstraint_descriptor;
    }

    @java.lang.Override
    public com.google.ortools.linearsolver.MPSosConstraint getDefaultInstanceForType() {
      return com.google.ortools.linearsolver.MPSosConstraint.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ortools.linearsolver.MPSosConstraint build() {
      com.google.ortools.linearsolver.MPSosConstraint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ortools.linearsolver.MPSosConstraint buildPartial() {
      com.google.ortools.linearsolver.MPSosConstraint result = new com.google.ortools.linearsolver.MPSosConstraint(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.ortools.linearsolver.MPSosConstraint result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.type_ = type_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        varIndex_.makeImmutable();
        result.varIndex_ = varIndex_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        weight_.makeImmutable();
        result.weight_ = weight_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ortools.linearsolver.MPSosConstraint) {
        return mergeFrom((com.google.ortools.linearsolver.MPSosConstraint)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ortools.linearsolver.MPSosConstraint other) {
      if (other == com.google.ortools.linearsolver.MPSosConstraint.getDefaultInstance()) return this;
      if (other.hasType()) {
        setType(other.getType());
      }
      if (!other.varIndex_.isEmpty()) {
        if (varIndex_.isEmpty()) {
          varIndex_ = other.varIndex_;
          varIndex_.makeImmutable();
          bitField0_ |= 0x00000002;
        } else {
          ensureVarIndexIsMutable();
          varIndex_.addAll(other.varIndex_);
        }
        onChanged();
      }
      if (!other.weight_.isEmpty()) {
        if (weight_.isEmpty()) {
          weight_ = other.weight_;
          weight_.makeImmutable();
          bitField0_ |= 0x00000004;
        } else {
          ensureWeightIsMutable();
          weight_.addAll(other.weight_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {
              int tmpRaw = input.readEnum();
              com.google.ortools.linearsolver.MPSosConstraint.Type tmpValue =
                  com.google.ortools.linearsolver.MPSosConstraint.Type.forNumber(tmpRaw);
              if (tmpValue == null) {
                mergeUnknownVarintField(1, tmpRaw);
              } else {
                type_ = tmpRaw;
                bitField0_ |= 0x00000001;
              }
              break;
            } // case 8
            case 16: {
              int v = input.readInt32();
              ensureVarIndexIsMutable();
              varIndex_.addInt(v);
              break;
            } // case 16
            case 18: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              ensureVarIndexIsMutable();
              while (input.getBytesUntilLimit() > 0) {
                varIndex_.addInt(input.readInt32());
              }
              input.popLimit(limit);
              break;
            } // case 18
            case 25: {
              double v = input.readDouble();
              ensureWeightIsMutable();
              weight_.addDouble(v);
              break;
            } // case 25
            case 26: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              int alloc = length > 4096 ? 4096 : length;
              ensureWeightIsMutable(alloc / 8);
              while (input.getBytesUntilLimit() > 0) {
                weight_.addDouble(input.readDouble());
              }
              input.popLimit(limit);
              break;
            } // case 26
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private int type_ = 0;
    /**
     * <code>optional .operations_research.MPSosConstraint.Type type = 1 [default = SOS1_DEFAULT];</code>
     * @return Whether the type field is set.
     */
    @java.lang.Override public boolean hasType() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional .operations_research.MPSosConstraint.Type type = 1 [default = SOS1_DEFAULT];</code>
     * @return The type.
     */
    @java.lang.Override
    public com.google.ortools.linearsolver.MPSosConstraint.Type getType() {
      com.google.ortools.linearsolver.MPSosConstraint.Type result = com.google.ortools.linearsolver.MPSosConstraint.Type.forNumber(type_);
      return result == null ? com.google.ortools.linearsolver.MPSosConstraint.Type.SOS1_DEFAULT : result;
    }
    /**
     * <code>optional .operations_research.MPSosConstraint.Type type = 1 [default = SOS1_DEFAULT];</code>
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.ortools.linearsolver.MPSosConstraint.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.MPSosConstraint.Type type = 1 [default = SOS1_DEFAULT];</code>
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      type_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.IntList varIndex_ = emptyIntList();
    private void ensureVarIndexIsMutable() {
      if (!varIndex_.isModifiable()) {
        varIndex_ = makeMutableCopy(varIndex_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     * <pre>
     * Variable index (w.r.t. the "variable" field of MPModelProto) of the
     * variables in the SOS.
     * </pre>
     *
     * <code>repeated int32 var_index = 2;</code>
     * @return A list containing the varIndex.
     */
    public java.util.List<java.lang.Integer>
        getVarIndexList() {
      varIndex_.makeImmutable();
      return varIndex_;
    }
    /**
     * <pre>
     * Variable index (w.r.t. the "variable" field of MPModelProto) of the
     * variables in the SOS.
     * </pre>
     *
     * <code>repeated int32 var_index = 2;</code>
     * @return The count of varIndex.
     */
    public int getVarIndexCount() {
      return varIndex_.size();
    }
    /**
     * <pre>
     * Variable index (w.r.t. the "variable" field of MPModelProto) of the
     * variables in the SOS.
     * </pre>
     *
     * <code>repeated int32 var_index = 2;</code>
     * @param index The index of the element to return.
     * @return The varIndex at the given index.
     */
    public int getVarIndex(int index) {
      return varIndex_.getInt(index);
    }
    /**
     * <pre>
     * Variable index (w.r.t. the "variable" field of MPModelProto) of the
     * variables in the SOS.
     * </pre>
     *
     * <code>repeated int32 var_index = 2;</code>
     * @param index The index to set the value at.
     * @param value The varIndex to set.
     * @return This builder for chaining.
     */
    public Builder setVarIndex(
        int index, int value) {

      ensureVarIndexIsMutable();
      varIndex_.setInt(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Variable index (w.r.t. the "variable" field of MPModelProto) of the
     * variables in the SOS.
     * </pre>
     *
     * <code>repeated int32 var_index = 2;</code>
     * @param value The varIndex to add.
     * @return This builder for chaining.
     */
    public Builder addVarIndex(int value) {

      ensureVarIndexIsMutable();
      varIndex_.addInt(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Variable index (w.r.t. the "variable" field of MPModelProto) of the
     * variables in the SOS.
     * </pre>
     *
     * <code>repeated int32 var_index = 2;</code>
     * @param values The varIndex to add.
     * @return This builder for chaining.
     */
    public Builder addAllVarIndex(
        java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureVarIndexIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, varIndex_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Variable index (w.r.t. the "variable" field of MPModelProto) of the
     * variables in the SOS.
     * </pre>
     *
     * <code>repeated int32 var_index = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearVarIndex() {
      varIndex_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.DoubleList weight_ = emptyDoubleList();
    private void ensureWeightIsMutable() {
      if (!weight_.isModifiable()) {
        weight_ = makeMutableCopy(weight_);
      }
      bitField0_ |= 0x00000004;
    }
    private void ensureWeightIsMutable(int capacity) {
      if (!weight_.isModifiable()) {
        weight_ = makeMutableCopy(weight_, capacity);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     * <pre>
     * Optional: SOS weights. If non-empty, must be of the same size as
     * "var_index", and strictly increasing. If empty and required by the
     * underlying solver, the 1..n sequence will be given as weights.
     * SUBTLE: The weights can help the solver make branch-and-bound decisions
     * that fit the underlying optimization model: after each LP relaxation, it
     * will compute the "average weight" of the SOS variables, weighted by value
     * (this is confusing: here we're using the values as weights), and the binary
     * branch decision will be: is the non-zero variable above or below that?
     * (weights are strictly monotonous, so the "cutoff" average weight
     * corresponds to a "cutoff" index in the var_index sequence).
     * </pre>
     *
     * <code>repeated double weight = 3;</code>
     * @return A list containing the weight.
     */
    public java.util.List<java.lang.Double>
        getWeightList() {
      weight_.makeImmutable();
      return weight_;
    }
    /**
     * <pre>
     * Optional: SOS weights. If non-empty, must be of the same size as
     * "var_index", and strictly increasing. If empty and required by the
     * underlying solver, the 1..n sequence will be given as weights.
     * SUBTLE: The weights can help the solver make branch-and-bound decisions
     * that fit the underlying optimization model: after each LP relaxation, it
     * will compute the "average weight" of the SOS variables, weighted by value
     * (this is confusing: here we're using the values as weights), and the binary
     * branch decision will be: is the non-zero variable above or below that?
     * (weights are strictly monotonous, so the "cutoff" average weight
     * corresponds to a "cutoff" index in the var_index sequence).
     * </pre>
     *
     * <code>repeated double weight = 3;</code>
     * @return The count of weight.
     */
    public int getWeightCount() {
      return weight_.size();
    }
    /**
     * <pre>
     * Optional: SOS weights. If non-empty, must be of the same size as
     * "var_index", and strictly increasing. If empty and required by the
     * underlying solver, the 1..n sequence will be given as weights.
     * SUBTLE: The weights can help the solver make branch-and-bound decisions
     * that fit the underlying optimization model: after each LP relaxation, it
     * will compute the "average weight" of the SOS variables, weighted by value
     * (this is confusing: here we're using the values as weights), and the binary
     * branch decision will be: is the non-zero variable above or below that?
     * (weights are strictly monotonous, so the "cutoff" average weight
     * corresponds to a "cutoff" index in the var_index sequence).
     * </pre>
     *
     * <code>repeated double weight = 3;</code>
     * @param index The index of the element to return.
     * @return The weight at the given index.
     */
    public double getWeight(int index) {
      return weight_.getDouble(index);
    }
    /**
     * <pre>
     * Optional: SOS weights. If non-empty, must be of the same size as
     * "var_index", and strictly increasing. If empty and required by the
     * underlying solver, the 1..n sequence will be given as weights.
     * SUBTLE: The weights can help the solver make branch-and-bound decisions
     * that fit the underlying optimization model: after each LP relaxation, it
     * will compute the "average weight" of the SOS variables, weighted by value
     * (this is confusing: here we're using the values as weights), and the binary
     * branch decision will be: is the non-zero variable above or below that?
     * (weights are strictly monotonous, so the "cutoff" average weight
     * corresponds to a "cutoff" index in the var_index sequence).
     * </pre>
     *
     * <code>repeated double weight = 3;</code>
     * @param index The index to set the value at.
     * @param value The weight to set.
     * @return This builder for chaining.
     */
    public Builder setWeight(
        int index, double value) {

      ensureWeightIsMutable();
      weight_.setDouble(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional: SOS weights. If non-empty, must be of the same size as
     * "var_index", and strictly increasing. If empty and required by the
     * underlying solver, the 1..n sequence will be given as weights.
     * SUBTLE: The weights can help the solver make branch-and-bound decisions
     * that fit the underlying optimization model: after each LP relaxation, it
     * will compute the "average weight" of the SOS variables, weighted by value
     * (this is confusing: here we're using the values as weights), and the binary
     * branch decision will be: is the non-zero variable above or below that?
     * (weights are strictly monotonous, so the "cutoff" average weight
     * corresponds to a "cutoff" index in the var_index sequence).
     * </pre>
     *
     * <code>repeated double weight = 3;</code>
     * @param value The weight to add.
     * @return This builder for chaining.
     */
    public Builder addWeight(double value) {

      ensureWeightIsMutable();
      weight_.addDouble(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional: SOS weights. If non-empty, must be of the same size as
     * "var_index", and strictly increasing. If empty and required by the
     * underlying solver, the 1..n sequence will be given as weights.
     * SUBTLE: The weights can help the solver make branch-and-bound decisions
     * that fit the underlying optimization model: after each LP relaxation, it
     * will compute the "average weight" of the SOS variables, weighted by value
     * (this is confusing: here we're using the values as weights), and the binary
     * branch decision will be: is the non-zero variable above or below that?
     * (weights are strictly monotonous, so the "cutoff" average weight
     * corresponds to a "cutoff" index in the var_index sequence).
     * </pre>
     *
     * <code>repeated double weight = 3;</code>
     * @param values The weight to add.
     * @return This builder for chaining.
     */
    public Builder addAllWeight(
        java.lang.Iterable<? extends java.lang.Double> values) {
      ensureWeightIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, weight_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional: SOS weights. If non-empty, must be of the same size as
     * "var_index", and strictly increasing. If empty and required by the
     * underlying solver, the 1..n sequence will be given as weights.
     * SUBTLE: The weights can help the solver make branch-and-bound decisions
     * that fit the underlying optimization model: after each LP relaxation, it
     * will compute the "average weight" of the SOS variables, weighted by value
     * (this is confusing: here we're using the values as weights), and the binary
     * branch decision will be: is the non-zero variable above or below that?
     * (weights are strictly monotonous, so the "cutoff" average weight
     * corresponds to a "cutoff" index in the var_index sequence).
     * </pre>
     *
     * <code>repeated double weight = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearWeight() {
      weight_ = emptyDoubleList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    // @@protoc_insertion_point(builder_scope:operations_research.MPSosConstraint)
  }

  // @@protoc_insertion_point(class_scope:operations_research.MPSosConstraint)
  private static final com.google.ortools.linearsolver.MPSosConstraint DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ortools.linearsolver.MPSosConstraint();
  }

  public static com.google.ortools.linearsolver.MPSosConstraint getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MPSosConstraint>
      PARSER = new com.google.protobuf.AbstractParser<MPSosConstraint>() {
    @java.lang.Override
    public MPSosConstraint parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<MPSosConstraint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MPSosConstraint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ortools.linearsolver.MPSosConstraint getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

