// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: ortools/pdlp/solvers.proto

// Protobuf Java Version: 4.26.1
package com.google.ortools.pdlp;

/**
 * <pre>
 * Parameters for PrimalDualHybridGradient() in primal_dual_hybrid_gradient.h.
 * While the defaults are generally good, it is usually worthwhile to perform a
 * parameter sweep to find good settings for a particular family of problems.
 * The following parameters should be considered for tuning:
 * - restart_strategy (jointly with major_iteration_frequency)
 * - primal_weight_update_smoothing (jointly with initial_primal_weight)
 * - presolve_options.use_glop
 * - l_inf_ruiz_iterations
 * - l2_norm_rescaling
 * In addition, tune num_threads to speed up the solve.
 * </pre>
 *
 * Protobuf type {@code operations_research.pdlp.PrimalDualHybridGradientParams}
 */
public final class PrimalDualHybridGradientParams extends
    com.google.protobuf.GeneratedMessage implements
    // @@protoc_insertion_point(message_implements:operations_research.pdlp.PrimalDualHybridGradientParams)
    PrimalDualHybridGradientParamsOrBuilder {
private static final long serialVersionUID = 0L;
  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
      com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
      /* major= */ 4,
      /* minor= */ 26,
      /* patch= */ 1,
      /* suffix= */ "",
      PrimalDualHybridGradientParams.class.getName());
  }
  // Use PrimalDualHybridGradientParams.newBuilder() to construct.
  private PrimalDualHybridGradientParams(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }
  private PrimalDualHybridGradientParams() {
    numThreads_ = 1;
    majorIterationFrequency_ = 64;
    terminationCheckFrequency_ = 64;
    restartStrategy_ = 3;
    primalWeightUpdateSmoothing_ = 0.5D;
    lInfRuizIterations_ = 5;
    l2NormRescaling_ = true;
    sufficientReductionForRestart_ = 0.1D;
    necessaryReductionForRestart_ = 0.9D;
    linesearchRule_ = 1;
    initialStepSizeScaling_ = 1D;
    randomProjectionSeeds_ = emptyIntList();
    infiniteConstraintBoundThreshold_ = Double.POSITIVE_INFINITY;
    handleSomePrimalGradientsOnFiniteBoundsAsResiduals_ = true;
    diagonalQpTrustRegionSolverTolerance_ = 1e-08D;
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ortools.pdlp.Solvers.internal_static_operations_research_pdlp_PrimalDualHybridGradientParams_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ortools.pdlp.Solvers.internal_static_operations_research_pdlp_PrimalDualHybridGradientParams_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ortools.pdlp.PrimalDualHybridGradientParams.class, com.google.ortools.pdlp.PrimalDualHybridGradientParams.Builder.class);
  }

  /**
   * Protobuf enum {@code operations_research.pdlp.PrimalDualHybridGradientParams.RestartStrategy}
   */
  public enum RestartStrategy
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>RESTART_STRATEGY_UNSPECIFIED = 0;</code>
     */
    RESTART_STRATEGY_UNSPECIFIED(0),
    /**
     * <pre>
     * No restarts are performed. The average solution is cleared every major
     * iteration, but the current solution is not changed.
     * </pre>
     *
     * <code>NO_RESTARTS = 1;</code>
     */
    NO_RESTARTS(1),
    /**
     * <pre>
     * On every major iteration, the current solution is reset to the average
     * since the last major iteration.
     * </pre>
     *
     * <code>EVERY_MAJOR_ITERATION = 2;</code>
     */
    EVERY_MAJOR_ITERATION(2),
    /**
     * <pre>
     * A heuristic that adaptively decides on every major iteration whether to
     * restart (this is forced approximately on increasing powers-of-two
     * iterations), and if so to the current or to the average, based on
     * reduction in a potential function. The rule more or less follows the
     * description of the adaptive restart scheme in
     * https://arxiv.org/pdf/2106.04756.pdf.
     * </pre>
     *
     * <code>ADAPTIVE_HEURISTIC = 3;</code>
     */
    ADAPTIVE_HEURISTIC(3),
    /**
     * <pre>
     * A distance-based restarting scheme that restarts the algorithm whenever
     * an appropriate potential function is reduced sufficiently. This check
     * happens at every major iteration.
     * TODO(user): Cite paper for the restart strategy and definition of the
     * potential function, when available.
     * </pre>
     *
     * <code>ADAPTIVE_DISTANCE_BASED = 4;</code>
     */
    ADAPTIVE_DISTANCE_BASED(4),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 26,
        /* patch= */ 1,
        /* suffix= */ "",
        RestartStrategy.class.getName());
    }
    /**
     * <code>RESTART_STRATEGY_UNSPECIFIED = 0;</code>
     */
    public static final int RESTART_STRATEGY_UNSPECIFIED_VALUE = 0;
    /**
     * <pre>
     * No restarts are performed. The average solution is cleared every major
     * iteration, but the current solution is not changed.
     * </pre>
     *
     * <code>NO_RESTARTS = 1;</code>
     */
    public static final int NO_RESTARTS_VALUE = 1;
    /**
     * <pre>
     * On every major iteration, the current solution is reset to the average
     * since the last major iteration.
     * </pre>
     *
     * <code>EVERY_MAJOR_ITERATION = 2;</code>
     */
    public static final int EVERY_MAJOR_ITERATION_VALUE = 2;
    /**
     * <pre>
     * A heuristic that adaptively decides on every major iteration whether to
     * restart (this is forced approximately on increasing powers-of-two
     * iterations), and if so to the current or to the average, based on
     * reduction in a potential function. The rule more or less follows the
     * description of the adaptive restart scheme in
     * https://arxiv.org/pdf/2106.04756.pdf.
     * </pre>
     *
     * <code>ADAPTIVE_HEURISTIC = 3;</code>
     */
    public static final int ADAPTIVE_HEURISTIC_VALUE = 3;
    /**
     * <pre>
     * A distance-based restarting scheme that restarts the algorithm whenever
     * an appropriate potential function is reduced sufficiently. This check
     * happens at every major iteration.
     * TODO(user): Cite paper for the restart strategy and definition of the
     * potential function, when available.
     * </pre>
     *
     * <code>ADAPTIVE_DISTANCE_BASED = 4;</code>
     */
    public static final int ADAPTIVE_DISTANCE_BASED_VALUE = 4;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RestartStrategy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RestartStrategy forNumber(int value) {
      switch (value) {
        case 0: return RESTART_STRATEGY_UNSPECIFIED;
        case 1: return NO_RESTARTS;
        case 2: return EVERY_MAJOR_ITERATION;
        case 3: return ADAPTIVE_HEURISTIC;
        case 4: return ADAPTIVE_DISTANCE_BASED;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RestartStrategy>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        RestartStrategy> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<RestartStrategy>() {
            public RestartStrategy findValueByNumber(int number) {
              return RestartStrategy.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.pdlp.PrimalDualHybridGradientParams.getDescriptor().getEnumTypes().get(0);
    }

    private static final RestartStrategy[] VALUES = values();

    public static RestartStrategy valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RestartStrategy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.pdlp.PrimalDualHybridGradientParams.RestartStrategy)
  }

  /**
   * Protobuf enum {@code operations_research.pdlp.PrimalDualHybridGradientParams.LinesearchRule}
   */
  public enum LinesearchRule
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>LINESEARCH_RULE_UNSPECIFIED = 0;</code>
     */
    LINESEARCH_RULE_UNSPECIFIED(0),
    /**
     * <pre>
     * Applies the heuristic rule presented in Section 3.1 of
     * https://arxiv.org/pdf/2106.04756.pdf (further generalized to QP). There
     * is not a proof of convergence for it. It is usually the fastest in
     * practice but sometimes behaves poorly.
     * </pre>
     *
     * <code>ADAPTIVE_LINESEARCH_RULE = 1;</code>
     */
    ADAPTIVE_LINESEARCH_RULE(1),
    /**
     * <pre>
     * Applies Malitsky &amp; Pock linesearch rule. This guarantees an
     * ergodic O(1/N) convergence rate https://arxiv.org/pdf/1608.08883.pdf.
     * This is provably convergent but doesn't usually work as well in practice
     * as ADAPTIVE_LINESEARCH_RULE.
     * </pre>
     *
     * <code>MALITSKY_POCK_LINESEARCH_RULE = 2;</code>
     */
    MALITSKY_POCK_LINESEARCH_RULE(2),
    /**
     * <pre>
     * Uses a constant step size corresponding to an estimate of the maximum
     * singular value of the constraint matrix.
     * </pre>
     *
     * <code>CONSTANT_STEP_SIZE_RULE = 3;</code>
     */
    CONSTANT_STEP_SIZE_RULE(3),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 26,
        /* patch= */ 1,
        /* suffix= */ "",
        LinesearchRule.class.getName());
    }
    /**
     * <code>LINESEARCH_RULE_UNSPECIFIED = 0;</code>
     */
    public static final int LINESEARCH_RULE_UNSPECIFIED_VALUE = 0;
    /**
     * <pre>
     * Applies the heuristic rule presented in Section 3.1 of
     * https://arxiv.org/pdf/2106.04756.pdf (further generalized to QP). There
     * is not a proof of convergence for it. It is usually the fastest in
     * practice but sometimes behaves poorly.
     * </pre>
     *
     * <code>ADAPTIVE_LINESEARCH_RULE = 1;</code>
     */
    public static final int ADAPTIVE_LINESEARCH_RULE_VALUE = 1;
    /**
     * <pre>
     * Applies Malitsky &amp; Pock linesearch rule. This guarantees an
     * ergodic O(1/N) convergence rate https://arxiv.org/pdf/1608.08883.pdf.
     * This is provably convergent but doesn't usually work as well in practice
     * as ADAPTIVE_LINESEARCH_RULE.
     * </pre>
     *
     * <code>MALITSKY_POCK_LINESEARCH_RULE = 2;</code>
     */
    public static final int MALITSKY_POCK_LINESEARCH_RULE_VALUE = 2;
    /**
     * <pre>
     * Uses a constant step size corresponding to an estimate of the maximum
     * singular value of the constraint matrix.
     * </pre>
     *
     * <code>CONSTANT_STEP_SIZE_RULE = 3;</code>
     */
    public static final int CONSTANT_STEP_SIZE_RULE_VALUE = 3;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LinesearchRule valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LinesearchRule forNumber(int value) {
      switch (value) {
        case 0: return LINESEARCH_RULE_UNSPECIFIED;
        case 1: return ADAPTIVE_LINESEARCH_RULE;
        case 2: return MALITSKY_POCK_LINESEARCH_RULE;
        case 3: return CONSTANT_STEP_SIZE_RULE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LinesearchRule>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        LinesearchRule> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<LinesearchRule>() {
            public LinesearchRule findValueByNumber(int number) {
              return LinesearchRule.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.pdlp.PrimalDualHybridGradientParams.getDescriptor().getEnumTypes().get(1);
    }

    private static final LinesearchRule[] VALUES = values();

    public static LinesearchRule valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LinesearchRule(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.pdlp.PrimalDualHybridGradientParams.LinesearchRule)
  }

  public interface PresolveOptionsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:operations_research.pdlp.PrimalDualHybridGradientParams.PresolveOptions)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * If true runs Glop's presolver on the given instance prior to solving.
     * Note that convergence criteria are still interpreted with respect to the
     * original problem. Certificates may not be available if presolve detects
     * infeasibility. Glop's presolver cannot apply to problems with quadratic
     * objectives or problems with more than 2^31 variables or constraints. It's
     * often beneficial to enable the presolver, especially on medium-sized
     * problems. At some larger scales, the presolver can become a serial
     * bottleneck.
     * </pre>
     *
     * <code>optional bool use_glop = 1;</code>
     * @return Whether the useGlop field is set.
     */
    boolean hasUseGlop();
    /**
     * <pre>
     * If true runs Glop's presolver on the given instance prior to solving.
     * Note that convergence criteria are still interpreted with respect to the
     * original problem. Certificates may not be available if presolve detects
     * infeasibility. Glop's presolver cannot apply to problems with quadratic
     * objectives or problems with more than 2^31 variables or constraints. It's
     * often beneficial to enable the presolver, especially on medium-sized
     * problems. At some larger scales, the presolver can become a serial
     * bottleneck.
     * </pre>
     *
     * <code>optional bool use_glop = 1;</code>
     * @return The useGlop.
     */
    boolean getUseGlop();

    /**
     * <pre>
     * Parameters to control glop's presolver. Only used when use_glop is true.
     * These are merged with and override PDLP's defaults.
     * </pre>
     *
     * <code>optional .operations_research.glop.GlopParameters glop_parameters = 2;</code>
     * @return Whether the glopParameters field is set.
     */
    boolean hasGlopParameters();
    /**
     * <pre>
     * Parameters to control glop's presolver. Only used when use_glop is true.
     * These are merged with and override PDLP's defaults.
     * </pre>
     *
     * <code>optional .operations_research.glop.GlopParameters glop_parameters = 2;</code>
     * @return The glopParameters.
     */
    com.google.ortools.glop.GlopParameters getGlopParameters();
    /**
     * <pre>
     * Parameters to control glop's presolver. Only used when use_glop is true.
     * These are merged with and override PDLP's defaults.
     * </pre>
     *
     * <code>optional .operations_research.glop.GlopParameters glop_parameters = 2;</code>
     */
    com.google.ortools.glop.GlopParametersOrBuilder getGlopParametersOrBuilder();
  }
  /**
   * Protobuf type {@code operations_research.pdlp.PrimalDualHybridGradientParams.PresolveOptions}
   */
  public static final class PresolveOptions extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:operations_research.pdlp.PrimalDualHybridGradientParams.PresolveOptions)
      PresolveOptionsOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 26,
        /* patch= */ 1,
        /* suffix= */ "",
        PresolveOptions.class.getName());
    }
    // Use PresolveOptions.newBuilder() to construct.
    private PresolveOptions(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private PresolveOptions() {
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ortools.pdlp.Solvers.internal_static_operations_research_pdlp_PrimalDualHybridGradientParams_PresolveOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ortools.pdlp.Solvers.internal_static_operations_research_pdlp_PrimalDualHybridGradientParams_PresolveOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions.class, com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions.Builder.class);
    }

    private int bitField0_;
    public static final int USE_GLOP_FIELD_NUMBER = 1;
    private boolean useGlop_ = false;
    /**
     * <pre>
     * If true runs Glop's presolver on the given instance prior to solving.
     * Note that convergence criteria are still interpreted with respect to the
     * original problem. Certificates may not be available if presolve detects
     * infeasibility. Glop's presolver cannot apply to problems with quadratic
     * objectives or problems with more than 2^31 variables or constraints. It's
     * often beneficial to enable the presolver, especially on medium-sized
     * problems. At some larger scales, the presolver can become a serial
     * bottleneck.
     * </pre>
     *
     * <code>optional bool use_glop = 1;</code>
     * @return Whether the useGlop field is set.
     */
    @java.lang.Override
    public boolean hasUseGlop() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * If true runs Glop's presolver on the given instance prior to solving.
     * Note that convergence criteria are still interpreted with respect to the
     * original problem. Certificates may not be available if presolve detects
     * infeasibility. Glop's presolver cannot apply to problems with quadratic
     * objectives or problems with more than 2^31 variables or constraints. It's
     * often beneficial to enable the presolver, especially on medium-sized
     * problems. At some larger scales, the presolver can become a serial
     * bottleneck.
     * </pre>
     *
     * <code>optional bool use_glop = 1;</code>
     * @return The useGlop.
     */
    @java.lang.Override
    public boolean getUseGlop() {
      return useGlop_;
    }

    public static final int GLOP_PARAMETERS_FIELD_NUMBER = 2;
    private com.google.ortools.glop.GlopParameters glopParameters_;
    /**
     * <pre>
     * Parameters to control glop's presolver. Only used when use_glop is true.
     * These are merged with and override PDLP's defaults.
     * </pre>
     *
     * <code>optional .operations_research.glop.GlopParameters glop_parameters = 2;</code>
     * @return Whether the glopParameters field is set.
     */
    @java.lang.Override
    public boolean hasGlopParameters() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Parameters to control glop's presolver. Only used when use_glop is true.
     * These are merged with and override PDLP's defaults.
     * </pre>
     *
     * <code>optional .operations_research.glop.GlopParameters glop_parameters = 2;</code>
     * @return The glopParameters.
     */
    @java.lang.Override
    public com.google.ortools.glop.GlopParameters getGlopParameters() {
      return glopParameters_ == null ? com.google.ortools.glop.GlopParameters.getDefaultInstance() : glopParameters_;
    }
    /**
     * <pre>
     * Parameters to control glop's presolver. Only used when use_glop is true.
     * These are merged with and override PDLP's defaults.
     * </pre>
     *
     * <code>optional .operations_research.glop.GlopParameters glop_parameters = 2;</code>
     */
    @java.lang.Override
    public com.google.ortools.glop.GlopParametersOrBuilder getGlopParametersOrBuilder() {
      return glopParameters_ == null ? com.google.ortools.glop.GlopParameters.getDefaultInstance() : glopParameters_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeBool(1, useGlop_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getGlopParameters());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(1, useGlop_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getGlopParameters());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions)) {
        return super.equals(obj);
      }
      com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions other = (com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions) obj;

      if (hasUseGlop() != other.hasUseGlop()) return false;
      if (hasUseGlop()) {
        if (getUseGlop()
            != other.getUseGlop()) return false;
      }
      if (hasGlopParameters() != other.hasGlopParameters()) return false;
      if (hasGlopParameters()) {
        if (!getGlopParameters()
            .equals(other.getGlopParameters())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasUseGlop()) {
        hash = (37 * hash) + USE_GLOP_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
            getUseGlop());
      }
      if (hasGlopParameters()) {
        hash = (37 * hash) + GLOP_PARAMETERS_FIELD_NUMBER;
        hash = (53 * hash) + getGlopParameters().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code operations_research.pdlp.PrimalDualHybridGradientParams.PresolveOptions}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:operations_research.pdlp.PrimalDualHybridGradientParams.PresolveOptions)
        com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.ortools.pdlp.Solvers.internal_static_operations_research_pdlp_PrimalDualHybridGradientParams_PresolveOptions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.ortools.pdlp.Solvers.internal_static_operations_research_pdlp_PrimalDualHybridGradientParams_PresolveOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions.class, com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions.Builder.class);
      }

      // Construct using com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage
                .alwaysUseFieldBuilders) {
          getGlopParametersFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        useGlop_ = false;
        glopParameters_ = null;
        if (glopParametersBuilder_ != null) {
          glopParametersBuilder_.dispose();
          glopParametersBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.ortools.pdlp.Solvers.internal_static_operations_research_pdlp_PrimalDualHybridGradientParams_PresolveOptions_descriptor;
      }

      @java.lang.Override
      public com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions getDefaultInstanceForType() {
        return com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions build() {
        com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions buildPartial() {
        com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions result = new com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.useGlop_ = useGlop_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.glopParameters_ = glopParametersBuilder_ == null
              ? glopParameters_
              : glopParametersBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions) {
          return mergeFrom((com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions other) {
        if (other == com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions.getDefaultInstance()) return this;
        if (other.hasUseGlop()) {
          setUseGlop(other.getUseGlop());
        }
        if (other.hasGlopParameters()) {
          mergeGlopParameters(other.getGlopParameters());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                useGlop_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              case 18: {
                input.readMessage(
                    getGlopParametersFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private boolean useGlop_ ;
      /**
       * <pre>
       * If true runs Glop's presolver on the given instance prior to solving.
       * Note that convergence criteria are still interpreted with respect to the
       * original problem. Certificates may not be available if presolve detects
       * infeasibility. Glop's presolver cannot apply to problems with quadratic
       * objectives or problems with more than 2^31 variables or constraints. It's
       * often beneficial to enable the presolver, especially on medium-sized
       * problems. At some larger scales, the presolver can become a serial
       * bottleneck.
       * </pre>
       *
       * <code>optional bool use_glop = 1;</code>
       * @return Whether the useGlop field is set.
       */
      @java.lang.Override
      public boolean hasUseGlop() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * If true runs Glop's presolver on the given instance prior to solving.
       * Note that convergence criteria are still interpreted with respect to the
       * original problem. Certificates may not be available if presolve detects
       * infeasibility. Glop's presolver cannot apply to problems with quadratic
       * objectives or problems with more than 2^31 variables or constraints. It's
       * often beneficial to enable the presolver, especially on medium-sized
       * problems. At some larger scales, the presolver can become a serial
       * bottleneck.
       * </pre>
       *
       * <code>optional bool use_glop = 1;</code>
       * @return The useGlop.
       */
      @java.lang.Override
      public boolean getUseGlop() {
        return useGlop_;
      }
      /**
       * <pre>
       * If true runs Glop's presolver on the given instance prior to solving.
       * Note that convergence criteria are still interpreted with respect to the
       * original problem. Certificates may not be available if presolve detects
       * infeasibility. Glop's presolver cannot apply to problems with quadratic
       * objectives or problems with more than 2^31 variables or constraints. It's
       * often beneficial to enable the presolver, especially on medium-sized
       * problems. At some larger scales, the presolver can become a serial
       * bottleneck.
       * </pre>
       *
       * <code>optional bool use_glop = 1;</code>
       * @param value The useGlop to set.
       * @return This builder for chaining.
       */
      public Builder setUseGlop(boolean value) {

        useGlop_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * If true runs Glop's presolver on the given instance prior to solving.
       * Note that convergence criteria are still interpreted with respect to the
       * original problem. Certificates may not be available if presolve detects
       * infeasibility. Glop's presolver cannot apply to problems with quadratic
       * objectives or problems with more than 2^31 variables or constraints. It's
       * often beneficial to enable the presolver, especially on medium-sized
       * problems. At some larger scales, the presolver can become a serial
       * bottleneck.
       * </pre>
       *
       * <code>optional bool use_glop = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearUseGlop() {
        bitField0_ = (bitField0_ & ~0x00000001);
        useGlop_ = false;
        onChanged();
        return this;
      }

      private com.google.ortools.glop.GlopParameters glopParameters_;
      private com.google.protobuf.SingleFieldBuilder<
          com.google.ortools.glop.GlopParameters, com.google.ortools.glop.GlopParameters.Builder, com.google.ortools.glop.GlopParametersOrBuilder> glopParametersBuilder_;
      /**
       * <pre>
       * Parameters to control glop's presolver. Only used when use_glop is true.
       * These are merged with and override PDLP's defaults.
       * </pre>
       *
       * <code>optional .operations_research.glop.GlopParameters glop_parameters = 2;</code>
       * @return Whether the glopParameters field is set.
       */
      public boolean hasGlopParameters() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * Parameters to control glop's presolver. Only used when use_glop is true.
       * These are merged with and override PDLP's defaults.
       * </pre>
       *
       * <code>optional .operations_research.glop.GlopParameters glop_parameters = 2;</code>
       * @return The glopParameters.
       */
      public com.google.ortools.glop.GlopParameters getGlopParameters() {
        if (glopParametersBuilder_ == null) {
          return glopParameters_ == null ? com.google.ortools.glop.GlopParameters.getDefaultInstance() : glopParameters_;
        } else {
          return glopParametersBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Parameters to control glop's presolver. Only used when use_glop is true.
       * These are merged with and override PDLP's defaults.
       * </pre>
       *
       * <code>optional .operations_research.glop.GlopParameters glop_parameters = 2;</code>
       */
      public Builder setGlopParameters(com.google.ortools.glop.GlopParameters value) {
        if (glopParametersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          glopParameters_ = value;
        } else {
          glopParametersBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Parameters to control glop's presolver. Only used when use_glop is true.
       * These are merged with and override PDLP's defaults.
       * </pre>
       *
       * <code>optional .operations_research.glop.GlopParameters glop_parameters = 2;</code>
       */
      public Builder setGlopParameters(
          com.google.ortools.glop.GlopParameters.Builder builderForValue) {
        if (glopParametersBuilder_ == null) {
          glopParameters_ = builderForValue.build();
        } else {
          glopParametersBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Parameters to control glop's presolver. Only used when use_glop is true.
       * These are merged with and override PDLP's defaults.
       * </pre>
       *
       * <code>optional .operations_research.glop.GlopParameters glop_parameters = 2;</code>
       */
      public Builder mergeGlopParameters(com.google.ortools.glop.GlopParameters value) {
        if (glopParametersBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            glopParameters_ != null &&
            glopParameters_ != com.google.ortools.glop.GlopParameters.getDefaultInstance()) {
            getGlopParametersBuilder().mergeFrom(value);
          } else {
            glopParameters_ = value;
          }
        } else {
          glopParametersBuilder_.mergeFrom(value);
        }
        if (glopParameters_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * Parameters to control glop's presolver. Only used when use_glop is true.
       * These are merged with and override PDLP's defaults.
       * </pre>
       *
       * <code>optional .operations_research.glop.GlopParameters glop_parameters = 2;</code>
       */
      public Builder clearGlopParameters() {
        bitField0_ = (bitField0_ & ~0x00000002);
        glopParameters_ = null;
        if (glopParametersBuilder_ != null) {
          glopParametersBuilder_.dispose();
          glopParametersBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Parameters to control glop's presolver. Only used when use_glop is true.
       * These are merged with and override PDLP's defaults.
       * </pre>
       *
       * <code>optional .operations_research.glop.GlopParameters glop_parameters = 2;</code>
       */
      public com.google.ortools.glop.GlopParameters.Builder getGlopParametersBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getGlopParametersFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Parameters to control glop's presolver. Only used when use_glop is true.
       * These are merged with and override PDLP's defaults.
       * </pre>
       *
       * <code>optional .operations_research.glop.GlopParameters glop_parameters = 2;</code>
       */
      public com.google.ortools.glop.GlopParametersOrBuilder getGlopParametersOrBuilder() {
        if (glopParametersBuilder_ != null) {
          return glopParametersBuilder_.getMessageOrBuilder();
        } else {
          return glopParameters_ == null ?
              com.google.ortools.glop.GlopParameters.getDefaultInstance() : glopParameters_;
        }
      }
      /**
       * <pre>
       * Parameters to control glop's presolver. Only used when use_glop is true.
       * These are merged with and override PDLP's defaults.
       * </pre>
       *
       * <code>optional .operations_research.glop.GlopParameters glop_parameters = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.google.ortools.glop.GlopParameters, com.google.ortools.glop.GlopParameters.Builder, com.google.ortools.glop.GlopParametersOrBuilder> 
          getGlopParametersFieldBuilder() {
        if (glopParametersBuilder_ == null) {
          glopParametersBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.google.ortools.glop.GlopParameters, com.google.ortools.glop.GlopParameters.Builder, com.google.ortools.glop.GlopParametersOrBuilder>(
                  getGlopParameters(),
                  getParentForChildren(),
                  isClean());
          glopParameters_ = null;
        }
        return glopParametersBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:operations_research.pdlp.PrimalDualHybridGradientParams.PresolveOptions)
    }

    // @@protoc_insertion_point(class_scope:operations_research.pdlp.PrimalDualHybridGradientParams.PresolveOptions)
    private static final com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions();
    }

    public static com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PresolveOptions>
        PARSER = new com.google.protobuf.AbstractParser<PresolveOptions>() {
      @java.lang.Override
      public PresolveOptions parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<PresolveOptions> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PresolveOptions> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private int bitField0_;
  public static final int TERMINATION_CRITERIA_FIELD_NUMBER = 1;
  private com.google.ortools.pdlp.TerminationCriteria terminationCriteria_;
  /**
   * <code>optional .operations_research.pdlp.TerminationCriteria termination_criteria = 1;</code>
   * @return Whether the terminationCriteria field is set.
   */
  @java.lang.Override
  public boolean hasTerminationCriteria() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <code>optional .operations_research.pdlp.TerminationCriteria termination_criteria = 1;</code>
   * @return The terminationCriteria.
   */
  @java.lang.Override
  public com.google.ortools.pdlp.TerminationCriteria getTerminationCriteria() {
    return terminationCriteria_ == null ? com.google.ortools.pdlp.TerminationCriteria.getDefaultInstance() : terminationCriteria_;
  }
  /**
   * <code>optional .operations_research.pdlp.TerminationCriteria termination_criteria = 1;</code>
   */
  @java.lang.Override
  public com.google.ortools.pdlp.TerminationCriteriaOrBuilder getTerminationCriteriaOrBuilder() {
    return terminationCriteria_ == null ? com.google.ortools.pdlp.TerminationCriteria.getDefaultInstance() : terminationCriteria_;
  }

  public static final int NUM_THREADS_FIELD_NUMBER = 2;
  private int numThreads_ = 1;
  /**
   * <pre>
   * The number of threads to use. Must be positive.
   * Try various values of num_threads, up to the number of physical cores.
   * Performance may not be monotonically increasing with the number of threads
   * because of memory bandwidth limitations.
   * </pre>
   *
   * <code>optional int32 num_threads = 2 [default = 1];</code>
   * @return Whether the numThreads field is set.
   */
  @java.lang.Override
  public boolean hasNumThreads() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * The number of threads to use. Must be positive.
   * Try various values of num_threads, up to the number of physical cores.
   * Performance may not be monotonically increasing with the number of threads
   * because of memory bandwidth limitations.
   * </pre>
   *
   * <code>optional int32 num_threads = 2 [default = 1];</code>
   * @return The numThreads.
   */
  @java.lang.Override
  public int getNumThreads() {
    return numThreads_;
  }

  public static final int NUM_SHARDS_FIELD_NUMBER = 27;
  private int numShards_ = 0;
  /**
   * <pre>
   * For more efficient parallel computation, the matrices and vectors are
   * divided (virtually) into num_shards shards. Results are computed
   * independently for each shard and then combined. As a consequence, the order
   * of computation, and hence floating point roundoff, depends on the number of
   * shards so reproducible results require using the same value for num_shards.
   * However, for efficiency num_shards should a be at least num_threads, and
   * preferably at least 4*num_threads to allow better load balancing. If
   * num_shards is positive, the computation will use that many shards.
   * Otherwise a default that depends on num_threads will be used.
   * </pre>
   *
   * <code>optional int32 num_shards = 27 [default = 0];</code>
   * @return Whether the numShards field is set.
   */
  @java.lang.Override
  public boolean hasNumShards() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * For more efficient parallel computation, the matrices and vectors are
   * divided (virtually) into num_shards shards. Results are computed
   * independently for each shard and then combined. As a consequence, the order
   * of computation, and hence floating point roundoff, depends on the number of
   * shards so reproducible results require using the same value for num_shards.
   * However, for efficiency num_shards should a be at least num_threads, and
   * preferably at least 4*num_threads to allow better load balancing. If
   * num_shards is positive, the computation will use that many shards.
   * Otherwise a default that depends on num_threads will be used.
   * </pre>
   *
   * <code>optional int32 num_shards = 27 [default = 0];</code>
   * @return The numShards.
   */
  @java.lang.Override
  public int getNumShards() {
    return numShards_;
  }

  public static final int RECORD_ITERATION_STATS_FIELD_NUMBER = 3;
  private boolean recordIterationStats_ = false;
  /**
   * <pre>
   * If true, the iteration_stats field of the SolveLog output will be populated
   * at every iteration. Note that we only compute solution statistics at
   * termination checks. Setting this parameter to true may substantially
   * increase the size of the output.
   * </pre>
   *
   * <code>optional bool record_iteration_stats = 3;</code>
   * @return Whether the recordIterationStats field is set.
   */
  @java.lang.Override
  public boolean hasRecordIterationStats() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * If true, the iteration_stats field of the SolveLog output will be populated
   * at every iteration. Note that we only compute solution statistics at
   * termination checks. Setting this parameter to true may substantially
   * increase the size of the output.
   * </pre>
   *
   * <code>optional bool record_iteration_stats = 3;</code>
   * @return The recordIterationStats.
   */
  @java.lang.Override
  public boolean getRecordIterationStats() {
    return recordIterationStats_;
  }

  public static final int VERBOSITY_LEVEL_FIELD_NUMBER = 26;
  private int verbosityLevel_ = 0;
  /**
   * <pre>
   * The verbosity of logging.
   * 0: No informational logging. (Errors are logged.)
   * 1: Summary statistics only. No iteration-level details.
   * 2: A table of iteration-level statistics is logged.
   * (See ToShortString() in primal_dual_hybrid_gradient.cc).
   * 3: A more detailed table of iteration-level statistics is logged.
   * (See ToString() in primal_dual_hybrid_gradient.cc).
   * 4: For iteration-level details, prints the statistics of both the average
   * (prefixed with A) and the current iterate (prefixed with C). Also prints
   * internal algorithmic state and details.
   * Logging at levels 2-4 also includes messages from level 1.
   * </pre>
   *
   * <code>optional int32 verbosity_level = 26 [default = 0];</code>
   * @return Whether the verbosityLevel field is set.
   */
  @java.lang.Override
  public boolean hasVerbosityLevel() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * The verbosity of logging.
   * 0: No informational logging. (Errors are logged.)
   * 1: Summary statistics only. No iteration-level details.
   * 2: A table of iteration-level statistics is logged.
   * (See ToShortString() in primal_dual_hybrid_gradient.cc).
   * 3: A more detailed table of iteration-level statistics is logged.
   * (See ToString() in primal_dual_hybrid_gradient.cc).
   * 4: For iteration-level details, prints the statistics of both the average
   * (prefixed with A) and the current iterate (prefixed with C). Also prints
   * internal algorithmic state and details.
   * Logging at levels 2-4 also includes messages from level 1.
   * </pre>
   *
   * <code>optional int32 verbosity_level = 26 [default = 0];</code>
   * @return The verbosityLevel.
   */
  @java.lang.Override
  public int getVerbosityLevel() {
    return verbosityLevel_;
  }

  public static final int LOG_INTERVAL_SECONDS_FIELD_NUMBER = 31;
  private double logIntervalSeconds_ = 0D;
  /**
   * <pre>
   * Time between iteration-level statistics logging (if `verbosity_level &gt; 1`).
   * Since iteration-level statistics are only generated when performing
   * termination checks, logs will be generated from next termination check
   * after `log_interval_seconds` have elapsed. Should be &gt;= 0.0. 0.0 (the
   * default) means log statistics at every termination check.
   * </pre>
   *
   * <code>optional double log_interval_seconds = 31 [default = 0];</code>
   * @return Whether the logIntervalSeconds field is set.
   */
  @java.lang.Override
  public boolean hasLogIntervalSeconds() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   * <pre>
   * Time between iteration-level statistics logging (if `verbosity_level &gt; 1`).
   * Since iteration-level statistics are only generated when performing
   * termination checks, logs will be generated from next termination check
   * after `log_interval_seconds` have elapsed. Should be &gt;= 0.0. 0.0 (the
   * default) means log statistics at every termination check.
   * </pre>
   *
   * <code>optional double log_interval_seconds = 31 [default = 0];</code>
   * @return The logIntervalSeconds.
   */
  @java.lang.Override
  public double getLogIntervalSeconds() {
    return logIntervalSeconds_;
  }

  public static final int MAJOR_ITERATION_FREQUENCY_FIELD_NUMBER = 4;
  private int majorIterationFrequency_ = 64;
  /**
   * <pre>
   * The frequency at which extra work is performed to make major algorithmic
   * decisions, e.g., performing restarts and updating the primal weight. Major
   * iterations also trigger a termination check. For best performance using the
   * NO_RESTARTS or EVERY_MAJOR_ITERATION rule, one should perform a log-scale
   * grid search over this parameter, for example, over powers of two.
   * ADAPTIVE_HEURISTIC is mostly insensitive to this value.
   * </pre>
   *
   * <code>optional int32 major_iteration_frequency = 4 [default = 64];</code>
   * @return Whether the majorIterationFrequency field is set.
   */
  @java.lang.Override
  public boolean hasMajorIterationFrequency() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   * <pre>
   * The frequency at which extra work is performed to make major algorithmic
   * decisions, e.g., performing restarts and updating the primal weight. Major
   * iterations also trigger a termination check. For best performance using the
   * NO_RESTARTS or EVERY_MAJOR_ITERATION rule, one should perform a log-scale
   * grid search over this parameter, for example, over powers of two.
   * ADAPTIVE_HEURISTIC is mostly insensitive to this value.
   * </pre>
   *
   * <code>optional int32 major_iteration_frequency = 4 [default = 64];</code>
   * @return The majorIterationFrequency.
   */
  @java.lang.Override
  public int getMajorIterationFrequency() {
    return majorIterationFrequency_;
  }

  public static final int TERMINATION_CHECK_FREQUENCY_FIELD_NUMBER = 5;
  private int terminationCheckFrequency_ = 64;
  /**
   * <pre>
   * The frequency (based on a counter reset every major iteration) to check for
   * termination (involves extra work) and log iteration stats. Termination
   * checks do not affect algorithmic progress unless termination is triggered.
   * </pre>
   *
   * <code>optional int32 termination_check_frequency = 5 [default = 64];</code>
   * @return Whether the terminationCheckFrequency field is set.
   */
  @java.lang.Override
  public boolean hasTerminationCheckFrequency() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   * <pre>
   * The frequency (based on a counter reset every major iteration) to check for
   * termination (involves extra work) and log iteration stats. Termination
   * checks do not affect algorithmic progress unless termination is triggered.
   * </pre>
   *
   * <code>optional int32 termination_check_frequency = 5 [default = 64];</code>
   * @return The terminationCheckFrequency.
   */
  @java.lang.Override
  public int getTerminationCheckFrequency() {
    return terminationCheckFrequency_;
  }

  public static final int RESTART_STRATEGY_FIELD_NUMBER = 6;
  private int restartStrategy_ = 3;
  /**
   * <pre>
   * NO_RESTARTS and EVERY_MAJOR_ITERATION occasionally outperform the default.
   * If using a strategy other than ADAPTIVE_HEURISTIC, you must also tune
   * major_iteration_frequency.
   * </pre>
   *
   * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.RestartStrategy restart_strategy = 6 [default = ADAPTIVE_HEURISTIC];</code>
   * @return Whether the restartStrategy field is set.
   */
  @java.lang.Override public boolean hasRestartStrategy() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   * <pre>
   * NO_RESTARTS and EVERY_MAJOR_ITERATION occasionally outperform the default.
   * If using a strategy other than ADAPTIVE_HEURISTIC, you must also tune
   * major_iteration_frequency.
   * </pre>
   *
   * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.RestartStrategy restart_strategy = 6 [default = ADAPTIVE_HEURISTIC];</code>
   * @return The restartStrategy.
   */
  @java.lang.Override public com.google.ortools.pdlp.PrimalDualHybridGradientParams.RestartStrategy getRestartStrategy() {
    com.google.ortools.pdlp.PrimalDualHybridGradientParams.RestartStrategy result = com.google.ortools.pdlp.PrimalDualHybridGradientParams.RestartStrategy.forNumber(restartStrategy_);
    return result == null ? com.google.ortools.pdlp.PrimalDualHybridGradientParams.RestartStrategy.ADAPTIVE_HEURISTIC : result;
  }

  public static final int PRIMAL_WEIGHT_UPDATE_SMOOTHING_FIELD_NUMBER = 7;
  private double primalWeightUpdateSmoothing_ = 0.5D;
  /**
   * <pre>
   * This parameter controls exponential smoothing of log(primal_weight) when a
   * primal weight update occurs (i.e., when the ratio of primal and dual step
   * sizes is adjusted). At 0.0, the primal weight will be frozen at its initial
   * value and there will be no dynamic updates in the algorithm. At 1.0, there
   * is no smoothing in the updates. The default of 0.5 generally performs well,
   * but has been observed on occasion to trigger unstable swings in the primal
   * weight. We recommend also trying 0.0 (disabling primal weight updates), in
   * which case you must also tune initial_primal_weight.
   * </pre>
   *
   * <code>optional double primal_weight_update_smoothing = 7 [default = 0.5];</code>
   * @return Whether the primalWeightUpdateSmoothing field is set.
   */
  @java.lang.Override
  public boolean hasPrimalWeightUpdateSmoothing() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   * <pre>
   * This parameter controls exponential smoothing of log(primal_weight) when a
   * primal weight update occurs (i.e., when the ratio of primal and dual step
   * sizes is adjusted). At 0.0, the primal weight will be frozen at its initial
   * value and there will be no dynamic updates in the algorithm. At 1.0, there
   * is no smoothing in the updates. The default of 0.5 generally performs well,
   * but has been observed on occasion to trigger unstable swings in the primal
   * weight. We recommend also trying 0.0 (disabling primal weight updates), in
   * which case you must also tune initial_primal_weight.
   * </pre>
   *
   * <code>optional double primal_weight_update_smoothing = 7 [default = 0.5];</code>
   * @return The primalWeightUpdateSmoothing.
   */
  @java.lang.Override
  public double getPrimalWeightUpdateSmoothing() {
    return primalWeightUpdateSmoothing_;
  }

  public static final int INITIAL_PRIMAL_WEIGHT_FIELD_NUMBER = 8;
  private double initialPrimalWeight_ = 0D;
  /**
   * <pre>
   * The initial value of the primal weight (i.e., the ratio of primal and dual
   * step sizes). The primal weight remains fixed throughout the solve if
   * primal_weight_update_smoothing = 0.0. If unset, the default is the ratio of
   * the norm of the objective vector to the L2 norm of the combined constraint
   * bounds vector (as defined above). If this ratio is not finite and positive,
   * then the default is 1.0 instead. For tuning, try powers of 10, for example,
   * from 10^{-6} to 10^6.
   * </pre>
   *
   * <code>optional double initial_primal_weight = 8;</code>
   * @return Whether the initialPrimalWeight field is set.
   */
  @java.lang.Override
  public boolean hasInitialPrimalWeight() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   * <pre>
   * The initial value of the primal weight (i.e., the ratio of primal and dual
   * step sizes). The primal weight remains fixed throughout the solve if
   * primal_weight_update_smoothing = 0.0. If unset, the default is the ratio of
   * the norm of the objective vector to the L2 norm of the combined constraint
   * bounds vector (as defined above). If this ratio is not finite and positive,
   * then the default is 1.0 instead. For tuning, try powers of 10, for example,
   * from 10^{-6} to 10^6.
   * </pre>
   *
   * <code>optional double initial_primal_weight = 8;</code>
   * @return The initialPrimalWeight.
   */
  @java.lang.Override
  public double getInitialPrimalWeight() {
    return initialPrimalWeight_;
  }

  public static final int PRESOLVE_OPTIONS_FIELD_NUMBER = 16;
  private com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions presolveOptions_;
  /**
   * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.PresolveOptions presolve_options = 16;</code>
   * @return Whether the presolveOptions field is set.
   */
  @java.lang.Override
  public boolean hasPresolveOptions() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.PresolveOptions presolve_options = 16;</code>
   * @return The presolveOptions.
   */
  @java.lang.Override
  public com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions getPresolveOptions() {
    return presolveOptions_ == null ? com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions.getDefaultInstance() : presolveOptions_;
  }
  /**
   * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.PresolveOptions presolve_options = 16;</code>
   */
  @java.lang.Override
  public com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptionsOrBuilder getPresolveOptionsOrBuilder() {
    return presolveOptions_ == null ? com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions.getDefaultInstance() : presolveOptions_;
  }

  public static final int L_INF_RUIZ_ITERATIONS_FIELD_NUMBER = 9;
  private int lInfRuizIterations_ = 5;
  /**
   * <pre>
   * Number of L_infinity Ruiz rescaling iterations to apply to the constraint
   * matrix. Zero disables this rescaling pass. Recommended values to try when
   * tuning are 0, 5, and 10.
   * </pre>
   *
   * <code>optional int32 l_inf_ruiz_iterations = 9 [default = 5];</code>
   * @return Whether the lInfRuizIterations field is set.
   */
  @java.lang.Override
  public boolean hasLInfRuizIterations() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   * <pre>
   * Number of L_infinity Ruiz rescaling iterations to apply to the constraint
   * matrix. Zero disables this rescaling pass. Recommended values to try when
   * tuning are 0, 5, and 10.
   * </pre>
   *
   * <code>optional int32 l_inf_ruiz_iterations = 9 [default = 5];</code>
   * @return The lInfRuizIterations.
   */
  @java.lang.Override
  public int getLInfRuizIterations() {
    return lInfRuizIterations_;
  }

  public static final int L2_NORM_RESCALING_FIELD_NUMBER = 10;
  private boolean l2NormRescaling_ = true;
  /**
   * <pre>
   * If true, applies L_2 norm rescaling after the Ruiz rescaling. Heuristically
   * this has been found to help convergence.
   * </pre>
   *
   * <code>optional bool l2_norm_rescaling = 10 [default = true];</code>
   * @return Whether the l2NormRescaling field is set.
   */
  @java.lang.Override
  public boolean hasL2NormRescaling() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   * <pre>
   * If true, applies L_2 norm rescaling after the Ruiz rescaling. Heuristically
   * this has been found to help convergence.
   * </pre>
   *
   * <code>optional bool l2_norm_rescaling = 10 [default = true];</code>
   * @return The l2NormRescaling.
   */
  @java.lang.Override
  public boolean getL2NormRescaling() {
    return l2NormRescaling_;
  }

  public static final int SUFFICIENT_REDUCTION_FOR_RESTART_FIELD_NUMBER = 11;
  private double sufficientReductionForRestart_ = 0.1D;
  /**
   * <pre>
   * For ADAPTIVE_HEURISTIC and ADAPTIVE_DISTANCE_BASED only: A relative
   * reduction in the potential function by this amount always triggers a
   * restart. Must be between 0.0 and 1.0.
   * </pre>
   *
   * <code>optional double sufficient_reduction_for_restart = 11 [default = 0.1];</code>
   * @return Whether the sufficientReductionForRestart field is set.
   */
  @java.lang.Override
  public boolean hasSufficientReductionForRestart() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   * <pre>
   * For ADAPTIVE_HEURISTIC and ADAPTIVE_DISTANCE_BASED only: A relative
   * reduction in the potential function by this amount always triggers a
   * restart. Must be between 0.0 and 1.0.
   * </pre>
   *
   * <code>optional double sufficient_reduction_for_restart = 11 [default = 0.1];</code>
   * @return The sufficientReductionForRestart.
   */
  @java.lang.Override
  public double getSufficientReductionForRestart() {
    return sufficientReductionForRestart_;
  }

  public static final int NECESSARY_REDUCTION_FOR_RESTART_FIELD_NUMBER = 17;
  private double necessaryReductionForRestart_ = 0.9D;
  /**
   * <pre>
   * For ADAPTIVE_HEURISTIC only: A relative reduction in the potential function
   * by this amount triggers a restart if, additionally, the quality of the
   * iterates appears to be getting worse. The value must be in the interval
   * [sufficient_reduction_for_restart, 1). Smaller values make restarts less
   * frequent, and larger values make them more frequent.
   * </pre>
   *
   * <code>optional double necessary_reduction_for_restart = 17 [default = 0.9];</code>
   * @return Whether the necessaryReductionForRestart field is set.
   */
  @java.lang.Override
  public boolean hasNecessaryReductionForRestart() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   * <pre>
   * For ADAPTIVE_HEURISTIC only: A relative reduction in the potential function
   * by this amount triggers a restart if, additionally, the quality of the
   * iterates appears to be getting worse. The value must be in the interval
   * [sufficient_reduction_for_restart, 1). Smaller values make restarts less
   * frequent, and larger values make them more frequent.
   * </pre>
   *
   * <code>optional double necessary_reduction_for_restart = 17 [default = 0.9];</code>
   * @return The necessaryReductionForRestart.
   */
  @java.lang.Override
  public double getNecessaryReductionForRestart() {
    return necessaryReductionForRestart_;
  }

  public static final int LINESEARCH_RULE_FIELD_NUMBER = 12;
  private int linesearchRule_ = 1;
  /**
   * <pre>
   * Linesearch rule applied at each major iteration.
   * </pre>
   *
   * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.LinesearchRule linesearch_rule = 12 [default = ADAPTIVE_LINESEARCH_RULE];</code>
   * @return Whether the linesearchRule field is set.
   */
  @java.lang.Override public boolean hasLinesearchRule() {
    return ((bitField0_ & 0x00010000) != 0);
  }
  /**
   * <pre>
   * Linesearch rule applied at each major iteration.
   * </pre>
   *
   * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.LinesearchRule linesearch_rule = 12 [default = ADAPTIVE_LINESEARCH_RULE];</code>
   * @return The linesearchRule.
   */
  @java.lang.Override public com.google.ortools.pdlp.PrimalDualHybridGradientParams.LinesearchRule getLinesearchRule() {
    com.google.ortools.pdlp.PrimalDualHybridGradientParams.LinesearchRule result = com.google.ortools.pdlp.PrimalDualHybridGradientParams.LinesearchRule.forNumber(linesearchRule_);
    return result == null ? com.google.ortools.pdlp.PrimalDualHybridGradientParams.LinesearchRule.ADAPTIVE_LINESEARCH_RULE : result;
  }

  public static final int ADAPTIVE_LINESEARCH_PARAMETERS_FIELD_NUMBER = 18;
  private com.google.ortools.pdlp.AdaptiveLinesearchParams adaptiveLinesearchParameters_;
  /**
   * <code>optional .operations_research.pdlp.AdaptiveLinesearchParams adaptive_linesearch_parameters = 18;</code>
   * @return Whether the adaptiveLinesearchParameters field is set.
   */
  @java.lang.Override
  public boolean hasAdaptiveLinesearchParameters() {
    return ((bitField0_ & 0x00020000) != 0);
  }
  /**
   * <code>optional .operations_research.pdlp.AdaptiveLinesearchParams adaptive_linesearch_parameters = 18;</code>
   * @return The adaptiveLinesearchParameters.
   */
  @java.lang.Override
  public com.google.ortools.pdlp.AdaptiveLinesearchParams getAdaptiveLinesearchParameters() {
    return adaptiveLinesearchParameters_ == null ? com.google.ortools.pdlp.AdaptiveLinesearchParams.getDefaultInstance() : adaptiveLinesearchParameters_;
  }
  /**
   * <code>optional .operations_research.pdlp.AdaptiveLinesearchParams adaptive_linesearch_parameters = 18;</code>
   */
  @java.lang.Override
  public com.google.ortools.pdlp.AdaptiveLinesearchParamsOrBuilder getAdaptiveLinesearchParametersOrBuilder() {
    return adaptiveLinesearchParameters_ == null ? com.google.ortools.pdlp.AdaptiveLinesearchParams.getDefaultInstance() : adaptiveLinesearchParameters_;
  }

  public static final int MALITSKY_POCK_PARAMETERS_FIELD_NUMBER = 19;
  private com.google.ortools.pdlp.MalitskyPockParams malitskyPockParameters_;
  /**
   * <code>optional .operations_research.pdlp.MalitskyPockParams malitsky_pock_parameters = 19;</code>
   * @return Whether the malitskyPockParameters field is set.
   */
  @java.lang.Override
  public boolean hasMalitskyPockParameters() {
    return ((bitField0_ & 0x00040000) != 0);
  }
  /**
   * <code>optional .operations_research.pdlp.MalitskyPockParams malitsky_pock_parameters = 19;</code>
   * @return The malitskyPockParameters.
   */
  @java.lang.Override
  public com.google.ortools.pdlp.MalitskyPockParams getMalitskyPockParameters() {
    return malitskyPockParameters_ == null ? com.google.ortools.pdlp.MalitskyPockParams.getDefaultInstance() : malitskyPockParameters_;
  }
  /**
   * <code>optional .operations_research.pdlp.MalitskyPockParams malitsky_pock_parameters = 19;</code>
   */
  @java.lang.Override
  public com.google.ortools.pdlp.MalitskyPockParamsOrBuilder getMalitskyPockParametersOrBuilder() {
    return malitskyPockParameters_ == null ? com.google.ortools.pdlp.MalitskyPockParams.getDefaultInstance() : malitskyPockParameters_;
  }

  public static final int INITIAL_STEP_SIZE_SCALING_FIELD_NUMBER = 25;
  private double initialStepSizeScaling_ = 1D;
  /**
   * <pre>
   * Scaling factor applied to the initial step size (all step sizes if
   * linesearch_rule == CONSTANT_STEP_SIZE_RULE).
   * </pre>
   *
   * <code>optional double initial_step_size_scaling = 25 [default = 1];</code>
   * @return Whether the initialStepSizeScaling field is set.
   */
  @java.lang.Override
  public boolean hasInitialStepSizeScaling() {
    return ((bitField0_ & 0x00080000) != 0);
  }
  /**
   * <pre>
   * Scaling factor applied to the initial step size (all step sizes if
   * linesearch_rule == CONSTANT_STEP_SIZE_RULE).
   * </pre>
   *
   * <code>optional double initial_step_size_scaling = 25 [default = 1];</code>
   * @return The initialStepSizeScaling.
   */
  @java.lang.Override
  public double getInitialStepSizeScaling() {
    return initialStepSizeScaling_;
  }

  public static final int RANDOM_PROJECTION_SEEDS_FIELD_NUMBER = 28;
  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.IntList randomProjectionSeeds_ =
      emptyIntList();
  /**
   * <pre>
   * Seeds for generating (pseudo-)random projections of iterates during
   * termination checks. For each seed, the projection of the primal and dual
   * solutions onto random planes in primal and dual space will be computed and
   * added the IterationStats if record_iteration_stats is true. The random
   * planes generated will be determined by the seeds, the primal and dual
   * dimensions, and num_threads.
   * </pre>
   *
   * <code>repeated int32 random_projection_seeds = 28 [packed = true];</code>
   * @return A list containing the randomProjectionSeeds.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer>
      getRandomProjectionSeedsList() {
    return randomProjectionSeeds_;
  }
  /**
   * <pre>
   * Seeds for generating (pseudo-)random projections of iterates during
   * termination checks. For each seed, the projection of the primal and dual
   * solutions onto random planes in primal and dual space will be computed and
   * added the IterationStats if record_iteration_stats is true. The random
   * planes generated will be determined by the seeds, the primal and dual
   * dimensions, and num_threads.
   * </pre>
   *
   * <code>repeated int32 random_projection_seeds = 28 [packed = true];</code>
   * @return The count of randomProjectionSeeds.
   */
  public int getRandomProjectionSeedsCount() {
    return randomProjectionSeeds_.size();
  }
  /**
   * <pre>
   * Seeds for generating (pseudo-)random projections of iterates during
   * termination checks. For each seed, the projection of the primal and dual
   * solutions onto random planes in primal and dual space will be computed and
   * added the IterationStats if record_iteration_stats is true. The random
   * planes generated will be determined by the seeds, the primal and dual
   * dimensions, and num_threads.
   * </pre>
   *
   * <code>repeated int32 random_projection_seeds = 28 [packed = true];</code>
   * @param index The index of the element to return.
   * @return The randomProjectionSeeds at the given index.
   */
  public int getRandomProjectionSeeds(int index) {
    return randomProjectionSeeds_.getInt(index);
  }
  private int randomProjectionSeedsMemoizedSerializedSize = -1;

  public static final int INFINITE_CONSTRAINT_BOUND_THRESHOLD_FIELD_NUMBER = 22;
  private double infiniteConstraintBoundThreshold_ = Double.POSITIVE_INFINITY;
  /**
   * <pre>
   * Constraint bounds with absolute value at least this threshold are replaced
   * with infinities.
   * NOTE: This primarily affects the relative convergence criteria. A smaller
   * value makes the relative convergence criteria stronger. It also affects the
   * problem statistics LOG()ed at the start of the run, and the default initial
   * primal weight, since that is based on the norm of the bounds.
   * </pre>
   *
   * <code>optional double infinite_constraint_bound_threshold = 22 [default = inf];</code>
   * @return Whether the infiniteConstraintBoundThreshold field is set.
   */
  @java.lang.Override
  public boolean hasInfiniteConstraintBoundThreshold() {
    return ((bitField0_ & 0x00100000) != 0);
  }
  /**
   * <pre>
   * Constraint bounds with absolute value at least this threshold are replaced
   * with infinities.
   * NOTE: This primarily affects the relative convergence criteria. A smaller
   * value makes the relative convergence criteria stronger. It also affects the
   * problem statistics LOG()ed at the start of the run, and the default initial
   * primal weight, since that is based on the norm of the bounds.
   * </pre>
   *
   * <code>optional double infinite_constraint_bound_threshold = 22 [default = inf];</code>
   * @return The infiniteConstraintBoundThreshold.
   */
  @java.lang.Override
  public double getInfiniteConstraintBoundThreshold() {
    return infiniteConstraintBoundThreshold_;
  }

  public static final int HANDLE_SOME_PRIMAL_GRADIENTS_ON_FINITE_BOUNDS_AS_RESIDUALS_FIELD_NUMBER = 29;
  private boolean handleSomePrimalGradientsOnFiniteBoundsAsResiduals_ = true;
  /**
   * <pre>
   * See
   * https://developers.google.com/optimization/lp/pdlp_math#treating_some_variable_bounds_as_infinite
   * for a description of this flag.
   * </pre>
   *
   * <code>optional bool handle_some_primal_gradients_on_finite_bounds_as_residuals = 29 [default = true];</code>
   * @return Whether the handleSomePrimalGradientsOnFiniteBoundsAsResiduals field is set.
   */
  @java.lang.Override
  public boolean hasHandleSomePrimalGradientsOnFiniteBoundsAsResiduals() {
    return ((bitField0_ & 0x00200000) != 0);
  }
  /**
   * <pre>
   * See
   * https://developers.google.com/optimization/lp/pdlp_math#treating_some_variable_bounds_as_infinite
   * for a description of this flag.
   * </pre>
   *
   * <code>optional bool handle_some_primal_gradients_on_finite_bounds_as_residuals = 29 [default = true];</code>
   * @return The handleSomePrimalGradientsOnFiniteBoundsAsResiduals.
   */
  @java.lang.Override
  public boolean getHandleSomePrimalGradientsOnFiniteBoundsAsResiduals() {
    return handleSomePrimalGradientsOnFiniteBoundsAsResiduals_;
  }

  public static final int USE_DIAGONAL_QP_TRUST_REGION_SOLVER_FIELD_NUMBER = 23;
  private boolean useDiagonalQpTrustRegionSolver_ = false;
  /**
   * <pre>
   * When solving QPs with diagonal objective matrices, this option can be
   * turned on to enable an experimental solver that avoids linearization of the
   * quadratic term. The `diagonal_qp_solver_accuracy` parameter controls the
   * solve accuracy.
   * TODO(user): Turn this option on by default for quadratic
   * programs after numerical evaluation.
   * </pre>
   *
   * <code>optional bool use_diagonal_qp_trust_region_solver = 23 [default = false];</code>
   * @return Whether the useDiagonalQpTrustRegionSolver field is set.
   */
  @java.lang.Override
  public boolean hasUseDiagonalQpTrustRegionSolver() {
    return ((bitField0_ & 0x00400000) != 0);
  }
  /**
   * <pre>
   * When solving QPs with diagonal objective matrices, this option can be
   * turned on to enable an experimental solver that avoids linearization of the
   * quadratic term. The `diagonal_qp_solver_accuracy` parameter controls the
   * solve accuracy.
   * TODO(user): Turn this option on by default for quadratic
   * programs after numerical evaluation.
   * </pre>
   *
   * <code>optional bool use_diagonal_qp_trust_region_solver = 23 [default = false];</code>
   * @return The useDiagonalQpTrustRegionSolver.
   */
  @java.lang.Override
  public boolean getUseDiagonalQpTrustRegionSolver() {
    return useDiagonalQpTrustRegionSolver_;
  }

  public static final int DIAGONAL_QP_TRUST_REGION_SOLVER_TOLERANCE_FIELD_NUMBER = 24;
  private double diagonalQpTrustRegionSolverTolerance_ = 1e-08D;
  /**
   * <pre>
   * The solve tolerance of the experimental trust region solver for diagonal
   * QPs, controlling the accuracy of binary search over a one-dimensional
   * scaling parameter. Smaller values imply smaller relative error of the final
   * solution vector.
   * TODO(user): Find an expression for the final relative error.
   * </pre>
   *
   * <code>optional double diagonal_qp_trust_region_solver_tolerance = 24 [default = 1e-08];</code>
   * @return Whether the diagonalQpTrustRegionSolverTolerance field is set.
   */
  @java.lang.Override
  public boolean hasDiagonalQpTrustRegionSolverTolerance() {
    return ((bitField0_ & 0x00800000) != 0);
  }
  /**
   * <pre>
   * The solve tolerance of the experimental trust region solver for diagonal
   * QPs, controlling the accuracy of binary search over a one-dimensional
   * scaling parameter. Smaller values imply smaller relative error of the final
   * solution vector.
   * TODO(user): Find an expression for the final relative error.
   * </pre>
   *
   * <code>optional double diagonal_qp_trust_region_solver_tolerance = 24 [default = 1e-08];</code>
   * @return The diagonalQpTrustRegionSolverTolerance.
   */
  @java.lang.Override
  public double getDiagonalQpTrustRegionSolverTolerance() {
    return diagonalQpTrustRegionSolverTolerance_;
  }

  public static final int USE_FEASIBILITY_POLISHING_FIELD_NUMBER = 30;
  private boolean useFeasibilityPolishing_ = false;
  /**
   * <pre>
   * If true, periodically runs feasibility polishing, which attempts to move
   * from latest average iterate to one that is closer to feasibility (i.e., has
   * smaller primal and dual residuals) while probably increasing the objective
   * gap. This is useful primarily when the feasibility tolerances are fairly
   * tight and the objective gap tolerance is somewhat looser. Note that this
   * does not change the termination criteria, but rather can help achieve the
   * termination criteria more quickly when the objective gap is not as
   * important as feasibility.
   *
   * `use_feasibility_polishing` cannot be used with glop presolve, and requires
   * `handle_some_primal_gradients_on_finite_bounds_as_residuals == false`.
   * `use_feasibility_polishing` can only be used with linear programs.
   *
   * Feasibility polishing runs two separate phases, primal feasibility and dual
   * feasibility. The primal feasibility phase runs PDHG on the primal
   * feasibility problem (obtained by changing the objective vector to all
   * zeros), using the average primal iterate and zero dual (which is optimal
   * for the primal feasibility problem) as the initial solution. The dual
   * feasibility phase runs PDHG on the dual feasibility problem (obtained by
   * changing all finite variable and constraint bounds to zero), using the
   * average dual iterate and zero primal (which is optimal for the dual
   * feasibility problem) as the initial solution. The primal solution from the
   * primal feasibility phase and dual solution from the dual feasibility phase
   * are then combined (forming a solution of type
   * `POINT_TYPE_FEASIBILITY_POLISHING_SOLUTION`) and checked against the
   * termination criteria.
   * </pre>
   *
   * <code>optional bool use_feasibility_polishing = 30 [default = false];</code>
   * @return Whether the useFeasibilityPolishing field is set.
   */
  @java.lang.Override
  public boolean hasUseFeasibilityPolishing() {
    return ((bitField0_ & 0x01000000) != 0);
  }
  /**
   * <pre>
   * If true, periodically runs feasibility polishing, which attempts to move
   * from latest average iterate to one that is closer to feasibility (i.e., has
   * smaller primal and dual residuals) while probably increasing the objective
   * gap. This is useful primarily when the feasibility tolerances are fairly
   * tight and the objective gap tolerance is somewhat looser. Note that this
   * does not change the termination criteria, but rather can help achieve the
   * termination criteria more quickly when the objective gap is not as
   * important as feasibility.
   *
   * `use_feasibility_polishing` cannot be used with glop presolve, and requires
   * `handle_some_primal_gradients_on_finite_bounds_as_residuals == false`.
   * `use_feasibility_polishing` can only be used with linear programs.
   *
   * Feasibility polishing runs two separate phases, primal feasibility and dual
   * feasibility. The primal feasibility phase runs PDHG on the primal
   * feasibility problem (obtained by changing the objective vector to all
   * zeros), using the average primal iterate and zero dual (which is optimal
   * for the primal feasibility problem) as the initial solution. The dual
   * feasibility phase runs PDHG on the dual feasibility problem (obtained by
   * changing all finite variable and constraint bounds to zero), using the
   * average dual iterate and zero primal (which is optimal for the dual
   * feasibility problem) as the initial solution. The primal solution from the
   * primal feasibility phase and dual solution from the dual feasibility phase
   * are then combined (forming a solution of type
   * `POINT_TYPE_FEASIBILITY_POLISHING_SOLUTION`) and checked against the
   * termination criteria.
   * </pre>
   *
   * <code>optional bool use_feasibility_polishing = 30 [default = false];</code>
   * @return The useFeasibilityPolishing.
   */
  @java.lang.Override
  public boolean getUseFeasibilityPolishing() {
    return useFeasibilityPolishing_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getTerminationCriteria());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt32(2, numThreads_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeBool(3, recordIterationStats_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeInt32(4, majorIterationFrequency_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeInt32(5, terminationCheckFrequency_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeEnum(6, restartStrategy_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeDouble(7, primalWeightUpdateSmoothing_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeDouble(8, initialPrimalWeight_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeInt32(9, lInfRuizIterations_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeBool(10, l2NormRescaling_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeDouble(11, sufficientReductionForRestart_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      output.writeEnum(12, linesearchRule_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeMessage(16, getPresolveOptions());
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeDouble(17, necessaryReductionForRestart_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      output.writeMessage(18, getAdaptiveLinesearchParameters());
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      output.writeMessage(19, getMalitskyPockParameters());
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      output.writeDouble(22, infiniteConstraintBoundThreshold_);
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      output.writeBool(23, useDiagonalQpTrustRegionSolver_);
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      output.writeDouble(24, diagonalQpTrustRegionSolverTolerance_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      output.writeDouble(25, initialStepSizeScaling_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeInt32(26, verbosityLevel_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt32(27, numShards_);
    }
    if (getRandomProjectionSeedsList().size() > 0) {
      output.writeUInt32NoTag(226);
      output.writeUInt32NoTag(randomProjectionSeedsMemoizedSerializedSize);
    }
    for (int i = 0; i < randomProjectionSeeds_.size(); i++) {
      output.writeInt32NoTag(randomProjectionSeeds_.getInt(i));
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      output.writeBool(29, handleSomePrimalGradientsOnFiniteBoundsAsResiduals_);
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      output.writeBool(30, useFeasibilityPolishing_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeDouble(31, logIntervalSeconds_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, getTerminationCriteria());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(2, numThreads_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(3, recordIterationStats_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(4, majorIterationFrequency_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(5, terminationCheckFrequency_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(6, restartStrategy_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(7, primalWeightUpdateSmoothing_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(8, initialPrimalWeight_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(9, lInfRuizIterations_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(10, l2NormRescaling_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(11, sufficientReductionForRestart_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(12, linesearchRule_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(16, getPresolveOptions());
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(17, necessaryReductionForRestart_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(18, getAdaptiveLinesearchParameters());
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(19, getMalitskyPockParameters());
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(22, infiniteConstraintBoundThreshold_);
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(23, useDiagonalQpTrustRegionSolver_);
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(24, diagonalQpTrustRegionSolverTolerance_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(25, initialStepSizeScaling_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(26, verbosityLevel_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(27, numShards_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < randomProjectionSeeds_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeInt32SizeNoTag(randomProjectionSeeds_.getInt(i));
      }
      size += dataSize;
      if (!getRandomProjectionSeedsList().isEmpty()) {
        size += 2;
        size += com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(dataSize);
      }
      randomProjectionSeedsMemoizedSerializedSize = dataSize;
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(29, handleSomePrimalGradientsOnFiniteBoundsAsResiduals_);
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(30, useFeasibilityPolishing_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(31, logIntervalSeconds_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ortools.pdlp.PrimalDualHybridGradientParams)) {
      return super.equals(obj);
    }
    com.google.ortools.pdlp.PrimalDualHybridGradientParams other = (com.google.ortools.pdlp.PrimalDualHybridGradientParams) obj;

    if (hasTerminationCriteria() != other.hasTerminationCriteria()) return false;
    if (hasTerminationCriteria()) {
      if (!getTerminationCriteria()
          .equals(other.getTerminationCriteria())) return false;
    }
    if (hasNumThreads() != other.hasNumThreads()) return false;
    if (hasNumThreads()) {
      if (getNumThreads()
          != other.getNumThreads()) return false;
    }
    if (hasNumShards() != other.hasNumShards()) return false;
    if (hasNumShards()) {
      if (getNumShards()
          != other.getNumShards()) return false;
    }
    if (hasRecordIterationStats() != other.hasRecordIterationStats()) return false;
    if (hasRecordIterationStats()) {
      if (getRecordIterationStats()
          != other.getRecordIterationStats()) return false;
    }
    if (hasVerbosityLevel() != other.hasVerbosityLevel()) return false;
    if (hasVerbosityLevel()) {
      if (getVerbosityLevel()
          != other.getVerbosityLevel()) return false;
    }
    if (hasLogIntervalSeconds() != other.hasLogIntervalSeconds()) return false;
    if (hasLogIntervalSeconds()) {
      if (java.lang.Double.doubleToLongBits(getLogIntervalSeconds())
          != java.lang.Double.doubleToLongBits(
              other.getLogIntervalSeconds())) return false;
    }
    if (hasMajorIterationFrequency() != other.hasMajorIterationFrequency()) return false;
    if (hasMajorIterationFrequency()) {
      if (getMajorIterationFrequency()
          != other.getMajorIterationFrequency()) return false;
    }
    if (hasTerminationCheckFrequency() != other.hasTerminationCheckFrequency()) return false;
    if (hasTerminationCheckFrequency()) {
      if (getTerminationCheckFrequency()
          != other.getTerminationCheckFrequency()) return false;
    }
    if (hasRestartStrategy() != other.hasRestartStrategy()) return false;
    if (hasRestartStrategy()) {
      if (restartStrategy_ != other.restartStrategy_) return false;
    }
    if (hasPrimalWeightUpdateSmoothing() != other.hasPrimalWeightUpdateSmoothing()) return false;
    if (hasPrimalWeightUpdateSmoothing()) {
      if (java.lang.Double.doubleToLongBits(getPrimalWeightUpdateSmoothing())
          != java.lang.Double.doubleToLongBits(
              other.getPrimalWeightUpdateSmoothing())) return false;
    }
    if (hasInitialPrimalWeight() != other.hasInitialPrimalWeight()) return false;
    if (hasInitialPrimalWeight()) {
      if (java.lang.Double.doubleToLongBits(getInitialPrimalWeight())
          != java.lang.Double.doubleToLongBits(
              other.getInitialPrimalWeight())) return false;
    }
    if (hasPresolveOptions() != other.hasPresolveOptions()) return false;
    if (hasPresolveOptions()) {
      if (!getPresolveOptions()
          .equals(other.getPresolveOptions())) return false;
    }
    if (hasLInfRuizIterations() != other.hasLInfRuizIterations()) return false;
    if (hasLInfRuizIterations()) {
      if (getLInfRuizIterations()
          != other.getLInfRuizIterations()) return false;
    }
    if (hasL2NormRescaling() != other.hasL2NormRescaling()) return false;
    if (hasL2NormRescaling()) {
      if (getL2NormRescaling()
          != other.getL2NormRescaling()) return false;
    }
    if (hasSufficientReductionForRestart() != other.hasSufficientReductionForRestart()) return false;
    if (hasSufficientReductionForRestart()) {
      if (java.lang.Double.doubleToLongBits(getSufficientReductionForRestart())
          != java.lang.Double.doubleToLongBits(
              other.getSufficientReductionForRestart())) return false;
    }
    if (hasNecessaryReductionForRestart() != other.hasNecessaryReductionForRestart()) return false;
    if (hasNecessaryReductionForRestart()) {
      if (java.lang.Double.doubleToLongBits(getNecessaryReductionForRestart())
          != java.lang.Double.doubleToLongBits(
              other.getNecessaryReductionForRestart())) return false;
    }
    if (hasLinesearchRule() != other.hasLinesearchRule()) return false;
    if (hasLinesearchRule()) {
      if (linesearchRule_ != other.linesearchRule_) return false;
    }
    if (hasAdaptiveLinesearchParameters() != other.hasAdaptiveLinesearchParameters()) return false;
    if (hasAdaptiveLinesearchParameters()) {
      if (!getAdaptiveLinesearchParameters()
          .equals(other.getAdaptiveLinesearchParameters())) return false;
    }
    if (hasMalitskyPockParameters() != other.hasMalitskyPockParameters()) return false;
    if (hasMalitskyPockParameters()) {
      if (!getMalitskyPockParameters()
          .equals(other.getMalitskyPockParameters())) return false;
    }
    if (hasInitialStepSizeScaling() != other.hasInitialStepSizeScaling()) return false;
    if (hasInitialStepSizeScaling()) {
      if (java.lang.Double.doubleToLongBits(getInitialStepSizeScaling())
          != java.lang.Double.doubleToLongBits(
              other.getInitialStepSizeScaling())) return false;
    }
    if (!getRandomProjectionSeedsList()
        .equals(other.getRandomProjectionSeedsList())) return false;
    if (hasInfiniteConstraintBoundThreshold() != other.hasInfiniteConstraintBoundThreshold()) return false;
    if (hasInfiniteConstraintBoundThreshold()) {
      if (java.lang.Double.doubleToLongBits(getInfiniteConstraintBoundThreshold())
          != java.lang.Double.doubleToLongBits(
              other.getInfiniteConstraintBoundThreshold())) return false;
    }
    if (hasHandleSomePrimalGradientsOnFiniteBoundsAsResiduals() != other.hasHandleSomePrimalGradientsOnFiniteBoundsAsResiduals()) return false;
    if (hasHandleSomePrimalGradientsOnFiniteBoundsAsResiduals()) {
      if (getHandleSomePrimalGradientsOnFiniteBoundsAsResiduals()
          != other.getHandleSomePrimalGradientsOnFiniteBoundsAsResiduals()) return false;
    }
    if (hasUseDiagonalQpTrustRegionSolver() != other.hasUseDiagonalQpTrustRegionSolver()) return false;
    if (hasUseDiagonalQpTrustRegionSolver()) {
      if (getUseDiagonalQpTrustRegionSolver()
          != other.getUseDiagonalQpTrustRegionSolver()) return false;
    }
    if (hasDiagonalQpTrustRegionSolverTolerance() != other.hasDiagonalQpTrustRegionSolverTolerance()) return false;
    if (hasDiagonalQpTrustRegionSolverTolerance()) {
      if (java.lang.Double.doubleToLongBits(getDiagonalQpTrustRegionSolverTolerance())
          != java.lang.Double.doubleToLongBits(
              other.getDiagonalQpTrustRegionSolverTolerance())) return false;
    }
    if (hasUseFeasibilityPolishing() != other.hasUseFeasibilityPolishing()) return false;
    if (hasUseFeasibilityPolishing()) {
      if (getUseFeasibilityPolishing()
          != other.getUseFeasibilityPolishing()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasTerminationCriteria()) {
      hash = (37 * hash) + TERMINATION_CRITERIA_FIELD_NUMBER;
      hash = (53 * hash) + getTerminationCriteria().hashCode();
    }
    if (hasNumThreads()) {
      hash = (37 * hash) + NUM_THREADS_FIELD_NUMBER;
      hash = (53 * hash) + getNumThreads();
    }
    if (hasNumShards()) {
      hash = (37 * hash) + NUM_SHARDS_FIELD_NUMBER;
      hash = (53 * hash) + getNumShards();
    }
    if (hasRecordIterationStats()) {
      hash = (37 * hash) + RECORD_ITERATION_STATS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getRecordIterationStats());
    }
    if (hasVerbosityLevel()) {
      hash = (37 * hash) + VERBOSITY_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + getVerbosityLevel();
    }
    if (hasLogIntervalSeconds()) {
      hash = (37 * hash) + LOG_INTERVAL_SECONDS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getLogIntervalSeconds()));
    }
    if (hasMajorIterationFrequency()) {
      hash = (37 * hash) + MAJOR_ITERATION_FREQUENCY_FIELD_NUMBER;
      hash = (53 * hash) + getMajorIterationFrequency();
    }
    if (hasTerminationCheckFrequency()) {
      hash = (37 * hash) + TERMINATION_CHECK_FREQUENCY_FIELD_NUMBER;
      hash = (53 * hash) + getTerminationCheckFrequency();
    }
    if (hasRestartStrategy()) {
      hash = (37 * hash) + RESTART_STRATEGY_FIELD_NUMBER;
      hash = (53 * hash) + restartStrategy_;
    }
    if (hasPrimalWeightUpdateSmoothing()) {
      hash = (37 * hash) + PRIMAL_WEIGHT_UPDATE_SMOOTHING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getPrimalWeightUpdateSmoothing()));
    }
    if (hasInitialPrimalWeight()) {
      hash = (37 * hash) + INITIAL_PRIMAL_WEIGHT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getInitialPrimalWeight()));
    }
    if (hasPresolveOptions()) {
      hash = (37 * hash) + PRESOLVE_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getPresolveOptions().hashCode();
    }
    if (hasLInfRuizIterations()) {
      hash = (37 * hash) + L_INF_RUIZ_ITERATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getLInfRuizIterations();
    }
    if (hasL2NormRescaling()) {
      hash = (37 * hash) + L2_NORM_RESCALING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getL2NormRescaling());
    }
    if (hasSufficientReductionForRestart()) {
      hash = (37 * hash) + SUFFICIENT_REDUCTION_FOR_RESTART_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getSufficientReductionForRestart()));
    }
    if (hasNecessaryReductionForRestart()) {
      hash = (37 * hash) + NECESSARY_REDUCTION_FOR_RESTART_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getNecessaryReductionForRestart()));
    }
    if (hasLinesearchRule()) {
      hash = (37 * hash) + LINESEARCH_RULE_FIELD_NUMBER;
      hash = (53 * hash) + linesearchRule_;
    }
    if (hasAdaptiveLinesearchParameters()) {
      hash = (37 * hash) + ADAPTIVE_LINESEARCH_PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getAdaptiveLinesearchParameters().hashCode();
    }
    if (hasMalitskyPockParameters()) {
      hash = (37 * hash) + MALITSKY_POCK_PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getMalitskyPockParameters().hashCode();
    }
    if (hasInitialStepSizeScaling()) {
      hash = (37 * hash) + INITIAL_STEP_SIZE_SCALING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getInitialStepSizeScaling()));
    }
    if (getRandomProjectionSeedsCount() > 0) {
      hash = (37 * hash) + RANDOM_PROJECTION_SEEDS_FIELD_NUMBER;
      hash = (53 * hash) + getRandomProjectionSeedsList().hashCode();
    }
    if (hasInfiniteConstraintBoundThreshold()) {
      hash = (37 * hash) + INFINITE_CONSTRAINT_BOUND_THRESHOLD_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getInfiniteConstraintBoundThreshold()));
    }
    if (hasHandleSomePrimalGradientsOnFiniteBoundsAsResiduals()) {
      hash = (37 * hash) + HANDLE_SOME_PRIMAL_GRADIENTS_ON_FINITE_BOUNDS_AS_RESIDUALS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getHandleSomePrimalGradientsOnFiniteBoundsAsResiduals());
    }
    if (hasUseDiagonalQpTrustRegionSolver()) {
      hash = (37 * hash) + USE_DIAGONAL_QP_TRUST_REGION_SOLVER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseDiagonalQpTrustRegionSolver());
    }
    if (hasDiagonalQpTrustRegionSolverTolerance()) {
      hash = (37 * hash) + DIAGONAL_QP_TRUST_REGION_SOLVER_TOLERANCE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getDiagonalQpTrustRegionSolverTolerance()));
    }
    if (hasUseFeasibilityPolishing()) {
      hash = (37 * hash) + USE_FEASIBILITY_POLISHING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseFeasibilityPolishing());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ortools.pdlp.PrimalDualHybridGradientParams parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.pdlp.PrimalDualHybridGradientParams parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.pdlp.PrimalDualHybridGradientParams parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.pdlp.PrimalDualHybridGradientParams parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.pdlp.PrimalDualHybridGradientParams parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.pdlp.PrimalDualHybridGradientParams parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.pdlp.PrimalDualHybridGradientParams parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.pdlp.PrimalDualHybridGradientParams parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ortools.pdlp.PrimalDualHybridGradientParams parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ortools.pdlp.PrimalDualHybridGradientParams parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ortools.pdlp.PrimalDualHybridGradientParams parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.pdlp.PrimalDualHybridGradientParams parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ortools.pdlp.PrimalDualHybridGradientParams prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Parameters for PrimalDualHybridGradient() in primal_dual_hybrid_gradient.h.
   * While the defaults are generally good, it is usually worthwhile to perform a
   * parameter sweep to find good settings for a particular family of problems.
   * The following parameters should be considered for tuning:
   * - restart_strategy (jointly with major_iteration_frequency)
   * - primal_weight_update_smoothing (jointly with initial_primal_weight)
   * - presolve_options.use_glop
   * - l_inf_ruiz_iterations
   * - l2_norm_rescaling
   * In addition, tune num_threads to speed up the solve.
   * </pre>
   *
   * Protobuf type {@code operations_research.pdlp.PrimalDualHybridGradientParams}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessage.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:operations_research.pdlp.PrimalDualHybridGradientParams)
      com.google.ortools.pdlp.PrimalDualHybridGradientParamsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ortools.pdlp.Solvers.internal_static_operations_research_pdlp_PrimalDualHybridGradientParams_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ortools.pdlp.Solvers.internal_static_operations_research_pdlp_PrimalDualHybridGradientParams_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ortools.pdlp.PrimalDualHybridGradientParams.class, com.google.ortools.pdlp.PrimalDualHybridGradientParams.Builder.class);
    }

    // Construct using com.google.ortools.pdlp.PrimalDualHybridGradientParams.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessage
              .alwaysUseFieldBuilders) {
        getTerminationCriteriaFieldBuilder();
        getPresolveOptionsFieldBuilder();
        getAdaptiveLinesearchParametersFieldBuilder();
        getMalitskyPockParametersFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      terminationCriteria_ = null;
      if (terminationCriteriaBuilder_ != null) {
        terminationCriteriaBuilder_.dispose();
        terminationCriteriaBuilder_ = null;
      }
      numThreads_ = 1;
      numShards_ = 0;
      recordIterationStats_ = false;
      verbosityLevel_ = 0;
      logIntervalSeconds_ = 0D;
      majorIterationFrequency_ = 64;
      terminationCheckFrequency_ = 64;
      restartStrategy_ = 3;
      primalWeightUpdateSmoothing_ = 0.5D;
      initialPrimalWeight_ = 0D;
      presolveOptions_ = null;
      if (presolveOptionsBuilder_ != null) {
        presolveOptionsBuilder_.dispose();
        presolveOptionsBuilder_ = null;
      }
      lInfRuizIterations_ = 5;
      l2NormRescaling_ = true;
      sufficientReductionForRestart_ = 0.1D;
      necessaryReductionForRestart_ = 0.9D;
      linesearchRule_ = 1;
      adaptiveLinesearchParameters_ = null;
      if (adaptiveLinesearchParametersBuilder_ != null) {
        adaptiveLinesearchParametersBuilder_.dispose();
        adaptiveLinesearchParametersBuilder_ = null;
      }
      malitskyPockParameters_ = null;
      if (malitskyPockParametersBuilder_ != null) {
        malitskyPockParametersBuilder_.dispose();
        malitskyPockParametersBuilder_ = null;
      }
      initialStepSizeScaling_ = 1D;
      randomProjectionSeeds_ = emptyIntList();
      infiniteConstraintBoundThreshold_ = Double.POSITIVE_INFINITY;
      handleSomePrimalGradientsOnFiniteBoundsAsResiduals_ = true;
      useDiagonalQpTrustRegionSolver_ = false;
      diagonalQpTrustRegionSolverTolerance_ = 1e-08D;
      useFeasibilityPolishing_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ortools.pdlp.Solvers.internal_static_operations_research_pdlp_PrimalDualHybridGradientParams_descriptor;
    }

    @java.lang.Override
    public com.google.ortools.pdlp.PrimalDualHybridGradientParams getDefaultInstanceForType() {
      return com.google.ortools.pdlp.PrimalDualHybridGradientParams.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ortools.pdlp.PrimalDualHybridGradientParams build() {
      com.google.ortools.pdlp.PrimalDualHybridGradientParams result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ortools.pdlp.PrimalDualHybridGradientParams buildPartial() {
      com.google.ortools.pdlp.PrimalDualHybridGradientParams result = new com.google.ortools.pdlp.PrimalDualHybridGradientParams(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.ortools.pdlp.PrimalDualHybridGradientParams result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.terminationCriteria_ = terminationCriteriaBuilder_ == null
            ? terminationCriteria_
            : terminationCriteriaBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.numThreads_ = numThreads_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.numShards_ = numShards_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.recordIterationStats_ = recordIterationStats_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.verbosityLevel_ = verbosityLevel_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.logIntervalSeconds_ = logIntervalSeconds_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.majorIterationFrequency_ = majorIterationFrequency_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.terminationCheckFrequency_ = terminationCheckFrequency_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.restartStrategy_ = restartStrategy_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.primalWeightUpdateSmoothing_ = primalWeightUpdateSmoothing_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.initialPrimalWeight_ = initialPrimalWeight_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.presolveOptions_ = presolveOptionsBuilder_ == null
            ? presolveOptions_
            : presolveOptionsBuilder_.build();
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.lInfRuizIterations_ = lInfRuizIterations_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.l2NormRescaling_ = l2NormRescaling_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.sufficientReductionForRestart_ = sufficientReductionForRestart_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.necessaryReductionForRestart_ = necessaryReductionForRestart_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.linesearchRule_ = linesearchRule_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.adaptiveLinesearchParameters_ = adaptiveLinesearchParametersBuilder_ == null
            ? adaptiveLinesearchParameters_
            : adaptiveLinesearchParametersBuilder_.build();
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.malitskyPockParameters_ = malitskyPockParametersBuilder_ == null
            ? malitskyPockParameters_
            : malitskyPockParametersBuilder_.build();
        to_bitField0_ |= 0x00040000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.initialStepSizeScaling_ = initialStepSizeScaling_;
        to_bitField0_ |= 0x00080000;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        randomProjectionSeeds_.makeImmutable();
        result.randomProjectionSeeds_ = randomProjectionSeeds_;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.infiniteConstraintBoundThreshold_ = infiniteConstraintBoundThreshold_;
        to_bitField0_ |= 0x00100000;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.handleSomePrimalGradientsOnFiniteBoundsAsResiduals_ = handleSomePrimalGradientsOnFiniteBoundsAsResiduals_;
        to_bitField0_ |= 0x00200000;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.useDiagonalQpTrustRegionSolver_ = useDiagonalQpTrustRegionSolver_;
        to_bitField0_ |= 0x00400000;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.diagonalQpTrustRegionSolverTolerance_ = diagonalQpTrustRegionSolverTolerance_;
        to_bitField0_ |= 0x00800000;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.useFeasibilityPolishing_ = useFeasibilityPolishing_;
        to_bitField0_ |= 0x01000000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ortools.pdlp.PrimalDualHybridGradientParams) {
        return mergeFrom((com.google.ortools.pdlp.PrimalDualHybridGradientParams)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ortools.pdlp.PrimalDualHybridGradientParams other) {
      if (other == com.google.ortools.pdlp.PrimalDualHybridGradientParams.getDefaultInstance()) return this;
      if (other.hasTerminationCriteria()) {
        mergeTerminationCriteria(other.getTerminationCriteria());
      }
      if (other.hasNumThreads()) {
        setNumThreads(other.getNumThreads());
      }
      if (other.hasNumShards()) {
        setNumShards(other.getNumShards());
      }
      if (other.hasRecordIterationStats()) {
        setRecordIterationStats(other.getRecordIterationStats());
      }
      if (other.hasVerbosityLevel()) {
        setVerbosityLevel(other.getVerbosityLevel());
      }
      if (other.hasLogIntervalSeconds()) {
        setLogIntervalSeconds(other.getLogIntervalSeconds());
      }
      if (other.hasMajorIterationFrequency()) {
        setMajorIterationFrequency(other.getMajorIterationFrequency());
      }
      if (other.hasTerminationCheckFrequency()) {
        setTerminationCheckFrequency(other.getTerminationCheckFrequency());
      }
      if (other.hasRestartStrategy()) {
        setRestartStrategy(other.getRestartStrategy());
      }
      if (other.hasPrimalWeightUpdateSmoothing()) {
        setPrimalWeightUpdateSmoothing(other.getPrimalWeightUpdateSmoothing());
      }
      if (other.hasInitialPrimalWeight()) {
        setInitialPrimalWeight(other.getInitialPrimalWeight());
      }
      if (other.hasPresolveOptions()) {
        mergePresolveOptions(other.getPresolveOptions());
      }
      if (other.hasLInfRuizIterations()) {
        setLInfRuizIterations(other.getLInfRuizIterations());
      }
      if (other.hasL2NormRescaling()) {
        setL2NormRescaling(other.getL2NormRescaling());
      }
      if (other.hasSufficientReductionForRestart()) {
        setSufficientReductionForRestart(other.getSufficientReductionForRestart());
      }
      if (other.hasNecessaryReductionForRestart()) {
        setNecessaryReductionForRestart(other.getNecessaryReductionForRestart());
      }
      if (other.hasLinesearchRule()) {
        setLinesearchRule(other.getLinesearchRule());
      }
      if (other.hasAdaptiveLinesearchParameters()) {
        mergeAdaptiveLinesearchParameters(other.getAdaptiveLinesearchParameters());
      }
      if (other.hasMalitskyPockParameters()) {
        mergeMalitskyPockParameters(other.getMalitskyPockParameters());
      }
      if (other.hasInitialStepSizeScaling()) {
        setInitialStepSizeScaling(other.getInitialStepSizeScaling());
      }
      if (!other.randomProjectionSeeds_.isEmpty()) {
        if (randomProjectionSeeds_.isEmpty()) {
          randomProjectionSeeds_ = other.randomProjectionSeeds_;
          randomProjectionSeeds_.makeImmutable();
          bitField0_ |= 0x00100000;
        } else {
          ensureRandomProjectionSeedsIsMutable();
          randomProjectionSeeds_.addAll(other.randomProjectionSeeds_);
        }
        onChanged();
      }
      if (other.hasInfiniteConstraintBoundThreshold()) {
        setInfiniteConstraintBoundThreshold(other.getInfiniteConstraintBoundThreshold());
      }
      if (other.hasHandleSomePrimalGradientsOnFiniteBoundsAsResiduals()) {
        setHandleSomePrimalGradientsOnFiniteBoundsAsResiduals(other.getHandleSomePrimalGradientsOnFiniteBoundsAsResiduals());
      }
      if (other.hasUseDiagonalQpTrustRegionSolver()) {
        setUseDiagonalQpTrustRegionSolver(other.getUseDiagonalQpTrustRegionSolver());
      }
      if (other.hasDiagonalQpTrustRegionSolverTolerance()) {
        setDiagonalQpTrustRegionSolverTolerance(other.getDiagonalQpTrustRegionSolverTolerance());
      }
      if (other.hasUseFeasibilityPolishing()) {
        setUseFeasibilityPolishing(other.getUseFeasibilityPolishing());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              input.readMessage(
                  getTerminationCriteriaFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 16: {
              numThreads_ = input.readInt32();
              bitField0_ |= 0x00000002;
              break;
            } // case 16
            case 24: {
              recordIterationStats_ = input.readBool();
              bitField0_ |= 0x00000008;
              break;
            } // case 24
            case 32: {
              majorIterationFrequency_ = input.readInt32();
              bitField0_ |= 0x00000040;
              break;
            } // case 32
            case 40: {
              terminationCheckFrequency_ = input.readInt32();
              bitField0_ |= 0x00000080;
              break;
            } // case 40
            case 48: {
              int tmpRaw = input.readEnum();
              com.google.ortools.pdlp.PrimalDualHybridGradientParams.RestartStrategy tmpValue =
                  com.google.ortools.pdlp.PrimalDualHybridGradientParams.RestartStrategy.forNumber(tmpRaw);
              if (tmpValue == null) {
                mergeUnknownVarintField(6, tmpRaw);
              } else {
                restartStrategy_ = tmpRaw;
                bitField0_ |= 0x00000100;
              }
              break;
            } // case 48
            case 57: {
              primalWeightUpdateSmoothing_ = input.readDouble();
              bitField0_ |= 0x00000200;
              break;
            } // case 57
            case 65: {
              initialPrimalWeight_ = input.readDouble();
              bitField0_ |= 0x00000400;
              break;
            } // case 65
            case 72: {
              lInfRuizIterations_ = input.readInt32();
              bitField0_ |= 0x00001000;
              break;
            } // case 72
            case 80: {
              l2NormRescaling_ = input.readBool();
              bitField0_ |= 0x00002000;
              break;
            } // case 80
            case 89: {
              sufficientReductionForRestart_ = input.readDouble();
              bitField0_ |= 0x00004000;
              break;
            } // case 89
            case 96: {
              int tmpRaw = input.readEnum();
              com.google.ortools.pdlp.PrimalDualHybridGradientParams.LinesearchRule tmpValue =
                  com.google.ortools.pdlp.PrimalDualHybridGradientParams.LinesearchRule.forNumber(tmpRaw);
              if (tmpValue == null) {
                mergeUnknownVarintField(12, tmpRaw);
              } else {
                linesearchRule_ = tmpRaw;
                bitField0_ |= 0x00010000;
              }
              break;
            } // case 96
            case 130: {
              input.readMessage(
                  getPresolveOptionsFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000800;
              break;
            } // case 130
            case 137: {
              necessaryReductionForRestart_ = input.readDouble();
              bitField0_ |= 0x00008000;
              break;
            } // case 137
            case 146: {
              input.readMessage(
                  getAdaptiveLinesearchParametersFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00020000;
              break;
            } // case 146
            case 154: {
              input.readMessage(
                  getMalitskyPockParametersFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00040000;
              break;
            } // case 154
            case 177: {
              infiniteConstraintBoundThreshold_ = input.readDouble();
              bitField0_ |= 0x00200000;
              break;
            } // case 177
            case 184: {
              useDiagonalQpTrustRegionSolver_ = input.readBool();
              bitField0_ |= 0x00800000;
              break;
            } // case 184
            case 193: {
              diagonalQpTrustRegionSolverTolerance_ = input.readDouble();
              bitField0_ |= 0x01000000;
              break;
            } // case 193
            case 201: {
              initialStepSizeScaling_ = input.readDouble();
              bitField0_ |= 0x00080000;
              break;
            } // case 201
            case 208: {
              verbosityLevel_ = input.readInt32();
              bitField0_ |= 0x00000010;
              break;
            } // case 208
            case 216: {
              numShards_ = input.readInt32();
              bitField0_ |= 0x00000004;
              break;
            } // case 216
            case 224: {
              int v = input.readInt32();
              ensureRandomProjectionSeedsIsMutable();
              randomProjectionSeeds_.addInt(v);
              break;
            } // case 224
            case 226: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              ensureRandomProjectionSeedsIsMutable();
              while (input.getBytesUntilLimit() > 0) {
                randomProjectionSeeds_.addInt(input.readInt32());
              }
              input.popLimit(limit);
              break;
            } // case 226
            case 232: {
              handleSomePrimalGradientsOnFiniteBoundsAsResiduals_ = input.readBool();
              bitField0_ |= 0x00400000;
              break;
            } // case 232
            case 240: {
              useFeasibilityPolishing_ = input.readBool();
              bitField0_ |= 0x02000000;
              break;
            } // case 240
            case 249: {
              logIntervalSeconds_ = input.readDouble();
              bitField0_ |= 0x00000020;
              break;
            } // case 249
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private com.google.ortools.pdlp.TerminationCriteria terminationCriteria_;
    private com.google.protobuf.SingleFieldBuilder<
        com.google.ortools.pdlp.TerminationCriteria, com.google.ortools.pdlp.TerminationCriteria.Builder, com.google.ortools.pdlp.TerminationCriteriaOrBuilder> terminationCriteriaBuilder_;
    /**
     * <code>optional .operations_research.pdlp.TerminationCriteria termination_criteria = 1;</code>
     * @return Whether the terminationCriteria field is set.
     */
    public boolean hasTerminationCriteria() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional .operations_research.pdlp.TerminationCriteria termination_criteria = 1;</code>
     * @return The terminationCriteria.
     */
    public com.google.ortools.pdlp.TerminationCriteria getTerminationCriteria() {
      if (terminationCriteriaBuilder_ == null) {
        return terminationCriteria_ == null ? com.google.ortools.pdlp.TerminationCriteria.getDefaultInstance() : terminationCriteria_;
      } else {
        return terminationCriteriaBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .operations_research.pdlp.TerminationCriteria termination_criteria = 1;</code>
     */
    public Builder setTerminationCriteria(com.google.ortools.pdlp.TerminationCriteria value) {
      if (terminationCriteriaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        terminationCriteria_ = value;
      } else {
        terminationCriteriaBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.pdlp.TerminationCriteria termination_criteria = 1;</code>
     */
    public Builder setTerminationCriteria(
        com.google.ortools.pdlp.TerminationCriteria.Builder builderForValue) {
      if (terminationCriteriaBuilder_ == null) {
        terminationCriteria_ = builderForValue.build();
      } else {
        terminationCriteriaBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.pdlp.TerminationCriteria termination_criteria = 1;</code>
     */
    public Builder mergeTerminationCriteria(com.google.ortools.pdlp.TerminationCriteria value) {
      if (terminationCriteriaBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0) &&
          terminationCriteria_ != null &&
          terminationCriteria_ != com.google.ortools.pdlp.TerminationCriteria.getDefaultInstance()) {
          getTerminationCriteriaBuilder().mergeFrom(value);
        } else {
          terminationCriteria_ = value;
        }
      } else {
        terminationCriteriaBuilder_.mergeFrom(value);
      }
      if (terminationCriteria_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     * <code>optional .operations_research.pdlp.TerminationCriteria termination_criteria = 1;</code>
     */
    public Builder clearTerminationCriteria() {
      bitField0_ = (bitField0_ & ~0x00000001);
      terminationCriteria_ = null;
      if (terminationCriteriaBuilder_ != null) {
        terminationCriteriaBuilder_.dispose();
        terminationCriteriaBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.pdlp.TerminationCriteria termination_criteria = 1;</code>
     */
    public com.google.ortools.pdlp.TerminationCriteria.Builder getTerminationCriteriaBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getTerminationCriteriaFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .operations_research.pdlp.TerminationCriteria termination_criteria = 1;</code>
     */
    public com.google.ortools.pdlp.TerminationCriteriaOrBuilder getTerminationCriteriaOrBuilder() {
      if (terminationCriteriaBuilder_ != null) {
        return terminationCriteriaBuilder_.getMessageOrBuilder();
      } else {
        return terminationCriteria_ == null ?
            com.google.ortools.pdlp.TerminationCriteria.getDefaultInstance() : terminationCriteria_;
      }
    }
    /**
     * <code>optional .operations_research.pdlp.TerminationCriteria termination_criteria = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
        com.google.ortools.pdlp.TerminationCriteria, com.google.ortools.pdlp.TerminationCriteria.Builder, com.google.ortools.pdlp.TerminationCriteriaOrBuilder> 
        getTerminationCriteriaFieldBuilder() {
      if (terminationCriteriaBuilder_ == null) {
        terminationCriteriaBuilder_ = new com.google.protobuf.SingleFieldBuilder<
            com.google.ortools.pdlp.TerminationCriteria, com.google.ortools.pdlp.TerminationCriteria.Builder, com.google.ortools.pdlp.TerminationCriteriaOrBuilder>(
                getTerminationCriteria(),
                getParentForChildren(),
                isClean());
        terminationCriteria_ = null;
      }
      return terminationCriteriaBuilder_;
    }

    private int numThreads_ = 1;
    /**
     * <pre>
     * The number of threads to use. Must be positive.
     * Try various values of num_threads, up to the number of physical cores.
     * Performance may not be monotonically increasing with the number of threads
     * because of memory bandwidth limitations.
     * </pre>
     *
     * <code>optional int32 num_threads = 2 [default = 1];</code>
     * @return Whether the numThreads field is set.
     */
    @java.lang.Override
    public boolean hasNumThreads() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * The number of threads to use. Must be positive.
     * Try various values of num_threads, up to the number of physical cores.
     * Performance may not be monotonically increasing with the number of threads
     * because of memory bandwidth limitations.
     * </pre>
     *
     * <code>optional int32 num_threads = 2 [default = 1];</code>
     * @return The numThreads.
     */
    @java.lang.Override
    public int getNumThreads() {
      return numThreads_;
    }
    /**
     * <pre>
     * The number of threads to use. Must be positive.
     * Try various values of num_threads, up to the number of physical cores.
     * Performance may not be monotonically increasing with the number of threads
     * because of memory bandwidth limitations.
     * </pre>
     *
     * <code>optional int32 num_threads = 2 [default = 1];</code>
     * @param value The numThreads to set.
     * @return This builder for chaining.
     */
    public Builder setNumThreads(int value) {

      numThreads_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The number of threads to use. Must be positive.
     * Try various values of num_threads, up to the number of physical cores.
     * Performance may not be monotonically increasing with the number of threads
     * because of memory bandwidth limitations.
     * </pre>
     *
     * <code>optional int32 num_threads = 2 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearNumThreads() {
      bitField0_ = (bitField0_ & ~0x00000002);
      numThreads_ = 1;
      onChanged();
      return this;
    }

    private int numShards_ ;
    /**
     * <pre>
     * For more efficient parallel computation, the matrices and vectors are
     * divided (virtually) into num_shards shards. Results are computed
     * independently for each shard and then combined. As a consequence, the order
     * of computation, and hence floating point roundoff, depends on the number of
     * shards so reproducible results require using the same value for num_shards.
     * However, for efficiency num_shards should a be at least num_threads, and
     * preferably at least 4*num_threads to allow better load balancing. If
     * num_shards is positive, the computation will use that many shards.
     * Otherwise a default that depends on num_threads will be used.
     * </pre>
     *
     * <code>optional int32 num_shards = 27 [default = 0];</code>
     * @return Whether the numShards field is set.
     */
    @java.lang.Override
    public boolean hasNumShards() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * For more efficient parallel computation, the matrices and vectors are
     * divided (virtually) into num_shards shards. Results are computed
     * independently for each shard and then combined. As a consequence, the order
     * of computation, and hence floating point roundoff, depends on the number of
     * shards so reproducible results require using the same value for num_shards.
     * However, for efficiency num_shards should a be at least num_threads, and
     * preferably at least 4*num_threads to allow better load balancing. If
     * num_shards is positive, the computation will use that many shards.
     * Otherwise a default that depends on num_threads will be used.
     * </pre>
     *
     * <code>optional int32 num_shards = 27 [default = 0];</code>
     * @return The numShards.
     */
    @java.lang.Override
    public int getNumShards() {
      return numShards_;
    }
    /**
     * <pre>
     * For more efficient parallel computation, the matrices and vectors are
     * divided (virtually) into num_shards shards. Results are computed
     * independently for each shard and then combined. As a consequence, the order
     * of computation, and hence floating point roundoff, depends on the number of
     * shards so reproducible results require using the same value for num_shards.
     * However, for efficiency num_shards should a be at least num_threads, and
     * preferably at least 4*num_threads to allow better load balancing. If
     * num_shards is positive, the computation will use that many shards.
     * Otherwise a default that depends on num_threads will be used.
     * </pre>
     *
     * <code>optional int32 num_shards = 27 [default = 0];</code>
     * @param value The numShards to set.
     * @return This builder for chaining.
     */
    public Builder setNumShards(int value) {

      numShards_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * For more efficient parallel computation, the matrices and vectors are
     * divided (virtually) into num_shards shards. Results are computed
     * independently for each shard and then combined. As a consequence, the order
     * of computation, and hence floating point roundoff, depends on the number of
     * shards so reproducible results require using the same value for num_shards.
     * However, for efficiency num_shards should a be at least num_threads, and
     * preferably at least 4*num_threads to allow better load balancing. If
     * num_shards is positive, the computation will use that many shards.
     * Otherwise a default that depends on num_threads will be used.
     * </pre>
     *
     * <code>optional int32 num_shards = 27 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearNumShards() {
      bitField0_ = (bitField0_ & ~0x00000004);
      numShards_ = 0;
      onChanged();
      return this;
    }

    private boolean recordIterationStats_ ;
    /**
     * <pre>
     * If true, the iteration_stats field of the SolveLog output will be populated
     * at every iteration. Note that we only compute solution statistics at
     * termination checks. Setting this parameter to true may substantially
     * increase the size of the output.
     * </pre>
     *
     * <code>optional bool record_iteration_stats = 3;</code>
     * @return Whether the recordIterationStats field is set.
     */
    @java.lang.Override
    public boolean hasRecordIterationStats() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * If true, the iteration_stats field of the SolveLog output will be populated
     * at every iteration. Note that we only compute solution statistics at
     * termination checks. Setting this parameter to true may substantially
     * increase the size of the output.
     * </pre>
     *
     * <code>optional bool record_iteration_stats = 3;</code>
     * @return The recordIterationStats.
     */
    @java.lang.Override
    public boolean getRecordIterationStats() {
      return recordIterationStats_;
    }
    /**
     * <pre>
     * If true, the iteration_stats field of the SolveLog output will be populated
     * at every iteration. Note that we only compute solution statistics at
     * termination checks. Setting this parameter to true may substantially
     * increase the size of the output.
     * </pre>
     *
     * <code>optional bool record_iteration_stats = 3;</code>
     * @param value The recordIterationStats to set.
     * @return This builder for chaining.
     */
    public Builder setRecordIterationStats(boolean value) {

      recordIterationStats_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, the iteration_stats field of the SolveLog output will be populated
     * at every iteration. Note that we only compute solution statistics at
     * termination checks. Setting this parameter to true may substantially
     * increase the size of the output.
     * </pre>
     *
     * <code>optional bool record_iteration_stats = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearRecordIterationStats() {
      bitField0_ = (bitField0_ & ~0x00000008);
      recordIterationStats_ = false;
      onChanged();
      return this;
    }

    private int verbosityLevel_ ;
    /**
     * <pre>
     * The verbosity of logging.
     * 0: No informational logging. (Errors are logged.)
     * 1: Summary statistics only. No iteration-level details.
     * 2: A table of iteration-level statistics is logged.
     * (See ToShortString() in primal_dual_hybrid_gradient.cc).
     * 3: A more detailed table of iteration-level statistics is logged.
     * (See ToString() in primal_dual_hybrid_gradient.cc).
     * 4: For iteration-level details, prints the statistics of both the average
     * (prefixed with A) and the current iterate (prefixed with C). Also prints
     * internal algorithmic state and details.
     * Logging at levels 2-4 also includes messages from level 1.
     * </pre>
     *
     * <code>optional int32 verbosity_level = 26 [default = 0];</code>
     * @return Whether the verbosityLevel field is set.
     */
    @java.lang.Override
    public boolean hasVerbosityLevel() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * The verbosity of logging.
     * 0: No informational logging. (Errors are logged.)
     * 1: Summary statistics only. No iteration-level details.
     * 2: A table of iteration-level statistics is logged.
     * (See ToShortString() in primal_dual_hybrid_gradient.cc).
     * 3: A more detailed table of iteration-level statistics is logged.
     * (See ToString() in primal_dual_hybrid_gradient.cc).
     * 4: For iteration-level details, prints the statistics of both the average
     * (prefixed with A) and the current iterate (prefixed with C). Also prints
     * internal algorithmic state and details.
     * Logging at levels 2-4 also includes messages from level 1.
     * </pre>
     *
     * <code>optional int32 verbosity_level = 26 [default = 0];</code>
     * @return The verbosityLevel.
     */
    @java.lang.Override
    public int getVerbosityLevel() {
      return verbosityLevel_;
    }
    /**
     * <pre>
     * The verbosity of logging.
     * 0: No informational logging. (Errors are logged.)
     * 1: Summary statistics only. No iteration-level details.
     * 2: A table of iteration-level statistics is logged.
     * (See ToShortString() in primal_dual_hybrid_gradient.cc).
     * 3: A more detailed table of iteration-level statistics is logged.
     * (See ToString() in primal_dual_hybrid_gradient.cc).
     * 4: For iteration-level details, prints the statistics of both the average
     * (prefixed with A) and the current iterate (prefixed with C). Also prints
     * internal algorithmic state and details.
     * Logging at levels 2-4 also includes messages from level 1.
     * </pre>
     *
     * <code>optional int32 verbosity_level = 26 [default = 0];</code>
     * @param value The verbosityLevel to set.
     * @return This builder for chaining.
     */
    public Builder setVerbosityLevel(int value) {

      verbosityLevel_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The verbosity of logging.
     * 0: No informational logging. (Errors are logged.)
     * 1: Summary statistics only. No iteration-level details.
     * 2: A table of iteration-level statistics is logged.
     * (See ToShortString() in primal_dual_hybrid_gradient.cc).
     * 3: A more detailed table of iteration-level statistics is logged.
     * (See ToString() in primal_dual_hybrid_gradient.cc).
     * 4: For iteration-level details, prints the statistics of both the average
     * (prefixed with A) and the current iterate (prefixed with C). Also prints
     * internal algorithmic state and details.
     * Logging at levels 2-4 also includes messages from level 1.
     * </pre>
     *
     * <code>optional int32 verbosity_level = 26 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearVerbosityLevel() {
      bitField0_ = (bitField0_ & ~0x00000010);
      verbosityLevel_ = 0;
      onChanged();
      return this;
    }

    private double logIntervalSeconds_ ;
    /**
     * <pre>
     * Time between iteration-level statistics logging (if `verbosity_level &gt; 1`).
     * Since iteration-level statistics are only generated when performing
     * termination checks, logs will be generated from next termination check
     * after `log_interval_seconds` have elapsed. Should be &gt;= 0.0. 0.0 (the
     * default) means log statistics at every termination check.
     * </pre>
     *
     * <code>optional double log_interval_seconds = 31 [default = 0];</code>
     * @return Whether the logIntervalSeconds field is set.
     */
    @java.lang.Override
    public boolean hasLogIntervalSeconds() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * Time between iteration-level statistics logging (if `verbosity_level &gt; 1`).
     * Since iteration-level statistics are only generated when performing
     * termination checks, logs will be generated from next termination check
     * after `log_interval_seconds` have elapsed. Should be &gt;= 0.0. 0.0 (the
     * default) means log statistics at every termination check.
     * </pre>
     *
     * <code>optional double log_interval_seconds = 31 [default = 0];</code>
     * @return The logIntervalSeconds.
     */
    @java.lang.Override
    public double getLogIntervalSeconds() {
      return logIntervalSeconds_;
    }
    /**
     * <pre>
     * Time between iteration-level statistics logging (if `verbosity_level &gt; 1`).
     * Since iteration-level statistics are only generated when performing
     * termination checks, logs will be generated from next termination check
     * after `log_interval_seconds` have elapsed. Should be &gt;= 0.0. 0.0 (the
     * default) means log statistics at every termination check.
     * </pre>
     *
     * <code>optional double log_interval_seconds = 31 [default = 0];</code>
     * @param value The logIntervalSeconds to set.
     * @return This builder for chaining.
     */
    public Builder setLogIntervalSeconds(double value) {

      logIntervalSeconds_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Time between iteration-level statistics logging (if `verbosity_level &gt; 1`).
     * Since iteration-level statistics are only generated when performing
     * termination checks, logs will be generated from next termination check
     * after `log_interval_seconds` have elapsed. Should be &gt;= 0.0. 0.0 (the
     * default) means log statistics at every termination check.
     * </pre>
     *
     * <code>optional double log_interval_seconds = 31 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearLogIntervalSeconds() {
      bitField0_ = (bitField0_ & ~0x00000020);
      logIntervalSeconds_ = 0D;
      onChanged();
      return this;
    }

    private int majorIterationFrequency_ = 64;
    /**
     * <pre>
     * The frequency at which extra work is performed to make major algorithmic
     * decisions, e.g., performing restarts and updating the primal weight. Major
     * iterations also trigger a termination check. For best performance using the
     * NO_RESTARTS or EVERY_MAJOR_ITERATION rule, one should perform a log-scale
     * grid search over this parameter, for example, over powers of two.
     * ADAPTIVE_HEURISTIC is mostly insensitive to this value.
     * </pre>
     *
     * <code>optional int32 major_iteration_frequency = 4 [default = 64];</code>
     * @return Whether the majorIterationFrequency field is set.
     */
    @java.lang.Override
    public boolean hasMajorIterationFrequency() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * The frequency at which extra work is performed to make major algorithmic
     * decisions, e.g., performing restarts and updating the primal weight. Major
     * iterations also trigger a termination check. For best performance using the
     * NO_RESTARTS or EVERY_MAJOR_ITERATION rule, one should perform a log-scale
     * grid search over this parameter, for example, over powers of two.
     * ADAPTIVE_HEURISTIC is mostly insensitive to this value.
     * </pre>
     *
     * <code>optional int32 major_iteration_frequency = 4 [default = 64];</code>
     * @return The majorIterationFrequency.
     */
    @java.lang.Override
    public int getMajorIterationFrequency() {
      return majorIterationFrequency_;
    }
    /**
     * <pre>
     * The frequency at which extra work is performed to make major algorithmic
     * decisions, e.g., performing restarts and updating the primal weight. Major
     * iterations also trigger a termination check. For best performance using the
     * NO_RESTARTS or EVERY_MAJOR_ITERATION rule, one should perform a log-scale
     * grid search over this parameter, for example, over powers of two.
     * ADAPTIVE_HEURISTIC is mostly insensitive to this value.
     * </pre>
     *
     * <code>optional int32 major_iteration_frequency = 4 [default = 64];</code>
     * @param value The majorIterationFrequency to set.
     * @return This builder for chaining.
     */
    public Builder setMajorIterationFrequency(int value) {

      majorIterationFrequency_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The frequency at which extra work is performed to make major algorithmic
     * decisions, e.g., performing restarts and updating the primal weight. Major
     * iterations also trigger a termination check. For best performance using the
     * NO_RESTARTS or EVERY_MAJOR_ITERATION rule, one should perform a log-scale
     * grid search over this parameter, for example, over powers of two.
     * ADAPTIVE_HEURISTIC is mostly insensitive to this value.
     * </pre>
     *
     * <code>optional int32 major_iteration_frequency = 4 [default = 64];</code>
     * @return This builder for chaining.
     */
    public Builder clearMajorIterationFrequency() {
      bitField0_ = (bitField0_ & ~0x00000040);
      majorIterationFrequency_ = 64;
      onChanged();
      return this;
    }

    private int terminationCheckFrequency_ = 64;
    /**
     * <pre>
     * The frequency (based on a counter reset every major iteration) to check for
     * termination (involves extra work) and log iteration stats. Termination
     * checks do not affect algorithmic progress unless termination is triggered.
     * </pre>
     *
     * <code>optional int32 termination_check_frequency = 5 [default = 64];</code>
     * @return Whether the terminationCheckFrequency field is set.
     */
    @java.lang.Override
    public boolean hasTerminationCheckFrequency() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     * <pre>
     * The frequency (based on a counter reset every major iteration) to check for
     * termination (involves extra work) and log iteration stats. Termination
     * checks do not affect algorithmic progress unless termination is triggered.
     * </pre>
     *
     * <code>optional int32 termination_check_frequency = 5 [default = 64];</code>
     * @return The terminationCheckFrequency.
     */
    @java.lang.Override
    public int getTerminationCheckFrequency() {
      return terminationCheckFrequency_;
    }
    /**
     * <pre>
     * The frequency (based on a counter reset every major iteration) to check for
     * termination (involves extra work) and log iteration stats. Termination
     * checks do not affect algorithmic progress unless termination is triggered.
     * </pre>
     *
     * <code>optional int32 termination_check_frequency = 5 [default = 64];</code>
     * @param value The terminationCheckFrequency to set.
     * @return This builder for chaining.
     */
    public Builder setTerminationCheckFrequency(int value) {

      terminationCheckFrequency_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The frequency (based on a counter reset every major iteration) to check for
     * termination (involves extra work) and log iteration stats. Termination
     * checks do not affect algorithmic progress unless termination is triggered.
     * </pre>
     *
     * <code>optional int32 termination_check_frequency = 5 [default = 64];</code>
     * @return This builder for chaining.
     */
    public Builder clearTerminationCheckFrequency() {
      bitField0_ = (bitField0_ & ~0x00000080);
      terminationCheckFrequency_ = 64;
      onChanged();
      return this;
    }

    private int restartStrategy_ = 3;
    /**
     * <pre>
     * NO_RESTARTS and EVERY_MAJOR_ITERATION occasionally outperform the default.
     * If using a strategy other than ADAPTIVE_HEURISTIC, you must also tune
     * major_iteration_frequency.
     * </pre>
     *
     * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.RestartStrategy restart_strategy = 6 [default = ADAPTIVE_HEURISTIC];</code>
     * @return Whether the restartStrategy field is set.
     */
    @java.lang.Override public boolean hasRestartStrategy() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     * <pre>
     * NO_RESTARTS and EVERY_MAJOR_ITERATION occasionally outperform the default.
     * If using a strategy other than ADAPTIVE_HEURISTIC, you must also tune
     * major_iteration_frequency.
     * </pre>
     *
     * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.RestartStrategy restart_strategy = 6 [default = ADAPTIVE_HEURISTIC];</code>
     * @return The restartStrategy.
     */
    @java.lang.Override
    public com.google.ortools.pdlp.PrimalDualHybridGradientParams.RestartStrategy getRestartStrategy() {
      com.google.ortools.pdlp.PrimalDualHybridGradientParams.RestartStrategy result = com.google.ortools.pdlp.PrimalDualHybridGradientParams.RestartStrategy.forNumber(restartStrategy_);
      return result == null ? com.google.ortools.pdlp.PrimalDualHybridGradientParams.RestartStrategy.ADAPTIVE_HEURISTIC : result;
    }
    /**
     * <pre>
     * NO_RESTARTS and EVERY_MAJOR_ITERATION occasionally outperform the default.
     * If using a strategy other than ADAPTIVE_HEURISTIC, you must also tune
     * major_iteration_frequency.
     * </pre>
     *
     * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.RestartStrategy restart_strategy = 6 [default = ADAPTIVE_HEURISTIC];</code>
     * @param value The restartStrategy to set.
     * @return This builder for chaining.
     */
    public Builder setRestartStrategy(com.google.ortools.pdlp.PrimalDualHybridGradientParams.RestartStrategy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      restartStrategy_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * NO_RESTARTS and EVERY_MAJOR_ITERATION occasionally outperform the default.
     * If using a strategy other than ADAPTIVE_HEURISTIC, you must also tune
     * major_iteration_frequency.
     * </pre>
     *
     * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.RestartStrategy restart_strategy = 6 [default = ADAPTIVE_HEURISTIC];</code>
     * @return This builder for chaining.
     */
    public Builder clearRestartStrategy() {
      bitField0_ = (bitField0_ & ~0x00000100);
      restartStrategy_ = 3;
      onChanged();
      return this;
    }

    private double primalWeightUpdateSmoothing_ = 0.5D;
    /**
     * <pre>
     * This parameter controls exponential smoothing of log(primal_weight) when a
     * primal weight update occurs (i.e., when the ratio of primal and dual step
     * sizes is adjusted). At 0.0, the primal weight will be frozen at its initial
     * value and there will be no dynamic updates in the algorithm. At 1.0, there
     * is no smoothing in the updates. The default of 0.5 generally performs well,
     * but has been observed on occasion to trigger unstable swings in the primal
     * weight. We recommend also trying 0.0 (disabling primal weight updates), in
     * which case you must also tune initial_primal_weight.
     * </pre>
     *
     * <code>optional double primal_weight_update_smoothing = 7 [default = 0.5];</code>
     * @return Whether the primalWeightUpdateSmoothing field is set.
     */
    @java.lang.Override
    public boolean hasPrimalWeightUpdateSmoothing() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     * <pre>
     * This parameter controls exponential smoothing of log(primal_weight) when a
     * primal weight update occurs (i.e., when the ratio of primal and dual step
     * sizes is adjusted). At 0.0, the primal weight will be frozen at its initial
     * value and there will be no dynamic updates in the algorithm. At 1.0, there
     * is no smoothing in the updates. The default of 0.5 generally performs well,
     * but has been observed on occasion to trigger unstable swings in the primal
     * weight. We recommend also trying 0.0 (disabling primal weight updates), in
     * which case you must also tune initial_primal_weight.
     * </pre>
     *
     * <code>optional double primal_weight_update_smoothing = 7 [default = 0.5];</code>
     * @return The primalWeightUpdateSmoothing.
     */
    @java.lang.Override
    public double getPrimalWeightUpdateSmoothing() {
      return primalWeightUpdateSmoothing_;
    }
    /**
     * <pre>
     * This parameter controls exponential smoothing of log(primal_weight) when a
     * primal weight update occurs (i.e., when the ratio of primal and dual step
     * sizes is adjusted). At 0.0, the primal weight will be frozen at its initial
     * value and there will be no dynamic updates in the algorithm. At 1.0, there
     * is no smoothing in the updates. The default of 0.5 generally performs well,
     * but has been observed on occasion to trigger unstable swings in the primal
     * weight. We recommend also trying 0.0 (disabling primal weight updates), in
     * which case you must also tune initial_primal_weight.
     * </pre>
     *
     * <code>optional double primal_weight_update_smoothing = 7 [default = 0.5];</code>
     * @param value The primalWeightUpdateSmoothing to set.
     * @return This builder for chaining.
     */
    public Builder setPrimalWeightUpdateSmoothing(double value) {

      primalWeightUpdateSmoothing_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * This parameter controls exponential smoothing of log(primal_weight) when a
     * primal weight update occurs (i.e., when the ratio of primal and dual step
     * sizes is adjusted). At 0.0, the primal weight will be frozen at its initial
     * value and there will be no dynamic updates in the algorithm. At 1.0, there
     * is no smoothing in the updates. The default of 0.5 generally performs well,
     * but has been observed on occasion to trigger unstable swings in the primal
     * weight. We recommend also trying 0.0 (disabling primal weight updates), in
     * which case you must also tune initial_primal_weight.
     * </pre>
     *
     * <code>optional double primal_weight_update_smoothing = 7 [default = 0.5];</code>
     * @return This builder for chaining.
     */
    public Builder clearPrimalWeightUpdateSmoothing() {
      bitField0_ = (bitField0_ & ~0x00000200);
      primalWeightUpdateSmoothing_ = 0.5D;
      onChanged();
      return this;
    }

    private double initialPrimalWeight_ ;
    /**
     * <pre>
     * The initial value of the primal weight (i.e., the ratio of primal and dual
     * step sizes). The primal weight remains fixed throughout the solve if
     * primal_weight_update_smoothing = 0.0. If unset, the default is the ratio of
     * the norm of the objective vector to the L2 norm of the combined constraint
     * bounds vector (as defined above). If this ratio is not finite and positive,
     * then the default is 1.0 instead. For tuning, try powers of 10, for example,
     * from 10^{-6} to 10^6.
     * </pre>
     *
     * <code>optional double initial_primal_weight = 8;</code>
     * @return Whether the initialPrimalWeight field is set.
     */
    @java.lang.Override
    public boolean hasInitialPrimalWeight() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     * <pre>
     * The initial value of the primal weight (i.e., the ratio of primal and dual
     * step sizes). The primal weight remains fixed throughout the solve if
     * primal_weight_update_smoothing = 0.0. If unset, the default is the ratio of
     * the norm of the objective vector to the L2 norm of the combined constraint
     * bounds vector (as defined above). If this ratio is not finite and positive,
     * then the default is 1.0 instead. For tuning, try powers of 10, for example,
     * from 10^{-6} to 10^6.
     * </pre>
     *
     * <code>optional double initial_primal_weight = 8;</code>
     * @return The initialPrimalWeight.
     */
    @java.lang.Override
    public double getInitialPrimalWeight() {
      return initialPrimalWeight_;
    }
    /**
     * <pre>
     * The initial value of the primal weight (i.e., the ratio of primal and dual
     * step sizes). The primal weight remains fixed throughout the solve if
     * primal_weight_update_smoothing = 0.0. If unset, the default is the ratio of
     * the norm of the objective vector to the L2 norm of the combined constraint
     * bounds vector (as defined above). If this ratio is not finite and positive,
     * then the default is 1.0 instead. For tuning, try powers of 10, for example,
     * from 10^{-6} to 10^6.
     * </pre>
     *
     * <code>optional double initial_primal_weight = 8;</code>
     * @param value The initialPrimalWeight to set.
     * @return This builder for chaining.
     */
    public Builder setInitialPrimalWeight(double value) {

      initialPrimalWeight_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The initial value of the primal weight (i.e., the ratio of primal and dual
     * step sizes). The primal weight remains fixed throughout the solve if
     * primal_weight_update_smoothing = 0.0. If unset, the default is the ratio of
     * the norm of the objective vector to the L2 norm of the combined constraint
     * bounds vector (as defined above). If this ratio is not finite and positive,
     * then the default is 1.0 instead. For tuning, try powers of 10, for example,
     * from 10^{-6} to 10^6.
     * </pre>
     *
     * <code>optional double initial_primal_weight = 8;</code>
     * @return This builder for chaining.
     */
    public Builder clearInitialPrimalWeight() {
      bitField0_ = (bitField0_ & ~0x00000400);
      initialPrimalWeight_ = 0D;
      onChanged();
      return this;
    }

    private com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions presolveOptions_;
    private com.google.protobuf.SingleFieldBuilder<
        com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions, com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions.Builder, com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptionsOrBuilder> presolveOptionsBuilder_;
    /**
     * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.PresolveOptions presolve_options = 16;</code>
     * @return Whether the presolveOptions field is set.
     */
    public boolean hasPresolveOptions() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.PresolveOptions presolve_options = 16;</code>
     * @return The presolveOptions.
     */
    public com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions getPresolveOptions() {
      if (presolveOptionsBuilder_ == null) {
        return presolveOptions_ == null ? com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions.getDefaultInstance() : presolveOptions_;
      } else {
        return presolveOptionsBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.PresolveOptions presolve_options = 16;</code>
     */
    public Builder setPresolveOptions(com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions value) {
      if (presolveOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        presolveOptions_ = value;
      } else {
        presolveOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.PresolveOptions presolve_options = 16;</code>
     */
    public Builder setPresolveOptions(
        com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions.Builder builderForValue) {
      if (presolveOptionsBuilder_ == null) {
        presolveOptions_ = builderForValue.build();
      } else {
        presolveOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.PresolveOptions presolve_options = 16;</code>
     */
    public Builder mergePresolveOptions(com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions value) {
      if (presolveOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0) &&
          presolveOptions_ != null &&
          presolveOptions_ != com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions.getDefaultInstance()) {
          getPresolveOptionsBuilder().mergeFrom(value);
        } else {
          presolveOptions_ = value;
        }
      } else {
        presolveOptionsBuilder_.mergeFrom(value);
      }
      if (presolveOptions_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.PresolveOptions presolve_options = 16;</code>
     */
    public Builder clearPresolveOptions() {
      bitField0_ = (bitField0_ & ~0x00000800);
      presolveOptions_ = null;
      if (presolveOptionsBuilder_ != null) {
        presolveOptionsBuilder_.dispose();
        presolveOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.PresolveOptions presolve_options = 16;</code>
     */
    public com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions.Builder getPresolveOptionsBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getPresolveOptionsFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.PresolveOptions presolve_options = 16;</code>
     */
    public com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptionsOrBuilder getPresolveOptionsOrBuilder() {
      if (presolveOptionsBuilder_ != null) {
        return presolveOptionsBuilder_.getMessageOrBuilder();
      } else {
        return presolveOptions_ == null ?
            com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions.getDefaultInstance() : presolveOptions_;
      }
    }
    /**
     * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.PresolveOptions presolve_options = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
        com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions, com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions.Builder, com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptionsOrBuilder> 
        getPresolveOptionsFieldBuilder() {
      if (presolveOptionsBuilder_ == null) {
        presolveOptionsBuilder_ = new com.google.protobuf.SingleFieldBuilder<
            com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions, com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptions.Builder, com.google.ortools.pdlp.PrimalDualHybridGradientParams.PresolveOptionsOrBuilder>(
                getPresolveOptions(),
                getParentForChildren(),
                isClean());
        presolveOptions_ = null;
      }
      return presolveOptionsBuilder_;
    }

    private int lInfRuizIterations_ = 5;
    /**
     * <pre>
     * Number of L_infinity Ruiz rescaling iterations to apply to the constraint
     * matrix. Zero disables this rescaling pass. Recommended values to try when
     * tuning are 0, 5, and 10.
     * </pre>
     *
     * <code>optional int32 l_inf_ruiz_iterations = 9 [default = 5];</code>
     * @return Whether the lInfRuizIterations field is set.
     */
    @java.lang.Override
    public boolean hasLInfRuizIterations() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     * <pre>
     * Number of L_infinity Ruiz rescaling iterations to apply to the constraint
     * matrix. Zero disables this rescaling pass. Recommended values to try when
     * tuning are 0, 5, and 10.
     * </pre>
     *
     * <code>optional int32 l_inf_ruiz_iterations = 9 [default = 5];</code>
     * @return The lInfRuizIterations.
     */
    @java.lang.Override
    public int getLInfRuizIterations() {
      return lInfRuizIterations_;
    }
    /**
     * <pre>
     * Number of L_infinity Ruiz rescaling iterations to apply to the constraint
     * matrix. Zero disables this rescaling pass. Recommended values to try when
     * tuning are 0, 5, and 10.
     * </pre>
     *
     * <code>optional int32 l_inf_ruiz_iterations = 9 [default = 5];</code>
     * @param value The lInfRuizIterations to set.
     * @return This builder for chaining.
     */
    public Builder setLInfRuizIterations(int value) {

      lInfRuizIterations_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Number of L_infinity Ruiz rescaling iterations to apply to the constraint
     * matrix. Zero disables this rescaling pass. Recommended values to try when
     * tuning are 0, 5, and 10.
     * </pre>
     *
     * <code>optional int32 l_inf_ruiz_iterations = 9 [default = 5];</code>
     * @return This builder for chaining.
     */
    public Builder clearLInfRuizIterations() {
      bitField0_ = (bitField0_ & ~0x00001000);
      lInfRuizIterations_ = 5;
      onChanged();
      return this;
    }

    private boolean l2NormRescaling_ = true;
    /**
     * <pre>
     * If true, applies L_2 norm rescaling after the Ruiz rescaling. Heuristically
     * this has been found to help convergence.
     * </pre>
     *
     * <code>optional bool l2_norm_rescaling = 10 [default = true];</code>
     * @return Whether the l2NormRescaling field is set.
     */
    @java.lang.Override
    public boolean hasL2NormRescaling() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     * <pre>
     * If true, applies L_2 norm rescaling after the Ruiz rescaling. Heuristically
     * this has been found to help convergence.
     * </pre>
     *
     * <code>optional bool l2_norm_rescaling = 10 [default = true];</code>
     * @return The l2NormRescaling.
     */
    @java.lang.Override
    public boolean getL2NormRescaling() {
      return l2NormRescaling_;
    }
    /**
     * <pre>
     * If true, applies L_2 norm rescaling after the Ruiz rescaling. Heuristically
     * this has been found to help convergence.
     * </pre>
     *
     * <code>optional bool l2_norm_rescaling = 10 [default = true];</code>
     * @param value The l2NormRescaling to set.
     * @return This builder for chaining.
     */
    public Builder setL2NormRescaling(boolean value) {

      l2NormRescaling_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, applies L_2 norm rescaling after the Ruiz rescaling. Heuristically
     * this has been found to help convergence.
     * </pre>
     *
     * <code>optional bool l2_norm_rescaling = 10 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearL2NormRescaling() {
      bitField0_ = (bitField0_ & ~0x00002000);
      l2NormRescaling_ = true;
      onChanged();
      return this;
    }

    private double sufficientReductionForRestart_ = 0.1D;
    /**
     * <pre>
     * For ADAPTIVE_HEURISTIC and ADAPTIVE_DISTANCE_BASED only: A relative
     * reduction in the potential function by this amount always triggers a
     * restart. Must be between 0.0 and 1.0.
     * </pre>
     *
     * <code>optional double sufficient_reduction_for_restart = 11 [default = 0.1];</code>
     * @return Whether the sufficientReductionForRestart field is set.
     */
    @java.lang.Override
    public boolean hasSufficientReductionForRestart() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     * <pre>
     * For ADAPTIVE_HEURISTIC and ADAPTIVE_DISTANCE_BASED only: A relative
     * reduction in the potential function by this amount always triggers a
     * restart. Must be between 0.0 and 1.0.
     * </pre>
     *
     * <code>optional double sufficient_reduction_for_restart = 11 [default = 0.1];</code>
     * @return The sufficientReductionForRestart.
     */
    @java.lang.Override
    public double getSufficientReductionForRestart() {
      return sufficientReductionForRestart_;
    }
    /**
     * <pre>
     * For ADAPTIVE_HEURISTIC and ADAPTIVE_DISTANCE_BASED only: A relative
     * reduction in the potential function by this amount always triggers a
     * restart. Must be between 0.0 and 1.0.
     * </pre>
     *
     * <code>optional double sufficient_reduction_for_restart = 11 [default = 0.1];</code>
     * @param value The sufficientReductionForRestart to set.
     * @return This builder for chaining.
     */
    public Builder setSufficientReductionForRestart(double value) {

      sufficientReductionForRestart_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * For ADAPTIVE_HEURISTIC and ADAPTIVE_DISTANCE_BASED only: A relative
     * reduction in the potential function by this amount always triggers a
     * restart. Must be between 0.0 and 1.0.
     * </pre>
     *
     * <code>optional double sufficient_reduction_for_restart = 11 [default = 0.1];</code>
     * @return This builder for chaining.
     */
    public Builder clearSufficientReductionForRestart() {
      bitField0_ = (bitField0_ & ~0x00004000);
      sufficientReductionForRestart_ = 0.1D;
      onChanged();
      return this;
    }

    private double necessaryReductionForRestart_ = 0.9D;
    /**
     * <pre>
     * For ADAPTIVE_HEURISTIC only: A relative reduction in the potential function
     * by this amount triggers a restart if, additionally, the quality of the
     * iterates appears to be getting worse. The value must be in the interval
     * [sufficient_reduction_for_restart, 1). Smaller values make restarts less
     * frequent, and larger values make them more frequent.
     * </pre>
     *
     * <code>optional double necessary_reduction_for_restart = 17 [default = 0.9];</code>
     * @return Whether the necessaryReductionForRestart field is set.
     */
    @java.lang.Override
    public boolean hasNecessaryReductionForRestart() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     * <pre>
     * For ADAPTIVE_HEURISTIC only: A relative reduction in the potential function
     * by this amount triggers a restart if, additionally, the quality of the
     * iterates appears to be getting worse. The value must be in the interval
     * [sufficient_reduction_for_restart, 1). Smaller values make restarts less
     * frequent, and larger values make them more frequent.
     * </pre>
     *
     * <code>optional double necessary_reduction_for_restart = 17 [default = 0.9];</code>
     * @return The necessaryReductionForRestart.
     */
    @java.lang.Override
    public double getNecessaryReductionForRestart() {
      return necessaryReductionForRestart_;
    }
    /**
     * <pre>
     * For ADAPTIVE_HEURISTIC only: A relative reduction in the potential function
     * by this amount triggers a restart if, additionally, the quality of the
     * iterates appears to be getting worse. The value must be in the interval
     * [sufficient_reduction_for_restart, 1). Smaller values make restarts less
     * frequent, and larger values make them more frequent.
     * </pre>
     *
     * <code>optional double necessary_reduction_for_restart = 17 [default = 0.9];</code>
     * @param value The necessaryReductionForRestart to set.
     * @return This builder for chaining.
     */
    public Builder setNecessaryReductionForRestart(double value) {

      necessaryReductionForRestart_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * For ADAPTIVE_HEURISTIC only: A relative reduction in the potential function
     * by this amount triggers a restart if, additionally, the quality of the
     * iterates appears to be getting worse. The value must be in the interval
     * [sufficient_reduction_for_restart, 1). Smaller values make restarts less
     * frequent, and larger values make them more frequent.
     * </pre>
     *
     * <code>optional double necessary_reduction_for_restart = 17 [default = 0.9];</code>
     * @return This builder for chaining.
     */
    public Builder clearNecessaryReductionForRestart() {
      bitField0_ = (bitField0_ & ~0x00008000);
      necessaryReductionForRestart_ = 0.9D;
      onChanged();
      return this;
    }

    private int linesearchRule_ = 1;
    /**
     * <pre>
     * Linesearch rule applied at each major iteration.
     * </pre>
     *
     * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.LinesearchRule linesearch_rule = 12 [default = ADAPTIVE_LINESEARCH_RULE];</code>
     * @return Whether the linesearchRule field is set.
     */
    @java.lang.Override public boolean hasLinesearchRule() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     * <pre>
     * Linesearch rule applied at each major iteration.
     * </pre>
     *
     * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.LinesearchRule linesearch_rule = 12 [default = ADAPTIVE_LINESEARCH_RULE];</code>
     * @return The linesearchRule.
     */
    @java.lang.Override
    public com.google.ortools.pdlp.PrimalDualHybridGradientParams.LinesearchRule getLinesearchRule() {
      com.google.ortools.pdlp.PrimalDualHybridGradientParams.LinesearchRule result = com.google.ortools.pdlp.PrimalDualHybridGradientParams.LinesearchRule.forNumber(linesearchRule_);
      return result == null ? com.google.ortools.pdlp.PrimalDualHybridGradientParams.LinesearchRule.ADAPTIVE_LINESEARCH_RULE : result;
    }
    /**
     * <pre>
     * Linesearch rule applied at each major iteration.
     * </pre>
     *
     * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.LinesearchRule linesearch_rule = 12 [default = ADAPTIVE_LINESEARCH_RULE];</code>
     * @param value The linesearchRule to set.
     * @return This builder for chaining.
     */
    public Builder setLinesearchRule(com.google.ortools.pdlp.PrimalDualHybridGradientParams.LinesearchRule value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00010000;
      linesearchRule_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Linesearch rule applied at each major iteration.
     * </pre>
     *
     * <code>optional .operations_research.pdlp.PrimalDualHybridGradientParams.LinesearchRule linesearch_rule = 12 [default = ADAPTIVE_LINESEARCH_RULE];</code>
     * @return This builder for chaining.
     */
    public Builder clearLinesearchRule() {
      bitField0_ = (bitField0_ & ~0x00010000);
      linesearchRule_ = 1;
      onChanged();
      return this;
    }

    private com.google.ortools.pdlp.AdaptiveLinesearchParams adaptiveLinesearchParameters_;
    private com.google.protobuf.SingleFieldBuilder<
        com.google.ortools.pdlp.AdaptiveLinesearchParams, com.google.ortools.pdlp.AdaptiveLinesearchParams.Builder, com.google.ortools.pdlp.AdaptiveLinesearchParamsOrBuilder> adaptiveLinesearchParametersBuilder_;
    /**
     * <code>optional .operations_research.pdlp.AdaptiveLinesearchParams adaptive_linesearch_parameters = 18;</code>
     * @return Whether the adaptiveLinesearchParameters field is set.
     */
    public boolean hasAdaptiveLinesearchParameters() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     * <code>optional .operations_research.pdlp.AdaptiveLinesearchParams adaptive_linesearch_parameters = 18;</code>
     * @return The adaptiveLinesearchParameters.
     */
    public com.google.ortools.pdlp.AdaptiveLinesearchParams getAdaptiveLinesearchParameters() {
      if (adaptiveLinesearchParametersBuilder_ == null) {
        return adaptiveLinesearchParameters_ == null ? com.google.ortools.pdlp.AdaptiveLinesearchParams.getDefaultInstance() : adaptiveLinesearchParameters_;
      } else {
        return adaptiveLinesearchParametersBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .operations_research.pdlp.AdaptiveLinesearchParams adaptive_linesearch_parameters = 18;</code>
     */
    public Builder setAdaptiveLinesearchParameters(com.google.ortools.pdlp.AdaptiveLinesearchParams value) {
      if (adaptiveLinesearchParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        adaptiveLinesearchParameters_ = value;
      } else {
        adaptiveLinesearchParametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.pdlp.AdaptiveLinesearchParams adaptive_linesearch_parameters = 18;</code>
     */
    public Builder setAdaptiveLinesearchParameters(
        com.google.ortools.pdlp.AdaptiveLinesearchParams.Builder builderForValue) {
      if (adaptiveLinesearchParametersBuilder_ == null) {
        adaptiveLinesearchParameters_ = builderForValue.build();
      } else {
        adaptiveLinesearchParametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.pdlp.AdaptiveLinesearchParams adaptive_linesearch_parameters = 18;</code>
     */
    public Builder mergeAdaptiveLinesearchParameters(com.google.ortools.pdlp.AdaptiveLinesearchParams value) {
      if (adaptiveLinesearchParametersBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0) &&
          adaptiveLinesearchParameters_ != null &&
          adaptiveLinesearchParameters_ != com.google.ortools.pdlp.AdaptiveLinesearchParams.getDefaultInstance()) {
          getAdaptiveLinesearchParametersBuilder().mergeFrom(value);
        } else {
          adaptiveLinesearchParameters_ = value;
        }
      } else {
        adaptiveLinesearchParametersBuilder_.mergeFrom(value);
      }
      if (adaptiveLinesearchParameters_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }
    /**
     * <code>optional .operations_research.pdlp.AdaptiveLinesearchParams adaptive_linesearch_parameters = 18;</code>
     */
    public Builder clearAdaptiveLinesearchParameters() {
      bitField0_ = (bitField0_ & ~0x00020000);
      adaptiveLinesearchParameters_ = null;
      if (adaptiveLinesearchParametersBuilder_ != null) {
        adaptiveLinesearchParametersBuilder_.dispose();
        adaptiveLinesearchParametersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.pdlp.AdaptiveLinesearchParams adaptive_linesearch_parameters = 18;</code>
     */
    public com.google.ortools.pdlp.AdaptiveLinesearchParams.Builder getAdaptiveLinesearchParametersBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getAdaptiveLinesearchParametersFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .operations_research.pdlp.AdaptiveLinesearchParams adaptive_linesearch_parameters = 18;</code>
     */
    public com.google.ortools.pdlp.AdaptiveLinesearchParamsOrBuilder getAdaptiveLinesearchParametersOrBuilder() {
      if (adaptiveLinesearchParametersBuilder_ != null) {
        return adaptiveLinesearchParametersBuilder_.getMessageOrBuilder();
      } else {
        return adaptiveLinesearchParameters_ == null ?
            com.google.ortools.pdlp.AdaptiveLinesearchParams.getDefaultInstance() : adaptiveLinesearchParameters_;
      }
    }
    /**
     * <code>optional .operations_research.pdlp.AdaptiveLinesearchParams adaptive_linesearch_parameters = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
        com.google.ortools.pdlp.AdaptiveLinesearchParams, com.google.ortools.pdlp.AdaptiveLinesearchParams.Builder, com.google.ortools.pdlp.AdaptiveLinesearchParamsOrBuilder> 
        getAdaptiveLinesearchParametersFieldBuilder() {
      if (adaptiveLinesearchParametersBuilder_ == null) {
        adaptiveLinesearchParametersBuilder_ = new com.google.protobuf.SingleFieldBuilder<
            com.google.ortools.pdlp.AdaptiveLinesearchParams, com.google.ortools.pdlp.AdaptiveLinesearchParams.Builder, com.google.ortools.pdlp.AdaptiveLinesearchParamsOrBuilder>(
                getAdaptiveLinesearchParameters(),
                getParentForChildren(),
                isClean());
        adaptiveLinesearchParameters_ = null;
      }
      return adaptiveLinesearchParametersBuilder_;
    }

    private com.google.ortools.pdlp.MalitskyPockParams malitskyPockParameters_;
    private com.google.protobuf.SingleFieldBuilder<
        com.google.ortools.pdlp.MalitskyPockParams, com.google.ortools.pdlp.MalitskyPockParams.Builder, com.google.ortools.pdlp.MalitskyPockParamsOrBuilder> malitskyPockParametersBuilder_;
    /**
     * <code>optional .operations_research.pdlp.MalitskyPockParams malitsky_pock_parameters = 19;</code>
     * @return Whether the malitskyPockParameters field is set.
     */
    public boolean hasMalitskyPockParameters() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     * <code>optional .operations_research.pdlp.MalitskyPockParams malitsky_pock_parameters = 19;</code>
     * @return The malitskyPockParameters.
     */
    public com.google.ortools.pdlp.MalitskyPockParams getMalitskyPockParameters() {
      if (malitskyPockParametersBuilder_ == null) {
        return malitskyPockParameters_ == null ? com.google.ortools.pdlp.MalitskyPockParams.getDefaultInstance() : malitskyPockParameters_;
      } else {
        return malitskyPockParametersBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .operations_research.pdlp.MalitskyPockParams malitsky_pock_parameters = 19;</code>
     */
    public Builder setMalitskyPockParameters(com.google.ortools.pdlp.MalitskyPockParams value) {
      if (malitskyPockParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        malitskyPockParameters_ = value;
      } else {
        malitskyPockParametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.pdlp.MalitskyPockParams malitsky_pock_parameters = 19;</code>
     */
    public Builder setMalitskyPockParameters(
        com.google.ortools.pdlp.MalitskyPockParams.Builder builderForValue) {
      if (malitskyPockParametersBuilder_ == null) {
        malitskyPockParameters_ = builderForValue.build();
      } else {
        malitskyPockParametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.pdlp.MalitskyPockParams malitsky_pock_parameters = 19;</code>
     */
    public Builder mergeMalitskyPockParameters(com.google.ortools.pdlp.MalitskyPockParams value) {
      if (malitskyPockParametersBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0) &&
          malitskyPockParameters_ != null &&
          malitskyPockParameters_ != com.google.ortools.pdlp.MalitskyPockParams.getDefaultInstance()) {
          getMalitskyPockParametersBuilder().mergeFrom(value);
        } else {
          malitskyPockParameters_ = value;
        }
      } else {
        malitskyPockParametersBuilder_.mergeFrom(value);
      }
      if (malitskyPockParameters_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }
    /**
     * <code>optional .operations_research.pdlp.MalitskyPockParams malitsky_pock_parameters = 19;</code>
     */
    public Builder clearMalitskyPockParameters() {
      bitField0_ = (bitField0_ & ~0x00040000);
      malitskyPockParameters_ = null;
      if (malitskyPockParametersBuilder_ != null) {
        malitskyPockParametersBuilder_.dispose();
        malitskyPockParametersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.pdlp.MalitskyPockParams malitsky_pock_parameters = 19;</code>
     */
    public com.google.ortools.pdlp.MalitskyPockParams.Builder getMalitskyPockParametersBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getMalitskyPockParametersFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .operations_research.pdlp.MalitskyPockParams malitsky_pock_parameters = 19;</code>
     */
    public com.google.ortools.pdlp.MalitskyPockParamsOrBuilder getMalitskyPockParametersOrBuilder() {
      if (malitskyPockParametersBuilder_ != null) {
        return malitskyPockParametersBuilder_.getMessageOrBuilder();
      } else {
        return malitskyPockParameters_ == null ?
            com.google.ortools.pdlp.MalitskyPockParams.getDefaultInstance() : malitskyPockParameters_;
      }
    }
    /**
     * <code>optional .operations_research.pdlp.MalitskyPockParams malitsky_pock_parameters = 19;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
        com.google.ortools.pdlp.MalitskyPockParams, com.google.ortools.pdlp.MalitskyPockParams.Builder, com.google.ortools.pdlp.MalitskyPockParamsOrBuilder> 
        getMalitskyPockParametersFieldBuilder() {
      if (malitskyPockParametersBuilder_ == null) {
        malitskyPockParametersBuilder_ = new com.google.protobuf.SingleFieldBuilder<
            com.google.ortools.pdlp.MalitskyPockParams, com.google.ortools.pdlp.MalitskyPockParams.Builder, com.google.ortools.pdlp.MalitskyPockParamsOrBuilder>(
                getMalitskyPockParameters(),
                getParentForChildren(),
                isClean());
        malitskyPockParameters_ = null;
      }
      return malitskyPockParametersBuilder_;
    }

    private double initialStepSizeScaling_ = 1D;
    /**
     * <pre>
     * Scaling factor applied to the initial step size (all step sizes if
     * linesearch_rule == CONSTANT_STEP_SIZE_RULE).
     * </pre>
     *
     * <code>optional double initial_step_size_scaling = 25 [default = 1];</code>
     * @return Whether the initialStepSizeScaling field is set.
     */
    @java.lang.Override
    public boolean hasInitialStepSizeScaling() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     * <pre>
     * Scaling factor applied to the initial step size (all step sizes if
     * linesearch_rule == CONSTANT_STEP_SIZE_RULE).
     * </pre>
     *
     * <code>optional double initial_step_size_scaling = 25 [default = 1];</code>
     * @return The initialStepSizeScaling.
     */
    @java.lang.Override
    public double getInitialStepSizeScaling() {
      return initialStepSizeScaling_;
    }
    /**
     * <pre>
     * Scaling factor applied to the initial step size (all step sizes if
     * linesearch_rule == CONSTANT_STEP_SIZE_RULE).
     * </pre>
     *
     * <code>optional double initial_step_size_scaling = 25 [default = 1];</code>
     * @param value The initialStepSizeScaling to set.
     * @return This builder for chaining.
     */
    public Builder setInitialStepSizeScaling(double value) {

      initialStepSizeScaling_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Scaling factor applied to the initial step size (all step sizes if
     * linesearch_rule == CONSTANT_STEP_SIZE_RULE).
     * </pre>
     *
     * <code>optional double initial_step_size_scaling = 25 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearInitialStepSizeScaling() {
      bitField0_ = (bitField0_ & ~0x00080000);
      initialStepSizeScaling_ = 1D;
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.IntList randomProjectionSeeds_ = emptyIntList();
    private void ensureRandomProjectionSeedsIsMutable() {
      if (!randomProjectionSeeds_.isModifiable()) {
        randomProjectionSeeds_ = makeMutableCopy(randomProjectionSeeds_);
      }
      bitField0_ |= 0x00100000;
    }
    /**
     * <pre>
     * Seeds for generating (pseudo-)random projections of iterates during
     * termination checks. For each seed, the projection of the primal and dual
     * solutions onto random planes in primal and dual space will be computed and
     * added the IterationStats if record_iteration_stats is true. The random
     * planes generated will be determined by the seeds, the primal and dual
     * dimensions, and num_threads.
     * </pre>
     *
     * <code>repeated int32 random_projection_seeds = 28 [packed = true];</code>
     * @return A list containing the randomProjectionSeeds.
     */
    public java.util.List<java.lang.Integer>
        getRandomProjectionSeedsList() {
      randomProjectionSeeds_.makeImmutable();
      return randomProjectionSeeds_;
    }
    /**
     * <pre>
     * Seeds for generating (pseudo-)random projections of iterates during
     * termination checks. For each seed, the projection of the primal and dual
     * solutions onto random planes in primal and dual space will be computed and
     * added the IterationStats if record_iteration_stats is true. The random
     * planes generated will be determined by the seeds, the primal and dual
     * dimensions, and num_threads.
     * </pre>
     *
     * <code>repeated int32 random_projection_seeds = 28 [packed = true];</code>
     * @return The count of randomProjectionSeeds.
     */
    public int getRandomProjectionSeedsCount() {
      return randomProjectionSeeds_.size();
    }
    /**
     * <pre>
     * Seeds for generating (pseudo-)random projections of iterates during
     * termination checks. For each seed, the projection of the primal and dual
     * solutions onto random planes in primal and dual space will be computed and
     * added the IterationStats if record_iteration_stats is true. The random
     * planes generated will be determined by the seeds, the primal and dual
     * dimensions, and num_threads.
     * </pre>
     *
     * <code>repeated int32 random_projection_seeds = 28 [packed = true];</code>
     * @param index The index of the element to return.
     * @return The randomProjectionSeeds at the given index.
     */
    public int getRandomProjectionSeeds(int index) {
      return randomProjectionSeeds_.getInt(index);
    }
    /**
     * <pre>
     * Seeds for generating (pseudo-)random projections of iterates during
     * termination checks. For each seed, the projection of the primal and dual
     * solutions onto random planes in primal and dual space will be computed and
     * added the IterationStats if record_iteration_stats is true. The random
     * planes generated will be determined by the seeds, the primal and dual
     * dimensions, and num_threads.
     * </pre>
     *
     * <code>repeated int32 random_projection_seeds = 28 [packed = true];</code>
     * @param index The index to set the value at.
     * @param value The randomProjectionSeeds to set.
     * @return This builder for chaining.
     */
    public Builder setRandomProjectionSeeds(
        int index, int value) {

      ensureRandomProjectionSeedsIsMutable();
      randomProjectionSeeds_.setInt(index, value);
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Seeds for generating (pseudo-)random projections of iterates during
     * termination checks. For each seed, the projection of the primal and dual
     * solutions onto random planes in primal and dual space will be computed and
     * added the IterationStats if record_iteration_stats is true. The random
     * planes generated will be determined by the seeds, the primal and dual
     * dimensions, and num_threads.
     * </pre>
     *
     * <code>repeated int32 random_projection_seeds = 28 [packed = true];</code>
     * @param value The randomProjectionSeeds to add.
     * @return This builder for chaining.
     */
    public Builder addRandomProjectionSeeds(int value) {

      ensureRandomProjectionSeedsIsMutable();
      randomProjectionSeeds_.addInt(value);
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Seeds for generating (pseudo-)random projections of iterates during
     * termination checks. For each seed, the projection of the primal and dual
     * solutions onto random planes in primal and dual space will be computed and
     * added the IterationStats if record_iteration_stats is true. The random
     * planes generated will be determined by the seeds, the primal and dual
     * dimensions, and num_threads.
     * </pre>
     *
     * <code>repeated int32 random_projection_seeds = 28 [packed = true];</code>
     * @param values The randomProjectionSeeds to add.
     * @return This builder for chaining.
     */
    public Builder addAllRandomProjectionSeeds(
        java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureRandomProjectionSeedsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, randomProjectionSeeds_);
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Seeds for generating (pseudo-)random projections of iterates during
     * termination checks. For each seed, the projection of the primal and dual
     * solutions onto random planes in primal and dual space will be computed and
     * added the IterationStats if record_iteration_stats is true. The random
     * planes generated will be determined by the seeds, the primal and dual
     * dimensions, and num_threads.
     * </pre>
     *
     * <code>repeated int32 random_projection_seeds = 28 [packed = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearRandomProjectionSeeds() {
      randomProjectionSeeds_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00100000);
      onChanged();
      return this;
    }

    private double infiniteConstraintBoundThreshold_ = Double.POSITIVE_INFINITY;
    /**
     * <pre>
     * Constraint bounds with absolute value at least this threshold are replaced
     * with infinities.
     * NOTE: This primarily affects the relative convergence criteria. A smaller
     * value makes the relative convergence criteria stronger. It also affects the
     * problem statistics LOG()ed at the start of the run, and the default initial
     * primal weight, since that is based on the norm of the bounds.
     * </pre>
     *
     * <code>optional double infinite_constraint_bound_threshold = 22 [default = inf];</code>
     * @return Whether the infiniteConstraintBoundThreshold field is set.
     */
    @java.lang.Override
    public boolean hasInfiniteConstraintBoundThreshold() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     * <pre>
     * Constraint bounds with absolute value at least this threshold are replaced
     * with infinities.
     * NOTE: This primarily affects the relative convergence criteria. A smaller
     * value makes the relative convergence criteria stronger. It also affects the
     * problem statistics LOG()ed at the start of the run, and the default initial
     * primal weight, since that is based on the norm of the bounds.
     * </pre>
     *
     * <code>optional double infinite_constraint_bound_threshold = 22 [default = inf];</code>
     * @return The infiniteConstraintBoundThreshold.
     */
    @java.lang.Override
    public double getInfiniteConstraintBoundThreshold() {
      return infiniteConstraintBoundThreshold_;
    }
    /**
     * <pre>
     * Constraint bounds with absolute value at least this threshold are replaced
     * with infinities.
     * NOTE: This primarily affects the relative convergence criteria. A smaller
     * value makes the relative convergence criteria stronger. It also affects the
     * problem statistics LOG()ed at the start of the run, and the default initial
     * primal weight, since that is based on the norm of the bounds.
     * </pre>
     *
     * <code>optional double infinite_constraint_bound_threshold = 22 [default = inf];</code>
     * @param value The infiniteConstraintBoundThreshold to set.
     * @return This builder for chaining.
     */
    public Builder setInfiniteConstraintBoundThreshold(double value) {

      infiniteConstraintBoundThreshold_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Constraint bounds with absolute value at least this threshold are replaced
     * with infinities.
     * NOTE: This primarily affects the relative convergence criteria. A smaller
     * value makes the relative convergence criteria stronger. It also affects the
     * problem statistics LOG()ed at the start of the run, and the default initial
     * primal weight, since that is based on the norm of the bounds.
     * </pre>
     *
     * <code>optional double infinite_constraint_bound_threshold = 22 [default = inf];</code>
     * @return This builder for chaining.
     */
    public Builder clearInfiniteConstraintBoundThreshold() {
      bitField0_ = (bitField0_ & ~0x00200000);
      infiniteConstraintBoundThreshold_ = Double.POSITIVE_INFINITY;
      onChanged();
      return this;
    }

    private boolean handleSomePrimalGradientsOnFiniteBoundsAsResiduals_ = true;
    /**
     * <pre>
     * See
     * https://developers.google.com/optimization/lp/pdlp_math#treating_some_variable_bounds_as_infinite
     * for a description of this flag.
     * </pre>
     *
     * <code>optional bool handle_some_primal_gradients_on_finite_bounds_as_residuals = 29 [default = true];</code>
     * @return Whether the handleSomePrimalGradientsOnFiniteBoundsAsResiduals field is set.
     */
    @java.lang.Override
    public boolean hasHandleSomePrimalGradientsOnFiniteBoundsAsResiduals() {
      return ((bitField0_ & 0x00400000) != 0);
    }
    /**
     * <pre>
     * See
     * https://developers.google.com/optimization/lp/pdlp_math#treating_some_variable_bounds_as_infinite
     * for a description of this flag.
     * </pre>
     *
     * <code>optional bool handle_some_primal_gradients_on_finite_bounds_as_residuals = 29 [default = true];</code>
     * @return The handleSomePrimalGradientsOnFiniteBoundsAsResiduals.
     */
    @java.lang.Override
    public boolean getHandleSomePrimalGradientsOnFiniteBoundsAsResiduals() {
      return handleSomePrimalGradientsOnFiniteBoundsAsResiduals_;
    }
    /**
     * <pre>
     * See
     * https://developers.google.com/optimization/lp/pdlp_math#treating_some_variable_bounds_as_infinite
     * for a description of this flag.
     * </pre>
     *
     * <code>optional bool handle_some_primal_gradients_on_finite_bounds_as_residuals = 29 [default = true];</code>
     * @param value The handleSomePrimalGradientsOnFiniteBoundsAsResiduals to set.
     * @return This builder for chaining.
     */
    public Builder setHandleSomePrimalGradientsOnFiniteBoundsAsResiduals(boolean value) {

      handleSomePrimalGradientsOnFiniteBoundsAsResiduals_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * See
     * https://developers.google.com/optimization/lp/pdlp_math#treating_some_variable_bounds_as_infinite
     * for a description of this flag.
     * </pre>
     *
     * <code>optional bool handle_some_primal_gradients_on_finite_bounds_as_residuals = 29 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearHandleSomePrimalGradientsOnFiniteBoundsAsResiduals() {
      bitField0_ = (bitField0_ & ~0x00400000);
      handleSomePrimalGradientsOnFiniteBoundsAsResiduals_ = true;
      onChanged();
      return this;
    }

    private boolean useDiagonalQpTrustRegionSolver_ ;
    /**
     * <pre>
     * When solving QPs with diagonal objective matrices, this option can be
     * turned on to enable an experimental solver that avoids linearization of the
     * quadratic term. The `diagonal_qp_solver_accuracy` parameter controls the
     * solve accuracy.
     * TODO(user): Turn this option on by default for quadratic
     * programs after numerical evaluation.
     * </pre>
     *
     * <code>optional bool use_diagonal_qp_trust_region_solver = 23 [default = false];</code>
     * @return Whether the useDiagonalQpTrustRegionSolver field is set.
     */
    @java.lang.Override
    public boolean hasUseDiagonalQpTrustRegionSolver() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     * <pre>
     * When solving QPs with diagonal objective matrices, this option can be
     * turned on to enable an experimental solver that avoids linearization of the
     * quadratic term. The `diagonal_qp_solver_accuracy` parameter controls the
     * solve accuracy.
     * TODO(user): Turn this option on by default for quadratic
     * programs after numerical evaluation.
     * </pre>
     *
     * <code>optional bool use_diagonal_qp_trust_region_solver = 23 [default = false];</code>
     * @return The useDiagonalQpTrustRegionSolver.
     */
    @java.lang.Override
    public boolean getUseDiagonalQpTrustRegionSolver() {
      return useDiagonalQpTrustRegionSolver_;
    }
    /**
     * <pre>
     * When solving QPs with diagonal objective matrices, this option can be
     * turned on to enable an experimental solver that avoids linearization of the
     * quadratic term. The `diagonal_qp_solver_accuracy` parameter controls the
     * solve accuracy.
     * TODO(user): Turn this option on by default for quadratic
     * programs after numerical evaluation.
     * </pre>
     *
     * <code>optional bool use_diagonal_qp_trust_region_solver = 23 [default = false];</code>
     * @param value The useDiagonalQpTrustRegionSolver to set.
     * @return This builder for chaining.
     */
    public Builder setUseDiagonalQpTrustRegionSolver(boolean value) {

      useDiagonalQpTrustRegionSolver_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * When solving QPs with diagonal objective matrices, this option can be
     * turned on to enable an experimental solver that avoids linearization of the
     * quadratic term. The `diagonal_qp_solver_accuracy` parameter controls the
     * solve accuracy.
     * TODO(user): Turn this option on by default for quadratic
     * programs after numerical evaluation.
     * </pre>
     *
     * <code>optional bool use_diagonal_qp_trust_region_solver = 23 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseDiagonalQpTrustRegionSolver() {
      bitField0_ = (bitField0_ & ~0x00800000);
      useDiagonalQpTrustRegionSolver_ = false;
      onChanged();
      return this;
    }

    private double diagonalQpTrustRegionSolverTolerance_ = 1e-08D;
    /**
     * <pre>
     * The solve tolerance of the experimental trust region solver for diagonal
     * QPs, controlling the accuracy of binary search over a one-dimensional
     * scaling parameter. Smaller values imply smaller relative error of the final
     * solution vector.
     * TODO(user): Find an expression for the final relative error.
     * </pre>
     *
     * <code>optional double diagonal_qp_trust_region_solver_tolerance = 24 [default = 1e-08];</code>
     * @return Whether the diagonalQpTrustRegionSolverTolerance field is set.
     */
    @java.lang.Override
    public boolean hasDiagonalQpTrustRegionSolverTolerance() {
      return ((bitField0_ & 0x01000000) != 0);
    }
    /**
     * <pre>
     * The solve tolerance of the experimental trust region solver for diagonal
     * QPs, controlling the accuracy of binary search over a one-dimensional
     * scaling parameter. Smaller values imply smaller relative error of the final
     * solution vector.
     * TODO(user): Find an expression for the final relative error.
     * </pre>
     *
     * <code>optional double diagonal_qp_trust_region_solver_tolerance = 24 [default = 1e-08];</code>
     * @return The diagonalQpTrustRegionSolverTolerance.
     */
    @java.lang.Override
    public double getDiagonalQpTrustRegionSolverTolerance() {
      return diagonalQpTrustRegionSolverTolerance_;
    }
    /**
     * <pre>
     * The solve tolerance of the experimental trust region solver for diagonal
     * QPs, controlling the accuracy of binary search over a one-dimensional
     * scaling parameter. Smaller values imply smaller relative error of the final
     * solution vector.
     * TODO(user): Find an expression for the final relative error.
     * </pre>
     *
     * <code>optional double diagonal_qp_trust_region_solver_tolerance = 24 [default = 1e-08];</code>
     * @param value The diagonalQpTrustRegionSolverTolerance to set.
     * @return This builder for chaining.
     */
    public Builder setDiagonalQpTrustRegionSolverTolerance(double value) {

      diagonalQpTrustRegionSolverTolerance_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The solve tolerance of the experimental trust region solver for diagonal
     * QPs, controlling the accuracy of binary search over a one-dimensional
     * scaling parameter. Smaller values imply smaller relative error of the final
     * solution vector.
     * TODO(user): Find an expression for the final relative error.
     * </pre>
     *
     * <code>optional double diagonal_qp_trust_region_solver_tolerance = 24 [default = 1e-08];</code>
     * @return This builder for chaining.
     */
    public Builder clearDiagonalQpTrustRegionSolverTolerance() {
      bitField0_ = (bitField0_ & ~0x01000000);
      diagonalQpTrustRegionSolverTolerance_ = 1e-08D;
      onChanged();
      return this;
    }

    private boolean useFeasibilityPolishing_ ;
    /**
     * <pre>
     * If true, periodically runs feasibility polishing, which attempts to move
     * from latest average iterate to one that is closer to feasibility (i.e., has
     * smaller primal and dual residuals) while probably increasing the objective
     * gap. This is useful primarily when the feasibility tolerances are fairly
     * tight and the objective gap tolerance is somewhat looser. Note that this
     * does not change the termination criteria, but rather can help achieve the
     * termination criteria more quickly when the objective gap is not as
     * important as feasibility.
     *
     * `use_feasibility_polishing` cannot be used with glop presolve, and requires
     * `handle_some_primal_gradients_on_finite_bounds_as_residuals == false`.
     * `use_feasibility_polishing` can only be used with linear programs.
     *
     * Feasibility polishing runs two separate phases, primal feasibility and dual
     * feasibility. The primal feasibility phase runs PDHG on the primal
     * feasibility problem (obtained by changing the objective vector to all
     * zeros), using the average primal iterate and zero dual (which is optimal
     * for the primal feasibility problem) as the initial solution. The dual
     * feasibility phase runs PDHG on the dual feasibility problem (obtained by
     * changing all finite variable and constraint bounds to zero), using the
     * average dual iterate and zero primal (which is optimal for the dual
     * feasibility problem) as the initial solution. The primal solution from the
     * primal feasibility phase and dual solution from the dual feasibility phase
     * are then combined (forming a solution of type
     * `POINT_TYPE_FEASIBILITY_POLISHING_SOLUTION`) and checked against the
     * termination criteria.
     * </pre>
     *
     * <code>optional bool use_feasibility_polishing = 30 [default = false];</code>
     * @return Whether the useFeasibilityPolishing field is set.
     */
    @java.lang.Override
    public boolean hasUseFeasibilityPolishing() {
      return ((bitField0_ & 0x02000000) != 0);
    }
    /**
     * <pre>
     * If true, periodically runs feasibility polishing, which attempts to move
     * from latest average iterate to one that is closer to feasibility (i.e., has
     * smaller primal and dual residuals) while probably increasing the objective
     * gap. This is useful primarily when the feasibility tolerances are fairly
     * tight and the objective gap tolerance is somewhat looser. Note that this
     * does not change the termination criteria, but rather can help achieve the
     * termination criteria more quickly when the objective gap is not as
     * important as feasibility.
     *
     * `use_feasibility_polishing` cannot be used with glop presolve, and requires
     * `handle_some_primal_gradients_on_finite_bounds_as_residuals == false`.
     * `use_feasibility_polishing` can only be used with linear programs.
     *
     * Feasibility polishing runs two separate phases, primal feasibility and dual
     * feasibility. The primal feasibility phase runs PDHG on the primal
     * feasibility problem (obtained by changing the objective vector to all
     * zeros), using the average primal iterate and zero dual (which is optimal
     * for the primal feasibility problem) as the initial solution. The dual
     * feasibility phase runs PDHG on the dual feasibility problem (obtained by
     * changing all finite variable and constraint bounds to zero), using the
     * average dual iterate and zero primal (which is optimal for the dual
     * feasibility problem) as the initial solution. The primal solution from the
     * primal feasibility phase and dual solution from the dual feasibility phase
     * are then combined (forming a solution of type
     * `POINT_TYPE_FEASIBILITY_POLISHING_SOLUTION`) and checked against the
     * termination criteria.
     * </pre>
     *
     * <code>optional bool use_feasibility_polishing = 30 [default = false];</code>
     * @return The useFeasibilityPolishing.
     */
    @java.lang.Override
    public boolean getUseFeasibilityPolishing() {
      return useFeasibilityPolishing_;
    }
    /**
     * <pre>
     * If true, periodically runs feasibility polishing, which attempts to move
     * from latest average iterate to one that is closer to feasibility (i.e., has
     * smaller primal and dual residuals) while probably increasing the objective
     * gap. This is useful primarily when the feasibility tolerances are fairly
     * tight and the objective gap tolerance is somewhat looser. Note that this
     * does not change the termination criteria, but rather can help achieve the
     * termination criteria more quickly when the objective gap is not as
     * important as feasibility.
     *
     * `use_feasibility_polishing` cannot be used with glop presolve, and requires
     * `handle_some_primal_gradients_on_finite_bounds_as_residuals == false`.
     * `use_feasibility_polishing` can only be used with linear programs.
     *
     * Feasibility polishing runs two separate phases, primal feasibility and dual
     * feasibility. The primal feasibility phase runs PDHG on the primal
     * feasibility problem (obtained by changing the objective vector to all
     * zeros), using the average primal iterate and zero dual (which is optimal
     * for the primal feasibility problem) as the initial solution. The dual
     * feasibility phase runs PDHG on the dual feasibility problem (obtained by
     * changing all finite variable and constraint bounds to zero), using the
     * average dual iterate and zero primal (which is optimal for the dual
     * feasibility problem) as the initial solution. The primal solution from the
     * primal feasibility phase and dual solution from the dual feasibility phase
     * are then combined (forming a solution of type
     * `POINT_TYPE_FEASIBILITY_POLISHING_SOLUTION`) and checked against the
     * termination criteria.
     * </pre>
     *
     * <code>optional bool use_feasibility_polishing = 30 [default = false];</code>
     * @param value The useFeasibilityPolishing to set.
     * @return This builder for chaining.
     */
    public Builder setUseFeasibilityPolishing(boolean value) {

      useFeasibilityPolishing_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, periodically runs feasibility polishing, which attempts to move
     * from latest average iterate to one that is closer to feasibility (i.e., has
     * smaller primal and dual residuals) while probably increasing the objective
     * gap. This is useful primarily when the feasibility tolerances are fairly
     * tight and the objective gap tolerance is somewhat looser. Note that this
     * does not change the termination criteria, but rather can help achieve the
     * termination criteria more quickly when the objective gap is not as
     * important as feasibility.
     *
     * `use_feasibility_polishing` cannot be used with glop presolve, and requires
     * `handle_some_primal_gradients_on_finite_bounds_as_residuals == false`.
     * `use_feasibility_polishing` can only be used with linear programs.
     *
     * Feasibility polishing runs two separate phases, primal feasibility and dual
     * feasibility. The primal feasibility phase runs PDHG on the primal
     * feasibility problem (obtained by changing the objective vector to all
     * zeros), using the average primal iterate and zero dual (which is optimal
     * for the primal feasibility problem) as the initial solution. The dual
     * feasibility phase runs PDHG on the dual feasibility problem (obtained by
     * changing all finite variable and constraint bounds to zero), using the
     * average dual iterate and zero primal (which is optimal for the dual
     * feasibility problem) as the initial solution. The primal solution from the
     * primal feasibility phase and dual solution from the dual feasibility phase
     * are then combined (forming a solution of type
     * `POINT_TYPE_FEASIBILITY_POLISHING_SOLUTION`) and checked against the
     * termination criteria.
     * </pre>
     *
     * <code>optional bool use_feasibility_polishing = 30 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseFeasibilityPolishing() {
      bitField0_ = (bitField0_ & ~0x02000000);
      useFeasibilityPolishing_ = false;
      onChanged();
      return this;
    }

    // @@protoc_insertion_point(builder_scope:operations_research.pdlp.PrimalDualHybridGradientParams)
  }

  // @@protoc_insertion_point(class_scope:operations_research.pdlp.PrimalDualHybridGradientParams)
  private static final com.google.ortools.pdlp.PrimalDualHybridGradientParams DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ortools.pdlp.PrimalDualHybridGradientParams();
  }

  public static com.google.ortools.pdlp.PrimalDualHybridGradientParams getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PrimalDualHybridGradientParams>
      PARSER = new com.google.protobuf.AbstractParser<PrimalDualHybridGradientParams>() {
    @java.lang.Override
    public PrimalDualHybridGradientParams parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<PrimalDualHybridGradientParams> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PrimalDualHybridGradientParams> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ortools.pdlp.PrimalDualHybridGradientParams getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

