// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: ortools/sat/sat_parameters.proto

// Protobuf Java Version: 4.26.1
package com.google.ortools.sat;

/**
 * <pre>
 * Contains the definitions for all the sat algorithm parameters and their
 * default values.
 *
 * NEXT TAG: 296
 * </pre>
 *
 * Protobuf type {@code operations_research.sat.SatParameters}
 */
public final class SatParameters extends
    com.google.protobuf.GeneratedMessage implements
    // @@protoc_insertion_point(message_implements:operations_research.sat.SatParameters)
    SatParametersOrBuilder {
private static final long serialVersionUID = 0L;
  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
      com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
      /* major= */ 4,
      /* minor= */ 26,
      /* patch= */ 1,
      /* suffix= */ "",
      SatParameters.class.getName());
  }
  // Use SatParameters.newBuilder() to construct.
  private SatParameters(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }
  private SatParameters() {
    name_ = "";
    preferredVariableOrder_ = 0;
    initialPolarity_ = 1;
    usePhaseSaving_ = true;
    polarityRephaseIncrement_ = 1000;
    minimizationAlgorithm_ = 2;
    binaryMinimizationAlgorithm_ = 1;
    subsumptionDuringConflictAnalysis_ = true;
    clauseCleanupPeriod_ = 10000;
    clauseCleanupRatio_ = 0.5D;
    clauseCleanupProtection_ = 0;
    clauseCleanupLbdBound_ = 5;
    clauseCleanupOrdering_ = 0;
    pbCleanupIncrement_ = 200;
    pbCleanupRatio_ = 0.5D;
    variableActivityDecay_ = 0.8D;
    maxVariableActivityValue_ = 1e+100D;
    glucoseMaxDecay_ = 0.95D;
    glucoseDecayIncrement_ = 0.01D;
    glucoseDecayIncrementPeriod_ = 5000;
    clauseActivityDecay_ = 0.999D;
    maxClauseActivityValue_ = 1e+20D;
    restartAlgorithms_ = java.util.Collections.emptyList();
    defaultRestartAlgorithms_ = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART";
    restartPeriod_ = 50;
    restartRunningWindowSize_ = 50;
    restartDlAverageRatio_ = 1D;
    restartLbdAverageRatio_ = 1D;
    blockingRestartWindowSize_ = 5000;
    blockingRestartMultiplier_ = 1.4D;
    maxTimeInSeconds_ = Double.POSITIVE_INFINITY;
    maxDeterministicTime_ = Double.POSITIVE_INFINITY;
    maxNumberOfConflicts_ = 9223372036854775807L;
    maxMemoryInMb_ = 10000L;
    absoluteGapLimit_ = 0.0001D;
    randomSeed_ = 1;
    logPrefix_ = "";
    logToStdout_ = true;
    countAssumptionLevelsInLbd_ = true;
    presolveBveThreshold_ = 500;
    presolveBveClauseWeight_ = 3;
    probingDeterministicTimeLimit_ = 1D;
    presolveProbingDeterministicTimeLimit_ = 30D;
    presolveBlockedClause_ = true;
    presolveUseBva_ = true;
    presolveBvaThreshold_ = 1;
    maxPresolveIterations_ = 3;
    cpModelPresolve_ = true;
    cpModelProbingLevel_ = 2;
    cpModelUseSatPresolve_ = true;
    tableCompressionLevel_ = 2;
    expandReservoirConstraints_ = true;
    mergeNoOverlapWorkLimit_ = 1000000000000D;
    mergeAtMostOneWorkLimit_ = 100000000D;
    presolveSubstitutionLevel_ = 1;
    presolveInclusionWorkLimit_ = 100000000L;
    ignoreNames_ = true;
    inferAllDiffs_ = true;
    findBigLinearOverlap_ = true;
    useSatInprocessing_ = true;
    inprocessingDtimeRatio_ = 0.2D;
    inprocessingProbingDtime_ = 1D;
    inprocessingMinimizationDtime_ = 1D;
    subsolvers_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    extraSubsolvers_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    ignoreSubsolvers_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    filterSubsolvers_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    subsolverParams_ = java.util.Collections.emptyList();
    shareObjectiveBounds_ = true;
    shareLevelZeroBounds_ = true;
    shareBinaryClauses_ = true;
    useOptimizationHints_ = true;
    coreMinimizationLevel_ = 2;
    findMultipleCores_ = true;
    coverOptimization_ = true;
    maxSatAssumptionOrder_ = 0;
    maxSatStratification_ = 1;
    propagationLoopDetectionFactor_ = 10D;
    usePrecedencesInDisjunctiveConstraint_ = true;
    maxSizeToCreatePrecedenceLiteralsInDisjunctive_ = 60;
    maxNumIntervalsForTimetableEdgeFinding_ = 100;
    useDisjunctiveConstraintInCumulative_ = true;
    maxPairsPairwiseReasoningInNoOverlap2D_ = 1250;
    useDualSchedulingHeuristics_ = true;
    searchBranching_ = 0;
    hintConflictLimit_ = 10;
    useExtendedProbing_ = true;
    probingNumCombinationsLimit_ = 20000;
    useShavingInProbingSearch_ = true;
    shavingSearchDeterministicTime_ = 0.001D;
    shavingSearchThreshold_ = 64L;
    pseudoCostReliabilityThreshold_ = 100L;
    binarySearchNumConflicts_ = -1;
    useFeasibilityJump_ = true;
    feasibilityJumpDecay_ = 0.95D;
    feasibilityJumpLinearizationLevel_ = 2;
    feasibilityJumpRestartFactor_ = 1;
    feasibilityJumpBatchDtime_ = 0.1D;
    feasibilityJumpVarRandomizationProbability_ = 0.05D;
    feasibilityJumpVarPerburbationRangeRatio_ = 0.2D;
    feasibilityJumpEnableRestarts_ = true;
    feasibilityJumpMaxExpandedConstraintSize_ = 500;
    violationLsPerturbationPeriod_ = 100;
    violationLsCompoundMoveProbability_ = 0.5D;
    sharedTreeWorkerObjectiveSplitProbability_ = 0.5D;
    sharedTreeWorkerMinRestartsPerSubtree_ = 1;
    sharedTreeWorkerEnableTrailSharing_ = true;
    sharedTreeOpenLeavesPerWorker_ = 2D;
    sharedTreeMaxNodesPerWorker_ = 100000;
    sharedTreeSplitStrategy_ = 0;
    instantiateAllVariables_ = true;
    autoDetectGreaterThanAtLeastOneOf_ = true;
    useLns_ = true;
    solutionPoolSize_ = 3;
    useRinsLns_ = true;
    useFeasibilityPump_ = true;
    fpRounding_ = 2;
    useExactLpReason_ = true;
    atMostOneMaxExpansionSize_ = 3;
    catchSigintSignal_ = true;
    useImpliedBounds_ = true;
    lpPrimalTolerance_ = 1e-07D;
    lpDualTolerance_ = 1e-07D;
    convertIntervals_ = true;
    symmetryLevel_ = 2;
    newLinearPropagation_ = true;
    linearSplitSize_ = 100;
    linearizationLevel_ = 1;
    booleanEncodingLevel_ = 1;
    maxDomainSizeWhenEncodingEqNeqConstraints_ = 16;
    maxNumCuts_ = 10000;
    cutLevel_ = 1;
    addCgCuts_ = true;
    addMirCuts_ = true;
    addZeroHalfCuts_ = true;
    addCliqueCuts_ = true;
    addRltCuts_ = true;
    maxAllDiffCutSize_ = 64;
    addLinMaxCuts_ = true;
    maxIntegerRoundingScaling_ = 600;
    addLpConstraintsLazily_ = true;
    rootLpIterations_ = 2000;
    minOrthogonalityForLpConstraints_ = 0.05D;
    maxCutRoundsAtLevelZero_ = 1;
    maxConsecutiveInactiveCount_ = 100;
    cutMaxActiveCountValue_ = 10000000000D;
    cutActiveCountDecay_ = 0.8D;
    cutCleanupTarget_ = 1000;
    newConstraintsBatchSize_ = 50;
    exploitIntegerLpSolution_ = true;
    exploitAllLpSolution_ = true;
    exploitObjective_ = true;
    mipMaxBound_ = 10000000D;
    mipVarScaling_ = 1D;
    mipAutomaticallyScaleVariables_ = true;
    mipWantedPrecision_ = 1e-06D;
    mipMaxActivityExponent_ = 53;
    mipCheckPrecision_ = 0.0001D;
    mipComputeTrueObjectiveBound_ = true;
    mipMaxValidMagnitude_ = 1e+20D;
    mipDropTolerance_ = 1e-16D;
    mipPresolveLevel_ = 2;
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ortools.sat.SatParametersOuterClass.internal_static_operations_research_sat_SatParameters_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ortools.sat.SatParametersOuterClass.internal_static_operations_research_sat_SatParameters_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ortools.sat.SatParameters.class, com.google.ortools.sat.SatParameters.Builder.class);
  }

  /**
   * <pre>
   * Variables without activity (i.e. at the beginning of the search) will be
   * tried in this preferred order.
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.VariableOrder}
   */
  public enum VariableOrder
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * As specified by the problem.
     * </pre>
     *
     * <code>IN_ORDER = 0;</code>
     */
    IN_ORDER(0),
    /**
     * <code>IN_REVERSE_ORDER = 1;</code>
     */
    IN_REVERSE_ORDER(1),
    /**
     * <code>IN_RANDOM_ORDER = 2;</code>
     */
    IN_RANDOM_ORDER(2),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 26,
        /* patch= */ 1,
        /* suffix= */ "",
        VariableOrder.class.getName());
    }
    /**
     * <pre>
     * As specified by the problem.
     * </pre>
     *
     * <code>IN_ORDER = 0;</code>
     */
    public static final int IN_ORDER_VALUE = 0;
    /**
     * <code>IN_REVERSE_ORDER = 1;</code>
     */
    public static final int IN_REVERSE_ORDER_VALUE = 1;
    /**
     * <code>IN_RANDOM_ORDER = 2;</code>
     */
    public static final int IN_RANDOM_ORDER_VALUE = 2;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VariableOrder valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static VariableOrder forNumber(int value) {
      switch (value) {
        case 0: return IN_ORDER;
        case 1: return IN_REVERSE_ORDER;
        case 2: return IN_RANDOM_ORDER;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<VariableOrder>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        VariableOrder> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<VariableOrder>() {
            public VariableOrder findValueByNumber(int number) {
              return VariableOrder.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(0);
    }

    private static final VariableOrder[] VALUES = values();

    public static VariableOrder valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private VariableOrder(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.VariableOrder)
  }

  /**
   * <pre>
   * Specifies the initial polarity (true/false) when the solver branches on a
   * variable. This can be modified later by the user, or the phase saving
   * heuristic.
   *
   * Note(user): POLARITY_FALSE is usually a good choice because of the
   * "natural" way to express a linear boolean problem.
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.Polarity}
   */
  public enum Polarity
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>POLARITY_TRUE = 0;</code>
     */
    POLARITY_TRUE(0),
    /**
     * <code>POLARITY_FALSE = 1;</code>
     */
    POLARITY_FALSE(1),
    /**
     * <code>POLARITY_RANDOM = 2;</code>
     */
    POLARITY_RANDOM(2),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 26,
        /* patch= */ 1,
        /* suffix= */ "",
        Polarity.class.getName());
    }
    /**
     * <code>POLARITY_TRUE = 0;</code>
     */
    public static final int POLARITY_TRUE_VALUE = 0;
    /**
     * <code>POLARITY_FALSE = 1;</code>
     */
    public static final int POLARITY_FALSE_VALUE = 1;
    /**
     * <code>POLARITY_RANDOM = 2;</code>
     */
    public static final int POLARITY_RANDOM_VALUE = 2;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Polarity valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Polarity forNumber(int value) {
      switch (value) {
        case 0: return POLARITY_TRUE;
        case 1: return POLARITY_FALSE;
        case 2: return POLARITY_RANDOM;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Polarity>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        Polarity> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Polarity>() {
            public Polarity findValueByNumber(int number) {
              return Polarity.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(1);
    }

    private static final Polarity[] VALUES = values();

    public static Polarity valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Polarity(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.Polarity)
  }

  /**
   * <pre>
   * Do we try to minimize conflicts (greedily) when creating them.
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.ConflictMinimizationAlgorithm}
   */
  public enum ConflictMinimizationAlgorithm
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>NONE = 0;</code>
     */
    NONE(0),
    /**
     * <code>SIMPLE = 1;</code>
     */
    SIMPLE(1),
    /**
     * <code>RECURSIVE = 2;</code>
     */
    RECURSIVE(2),
    /**
     * <code>EXPERIMENTAL = 3;</code>
     */
    EXPERIMENTAL(3),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 26,
        /* patch= */ 1,
        /* suffix= */ "",
        ConflictMinimizationAlgorithm.class.getName());
    }
    /**
     * <code>NONE = 0;</code>
     */
    public static final int NONE_VALUE = 0;
    /**
     * <code>SIMPLE = 1;</code>
     */
    public static final int SIMPLE_VALUE = 1;
    /**
     * <code>RECURSIVE = 2;</code>
     */
    public static final int RECURSIVE_VALUE = 2;
    /**
     * <code>EXPERIMENTAL = 3;</code>
     */
    public static final int EXPERIMENTAL_VALUE = 3;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConflictMinimizationAlgorithm valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ConflictMinimizationAlgorithm forNumber(int value) {
      switch (value) {
        case 0: return NONE;
        case 1: return SIMPLE;
        case 2: return RECURSIVE;
        case 3: return EXPERIMENTAL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConflictMinimizationAlgorithm>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ConflictMinimizationAlgorithm> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ConflictMinimizationAlgorithm>() {
            public ConflictMinimizationAlgorithm findValueByNumber(int number) {
              return ConflictMinimizationAlgorithm.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(2);
    }

    private static final ConflictMinimizationAlgorithm[] VALUES = values();

    public static ConflictMinimizationAlgorithm valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConflictMinimizationAlgorithm(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.ConflictMinimizationAlgorithm)
  }

  /**
   * <pre>
   * Whether to expoit the binary clause to minimize learned clauses further.
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.BinaryMinizationAlgorithm}
   */
  public enum BinaryMinizationAlgorithm
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>NO_BINARY_MINIMIZATION = 0;</code>
     */
    NO_BINARY_MINIMIZATION(0),
    /**
     * <code>BINARY_MINIMIZATION_FIRST = 1;</code>
     */
    BINARY_MINIMIZATION_FIRST(1),
    /**
     * <code>BINARY_MINIMIZATION_FIRST_WITH_TRANSITIVE_REDUCTION = 4;</code>
     */
    BINARY_MINIMIZATION_FIRST_WITH_TRANSITIVE_REDUCTION(4),
    /**
     * <code>BINARY_MINIMIZATION_WITH_REACHABILITY = 2;</code>
     */
    BINARY_MINIMIZATION_WITH_REACHABILITY(2),
    /**
     * <code>EXPERIMENTAL_BINARY_MINIMIZATION = 3;</code>
     */
    EXPERIMENTAL_BINARY_MINIMIZATION(3),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 26,
        /* patch= */ 1,
        /* suffix= */ "",
        BinaryMinizationAlgorithm.class.getName());
    }
    /**
     * <code>NO_BINARY_MINIMIZATION = 0;</code>
     */
    public static final int NO_BINARY_MINIMIZATION_VALUE = 0;
    /**
     * <code>BINARY_MINIMIZATION_FIRST = 1;</code>
     */
    public static final int BINARY_MINIMIZATION_FIRST_VALUE = 1;
    /**
     * <code>BINARY_MINIMIZATION_FIRST_WITH_TRANSITIVE_REDUCTION = 4;</code>
     */
    public static final int BINARY_MINIMIZATION_FIRST_WITH_TRANSITIVE_REDUCTION_VALUE = 4;
    /**
     * <code>BINARY_MINIMIZATION_WITH_REACHABILITY = 2;</code>
     */
    public static final int BINARY_MINIMIZATION_WITH_REACHABILITY_VALUE = 2;
    /**
     * <code>EXPERIMENTAL_BINARY_MINIMIZATION = 3;</code>
     */
    public static final int EXPERIMENTAL_BINARY_MINIMIZATION_VALUE = 3;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BinaryMinizationAlgorithm valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static BinaryMinizationAlgorithm forNumber(int value) {
      switch (value) {
        case 0: return NO_BINARY_MINIMIZATION;
        case 1: return BINARY_MINIMIZATION_FIRST;
        case 4: return BINARY_MINIMIZATION_FIRST_WITH_TRANSITIVE_REDUCTION;
        case 2: return BINARY_MINIMIZATION_WITH_REACHABILITY;
        case 3: return EXPERIMENTAL_BINARY_MINIMIZATION;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<BinaryMinizationAlgorithm>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        BinaryMinizationAlgorithm> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<BinaryMinizationAlgorithm>() {
            public BinaryMinizationAlgorithm findValueByNumber(int number) {
              return BinaryMinizationAlgorithm.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(3);
    }

    private static final BinaryMinizationAlgorithm[] VALUES = values();

    public static BinaryMinizationAlgorithm valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private BinaryMinizationAlgorithm(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.BinaryMinizationAlgorithm)
  }

  /**
   * <pre>
   * Each time a clause activity is bumped, the clause has a chance to be
   * protected during the next cleanup phase. Note that clauses used as a reason
   * are always protected.
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.ClauseProtection}
   */
  public enum ClauseProtection
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * No protection.
     * </pre>
     *
     * <code>PROTECTION_NONE = 0;</code>
     */
    PROTECTION_NONE(0),
    /**
     * <pre>
     * Protect all clauses whose activity is bumped.
     * </pre>
     *
     * <code>PROTECTION_ALWAYS = 1;</code>
     */
    PROTECTION_ALWAYS(1),
    /**
     * <pre>
     * Only protect clause with a better LBD.
     * </pre>
     *
     * <code>PROTECTION_LBD = 2;</code>
     */
    PROTECTION_LBD(2),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 26,
        /* patch= */ 1,
        /* suffix= */ "",
        ClauseProtection.class.getName());
    }
    /**
     * <pre>
     * No protection.
     * </pre>
     *
     * <code>PROTECTION_NONE = 0;</code>
     */
    public static final int PROTECTION_NONE_VALUE = 0;
    /**
     * <pre>
     * Protect all clauses whose activity is bumped.
     * </pre>
     *
     * <code>PROTECTION_ALWAYS = 1;</code>
     */
    public static final int PROTECTION_ALWAYS_VALUE = 1;
    /**
     * <pre>
     * Only protect clause with a better LBD.
     * </pre>
     *
     * <code>PROTECTION_LBD = 2;</code>
     */
    public static final int PROTECTION_LBD_VALUE = 2;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ClauseProtection valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ClauseProtection forNumber(int value) {
      switch (value) {
        case 0: return PROTECTION_NONE;
        case 1: return PROTECTION_ALWAYS;
        case 2: return PROTECTION_LBD;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ClauseProtection>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ClauseProtection> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ClauseProtection>() {
            public ClauseProtection findValueByNumber(int number) {
              return ClauseProtection.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(4);
    }

    private static final ClauseProtection[] VALUES = values();

    public static ClauseProtection valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ClauseProtection(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.ClauseProtection)
  }

  /**
   * <pre>
   * The clauses that will be kept during a cleanup are the ones that come
   * first under this order. We always keep or exclude ties together.
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.ClauseOrdering}
   */
  public enum ClauseOrdering
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Order clause by decreasing activity, then by increasing LBD.
     * </pre>
     *
     * <code>CLAUSE_ACTIVITY = 0;</code>
     */
    CLAUSE_ACTIVITY(0),
    /**
     * <pre>
     * Order clause by increasing LBD, then by decreasing activity.
     * </pre>
     *
     * <code>CLAUSE_LBD = 1;</code>
     */
    CLAUSE_LBD(1),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 26,
        /* patch= */ 1,
        /* suffix= */ "",
        ClauseOrdering.class.getName());
    }
    /**
     * <pre>
     * Order clause by decreasing activity, then by increasing LBD.
     * </pre>
     *
     * <code>CLAUSE_ACTIVITY = 0;</code>
     */
    public static final int CLAUSE_ACTIVITY_VALUE = 0;
    /**
     * <pre>
     * Order clause by increasing LBD, then by decreasing activity.
     * </pre>
     *
     * <code>CLAUSE_LBD = 1;</code>
     */
    public static final int CLAUSE_LBD_VALUE = 1;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ClauseOrdering valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ClauseOrdering forNumber(int value) {
      switch (value) {
        case 0: return CLAUSE_ACTIVITY;
        case 1: return CLAUSE_LBD;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ClauseOrdering>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ClauseOrdering> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ClauseOrdering>() {
            public ClauseOrdering findValueByNumber(int number) {
              return ClauseOrdering.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(5);
    }

    private static final ClauseOrdering[] VALUES = values();

    public static ClauseOrdering valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ClauseOrdering(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.ClauseOrdering)
  }

  /**
   * <pre>
   * Restart algorithms.
   *
   * A reference for the more advanced ones is:
   * Gilles Audemard, Laurent Simon, "Refining Restarts Strategies for SAT
   * and UNSAT", Principles and Practice of Constraint Programming Lecture
   * Notes in Computer Science 2012, pp 118-126
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.RestartAlgorithm}
   */
  public enum RestartAlgorithm
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>NO_RESTART = 0;</code>
     */
    NO_RESTART(0),
    /**
     * <pre>
     * Just follow a Luby sequence times restart_period.
     * </pre>
     *
     * <code>LUBY_RESTART = 1;</code>
     */
    LUBY_RESTART(1),
    /**
     * <pre>
     * Moving average restart based on the decision level of conflicts.
     * </pre>
     *
     * <code>DL_MOVING_AVERAGE_RESTART = 2;</code>
     */
    DL_MOVING_AVERAGE_RESTART(2),
    /**
     * <pre>
     * Moving average restart based on the LBD of conflicts.
     * </pre>
     *
     * <code>LBD_MOVING_AVERAGE_RESTART = 3;</code>
     */
    LBD_MOVING_AVERAGE_RESTART(3),
    /**
     * <pre>
     * Fixed period restart every restart period.
     * </pre>
     *
     * <code>FIXED_RESTART = 4;</code>
     */
    FIXED_RESTART(4),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 26,
        /* patch= */ 1,
        /* suffix= */ "",
        RestartAlgorithm.class.getName());
    }
    /**
     * <code>NO_RESTART = 0;</code>
     */
    public static final int NO_RESTART_VALUE = 0;
    /**
     * <pre>
     * Just follow a Luby sequence times restart_period.
     * </pre>
     *
     * <code>LUBY_RESTART = 1;</code>
     */
    public static final int LUBY_RESTART_VALUE = 1;
    /**
     * <pre>
     * Moving average restart based on the decision level of conflicts.
     * </pre>
     *
     * <code>DL_MOVING_AVERAGE_RESTART = 2;</code>
     */
    public static final int DL_MOVING_AVERAGE_RESTART_VALUE = 2;
    /**
     * <pre>
     * Moving average restart based on the LBD of conflicts.
     * </pre>
     *
     * <code>LBD_MOVING_AVERAGE_RESTART = 3;</code>
     */
    public static final int LBD_MOVING_AVERAGE_RESTART_VALUE = 3;
    /**
     * <pre>
     * Fixed period restart every restart period.
     * </pre>
     *
     * <code>FIXED_RESTART = 4;</code>
     */
    public static final int FIXED_RESTART_VALUE = 4;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RestartAlgorithm valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RestartAlgorithm forNumber(int value) {
      switch (value) {
        case 0: return NO_RESTART;
        case 1: return LUBY_RESTART;
        case 2: return DL_MOVING_AVERAGE_RESTART;
        case 3: return LBD_MOVING_AVERAGE_RESTART;
        case 4: return FIXED_RESTART;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RestartAlgorithm>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        RestartAlgorithm> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<RestartAlgorithm>() {
            public RestartAlgorithm findValueByNumber(int number) {
              return RestartAlgorithm.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(6);
    }

    private static final RestartAlgorithm[] VALUES = values();

    public static RestartAlgorithm valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RestartAlgorithm(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.RestartAlgorithm)
  }

  /**
   * <pre>
   * In what order do we add the assumptions in a core-based max-sat algorithm
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.MaxSatAssumptionOrder}
   */
  public enum MaxSatAssumptionOrder
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>DEFAULT_ASSUMPTION_ORDER = 0;</code>
     */
    DEFAULT_ASSUMPTION_ORDER(0),
    /**
     * <code>ORDER_ASSUMPTION_BY_DEPTH = 1;</code>
     */
    ORDER_ASSUMPTION_BY_DEPTH(1),
    /**
     * <code>ORDER_ASSUMPTION_BY_WEIGHT = 2;</code>
     */
    ORDER_ASSUMPTION_BY_WEIGHT(2),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 26,
        /* patch= */ 1,
        /* suffix= */ "",
        MaxSatAssumptionOrder.class.getName());
    }
    /**
     * <code>DEFAULT_ASSUMPTION_ORDER = 0;</code>
     */
    public static final int DEFAULT_ASSUMPTION_ORDER_VALUE = 0;
    /**
     * <code>ORDER_ASSUMPTION_BY_DEPTH = 1;</code>
     */
    public static final int ORDER_ASSUMPTION_BY_DEPTH_VALUE = 1;
    /**
     * <code>ORDER_ASSUMPTION_BY_WEIGHT = 2;</code>
     */
    public static final int ORDER_ASSUMPTION_BY_WEIGHT_VALUE = 2;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MaxSatAssumptionOrder valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MaxSatAssumptionOrder forNumber(int value) {
      switch (value) {
        case 0: return DEFAULT_ASSUMPTION_ORDER;
        case 1: return ORDER_ASSUMPTION_BY_DEPTH;
        case 2: return ORDER_ASSUMPTION_BY_WEIGHT;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MaxSatAssumptionOrder>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        MaxSatAssumptionOrder> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<MaxSatAssumptionOrder>() {
            public MaxSatAssumptionOrder findValueByNumber(int number) {
              return MaxSatAssumptionOrder.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(7);
    }

    private static final MaxSatAssumptionOrder[] VALUES = values();

    public static MaxSatAssumptionOrder valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MaxSatAssumptionOrder(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.MaxSatAssumptionOrder)
  }

  /**
   * <pre>
   * What stratification algorithm we use in the presence of weight.
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.MaxSatStratificationAlgorithm}
   */
  public enum MaxSatStratificationAlgorithm
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * No stratification of the problem.
     * </pre>
     *
     * <code>STRATIFICATION_NONE = 0;</code>
     */
    STRATIFICATION_NONE(0),
    /**
     * <pre>
     * Start with literals with the highest weight, and when SAT, add the
     * literals with the next highest weight and so on.
     * </pre>
     *
     * <code>STRATIFICATION_DESCENT = 1;</code>
     */
    STRATIFICATION_DESCENT(1),
    /**
     * <pre>
     * Start with all literals. Each time a core is found with a given minimum
     * weight, do not consider literals with a lower weight for the next core
     * computation. If the subproblem is SAT, do like in STRATIFICATION_DESCENT
     * and just add the literals with the next highest weight.
     * </pre>
     *
     * <code>STRATIFICATION_ASCENT = 2;</code>
     */
    STRATIFICATION_ASCENT(2),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 26,
        /* patch= */ 1,
        /* suffix= */ "",
        MaxSatStratificationAlgorithm.class.getName());
    }
    /**
     * <pre>
     * No stratification of the problem.
     * </pre>
     *
     * <code>STRATIFICATION_NONE = 0;</code>
     */
    public static final int STRATIFICATION_NONE_VALUE = 0;
    /**
     * <pre>
     * Start with literals with the highest weight, and when SAT, add the
     * literals with the next highest weight and so on.
     * </pre>
     *
     * <code>STRATIFICATION_DESCENT = 1;</code>
     */
    public static final int STRATIFICATION_DESCENT_VALUE = 1;
    /**
     * <pre>
     * Start with all literals. Each time a core is found with a given minimum
     * weight, do not consider literals with a lower weight for the next core
     * computation. If the subproblem is SAT, do like in STRATIFICATION_DESCENT
     * and just add the literals with the next highest weight.
     * </pre>
     *
     * <code>STRATIFICATION_ASCENT = 2;</code>
     */
    public static final int STRATIFICATION_ASCENT_VALUE = 2;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MaxSatStratificationAlgorithm valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MaxSatStratificationAlgorithm forNumber(int value) {
      switch (value) {
        case 0: return STRATIFICATION_NONE;
        case 1: return STRATIFICATION_DESCENT;
        case 2: return STRATIFICATION_ASCENT;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MaxSatStratificationAlgorithm>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        MaxSatStratificationAlgorithm> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<MaxSatStratificationAlgorithm>() {
            public MaxSatStratificationAlgorithm findValueByNumber(int number) {
              return MaxSatStratificationAlgorithm.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(8);
    }

    private static final MaxSatStratificationAlgorithm[] VALUES = values();

    public static MaxSatStratificationAlgorithm valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MaxSatStratificationAlgorithm(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.MaxSatStratificationAlgorithm)
  }

  /**
   * <pre>
   * The search branching will be used to decide how to branch on unfixed nodes.
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.SearchBranching}
   */
  public enum SearchBranching
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Try to fix all literals using the underlying SAT solver's heuristics,
     * then generate and fix literals until integer variables are fixed. New
     * literals on integer variables are generated using the fixed search
     * specified by the user or our default one.
     * </pre>
     *
     * <code>AUTOMATIC_SEARCH = 0;</code>
     */
    AUTOMATIC_SEARCH(0),
    /**
     * <pre>
     * If used then all decisions taken by the solver are made using a fixed
     * order as specified in the API or in the CpModelProto search_strategy
     * field.
     * </pre>
     *
     * <code>FIXED_SEARCH = 1;</code>
     */
    FIXED_SEARCH(1),
    /**
     * <pre>
     * Simple portfolio search used by LNS workers.
     * </pre>
     *
     * <code>PORTFOLIO_SEARCH = 2;</code>
     */
    PORTFOLIO_SEARCH(2),
    /**
     * <pre>
     * If used, the solver will use heuristics from the LP relaxation. This
     * exploit the reduced costs of the variables in the relaxation.
     * </pre>
     *
     * <code>LP_SEARCH = 3;</code>
     */
    LP_SEARCH(3),
    /**
     * <pre>
     * If used, the solver uses the pseudo costs for branching. Pseudo costs
     * are computed using the historical change in objective bounds when some
     * decision are taken. Note that this works whether we use an LP or not.
     * </pre>
     *
     * <code>PSEUDO_COST_SEARCH = 4;</code>
     */
    PSEUDO_COST_SEARCH(4),
    /**
     * <pre>
     * Mainly exposed here for testing. This quickly tries a lot of randomized
     * heuristics with a low conflict limit. It usually provides a good first
     * solution.
     * </pre>
     *
     * <code>PORTFOLIO_WITH_QUICK_RESTART_SEARCH = 5;</code>
     */
    PORTFOLIO_WITH_QUICK_RESTART_SEARCH(5),
    /**
     * <pre>
     * Mainly used internally. This is like FIXED_SEARCH, except we follow the
     * solution_hint field of the CpModelProto rather than using the information
     * provided in the search_strategy.
     * </pre>
     *
     * <code>HINT_SEARCH = 6;</code>
     */
    HINT_SEARCH(6),
    /**
     * <pre>
     * Similar to FIXED_SEARCH, but differ in how the variable not listed into
     * the fixed search heuristics are branched on. This will always start the
     * search tree according to the specified fixed search strategy, but will
     * complete it using the default automatic search.
     * </pre>
     *
     * <code>PARTIAL_FIXED_SEARCH = 7;</code>
     */
    PARTIAL_FIXED_SEARCH(7),
    /**
     * <pre>
     * Randomized search. Used to increase entropy in the search.
     * </pre>
     *
     * <code>RANDOMIZED_SEARCH = 8;</code>
     */
    RANDOMIZED_SEARCH(8),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 26,
        /* patch= */ 1,
        /* suffix= */ "",
        SearchBranching.class.getName());
    }
    /**
     * <pre>
     * Try to fix all literals using the underlying SAT solver's heuristics,
     * then generate and fix literals until integer variables are fixed. New
     * literals on integer variables are generated using the fixed search
     * specified by the user or our default one.
     * </pre>
     *
     * <code>AUTOMATIC_SEARCH = 0;</code>
     */
    public static final int AUTOMATIC_SEARCH_VALUE = 0;
    /**
     * <pre>
     * If used then all decisions taken by the solver are made using a fixed
     * order as specified in the API or in the CpModelProto search_strategy
     * field.
     * </pre>
     *
     * <code>FIXED_SEARCH = 1;</code>
     */
    public static final int FIXED_SEARCH_VALUE = 1;
    /**
     * <pre>
     * Simple portfolio search used by LNS workers.
     * </pre>
     *
     * <code>PORTFOLIO_SEARCH = 2;</code>
     */
    public static final int PORTFOLIO_SEARCH_VALUE = 2;
    /**
     * <pre>
     * If used, the solver will use heuristics from the LP relaxation. This
     * exploit the reduced costs of the variables in the relaxation.
     * </pre>
     *
     * <code>LP_SEARCH = 3;</code>
     */
    public static final int LP_SEARCH_VALUE = 3;
    /**
     * <pre>
     * If used, the solver uses the pseudo costs for branching. Pseudo costs
     * are computed using the historical change in objective bounds when some
     * decision are taken. Note that this works whether we use an LP or not.
     * </pre>
     *
     * <code>PSEUDO_COST_SEARCH = 4;</code>
     */
    public static final int PSEUDO_COST_SEARCH_VALUE = 4;
    /**
     * <pre>
     * Mainly exposed here for testing. This quickly tries a lot of randomized
     * heuristics with a low conflict limit. It usually provides a good first
     * solution.
     * </pre>
     *
     * <code>PORTFOLIO_WITH_QUICK_RESTART_SEARCH = 5;</code>
     */
    public static final int PORTFOLIO_WITH_QUICK_RESTART_SEARCH_VALUE = 5;
    /**
     * <pre>
     * Mainly used internally. This is like FIXED_SEARCH, except we follow the
     * solution_hint field of the CpModelProto rather than using the information
     * provided in the search_strategy.
     * </pre>
     *
     * <code>HINT_SEARCH = 6;</code>
     */
    public static final int HINT_SEARCH_VALUE = 6;
    /**
     * <pre>
     * Similar to FIXED_SEARCH, but differ in how the variable not listed into
     * the fixed search heuristics are branched on. This will always start the
     * search tree according to the specified fixed search strategy, but will
     * complete it using the default automatic search.
     * </pre>
     *
     * <code>PARTIAL_FIXED_SEARCH = 7;</code>
     */
    public static final int PARTIAL_FIXED_SEARCH_VALUE = 7;
    /**
     * <pre>
     * Randomized search. Used to increase entropy in the search.
     * </pre>
     *
     * <code>RANDOMIZED_SEARCH = 8;</code>
     */
    public static final int RANDOMIZED_SEARCH_VALUE = 8;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SearchBranching valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SearchBranching forNumber(int value) {
      switch (value) {
        case 0: return AUTOMATIC_SEARCH;
        case 1: return FIXED_SEARCH;
        case 2: return PORTFOLIO_SEARCH;
        case 3: return LP_SEARCH;
        case 4: return PSEUDO_COST_SEARCH;
        case 5: return PORTFOLIO_WITH_QUICK_RESTART_SEARCH;
        case 6: return HINT_SEARCH;
        case 7: return PARTIAL_FIXED_SEARCH;
        case 8: return RANDOMIZED_SEARCH;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SearchBranching>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        SearchBranching> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<SearchBranching>() {
            public SearchBranching findValueByNumber(int number) {
              return SearchBranching.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(9);
    }

    private static final SearchBranching[] VALUES = values();

    public static SearchBranching valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SearchBranching(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.SearchBranching)
  }

  /**
   * Protobuf enum {@code operations_research.sat.SatParameters.SharedTreeSplitStrategy}
   */
  public enum SharedTreeSplitStrategy
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Uses the default strategy, currently equivalent to
     * SPLIT_STRATEGY_DISCREPANCY.
     * </pre>
     *
     * <code>SPLIT_STRATEGY_AUTO = 0;</code>
     */
    SPLIT_STRATEGY_AUTO(0),
    /**
     * <pre>
     * Only accept splits if the node to be split's depth+discrepancy is minimal
     * for the desired number of leaves.
     * The preferred child for discrepancy calculation is the one with the
     * lowest objective lower bound or the original branch direction if the
     * bounds are equal. This rule allows twice as many workers to work in the
     * preferred subtree as non-preferred.
     * </pre>
     *
     * <code>SPLIT_STRATEGY_DISCREPANCY = 1;</code>
     */
    SPLIT_STRATEGY_DISCREPANCY(1),
    /**
     * <pre>
     * Only split nodes with an objective lb equal to the global lb. If there is
     * no objective, this is equivalent to SPLIT_STRATEGY_FIRST_PROPOSAL.
     * </pre>
     *
     * <code>SPLIT_STRATEGY_OBJECTIVE_LB = 2;</code>
     */
    SPLIT_STRATEGY_OBJECTIVE_LB(2),
    /**
     * <pre>
     * Attempt to keep the shared tree balanced.
     * </pre>
     *
     * <code>SPLIT_STRATEGY_BALANCED_TREE = 3;</code>
     */
    SPLIT_STRATEGY_BALANCED_TREE(3),
    /**
     * <pre>
     * Workers race to split their subtree, the winner's proposal is accepted.
     * </pre>
     *
     * <code>SPLIT_STRATEGY_FIRST_PROPOSAL = 4;</code>
     */
    SPLIT_STRATEGY_FIRST_PROPOSAL(4),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 26,
        /* patch= */ 1,
        /* suffix= */ "",
        SharedTreeSplitStrategy.class.getName());
    }
    /**
     * <pre>
     * Uses the default strategy, currently equivalent to
     * SPLIT_STRATEGY_DISCREPANCY.
     * </pre>
     *
     * <code>SPLIT_STRATEGY_AUTO = 0;</code>
     */
    public static final int SPLIT_STRATEGY_AUTO_VALUE = 0;
    /**
     * <pre>
     * Only accept splits if the node to be split's depth+discrepancy is minimal
     * for the desired number of leaves.
     * The preferred child for discrepancy calculation is the one with the
     * lowest objective lower bound or the original branch direction if the
     * bounds are equal. This rule allows twice as many workers to work in the
     * preferred subtree as non-preferred.
     * </pre>
     *
     * <code>SPLIT_STRATEGY_DISCREPANCY = 1;</code>
     */
    public static final int SPLIT_STRATEGY_DISCREPANCY_VALUE = 1;
    /**
     * <pre>
     * Only split nodes with an objective lb equal to the global lb. If there is
     * no objective, this is equivalent to SPLIT_STRATEGY_FIRST_PROPOSAL.
     * </pre>
     *
     * <code>SPLIT_STRATEGY_OBJECTIVE_LB = 2;</code>
     */
    public static final int SPLIT_STRATEGY_OBJECTIVE_LB_VALUE = 2;
    /**
     * <pre>
     * Attempt to keep the shared tree balanced.
     * </pre>
     *
     * <code>SPLIT_STRATEGY_BALANCED_TREE = 3;</code>
     */
    public static final int SPLIT_STRATEGY_BALANCED_TREE_VALUE = 3;
    /**
     * <pre>
     * Workers race to split their subtree, the winner's proposal is accepted.
     * </pre>
     *
     * <code>SPLIT_STRATEGY_FIRST_PROPOSAL = 4;</code>
     */
    public static final int SPLIT_STRATEGY_FIRST_PROPOSAL_VALUE = 4;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SharedTreeSplitStrategy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SharedTreeSplitStrategy forNumber(int value) {
      switch (value) {
        case 0: return SPLIT_STRATEGY_AUTO;
        case 1: return SPLIT_STRATEGY_DISCREPANCY;
        case 2: return SPLIT_STRATEGY_OBJECTIVE_LB;
        case 3: return SPLIT_STRATEGY_BALANCED_TREE;
        case 4: return SPLIT_STRATEGY_FIRST_PROPOSAL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SharedTreeSplitStrategy>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        SharedTreeSplitStrategy> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<SharedTreeSplitStrategy>() {
            public SharedTreeSplitStrategy findValueByNumber(int number) {
              return SharedTreeSplitStrategy.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(10);
    }

    private static final SharedTreeSplitStrategy[] VALUES = values();

    public static SharedTreeSplitStrategy valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SharedTreeSplitStrategy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.SharedTreeSplitStrategy)
  }

  /**
   * <pre>
   * Rounding method to use for feasibility pump.
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.SatParameters.FPRoundingMethod}
   */
  public enum FPRoundingMethod
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Rounds to the nearest integer value.
     * </pre>
     *
     * <code>NEAREST_INTEGER = 0;</code>
     */
    NEAREST_INTEGER(0),
    /**
     * <pre>
     * Counts the number of linear constraints restricting the variable in the
     * increasing values (up locks) and decreasing values (down locks). Rounds
     * the variable in the direction of lesser locks.
     * </pre>
     *
     * <code>LOCK_BASED = 1;</code>
     */
    LOCK_BASED(1),
    /**
     * <pre>
     * Similar to lock based rounding except this only considers locks of active
     * constraints from the last lp solve.
     * </pre>
     *
     * <code>ACTIVE_LOCK_BASED = 3;</code>
     */
    ACTIVE_LOCK_BASED(3),
    /**
     * <pre>
     * This is expensive rounding algorithm. We round variables one by one and
     * propagate the bounds in between. If none of the rounded values fall in
     * the continuous domain specified by lower and upper bound, we use the
     * current lower/upper bound (whichever one is closest) instead of rounding
     * the fractional lp solution value. If both the rounded values are in the
     * domain, we round to nearest integer.
     * </pre>
     *
     * <code>PROPAGATION_ASSISTED = 2;</code>
     */
    PROPAGATION_ASSISTED(2),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 26,
        /* patch= */ 1,
        /* suffix= */ "",
        FPRoundingMethod.class.getName());
    }
    /**
     * <pre>
     * Rounds to the nearest integer value.
     * </pre>
     *
     * <code>NEAREST_INTEGER = 0;</code>
     */
    public static final int NEAREST_INTEGER_VALUE = 0;
    /**
     * <pre>
     * Counts the number of linear constraints restricting the variable in the
     * increasing values (up locks) and decreasing values (down locks). Rounds
     * the variable in the direction of lesser locks.
     * </pre>
     *
     * <code>LOCK_BASED = 1;</code>
     */
    public static final int LOCK_BASED_VALUE = 1;
    /**
     * <pre>
     * Similar to lock based rounding except this only considers locks of active
     * constraints from the last lp solve.
     * </pre>
     *
     * <code>ACTIVE_LOCK_BASED = 3;</code>
     */
    public static final int ACTIVE_LOCK_BASED_VALUE = 3;
    /**
     * <pre>
     * This is expensive rounding algorithm. We round variables one by one and
     * propagate the bounds in between. If none of the rounded values fall in
     * the continuous domain specified by lower and upper bound, we use the
     * current lower/upper bound (whichever one is closest) instead of rounding
     * the fractional lp solution value. If both the rounded values are in the
     * domain, we round to nearest integer.
     * </pre>
     *
     * <code>PROPAGATION_ASSISTED = 2;</code>
     */
    public static final int PROPAGATION_ASSISTED_VALUE = 2;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FPRoundingMethod valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static FPRoundingMethod forNumber(int value) {
      switch (value) {
        case 0: return NEAREST_INTEGER;
        case 1: return LOCK_BASED;
        case 3: return ACTIVE_LOCK_BASED;
        case 2: return PROPAGATION_ASSISTED;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<FPRoundingMethod>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        FPRoundingMethod> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<FPRoundingMethod>() {
            public FPRoundingMethod findValueByNumber(int number) {
              return FPRoundingMethod.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParameters.getDescriptor().getEnumTypes().get(11);
    }

    private static final FPRoundingMethod[] VALUES = values();

    public static FPRoundingMethod valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private FPRoundingMethod(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.SatParameters.FPRoundingMethod)
  }

  private int bitField0_;
  private int bitField1_;
  private int bitField2_;
  private int bitField3_;
  private int bitField4_;
  private int bitField5_;
  private int bitField6_;
  private int bitField7_;
  public static final int NAME_FIELD_NUMBER = 171;
  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   * <pre>
   * In some context, like in a portfolio of search, it makes sense to name a
   * given parameters set for logging purpose.
   * </pre>
   *
   * <code>optional string name = 171 [default = ""];</code>
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * In some context, like in a portfolio of search, it makes sense to name a
   * given parameters set for logging purpose.
   * </pre>
   *
   * <code>optional string name = 171 [default = ""];</code>
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (bs.isValidUtf8()) {
        name_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * In some context, like in a portfolio of search, it makes sense to name a
   * given parameters set for logging purpose.
   * </pre>
   *
   * <code>optional string name = 171 [default = ""];</code>
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREFERRED_VARIABLE_ORDER_FIELD_NUMBER = 1;
  private int preferredVariableOrder_ = 0;
  /**
   * <code>optional .operations_research.sat.SatParameters.VariableOrder preferred_variable_order = 1 [default = IN_ORDER];</code>
   * @return Whether the preferredVariableOrder field is set.
   */
  @java.lang.Override public boolean hasPreferredVariableOrder() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <code>optional .operations_research.sat.SatParameters.VariableOrder preferred_variable_order = 1 [default = IN_ORDER];</code>
   * @return The preferredVariableOrder.
   */
  @java.lang.Override public com.google.ortools.sat.SatParameters.VariableOrder getPreferredVariableOrder() {
    com.google.ortools.sat.SatParameters.VariableOrder result = com.google.ortools.sat.SatParameters.VariableOrder.forNumber(preferredVariableOrder_);
    return result == null ? com.google.ortools.sat.SatParameters.VariableOrder.IN_ORDER : result;
  }

  public static final int INITIAL_POLARITY_FIELD_NUMBER = 2;
  private int initialPolarity_ = 1;
  /**
   * <code>optional .operations_research.sat.SatParameters.Polarity initial_polarity = 2 [default = POLARITY_FALSE];</code>
   * @return Whether the initialPolarity field is set.
   */
  @java.lang.Override public boolean hasInitialPolarity() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <code>optional .operations_research.sat.SatParameters.Polarity initial_polarity = 2 [default = POLARITY_FALSE];</code>
   * @return The initialPolarity.
   */
  @java.lang.Override public com.google.ortools.sat.SatParameters.Polarity getInitialPolarity() {
    com.google.ortools.sat.SatParameters.Polarity result = com.google.ortools.sat.SatParameters.Polarity.forNumber(initialPolarity_);
    return result == null ? com.google.ortools.sat.SatParameters.Polarity.POLARITY_FALSE : result;
  }

  public static final int USE_PHASE_SAVING_FIELD_NUMBER = 44;
  private boolean usePhaseSaving_ = true;
  /**
   * <pre>
   * If this is true, then the polarity of a variable will be the last value it
   * was assigned to, or its default polarity if it was never assigned since the
   * call to ResetDecisionHeuristic().
   *
   * Actually, we use a newer version where we follow the last value in the
   * longest non-conflicting partial assignment in the current phase.
   *
   * This is called 'literal phase saving'. For details see 'A Lightweight
   * Component Caching Scheme for Satisfiability Solvers' K. Pipatsrisawat and
   * A.Darwiche, In 10th International Conference on Theory and Applications of
   * Satisfiability Testing, 2007.
   * </pre>
   *
   * <code>optional bool use_phase_saving = 44 [default = true];</code>
   * @return Whether the usePhaseSaving field is set.
   */
  @java.lang.Override
  public boolean hasUsePhaseSaving() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * If this is true, then the polarity of a variable will be the last value it
   * was assigned to, or its default polarity if it was never assigned since the
   * call to ResetDecisionHeuristic().
   *
   * Actually, we use a newer version where we follow the last value in the
   * longest non-conflicting partial assignment in the current phase.
   *
   * This is called 'literal phase saving'. For details see 'A Lightweight
   * Component Caching Scheme for Satisfiability Solvers' K. Pipatsrisawat and
   * A.Darwiche, In 10th International Conference on Theory and Applications of
   * Satisfiability Testing, 2007.
   * </pre>
   *
   * <code>optional bool use_phase_saving = 44 [default = true];</code>
   * @return The usePhaseSaving.
   */
  @java.lang.Override
  public boolean getUsePhaseSaving() {
    return usePhaseSaving_;
  }

  public static final int POLARITY_REPHASE_INCREMENT_FIELD_NUMBER = 168;
  private int polarityRephaseIncrement_ = 1000;
  /**
   * <pre>
   * If non-zero, then we change the polarity heuristic after that many number
   * of conflicts in an arithmetically increasing fashion. So x the first time,
   * 2 * x the second time, etc...
   * </pre>
   *
   * <code>optional int32 polarity_rephase_increment = 168 [default = 1000];</code>
   * @return Whether the polarityRephaseIncrement field is set.
   */
  @java.lang.Override
  public boolean hasPolarityRephaseIncrement() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * If non-zero, then we change the polarity heuristic after that many number
   * of conflicts in an arithmetically increasing fashion. So x the first time,
   * 2 * x the second time, etc...
   * </pre>
   *
   * <code>optional int32 polarity_rephase_increment = 168 [default = 1000];</code>
   * @return The polarityRephaseIncrement.
   */
  @java.lang.Override
  public int getPolarityRephaseIncrement() {
    return polarityRephaseIncrement_;
  }

  public static final int RANDOM_POLARITY_RATIO_FIELD_NUMBER = 45;
  private double randomPolarityRatio_ = 0D;
  /**
   * <pre>
   * The proportion of polarity chosen at random. Note that this take
   * precedence over the phase saving heuristic. This is different from
   * initial_polarity:POLARITY_RANDOM because it will select a new random
   * polarity each time the variable is branched upon instead of selecting one
   * initially and then always taking this choice.
   * </pre>
   *
   * <code>optional double random_polarity_ratio = 45 [default = 0];</code>
   * @return Whether the randomPolarityRatio field is set.
   */
  @java.lang.Override
  public boolean hasRandomPolarityRatio() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   * <pre>
   * The proportion of polarity chosen at random. Note that this take
   * precedence over the phase saving heuristic. This is different from
   * initial_polarity:POLARITY_RANDOM because it will select a new random
   * polarity each time the variable is branched upon instead of selecting one
   * initially and then always taking this choice.
   * </pre>
   *
   * <code>optional double random_polarity_ratio = 45 [default = 0];</code>
   * @return The randomPolarityRatio.
   */
  @java.lang.Override
  public double getRandomPolarityRatio() {
    return randomPolarityRatio_;
  }

  public static final int RANDOM_BRANCHES_RATIO_FIELD_NUMBER = 32;
  private double randomBranchesRatio_ = 0D;
  /**
   * <pre>
   * A number between 0 and 1 that indicates the proportion of branching
   * variables that are selected randomly instead of choosing the first variable
   * from the given variable_ordering strategy.
   * </pre>
   *
   * <code>optional double random_branches_ratio = 32 [default = 0];</code>
   * @return Whether the randomBranchesRatio field is set.
   */
  @java.lang.Override
  public boolean hasRandomBranchesRatio() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   * <pre>
   * A number between 0 and 1 that indicates the proportion of branching
   * variables that are selected randomly instead of choosing the first variable
   * from the given variable_ordering strategy.
   * </pre>
   *
   * <code>optional double random_branches_ratio = 32 [default = 0];</code>
   * @return The randomBranchesRatio.
   */
  @java.lang.Override
  public double getRandomBranchesRatio() {
    return randomBranchesRatio_;
  }

  public static final int USE_ERWA_HEURISTIC_FIELD_NUMBER = 75;
  private boolean useErwaHeuristic_ = false;
  /**
   * <pre>
   * Whether we use the ERWA (Exponential Recency Weighted Average) heuristic as
   * described in "Learning Rate Based Branching Heuristic for SAT solvers",
   * J.H.Liang, V. Ganesh, P. Poupart, K.Czarnecki, SAT 2016.
   * </pre>
   *
   * <code>optional bool use_erwa_heuristic = 75 [default = false];</code>
   * @return Whether the useErwaHeuristic field is set.
   */
  @java.lang.Override
  public boolean hasUseErwaHeuristic() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   * <pre>
   * Whether we use the ERWA (Exponential Recency Weighted Average) heuristic as
   * described in "Learning Rate Based Branching Heuristic for SAT solvers",
   * J.H.Liang, V. Ganesh, P. Poupart, K.Czarnecki, SAT 2016.
   * </pre>
   *
   * <code>optional bool use_erwa_heuristic = 75 [default = false];</code>
   * @return The useErwaHeuristic.
   */
  @java.lang.Override
  public boolean getUseErwaHeuristic() {
    return useErwaHeuristic_;
  }

  public static final int INITIAL_VARIABLES_ACTIVITY_FIELD_NUMBER = 76;
  private double initialVariablesActivity_ = 0D;
  /**
   * <pre>
   * The initial value of the variables activity. A non-zero value only make
   * sense when use_erwa_heuristic is true. Experiments with a value of 1e-2
   * together with the ERWA heuristic showed slighthly better result than simply
   * using zero. The idea is that when the "learning rate" of a variable becomes
   * lower than this value, then we prefer to branch on never explored before
   * variables. This is not in the ERWA paper.
   * </pre>
   *
   * <code>optional double initial_variables_activity = 76 [default = 0];</code>
   * @return Whether the initialVariablesActivity field is set.
   */
  @java.lang.Override
  public boolean hasInitialVariablesActivity() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   * <pre>
   * The initial value of the variables activity. A non-zero value only make
   * sense when use_erwa_heuristic is true. Experiments with a value of 1e-2
   * together with the ERWA heuristic showed slighthly better result than simply
   * using zero. The idea is that when the "learning rate" of a variable becomes
   * lower than this value, then we prefer to branch on never explored before
   * variables. This is not in the ERWA paper.
   * </pre>
   *
   * <code>optional double initial_variables_activity = 76 [default = 0];</code>
   * @return The initialVariablesActivity.
   */
  @java.lang.Override
  public double getInitialVariablesActivity() {
    return initialVariablesActivity_;
  }

  public static final int ALSO_BUMP_VARIABLES_IN_CONFLICT_REASONS_FIELD_NUMBER = 77;
  private boolean alsoBumpVariablesInConflictReasons_ = false;
  /**
   * <pre>
   * When this is true, then the variables that appear in any of the reason of
   * the variables in a conflict have their activity bumped. This is addition to
   * the variables in the conflict, and the one that were used during conflict
   * resolution.
   * </pre>
   *
   * <code>optional bool also_bump_variables_in_conflict_reasons = 77 [default = false];</code>
   * @return Whether the alsoBumpVariablesInConflictReasons field is set.
   */
  @java.lang.Override
  public boolean hasAlsoBumpVariablesInConflictReasons() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   * <pre>
   * When this is true, then the variables that appear in any of the reason of
   * the variables in a conflict have their activity bumped. This is addition to
   * the variables in the conflict, and the one that were used during conflict
   * resolution.
   * </pre>
   *
   * <code>optional bool also_bump_variables_in_conflict_reasons = 77 [default = false];</code>
   * @return The alsoBumpVariablesInConflictReasons.
   */
  @java.lang.Override
  public boolean getAlsoBumpVariablesInConflictReasons() {
    return alsoBumpVariablesInConflictReasons_;
  }

  public static final int MINIMIZATION_ALGORITHM_FIELD_NUMBER = 4;
  private int minimizationAlgorithm_ = 2;
  /**
   * <code>optional .operations_research.sat.SatParameters.ConflictMinimizationAlgorithm minimization_algorithm = 4 [default = RECURSIVE];</code>
   * @return Whether the minimizationAlgorithm field is set.
   */
  @java.lang.Override public boolean hasMinimizationAlgorithm() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   * <code>optional .operations_research.sat.SatParameters.ConflictMinimizationAlgorithm minimization_algorithm = 4 [default = RECURSIVE];</code>
   * @return The minimizationAlgorithm.
   */
  @java.lang.Override public com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm getMinimizationAlgorithm() {
    com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm result = com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm.forNumber(minimizationAlgorithm_);
    return result == null ? com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm.RECURSIVE : result;
  }

  public static final int BINARY_MINIMIZATION_ALGORITHM_FIELD_NUMBER = 34;
  private int binaryMinimizationAlgorithm_ = 1;
  /**
   * <code>optional .operations_research.sat.SatParameters.BinaryMinizationAlgorithm binary_minimization_algorithm = 34 [default = BINARY_MINIMIZATION_FIRST];</code>
   * @return Whether the binaryMinimizationAlgorithm field is set.
   */
  @java.lang.Override public boolean hasBinaryMinimizationAlgorithm() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   * <code>optional .operations_research.sat.SatParameters.BinaryMinizationAlgorithm binary_minimization_algorithm = 34 [default = BINARY_MINIMIZATION_FIRST];</code>
   * @return The binaryMinimizationAlgorithm.
   */
  @java.lang.Override public com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm getBinaryMinimizationAlgorithm() {
    com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm result = com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm.forNumber(binaryMinimizationAlgorithm_);
    return result == null ? com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm.BINARY_MINIMIZATION_FIRST : result;
  }

  public static final int SUBSUMPTION_DURING_CONFLICT_ANALYSIS_FIELD_NUMBER = 56;
  private boolean subsumptionDuringConflictAnalysis_ = true;
  /**
   * <pre>
   * At a really low cost, during the 1-UIP conflict computation, it is easy to
   * detect if some of the involved reasons are subsumed by the current
   * conflict. When this is true, such clauses are detached and later removed
   * from the problem.
   * </pre>
   *
   * <code>optional bool subsumption_during_conflict_analysis = 56 [default = true];</code>
   * @return Whether the subsumptionDuringConflictAnalysis field is set.
   */
  @java.lang.Override
  public boolean hasSubsumptionDuringConflictAnalysis() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   * <pre>
   * At a really low cost, during the 1-UIP conflict computation, it is easy to
   * detect if some of the involved reasons are subsumed by the current
   * conflict. When this is true, such clauses are detached and later removed
   * from the problem.
   * </pre>
   *
   * <code>optional bool subsumption_during_conflict_analysis = 56 [default = true];</code>
   * @return The subsumptionDuringConflictAnalysis.
   */
  @java.lang.Override
  public boolean getSubsumptionDuringConflictAnalysis() {
    return subsumptionDuringConflictAnalysis_;
  }

  public static final int CLAUSE_CLEANUP_PERIOD_FIELD_NUMBER = 11;
  private int clauseCleanupPeriod_ = 10000;
  /**
   * <pre>
   * Trigger a cleanup when this number of "deletable" clauses is learned.
   * </pre>
   *
   * <code>optional int32 clause_cleanup_period = 11 [default = 10000];</code>
   * @return Whether the clauseCleanupPeriod field is set.
   */
  @java.lang.Override
  public boolean hasClauseCleanupPeriod() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   * <pre>
   * Trigger a cleanup when this number of "deletable" clauses is learned.
   * </pre>
   *
   * <code>optional int32 clause_cleanup_period = 11 [default = 10000];</code>
   * @return The clauseCleanupPeriod.
   */
  @java.lang.Override
  public int getClauseCleanupPeriod() {
    return clauseCleanupPeriod_;
  }

  public static final int CLAUSE_CLEANUP_TARGET_FIELD_NUMBER = 13;
  private int clauseCleanupTarget_ = 0;
  /**
   * <pre>
   * During a cleanup, we will always keep that number of "deletable" clauses.
   * Note that this doesn't include the "protected" clauses.
   * </pre>
   *
   * <code>optional int32 clause_cleanup_target = 13 [default = 0];</code>
   * @return Whether the clauseCleanupTarget field is set.
   */
  @java.lang.Override
  public boolean hasClauseCleanupTarget() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   * <pre>
   * During a cleanup, we will always keep that number of "deletable" clauses.
   * Note that this doesn't include the "protected" clauses.
   * </pre>
   *
   * <code>optional int32 clause_cleanup_target = 13 [default = 0];</code>
   * @return The clauseCleanupTarget.
   */
  @java.lang.Override
  public int getClauseCleanupTarget() {
    return clauseCleanupTarget_;
  }

  public static final int CLAUSE_CLEANUP_RATIO_FIELD_NUMBER = 190;
  private double clauseCleanupRatio_ = 0.5D;
  /**
   * <pre>
   * During a cleanup, if clause_cleanup_target is 0, we will delete the
   * clause_cleanup_ratio of "deletable" clauses instead of aiming for a fixed
   * target of clauses to keep.
   * </pre>
   *
   * <code>optional double clause_cleanup_ratio = 190 [default = 0.5];</code>
   * @return Whether the clauseCleanupRatio field is set.
   */
  @java.lang.Override
  public boolean hasClauseCleanupRatio() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   * <pre>
   * During a cleanup, if clause_cleanup_target is 0, we will delete the
   * clause_cleanup_ratio of "deletable" clauses instead of aiming for a fixed
   * target of clauses to keep.
   * </pre>
   *
   * <code>optional double clause_cleanup_ratio = 190 [default = 0.5];</code>
   * @return The clauseCleanupRatio.
   */
  @java.lang.Override
  public double getClauseCleanupRatio() {
    return clauseCleanupRatio_;
  }

  public static final int CLAUSE_CLEANUP_PROTECTION_FIELD_NUMBER = 58;
  private int clauseCleanupProtection_ = 0;
  /**
   * <code>optional .operations_research.sat.SatParameters.ClauseProtection clause_cleanup_protection = 58 [default = PROTECTION_NONE];</code>
   * @return Whether the clauseCleanupProtection field is set.
   */
  @java.lang.Override public boolean hasClauseCleanupProtection() {
    return ((bitField0_ & 0x00010000) != 0);
  }
  /**
   * <code>optional .operations_research.sat.SatParameters.ClauseProtection clause_cleanup_protection = 58 [default = PROTECTION_NONE];</code>
   * @return The clauseCleanupProtection.
   */
  @java.lang.Override public com.google.ortools.sat.SatParameters.ClauseProtection getClauseCleanupProtection() {
    com.google.ortools.sat.SatParameters.ClauseProtection result = com.google.ortools.sat.SatParameters.ClauseProtection.forNumber(clauseCleanupProtection_);
    return result == null ? com.google.ortools.sat.SatParameters.ClauseProtection.PROTECTION_NONE : result;
  }

  public static final int CLAUSE_CLEANUP_LBD_BOUND_FIELD_NUMBER = 59;
  private int clauseCleanupLbdBound_ = 5;
  /**
   * <pre>
   * All the clauses with a LBD (literal blocks distance) lower or equal to this
   * parameters will always be kept.
   * </pre>
   *
   * <code>optional int32 clause_cleanup_lbd_bound = 59 [default = 5];</code>
   * @return Whether the clauseCleanupLbdBound field is set.
   */
  @java.lang.Override
  public boolean hasClauseCleanupLbdBound() {
    return ((bitField0_ & 0x00020000) != 0);
  }
  /**
   * <pre>
   * All the clauses with a LBD (literal blocks distance) lower or equal to this
   * parameters will always be kept.
   * </pre>
   *
   * <code>optional int32 clause_cleanup_lbd_bound = 59 [default = 5];</code>
   * @return The clauseCleanupLbdBound.
   */
  @java.lang.Override
  public int getClauseCleanupLbdBound() {
    return clauseCleanupLbdBound_;
  }

  public static final int CLAUSE_CLEANUP_ORDERING_FIELD_NUMBER = 60;
  private int clauseCleanupOrdering_ = 0;
  /**
   * <code>optional .operations_research.sat.SatParameters.ClauseOrdering clause_cleanup_ordering = 60 [default = CLAUSE_ACTIVITY];</code>
   * @return Whether the clauseCleanupOrdering field is set.
   */
  @java.lang.Override public boolean hasClauseCleanupOrdering() {
    return ((bitField0_ & 0x00040000) != 0);
  }
  /**
   * <code>optional .operations_research.sat.SatParameters.ClauseOrdering clause_cleanup_ordering = 60 [default = CLAUSE_ACTIVITY];</code>
   * @return The clauseCleanupOrdering.
   */
  @java.lang.Override public com.google.ortools.sat.SatParameters.ClauseOrdering getClauseCleanupOrdering() {
    com.google.ortools.sat.SatParameters.ClauseOrdering result = com.google.ortools.sat.SatParameters.ClauseOrdering.forNumber(clauseCleanupOrdering_);
    return result == null ? com.google.ortools.sat.SatParameters.ClauseOrdering.CLAUSE_ACTIVITY : result;
  }

  public static final int PB_CLEANUP_INCREMENT_FIELD_NUMBER = 46;
  private int pbCleanupIncrement_ = 200;
  /**
   * <pre>
   * Same as for the clauses, but for the learned pseudo-Boolean constraints.
   * </pre>
   *
   * <code>optional int32 pb_cleanup_increment = 46 [default = 200];</code>
   * @return Whether the pbCleanupIncrement field is set.
   */
  @java.lang.Override
  public boolean hasPbCleanupIncrement() {
    return ((bitField0_ & 0x00080000) != 0);
  }
  /**
   * <pre>
   * Same as for the clauses, but for the learned pseudo-Boolean constraints.
   * </pre>
   *
   * <code>optional int32 pb_cleanup_increment = 46 [default = 200];</code>
   * @return The pbCleanupIncrement.
   */
  @java.lang.Override
  public int getPbCleanupIncrement() {
    return pbCleanupIncrement_;
  }

  public static final int PB_CLEANUP_RATIO_FIELD_NUMBER = 47;
  private double pbCleanupRatio_ = 0.5D;
  /**
   * <code>optional double pb_cleanup_ratio = 47 [default = 0.5];</code>
   * @return Whether the pbCleanupRatio field is set.
   */
  @java.lang.Override
  public boolean hasPbCleanupRatio() {
    return ((bitField0_ & 0x00100000) != 0);
  }
  /**
   * <code>optional double pb_cleanup_ratio = 47 [default = 0.5];</code>
   * @return The pbCleanupRatio.
   */
  @java.lang.Override
  public double getPbCleanupRatio() {
    return pbCleanupRatio_;
  }

  public static final int VARIABLE_ACTIVITY_DECAY_FIELD_NUMBER = 15;
  private double variableActivityDecay_ = 0.8D;
  /**
   * <pre>
   * Each time a conflict is found, the activities of some variables are
   * increased by one. Then, the activity of all variables are multiplied by
   * variable_activity_decay.
   *
   * To implement this efficiently, the activity of all the variables is not
   * decayed at each conflict. Instead, the activity increment is multiplied by
   * 1 / decay. When an activity reach max_variable_activity_value, all the
   * activity are multiplied by 1 / max_variable_activity_value.
   * </pre>
   *
   * <code>optional double variable_activity_decay = 15 [default = 0.8];</code>
   * @return Whether the variableActivityDecay field is set.
   */
  @java.lang.Override
  public boolean hasVariableActivityDecay() {
    return ((bitField0_ & 0x00200000) != 0);
  }
  /**
   * <pre>
   * Each time a conflict is found, the activities of some variables are
   * increased by one. Then, the activity of all variables are multiplied by
   * variable_activity_decay.
   *
   * To implement this efficiently, the activity of all the variables is not
   * decayed at each conflict. Instead, the activity increment is multiplied by
   * 1 / decay. When an activity reach max_variable_activity_value, all the
   * activity are multiplied by 1 / max_variable_activity_value.
   * </pre>
   *
   * <code>optional double variable_activity_decay = 15 [default = 0.8];</code>
   * @return The variableActivityDecay.
   */
  @java.lang.Override
  public double getVariableActivityDecay() {
    return variableActivityDecay_;
  }

  public static final int MAX_VARIABLE_ACTIVITY_VALUE_FIELD_NUMBER = 16;
  private double maxVariableActivityValue_ = 1e+100D;
  /**
   * <code>optional double max_variable_activity_value = 16 [default = 1e+100];</code>
   * @return Whether the maxVariableActivityValue field is set.
   */
  @java.lang.Override
  public boolean hasMaxVariableActivityValue() {
    return ((bitField0_ & 0x00400000) != 0);
  }
  /**
   * <code>optional double max_variable_activity_value = 16 [default = 1e+100];</code>
   * @return The maxVariableActivityValue.
   */
  @java.lang.Override
  public double getMaxVariableActivityValue() {
    return maxVariableActivityValue_;
  }

  public static final int GLUCOSE_MAX_DECAY_FIELD_NUMBER = 22;
  private double glucoseMaxDecay_ = 0.95D;
  /**
   * <pre>
   * The activity starts at 0.8 and increment by 0.01 every 5000 conflicts until
   * 0.95. This "hack" seems to work well and comes from:
   *
   * Glucose 2.3 in the SAT 2013 Competition - SAT Competition 2013
   * http://edacc4.informatik.uni-ulm.de/SC13/solver-description-download/136
   * </pre>
   *
   * <code>optional double glucose_max_decay = 22 [default = 0.95];</code>
   * @return Whether the glucoseMaxDecay field is set.
   */
  @java.lang.Override
  public boolean hasGlucoseMaxDecay() {
    return ((bitField0_ & 0x00800000) != 0);
  }
  /**
   * <pre>
   * The activity starts at 0.8 and increment by 0.01 every 5000 conflicts until
   * 0.95. This "hack" seems to work well and comes from:
   *
   * Glucose 2.3 in the SAT 2013 Competition - SAT Competition 2013
   * http://edacc4.informatik.uni-ulm.de/SC13/solver-description-download/136
   * </pre>
   *
   * <code>optional double glucose_max_decay = 22 [default = 0.95];</code>
   * @return The glucoseMaxDecay.
   */
  @java.lang.Override
  public double getGlucoseMaxDecay() {
    return glucoseMaxDecay_;
  }

  public static final int GLUCOSE_DECAY_INCREMENT_FIELD_NUMBER = 23;
  private double glucoseDecayIncrement_ = 0.01D;
  /**
   * <code>optional double glucose_decay_increment = 23 [default = 0.01];</code>
   * @return Whether the glucoseDecayIncrement field is set.
   */
  @java.lang.Override
  public boolean hasGlucoseDecayIncrement() {
    return ((bitField0_ & 0x01000000) != 0);
  }
  /**
   * <code>optional double glucose_decay_increment = 23 [default = 0.01];</code>
   * @return The glucoseDecayIncrement.
   */
  @java.lang.Override
  public double getGlucoseDecayIncrement() {
    return glucoseDecayIncrement_;
  }

  public static final int GLUCOSE_DECAY_INCREMENT_PERIOD_FIELD_NUMBER = 24;
  private int glucoseDecayIncrementPeriod_ = 5000;
  /**
   * <code>optional int32 glucose_decay_increment_period = 24 [default = 5000];</code>
   * @return Whether the glucoseDecayIncrementPeriod field is set.
   */
  @java.lang.Override
  public boolean hasGlucoseDecayIncrementPeriod() {
    return ((bitField0_ & 0x02000000) != 0);
  }
  /**
   * <code>optional int32 glucose_decay_increment_period = 24 [default = 5000];</code>
   * @return The glucoseDecayIncrementPeriod.
   */
  @java.lang.Override
  public int getGlucoseDecayIncrementPeriod() {
    return glucoseDecayIncrementPeriod_;
  }

  public static final int CLAUSE_ACTIVITY_DECAY_FIELD_NUMBER = 17;
  private double clauseActivityDecay_ = 0.999D;
  /**
   * <pre>
   * Clause activity parameters (same effect as the one on the variables).
   * </pre>
   *
   * <code>optional double clause_activity_decay = 17 [default = 0.999];</code>
   * @return Whether the clauseActivityDecay field is set.
   */
  @java.lang.Override
  public boolean hasClauseActivityDecay() {
    return ((bitField0_ & 0x04000000) != 0);
  }
  /**
   * <pre>
   * Clause activity parameters (same effect as the one on the variables).
   * </pre>
   *
   * <code>optional double clause_activity_decay = 17 [default = 0.999];</code>
   * @return The clauseActivityDecay.
   */
  @java.lang.Override
  public double getClauseActivityDecay() {
    return clauseActivityDecay_;
  }

  public static final int MAX_CLAUSE_ACTIVITY_VALUE_FIELD_NUMBER = 18;
  private double maxClauseActivityValue_ = 1e+20D;
  /**
   * <code>optional double max_clause_activity_value = 18 [default = 1e+20];</code>
   * @return Whether the maxClauseActivityValue field is set.
   */
  @java.lang.Override
  public boolean hasMaxClauseActivityValue() {
    return ((bitField0_ & 0x08000000) != 0);
  }
  /**
   * <code>optional double max_clause_activity_value = 18 [default = 1e+20];</code>
   * @return The maxClauseActivityValue.
   */
  @java.lang.Override
  public double getMaxClauseActivityValue() {
    return maxClauseActivityValue_;
  }

  public static final int RESTART_ALGORITHMS_FIELD_NUMBER = 61;
  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> restartAlgorithms_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
      java.lang.Integer, com.google.ortools.sat.SatParameters.RestartAlgorithm> restartAlgorithms_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.ortools.sat.SatParameters.RestartAlgorithm>() {
            public com.google.ortools.sat.SatParameters.RestartAlgorithm convert(java.lang.Integer from) {
              com.google.ortools.sat.SatParameters.RestartAlgorithm result = com.google.ortools.sat.SatParameters.RestartAlgorithm.forNumber(from);
              return result == null ? com.google.ortools.sat.SatParameters.RestartAlgorithm.NO_RESTART : result;
            }
          };
  /**
   * <pre>
   * The restart strategies will change each time the strategy_counter is
   * increased. The current strategy will simply be the one at index
   * strategy_counter modulo the number of strategy. Note that if this list
   * includes a NO_RESTART, nothing will change when it is reached because the
   * strategy_counter will only increment after a restart.
   *
   * The idea of switching of search strategy tailored for SAT/UNSAT comes from
   * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
   * But more generally, it seems REALLY beneficial to try different strategy.
   * </pre>
   *
   * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
   * @return A list containing the restartAlgorithms.
   */
  @java.lang.Override
  public java.util.List<com.google.ortools.sat.SatParameters.RestartAlgorithm> getRestartAlgorithmsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.ortools.sat.SatParameters.RestartAlgorithm>(restartAlgorithms_, restartAlgorithms_converter_);
  }
  /**
   * <pre>
   * The restart strategies will change each time the strategy_counter is
   * increased. The current strategy will simply be the one at index
   * strategy_counter modulo the number of strategy. Note that if this list
   * includes a NO_RESTART, nothing will change when it is reached because the
   * strategy_counter will only increment after a restart.
   *
   * The idea of switching of search strategy tailored for SAT/UNSAT comes from
   * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
   * But more generally, it seems REALLY beneficial to try different strategy.
   * </pre>
   *
   * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
   * @return The count of restartAlgorithms.
   */
  @java.lang.Override
  public int getRestartAlgorithmsCount() {
    return restartAlgorithms_.size();
  }
  /**
   * <pre>
   * The restart strategies will change each time the strategy_counter is
   * increased. The current strategy will simply be the one at index
   * strategy_counter modulo the number of strategy. Note that if this list
   * includes a NO_RESTART, nothing will change when it is reached because the
   * strategy_counter will only increment after a restart.
   *
   * The idea of switching of search strategy tailored for SAT/UNSAT comes from
   * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
   * But more generally, it seems REALLY beneficial to try different strategy.
   * </pre>
   *
   * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
   * @param index The index of the element to return.
   * @return The restartAlgorithms at the given index.
   */
  @java.lang.Override
  public com.google.ortools.sat.SatParameters.RestartAlgorithm getRestartAlgorithms(int index) {
    return restartAlgorithms_converter_.convert(restartAlgorithms_.get(index));
  }

  public static final int DEFAULT_RESTART_ALGORITHMS_FIELD_NUMBER = 70;
  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultRestartAlgorithms_ = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART";
  /**
   * <code>optional string default_restart_algorithms = 70 [default = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART"];</code>
   * @return Whether the defaultRestartAlgorithms field is set.
   */
  @java.lang.Override
  public boolean hasDefaultRestartAlgorithms() {
    return ((bitField0_ & 0x10000000) != 0);
  }
  /**
   * <code>optional string default_restart_algorithms = 70 [default = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART"];</code>
   * @return The defaultRestartAlgorithms.
   */
  @java.lang.Override
  public java.lang.String getDefaultRestartAlgorithms() {
    java.lang.Object ref = defaultRestartAlgorithms_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (bs.isValidUtf8()) {
        defaultRestartAlgorithms_ = s;
      }
      return s;
    }
  }
  /**
   * <code>optional string default_restart_algorithms = 70 [default = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART"];</code>
   * @return The bytes for defaultRestartAlgorithms.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getDefaultRestartAlgorithmsBytes() {
    java.lang.Object ref = defaultRestartAlgorithms_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      defaultRestartAlgorithms_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESTART_PERIOD_FIELD_NUMBER = 30;
  private int restartPeriod_ = 50;
  /**
   * <pre>
   * Restart period for the FIXED_RESTART strategy. This is also the multiplier
   * used by the LUBY_RESTART strategy.
   * </pre>
   *
   * <code>optional int32 restart_period = 30 [default = 50];</code>
   * @return Whether the restartPeriod field is set.
   */
  @java.lang.Override
  public boolean hasRestartPeriod() {
    return ((bitField0_ & 0x20000000) != 0);
  }
  /**
   * <pre>
   * Restart period for the FIXED_RESTART strategy. This is also the multiplier
   * used by the LUBY_RESTART strategy.
   * </pre>
   *
   * <code>optional int32 restart_period = 30 [default = 50];</code>
   * @return The restartPeriod.
   */
  @java.lang.Override
  public int getRestartPeriod() {
    return restartPeriod_;
  }

  public static final int RESTART_RUNNING_WINDOW_SIZE_FIELD_NUMBER = 62;
  private int restartRunningWindowSize_ = 50;
  /**
   * <pre>
   * Size of the window for the moving average restarts.
   * </pre>
   *
   * <code>optional int32 restart_running_window_size = 62 [default = 50];</code>
   * @return Whether the restartRunningWindowSize field is set.
   */
  @java.lang.Override
  public boolean hasRestartRunningWindowSize() {
    return ((bitField0_ & 0x40000000) != 0);
  }
  /**
   * <pre>
   * Size of the window for the moving average restarts.
   * </pre>
   *
   * <code>optional int32 restart_running_window_size = 62 [default = 50];</code>
   * @return The restartRunningWindowSize.
   */
  @java.lang.Override
  public int getRestartRunningWindowSize() {
    return restartRunningWindowSize_;
  }

  public static final int RESTART_DL_AVERAGE_RATIO_FIELD_NUMBER = 63;
  private double restartDlAverageRatio_ = 1D;
  /**
   * <pre>
   * In the moving average restart algorithms, a restart is triggered if the
   * window average times this ratio is greater that the global average.
   * </pre>
   *
   * <code>optional double restart_dl_average_ratio = 63 [default = 1];</code>
   * @return Whether the restartDlAverageRatio field is set.
   */
  @java.lang.Override
  public boolean hasRestartDlAverageRatio() {
    return ((bitField0_ & 0x80000000) != 0);
  }
  /**
   * <pre>
   * In the moving average restart algorithms, a restart is triggered if the
   * window average times this ratio is greater that the global average.
   * </pre>
   *
   * <code>optional double restart_dl_average_ratio = 63 [default = 1];</code>
   * @return The restartDlAverageRatio.
   */
  @java.lang.Override
  public double getRestartDlAverageRatio() {
    return restartDlAverageRatio_;
  }

  public static final int RESTART_LBD_AVERAGE_RATIO_FIELD_NUMBER = 71;
  private double restartLbdAverageRatio_ = 1D;
  /**
   * <code>optional double restart_lbd_average_ratio = 71 [default = 1];</code>
   * @return Whether the restartLbdAverageRatio field is set.
   */
  @java.lang.Override
  public boolean hasRestartLbdAverageRatio() {
    return ((bitField1_ & 0x00000001) != 0);
  }
  /**
   * <code>optional double restart_lbd_average_ratio = 71 [default = 1];</code>
   * @return The restartLbdAverageRatio.
   */
  @java.lang.Override
  public double getRestartLbdAverageRatio() {
    return restartLbdAverageRatio_;
  }

  public static final int USE_BLOCKING_RESTART_FIELD_NUMBER = 64;
  private boolean useBlockingRestart_ = false;
  /**
   * <pre>
   * Block a moving restart algorithm if the trail size of the current conflict
   * is greater than the multiplier times the moving average of the trail size
   * at the previous conflicts.
   * </pre>
   *
   * <code>optional bool use_blocking_restart = 64 [default = false];</code>
   * @return Whether the useBlockingRestart field is set.
   */
  @java.lang.Override
  public boolean hasUseBlockingRestart() {
    return ((bitField1_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * Block a moving restart algorithm if the trail size of the current conflict
   * is greater than the multiplier times the moving average of the trail size
   * at the previous conflicts.
   * </pre>
   *
   * <code>optional bool use_blocking_restart = 64 [default = false];</code>
   * @return The useBlockingRestart.
   */
  @java.lang.Override
  public boolean getUseBlockingRestart() {
    return useBlockingRestart_;
  }

  public static final int BLOCKING_RESTART_WINDOW_SIZE_FIELD_NUMBER = 65;
  private int blockingRestartWindowSize_ = 5000;
  /**
   * <code>optional int32 blocking_restart_window_size = 65 [default = 5000];</code>
   * @return Whether the blockingRestartWindowSize field is set.
   */
  @java.lang.Override
  public boolean hasBlockingRestartWindowSize() {
    return ((bitField1_ & 0x00000004) != 0);
  }
  /**
   * <code>optional int32 blocking_restart_window_size = 65 [default = 5000];</code>
   * @return The blockingRestartWindowSize.
   */
  @java.lang.Override
  public int getBlockingRestartWindowSize() {
    return blockingRestartWindowSize_;
  }

  public static final int BLOCKING_RESTART_MULTIPLIER_FIELD_NUMBER = 66;
  private double blockingRestartMultiplier_ = 1.4D;
  /**
   * <code>optional double blocking_restart_multiplier = 66 [default = 1.4];</code>
   * @return Whether the blockingRestartMultiplier field is set.
   */
  @java.lang.Override
  public boolean hasBlockingRestartMultiplier() {
    return ((bitField1_ & 0x00000008) != 0);
  }
  /**
   * <code>optional double blocking_restart_multiplier = 66 [default = 1.4];</code>
   * @return The blockingRestartMultiplier.
   */
  @java.lang.Override
  public double getBlockingRestartMultiplier() {
    return blockingRestartMultiplier_;
  }

  public static final int NUM_CONFLICTS_BEFORE_STRATEGY_CHANGES_FIELD_NUMBER = 68;
  private int numConflictsBeforeStrategyChanges_ = 0;
  /**
   * <pre>
   * After each restart, if the number of conflict since the last strategy
   * change is greater that this, then we increment a "strategy_counter" that
   * can be use to change the search strategy used by the following restarts.
   * </pre>
   *
   * <code>optional int32 num_conflicts_before_strategy_changes = 68 [default = 0];</code>
   * @return Whether the numConflictsBeforeStrategyChanges field is set.
   */
  @java.lang.Override
  public boolean hasNumConflictsBeforeStrategyChanges() {
    return ((bitField1_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * After each restart, if the number of conflict since the last strategy
   * change is greater that this, then we increment a "strategy_counter" that
   * can be use to change the search strategy used by the following restarts.
   * </pre>
   *
   * <code>optional int32 num_conflicts_before_strategy_changes = 68 [default = 0];</code>
   * @return The numConflictsBeforeStrategyChanges.
   */
  @java.lang.Override
  public int getNumConflictsBeforeStrategyChanges() {
    return numConflictsBeforeStrategyChanges_;
  }

  public static final int STRATEGY_CHANGE_INCREASE_RATIO_FIELD_NUMBER = 69;
  private double strategyChangeIncreaseRatio_ = 0D;
  /**
   * <pre>
   * The parameter num_conflicts_before_strategy_changes is increased by that
   * much after each strategy change.
   * </pre>
   *
   * <code>optional double strategy_change_increase_ratio = 69 [default = 0];</code>
   * @return Whether the strategyChangeIncreaseRatio field is set.
   */
  @java.lang.Override
  public boolean hasStrategyChangeIncreaseRatio() {
    return ((bitField1_ & 0x00000020) != 0);
  }
  /**
   * <pre>
   * The parameter num_conflicts_before_strategy_changes is increased by that
   * much after each strategy change.
   * </pre>
   *
   * <code>optional double strategy_change_increase_ratio = 69 [default = 0];</code>
   * @return The strategyChangeIncreaseRatio.
   */
  @java.lang.Override
  public double getStrategyChangeIncreaseRatio() {
    return strategyChangeIncreaseRatio_;
  }

  public static final int MAX_TIME_IN_SECONDS_FIELD_NUMBER = 36;
  private double maxTimeInSeconds_ = Double.POSITIVE_INFINITY;
  /**
   * <pre>
   * Maximum time allowed in seconds to solve a problem.
   * The counter will starts at the beginning of the Solve() call.
   * </pre>
   *
   * <code>optional double max_time_in_seconds = 36 [default = inf];</code>
   * @return Whether the maxTimeInSeconds field is set.
   */
  @java.lang.Override
  public boolean hasMaxTimeInSeconds() {
    return ((bitField1_ & 0x00000040) != 0);
  }
  /**
   * <pre>
   * Maximum time allowed in seconds to solve a problem.
   * The counter will starts at the beginning of the Solve() call.
   * </pre>
   *
   * <code>optional double max_time_in_seconds = 36 [default = inf];</code>
   * @return The maxTimeInSeconds.
   */
  @java.lang.Override
  public double getMaxTimeInSeconds() {
    return maxTimeInSeconds_;
  }

  public static final int MAX_DETERMINISTIC_TIME_FIELD_NUMBER = 67;
  private double maxDeterministicTime_ = Double.POSITIVE_INFINITY;
  /**
   * <pre>
   * Maximum time allowed in deterministic time to solve a problem.
   * The deterministic time should be correlated with the real time used by the
   * solver, the time unit being as close as possible to a second.
   * </pre>
   *
   * <code>optional double max_deterministic_time = 67 [default = inf];</code>
   * @return Whether the maxDeterministicTime field is set.
   */
  @java.lang.Override
  public boolean hasMaxDeterministicTime() {
    return ((bitField1_ & 0x00000080) != 0);
  }
  /**
   * <pre>
   * Maximum time allowed in deterministic time to solve a problem.
   * The deterministic time should be correlated with the real time used by the
   * solver, the time unit being as close as possible to a second.
   * </pre>
   *
   * <code>optional double max_deterministic_time = 67 [default = inf];</code>
   * @return The maxDeterministicTime.
   */
  @java.lang.Override
  public double getMaxDeterministicTime() {
    return maxDeterministicTime_;
  }

  public static final int MAX_NUM_DETERMINISTIC_BATCHES_FIELD_NUMBER = 291;
  private int maxNumDeterministicBatches_ = 0;
  /**
   * <pre>
   * Stops after that number of batches has been scheduled. This only make sense
   * when interleave_search is true.
   * </pre>
   *
   * <code>optional int32 max_num_deterministic_batches = 291 [default = 0];</code>
   * @return Whether the maxNumDeterministicBatches field is set.
   */
  @java.lang.Override
  public boolean hasMaxNumDeterministicBatches() {
    return ((bitField1_ & 0x00000100) != 0);
  }
  /**
   * <pre>
   * Stops after that number of batches has been scheduled. This only make sense
   * when interleave_search is true.
   * </pre>
   *
   * <code>optional int32 max_num_deterministic_batches = 291 [default = 0];</code>
   * @return The maxNumDeterministicBatches.
   */
  @java.lang.Override
  public int getMaxNumDeterministicBatches() {
    return maxNumDeterministicBatches_;
  }

  public static final int MAX_NUMBER_OF_CONFLICTS_FIELD_NUMBER = 37;
  private long maxNumberOfConflicts_ = 9223372036854775807L;
  /**
   * <pre>
   * Maximum number of conflicts allowed to solve a problem.
   *
   * TODO(user): Maybe change the way the conflict limit is enforced?
   * currently it is enforced on each independent internal SAT solve, rather
   * than on the overall number of conflicts across all solves. So in the
   * context of an optimization problem, this is not really usable directly by a
   * client.
   * </pre>
   *
   * <code>optional int64 max_number_of_conflicts = 37 [default = 9223372036854775807];</code>
   * @return Whether the maxNumberOfConflicts field is set.
   */
  @java.lang.Override
  public boolean hasMaxNumberOfConflicts() {
    return ((bitField1_ & 0x00000200) != 0);
  }
  /**
   * <pre>
   * Maximum number of conflicts allowed to solve a problem.
   *
   * TODO(user): Maybe change the way the conflict limit is enforced?
   * currently it is enforced on each independent internal SAT solve, rather
   * than on the overall number of conflicts across all solves. So in the
   * context of an optimization problem, this is not really usable directly by a
   * client.
   * </pre>
   *
   * <code>optional int64 max_number_of_conflicts = 37 [default = 9223372036854775807];</code>
   * @return The maxNumberOfConflicts.
   */
  @java.lang.Override
  public long getMaxNumberOfConflicts() {
    return maxNumberOfConflicts_;
  }

  public static final int MAX_MEMORY_IN_MB_FIELD_NUMBER = 40;
  private long maxMemoryInMb_ = 10000L;
  /**
   * <pre>
   * Maximum memory allowed for the whole thread containing the solver. The
   * solver will abort as soon as it detects that this limit is crossed. As a
   * result, this limit is approximative, but usually the solver will not go too
   * much over.
   *
   * TODO(user): This is only used by the pure SAT solver, generalize to CP-SAT.
   * </pre>
   *
   * <code>optional int64 max_memory_in_mb = 40 [default = 10000];</code>
   * @return Whether the maxMemoryInMb field is set.
   */
  @java.lang.Override
  public boolean hasMaxMemoryInMb() {
    return ((bitField1_ & 0x00000400) != 0);
  }
  /**
   * <pre>
   * Maximum memory allowed for the whole thread containing the solver. The
   * solver will abort as soon as it detects that this limit is crossed. As a
   * result, this limit is approximative, but usually the solver will not go too
   * much over.
   *
   * TODO(user): This is only used by the pure SAT solver, generalize to CP-SAT.
   * </pre>
   *
   * <code>optional int64 max_memory_in_mb = 40 [default = 10000];</code>
   * @return The maxMemoryInMb.
   */
  @java.lang.Override
  public long getMaxMemoryInMb() {
    return maxMemoryInMb_;
  }

  public static final int ABSOLUTE_GAP_LIMIT_FIELD_NUMBER = 159;
  private double absoluteGapLimit_ = 0.0001D;
  /**
   * <pre>
   * Stop the search when the gap between the best feasible objective (O) and
   * our best objective bound (B) is smaller than a limit.
   * The exact definition is:
   * - Absolute: abs(O - B)
   * - Relative: abs(O - B) / max(1, abs(O)).
   *
   * Important: The relative gap depends on the objective offset! If you
   * artificially shift the objective, you will get widely different value of
   * the relative gap.
   *
   * Note that if the gap is reached, the search status will be OPTIMAL. But
   * one can check the best objective bound to see the actual gap.
   *
   * If the objective is integer, then any absolute gap &lt; 1 will lead to a true
   * optimal. If the objective is floating point, a gap of zero make little
   * sense so is is why we use a non-zero default value. At the end of the
   * search, we will display a warning if OPTIMAL is reported yet the gap is
   * greater than this absolute gap.
   * </pre>
   *
   * <code>optional double absolute_gap_limit = 159 [default = 0.0001];</code>
   * @return Whether the absoluteGapLimit field is set.
   */
  @java.lang.Override
  public boolean hasAbsoluteGapLimit() {
    return ((bitField1_ & 0x00000800) != 0);
  }
  /**
   * <pre>
   * Stop the search when the gap between the best feasible objective (O) and
   * our best objective bound (B) is smaller than a limit.
   * The exact definition is:
   * - Absolute: abs(O - B)
   * - Relative: abs(O - B) / max(1, abs(O)).
   *
   * Important: The relative gap depends on the objective offset! If you
   * artificially shift the objective, you will get widely different value of
   * the relative gap.
   *
   * Note that if the gap is reached, the search status will be OPTIMAL. But
   * one can check the best objective bound to see the actual gap.
   *
   * If the objective is integer, then any absolute gap &lt; 1 will lead to a true
   * optimal. If the objective is floating point, a gap of zero make little
   * sense so is is why we use a non-zero default value. At the end of the
   * search, we will display a warning if OPTIMAL is reported yet the gap is
   * greater than this absolute gap.
   * </pre>
   *
   * <code>optional double absolute_gap_limit = 159 [default = 0.0001];</code>
   * @return The absoluteGapLimit.
   */
  @java.lang.Override
  public double getAbsoluteGapLimit() {
    return absoluteGapLimit_;
  }

  public static final int RELATIVE_GAP_LIMIT_FIELD_NUMBER = 160;
  private double relativeGapLimit_ = 0D;
  /**
   * <code>optional double relative_gap_limit = 160 [default = 0];</code>
   * @return Whether the relativeGapLimit field is set.
   */
  @java.lang.Override
  public boolean hasRelativeGapLimit() {
    return ((bitField1_ & 0x00001000) != 0);
  }
  /**
   * <code>optional double relative_gap_limit = 160 [default = 0];</code>
   * @return The relativeGapLimit.
   */
  @java.lang.Override
  public double getRelativeGapLimit() {
    return relativeGapLimit_;
  }

  public static final int RANDOM_SEED_FIELD_NUMBER = 31;
  private int randomSeed_ = 1;
  /**
   * <pre>
   * At the beginning of each solve, the random number generator used in some
   * part of the solver is reinitialized to this seed. If you change the random
   * seed, the solver may make different choices during the solving process.
   *
   * For some problems, the running time may vary a lot depending on small
   * change in the solving algorithm. Running the solver with different seeds
   * enables to have more robust benchmarks when evaluating new features.
   * </pre>
   *
   * <code>optional int32 random_seed = 31 [default = 1];</code>
   * @return Whether the randomSeed field is set.
   */
  @java.lang.Override
  public boolean hasRandomSeed() {
    return ((bitField1_ & 0x00002000) != 0);
  }
  /**
   * <pre>
   * At the beginning of each solve, the random number generator used in some
   * part of the solver is reinitialized to this seed. If you change the random
   * seed, the solver may make different choices during the solving process.
   *
   * For some problems, the running time may vary a lot depending on small
   * change in the solving algorithm. Running the solver with different seeds
   * enables to have more robust benchmarks when evaluating new features.
   * </pre>
   *
   * <code>optional int32 random_seed = 31 [default = 1];</code>
   * @return The randomSeed.
   */
  @java.lang.Override
  public int getRandomSeed() {
    return randomSeed_;
  }

  public static final int PERMUTE_VARIABLE_RANDOMLY_FIELD_NUMBER = 178;
  private boolean permuteVariableRandomly_ = false;
  /**
   * <pre>
   * This is mainly here to test the solver variability. Note that in tests, if
   * not explicitly set to false, all 3 options will be set to true so that
   * clients do not rely on the solver returning a specific solution if they are
   * many equivalent optimal solutions.
   * </pre>
   *
   * <code>optional bool permute_variable_randomly = 178 [default = false];</code>
   * @return Whether the permuteVariableRandomly field is set.
   */
  @java.lang.Override
  public boolean hasPermuteVariableRandomly() {
    return ((bitField1_ & 0x00004000) != 0);
  }
  /**
   * <pre>
   * This is mainly here to test the solver variability. Note that in tests, if
   * not explicitly set to false, all 3 options will be set to true so that
   * clients do not rely on the solver returning a specific solution if they are
   * many equivalent optimal solutions.
   * </pre>
   *
   * <code>optional bool permute_variable_randomly = 178 [default = false];</code>
   * @return The permuteVariableRandomly.
   */
  @java.lang.Override
  public boolean getPermuteVariableRandomly() {
    return permuteVariableRandomly_;
  }

  public static final int PERMUTE_PRESOLVE_CONSTRAINT_ORDER_FIELD_NUMBER = 179;
  private boolean permutePresolveConstraintOrder_ = false;
  /**
   * <code>optional bool permute_presolve_constraint_order = 179 [default = false];</code>
   * @return Whether the permutePresolveConstraintOrder field is set.
   */
  @java.lang.Override
  public boolean hasPermutePresolveConstraintOrder() {
    return ((bitField1_ & 0x00008000) != 0);
  }
  /**
   * <code>optional bool permute_presolve_constraint_order = 179 [default = false];</code>
   * @return The permutePresolveConstraintOrder.
   */
  @java.lang.Override
  public boolean getPermutePresolveConstraintOrder() {
    return permutePresolveConstraintOrder_;
  }

  public static final int USE_ABSL_RANDOM_FIELD_NUMBER = 180;
  private boolean useAbslRandom_ = false;
  /**
   * <code>optional bool use_absl_random = 180 [default = false];</code>
   * @return Whether the useAbslRandom field is set.
   */
  @java.lang.Override
  public boolean hasUseAbslRandom() {
    return ((bitField1_ & 0x00010000) != 0);
  }
  /**
   * <code>optional bool use_absl_random = 180 [default = false];</code>
   * @return The useAbslRandom.
   */
  @java.lang.Override
  public boolean getUseAbslRandom() {
    return useAbslRandom_;
  }

  public static final int LOG_SEARCH_PROGRESS_FIELD_NUMBER = 41;
  private boolean logSearchProgress_ = false;
  /**
   * <pre>
   * Whether the solver should log the search progress. This is the maing
   * logging parameter and if this is false, none of the logging (callbacks,
   * log_to_stdout, log_to_response, ...) will do anything.
   * </pre>
   *
   * <code>optional bool log_search_progress = 41 [default = false];</code>
   * @return Whether the logSearchProgress field is set.
   */
  @java.lang.Override
  public boolean hasLogSearchProgress() {
    return ((bitField1_ & 0x00020000) != 0);
  }
  /**
   * <pre>
   * Whether the solver should log the search progress. This is the maing
   * logging parameter and if this is false, none of the logging (callbacks,
   * log_to_stdout, log_to_response, ...) will do anything.
   * </pre>
   *
   * <code>optional bool log_search_progress = 41 [default = false];</code>
   * @return The logSearchProgress.
   */
  @java.lang.Override
  public boolean getLogSearchProgress() {
    return logSearchProgress_;
  }

  public static final int LOG_SUBSOLVER_STATISTICS_FIELD_NUMBER = 189;
  private boolean logSubsolverStatistics_ = false;
  /**
   * <pre>
   * Whether the solver should display per sub-solver search statistics.
   * This is only useful is log_search_progress is set to true, and if the
   * number of search workers is &gt; 1. Note that in all case we display a bit
   * of stats with one line per subsolver.
   * </pre>
   *
   * <code>optional bool log_subsolver_statistics = 189 [default = false];</code>
   * @return Whether the logSubsolverStatistics field is set.
   */
  @java.lang.Override
  public boolean hasLogSubsolverStatistics() {
    return ((bitField1_ & 0x00040000) != 0);
  }
  /**
   * <pre>
   * Whether the solver should display per sub-solver search statistics.
   * This is only useful is log_search_progress is set to true, and if the
   * number of search workers is &gt; 1. Note that in all case we display a bit
   * of stats with one line per subsolver.
   * </pre>
   *
   * <code>optional bool log_subsolver_statistics = 189 [default = false];</code>
   * @return The logSubsolverStatistics.
   */
  @java.lang.Override
  public boolean getLogSubsolverStatistics() {
    return logSubsolverStatistics_;
  }

  public static final int LOG_PREFIX_FIELD_NUMBER = 185;
  @SuppressWarnings("serial")
  private volatile java.lang.Object logPrefix_ = "";
  /**
   * <pre>
   * Add a prefix to all logs.
   * </pre>
   *
   * <code>optional string log_prefix = 185 [default = ""];</code>
   * @return Whether the logPrefix field is set.
   */
  @java.lang.Override
  public boolean hasLogPrefix() {
    return ((bitField1_ & 0x00080000) != 0);
  }
  /**
   * <pre>
   * Add a prefix to all logs.
   * </pre>
   *
   * <code>optional string log_prefix = 185 [default = ""];</code>
   * @return The logPrefix.
   */
  @java.lang.Override
  public java.lang.String getLogPrefix() {
    java.lang.Object ref = logPrefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (bs.isValidUtf8()) {
        logPrefix_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * Add a prefix to all logs.
   * </pre>
   *
   * <code>optional string log_prefix = 185 [default = ""];</code>
   * @return The bytes for logPrefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getLogPrefixBytes() {
    java.lang.Object ref = logPrefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      logPrefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOG_TO_STDOUT_FIELD_NUMBER = 186;
  private boolean logToStdout_ = true;
  /**
   * <pre>
   * Log to stdout.
   * </pre>
   *
   * <code>optional bool log_to_stdout = 186 [default = true];</code>
   * @return Whether the logToStdout field is set.
   */
  @java.lang.Override
  public boolean hasLogToStdout() {
    return ((bitField1_ & 0x00100000) != 0);
  }
  /**
   * <pre>
   * Log to stdout.
   * </pre>
   *
   * <code>optional bool log_to_stdout = 186 [default = true];</code>
   * @return The logToStdout.
   */
  @java.lang.Override
  public boolean getLogToStdout() {
    return logToStdout_;
  }

  public static final int LOG_TO_RESPONSE_FIELD_NUMBER = 187;
  private boolean logToResponse_ = false;
  /**
   * <pre>
   * Log to response proto.
   * </pre>
   *
   * <code>optional bool log_to_response = 187 [default = false];</code>
   * @return Whether the logToResponse field is set.
   */
  @java.lang.Override
  public boolean hasLogToResponse() {
    return ((bitField1_ & 0x00200000) != 0);
  }
  /**
   * <pre>
   * Log to response proto.
   * </pre>
   *
   * <code>optional bool log_to_response = 187 [default = false];</code>
   * @return The logToResponse.
   */
  @java.lang.Override
  public boolean getLogToResponse() {
    return logToResponse_;
  }

  public static final int USE_PB_RESOLUTION_FIELD_NUMBER = 43;
  private boolean usePbResolution_ = false;
  /**
   * <pre>
   * Whether to use pseudo-Boolean resolution to analyze a conflict. Note that
   * this option only make sense if your problem is modelized using
   * pseudo-Boolean constraints. If you only have clauses, this shouldn't change
   * anything (except slow the solver down).
   * </pre>
   *
   * <code>optional bool use_pb_resolution = 43 [default = false];</code>
   * @return Whether the usePbResolution field is set.
   */
  @java.lang.Override
  public boolean hasUsePbResolution() {
    return ((bitField1_ & 0x00400000) != 0);
  }
  /**
   * <pre>
   * Whether to use pseudo-Boolean resolution to analyze a conflict. Note that
   * this option only make sense if your problem is modelized using
   * pseudo-Boolean constraints. If you only have clauses, this shouldn't change
   * anything (except slow the solver down).
   * </pre>
   *
   * <code>optional bool use_pb_resolution = 43 [default = false];</code>
   * @return The usePbResolution.
   */
  @java.lang.Override
  public boolean getUsePbResolution() {
    return usePbResolution_;
  }

  public static final int MINIMIZE_REDUCTION_DURING_PB_RESOLUTION_FIELD_NUMBER = 48;
  private boolean minimizeReductionDuringPbResolution_ = false;
  /**
   * <pre>
   * A different algorithm during PB resolution. It minimizes the number of
   * calls to ReduceCoefficients() which can be time consuming. However, the
   * search space will be different and if the coefficients are large, this may
   * lead to integer overflows that could otherwise be prevented.
   * </pre>
   *
   * <code>optional bool minimize_reduction_during_pb_resolution = 48 [default = false];</code>
   * @return Whether the minimizeReductionDuringPbResolution field is set.
   */
  @java.lang.Override
  public boolean hasMinimizeReductionDuringPbResolution() {
    return ((bitField1_ & 0x00800000) != 0);
  }
  /**
   * <pre>
   * A different algorithm during PB resolution. It minimizes the number of
   * calls to ReduceCoefficients() which can be time consuming. However, the
   * search space will be different and if the coefficients are large, this may
   * lead to integer overflows that could otherwise be prevented.
   * </pre>
   *
   * <code>optional bool minimize_reduction_during_pb_resolution = 48 [default = false];</code>
   * @return The minimizeReductionDuringPbResolution.
   */
  @java.lang.Override
  public boolean getMinimizeReductionDuringPbResolution() {
    return minimizeReductionDuringPbResolution_;
  }

  public static final int COUNT_ASSUMPTION_LEVELS_IN_LBD_FIELD_NUMBER = 49;
  private boolean countAssumptionLevelsInLbd_ = true;
  /**
   * <pre>
   * Whether or not the assumption levels are taken into account during the LBD
   * computation. According to the reference below, not counting them improves
   * the solver in some situation. Note that this only impact solves under
   * assumptions.
   *
   * Gilles Audemard, Jean-Marie Lagniez, Laurent Simon, "Improving Glucose for
   * Incremental SAT Solving with Assumptions: Application to MUS Extraction"
   * Theory and Applications of Satisfiability Testing - SAT 2013, Lecture Notes
   * in Computer Science Volume 7962, 2013, pp 309-317.
   * </pre>
   *
   * <code>optional bool count_assumption_levels_in_lbd = 49 [default = true];</code>
   * @return Whether the countAssumptionLevelsInLbd field is set.
   */
  @java.lang.Override
  public boolean hasCountAssumptionLevelsInLbd() {
    return ((bitField1_ & 0x01000000) != 0);
  }
  /**
   * <pre>
   * Whether or not the assumption levels are taken into account during the LBD
   * computation. According to the reference below, not counting them improves
   * the solver in some situation. Note that this only impact solves under
   * assumptions.
   *
   * Gilles Audemard, Jean-Marie Lagniez, Laurent Simon, "Improving Glucose for
   * Incremental SAT Solving with Assumptions: Application to MUS Extraction"
   * Theory and Applications of Satisfiability Testing - SAT 2013, Lecture Notes
   * in Computer Science Volume 7962, 2013, pp 309-317.
   * </pre>
   *
   * <code>optional bool count_assumption_levels_in_lbd = 49 [default = true];</code>
   * @return The countAssumptionLevelsInLbd.
   */
  @java.lang.Override
  public boolean getCountAssumptionLevelsInLbd() {
    return countAssumptionLevelsInLbd_;
  }

  public static final int PRESOLVE_BVE_THRESHOLD_FIELD_NUMBER = 54;
  private int presolveBveThreshold_ = 500;
  /**
   * <pre>
   * During presolve, only try to perform the bounded variable elimination (BVE)
   * of a variable x if the number of occurrences of x times the number of
   * occurrences of not(x) is not greater than this parameter.
   * </pre>
   *
   * <code>optional int32 presolve_bve_threshold = 54 [default = 500];</code>
   * @return Whether the presolveBveThreshold field is set.
   */
  @java.lang.Override
  public boolean hasPresolveBveThreshold() {
    return ((bitField1_ & 0x02000000) != 0);
  }
  /**
   * <pre>
   * During presolve, only try to perform the bounded variable elimination (BVE)
   * of a variable x if the number of occurrences of x times the number of
   * occurrences of not(x) is not greater than this parameter.
   * </pre>
   *
   * <code>optional int32 presolve_bve_threshold = 54 [default = 500];</code>
   * @return The presolveBveThreshold.
   */
  @java.lang.Override
  public int getPresolveBveThreshold() {
    return presolveBveThreshold_;
  }

  public static final int PRESOLVE_BVE_CLAUSE_WEIGHT_FIELD_NUMBER = 55;
  private int presolveBveClauseWeight_ = 3;
  /**
   * <pre>
   * During presolve, we apply BVE only if this weight times the number of
   * clauses plus the number of clause literals is not increased.
   * </pre>
   *
   * <code>optional int32 presolve_bve_clause_weight = 55 [default = 3];</code>
   * @return Whether the presolveBveClauseWeight field is set.
   */
  @java.lang.Override
  public boolean hasPresolveBveClauseWeight() {
    return ((bitField1_ & 0x04000000) != 0);
  }
  /**
   * <pre>
   * During presolve, we apply BVE only if this weight times the number of
   * clauses plus the number of clause literals is not increased.
   * </pre>
   *
   * <code>optional int32 presolve_bve_clause_weight = 55 [default = 3];</code>
   * @return The presolveBveClauseWeight.
   */
  @java.lang.Override
  public int getPresolveBveClauseWeight() {
    return presolveBveClauseWeight_;
  }

  public static final int PROBING_DETERMINISTIC_TIME_LIMIT_FIELD_NUMBER = 226;
  private double probingDeterministicTimeLimit_ = 1D;
  /**
   * <pre>
   * The maximum "deterministic" time limit to spend in probing. A value of
   * zero will disable the probing.
   *
   * TODO(user): Clean up. The first one is used in CP-SAT, the other in pure
   * SAT presolve.
   * </pre>
   *
   * <code>optional double probing_deterministic_time_limit = 226 [default = 1];</code>
   * @return Whether the probingDeterministicTimeLimit field is set.
   */
  @java.lang.Override
  public boolean hasProbingDeterministicTimeLimit() {
    return ((bitField1_ & 0x08000000) != 0);
  }
  /**
   * <pre>
   * The maximum "deterministic" time limit to spend in probing. A value of
   * zero will disable the probing.
   *
   * TODO(user): Clean up. The first one is used in CP-SAT, the other in pure
   * SAT presolve.
   * </pre>
   *
   * <code>optional double probing_deterministic_time_limit = 226 [default = 1];</code>
   * @return The probingDeterministicTimeLimit.
   */
  @java.lang.Override
  public double getProbingDeterministicTimeLimit() {
    return probingDeterministicTimeLimit_;
  }

  public static final int PRESOLVE_PROBING_DETERMINISTIC_TIME_LIMIT_FIELD_NUMBER = 57;
  private double presolveProbingDeterministicTimeLimit_ = 30D;
  /**
   * <code>optional double presolve_probing_deterministic_time_limit = 57 [default = 30];</code>
   * @return Whether the presolveProbingDeterministicTimeLimit field is set.
   */
  @java.lang.Override
  public boolean hasPresolveProbingDeterministicTimeLimit() {
    return ((bitField1_ & 0x10000000) != 0);
  }
  /**
   * <code>optional double presolve_probing_deterministic_time_limit = 57 [default = 30];</code>
   * @return The presolveProbingDeterministicTimeLimit.
   */
  @java.lang.Override
  public double getPresolveProbingDeterministicTimeLimit() {
    return presolveProbingDeterministicTimeLimit_;
  }

  public static final int PRESOLVE_BLOCKED_CLAUSE_FIELD_NUMBER = 88;
  private boolean presolveBlockedClause_ = true;
  /**
   * <pre>
   * Whether we use an heuristic to detect some basic case of blocked clause
   * in the SAT presolve.
   * </pre>
   *
   * <code>optional bool presolve_blocked_clause = 88 [default = true];</code>
   * @return Whether the presolveBlockedClause field is set.
   */
  @java.lang.Override
  public boolean hasPresolveBlockedClause() {
    return ((bitField1_ & 0x20000000) != 0);
  }
  /**
   * <pre>
   * Whether we use an heuristic to detect some basic case of blocked clause
   * in the SAT presolve.
   * </pre>
   *
   * <code>optional bool presolve_blocked_clause = 88 [default = true];</code>
   * @return The presolveBlockedClause.
   */
  @java.lang.Override
  public boolean getPresolveBlockedClause() {
    return presolveBlockedClause_;
  }

  public static final int PRESOLVE_USE_BVA_FIELD_NUMBER = 72;
  private boolean presolveUseBva_ = true;
  /**
   * <pre>
   * Whether or not we use Bounded Variable Addition (BVA) in the presolve.
   * </pre>
   *
   * <code>optional bool presolve_use_bva = 72 [default = true];</code>
   * @return Whether the presolveUseBva field is set.
   */
  @java.lang.Override
  public boolean hasPresolveUseBva() {
    return ((bitField1_ & 0x40000000) != 0);
  }
  /**
   * <pre>
   * Whether or not we use Bounded Variable Addition (BVA) in the presolve.
   * </pre>
   *
   * <code>optional bool presolve_use_bva = 72 [default = true];</code>
   * @return The presolveUseBva.
   */
  @java.lang.Override
  public boolean getPresolveUseBva() {
    return presolveUseBva_;
  }

  public static final int PRESOLVE_BVA_THRESHOLD_FIELD_NUMBER = 73;
  private int presolveBvaThreshold_ = 1;
  /**
   * <pre>
   * Apply Bounded Variable Addition (BVA) if the number of clauses is reduced
   * by stricly more than this threshold. The algorithm described in the paper
   * uses 0, but quick experiments showed that 1 is a good value. It may not be
   * worth it to add a new variable just to remove one clause.
   * </pre>
   *
   * <code>optional int32 presolve_bva_threshold = 73 [default = 1];</code>
   * @return Whether the presolveBvaThreshold field is set.
   */
  @java.lang.Override
  public boolean hasPresolveBvaThreshold() {
    return ((bitField1_ & 0x80000000) != 0);
  }
  /**
   * <pre>
   * Apply Bounded Variable Addition (BVA) if the number of clauses is reduced
   * by stricly more than this threshold. The algorithm described in the paper
   * uses 0, but quick experiments showed that 1 is a good value. It may not be
   * worth it to add a new variable just to remove one clause.
   * </pre>
   *
   * <code>optional int32 presolve_bva_threshold = 73 [default = 1];</code>
   * @return The presolveBvaThreshold.
   */
  @java.lang.Override
  public int getPresolveBvaThreshold() {
    return presolveBvaThreshold_;
  }

  public static final int MAX_PRESOLVE_ITERATIONS_FIELD_NUMBER = 138;
  private int maxPresolveIterations_ = 3;
  /**
   * <pre>
   * In case of large reduction in a presolve iteration, we perform multiple
   * presolve iterations. This parameter controls the maximum number of such
   * presolve iterations.
   * </pre>
   *
   * <code>optional int32 max_presolve_iterations = 138 [default = 3];</code>
   * @return Whether the maxPresolveIterations field is set.
   */
  @java.lang.Override
  public boolean hasMaxPresolveIterations() {
    return ((bitField2_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * In case of large reduction in a presolve iteration, we perform multiple
   * presolve iterations. This parameter controls the maximum number of such
   * presolve iterations.
   * </pre>
   *
   * <code>optional int32 max_presolve_iterations = 138 [default = 3];</code>
   * @return The maxPresolveIterations.
   */
  @java.lang.Override
  public int getMaxPresolveIterations() {
    return maxPresolveIterations_;
  }

  public static final int CP_MODEL_PRESOLVE_FIELD_NUMBER = 86;
  private boolean cpModelPresolve_ = true;
  /**
   * <pre>
   * Whether we presolve the cp_model before solving it.
   * </pre>
   *
   * <code>optional bool cp_model_presolve = 86 [default = true];</code>
   * @return Whether the cpModelPresolve field is set.
   */
  @java.lang.Override
  public boolean hasCpModelPresolve() {
    return ((bitField2_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * Whether we presolve the cp_model before solving it.
   * </pre>
   *
   * <code>optional bool cp_model_presolve = 86 [default = true];</code>
   * @return The cpModelPresolve.
   */
  @java.lang.Override
  public boolean getCpModelPresolve() {
    return cpModelPresolve_;
  }

  public static final int CP_MODEL_PROBING_LEVEL_FIELD_NUMBER = 110;
  private int cpModelProbingLevel_ = 2;
  /**
   * <pre>
   * How much effort do we spend on probing. 0 disables it completely.
   * </pre>
   *
   * <code>optional int32 cp_model_probing_level = 110 [default = 2];</code>
   * @return Whether the cpModelProbingLevel field is set.
   */
  @java.lang.Override
  public boolean hasCpModelProbingLevel() {
    return ((bitField2_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * How much effort do we spend on probing. 0 disables it completely.
   * </pre>
   *
   * <code>optional int32 cp_model_probing_level = 110 [default = 2];</code>
   * @return The cpModelProbingLevel.
   */
  @java.lang.Override
  public int getCpModelProbingLevel() {
    return cpModelProbingLevel_;
  }

  public static final int CP_MODEL_USE_SAT_PRESOLVE_FIELD_NUMBER = 93;
  private boolean cpModelUseSatPresolve_ = true;
  /**
   * <pre>
   * Whether we also use the sat presolve when cp_model_presolve is true.
   * </pre>
   *
   * <code>optional bool cp_model_use_sat_presolve = 93 [default = true];</code>
   * @return Whether the cpModelUseSatPresolve field is set.
   */
  @java.lang.Override
  public boolean hasCpModelUseSatPresolve() {
    return ((bitField2_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * Whether we also use the sat presolve when cp_model_presolve is true.
   * </pre>
   *
   * <code>optional bool cp_model_use_sat_presolve = 93 [default = true];</code>
   * @return The cpModelUseSatPresolve.
   */
  @java.lang.Override
  public boolean getCpModelUseSatPresolve() {
    return cpModelUseSatPresolve_;
  }

  public static final int DETECT_TABLE_WITH_COST_FIELD_NUMBER = 216;
  private boolean detectTableWithCost_ = false;
  /**
   * <pre>
   * If true, we detect variable that are unique to a table constraint and only
   * there to encode a cost on each tuple. This is usually the case when a WCSP
   * (weighted constraint program) is encoded into CP-SAT format.
   *
   * This can lead to a dramatic speed-up for such problems but is still
   * experimental at this point.
   * </pre>
   *
   * <code>optional bool detect_table_with_cost = 216 [default = false];</code>
   * @return Whether the detectTableWithCost field is set.
   */
  @java.lang.Override
  public boolean hasDetectTableWithCost() {
    return ((bitField2_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * If true, we detect variable that are unique to a table constraint and only
   * there to encode a cost on each tuple. This is usually the case when a WCSP
   * (weighted constraint program) is encoded into CP-SAT format.
   *
   * This can lead to a dramatic speed-up for such problems but is still
   * experimental at this point.
   * </pre>
   *
   * <code>optional bool detect_table_with_cost = 216 [default = false];</code>
   * @return The detectTableWithCost.
   */
  @java.lang.Override
  public boolean getDetectTableWithCost() {
    return detectTableWithCost_;
  }

  public static final int TABLE_COMPRESSION_LEVEL_FIELD_NUMBER = 217;
  private int tableCompressionLevel_ = 2;
  /**
   * <pre>
   * How much we try to "compress" a table constraint. Compressing more leads to
   * less Booleans and faster propagation but can reduced the quality of the lp
   * relaxation. Values goes from 0 to 3 where we always try to fully compress a
   * table. At 2, we try to automatically decide if it is worth it.
   * </pre>
   *
   * <code>optional int32 table_compression_level = 217 [default = 2];</code>
   * @return Whether the tableCompressionLevel field is set.
   */
  @java.lang.Override
  public boolean hasTableCompressionLevel() {
    return ((bitField2_ & 0x00000020) != 0);
  }
  /**
   * <pre>
   * How much we try to "compress" a table constraint. Compressing more leads to
   * less Booleans and faster propagation but can reduced the quality of the lp
   * relaxation. Values goes from 0 to 3 where we always try to fully compress a
   * table. At 2, we try to automatically decide if it is worth it.
   * </pre>
   *
   * <code>optional int32 table_compression_level = 217 [default = 2];</code>
   * @return The tableCompressionLevel.
   */
  @java.lang.Override
  public int getTableCompressionLevel() {
    return tableCompressionLevel_;
  }

  public static final int EXPAND_ALLDIFF_CONSTRAINTS_FIELD_NUMBER = 170;
  private boolean expandAlldiffConstraints_ = false;
  /**
   * <pre>
   * If true, expand all_different constraints that are not permutations.
   * Permutations (#Variables = #Values) are always expanded.
   * </pre>
   *
   * <code>optional bool expand_alldiff_constraints = 170 [default = false];</code>
   * @return Whether the expandAlldiffConstraints field is set.
   */
  @java.lang.Override
  public boolean hasExpandAlldiffConstraints() {
    return ((bitField2_ & 0x00000040) != 0);
  }
  /**
   * <pre>
   * If true, expand all_different constraints that are not permutations.
   * Permutations (#Variables = #Values) are always expanded.
   * </pre>
   *
   * <code>optional bool expand_alldiff_constraints = 170 [default = false];</code>
   * @return The expandAlldiffConstraints.
   */
  @java.lang.Override
  public boolean getExpandAlldiffConstraints() {
    return expandAlldiffConstraints_;
  }

  public static final int EXPAND_RESERVOIR_CONSTRAINTS_FIELD_NUMBER = 182;
  private boolean expandReservoirConstraints_ = true;
  /**
   * <pre>
   * If true, expand the reservoir constraints by creating booleans for all
   * possible precedences between event and encoding the constraint.
   * </pre>
   *
   * <code>optional bool expand_reservoir_constraints = 182 [default = true];</code>
   * @return Whether the expandReservoirConstraints field is set.
   */
  @java.lang.Override
  public boolean hasExpandReservoirConstraints() {
    return ((bitField2_ & 0x00000080) != 0);
  }
  /**
   * <pre>
   * If true, expand the reservoir constraints by creating booleans for all
   * possible precedences between event and encoding the constraint.
   * </pre>
   *
   * <code>optional bool expand_reservoir_constraints = 182 [default = true];</code>
   * @return The expandReservoirConstraints.
   */
  @java.lang.Override
  public boolean getExpandReservoirConstraints() {
    return expandReservoirConstraints_;
  }

  public static final int EXPAND_RESERVOIR_USING_CIRCUIT_FIELD_NUMBER = 288;
  private boolean expandReservoirUsingCircuit_ = false;
  /**
   * <pre>
   * Mainly useful for testing.
   *
   * If this and expand_reservoir_constraints is true, we use a different
   * encoding of the reservoir constraint using circuit instead of precedences.
   * Note that this is usually slower, but can exercise different part of the
   * solver. Note that contrary to the precedence encoding, this easily support
   * variable demands.
   *
   * WARNING: with this encoding, the constraint take a slighlty different
   * meaning. The level must be within the reservoir for any permutation of the
   * events. So we cannot have +100 and -100 at the same time if the maximum
   * level is 10 (as autorized by the reservoir constraint).
   * </pre>
   *
   * <code>optional bool expand_reservoir_using_circuit = 288 [default = false];</code>
   * @return Whether the expandReservoirUsingCircuit field is set.
   */
  @java.lang.Override
  public boolean hasExpandReservoirUsingCircuit() {
    return ((bitField2_ & 0x00000100) != 0);
  }
  /**
   * <pre>
   * Mainly useful for testing.
   *
   * If this and expand_reservoir_constraints is true, we use a different
   * encoding of the reservoir constraint using circuit instead of precedences.
   * Note that this is usually slower, but can exercise different part of the
   * solver. Note that contrary to the precedence encoding, this easily support
   * variable demands.
   *
   * WARNING: with this encoding, the constraint take a slighlty different
   * meaning. The level must be within the reservoir for any permutation of the
   * events. So we cannot have +100 and -100 at the same time if the maximum
   * level is 10 (as autorized by the reservoir constraint).
   * </pre>
   *
   * <code>optional bool expand_reservoir_using_circuit = 288 [default = false];</code>
   * @return The expandReservoirUsingCircuit.
   */
  @java.lang.Override
  public boolean getExpandReservoirUsingCircuit() {
    return expandReservoirUsingCircuit_;
  }

  public static final int ENCODE_CUMULATIVE_AS_RESERVOIR_FIELD_NUMBER = 287;
  private boolean encodeCumulativeAsReservoir_ = false;
  /**
   * <pre>
   * Encore cumulative with fixed demands and capacity as a reservoir
   * constraint. The only reason you might want to do that is to test the
   * reservoir propagation code!
   * </pre>
   *
   * <code>optional bool encode_cumulative_as_reservoir = 287 [default = false];</code>
   * @return Whether the encodeCumulativeAsReservoir field is set.
   */
  @java.lang.Override
  public boolean hasEncodeCumulativeAsReservoir() {
    return ((bitField2_ & 0x00000200) != 0);
  }
  /**
   * <pre>
   * Encore cumulative with fixed demands and capacity as a reservoir
   * constraint. The only reason you might want to do that is to test the
   * reservoir propagation code!
   * </pre>
   *
   * <code>optional bool encode_cumulative_as_reservoir = 287 [default = false];</code>
   * @return The encodeCumulativeAsReservoir.
   */
  @java.lang.Override
  public boolean getEncodeCumulativeAsReservoir() {
    return encodeCumulativeAsReservoir_;
  }

  public static final int MAX_LIN_MAX_SIZE_FOR_EXPANSION_FIELD_NUMBER = 280;
  private int maxLinMaxSizeForExpansion_ = 0;
  /**
   * <pre>
   * If the number of expressions in the lin_max is less that the max size
   * parameter, model expansion replaces target = max(xi) by linear constraint
   * with the introduction of new booleans bi such that bi =&gt; target == xi.
   *
   * This is mainly for experimenting compared to a custom lin_max propagator.
   * </pre>
   *
   * <code>optional int32 max_lin_max_size_for_expansion = 280 [default = 0];</code>
   * @return Whether the maxLinMaxSizeForExpansion field is set.
   */
  @java.lang.Override
  public boolean hasMaxLinMaxSizeForExpansion() {
    return ((bitField2_ & 0x00000400) != 0);
  }
  /**
   * <pre>
   * If the number of expressions in the lin_max is less that the max size
   * parameter, model expansion replaces target = max(xi) by linear constraint
   * with the introduction of new booleans bi such that bi =&gt; target == xi.
   *
   * This is mainly for experimenting compared to a custom lin_max propagator.
   * </pre>
   *
   * <code>optional int32 max_lin_max_size_for_expansion = 280 [default = 0];</code>
   * @return The maxLinMaxSizeForExpansion.
   */
  @java.lang.Override
  public int getMaxLinMaxSizeForExpansion() {
    return maxLinMaxSizeForExpansion_;
  }

  public static final int DISABLE_CONSTRAINT_EXPANSION_FIELD_NUMBER = 181;
  private boolean disableConstraintExpansion_ = false;
  /**
   * <pre>
   * If true, it disable all constraint expansion.
   * This should only be used to test the presolve of expanded constraints.
   * </pre>
   *
   * <code>optional bool disable_constraint_expansion = 181 [default = false];</code>
   * @return Whether the disableConstraintExpansion field is set.
   */
  @java.lang.Override
  public boolean hasDisableConstraintExpansion() {
    return ((bitField2_ & 0x00000800) != 0);
  }
  /**
   * <pre>
   * If true, it disable all constraint expansion.
   * This should only be used to test the presolve of expanded constraints.
   * </pre>
   *
   * <code>optional bool disable_constraint_expansion = 181 [default = false];</code>
   * @return The disableConstraintExpansion.
   */
  @java.lang.Override
  public boolean getDisableConstraintExpansion() {
    return disableConstraintExpansion_;
  }

  public static final int ENCODE_COMPLEX_LINEAR_CONSTRAINT_WITH_INTEGER_FIELD_NUMBER = 223;
  private boolean encodeComplexLinearConstraintWithInteger_ = false;
  /**
   * <pre>
   * Linear constraint with a complex right hand side (more than a single
   * interval) need to be expanded, there is a couple of way to do that.
   * </pre>
   *
   * <code>optional bool encode_complex_linear_constraint_with_integer = 223 [default = false];</code>
   * @return Whether the encodeComplexLinearConstraintWithInteger field is set.
   */
  @java.lang.Override
  public boolean hasEncodeComplexLinearConstraintWithInteger() {
    return ((bitField2_ & 0x00001000) != 0);
  }
  /**
   * <pre>
   * Linear constraint with a complex right hand side (more than a single
   * interval) need to be expanded, there is a couple of way to do that.
   * </pre>
   *
   * <code>optional bool encode_complex_linear_constraint_with_integer = 223 [default = false];</code>
   * @return The encodeComplexLinearConstraintWithInteger.
   */
  @java.lang.Override
  public boolean getEncodeComplexLinearConstraintWithInteger() {
    return encodeComplexLinearConstraintWithInteger_;
  }

  public static final int MERGE_NO_OVERLAP_WORK_LIMIT_FIELD_NUMBER = 145;
  private double mergeNoOverlapWorkLimit_ = 1000000000000D;
  /**
   * <pre>
   * During presolve, we use a maximum clique heuristic to merge together
   * no-overlap constraints or at most one constraints. This code can be slow,
   * so we have a limit in place on the number of explored nodes in the
   * underlying graph. The internal limit is an int64, but we use double here to
   * simplify manual input.
   * </pre>
   *
   * <code>optional double merge_no_overlap_work_limit = 145 [default = 1000000000000];</code>
   * @return Whether the mergeNoOverlapWorkLimit field is set.
   */
  @java.lang.Override
  public boolean hasMergeNoOverlapWorkLimit() {
    return ((bitField2_ & 0x00002000) != 0);
  }
  /**
   * <pre>
   * During presolve, we use a maximum clique heuristic to merge together
   * no-overlap constraints or at most one constraints. This code can be slow,
   * so we have a limit in place on the number of explored nodes in the
   * underlying graph. The internal limit is an int64, but we use double here to
   * simplify manual input.
   * </pre>
   *
   * <code>optional double merge_no_overlap_work_limit = 145 [default = 1000000000000];</code>
   * @return The mergeNoOverlapWorkLimit.
   */
  @java.lang.Override
  public double getMergeNoOverlapWorkLimit() {
    return mergeNoOverlapWorkLimit_;
  }

  public static final int MERGE_AT_MOST_ONE_WORK_LIMIT_FIELD_NUMBER = 146;
  private double mergeAtMostOneWorkLimit_ = 100000000D;
  /**
   * <code>optional double merge_at_most_one_work_limit = 146 [default = 100000000];</code>
   * @return Whether the mergeAtMostOneWorkLimit field is set.
   */
  @java.lang.Override
  public boolean hasMergeAtMostOneWorkLimit() {
    return ((bitField2_ & 0x00004000) != 0);
  }
  /**
   * <code>optional double merge_at_most_one_work_limit = 146 [default = 100000000];</code>
   * @return The mergeAtMostOneWorkLimit.
   */
  @java.lang.Override
  public double getMergeAtMostOneWorkLimit() {
    return mergeAtMostOneWorkLimit_;
  }

  public static final int PRESOLVE_SUBSTITUTION_LEVEL_FIELD_NUMBER = 147;
  private int presolveSubstitutionLevel_ = 1;
  /**
   * <pre>
   * How much substitution (also called free variable aggregation in MIP
   * litterature) should we perform at presolve. This currently only concerns
   * variable appearing only in linear constraints. For now the value 0 turns it
   * off and any positive value performs substitution.
   * </pre>
   *
   * <code>optional int32 presolve_substitution_level = 147 [default = 1];</code>
   * @return Whether the presolveSubstitutionLevel field is set.
   */
  @java.lang.Override
  public boolean hasPresolveSubstitutionLevel() {
    return ((bitField2_ & 0x00008000) != 0);
  }
  /**
   * <pre>
   * How much substitution (also called free variable aggregation in MIP
   * litterature) should we perform at presolve. This currently only concerns
   * variable appearing only in linear constraints. For now the value 0 turns it
   * off and any positive value performs substitution.
   * </pre>
   *
   * <code>optional int32 presolve_substitution_level = 147 [default = 1];</code>
   * @return The presolveSubstitutionLevel.
   */
  @java.lang.Override
  public int getPresolveSubstitutionLevel() {
    return presolveSubstitutionLevel_;
  }

  public static final int PRESOLVE_EXTRACT_INTEGER_ENFORCEMENT_FIELD_NUMBER = 174;
  private boolean presolveExtractIntegerEnforcement_ = false;
  /**
   * <pre>
   * If true, we will extract from linear constraints, enforcement literals of
   * the form "integer variable at bound =&gt; simplified constraint". This should
   * always be beneficial except that we don't always handle them as efficiently
   * as we could for now. This causes problem on manna81.mps (LP relaxation not
   * as tight it seems) and on neos-3354841-apure.mps.gz (too many literals
   * created this way).
   * </pre>
   *
   * <code>optional bool presolve_extract_integer_enforcement = 174 [default = false];</code>
   * @return Whether the presolveExtractIntegerEnforcement field is set.
   */
  @java.lang.Override
  public boolean hasPresolveExtractIntegerEnforcement() {
    return ((bitField2_ & 0x00010000) != 0);
  }
  /**
   * <pre>
   * If true, we will extract from linear constraints, enforcement literals of
   * the form "integer variable at bound =&gt; simplified constraint". This should
   * always be beneficial except that we don't always handle them as efficiently
   * as we could for now. This causes problem on manna81.mps (LP relaxation not
   * as tight it seems) and on neos-3354841-apure.mps.gz (too many literals
   * created this way).
   * </pre>
   *
   * <code>optional bool presolve_extract_integer_enforcement = 174 [default = false];</code>
   * @return The presolveExtractIntegerEnforcement.
   */
  @java.lang.Override
  public boolean getPresolveExtractIntegerEnforcement() {
    return presolveExtractIntegerEnforcement_;
  }

  public static final int PRESOLVE_INCLUSION_WORK_LIMIT_FIELD_NUMBER = 201;
  private long presolveInclusionWorkLimit_ = 100000000L;
  /**
   * <pre>
   * A few presolve operations involve detecting constraints included in other
   * constraint. Since there can be a quadratic number of such pairs, and
   * processing them usually involve scanning them, the complexity of these
   * operations can be big. This enforce a local deterministic limit on the
   * number of entries scanned. Default is 1e8.
   *
   * A value of zero will disable these presolve rules completely.
   * </pre>
   *
   * <code>optional int64 presolve_inclusion_work_limit = 201 [default = 100000000];</code>
   * @return Whether the presolveInclusionWorkLimit field is set.
   */
  @java.lang.Override
  public boolean hasPresolveInclusionWorkLimit() {
    return ((bitField2_ & 0x00020000) != 0);
  }
  /**
   * <pre>
   * A few presolve operations involve detecting constraints included in other
   * constraint. Since there can be a quadratic number of such pairs, and
   * processing them usually involve scanning them, the complexity of these
   * operations can be big. This enforce a local deterministic limit on the
   * number of entries scanned. Default is 1e8.
   *
   * A value of zero will disable these presolve rules completely.
   * </pre>
   *
   * <code>optional int64 presolve_inclusion_work_limit = 201 [default = 100000000];</code>
   * @return The presolveInclusionWorkLimit.
   */
  @java.lang.Override
  public long getPresolveInclusionWorkLimit() {
    return presolveInclusionWorkLimit_;
  }

  public static final int IGNORE_NAMES_FIELD_NUMBER = 202;
  private boolean ignoreNames_ = true;
  /**
   * <pre>
   * If true, we don't keep names in our internal copy of the user given model.
   * </pre>
   *
   * <code>optional bool ignore_names = 202 [default = true];</code>
   * @return Whether the ignoreNames field is set.
   */
  @java.lang.Override
  public boolean hasIgnoreNames() {
    return ((bitField2_ & 0x00040000) != 0);
  }
  /**
   * <pre>
   * If true, we don't keep names in our internal copy of the user given model.
   * </pre>
   *
   * <code>optional bool ignore_names = 202 [default = true];</code>
   * @return The ignoreNames.
   */
  @java.lang.Override
  public boolean getIgnoreNames() {
    return ignoreNames_;
  }

  public static final int INFER_ALL_DIFFS_FIELD_NUMBER = 233;
  private boolean inferAllDiffs_ = true;
  /**
   * <pre>
   * Run a max-clique code amongst all the x != y we can find and try to infer
   * set of variables that are all different. This allows to close neos16.mps
   * for instance. Note that we only run this code if there is no all_diff
   * already in the model so that if a user want to add some all_diff, we assume
   * it is well done and do not try to add more.
   *
   * This will also detect and add no_overlap constraints, if all the relations
   * x != y have "offsets" between them. I.e. x &gt; y + offset.
   * </pre>
   *
   * <code>optional bool infer_all_diffs = 233 [default = true];</code>
   * @return Whether the inferAllDiffs field is set.
   */
  @java.lang.Override
  public boolean hasInferAllDiffs() {
    return ((bitField2_ & 0x00080000) != 0);
  }
  /**
   * <pre>
   * Run a max-clique code amongst all the x != y we can find and try to infer
   * set of variables that are all different. This allows to close neos16.mps
   * for instance. Note that we only run this code if there is no all_diff
   * already in the model so that if a user want to add some all_diff, we assume
   * it is well done and do not try to add more.
   *
   * This will also detect and add no_overlap constraints, if all the relations
   * x != y have "offsets" between them. I.e. x &gt; y + offset.
   * </pre>
   *
   * <code>optional bool infer_all_diffs = 233 [default = true];</code>
   * @return The inferAllDiffs.
   */
  @java.lang.Override
  public boolean getInferAllDiffs() {
    return inferAllDiffs_;
  }

  public static final int FIND_BIG_LINEAR_OVERLAP_FIELD_NUMBER = 234;
  private boolean findBigLinearOverlap_ = true;
  /**
   * <pre>
   * Try to find large "rectangle" in the linear constraint matrix with
   * identical lines. If such rectangle is big enough, we can introduce a new
   * integer variable corresponding to the common expression and greatly reduce
   * the number of non-zero.
   * </pre>
   *
   * <code>optional bool find_big_linear_overlap = 234 [default = true];</code>
   * @return Whether the findBigLinearOverlap field is set.
   */
  @java.lang.Override
  public boolean hasFindBigLinearOverlap() {
    return ((bitField2_ & 0x00100000) != 0);
  }
  /**
   * <pre>
   * Try to find large "rectangle" in the linear constraint matrix with
   * identical lines. If such rectangle is big enough, we can introduce a new
   * integer variable corresponding to the common expression and greatly reduce
   * the number of non-zero.
   * </pre>
   *
   * <code>optional bool find_big_linear_overlap = 234 [default = true];</code>
   * @return The findBigLinearOverlap.
   */
  @java.lang.Override
  public boolean getFindBigLinearOverlap() {
    return findBigLinearOverlap_;
  }

  public static final int USE_SAT_INPROCESSING_FIELD_NUMBER = 163;
  private boolean useSatInprocessing_ = true;
  /**
   * <pre>
   * Enable or disable "inprocessing" which is some SAT presolving done at
   * each restart to the root level.
   * </pre>
   *
   * <code>optional bool use_sat_inprocessing = 163 [default = true];</code>
   * @return Whether the useSatInprocessing field is set.
   */
  @java.lang.Override
  public boolean hasUseSatInprocessing() {
    return ((bitField2_ & 0x00200000) != 0);
  }
  /**
   * <pre>
   * Enable or disable "inprocessing" which is some SAT presolving done at
   * each restart to the root level.
   * </pre>
   *
   * <code>optional bool use_sat_inprocessing = 163 [default = true];</code>
   * @return The useSatInprocessing.
   */
  @java.lang.Override
  public boolean getUseSatInprocessing() {
    return useSatInprocessing_;
  }

  public static final int INPROCESSING_DTIME_RATIO_FIELD_NUMBER = 273;
  private double inprocessingDtimeRatio_ = 0.2D;
  /**
   * <pre>
   * Proportion of deterministic time we should spend on inprocessing.
   * At each "restart", if the proportion is below this ratio, we will do some
   * inprocessing, otherwise, we skip it for this restart.
   * </pre>
   *
   * <code>optional double inprocessing_dtime_ratio = 273 [default = 0.2];</code>
   * @return Whether the inprocessingDtimeRatio field is set.
   */
  @java.lang.Override
  public boolean hasInprocessingDtimeRatio() {
    return ((bitField2_ & 0x00400000) != 0);
  }
  /**
   * <pre>
   * Proportion of deterministic time we should spend on inprocessing.
   * At each "restart", if the proportion is below this ratio, we will do some
   * inprocessing, otherwise, we skip it for this restart.
   * </pre>
   *
   * <code>optional double inprocessing_dtime_ratio = 273 [default = 0.2];</code>
   * @return The inprocessingDtimeRatio.
   */
  @java.lang.Override
  public double getInprocessingDtimeRatio() {
    return inprocessingDtimeRatio_;
  }

  public static final int INPROCESSING_PROBING_DTIME_FIELD_NUMBER = 274;
  private double inprocessingProbingDtime_ = 1D;
  /**
   * <pre>
   * The amount of dtime we should spend on probing for each inprocessing round.
   * </pre>
   *
   * <code>optional double inprocessing_probing_dtime = 274 [default = 1];</code>
   * @return Whether the inprocessingProbingDtime field is set.
   */
  @java.lang.Override
  public boolean hasInprocessingProbingDtime() {
    return ((bitField2_ & 0x00800000) != 0);
  }
  /**
   * <pre>
   * The amount of dtime we should spend on probing for each inprocessing round.
   * </pre>
   *
   * <code>optional double inprocessing_probing_dtime = 274 [default = 1];</code>
   * @return The inprocessingProbingDtime.
   */
  @java.lang.Override
  public double getInprocessingProbingDtime() {
    return inprocessingProbingDtime_;
  }

  public static final int INPROCESSING_MINIMIZATION_DTIME_FIELD_NUMBER = 275;
  private double inprocessingMinimizationDtime_ = 1D;
  /**
   * <pre>
   * Parameters for an heuristic similar to the one described in "An effective
   * learnt clause minimization approach for CDCL Sat Solvers",
   * https://www.ijcai.org/proceedings/2017/0098.pdf
   *
   * This is the amount of dtime we should spend on this technique during each
   * inprocessing phase.
   *
   * The minimization technique is the same as the one used to minimize core in
   * max-sat. We also minimize problem clauses and not just the learned clause
   * that we keep forever like in the paper.
   * </pre>
   *
   * <code>optional double inprocessing_minimization_dtime = 275 [default = 1];</code>
   * @return Whether the inprocessingMinimizationDtime field is set.
   */
  @java.lang.Override
  public boolean hasInprocessingMinimizationDtime() {
    return ((bitField2_ & 0x01000000) != 0);
  }
  /**
   * <pre>
   * Parameters for an heuristic similar to the one described in "An effective
   * learnt clause minimization approach for CDCL Sat Solvers",
   * https://www.ijcai.org/proceedings/2017/0098.pdf
   *
   * This is the amount of dtime we should spend on this technique during each
   * inprocessing phase.
   *
   * The minimization technique is the same as the one used to minimize core in
   * max-sat. We also minimize problem clauses and not just the learned clause
   * that we keep forever like in the paper.
   * </pre>
   *
   * <code>optional double inprocessing_minimization_dtime = 275 [default = 1];</code>
   * @return The inprocessingMinimizationDtime.
   */
  @java.lang.Override
  public double getInprocessingMinimizationDtime() {
    return inprocessingMinimizationDtime_;
  }

  public static final int NUM_WORKERS_FIELD_NUMBER = 206;
  private int numWorkers_ = 0;
  /**
   * <pre>
   * Specify the number of parallel workers (i.e. threads) to use during search.
   * This should usually be lower than your number of available cpus +
   * hyperthread in your machine.
   *
   * A value of 0 means the solver will try to use all cores on the machine.
   * A number of 1 means no parallelism.
   *
   * Note that 'num_workers' is the preferred name, but if it is set to zero,
   * we will still read the deprecated 'num_search_workers'.
   *
   * As of 2020-04-10, if you're using SAT via MPSolver (to solve integer
   * programs) this field is overridden with a value of 8, if the field is not
   * set *explicitly*. Thus, always set this field explicitly or via
   * MPSolver::SetNumThreads().
   * </pre>
   *
   * <code>optional int32 num_workers = 206 [default = 0];</code>
   * @return Whether the numWorkers field is set.
   */
  @java.lang.Override
  public boolean hasNumWorkers() {
    return ((bitField2_ & 0x02000000) != 0);
  }
  /**
   * <pre>
   * Specify the number of parallel workers (i.e. threads) to use during search.
   * This should usually be lower than your number of available cpus +
   * hyperthread in your machine.
   *
   * A value of 0 means the solver will try to use all cores on the machine.
   * A number of 1 means no parallelism.
   *
   * Note that 'num_workers' is the preferred name, but if it is set to zero,
   * we will still read the deprecated 'num_search_workers'.
   *
   * As of 2020-04-10, if you're using SAT via MPSolver (to solve integer
   * programs) this field is overridden with a value of 8, if the field is not
   * set *explicitly*. Thus, always set this field explicitly or via
   * MPSolver::SetNumThreads().
   * </pre>
   *
   * <code>optional int32 num_workers = 206 [default = 0];</code>
   * @return The numWorkers.
   */
  @java.lang.Override
  public int getNumWorkers() {
    return numWorkers_;
  }

  public static final int NUM_SEARCH_WORKERS_FIELD_NUMBER = 100;
  private int numSearchWorkers_ = 0;
  /**
   * <code>optional int32 num_search_workers = 100 [default = 0];</code>
   * @return Whether the numSearchWorkers field is set.
   */
  @java.lang.Override
  public boolean hasNumSearchWorkers() {
    return ((bitField2_ & 0x04000000) != 0);
  }
  /**
   * <code>optional int32 num_search_workers = 100 [default = 0];</code>
   * @return The numSearchWorkers.
   */
  @java.lang.Override
  public int getNumSearchWorkers() {
    return numSearchWorkers_;
  }

  public static final int NUM_FULL_SUBSOLVERS_FIELD_NUMBER = 294;
  private int numFullSubsolvers_ = 0;
  /**
   * <pre>
   * We distinguish subsolvers that consume a full thread, and the ones that are
   * always interleaved. If left at zero, we will fix this with a default
   * formula that depends on num_workers. But if you start modifying what runs,
   * you might want to fix that to a given value depending on the num_workers
   * you use.
   * </pre>
   *
   * <code>optional int32 num_full_subsolvers = 294 [default = 0];</code>
   * @return Whether the numFullSubsolvers field is set.
   */
  @java.lang.Override
  public boolean hasNumFullSubsolvers() {
    return ((bitField2_ & 0x08000000) != 0);
  }
  /**
   * <pre>
   * We distinguish subsolvers that consume a full thread, and the ones that are
   * always interleaved. If left at zero, we will fix this with a default
   * formula that depends on num_workers. But if you start modifying what runs,
   * you might want to fix that to a given value depending on the num_workers
   * you use.
   * </pre>
   *
   * <code>optional int32 num_full_subsolvers = 294 [default = 0];</code>
   * @return The numFullSubsolvers.
   */
  @java.lang.Override
  public int getNumFullSubsolvers() {
    return numFullSubsolvers_;
  }

  public static final int SUBSOLVERS_FIELD_NUMBER = 207;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList subsolvers_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * In multi-thread, the solver can be mainly seen as a portfolio of solvers
   * with different parameters. This field indicates the names of the parameters
   * that are used in multithread. This only applies to "full" subsolvers.
   *
   * See cp_model_search.cc to see a list of the names and the default value (if
   * left empty) that looks like:
   * - default_lp           (linearization_level:1)
   * - fixed                (only if fixed search specified or scheduling)
   * - no_lp                (linearization_level:0)
   * - max_lp               (linearization_level:2)
   * - pseudo_costs         (only if objective, change search heuristic)
   * - reduced_costs        (only if objective, change search heuristic)
   * - quick_restart        (kind of probing)
   * - quick_restart_no_lp  (kind of probing with linearization_level:0)
   * - lb_tree_search       (to improve lower bound, MIP like tree search)
   * - probing              (continuous probing and shaving)
   *
   * Also, note that some set of parameters will be ignored if they do not make
   * sense. For instance if there is no objective, pseudo_cost or reduced_cost
   * search will be ignored. Core based search will only work if the objective
   * has many terms. If there is no fixed strategy fixed will be ignored. And so
   * on.
   *
   * The order is important, as only the first num_full_subsolvers will be
   * scheduled. You can see in the log which one are selected for a given run.
   * </pre>
   *
   * <code>repeated string subsolvers = 207;</code>
   * @return A list containing the subsolvers.
   */
  public com.google.protobuf.ProtocolStringList
      getSubsolversList() {
    return subsolvers_;
  }
  /**
   * <pre>
   * In multi-thread, the solver can be mainly seen as a portfolio of solvers
   * with different parameters. This field indicates the names of the parameters
   * that are used in multithread. This only applies to "full" subsolvers.
   *
   * See cp_model_search.cc to see a list of the names and the default value (if
   * left empty) that looks like:
   * - default_lp           (linearization_level:1)
   * - fixed                (only if fixed search specified or scheduling)
   * - no_lp                (linearization_level:0)
   * - max_lp               (linearization_level:2)
   * - pseudo_costs         (only if objective, change search heuristic)
   * - reduced_costs        (only if objective, change search heuristic)
   * - quick_restart        (kind of probing)
   * - quick_restart_no_lp  (kind of probing with linearization_level:0)
   * - lb_tree_search       (to improve lower bound, MIP like tree search)
   * - probing              (continuous probing and shaving)
   *
   * Also, note that some set of parameters will be ignored if they do not make
   * sense. For instance if there is no objective, pseudo_cost or reduced_cost
   * search will be ignored. Core based search will only work if the objective
   * has many terms. If there is no fixed strategy fixed will be ignored. And so
   * on.
   *
   * The order is important, as only the first num_full_subsolvers will be
   * scheduled. You can see in the log which one are selected for a given run.
   * </pre>
   *
   * <code>repeated string subsolvers = 207;</code>
   * @return The count of subsolvers.
   */
  public int getSubsolversCount() {
    return subsolvers_.size();
  }
  /**
   * <pre>
   * In multi-thread, the solver can be mainly seen as a portfolio of solvers
   * with different parameters. This field indicates the names of the parameters
   * that are used in multithread. This only applies to "full" subsolvers.
   *
   * See cp_model_search.cc to see a list of the names and the default value (if
   * left empty) that looks like:
   * - default_lp           (linearization_level:1)
   * - fixed                (only if fixed search specified or scheduling)
   * - no_lp                (linearization_level:0)
   * - max_lp               (linearization_level:2)
   * - pseudo_costs         (only if objective, change search heuristic)
   * - reduced_costs        (only if objective, change search heuristic)
   * - quick_restart        (kind of probing)
   * - quick_restart_no_lp  (kind of probing with linearization_level:0)
   * - lb_tree_search       (to improve lower bound, MIP like tree search)
   * - probing              (continuous probing and shaving)
   *
   * Also, note that some set of parameters will be ignored if they do not make
   * sense. For instance if there is no objective, pseudo_cost or reduced_cost
   * search will be ignored. Core based search will only work if the objective
   * has many terms. If there is no fixed strategy fixed will be ignored. And so
   * on.
   *
   * The order is important, as only the first num_full_subsolvers will be
   * scheduled. You can see in the log which one are selected for a given run.
   * </pre>
   *
   * <code>repeated string subsolvers = 207;</code>
   * @param index The index of the element to return.
   * @return The subsolvers at the given index.
   */
  public java.lang.String getSubsolvers(int index) {
    return subsolvers_.get(index);
  }
  /**
   * <pre>
   * In multi-thread, the solver can be mainly seen as a portfolio of solvers
   * with different parameters. This field indicates the names of the parameters
   * that are used in multithread. This only applies to "full" subsolvers.
   *
   * See cp_model_search.cc to see a list of the names and the default value (if
   * left empty) that looks like:
   * - default_lp           (linearization_level:1)
   * - fixed                (only if fixed search specified or scheduling)
   * - no_lp                (linearization_level:0)
   * - max_lp               (linearization_level:2)
   * - pseudo_costs         (only if objective, change search heuristic)
   * - reduced_costs        (only if objective, change search heuristic)
   * - quick_restart        (kind of probing)
   * - quick_restart_no_lp  (kind of probing with linearization_level:0)
   * - lb_tree_search       (to improve lower bound, MIP like tree search)
   * - probing              (continuous probing and shaving)
   *
   * Also, note that some set of parameters will be ignored if they do not make
   * sense. For instance if there is no objective, pseudo_cost or reduced_cost
   * search will be ignored. Core based search will only work if the objective
   * has many terms. If there is no fixed strategy fixed will be ignored. And so
   * on.
   *
   * The order is important, as only the first num_full_subsolvers will be
   * scheduled. You can see in the log which one are selected for a given run.
   * </pre>
   *
   * <code>repeated string subsolvers = 207;</code>
   * @param index The index of the value to return.
   * @return The bytes of the subsolvers at the given index.
   */
  public com.google.protobuf.ByteString
      getSubsolversBytes(int index) {
    return subsolvers_.getByteString(index);
  }

  public static final int EXTRA_SUBSOLVERS_FIELD_NUMBER = 219;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList extraSubsolvers_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * A convenient way to add more workers types.
   * These will be added at the beginning of the list.
   * </pre>
   *
   * <code>repeated string extra_subsolvers = 219;</code>
   * @return A list containing the extraSubsolvers.
   */
  public com.google.protobuf.ProtocolStringList
      getExtraSubsolversList() {
    return extraSubsolvers_;
  }
  /**
   * <pre>
   * A convenient way to add more workers types.
   * These will be added at the beginning of the list.
   * </pre>
   *
   * <code>repeated string extra_subsolvers = 219;</code>
   * @return The count of extraSubsolvers.
   */
  public int getExtraSubsolversCount() {
    return extraSubsolvers_.size();
  }
  /**
   * <pre>
   * A convenient way to add more workers types.
   * These will be added at the beginning of the list.
   * </pre>
   *
   * <code>repeated string extra_subsolvers = 219;</code>
   * @param index The index of the element to return.
   * @return The extraSubsolvers at the given index.
   */
  public java.lang.String getExtraSubsolvers(int index) {
    return extraSubsolvers_.get(index);
  }
  /**
   * <pre>
   * A convenient way to add more workers types.
   * These will be added at the beginning of the list.
   * </pre>
   *
   * <code>repeated string extra_subsolvers = 219;</code>
   * @param index The index of the value to return.
   * @return The bytes of the extraSubsolvers at the given index.
   */
  public com.google.protobuf.ByteString
      getExtraSubsolversBytes(int index) {
    return extraSubsolvers_.getByteString(index);
  }

  public static final int IGNORE_SUBSOLVERS_FIELD_NUMBER = 209;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList ignoreSubsolvers_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * Rather than fully specifying subsolvers, it is often convenient to just
   * remove the ones that are not useful on a given problem or only keep
   * specific ones for testing. Each string is interpreted as a "glob", so we
   * support '*' and '?'.
   *
   * The way this work is that we will only accept a name that match a filter
   * pattern (if non-empty) and do not match an ignore pattern. Note also that
   * these fields work on LNS or LS names even if these are currently not
   * specified via the subsolvers field.
   * </pre>
   *
   * <code>repeated string ignore_subsolvers = 209;</code>
   * @return A list containing the ignoreSubsolvers.
   */
  public com.google.protobuf.ProtocolStringList
      getIgnoreSubsolversList() {
    return ignoreSubsolvers_;
  }
  /**
   * <pre>
   * Rather than fully specifying subsolvers, it is often convenient to just
   * remove the ones that are not useful on a given problem or only keep
   * specific ones for testing. Each string is interpreted as a "glob", so we
   * support '*' and '?'.
   *
   * The way this work is that we will only accept a name that match a filter
   * pattern (if non-empty) and do not match an ignore pattern. Note also that
   * these fields work on LNS or LS names even if these are currently not
   * specified via the subsolvers field.
   * </pre>
   *
   * <code>repeated string ignore_subsolvers = 209;</code>
   * @return The count of ignoreSubsolvers.
   */
  public int getIgnoreSubsolversCount() {
    return ignoreSubsolvers_.size();
  }
  /**
   * <pre>
   * Rather than fully specifying subsolvers, it is often convenient to just
   * remove the ones that are not useful on a given problem or only keep
   * specific ones for testing. Each string is interpreted as a "glob", so we
   * support '*' and '?'.
   *
   * The way this work is that we will only accept a name that match a filter
   * pattern (if non-empty) and do not match an ignore pattern. Note also that
   * these fields work on LNS or LS names even if these are currently not
   * specified via the subsolvers field.
   * </pre>
   *
   * <code>repeated string ignore_subsolvers = 209;</code>
   * @param index The index of the element to return.
   * @return The ignoreSubsolvers at the given index.
   */
  public java.lang.String getIgnoreSubsolvers(int index) {
    return ignoreSubsolvers_.get(index);
  }
  /**
   * <pre>
   * Rather than fully specifying subsolvers, it is often convenient to just
   * remove the ones that are not useful on a given problem or only keep
   * specific ones for testing. Each string is interpreted as a "glob", so we
   * support '*' and '?'.
   *
   * The way this work is that we will only accept a name that match a filter
   * pattern (if non-empty) and do not match an ignore pattern. Note also that
   * these fields work on LNS or LS names even if these are currently not
   * specified via the subsolvers field.
   * </pre>
   *
   * <code>repeated string ignore_subsolvers = 209;</code>
   * @param index The index of the value to return.
   * @return The bytes of the ignoreSubsolvers at the given index.
   */
  public com.google.protobuf.ByteString
      getIgnoreSubsolversBytes(int index) {
    return ignoreSubsolvers_.getByteString(index);
  }

  public static final int FILTER_SUBSOLVERS_FIELD_NUMBER = 293;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList filterSubsolvers_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <code>repeated string filter_subsolvers = 293;</code>
   * @return A list containing the filterSubsolvers.
   */
  public com.google.protobuf.ProtocolStringList
      getFilterSubsolversList() {
    return filterSubsolvers_;
  }
  /**
   * <code>repeated string filter_subsolvers = 293;</code>
   * @return The count of filterSubsolvers.
   */
  public int getFilterSubsolversCount() {
    return filterSubsolvers_.size();
  }
  /**
   * <code>repeated string filter_subsolvers = 293;</code>
   * @param index The index of the element to return.
   * @return The filterSubsolvers at the given index.
   */
  public java.lang.String getFilterSubsolvers(int index) {
    return filterSubsolvers_.get(index);
  }
  /**
   * <code>repeated string filter_subsolvers = 293;</code>
   * @param index The index of the value to return.
   * @return The bytes of the filterSubsolvers at the given index.
   */
  public com.google.protobuf.ByteString
      getFilterSubsolversBytes(int index) {
    return filterSubsolvers_.getByteString(index);
  }

  public static final int SUBSOLVER_PARAMS_FIELD_NUMBER = 210;
  @SuppressWarnings("serial")
  private java.util.List<com.google.ortools.sat.SatParameters> subsolverParams_;
  /**
   * <pre>
   * It is possible to specify additional subsolver configuration. These can be
   * referred by their params.name() in the fields above. Note that only the
   * specified field will "overwrite" the ones of the base parameter. If a
   * subsolver_params has the name of an existing subsolver configuration, the
   * named parameters will be merged into the subsolver configuration.
   * </pre>
   *
   * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.ortools.sat.SatParameters> getSubsolverParamsList() {
    return subsolverParams_;
  }
  /**
   * <pre>
   * It is possible to specify additional subsolver configuration. These can be
   * referred by their params.name() in the fields above. Note that only the
   * specified field will "overwrite" the ones of the base parameter. If a
   * subsolver_params has the name of an existing subsolver configuration, the
   * named parameters will be merged into the subsolver configuration.
   * </pre>
   *
   * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.ortools.sat.SatParametersOrBuilder> 
      getSubsolverParamsOrBuilderList() {
    return subsolverParams_;
  }
  /**
   * <pre>
   * It is possible to specify additional subsolver configuration. These can be
   * referred by their params.name() in the fields above. Note that only the
   * specified field will "overwrite" the ones of the base parameter. If a
   * subsolver_params has the name of an existing subsolver configuration, the
   * named parameters will be merged into the subsolver configuration.
   * </pre>
   *
   * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
   */
  @java.lang.Override
  public int getSubsolverParamsCount() {
    return subsolverParams_.size();
  }
  /**
   * <pre>
   * It is possible to specify additional subsolver configuration. These can be
   * referred by their params.name() in the fields above. Note that only the
   * specified field will "overwrite" the ones of the base parameter. If a
   * subsolver_params has the name of an existing subsolver configuration, the
   * named parameters will be merged into the subsolver configuration.
   * </pre>
   *
   * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
   */
  @java.lang.Override
  public com.google.ortools.sat.SatParameters getSubsolverParams(int index) {
    return subsolverParams_.get(index);
  }
  /**
   * <pre>
   * It is possible to specify additional subsolver configuration. These can be
   * referred by their params.name() in the fields above. Note that only the
   * specified field will "overwrite" the ones of the base parameter. If a
   * subsolver_params has the name of an existing subsolver configuration, the
   * named parameters will be merged into the subsolver configuration.
   * </pre>
   *
   * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
   */
  @java.lang.Override
  public com.google.ortools.sat.SatParametersOrBuilder getSubsolverParamsOrBuilder(
      int index) {
    return subsolverParams_.get(index);
  }

  public static final int INTERLEAVE_SEARCH_FIELD_NUMBER = 136;
  private boolean interleaveSearch_ = false;
  /**
   * <pre>
   * Experimental. If this is true, then we interleave all our major search
   * strategy and distribute the work amongst num_workers.
   *
   * The search is deterministic (independently of num_workers!), and we
   * schedule and wait for interleave_batch_size task to be completed before
   * synchronizing and scheduling the next batch of tasks.
   * </pre>
   *
   * <code>optional bool interleave_search = 136 [default = false];</code>
   * @return Whether the interleaveSearch field is set.
   */
  @java.lang.Override
  public boolean hasInterleaveSearch() {
    return ((bitField2_ & 0x10000000) != 0);
  }
  /**
   * <pre>
   * Experimental. If this is true, then we interleave all our major search
   * strategy and distribute the work amongst num_workers.
   *
   * The search is deterministic (independently of num_workers!), and we
   * schedule and wait for interleave_batch_size task to be completed before
   * synchronizing and scheduling the next batch of tasks.
   * </pre>
   *
   * <code>optional bool interleave_search = 136 [default = false];</code>
   * @return The interleaveSearch.
   */
  @java.lang.Override
  public boolean getInterleaveSearch() {
    return interleaveSearch_;
  }

  public static final int INTERLEAVE_BATCH_SIZE_FIELD_NUMBER = 134;
  private int interleaveBatchSize_ = 0;
  /**
   * <code>optional int32 interleave_batch_size = 134 [default = 0];</code>
   * @return Whether the interleaveBatchSize field is set.
   */
  @java.lang.Override
  public boolean hasInterleaveBatchSize() {
    return ((bitField2_ & 0x20000000) != 0);
  }
  /**
   * <code>optional int32 interleave_batch_size = 134 [default = 0];</code>
   * @return The interleaveBatchSize.
   */
  @java.lang.Override
  public int getInterleaveBatchSize() {
    return interleaveBatchSize_;
  }

  public static final int SHARE_OBJECTIVE_BOUNDS_FIELD_NUMBER = 113;
  private boolean shareObjectiveBounds_ = true;
  /**
   * <pre>
   * Allows objective sharing between workers.
   * </pre>
   *
   * <code>optional bool share_objective_bounds = 113 [default = true];</code>
   * @return Whether the shareObjectiveBounds field is set.
   */
  @java.lang.Override
  public boolean hasShareObjectiveBounds() {
    return ((bitField2_ & 0x40000000) != 0);
  }
  /**
   * <pre>
   * Allows objective sharing between workers.
   * </pre>
   *
   * <code>optional bool share_objective_bounds = 113 [default = true];</code>
   * @return The shareObjectiveBounds.
   */
  @java.lang.Override
  public boolean getShareObjectiveBounds() {
    return shareObjectiveBounds_;
  }

  public static final int SHARE_LEVEL_ZERO_BOUNDS_FIELD_NUMBER = 114;
  private boolean shareLevelZeroBounds_ = true;
  /**
   * <pre>
   * Allows sharing of the bounds of modified variables at level 0.
   * </pre>
   *
   * <code>optional bool share_level_zero_bounds = 114 [default = true];</code>
   * @return Whether the shareLevelZeroBounds field is set.
   */
  @java.lang.Override
  public boolean hasShareLevelZeroBounds() {
    return ((bitField2_ & 0x80000000) != 0);
  }
  /**
   * <pre>
   * Allows sharing of the bounds of modified variables at level 0.
   * </pre>
   *
   * <code>optional bool share_level_zero_bounds = 114 [default = true];</code>
   * @return The shareLevelZeroBounds.
   */
  @java.lang.Override
  public boolean getShareLevelZeroBounds() {
    return shareLevelZeroBounds_;
  }

  public static final int SHARE_BINARY_CLAUSES_FIELD_NUMBER = 203;
  private boolean shareBinaryClauses_ = true;
  /**
   * <pre>
   * Allows sharing of new learned binary clause between workers.
   * </pre>
   *
   * <code>optional bool share_binary_clauses = 203 [default = true];</code>
   * @return Whether the shareBinaryClauses field is set.
   */
  @java.lang.Override
  public boolean hasShareBinaryClauses() {
    return ((bitField3_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Allows sharing of new learned binary clause between workers.
   * </pre>
   *
   * <code>optional bool share_binary_clauses = 203 [default = true];</code>
   * @return The shareBinaryClauses.
   */
  @java.lang.Override
  public boolean getShareBinaryClauses() {
    return shareBinaryClauses_;
  }

  public static final int SHARE_GLUE_CLAUSES_FIELD_NUMBER = 285;
  private boolean shareGlueClauses_ = false;
  /**
   * <pre>
   * Allows sharing of short glue clauses between workers.
   * Implicitly disabled if share_binary_clauses is false.
   * </pre>
   *
   * <code>optional bool share_glue_clauses = 285 [default = false];</code>
   * @return Whether the shareGlueClauses field is set.
   */
  @java.lang.Override
  public boolean hasShareGlueClauses() {
    return ((bitField3_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * Allows sharing of short glue clauses between workers.
   * Implicitly disabled if share_binary_clauses is false.
   * </pre>
   *
   * <code>optional bool share_glue_clauses = 285 [default = false];</code>
   * @return The shareGlueClauses.
   */
  @java.lang.Override
  public boolean getShareGlueClauses() {
    return shareGlueClauses_;
  }

  public static final int DEBUG_POSTSOLVE_WITH_FULL_SOLVER_FIELD_NUMBER = 162;
  private boolean debugPostsolveWithFullSolver_ = false;
  /**
   * <pre>
   * We have two different postsolve code. The default one should be better and
   * it allows for a more powerful presolve, but it can be useful to postsolve
   * using the full solver instead.
   * </pre>
   *
   * <code>optional bool debug_postsolve_with_full_solver = 162 [default = false];</code>
   * @return Whether the debugPostsolveWithFullSolver field is set.
   */
  @java.lang.Override
  public boolean hasDebugPostsolveWithFullSolver() {
    return ((bitField3_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * We have two different postsolve code. The default one should be better and
   * it allows for a more powerful presolve, but it can be useful to postsolve
   * using the full solver instead.
   * </pre>
   *
   * <code>optional bool debug_postsolve_with_full_solver = 162 [default = false];</code>
   * @return The debugPostsolveWithFullSolver.
   */
  @java.lang.Override
  public boolean getDebugPostsolveWithFullSolver() {
    return debugPostsolveWithFullSolver_;
  }

  public static final int DEBUG_MAX_NUM_PRESOLVE_OPERATIONS_FIELD_NUMBER = 151;
  private int debugMaxNumPresolveOperations_ = 0;
  /**
   * <pre>
   * If positive, try to stop just after that many presolve rules have been
   * applied. This is mainly useful for debugging presolve.
   * </pre>
   *
   * <code>optional int32 debug_max_num_presolve_operations = 151 [default = 0];</code>
   * @return Whether the debugMaxNumPresolveOperations field is set.
   */
  @java.lang.Override
  public boolean hasDebugMaxNumPresolveOperations() {
    return ((bitField3_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * If positive, try to stop just after that many presolve rules have been
   * applied. This is mainly useful for debugging presolve.
   * </pre>
   *
   * <code>optional int32 debug_max_num_presolve_operations = 151 [default = 0];</code>
   * @return The debugMaxNumPresolveOperations.
   */
  @java.lang.Override
  public int getDebugMaxNumPresolveOperations() {
    return debugMaxNumPresolveOperations_;
  }

  public static final int DEBUG_CRASH_ON_BAD_HINT_FIELD_NUMBER = 195;
  private boolean debugCrashOnBadHint_ = false;
  /**
   * <pre>
   * Crash if we do not manage to complete the hint into a full solution.
   * </pre>
   *
   * <code>optional bool debug_crash_on_bad_hint = 195 [default = false];</code>
   * @return Whether the debugCrashOnBadHint field is set.
   */
  @java.lang.Override
  public boolean hasDebugCrashOnBadHint() {
    return ((bitField3_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * Crash if we do not manage to complete the hint into a full solution.
   * </pre>
   *
   * <code>optional bool debug_crash_on_bad_hint = 195 [default = false];</code>
   * @return The debugCrashOnBadHint.
   */
  @java.lang.Override
  public boolean getDebugCrashOnBadHint() {
    return debugCrashOnBadHint_;
  }

  public static final int USE_OPTIMIZATION_HINTS_FIELD_NUMBER = 35;
  private boolean useOptimizationHints_ = true;
  /**
   * <pre>
   * For an optimization problem, whether we follow some hints in order to find
   * a better first solution. For a variable with hint, the solver will always
   * try to follow the hint. It will revert to the variable_branching default
   * otherwise.
   * </pre>
   *
   * <code>optional bool use_optimization_hints = 35 [default = true];</code>
   * @return Whether the useOptimizationHints field is set.
   */
  @java.lang.Override
  public boolean hasUseOptimizationHints() {
    return ((bitField3_ & 0x00000020) != 0);
  }
  /**
   * <pre>
   * For an optimization problem, whether we follow some hints in order to find
   * a better first solution. For a variable with hint, the solver will always
   * try to follow the hint. It will revert to the variable_branching default
   * otherwise.
   * </pre>
   *
   * <code>optional bool use_optimization_hints = 35 [default = true];</code>
   * @return The useOptimizationHints.
   */
  @java.lang.Override
  public boolean getUseOptimizationHints() {
    return useOptimizationHints_;
  }

  public static final int CORE_MINIMIZATION_LEVEL_FIELD_NUMBER = 50;
  private int coreMinimizationLevel_ = 2;
  /**
   * <pre>
   * If positive, we spend some effort on each core:
   * - At level 1, we use a simple heuristic to try to minimize an UNSAT core.
   * - At level 2, we use propagation to minimize the core but also identify
   * literal in at most one relationship in this core.
   * </pre>
   *
   * <code>optional int32 core_minimization_level = 50 [default = 2];</code>
   * @return Whether the coreMinimizationLevel field is set.
   */
  @java.lang.Override
  public boolean hasCoreMinimizationLevel() {
    return ((bitField3_ & 0x00000040) != 0);
  }
  /**
   * <pre>
   * If positive, we spend some effort on each core:
   * - At level 1, we use a simple heuristic to try to minimize an UNSAT core.
   * - At level 2, we use propagation to minimize the core but also identify
   * literal in at most one relationship in this core.
   * </pre>
   *
   * <code>optional int32 core_minimization_level = 50 [default = 2];</code>
   * @return The coreMinimizationLevel.
   */
  @java.lang.Override
  public int getCoreMinimizationLevel() {
    return coreMinimizationLevel_;
  }

  public static final int FIND_MULTIPLE_CORES_FIELD_NUMBER = 84;
  private boolean findMultipleCores_ = true;
  /**
   * <pre>
   * Whether we try to find more independent cores for a given set of
   * assumptions in the core based max-SAT algorithms.
   * </pre>
   *
   * <code>optional bool find_multiple_cores = 84 [default = true];</code>
   * @return Whether the findMultipleCores field is set.
   */
  @java.lang.Override
  public boolean hasFindMultipleCores() {
    return ((bitField3_ & 0x00000080) != 0);
  }
  /**
   * <pre>
   * Whether we try to find more independent cores for a given set of
   * assumptions in the core based max-SAT algorithms.
   * </pre>
   *
   * <code>optional bool find_multiple_cores = 84 [default = true];</code>
   * @return The findMultipleCores.
   */
  @java.lang.Override
  public boolean getFindMultipleCores() {
    return findMultipleCores_;
  }

  public static final int COVER_OPTIMIZATION_FIELD_NUMBER = 89;
  private boolean coverOptimization_ = true;
  /**
   * <pre>
   * If true, when the max-sat algo find a core, we compute the minimal number
   * of literals in the core that needs to be true to have a feasible solution.
   * This is also called core exhaustion in more recent max-SAT papers.
   * </pre>
   *
   * <code>optional bool cover_optimization = 89 [default = true];</code>
   * @return Whether the coverOptimization field is set.
   */
  @java.lang.Override
  public boolean hasCoverOptimization() {
    return ((bitField3_ & 0x00000100) != 0);
  }
  /**
   * <pre>
   * If true, when the max-sat algo find a core, we compute the minimal number
   * of literals in the core that needs to be true to have a feasible solution.
   * This is also called core exhaustion in more recent max-SAT papers.
   * </pre>
   *
   * <code>optional bool cover_optimization = 89 [default = true];</code>
   * @return The coverOptimization.
   */
  @java.lang.Override
  public boolean getCoverOptimization() {
    return coverOptimization_;
  }

  public static final int MAX_SAT_ASSUMPTION_ORDER_FIELD_NUMBER = 51;
  private int maxSatAssumptionOrder_ = 0;
  /**
   * <code>optional .operations_research.sat.SatParameters.MaxSatAssumptionOrder max_sat_assumption_order = 51 [default = DEFAULT_ASSUMPTION_ORDER];</code>
   * @return Whether the maxSatAssumptionOrder field is set.
   */
  @java.lang.Override public boolean hasMaxSatAssumptionOrder() {
    return ((bitField3_ & 0x00000200) != 0);
  }
  /**
   * <code>optional .operations_research.sat.SatParameters.MaxSatAssumptionOrder max_sat_assumption_order = 51 [default = DEFAULT_ASSUMPTION_ORDER];</code>
   * @return The maxSatAssumptionOrder.
   */
  @java.lang.Override public com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder getMaxSatAssumptionOrder() {
    com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder result = com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder.forNumber(maxSatAssumptionOrder_);
    return result == null ? com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder.DEFAULT_ASSUMPTION_ORDER : result;
  }

  public static final int MAX_SAT_REVERSE_ASSUMPTION_ORDER_FIELD_NUMBER = 52;
  private boolean maxSatReverseAssumptionOrder_ = false;
  /**
   * <pre>
   * If true, adds the assumption in the reverse order of the one defined by
   * max_sat_assumption_order.
   * </pre>
   *
   * <code>optional bool max_sat_reverse_assumption_order = 52 [default = false];</code>
   * @return Whether the maxSatReverseAssumptionOrder field is set.
   */
  @java.lang.Override
  public boolean hasMaxSatReverseAssumptionOrder() {
    return ((bitField3_ & 0x00000400) != 0);
  }
  /**
   * <pre>
   * If true, adds the assumption in the reverse order of the one defined by
   * max_sat_assumption_order.
   * </pre>
   *
   * <code>optional bool max_sat_reverse_assumption_order = 52 [default = false];</code>
   * @return The maxSatReverseAssumptionOrder.
   */
  @java.lang.Override
  public boolean getMaxSatReverseAssumptionOrder() {
    return maxSatReverseAssumptionOrder_;
  }

  public static final int MAX_SAT_STRATIFICATION_FIELD_NUMBER = 53;
  private int maxSatStratification_ = 1;
  /**
   * <code>optional .operations_research.sat.SatParameters.MaxSatStratificationAlgorithm max_sat_stratification = 53 [default = STRATIFICATION_DESCENT];</code>
   * @return Whether the maxSatStratification field is set.
   */
  @java.lang.Override public boolean hasMaxSatStratification() {
    return ((bitField3_ & 0x00000800) != 0);
  }
  /**
   * <code>optional .operations_research.sat.SatParameters.MaxSatStratificationAlgorithm max_sat_stratification = 53 [default = STRATIFICATION_DESCENT];</code>
   * @return The maxSatStratification.
   */
  @java.lang.Override public com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm getMaxSatStratification() {
    com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm result = com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm.forNumber(maxSatStratification_);
    return result == null ? com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm.STRATIFICATION_DESCENT : result;
  }

  public static final int PROPAGATION_LOOP_DETECTION_FACTOR_FIELD_NUMBER = 221;
  private double propagationLoopDetectionFactor_ = 10D;
  /**
   * <pre>
   * Some search decisions might cause a really large number of propagations to
   * happen when integer variables with large domains are only reduced by 1 at
   * each step. If we propagate more than the number of variable times this
   * parameters we try to take counter-measure. Setting this to 0.0 disable this
   * feature.
   *
   * TODO(user): Setting this to something like 10 helps in most cases, but the
   * code is currently buggy and can cause the solve to enter a bad state where
   * no progress is made.
   * </pre>
   *
   * <code>optional double propagation_loop_detection_factor = 221 [default = 10];</code>
   * @return Whether the propagationLoopDetectionFactor field is set.
   */
  @java.lang.Override
  public boolean hasPropagationLoopDetectionFactor() {
    return ((bitField3_ & 0x00001000) != 0);
  }
  /**
   * <pre>
   * Some search decisions might cause a really large number of propagations to
   * happen when integer variables with large domains are only reduced by 1 at
   * each step. If we propagate more than the number of variable times this
   * parameters we try to take counter-measure. Setting this to 0.0 disable this
   * feature.
   *
   * TODO(user): Setting this to something like 10 helps in most cases, but the
   * code is currently buggy and can cause the solve to enter a bad state where
   * no progress is made.
   * </pre>
   *
   * <code>optional double propagation_loop_detection_factor = 221 [default = 10];</code>
   * @return The propagationLoopDetectionFactor.
   */
  @java.lang.Override
  public double getPropagationLoopDetectionFactor() {
    return propagationLoopDetectionFactor_;
  }

  public static final int USE_PRECEDENCES_IN_DISJUNCTIVE_CONSTRAINT_FIELD_NUMBER = 74;
  private boolean usePrecedencesInDisjunctiveConstraint_ = true;
  /**
   * <pre>
   * When this is true, then a disjunctive constraint will try to use the
   * precedence relations between time intervals to propagate their bounds
   * further. For instance if task A and B are both before C and task A and B
   * are in disjunction, then we can deduce that task C must start after
   * duration(A) + duration(B) instead of simply max(duration(A), duration(B)),
   * provided that the start time for all task was currently zero.
   *
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_precedences_in_disjunctive_constraint = 74 [default = true];</code>
   * @return Whether the usePrecedencesInDisjunctiveConstraint field is set.
   */
  @java.lang.Override
  public boolean hasUsePrecedencesInDisjunctiveConstraint() {
    return ((bitField3_ & 0x00002000) != 0);
  }
  /**
   * <pre>
   * When this is true, then a disjunctive constraint will try to use the
   * precedence relations between time intervals to propagate their bounds
   * further. For instance if task A and B are both before C and task A and B
   * are in disjunction, then we can deduce that task C must start after
   * duration(A) + duration(B) instead of simply max(duration(A), duration(B)),
   * provided that the start time for all task was currently zero.
   *
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_precedences_in_disjunctive_constraint = 74 [default = true];</code>
   * @return The usePrecedencesInDisjunctiveConstraint.
   */
  @java.lang.Override
  public boolean getUsePrecedencesInDisjunctiveConstraint() {
    return usePrecedencesInDisjunctiveConstraint_;
  }

  public static final int MAX_SIZE_TO_CREATE_PRECEDENCE_LITERALS_IN_DISJUNCTIVE_FIELD_NUMBER = 229;
  private int maxSizeToCreatePrecedenceLiteralsInDisjunctive_ = 60;
  /**
   * <pre>
   * Create one literal for each disjunction of two pairs of tasks. This slows
   * down the solve time, but improves the lower bound of the objective in the
   * makespan case. This will be triggered if the number of intervals is less or
   * equal than the parameter and if use_strong_propagation_in_disjunctive is
   * true.
   * </pre>
   *
   * <code>optional int32 max_size_to_create_precedence_literals_in_disjunctive = 229 [default = 60];</code>
   * @return Whether the maxSizeToCreatePrecedenceLiteralsInDisjunctive field is set.
   */
  @java.lang.Override
  public boolean hasMaxSizeToCreatePrecedenceLiteralsInDisjunctive() {
    return ((bitField3_ & 0x00004000) != 0);
  }
  /**
   * <pre>
   * Create one literal for each disjunction of two pairs of tasks. This slows
   * down the solve time, but improves the lower bound of the objective in the
   * makespan case. This will be triggered if the number of intervals is less or
   * equal than the parameter and if use_strong_propagation_in_disjunctive is
   * true.
   * </pre>
   *
   * <code>optional int32 max_size_to_create_precedence_literals_in_disjunctive = 229 [default = 60];</code>
   * @return The maxSizeToCreatePrecedenceLiteralsInDisjunctive.
   */
  @java.lang.Override
  public int getMaxSizeToCreatePrecedenceLiteralsInDisjunctive() {
    return maxSizeToCreatePrecedenceLiteralsInDisjunctive_;
  }

  public static final int USE_STRONG_PROPAGATION_IN_DISJUNCTIVE_FIELD_NUMBER = 230;
  private boolean useStrongPropagationInDisjunctive_ = false;
  /**
   * <pre>
   * Enable stronger and more expensive propagation on no_overlap constraint.
   * </pre>
   *
   * <code>optional bool use_strong_propagation_in_disjunctive = 230 [default = false];</code>
   * @return Whether the useStrongPropagationInDisjunctive field is set.
   */
  @java.lang.Override
  public boolean hasUseStrongPropagationInDisjunctive() {
    return ((bitField3_ & 0x00008000) != 0);
  }
  /**
   * <pre>
   * Enable stronger and more expensive propagation on no_overlap constraint.
   * </pre>
   *
   * <code>optional bool use_strong_propagation_in_disjunctive = 230 [default = false];</code>
   * @return The useStrongPropagationInDisjunctive.
   */
  @java.lang.Override
  public boolean getUseStrongPropagationInDisjunctive() {
    return useStrongPropagationInDisjunctive_;
  }

  public static final int USE_DYNAMIC_PRECEDENCE_IN_DISJUNCTIVE_FIELD_NUMBER = 263;
  private boolean useDynamicPrecedenceInDisjunctive_ = false;
  /**
   * <pre>
   * Whether we try to branch on decision "interval A before interval B" rather
   * than on intervals bounds. This usually works better, but slow down a bit
   * the time to find the first solution.
   *
   * These parameters are still EXPERIMENTAL, the result should be correct, but
   * it some corner cases, they can cause some failing CHECK in the solver.
   * </pre>
   *
   * <code>optional bool use_dynamic_precedence_in_disjunctive = 263 [default = false];</code>
   * @return Whether the useDynamicPrecedenceInDisjunctive field is set.
   */
  @java.lang.Override
  public boolean hasUseDynamicPrecedenceInDisjunctive() {
    return ((bitField3_ & 0x00010000) != 0);
  }
  /**
   * <pre>
   * Whether we try to branch on decision "interval A before interval B" rather
   * than on intervals bounds. This usually works better, but slow down a bit
   * the time to find the first solution.
   *
   * These parameters are still EXPERIMENTAL, the result should be correct, but
   * it some corner cases, they can cause some failing CHECK in the solver.
   * </pre>
   *
   * <code>optional bool use_dynamic_precedence_in_disjunctive = 263 [default = false];</code>
   * @return The useDynamicPrecedenceInDisjunctive.
   */
  @java.lang.Override
  public boolean getUseDynamicPrecedenceInDisjunctive() {
    return useDynamicPrecedenceInDisjunctive_;
  }

  public static final int USE_DYNAMIC_PRECEDENCE_IN_CUMULATIVE_FIELD_NUMBER = 268;
  private boolean useDynamicPrecedenceInCumulative_ = false;
  /**
   * <code>optional bool use_dynamic_precedence_in_cumulative = 268 [default = false];</code>
   * @return Whether the useDynamicPrecedenceInCumulative field is set.
   */
  @java.lang.Override
  public boolean hasUseDynamicPrecedenceInCumulative() {
    return ((bitField3_ & 0x00020000) != 0);
  }
  /**
   * <code>optional bool use_dynamic_precedence_in_cumulative = 268 [default = false];</code>
   * @return The useDynamicPrecedenceInCumulative.
   */
  @java.lang.Override
  public boolean getUseDynamicPrecedenceInCumulative() {
    return useDynamicPrecedenceInCumulative_;
  }

  public static final int USE_OVERLOAD_CHECKER_IN_CUMULATIVE_FIELD_NUMBER = 78;
  private boolean useOverloadCheckerInCumulative_ = false;
  /**
   * <pre>
   * When this is true, the cumulative constraint is reinforced with overload
   * checking, i.e., an additional level of reasoning based on energy. This
   * additional level supplements the default level of reasoning as well as
   * timetable edge finding.
   *
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_overload_checker_in_cumulative = 78 [default = false];</code>
   * @return Whether the useOverloadCheckerInCumulative field is set.
   */
  @java.lang.Override
  public boolean hasUseOverloadCheckerInCumulative() {
    return ((bitField3_ & 0x00040000) != 0);
  }
  /**
   * <pre>
   * When this is true, the cumulative constraint is reinforced with overload
   * checking, i.e., an additional level of reasoning based on energy. This
   * additional level supplements the default level of reasoning as well as
   * timetable edge finding.
   *
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_overload_checker_in_cumulative = 78 [default = false];</code>
   * @return The useOverloadCheckerInCumulative.
   */
  @java.lang.Override
  public boolean getUseOverloadCheckerInCumulative() {
    return useOverloadCheckerInCumulative_;
  }

  public static final int USE_CONSERVATIVE_SCALE_OVERLOAD_CHECKER_FIELD_NUMBER = 286;
  private boolean useConservativeScaleOverloadChecker_ = false;
  /**
   * <pre>
   * Enable a heuristic to solve cumulative constraints using a modified energy
   * constraint. We modify the usual energy definition by applying a
   * super-additive function (also called "conservative scale" or "dual-feasible
   * function") to the demand and the durations of the tasks.
   *
   * This heuristic is fast but for most problems it does not help much to find
   * a solution.
   * </pre>
   *
   * <code>optional bool use_conservative_scale_overload_checker = 286 [default = false];</code>
   * @return Whether the useConservativeScaleOverloadChecker field is set.
   */
  @java.lang.Override
  public boolean hasUseConservativeScaleOverloadChecker() {
    return ((bitField3_ & 0x00080000) != 0);
  }
  /**
   * <pre>
   * Enable a heuristic to solve cumulative constraints using a modified energy
   * constraint. We modify the usual energy definition by applying a
   * super-additive function (also called "conservative scale" or "dual-feasible
   * function") to the demand and the durations of the tasks.
   *
   * This heuristic is fast but for most problems it does not help much to find
   * a solution.
   * </pre>
   *
   * <code>optional bool use_conservative_scale_overload_checker = 286 [default = false];</code>
   * @return The useConservativeScaleOverloadChecker.
   */
  @java.lang.Override
  public boolean getUseConservativeScaleOverloadChecker() {
    return useConservativeScaleOverloadChecker_;
  }

  public static final int USE_TIMETABLE_EDGE_FINDING_IN_CUMULATIVE_FIELD_NUMBER = 79;
  private boolean useTimetableEdgeFindingInCumulative_ = false;
  /**
   * <pre>
   * When this is true, the cumulative constraint is reinforced with timetable
   * edge finding, i.e., an additional level of reasoning based on the
   * conjunction of energy and mandatory parts. This additional level
   * supplements the default level of reasoning as well as overload_checker.
   *
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_timetable_edge_finding_in_cumulative = 79 [default = false];</code>
   * @return Whether the useTimetableEdgeFindingInCumulative field is set.
   */
  @java.lang.Override
  public boolean hasUseTimetableEdgeFindingInCumulative() {
    return ((bitField3_ & 0x00100000) != 0);
  }
  /**
   * <pre>
   * When this is true, the cumulative constraint is reinforced with timetable
   * edge finding, i.e., an additional level of reasoning based on the
   * conjunction of energy and mandatory parts. This additional level
   * supplements the default level of reasoning as well as overload_checker.
   *
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_timetable_edge_finding_in_cumulative = 79 [default = false];</code>
   * @return The useTimetableEdgeFindingInCumulative.
   */
  @java.lang.Override
  public boolean getUseTimetableEdgeFindingInCumulative() {
    return useTimetableEdgeFindingInCumulative_;
  }

  public static final int MAX_NUM_INTERVALS_FOR_TIMETABLE_EDGE_FINDING_FIELD_NUMBER = 260;
  private int maxNumIntervalsForTimetableEdgeFinding_ = 100;
  /**
   * <pre>
   * Max number of intervals for the timetable_edge_finding algorithm to
   * propagate. A value of 0 disables the constraint.
   * </pre>
   *
   * <code>optional int32 max_num_intervals_for_timetable_edge_finding = 260 [default = 100];</code>
   * @return Whether the maxNumIntervalsForTimetableEdgeFinding field is set.
   */
  @java.lang.Override
  public boolean hasMaxNumIntervalsForTimetableEdgeFinding() {
    return ((bitField3_ & 0x00200000) != 0);
  }
  /**
   * <pre>
   * Max number of intervals for the timetable_edge_finding algorithm to
   * propagate. A value of 0 disables the constraint.
   * </pre>
   *
   * <code>optional int32 max_num_intervals_for_timetable_edge_finding = 260 [default = 100];</code>
   * @return The maxNumIntervalsForTimetableEdgeFinding.
   */
  @java.lang.Override
  public int getMaxNumIntervalsForTimetableEdgeFinding() {
    return maxNumIntervalsForTimetableEdgeFinding_;
  }

  public static final int USE_HARD_PRECEDENCES_IN_CUMULATIVE_FIELD_NUMBER = 215;
  private boolean useHardPrecedencesInCumulative_ = false;
  /**
   * <pre>
   * If true, detect and create constraint for integer variable that are "after"
   * a set of intervals in the same cumulative constraint.
   *
   * Experimental: by default we just use "direct" precedences. If
   * exploit_all_precedences is true, we explore the full precedence graph. This
   * assumes we have a DAG otherwise it fails.
   * </pre>
   *
   * <code>optional bool use_hard_precedences_in_cumulative = 215 [default = false];</code>
   * @return Whether the useHardPrecedencesInCumulative field is set.
   */
  @java.lang.Override
  public boolean hasUseHardPrecedencesInCumulative() {
    return ((bitField3_ & 0x00400000) != 0);
  }
  /**
   * <pre>
   * If true, detect and create constraint for integer variable that are "after"
   * a set of intervals in the same cumulative constraint.
   *
   * Experimental: by default we just use "direct" precedences. If
   * exploit_all_precedences is true, we explore the full precedence graph. This
   * assumes we have a DAG otherwise it fails.
   * </pre>
   *
   * <code>optional bool use_hard_precedences_in_cumulative = 215 [default = false];</code>
   * @return The useHardPrecedencesInCumulative.
   */
  @java.lang.Override
  public boolean getUseHardPrecedencesInCumulative() {
    return useHardPrecedencesInCumulative_;
  }

  public static final int EXPLOIT_ALL_PRECEDENCES_FIELD_NUMBER = 220;
  private boolean exploitAllPrecedences_ = false;
  /**
   * <code>optional bool exploit_all_precedences = 220 [default = false];</code>
   * @return Whether the exploitAllPrecedences field is set.
   */
  @java.lang.Override
  public boolean hasExploitAllPrecedences() {
    return ((bitField3_ & 0x00800000) != 0);
  }
  /**
   * <code>optional bool exploit_all_precedences = 220 [default = false];</code>
   * @return The exploitAllPrecedences.
   */
  @java.lang.Override
  public boolean getExploitAllPrecedences() {
    return exploitAllPrecedences_;
  }

  public static final int USE_DISJUNCTIVE_CONSTRAINT_IN_CUMULATIVE_FIELD_NUMBER = 80;
  private boolean useDisjunctiveConstraintInCumulative_ = true;
  /**
   * <pre>
   * When this is true, the cumulative constraint is reinforced with propagators
   * from the disjunctive constraint to improve the inference on a set of tasks
   * that are disjunctive at the root of the problem. This additional level
   * supplements the default level of reasoning.
   *
   * Propagators of the cumulative constraint will not be used at all if all the
   * tasks are disjunctive at root node.
   *
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_disjunctive_constraint_in_cumulative = 80 [default = true];</code>
   * @return Whether the useDisjunctiveConstraintInCumulative field is set.
   */
  @java.lang.Override
  public boolean hasUseDisjunctiveConstraintInCumulative() {
    return ((bitField3_ & 0x01000000) != 0);
  }
  /**
   * <pre>
   * When this is true, the cumulative constraint is reinforced with propagators
   * from the disjunctive constraint to improve the inference on a set of tasks
   * that are disjunctive at the root of the problem. This additional level
   * supplements the default level of reasoning.
   *
   * Propagators of the cumulative constraint will not be used at all if all the
   * tasks are disjunctive at root node.
   *
   * This always result in better propagation, but it is usually slow, so
   * depending on the problem, turning this off may lead to a faster solution.
   * </pre>
   *
   * <code>optional bool use_disjunctive_constraint_in_cumulative = 80 [default = true];</code>
   * @return The useDisjunctiveConstraintInCumulative.
   */
  @java.lang.Override
  public boolean getUseDisjunctiveConstraintInCumulative() {
    return useDisjunctiveConstraintInCumulative_;
  }

  public static final int USE_TIMETABLING_IN_NO_OVERLAP_2D_FIELD_NUMBER = 200;
  private boolean useTimetablingInNoOverlap2D_ = false;
  /**
   * <pre>
   * When this is true, the no_overlap_2d constraint is reinforced with
   * propagators from the cumulative constraints. It consists of ignoring the
   * position of rectangles in one position and projecting the no_overlap_2d on
   * the other dimension to create a cumulative constraint. This is done on both
   * axis. This additional level supplements the default level of reasoning.
   * </pre>
   *
   * <code>optional bool use_timetabling_in_no_overlap_2d = 200 [default = false];</code>
   * @return Whether the useTimetablingInNoOverlap2d field is set.
   */
  @java.lang.Override
  public boolean hasUseTimetablingInNoOverlap2D() {
    return ((bitField3_ & 0x02000000) != 0);
  }
  /**
   * <pre>
   * When this is true, the no_overlap_2d constraint is reinforced with
   * propagators from the cumulative constraints. It consists of ignoring the
   * position of rectangles in one position and projecting the no_overlap_2d on
   * the other dimension to create a cumulative constraint. This is done on both
   * axis. This additional level supplements the default level of reasoning.
   * </pre>
   *
   * <code>optional bool use_timetabling_in_no_overlap_2d = 200 [default = false];</code>
   * @return The useTimetablingInNoOverlap2d.
   */
  @java.lang.Override
  public boolean getUseTimetablingInNoOverlap2D() {
    return useTimetablingInNoOverlap2D_;
  }

  public static final int USE_ENERGETIC_REASONING_IN_NO_OVERLAP_2D_FIELD_NUMBER = 213;
  private boolean useEnergeticReasoningInNoOverlap2D_ = false;
  /**
   * <pre>
   * When this is true, the no_overlap_2d constraint is reinforced with
   * energetic reasoning. This additional level supplements the default level of
   * reasoning.
   * </pre>
   *
   * <code>optional bool use_energetic_reasoning_in_no_overlap_2d = 213 [default = false];</code>
   * @return Whether the useEnergeticReasoningInNoOverlap2d field is set.
   */
  @java.lang.Override
  public boolean hasUseEnergeticReasoningInNoOverlap2D() {
    return ((bitField3_ & 0x04000000) != 0);
  }
  /**
   * <pre>
   * When this is true, the no_overlap_2d constraint is reinforced with
   * energetic reasoning. This additional level supplements the default level of
   * reasoning.
   * </pre>
   *
   * <code>optional bool use_energetic_reasoning_in_no_overlap_2d = 213 [default = false];</code>
   * @return The useEnergeticReasoningInNoOverlap2d.
   */
  @java.lang.Override
  public boolean getUseEnergeticReasoningInNoOverlap2D() {
    return useEnergeticReasoningInNoOverlap2D_;
  }

  public static final int USE_AREA_ENERGETIC_REASONING_IN_NO_OVERLAP_2D_FIELD_NUMBER = 271;
  private boolean useAreaEnergeticReasoningInNoOverlap2D_ = false;
  /**
   * <pre>
   * When this is true, the no_overlap_2d constraint is reinforced with
   * an energetic reasoning that uses an area-based energy. This can be combined
   * with the two other overlap heuristics above.
   * </pre>
   *
   * <code>optional bool use_area_energetic_reasoning_in_no_overlap_2d = 271 [default = false];</code>
   * @return Whether the useAreaEnergeticReasoningInNoOverlap2d field is set.
   */
  @java.lang.Override
  public boolean hasUseAreaEnergeticReasoningInNoOverlap2D() {
    return ((bitField3_ & 0x08000000) != 0);
  }
  /**
   * <pre>
   * When this is true, the no_overlap_2d constraint is reinforced with
   * an energetic reasoning that uses an area-based energy. This can be combined
   * with the two other overlap heuristics above.
   * </pre>
   *
   * <code>optional bool use_area_energetic_reasoning_in_no_overlap_2d = 271 [default = false];</code>
   * @return The useAreaEnergeticReasoningInNoOverlap2d.
   */
  @java.lang.Override
  public boolean getUseAreaEnergeticReasoningInNoOverlap2D() {
    return useAreaEnergeticReasoningInNoOverlap2D_;
  }

  public static final int MAX_PAIRS_PAIRWISE_REASONING_IN_NO_OVERLAP_2D_FIELD_NUMBER = 276;
  private int maxPairsPairwiseReasoningInNoOverlap2D_ = 1250;
  /**
   * <pre>
   * If the number of pairs to look is below this threshold, do an extra step of
   * propagation in the no_overlap_2d constraint by looking at all pairs of
   * intervals.
   * </pre>
   *
   * <code>optional int32 max_pairs_pairwise_reasoning_in_no_overlap_2d = 276 [default = 1250];</code>
   * @return Whether the maxPairsPairwiseReasoningInNoOverlap2d field is set.
   */
  @java.lang.Override
  public boolean hasMaxPairsPairwiseReasoningInNoOverlap2D() {
    return ((bitField3_ & 0x10000000) != 0);
  }
  /**
   * <pre>
   * If the number of pairs to look is below this threshold, do an extra step of
   * propagation in the no_overlap_2d constraint by looking at all pairs of
   * intervals.
   * </pre>
   *
   * <code>optional int32 max_pairs_pairwise_reasoning_in_no_overlap_2d = 276 [default = 1250];</code>
   * @return The maxPairsPairwiseReasoningInNoOverlap2d.
   */
  @java.lang.Override
  public int getMaxPairsPairwiseReasoningInNoOverlap2D() {
    return maxPairsPairwiseReasoningInNoOverlap2D_;
  }

  public static final int USE_DUAL_SCHEDULING_HEURISTICS_FIELD_NUMBER = 214;
  private boolean useDualSchedulingHeuristics_ = true;
  /**
   * <pre>
   * When set, it activates a few scheduling parameters to improve the lower
   * bound of scheduling problems. This is only effective with multiple workers
   * as it modifies the reduced_cost, lb_tree_search, and probing workers.
   * </pre>
   *
   * <code>optional bool use_dual_scheduling_heuristics = 214 [default = true];</code>
   * @return Whether the useDualSchedulingHeuristics field is set.
   */
  @java.lang.Override
  public boolean hasUseDualSchedulingHeuristics() {
    return ((bitField3_ & 0x20000000) != 0);
  }
  /**
   * <pre>
   * When set, it activates a few scheduling parameters to improve the lower
   * bound of scheduling problems. This is only effective with multiple workers
   * as it modifies the reduced_cost, lb_tree_search, and probing workers.
   * </pre>
   *
   * <code>optional bool use_dual_scheduling_heuristics = 214 [default = true];</code>
   * @return The useDualSchedulingHeuristics.
   */
  @java.lang.Override
  public boolean getUseDualSchedulingHeuristics() {
    return useDualSchedulingHeuristics_;
  }

  public static final int SEARCH_BRANCHING_FIELD_NUMBER = 82;
  private int searchBranching_ = 0;
  /**
   * <code>optional .operations_research.sat.SatParameters.SearchBranching search_branching = 82 [default = AUTOMATIC_SEARCH];</code>
   * @return Whether the searchBranching field is set.
   */
  @java.lang.Override public boolean hasSearchBranching() {
    return ((bitField3_ & 0x40000000) != 0);
  }
  /**
   * <code>optional .operations_research.sat.SatParameters.SearchBranching search_branching = 82 [default = AUTOMATIC_SEARCH];</code>
   * @return The searchBranching.
   */
  @java.lang.Override public com.google.ortools.sat.SatParameters.SearchBranching getSearchBranching() {
    com.google.ortools.sat.SatParameters.SearchBranching result = com.google.ortools.sat.SatParameters.SearchBranching.forNumber(searchBranching_);
    return result == null ? com.google.ortools.sat.SatParameters.SearchBranching.AUTOMATIC_SEARCH : result;
  }

  public static final int HINT_CONFLICT_LIMIT_FIELD_NUMBER = 153;
  private int hintConflictLimit_ = 10;
  /**
   * <pre>
   * Conflict limit used in the phase that exploit the solution hint.
   * </pre>
   *
   * <code>optional int32 hint_conflict_limit = 153 [default = 10];</code>
   * @return Whether the hintConflictLimit field is set.
   */
  @java.lang.Override
  public boolean hasHintConflictLimit() {
    return ((bitField3_ & 0x80000000) != 0);
  }
  /**
   * <pre>
   * Conflict limit used in the phase that exploit the solution hint.
   * </pre>
   *
   * <code>optional int32 hint_conflict_limit = 153 [default = 10];</code>
   * @return The hintConflictLimit.
   */
  @java.lang.Override
  public int getHintConflictLimit() {
    return hintConflictLimit_;
  }

  public static final int REPAIR_HINT_FIELD_NUMBER = 167;
  private boolean repairHint_ = false;
  /**
   * <pre>
   * If true, the solver tries to repair the solution given in the hint. This
   * search terminates after the 'hint_conflict_limit' is reached and the solver
   * switches to regular search. If false, then  we do a FIXED_SEARCH using the
   * hint until the hint_conflict_limit is reached.
   * </pre>
   *
   * <code>optional bool repair_hint = 167 [default = false];</code>
   * @return Whether the repairHint field is set.
   */
  @java.lang.Override
  public boolean hasRepairHint() {
    return ((bitField4_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * If true, the solver tries to repair the solution given in the hint. This
   * search terminates after the 'hint_conflict_limit' is reached and the solver
   * switches to regular search. If false, then  we do a FIXED_SEARCH using the
   * hint until the hint_conflict_limit is reached.
   * </pre>
   *
   * <code>optional bool repair_hint = 167 [default = false];</code>
   * @return The repairHint.
   */
  @java.lang.Override
  public boolean getRepairHint() {
    return repairHint_;
  }

  public static final int FIX_VARIABLES_TO_THEIR_HINTED_VALUE_FIELD_NUMBER = 192;
  private boolean fixVariablesToTheirHintedValue_ = false;
  /**
   * <pre>
   * If true, variables appearing in the solution hints will be fixed to their
   * hinted value.
   * </pre>
   *
   * <code>optional bool fix_variables_to_their_hinted_value = 192 [default = false];</code>
   * @return Whether the fixVariablesToTheirHintedValue field is set.
   */
  @java.lang.Override
  public boolean hasFixVariablesToTheirHintedValue() {
    return ((bitField4_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * If true, variables appearing in the solution hints will be fixed to their
   * hinted value.
   * </pre>
   *
   * <code>optional bool fix_variables_to_their_hinted_value = 192 [default = false];</code>
   * @return The fixVariablesToTheirHintedValue.
   */
  @java.lang.Override
  public boolean getFixVariablesToTheirHintedValue() {
    return fixVariablesToTheirHintedValue_;
  }

  public static final int USE_PROBING_SEARCH_FIELD_NUMBER = 176;
  private boolean useProbingSearch_ = false;
  /**
   * <pre>
   * If true, search will continuously probe Boolean variables, and integer
   * variable bounds. This parameter is set to true in parallel on the probing
   * worker.
   * </pre>
   *
   * <code>optional bool use_probing_search = 176 [default = false];</code>
   * @return Whether the useProbingSearch field is set.
   */
  @java.lang.Override
  public boolean hasUseProbingSearch() {
    return ((bitField4_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * If true, search will continuously probe Boolean variables, and integer
   * variable bounds. This parameter is set to true in parallel on the probing
   * worker.
   * </pre>
   *
   * <code>optional bool use_probing_search = 176 [default = false];</code>
   * @return The useProbingSearch.
   */
  @java.lang.Override
  public boolean getUseProbingSearch() {
    return useProbingSearch_;
  }

  public static final int USE_EXTENDED_PROBING_FIELD_NUMBER = 269;
  private boolean useExtendedProbing_ = true;
  /**
   * <pre>
   * Use extended probing (probe bool_or, at_most_one, exactly_one).
   * </pre>
   *
   * <code>optional bool use_extended_probing = 269 [default = true];</code>
   * @return Whether the useExtendedProbing field is set.
   */
  @java.lang.Override
  public boolean hasUseExtendedProbing() {
    return ((bitField4_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * Use extended probing (probe bool_or, at_most_one, exactly_one).
   * </pre>
   *
   * <code>optional bool use_extended_probing = 269 [default = true];</code>
   * @return The useExtendedProbing.
   */
  @java.lang.Override
  public boolean getUseExtendedProbing() {
    return useExtendedProbing_;
  }

  public static final int PROBING_NUM_COMBINATIONS_LIMIT_FIELD_NUMBER = 272;
  private int probingNumCombinationsLimit_ = 20000;
  /**
   * <pre>
   * How many combinations of pairs or triplets of variables we want to scan.
   * </pre>
   *
   * <code>optional int32 probing_num_combinations_limit = 272 [default = 20000];</code>
   * @return Whether the probingNumCombinationsLimit field is set.
   */
  @java.lang.Override
  public boolean hasProbingNumCombinationsLimit() {
    return ((bitField4_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * How many combinations of pairs or triplets of variables we want to scan.
   * </pre>
   *
   * <code>optional int32 probing_num_combinations_limit = 272 [default = 20000];</code>
   * @return The probingNumCombinationsLimit.
   */
  @java.lang.Override
  public int getProbingNumCombinationsLimit() {
    return probingNumCombinationsLimit_;
  }

  public static final int USE_SHAVING_IN_PROBING_SEARCH_FIELD_NUMBER = 204;
  private boolean useShavingInProbingSearch_ = true;
  /**
   * <pre>
   * Add a shaving phase (where the solver tries to prove that the lower or
   * upper bound of a variable are infeasible) to the probing search.
   * </pre>
   *
   * <code>optional bool use_shaving_in_probing_search = 204 [default = true];</code>
   * @return Whether the useShavingInProbingSearch field is set.
   */
  @java.lang.Override
  public boolean hasUseShavingInProbingSearch() {
    return ((bitField4_ & 0x00000020) != 0);
  }
  /**
   * <pre>
   * Add a shaving phase (where the solver tries to prove that the lower or
   * upper bound of a variable are infeasible) to the probing search.
   * </pre>
   *
   * <code>optional bool use_shaving_in_probing_search = 204 [default = true];</code>
   * @return The useShavingInProbingSearch.
   */
  @java.lang.Override
  public boolean getUseShavingInProbingSearch() {
    return useShavingInProbingSearch_;
  }

  public static final int SHAVING_SEARCH_DETERMINISTIC_TIME_FIELD_NUMBER = 205;
  private double shavingSearchDeterministicTime_ = 0.001D;
  /**
   * <pre>
   * Specifies the amount of deterministic time spent of each try at shaving a
   * bound in the shaving search.
   * </pre>
   *
   * <code>optional double shaving_search_deterministic_time = 205 [default = 0.001];</code>
   * @return Whether the shavingSearchDeterministicTime field is set.
   */
  @java.lang.Override
  public boolean hasShavingSearchDeterministicTime() {
    return ((bitField4_ & 0x00000040) != 0);
  }
  /**
   * <pre>
   * Specifies the amount of deterministic time spent of each try at shaving a
   * bound in the shaving search.
   * </pre>
   *
   * <code>optional double shaving_search_deterministic_time = 205 [default = 0.001];</code>
   * @return The shavingSearchDeterministicTime.
   */
  @java.lang.Override
  public double getShavingSearchDeterministicTime() {
    return shavingSearchDeterministicTime_;
  }

  public static final int SHAVING_SEARCH_THRESHOLD_FIELD_NUMBER = 290;
  private long shavingSearchThreshold_ = 64L;
  /**
   * <pre>
   * Specifies the threshold between two modes in the shaving procedure.
   * If the range of the variable/objective is less than this threshold, then
   * the shaving procedure will try to remove values one by one. Otherwise, it
   * will try to remove one range at a time.
   * </pre>
   *
   * <code>optional int64 shaving_search_threshold = 290 [default = 64];</code>
   * @return Whether the shavingSearchThreshold field is set.
   */
  @java.lang.Override
  public boolean hasShavingSearchThreshold() {
    return ((bitField4_ & 0x00000080) != 0);
  }
  /**
   * <pre>
   * Specifies the threshold between two modes in the shaving procedure.
   * If the range of the variable/objective is less than this threshold, then
   * the shaving procedure will try to remove values one by one. Otherwise, it
   * will try to remove one range at a time.
   * </pre>
   *
   * <code>optional int64 shaving_search_threshold = 290 [default = 64];</code>
   * @return The shavingSearchThreshold.
   */
  @java.lang.Override
  public long getShavingSearchThreshold() {
    return shavingSearchThreshold_;
  }

  public static final int USE_OBJECTIVE_LB_SEARCH_FIELD_NUMBER = 228;
  private boolean useObjectiveLbSearch_ = false;
  /**
   * <pre>
   * If true, search will search in ascending max objective value (when
   * minimizing) starting from the lower bound of the objective.
   * </pre>
   *
   * <code>optional bool use_objective_lb_search = 228 [default = false];</code>
   * @return Whether the useObjectiveLbSearch field is set.
   */
  @java.lang.Override
  public boolean hasUseObjectiveLbSearch() {
    return ((bitField4_ & 0x00000100) != 0);
  }
  /**
   * <pre>
   * If true, search will search in ascending max objective value (when
   * minimizing) starting from the lower bound of the objective.
   * </pre>
   *
   * <code>optional bool use_objective_lb_search = 228 [default = false];</code>
   * @return The useObjectiveLbSearch.
   */
  @java.lang.Override
  public boolean getUseObjectiveLbSearch() {
    return useObjectiveLbSearch_;
  }

  public static final int USE_OBJECTIVE_SHAVING_SEARCH_FIELD_NUMBER = 253;
  private boolean useObjectiveShavingSearch_ = false;
  /**
   * <pre>
   * This search differs from the previous search as it will not use assumptions
   * to bound the objective, and it will recreate a full model with the
   * hardcoded objective value.
   * </pre>
   *
   * <code>optional bool use_objective_shaving_search = 253 [default = false];</code>
   * @return Whether the useObjectiveShavingSearch field is set.
   */
  @java.lang.Override
  public boolean hasUseObjectiveShavingSearch() {
    return ((bitField4_ & 0x00000200) != 0);
  }
  /**
   * <pre>
   * This search differs from the previous search as it will not use assumptions
   * to bound the objective, and it will recreate a full model with the
   * hardcoded objective value.
   * </pre>
   *
   * <code>optional bool use_objective_shaving_search = 253 [default = false];</code>
   * @return The useObjectiveShavingSearch.
   */
  @java.lang.Override
  public boolean getUseObjectiveShavingSearch() {
    return useObjectiveShavingSearch_;
  }

  public static final int USE_VARIABLES_SHAVING_SEARCH_FIELD_NUMBER = 289;
  private boolean useVariablesShavingSearch_ = false;
  /**
   * <pre>
   * This search takes all Boolean or integer variables, and maximize or
   * minimize them in order to reduce their domain.
   * </pre>
   *
   * <code>optional bool use_variables_shaving_search = 289 [default = false];</code>
   * @return Whether the useVariablesShavingSearch field is set.
   */
  @java.lang.Override
  public boolean hasUseVariablesShavingSearch() {
    return ((bitField4_ & 0x00000400) != 0);
  }
  /**
   * <pre>
   * This search takes all Boolean or integer variables, and maximize or
   * minimize them in order to reduce their domain.
   * </pre>
   *
   * <code>optional bool use_variables_shaving_search = 289 [default = false];</code>
   * @return The useVariablesShavingSearch.
   */
  @java.lang.Override
  public boolean getUseVariablesShavingSearch() {
    return useVariablesShavingSearch_;
  }

  public static final int PSEUDO_COST_RELIABILITY_THRESHOLD_FIELD_NUMBER = 123;
  private long pseudoCostReliabilityThreshold_ = 100L;
  /**
   * <pre>
   * The solver ignores the pseudo costs of variables with number of recordings
   * less than this threshold.
   * </pre>
   *
   * <code>optional int64 pseudo_cost_reliability_threshold = 123 [default = 100];</code>
   * @return Whether the pseudoCostReliabilityThreshold field is set.
   */
  @java.lang.Override
  public boolean hasPseudoCostReliabilityThreshold() {
    return ((bitField4_ & 0x00000800) != 0);
  }
  /**
   * <pre>
   * The solver ignores the pseudo costs of variables with number of recordings
   * less than this threshold.
   * </pre>
   *
   * <code>optional int64 pseudo_cost_reliability_threshold = 123 [default = 100];</code>
   * @return The pseudoCostReliabilityThreshold.
   */
  @java.lang.Override
  public long getPseudoCostReliabilityThreshold() {
    return pseudoCostReliabilityThreshold_;
  }

  public static final int OPTIMIZE_WITH_CORE_FIELD_NUMBER = 83;
  private boolean optimizeWithCore_ = false;
  /**
   * <pre>
   * The default optimization method is a simple "linear scan", each time trying
   * to find a better solution than the previous one. If this is true, then we
   * use a core-based approach (like in max-SAT) when we try to increase the
   * lower bound instead.
   * </pre>
   *
   * <code>optional bool optimize_with_core = 83 [default = false];</code>
   * @return Whether the optimizeWithCore field is set.
   */
  @java.lang.Override
  public boolean hasOptimizeWithCore() {
    return ((bitField4_ & 0x00001000) != 0);
  }
  /**
   * <pre>
   * The default optimization method is a simple "linear scan", each time trying
   * to find a better solution than the previous one. If this is true, then we
   * use a core-based approach (like in max-SAT) when we try to increase the
   * lower bound instead.
   * </pre>
   *
   * <code>optional bool optimize_with_core = 83 [default = false];</code>
   * @return The optimizeWithCore.
   */
  @java.lang.Override
  public boolean getOptimizeWithCore() {
    return optimizeWithCore_;
  }

  public static final int OPTIMIZE_WITH_LB_TREE_SEARCH_FIELD_NUMBER = 188;
  private boolean optimizeWithLbTreeSearch_ = false;
  /**
   * <pre>
   * Do a more conventional tree search (by opposition to SAT based one) where
   * we keep all the explored node in a tree. This is meant to be used in a
   * portfolio and focus on improving the objective lower bound. Keeping the
   * whole tree allow us to report a better objective lower bound coming from
   * the worst open node in the tree.
   * </pre>
   *
   * <code>optional bool optimize_with_lb_tree_search = 188 [default = false];</code>
   * @return Whether the optimizeWithLbTreeSearch field is set.
   */
  @java.lang.Override
  public boolean hasOptimizeWithLbTreeSearch() {
    return ((bitField4_ & 0x00002000) != 0);
  }
  /**
   * <pre>
   * Do a more conventional tree search (by opposition to SAT based one) where
   * we keep all the explored node in a tree. This is meant to be used in a
   * portfolio and focus on improving the objective lower bound. Keeping the
   * whole tree allow us to report a better objective lower bound coming from
   * the worst open node in the tree.
   * </pre>
   *
   * <code>optional bool optimize_with_lb_tree_search = 188 [default = false];</code>
   * @return The optimizeWithLbTreeSearch.
   */
  @java.lang.Override
  public boolean getOptimizeWithLbTreeSearch() {
    return optimizeWithLbTreeSearch_;
  }

  public static final int SAVE_LP_BASIS_IN_LB_TREE_SEARCH_FIELD_NUMBER = 284;
  private boolean saveLpBasisInLbTreeSearch_ = false;
  /**
   * <pre>
   * Experimental. Save the current LP basis at each node of the search tree so
   * that when we jump around, we can load it and reduce the number of LP
   * iterations needed.
   *
   * It currently works okay if we do not change the lp with cuts or
   * simplification... More work is needed to make it robust in all cases.
   * </pre>
   *
   * <code>optional bool save_lp_basis_in_lb_tree_search = 284 [default = false];</code>
   * @return Whether the saveLpBasisInLbTreeSearch field is set.
   */
  @java.lang.Override
  public boolean hasSaveLpBasisInLbTreeSearch() {
    return ((bitField4_ & 0x00004000) != 0);
  }
  /**
   * <pre>
   * Experimental. Save the current LP basis at each node of the search tree so
   * that when we jump around, we can load it and reduce the number of LP
   * iterations needed.
   *
   * It currently works okay if we do not change the lp with cuts or
   * simplification... More work is needed to make it robust in all cases.
   * </pre>
   *
   * <code>optional bool save_lp_basis_in_lb_tree_search = 284 [default = false];</code>
   * @return The saveLpBasisInLbTreeSearch.
   */
  @java.lang.Override
  public boolean getSaveLpBasisInLbTreeSearch() {
    return saveLpBasisInLbTreeSearch_;
  }

  public static final int BINARY_SEARCH_NUM_CONFLICTS_FIELD_NUMBER = 99;
  private int binarySearchNumConflicts_ = -1;
  /**
   * <pre>
   * If non-negative, perform a binary search on the objective variable in order
   * to find an [min, max] interval outside of which the solver proved unsat/sat
   * under this amount of conflict. This can quickly reduce the objective domain
   * on some problems.
   * </pre>
   *
   * <code>optional int32 binary_search_num_conflicts = 99 [default = -1];</code>
   * @return Whether the binarySearchNumConflicts field is set.
   */
  @java.lang.Override
  public boolean hasBinarySearchNumConflicts() {
    return ((bitField4_ & 0x00008000) != 0);
  }
  /**
   * <pre>
   * If non-negative, perform a binary search on the objective variable in order
   * to find an [min, max] interval outside of which the solver proved unsat/sat
   * under this amount of conflict. This can quickly reduce the objective domain
   * on some problems.
   * </pre>
   *
   * <code>optional int32 binary_search_num_conflicts = 99 [default = -1];</code>
   * @return The binarySearchNumConflicts.
   */
  @java.lang.Override
  public int getBinarySearchNumConflicts() {
    return binarySearchNumConflicts_;
  }

  public static final int OPTIMIZE_WITH_MAX_HS_FIELD_NUMBER = 85;
  private boolean optimizeWithMaxHs_ = false;
  /**
   * <pre>
   * This has no effect if optimize_with_core is false. If true, use a different
   * core-based algorithm similar to the max-HS algo for max-SAT. This is a
   * hybrid MIP/CP approach and it uses a MIP solver in addition to the CP/SAT
   * one. This is also related to the PhD work of tobyodavies&#64;
   * "Automatic Logic-Based Benders Decomposition with MiniZinc"
   * http://aaai.org/ocs/index.php/AAAI/AAAI17/paper/view/14489
   * </pre>
   *
   * <code>optional bool optimize_with_max_hs = 85 [default = false];</code>
   * @return Whether the optimizeWithMaxHs field is set.
   */
  @java.lang.Override
  public boolean hasOptimizeWithMaxHs() {
    return ((bitField4_ & 0x00010000) != 0);
  }
  /**
   * <pre>
   * This has no effect if optimize_with_core is false. If true, use a different
   * core-based algorithm similar to the max-HS algo for max-SAT. This is a
   * hybrid MIP/CP approach and it uses a MIP solver in addition to the CP/SAT
   * one. This is also related to the PhD work of tobyodavies&#64;
   * "Automatic Logic-Based Benders Decomposition with MiniZinc"
   * http://aaai.org/ocs/index.php/AAAI/AAAI17/paper/view/14489
   * </pre>
   *
   * <code>optional bool optimize_with_max_hs = 85 [default = false];</code>
   * @return The optimizeWithMaxHs.
   */
  @java.lang.Override
  public boolean getOptimizeWithMaxHs() {
    return optimizeWithMaxHs_;
  }

  public static final int USE_FEASIBILITY_JUMP_FIELD_NUMBER = 265;
  private boolean useFeasibilityJump_ = true;
  /**
   * <pre>
   * Parameters for an heuristic similar to the one described in the paper:
   * "Feasibility Jump: an LP-free Lagrangian MIP heuristic", Bjørnar
   * Luteberget, Giorgio Sartor, 2023, Mathematical Programming Computation.
   * </pre>
   *
   * <code>optional bool use_feasibility_jump = 265 [default = true];</code>
   * @return Whether the useFeasibilityJump field is set.
   */
  @java.lang.Override
  public boolean hasUseFeasibilityJump() {
    return ((bitField4_ & 0x00020000) != 0);
  }
  /**
   * <pre>
   * Parameters for an heuristic similar to the one described in the paper:
   * "Feasibility Jump: an LP-free Lagrangian MIP heuristic", Bjørnar
   * Luteberget, Giorgio Sartor, 2023, Mathematical Programming Computation.
   * </pre>
   *
   * <code>optional bool use_feasibility_jump = 265 [default = true];</code>
   * @return The useFeasibilityJump.
   */
  @java.lang.Override
  public boolean getUseFeasibilityJump() {
    return useFeasibilityJump_;
  }

  public static final int USE_LS_ONLY_FIELD_NUMBER = 240;
  private boolean useLsOnly_ = false;
  /**
   * <pre>
   * Disable every other type of subsolver, setting this turns CP-SAT into a
   * pure local-search solver.
   * </pre>
   *
   * <code>optional bool use_ls_only = 240 [default = false];</code>
   * @return Whether the useLsOnly field is set.
   */
  @java.lang.Override
  public boolean hasUseLsOnly() {
    return ((bitField4_ & 0x00040000) != 0);
  }
  /**
   * <pre>
   * Disable every other type of subsolver, setting this turns CP-SAT into a
   * pure local-search solver.
   * </pre>
   *
   * <code>optional bool use_ls_only = 240 [default = false];</code>
   * @return The useLsOnly.
   */
  @java.lang.Override
  public boolean getUseLsOnly() {
    return useLsOnly_;
  }

  public static final int FEASIBILITY_JUMP_DECAY_FIELD_NUMBER = 242;
  private double feasibilityJumpDecay_ = 0.95D;
  /**
   * <pre>
   * On each restart, we randomly choose if we use decay (with this parameter)
   * or no decay.
   * </pre>
   *
   * <code>optional double feasibility_jump_decay = 242 [default = 0.95];</code>
   * @return Whether the feasibilityJumpDecay field is set.
   */
  @java.lang.Override
  public boolean hasFeasibilityJumpDecay() {
    return ((bitField4_ & 0x00080000) != 0);
  }
  /**
   * <pre>
   * On each restart, we randomly choose if we use decay (with this parameter)
   * or no decay.
   * </pre>
   *
   * <code>optional double feasibility_jump_decay = 242 [default = 0.95];</code>
   * @return The feasibilityJumpDecay.
   */
  @java.lang.Override
  public double getFeasibilityJumpDecay() {
    return feasibilityJumpDecay_;
  }

  public static final int FEASIBILITY_JUMP_LINEARIZATION_LEVEL_FIELD_NUMBER = 257;
  private int feasibilityJumpLinearizationLevel_ = 2;
  /**
   * <pre>
   * How much do we linearize the problem in the local search code.
   * </pre>
   *
   * <code>optional int32 feasibility_jump_linearization_level = 257 [default = 2];</code>
   * @return Whether the feasibilityJumpLinearizationLevel field is set.
   */
  @java.lang.Override
  public boolean hasFeasibilityJumpLinearizationLevel() {
    return ((bitField4_ & 0x00100000) != 0);
  }
  /**
   * <pre>
   * How much do we linearize the problem in the local search code.
   * </pre>
   *
   * <code>optional int32 feasibility_jump_linearization_level = 257 [default = 2];</code>
   * @return The feasibilityJumpLinearizationLevel.
   */
  @java.lang.Override
  public int getFeasibilityJumpLinearizationLevel() {
    return feasibilityJumpLinearizationLevel_;
  }

  public static final int FEASIBILITY_JUMP_RESTART_FACTOR_FIELD_NUMBER = 258;
  private int feasibilityJumpRestartFactor_ = 1;
  /**
   * <pre>
   * This is a factor that directly influence the work before each restart.
   * Increasing it leads to longer restart.
   * </pre>
   *
   * <code>optional int32 feasibility_jump_restart_factor = 258 [default = 1];</code>
   * @return Whether the feasibilityJumpRestartFactor field is set.
   */
  @java.lang.Override
  public boolean hasFeasibilityJumpRestartFactor() {
    return ((bitField4_ & 0x00200000) != 0);
  }
  /**
   * <pre>
   * This is a factor that directly influence the work before each restart.
   * Increasing it leads to longer restart.
   * </pre>
   *
   * <code>optional int32 feasibility_jump_restart_factor = 258 [default = 1];</code>
   * @return The feasibilityJumpRestartFactor.
   */
  @java.lang.Override
  public int getFeasibilityJumpRestartFactor() {
    return feasibilityJumpRestartFactor_;
  }

  public static final int FEASIBILITY_JUMP_BATCH_DTIME_FIELD_NUMBER = 292;
  private double feasibilityJumpBatchDtime_ = 0.1D;
  /**
   * <pre>
   * How much dtime for each LS batch.
   * </pre>
   *
   * <code>optional double feasibility_jump_batch_dtime = 292 [default = 0.1];</code>
   * @return Whether the feasibilityJumpBatchDtime field is set.
   */
  @java.lang.Override
  public boolean hasFeasibilityJumpBatchDtime() {
    return ((bitField4_ & 0x00400000) != 0);
  }
  /**
   * <pre>
   * How much dtime for each LS batch.
   * </pre>
   *
   * <code>optional double feasibility_jump_batch_dtime = 292 [default = 0.1];</code>
   * @return The feasibilityJumpBatchDtime.
   */
  @java.lang.Override
  public double getFeasibilityJumpBatchDtime() {
    return feasibilityJumpBatchDtime_;
  }

  public static final int FEASIBILITY_JUMP_VAR_RANDOMIZATION_PROBABILITY_FIELD_NUMBER = 247;
  private double feasibilityJumpVarRandomizationProbability_ = 0.05D;
  /**
   * <pre>
   * Probability for a variable to have a non default value upon restarts or
   * perturbations.
   * </pre>
   *
   * <code>optional double feasibility_jump_var_randomization_probability = 247 [default = 0.05];</code>
   * @return Whether the feasibilityJumpVarRandomizationProbability field is set.
   */
  @java.lang.Override
  public boolean hasFeasibilityJumpVarRandomizationProbability() {
    return ((bitField4_ & 0x00800000) != 0);
  }
  /**
   * <pre>
   * Probability for a variable to have a non default value upon restarts or
   * perturbations.
   * </pre>
   *
   * <code>optional double feasibility_jump_var_randomization_probability = 247 [default = 0.05];</code>
   * @return The feasibilityJumpVarRandomizationProbability.
   */
  @java.lang.Override
  public double getFeasibilityJumpVarRandomizationProbability() {
    return feasibilityJumpVarRandomizationProbability_;
  }

  public static final int FEASIBILITY_JUMP_VAR_PERBURBATION_RANGE_RATIO_FIELD_NUMBER = 248;
  private double feasibilityJumpVarPerburbationRangeRatio_ = 0.2D;
  /**
   * <pre>
   * Max distance between the default value and the pertubated value relative to
   * the range of the domain of the variable.
   * </pre>
   *
   * <code>optional double feasibility_jump_var_perburbation_range_ratio = 248 [default = 0.2];</code>
   * @return Whether the feasibilityJumpVarPerburbationRangeRatio field is set.
   */
  @java.lang.Override
  public boolean hasFeasibilityJumpVarPerburbationRangeRatio() {
    return ((bitField4_ & 0x01000000) != 0);
  }
  /**
   * <pre>
   * Max distance between the default value and the pertubated value relative to
   * the range of the domain of the variable.
   * </pre>
   *
   * <code>optional double feasibility_jump_var_perburbation_range_ratio = 248 [default = 0.2];</code>
   * @return The feasibilityJumpVarPerburbationRangeRatio.
   */
  @java.lang.Override
  public double getFeasibilityJumpVarPerburbationRangeRatio() {
    return feasibilityJumpVarPerburbationRangeRatio_;
  }

  public static final int FEASIBILITY_JUMP_ENABLE_RESTARTS_FIELD_NUMBER = 250;
  private boolean feasibilityJumpEnableRestarts_ = true;
  /**
   * <pre>
   * When stagnating, feasibility jump will either restart from a default
   * solution (with some possible randomization), or randomly pertubate the
   * current solution. This parameter selects the first option.
   * </pre>
   *
   * <code>optional bool feasibility_jump_enable_restarts = 250 [default = true];</code>
   * @return Whether the feasibilityJumpEnableRestarts field is set.
   */
  @java.lang.Override
  public boolean hasFeasibilityJumpEnableRestarts() {
    return ((bitField4_ & 0x02000000) != 0);
  }
  /**
   * <pre>
   * When stagnating, feasibility jump will either restart from a default
   * solution (with some possible randomization), or randomly pertubate the
   * current solution. This parameter selects the first option.
   * </pre>
   *
   * <code>optional bool feasibility_jump_enable_restarts = 250 [default = true];</code>
   * @return The feasibilityJumpEnableRestarts.
   */
  @java.lang.Override
  public boolean getFeasibilityJumpEnableRestarts() {
    return feasibilityJumpEnableRestarts_;
  }

  public static final int FEASIBILITY_JUMP_MAX_EXPANDED_CONSTRAINT_SIZE_FIELD_NUMBER = 264;
  private int feasibilityJumpMaxExpandedConstraintSize_ = 500;
  /**
   * <pre>
   * Maximum size of no_overlap or no_overlap_2d constraint for a quadratic
   * expansion. This might look a lot, but by expanding such constraint, we get
   * a linear time evaluation per single variable moves instead of a slow O(n
   * log n) one.
   * </pre>
   *
   * <code>optional int32 feasibility_jump_max_expanded_constraint_size = 264 [default = 500];</code>
   * @return Whether the feasibilityJumpMaxExpandedConstraintSize field is set.
   */
  @java.lang.Override
  public boolean hasFeasibilityJumpMaxExpandedConstraintSize() {
    return ((bitField4_ & 0x04000000) != 0);
  }
  /**
   * <pre>
   * Maximum size of no_overlap or no_overlap_2d constraint for a quadratic
   * expansion. This might look a lot, but by expanding such constraint, we get
   * a linear time evaluation per single variable moves instead of a slow O(n
   * log n) one.
   * </pre>
   *
   * <code>optional int32 feasibility_jump_max_expanded_constraint_size = 264 [default = 500];</code>
   * @return The feasibilityJumpMaxExpandedConstraintSize.
   */
  @java.lang.Override
  public int getFeasibilityJumpMaxExpandedConstraintSize() {
    return feasibilityJumpMaxExpandedConstraintSize_;
  }

  public static final int NUM_VIOLATION_LS_FIELD_NUMBER = 244;
  private int numViolationLs_ = 0;
  /**
   * <pre>
   * This will create incomplete subsolvers (that are not LNS subsolvers)
   * that use the feasibility jump code to find improving solution, treating
   * the objective improvement as a hard constraint.
   * </pre>
   *
   * <code>optional int32 num_violation_ls = 244 [default = 0];</code>
   * @return Whether the numViolationLs field is set.
   */
  @java.lang.Override
  public boolean hasNumViolationLs() {
    return ((bitField4_ & 0x08000000) != 0);
  }
  /**
   * <pre>
   * This will create incomplete subsolvers (that are not LNS subsolvers)
   * that use the feasibility jump code to find improving solution, treating
   * the objective improvement as a hard constraint.
   * </pre>
   *
   * <code>optional int32 num_violation_ls = 244 [default = 0];</code>
   * @return The numViolationLs.
   */
  @java.lang.Override
  public int getNumViolationLs() {
    return numViolationLs_;
  }

  public static final int VIOLATION_LS_PERTURBATION_PERIOD_FIELD_NUMBER = 249;
  private int violationLsPerturbationPeriod_ = 100;
  /**
   * <pre>
   * How long violation_ls should wait before perturbating a solution.
   * </pre>
   *
   * <code>optional int32 violation_ls_perturbation_period = 249 [default = 100];</code>
   * @return Whether the violationLsPerturbationPeriod field is set.
   */
  @java.lang.Override
  public boolean hasViolationLsPerturbationPeriod() {
    return ((bitField4_ & 0x10000000) != 0);
  }
  /**
   * <pre>
   * How long violation_ls should wait before perturbating a solution.
   * </pre>
   *
   * <code>optional int32 violation_ls_perturbation_period = 249 [default = 100];</code>
   * @return The violationLsPerturbationPeriod.
   */
  @java.lang.Override
  public int getViolationLsPerturbationPeriod() {
    return violationLsPerturbationPeriod_;
  }

  public static final int VIOLATION_LS_COMPOUND_MOVE_PROBABILITY_FIELD_NUMBER = 259;
  private double violationLsCompoundMoveProbability_ = 0.5D;
  /**
   * <pre>
   * Probability of using compound move search each restart.
   * TODO(user): Add reference to paper when published.
   * </pre>
   *
   * <code>optional double violation_ls_compound_move_probability = 259 [default = 0.5];</code>
   * @return Whether the violationLsCompoundMoveProbability field is set.
   */
  @java.lang.Override
  public boolean hasViolationLsCompoundMoveProbability() {
    return ((bitField4_ & 0x20000000) != 0);
  }
  /**
   * <pre>
   * Probability of using compound move search each restart.
   * TODO(user): Add reference to paper when published.
   * </pre>
   *
   * <code>optional double violation_ls_compound_move_probability = 259 [default = 0.5];</code>
   * @return The violationLsCompoundMoveProbability.
   */
  @java.lang.Override
  public double getViolationLsCompoundMoveProbability() {
    return violationLsCompoundMoveProbability_;
  }

  public static final int SHARED_TREE_NUM_WORKERS_FIELD_NUMBER = 235;
  private int sharedTreeNumWorkers_ = 0;
  /**
   * <pre>
   * Enables experimental workstealing-like shared tree search.
   * If non-zero, start this many complete worker threads to explore a shared
   * search tree. These workers communicate objective bounds and simple decision
   * nogoods relating to the shared prefix of the tree, and will avoid exploring
   * the same subtrees as one another.
   * </pre>
   *
   * <code>optional int32 shared_tree_num_workers = 235 [default = 0];</code>
   * @return Whether the sharedTreeNumWorkers field is set.
   */
  @java.lang.Override
  public boolean hasSharedTreeNumWorkers() {
    return ((bitField4_ & 0x40000000) != 0);
  }
  /**
   * <pre>
   * Enables experimental workstealing-like shared tree search.
   * If non-zero, start this many complete worker threads to explore a shared
   * search tree. These workers communicate objective bounds and simple decision
   * nogoods relating to the shared prefix of the tree, and will avoid exploring
   * the same subtrees as one another.
   * </pre>
   *
   * <code>optional int32 shared_tree_num_workers = 235 [default = 0];</code>
   * @return The sharedTreeNumWorkers.
   */
  @java.lang.Override
  public int getSharedTreeNumWorkers() {
    return sharedTreeNumWorkers_;
  }

  public static final int USE_SHARED_TREE_SEARCH_FIELD_NUMBER = 236;
  private boolean useSharedTreeSearch_ = false;
  /**
   * <pre>
   * Set on shared subtree workers. Users should not set this directly.
   * </pre>
   *
   * <code>optional bool use_shared_tree_search = 236 [default = false];</code>
   * @return Whether the useSharedTreeSearch field is set.
   */
  @java.lang.Override
  public boolean hasUseSharedTreeSearch() {
    return ((bitField4_ & 0x80000000) != 0);
  }
  /**
   * <pre>
   * Set on shared subtree workers. Users should not set this directly.
   * </pre>
   *
   * <code>optional bool use_shared_tree_search = 236 [default = false];</code>
   * @return The useSharedTreeSearch.
   */
  @java.lang.Override
  public boolean getUseSharedTreeSearch() {
    return useSharedTreeSearch_;
  }

  public static final int SHARED_TREE_WORKER_OBJECTIVE_SPLIT_PROBABILITY_FIELD_NUMBER = 237;
  private double sharedTreeWorkerObjectiveSplitProbability_ = 0.5D;
  /**
   * <pre>
   * After their assigned prefix, shared tree workers will branch on the
   * objective with this probability. Higher numbers cause the shared tree
   * search to focus on improving the lower bound over finding primal solutions.
   * </pre>
   *
   * <code>optional double shared_tree_worker_objective_split_probability = 237 [default = 0.5];</code>
   * @return Whether the sharedTreeWorkerObjectiveSplitProbability field is set.
   */
  @java.lang.Override
  public boolean hasSharedTreeWorkerObjectiveSplitProbability() {
    return ((bitField5_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * After their assigned prefix, shared tree workers will branch on the
   * objective with this probability. Higher numbers cause the shared tree
   * search to focus on improving the lower bound over finding primal solutions.
   * </pre>
   *
   * <code>optional double shared_tree_worker_objective_split_probability = 237 [default = 0.5];</code>
   * @return The sharedTreeWorkerObjectiveSplitProbability.
   */
  @java.lang.Override
  public double getSharedTreeWorkerObjectiveSplitProbability() {
    return sharedTreeWorkerObjectiveSplitProbability_;
  }

  public static final int SHARED_TREE_WORKER_MIN_RESTARTS_PER_SUBTREE_FIELD_NUMBER = 282;
  private int sharedTreeWorkerMinRestartsPerSubtree_ = 1;
  /**
   * <pre>
   * Minimum number of restarts before a worker will replace a subtree
   * that looks "bad" based on the average LBD of learned clauses.
   * </pre>
   *
   * <code>optional int32 shared_tree_worker_min_restarts_per_subtree = 282 [default = 1];</code>
   * @return Whether the sharedTreeWorkerMinRestartsPerSubtree field is set.
   */
  @java.lang.Override
  public boolean hasSharedTreeWorkerMinRestartsPerSubtree() {
    return ((bitField5_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * Minimum number of restarts before a worker will replace a subtree
   * that looks "bad" based on the average LBD of learned clauses.
   * </pre>
   *
   * <code>optional int32 shared_tree_worker_min_restarts_per_subtree = 282 [default = 1];</code>
   * @return The sharedTreeWorkerMinRestartsPerSubtree.
   */
  @java.lang.Override
  public int getSharedTreeWorkerMinRestartsPerSubtree() {
    return sharedTreeWorkerMinRestartsPerSubtree_;
  }

  public static final int SHARED_TREE_WORKER_ENABLE_TRAIL_SHARING_FIELD_NUMBER = 295;
  private boolean sharedTreeWorkerEnableTrailSharing_ = true;
  /**
   * <pre>
   * If true, workers share more of the information from their local trail.
   * Specifically, literals implied by the shared tree decisions and
   * the longest conflict-free assignment from the last restart (to enable
   * cross-worker phase-saving).
   * </pre>
   *
   * <code>optional bool shared_tree_worker_enable_trail_sharing = 295 [default = true];</code>
   * @return Whether the sharedTreeWorkerEnableTrailSharing field is set.
   */
  @java.lang.Override
  public boolean hasSharedTreeWorkerEnableTrailSharing() {
    return ((bitField5_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * If true, workers share more of the information from their local trail.
   * Specifically, literals implied by the shared tree decisions and
   * the longest conflict-free assignment from the last restart (to enable
   * cross-worker phase-saving).
   * </pre>
   *
   * <code>optional bool shared_tree_worker_enable_trail_sharing = 295 [default = true];</code>
   * @return The sharedTreeWorkerEnableTrailSharing.
   */
  @java.lang.Override
  public boolean getSharedTreeWorkerEnableTrailSharing() {
    return sharedTreeWorkerEnableTrailSharing_;
  }

  public static final int SHARED_TREE_OPEN_LEAVES_PER_WORKER_FIELD_NUMBER = 281;
  private double sharedTreeOpenLeavesPerWorker_ = 2D;
  /**
   * <pre>
   * How many open leaf nodes should the shared tree maintain per worker.
   * </pre>
   *
   * <code>optional double shared_tree_open_leaves_per_worker = 281 [default = 2];</code>
   * @return Whether the sharedTreeOpenLeavesPerWorker field is set.
   */
  @java.lang.Override
  public boolean hasSharedTreeOpenLeavesPerWorker() {
    return ((bitField5_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * How many open leaf nodes should the shared tree maintain per worker.
   * </pre>
   *
   * <code>optional double shared_tree_open_leaves_per_worker = 281 [default = 2];</code>
   * @return The sharedTreeOpenLeavesPerWorker.
   */
  @java.lang.Override
  public double getSharedTreeOpenLeavesPerWorker() {
    return sharedTreeOpenLeavesPerWorker_;
  }

  public static final int SHARED_TREE_MAX_NODES_PER_WORKER_FIELD_NUMBER = 238;
  private int sharedTreeMaxNodesPerWorker_ = 100000;
  /**
   * <pre>
   * In order to limit total shared memory and communication overhead, limit the
   * total number of nodes that may be generated in the shared tree. If the
   * shared tree runs out of unassigned leaves, workers act as portfolio
   * workers. Note: this limit includes interior nodes, not just leaves.
   * </pre>
   *
   * <code>optional int32 shared_tree_max_nodes_per_worker = 238 [default = 100000];</code>
   * @return Whether the sharedTreeMaxNodesPerWorker field is set.
   */
  @java.lang.Override
  public boolean hasSharedTreeMaxNodesPerWorker() {
    return ((bitField5_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * In order to limit total shared memory and communication overhead, limit the
   * total number of nodes that may be generated in the shared tree. If the
   * shared tree runs out of unassigned leaves, workers act as portfolio
   * workers. Note: this limit includes interior nodes, not just leaves.
   * </pre>
   *
   * <code>optional int32 shared_tree_max_nodes_per_worker = 238 [default = 100000];</code>
   * @return The sharedTreeMaxNodesPerWorker.
   */
  @java.lang.Override
  public int getSharedTreeMaxNodesPerWorker() {
    return sharedTreeMaxNodesPerWorker_;
  }

  public static final int SHARED_TREE_SPLIT_STRATEGY_FIELD_NUMBER = 239;
  private int sharedTreeSplitStrategy_ = 0;
  /**
   * <code>optional .operations_research.sat.SatParameters.SharedTreeSplitStrategy shared_tree_split_strategy = 239 [default = SPLIT_STRATEGY_AUTO];</code>
   * @return Whether the sharedTreeSplitStrategy field is set.
   */
  @java.lang.Override public boolean hasSharedTreeSplitStrategy() {
    return ((bitField5_ & 0x00000020) != 0);
  }
  /**
   * <code>optional .operations_research.sat.SatParameters.SharedTreeSplitStrategy shared_tree_split_strategy = 239 [default = SPLIT_STRATEGY_AUTO];</code>
   * @return The sharedTreeSplitStrategy.
   */
  @java.lang.Override public com.google.ortools.sat.SatParameters.SharedTreeSplitStrategy getSharedTreeSplitStrategy() {
    com.google.ortools.sat.SatParameters.SharedTreeSplitStrategy result = com.google.ortools.sat.SatParameters.SharedTreeSplitStrategy.forNumber(sharedTreeSplitStrategy_);
    return result == null ? com.google.ortools.sat.SatParameters.SharedTreeSplitStrategy.SPLIT_STRATEGY_AUTO : result;
  }

  public static final int ENUMERATE_ALL_SOLUTIONS_FIELD_NUMBER = 87;
  private boolean enumerateAllSolutions_ = false;
  /**
   * <pre>
   * Whether we enumerate all solutions of a problem without objective. Note
   * that setting this to true automatically disable some presolve reduction
   * that can remove feasible solution. That is it has the same effect as
   * setting keep_all_feasible_solutions_in_presolve.
   *
   * TODO(user): Do not do that and let the user choose what behavior is best by
   * setting keep_all_feasible_solutions_in_presolve ?
   * </pre>
   *
   * <code>optional bool enumerate_all_solutions = 87 [default = false];</code>
   * @return Whether the enumerateAllSolutions field is set.
   */
  @java.lang.Override
  public boolean hasEnumerateAllSolutions() {
    return ((bitField5_ & 0x00000040) != 0);
  }
  /**
   * <pre>
   * Whether we enumerate all solutions of a problem without objective. Note
   * that setting this to true automatically disable some presolve reduction
   * that can remove feasible solution. That is it has the same effect as
   * setting keep_all_feasible_solutions_in_presolve.
   *
   * TODO(user): Do not do that and let the user choose what behavior is best by
   * setting keep_all_feasible_solutions_in_presolve ?
   * </pre>
   *
   * <code>optional bool enumerate_all_solutions = 87 [default = false];</code>
   * @return The enumerateAllSolutions.
   */
  @java.lang.Override
  public boolean getEnumerateAllSolutions() {
    return enumerateAllSolutions_;
  }

  public static final int KEEP_ALL_FEASIBLE_SOLUTIONS_IN_PRESOLVE_FIELD_NUMBER = 173;
  private boolean keepAllFeasibleSolutionsInPresolve_ = false;
  /**
   * <pre>
   * If true, we disable the presolve reductions that remove feasible solutions
   * from the search space. Such solution are usually dominated by a "better"
   * solution that is kept, but depending on the situation, we might want to
   * keep all solutions.
   *
   * A trivial example is when a variable is unused. If this is true, then the
   * presolve will not fix it to an arbitrary value and it will stay in the
   * search space.
   * </pre>
   *
   * <code>optional bool keep_all_feasible_solutions_in_presolve = 173 [default = false];</code>
   * @return Whether the keepAllFeasibleSolutionsInPresolve field is set.
   */
  @java.lang.Override
  public boolean hasKeepAllFeasibleSolutionsInPresolve() {
    return ((bitField5_ & 0x00000080) != 0);
  }
  /**
   * <pre>
   * If true, we disable the presolve reductions that remove feasible solutions
   * from the search space. Such solution are usually dominated by a "better"
   * solution that is kept, but depending on the situation, we might want to
   * keep all solutions.
   *
   * A trivial example is when a variable is unused. If this is true, then the
   * presolve will not fix it to an arbitrary value and it will stay in the
   * search space.
   * </pre>
   *
   * <code>optional bool keep_all_feasible_solutions_in_presolve = 173 [default = false];</code>
   * @return The keepAllFeasibleSolutionsInPresolve.
   */
  @java.lang.Override
  public boolean getKeepAllFeasibleSolutionsInPresolve() {
    return keepAllFeasibleSolutionsInPresolve_;
  }

  public static final int FILL_TIGHTENED_DOMAINS_IN_RESPONSE_FIELD_NUMBER = 132;
  private boolean fillTightenedDomainsInResponse_ = false;
  /**
   * <pre>
   * If true, add information about the derived variable domains to the
   * CpSolverResponse. It is an option because it makes the response slighly
   * bigger and there is a bit more work involved during the postsolve to
   * construct it, but it should still have a low overhead. See the
   * tightened_variables field in CpSolverResponse for more details.
   * </pre>
   *
   * <code>optional bool fill_tightened_domains_in_response = 132 [default = false];</code>
   * @return Whether the fillTightenedDomainsInResponse field is set.
   */
  @java.lang.Override
  public boolean hasFillTightenedDomainsInResponse() {
    return ((bitField5_ & 0x00000100) != 0);
  }
  /**
   * <pre>
   * If true, add information about the derived variable domains to the
   * CpSolverResponse. It is an option because it makes the response slighly
   * bigger and there is a bit more work involved during the postsolve to
   * construct it, but it should still have a low overhead. See the
   * tightened_variables field in CpSolverResponse for more details.
   * </pre>
   *
   * <code>optional bool fill_tightened_domains_in_response = 132 [default = false];</code>
   * @return The fillTightenedDomainsInResponse.
   */
  @java.lang.Override
  public boolean getFillTightenedDomainsInResponse() {
    return fillTightenedDomainsInResponse_;
  }

  public static final int FILL_ADDITIONAL_SOLUTIONS_IN_RESPONSE_FIELD_NUMBER = 194;
  private boolean fillAdditionalSolutionsInResponse_ = false;
  /**
   * <pre>
   * If true, the final response addition_solutions field will be filled with
   * all solutions from our solutions pool.
   *
   * Note that if both this field and enumerate_all_solutions is true, we will
   * copy to the pool all of the solution found. So if solution_pool_size is big
   * enough, you can get all solutions this way instead of using the solution
   * callback.
   *
   * Note that this only affect the "final" solution, not the one passed to the
   * solution callbacks.
   * </pre>
   *
   * <code>optional bool fill_additional_solutions_in_response = 194 [default = false];</code>
   * @return Whether the fillAdditionalSolutionsInResponse field is set.
   */
  @java.lang.Override
  public boolean hasFillAdditionalSolutionsInResponse() {
    return ((bitField5_ & 0x00000200) != 0);
  }
  /**
   * <pre>
   * If true, the final response addition_solutions field will be filled with
   * all solutions from our solutions pool.
   *
   * Note that if both this field and enumerate_all_solutions is true, we will
   * copy to the pool all of the solution found. So if solution_pool_size is big
   * enough, you can get all solutions this way instead of using the solution
   * callback.
   *
   * Note that this only affect the "final" solution, not the one passed to the
   * solution callbacks.
   * </pre>
   *
   * <code>optional bool fill_additional_solutions_in_response = 194 [default = false];</code>
   * @return The fillAdditionalSolutionsInResponse.
   */
  @java.lang.Override
  public boolean getFillAdditionalSolutionsInResponse() {
    return fillAdditionalSolutionsInResponse_;
  }

  public static final int INSTANTIATE_ALL_VARIABLES_FIELD_NUMBER = 106;
  private boolean instantiateAllVariables_ = true;
  /**
   * <pre>
   * If true, the solver will add a default integer branching strategy to the
   * already defined search strategy. If not, some variable might still not be
   * fixed at the end of the search. For now we assume these variable can just
   * be set to their lower bound.
   * </pre>
   *
   * <code>optional bool instantiate_all_variables = 106 [default = true];</code>
   * @return Whether the instantiateAllVariables field is set.
   */
  @java.lang.Override
  public boolean hasInstantiateAllVariables() {
    return ((bitField5_ & 0x00000400) != 0);
  }
  /**
   * <pre>
   * If true, the solver will add a default integer branching strategy to the
   * already defined search strategy. If not, some variable might still not be
   * fixed at the end of the search. For now we assume these variable can just
   * be set to their lower bound.
   * </pre>
   *
   * <code>optional bool instantiate_all_variables = 106 [default = true];</code>
   * @return The instantiateAllVariables.
   */
  @java.lang.Override
  public boolean getInstantiateAllVariables() {
    return instantiateAllVariables_;
  }

  public static final int AUTO_DETECT_GREATER_THAN_AT_LEAST_ONE_OF_FIELD_NUMBER = 95;
  private boolean autoDetectGreaterThanAtLeastOneOf_ = true;
  /**
   * <pre>
   * If true, then the precedences propagator try to detect for each variable if
   * it has a set of "optional incoming arc" for which at least one of them is
   * present. This is usually useful to have but can be slow on model with a lot
   * of precedence.
   * </pre>
   *
   * <code>optional bool auto_detect_greater_than_at_least_one_of = 95 [default = true];</code>
   * @return Whether the autoDetectGreaterThanAtLeastOneOf field is set.
   */
  @java.lang.Override
  public boolean hasAutoDetectGreaterThanAtLeastOneOf() {
    return ((bitField5_ & 0x00000800) != 0);
  }
  /**
   * <pre>
   * If true, then the precedences propagator try to detect for each variable if
   * it has a set of "optional incoming arc" for which at least one of them is
   * present. This is usually useful to have but can be slow on model with a lot
   * of precedence.
   * </pre>
   *
   * <code>optional bool auto_detect_greater_than_at_least_one_of = 95 [default = true];</code>
   * @return The autoDetectGreaterThanAtLeastOneOf.
   */
  @java.lang.Override
  public boolean getAutoDetectGreaterThanAtLeastOneOf() {
    return autoDetectGreaterThanAtLeastOneOf_;
  }

  public static final int STOP_AFTER_FIRST_SOLUTION_FIELD_NUMBER = 98;
  private boolean stopAfterFirstSolution_ = false;
  /**
   * <pre>
   * For an optimization problem, stop the solver as soon as we have a solution.
   * </pre>
   *
   * <code>optional bool stop_after_first_solution = 98 [default = false];</code>
   * @return Whether the stopAfterFirstSolution field is set.
   */
  @java.lang.Override
  public boolean hasStopAfterFirstSolution() {
    return ((bitField5_ & 0x00001000) != 0);
  }
  /**
   * <pre>
   * For an optimization problem, stop the solver as soon as we have a solution.
   * </pre>
   *
   * <code>optional bool stop_after_first_solution = 98 [default = false];</code>
   * @return The stopAfterFirstSolution.
   */
  @java.lang.Override
  public boolean getStopAfterFirstSolution() {
    return stopAfterFirstSolution_;
  }

  public static final int STOP_AFTER_PRESOLVE_FIELD_NUMBER = 149;
  private boolean stopAfterPresolve_ = false;
  /**
   * <pre>
   * Mainly used when improving the presolver. When true, stops the solver after
   * the presolve is complete (or after loading and root level propagation).
   * </pre>
   *
   * <code>optional bool stop_after_presolve = 149 [default = false];</code>
   * @return Whether the stopAfterPresolve field is set.
   */
  @java.lang.Override
  public boolean hasStopAfterPresolve() {
    return ((bitField5_ & 0x00002000) != 0);
  }
  /**
   * <pre>
   * Mainly used when improving the presolver. When true, stops the solver after
   * the presolve is complete (or after loading and root level propagation).
   * </pre>
   *
   * <code>optional bool stop_after_presolve = 149 [default = false];</code>
   * @return The stopAfterPresolve.
   */
  @java.lang.Override
  public boolean getStopAfterPresolve() {
    return stopAfterPresolve_;
  }

  public static final int STOP_AFTER_ROOT_PROPAGATION_FIELD_NUMBER = 252;
  private boolean stopAfterRootPropagation_ = false;
  /**
   * <code>optional bool stop_after_root_propagation = 252 [default = false];</code>
   * @return Whether the stopAfterRootPropagation field is set.
   */
  @java.lang.Override
  public boolean hasStopAfterRootPropagation() {
    return ((bitField5_ & 0x00004000) != 0);
  }
  /**
   * <code>optional bool stop_after_root_propagation = 252 [default = false];</code>
   * @return The stopAfterRootPropagation.
   */
  @java.lang.Override
  public boolean getStopAfterRootPropagation() {
    return stopAfterRootPropagation_;
  }

  public static final int USE_LNS_FIELD_NUMBER = 283;
  private boolean useLns_ = true;
  /**
   * <pre>
   * Testing parameters used to disable all lns workers.
   * </pre>
   *
   * <code>optional bool use_lns = 283 [default = true];</code>
   * @return Whether the useLns field is set.
   */
  @java.lang.Override
  public boolean hasUseLns() {
    return ((bitField5_ & 0x00008000) != 0);
  }
  /**
   * <pre>
   * Testing parameters used to disable all lns workers.
   * </pre>
   *
   * <code>optional bool use_lns = 283 [default = true];</code>
   * @return The useLns.
   */
  @java.lang.Override
  public boolean getUseLns() {
    return useLns_;
  }

  public static final int USE_LNS_ONLY_FIELD_NUMBER = 101;
  private boolean useLnsOnly_ = false;
  /**
   * <pre>
   * Experimental parameters to disable everything but lns.
   * </pre>
   *
   * <code>optional bool use_lns_only = 101 [default = false];</code>
   * @return Whether the useLnsOnly field is set.
   */
  @java.lang.Override
  public boolean hasUseLnsOnly() {
    return ((bitField5_ & 0x00010000) != 0);
  }
  /**
   * <pre>
   * Experimental parameters to disable everything but lns.
   * </pre>
   *
   * <code>optional bool use_lns_only = 101 [default = false];</code>
   * @return The useLnsOnly.
   */
  @java.lang.Override
  public boolean getUseLnsOnly() {
    return useLnsOnly_;
  }

  public static final int SOLUTION_POOL_SIZE_FIELD_NUMBER = 193;
  private int solutionPoolSize_ = 3;
  /**
   * <pre>
   * Size of the top-n different solutions kept by the solver.
   * This parameter must be &gt; 0.
   * Currently this only impact the "base" solution chosen for a LNS fragment.
   * </pre>
   *
   * <code>optional int32 solution_pool_size = 193 [default = 3];</code>
   * @return Whether the solutionPoolSize field is set.
   */
  @java.lang.Override
  public boolean hasSolutionPoolSize() {
    return ((bitField5_ & 0x00020000) != 0);
  }
  /**
   * <pre>
   * Size of the top-n different solutions kept by the solver.
   * This parameter must be &gt; 0.
   * Currently this only impact the "base" solution chosen for a LNS fragment.
   * </pre>
   *
   * <code>optional int32 solution_pool_size = 193 [default = 3];</code>
   * @return The solutionPoolSize.
   */
  @java.lang.Override
  public int getSolutionPoolSize() {
    return solutionPoolSize_;
  }

  public static final int USE_RINS_LNS_FIELD_NUMBER = 129;
  private boolean useRinsLns_ = true;
  /**
   * <pre>
   * Turns on relaxation induced neighborhood generator.
   * </pre>
   *
   * <code>optional bool use_rins_lns = 129 [default = true];</code>
   * @return Whether the useRinsLns field is set.
   */
  @java.lang.Override
  public boolean hasUseRinsLns() {
    return ((bitField5_ & 0x00040000) != 0);
  }
  /**
   * <pre>
   * Turns on relaxation induced neighborhood generator.
   * </pre>
   *
   * <code>optional bool use_rins_lns = 129 [default = true];</code>
   * @return The useRinsLns.
   */
  @java.lang.Override
  public boolean getUseRinsLns() {
    return useRinsLns_;
  }

  public static final int USE_FEASIBILITY_PUMP_FIELD_NUMBER = 164;
  private boolean useFeasibilityPump_ = true;
  /**
   * <pre>
   * Adds a feasibility pump subsolver along with lns subsolvers.
   * </pre>
   *
   * <code>optional bool use_feasibility_pump = 164 [default = true];</code>
   * @return Whether the useFeasibilityPump field is set.
   */
  @java.lang.Override
  public boolean hasUseFeasibilityPump() {
    return ((bitField5_ & 0x00080000) != 0);
  }
  /**
   * <pre>
   * Adds a feasibility pump subsolver along with lns subsolvers.
   * </pre>
   *
   * <code>optional bool use_feasibility_pump = 164 [default = true];</code>
   * @return The useFeasibilityPump.
   */
  @java.lang.Override
  public boolean getUseFeasibilityPump() {
    return useFeasibilityPump_;
  }

  public static final int USE_LB_RELAX_LNS_FIELD_NUMBER = 255;
  private boolean useLbRelaxLns_ = false;
  /**
   * <pre>
   * Turns on neighborhood generator based on local branching LP. Based on Huang
   * et al., "Local Branching Relaxation Heuristics for Integer Linear
   * Programs", 2023.
   * </pre>
   *
   * <code>optional bool use_lb_relax_lns = 255 [default = false];</code>
   * @return Whether the useLbRelaxLns field is set.
   */
  @java.lang.Override
  public boolean hasUseLbRelaxLns() {
    return ((bitField5_ & 0x00100000) != 0);
  }
  /**
   * <pre>
   * Turns on neighborhood generator based on local branching LP. Based on Huang
   * et al., "Local Branching Relaxation Heuristics for Integer Linear
   * Programs", 2023.
   * </pre>
   *
   * <code>optional bool use_lb_relax_lns = 255 [default = false];</code>
   * @return The useLbRelaxLns.
   */
  @java.lang.Override
  public boolean getUseLbRelaxLns() {
    return useLbRelaxLns_;
  }

  public static final int FP_ROUNDING_FIELD_NUMBER = 165;
  private int fpRounding_ = 2;
  /**
   * <code>optional .operations_research.sat.SatParameters.FPRoundingMethod fp_rounding = 165 [default = PROPAGATION_ASSISTED];</code>
   * @return Whether the fpRounding field is set.
   */
  @java.lang.Override public boolean hasFpRounding() {
    return ((bitField5_ & 0x00200000) != 0);
  }
  /**
   * <code>optional .operations_research.sat.SatParameters.FPRoundingMethod fp_rounding = 165 [default = PROPAGATION_ASSISTED];</code>
   * @return The fpRounding.
   */
  @java.lang.Override public com.google.ortools.sat.SatParameters.FPRoundingMethod getFpRounding() {
    com.google.ortools.sat.SatParameters.FPRoundingMethod result = com.google.ortools.sat.SatParameters.FPRoundingMethod.forNumber(fpRounding_);
    return result == null ? com.google.ortools.sat.SatParameters.FPRoundingMethod.PROPAGATION_ASSISTED : result;
  }

  public static final int DIVERSIFY_LNS_PARAMS_FIELD_NUMBER = 137;
  private boolean diversifyLnsParams_ = false;
  /**
   * <pre>
   * If true, registers more lns subsolvers with different parameters.
   * </pre>
   *
   * <code>optional bool diversify_lns_params = 137 [default = false];</code>
   * @return Whether the diversifyLnsParams field is set.
   */
  @java.lang.Override
  public boolean hasDiversifyLnsParams() {
    return ((bitField5_ & 0x00400000) != 0);
  }
  /**
   * <pre>
   * If true, registers more lns subsolvers with different parameters.
   * </pre>
   *
   * <code>optional bool diversify_lns_params = 137 [default = false];</code>
   * @return The diversifyLnsParams.
   */
  @java.lang.Override
  public boolean getDiversifyLnsParams() {
    return diversifyLnsParams_;
  }

  public static final int RANDOMIZE_SEARCH_FIELD_NUMBER = 103;
  private boolean randomizeSearch_ = false;
  /**
   * <pre>
   * Randomize fixed search.
   * </pre>
   *
   * <code>optional bool randomize_search = 103 [default = false];</code>
   * @return Whether the randomizeSearch field is set.
   */
  @java.lang.Override
  public boolean hasRandomizeSearch() {
    return ((bitField5_ & 0x00800000) != 0);
  }
  /**
   * <pre>
   * Randomize fixed search.
   * </pre>
   *
   * <code>optional bool randomize_search = 103 [default = false];</code>
   * @return The randomizeSearch.
   */
  @java.lang.Override
  public boolean getRandomizeSearch() {
    return randomizeSearch_;
  }

  public static final int SEARCH_RANDOM_VARIABLE_POOL_SIZE_FIELD_NUMBER = 104;
  private long searchRandomVariablePoolSize_ = 0L;
  /**
   * <pre>
   * Search randomization will collect the top
   * 'search_random_variable_pool_size' valued variables, and pick one randomly.
   * The value of the variable is specific to each strategy.
   * </pre>
   *
   * <code>optional int64 search_random_variable_pool_size = 104 [default = 0];</code>
   * @return Whether the searchRandomVariablePoolSize field is set.
   */
  @java.lang.Override
  public boolean hasSearchRandomVariablePoolSize() {
    return ((bitField5_ & 0x01000000) != 0);
  }
  /**
   * <pre>
   * Search randomization will collect the top
   * 'search_random_variable_pool_size' valued variables, and pick one randomly.
   * The value of the variable is specific to each strategy.
   * </pre>
   *
   * <code>optional int64 search_random_variable_pool_size = 104 [default = 0];</code>
   * @return The searchRandomVariablePoolSize.
   */
  @java.lang.Override
  public long getSearchRandomVariablePoolSize() {
    return searchRandomVariablePoolSize_;
  }

  public static final int PUSH_ALL_TASKS_TOWARD_START_FIELD_NUMBER = 262;
  private boolean pushAllTasksTowardStart_ = false;
  /**
   * <pre>
   * Experimental code: specify if the objective pushes all tasks toward the
   * start of the schedule.
   * </pre>
   *
   * <code>optional bool push_all_tasks_toward_start = 262 [default = false];</code>
   * @return Whether the pushAllTasksTowardStart field is set.
   */
  @java.lang.Override
  public boolean hasPushAllTasksTowardStart() {
    return ((bitField5_ & 0x02000000) != 0);
  }
  /**
   * <pre>
   * Experimental code: specify if the objective pushes all tasks toward the
   * start of the schedule.
   * </pre>
   *
   * <code>optional bool push_all_tasks_toward_start = 262 [default = false];</code>
   * @return The pushAllTasksTowardStart.
   */
  @java.lang.Override
  public boolean getPushAllTasksTowardStart() {
    return pushAllTasksTowardStart_;
  }

  public static final int USE_OPTIONAL_VARIABLES_FIELD_NUMBER = 108;
  private boolean useOptionalVariables_ = false;
  /**
   * <pre>
   * If true, we automatically detect variables whose constraint are always
   * enforced by the same literal and we mark them as optional. This allows
   * to propagate them as if they were present in some situation.
   *
   * TODO(user): This is experimental and seems to lead to wrong optimal in
   * some situation. It should however gives correct solutions. Fix.
   * </pre>
   *
   * <code>optional bool use_optional_variables = 108 [default = false];</code>
   * @return Whether the useOptionalVariables field is set.
   */
  @java.lang.Override
  public boolean hasUseOptionalVariables() {
    return ((bitField5_ & 0x04000000) != 0);
  }
  /**
   * <pre>
   * If true, we automatically detect variables whose constraint are always
   * enforced by the same literal and we mark them as optional. This allows
   * to propagate them as if they were present in some situation.
   *
   * TODO(user): This is experimental and seems to lead to wrong optimal in
   * some situation. It should however gives correct solutions. Fix.
   * </pre>
   *
   * <code>optional bool use_optional_variables = 108 [default = false];</code>
   * @return The useOptionalVariables.
   */
  @java.lang.Override
  public boolean getUseOptionalVariables() {
    return useOptionalVariables_;
  }

  public static final int USE_EXACT_LP_REASON_FIELD_NUMBER = 109;
  private boolean useExactLpReason_ = true;
  /**
   * <pre>
   * The solver usually exploit the LP relaxation of a model. If this option is
   * true, then whatever is infered by the LP will be used like an heuristic to
   * compute EXACT propagation on the IP. So with this option, there is no
   * numerical imprecision issues.
   * </pre>
   *
   * <code>optional bool use_exact_lp_reason = 109 [default = true];</code>
   * @return Whether the useExactLpReason field is set.
   */
  @java.lang.Override
  public boolean hasUseExactLpReason() {
    return ((bitField5_ & 0x08000000) != 0);
  }
  /**
   * <pre>
   * The solver usually exploit the LP relaxation of a model. If this option is
   * true, then whatever is infered by the LP will be used like an heuristic to
   * compute EXACT propagation on the IP. So with this option, there is no
   * numerical imprecision issues.
   * </pre>
   *
   * <code>optional bool use_exact_lp_reason = 109 [default = true];</code>
   * @return The useExactLpReason.
   */
  @java.lang.Override
  public boolean getUseExactLpReason() {
    return useExactLpReason_;
  }

  public static final int USE_COMBINED_NO_OVERLAP_FIELD_NUMBER = 133;
  private boolean useCombinedNoOverlap_ = false;
  /**
   * <pre>
   * This can be beneficial if there is a lot of no-overlap constraints but a
   * relatively low number of different intervals in the problem. Like 1000
   * intervals, but 1M intervals in the no-overlap constraints covering them.
   * </pre>
   *
   * <code>optional bool use_combined_no_overlap = 133 [default = false];</code>
   * @return Whether the useCombinedNoOverlap field is set.
   */
  @java.lang.Override
  public boolean hasUseCombinedNoOverlap() {
    return ((bitField5_ & 0x10000000) != 0);
  }
  /**
   * <pre>
   * This can be beneficial if there is a lot of no-overlap constraints but a
   * relatively low number of different intervals in the problem. Like 1000
   * intervals, but 1M intervals in the no-overlap constraints covering them.
   * </pre>
   *
   * <code>optional bool use_combined_no_overlap = 133 [default = false];</code>
   * @return The useCombinedNoOverlap.
   */
  @java.lang.Override
  public boolean getUseCombinedNoOverlap() {
    return useCombinedNoOverlap_;
  }

  public static final int AT_MOST_ONE_MAX_EXPANSION_SIZE_FIELD_NUMBER = 270;
  private int atMostOneMaxExpansionSize_ = 3;
  /**
   * <pre>
   * All at_most_one constraints with a size &lt;= param will be replaced by a
   * quadratic number of binary implications.
   * </pre>
   *
   * <code>optional int32 at_most_one_max_expansion_size = 270 [default = 3];</code>
   * @return Whether the atMostOneMaxExpansionSize field is set.
   */
  @java.lang.Override
  public boolean hasAtMostOneMaxExpansionSize() {
    return ((bitField5_ & 0x20000000) != 0);
  }
  /**
   * <pre>
   * All at_most_one constraints with a size &lt;= param will be replaced by a
   * quadratic number of binary implications.
   * </pre>
   *
   * <code>optional int32 at_most_one_max_expansion_size = 270 [default = 3];</code>
   * @return The atMostOneMaxExpansionSize.
   */
  @java.lang.Override
  public int getAtMostOneMaxExpansionSize() {
    return atMostOneMaxExpansionSize_;
  }

  public static final int CATCH_SIGINT_SIGNAL_FIELD_NUMBER = 135;
  private boolean catchSigintSignal_ = true;
  /**
   * <pre>
   * Indicates if the CP-SAT layer should catch Control-C (SIGINT) signals
   * when calling solve. If set, catching the SIGINT signal will terminate the
   * search gracefully, as if a time limit was reached.
   * </pre>
   *
   * <code>optional bool catch_sigint_signal = 135 [default = true];</code>
   * @return Whether the catchSigintSignal field is set.
   */
  @java.lang.Override
  public boolean hasCatchSigintSignal() {
    return ((bitField5_ & 0x40000000) != 0);
  }
  /**
   * <pre>
   * Indicates if the CP-SAT layer should catch Control-C (SIGINT) signals
   * when calling solve. If set, catching the SIGINT signal will terminate the
   * search gracefully, as if a time limit was reached.
   * </pre>
   *
   * <code>optional bool catch_sigint_signal = 135 [default = true];</code>
   * @return The catchSigintSignal.
   */
  @java.lang.Override
  public boolean getCatchSigintSignal() {
    return catchSigintSignal_;
  }

  public static final int USE_IMPLIED_BOUNDS_FIELD_NUMBER = 144;
  private boolean useImpliedBounds_ = true;
  /**
   * <pre>
   * Stores and exploits "implied-bounds" in the solver. That is, relations of
   * the form literal =&gt; (var &gt;= bound). This is currently used to derive
   * stronger cuts.
   * </pre>
   *
   * <code>optional bool use_implied_bounds = 144 [default = true];</code>
   * @return Whether the useImpliedBounds field is set.
   */
  @java.lang.Override
  public boolean hasUseImpliedBounds() {
    return ((bitField5_ & 0x80000000) != 0);
  }
  /**
   * <pre>
   * Stores and exploits "implied-bounds" in the solver. That is, relations of
   * the form literal =&gt; (var &gt;= bound). This is currently used to derive
   * stronger cuts.
   * </pre>
   *
   * <code>optional bool use_implied_bounds = 144 [default = true];</code>
   * @return The useImpliedBounds.
   */
  @java.lang.Override
  public boolean getUseImpliedBounds() {
    return useImpliedBounds_;
  }

  public static final int POLISH_LP_SOLUTION_FIELD_NUMBER = 175;
  private boolean polishLpSolution_ = false;
  /**
   * <pre>
   * Whether we try to do a few degenerate iteration at the end of an LP solve
   * to minimize the fractionality of the integer variable in the basis. This
   * helps on some problems, but not so much on others. It also cost of bit of
   * time to do such polish step.
   * </pre>
   *
   * <code>optional bool polish_lp_solution = 175 [default = false];</code>
   * @return Whether the polishLpSolution field is set.
   */
  @java.lang.Override
  public boolean hasPolishLpSolution() {
    return ((bitField6_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Whether we try to do a few degenerate iteration at the end of an LP solve
   * to minimize the fractionality of the integer variable in the basis. This
   * helps on some problems, but not so much on others. It also cost of bit of
   * time to do such polish step.
   * </pre>
   *
   * <code>optional bool polish_lp_solution = 175 [default = false];</code>
   * @return The polishLpSolution.
   */
  @java.lang.Override
  public boolean getPolishLpSolution() {
    return polishLpSolution_;
  }

  public static final int LP_PRIMAL_TOLERANCE_FIELD_NUMBER = 266;
  private double lpPrimalTolerance_ = 1e-07D;
  /**
   * <pre>
   * The internal LP tolerances used by CP-SAT. These applies to the internal
   * and scaled problem. If the domains of your variables are large it might be
   * good to use lower tolerances. If your problem is binary with low
   * coefficients, it might be good to use higher ones to speed-up the lp
   * solves.
   * </pre>
   *
   * <code>optional double lp_primal_tolerance = 266 [default = 1e-07];</code>
   * @return Whether the lpPrimalTolerance field is set.
   */
  @java.lang.Override
  public boolean hasLpPrimalTolerance() {
    return ((bitField6_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * The internal LP tolerances used by CP-SAT. These applies to the internal
   * and scaled problem. If the domains of your variables are large it might be
   * good to use lower tolerances. If your problem is binary with low
   * coefficients, it might be good to use higher ones to speed-up the lp
   * solves.
   * </pre>
   *
   * <code>optional double lp_primal_tolerance = 266 [default = 1e-07];</code>
   * @return The lpPrimalTolerance.
   */
  @java.lang.Override
  public double getLpPrimalTolerance() {
    return lpPrimalTolerance_;
  }

  public static final int LP_DUAL_TOLERANCE_FIELD_NUMBER = 267;
  private double lpDualTolerance_ = 1e-07D;
  /**
   * <code>optional double lp_dual_tolerance = 267 [default = 1e-07];</code>
   * @return Whether the lpDualTolerance field is set.
   */
  @java.lang.Override
  public boolean hasLpDualTolerance() {
    return ((bitField6_ & 0x00000004) != 0);
  }
  /**
   * <code>optional double lp_dual_tolerance = 267 [default = 1e-07];</code>
   * @return The lpDualTolerance.
   */
  @java.lang.Override
  public double getLpDualTolerance() {
    return lpDualTolerance_;
  }

  public static final int CONVERT_INTERVALS_FIELD_NUMBER = 177;
  private boolean convertIntervals_ = true;
  /**
   * <pre>
   * Temporary flag util the feature is more mature. This convert intervals to
   * the newer proto format that support affine start/var/end instead of just
   * variables.
   * </pre>
   *
   * <code>optional bool convert_intervals = 177 [default = true];</code>
   * @return Whether the convertIntervals field is set.
   */
  @java.lang.Override
  public boolean hasConvertIntervals() {
    return ((bitField6_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * Temporary flag util the feature is more mature. This convert intervals to
   * the newer proto format that support affine start/var/end instead of just
   * variables.
   * </pre>
   *
   * <code>optional bool convert_intervals = 177 [default = true];</code>
   * @return The convertIntervals.
   */
  @java.lang.Override
  public boolean getConvertIntervals() {
    return convertIntervals_;
  }

  public static final int SYMMETRY_LEVEL_FIELD_NUMBER = 183;
  private int symmetryLevel_ = 2;
  /**
   * <pre>
   * Whether we try to automatically detect the symmetries in a model and
   * exploit them. Currently, at level 1 we detect them in presolve and try
   * to fix Booleans. At level 2, we also do some form of dynamic symmetry
   * breaking during search. At level 3, we also detect symmetries for very
   * large models, which can be slow. At level 4, we try to break as much
   * symmetry as possible in presolve.
   * </pre>
   *
   * <code>optional int32 symmetry_level = 183 [default = 2];</code>
   * @return Whether the symmetryLevel field is set.
   */
  @java.lang.Override
  public boolean hasSymmetryLevel() {
    return ((bitField6_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * Whether we try to automatically detect the symmetries in a model and
   * exploit them. Currently, at level 1 we detect them in presolve and try
   * to fix Booleans. At level 2, we also do some form of dynamic symmetry
   * breaking during search. At level 3, we also detect symmetries for very
   * large models, which can be slow. At level 4, we try to break as much
   * symmetry as possible in presolve.
   * </pre>
   *
   * <code>optional int32 symmetry_level = 183 [default = 2];</code>
   * @return The symmetryLevel.
   */
  @java.lang.Override
  public int getSymmetryLevel() {
    return symmetryLevel_;
  }

  public static final int NEW_LINEAR_PROPAGATION_FIELD_NUMBER = 224;
  private boolean newLinearPropagation_ = true;
  /**
   * <pre>
   * The new linear propagation code treat all constraints at once and use
   * an adaptation of Bellman-Ford-Tarjan to propagate constraint in a smarter
   * order and potentially detect propagation cycle earlier.
   * </pre>
   *
   * <code>optional bool new_linear_propagation = 224 [default = true];</code>
   * @return Whether the newLinearPropagation field is set.
   */
  @java.lang.Override
  public boolean hasNewLinearPropagation() {
    return ((bitField6_ & 0x00000020) != 0);
  }
  /**
   * <pre>
   * The new linear propagation code treat all constraints at once and use
   * an adaptation of Bellman-Ford-Tarjan to propagate constraint in a smarter
   * order and potentially detect propagation cycle earlier.
   * </pre>
   *
   * <code>optional bool new_linear_propagation = 224 [default = true];</code>
   * @return The newLinearPropagation.
   */
  @java.lang.Override
  public boolean getNewLinearPropagation() {
    return newLinearPropagation_;
  }

  public static final int LINEAR_SPLIT_SIZE_FIELD_NUMBER = 256;
  private int linearSplitSize_ = 100;
  /**
   * <pre>
   * Linear constraints that are not pseudo-Boolean and that are longer than
   * this size will be split into sqrt(size) intermediate sums in order to have
   * faster propation in the CP engine.
   * </pre>
   *
   * <code>optional int32 linear_split_size = 256 [default = 100];</code>
   * @return Whether the linearSplitSize field is set.
   */
  @java.lang.Override
  public boolean hasLinearSplitSize() {
    return ((bitField6_ & 0x00000040) != 0);
  }
  /**
   * <pre>
   * Linear constraints that are not pseudo-Boolean and that are longer than
   * this size will be split into sqrt(size) intermediate sums in order to have
   * faster propation in the CP engine.
   * </pre>
   *
   * <code>optional int32 linear_split_size = 256 [default = 100];</code>
   * @return The linearSplitSize.
   */
  @java.lang.Override
  public int getLinearSplitSize() {
    return linearSplitSize_;
  }

  public static final int LINEARIZATION_LEVEL_FIELD_NUMBER = 90;
  private int linearizationLevel_ = 1;
  /**
   * <pre>
   * A non-negative level indicating the type of constraints we consider in the
   * LP relaxation. At level zero, no LP relaxation is used. At level 1, only
   * the linear constraint and full encoding are added. At level 2, we also add
   * all the Boolean constraints.
   * </pre>
   *
   * <code>optional int32 linearization_level = 90 [default = 1];</code>
   * @return Whether the linearizationLevel field is set.
   */
  @java.lang.Override
  public boolean hasLinearizationLevel() {
    return ((bitField6_ & 0x00000080) != 0);
  }
  /**
   * <pre>
   * A non-negative level indicating the type of constraints we consider in the
   * LP relaxation. At level zero, no LP relaxation is used. At level 1, only
   * the linear constraint and full encoding are added. At level 2, we also add
   * all the Boolean constraints.
   * </pre>
   *
   * <code>optional int32 linearization_level = 90 [default = 1];</code>
   * @return The linearizationLevel.
   */
  @java.lang.Override
  public int getLinearizationLevel() {
    return linearizationLevel_;
  }

  public static final int BOOLEAN_ENCODING_LEVEL_FIELD_NUMBER = 107;
  private int booleanEncodingLevel_ = 1;
  /**
   * <pre>
   * A non-negative level indicating how much we should try to fully encode
   * Integer variables as Boolean.
   * </pre>
   *
   * <code>optional int32 boolean_encoding_level = 107 [default = 1];</code>
   * @return Whether the booleanEncodingLevel field is set.
   */
  @java.lang.Override
  public boolean hasBooleanEncodingLevel() {
    return ((bitField6_ & 0x00000100) != 0);
  }
  /**
   * <pre>
   * A non-negative level indicating how much we should try to fully encode
   * Integer variables as Boolean.
   * </pre>
   *
   * <code>optional int32 boolean_encoding_level = 107 [default = 1];</code>
   * @return The booleanEncodingLevel.
   */
  @java.lang.Override
  public int getBooleanEncodingLevel() {
    return booleanEncodingLevel_;
  }

  public static final int MAX_DOMAIN_SIZE_WHEN_ENCODING_EQ_NEQ_CONSTRAINTS_FIELD_NUMBER = 191;
  private int maxDomainSizeWhenEncodingEqNeqConstraints_ = 16;
  /**
   * <pre>
   * When loading a*x + b*y ==/!= c when x and y are both fully encoded.
   * The solver may decide to replace the linear equation by a set of clauses.
   * This is triggered if the sizes of the domains of x and y are below the
   * threshold.
   * </pre>
   *
   * <code>optional int32 max_domain_size_when_encoding_eq_neq_constraints = 191 [default = 16];</code>
   * @return Whether the maxDomainSizeWhenEncodingEqNeqConstraints field is set.
   */
  @java.lang.Override
  public boolean hasMaxDomainSizeWhenEncodingEqNeqConstraints() {
    return ((bitField6_ & 0x00000200) != 0);
  }
  /**
   * <pre>
   * When loading a*x + b*y ==/!= c when x and y are both fully encoded.
   * The solver may decide to replace the linear equation by a set of clauses.
   * This is triggered if the sizes of the domains of x and y are below the
   * threshold.
   * </pre>
   *
   * <code>optional int32 max_domain_size_when_encoding_eq_neq_constraints = 191 [default = 16];</code>
   * @return The maxDomainSizeWhenEncodingEqNeqConstraints.
   */
  @java.lang.Override
  public int getMaxDomainSizeWhenEncodingEqNeqConstraints() {
    return maxDomainSizeWhenEncodingEqNeqConstraints_;
  }

  public static final int MAX_NUM_CUTS_FIELD_NUMBER = 91;
  private int maxNumCuts_ = 10000;
  /**
   * <pre>
   * The limit on the number of cuts in our cut pool. When this is reached we do
   * not generate cuts anymore.
   *
   * TODO(user): We should probably remove this parameters, and just always
   * generate cuts but only keep the best n or something.
   * </pre>
   *
   * <code>optional int32 max_num_cuts = 91 [default = 10000];</code>
   * @return Whether the maxNumCuts field is set.
   */
  @java.lang.Override
  public boolean hasMaxNumCuts() {
    return ((bitField6_ & 0x00000400) != 0);
  }
  /**
   * <pre>
   * The limit on the number of cuts in our cut pool. When this is reached we do
   * not generate cuts anymore.
   *
   * TODO(user): We should probably remove this parameters, and just always
   * generate cuts but only keep the best n or something.
   * </pre>
   *
   * <code>optional int32 max_num_cuts = 91 [default = 10000];</code>
   * @return The maxNumCuts.
   */
  @java.lang.Override
  public int getMaxNumCuts() {
    return maxNumCuts_;
  }

  public static final int CUT_LEVEL_FIELD_NUMBER = 196;
  private int cutLevel_ = 1;
  /**
   * <pre>
   * Control the global cut effort. Zero will turn off all cut. For now we just
   * have one level. Note also that most cuts are only used at linearization
   * level &gt;= 2.
   * </pre>
   *
   * <code>optional int32 cut_level = 196 [default = 1];</code>
   * @return Whether the cutLevel field is set.
   */
  @java.lang.Override
  public boolean hasCutLevel() {
    return ((bitField6_ & 0x00000800) != 0);
  }
  /**
   * <pre>
   * Control the global cut effort. Zero will turn off all cut. For now we just
   * have one level. Note also that most cuts are only used at linearization
   * level &gt;= 2.
   * </pre>
   *
   * <code>optional int32 cut_level = 196 [default = 1];</code>
   * @return The cutLevel.
   */
  @java.lang.Override
  public int getCutLevel() {
    return cutLevel_;
  }

  public static final int ONLY_ADD_CUTS_AT_LEVEL_ZERO_FIELD_NUMBER = 92;
  private boolean onlyAddCutsAtLevelZero_ = false;
  /**
   * <pre>
   * For the cut that can be generated at any level, this control if we only
   * try to generate them at the root node.
   * </pre>
   *
   * <code>optional bool only_add_cuts_at_level_zero = 92 [default = false];</code>
   * @return Whether the onlyAddCutsAtLevelZero field is set.
   */
  @java.lang.Override
  public boolean hasOnlyAddCutsAtLevelZero() {
    return ((bitField6_ & 0x00001000) != 0);
  }
  /**
   * <pre>
   * For the cut that can be generated at any level, this control if we only
   * try to generate them at the root node.
   * </pre>
   *
   * <code>optional bool only_add_cuts_at_level_zero = 92 [default = false];</code>
   * @return The onlyAddCutsAtLevelZero.
   */
  @java.lang.Override
  public boolean getOnlyAddCutsAtLevelZero() {
    return onlyAddCutsAtLevelZero_;
  }

  public static final int ADD_OBJECTIVE_CUT_FIELD_NUMBER = 197;
  private boolean addObjectiveCut_ = false;
  /**
   * <pre>
   * When the LP objective is fractional, do we add the cut that forces the
   * linear objective expression to be greater or equal to this fractional value
   * rounded up? We can always do that since our objective is integer, and
   * combined with MIR heuristic to reduce the coefficient of such cut, it can
   * help.
   * </pre>
   *
   * <code>optional bool add_objective_cut = 197 [default = false];</code>
   * @return Whether the addObjectiveCut field is set.
   */
  @java.lang.Override
  public boolean hasAddObjectiveCut() {
    return ((bitField6_ & 0x00002000) != 0);
  }
  /**
   * <pre>
   * When the LP objective is fractional, do we add the cut that forces the
   * linear objective expression to be greater or equal to this fractional value
   * rounded up? We can always do that since our objective is integer, and
   * combined with MIR heuristic to reduce the coefficient of such cut, it can
   * help.
   * </pre>
   *
   * <code>optional bool add_objective_cut = 197 [default = false];</code>
   * @return The addObjectiveCut.
   */
  @java.lang.Override
  public boolean getAddObjectiveCut() {
    return addObjectiveCut_;
  }

  public static final int ADD_CG_CUTS_FIELD_NUMBER = 117;
  private boolean addCgCuts_ = true;
  /**
   * <pre>
   * Whether we generate and add Chvatal-Gomory cuts to the LP at root node.
   * Note that for now, this is not heavily tuned.
   * </pre>
   *
   * <code>optional bool add_cg_cuts = 117 [default = true];</code>
   * @return Whether the addCgCuts field is set.
   */
  @java.lang.Override
  public boolean hasAddCgCuts() {
    return ((bitField6_ & 0x00004000) != 0);
  }
  /**
   * <pre>
   * Whether we generate and add Chvatal-Gomory cuts to the LP at root node.
   * Note that for now, this is not heavily tuned.
   * </pre>
   *
   * <code>optional bool add_cg_cuts = 117 [default = true];</code>
   * @return The addCgCuts.
   */
  @java.lang.Override
  public boolean getAddCgCuts() {
    return addCgCuts_;
  }

  public static final int ADD_MIR_CUTS_FIELD_NUMBER = 120;
  private boolean addMirCuts_ = true;
  /**
   * <pre>
   * Whether we generate MIR cuts at root node.
   * Note that for now, this is not heavily tuned.
   * </pre>
   *
   * <code>optional bool add_mir_cuts = 120 [default = true];</code>
   * @return Whether the addMirCuts field is set.
   */
  @java.lang.Override
  public boolean hasAddMirCuts() {
    return ((bitField6_ & 0x00008000) != 0);
  }
  /**
   * <pre>
   * Whether we generate MIR cuts at root node.
   * Note that for now, this is not heavily tuned.
   * </pre>
   *
   * <code>optional bool add_mir_cuts = 120 [default = true];</code>
   * @return The addMirCuts.
   */
  @java.lang.Override
  public boolean getAddMirCuts() {
    return addMirCuts_;
  }

  public static final int ADD_ZERO_HALF_CUTS_FIELD_NUMBER = 169;
  private boolean addZeroHalfCuts_ = true;
  /**
   * <pre>
   * Whether we generate Zero-Half cuts at root node.
   * Note that for now, this is not heavily tuned.
   * </pre>
   *
   * <code>optional bool add_zero_half_cuts = 169 [default = true];</code>
   * @return Whether the addZeroHalfCuts field is set.
   */
  @java.lang.Override
  public boolean hasAddZeroHalfCuts() {
    return ((bitField6_ & 0x00010000) != 0);
  }
  /**
   * <pre>
   * Whether we generate Zero-Half cuts at root node.
   * Note that for now, this is not heavily tuned.
   * </pre>
   *
   * <code>optional bool add_zero_half_cuts = 169 [default = true];</code>
   * @return The addZeroHalfCuts.
   */
  @java.lang.Override
  public boolean getAddZeroHalfCuts() {
    return addZeroHalfCuts_;
  }

  public static final int ADD_CLIQUE_CUTS_FIELD_NUMBER = 172;
  private boolean addCliqueCuts_ = true;
  /**
   * <pre>
   * Whether we generate clique cuts from the binary implication graph. Note
   * that as the search goes on, this graph will contains new binary clauses
   * learned by the SAT engine.
   * </pre>
   *
   * <code>optional bool add_clique_cuts = 172 [default = true];</code>
   * @return Whether the addCliqueCuts field is set.
   */
  @java.lang.Override
  public boolean hasAddCliqueCuts() {
    return ((bitField6_ & 0x00020000) != 0);
  }
  /**
   * <pre>
   * Whether we generate clique cuts from the binary implication graph. Note
   * that as the search goes on, this graph will contains new binary clauses
   * learned by the SAT engine.
   * </pre>
   *
   * <code>optional bool add_clique_cuts = 172 [default = true];</code>
   * @return The addCliqueCuts.
   */
  @java.lang.Override
  public boolean getAddCliqueCuts() {
    return addCliqueCuts_;
  }

  public static final int ADD_RLT_CUTS_FIELD_NUMBER = 279;
  private boolean addRltCuts_ = true;
  /**
   * <pre>
   * Whether we generate RLT cuts. This is still experimental but can help on
   * binary problem with a lot of clauses of size 3.
   * </pre>
   *
   * <code>optional bool add_rlt_cuts = 279 [default = true];</code>
   * @return Whether the addRltCuts field is set.
   */
  @java.lang.Override
  public boolean hasAddRltCuts() {
    return ((bitField6_ & 0x00040000) != 0);
  }
  /**
   * <pre>
   * Whether we generate RLT cuts. This is still experimental but can help on
   * binary problem with a lot of clauses of size 3.
   * </pre>
   *
   * <code>optional bool add_rlt_cuts = 279 [default = true];</code>
   * @return The addRltCuts.
   */
  @java.lang.Override
  public boolean getAddRltCuts() {
    return addRltCuts_;
  }

  public static final int MAX_ALL_DIFF_CUT_SIZE_FIELD_NUMBER = 148;
  private int maxAllDiffCutSize_ = 64;
  /**
   * <pre>
   * Cut generator for all diffs can add too many cuts for large all_diff
   * constraints. This parameter restricts the large all_diff constraints to
   * have a cut generator.
   * </pre>
   *
   * <code>optional int32 max_all_diff_cut_size = 148 [default = 64];</code>
   * @return Whether the maxAllDiffCutSize field is set.
   */
  @java.lang.Override
  public boolean hasMaxAllDiffCutSize() {
    return ((bitField6_ & 0x00080000) != 0);
  }
  /**
   * <pre>
   * Cut generator for all diffs can add too many cuts for large all_diff
   * constraints. This parameter restricts the large all_diff constraints to
   * have a cut generator.
   * </pre>
   *
   * <code>optional int32 max_all_diff_cut_size = 148 [default = 64];</code>
   * @return The maxAllDiffCutSize.
   */
  @java.lang.Override
  public int getMaxAllDiffCutSize() {
    return maxAllDiffCutSize_;
  }

  public static final int ADD_LIN_MAX_CUTS_FIELD_NUMBER = 152;
  private boolean addLinMaxCuts_ = true;
  /**
   * <pre>
   * For the lin max constraints, generates the cuts described in "Strong
   * mixed-integer programming formulations for trained neural networks" by Ross
   * Anderson et. (https://arxiv.org/pdf/1811.01988.pdf)
   * </pre>
   *
   * <code>optional bool add_lin_max_cuts = 152 [default = true];</code>
   * @return Whether the addLinMaxCuts field is set.
   */
  @java.lang.Override
  public boolean hasAddLinMaxCuts() {
    return ((bitField6_ & 0x00100000) != 0);
  }
  /**
   * <pre>
   * For the lin max constraints, generates the cuts described in "Strong
   * mixed-integer programming formulations for trained neural networks" by Ross
   * Anderson et. (https://arxiv.org/pdf/1811.01988.pdf)
   * </pre>
   *
   * <code>optional bool add_lin_max_cuts = 152 [default = true];</code>
   * @return The addLinMaxCuts.
   */
  @java.lang.Override
  public boolean getAddLinMaxCuts() {
    return addLinMaxCuts_;
  }

  public static final int MAX_INTEGER_ROUNDING_SCALING_FIELD_NUMBER = 119;
  private int maxIntegerRoundingScaling_ = 600;
  /**
   * <pre>
   * In the integer rounding procedure used for MIR and Gomory cut, the maximum
   * "scaling" we use (must be positive). The lower this is, the lower the
   * integer coefficients of the cut will be. Note that cut generated by lower
   * values are not necessarily worse than cut generated by larger value. There
   * is no strict dominance relationship.
   *
   * Setting this to 2 result in the "strong fractional rouding" of Letchford
   * and Lodi.
   * </pre>
   *
   * <code>optional int32 max_integer_rounding_scaling = 119 [default = 600];</code>
   * @return Whether the maxIntegerRoundingScaling field is set.
   */
  @java.lang.Override
  public boolean hasMaxIntegerRoundingScaling() {
    return ((bitField6_ & 0x00200000) != 0);
  }
  /**
   * <pre>
   * In the integer rounding procedure used for MIR and Gomory cut, the maximum
   * "scaling" we use (must be positive). The lower this is, the lower the
   * integer coefficients of the cut will be. Note that cut generated by lower
   * values are not necessarily worse than cut generated by larger value. There
   * is no strict dominance relationship.
   *
   * Setting this to 2 result in the "strong fractional rouding" of Letchford
   * and Lodi.
   * </pre>
   *
   * <code>optional int32 max_integer_rounding_scaling = 119 [default = 600];</code>
   * @return The maxIntegerRoundingScaling.
   */
  @java.lang.Override
  public int getMaxIntegerRoundingScaling() {
    return maxIntegerRoundingScaling_;
  }

  public static final int ADD_LP_CONSTRAINTS_LAZILY_FIELD_NUMBER = 112;
  private boolean addLpConstraintsLazily_ = true;
  /**
   * <pre>
   * If true, we start by an empty LP, and only add constraints not satisfied
   * by the current LP solution batch by batch. A constraint that is only added
   * like this is known as a "lazy" constraint in the literature, except that we
   * currently consider all constraints as lazy here.
   * </pre>
   *
   * <code>optional bool add_lp_constraints_lazily = 112 [default = true];</code>
   * @return Whether the addLpConstraintsLazily field is set.
   */
  @java.lang.Override
  public boolean hasAddLpConstraintsLazily() {
    return ((bitField6_ & 0x00400000) != 0);
  }
  /**
   * <pre>
   * If true, we start by an empty LP, and only add constraints not satisfied
   * by the current LP solution batch by batch. A constraint that is only added
   * like this is known as a "lazy" constraint in the literature, except that we
   * currently consider all constraints as lazy here.
   * </pre>
   *
   * <code>optional bool add_lp_constraints_lazily = 112 [default = true];</code>
   * @return The addLpConstraintsLazily.
   */
  @java.lang.Override
  public boolean getAddLpConstraintsLazily() {
    return addLpConstraintsLazily_;
  }

  public static final int ROOT_LP_ITERATIONS_FIELD_NUMBER = 227;
  private int rootLpIterations_ = 2000;
  /**
   * <pre>
   * Even at the root node, we do not want to spend too much time on the LP if
   * it is "difficult". So we solve it in "chunks" of that many iterations. The
   * solve will be continued down in the tree or the next time we go back to the
   * root node.
   * </pre>
   *
   * <code>optional int32 root_lp_iterations = 227 [default = 2000];</code>
   * @return Whether the rootLpIterations field is set.
   */
  @java.lang.Override
  public boolean hasRootLpIterations() {
    return ((bitField6_ & 0x00800000) != 0);
  }
  /**
   * <pre>
   * Even at the root node, we do not want to spend too much time on the LP if
   * it is "difficult". So we solve it in "chunks" of that many iterations. The
   * solve will be continued down in the tree or the next time we go back to the
   * root node.
   * </pre>
   *
   * <code>optional int32 root_lp_iterations = 227 [default = 2000];</code>
   * @return The rootLpIterations.
   */
  @java.lang.Override
  public int getRootLpIterations() {
    return rootLpIterations_;
  }

  public static final int MIN_ORTHOGONALITY_FOR_LP_CONSTRAINTS_FIELD_NUMBER = 115;
  private double minOrthogonalityForLpConstraints_ = 0.05D;
  /**
   * <pre>
   * While adding constraints, skip the constraints which have orthogonality
   * less than 'min_orthogonality_for_lp_constraints' with already added
   * constraints during current call. Orthogonality is defined as 1 -
   * cosine(vector angle between constraints). A value of zero disable this
   * feature.
   * </pre>
   *
   * <code>optional double min_orthogonality_for_lp_constraints = 115 [default = 0.05];</code>
   * @return Whether the minOrthogonalityForLpConstraints field is set.
   */
  @java.lang.Override
  public boolean hasMinOrthogonalityForLpConstraints() {
    return ((bitField6_ & 0x01000000) != 0);
  }
  /**
   * <pre>
   * While adding constraints, skip the constraints which have orthogonality
   * less than 'min_orthogonality_for_lp_constraints' with already added
   * constraints during current call. Orthogonality is defined as 1 -
   * cosine(vector angle between constraints). A value of zero disable this
   * feature.
   * </pre>
   *
   * <code>optional double min_orthogonality_for_lp_constraints = 115 [default = 0.05];</code>
   * @return The minOrthogonalityForLpConstraints.
   */
  @java.lang.Override
  public double getMinOrthogonalityForLpConstraints() {
    return minOrthogonalityForLpConstraints_;
  }

  public static final int MAX_CUT_ROUNDS_AT_LEVEL_ZERO_FIELD_NUMBER = 154;
  private int maxCutRoundsAtLevelZero_ = 1;
  /**
   * <pre>
   * Max number of time we perform cut generation and resolve the LP at level 0.
   * </pre>
   *
   * <code>optional int32 max_cut_rounds_at_level_zero = 154 [default = 1];</code>
   * @return Whether the maxCutRoundsAtLevelZero field is set.
   */
  @java.lang.Override
  public boolean hasMaxCutRoundsAtLevelZero() {
    return ((bitField6_ & 0x02000000) != 0);
  }
  /**
   * <pre>
   * Max number of time we perform cut generation and resolve the LP at level 0.
   * </pre>
   *
   * <code>optional int32 max_cut_rounds_at_level_zero = 154 [default = 1];</code>
   * @return The maxCutRoundsAtLevelZero.
   */
  @java.lang.Override
  public int getMaxCutRoundsAtLevelZero() {
    return maxCutRoundsAtLevelZero_;
  }

  public static final int MAX_CONSECUTIVE_INACTIVE_COUNT_FIELD_NUMBER = 121;
  private int maxConsecutiveInactiveCount_ = 100;
  /**
   * <pre>
   * If a constraint/cut in LP is not active for that many consecutive OPTIMAL
   * solves, remove it from the LP. Note that it might be added again later if
   * it become violated by the current LP solution.
   * </pre>
   *
   * <code>optional int32 max_consecutive_inactive_count = 121 [default = 100];</code>
   * @return Whether the maxConsecutiveInactiveCount field is set.
   */
  @java.lang.Override
  public boolean hasMaxConsecutiveInactiveCount() {
    return ((bitField6_ & 0x04000000) != 0);
  }
  /**
   * <pre>
   * If a constraint/cut in LP is not active for that many consecutive OPTIMAL
   * solves, remove it from the LP. Note that it might be added again later if
   * it become violated by the current LP solution.
   * </pre>
   *
   * <code>optional int32 max_consecutive_inactive_count = 121 [default = 100];</code>
   * @return The maxConsecutiveInactiveCount.
   */
  @java.lang.Override
  public int getMaxConsecutiveInactiveCount() {
    return maxConsecutiveInactiveCount_;
  }

  public static final int CUT_MAX_ACTIVE_COUNT_VALUE_FIELD_NUMBER = 155;
  private double cutMaxActiveCountValue_ = 10000000000D;
  /**
   * <pre>
   * These parameters are similar to sat clause management activity parameters.
   * They are effective only if the number of generated cuts exceed the storage
   * limit. Default values are based on a few experiments on miplib instances.
   * </pre>
   *
   * <code>optional double cut_max_active_count_value = 155 [default = 10000000000];</code>
   * @return Whether the cutMaxActiveCountValue field is set.
   */
  @java.lang.Override
  public boolean hasCutMaxActiveCountValue() {
    return ((bitField6_ & 0x08000000) != 0);
  }
  /**
   * <pre>
   * These parameters are similar to sat clause management activity parameters.
   * They are effective only if the number of generated cuts exceed the storage
   * limit. Default values are based on a few experiments on miplib instances.
   * </pre>
   *
   * <code>optional double cut_max_active_count_value = 155 [default = 10000000000];</code>
   * @return The cutMaxActiveCountValue.
   */
  @java.lang.Override
  public double getCutMaxActiveCountValue() {
    return cutMaxActiveCountValue_;
  }

  public static final int CUT_ACTIVE_COUNT_DECAY_FIELD_NUMBER = 156;
  private double cutActiveCountDecay_ = 0.8D;
  /**
   * <code>optional double cut_active_count_decay = 156 [default = 0.8];</code>
   * @return Whether the cutActiveCountDecay field is set.
   */
  @java.lang.Override
  public boolean hasCutActiveCountDecay() {
    return ((bitField6_ & 0x10000000) != 0);
  }
  /**
   * <code>optional double cut_active_count_decay = 156 [default = 0.8];</code>
   * @return The cutActiveCountDecay.
   */
  @java.lang.Override
  public double getCutActiveCountDecay() {
    return cutActiveCountDecay_;
  }

  public static final int CUT_CLEANUP_TARGET_FIELD_NUMBER = 157;
  private int cutCleanupTarget_ = 1000;
  /**
   * <pre>
   * Target number of constraints to remove during cleanup.
   * </pre>
   *
   * <code>optional int32 cut_cleanup_target = 157 [default = 1000];</code>
   * @return Whether the cutCleanupTarget field is set.
   */
  @java.lang.Override
  public boolean hasCutCleanupTarget() {
    return ((bitField6_ & 0x20000000) != 0);
  }
  /**
   * <pre>
   * Target number of constraints to remove during cleanup.
   * </pre>
   *
   * <code>optional int32 cut_cleanup_target = 157 [default = 1000];</code>
   * @return The cutCleanupTarget.
   */
  @java.lang.Override
  public int getCutCleanupTarget() {
    return cutCleanupTarget_;
  }

  public static final int NEW_CONSTRAINTS_BATCH_SIZE_FIELD_NUMBER = 122;
  private int newConstraintsBatchSize_ = 50;
  /**
   * <pre>
   * Add that many lazy constraints (or cuts) at once in the LP. Note that at
   * the beginning of the solve, we do add more than this.
   * </pre>
   *
   * <code>optional int32 new_constraints_batch_size = 122 [default = 50];</code>
   * @return Whether the newConstraintsBatchSize field is set.
   */
  @java.lang.Override
  public boolean hasNewConstraintsBatchSize() {
    return ((bitField6_ & 0x40000000) != 0);
  }
  /**
   * <pre>
   * Add that many lazy constraints (or cuts) at once in the LP. Note that at
   * the beginning of the solve, we do add more than this.
   * </pre>
   *
   * <code>optional int32 new_constraints_batch_size = 122 [default = 50];</code>
   * @return The newConstraintsBatchSize.
   */
  @java.lang.Override
  public int getNewConstraintsBatchSize() {
    return newConstraintsBatchSize_;
  }

  public static final int EXPLOIT_INTEGER_LP_SOLUTION_FIELD_NUMBER = 94;
  private boolean exploitIntegerLpSolution_ = true;
  /**
   * <pre>
   * If true and the Lp relaxation of the problem has an integer optimal
   * solution, try to exploit it. Note that since the LP relaxation may not
   * contain all the constraints, such a solution is not necessarily a solution
   * of the full problem.
   * </pre>
   *
   * <code>optional bool exploit_integer_lp_solution = 94 [default = true];</code>
   * @return Whether the exploitIntegerLpSolution field is set.
   */
  @java.lang.Override
  public boolean hasExploitIntegerLpSolution() {
    return ((bitField6_ & 0x80000000) != 0);
  }
  /**
   * <pre>
   * If true and the Lp relaxation of the problem has an integer optimal
   * solution, try to exploit it. Note that since the LP relaxation may not
   * contain all the constraints, such a solution is not necessarily a solution
   * of the full problem.
   * </pre>
   *
   * <code>optional bool exploit_integer_lp_solution = 94 [default = true];</code>
   * @return The exploitIntegerLpSolution.
   */
  @java.lang.Override
  public boolean getExploitIntegerLpSolution() {
    return exploitIntegerLpSolution_;
  }

  public static final int EXPLOIT_ALL_LP_SOLUTION_FIELD_NUMBER = 116;
  private boolean exploitAllLpSolution_ = true;
  /**
   * <pre>
   * If true and the Lp relaxation of the problem has a solution, try to exploit
   * it. This is same as above except in this case the lp solution might not be
   * an integer solution.
   * </pre>
   *
   * <code>optional bool exploit_all_lp_solution = 116 [default = true];</code>
   * @return Whether the exploitAllLpSolution field is set.
   */
  @java.lang.Override
  public boolean hasExploitAllLpSolution() {
    return ((bitField7_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * If true and the Lp relaxation of the problem has a solution, try to exploit
   * it. This is same as above except in this case the lp solution might not be
   * an integer solution.
   * </pre>
   *
   * <code>optional bool exploit_all_lp_solution = 116 [default = true];</code>
   * @return The exploitAllLpSolution.
   */
  @java.lang.Override
  public boolean getExploitAllLpSolution() {
    return exploitAllLpSolution_;
  }

  public static final int EXPLOIT_BEST_SOLUTION_FIELD_NUMBER = 130;
  private boolean exploitBestSolution_ = false;
  /**
   * <pre>
   * When branching on a variable, follow the last best solution value.
   * </pre>
   *
   * <code>optional bool exploit_best_solution = 130 [default = false];</code>
   * @return Whether the exploitBestSolution field is set.
   */
  @java.lang.Override
  public boolean hasExploitBestSolution() {
    return ((bitField7_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * When branching on a variable, follow the last best solution value.
   * </pre>
   *
   * <code>optional bool exploit_best_solution = 130 [default = false];</code>
   * @return The exploitBestSolution.
   */
  @java.lang.Override
  public boolean getExploitBestSolution() {
    return exploitBestSolution_;
  }

  public static final int EXPLOIT_RELAXATION_SOLUTION_FIELD_NUMBER = 161;
  private boolean exploitRelaxationSolution_ = false;
  /**
   * <pre>
   * When branching on a variable, follow the last best relaxation solution
   * value. We use the relaxation with the tightest bound on the objective as
   * the best relaxation solution.
   * </pre>
   *
   * <code>optional bool exploit_relaxation_solution = 161 [default = false];</code>
   * @return Whether the exploitRelaxationSolution field is set.
   */
  @java.lang.Override
  public boolean hasExploitRelaxationSolution() {
    return ((bitField7_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * When branching on a variable, follow the last best relaxation solution
   * value. We use the relaxation with the tightest bound on the objective as
   * the best relaxation solution.
   * </pre>
   *
   * <code>optional bool exploit_relaxation_solution = 161 [default = false];</code>
   * @return The exploitRelaxationSolution.
   */
  @java.lang.Override
  public boolean getExploitRelaxationSolution() {
    return exploitRelaxationSolution_;
  }

  public static final int EXPLOIT_OBJECTIVE_FIELD_NUMBER = 131;
  private boolean exploitObjective_ = true;
  /**
   * <pre>
   * When branching an a variable that directly affect the objective,
   * branch on the value that lead to the best objective first.
   * </pre>
   *
   * <code>optional bool exploit_objective = 131 [default = true];</code>
   * @return Whether the exploitObjective field is set.
   */
  @java.lang.Override
  public boolean hasExploitObjective() {
    return ((bitField7_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * When branching an a variable that directly affect the objective,
   * branch on the value that lead to the best objective first.
   * </pre>
   *
   * <code>optional bool exploit_objective = 131 [default = true];</code>
   * @return The exploitObjective.
   */
  @java.lang.Override
  public boolean getExploitObjective() {
    return exploitObjective_;
  }

  public static final int DETECT_LINEARIZED_PRODUCT_FIELD_NUMBER = 277;
  private boolean detectLinearizedProduct_ = false;
  /**
   * <pre>
   * Infer products of Boolean or of Boolean time IntegerVariable from the
   * linear constrainst in the problem. This can be used in some cuts, altough
   * for now we don't really exploit it.
   * </pre>
   *
   * <code>optional bool detect_linearized_product = 277 [default = false];</code>
   * @return Whether the detectLinearizedProduct field is set.
   */
  @java.lang.Override
  public boolean hasDetectLinearizedProduct() {
    return ((bitField7_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * Infer products of Boolean or of Boolean time IntegerVariable from the
   * linear constrainst in the problem. This can be used in some cuts, altough
   * for now we don't really exploit it.
   * </pre>
   *
   * <code>optional bool detect_linearized_product = 277 [default = false];</code>
   * @return The detectLinearizedProduct.
   */
  @java.lang.Override
  public boolean getDetectLinearizedProduct() {
    return detectLinearizedProduct_;
  }

  public static final int MIP_MAX_BOUND_FIELD_NUMBER = 124;
  private double mipMaxBound_ = 10000000D;
  /**
   * <pre>
   * We need to bound the maximum magnitude of the variables for CP-SAT, and
   * that is the bound we use. If the MIP model expect larger variable value in
   * the solution, then the converted model will likely not be relevant.
   * </pre>
   *
   * <code>optional double mip_max_bound = 124 [default = 10000000];</code>
   * @return Whether the mipMaxBound field is set.
   */
  @java.lang.Override
  public boolean hasMipMaxBound() {
    return ((bitField7_ & 0x00000020) != 0);
  }
  /**
   * <pre>
   * We need to bound the maximum magnitude of the variables for CP-SAT, and
   * that is the bound we use. If the MIP model expect larger variable value in
   * the solution, then the converted model will likely not be relevant.
   * </pre>
   *
   * <code>optional double mip_max_bound = 124 [default = 10000000];</code>
   * @return The mipMaxBound.
   */
  @java.lang.Override
  public double getMipMaxBound() {
    return mipMaxBound_;
  }

  public static final int MIP_VAR_SCALING_FIELD_NUMBER = 125;
  private double mipVarScaling_ = 1D;
  /**
   * <pre>
   * All continuous variable of the problem will be multiplied by this factor.
   * By default, we don't do any variable scaling and rely on the MIP model to
   * specify continuous variable domain with the wanted precision.
   * </pre>
   *
   * <code>optional double mip_var_scaling = 125 [default = 1];</code>
   * @return Whether the mipVarScaling field is set.
   */
  @java.lang.Override
  public boolean hasMipVarScaling() {
    return ((bitField7_ & 0x00000040) != 0);
  }
  /**
   * <pre>
   * All continuous variable of the problem will be multiplied by this factor.
   * By default, we don't do any variable scaling and rely on the MIP model to
   * specify continuous variable domain with the wanted precision.
   * </pre>
   *
   * <code>optional double mip_var_scaling = 125 [default = 1];</code>
   * @return The mipVarScaling.
   */
  @java.lang.Override
  public double getMipVarScaling() {
    return mipVarScaling_;
  }

  public static final int MIP_SCALE_LARGE_DOMAIN_FIELD_NUMBER = 225;
  private boolean mipScaleLargeDomain_ = false;
  /**
   * <pre>
   * If this is false, then mip_var_scaling is only applied to variables with
   * "small" domain. If it is true, we scale all floating point variable
   * independenlty of their domain.
   * </pre>
   *
   * <code>optional bool mip_scale_large_domain = 225 [default = false];</code>
   * @return Whether the mipScaleLargeDomain field is set.
   */
  @java.lang.Override
  public boolean hasMipScaleLargeDomain() {
    return ((bitField7_ & 0x00000080) != 0);
  }
  /**
   * <pre>
   * If this is false, then mip_var_scaling is only applied to variables with
   * "small" domain. If it is true, we scale all floating point variable
   * independenlty of their domain.
   * </pre>
   *
   * <code>optional bool mip_scale_large_domain = 225 [default = false];</code>
   * @return The mipScaleLargeDomain.
   */
  @java.lang.Override
  public boolean getMipScaleLargeDomain() {
    return mipScaleLargeDomain_;
  }

  public static final int MIP_AUTOMATICALLY_SCALE_VARIABLES_FIELD_NUMBER = 166;
  private boolean mipAutomaticallyScaleVariables_ = true;
  /**
   * <pre>
   * If true, some continuous variable might be automatically scaled. For now,
   * this is only the case where we detect that a variable is actually an
   * integer multiple of a constant. For instance, variables of the form k * 0.5
   * are quite frequent, and if we detect this, we will scale such variable
   * domain by 2 to make it implied integer.
   * </pre>
   *
   * <code>optional bool mip_automatically_scale_variables = 166 [default = true];</code>
   * @return Whether the mipAutomaticallyScaleVariables field is set.
   */
  @java.lang.Override
  public boolean hasMipAutomaticallyScaleVariables() {
    return ((bitField7_ & 0x00000100) != 0);
  }
  /**
   * <pre>
   * If true, some continuous variable might be automatically scaled. For now,
   * this is only the case where we detect that a variable is actually an
   * integer multiple of a constant. For instance, variables of the form k * 0.5
   * are quite frequent, and if we detect this, we will scale such variable
   * domain by 2 to make it implied integer.
   * </pre>
   *
   * <code>optional bool mip_automatically_scale_variables = 166 [default = true];</code>
   * @return The mipAutomaticallyScaleVariables.
   */
  @java.lang.Override
  public boolean getMipAutomaticallyScaleVariables() {
    return mipAutomaticallyScaleVariables_;
  }

  public static final int ONLY_SOLVE_IP_FIELD_NUMBER = 222;
  private boolean onlySolveIp_ = false;
  /**
   * <pre>
   * If one try to solve a MIP model with CP-SAT, because we assume all variable
   * to be integer after scaling, we will not necessarily have the correct
   * optimal. Note however that all feasible solutions are valid since we will
   * just solve a more restricted version of the original problem.
   *
   * This parameters is here to prevent user to think the solution is optimal
   * when it might not be. One will need to manually set this to false to solve
   * a MIP model where the optimal might be different.
   *
   * Note that this is tested after some MIP presolve steps, so even if not
   * all original variable are integer, we might end up with a pure IP after
   * presolve and after implied integer detection.
   * </pre>
   *
   * <code>optional bool only_solve_ip = 222 [default = false];</code>
   * @return Whether the onlySolveIp field is set.
   */
  @java.lang.Override
  public boolean hasOnlySolveIp() {
    return ((bitField7_ & 0x00000200) != 0);
  }
  /**
   * <pre>
   * If one try to solve a MIP model with CP-SAT, because we assume all variable
   * to be integer after scaling, we will not necessarily have the correct
   * optimal. Note however that all feasible solutions are valid since we will
   * just solve a more restricted version of the original problem.
   *
   * This parameters is here to prevent user to think the solution is optimal
   * when it might not be. One will need to manually set this to false to solve
   * a MIP model where the optimal might be different.
   *
   * Note that this is tested after some MIP presolve steps, so even if not
   * all original variable are integer, we might end up with a pure IP after
   * presolve and after implied integer detection.
   * </pre>
   *
   * <code>optional bool only_solve_ip = 222 [default = false];</code>
   * @return The onlySolveIp.
   */
  @java.lang.Override
  public boolean getOnlySolveIp() {
    return onlySolveIp_;
  }

  public static final int MIP_WANTED_PRECISION_FIELD_NUMBER = 126;
  private double mipWantedPrecision_ = 1e-06D;
  /**
   * <pre>
   * When scaling constraint with double coefficients to integer coefficients,
   * we will multiply by a power of 2 and round the coefficients. We will choose
   * the lowest power such that we have no potential overflow (see
   * mip_max_activity_exponent) and the worst case constraint activity error
   * does not exceed this threshold.
   *
   * Note that we also detect constraint with rational coefficients and scale
   * them accordingly when it seems better instead of using a power of 2.
   *
   * We also relax all constraint bounds by this absolute value. For pure
   * integer constraint, if this value if lower than one, this will not change
   * anything. However it is needed when scaling MIP problems.
   *
   * If we manage to scale a constraint correctly, the maximum error we can make
   * will be twice this value (once for the scaling error and once for the
   * relaxed bounds). If we are not able to scale that well, we will display
   * that fact but still scale as best as we can.
   * </pre>
   *
   * <code>optional double mip_wanted_precision = 126 [default = 1e-06];</code>
   * @return Whether the mipWantedPrecision field is set.
   */
  @java.lang.Override
  public boolean hasMipWantedPrecision() {
    return ((bitField7_ & 0x00000400) != 0);
  }
  /**
   * <pre>
   * When scaling constraint with double coefficients to integer coefficients,
   * we will multiply by a power of 2 and round the coefficients. We will choose
   * the lowest power such that we have no potential overflow (see
   * mip_max_activity_exponent) and the worst case constraint activity error
   * does not exceed this threshold.
   *
   * Note that we also detect constraint with rational coefficients and scale
   * them accordingly when it seems better instead of using a power of 2.
   *
   * We also relax all constraint bounds by this absolute value. For pure
   * integer constraint, if this value if lower than one, this will not change
   * anything. However it is needed when scaling MIP problems.
   *
   * If we manage to scale a constraint correctly, the maximum error we can make
   * will be twice this value (once for the scaling error and once for the
   * relaxed bounds). If we are not able to scale that well, we will display
   * that fact but still scale as best as we can.
   * </pre>
   *
   * <code>optional double mip_wanted_precision = 126 [default = 1e-06];</code>
   * @return The mipWantedPrecision.
   */
  @java.lang.Override
  public double getMipWantedPrecision() {
    return mipWantedPrecision_;
  }

  public static final int MIP_MAX_ACTIVITY_EXPONENT_FIELD_NUMBER = 127;
  private int mipMaxActivityExponent_ = 53;
  /**
   * <pre>
   * To avoid integer overflow, we always force the maximum possible constraint
   * activity (and objective value) according to the initial variable domain to
   * be smaller than 2 to this given power. Because of this, we cannot always
   * reach the "mip_wanted_precision" parameter above.
   *
   * This can go as high as 62, but some internal algo currently abort early if
   * they might run into integer overflow, so it is better to keep it a bit
   * lower than this.
   * </pre>
   *
   * <code>optional int32 mip_max_activity_exponent = 127 [default = 53];</code>
   * @return Whether the mipMaxActivityExponent field is set.
   */
  @java.lang.Override
  public boolean hasMipMaxActivityExponent() {
    return ((bitField7_ & 0x00000800) != 0);
  }
  /**
   * <pre>
   * To avoid integer overflow, we always force the maximum possible constraint
   * activity (and objective value) according to the initial variable domain to
   * be smaller than 2 to this given power. Because of this, we cannot always
   * reach the "mip_wanted_precision" parameter above.
   *
   * This can go as high as 62, but some internal algo currently abort early if
   * they might run into integer overflow, so it is better to keep it a bit
   * lower than this.
   * </pre>
   *
   * <code>optional int32 mip_max_activity_exponent = 127 [default = 53];</code>
   * @return The mipMaxActivityExponent.
   */
  @java.lang.Override
  public int getMipMaxActivityExponent() {
    return mipMaxActivityExponent_;
  }

  public static final int MIP_CHECK_PRECISION_FIELD_NUMBER = 128;
  private double mipCheckPrecision_ = 0.0001D;
  /**
   * <pre>
   * As explained in mip_precision and mip_max_activity_exponent, we cannot
   * always reach the wanted precision during scaling. We use this threshold to
   * enphasize in the logs when the precision seems bad.
   * </pre>
   *
   * <code>optional double mip_check_precision = 128 [default = 0.0001];</code>
   * @return Whether the mipCheckPrecision field is set.
   */
  @java.lang.Override
  public boolean hasMipCheckPrecision() {
    return ((bitField7_ & 0x00001000) != 0);
  }
  /**
   * <pre>
   * As explained in mip_precision and mip_max_activity_exponent, we cannot
   * always reach the wanted precision during scaling. We use this threshold to
   * enphasize in the logs when the precision seems bad.
   * </pre>
   *
   * <code>optional double mip_check_precision = 128 [default = 0.0001];</code>
   * @return The mipCheckPrecision.
   */
  @java.lang.Override
  public double getMipCheckPrecision() {
    return mipCheckPrecision_;
  }

  public static final int MIP_COMPUTE_TRUE_OBJECTIVE_BOUND_FIELD_NUMBER = 198;
  private boolean mipComputeTrueObjectiveBound_ = true;
  /**
   * <pre>
   * Even if we make big error when scaling the objective, we can always derive
   * a correct lower bound on the original objective by using the exact lower
   * bound on the scaled integer version of the objective. This should be fast,
   * but if you don't care about having a precise lower bound, you can turn it
   * off.
   * </pre>
   *
   * <code>optional bool mip_compute_true_objective_bound = 198 [default = true];</code>
   * @return Whether the mipComputeTrueObjectiveBound field is set.
   */
  @java.lang.Override
  public boolean hasMipComputeTrueObjectiveBound() {
    return ((bitField7_ & 0x00002000) != 0);
  }
  /**
   * <pre>
   * Even if we make big error when scaling the objective, we can always derive
   * a correct lower bound on the original objective by using the exact lower
   * bound on the scaled integer version of the objective. This should be fast,
   * but if you don't care about having a precise lower bound, you can turn it
   * off.
   * </pre>
   *
   * <code>optional bool mip_compute_true_objective_bound = 198 [default = true];</code>
   * @return The mipComputeTrueObjectiveBound.
   */
  @java.lang.Override
  public boolean getMipComputeTrueObjectiveBound() {
    return mipComputeTrueObjectiveBound_;
  }

  public static final int MIP_MAX_VALID_MAGNITUDE_FIELD_NUMBER = 199;
  private double mipMaxValidMagnitude_ = 1e+20D;
  /**
   * <pre>
   * Any finite values in the input MIP must be below this threshold, otherwise
   * the model will be reported invalid. This is needed to avoid floating point
   * overflow when evaluating bounds * coeff for instance. We are a bit more
   * defensive, but in practice, users shouldn't use super large values in a
   * MIP.
   * </pre>
   *
   * <code>optional double mip_max_valid_magnitude = 199 [default = 1e+20];</code>
   * @return Whether the mipMaxValidMagnitude field is set.
   */
  @java.lang.Override
  public boolean hasMipMaxValidMagnitude() {
    return ((bitField7_ & 0x00004000) != 0);
  }
  /**
   * <pre>
   * Any finite values in the input MIP must be below this threshold, otherwise
   * the model will be reported invalid. This is needed to avoid floating point
   * overflow when evaluating bounds * coeff for instance. We are a bit more
   * defensive, but in practice, users shouldn't use super large values in a
   * MIP.
   * </pre>
   *
   * <code>optional double mip_max_valid_magnitude = 199 [default = 1e+20];</code>
   * @return The mipMaxValidMagnitude.
   */
  @java.lang.Override
  public double getMipMaxValidMagnitude() {
    return mipMaxValidMagnitude_;
  }

  public static final int MIP_TREAT_HIGH_MAGNITUDE_BOUNDS_AS_INFINITY_FIELD_NUMBER = 278;
  private boolean mipTreatHighMagnitudeBoundsAsInfinity_ = false;
  /**
   * <pre>
   * By default, any variable/constraint bound with a finite value and a
   * magnitude greater than the mip_max_valid_magnitude will result with a
   * invalid model. This flags change the behavior such that such bounds are
   * silently transformed to +∞ or -∞.
   *
   * It is recommended to keep it at false, and create valid bounds.
   * </pre>
   *
   * <code>optional bool mip_treat_high_magnitude_bounds_as_infinity = 278 [default = false];</code>
   * @return Whether the mipTreatHighMagnitudeBoundsAsInfinity field is set.
   */
  @java.lang.Override
  public boolean hasMipTreatHighMagnitudeBoundsAsInfinity() {
    return ((bitField7_ & 0x00008000) != 0);
  }
  /**
   * <pre>
   * By default, any variable/constraint bound with a finite value and a
   * magnitude greater than the mip_max_valid_magnitude will result with a
   * invalid model. This flags change the behavior such that such bounds are
   * silently transformed to +∞ or -∞.
   *
   * It is recommended to keep it at false, and create valid bounds.
   * </pre>
   *
   * <code>optional bool mip_treat_high_magnitude_bounds_as_infinity = 278 [default = false];</code>
   * @return The mipTreatHighMagnitudeBoundsAsInfinity.
   */
  @java.lang.Override
  public boolean getMipTreatHighMagnitudeBoundsAsInfinity() {
    return mipTreatHighMagnitudeBoundsAsInfinity_;
  }

  public static final int MIP_DROP_TOLERANCE_FIELD_NUMBER = 232;
  private double mipDropTolerance_ = 1e-16D;
  /**
   * <pre>
   * Any value in the input mip with a magnitude lower than this will be set to
   * zero. This is to avoid some issue in LP presolving.
   * </pre>
   *
   * <code>optional double mip_drop_tolerance = 232 [default = 1e-16];</code>
   * @return Whether the mipDropTolerance field is set.
   */
  @java.lang.Override
  public boolean hasMipDropTolerance() {
    return ((bitField7_ & 0x00010000) != 0);
  }
  /**
   * <pre>
   * Any value in the input mip with a magnitude lower than this will be set to
   * zero. This is to avoid some issue in LP presolving.
   * </pre>
   *
   * <code>optional double mip_drop_tolerance = 232 [default = 1e-16];</code>
   * @return The mipDropTolerance.
   */
  @java.lang.Override
  public double getMipDropTolerance() {
    return mipDropTolerance_;
  }

  public static final int MIP_PRESOLVE_LEVEL_FIELD_NUMBER = 261;
  private int mipPresolveLevel_ = 2;
  /**
   * <pre>
   * When solving a MIP, we do some basic floating point presolving before
   * scaling the problem to integer to be handled by CP-SAT. This control how
   * much of that presolve we do. It can help to better scale floating point
   * model, but it is not always behaving nicely.
   * </pre>
   *
   * <code>optional int32 mip_presolve_level = 261 [default = 2];</code>
   * @return Whether the mipPresolveLevel field is set.
   */
  @java.lang.Override
  public boolean hasMipPresolveLevel() {
    return ((bitField7_ & 0x00020000) != 0);
  }
  /**
   * <pre>
   * When solving a MIP, we do some basic floating point presolving before
   * scaling the problem to integer to be handled by CP-SAT. This control how
   * much of that presolve we do. It can help to better scale floating point
   * model, but it is not always behaving nicely.
   * </pre>
   *
   * <code>optional int32 mip_presolve_level = 261 [default = 2];</code>
   * @return The mipPresolveLevel.
   */
  @java.lang.Override
  public int getMipPresolveLevel() {
    return mipPresolveLevel_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeEnum(1, preferredVariableOrder_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeEnum(2, initialPolarity_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeEnum(4, minimizationAlgorithm_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeInt32(11, clauseCleanupPeriod_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeInt32(13, clauseCleanupTarget_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      output.writeDouble(15, variableActivityDecay_);
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      output.writeDouble(16, maxVariableActivityValue_);
    }
    if (((bitField0_ & 0x04000000) != 0)) {
      output.writeDouble(17, clauseActivityDecay_);
    }
    if (((bitField0_ & 0x08000000) != 0)) {
      output.writeDouble(18, maxClauseActivityValue_);
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      output.writeDouble(22, glucoseMaxDecay_);
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      output.writeDouble(23, glucoseDecayIncrement_);
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      output.writeInt32(24, glucoseDecayIncrementPeriod_);
    }
    if (((bitField0_ & 0x20000000) != 0)) {
      output.writeInt32(30, restartPeriod_);
    }
    if (((bitField1_ & 0x00002000) != 0)) {
      output.writeInt32(31, randomSeed_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeDouble(32, randomBranchesRatio_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeEnum(34, binaryMinimizationAlgorithm_);
    }
    if (((bitField3_ & 0x00000020) != 0)) {
      output.writeBool(35, useOptimizationHints_);
    }
    if (((bitField1_ & 0x00000040) != 0)) {
      output.writeDouble(36, maxTimeInSeconds_);
    }
    if (((bitField1_ & 0x00000200) != 0)) {
      output.writeInt64(37, maxNumberOfConflicts_);
    }
    if (((bitField1_ & 0x00000400) != 0)) {
      output.writeInt64(40, maxMemoryInMb_);
    }
    if (((bitField1_ & 0x00020000) != 0)) {
      output.writeBool(41, logSearchProgress_);
    }
    if (((bitField1_ & 0x00400000) != 0)) {
      output.writeBool(43, usePbResolution_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeBool(44, usePhaseSaving_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeDouble(45, randomPolarityRatio_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      output.writeInt32(46, pbCleanupIncrement_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      output.writeDouble(47, pbCleanupRatio_);
    }
    if (((bitField1_ & 0x00800000) != 0)) {
      output.writeBool(48, minimizeReductionDuringPbResolution_);
    }
    if (((bitField1_ & 0x01000000) != 0)) {
      output.writeBool(49, countAssumptionLevelsInLbd_);
    }
    if (((bitField3_ & 0x00000040) != 0)) {
      output.writeInt32(50, coreMinimizationLevel_);
    }
    if (((bitField3_ & 0x00000200) != 0)) {
      output.writeEnum(51, maxSatAssumptionOrder_);
    }
    if (((bitField3_ & 0x00000400) != 0)) {
      output.writeBool(52, maxSatReverseAssumptionOrder_);
    }
    if (((bitField3_ & 0x00000800) != 0)) {
      output.writeEnum(53, maxSatStratification_);
    }
    if (((bitField1_ & 0x02000000) != 0)) {
      output.writeInt32(54, presolveBveThreshold_);
    }
    if (((bitField1_ & 0x04000000) != 0)) {
      output.writeInt32(55, presolveBveClauseWeight_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeBool(56, subsumptionDuringConflictAnalysis_);
    }
    if (((bitField1_ & 0x10000000) != 0)) {
      output.writeDouble(57, presolveProbingDeterministicTimeLimit_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      output.writeEnum(58, clauseCleanupProtection_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      output.writeInt32(59, clauseCleanupLbdBound_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      output.writeEnum(60, clauseCleanupOrdering_);
    }
    for (int i = 0; i < restartAlgorithms_.size(); i++) {
      output.writeEnum(61, restartAlgorithms_.get(i));
    }
    if (((bitField0_ & 0x40000000) != 0)) {
      output.writeInt32(62, restartRunningWindowSize_);
    }
    if (((bitField0_ & 0x80000000) != 0)) {
      output.writeDouble(63, restartDlAverageRatio_);
    }
    if (((bitField1_ & 0x00000002) != 0)) {
      output.writeBool(64, useBlockingRestart_);
    }
    if (((bitField1_ & 0x00000004) != 0)) {
      output.writeInt32(65, blockingRestartWindowSize_);
    }
    if (((bitField1_ & 0x00000008) != 0)) {
      output.writeDouble(66, blockingRestartMultiplier_);
    }
    if (((bitField1_ & 0x00000080) != 0)) {
      output.writeDouble(67, maxDeterministicTime_);
    }
    if (((bitField1_ & 0x00000010) != 0)) {
      output.writeInt32(68, numConflictsBeforeStrategyChanges_);
    }
    if (((bitField1_ & 0x00000020) != 0)) {
      output.writeDouble(69, strategyChangeIncreaseRatio_);
    }
    if (((bitField0_ & 0x10000000) != 0)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 70, defaultRestartAlgorithms_);
    }
    if (((bitField1_ & 0x00000001) != 0)) {
      output.writeDouble(71, restartLbdAverageRatio_);
    }
    if (((bitField1_ & 0x40000000) != 0)) {
      output.writeBool(72, presolveUseBva_);
    }
    if (((bitField1_ & 0x80000000) != 0)) {
      output.writeInt32(73, presolveBvaThreshold_);
    }
    if (((bitField3_ & 0x00002000) != 0)) {
      output.writeBool(74, usePrecedencesInDisjunctiveConstraint_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeBool(75, useErwaHeuristic_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeDouble(76, initialVariablesActivity_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeBool(77, alsoBumpVariablesInConflictReasons_);
    }
    if (((bitField3_ & 0x00040000) != 0)) {
      output.writeBool(78, useOverloadCheckerInCumulative_);
    }
    if (((bitField3_ & 0x00100000) != 0)) {
      output.writeBool(79, useTimetableEdgeFindingInCumulative_);
    }
    if (((bitField3_ & 0x01000000) != 0)) {
      output.writeBool(80, useDisjunctiveConstraintInCumulative_);
    }
    if (((bitField3_ & 0x40000000) != 0)) {
      output.writeEnum(82, searchBranching_);
    }
    if (((bitField4_ & 0x00001000) != 0)) {
      output.writeBool(83, optimizeWithCore_);
    }
    if (((bitField3_ & 0x00000080) != 0)) {
      output.writeBool(84, findMultipleCores_);
    }
    if (((bitField4_ & 0x00010000) != 0)) {
      output.writeBool(85, optimizeWithMaxHs_);
    }
    if (((bitField2_ & 0x00000002) != 0)) {
      output.writeBool(86, cpModelPresolve_);
    }
    if (((bitField5_ & 0x00000040) != 0)) {
      output.writeBool(87, enumerateAllSolutions_);
    }
    if (((bitField1_ & 0x20000000) != 0)) {
      output.writeBool(88, presolveBlockedClause_);
    }
    if (((bitField3_ & 0x00000100) != 0)) {
      output.writeBool(89, coverOptimization_);
    }
    if (((bitField6_ & 0x00000080) != 0)) {
      output.writeInt32(90, linearizationLevel_);
    }
    if (((bitField6_ & 0x00000400) != 0)) {
      output.writeInt32(91, maxNumCuts_);
    }
    if (((bitField6_ & 0x00001000) != 0)) {
      output.writeBool(92, onlyAddCutsAtLevelZero_);
    }
    if (((bitField2_ & 0x00000008) != 0)) {
      output.writeBool(93, cpModelUseSatPresolve_);
    }
    if (((bitField6_ & 0x80000000) != 0)) {
      output.writeBool(94, exploitIntegerLpSolution_);
    }
    if (((bitField5_ & 0x00000800) != 0)) {
      output.writeBool(95, autoDetectGreaterThanAtLeastOneOf_);
    }
    if (((bitField5_ & 0x00001000) != 0)) {
      output.writeBool(98, stopAfterFirstSolution_);
    }
    if (((bitField4_ & 0x00008000) != 0)) {
      output.writeInt32(99, binarySearchNumConflicts_);
    }
    if (((bitField2_ & 0x04000000) != 0)) {
      output.writeInt32(100, numSearchWorkers_);
    }
    if (((bitField5_ & 0x00010000) != 0)) {
      output.writeBool(101, useLnsOnly_);
    }
    if (((bitField5_ & 0x00800000) != 0)) {
      output.writeBool(103, randomizeSearch_);
    }
    if (((bitField5_ & 0x01000000) != 0)) {
      output.writeInt64(104, searchRandomVariablePoolSize_);
    }
    if (((bitField5_ & 0x00000400) != 0)) {
      output.writeBool(106, instantiateAllVariables_);
    }
    if (((bitField6_ & 0x00000100) != 0)) {
      output.writeInt32(107, booleanEncodingLevel_);
    }
    if (((bitField5_ & 0x04000000) != 0)) {
      output.writeBool(108, useOptionalVariables_);
    }
    if (((bitField5_ & 0x08000000) != 0)) {
      output.writeBool(109, useExactLpReason_);
    }
    if (((bitField2_ & 0x00000004) != 0)) {
      output.writeInt32(110, cpModelProbingLevel_);
    }
    if (((bitField6_ & 0x00400000) != 0)) {
      output.writeBool(112, addLpConstraintsLazily_);
    }
    if (((bitField2_ & 0x40000000) != 0)) {
      output.writeBool(113, shareObjectiveBounds_);
    }
    if (((bitField2_ & 0x80000000) != 0)) {
      output.writeBool(114, shareLevelZeroBounds_);
    }
    if (((bitField6_ & 0x01000000) != 0)) {
      output.writeDouble(115, minOrthogonalityForLpConstraints_);
    }
    if (((bitField7_ & 0x00000001) != 0)) {
      output.writeBool(116, exploitAllLpSolution_);
    }
    if (((bitField6_ & 0x00004000) != 0)) {
      output.writeBool(117, addCgCuts_);
    }
    if (((bitField6_ & 0x00200000) != 0)) {
      output.writeInt32(119, maxIntegerRoundingScaling_);
    }
    if (((bitField6_ & 0x00008000) != 0)) {
      output.writeBool(120, addMirCuts_);
    }
    if (((bitField6_ & 0x04000000) != 0)) {
      output.writeInt32(121, maxConsecutiveInactiveCount_);
    }
    if (((bitField6_ & 0x40000000) != 0)) {
      output.writeInt32(122, newConstraintsBatchSize_);
    }
    if (((bitField4_ & 0x00000800) != 0)) {
      output.writeInt64(123, pseudoCostReliabilityThreshold_);
    }
    if (((bitField7_ & 0x00000020) != 0)) {
      output.writeDouble(124, mipMaxBound_);
    }
    if (((bitField7_ & 0x00000040) != 0)) {
      output.writeDouble(125, mipVarScaling_);
    }
    if (((bitField7_ & 0x00000400) != 0)) {
      output.writeDouble(126, mipWantedPrecision_);
    }
    if (((bitField7_ & 0x00000800) != 0)) {
      output.writeInt32(127, mipMaxActivityExponent_);
    }
    if (((bitField7_ & 0x00001000) != 0)) {
      output.writeDouble(128, mipCheckPrecision_);
    }
    if (((bitField5_ & 0x00040000) != 0)) {
      output.writeBool(129, useRinsLns_);
    }
    if (((bitField7_ & 0x00000002) != 0)) {
      output.writeBool(130, exploitBestSolution_);
    }
    if (((bitField7_ & 0x00000008) != 0)) {
      output.writeBool(131, exploitObjective_);
    }
    if (((bitField5_ & 0x00000100) != 0)) {
      output.writeBool(132, fillTightenedDomainsInResponse_);
    }
    if (((bitField5_ & 0x10000000) != 0)) {
      output.writeBool(133, useCombinedNoOverlap_);
    }
    if (((bitField2_ & 0x20000000) != 0)) {
      output.writeInt32(134, interleaveBatchSize_);
    }
    if (((bitField5_ & 0x40000000) != 0)) {
      output.writeBool(135, catchSigintSignal_);
    }
    if (((bitField2_ & 0x10000000) != 0)) {
      output.writeBool(136, interleaveSearch_);
    }
    if (((bitField5_ & 0x00400000) != 0)) {
      output.writeBool(137, diversifyLnsParams_);
    }
    if (((bitField2_ & 0x00000001) != 0)) {
      output.writeInt32(138, maxPresolveIterations_);
    }
    if (((bitField5_ & 0x80000000) != 0)) {
      output.writeBool(144, useImpliedBounds_);
    }
    if (((bitField2_ & 0x00002000) != 0)) {
      output.writeDouble(145, mergeNoOverlapWorkLimit_);
    }
    if (((bitField2_ & 0x00004000) != 0)) {
      output.writeDouble(146, mergeAtMostOneWorkLimit_);
    }
    if (((bitField2_ & 0x00008000) != 0)) {
      output.writeInt32(147, presolveSubstitutionLevel_);
    }
    if (((bitField6_ & 0x00080000) != 0)) {
      output.writeInt32(148, maxAllDiffCutSize_);
    }
    if (((bitField5_ & 0x00002000) != 0)) {
      output.writeBool(149, stopAfterPresolve_);
    }
    if (((bitField3_ & 0x00000008) != 0)) {
      output.writeInt32(151, debugMaxNumPresolveOperations_);
    }
    if (((bitField6_ & 0x00100000) != 0)) {
      output.writeBool(152, addLinMaxCuts_);
    }
    if (((bitField3_ & 0x80000000) != 0)) {
      output.writeInt32(153, hintConflictLimit_);
    }
    if (((bitField6_ & 0x02000000) != 0)) {
      output.writeInt32(154, maxCutRoundsAtLevelZero_);
    }
    if (((bitField6_ & 0x08000000) != 0)) {
      output.writeDouble(155, cutMaxActiveCountValue_);
    }
    if (((bitField6_ & 0x10000000) != 0)) {
      output.writeDouble(156, cutActiveCountDecay_);
    }
    if (((bitField6_ & 0x20000000) != 0)) {
      output.writeInt32(157, cutCleanupTarget_);
    }
    if (((bitField1_ & 0x00000800) != 0)) {
      output.writeDouble(159, absoluteGapLimit_);
    }
    if (((bitField1_ & 0x00001000) != 0)) {
      output.writeDouble(160, relativeGapLimit_);
    }
    if (((bitField7_ & 0x00000004) != 0)) {
      output.writeBool(161, exploitRelaxationSolution_);
    }
    if (((bitField3_ & 0x00000004) != 0)) {
      output.writeBool(162, debugPostsolveWithFullSolver_);
    }
    if (((bitField2_ & 0x00200000) != 0)) {
      output.writeBool(163, useSatInprocessing_);
    }
    if (((bitField5_ & 0x00080000) != 0)) {
      output.writeBool(164, useFeasibilityPump_);
    }
    if (((bitField5_ & 0x00200000) != 0)) {
      output.writeEnum(165, fpRounding_);
    }
    if (((bitField7_ & 0x00000100) != 0)) {
      output.writeBool(166, mipAutomaticallyScaleVariables_);
    }
    if (((bitField4_ & 0x00000001) != 0)) {
      output.writeBool(167, repairHint_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeInt32(168, polarityRephaseIncrement_);
    }
    if (((bitField6_ & 0x00010000) != 0)) {
      output.writeBool(169, addZeroHalfCuts_);
    }
    if (((bitField2_ & 0x00000040) != 0)) {
      output.writeBool(170, expandAlldiffConstraints_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 171, name_);
    }
    if (((bitField6_ & 0x00020000) != 0)) {
      output.writeBool(172, addCliqueCuts_);
    }
    if (((bitField5_ & 0x00000080) != 0)) {
      output.writeBool(173, keepAllFeasibleSolutionsInPresolve_);
    }
    if (((bitField2_ & 0x00010000) != 0)) {
      output.writeBool(174, presolveExtractIntegerEnforcement_);
    }
    if (((bitField6_ & 0x00000001) != 0)) {
      output.writeBool(175, polishLpSolution_);
    }
    if (((bitField4_ & 0x00000004) != 0)) {
      output.writeBool(176, useProbingSearch_);
    }
    if (((bitField6_ & 0x00000008) != 0)) {
      output.writeBool(177, convertIntervals_);
    }
    if (((bitField1_ & 0x00004000) != 0)) {
      output.writeBool(178, permuteVariableRandomly_);
    }
    if (((bitField1_ & 0x00008000) != 0)) {
      output.writeBool(179, permutePresolveConstraintOrder_);
    }
    if (((bitField1_ & 0x00010000) != 0)) {
      output.writeBool(180, useAbslRandom_);
    }
    if (((bitField2_ & 0x00000800) != 0)) {
      output.writeBool(181, disableConstraintExpansion_);
    }
    if (((bitField2_ & 0x00000080) != 0)) {
      output.writeBool(182, expandReservoirConstraints_);
    }
    if (((bitField6_ & 0x00000010) != 0)) {
      output.writeInt32(183, symmetryLevel_);
    }
    if (((bitField1_ & 0x00080000) != 0)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 185, logPrefix_);
    }
    if (((bitField1_ & 0x00100000) != 0)) {
      output.writeBool(186, logToStdout_);
    }
    if (((bitField1_ & 0x00200000) != 0)) {
      output.writeBool(187, logToResponse_);
    }
    if (((bitField4_ & 0x00002000) != 0)) {
      output.writeBool(188, optimizeWithLbTreeSearch_);
    }
    if (((bitField1_ & 0x00040000) != 0)) {
      output.writeBool(189, logSubsolverStatistics_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeDouble(190, clauseCleanupRatio_);
    }
    if (((bitField6_ & 0x00000200) != 0)) {
      output.writeInt32(191, maxDomainSizeWhenEncodingEqNeqConstraints_);
    }
    if (((bitField4_ & 0x00000002) != 0)) {
      output.writeBool(192, fixVariablesToTheirHintedValue_);
    }
    if (((bitField5_ & 0x00020000) != 0)) {
      output.writeInt32(193, solutionPoolSize_);
    }
    if (((bitField5_ & 0x00000200) != 0)) {
      output.writeBool(194, fillAdditionalSolutionsInResponse_);
    }
    if (((bitField3_ & 0x00000010) != 0)) {
      output.writeBool(195, debugCrashOnBadHint_);
    }
    if (((bitField6_ & 0x00000800) != 0)) {
      output.writeInt32(196, cutLevel_);
    }
    if (((bitField6_ & 0x00002000) != 0)) {
      output.writeBool(197, addObjectiveCut_);
    }
    if (((bitField7_ & 0x00002000) != 0)) {
      output.writeBool(198, mipComputeTrueObjectiveBound_);
    }
    if (((bitField7_ & 0x00004000) != 0)) {
      output.writeDouble(199, mipMaxValidMagnitude_);
    }
    if (((bitField3_ & 0x02000000) != 0)) {
      output.writeBool(200, useTimetablingInNoOverlap2D_);
    }
    if (((bitField2_ & 0x00020000) != 0)) {
      output.writeInt64(201, presolveInclusionWorkLimit_);
    }
    if (((bitField2_ & 0x00040000) != 0)) {
      output.writeBool(202, ignoreNames_);
    }
    if (((bitField3_ & 0x00000001) != 0)) {
      output.writeBool(203, shareBinaryClauses_);
    }
    if (((bitField4_ & 0x00000020) != 0)) {
      output.writeBool(204, useShavingInProbingSearch_);
    }
    if (((bitField4_ & 0x00000040) != 0)) {
      output.writeDouble(205, shavingSearchDeterministicTime_);
    }
    if (((bitField2_ & 0x02000000) != 0)) {
      output.writeInt32(206, numWorkers_);
    }
    for (int i = 0; i < subsolvers_.size(); i++) {
      com.google.protobuf.GeneratedMessage.writeString(output, 207, subsolvers_.getRaw(i));
    }
    for (int i = 0; i < ignoreSubsolvers_.size(); i++) {
      com.google.protobuf.GeneratedMessage.writeString(output, 209, ignoreSubsolvers_.getRaw(i));
    }
    for (int i = 0; i < subsolverParams_.size(); i++) {
      output.writeMessage(210, subsolverParams_.get(i));
    }
    if (((bitField3_ & 0x04000000) != 0)) {
      output.writeBool(213, useEnergeticReasoningInNoOverlap2D_);
    }
    if (((bitField3_ & 0x20000000) != 0)) {
      output.writeBool(214, useDualSchedulingHeuristics_);
    }
    if (((bitField3_ & 0x00400000) != 0)) {
      output.writeBool(215, useHardPrecedencesInCumulative_);
    }
    if (((bitField2_ & 0x00000010) != 0)) {
      output.writeBool(216, detectTableWithCost_);
    }
    if (((bitField2_ & 0x00000020) != 0)) {
      output.writeInt32(217, tableCompressionLevel_);
    }
    for (int i = 0; i < extraSubsolvers_.size(); i++) {
      com.google.protobuf.GeneratedMessage.writeString(output, 219, extraSubsolvers_.getRaw(i));
    }
    if (((bitField3_ & 0x00800000) != 0)) {
      output.writeBool(220, exploitAllPrecedences_);
    }
    if (((bitField3_ & 0x00001000) != 0)) {
      output.writeDouble(221, propagationLoopDetectionFactor_);
    }
    if (((bitField7_ & 0x00000200) != 0)) {
      output.writeBool(222, onlySolveIp_);
    }
    if (((bitField2_ & 0x00001000) != 0)) {
      output.writeBool(223, encodeComplexLinearConstraintWithInteger_);
    }
    if (((bitField6_ & 0x00000020) != 0)) {
      output.writeBool(224, newLinearPropagation_);
    }
    if (((bitField7_ & 0x00000080) != 0)) {
      output.writeBool(225, mipScaleLargeDomain_);
    }
    if (((bitField1_ & 0x08000000) != 0)) {
      output.writeDouble(226, probingDeterministicTimeLimit_);
    }
    if (((bitField6_ & 0x00800000) != 0)) {
      output.writeInt32(227, rootLpIterations_);
    }
    if (((bitField4_ & 0x00000100) != 0)) {
      output.writeBool(228, useObjectiveLbSearch_);
    }
    if (((bitField3_ & 0x00004000) != 0)) {
      output.writeInt32(229, maxSizeToCreatePrecedenceLiteralsInDisjunctive_);
    }
    if (((bitField3_ & 0x00008000) != 0)) {
      output.writeBool(230, useStrongPropagationInDisjunctive_);
    }
    if (((bitField7_ & 0x00010000) != 0)) {
      output.writeDouble(232, mipDropTolerance_);
    }
    if (((bitField2_ & 0x00080000) != 0)) {
      output.writeBool(233, inferAllDiffs_);
    }
    if (((bitField2_ & 0x00100000) != 0)) {
      output.writeBool(234, findBigLinearOverlap_);
    }
    if (((bitField4_ & 0x40000000) != 0)) {
      output.writeInt32(235, sharedTreeNumWorkers_);
    }
    if (((bitField4_ & 0x80000000) != 0)) {
      output.writeBool(236, useSharedTreeSearch_);
    }
    if (((bitField5_ & 0x00000001) != 0)) {
      output.writeDouble(237, sharedTreeWorkerObjectiveSplitProbability_);
    }
    if (((bitField5_ & 0x00000010) != 0)) {
      output.writeInt32(238, sharedTreeMaxNodesPerWorker_);
    }
    if (((bitField5_ & 0x00000020) != 0)) {
      output.writeEnum(239, sharedTreeSplitStrategy_);
    }
    if (((bitField4_ & 0x00040000) != 0)) {
      output.writeBool(240, useLsOnly_);
    }
    if (((bitField4_ & 0x00080000) != 0)) {
      output.writeDouble(242, feasibilityJumpDecay_);
    }
    if (((bitField4_ & 0x08000000) != 0)) {
      output.writeInt32(244, numViolationLs_);
    }
    if (((bitField4_ & 0x00800000) != 0)) {
      output.writeDouble(247, feasibilityJumpVarRandomizationProbability_);
    }
    if (((bitField4_ & 0x01000000) != 0)) {
      output.writeDouble(248, feasibilityJumpVarPerburbationRangeRatio_);
    }
    if (((bitField4_ & 0x10000000) != 0)) {
      output.writeInt32(249, violationLsPerturbationPeriod_);
    }
    if (((bitField4_ & 0x02000000) != 0)) {
      output.writeBool(250, feasibilityJumpEnableRestarts_);
    }
    if (((bitField5_ & 0x00004000) != 0)) {
      output.writeBool(252, stopAfterRootPropagation_);
    }
    if (((bitField4_ & 0x00000200) != 0)) {
      output.writeBool(253, useObjectiveShavingSearch_);
    }
    if (((bitField5_ & 0x00100000) != 0)) {
      output.writeBool(255, useLbRelaxLns_);
    }
    if (((bitField6_ & 0x00000040) != 0)) {
      output.writeInt32(256, linearSplitSize_);
    }
    if (((bitField4_ & 0x00100000) != 0)) {
      output.writeInt32(257, feasibilityJumpLinearizationLevel_);
    }
    if (((bitField4_ & 0x00200000) != 0)) {
      output.writeInt32(258, feasibilityJumpRestartFactor_);
    }
    if (((bitField4_ & 0x20000000) != 0)) {
      output.writeDouble(259, violationLsCompoundMoveProbability_);
    }
    if (((bitField3_ & 0x00200000) != 0)) {
      output.writeInt32(260, maxNumIntervalsForTimetableEdgeFinding_);
    }
    if (((bitField7_ & 0x00020000) != 0)) {
      output.writeInt32(261, mipPresolveLevel_);
    }
    if (((bitField5_ & 0x02000000) != 0)) {
      output.writeBool(262, pushAllTasksTowardStart_);
    }
    if (((bitField3_ & 0x00010000) != 0)) {
      output.writeBool(263, useDynamicPrecedenceInDisjunctive_);
    }
    if (((bitField4_ & 0x04000000) != 0)) {
      output.writeInt32(264, feasibilityJumpMaxExpandedConstraintSize_);
    }
    if (((bitField4_ & 0x00020000) != 0)) {
      output.writeBool(265, useFeasibilityJump_);
    }
    if (((bitField6_ & 0x00000002) != 0)) {
      output.writeDouble(266, lpPrimalTolerance_);
    }
    if (((bitField6_ & 0x00000004) != 0)) {
      output.writeDouble(267, lpDualTolerance_);
    }
    if (((bitField3_ & 0x00020000) != 0)) {
      output.writeBool(268, useDynamicPrecedenceInCumulative_);
    }
    if (((bitField4_ & 0x00000008) != 0)) {
      output.writeBool(269, useExtendedProbing_);
    }
    if (((bitField5_ & 0x20000000) != 0)) {
      output.writeInt32(270, atMostOneMaxExpansionSize_);
    }
    if (((bitField3_ & 0x08000000) != 0)) {
      output.writeBool(271, useAreaEnergeticReasoningInNoOverlap2D_);
    }
    if (((bitField4_ & 0x00000010) != 0)) {
      output.writeInt32(272, probingNumCombinationsLimit_);
    }
    if (((bitField2_ & 0x00400000) != 0)) {
      output.writeDouble(273, inprocessingDtimeRatio_);
    }
    if (((bitField2_ & 0x00800000) != 0)) {
      output.writeDouble(274, inprocessingProbingDtime_);
    }
    if (((bitField2_ & 0x01000000) != 0)) {
      output.writeDouble(275, inprocessingMinimizationDtime_);
    }
    if (((bitField3_ & 0x10000000) != 0)) {
      output.writeInt32(276, maxPairsPairwiseReasoningInNoOverlap2D_);
    }
    if (((bitField7_ & 0x00000010) != 0)) {
      output.writeBool(277, detectLinearizedProduct_);
    }
    if (((bitField7_ & 0x00008000) != 0)) {
      output.writeBool(278, mipTreatHighMagnitudeBoundsAsInfinity_);
    }
    if (((bitField6_ & 0x00040000) != 0)) {
      output.writeBool(279, addRltCuts_);
    }
    if (((bitField2_ & 0x00000400) != 0)) {
      output.writeInt32(280, maxLinMaxSizeForExpansion_);
    }
    if (((bitField5_ & 0x00000008) != 0)) {
      output.writeDouble(281, sharedTreeOpenLeavesPerWorker_);
    }
    if (((bitField5_ & 0x00000002) != 0)) {
      output.writeInt32(282, sharedTreeWorkerMinRestartsPerSubtree_);
    }
    if (((bitField5_ & 0x00008000) != 0)) {
      output.writeBool(283, useLns_);
    }
    if (((bitField4_ & 0x00004000) != 0)) {
      output.writeBool(284, saveLpBasisInLbTreeSearch_);
    }
    if (((bitField3_ & 0x00000002) != 0)) {
      output.writeBool(285, shareGlueClauses_);
    }
    if (((bitField3_ & 0x00080000) != 0)) {
      output.writeBool(286, useConservativeScaleOverloadChecker_);
    }
    if (((bitField2_ & 0x00000200) != 0)) {
      output.writeBool(287, encodeCumulativeAsReservoir_);
    }
    if (((bitField2_ & 0x00000100) != 0)) {
      output.writeBool(288, expandReservoirUsingCircuit_);
    }
    if (((bitField4_ & 0x00000400) != 0)) {
      output.writeBool(289, useVariablesShavingSearch_);
    }
    if (((bitField4_ & 0x00000080) != 0)) {
      output.writeInt64(290, shavingSearchThreshold_);
    }
    if (((bitField1_ & 0x00000100) != 0)) {
      output.writeInt32(291, maxNumDeterministicBatches_);
    }
    if (((bitField4_ & 0x00400000) != 0)) {
      output.writeDouble(292, feasibilityJumpBatchDtime_);
    }
    for (int i = 0; i < filterSubsolvers_.size(); i++) {
      com.google.protobuf.GeneratedMessage.writeString(output, 293, filterSubsolvers_.getRaw(i));
    }
    if (((bitField2_ & 0x08000000) != 0)) {
      output.writeInt32(294, numFullSubsolvers_);
    }
    if (((bitField5_ & 0x00000004) != 0)) {
      output.writeBool(295, sharedTreeWorkerEnableTrailSharing_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(1, preferredVariableOrder_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(2, initialPolarity_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(4, minimizationAlgorithm_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(11, clauseCleanupPeriod_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(13, clauseCleanupTarget_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(15, variableActivityDecay_);
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(16, maxVariableActivityValue_);
    }
    if (((bitField0_ & 0x04000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(17, clauseActivityDecay_);
    }
    if (((bitField0_ & 0x08000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(18, maxClauseActivityValue_);
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(22, glucoseMaxDecay_);
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(23, glucoseDecayIncrement_);
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(24, glucoseDecayIncrementPeriod_);
    }
    if (((bitField0_ & 0x20000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(30, restartPeriod_);
    }
    if (((bitField1_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(31, randomSeed_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(32, randomBranchesRatio_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(34, binaryMinimizationAlgorithm_);
    }
    if (((bitField3_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(35, useOptimizationHints_);
    }
    if (((bitField1_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(36, maxTimeInSeconds_);
    }
    if (((bitField1_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(37, maxNumberOfConflicts_);
    }
    if (((bitField1_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(40, maxMemoryInMb_);
    }
    if (((bitField1_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(41, logSearchProgress_);
    }
    if (((bitField1_ & 0x00400000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(43, usePbResolution_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(44, usePhaseSaving_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(45, randomPolarityRatio_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(46, pbCleanupIncrement_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(47, pbCleanupRatio_);
    }
    if (((bitField1_ & 0x00800000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(48, minimizeReductionDuringPbResolution_);
    }
    if (((bitField1_ & 0x01000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(49, countAssumptionLevelsInLbd_);
    }
    if (((bitField3_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(50, coreMinimizationLevel_);
    }
    if (((bitField3_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(51, maxSatAssumptionOrder_);
    }
    if (((bitField3_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(52, maxSatReverseAssumptionOrder_);
    }
    if (((bitField3_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(53, maxSatStratification_);
    }
    if (((bitField1_ & 0x02000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(54, presolveBveThreshold_);
    }
    if (((bitField1_ & 0x04000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(55, presolveBveClauseWeight_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(56, subsumptionDuringConflictAnalysis_);
    }
    if (((bitField1_ & 0x10000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(57, presolveProbingDeterministicTimeLimit_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(58, clauseCleanupProtection_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(59, clauseCleanupLbdBound_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(60, clauseCleanupOrdering_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < restartAlgorithms_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeEnumSizeNoTag(restartAlgorithms_.get(i));
      }
      size += dataSize;
      size += 2 * restartAlgorithms_.size();
    }
    if (((bitField0_ & 0x40000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(62, restartRunningWindowSize_);
    }
    if (((bitField0_ & 0x80000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(63, restartDlAverageRatio_);
    }
    if (((bitField1_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(64, useBlockingRestart_);
    }
    if (((bitField1_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(65, blockingRestartWindowSize_);
    }
    if (((bitField1_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(66, blockingRestartMultiplier_);
    }
    if (((bitField1_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(67, maxDeterministicTime_);
    }
    if (((bitField1_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(68, numConflictsBeforeStrategyChanges_);
    }
    if (((bitField1_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(69, strategyChangeIncreaseRatio_);
    }
    if (((bitField0_ & 0x10000000) != 0)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(70, defaultRestartAlgorithms_);
    }
    if (((bitField1_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(71, restartLbdAverageRatio_);
    }
    if (((bitField1_ & 0x40000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(72, presolveUseBva_);
    }
    if (((bitField1_ & 0x80000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(73, presolveBvaThreshold_);
    }
    if (((bitField3_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(74, usePrecedencesInDisjunctiveConstraint_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(75, useErwaHeuristic_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(76, initialVariablesActivity_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(77, alsoBumpVariablesInConflictReasons_);
    }
    if (((bitField3_ & 0x00040000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(78, useOverloadCheckerInCumulative_);
    }
    if (((bitField3_ & 0x00100000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(79, useTimetableEdgeFindingInCumulative_);
    }
    if (((bitField3_ & 0x01000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(80, useDisjunctiveConstraintInCumulative_);
    }
    if (((bitField3_ & 0x40000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(82, searchBranching_);
    }
    if (((bitField4_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(83, optimizeWithCore_);
    }
    if (((bitField3_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(84, findMultipleCores_);
    }
    if (((bitField4_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(85, optimizeWithMaxHs_);
    }
    if (((bitField2_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(86, cpModelPresolve_);
    }
    if (((bitField5_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(87, enumerateAllSolutions_);
    }
    if (((bitField1_ & 0x20000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(88, presolveBlockedClause_);
    }
    if (((bitField3_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(89, coverOptimization_);
    }
    if (((bitField6_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(90, linearizationLevel_);
    }
    if (((bitField6_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(91, maxNumCuts_);
    }
    if (((bitField6_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(92, onlyAddCutsAtLevelZero_);
    }
    if (((bitField2_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(93, cpModelUseSatPresolve_);
    }
    if (((bitField6_ & 0x80000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(94, exploitIntegerLpSolution_);
    }
    if (((bitField5_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(95, autoDetectGreaterThanAtLeastOneOf_);
    }
    if (((bitField5_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(98, stopAfterFirstSolution_);
    }
    if (((bitField4_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(99, binarySearchNumConflicts_);
    }
    if (((bitField2_ & 0x04000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(100, numSearchWorkers_);
    }
    if (((bitField5_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(101, useLnsOnly_);
    }
    if (((bitField5_ & 0x00800000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(103, randomizeSearch_);
    }
    if (((bitField5_ & 0x01000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(104, searchRandomVariablePoolSize_);
    }
    if (((bitField5_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(106, instantiateAllVariables_);
    }
    if (((bitField6_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(107, booleanEncodingLevel_);
    }
    if (((bitField5_ & 0x04000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(108, useOptionalVariables_);
    }
    if (((bitField5_ & 0x08000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(109, useExactLpReason_);
    }
    if (((bitField2_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(110, cpModelProbingLevel_);
    }
    if (((bitField6_ & 0x00400000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(112, addLpConstraintsLazily_);
    }
    if (((bitField2_ & 0x40000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(113, shareObjectiveBounds_);
    }
    if (((bitField2_ & 0x80000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(114, shareLevelZeroBounds_);
    }
    if (((bitField6_ & 0x01000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(115, minOrthogonalityForLpConstraints_);
    }
    if (((bitField7_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(116, exploitAllLpSolution_);
    }
    if (((bitField6_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(117, addCgCuts_);
    }
    if (((bitField6_ & 0x00200000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(119, maxIntegerRoundingScaling_);
    }
    if (((bitField6_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(120, addMirCuts_);
    }
    if (((bitField6_ & 0x04000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(121, maxConsecutiveInactiveCount_);
    }
    if (((bitField6_ & 0x40000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(122, newConstraintsBatchSize_);
    }
    if (((bitField4_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(123, pseudoCostReliabilityThreshold_);
    }
    if (((bitField7_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(124, mipMaxBound_);
    }
    if (((bitField7_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(125, mipVarScaling_);
    }
    if (((bitField7_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(126, mipWantedPrecision_);
    }
    if (((bitField7_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(127, mipMaxActivityExponent_);
    }
    if (((bitField7_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(128, mipCheckPrecision_);
    }
    if (((bitField5_ & 0x00040000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(129, useRinsLns_);
    }
    if (((bitField7_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(130, exploitBestSolution_);
    }
    if (((bitField7_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(131, exploitObjective_);
    }
    if (((bitField5_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(132, fillTightenedDomainsInResponse_);
    }
    if (((bitField5_ & 0x10000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(133, useCombinedNoOverlap_);
    }
    if (((bitField2_ & 0x20000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(134, interleaveBatchSize_);
    }
    if (((bitField5_ & 0x40000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(135, catchSigintSignal_);
    }
    if (((bitField2_ & 0x10000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(136, interleaveSearch_);
    }
    if (((bitField5_ & 0x00400000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(137, diversifyLnsParams_);
    }
    if (((bitField2_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(138, maxPresolveIterations_);
    }
    if (((bitField5_ & 0x80000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(144, useImpliedBounds_);
    }
    if (((bitField2_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(145, mergeNoOverlapWorkLimit_);
    }
    if (((bitField2_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(146, mergeAtMostOneWorkLimit_);
    }
    if (((bitField2_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(147, presolveSubstitutionLevel_);
    }
    if (((bitField6_ & 0x00080000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(148, maxAllDiffCutSize_);
    }
    if (((bitField5_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(149, stopAfterPresolve_);
    }
    if (((bitField3_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(151, debugMaxNumPresolveOperations_);
    }
    if (((bitField6_ & 0x00100000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(152, addLinMaxCuts_);
    }
    if (((bitField3_ & 0x80000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(153, hintConflictLimit_);
    }
    if (((bitField6_ & 0x02000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(154, maxCutRoundsAtLevelZero_);
    }
    if (((bitField6_ & 0x08000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(155, cutMaxActiveCountValue_);
    }
    if (((bitField6_ & 0x10000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(156, cutActiveCountDecay_);
    }
    if (((bitField6_ & 0x20000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(157, cutCleanupTarget_);
    }
    if (((bitField1_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(159, absoluteGapLimit_);
    }
    if (((bitField1_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(160, relativeGapLimit_);
    }
    if (((bitField7_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(161, exploitRelaxationSolution_);
    }
    if (((bitField3_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(162, debugPostsolveWithFullSolver_);
    }
    if (((bitField2_ & 0x00200000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(163, useSatInprocessing_);
    }
    if (((bitField5_ & 0x00080000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(164, useFeasibilityPump_);
    }
    if (((bitField5_ & 0x00200000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(165, fpRounding_);
    }
    if (((bitField7_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(166, mipAutomaticallyScaleVariables_);
    }
    if (((bitField4_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(167, repairHint_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(168, polarityRephaseIncrement_);
    }
    if (((bitField6_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(169, addZeroHalfCuts_);
    }
    if (((bitField2_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(170, expandAlldiffConstraints_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(171, name_);
    }
    if (((bitField6_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(172, addCliqueCuts_);
    }
    if (((bitField5_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(173, keepAllFeasibleSolutionsInPresolve_);
    }
    if (((bitField2_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(174, presolveExtractIntegerEnforcement_);
    }
    if (((bitField6_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(175, polishLpSolution_);
    }
    if (((bitField4_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(176, useProbingSearch_);
    }
    if (((bitField6_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(177, convertIntervals_);
    }
    if (((bitField1_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(178, permuteVariableRandomly_);
    }
    if (((bitField1_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(179, permutePresolveConstraintOrder_);
    }
    if (((bitField1_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(180, useAbslRandom_);
    }
    if (((bitField2_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(181, disableConstraintExpansion_);
    }
    if (((bitField2_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(182, expandReservoirConstraints_);
    }
    if (((bitField6_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(183, symmetryLevel_);
    }
    if (((bitField1_ & 0x00080000) != 0)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(185, logPrefix_);
    }
    if (((bitField1_ & 0x00100000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(186, logToStdout_);
    }
    if (((bitField1_ & 0x00200000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(187, logToResponse_);
    }
    if (((bitField4_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(188, optimizeWithLbTreeSearch_);
    }
    if (((bitField1_ & 0x00040000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(189, logSubsolverStatistics_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(190, clauseCleanupRatio_);
    }
    if (((bitField6_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(191, maxDomainSizeWhenEncodingEqNeqConstraints_);
    }
    if (((bitField4_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(192, fixVariablesToTheirHintedValue_);
    }
    if (((bitField5_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(193, solutionPoolSize_);
    }
    if (((bitField5_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(194, fillAdditionalSolutionsInResponse_);
    }
    if (((bitField3_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(195, debugCrashOnBadHint_);
    }
    if (((bitField6_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(196, cutLevel_);
    }
    if (((bitField6_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(197, addObjectiveCut_);
    }
    if (((bitField7_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(198, mipComputeTrueObjectiveBound_);
    }
    if (((bitField7_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(199, mipMaxValidMagnitude_);
    }
    if (((bitField3_ & 0x02000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(200, useTimetablingInNoOverlap2D_);
    }
    if (((bitField2_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(201, presolveInclusionWorkLimit_);
    }
    if (((bitField2_ & 0x00040000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(202, ignoreNames_);
    }
    if (((bitField3_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(203, shareBinaryClauses_);
    }
    if (((bitField4_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(204, useShavingInProbingSearch_);
    }
    if (((bitField4_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(205, shavingSearchDeterministicTime_);
    }
    if (((bitField2_ & 0x02000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(206, numWorkers_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < subsolvers_.size(); i++) {
        dataSize += computeStringSizeNoTag(subsolvers_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getSubsolversList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < ignoreSubsolvers_.size(); i++) {
        dataSize += computeStringSizeNoTag(ignoreSubsolvers_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getIgnoreSubsolversList().size();
    }
    for (int i = 0; i < subsolverParams_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(210, subsolverParams_.get(i));
    }
    if (((bitField3_ & 0x04000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(213, useEnergeticReasoningInNoOverlap2D_);
    }
    if (((bitField3_ & 0x20000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(214, useDualSchedulingHeuristics_);
    }
    if (((bitField3_ & 0x00400000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(215, useHardPrecedencesInCumulative_);
    }
    if (((bitField2_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(216, detectTableWithCost_);
    }
    if (((bitField2_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(217, tableCompressionLevel_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < extraSubsolvers_.size(); i++) {
        dataSize += computeStringSizeNoTag(extraSubsolvers_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getExtraSubsolversList().size();
    }
    if (((bitField3_ & 0x00800000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(220, exploitAllPrecedences_);
    }
    if (((bitField3_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(221, propagationLoopDetectionFactor_);
    }
    if (((bitField7_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(222, onlySolveIp_);
    }
    if (((bitField2_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(223, encodeComplexLinearConstraintWithInteger_);
    }
    if (((bitField6_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(224, newLinearPropagation_);
    }
    if (((bitField7_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(225, mipScaleLargeDomain_);
    }
    if (((bitField1_ & 0x08000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(226, probingDeterministicTimeLimit_);
    }
    if (((bitField6_ & 0x00800000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(227, rootLpIterations_);
    }
    if (((bitField4_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(228, useObjectiveLbSearch_);
    }
    if (((bitField3_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(229, maxSizeToCreatePrecedenceLiteralsInDisjunctive_);
    }
    if (((bitField3_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(230, useStrongPropagationInDisjunctive_);
    }
    if (((bitField7_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(232, mipDropTolerance_);
    }
    if (((bitField2_ & 0x00080000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(233, inferAllDiffs_);
    }
    if (((bitField2_ & 0x00100000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(234, findBigLinearOverlap_);
    }
    if (((bitField4_ & 0x40000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(235, sharedTreeNumWorkers_);
    }
    if (((bitField4_ & 0x80000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(236, useSharedTreeSearch_);
    }
    if (((bitField5_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(237, sharedTreeWorkerObjectiveSplitProbability_);
    }
    if (((bitField5_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(238, sharedTreeMaxNodesPerWorker_);
    }
    if (((bitField5_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(239, sharedTreeSplitStrategy_);
    }
    if (((bitField4_ & 0x00040000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(240, useLsOnly_);
    }
    if (((bitField4_ & 0x00080000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(242, feasibilityJumpDecay_);
    }
    if (((bitField4_ & 0x08000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(244, numViolationLs_);
    }
    if (((bitField4_ & 0x00800000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(247, feasibilityJumpVarRandomizationProbability_);
    }
    if (((bitField4_ & 0x01000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(248, feasibilityJumpVarPerburbationRangeRatio_);
    }
    if (((bitField4_ & 0x10000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(249, violationLsPerturbationPeriod_);
    }
    if (((bitField4_ & 0x02000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(250, feasibilityJumpEnableRestarts_);
    }
    if (((bitField5_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(252, stopAfterRootPropagation_);
    }
    if (((bitField4_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(253, useObjectiveShavingSearch_);
    }
    if (((bitField5_ & 0x00100000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(255, useLbRelaxLns_);
    }
    if (((bitField6_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(256, linearSplitSize_);
    }
    if (((bitField4_ & 0x00100000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(257, feasibilityJumpLinearizationLevel_);
    }
    if (((bitField4_ & 0x00200000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(258, feasibilityJumpRestartFactor_);
    }
    if (((bitField4_ & 0x20000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(259, violationLsCompoundMoveProbability_);
    }
    if (((bitField3_ & 0x00200000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(260, maxNumIntervalsForTimetableEdgeFinding_);
    }
    if (((bitField7_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(261, mipPresolveLevel_);
    }
    if (((bitField5_ & 0x02000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(262, pushAllTasksTowardStart_);
    }
    if (((bitField3_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(263, useDynamicPrecedenceInDisjunctive_);
    }
    if (((bitField4_ & 0x04000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(264, feasibilityJumpMaxExpandedConstraintSize_);
    }
    if (((bitField4_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(265, useFeasibilityJump_);
    }
    if (((bitField6_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(266, lpPrimalTolerance_);
    }
    if (((bitField6_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(267, lpDualTolerance_);
    }
    if (((bitField3_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(268, useDynamicPrecedenceInCumulative_);
    }
    if (((bitField4_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(269, useExtendedProbing_);
    }
    if (((bitField5_ & 0x20000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(270, atMostOneMaxExpansionSize_);
    }
    if (((bitField3_ & 0x08000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(271, useAreaEnergeticReasoningInNoOverlap2D_);
    }
    if (((bitField4_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(272, probingNumCombinationsLimit_);
    }
    if (((bitField2_ & 0x00400000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(273, inprocessingDtimeRatio_);
    }
    if (((bitField2_ & 0x00800000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(274, inprocessingProbingDtime_);
    }
    if (((bitField2_ & 0x01000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(275, inprocessingMinimizationDtime_);
    }
    if (((bitField3_ & 0x10000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(276, maxPairsPairwiseReasoningInNoOverlap2D_);
    }
    if (((bitField7_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(277, detectLinearizedProduct_);
    }
    if (((bitField7_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(278, mipTreatHighMagnitudeBoundsAsInfinity_);
    }
    if (((bitField6_ & 0x00040000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(279, addRltCuts_);
    }
    if (((bitField2_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(280, maxLinMaxSizeForExpansion_);
    }
    if (((bitField5_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(281, sharedTreeOpenLeavesPerWorker_);
    }
    if (((bitField5_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(282, sharedTreeWorkerMinRestartsPerSubtree_);
    }
    if (((bitField5_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(283, useLns_);
    }
    if (((bitField4_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(284, saveLpBasisInLbTreeSearch_);
    }
    if (((bitField3_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(285, shareGlueClauses_);
    }
    if (((bitField3_ & 0x00080000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(286, useConservativeScaleOverloadChecker_);
    }
    if (((bitField2_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(287, encodeCumulativeAsReservoir_);
    }
    if (((bitField2_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(288, expandReservoirUsingCircuit_);
    }
    if (((bitField4_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(289, useVariablesShavingSearch_);
    }
    if (((bitField4_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(290, shavingSearchThreshold_);
    }
    if (((bitField1_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(291, maxNumDeterministicBatches_);
    }
    if (((bitField4_ & 0x00400000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(292, feasibilityJumpBatchDtime_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < filterSubsolvers_.size(); i++) {
        dataSize += computeStringSizeNoTag(filterSubsolvers_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getFilterSubsolversList().size();
    }
    if (((bitField2_ & 0x08000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(294, numFullSubsolvers_);
    }
    if (((bitField5_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(295, sharedTreeWorkerEnableTrailSharing_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ortools.sat.SatParameters)) {
      return super.equals(obj);
    }
    com.google.ortools.sat.SatParameters other = (com.google.ortools.sat.SatParameters) obj;

    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName()
          .equals(other.getName())) return false;
    }
    if (hasPreferredVariableOrder() != other.hasPreferredVariableOrder()) return false;
    if (hasPreferredVariableOrder()) {
      if (preferredVariableOrder_ != other.preferredVariableOrder_) return false;
    }
    if (hasInitialPolarity() != other.hasInitialPolarity()) return false;
    if (hasInitialPolarity()) {
      if (initialPolarity_ != other.initialPolarity_) return false;
    }
    if (hasUsePhaseSaving() != other.hasUsePhaseSaving()) return false;
    if (hasUsePhaseSaving()) {
      if (getUsePhaseSaving()
          != other.getUsePhaseSaving()) return false;
    }
    if (hasPolarityRephaseIncrement() != other.hasPolarityRephaseIncrement()) return false;
    if (hasPolarityRephaseIncrement()) {
      if (getPolarityRephaseIncrement()
          != other.getPolarityRephaseIncrement()) return false;
    }
    if (hasRandomPolarityRatio() != other.hasRandomPolarityRatio()) return false;
    if (hasRandomPolarityRatio()) {
      if (java.lang.Double.doubleToLongBits(getRandomPolarityRatio())
          != java.lang.Double.doubleToLongBits(
              other.getRandomPolarityRatio())) return false;
    }
    if (hasRandomBranchesRatio() != other.hasRandomBranchesRatio()) return false;
    if (hasRandomBranchesRatio()) {
      if (java.lang.Double.doubleToLongBits(getRandomBranchesRatio())
          != java.lang.Double.doubleToLongBits(
              other.getRandomBranchesRatio())) return false;
    }
    if (hasUseErwaHeuristic() != other.hasUseErwaHeuristic()) return false;
    if (hasUseErwaHeuristic()) {
      if (getUseErwaHeuristic()
          != other.getUseErwaHeuristic()) return false;
    }
    if (hasInitialVariablesActivity() != other.hasInitialVariablesActivity()) return false;
    if (hasInitialVariablesActivity()) {
      if (java.lang.Double.doubleToLongBits(getInitialVariablesActivity())
          != java.lang.Double.doubleToLongBits(
              other.getInitialVariablesActivity())) return false;
    }
    if (hasAlsoBumpVariablesInConflictReasons() != other.hasAlsoBumpVariablesInConflictReasons()) return false;
    if (hasAlsoBumpVariablesInConflictReasons()) {
      if (getAlsoBumpVariablesInConflictReasons()
          != other.getAlsoBumpVariablesInConflictReasons()) return false;
    }
    if (hasMinimizationAlgorithm() != other.hasMinimizationAlgorithm()) return false;
    if (hasMinimizationAlgorithm()) {
      if (minimizationAlgorithm_ != other.minimizationAlgorithm_) return false;
    }
    if (hasBinaryMinimizationAlgorithm() != other.hasBinaryMinimizationAlgorithm()) return false;
    if (hasBinaryMinimizationAlgorithm()) {
      if (binaryMinimizationAlgorithm_ != other.binaryMinimizationAlgorithm_) return false;
    }
    if (hasSubsumptionDuringConflictAnalysis() != other.hasSubsumptionDuringConflictAnalysis()) return false;
    if (hasSubsumptionDuringConflictAnalysis()) {
      if (getSubsumptionDuringConflictAnalysis()
          != other.getSubsumptionDuringConflictAnalysis()) return false;
    }
    if (hasClauseCleanupPeriod() != other.hasClauseCleanupPeriod()) return false;
    if (hasClauseCleanupPeriod()) {
      if (getClauseCleanupPeriod()
          != other.getClauseCleanupPeriod()) return false;
    }
    if (hasClauseCleanupTarget() != other.hasClauseCleanupTarget()) return false;
    if (hasClauseCleanupTarget()) {
      if (getClauseCleanupTarget()
          != other.getClauseCleanupTarget()) return false;
    }
    if (hasClauseCleanupRatio() != other.hasClauseCleanupRatio()) return false;
    if (hasClauseCleanupRatio()) {
      if (java.lang.Double.doubleToLongBits(getClauseCleanupRatio())
          != java.lang.Double.doubleToLongBits(
              other.getClauseCleanupRatio())) return false;
    }
    if (hasClauseCleanupProtection() != other.hasClauseCleanupProtection()) return false;
    if (hasClauseCleanupProtection()) {
      if (clauseCleanupProtection_ != other.clauseCleanupProtection_) return false;
    }
    if (hasClauseCleanupLbdBound() != other.hasClauseCleanupLbdBound()) return false;
    if (hasClauseCleanupLbdBound()) {
      if (getClauseCleanupLbdBound()
          != other.getClauseCleanupLbdBound()) return false;
    }
    if (hasClauseCleanupOrdering() != other.hasClauseCleanupOrdering()) return false;
    if (hasClauseCleanupOrdering()) {
      if (clauseCleanupOrdering_ != other.clauseCleanupOrdering_) return false;
    }
    if (hasPbCleanupIncrement() != other.hasPbCleanupIncrement()) return false;
    if (hasPbCleanupIncrement()) {
      if (getPbCleanupIncrement()
          != other.getPbCleanupIncrement()) return false;
    }
    if (hasPbCleanupRatio() != other.hasPbCleanupRatio()) return false;
    if (hasPbCleanupRatio()) {
      if (java.lang.Double.doubleToLongBits(getPbCleanupRatio())
          != java.lang.Double.doubleToLongBits(
              other.getPbCleanupRatio())) return false;
    }
    if (hasVariableActivityDecay() != other.hasVariableActivityDecay()) return false;
    if (hasVariableActivityDecay()) {
      if (java.lang.Double.doubleToLongBits(getVariableActivityDecay())
          != java.lang.Double.doubleToLongBits(
              other.getVariableActivityDecay())) return false;
    }
    if (hasMaxVariableActivityValue() != other.hasMaxVariableActivityValue()) return false;
    if (hasMaxVariableActivityValue()) {
      if (java.lang.Double.doubleToLongBits(getMaxVariableActivityValue())
          != java.lang.Double.doubleToLongBits(
              other.getMaxVariableActivityValue())) return false;
    }
    if (hasGlucoseMaxDecay() != other.hasGlucoseMaxDecay()) return false;
    if (hasGlucoseMaxDecay()) {
      if (java.lang.Double.doubleToLongBits(getGlucoseMaxDecay())
          != java.lang.Double.doubleToLongBits(
              other.getGlucoseMaxDecay())) return false;
    }
    if (hasGlucoseDecayIncrement() != other.hasGlucoseDecayIncrement()) return false;
    if (hasGlucoseDecayIncrement()) {
      if (java.lang.Double.doubleToLongBits(getGlucoseDecayIncrement())
          != java.lang.Double.doubleToLongBits(
              other.getGlucoseDecayIncrement())) return false;
    }
    if (hasGlucoseDecayIncrementPeriod() != other.hasGlucoseDecayIncrementPeriod()) return false;
    if (hasGlucoseDecayIncrementPeriod()) {
      if (getGlucoseDecayIncrementPeriod()
          != other.getGlucoseDecayIncrementPeriod()) return false;
    }
    if (hasClauseActivityDecay() != other.hasClauseActivityDecay()) return false;
    if (hasClauseActivityDecay()) {
      if (java.lang.Double.doubleToLongBits(getClauseActivityDecay())
          != java.lang.Double.doubleToLongBits(
              other.getClauseActivityDecay())) return false;
    }
    if (hasMaxClauseActivityValue() != other.hasMaxClauseActivityValue()) return false;
    if (hasMaxClauseActivityValue()) {
      if (java.lang.Double.doubleToLongBits(getMaxClauseActivityValue())
          != java.lang.Double.doubleToLongBits(
              other.getMaxClauseActivityValue())) return false;
    }
    if (!restartAlgorithms_.equals(other.restartAlgorithms_)) return false;
    if (hasDefaultRestartAlgorithms() != other.hasDefaultRestartAlgorithms()) return false;
    if (hasDefaultRestartAlgorithms()) {
      if (!getDefaultRestartAlgorithms()
          .equals(other.getDefaultRestartAlgorithms())) return false;
    }
    if (hasRestartPeriod() != other.hasRestartPeriod()) return false;
    if (hasRestartPeriod()) {
      if (getRestartPeriod()
          != other.getRestartPeriod()) return false;
    }
    if (hasRestartRunningWindowSize() != other.hasRestartRunningWindowSize()) return false;
    if (hasRestartRunningWindowSize()) {
      if (getRestartRunningWindowSize()
          != other.getRestartRunningWindowSize()) return false;
    }
    if (hasRestartDlAverageRatio() != other.hasRestartDlAverageRatio()) return false;
    if (hasRestartDlAverageRatio()) {
      if (java.lang.Double.doubleToLongBits(getRestartDlAverageRatio())
          != java.lang.Double.doubleToLongBits(
              other.getRestartDlAverageRatio())) return false;
    }
    if (hasRestartLbdAverageRatio() != other.hasRestartLbdAverageRatio()) return false;
    if (hasRestartLbdAverageRatio()) {
      if (java.lang.Double.doubleToLongBits(getRestartLbdAverageRatio())
          != java.lang.Double.doubleToLongBits(
              other.getRestartLbdAverageRatio())) return false;
    }
    if (hasUseBlockingRestart() != other.hasUseBlockingRestart()) return false;
    if (hasUseBlockingRestart()) {
      if (getUseBlockingRestart()
          != other.getUseBlockingRestart()) return false;
    }
    if (hasBlockingRestartWindowSize() != other.hasBlockingRestartWindowSize()) return false;
    if (hasBlockingRestartWindowSize()) {
      if (getBlockingRestartWindowSize()
          != other.getBlockingRestartWindowSize()) return false;
    }
    if (hasBlockingRestartMultiplier() != other.hasBlockingRestartMultiplier()) return false;
    if (hasBlockingRestartMultiplier()) {
      if (java.lang.Double.doubleToLongBits(getBlockingRestartMultiplier())
          != java.lang.Double.doubleToLongBits(
              other.getBlockingRestartMultiplier())) return false;
    }
    if (hasNumConflictsBeforeStrategyChanges() != other.hasNumConflictsBeforeStrategyChanges()) return false;
    if (hasNumConflictsBeforeStrategyChanges()) {
      if (getNumConflictsBeforeStrategyChanges()
          != other.getNumConflictsBeforeStrategyChanges()) return false;
    }
    if (hasStrategyChangeIncreaseRatio() != other.hasStrategyChangeIncreaseRatio()) return false;
    if (hasStrategyChangeIncreaseRatio()) {
      if (java.lang.Double.doubleToLongBits(getStrategyChangeIncreaseRatio())
          != java.lang.Double.doubleToLongBits(
              other.getStrategyChangeIncreaseRatio())) return false;
    }
    if (hasMaxTimeInSeconds() != other.hasMaxTimeInSeconds()) return false;
    if (hasMaxTimeInSeconds()) {
      if (java.lang.Double.doubleToLongBits(getMaxTimeInSeconds())
          != java.lang.Double.doubleToLongBits(
              other.getMaxTimeInSeconds())) return false;
    }
    if (hasMaxDeterministicTime() != other.hasMaxDeterministicTime()) return false;
    if (hasMaxDeterministicTime()) {
      if (java.lang.Double.doubleToLongBits(getMaxDeterministicTime())
          != java.lang.Double.doubleToLongBits(
              other.getMaxDeterministicTime())) return false;
    }
    if (hasMaxNumDeterministicBatches() != other.hasMaxNumDeterministicBatches()) return false;
    if (hasMaxNumDeterministicBatches()) {
      if (getMaxNumDeterministicBatches()
          != other.getMaxNumDeterministicBatches()) return false;
    }
    if (hasMaxNumberOfConflicts() != other.hasMaxNumberOfConflicts()) return false;
    if (hasMaxNumberOfConflicts()) {
      if (getMaxNumberOfConflicts()
          != other.getMaxNumberOfConflicts()) return false;
    }
    if (hasMaxMemoryInMb() != other.hasMaxMemoryInMb()) return false;
    if (hasMaxMemoryInMb()) {
      if (getMaxMemoryInMb()
          != other.getMaxMemoryInMb()) return false;
    }
    if (hasAbsoluteGapLimit() != other.hasAbsoluteGapLimit()) return false;
    if (hasAbsoluteGapLimit()) {
      if (java.lang.Double.doubleToLongBits(getAbsoluteGapLimit())
          != java.lang.Double.doubleToLongBits(
              other.getAbsoluteGapLimit())) return false;
    }
    if (hasRelativeGapLimit() != other.hasRelativeGapLimit()) return false;
    if (hasRelativeGapLimit()) {
      if (java.lang.Double.doubleToLongBits(getRelativeGapLimit())
          != java.lang.Double.doubleToLongBits(
              other.getRelativeGapLimit())) return false;
    }
    if (hasRandomSeed() != other.hasRandomSeed()) return false;
    if (hasRandomSeed()) {
      if (getRandomSeed()
          != other.getRandomSeed()) return false;
    }
    if (hasPermuteVariableRandomly() != other.hasPermuteVariableRandomly()) return false;
    if (hasPermuteVariableRandomly()) {
      if (getPermuteVariableRandomly()
          != other.getPermuteVariableRandomly()) return false;
    }
    if (hasPermutePresolveConstraintOrder() != other.hasPermutePresolveConstraintOrder()) return false;
    if (hasPermutePresolveConstraintOrder()) {
      if (getPermutePresolveConstraintOrder()
          != other.getPermutePresolveConstraintOrder()) return false;
    }
    if (hasUseAbslRandom() != other.hasUseAbslRandom()) return false;
    if (hasUseAbslRandom()) {
      if (getUseAbslRandom()
          != other.getUseAbslRandom()) return false;
    }
    if (hasLogSearchProgress() != other.hasLogSearchProgress()) return false;
    if (hasLogSearchProgress()) {
      if (getLogSearchProgress()
          != other.getLogSearchProgress()) return false;
    }
    if (hasLogSubsolverStatistics() != other.hasLogSubsolverStatistics()) return false;
    if (hasLogSubsolverStatistics()) {
      if (getLogSubsolverStatistics()
          != other.getLogSubsolverStatistics()) return false;
    }
    if (hasLogPrefix() != other.hasLogPrefix()) return false;
    if (hasLogPrefix()) {
      if (!getLogPrefix()
          .equals(other.getLogPrefix())) return false;
    }
    if (hasLogToStdout() != other.hasLogToStdout()) return false;
    if (hasLogToStdout()) {
      if (getLogToStdout()
          != other.getLogToStdout()) return false;
    }
    if (hasLogToResponse() != other.hasLogToResponse()) return false;
    if (hasLogToResponse()) {
      if (getLogToResponse()
          != other.getLogToResponse()) return false;
    }
    if (hasUsePbResolution() != other.hasUsePbResolution()) return false;
    if (hasUsePbResolution()) {
      if (getUsePbResolution()
          != other.getUsePbResolution()) return false;
    }
    if (hasMinimizeReductionDuringPbResolution() != other.hasMinimizeReductionDuringPbResolution()) return false;
    if (hasMinimizeReductionDuringPbResolution()) {
      if (getMinimizeReductionDuringPbResolution()
          != other.getMinimizeReductionDuringPbResolution()) return false;
    }
    if (hasCountAssumptionLevelsInLbd() != other.hasCountAssumptionLevelsInLbd()) return false;
    if (hasCountAssumptionLevelsInLbd()) {
      if (getCountAssumptionLevelsInLbd()
          != other.getCountAssumptionLevelsInLbd()) return false;
    }
    if (hasPresolveBveThreshold() != other.hasPresolveBveThreshold()) return false;
    if (hasPresolveBveThreshold()) {
      if (getPresolveBveThreshold()
          != other.getPresolveBveThreshold()) return false;
    }
    if (hasPresolveBveClauseWeight() != other.hasPresolveBveClauseWeight()) return false;
    if (hasPresolveBveClauseWeight()) {
      if (getPresolveBveClauseWeight()
          != other.getPresolveBveClauseWeight()) return false;
    }
    if (hasProbingDeterministicTimeLimit() != other.hasProbingDeterministicTimeLimit()) return false;
    if (hasProbingDeterministicTimeLimit()) {
      if (java.lang.Double.doubleToLongBits(getProbingDeterministicTimeLimit())
          != java.lang.Double.doubleToLongBits(
              other.getProbingDeterministicTimeLimit())) return false;
    }
    if (hasPresolveProbingDeterministicTimeLimit() != other.hasPresolveProbingDeterministicTimeLimit()) return false;
    if (hasPresolveProbingDeterministicTimeLimit()) {
      if (java.lang.Double.doubleToLongBits(getPresolveProbingDeterministicTimeLimit())
          != java.lang.Double.doubleToLongBits(
              other.getPresolveProbingDeterministicTimeLimit())) return false;
    }
    if (hasPresolveBlockedClause() != other.hasPresolveBlockedClause()) return false;
    if (hasPresolveBlockedClause()) {
      if (getPresolveBlockedClause()
          != other.getPresolveBlockedClause()) return false;
    }
    if (hasPresolveUseBva() != other.hasPresolveUseBva()) return false;
    if (hasPresolveUseBva()) {
      if (getPresolveUseBva()
          != other.getPresolveUseBva()) return false;
    }
    if (hasPresolveBvaThreshold() != other.hasPresolveBvaThreshold()) return false;
    if (hasPresolveBvaThreshold()) {
      if (getPresolveBvaThreshold()
          != other.getPresolveBvaThreshold()) return false;
    }
    if (hasMaxPresolveIterations() != other.hasMaxPresolveIterations()) return false;
    if (hasMaxPresolveIterations()) {
      if (getMaxPresolveIterations()
          != other.getMaxPresolveIterations()) return false;
    }
    if (hasCpModelPresolve() != other.hasCpModelPresolve()) return false;
    if (hasCpModelPresolve()) {
      if (getCpModelPresolve()
          != other.getCpModelPresolve()) return false;
    }
    if (hasCpModelProbingLevel() != other.hasCpModelProbingLevel()) return false;
    if (hasCpModelProbingLevel()) {
      if (getCpModelProbingLevel()
          != other.getCpModelProbingLevel()) return false;
    }
    if (hasCpModelUseSatPresolve() != other.hasCpModelUseSatPresolve()) return false;
    if (hasCpModelUseSatPresolve()) {
      if (getCpModelUseSatPresolve()
          != other.getCpModelUseSatPresolve()) return false;
    }
    if (hasDetectTableWithCost() != other.hasDetectTableWithCost()) return false;
    if (hasDetectTableWithCost()) {
      if (getDetectTableWithCost()
          != other.getDetectTableWithCost()) return false;
    }
    if (hasTableCompressionLevel() != other.hasTableCompressionLevel()) return false;
    if (hasTableCompressionLevel()) {
      if (getTableCompressionLevel()
          != other.getTableCompressionLevel()) return false;
    }
    if (hasExpandAlldiffConstraints() != other.hasExpandAlldiffConstraints()) return false;
    if (hasExpandAlldiffConstraints()) {
      if (getExpandAlldiffConstraints()
          != other.getExpandAlldiffConstraints()) return false;
    }
    if (hasExpandReservoirConstraints() != other.hasExpandReservoirConstraints()) return false;
    if (hasExpandReservoirConstraints()) {
      if (getExpandReservoirConstraints()
          != other.getExpandReservoirConstraints()) return false;
    }
    if (hasExpandReservoirUsingCircuit() != other.hasExpandReservoirUsingCircuit()) return false;
    if (hasExpandReservoirUsingCircuit()) {
      if (getExpandReservoirUsingCircuit()
          != other.getExpandReservoirUsingCircuit()) return false;
    }
    if (hasEncodeCumulativeAsReservoir() != other.hasEncodeCumulativeAsReservoir()) return false;
    if (hasEncodeCumulativeAsReservoir()) {
      if (getEncodeCumulativeAsReservoir()
          != other.getEncodeCumulativeAsReservoir()) return false;
    }
    if (hasMaxLinMaxSizeForExpansion() != other.hasMaxLinMaxSizeForExpansion()) return false;
    if (hasMaxLinMaxSizeForExpansion()) {
      if (getMaxLinMaxSizeForExpansion()
          != other.getMaxLinMaxSizeForExpansion()) return false;
    }
    if (hasDisableConstraintExpansion() != other.hasDisableConstraintExpansion()) return false;
    if (hasDisableConstraintExpansion()) {
      if (getDisableConstraintExpansion()
          != other.getDisableConstraintExpansion()) return false;
    }
    if (hasEncodeComplexLinearConstraintWithInteger() != other.hasEncodeComplexLinearConstraintWithInteger()) return false;
    if (hasEncodeComplexLinearConstraintWithInteger()) {
      if (getEncodeComplexLinearConstraintWithInteger()
          != other.getEncodeComplexLinearConstraintWithInteger()) return false;
    }
    if (hasMergeNoOverlapWorkLimit() != other.hasMergeNoOverlapWorkLimit()) return false;
    if (hasMergeNoOverlapWorkLimit()) {
      if (java.lang.Double.doubleToLongBits(getMergeNoOverlapWorkLimit())
          != java.lang.Double.doubleToLongBits(
              other.getMergeNoOverlapWorkLimit())) return false;
    }
    if (hasMergeAtMostOneWorkLimit() != other.hasMergeAtMostOneWorkLimit()) return false;
    if (hasMergeAtMostOneWorkLimit()) {
      if (java.lang.Double.doubleToLongBits(getMergeAtMostOneWorkLimit())
          != java.lang.Double.doubleToLongBits(
              other.getMergeAtMostOneWorkLimit())) return false;
    }
    if (hasPresolveSubstitutionLevel() != other.hasPresolveSubstitutionLevel()) return false;
    if (hasPresolveSubstitutionLevel()) {
      if (getPresolveSubstitutionLevel()
          != other.getPresolveSubstitutionLevel()) return false;
    }
    if (hasPresolveExtractIntegerEnforcement() != other.hasPresolveExtractIntegerEnforcement()) return false;
    if (hasPresolveExtractIntegerEnforcement()) {
      if (getPresolveExtractIntegerEnforcement()
          != other.getPresolveExtractIntegerEnforcement()) return false;
    }
    if (hasPresolveInclusionWorkLimit() != other.hasPresolveInclusionWorkLimit()) return false;
    if (hasPresolveInclusionWorkLimit()) {
      if (getPresolveInclusionWorkLimit()
          != other.getPresolveInclusionWorkLimit()) return false;
    }
    if (hasIgnoreNames() != other.hasIgnoreNames()) return false;
    if (hasIgnoreNames()) {
      if (getIgnoreNames()
          != other.getIgnoreNames()) return false;
    }
    if (hasInferAllDiffs() != other.hasInferAllDiffs()) return false;
    if (hasInferAllDiffs()) {
      if (getInferAllDiffs()
          != other.getInferAllDiffs()) return false;
    }
    if (hasFindBigLinearOverlap() != other.hasFindBigLinearOverlap()) return false;
    if (hasFindBigLinearOverlap()) {
      if (getFindBigLinearOverlap()
          != other.getFindBigLinearOverlap()) return false;
    }
    if (hasUseSatInprocessing() != other.hasUseSatInprocessing()) return false;
    if (hasUseSatInprocessing()) {
      if (getUseSatInprocessing()
          != other.getUseSatInprocessing()) return false;
    }
    if (hasInprocessingDtimeRatio() != other.hasInprocessingDtimeRatio()) return false;
    if (hasInprocessingDtimeRatio()) {
      if (java.lang.Double.doubleToLongBits(getInprocessingDtimeRatio())
          != java.lang.Double.doubleToLongBits(
              other.getInprocessingDtimeRatio())) return false;
    }
    if (hasInprocessingProbingDtime() != other.hasInprocessingProbingDtime()) return false;
    if (hasInprocessingProbingDtime()) {
      if (java.lang.Double.doubleToLongBits(getInprocessingProbingDtime())
          != java.lang.Double.doubleToLongBits(
              other.getInprocessingProbingDtime())) return false;
    }
    if (hasInprocessingMinimizationDtime() != other.hasInprocessingMinimizationDtime()) return false;
    if (hasInprocessingMinimizationDtime()) {
      if (java.lang.Double.doubleToLongBits(getInprocessingMinimizationDtime())
          != java.lang.Double.doubleToLongBits(
              other.getInprocessingMinimizationDtime())) return false;
    }
    if (hasNumWorkers() != other.hasNumWorkers()) return false;
    if (hasNumWorkers()) {
      if (getNumWorkers()
          != other.getNumWorkers()) return false;
    }
    if (hasNumSearchWorkers() != other.hasNumSearchWorkers()) return false;
    if (hasNumSearchWorkers()) {
      if (getNumSearchWorkers()
          != other.getNumSearchWorkers()) return false;
    }
    if (hasNumFullSubsolvers() != other.hasNumFullSubsolvers()) return false;
    if (hasNumFullSubsolvers()) {
      if (getNumFullSubsolvers()
          != other.getNumFullSubsolvers()) return false;
    }
    if (!getSubsolversList()
        .equals(other.getSubsolversList())) return false;
    if (!getExtraSubsolversList()
        .equals(other.getExtraSubsolversList())) return false;
    if (!getIgnoreSubsolversList()
        .equals(other.getIgnoreSubsolversList())) return false;
    if (!getFilterSubsolversList()
        .equals(other.getFilterSubsolversList())) return false;
    if (!getSubsolverParamsList()
        .equals(other.getSubsolverParamsList())) return false;
    if (hasInterleaveSearch() != other.hasInterleaveSearch()) return false;
    if (hasInterleaveSearch()) {
      if (getInterleaveSearch()
          != other.getInterleaveSearch()) return false;
    }
    if (hasInterleaveBatchSize() != other.hasInterleaveBatchSize()) return false;
    if (hasInterleaveBatchSize()) {
      if (getInterleaveBatchSize()
          != other.getInterleaveBatchSize()) return false;
    }
    if (hasShareObjectiveBounds() != other.hasShareObjectiveBounds()) return false;
    if (hasShareObjectiveBounds()) {
      if (getShareObjectiveBounds()
          != other.getShareObjectiveBounds()) return false;
    }
    if (hasShareLevelZeroBounds() != other.hasShareLevelZeroBounds()) return false;
    if (hasShareLevelZeroBounds()) {
      if (getShareLevelZeroBounds()
          != other.getShareLevelZeroBounds()) return false;
    }
    if (hasShareBinaryClauses() != other.hasShareBinaryClauses()) return false;
    if (hasShareBinaryClauses()) {
      if (getShareBinaryClauses()
          != other.getShareBinaryClauses()) return false;
    }
    if (hasShareGlueClauses() != other.hasShareGlueClauses()) return false;
    if (hasShareGlueClauses()) {
      if (getShareGlueClauses()
          != other.getShareGlueClauses()) return false;
    }
    if (hasDebugPostsolveWithFullSolver() != other.hasDebugPostsolveWithFullSolver()) return false;
    if (hasDebugPostsolveWithFullSolver()) {
      if (getDebugPostsolveWithFullSolver()
          != other.getDebugPostsolveWithFullSolver()) return false;
    }
    if (hasDebugMaxNumPresolveOperations() != other.hasDebugMaxNumPresolveOperations()) return false;
    if (hasDebugMaxNumPresolveOperations()) {
      if (getDebugMaxNumPresolveOperations()
          != other.getDebugMaxNumPresolveOperations()) return false;
    }
    if (hasDebugCrashOnBadHint() != other.hasDebugCrashOnBadHint()) return false;
    if (hasDebugCrashOnBadHint()) {
      if (getDebugCrashOnBadHint()
          != other.getDebugCrashOnBadHint()) return false;
    }
    if (hasUseOptimizationHints() != other.hasUseOptimizationHints()) return false;
    if (hasUseOptimizationHints()) {
      if (getUseOptimizationHints()
          != other.getUseOptimizationHints()) return false;
    }
    if (hasCoreMinimizationLevel() != other.hasCoreMinimizationLevel()) return false;
    if (hasCoreMinimizationLevel()) {
      if (getCoreMinimizationLevel()
          != other.getCoreMinimizationLevel()) return false;
    }
    if (hasFindMultipleCores() != other.hasFindMultipleCores()) return false;
    if (hasFindMultipleCores()) {
      if (getFindMultipleCores()
          != other.getFindMultipleCores()) return false;
    }
    if (hasCoverOptimization() != other.hasCoverOptimization()) return false;
    if (hasCoverOptimization()) {
      if (getCoverOptimization()
          != other.getCoverOptimization()) return false;
    }
    if (hasMaxSatAssumptionOrder() != other.hasMaxSatAssumptionOrder()) return false;
    if (hasMaxSatAssumptionOrder()) {
      if (maxSatAssumptionOrder_ != other.maxSatAssumptionOrder_) return false;
    }
    if (hasMaxSatReverseAssumptionOrder() != other.hasMaxSatReverseAssumptionOrder()) return false;
    if (hasMaxSatReverseAssumptionOrder()) {
      if (getMaxSatReverseAssumptionOrder()
          != other.getMaxSatReverseAssumptionOrder()) return false;
    }
    if (hasMaxSatStratification() != other.hasMaxSatStratification()) return false;
    if (hasMaxSatStratification()) {
      if (maxSatStratification_ != other.maxSatStratification_) return false;
    }
    if (hasPropagationLoopDetectionFactor() != other.hasPropagationLoopDetectionFactor()) return false;
    if (hasPropagationLoopDetectionFactor()) {
      if (java.lang.Double.doubleToLongBits(getPropagationLoopDetectionFactor())
          != java.lang.Double.doubleToLongBits(
              other.getPropagationLoopDetectionFactor())) return false;
    }
    if (hasUsePrecedencesInDisjunctiveConstraint() != other.hasUsePrecedencesInDisjunctiveConstraint()) return false;
    if (hasUsePrecedencesInDisjunctiveConstraint()) {
      if (getUsePrecedencesInDisjunctiveConstraint()
          != other.getUsePrecedencesInDisjunctiveConstraint()) return false;
    }
    if (hasMaxSizeToCreatePrecedenceLiteralsInDisjunctive() != other.hasMaxSizeToCreatePrecedenceLiteralsInDisjunctive()) return false;
    if (hasMaxSizeToCreatePrecedenceLiteralsInDisjunctive()) {
      if (getMaxSizeToCreatePrecedenceLiteralsInDisjunctive()
          != other.getMaxSizeToCreatePrecedenceLiteralsInDisjunctive()) return false;
    }
    if (hasUseStrongPropagationInDisjunctive() != other.hasUseStrongPropagationInDisjunctive()) return false;
    if (hasUseStrongPropagationInDisjunctive()) {
      if (getUseStrongPropagationInDisjunctive()
          != other.getUseStrongPropagationInDisjunctive()) return false;
    }
    if (hasUseDynamicPrecedenceInDisjunctive() != other.hasUseDynamicPrecedenceInDisjunctive()) return false;
    if (hasUseDynamicPrecedenceInDisjunctive()) {
      if (getUseDynamicPrecedenceInDisjunctive()
          != other.getUseDynamicPrecedenceInDisjunctive()) return false;
    }
    if (hasUseDynamicPrecedenceInCumulative() != other.hasUseDynamicPrecedenceInCumulative()) return false;
    if (hasUseDynamicPrecedenceInCumulative()) {
      if (getUseDynamicPrecedenceInCumulative()
          != other.getUseDynamicPrecedenceInCumulative()) return false;
    }
    if (hasUseOverloadCheckerInCumulative() != other.hasUseOverloadCheckerInCumulative()) return false;
    if (hasUseOverloadCheckerInCumulative()) {
      if (getUseOverloadCheckerInCumulative()
          != other.getUseOverloadCheckerInCumulative()) return false;
    }
    if (hasUseConservativeScaleOverloadChecker() != other.hasUseConservativeScaleOverloadChecker()) return false;
    if (hasUseConservativeScaleOverloadChecker()) {
      if (getUseConservativeScaleOverloadChecker()
          != other.getUseConservativeScaleOverloadChecker()) return false;
    }
    if (hasUseTimetableEdgeFindingInCumulative() != other.hasUseTimetableEdgeFindingInCumulative()) return false;
    if (hasUseTimetableEdgeFindingInCumulative()) {
      if (getUseTimetableEdgeFindingInCumulative()
          != other.getUseTimetableEdgeFindingInCumulative()) return false;
    }
    if (hasMaxNumIntervalsForTimetableEdgeFinding() != other.hasMaxNumIntervalsForTimetableEdgeFinding()) return false;
    if (hasMaxNumIntervalsForTimetableEdgeFinding()) {
      if (getMaxNumIntervalsForTimetableEdgeFinding()
          != other.getMaxNumIntervalsForTimetableEdgeFinding()) return false;
    }
    if (hasUseHardPrecedencesInCumulative() != other.hasUseHardPrecedencesInCumulative()) return false;
    if (hasUseHardPrecedencesInCumulative()) {
      if (getUseHardPrecedencesInCumulative()
          != other.getUseHardPrecedencesInCumulative()) return false;
    }
    if (hasExploitAllPrecedences() != other.hasExploitAllPrecedences()) return false;
    if (hasExploitAllPrecedences()) {
      if (getExploitAllPrecedences()
          != other.getExploitAllPrecedences()) return false;
    }
    if (hasUseDisjunctiveConstraintInCumulative() != other.hasUseDisjunctiveConstraintInCumulative()) return false;
    if (hasUseDisjunctiveConstraintInCumulative()) {
      if (getUseDisjunctiveConstraintInCumulative()
          != other.getUseDisjunctiveConstraintInCumulative()) return false;
    }
    if (hasUseTimetablingInNoOverlap2D() != other.hasUseTimetablingInNoOverlap2D()) return false;
    if (hasUseTimetablingInNoOverlap2D()) {
      if (getUseTimetablingInNoOverlap2D()
          != other.getUseTimetablingInNoOverlap2D()) return false;
    }
    if (hasUseEnergeticReasoningInNoOverlap2D() != other.hasUseEnergeticReasoningInNoOverlap2D()) return false;
    if (hasUseEnergeticReasoningInNoOverlap2D()) {
      if (getUseEnergeticReasoningInNoOverlap2D()
          != other.getUseEnergeticReasoningInNoOverlap2D()) return false;
    }
    if (hasUseAreaEnergeticReasoningInNoOverlap2D() != other.hasUseAreaEnergeticReasoningInNoOverlap2D()) return false;
    if (hasUseAreaEnergeticReasoningInNoOverlap2D()) {
      if (getUseAreaEnergeticReasoningInNoOverlap2D()
          != other.getUseAreaEnergeticReasoningInNoOverlap2D()) return false;
    }
    if (hasMaxPairsPairwiseReasoningInNoOverlap2D() != other.hasMaxPairsPairwiseReasoningInNoOverlap2D()) return false;
    if (hasMaxPairsPairwiseReasoningInNoOverlap2D()) {
      if (getMaxPairsPairwiseReasoningInNoOverlap2D()
          != other.getMaxPairsPairwiseReasoningInNoOverlap2D()) return false;
    }
    if (hasUseDualSchedulingHeuristics() != other.hasUseDualSchedulingHeuristics()) return false;
    if (hasUseDualSchedulingHeuristics()) {
      if (getUseDualSchedulingHeuristics()
          != other.getUseDualSchedulingHeuristics()) return false;
    }
    if (hasSearchBranching() != other.hasSearchBranching()) return false;
    if (hasSearchBranching()) {
      if (searchBranching_ != other.searchBranching_) return false;
    }
    if (hasHintConflictLimit() != other.hasHintConflictLimit()) return false;
    if (hasHintConflictLimit()) {
      if (getHintConflictLimit()
          != other.getHintConflictLimit()) return false;
    }
    if (hasRepairHint() != other.hasRepairHint()) return false;
    if (hasRepairHint()) {
      if (getRepairHint()
          != other.getRepairHint()) return false;
    }
    if (hasFixVariablesToTheirHintedValue() != other.hasFixVariablesToTheirHintedValue()) return false;
    if (hasFixVariablesToTheirHintedValue()) {
      if (getFixVariablesToTheirHintedValue()
          != other.getFixVariablesToTheirHintedValue()) return false;
    }
    if (hasUseProbingSearch() != other.hasUseProbingSearch()) return false;
    if (hasUseProbingSearch()) {
      if (getUseProbingSearch()
          != other.getUseProbingSearch()) return false;
    }
    if (hasUseExtendedProbing() != other.hasUseExtendedProbing()) return false;
    if (hasUseExtendedProbing()) {
      if (getUseExtendedProbing()
          != other.getUseExtendedProbing()) return false;
    }
    if (hasProbingNumCombinationsLimit() != other.hasProbingNumCombinationsLimit()) return false;
    if (hasProbingNumCombinationsLimit()) {
      if (getProbingNumCombinationsLimit()
          != other.getProbingNumCombinationsLimit()) return false;
    }
    if (hasUseShavingInProbingSearch() != other.hasUseShavingInProbingSearch()) return false;
    if (hasUseShavingInProbingSearch()) {
      if (getUseShavingInProbingSearch()
          != other.getUseShavingInProbingSearch()) return false;
    }
    if (hasShavingSearchDeterministicTime() != other.hasShavingSearchDeterministicTime()) return false;
    if (hasShavingSearchDeterministicTime()) {
      if (java.lang.Double.doubleToLongBits(getShavingSearchDeterministicTime())
          != java.lang.Double.doubleToLongBits(
              other.getShavingSearchDeterministicTime())) return false;
    }
    if (hasShavingSearchThreshold() != other.hasShavingSearchThreshold()) return false;
    if (hasShavingSearchThreshold()) {
      if (getShavingSearchThreshold()
          != other.getShavingSearchThreshold()) return false;
    }
    if (hasUseObjectiveLbSearch() != other.hasUseObjectiveLbSearch()) return false;
    if (hasUseObjectiveLbSearch()) {
      if (getUseObjectiveLbSearch()
          != other.getUseObjectiveLbSearch()) return false;
    }
    if (hasUseObjectiveShavingSearch() != other.hasUseObjectiveShavingSearch()) return false;
    if (hasUseObjectiveShavingSearch()) {
      if (getUseObjectiveShavingSearch()
          != other.getUseObjectiveShavingSearch()) return false;
    }
    if (hasUseVariablesShavingSearch() != other.hasUseVariablesShavingSearch()) return false;
    if (hasUseVariablesShavingSearch()) {
      if (getUseVariablesShavingSearch()
          != other.getUseVariablesShavingSearch()) return false;
    }
    if (hasPseudoCostReliabilityThreshold() != other.hasPseudoCostReliabilityThreshold()) return false;
    if (hasPseudoCostReliabilityThreshold()) {
      if (getPseudoCostReliabilityThreshold()
          != other.getPseudoCostReliabilityThreshold()) return false;
    }
    if (hasOptimizeWithCore() != other.hasOptimizeWithCore()) return false;
    if (hasOptimizeWithCore()) {
      if (getOptimizeWithCore()
          != other.getOptimizeWithCore()) return false;
    }
    if (hasOptimizeWithLbTreeSearch() != other.hasOptimizeWithLbTreeSearch()) return false;
    if (hasOptimizeWithLbTreeSearch()) {
      if (getOptimizeWithLbTreeSearch()
          != other.getOptimizeWithLbTreeSearch()) return false;
    }
    if (hasSaveLpBasisInLbTreeSearch() != other.hasSaveLpBasisInLbTreeSearch()) return false;
    if (hasSaveLpBasisInLbTreeSearch()) {
      if (getSaveLpBasisInLbTreeSearch()
          != other.getSaveLpBasisInLbTreeSearch()) return false;
    }
    if (hasBinarySearchNumConflicts() != other.hasBinarySearchNumConflicts()) return false;
    if (hasBinarySearchNumConflicts()) {
      if (getBinarySearchNumConflicts()
          != other.getBinarySearchNumConflicts()) return false;
    }
    if (hasOptimizeWithMaxHs() != other.hasOptimizeWithMaxHs()) return false;
    if (hasOptimizeWithMaxHs()) {
      if (getOptimizeWithMaxHs()
          != other.getOptimizeWithMaxHs()) return false;
    }
    if (hasUseFeasibilityJump() != other.hasUseFeasibilityJump()) return false;
    if (hasUseFeasibilityJump()) {
      if (getUseFeasibilityJump()
          != other.getUseFeasibilityJump()) return false;
    }
    if (hasUseLsOnly() != other.hasUseLsOnly()) return false;
    if (hasUseLsOnly()) {
      if (getUseLsOnly()
          != other.getUseLsOnly()) return false;
    }
    if (hasFeasibilityJumpDecay() != other.hasFeasibilityJumpDecay()) return false;
    if (hasFeasibilityJumpDecay()) {
      if (java.lang.Double.doubleToLongBits(getFeasibilityJumpDecay())
          != java.lang.Double.doubleToLongBits(
              other.getFeasibilityJumpDecay())) return false;
    }
    if (hasFeasibilityJumpLinearizationLevel() != other.hasFeasibilityJumpLinearizationLevel()) return false;
    if (hasFeasibilityJumpLinearizationLevel()) {
      if (getFeasibilityJumpLinearizationLevel()
          != other.getFeasibilityJumpLinearizationLevel()) return false;
    }
    if (hasFeasibilityJumpRestartFactor() != other.hasFeasibilityJumpRestartFactor()) return false;
    if (hasFeasibilityJumpRestartFactor()) {
      if (getFeasibilityJumpRestartFactor()
          != other.getFeasibilityJumpRestartFactor()) return false;
    }
    if (hasFeasibilityJumpBatchDtime() != other.hasFeasibilityJumpBatchDtime()) return false;
    if (hasFeasibilityJumpBatchDtime()) {
      if (java.lang.Double.doubleToLongBits(getFeasibilityJumpBatchDtime())
          != java.lang.Double.doubleToLongBits(
              other.getFeasibilityJumpBatchDtime())) return false;
    }
    if (hasFeasibilityJumpVarRandomizationProbability() != other.hasFeasibilityJumpVarRandomizationProbability()) return false;
    if (hasFeasibilityJumpVarRandomizationProbability()) {
      if (java.lang.Double.doubleToLongBits(getFeasibilityJumpVarRandomizationProbability())
          != java.lang.Double.doubleToLongBits(
              other.getFeasibilityJumpVarRandomizationProbability())) return false;
    }
    if (hasFeasibilityJumpVarPerburbationRangeRatio() != other.hasFeasibilityJumpVarPerburbationRangeRatio()) return false;
    if (hasFeasibilityJumpVarPerburbationRangeRatio()) {
      if (java.lang.Double.doubleToLongBits(getFeasibilityJumpVarPerburbationRangeRatio())
          != java.lang.Double.doubleToLongBits(
              other.getFeasibilityJumpVarPerburbationRangeRatio())) return false;
    }
    if (hasFeasibilityJumpEnableRestarts() != other.hasFeasibilityJumpEnableRestarts()) return false;
    if (hasFeasibilityJumpEnableRestarts()) {
      if (getFeasibilityJumpEnableRestarts()
          != other.getFeasibilityJumpEnableRestarts()) return false;
    }
    if (hasFeasibilityJumpMaxExpandedConstraintSize() != other.hasFeasibilityJumpMaxExpandedConstraintSize()) return false;
    if (hasFeasibilityJumpMaxExpandedConstraintSize()) {
      if (getFeasibilityJumpMaxExpandedConstraintSize()
          != other.getFeasibilityJumpMaxExpandedConstraintSize()) return false;
    }
    if (hasNumViolationLs() != other.hasNumViolationLs()) return false;
    if (hasNumViolationLs()) {
      if (getNumViolationLs()
          != other.getNumViolationLs()) return false;
    }
    if (hasViolationLsPerturbationPeriod() != other.hasViolationLsPerturbationPeriod()) return false;
    if (hasViolationLsPerturbationPeriod()) {
      if (getViolationLsPerturbationPeriod()
          != other.getViolationLsPerturbationPeriod()) return false;
    }
    if (hasViolationLsCompoundMoveProbability() != other.hasViolationLsCompoundMoveProbability()) return false;
    if (hasViolationLsCompoundMoveProbability()) {
      if (java.lang.Double.doubleToLongBits(getViolationLsCompoundMoveProbability())
          != java.lang.Double.doubleToLongBits(
              other.getViolationLsCompoundMoveProbability())) return false;
    }
    if (hasSharedTreeNumWorkers() != other.hasSharedTreeNumWorkers()) return false;
    if (hasSharedTreeNumWorkers()) {
      if (getSharedTreeNumWorkers()
          != other.getSharedTreeNumWorkers()) return false;
    }
    if (hasUseSharedTreeSearch() != other.hasUseSharedTreeSearch()) return false;
    if (hasUseSharedTreeSearch()) {
      if (getUseSharedTreeSearch()
          != other.getUseSharedTreeSearch()) return false;
    }
    if (hasSharedTreeWorkerObjectiveSplitProbability() != other.hasSharedTreeWorkerObjectiveSplitProbability()) return false;
    if (hasSharedTreeWorkerObjectiveSplitProbability()) {
      if (java.lang.Double.doubleToLongBits(getSharedTreeWorkerObjectiveSplitProbability())
          != java.lang.Double.doubleToLongBits(
              other.getSharedTreeWorkerObjectiveSplitProbability())) return false;
    }
    if (hasSharedTreeWorkerMinRestartsPerSubtree() != other.hasSharedTreeWorkerMinRestartsPerSubtree()) return false;
    if (hasSharedTreeWorkerMinRestartsPerSubtree()) {
      if (getSharedTreeWorkerMinRestartsPerSubtree()
          != other.getSharedTreeWorkerMinRestartsPerSubtree()) return false;
    }
    if (hasSharedTreeWorkerEnableTrailSharing() != other.hasSharedTreeWorkerEnableTrailSharing()) return false;
    if (hasSharedTreeWorkerEnableTrailSharing()) {
      if (getSharedTreeWorkerEnableTrailSharing()
          != other.getSharedTreeWorkerEnableTrailSharing()) return false;
    }
    if (hasSharedTreeOpenLeavesPerWorker() != other.hasSharedTreeOpenLeavesPerWorker()) return false;
    if (hasSharedTreeOpenLeavesPerWorker()) {
      if (java.lang.Double.doubleToLongBits(getSharedTreeOpenLeavesPerWorker())
          != java.lang.Double.doubleToLongBits(
              other.getSharedTreeOpenLeavesPerWorker())) return false;
    }
    if (hasSharedTreeMaxNodesPerWorker() != other.hasSharedTreeMaxNodesPerWorker()) return false;
    if (hasSharedTreeMaxNodesPerWorker()) {
      if (getSharedTreeMaxNodesPerWorker()
          != other.getSharedTreeMaxNodesPerWorker()) return false;
    }
    if (hasSharedTreeSplitStrategy() != other.hasSharedTreeSplitStrategy()) return false;
    if (hasSharedTreeSplitStrategy()) {
      if (sharedTreeSplitStrategy_ != other.sharedTreeSplitStrategy_) return false;
    }
    if (hasEnumerateAllSolutions() != other.hasEnumerateAllSolutions()) return false;
    if (hasEnumerateAllSolutions()) {
      if (getEnumerateAllSolutions()
          != other.getEnumerateAllSolutions()) return false;
    }
    if (hasKeepAllFeasibleSolutionsInPresolve() != other.hasKeepAllFeasibleSolutionsInPresolve()) return false;
    if (hasKeepAllFeasibleSolutionsInPresolve()) {
      if (getKeepAllFeasibleSolutionsInPresolve()
          != other.getKeepAllFeasibleSolutionsInPresolve()) return false;
    }
    if (hasFillTightenedDomainsInResponse() != other.hasFillTightenedDomainsInResponse()) return false;
    if (hasFillTightenedDomainsInResponse()) {
      if (getFillTightenedDomainsInResponse()
          != other.getFillTightenedDomainsInResponse()) return false;
    }
    if (hasFillAdditionalSolutionsInResponse() != other.hasFillAdditionalSolutionsInResponse()) return false;
    if (hasFillAdditionalSolutionsInResponse()) {
      if (getFillAdditionalSolutionsInResponse()
          != other.getFillAdditionalSolutionsInResponse()) return false;
    }
    if (hasInstantiateAllVariables() != other.hasInstantiateAllVariables()) return false;
    if (hasInstantiateAllVariables()) {
      if (getInstantiateAllVariables()
          != other.getInstantiateAllVariables()) return false;
    }
    if (hasAutoDetectGreaterThanAtLeastOneOf() != other.hasAutoDetectGreaterThanAtLeastOneOf()) return false;
    if (hasAutoDetectGreaterThanAtLeastOneOf()) {
      if (getAutoDetectGreaterThanAtLeastOneOf()
          != other.getAutoDetectGreaterThanAtLeastOneOf()) return false;
    }
    if (hasStopAfterFirstSolution() != other.hasStopAfterFirstSolution()) return false;
    if (hasStopAfterFirstSolution()) {
      if (getStopAfterFirstSolution()
          != other.getStopAfterFirstSolution()) return false;
    }
    if (hasStopAfterPresolve() != other.hasStopAfterPresolve()) return false;
    if (hasStopAfterPresolve()) {
      if (getStopAfterPresolve()
          != other.getStopAfterPresolve()) return false;
    }
    if (hasStopAfterRootPropagation() != other.hasStopAfterRootPropagation()) return false;
    if (hasStopAfterRootPropagation()) {
      if (getStopAfterRootPropagation()
          != other.getStopAfterRootPropagation()) return false;
    }
    if (hasUseLns() != other.hasUseLns()) return false;
    if (hasUseLns()) {
      if (getUseLns()
          != other.getUseLns()) return false;
    }
    if (hasUseLnsOnly() != other.hasUseLnsOnly()) return false;
    if (hasUseLnsOnly()) {
      if (getUseLnsOnly()
          != other.getUseLnsOnly()) return false;
    }
    if (hasSolutionPoolSize() != other.hasSolutionPoolSize()) return false;
    if (hasSolutionPoolSize()) {
      if (getSolutionPoolSize()
          != other.getSolutionPoolSize()) return false;
    }
    if (hasUseRinsLns() != other.hasUseRinsLns()) return false;
    if (hasUseRinsLns()) {
      if (getUseRinsLns()
          != other.getUseRinsLns()) return false;
    }
    if (hasUseFeasibilityPump() != other.hasUseFeasibilityPump()) return false;
    if (hasUseFeasibilityPump()) {
      if (getUseFeasibilityPump()
          != other.getUseFeasibilityPump()) return false;
    }
    if (hasUseLbRelaxLns() != other.hasUseLbRelaxLns()) return false;
    if (hasUseLbRelaxLns()) {
      if (getUseLbRelaxLns()
          != other.getUseLbRelaxLns()) return false;
    }
    if (hasFpRounding() != other.hasFpRounding()) return false;
    if (hasFpRounding()) {
      if (fpRounding_ != other.fpRounding_) return false;
    }
    if (hasDiversifyLnsParams() != other.hasDiversifyLnsParams()) return false;
    if (hasDiversifyLnsParams()) {
      if (getDiversifyLnsParams()
          != other.getDiversifyLnsParams()) return false;
    }
    if (hasRandomizeSearch() != other.hasRandomizeSearch()) return false;
    if (hasRandomizeSearch()) {
      if (getRandomizeSearch()
          != other.getRandomizeSearch()) return false;
    }
    if (hasSearchRandomVariablePoolSize() != other.hasSearchRandomVariablePoolSize()) return false;
    if (hasSearchRandomVariablePoolSize()) {
      if (getSearchRandomVariablePoolSize()
          != other.getSearchRandomVariablePoolSize()) return false;
    }
    if (hasPushAllTasksTowardStart() != other.hasPushAllTasksTowardStart()) return false;
    if (hasPushAllTasksTowardStart()) {
      if (getPushAllTasksTowardStart()
          != other.getPushAllTasksTowardStart()) return false;
    }
    if (hasUseOptionalVariables() != other.hasUseOptionalVariables()) return false;
    if (hasUseOptionalVariables()) {
      if (getUseOptionalVariables()
          != other.getUseOptionalVariables()) return false;
    }
    if (hasUseExactLpReason() != other.hasUseExactLpReason()) return false;
    if (hasUseExactLpReason()) {
      if (getUseExactLpReason()
          != other.getUseExactLpReason()) return false;
    }
    if (hasUseCombinedNoOverlap() != other.hasUseCombinedNoOverlap()) return false;
    if (hasUseCombinedNoOverlap()) {
      if (getUseCombinedNoOverlap()
          != other.getUseCombinedNoOverlap()) return false;
    }
    if (hasAtMostOneMaxExpansionSize() != other.hasAtMostOneMaxExpansionSize()) return false;
    if (hasAtMostOneMaxExpansionSize()) {
      if (getAtMostOneMaxExpansionSize()
          != other.getAtMostOneMaxExpansionSize()) return false;
    }
    if (hasCatchSigintSignal() != other.hasCatchSigintSignal()) return false;
    if (hasCatchSigintSignal()) {
      if (getCatchSigintSignal()
          != other.getCatchSigintSignal()) return false;
    }
    if (hasUseImpliedBounds() != other.hasUseImpliedBounds()) return false;
    if (hasUseImpliedBounds()) {
      if (getUseImpliedBounds()
          != other.getUseImpliedBounds()) return false;
    }
    if (hasPolishLpSolution() != other.hasPolishLpSolution()) return false;
    if (hasPolishLpSolution()) {
      if (getPolishLpSolution()
          != other.getPolishLpSolution()) return false;
    }
    if (hasLpPrimalTolerance() != other.hasLpPrimalTolerance()) return false;
    if (hasLpPrimalTolerance()) {
      if (java.lang.Double.doubleToLongBits(getLpPrimalTolerance())
          != java.lang.Double.doubleToLongBits(
              other.getLpPrimalTolerance())) return false;
    }
    if (hasLpDualTolerance() != other.hasLpDualTolerance()) return false;
    if (hasLpDualTolerance()) {
      if (java.lang.Double.doubleToLongBits(getLpDualTolerance())
          != java.lang.Double.doubleToLongBits(
              other.getLpDualTolerance())) return false;
    }
    if (hasConvertIntervals() != other.hasConvertIntervals()) return false;
    if (hasConvertIntervals()) {
      if (getConvertIntervals()
          != other.getConvertIntervals()) return false;
    }
    if (hasSymmetryLevel() != other.hasSymmetryLevel()) return false;
    if (hasSymmetryLevel()) {
      if (getSymmetryLevel()
          != other.getSymmetryLevel()) return false;
    }
    if (hasNewLinearPropagation() != other.hasNewLinearPropagation()) return false;
    if (hasNewLinearPropagation()) {
      if (getNewLinearPropagation()
          != other.getNewLinearPropagation()) return false;
    }
    if (hasLinearSplitSize() != other.hasLinearSplitSize()) return false;
    if (hasLinearSplitSize()) {
      if (getLinearSplitSize()
          != other.getLinearSplitSize()) return false;
    }
    if (hasLinearizationLevel() != other.hasLinearizationLevel()) return false;
    if (hasLinearizationLevel()) {
      if (getLinearizationLevel()
          != other.getLinearizationLevel()) return false;
    }
    if (hasBooleanEncodingLevel() != other.hasBooleanEncodingLevel()) return false;
    if (hasBooleanEncodingLevel()) {
      if (getBooleanEncodingLevel()
          != other.getBooleanEncodingLevel()) return false;
    }
    if (hasMaxDomainSizeWhenEncodingEqNeqConstraints() != other.hasMaxDomainSizeWhenEncodingEqNeqConstraints()) return false;
    if (hasMaxDomainSizeWhenEncodingEqNeqConstraints()) {
      if (getMaxDomainSizeWhenEncodingEqNeqConstraints()
          != other.getMaxDomainSizeWhenEncodingEqNeqConstraints()) return false;
    }
    if (hasMaxNumCuts() != other.hasMaxNumCuts()) return false;
    if (hasMaxNumCuts()) {
      if (getMaxNumCuts()
          != other.getMaxNumCuts()) return false;
    }
    if (hasCutLevel() != other.hasCutLevel()) return false;
    if (hasCutLevel()) {
      if (getCutLevel()
          != other.getCutLevel()) return false;
    }
    if (hasOnlyAddCutsAtLevelZero() != other.hasOnlyAddCutsAtLevelZero()) return false;
    if (hasOnlyAddCutsAtLevelZero()) {
      if (getOnlyAddCutsAtLevelZero()
          != other.getOnlyAddCutsAtLevelZero()) return false;
    }
    if (hasAddObjectiveCut() != other.hasAddObjectiveCut()) return false;
    if (hasAddObjectiveCut()) {
      if (getAddObjectiveCut()
          != other.getAddObjectiveCut()) return false;
    }
    if (hasAddCgCuts() != other.hasAddCgCuts()) return false;
    if (hasAddCgCuts()) {
      if (getAddCgCuts()
          != other.getAddCgCuts()) return false;
    }
    if (hasAddMirCuts() != other.hasAddMirCuts()) return false;
    if (hasAddMirCuts()) {
      if (getAddMirCuts()
          != other.getAddMirCuts()) return false;
    }
    if (hasAddZeroHalfCuts() != other.hasAddZeroHalfCuts()) return false;
    if (hasAddZeroHalfCuts()) {
      if (getAddZeroHalfCuts()
          != other.getAddZeroHalfCuts()) return false;
    }
    if (hasAddCliqueCuts() != other.hasAddCliqueCuts()) return false;
    if (hasAddCliqueCuts()) {
      if (getAddCliqueCuts()
          != other.getAddCliqueCuts()) return false;
    }
    if (hasAddRltCuts() != other.hasAddRltCuts()) return false;
    if (hasAddRltCuts()) {
      if (getAddRltCuts()
          != other.getAddRltCuts()) return false;
    }
    if (hasMaxAllDiffCutSize() != other.hasMaxAllDiffCutSize()) return false;
    if (hasMaxAllDiffCutSize()) {
      if (getMaxAllDiffCutSize()
          != other.getMaxAllDiffCutSize()) return false;
    }
    if (hasAddLinMaxCuts() != other.hasAddLinMaxCuts()) return false;
    if (hasAddLinMaxCuts()) {
      if (getAddLinMaxCuts()
          != other.getAddLinMaxCuts()) return false;
    }
    if (hasMaxIntegerRoundingScaling() != other.hasMaxIntegerRoundingScaling()) return false;
    if (hasMaxIntegerRoundingScaling()) {
      if (getMaxIntegerRoundingScaling()
          != other.getMaxIntegerRoundingScaling()) return false;
    }
    if (hasAddLpConstraintsLazily() != other.hasAddLpConstraintsLazily()) return false;
    if (hasAddLpConstraintsLazily()) {
      if (getAddLpConstraintsLazily()
          != other.getAddLpConstraintsLazily()) return false;
    }
    if (hasRootLpIterations() != other.hasRootLpIterations()) return false;
    if (hasRootLpIterations()) {
      if (getRootLpIterations()
          != other.getRootLpIterations()) return false;
    }
    if (hasMinOrthogonalityForLpConstraints() != other.hasMinOrthogonalityForLpConstraints()) return false;
    if (hasMinOrthogonalityForLpConstraints()) {
      if (java.lang.Double.doubleToLongBits(getMinOrthogonalityForLpConstraints())
          != java.lang.Double.doubleToLongBits(
              other.getMinOrthogonalityForLpConstraints())) return false;
    }
    if (hasMaxCutRoundsAtLevelZero() != other.hasMaxCutRoundsAtLevelZero()) return false;
    if (hasMaxCutRoundsAtLevelZero()) {
      if (getMaxCutRoundsAtLevelZero()
          != other.getMaxCutRoundsAtLevelZero()) return false;
    }
    if (hasMaxConsecutiveInactiveCount() != other.hasMaxConsecutiveInactiveCount()) return false;
    if (hasMaxConsecutiveInactiveCount()) {
      if (getMaxConsecutiveInactiveCount()
          != other.getMaxConsecutiveInactiveCount()) return false;
    }
    if (hasCutMaxActiveCountValue() != other.hasCutMaxActiveCountValue()) return false;
    if (hasCutMaxActiveCountValue()) {
      if (java.lang.Double.doubleToLongBits(getCutMaxActiveCountValue())
          != java.lang.Double.doubleToLongBits(
              other.getCutMaxActiveCountValue())) return false;
    }
    if (hasCutActiveCountDecay() != other.hasCutActiveCountDecay()) return false;
    if (hasCutActiveCountDecay()) {
      if (java.lang.Double.doubleToLongBits(getCutActiveCountDecay())
          != java.lang.Double.doubleToLongBits(
              other.getCutActiveCountDecay())) return false;
    }
    if (hasCutCleanupTarget() != other.hasCutCleanupTarget()) return false;
    if (hasCutCleanupTarget()) {
      if (getCutCleanupTarget()
          != other.getCutCleanupTarget()) return false;
    }
    if (hasNewConstraintsBatchSize() != other.hasNewConstraintsBatchSize()) return false;
    if (hasNewConstraintsBatchSize()) {
      if (getNewConstraintsBatchSize()
          != other.getNewConstraintsBatchSize()) return false;
    }
    if (hasExploitIntegerLpSolution() != other.hasExploitIntegerLpSolution()) return false;
    if (hasExploitIntegerLpSolution()) {
      if (getExploitIntegerLpSolution()
          != other.getExploitIntegerLpSolution()) return false;
    }
    if (hasExploitAllLpSolution() != other.hasExploitAllLpSolution()) return false;
    if (hasExploitAllLpSolution()) {
      if (getExploitAllLpSolution()
          != other.getExploitAllLpSolution()) return false;
    }
    if (hasExploitBestSolution() != other.hasExploitBestSolution()) return false;
    if (hasExploitBestSolution()) {
      if (getExploitBestSolution()
          != other.getExploitBestSolution()) return false;
    }
    if (hasExploitRelaxationSolution() != other.hasExploitRelaxationSolution()) return false;
    if (hasExploitRelaxationSolution()) {
      if (getExploitRelaxationSolution()
          != other.getExploitRelaxationSolution()) return false;
    }
    if (hasExploitObjective() != other.hasExploitObjective()) return false;
    if (hasExploitObjective()) {
      if (getExploitObjective()
          != other.getExploitObjective()) return false;
    }
    if (hasDetectLinearizedProduct() != other.hasDetectLinearizedProduct()) return false;
    if (hasDetectLinearizedProduct()) {
      if (getDetectLinearizedProduct()
          != other.getDetectLinearizedProduct()) return false;
    }
    if (hasMipMaxBound() != other.hasMipMaxBound()) return false;
    if (hasMipMaxBound()) {
      if (java.lang.Double.doubleToLongBits(getMipMaxBound())
          != java.lang.Double.doubleToLongBits(
              other.getMipMaxBound())) return false;
    }
    if (hasMipVarScaling() != other.hasMipVarScaling()) return false;
    if (hasMipVarScaling()) {
      if (java.lang.Double.doubleToLongBits(getMipVarScaling())
          != java.lang.Double.doubleToLongBits(
              other.getMipVarScaling())) return false;
    }
    if (hasMipScaleLargeDomain() != other.hasMipScaleLargeDomain()) return false;
    if (hasMipScaleLargeDomain()) {
      if (getMipScaleLargeDomain()
          != other.getMipScaleLargeDomain()) return false;
    }
    if (hasMipAutomaticallyScaleVariables() != other.hasMipAutomaticallyScaleVariables()) return false;
    if (hasMipAutomaticallyScaleVariables()) {
      if (getMipAutomaticallyScaleVariables()
          != other.getMipAutomaticallyScaleVariables()) return false;
    }
    if (hasOnlySolveIp() != other.hasOnlySolveIp()) return false;
    if (hasOnlySolveIp()) {
      if (getOnlySolveIp()
          != other.getOnlySolveIp()) return false;
    }
    if (hasMipWantedPrecision() != other.hasMipWantedPrecision()) return false;
    if (hasMipWantedPrecision()) {
      if (java.lang.Double.doubleToLongBits(getMipWantedPrecision())
          != java.lang.Double.doubleToLongBits(
              other.getMipWantedPrecision())) return false;
    }
    if (hasMipMaxActivityExponent() != other.hasMipMaxActivityExponent()) return false;
    if (hasMipMaxActivityExponent()) {
      if (getMipMaxActivityExponent()
          != other.getMipMaxActivityExponent()) return false;
    }
    if (hasMipCheckPrecision() != other.hasMipCheckPrecision()) return false;
    if (hasMipCheckPrecision()) {
      if (java.lang.Double.doubleToLongBits(getMipCheckPrecision())
          != java.lang.Double.doubleToLongBits(
              other.getMipCheckPrecision())) return false;
    }
    if (hasMipComputeTrueObjectiveBound() != other.hasMipComputeTrueObjectiveBound()) return false;
    if (hasMipComputeTrueObjectiveBound()) {
      if (getMipComputeTrueObjectiveBound()
          != other.getMipComputeTrueObjectiveBound()) return false;
    }
    if (hasMipMaxValidMagnitude() != other.hasMipMaxValidMagnitude()) return false;
    if (hasMipMaxValidMagnitude()) {
      if (java.lang.Double.doubleToLongBits(getMipMaxValidMagnitude())
          != java.lang.Double.doubleToLongBits(
              other.getMipMaxValidMagnitude())) return false;
    }
    if (hasMipTreatHighMagnitudeBoundsAsInfinity() != other.hasMipTreatHighMagnitudeBoundsAsInfinity()) return false;
    if (hasMipTreatHighMagnitudeBoundsAsInfinity()) {
      if (getMipTreatHighMagnitudeBoundsAsInfinity()
          != other.getMipTreatHighMagnitudeBoundsAsInfinity()) return false;
    }
    if (hasMipDropTolerance() != other.hasMipDropTolerance()) return false;
    if (hasMipDropTolerance()) {
      if (java.lang.Double.doubleToLongBits(getMipDropTolerance())
          != java.lang.Double.doubleToLongBits(
              other.getMipDropTolerance())) return false;
    }
    if (hasMipPresolveLevel() != other.hasMipPresolveLevel()) return false;
    if (hasMipPresolveLevel()) {
      if (getMipPresolveLevel()
          != other.getMipPresolveLevel()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasPreferredVariableOrder()) {
      hash = (37 * hash) + PREFERRED_VARIABLE_ORDER_FIELD_NUMBER;
      hash = (53 * hash) + preferredVariableOrder_;
    }
    if (hasInitialPolarity()) {
      hash = (37 * hash) + INITIAL_POLARITY_FIELD_NUMBER;
      hash = (53 * hash) + initialPolarity_;
    }
    if (hasUsePhaseSaving()) {
      hash = (37 * hash) + USE_PHASE_SAVING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUsePhaseSaving());
    }
    if (hasPolarityRephaseIncrement()) {
      hash = (37 * hash) + POLARITY_REPHASE_INCREMENT_FIELD_NUMBER;
      hash = (53 * hash) + getPolarityRephaseIncrement();
    }
    if (hasRandomPolarityRatio()) {
      hash = (37 * hash) + RANDOM_POLARITY_RATIO_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getRandomPolarityRatio()));
    }
    if (hasRandomBranchesRatio()) {
      hash = (37 * hash) + RANDOM_BRANCHES_RATIO_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getRandomBranchesRatio()));
    }
    if (hasUseErwaHeuristic()) {
      hash = (37 * hash) + USE_ERWA_HEURISTIC_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseErwaHeuristic());
    }
    if (hasInitialVariablesActivity()) {
      hash = (37 * hash) + INITIAL_VARIABLES_ACTIVITY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getInitialVariablesActivity()));
    }
    if (hasAlsoBumpVariablesInConflictReasons()) {
      hash = (37 * hash) + ALSO_BUMP_VARIABLES_IN_CONFLICT_REASONS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAlsoBumpVariablesInConflictReasons());
    }
    if (hasMinimizationAlgorithm()) {
      hash = (37 * hash) + MINIMIZATION_ALGORITHM_FIELD_NUMBER;
      hash = (53 * hash) + minimizationAlgorithm_;
    }
    if (hasBinaryMinimizationAlgorithm()) {
      hash = (37 * hash) + BINARY_MINIMIZATION_ALGORITHM_FIELD_NUMBER;
      hash = (53 * hash) + binaryMinimizationAlgorithm_;
    }
    if (hasSubsumptionDuringConflictAnalysis()) {
      hash = (37 * hash) + SUBSUMPTION_DURING_CONFLICT_ANALYSIS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getSubsumptionDuringConflictAnalysis());
    }
    if (hasClauseCleanupPeriod()) {
      hash = (37 * hash) + CLAUSE_CLEANUP_PERIOD_FIELD_NUMBER;
      hash = (53 * hash) + getClauseCleanupPeriod();
    }
    if (hasClauseCleanupTarget()) {
      hash = (37 * hash) + CLAUSE_CLEANUP_TARGET_FIELD_NUMBER;
      hash = (53 * hash) + getClauseCleanupTarget();
    }
    if (hasClauseCleanupRatio()) {
      hash = (37 * hash) + CLAUSE_CLEANUP_RATIO_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getClauseCleanupRatio()));
    }
    if (hasClauseCleanupProtection()) {
      hash = (37 * hash) + CLAUSE_CLEANUP_PROTECTION_FIELD_NUMBER;
      hash = (53 * hash) + clauseCleanupProtection_;
    }
    if (hasClauseCleanupLbdBound()) {
      hash = (37 * hash) + CLAUSE_CLEANUP_LBD_BOUND_FIELD_NUMBER;
      hash = (53 * hash) + getClauseCleanupLbdBound();
    }
    if (hasClauseCleanupOrdering()) {
      hash = (37 * hash) + CLAUSE_CLEANUP_ORDERING_FIELD_NUMBER;
      hash = (53 * hash) + clauseCleanupOrdering_;
    }
    if (hasPbCleanupIncrement()) {
      hash = (37 * hash) + PB_CLEANUP_INCREMENT_FIELD_NUMBER;
      hash = (53 * hash) + getPbCleanupIncrement();
    }
    if (hasPbCleanupRatio()) {
      hash = (37 * hash) + PB_CLEANUP_RATIO_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getPbCleanupRatio()));
    }
    if (hasVariableActivityDecay()) {
      hash = (37 * hash) + VARIABLE_ACTIVITY_DECAY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getVariableActivityDecay()));
    }
    if (hasMaxVariableActivityValue()) {
      hash = (37 * hash) + MAX_VARIABLE_ACTIVITY_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMaxVariableActivityValue()));
    }
    if (hasGlucoseMaxDecay()) {
      hash = (37 * hash) + GLUCOSE_MAX_DECAY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getGlucoseMaxDecay()));
    }
    if (hasGlucoseDecayIncrement()) {
      hash = (37 * hash) + GLUCOSE_DECAY_INCREMENT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getGlucoseDecayIncrement()));
    }
    if (hasGlucoseDecayIncrementPeriod()) {
      hash = (37 * hash) + GLUCOSE_DECAY_INCREMENT_PERIOD_FIELD_NUMBER;
      hash = (53 * hash) + getGlucoseDecayIncrementPeriod();
    }
    if (hasClauseActivityDecay()) {
      hash = (37 * hash) + CLAUSE_ACTIVITY_DECAY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getClauseActivityDecay()));
    }
    if (hasMaxClauseActivityValue()) {
      hash = (37 * hash) + MAX_CLAUSE_ACTIVITY_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMaxClauseActivityValue()));
    }
    if (getRestartAlgorithmsCount() > 0) {
      hash = (37 * hash) + RESTART_ALGORITHMS_FIELD_NUMBER;
      hash = (53 * hash) + restartAlgorithms_.hashCode();
    }
    if (hasDefaultRestartAlgorithms()) {
      hash = (37 * hash) + DEFAULT_RESTART_ALGORITHMS_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultRestartAlgorithms().hashCode();
    }
    if (hasRestartPeriod()) {
      hash = (37 * hash) + RESTART_PERIOD_FIELD_NUMBER;
      hash = (53 * hash) + getRestartPeriod();
    }
    if (hasRestartRunningWindowSize()) {
      hash = (37 * hash) + RESTART_RUNNING_WINDOW_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getRestartRunningWindowSize();
    }
    if (hasRestartDlAverageRatio()) {
      hash = (37 * hash) + RESTART_DL_AVERAGE_RATIO_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getRestartDlAverageRatio()));
    }
    if (hasRestartLbdAverageRatio()) {
      hash = (37 * hash) + RESTART_LBD_AVERAGE_RATIO_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getRestartLbdAverageRatio()));
    }
    if (hasUseBlockingRestart()) {
      hash = (37 * hash) + USE_BLOCKING_RESTART_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseBlockingRestart());
    }
    if (hasBlockingRestartWindowSize()) {
      hash = (37 * hash) + BLOCKING_RESTART_WINDOW_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getBlockingRestartWindowSize();
    }
    if (hasBlockingRestartMultiplier()) {
      hash = (37 * hash) + BLOCKING_RESTART_MULTIPLIER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getBlockingRestartMultiplier()));
    }
    if (hasNumConflictsBeforeStrategyChanges()) {
      hash = (37 * hash) + NUM_CONFLICTS_BEFORE_STRATEGY_CHANGES_FIELD_NUMBER;
      hash = (53 * hash) + getNumConflictsBeforeStrategyChanges();
    }
    if (hasStrategyChangeIncreaseRatio()) {
      hash = (37 * hash) + STRATEGY_CHANGE_INCREASE_RATIO_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getStrategyChangeIncreaseRatio()));
    }
    if (hasMaxTimeInSeconds()) {
      hash = (37 * hash) + MAX_TIME_IN_SECONDS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMaxTimeInSeconds()));
    }
    if (hasMaxDeterministicTime()) {
      hash = (37 * hash) + MAX_DETERMINISTIC_TIME_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMaxDeterministicTime()));
    }
    if (hasMaxNumDeterministicBatches()) {
      hash = (37 * hash) + MAX_NUM_DETERMINISTIC_BATCHES_FIELD_NUMBER;
      hash = (53 * hash) + getMaxNumDeterministicBatches();
    }
    if (hasMaxNumberOfConflicts()) {
      hash = (37 * hash) + MAX_NUMBER_OF_CONFLICTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getMaxNumberOfConflicts());
    }
    if (hasMaxMemoryInMb()) {
      hash = (37 * hash) + MAX_MEMORY_IN_MB_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getMaxMemoryInMb());
    }
    if (hasAbsoluteGapLimit()) {
      hash = (37 * hash) + ABSOLUTE_GAP_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getAbsoluteGapLimit()));
    }
    if (hasRelativeGapLimit()) {
      hash = (37 * hash) + RELATIVE_GAP_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getRelativeGapLimit()));
    }
    if (hasRandomSeed()) {
      hash = (37 * hash) + RANDOM_SEED_FIELD_NUMBER;
      hash = (53 * hash) + getRandomSeed();
    }
    if (hasPermuteVariableRandomly()) {
      hash = (37 * hash) + PERMUTE_VARIABLE_RANDOMLY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getPermuteVariableRandomly());
    }
    if (hasPermutePresolveConstraintOrder()) {
      hash = (37 * hash) + PERMUTE_PRESOLVE_CONSTRAINT_ORDER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getPermutePresolveConstraintOrder());
    }
    if (hasUseAbslRandom()) {
      hash = (37 * hash) + USE_ABSL_RANDOM_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseAbslRandom());
    }
    if (hasLogSearchProgress()) {
      hash = (37 * hash) + LOG_SEARCH_PROGRESS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getLogSearchProgress());
    }
    if (hasLogSubsolverStatistics()) {
      hash = (37 * hash) + LOG_SUBSOLVER_STATISTICS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getLogSubsolverStatistics());
    }
    if (hasLogPrefix()) {
      hash = (37 * hash) + LOG_PREFIX_FIELD_NUMBER;
      hash = (53 * hash) + getLogPrefix().hashCode();
    }
    if (hasLogToStdout()) {
      hash = (37 * hash) + LOG_TO_STDOUT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getLogToStdout());
    }
    if (hasLogToResponse()) {
      hash = (37 * hash) + LOG_TO_RESPONSE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getLogToResponse());
    }
    if (hasUsePbResolution()) {
      hash = (37 * hash) + USE_PB_RESOLUTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUsePbResolution());
    }
    if (hasMinimizeReductionDuringPbResolution()) {
      hash = (37 * hash) + MINIMIZE_REDUCTION_DURING_PB_RESOLUTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getMinimizeReductionDuringPbResolution());
    }
    if (hasCountAssumptionLevelsInLbd()) {
      hash = (37 * hash) + COUNT_ASSUMPTION_LEVELS_IN_LBD_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getCountAssumptionLevelsInLbd());
    }
    if (hasPresolveBveThreshold()) {
      hash = (37 * hash) + PRESOLVE_BVE_THRESHOLD_FIELD_NUMBER;
      hash = (53 * hash) + getPresolveBveThreshold();
    }
    if (hasPresolveBveClauseWeight()) {
      hash = (37 * hash) + PRESOLVE_BVE_CLAUSE_WEIGHT_FIELD_NUMBER;
      hash = (53 * hash) + getPresolveBveClauseWeight();
    }
    if (hasProbingDeterministicTimeLimit()) {
      hash = (37 * hash) + PROBING_DETERMINISTIC_TIME_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getProbingDeterministicTimeLimit()));
    }
    if (hasPresolveProbingDeterministicTimeLimit()) {
      hash = (37 * hash) + PRESOLVE_PROBING_DETERMINISTIC_TIME_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getPresolveProbingDeterministicTimeLimit()));
    }
    if (hasPresolveBlockedClause()) {
      hash = (37 * hash) + PRESOLVE_BLOCKED_CLAUSE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getPresolveBlockedClause());
    }
    if (hasPresolveUseBva()) {
      hash = (37 * hash) + PRESOLVE_USE_BVA_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getPresolveUseBva());
    }
    if (hasPresolveBvaThreshold()) {
      hash = (37 * hash) + PRESOLVE_BVA_THRESHOLD_FIELD_NUMBER;
      hash = (53 * hash) + getPresolveBvaThreshold();
    }
    if (hasMaxPresolveIterations()) {
      hash = (37 * hash) + MAX_PRESOLVE_ITERATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxPresolveIterations();
    }
    if (hasCpModelPresolve()) {
      hash = (37 * hash) + CP_MODEL_PRESOLVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getCpModelPresolve());
    }
    if (hasCpModelProbingLevel()) {
      hash = (37 * hash) + CP_MODEL_PROBING_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + getCpModelProbingLevel();
    }
    if (hasCpModelUseSatPresolve()) {
      hash = (37 * hash) + CP_MODEL_USE_SAT_PRESOLVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getCpModelUseSatPresolve());
    }
    if (hasDetectTableWithCost()) {
      hash = (37 * hash) + DETECT_TABLE_WITH_COST_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getDetectTableWithCost());
    }
    if (hasTableCompressionLevel()) {
      hash = (37 * hash) + TABLE_COMPRESSION_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + getTableCompressionLevel();
    }
    if (hasExpandAlldiffConstraints()) {
      hash = (37 * hash) + EXPAND_ALLDIFF_CONSTRAINTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getExpandAlldiffConstraints());
    }
    if (hasExpandReservoirConstraints()) {
      hash = (37 * hash) + EXPAND_RESERVOIR_CONSTRAINTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getExpandReservoirConstraints());
    }
    if (hasExpandReservoirUsingCircuit()) {
      hash = (37 * hash) + EXPAND_RESERVOIR_USING_CIRCUIT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getExpandReservoirUsingCircuit());
    }
    if (hasEncodeCumulativeAsReservoir()) {
      hash = (37 * hash) + ENCODE_CUMULATIVE_AS_RESERVOIR_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getEncodeCumulativeAsReservoir());
    }
    if (hasMaxLinMaxSizeForExpansion()) {
      hash = (37 * hash) + MAX_LIN_MAX_SIZE_FOR_EXPANSION_FIELD_NUMBER;
      hash = (53 * hash) + getMaxLinMaxSizeForExpansion();
    }
    if (hasDisableConstraintExpansion()) {
      hash = (37 * hash) + DISABLE_CONSTRAINT_EXPANSION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getDisableConstraintExpansion());
    }
    if (hasEncodeComplexLinearConstraintWithInteger()) {
      hash = (37 * hash) + ENCODE_COMPLEX_LINEAR_CONSTRAINT_WITH_INTEGER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getEncodeComplexLinearConstraintWithInteger());
    }
    if (hasMergeNoOverlapWorkLimit()) {
      hash = (37 * hash) + MERGE_NO_OVERLAP_WORK_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMergeNoOverlapWorkLimit()));
    }
    if (hasMergeAtMostOneWorkLimit()) {
      hash = (37 * hash) + MERGE_AT_MOST_ONE_WORK_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMergeAtMostOneWorkLimit()));
    }
    if (hasPresolveSubstitutionLevel()) {
      hash = (37 * hash) + PRESOLVE_SUBSTITUTION_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + getPresolveSubstitutionLevel();
    }
    if (hasPresolveExtractIntegerEnforcement()) {
      hash = (37 * hash) + PRESOLVE_EXTRACT_INTEGER_ENFORCEMENT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getPresolveExtractIntegerEnforcement());
    }
    if (hasPresolveInclusionWorkLimit()) {
      hash = (37 * hash) + PRESOLVE_INCLUSION_WORK_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getPresolveInclusionWorkLimit());
    }
    if (hasIgnoreNames()) {
      hash = (37 * hash) + IGNORE_NAMES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getIgnoreNames());
    }
    if (hasInferAllDiffs()) {
      hash = (37 * hash) + INFER_ALL_DIFFS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getInferAllDiffs());
    }
    if (hasFindBigLinearOverlap()) {
      hash = (37 * hash) + FIND_BIG_LINEAR_OVERLAP_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getFindBigLinearOverlap());
    }
    if (hasUseSatInprocessing()) {
      hash = (37 * hash) + USE_SAT_INPROCESSING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseSatInprocessing());
    }
    if (hasInprocessingDtimeRatio()) {
      hash = (37 * hash) + INPROCESSING_DTIME_RATIO_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getInprocessingDtimeRatio()));
    }
    if (hasInprocessingProbingDtime()) {
      hash = (37 * hash) + INPROCESSING_PROBING_DTIME_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getInprocessingProbingDtime()));
    }
    if (hasInprocessingMinimizationDtime()) {
      hash = (37 * hash) + INPROCESSING_MINIMIZATION_DTIME_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getInprocessingMinimizationDtime()));
    }
    if (hasNumWorkers()) {
      hash = (37 * hash) + NUM_WORKERS_FIELD_NUMBER;
      hash = (53 * hash) + getNumWorkers();
    }
    if (hasNumSearchWorkers()) {
      hash = (37 * hash) + NUM_SEARCH_WORKERS_FIELD_NUMBER;
      hash = (53 * hash) + getNumSearchWorkers();
    }
    if (hasNumFullSubsolvers()) {
      hash = (37 * hash) + NUM_FULL_SUBSOLVERS_FIELD_NUMBER;
      hash = (53 * hash) + getNumFullSubsolvers();
    }
    if (getSubsolversCount() > 0) {
      hash = (37 * hash) + SUBSOLVERS_FIELD_NUMBER;
      hash = (53 * hash) + getSubsolversList().hashCode();
    }
    if (getExtraSubsolversCount() > 0) {
      hash = (37 * hash) + EXTRA_SUBSOLVERS_FIELD_NUMBER;
      hash = (53 * hash) + getExtraSubsolversList().hashCode();
    }
    if (getIgnoreSubsolversCount() > 0) {
      hash = (37 * hash) + IGNORE_SUBSOLVERS_FIELD_NUMBER;
      hash = (53 * hash) + getIgnoreSubsolversList().hashCode();
    }
    if (getFilterSubsolversCount() > 0) {
      hash = (37 * hash) + FILTER_SUBSOLVERS_FIELD_NUMBER;
      hash = (53 * hash) + getFilterSubsolversList().hashCode();
    }
    if (getSubsolverParamsCount() > 0) {
      hash = (37 * hash) + SUBSOLVER_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getSubsolverParamsList().hashCode();
    }
    if (hasInterleaveSearch()) {
      hash = (37 * hash) + INTERLEAVE_SEARCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getInterleaveSearch());
    }
    if (hasInterleaveBatchSize()) {
      hash = (37 * hash) + INTERLEAVE_BATCH_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getInterleaveBatchSize();
    }
    if (hasShareObjectiveBounds()) {
      hash = (37 * hash) + SHARE_OBJECTIVE_BOUNDS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getShareObjectiveBounds());
    }
    if (hasShareLevelZeroBounds()) {
      hash = (37 * hash) + SHARE_LEVEL_ZERO_BOUNDS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getShareLevelZeroBounds());
    }
    if (hasShareBinaryClauses()) {
      hash = (37 * hash) + SHARE_BINARY_CLAUSES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getShareBinaryClauses());
    }
    if (hasShareGlueClauses()) {
      hash = (37 * hash) + SHARE_GLUE_CLAUSES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getShareGlueClauses());
    }
    if (hasDebugPostsolveWithFullSolver()) {
      hash = (37 * hash) + DEBUG_POSTSOLVE_WITH_FULL_SOLVER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getDebugPostsolveWithFullSolver());
    }
    if (hasDebugMaxNumPresolveOperations()) {
      hash = (37 * hash) + DEBUG_MAX_NUM_PRESOLVE_OPERATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getDebugMaxNumPresolveOperations();
    }
    if (hasDebugCrashOnBadHint()) {
      hash = (37 * hash) + DEBUG_CRASH_ON_BAD_HINT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getDebugCrashOnBadHint());
    }
    if (hasUseOptimizationHints()) {
      hash = (37 * hash) + USE_OPTIMIZATION_HINTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseOptimizationHints());
    }
    if (hasCoreMinimizationLevel()) {
      hash = (37 * hash) + CORE_MINIMIZATION_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + getCoreMinimizationLevel();
    }
    if (hasFindMultipleCores()) {
      hash = (37 * hash) + FIND_MULTIPLE_CORES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getFindMultipleCores());
    }
    if (hasCoverOptimization()) {
      hash = (37 * hash) + COVER_OPTIMIZATION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getCoverOptimization());
    }
    if (hasMaxSatAssumptionOrder()) {
      hash = (37 * hash) + MAX_SAT_ASSUMPTION_ORDER_FIELD_NUMBER;
      hash = (53 * hash) + maxSatAssumptionOrder_;
    }
    if (hasMaxSatReverseAssumptionOrder()) {
      hash = (37 * hash) + MAX_SAT_REVERSE_ASSUMPTION_ORDER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getMaxSatReverseAssumptionOrder());
    }
    if (hasMaxSatStratification()) {
      hash = (37 * hash) + MAX_SAT_STRATIFICATION_FIELD_NUMBER;
      hash = (53 * hash) + maxSatStratification_;
    }
    if (hasPropagationLoopDetectionFactor()) {
      hash = (37 * hash) + PROPAGATION_LOOP_DETECTION_FACTOR_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getPropagationLoopDetectionFactor()));
    }
    if (hasUsePrecedencesInDisjunctiveConstraint()) {
      hash = (37 * hash) + USE_PRECEDENCES_IN_DISJUNCTIVE_CONSTRAINT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUsePrecedencesInDisjunctiveConstraint());
    }
    if (hasMaxSizeToCreatePrecedenceLiteralsInDisjunctive()) {
      hash = (37 * hash) + MAX_SIZE_TO_CREATE_PRECEDENCE_LITERALS_IN_DISJUNCTIVE_FIELD_NUMBER;
      hash = (53 * hash) + getMaxSizeToCreatePrecedenceLiteralsInDisjunctive();
    }
    if (hasUseStrongPropagationInDisjunctive()) {
      hash = (37 * hash) + USE_STRONG_PROPAGATION_IN_DISJUNCTIVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseStrongPropagationInDisjunctive());
    }
    if (hasUseDynamicPrecedenceInDisjunctive()) {
      hash = (37 * hash) + USE_DYNAMIC_PRECEDENCE_IN_DISJUNCTIVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseDynamicPrecedenceInDisjunctive());
    }
    if (hasUseDynamicPrecedenceInCumulative()) {
      hash = (37 * hash) + USE_DYNAMIC_PRECEDENCE_IN_CUMULATIVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseDynamicPrecedenceInCumulative());
    }
    if (hasUseOverloadCheckerInCumulative()) {
      hash = (37 * hash) + USE_OVERLOAD_CHECKER_IN_CUMULATIVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseOverloadCheckerInCumulative());
    }
    if (hasUseConservativeScaleOverloadChecker()) {
      hash = (37 * hash) + USE_CONSERVATIVE_SCALE_OVERLOAD_CHECKER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseConservativeScaleOverloadChecker());
    }
    if (hasUseTimetableEdgeFindingInCumulative()) {
      hash = (37 * hash) + USE_TIMETABLE_EDGE_FINDING_IN_CUMULATIVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseTimetableEdgeFindingInCumulative());
    }
    if (hasMaxNumIntervalsForTimetableEdgeFinding()) {
      hash = (37 * hash) + MAX_NUM_INTERVALS_FOR_TIMETABLE_EDGE_FINDING_FIELD_NUMBER;
      hash = (53 * hash) + getMaxNumIntervalsForTimetableEdgeFinding();
    }
    if (hasUseHardPrecedencesInCumulative()) {
      hash = (37 * hash) + USE_HARD_PRECEDENCES_IN_CUMULATIVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseHardPrecedencesInCumulative());
    }
    if (hasExploitAllPrecedences()) {
      hash = (37 * hash) + EXPLOIT_ALL_PRECEDENCES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getExploitAllPrecedences());
    }
    if (hasUseDisjunctiveConstraintInCumulative()) {
      hash = (37 * hash) + USE_DISJUNCTIVE_CONSTRAINT_IN_CUMULATIVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseDisjunctiveConstraintInCumulative());
    }
    if (hasUseTimetablingInNoOverlap2D()) {
      hash = (37 * hash) + USE_TIMETABLING_IN_NO_OVERLAP_2D_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseTimetablingInNoOverlap2D());
    }
    if (hasUseEnergeticReasoningInNoOverlap2D()) {
      hash = (37 * hash) + USE_ENERGETIC_REASONING_IN_NO_OVERLAP_2D_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseEnergeticReasoningInNoOverlap2D());
    }
    if (hasUseAreaEnergeticReasoningInNoOverlap2D()) {
      hash = (37 * hash) + USE_AREA_ENERGETIC_REASONING_IN_NO_OVERLAP_2D_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseAreaEnergeticReasoningInNoOverlap2D());
    }
    if (hasMaxPairsPairwiseReasoningInNoOverlap2D()) {
      hash = (37 * hash) + MAX_PAIRS_PAIRWISE_REASONING_IN_NO_OVERLAP_2D_FIELD_NUMBER;
      hash = (53 * hash) + getMaxPairsPairwiseReasoningInNoOverlap2D();
    }
    if (hasUseDualSchedulingHeuristics()) {
      hash = (37 * hash) + USE_DUAL_SCHEDULING_HEURISTICS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseDualSchedulingHeuristics());
    }
    if (hasSearchBranching()) {
      hash = (37 * hash) + SEARCH_BRANCHING_FIELD_NUMBER;
      hash = (53 * hash) + searchBranching_;
    }
    if (hasHintConflictLimit()) {
      hash = (37 * hash) + HINT_CONFLICT_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + getHintConflictLimit();
    }
    if (hasRepairHint()) {
      hash = (37 * hash) + REPAIR_HINT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getRepairHint());
    }
    if (hasFixVariablesToTheirHintedValue()) {
      hash = (37 * hash) + FIX_VARIABLES_TO_THEIR_HINTED_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getFixVariablesToTheirHintedValue());
    }
    if (hasUseProbingSearch()) {
      hash = (37 * hash) + USE_PROBING_SEARCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseProbingSearch());
    }
    if (hasUseExtendedProbing()) {
      hash = (37 * hash) + USE_EXTENDED_PROBING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseExtendedProbing());
    }
    if (hasProbingNumCombinationsLimit()) {
      hash = (37 * hash) + PROBING_NUM_COMBINATIONS_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + getProbingNumCombinationsLimit();
    }
    if (hasUseShavingInProbingSearch()) {
      hash = (37 * hash) + USE_SHAVING_IN_PROBING_SEARCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseShavingInProbingSearch());
    }
    if (hasShavingSearchDeterministicTime()) {
      hash = (37 * hash) + SHAVING_SEARCH_DETERMINISTIC_TIME_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getShavingSearchDeterministicTime()));
    }
    if (hasShavingSearchThreshold()) {
      hash = (37 * hash) + SHAVING_SEARCH_THRESHOLD_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getShavingSearchThreshold());
    }
    if (hasUseObjectiveLbSearch()) {
      hash = (37 * hash) + USE_OBJECTIVE_LB_SEARCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseObjectiveLbSearch());
    }
    if (hasUseObjectiveShavingSearch()) {
      hash = (37 * hash) + USE_OBJECTIVE_SHAVING_SEARCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseObjectiveShavingSearch());
    }
    if (hasUseVariablesShavingSearch()) {
      hash = (37 * hash) + USE_VARIABLES_SHAVING_SEARCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseVariablesShavingSearch());
    }
    if (hasPseudoCostReliabilityThreshold()) {
      hash = (37 * hash) + PSEUDO_COST_RELIABILITY_THRESHOLD_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getPseudoCostReliabilityThreshold());
    }
    if (hasOptimizeWithCore()) {
      hash = (37 * hash) + OPTIMIZE_WITH_CORE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getOptimizeWithCore());
    }
    if (hasOptimizeWithLbTreeSearch()) {
      hash = (37 * hash) + OPTIMIZE_WITH_LB_TREE_SEARCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getOptimizeWithLbTreeSearch());
    }
    if (hasSaveLpBasisInLbTreeSearch()) {
      hash = (37 * hash) + SAVE_LP_BASIS_IN_LB_TREE_SEARCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getSaveLpBasisInLbTreeSearch());
    }
    if (hasBinarySearchNumConflicts()) {
      hash = (37 * hash) + BINARY_SEARCH_NUM_CONFLICTS_FIELD_NUMBER;
      hash = (53 * hash) + getBinarySearchNumConflicts();
    }
    if (hasOptimizeWithMaxHs()) {
      hash = (37 * hash) + OPTIMIZE_WITH_MAX_HS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getOptimizeWithMaxHs());
    }
    if (hasUseFeasibilityJump()) {
      hash = (37 * hash) + USE_FEASIBILITY_JUMP_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseFeasibilityJump());
    }
    if (hasUseLsOnly()) {
      hash = (37 * hash) + USE_LS_ONLY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseLsOnly());
    }
    if (hasFeasibilityJumpDecay()) {
      hash = (37 * hash) + FEASIBILITY_JUMP_DECAY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getFeasibilityJumpDecay()));
    }
    if (hasFeasibilityJumpLinearizationLevel()) {
      hash = (37 * hash) + FEASIBILITY_JUMP_LINEARIZATION_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + getFeasibilityJumpLinearizationLevel();
    }
    if (hasFeasibilityJumpRestartFactor()) {
      hash = (37 * hash) + FEASIBILITY_JUMP_RESTART_FACTOR_FIELD_NUMBER;
      hash = (53 * hash) + getFeasibilityJumpRestartFactor();
    }
    if (hasFeasibilityJumpBatchDtime()) {
      hash = (37 * hash) + FEASIBILITY_JUMP_BATCH_DTIME_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getFeasibilityJumpBatchDtime()));
    }
    if (hasFeasibilityJumpVarRandomizationProbability()) {
      hash = (37 * hash) + FEASIBILITY_JUMP_VAR_RANDOMIZATION_PROBABILITY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getFeasibilityJumpVarRandomizationProbability()));
    }
    if (hasFeasibilityJumpVarPerburbationRangeRatio()) {
      hash = (37 * hash) + FEASIBILITY_JUMP_VAR_PERBURBATION_RANGE_RATIO_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getFeasibilityJumpVarPerburbationRangeRatio()));
    }
    if (hasFeasibilityJumpEnableRestarts()) {
      hash = (37 * hash) + FEASIBILITY_JUMP_ENABLE_RESTARTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getFeasibilityJumpEnableRestarts());
    }
    if (hasFeasibilityJumpMaxExpandedConstraintSize()) {
      hash = (37 * hash) + FEASIBILITY_JUMP_MAX_EXPANDED_CONSTRAINT_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getFeasibilityJumpMaxExpandedConstraintSize();
    }
    if (hasNumViolationLs()) {
      hash = (37 * hash) + NUM_VIOLATION_LS_FIELD_NUMBER;
      hash = (53 * hash) + getNumViolationLs();
    }
    if (hasViolationLsPerturbationPeriod()) {
      hash = (37 * hash) + VIOLATION_LS_PERTURBATION_PERIOD_FIELD_NUMBER;
      hash = (53 * hash) + getViolationLsPerturbationPeriod();
    }
    if (hasViolationLsCompoundMoveProbability()) {
      hash = (37 * hash) + VIOLATION_LS_COMPOUND_MOVE_PROBABILITY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getViolationLsCompoundMoveProbability()));
    }
    if (hasSharedTreeNumWorkers()) {
      hash = (37 * hash) + SHARED_TREE_NUM_WORKERS_FIELD_NUMBER;
      hash = (53 * hash) + getSharedTreeNumWorkers();
    }
    if (hasUseSharedTreeSearch()) {
      hash = (37 * hash) + USE_SHARED_TREE_SEARCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseSharedTreeSearch());
    }
    if (hasSharedTreeWorkerObjectiveSplitProbability()) {
      hash = (37 * hash) + SHARED_TREE_WORKER_OBJECTIVE_SPLIT_PROBABILITY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getSharedTreeWorkerObjectiveSplitProbability()));
    }
    if (hasSharedTreeWorkerMinRestartsPerSubtree()) {
      hash = (37 * hash) + SHARED_TREE_WORKER_MIN_RESTARTS_PER_SUBTREE_FIELD_NUMBER;
      hash = (53 * hash) + getSharedTreeWorkerMinRestartsPerSubtree();
    }
    if (hasSharedTreeWorkerEnableTrailSharing()) {
      hash = (37 * hash) + SHARED_TREE_WORKER_ENABLE_TRAIL_SHARING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getSharedTreeWorkerEnableTrailSharing());
    }
    if (hasSharedTreeOpenLeavesPerWorker()) {
      hash = (37 * hash) + SHARED_TREE_OPEN_LEAVES_PER_WORKER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getSharedTreeOpenLeavesPerWorker()));
    }
    if (hasSharedTreeMaxNodesPerWorker()) {
      hash = (37 * hash) + SHARED_TREE_MAX_NODES_PER_WORKER_FIELD_NUMBER;
      hash = (53 * hash) + getSharedTreeMaxNodesPerWorker();
    }
    if (hasSharedTreeSplitStrategy()) {
      hash = (37 * hash) + SHARED_TREE_SPLIT_STRATEGY_FIELD_NUMBER;
      hash = (53 * hash) + sharedTreeSplitStrategy_;
    }
    if (hasEnumerateAllSolutions()) {
      hash = (37 * hash) + ENUMERATE_ALL_SOLUTIONS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getEnumerateAllSolutions());
    }
    if (hasKeepAllFeasibleSolutionsInPresolve()) {
      hash = (37 * hash) + KEEP_ALL_FEASIBLE_SOLUTIONS_IN_PRESOLVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getKeepAllFeasibleSolutionsInPresolve());
    }
    if (hasFillTightenedDomainsInResponse()) {
      hash = (37 * hash) + FILL_TIGHTENED_DOMAINS_IN_RESPONSE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getFillTightenedDomainsInResponse());
    }
    if (hasFillAdditionalSolutionsInResponse()) {
      hash = (37 * hash) + FILL_ADDITIONAL_SOLUTIONS_IN_RESPONSE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getFillAdditionalSolutionsInResponse());
    }
    if (hasInstantiateAllVariables()) {
      hash = (37 * hash) + INSTANTIATE_ALL_VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getInstantiateAllVariables());
    }
    if (hasAutoDetectGreaterThanAtLeastOneOf()) {
      hash = (37 * hash) + AUTO_DETECT_GREATER_THAN_AT_LEAST_ONE_OF_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAutoDetectGreaterThanAtLeastOneOf());
    }
    if (hasStopAfterFirstSolution()) {
      hash = (37 * hash) + STOP_AFTER_FIRST_SOLUTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getStopAfterFirstSolution());
    }
    if (hasStopAfterPresolve()) {
      hash = (37 * hash) + STOP_AFTER_PRESOLVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getStopAfterPresolve());
    }
    if (hasStopAfterRootPropagation()) {
      hash = (37 * hash) + STOP_AFTER_ROOT_PROPAGATION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getStopAfterRootPropagation());
    }
    if (hasUseLns()) {
      hash = (37 * hash) + USE_LNS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseLns());
    }
    if (hasUseLnsOnly()) {
      hash = (37 * hash) + USE_LNS_ONLY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseLnsOnly());
    }
    if (hasSolutionPoolSize()) {
      hash = (37 * hash) + SOLUTION_POOL_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getSolutionPoolSize();
    }
    if (hasUseRinsLns()) {
      hash = (37 * hash) + USE_RINS_LNS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseRinsLns());
    }
    if (hasUseFeasibilityPump()) {
      hash = (37 * hash) + USE_FEASIBILITY_PUMP_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseFeasibilityPump());
    }
    if (hasUseLbRelaxLns()) {
      hash = (37 * hash) + USE_LB_RELAX_LNS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseLbRelaxLns());
    }
    if (hasFpRounding()) {
      hash = (37 * hash) + FP_ROUNDING_FIELD_NUMBER;
      hash = (53 * hash) + fpRounding_;
    }
    if (hasDiversifyLnsParams()) {
      hash = (37 * hash) + DIVERSIFY_LNS_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getDiversifyLnsParams());
    }
    if (hasRandomizeSearch()) {
      hash = (37 * hash) + RANDOMIZE_SEARCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getRandomizeSearch());
    }
    if (hasSearchRandomVariablePoolSize()) {
      hash = (37 * hash) + SEARCH_RANDOM_VARIABLE_POOL_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getSearchRandomVariablePoolSize());
    }
    if (hasPushAllTasksTowardStart()) {
      hash = (37 * hash) + PUSH_ALL_TASKS_TOWARD_START_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getPushAllTasksTowardStart());
    }
    if (hasUseOptionalVariables()) {
      hash = (37 * hash) + USE_OPTIONAL_VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseOptionalVariables());
    }
    if (hasUseExactLpReason()) {
      hash = (37 * hash) + USE_EXACT_LP_REASON_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseExactLpReason());
    }
    if (hasUseCombinedNoOverlap()) {
      hash = (37 * hash) + USE_COMBINED_NO_OVERLAP_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseCombinedNoOverlap());
    }
    if (hasAtMostOneMaxExpansionSize()) {
      hash = (37 * hash) + AT_MOST_ONE_MAX_EXPANSION_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getAtMostOneMaxExpansionSize();
    }
    if (hasCatchSigintSignal()) {
      hash = (37 * hash) + CATCH_SIGINT_SIGNAL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getCatchSigintSignal());
    }
    if (hasUseImpliedBounds()) {
      hash = (37 * hash) + USE_IMPLIED_BOUNDS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseImpliedBounds());
    }
    if (hasPolishLpSolution()) {
      hash = (37 * hash) + POLISH_LP_SOLUTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getPolishLpSolution());
    }
    if (hasLpPrimalTolerance()) {
      hash = (37 * hash) + LP_PRIMAL_TOLERANCE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getLpPrimalTolerance()));
    }
    if (hasLpDualTolerance()) {
      hash = (37 * hash) + LP_DUAL_TOLERANCE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getLpDualTolerance()));
    }
    if (hasConvertIntervals()) {
      hash = (37 * hash) + CONVERT_INTERVALS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getConvertIntervals());
    }
    if (hasSymmetryLevel()) {
      hash = (37 * hash) + SYMMETRY_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + getSymmetryLevel();
    }
    if (hasNewLinearPropagation()) {
      hash = (37 * hash) + NEW_LINEAR_PROPAGATION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getNewLinearPropagation());
    }
    if (hasLinearSplitSize()) {
      hash = (37 * hash) + LINEAR_SPLIT_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getLinearSplitSize();
    }
    if (hasLinearizationLevel()) {
      hash = (37 * hash) + LINEARIZATION_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + getLinearizationLevel();
    }
    if (hasBooleanEncodingLevel()) {
      hash = (37 * hash) + BOOLEAN_ENCODING_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + getBooleanEncodingLevel();
    }
    if (hasMaxDomainSizeWhenEncodingEqNeqConstraints()) {
      hash = (37 * hash) + MAX_DOMAIN_SIZE_WHEN_ENCODING_EQ_NEQ_CONSTRAINTS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxDomainSizeWhenEncodingEqNeqConstraints();
    }
    if (hasMaxNumCuts()) {
      hash = (37 * hash) + MAX_NUM_CUTS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxNumCuts();
    }
    if (hasCutLevel()) {
      hash = (37 * hash) + CUT_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + getCutLevel();
    }
    if (hasOnlyAddCutsAtLevelZero()) {
      hash = (37 * hash) + ONLY_ADD_CUTS_AT_LEVEL_ZERO_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getOnlyAddCutsAtLevelZero());
    }
    if (hasAddObjectiveCut()) {
      hash = (37 * hash) + ADD_OBJECTIVE_CUT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAddObjectiveCut());
    }
    if (hasAddCgCuts()) {
      hash = (37 * hash) + ADD_CG_CUTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAddCgCuts());
    }
    if (hasAddMirCuts()) {
      hash = (37 * hash) + ADD_MIR_CUTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAddMirCuts());
    }
    if (hasAddZeroHalfCuts()) {
      hash = (37 * hash) + ADD_ZERO_HALF_CUTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAddZeroHalfCuts());
    }
    if (hasAddCliqueCuts()) {
      hash = (37 * hash) + ADD_CLIQUE_CUTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAddCliqueCuts());
    }
    if (hasAddRltCuts()) {
      hash = (37 * hash) + ADD_RLT_CUTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAddRltCuts());
    }
    if (hasMaxAllDiffCutSize()) {
      hash = (37 * hash) + MAX_ALL_DIFF_CUT_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getMaxAllDiffCutSize();
    }
    if (hasAddLinMaxCuts()) {
      hash = (37 * hash) + ADD_LIN_MAX_CUTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAddLinMaxCuts());
    }
    if (hasMaxIntegerRoundingScaling()) {
      hash = (37 * hash) + MAX_INTEGER_ROUNDING_SCALING_FIELD_NUMBER;
      hash = (53 * hash) + getMaxIntegerRoundingScaling();
    }
    if (hasAddLpConstraintsLazily()) {
      hash = (37 * hash) + ADD_LP_CONSTRAINTS_LAZILY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAddLpConstraintsLazily());
    }
    if (hasRootLpIterations()) {
      hash = (37 * hash) + ROOT_LP_ITERATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getRootLpIterations();
    }
    if (hasMinOrthogonalityForLpConstraints()) {
      hash = (37 * hash) + MIN_ORTHOGONALITY_FOR_LP_CONSTRAINTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMinOrthogonalityForLpConstraints()));
    }
    if (hasMaxCutRoundsAtLevelZero()) {
      hash = (37 * hash) + MAX_CUT_ROUNDS_AT_LEVEL_ZERO_FIELD_NUMBER;
      hash = (53 * hash) + getMaxCutRoundsAtLevelZero();
    }
    if (hasMaxConsecutiveInactiveCount()) {
      hash = (37 * hash) + MAX_CONSECUTIVE_INACTIVE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getMaxConsecutiveInactiveCount();
    }
    if (hasCutMaxActiveCountValue()) {
      hash = (37 * hash) + CUT_MAX_ACTIVE_COUNT_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getCutMaxActiveCountValue()));
    }
    if (hasCutActiveCountDecay()) {
      hash = (37 * hash) + CUT_ACTIVE_COUNT_DECAY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getCutActiveCountDecay()));
    }
    if (hasCutCleanupTarget()) {
      hash = (37 * hash) + CUT_CLEANUP_TARGET_FIELD_NUMBER;
      hash = (53 * hash) + getCutCleanupTarget();
    }
    if (hasNewConstraintsBatchSize()) {
      hash = (37 * hash) + NEW_CONSTRAINTS_BATCH_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getNewConstraintsBatchSize();
    }
    if (hasExploitIntegerLpSolution()) {
      hash = (37 * hash) + EXPLOIT_INTEGER_LP_SOLUTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getExploitIntegerLpSolution());
    }
    if (hasExploitAllLpSolution()) {
      hash = (37 * hash) + EXPLOIT_ALL_LP_SOLUTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getExploitAllLpSolution());
    }
    if (hasExploitBestSolution()) {
      hash = (37 * hash) + EXPLOIT_BEST_SOLUTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getExploitBestSolution());
    }
    if (hasExploitRelaxationSolution()) {
      hash = (37 * hash) + EXPLOIT_RELAXATION_SOLUTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getExploitRelaxationSolution());
    }
    if (hasExploitObjective()) {
      hash = (37 * hash) + EXPLOIT_OBJECTIVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getExploitObjective());
    }
    if (hasDetectLinearizedProduct()) {
      hash = (37 * hash) + DETECT_LINEARIZED_PRODUCT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getDetectLinearizedProduct());
    }
    if (hasMipMaxBound()) {
      hash = (37 * hash) + MIP_MAX_BOUND_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMipMaxBound()));
    }
    if (hasMipVarScaling()) {
      hash = (37 * hash) + MIP_VAR_SCALING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMipVarScaling()));
    }
    if (hasMipScaleLargeDomain()) {
      hash = (37 * hash) + MIP_SCALE_LARGE_DOMAIN_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getMipScaleLargeDomain());
    }
    if (hasMipAutomaticallyScaleVariables()) {
      hash = (37 * hash) + MIP_AUTOMATICALLY_SCALE_VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getMipAutomaticallyScaleVariables());
    }
    if (hasOnlySolveIp()) {
      hash = (37 * hash) + ONLY_SOLVE_IP_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getOnlySolveIp());
    }
    if (hasMipWantedPrecision()) {
      hash = (37 * hash) + MIP_WANTED_PRECISION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMipWantedPrecision()));
    }
    if (hasMipMaxActivityExponent()) {
      hash = (37 * hash) + MIP_MAX_ACTIVITY_EXPONENT_FIELD_NUMBER;
      hash = (53 * hash) + getMipMaxActivityExponent();
    }
    if (hasMipCheckPrecision()) {
      hash = (37 * hash) + MIP_CHECK_PRECISION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMipCheckPrecision()));
    }
    if (hasMipComputeTrueObjectiveBound()) {
      hash = (37 * hash) + MIP_COMPUTE_TRUE_OBJECTIVE_BOUND_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getMipComputeTrueObjectiveBound());
    }
    if (hasMipMaxValidMagnitude()) {
      hash = (37 * hash) + MIP_MAX_VALID_MAGNITUDE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMipMaxValidMagnitude()));
    }
    if (hasMipTreatHighMagnitudeBoundsAsInfinity()) {
      hash = (37 * hash) + MIP_TREAT_HIGH_MAGNITUDE_BOUNDS_AS_INFINITY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getMipTreatHighMagnitudeBoundsAsInfinity());
    }
    if (hasMipDropTolerance()) {
      hash = (37 * hash) + MIP_DROP_TOLERANCE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMipDropTolerance()));
    }
    if (hasMipPresolveLevel()) {
      hash = (37 * hash) + MIP_PRESOLVE_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + getMipPresolveLevel();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ortools.sat.SatParameters parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.sat.SatParameters parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.sat.SatParameters parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.sat.SatParameters parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.sat.SatParameters parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.sat.SatParameters parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.sat.SatParameters parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.sat.SatParameters parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ortools.sat.SatParameters parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ortools.sat.SatParameters parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ortools.sat.SatParameters parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.sat.SatParameters parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ortools.sat.SatParameters prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Contains the definitions for all the sat algorithm parameters and their
   * default values.
   *
   * NEXT TAG: 296
   * </pre>
   *
   * Protobuf type {@code operations_research.sat.SatParameters}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessage.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:operations_research.sat.SatParameters)
      com.google.ortools.sat.SatParametersOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ortools.sat.SatParametersOuterClass.internal_static_operations_research_sat_SatParameters_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ortools.sat.SatParametersOuterClass.internal_static_operations_research_sat_SatParameters_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ortools.sat.SatParameters.class, com.google.ortools.sat.SatParameters.Builder.class);
    }

    // Construct using com.google.ortools.sat.SatParameters.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bitField1_ = 0;
      bitField2_ = 0;
      bitField3_ = 0;
      bitField4_ = 0;
      bitField5_ = 0;
      bitField6_ = 0;
      bitField7_ = 0;
      name_ = "";
      preferredVariableOrder_ = 0;
      initialPolarity_ = 1;
      usePhaseSaving_ = true;
      polarityRephaseIncrement_ = 1000;
      randomPolarityRatio_ = 0D;
      randomBranchesRatio_ = 0D;
      useErwaHeuristic_ = false;
      initialVariablesActivity_ = 0D;
      alsoBumpVariablesInConflictReasons_ = false;
      minimizationAlgorithm_ = 2;
      binaryMinimizationAlgorithm_ = 1;
      subsumptionDuringConflictAnalysis_ = true;
      clauseCleanupPeriod_ = 10000;
      clauseCleanupTarget_ = 0;
      clauseCleanupRatio_ = 0.5D;
      clauseCleanupProtection_ = 0;
      clauseCleanupLbdBound_ = 5;
      clauseCleanupOrdering_ = 0;
      pbCleanupIncrement_ = 200;
      pbCleanupRatio_ = 0.5D;
      variableActivityDecay_ = 0.8D;
      maxVariableActivityValue_ = 1e+100D;
      glucoseMaxDecay_ = 0.95D;
      glucoseDecayIncrement_ = 0.01D;
      glucoseDecayIncrementPeriod_ = 5000;
      clauseActivityDecay_ = 0.999D;
      maxClauseActivityValue_ = 1e+20D;
      restartAlgorithms_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x10000000);
      defaultRestartAlgorithms_ = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART";
      restartPeriod_ = 50;
      restartRunningWindowSize_ = 50;
      restartDlAverageRatio_ = 1D;
      restartLbdAverageRatio_ = 1D;
      useBlockingRestart_ = false;
      blockingRestartWindowSize_ = 5000;
      blockingRestartMultiplier_ = 1.4D;
      numConflictsBeforeStrategyChanges_ = 0;
      strategyChangeIncreaseRatio_ = 0D;
      maxTimeInSeconds_ = Double.POSITIVE_INFINITY;
      maxDeterministicTime_ = Double.POSITIVE_INFINITY;
      maxNumDeterministicBatches_ = 0;
      maxNumberOfConflicts_ = 9223372036854775807L;
      maxMemoryInMb_ = 10000L;
      absoluteGapLimit_ = 0.0001D;
      relativeGapLimit_ = 0D;
      randomSeed_ = 1;
      permuteVariableRandomly_ = false;
      permutePresolveConstraintOrder_ = false;
      useAbslRandom_ = false;
      logSearchProgress_ = false;
      logSubsolverStatistics_ = false;
      logPrefix_ = "";
      logToStdout_ = true;
      logToResponse_ = false;
      usePbResolution_ = false;
      minimizeReductionDuringPbResolution_ = false;
      countAssumptionLevelsInLbd_ = true;
      presolveBveThreshold_ = 500;
      presolveBveClauseWeight_ = 3;
      probingDeterministicTimeLimit_ = 1D;
      presolveProbingDeterministicTimeLimit_ = 30D;
      presolveBlockedClause_ = true;
      presolveUseBva_ = true;
      presolveBvaThreshold_ = 1;
      maxPresolveIterations_ = 3;
      cpModelPresolve_ = true;
      cpModelProbingLevel_ = 2;
      cpModelUseSatPresolve_ = true;
      detectTableWithCost_ = false;
      tableCompressionLevel_ = 2;
      expandAlldiffConstraints_ = false;
      expandReservoirConstraints_ = true;
      expandReservoirUsingCircuit_ = false;
      encodeCumulativeAsReservoir_ = false;
      maxLinMaxSizeForExpansion_ = 0;
      disableConstraintExpansion_ = false;
      encodeComplexLinearConstraintWithInteger_ = false;
      mergeNoOverlapWorkLimit_ = 1000000000000D;
      mergeAtMostOneWorkLimit_ = 100000000D;
      presolveSubstitutionLevel_ = 1;
      presolveExtractIntegerEnforcement_ = false;
      presolveInclusionWorkLimit_ = 100000000L;
      ignoreNames_ = true;
      inferAllDiffs_ = true;
      findBigLinearOverlap_ = true;
      useSatInprocessing_ = true;
      inprocessingDtimeRatio_ = 0.2D;
      inprocessingProbingDtime_ = 1D;
      inprocessingMinimizationDtime_ = 1D;
      numWorkers_ = 0;
      numSearchWorkers_ = 0;
      numFullSubsolvers_ = 0;
      subsolvers_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      extraSubsolvers_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      ignoreSubsolvers_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      filterSubsolvers_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      if (subsolverParamsBuilder_ == null) {
        subsolverParams_ = java.util.Collections.emptyList();
      } else {
        subsolverParams_ = null;
        subsolverParamsBuilder_.clear();
      }
      bitField3_ = (bitField3_ & ~0x00000002);
      interleaveSearch_ = false;
      interleaveBatchSize_ = 0;
      shareObjectiveBounds_ = true;
      shareLevelZeroBounds_ = true;
      shareBinaryClauses_ = true;
      shareGlueClauses_ = false;
      debugPostsolveWithFullSolver_ = false;
      debugMaxNumPresolveOperations_ = 0;
      debugCrashOnBadHint_ = false;
      useOptimizationHints_ = true;
      coreMinimizationLevel_ = 2;
      findMultipleCores_ = true;
      coverOptimization_ = true;
      maxSatAssumptionOrder_ = 0;
      maxSatReverseAssumptionOrder_ = false;
      maxSatStratification_ = 1;
      propagationLoopDetectionFactor_ = 10D;
      usePrecedencesInDisjunctiveConstraint_ = true;
      maxSizeToCreatePrecedenceLiteralsInDisjunctive_ = 60;
      useStrongPropagationInDisjunctive_ = false;
      useDynamicPrecedenceInDisjunctive_ = false;
      useDynamicPrecedenceInCumulative_ = false;
      useOverloadCheckerInCumulative_ = false;
      useConservativeScaleOverloadChecker_ = false;
      useTimetableEdgeFindingInCumulative_ = false;
      maxNumIntervalsForTimetableEdgeFinding_ = 100;
      useHardPrecedencesInCumulative_ = false;
      exploitAllPrecedences_ = false;
      useDisjunctiveConstraintInCumulative_ = true;
      useTimetablingInNoOverlap2D_ = false;
      useEnergeticReasoningInNoOverlap2D_ = false;
      useAreaEnergeticReasoningInNoOverlap2D_ = false;
      maxPairsPairwiseReasoningInNoOverlap2D_ = 1250;
      useDualSchedulingHeuristics_ = true;
      searchBranching_ = 0;
      hintConflictLimit_ = 10;
      repairHint_ = false;
      fixVariablesToTheirHintedValue_ = false;
      useProbingSearch_ = false;
      useExtendedProbing_ = true;
      probingNumCombinationsLimit_ = 20000;
      useShavingInProbingSearch_ = true;
      shavingSearchDeterministicTime_ = 0.001D;
      shavingSearchThreshold_ = 64L;
      useObjectiveLbSearch_ = false;
      useObjectiveShavingSearch_ = false;
      useVariablesShavingSearch_ = false;
      pseudoCostReliabilityThreshold_ = 100L;
      optimizeWithCore_ = false;
      optimizeWithLbTreeSearch_ = false;
      saveLpBasisInLbTreeSearch_ = false;
      binarySearchNumConflicts_ = -1;
      optimizeWithMaxHs_ = false;
      useFeasibilityJump_ = true;
      useLsOnly_ = false;
      feasibilityJumpDecay_ = 0.95D;
      feasibilityJumpLinearizationLevel_ = 2;
      feasibilityJumpRestartFactor_ = 1;
      feasibilityJumpBatchDtime_ = 0.1D;
      feasibilityJumpVarRandomizationProbability_ = 0.05D;
      feasibilityJumpVarPerburbationRangeRatio_ = 0.2D;
      feasibilityJumpEnableRestarts_ = true;
      feasibilityJumpMaxExpandedConstraintSize_ = 500;
      numViolationLs_ = 0;
      violationLsPerturbationPeriod_ = 100;
      violationLsCompoundMoveProbability_ = 0.5D;
      sharedTreeNumWorkers_ = 0;
      useSharedTreeSearch_ = false;
      sharedTreeWorkerObjectiveSplitProbability_ = 0.5D;
      sharedTreeWorkerMinRestartsPerSubtree_ = 1;
      sharedTreeWorkerEnableTrailSharing_ = true;
      sharedTreeOpenLeavesPerWorker_ = 2D;
      sharedTreeMaxNodesPerWorker_ = 100000;
      sharedTreeSplitStrategy_ = 0;
      enumerateAllSolutions_ = false;
      keepAllFeasibleSolutionsInPresolve_ = false;
      fillTightenedDomainsInResponse_ = false;
      fillAdditionalSolutionsInResponse_ = false;
      instantiateAllVariables_ = true;
      autoDetectGreaterThanAtLeastOneOf_ = true;
      stopAfterFirstSolution_ = false;
      stopAfterPresolve_ = false;
      stopAfterRootPropagation_ = false;
      useLns_ = true;
      useLnsOnly_ = false;
      solutionPoolSize_ = 3;
      useRinsLns_ = true;
      useFeasibilityPump_ = true;
      useLbRelaxLns_ = false;
      fpRounding_ = 2;
      diversifyLnsParams_ = false;
      randomizeSearch_ = false;
      searchRandomVariablePoolSize_ = 0L;
      pushAllTasksTowardStart_ = false;
      useOptionalVariables_ = false;
      useExactLpReason_ = true;
      useCombinedNoOverlap_ = false;
      atMostOneMaxExpansionSize_ = 3;
      catchSigintSignal_ = true;
      useImpliedBounds_ = true;
      polishLpSolution_ = false;
      lpPrimalTolerance_ = 1e-07D;
      lpDualTolerance_ = 1e-07D;
      convertIntervals_ = true;
      symmetryLevel_ = 2;
      newLinearPropagation_ = true;
      linearSplitSize_ = 100;
      linearizationLevel_ = 1;
      booleanEncodingLevel_ = 1;
      maxDomainSizeWhenEncodingEqNeqConstraints_ = 16;
      maxNumCuts_ = 10000;
      cutLevel_ = 1;
      onlyAddCutsAtLevelZero_ = false;
      addObjectiveCut_ = false;
      addCgCuts_ = true;
      addMirCuts_ = true;
      addZeroHalfCuts_ = true;
      addCliqueCuts_ = true;
      addRltCuts_ = true;
      maxAllDiffCutSize_ = 64;
      addLinMaxCuts_ = true;
      maxIntegerRoundingScaling_ = 600;
      addLpConstraintsLazily_ = true;
      rootLpIterations_ = 2000;
      minOrthogonalityForLpConstraints_ = 0.05D;
      maxCutRoundsAtLevelZero_ = 1;
      maxConsecutiveInactiveCount_ = 100;
      cutMaxActiveCountValue_ = 10000000000D;
      cutActiveCountDecay_ = 0.8D;
      cutCleanupTarget_ = 1000;
      newConstraintsBatchSize_ = 50;
      exploitIntegerLpSolution_ = true;
      exploitAllLpSolution_ = true;
      exploitBestSolution_ = false;
      exploitRelaxationSolution_ = false;
      exploitObjective_ = true;
      detectLinearizedProduct_ = false;
      mipMaxBound_ = 10000000D;
      mipVarScaling_ = 1D;
      mipScaleLargeDomain_ = false;
      mipAutomaticallyScaleVariables_ = true;
      onlySolveIp_ = false;
      mipWantedPrecision_ = 1e-06D;
      mipMaxActivityExponent_ = 53;
      mipCheckPrecision_ = 0.0001D;
      mipComputeTrueObjectiveBound_ = true;
      mipMaxValidMagnitude_ = 1e+20D;
      mipTreatHighMagnitudeBoundsAsInfinity_ = false;
      mipDropTolerance_ = 1e-16D;
      mipPresolveLevel_ = 2;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ortools.sat.SatParametersOuterClass.internal_static_operations_research_sat_SatParameters_descriptor;
    }

    @java.lang.Override
    public com.google.ortools.sat.SatParameters getDefaultInstanceForType() {
      return com.google.ortools.sat.SatParameters.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ortools.sat.SatParameters build() {
      com.google.ortools.sat.SatParameters result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ortools.sat.SatParameters buildPartial() {
      com.google.ortools.sat.SatParameters result = new com.google.ortools.sat.SatParameters(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      if (bitField1_ != 0) { buildPartial1(result); }
      if (bitField2_ != 0) { buildPartial2(result); }
      if (bitField3_ != 0) { buildPartial3(result); }
      if (bitField4_ != 0) { buildPartial4(result); }
      if (bitField5_ != 0) { buildPartial5(result); }
      if (bitField6_ != 0) { buildPartial6(result); }
      if (bitField7_ != 0) { buildPartial7(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.ortools.sat.SatParameters result) {
      if (((bitField0_ & 0x10000000) != 0)) {
        restartAlgorithms_ = java.util.Collections.unmodifiableList(restartAlgorithms_);
        bitField0_ = (bitField0_ & ~0x10000000);
      }
      result.restartAlgorithms_ = restartAlgorithms_;
      if (subsolverParamsBuilder_ == null) {
        if (((bitField3_ & 0x00000002) != 0)) {
          subsolverParams_ = java.util.Collections.unmodifiableList(subsolverParams_);
          bitField3_ = (bitField3_ & ~0x00000002);
        }
        result.subsolverParams_ = subsolverParams_;
      } else {
        result.subsolverParams_ = subsolverParamsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.ortools.sat.SatParameters result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.preferredVariableOrder_ = preferredVariableOrder_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.initialPolarity_ = initialPolarity_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.usePhaseSaving_ = usePhaseSaving_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.polarityRephaseIncrement_ = polarityRephaseIncrement_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.randomPolarityRatio_ = randomPolarityRatio_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.randomBranchesRatio_ = randomBranchesRatio_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.useErwaHeuristic_ = useErwaHeuristic_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.initialVariablesActivity_ = initialVariablesActivity_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.alsoBumpVariablesInConflictReasons_ = alsoBumpVariablesInConflictReasons_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.minimizationAlgorithm_ = minimizationAlgorithm_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.binaryMinimizationAlgorithm_ = binaryMinimizationAlgorithm_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.subsumptionDuringConflictAnalysis_ = subsumptionDuringConflictAnalysis_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.clauseCleanupPeriod_ = clauseCleanupPeriod_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.clauseCleanupTarget_ = clauseCleanupTarget_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.clauseCleanupRatio_ = clauseCleanupRatio_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.clauseCleanupProtection_ = clauseCleanupProtection_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.clauseCleanupLbdBound_ = clauseCleanupLbdBound_;
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.clauseCleanupOrdering_ = clauseCleanupOrdering_;
        to_bitField0_ |= 0x00040000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.pbCleanupIncrement_ = pbCleanupIncrement_;
        to_bitField0_ |= 0x00080000;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.pbCleanupRatio_ = pbCleanupRatio_;
        to_bitField0_ |= 0x00100000;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.variableActivityDecay_ = variableActivityDecay_;
        to_bitField0_ |= 0x00200000;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.maxVariableActivityValue_ = maxVariableActivityValue_;
        to_bitField0_ |= 0x00400000;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.glucoseMaxDecay_ = glucoseMaxDecay_;
        to_bitField0_ |= 0x00800000;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.glucoseDecayIncrement_ = glucoseDecayIncrement_;
        to_bitField0_ |= 0x01000000;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.glucoseDecayIncrementPeriod_ = glucoseDecayIncrementPeriod_;
        to_bitField0_ |= 0x02000000;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.clauseActivityDecay_ = clauseActivityDecay_;
        to_bitField0_ |= 0x04000000;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.maxClauseActivityValue_ = maxClauseActivityValue_;
        to_bitField0_ |= 0x08000000;
      }
      if (((from_bitField0_ & 0x20000000) != 0)) {
        result.defaultRestartAlgorithms_ = defaultRestartAlgorithms_;
        to_bitField0_ |= 0x10000000;
      }
      if (((from_bitField0_ & 0x40000000) != 0)) {
        result.restartPeriod_ = restartPeriod_;
        to_bitField0_ |= 0x20000000;
      }
      if (((from_bitField0_ & 0x80000000) != 0)) {
        result.restartRunningWindowSize_ = restartRunningWindowSize_;
        to_bitField0_ |= 0x40000000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartial1(com.google.ortools.sat.SatParameters result) {
      int from_bitField1_ = bitField1_;
      int to_bitField0_ = 0;
      if (((from_bitField1_ & 0x00000001) != 0)) {
        result.restartDlAverageRatio_ = restartDlAverageRatio_;
        to_bitField0_ |= 0x80000000;
      }
      int to_bitField1_ = 0;
      if (((from_bitField1_ & 0x00000002) != 0)) {
        result.restartLbdAverageRatio_ = restartLbdAverageRatio_;
        to_bitField1_ |= 0x00000001;
      }
      if (((from_bitField1_ & 0x00000004) != 0)) {
        result.useBlockingRestart_ = useBlockingRestart_;
        to_bitField1_ |= 0x00000002;
      }
      if (((from_bitField1_ & 0x00000008) != 0)) {
        result.blockingRestartWindowSize_ = blockingRestartWindowSize_;
        to_bitField1_ |= 0x00000004;
      }
      if (((from_bitField1_ & 0x00000010) != 0)) {
        result.blockingRestartMultiplier_ = blockingRestartMultiplier_;
        to_bitField1_ |= 0x00000008;
      }
      if (((from_bitField1_ & 0x00000020) != 0)) {
        result.numConflictsBeforeStrategyChanges_ = numConflictsBeforeStrategyChanges_;
        to_bitField1_ |= 0x00000010;
      }
      if (((from_bitField1_ & 0x00000040) != 0)) {
        result.strategyChangeIncreaseRatio_ = strategyChangeIncreaseRatio_;
        to_bitField1_ |= 0x00000020;
      }
      if (((from_bitField1_ & 0x00000080) != 0)) {
        result.maxTimeInSeconds_ = maxTimeInSeconds_;
        to_bitField1_ |= 0x00000040;
      }
      if (((from_bitField1_ & 0x00000100) != 0)) {
        result.maxDeterministicTime_ = maxDeterministicTime_;
        to_bitField1_ |= 0x00000080;
      }
      if (((from_bitField1_ & 0x00000200) != 0)) {
        result.maxNumDeterministicBatches_ = maxNumDeterministicBatches_;
        to_bitField1_ |= 0x00000100;
      }
      if (((from_bitField1_ & 0x00000400) != 0)) {
        result.maxNumberOfConflicts_ = maxNumberOfConflicts_;
        to_bitField1_ |= 0x00000200;
      }
      if (((from_bitField1_ & 0x00000800) != 0)) {
        result.maxMemoryInMb_ = maxMemoryInMb_;
        to_bitField1_ |= 0x00000400;
      }
      if (((from_bitField1_ & 0x00001000) != 0)) {
        result.absoluteGapLimit_ = absoluteGapLimit_;
        to_bitField1_ |= 0x00000800;
      }
      if (((from_bitField1_ & 0x00002000) != 0)) {
        result.relativeGapLimit_ = relativeGapLimit_;
        to_bitField1_ |= 0x00001000;
      }
      if (((from_bitField1_ & 0x00004000) != 0)) {
        result.randomSeed_ = randomSeed_;
        to_bitField1_ |= 0x00002000;
      }
      if (((from_bitField1_ & 0x00008000) != 0)) {
        result.permuteVariableRandomly_ = permuteVariableRandomly_;
        to_bitField1_ |= 0x00004000;
      }
      if (((from_bitField1_ & 0x00010000) != 0)) {
        result.permutePresolveConstraintOrder_ = permutePresolveConstraintOrder_;
        to_bitField1_ |= 0x00008000;
      }
      if (((from_bitField1_ & 0x00020000) != 0)) {
        result.useAbslRandom_ = useAbslRandom_;
        to_bitField1_ |= 0x00010000;
      }
      if (((from_bitField1_ & 0x00040000) != 0)) {
        result.logSearchProgress_ = logSearchProgress_;
        to_bitField1_ |= 0x00020000;
      }
      if (((from_bitField1_ & 0x00080000) != 0)) {
        result.logSubsolverStatistics_ = logSubsolverStatistics_;
        to_bitField1_ |= 0x00040000;
      }
      if (((from_bitField1_ & 0x00100000) != 0)) {
        result.logPrefix_ = logPrefix_;
        to_bitField1_ |= 0x00080000;
      }
      if (((from_bitField1_ & 0x00200000) != 0)) {
        result.logToStdout_ = logToStdout_;
        to_bitField1_ |= 0x00100000;
      }
      if (((from_bitField1_ & 0x00400000) != 0)) {
        result.logToResponse_ = logToResponse_;
        to_bitField1_ |= 0x00200000;
      }
      if (((from_bitField1_ & 0x00800000) != 0)) {
        result.usePbResolution_ = usePbResolution_;
        to_bitField1_ |= 0x00400000;
      }
      if (((from_bitField1_ & 0x01000000) != 0)) {
        result.minimizeReductionDuringPbResolution_ = minimizeReductionDuringPbResolution_;
        to_bitField1_ |= 0x00800000;
      }
      if (((from_bitField1_ & 0x02000000) != 0)) {
        result.countAssumptionLevelsInLbd_ = countAssumptionLevelsInLbd_;
        to_bitField1_ |= 0x01000000;
      }
      if (((from_bitField1_ & 0x04000000) != 0)) {
        result.presolveBveThreshold_ = presolveBveThreshold_;
        to_bitField1_ |= 0x02000000;
      }
      if (((from_bitField1_ & 0x08000000) != 0)) {
        result.presolveBveClauseWeight_ = presolveBveClauseWeight_;
        to_bitField1_ |= 0x04000000;
      }
      if (((from_bitField1_ & 0x10000000) != 0)) {
        result.probingDeterministicTimeLimit_ = probingDeterministicTimeLimit_;
        to_bitField1_ |= 0x08000000;
      }
      if (((from_bitField1_ & 0x20000000) != 0)) {
        result.presolveProbingDeterministicTimeLimit_ = presolveProbingDeterministicTimeLimit_;
        to_bitField1_ |= 0x10000000;
      }
      if (((from_bitField1_ & 0x40000000) != 0)) {
        result.presolveBlockedClause_ = presolveBlockedClause_;
        to_bitField1_ |= 0x20000000;
      }
      if (((from_bitField1_ & 0x80000000) != 0)) {
        result.presolveUseBva_ = presolveUseBva_;
        to_bitField1_ |= 0x40000000;
      }
      result.bitField0_ |= to_bitField0_;
      result.bitField1_ |= to_bitField1_;
    }

    private void buildPartial2(com.google.ortools.sat.SatParameters result) {
      int from_bitField2_ = bitField2_;
      int to_bitField1_ = 0;
      if (((from_bitField2_ & 0x00000001) != 0)) {
        result.presolveBvaThreshold_ = presolveBvaThreshold_;
        to_bitField1_ |= 0x80000000;
      }
      int to_bitField2_ = 0;
      if (((from_bitField2_ & 0x00000002) != 0)) {
        result.maxPresolveIterations_ = maxPresolveIterations_;
        to_bitField2_ |= 0x00000001;
      }
      if (((from_bitField2_ & 0x00000004) != 0)) {
        result.cpModelPresolve_ = cpModelPresolve_;
        to_bitField2_ |= 0x00000002;
      }
      if (((from_bitField2_ & 0x00000008) != 0)) {
        result.cpModelProbingLevel_ = cpModelProbingLevel_;
        to_bitField2_ |= 0x00000004;
      }
      if (((from_bitField2_ & 0x00000010) != 0)) {
        result.cpModelUseSatPresolve_ = cpModelUseSatPresolve_;
        to_bitField2_ |= 0x00000008;
      }
      if (((from_bitField2_ & 0x00000020) != 0)) {
        result.detectTableWithCost_ = detectTableWithCost_;
        to_bitField2_ |= 0x00000010;
      }
      if (((from_bitField2_ & 0x00000040) != 0)) {
        result.tableCompressionLevel_ = tableCompressionLevel_;
        to_bitField2_ |= 0x00000020;
      }
      if (((from_bitField2_ & 0x00000080) != 0)) {
        result.expandAlldiffConstraints_ = expandAlldiffConstraints_;
        to_bitField2_ |= 0x00000040;
      }
      if (((from_bitField2_ & 0x00000100) != 0)) {
        result.expandReservoirConstraints_ = expandReservoirConstraints_;
        to_bitField2_ |= 0x00000080;
      }
      if (((from_bitField2_ & 0x00000200) != 0)) {
        result.expandReservoirUsingCircuit_ = expandReservoirUsingCircuit_;
        to_bitField2_ |= 0x00000100;
      }
      if (((from_bitField2_ & 0x00000400) != 0)) {
        result.encodeCumulativeAsReservoir_ = encodeCumulativeAsReservoir_;
        to_bitField2_ |= 0x00000200;
      }
      if (((from_bitField2_ & 0x00000800) != 0)) {
        result.maxLinMaxSizeForExpansion_ = maxLinMaxSizeForExpansion_;
        to_bitField2_ |= 0x00000400;
      }
      if (((from_bitField2_ & 0x00001000) != 0)) {
        result.disableConstraintExpansion_ = disableConstraintExpansion_;
        to_bitField2_ |= 0x00000800;
      }
      if (((from_bitField2_ & 0x00002000) != 0)) {
        result.encodeComplexLinearConstraintWithInteger_ = encodeComplexLinearConstraintWithInteger_;
        to_bitField2_ |= 0x00001000;
      }
      if (((from_bitField2_ & 0x00004000) != 0)) {
        result.mergeNoOverlapWorkLimit_ = mergeNoOverlapWorkLimit_;
        to_bitField2_ |= 0x00002000;
      }
      if (((from_bitField2_ & 0x00008000) != 0)) {
        result.mergeAtMostOneWorkLimit_ = mergeAtMostOneWorkLimit_;
        to_bitField2_ |= 0x00004000;
      }
      if (((from_bitField2_ & 0x00010000) != 0)) {
        result.presolveSubstitutionLevel_ = presolveSubstitutionLevel_;
        to_bitField2_ |= 0x00008000;
      }
      if (((from_bitField2_ & 0x00020000) != 0)) {
        result.presolveExtractIntegerEnforcement_ = presolveExtractIntegerEnforcement_;
        to_bitField2_ |= 0x00010000;
      }
      if (((from_bitField2_ & 0x00040000) != 0)) {
        result.presolveInclusionWorkLimit_ = presolveInclusionWorkLimit_;
        to_bitField2_ |= 0x00020000;
      }
      if (((from_bitField2_ & 0x00080000) != 0)) {
        result.ignoreNames_ = ignoreNames_;
        to_bitField2_ |= 0x00040000;
      }
      if (((from_bitField2_ & 0x00100000) != 0)) {
        result.inferAllDiffs_ = inferAllDiffs_;
        to_bitField2_ |= 0x00080000;
      }
      if (((from_bitField2_ & 0x00200000) != 0)) {
        result.findBigLinearOverlap_ = findBigLinearOverlap_;
        to_bitField2_ |= 0x00100000;
      }
      if (((from_bitField2_ & 0x00400000) != 0)) {
        result.useSatInprocessing_ = useSatInprocessing_;
        to_bitField2_ |= 0x00200000;
      }
      if (((from_bitField2_ & 0x00800000) != 0)) {
        result.inprocessingDtimeRatio_ = inprocessingDtimeRatio_;
        to_bitField2_ |= 0x00400000;
      }
      if (((from_bitField2_ & 0x01000000) != 0)) {
        result.inprocessingProbingDtime_ = inprocessingProbingDtime_;
        to_bitField2_ |= 0x00800000;
      }
      if (((from_bitField2_ & 0x02000000) != 0)) {
        result.inprocessingMinimizationDtime_ = inprocessingMinimizationDtime_;
        to_bitField2_ |= 0x01000000;
      }
      if (((from_bitField2_ & 0x04000000) != 0)) {
        result.numWorkers_ = numWorkers_;
        to_bitField2_ |= 0x02000000;
      }
      if (((from_bitField2_ & 0x08000000) != 0)) {
        result.numSearchWorkers_ = numSearchWorkers_;
        to_bitField2_ |= 0x04000000;
      }
      if (((from_bitField2_ & 0x10000000) != 0)) {
        result.numFullSubsolvers_ = numFullSubsolvers_;
        to_bitField2_ |= 0x08000000;
      }
      if (((from_bitField2_ & 0x20000000) != 0)) {
        subsolvers_.makeImmutable();
        result.subsolvers_ = subsolvers_;
      }
      if (((from_bitField2_ & 0x40000000) != 0)) {
        extraSubsolvers_.makeImmutable();
        result.extraSubsolvers_ = extraSubsolvers_;
      }
      if (((from_bitField2_ & 0x80000000) != 0)) {
        ignoreSubsolvers_.makeImmutable();
        result.ignoreSubsolvers_ = ignoreSubsolvers_;
      }
      result.bitField1_ |= to_bitField1_;
      result.bitField2_ |= to_bitField2_;
    }

    private void buildPartial3(com.google.ortools.sat.SatParameters result) {
      int from_bitField3_ = bitField3_;
      if (((from_bitField3_ & 0x00000001) != 0)) {
        filterSubsolvers_.makeImmutable();
        result.filterSubsolvers_ = filterSubsolvers_;
      }
      int to_bitField2_ = 0;
      if (((from_bitField3_ & 0x00000004) != 0)) {
        result.interleaveSearch_ = interleaveSearch_;
        to_bitField2_ |= 0x10000000;
      }
      if (((from_bitField3_ & 0x00000008) != 0)) {
        result.interleaveBatchSize_ = interleaveBatchSize_;
        to_bitField2_ |= 0x20000000;
      }
      if (((from_bitField3_ & 0x00000010) != 0)) {
        result.shareObjectiveBounds_ = shareObjectiveBounds_;
        to_bitField2_ |= 0x40000000;
      }
      if (((from_bitField3_ & 0x00000020) != 0)) {
        result.shareLevelZeroBounds_ = shareLevelZeroBounds_;
        to_bitField2_ |= 0x80000000;
      }
      int to_bitField3_ = 0;
      if (((from_bitField3_ & 0x00000040) != 0)) {
        result.shareBinaryClauses_ = shareBinaryClauses_;
        to_bitField3_ |= 0x00000001;
      }
      if (((from_bitField3_ & 0x00000080) != 0)) {
        result.shareGlueClauses_ = shareGlueClauses_;
        to_bitField3_ |= 0x00000002;
      }
      if (((from_bitField3_ & 0x00000100) != 0)) {
        result.debugPostsolveWithFullSolver_ = debugPostsolveWithFullSolver_;
        to_bitField3_ |= 0x00000004;
      }
      if (((from_bitField3_ & 0x00000200) != 0)) {
        result.debugMaxNumPresolveOperations_ = debugMaxNumPresolveOperations_;
        to_bitField3_ |= 0x00000008;
      }
      if (((from_bitField3_ & 0x00000400) != 0)) {
        result.debugCrashOnBadHint_ = debugCrashOnBadHint_;
        to_bitField3_ |= 0x00000010;
      }
      if (((from_bitField3_ & 0x00000800) != 0)) {
        result.useOptimizationHints_ = useOptimizationHints_;
        to_bitField3_ |= 0x00000020;
      }
      if (((from_bitField3_ & 0x00001000) != 0)) {
        result.coreMinimizationLevel_ = coreMinimizationLevel_;
        to_bitField3_ |= 0x00000040;
      }
      if (((from_bitField3_ & 0x00002000) != 0)) {
        result.findMultipleCores_ = findMultipleCores_;
        to_bitField3_ |= 0x00000080;
      }
      if (((from_bitField3_ & 0x00004000) != 0)) {
        result.coverOptimization_ = coverOptimization_;
        to_bitField3_ |= 0x00000100;
      }
      if (((from_bitField3_ & 0x00008000) != 0)) {
        result.maxSatAssumptionOrder_ = maxSatAssumptionOrder_;
        to_bitField3_ |= 0x00000200;
      }
      if (((from_bitField3_ & 0x00010000) != 0)) {
        result.maxSatReverseAssumptionOrder_ = maxSatReverseAssumptionOrder_;
        to_bitField3_ |= 0x00000400;
      }
      if (((from_bitField3_ & 0x00020000) != 0)) {
        result.maxSatStratification_ = maxSatStratification_;
        to_bitField3_ |= 0x00000800;
      }
      if (((from_bitField3_ & 0x00040000) != 0)) {
        result.propagationLoopDetectionFactor_ = propagationLoopDetectionFactor_;
        to_bitField3_ |= 0x00001000;
      }
      if (((from_bitField3_ & 0x00080000) != 0)) {
        result.usePrecedencesInDisjunctiveConstraint_ = usePrecedencesInDisjunctiveConstraint_;
        to_bitField3_ |= 0x00002000;
      }
      if (((from_bitField3_ & 0x00100000) != 0)) {
        result.maxSizeToCreatePrecedenceLiteralsInDisjunctive_ = maxSizeToCreatePrecedenceLiteralsInDisjunctive_;
        to_bitField3_ |= 0x00004000;
      }
      if (((from_bitField3_ & 0x00200000) != 0)) {
        result.useStrongPropagationInDisjunctive_ = useStrongPropagationInDisjunctive_;
        to_bitField3_ |= 0x00008000;
      }
      if (((from_bitField3_ & 0x00400000) != 0)) {
        result.useDynamicPrecedenceInDisjunctive_ = useDynamicPrecedenceInDisjunctive_;
        to_bitField3_ |= 0x00010000;
      }
      if (((from_bitField3_ & 0x00800000) != 0)) {
        result.useDynamicPrecedenceInCumulative_ = useDynamicPrecedenceInCumulative_;
        to_bitField3_ |= 0x00020000;
      }
      if (((from_bitField3_ & 0x01000000) != 0)) {
        result.useOverloadCheckerInCumulative_ = useOverloadCheckerInCumulative_;
        to_bitField3_ |= 0x00040000;
      }
      if (((from_bitField3_ & 0x02000000) != 0)) {
        result.useConservativeScaleOverloadChecker_ = useConservativeScaleOverloadChecker_;
        to_bitField3_ |= 0x00080000;
      }
      if (((from_bitField3_ & 0x04000000) != 0)) {
        result.useTimetableEdgeFindingInCumulative_ = useTimetableEdgeFindingInCumulative_;
        to_bitField3_ |= 0x00100000;
      }
      if (((from_bitField3_ & 0x08000000) != 0)) {
        result.maxNumIntervalsForTimetableEdgeFinding_ = maxNumIntervalsForTimetableEdgeFinding_;
        to_bitField3_ |= 0x00200000;
      }
      if (((from_bitField3_ & 0x10000000) != 0)) {
        result.useHardPrecedencesInCumulative_ = useHardPrecedencesInCumulative_;
        to_bitField3_ |= 0x00400000;
      }
      if (((from_bitField3_ & 0x20000000) != 0)) {
        result.exploitAllPrecedences_ = exploitAllPrecedences_;
        to_bitField3_ |= 0x00800000;
      }
      if (((from_bitField3_ & 0x40000000) != 0)) {
        result.useDisjunctiveConstraintInCumulative_ = useDisjunctiveConstraintInCumulative_;
        to_bitField3_ |= 0x01000000;
      }
      if (((from_bitField3_ & 0x80000000) != 0)) {
        result.useTimetablingInNoOverlap2D_ = useTimetablingInNoOverlap2D_;
        to_bitField3_ |= 0x02000000;
      }
      result.bitField2_ |= to_bitField2_;
      result.bitField3_ |= to_bitField3_;
    }

    private void buildPartial4(com.google.ortools.sat.SatParameters result) {
      int from_bitField4_ = bitField4_;
      int to_bitField3_ = 0;
      if (((from_bitField4_ & 0x00000001) != 0)) {
        result.useEnergeticReasoningInNoOverlap2D_ = useEnergeticReasoningInNoOverlap2D_;
        to_bitField3_ |= 0x04000000;
      }
      if (((from_bitField4_ & 0x00000002) != 0)) {
        result.useAreaEnergeticReasoningInNoOverlap2D_ = useAreaEnergeticReasoningInNoOverlap2D_;
        to_bitField3_ |= 0x08000000;
      }
      if (((from_bitField4_ & 0x00000004) != 0)) {
        result.maxPairsPairwiseReasoningInNoOverlap2D_ = maxPairsPairwiseReasoningInNoOverlap2D_;
        to_bitField3_ |= 0x10000000;
      }
      if (((from_bitField4_ & 0x00000008) != 0)) {
        result.useDualSchedulingHeuristics_ = useDualSchedulingHeuristics_;
        to_bitField3_ |= 0x20000000;
      }
      if (((from_bitField4_ & 0x00000010) != 0)) {
        result.searchBranching_ = searchBranching_;
        to_bitField3_ |= 0x40000000;
      }
      if (((from_bitField4_ & 0x00000020) != 0)) {
        result.hintConflictLimit_ = hintConflictLimit_;
        to_bitField3_ |= 0x80000000;
      }
      int to_bitField4_ = 0;
      if (((from_bitField4_ & 0x00000040) != 0)) {
        result.repairHint_ = repairHint_;
        to_bitField4_ |= 0x00000001;
      }
      if (((from_bitField4_ & 0x00000080) != 0)) {
        result.fixVariablesToTheirHintedValue_ = fixVariablesToTheirHintedValue_;
        to_bitField4_ |= 0x00000002;
      }
      if (((from_bitField4_ & 0x00000100) != 0)) {
        result.useProbingSearch_ = useProbingSearch_;
        to_bitField4_ |= 0x00000004;
      }
      if (((from_bitField4_ & 0x00000200) != 0)) {
        result.useExtendedProbing_ = useExtendedProbing_;
        to_bitField4_ |= 0x00000008;
      }
      if (((from_bitField4_ & 0x00000400) != 0)) {
        result.probingNumCombinationsLimit_ = probingNumCombinationsLimit_;
        to_bitField4_ |= 0x00000010;
      }
      if (((from_bitField4_ & 0x00000800) != 0)) {
        result.useShavingInProbingSearch_ = useShavingInProbingSearch_;
        to_bitField4_ |= 0x00000020;
      }
      if (((from_bitField4_ & 0x00001000) != 0)) {
        result.shavingSearchDeterministicTime_ = shavingSearchDeterministicTime_;
        to_bitField4_ |= 0x00000040;
      }
      if (((from_bitField4_ & 0x00002000) != 0)) {
        result.shavingSearchThreshold_ = shavingSearchThreshold_;
        to_bitField4_ |= 0x00000080;
      }
      if (((from_bitField4_ & 0x00004000) != 0)) {
        result.useObjectiveLbSearch_ = useObjectiveLbSearch_;
        to_bitField4_ |= 0x00000100;
      }
      if (((from_bitField4_ & 0x00008000) != 0)) {
        result.useObjectiveShavingSearch_ = useObjectiveShavingSearch_;
        to_bitField4_ |= 0x00000200;
      }
      if (((from_bitField4_ & 0x00010000) != 0)) {
        result.useVariablesShavingSearch_ = useVariablesShavingSearch_;
        to_bitField4_ |= 0x00000400;
      }
      if (((from_bitField4_ & 0x00020000) != 0)) {
        result.pseudoCostReliabilityThreshold_ = pseudoCostReliabilityThreshold_;
        to_bitField4_ |= 0x00000800;
      }
      if (((from_bitField4_ & 0x00040000) != 0)) {
        result.optimizeWithCore_ = optimizeWithCore_;
        to_bitField4_ |= 0x00001000;
      }
      if (((from_bitField4_ & 0x00080000) != 0)) {
        result.optimizeWithLbTreeSearch_ = optimizeWithLbTreeSearch_;
        to_bitField4_ |= 0x00002000;
      }
      if (((from_bitField4_ & 0x00100000) != 0)) {
        result.saveLpBasisInLbTreeSearch_ = saveLpBasisInLbTreeSearch_;
        to_bitField4_ |= 0x00004000;
      }
      if (((from_bitField4_ & 0x00200000) != 0)) {
        result.binarySearchNumConflicts_ = binarySearchNumConflicts_;
        to_bitField4_ |= 0x00008000;
      }
      if (((from_bitField4_ & 0x00400000) != 0)) {
        result.optimizeWithMaxHs_ = optimizeWithMaxHs_;
        to_bitField4_ |= 0x00010000;
      }
      if (((from_bitField4_ & 0x00800000) != 0)) {
        result.useFeasibilityJump_ = useFeasibilityJump_;
        to_bitField4_ |= 0x00020000;
      }
      if (((from_bitField4_ & 0x01000000) != 0)) {
        result.useLsOnly_ = useLsOnly_;
        to_bitField4_ |= 0x00040000;
      }
      if (((from_bitField4_ & 0x02000000) != 0)) {
        result.feasibilityJumpDecay_ = feasibilityJumpDecay_;
        to_bitField4_ |= 0x00080000;
      }
      if (((from_bitField4_ & 0x04000000) != 0)) {
        result.feasibilityJumpLinearizationLevel_ = feasibilityJumpLinearizationLevel_;
        to_bitField4_ |= 0x00100000;
      }
      if (((from_bitField4_ & 0x08000000) != 0)) {
        result.feasibilityJumpRestartFactor_ = feasibilityJumpRestartFactor_;
        to_bitField4_ |= 0x00200000;
      }
      if (((from_bitField4_ & 0x10000000) != 0)) {
        result.feasibilityJumpBatchDtime_ = feasibilityJumpBatchDtime_;
        to_bitField4_ |= 0x00400000;
      }
      if (((from_bitField4_ & 0x20000000) != 0)) {
        result.feasibilityJumpVarRandomizationProbability_ = feasibilityJumpVarRandomizationProbability_;
        to_bitField4_ |= 0x00800000;
      }
      if (((from_bitField4_ & 0x40000000) != 0)) {
        result.feasibilityJumpVarPerburbationRangeRatio_ = feasibilityJumpVarPerburbationRangeRatio_;
        to_bitField4_ |= 0x01000000;
      }
      if (((from_bitField4_ & 0x80000000) != 0)) {
        result.feasibilityJumpEnableRestarts_ = feasibilityJumpEnableRestarts_;
        to_bitField4_ |= 0x02000000;
      }
      result.bitField3_ |= to_bitField3_;
      result.bitField4_ |= to_bitField4_;
    }

    private void buildPartial5(com.google.ortools.sat.SatParameters result) {
      int from_bitField5_ = bitField5_;
      int to_bitField4_ = 0;
      if (((from_bitField5_ & 0x00000001) != 0)) {
        result.feasibilityJumpMaxExpandedConstraintSize_ = feasibilityJumpMaxExpandedConstraintSize_;
        to_bitField4_ |= 0x04000000;
      }
      if (((from_bitField5_ & 0x00000002) != 0)) {
        result.numViolationLs_ = numViolationLs_;
        to_bitField4_ |= 0x08000000;
      }
      if (((from_bitField5_ & 0x00000004) != 0)) {
        result.violationLsPerturbationPeriod_ = violationLsPerturbationPeriod_;
        to_bitField4_ |= 0x10000000;
      }
      if (((from_bitField5_ & 0x00000008) != 0)) {
        result.violationLsCompoundMoveProbability_ = violationLsCompoundMoveProbability_;
        to_bitField4_ |= 0x20000000;
      }
      if (((from_bitField5_ & 0x00000010) != 0)) {
        result.sharedTreeNumWorkers_ = sharedTreeNumWorkers_;
        to_bitField4_ |= 0x40000000;
      }
      if (((from_bitField5_ & 0x00000020) != 0)) {
        result.useSharedTreeSearch_ = useSharedTreeSearch_;
        to_bitField4_ |= 0x80000000;
      }
      int to_bitField5_ = 0;
      if (((from_bitField5_ & 0x00000040) != 0)) {
        result.sharedTreeWorkerObjectiveSplitProbability_ = sharedTreeWorkerObjectiveSplitProbability_;
        to_bitField5_ |= 0x00000001;
      }
      if (((from_bitField5_ & 0x00000080) != 0)) {
        result.sharedTreeWorkerMinRestartsPerSubtree_ = sharedTreeWorkerMinRestartsPerSubtree_;
        to_bitField5_ |= 0x00000002;
      }
      if (((from_bitField5_ & 0x00000100) != 0)) {
        result.sharedTreeWorkerEnableTrailSharing_ = sharedTreeWorkerEnableTrailSharing_;
        to_bitField5_ |= 0x00000004;
      }
      if (((from_bitField5_ & 0x00000200) != 0)) {
        result.sharedTreeOpenLeavesPerWorker_ = sharedTreeOpenLeavesPerWorker_;
        to_bitField5_ |= 0x00000008;
      }
      if (((from_bitField5_ & 0x00000400) != 0)) {
        result.sharedTreeMaxNodesPerWorker_ = sharedTreeMaxNodesPerWorker_;
        to_bitField5_ |= 0x00000010;
      }
      if (((from_bitField5_ & 0x00000800) != 0)) {
        result.sharedTreeSplitStrategy_ = sharedTreeSplitStrategy_;
        to_bitField5_ |= 0x00000020;
      }
      if (((from_bitField5_ & 0x00001000) != 0)) {
        result.enumerateAllSolutions_ = enumerateAllSolutions_;
        to_bitField5_ |= 0x00000040;
      }
      if (((from_bitField5_ & 0x00002000) != 0)) {
        result.keepAllFeasibleSolutionsInPresolve_ = keepAllFeasibleSolutionsInPresolve_;
        to_bitField5_ |= 0x00000080;
      }
      if (((from_bitField5_ & 0x00004000) != 0)) {
        result.fillTightenedDomainsInResponse_ = fillTightenedDomainsInResponse_;
        to_bitField5_ |= 0x00000100;
      }
      if (((from_bitField5_ & 0x00008000) != 0)) {
        result.fillAdditionalSolutionsInResponse_ = fillAdditionalSolutionsInResponse_;
        to_bitField5_ |= 0x00000200;
      }
      if (((from_bitField5_ & 0x00010000) != 0)) {
        result.instantiateAllVariables_ = instantiateAllVariables_;
        to_bitField5_ |= 0x00000400;
      }
      if (((from_bitField5_ & 0x00020000) != 0)) {
        result.autoDetectGreaterThanAtLeastOneOf_ = autoDetectGreaterThanAtLeastOneOf_;
        to_bitField5_ |= 0x00000800;
      }
      if (((from_bitField5_ & 0x00040000) != 0)) {
        result.stopAfterFirstSolution_ = stopAfterFirstSolution_;
        to_bitField5_ |= 0x00001000;
      }
      if (((from_bitField5_ & 0x00080000) != 0)) {
        result.stopAfterPresolve_ = stopAfterPresolve_;
        to_bitField5_ |= 0x00002000;
      }
      if (((from_bitField5_ & 0x00100000) != 0)) {
        result.stopAfterRootPropagation_ = stopAfterRootPropagation_;
        to_bitField5_ |= 0x00004000;
      }
      if (((from_bitField5_ & 0x00200000) != 0)) {
        result.useLns_ = useLns_;
        to_bitField5_ |= 0x00008000;
      }
      if (((from_bitField5_ & 0x00400000) != 0)) {
        result.useLnsOnly_ = useLnsOnly_;
        to_bitField5_ |= 0x00010000;
      }
      if (((from_bitField5_ & 0x00800000) != 0)) {
        result.solutionPoolSize_ = solutionPoolSize_;
        to_bitField5_ |= 0x00020000;
      }
      if (((from_bitField5_ & 0x01000000) != 0)) {
        result.useRinsLns_ = useRinsLns_;
        to_bitField5_ |= 0x00040000;
      }
      if (((from_bitField5_ & 0x02000000) != 0)) {
        result.useFeasibilityPump_ = useFeasibilityPump_;
        to_bitField5_ |= 0x00080000;
      }
      if (((from_bitField5_ & 0x04000000) != 0)) {
        result.useLbRelaxLns_ = useLbRelaxLns_;
        to_bitField5_ |= 0x00100000;
      }
      if (((from_bitField5_ & 0x08000000) != 0)) {
        result.fpRounding_ = fpRounding_;
        to_bitField5_ |= 0x00200000;
      }
      if (((from_bitField5_ & 0x10000000) != 0)) {
        result.diversifyLnsParams_ = diversifyLnsParams_;
        to_bitField5_ |= 0x00400000;
      }
      if (((from_bitField5_ & 0x20000000) != 0)) {
        result.randomizeSearch_ = randomizeSearch_;
        to_bitField5_ |= 0x00800000;
      }
      if (((from_bitField5_ & 0x40000000) != 0)) {
        result.searchRandomVariablePoolSize_ = searchRandomVariablePoolSize_;
        to_bitField5_ |= 0x01000000;
      }
      if (((from_bitField5_ & 0x80000000) != 0)) {
        result.pushAllTasksTowardStart_ = pushAllTasksTowardStart_;
        to_bitField5_ |= 0x02000000;
      }
      result.bitField4_ |= to_bitField4_;
      result.bitField5_ |= to_bitField5_;
    }

    private void buildPartial6(com.google.ortools.sat.SatParameters result) {
      int from_bitField6_ = bitField6_;
      int to_bitField5_ = 0;
      if (((from_bitField6_ & 0x00000001) != 0)) {
        result.useOptionalVariables_ = useOptionalVariables_;
        to_bitField5_ |= 0x04000000;
      }
      if (((from_bitField6_ & 0x00000002) != 0)) {
        result.useExactLpReason_ = useExactLpReason_;
        to_bitField5_ |= 0x08000000;
      }
      if (((from_bitField6_ & 0x00000004) != 0)) {
        result.useCombinedNoOverlap_ = useCombinedNoOverlap_;
        to_bitField5_ |= 0x10000000;
      }
      if (((from_bitField6_ & 0x00000008) != 0)) {
        result.atMostOneMaxExpansionSize_ = atMostOneMaxExpansionSize_;
        to_bitField5_ |= 0x20000000;
      }
      if (((from_bitField6_ & 0x00000010) != 0)) {
        result.catchSigintSignal_ = catchSigintSignal_;
        to_bitField5_ |= 0x40000000;
      }
      if (((from_bitField6_ & 0x00000020) != 0)) {
        result.useImpliedBounds_ = useImpliedBounds_;
        to_bitField5_ |= 0x80000000;
      }
      int to_bitField6_ = 0;
      if (((from_bitField6_ & 0x00000040) != 0)) {
        result.polishLpSolution_ = polishLpSolution_;
        to_bitField6_ |= 0x00000001;
      }
      if (((from_bitField6_ & 0x00000080) != 0)) {
        result.lpPrimalTolerance_ = lpPrimalTolerance_;
        to_bitField6_ |= 0x00000002;
      }
      if (((from_bitField6_ & 0x00000100) != 0)) {
        result.lpDualTolerance_ = lpDualTolerance_;
        to_bitField6_ |= 0x00000004;
      }
      if (((from_bitField6_ & 0x00000200) != 0)) {
        result.convertIntervals_ = convertIntervals_;
        to_bitField6_ |= 0x00000008;
      }
      if (((from_bitField6_ & 0x00000400) != 0)) {
        result.symmetryLevel_ = symmetryLevel_;
        to_bitField6_ |= 0x00000010;
      }
      if (((from_bitField6_ & 0x00000800) != 0)) {
        result.newLinearPropagation_ = newLinearPropagation_;
        to_bitField6_ |= 0x00000020;
      }
      if (((from_bitField6_ & 0x00001000) != 0)) {
        result.linearSplitSize_ = linearSplitSize_;
        to_bitField6_ |= 0x00000040;
      }
      if (((from_bitField6_ & 0x00002000) != 0)) {
        result.linearizationLevel_ = linearizationLevel_;
        to_bitField6_ |= 0x00000080;
      }
      if (((from_bitField6_ & 0x00004000) != 0)) {
        result.booleanEncodingLevel_ = booleanEncodingLevel_;
        to_bitField6_ |= 0x00000100;
      }
      if (((from_bitField6_ & 0x00008000) != 0)) {
        result.maxDomainSizeWhenEncodingEqNeqConstraints_ = maxDomainSizeWhenEncodingEqNeqConstraints_;
        to_bitField6_ |= 0x00000200;
      }
      if (((from_bitField6_ & 0x00010000) != 0)) {
        result.maxNumCuts_ = maxNumCuts_;
        to_bitField6_ |= 0x00000400;
      }
      if (((from_bitField6_ & 0x00020000) != 0)) {
        result.cutLevel_ = cutLevel_;
        to_bitField6_ |= 0x00000800;
      }
      if (((from_bitField6_ & 0x00040000) != 0)) {
        result.onlyAddCutsAtLevelZero_ = onlyAddCutsAtLevelZero_;
        to_bitField6_ |= 0x00001000;
      }
      if (((from_bitField6_ & 0x00080000) != 0)) {
        result.addObjectiveCut_ = addObjectiveCut_;
        to_bitField6_ |= 0x00002000;
      }
      if (((from_bitField6_ & 0x00100000) != 0)) {
        result.addCgCuts_ = addCgCuts_;
        to_bitField6_ |= 0x00004000;
      }
      if (((from_bitField6_ & 0x00200000) != 0)) {
        result.addMirCuts_ = addMirCuts_;
        to_bitField6_ |= 0x00008000;
      }
      if (((from_bitField6_ & 0x00400000) != 0)) {
        result.addZeroHalfCuts_ = addZeroHalfCuts_;
        to_bitField6_ |= 0x00010000;
      }
      if (((from_bitField6_ & 0x00800000) != 0)) {
        result.addCliqueCuts_ = addCliqueCuts_;
        to_bitField6_ |= 0x00020000;
      }
      if (((from_bitField6_ & 0x01000000) != 0)) {
        result.addRltCuts_ = addRltCuts_;
        to_bitField6_ |= 0x00040000;
      }
      if (((from_bitField6_ & 0x02000000) != 0)) {
        result.maxAllDiffCutSize_ = maxAllDiffCutSize_;
        to_bitField6_ |= 0x00080000;
      }
      if (((from_bitField6_ & 0x04000000) != 0)) {
        result.addLinMaxCuts_ = addLinMaxCuts_;
        to_bitField6_ |= 0x00100000;
      }
      if (((from_bitField6_ & 0x08000000) != 0)) {
        result.maxIntegerRoundingScaling_ = maxIntegerRoundingScaling_;
        to_bitField6_ |= 0x00200000;
      }
      if (((from_bitField6_ & 0x10000000) != 0)) {
        result.addLpConstraintsLazily_ = addLpConstraintsLazily_;
        to_bitField6_ |= 0x00400000;
      }
      if (((from_bitField6_ & 0x20000000) != 0)) {
        result.rootLpIterations_ = rootLpIterations_;
        to_bitField6_ |= 0x00800000;
      }
      if (((from_bitField6_ & 0x40000000) != 0)) {
        result.minOrthogonalityForLpConstraints_ = minOrthogonalityForLpConstraints_;
        to_bitField6_ |= 0x01000000;
      }
      if (((from_bitField6_ & 0x80000000) != 0)) {
        result.maxCutRoundsAtLevelZero_ = maxCutRoundsAtLevelZero_;
        to_bitField6_ |= 0x02000000;
      }
      result.bitField5_ |= to_bitField5_;
      result.bitField6_ |= to_bitField6_;
    }

    private void buildPartial7(com.google.ortools.sat.SatParameters result) {
      int from_bitField7_ = bitField7_;
      int to_bitField6_ = 0;
      if (((from_bitField7_ & 0x00000001) != 0)) {
        result.maxConsecutiveInactiveCount_ = maxConsecutiveInactiveCount_;
        to_bitField6_ |= 0x04000000;
      }
      if (((from_bitField7_ & 0x00000002) != 0)) {
        result.cutMaxActiveCountValue_ = cutMaxActiveCountValue_;
        to_bitField6_ |= 0x08000000;
      }
      if (((from_bitField7_ & 0x00000004) != 0)) {
        result.cutActiveCountDecay_ = cutActiveCountDecay_;
        to_bitField6_ |= 0x10000000;
      }
      if (((from_bitField7_ & 0x00000008) != 0)) {
        result.cutCleanupTarget_ = cutCleanupTarget_;
        to_bitField6_ |= 0x20000000;
      }
      if (((from_bitField7_ & 0x00000010) != 0)) {
        result.newConstraintsBatchSize_ = newConstraintsBatchSize_;
        to_bitField6_ |= 0x40000000;
      }
      if (((from_bitField7_ & 0x00000020) != 0)) {
        result.exploitIntegerLpSolution_ = exploitIntegerLpSolution_;
        to_bitField6_ |= 0x80000000;
      }
      int to_bitField7_ = 0;
      if (((from_bitField7_ & 0x00000040) != 0)) {
        result.exploitAllLpSolution_ = exploitAllLpSolution_;
        to_bitField7_ |= 0x00000001;
      }
      if (((from_bitField7_ & 0x00000080) != 0)) {
        result.exploitBestSolution_ = exploitBestSolution_;
        to_bitField7_ |= 0x00000002;
      }
      if (((from_bitField7_ & 0x00000100) != 0)) {
        result.exploitRelaxationSolution_ = exploitRelaxationSolution_;
        to_bitField7_ |= 0x00000004;
      }
      if (((from_bitField7_ & 0x00000200) != 0)) {
        result.exploitObjective_ = exploitObjective_;
        to_bitField7_ |= 0x00000008;
      }
      if (((from_bitField7_ & 0x00000400) != 0)) {
        result.detectLinearizedProduct_ = detectLinearizedProduct_;
        to_bitField7_ |= 0x00000010;
      }
      if (((from_bitField7_ & 0x00000800) != 0)) {
        result.mipMaxBound_ = mipMaxBound_;
        to_bitField7_ |= 0x00000020;
      }
      if (((from_bitField7_ & 0x00001000) != 0)) {
        result.mipVarScaling_ = mipVarScaling_;
        to_bitField7_ |= 0x00000040;
      }
      if (((from_bitField7_ & 0x00002000) != 0)) {
        result.mipScaleLargeDomain_ = mipScaleLargeDomain_;
        to_bitField7_ |= 0x00000080;
      }
      if (((from_bitField7_ & 0x00004000) != 0)) {
        result.mipAutomaticallyScaleVariables_ = mipAutomaticallyScaleVariables_;
        to_bitField7_ |= 0x00000100;
      }
      if (((from_bitField7_ & 0x00008000) != 0)) {
        result.onlySolveIp_ = onlySolveIp_;
        to_bitField7_ |= 0x00000200;
      }
      if (((from_bitField7_ & 0x00010000) != 0)) {
        result.mipWantedPrecision_ = mipWantedPrecision_;
        to_bitField7_ |= 0x00000400;
      }
      if (((from_bitField7_ & 0x00020000) != 0)) {
        result.mipMaxActivityExponent_ = mipMaxActivityExponent_;
        to_bitField7_ |= 0x00000800;
      }
      if (((from_bitField7_ & 0x00040000) != 0)) {
        result.mipCheckPrecision_ = mipCheckPrecision_;
        to_bitField7_ |= 0x00001000;
      }
      if (((from_bitField7_ & 0x00080000) != 0)) {
        result.mipComputeTrueObjectiveBound_ = mipComputeTrueObjectiveBound_;
        to_bitField7_ |= 0x00002000;
      }
      if (((from_bitField7_ & 0x00100000) != 0)) {
        result.mipMaxValidMagnitude_ = mipMaxValidMagnitude_;
        to_bitField7_ |= 0x00004000;
      }
      if (((from_bitField7_ & 0x00200000) != 0)) {
        result.mipTreatHighMagnitudeBoundsAsInfinity_ = mipTreatHighMagnitudeBoundsAsInfinity_;
        to_bitField7_ |= 0x00008000;
      }
      if (((from_bitField7_ & 0x00400000) != 0)) {
        result.mipDropTolerance_ = mipDropTolerance_;
        to_bitField7_ |= 0x00010000;
      }
      if (((from_bitField7_ & 0x00800000) != 0)) {
        result.mipPresolveLevel_ = mipPresolveLevel_;
        to_bitField7_ |= 0x00020000;
      }
      result.bitField6_ |= to_bitField6_;
      result.bitField7_ |= to_bitField7_;
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ortools.sat.SatParameters) {
        return mergeFrom((com.google.ortools.sat.SatParameters)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ortools.sat.SatParameters other) {
      if (other == com.google.ortools.sat.SatParameters.getDefaultInstance()) return this;
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasPreferredVariableOrder()) {
        setPreferredVariableOrder(other.getPreferredVariableOrder());
      }
      if (other.hasInitialPolarity()) {
        setInitialPolarity(other.getInitialPolarity());
      }
      if (other.hasUsePhaseSaving()) {
        setUsePhaseSaving(other.getUsePhaseSaving());
      }
      if (other.hasPolarityRephaseIncrement()) {
        setPolarityRephaseIncrement(other.getPolarityRephaseIncrement());
      }
      if (other.hasRandomPolarityRatio()) {
        setRandomPolarityRatio(other.getRandomPolarityRatio());
      }
      if (other.hasRandomBranchesRatio()) {
        setRandomBranchesRatio(other.getRandomBranchesRatio());
      }
      if (other.hasUseErwaHeuristic()) {
        setUseErwaHeuristic(other.getUseErwaHeuristic());
      }
      if (other.hasInitialVariablesActivity()) {
        setInitialVariablesActivity(other.getInitialVariablesActivity());
      }
      if (other.hasAlsoBumpVariablesInConflictReasons()) {
        setAlsoBumpVariablesInConflictReasons(other.getAlsoBumpVariablesInConflictReasons());
      }
      if (other.hasMinimizationAlgorithm()) {
        setMinimizationAlgorithm(other.getMinimizationAlgorithm());
      }
      if (other.hasBinaryMinimizationAlgorithm()) {
        setBinaryMinimizationAlgorithm(other.getBinaryMinimizationAlgorithm());
      }
      if (other.hasSubsumptionDuringConflictAnalysis()) {
        setSubsumptionDuringConflictAnalysis(other.getSubsumptionDuringConflictAnalysis());
      }
      if (other.hasClauseCleanupPeriod()) {
        setClauseCleanupPeriod(other.getClauseCleanupPeriod());
      }
      if (other.hasClauseCleanupTarget()) {
        setClauseCleanupTarget(other.getClauseCleanupTarget());
      }
      if (other.hasClauseCleanupRatio()) {
        setClauseCleanupRatio(other.getClauseCleanupRatio());
      }
      if (other.hasClauseCleanupProtection()) {
        setClauseCleanupProtection(other.getClauseCleanupProtection());
      }
      if (other.hasClauseCleanupLbdBound()) {
        setClauseCleanupLbdBound(other.getClauseCleanupLbdBound());
      }
      if (other.hasClauseCleanupOrdering()) {
        setClauseCleanupOrdering(other.getClauseCleanupOrdering());
      }
      if (other.hasPbCleanupIncrement()) {
        setPbCleanupIncrement(other.getPbCleanupIncrement());
      }
      if (other.hasPbCleanupRatio()) {
        setPbCleanupRatio(other.getPbCleanupRatio());
      }
      if (other.hasVariableActivityDecay()) {
        setVariableActivityDecay(other.getVariableActivityDecay());
      }
      if (other.hasMaxVariableActivityValue()) {
        setMaxVariableActivityValue(other.getMaxVariableActivityValue());
      }
      if (other.hasGlucoseMaxDecay()) {
        setGlucoseMaxDecay(other.getGlucoseMaxDecay());
      }
      if (other.hasGlucoseDecayIncrement()) {
        setGlucoseDecayIncrement(other.getGlucoseDecayIncrement());
      }
      if (other.hasGlucoseDecayIncrementPeriod()) {
        setGlucoseDecayIncrementPeriod(other.getGlucoseDecayIncrementPeriod());
      }
      if (other.hasClauseActivityDecay()) {
        setClauseActivityDecay(other.getClauseActivityDecay());
      }
      if (other.hasMaxClauseActivityValue()) {
        setMaxClauseActivityValue(other.getMaxClauseActivityValue());
      }
      if (!other.restartAlgorithms_.isEmpty()) {
        if (restartAlgorithms_.isEmpty()) {
          restartAlgorithms_ = other.restartAlgorithms_;
          bitField0_ = (bitField0_ & ~0x10000000);
        } else {
          ensureRestartAlgorithmsIsMutable();
          restartAlgorithms_.addAll(other.restartAlgorithms_);
        }
        onChanged();
      }
      if (other.hasDefaultRestartAlgorithms()) {
        defaultRestartAlgorithms_ = other.defaultRestartAlgorithms_;
        bitField0_ |= 0x20000000;
        onChanged();
      }
      if (other.hasRestartPeriod()) {
        setRestartPeriod(other.getRestartPeriod());
      }
      if (other.hasRestartRunningWindowSize()) {
        setRestartRunningWindowSize(other.getRestartRunningWindowSize());
      }
      if (other.hasRestartDlAverageRatio()) {
        setRestartDlAverageRatio(other.getRestartDlAverageRatio());
      }
      if (other.hasRestartLbdAverageRatio()) {
        setRestartLbdAverageRatio(other.getRestartLbdAverageRatio());
      }
      if (other.hasUseBlockingRestart()) {
        setUseBlockingRestart(other.getUseBlockingRestart());
      }
      if (other.hasBlockingRestartWindowSize()) {
        setBlockingRestartWindowSize(other.getBlockingRestartWindowSize());
      }
      if (other.hasBlockingRestartMultiplier()) {
        setBlockingRestartMultiplier(other.getBlockingRestartMultiplier());
      }
      if (other.hasNumConflictsBeforeStrategyChanges()) {
        setNumConflictsBeforeStrategyChanges(other.getNumConflictsBeforeStrategyChanges());
      }
      if (other.hasStrategyChangeIncreaseRatio()) {
        setStrategyChangeIncreaseRatio(other.getStrategyChangeIncreaseRatio());
      }
      if (other.hasMaxTimeInSeconds()) {
        setMaxTimeInSeconds(other.getMaxTimeInSeconds());
      }
      if (other.hasMaxDeterministicTime()) {
        setMaxDeterministicTime(other.getMaxDeterministicTime());
      }
      if (other.hasMaxNumDeterministicBatches()) {
        setMaxNumDeterministicBatches(other.getMaxNumDeterministicBatches());
      }
      if (other.hasMaxNumberOfConflicts()) {
        setMaxNumberOfConflicts(other.getMaxNumberOfConflicts());
      }
      if (other.hasMaxMemoryInMb()) {
        setMaxMemoryInMb(other.getMaxMemoryInMb());
      }
      if (other.hasAbsoluteGapLimit()) {
        setAbsoluteGapLimit(other.getAbsoluteGapLimit());
      }
      if (other.hasRelativeGapLimit()) {
        setRelativeGapLimit(other.getRelativeGapLimit());
      }
      if (other.hasRandomSeed()) {
        setRandomSeed(other.getRandomSeed());
      }
      if (other.hasPermuteVariableRandomly()) {
        setPermuteVariableRandomly(other.getPermuteVariableRandomly());
      }
      if (other.hasPermutePresolveConstraintOrder()) {
        setPermutePresolveConstraintOrder(other.getPermutePresolveConstraintOrder());
      }
      if (other.hasUseAbslRandom()) {
        setUseAbslRandom(other.getUseAbslRandom());
      }
      if (other.hasLogSearchProgress()) {
        setLogSearchProgress(other.getLogSearchProgress());
      }
      if (other.hasLogSubsolverStatistics()) {
        setLogSubsolverStatistics(other.getLogSubsolverStatistics());
      }
      if (other.hasLogPrefix()) {
        logPrefix_ = other.logPrefix_;
        bitField1_ |= 0x00100000;
        onChanged();
      }
      if (other.hasLogToStdout()) {
        setLogToStdout(other.getLogToStdout());
      }
      if (other.hasLogToResponse()) {
        setLogToResponse(other.getLogToResponse());
      }
      if (other.hasUsePbResolution()) {
        setUsePbResolution(other.getUsePbResolution());
      }
      if (other.hasMinimizeReductionDuringPbResolution()) {
        setMinimizeReductionDuringPbResolution(other.getMinimizeReductionDuringPbResolution());
      }
      if (other.hasCountAssumptionLevelsInLbd()) {
        setCountAssumptionLevelsInLbd(other.getCountAssumptionLevelsInLbd());
      }
      if (other.hasPresolveBveThreshold()) {
        setPresolveBveThreshold(other.getPresolveBveThreshold());
      }
      if (other.hasPresolveBveClauseWeight()) {
        setPresolveBveClauseWeight(other.getPresolveBveClauseWeight());
      }
      if (other.hasProbingDeterministicTimeLimit()) {
        setProbingDeterministicTimeLimit(other.getProbingDeterministicTimeLimit());
      }
      if (other.hasPresolveProbingDeterministicTimeLimit()) {
        setPresolveProbingDeterministicTimeLimit(other.getPresolveProbingDeterministicTimeLimit());
      }
      if (other.hasPresolveBlockedClause()) {
        setPresolveBlockedClause(other.getPresolveBlockedClause());
      }
      if (other.hasPresolveUseBva()) {
        setPresolveUseBva(other.getPresolveUseBva());
      }
      if (other.hasPresolveBvaThreshold()) {
        setPresolveBvaThreshold(other.getPresolveBvaThreshold());
      }
      if (other.hasMaxPresolveIterations()) {
        setMaxPresolveIterations(other.getMaxPresolveIterations());
      }
      if (other.hasCpModelPresolve()) {
        setCpModelPresolve(other.getCpModelPresolve());
      }
      if (other.hasCpModelProbingLevel()) {
        setCpModelProbingLevel(other.getCpModelProbingLevel());
      }
      if (other.hasCpModelUseSatPresolve()) {
        setCpModelUseSatPresolve(other.getCpModelUseSatPresolve());
      }
      if (other.hasDetectTableWithCost()) {
        setDetectTableWithCost(other.getDetectTableWithCost());
      }
      if (other.hasTableCompressionLevel()) {
        setTableCompressionLevel(other.getTableCompressionLevel());
      }
      if (other.hasExpandAlldiffConstraints()) {
        setExpandAlldiffConstraints(other.getExpandAlldiffConstraints());
      }
      if (other.hasExpandReservoirConstraints()) {
        setExpandReservoirConstraints(other.getExpandReservoirConstraints());
      }
      if (other.hasExpandReservoirUsingCircuit()) {
        setExpandReservoirUsingCircuit(other.getExpandReservoirUsingCircuit());
      }
      if (other.hasEncodeCumulativeAsReservoir()) {
        setEncodeCumulativeAsReservoir(other.getEncodeCumulativeAsReservoir());
      }
      if (other.hasMaxLinMaxSizeForExpansion()) {
        setMaxLinMaxSizeForExpansion(other.getMaxLinMaxSizeForExpansion());
      }
      if (other.hasDisableConstraintExpansion()) {
        setDisableConstraintExpansion(other.getDisableConstraintExpansion());
      }
      if (other.hasEncodeComplexLinearConstraintWithInteger()) {
        setEncodeComplexLinearConstraintWithInteger(other.getEncodeComplexLinearConstraintWithInteger());
      }
      if (other.hasMergeNoOverlapWorkLimit()) {
        setMergeNoOverlapWorkLimit(other.getMergeNoOverlapWorkLimit());
      }
      if (other.hasMergeAtMostOneWorkLimit()) {
        setMergeAtMostOneWorkLimit(other.getMergeAtMostOneWorkLimit());
      }
      if (other.hasPresolveSubstitutionLevel()) {
        setPresolveSubstitutionLevel(other.getPresolveSubstitutionLevel());
      }
      if (other.hasPresolveExtractIntegerEnforcement()) {
        setPresolveExtractIntegerEnforcement(other.getPresolveExtractIntegerEnforcement());
      }
      if (other.hasPresolveInclusionWorkLimit()) {
        setPresolveInclusionWorkLimit(other.getPresolveInclusionWorkLimit());
      }
      if (other.hasIgnoreNames()) {
        setIgnoreNames(other.getIgnoreNames());
      }
      if (other.hasInferAllDiffs()) {
        setInferAllDiffs(other.getInferAllDiffs());
      }
      if (other.hasFindBigLinearOverlap()) {
        setFindBigLinearOverlap(other.getFindBigLinearOverlap());
      }
      if (other.hasUseSatInprocessing()) {
        setUseSatInprocessing(other.getUseSatInprocessing());
      }
      if (other.hasInprocessingDtimeRatio()) {
        setInprocessingDtimeRatio(other.getInprocessingDtimeRatio());
      }
      if (other.hasInprocessingProbingDtime()) {
        setInprocessingProbingDtime(other.getInprocessingProbingDtime());
      }
      if (other.hasInprocessingMinimizationDtime()) {
        setInprocessingMinimizationDtime(other.getInprocessingMinimizationDtime());
      }
      if (other.hasNumWorkers()) {
        setNumWorkers(other.getNumWorkers());
      }
      if (other.hasNumSearchWorkers()) {
        setNumSearchWorkers(other.getNumSearchWorkers());
      }
      if (other.hasNumFullSubsolvers()) {
        setNumFullSubsolvers(other.getNumFullSubsolvers());
      }
      if (!other.subsolvers_.isEmpty()) {
        if (subsolvers_.isEmpty()) {
          subsolvers_ = other.subsolvers_;
          bitField2_ |= 0x20000000;
        } else {
          ensureSubsolversIsMutable();
          subsolvers_.addAll(other.subsolvers_);
        }
        onChanged();
      }
      if (!other.extraSubsolvers_.isEmpty()) {
        if (extraSubsolvers_.isEmpty()) {
          extraSubsolvers_ = other.extraSubsolvers_;
          bitField2_ |= 0x40000000;
        } else {
          ensureExtraSubsolversIsMutable();
          extraSubsolvers_.addAll(other.extraSubsolvers_);
        }
        onChanged();
      }
      if (!other.ignoreSubsolvers_.isEmpty()) {
        if (ignoreSubsolvers_.isEmpty()) {
          ignoreSubsolvers_ = other.ignoreSubsolvers_;
          bitField2_ |= 0x80000000;
        } else {
          ensureIgnoreSubsolversIsMutable();
          ignoreSubsolvers_.addAll(other.ignoreSubsolvers_);
        }
        onChanged();
      }
      if (!other.filterSubsolvers_.isEmpty()) {
        if (filterSubsolvers_.isEmpty()) {
          filterSubsolvers_ = other.filterSubsolvers_;
          bitField3_ |= 0x00000001;
        } else {
          ensureFilterSubsolversIsMutable();
          filterSubsolvers_.addAll(other.filterSubsolvers_);
        }
        onChanged();
      }
      if (subsolverParamsBuilder_ == null) {
        if (!other.subsolverParams_.isEmpty()) {
          if (subsolverParams_.isEmpty()) {
            subsolverParams_ = other.subsolverParams_;
            bitField3_ = (bitField3_ & ~0x00000002);
          } else {
            ensureSubsolverParamsIsMutable();
            subsolverParams_.addAll(other.subsolverParams_);
          }
          onChanged();
        }
      } else {
        if (!other.subsolverParams_.isEmpty()) {
          if (subsolverParamsBuilder_.isEmpty()) {
            subsolverParamsBuilder_.dispose();
            subsolverParamsBuilder_ = null;
            subsolverParams_ = other.subsolverParams_;
            bitField3_ = (bitField3_ & ~0x00000002);
            subsolverParamsBuilder_ = 
              com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                 getSubsolverParamsFieldBuilder() : null;
          } else {
            subsolverParamsBuilder_.addAllMessages(other.subsolverParams_);
          }
        }
      }
      if (other.hasInterleaveSearch()) {
        setInterleaveSearch(other.getInterleaveSearch());
      }
      if (other.hasInterleaveBatchSize()) {
        setInterleaveBatchSize(other.getInterleaveBatchSize());
      }
      if (other.hasShareObjectiveBounds()) {
        setShareObjectiveBounds(other.getShareObjectiveBounds());
      }
      if (other.hasShareLevelZeroBounds()) {
        setShareLevelZeroBounds(other.getShareLevelZeroBounds());
      }
      if (other.hasShareBinaryClauses()) {
        setShareBinaryClauses(other.getShareBinaryClauses());
      }
      if (other.hasShareGlueClauses()) {
        setShareGlueClauses(other.getShareGlueClauses());
      }
      if (other.hasDebugPostsolveWithFullSolver()) {
        setDebugPostsolveWithFullSolver(other.getDebugPostsolveWithFullSolver());
      }
      if (other.hasDebugMaxNumPresolveOperations()) {
        setDebugMaxNumPresolveOperations(other.getDebugMaxNumPresolveOperations());
      }
      if (other.hasDebugCrashOnBadHint()) {
        setDebugCrashOnBadHint(other.getDebugCrashOnBadHint());
      }
      if (other.hasUseOptimizationHints()) {
        setUseOptimizationHints(other.getUseOptimizationHints());
      }
      if (other.hasCoreMinimizationLevel()) {
        setCoreMinimizationLevel(other.getCoreMinimizationLevel());
      }
      if (other.hasFindMultipleCores()) {
        setFindMultipleCores(other.getFindMultipleCores());
      }
      if (other.hasCoverOptimization()) {
        setCoverOptimization(other.getCoverOptimization());
      }
      if (other.hasMaxSatAssumptionOrder()) {
        setMaxSatAssumptionOrder(other.getMaxSatAssumptionOrder());
      }
      if (other.hasMaxSatReverseAssumptionOrder()) {
        setMaxSatReverseAssumptionOrder(other.getMaxSatReverseAssumptionOrder());
      }
      if (other.hasMaxSatStratification()) {
        setMaxSatStratification(other.getMaxSatStratification());
      }
      if (other.hasPropagationLoopDetectionFactor()) {
        setPropagationLoopDetectionFactor(other.getPropagationLoopDetectionFactor());
      }
      if (other.hasUsePrecedencesInDisjunctiveConstraint()) {
        setUsePrecedencesInDisjunctiveConstraint(other.getUsePrecedencesInDisjunctiveConstraint());
      }
      if (other.hasMaxSizeToCreatePrecedenceLiteralsInDisjunctive()) {
        setMaxSizeToCreatePrecedenceLiteralsInDisjunctive(other.getMaxSizeToCreatePrecedenceLiteralsInDisjunctive());
      }
      if (other.hasUseStrongPropagationInDisjunctive()) {
        setUseStrongPropagationInDisjunctive(other.getUseStrongPropagationInDisjunctive());
      }
      if (other.hasUseDynamicPrecedenceInDisjunctive()) {
        setUseDynamicPrecedenceInDisjunctive(other.getUseDynamicPrecedenceInDisjunctive());
      }
      if (other.hasUseDynamicPrecedenceInCumulative()) {
        setUseDynamicPrecedenceInCumulative(other.getUseDynamicPrecedenceInCumulative());
      }
      if (other.hasUseOverloadCheckerInCumulative()) {
        setUseOverloadCheckerInCumulative(other.getUseOverloadCheckerInCumulative());
      }
      if (other.hasUseConservativeScaleOverloadChecker()) {
        setUseConservativeScaleOverloadChecker(other.getUseConservativeScaleOverloadChecker());
      }
      if (other.hasUseTimetableEdgeFindingInCumulative()) {
        setUseTimetableEdgeFindingInCumulative(other.getUseTimetableEdgeFindingInCumulative());
      }
      if (other.hasMaxNumIntervalsForTimetableEdgeFinding()) {
        setMaxNumIntervalsForTimetableEdgeFinding(other.getMaxNumIntervalsForTimetableEdgeFinding());
      }
      if (other.hasUseHardPrecedencesInCumulative()) {
        setUseHardPrecedencesInCumulative(other.getUseHardPrecedencesInCumulative());
      }
      if (other.hasExploitAllPrecedences()) {
        setExploitAllPrecedences(other.getExploitAllPrecedences());
      }
      if (other.hasUseDisjunctiveConstraintInCumulative()) {
        setUseDisjunctiveConstraintInCumulative(other.getUseDisjunctiveConstraintInCumulative());
      }
      if (other.hasUseTimetablingInNoOverlap2D()) {
        setUseTimetablingInNoOverlap2D(other.getUseTimetablingInNoOverlap2D());
      }
      if (other.hasUseEnergeticReasoningInNoOverlap2D()) {
        setUseEnergeticReasoningInNoOverlap2D(other.getUseEnergeticReasoningInNoOverlap2D());
      }
      if (other.hasUseAreaEnergeticReasoningInNoOverlap2D()) {
        setUseAreaEnergeticReasoningInNoOverlap2D(other.getUseAreaEnergeticReasoningInNoOverlap2D());
      }
      if (other.hasMaxPairsPairwiseReasoningInNoOverlap2D()) {
        setMaxPairsPairwiseReasoningInNoOverlap2D(other.getMaxPairsPairwiseReasoningInNoOverlap2D());
      }
      if (other.hasUseDualSchedulingHeuristics()) {
        setUseDualSchedulingHeuristics(other.getUseDualSchedulingHeuristics());
      }
      if (other.hasSearchBranching()) {
        setSearchBranching(other.getSearchBranching());
      }
      if (other.hasHintConflictLimit()) {
        setHintConflictLimit(other.getHintConflictLimit());
      }
      if (other.hasRepairHint()) {
        setRepairHint(other.getRepairHint());
      }
      if (other.hasFixVariablesToTheirHintedValue()) {
        setFixVariablesToTheirHintedValue(other.getFixVariablesToTheirHintedValue());
      }
      if (other.hasUseProbingSearch()) {
        setUseProbingSearch(other.getUseProbingSearch());
      }
      if (other.hasUseExtendedProbing()) {
        setUseExtendedProbing(other.getUseExtendedProbing());
      }
      if (other.hasProbingNumCombinationsLimit()) {
        setProbingNumCombinationsLimit(other.getProbingNumCombinationsLimit());
      }
      if (other.hasUseShavingInProbingSearch()) {
        setUseShavingInProbingSearch(other.getUseShavingInProbingSearch());
      }
      if (other.hasShavingSearchDeterministicTime()) {
        setShavingSearchDeterministicTime(other.getShavingSearchDeterministicTime());
      }
      if (other.hasShavingSearchThreshold()) {
        setShavingSearchThreshold(other.getShavingSearchThreshold());
      }
      if (other.hasUseObjectiveLbSearch()) {
        setUseObjectiveLbSearch(other.getUseObjectiveLbSearch());
      }
      if (other.hasUseObjectiveShavingSearch()) {
        setUseObjectiveShavingSearch(other.getUseObjectiveShavingSearch());
      }
      if (other.hasUseVariablesShavingSearch()) {
        setUseVariablesShavingSearch(other.getUseVariablesShavingSearch());
      }
      if (other.hasPseudoCostReliabilityThreshold()) {
        setPseudoCostReliabilityThreshold(other.getPseudoCostReliabilityThreshold());
      }
      if (other.hasOptimizeWithCore()) {
        setOptimizeWithCore(other.getOptimizeWithCore());
      }
      if (other.hasOptimizeWithLbTreeSearch()) {
        setOptimizeWithLbTreeSearch(other.getOptimizeWithLbTreeSearch());
      }
      if (other.hasSaveLpBasisInLbTreeSearch()) {
        setSaveLpBasisInLbTreeSearch(other.getSaveLpBasisInLbTreeSearch());
      }
      if (other.hasBinarySearchNumConflicts()) {
        setBinarySearchNumConflicts(other.getBinarySearchNumConflicts());
      }
      if (other.hasOptimizeWithMaxHs()) {
        setOptimizeWithMaxHs(other.getOptimizeWithMaxHs());
      }
      if (other.hasUseFeasibilityJump()) {
        setUseFeasibilityJump(other.getUseFeasibilityJump());
      }
      if (other.hasUseLsOnly()) {
        setUseLsOnly(other.getUseLsOnly());
      }
      if (other.hasFeasibilityJumpDecay()) {
        setFeasibilityJumpDecay(other.getFeasibilityJumpDecay());
      }
      if (other.hasFeasibilityJumpLinearizationLevel()) {
        setFeasibilityJumpLinearizationLevel(other.getFeasibilityJumpLinearizationLevel());
      }
      if (other.hasFeasibilityJumpRestartFactor()) {
        setFeasibilityJumpRestartFactor(other.getFeasibilityJumpRestartFactor());
      }
      if (other.hasFeasibilityJumpBatchDtime()) {
        setFeasibilityJumpBatchDtime(other.getFeasibilityJumpBatchDtime());
      }
      if (other.hasFeasibilityJumpVarRandomizationProbability()) {
        setFeasibilityJumpVarRandomizationProbability(other.getFeasibilityJumpVarRandomizationProbability());
      }
      if (other.hasFeasibilityJumpVarPerburbationRangeRatio()) {
        setFeasibilityJumpVarPerburbationRangeRatio(other.getFeasibilityJumpVarPerburbationRangeRatio());
      }
      if (other.hasFeasibilityJumpEnableRestarts()) {
        setFeasibilityJumpEnableRestarts(other.getFeasibilityJumpEnableRestarts());
      }
      if (other.hasFeasibilityJumpMaxExpandedConstraintSize()) {
        setFeasibilityJumpMaxExpandedConstraintSize(other.getFeasibilityJumpMaxExpandedConstraintSize());
      }
      if (other.hasNumViolationLs()) {
        setNumViolationLs(other.getNumViolationLs());
      }
      if (other.hasViolationLsPerturbationPeriod()) {
        setViolationLsPerturbationPeriod(other.getViolationLsPerturbationPeriod());
      }
      if (other.hasViolationLsCompoundMoveProbability()) {
        setViolationLsCompoundMoveProbability(other.getViolationLsCompoundMoveProbability());
      }
      if (other.hasSharedTreeNumWorkers()) {
        setSharedTreeNumWorkers(other.getSharedTreeNumWorkers());
      }
      if (other.hasUseSharedTreeSearch()) {
        setUseSharedTreeSearch(other.getUseSharedTreeSearch());
      }
      if (other.hasSharedTreeWorkerObjectiveSplitProbability()) {
        setSharedTreeWorkerObjectiveSplitProbability(other.getSharedTreeWorkerObjectiveSplitProbability());
      }
      if (other.hasSharedTreeWorkerMinRestartsPerSubtree()) {
        setSharedTreeWorkerMinRestartsPerSubtree(other.getSharedTreeWorkerMinRestartsPerSubtree());
      }
      if (other.hasSharedTreeWorkerEnableTrailSharing()) {
        setSharedTreeWorkerEnableTrailSharing(other.getSharedTreeWorkerEnableTrailSharing());
      }
      if (other.hasSharedTreeOpenLeavesPerWorker()) {
        setSharedTreeOpenLeavesPerWorker(other.getSharedTreeOpenLeavesPerWorker());
      }
      if (other.hasSharedTreeMaxNodesPerWorker()) {
        setSharedTreeMaxNodesPerWorker(other.getSharedTreeMaxNodesPerWorker());
      }
      if (other.hasSharedTreeSplitStrategy()) {
        setSharedTreeSplitStrategy(other.getSharedTreeSplitStrategy());
      }
      if (other.hasEnumerateAllSolutions()) {
        setEnumerateAllSolutions(other.getEnumerateAllSolutions());
      }
      if (other.hasKeepAllFeasibleSolutionsInPresolve()) {
        setKeepAllFeasibleSolutionsInPresolve(other.getKeepAllFeasibleSolutionsInPresolve());
      }
      if (other.hasFillTightenedDomainsInResponse()) {
        setFillTightenedDomainsInResponse(other.getFillTightenedDomainsInResponse());
      }
      if (other.hasFillAdditionalSolutionsInResponse()) {
        setFillAdditionalSolutionsInResponse(other.getFillAdditionalSolutionsInResponse());
      }
      if (other.hasInstantiateAllVariables()) {
        setInstantiateAllVariables(other.getInstantiateAllVariables());
      }
      if (other.hasAutoDetectGreaterThanAtLeastOneOf()) {
        setAutoDetectGreaterThanAtLeastOneOf(other.getAutoDetectGreaterThanAtLeastOneOf());
      }
      if (other.hasStopAfterFirstSolution()) {
        setStopAfterFirstSolution(other.getStopAfterFirstSolution());
      }
      if (other.hasStopAfterPresolve()) {
        setStopAfterPresolve(other.getStopAfterPresolve());
      }
      if (other.hasStopAfterRootPropagation()) {
        setStopAfterRootPropagation(other.getStopAfterRootPropagation());
      }
      if (other.hasUseLns()) {
        setUseLns(other.getUseLns());
      }
      if (other.hasUseLnsOnly()) {
        setUseLnsOnly(other.getUseLnsOnly());
      }
      if (other.hasSolutionPoolSize()) {
        setSolutionPoolSize(other.getSolutionPoolSize());
      }
      if (other.hasUseRinsLns()) {
        setUseRinsLns(other.getUseRinsLns());
      }
      if (other.hasUseFeasibilityPump()) {
        setUseFeasibilityPump(other.getUseFeasibilityPump());
      }
      if (other.hasUseLbRelaxLns()) {
        setUseLbRelaxLns(other.getUseLbRelaxLns());
      }
      if (other.hasFpRounding()) {
        setFpRounding(other.getFpRounding());
      }
      if (other.hasDiversifyLnsParams()) {
        setDiversifyLnsParams(other.getDiversifyLnsParams());
      }
      if (other.hasRandomizeSearch()) {
        setRandomizeSearch(other.getRandomizeSearch());
      }
      if (other.hasSearchRandomVariablePoolSize()) {
        setSearchRandomVariablePoolSize(other.getSearchRandomVariablePoolSize());
      }
      if (other.hasPushAllTasksTowardStart()) {
        setPushAllTasksTowardStart(other.getPushAllTasksTowardStart());
      }
      if (other.hasUseOptionalVariables()) {
        setUseOptionalVariables(other.getUseOptionalVariables());
      }
      if (other.hasUseExactLpReason()) {
        setUseExactLpReason(other.getUseExactLpReason());
      }
      if (other.hasUseCombinedNoOverlap()) {
        setUseCombinedNoOverlap(other.getUseCombinedNoOverlap());
      }
      if (other.hasAtMostOneMaxExpansionSize()) {
        setAtMostOneMaxExpansionSize(other.getAtMostOneMaxExpansionSize());
      }
      if (other.hasCatchSigintSignal()) {
        setCatchSigintSignal(other.getCatchSigintSignal());
      }
      if (other.hasUseImpliedBounds()) {
        setUseImpliedBounds(other.getUseImpliedBounds());
      }
      if (other.hasPolishLpSolution()) {
        setPolishLpSolution(other.getPolishLpSolution());
      }
      if (other.hasLpPrimalTolerance()) {
        setLpPrimalTolerance(other.getLpPrimalTolerance());
      }
      if (other.hasLpDualTolerance()) {
        setLpDualTolerance(other.getLpDualTolerance());
      }
      if (other.hasConvertIntervals()) {
        setConvertIntervals(other.getConvertIntervals());
      }
      if (other.hasSymmetryLevel()) {
        setSymmetryLevel(other.getSymmetryLevel());
      }
      if (other.hasNewLinearPropagation()) {
        setNewLinearPropagation(other.getNewLinearPropagation());
      }
      if (other.hasLinearSplitSize()) {
        setLinearSplitSize(other.getLinearSplitSize());
      }
      if (other.hasLinearizationLevel()) {
        setLinearizationLevel(other.getLinearizationLevel());
      }
      if (other.hasBooleanEncodingLevel()) {
        setBooleanEncodingLevel(other.getBooleanEncodingLevel());
      }
      if (other.hasMaxDomainSizeWhenEncodingEqNeqConstraints()) {
        setMaxDomainSizeWhenEncodingEqNeqConstraints(other.getMaxDomainSizeWhenEncodingEqNeqConstraints());
      }
      if (other.hasMaxNumCuts()) {
        setMaxNumCuts(other.getMaxNumCuts());
      }
      if (other.hasCutLevel()) {
        setCutLevel(other.getCutLevel());
      }
      if (other.hasOnlyAddCutsAtLevelZero()) {
        setOnlyAddCutsAtLevelZero(other.getOnlyAddCutsAtLevelZero());
      }
      if (other.hasAddObjectiveCut()) {
        setAddObjectiveCut(other.getAddObjectiveCut());
      }
      if (other.hasAddCgCuts()) {
        setAddCgCuts(other.getAddCgCuts());
      }
      if (other.hasAddMirCuts()) {
        setAddMirCuts(other.getAddMirCuts());
      }
      if (other.hasAddZeroHalfCuts()) {
        setAddZeroHalfCuts(other.getAddZeroHalfCuts());
      }
      if (other.hasAddCliqueCuts()) {
        setAddCliqueCuts(other.getAddCliqueCuts());
      }
      if (other.hasAddRltCuts()) {
        setAddRltCuts(other.getAddRltCuts());
      }
      if (other.hasMaxAllDiffCutSize()) {
        setMaxAllDiffCutSize(other.getMaxAllDiffCutSize());
      }
      if (other.hasAddLinMaxCuts()) {
        setAddLinMaxCuts(other.getAddLinMaxCuts());
      }
      if (other.hasMaxIntegerRoundingScaling()) {
        setMaxIntegerRoundingScaling(other.getMaxIntegerRoundingScaling());
      }
      if (other.hasAddLpConstraintsLazily()) {
        setAddLpConstraintsLazily(other.getAddLpConstraintsLazily());
      }
      if (other.hasRootLpIterations()) {
        setRootLpIterations(other.getRootLpIterations());
      }
      if (other.hasMinOrthogonalityForLpConstraints()) {
        setMinOrthogonalityForLpConstraints(other.getMinOrthogonalityForLpConstraints());
      }
      if (other.hasMaxCutRoundsAtLevelZero()) {
        setMaxCutRoundsAtLevelZero(other.getMaxCutRoundsAtLevelZero());
      }
      if (other.hasMaxConsecutiveInactiveCount()) {
        setMaxConsecutiveInactiveCount(other.getMaxConsecutiveInactiveCount());
      }
      if (other.hasCutMaxActiveCountValue()) {
        setCutMaxActiveCountValue(other.getCutMaxActiveCountValue());
      }
      if (other.hasCutActiveCountDecay()) {
        setCutActiveCountDecay(other.getCutActiveCountDecay());
      }
      if (other.hasCutCleanupTarget()) {
        setCutCleanupTarget(other.getCutCleanupTarget());
      }
      if (other.hasNewConstraintsBatchSize()) {
        setNewConstraintsBatchSize(other.getNewConstraintsBatchSize());
      }
      if (other.hasExploitIntegerLpSolution()) {
        setExploitIntegerLpSolution(other.getExploitIntegerLpSolution());
      }
      if (other.hasExploitAllLpSolution()) {
        setExploitAllLpSolution(other.getExploitAllLpSolution());
      }
      if (other.hasExploitBestSolution()) {
        setExploitBestSolution(other.getExploitBestSolution());
      }
      if (other.hasExploitRelaxationSolution()) {
        setExploitRelaxationSolution(other.getExploitRelaxationSolution());
      }
      if (other.hasExploitObjective()) {
        setExploitObjective(other.getExploitObjective());
      }
      if (other.hasDetectLinearizedProduct()) {
        setDetectLinearizedProduct(other.getDetectLinearizedProduct());
      }
      if (other.hasMipMaxBound()) {
        setMipMaxBound(other.getMipMaxBound());
      }
      if (other.hasMipVarScaling()) {
        setMipVarScaling(other.getMipVarScaling());
      }
      if (other.hasMipScaleLargeDomain()) {
        setMipScaleLargeDomain(other.getMipScaleLargeDomain());
      }
      if (other.hasMipAutomaticallyScaleVariables()) {
        setMipAutomaticallyScaleVariables(other.getMipAutomaticallyScaleVariables());
      }
      if (other.hasOnlySolveIp()) {
        setOnlySolveIp(other.getOnlySolveIp());
      }
      if (other.hasMipWantedPrecision()) {
        setMipWantedPrecision(other.getMipWantedPrecision());
      }
      if (other.hasMipMaxActivityExponent()) {
        setMipMaxActivityExponent(other.getMipMaxActivityExponent());
      }
      if (other.hasMipCheckPrecision()) {
        setMipCheckPrecision(other.getMipCheckPrecision());
      }
      if (other.hasMipComputeTrueObjectiveBound()) {
        setMipComputeTrueObjectiveBound(other.getMipComputeTrueObjectiveBound());
      }
      if (other.hasMipMaxValidMagnitude()) {
        setMipMaxValidMagnitude(other.getMipMaxValidMagnitude());
      }
      if (other.hasMipTreatHighMagnitudeBoundsAsInfinity()) {
        setMipTreatHighMagnitudeBoundsAsInfinity(other.getMipTreatHighMagnitudeBoundsAsInfinity());
      }
      if (other.hasMipDropTolerance()) {
        setMipDropTolerance(other.getMipDropTolerance());
      }
      if (other.hasMipPresolveLevel()) {
        setMipPresolveLevel(other.getMipPresolveLevel());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {
              int tmpRaw = input.readEnum();
              com.google.ortools.sat.SatParameters.VariableOrder tmpValue =
                  com.google.ortools.sat.SatParameters.VariableOrder.forNumber(tmpRaw);
              if (tmpValue == null) {
                mergeUnknownVarintField(1, tmpRaw);
              } else {
                preferredVariableOrder_ = tmpRaw;
                bitField0_ |= 0x00000002;
              }
              break;
            } // case 8
            case 16: {
              int tmpRaw = input.readEnum();
              com.google.ortools.sat.SatParameters.Polarity tmpValue =
                  com.google.ortools.sat.SatParameters.Polarity.forNumber(tmpRaw);
              if (tmpValue == null) {
                mergeUnknownVarintField(2, tmpRaw);
              } else {
                initialPolarity_ = tmpRaw;
                bitField0_ |= 0x00000004;
              }
              break;
            } // case 16
            case 32: {
              int tmpRaw = input.readEnum();
              com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm tmpValue =
                  com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm.forNumber(tmpRaw);
              if (tmpValue == null) {
                mergeUnknownVarintField(4, tmpRaw);
              } else {
                minimizationAlgorithm_ = tmpRaw;
                bitField0_ |= 0x00000400;
              }
              break;
            } // case 32
            case 88: {
              clauseCleanupPeriod_ = input.readInt32();
              bitField0_ |= 0x00002000;
              break;
            } // case 88
            case 104: {
              clauseCleanupTarget_ = input.readInt32();
              bitField0_ |= 0x00004000;
              break;
            } // case 104
            case 121: {
              variableActivityDecay_ = input.readDouble();
              bitField0_ |= 0x00200000;
              break;
            } // case 121
            case 129: {
              maxVariableActivityValue_ = input.readDouble();
              bitField0_ |= 0x00400000;
              break;
            } // case 129
            case 137: {
              clauseActivityDecay_ = input.readDouble();
              bitField0_ |= 0x04000000;
              break;
            } // case 137
            case 145: {
              maxClauseActivityValue_ = input.readDouble();
              bitField0_ |= 0x08000000;
              break;
            } // case 145
            case 177: {
              glucoseMaxDecay_ = input.readDouble();
              bitField0_ |= 0x00800000;
              break;
            } // case 177
            case 185: {
              glucoseDecayIncrement_ = input.readDouble();
              bitField0_ |= 0x01000000;
              break;
            } // case 185
            case 192: {
              glucoseDecayIncrementPeriod_ = input.readInt32();
              bitField0_ |= 0x02000000;
              break;
            } // case 192
            case 240: {
              restartPeriod_ = input.readInt32();
              bitField0_ |= 0x40000000;
              break;
            } // case 240
            case 248: {
              randomSeed_ = input.readInt32();
              bitField1_ |= 0x00004000;
              break;
            } // case 248
            case 257: {
              randomBranchesRatio_ = input.readDouble();
              bitField0_ |= 0x00000040;
              break;
            } // case 257
            case 272: {
              int tmpRaw = input.readEnum();
              com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm tmpValue =
                  com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm.forNumber(tmpRaw);
              if (tmpValue == null) {
                mergeUnknownVarintField(34, tmpRaw);
              } else {
                binaryMinimizationAlgorithm_ = tmpRaw;
                bitField0_ |= 0x00000800;
              }
              break;
            } // case 272
            case 280: {
              useOptimizationHints_ = input.readBool();
              bitField3_ |= 0x00000800;
              break;
            } // case 280
            case 289: {
              maxTimeInSeconds_ = input.readDouble();
              bitField1_ |= 0x00000080;
              break;
            } // case 289
            case 296: {
              maxNumberOfConflicts_ = input.readInt64();
              bitField1_ |= 0x00000400;
              break;
            } // case 296
            case 320: {
              maxMemoryInMb_ = input.readInt64();
              bitField1_ |= 0x00000800;
              break;
            } // case 320
            case 328: {
              logSearchProgress_ = input.readBool();
              bitField1_ |= 0x00040000;
              break;
            } // case 328
            case 344: {
              usePbResolution_ = input.readBool();
              bitField1_ |= 0x00800000;
              break;
            } // case 344
            case 352: {
              usePhaseSaving_ = input.readBool();
              bitField0_ |= 0x00000008;
              break;
            } // case 352
            case 361: {
              randomPolarityRatio_ = input.readDouble();
              bitField0_ |= 0x00000020;
              break;
            } // case 361
            case 368: {
              pbCleanupIncrement_ = input.readInt32();
              bitField0_ |= 0x00080000;
              break;
            } // case 368
            case 377: {
              pbCleanupRatio_ = input.readDouble();
              bitField0_ |= 0x00100000;
              break;
            } // case 377
            case 384: {
              minimizeReductionDuringPbResolution_ = input.readBool();
              bitField1_ |= 0x01000000;
              break;
            } // case 384
            case 392: {
              countAssumptionLevelsInLbd_ = input.readBool();
              bitField1_ |= 0x02000000;
              break;
            } // case 392
            case 400: {
              coreMinimizationLevel_ = input.readInt32();
              bitField3_ |= 0x00001000;
              break;
            } // case 400
            case 408: {
              int tmpRaw = input.readEnum();
              com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder tmpValue =
                  com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder.forNumber(tmpRaw);
              if (tmpValue == null) {
                mergeUnknownVarintField(51, tmpRaw);
              } else {
                maxSatAssumptionOrder_ = tmpRaw;
                bitField3_ |= 0x00008000;
              }
              break;
            } // case 408
            case 416: {
              maxSatReverseAssumptionOrder_ = input.readBool();
              bitField3_ |= 0x00010000;
              break;
            } // case 416
            case 424: {
              int tmpRaw = input.readEnum();
              com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm tmpValue =
                  com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm.forNumber(tmpRaw);
              if (tmpValue == null) {
                mergeUnknownVarintField(53, tmpRaw);
              } else {
                maxSatStratification_ = tmpRaw;
                bitField3_ |= 0x00020000;
              }
              break;
            } // case 424
            case 432: {
              presolveBveThreshold_ = input.readInt32();
              bitField1_ |= 0x04000000;
              break;
            } // case 432
            case 440: {
              presolveBveClauseWeight_ = input.readInt32();
              bitField1_ |= 0x08000000;
              break;
            } // case 440
            case 448: {
              subsumptionDuringConflictAnalysis_ = input.readBool();
              bitField0_ |= 0x00001000;
              break;
            } // case 448
            case 457: {
              presolveProbingDeterministicTimeLimit_ = input.readDouble();
              bitField1_ |= 0x20000000;
              break;
            } // case 457
            case 464: {
              int tmpRaw = input.readEnum();
              com.google.ortools.sat.SatParameters.ClauseProtection tmpValue =
                  com.google.ortools.sat.SatParameters.ClauseProtection.forNumber(tmpRaw);
              if (tmpValue == null) {
                mergeUnknownVarintField(58, tmpRaw);
              } else {
                clauseCleanupProtection_ = tmpRaw;
                bitField0_ |= 0x00010000;
              }
              break;
            } // case 464
            case 472: {
              clauseCleanupLbdBound_ = input.readInt32();
              bitField0_ |= 0x00020000;
              break;
            } // case 472
            case 480: {
              int tmpRaw = input.readEnum();
              com.google.ortools.sat.SatParameters.ClauseOrdering tmpValue =
                  com.google.ortools.sat.SatParameters.ClauseOrdering.forNumber(tmpRaw);
              if (tmpValue == null) {
                mergeUnknownVarintField(60, tmpRaw);
              } else {
                clauseCleanupOrdering_ = tmpRaw;
                bitField0_ |= 0x00040000;
              }
              break;
            } // case 480
            case 488: {
              int tmpRaw = input.readEnum();
              com.google.ortools.sat.SatParameters.RestartAlgorithm tmpValue =
                  com.google.ortools.sat.SatParameters.RestartAlgorithm.forNumber(tmpRaw);
              if (tmpValue == null) {
                mergeUnknownVarintField(61, tmpRaw);
              } else {
                ensureRestartAlgorithmsIsMutable();
                restartAlgorithms_.add(tmpRaw);
              }
              break;
            } // case 488
            case 490: {
              int length = input.readRawVarint32();
              int oldLimit = input.pushLimit(length);
              while(input.getBytesUntilLimit() > 0) {
                int tmpRaw = input.readEnum();
                com.google.ortools.sat.SatParameters.RestartAlgorithm tmpValue =
                    com.google.ortools.sat.SatParameters.RestartAlgorithm.forNumber(tmpRaw);
                if (tmpValue == null) {
                  mergeUnknownVarintField(61, tmpRaw);
                } else {
                  ensureRestartAlgorithmsIsMutable();
                  restartAlgorithms_.add(tmpRaw);
                }
              }
              input.popLimit(oldLimit);
              break;
            } // case 490
            case 496: {
              restartRunningWindowSize_ = input.readInt32();
              bitField0_ |= 0x80000000;
              break;
            } // case 496
            case 505: {
              restartDlAverageRatio_ = input.readDouble();
              bitField1_ |= 0x00000001;
              break;
            } // case 505
            case 512: {
              useBlockingRestart_ = input.readBool();
              bitField1_ |= 0x00000004;
              break;
            } // case 512
            case 520: {
              blockingRestartWindowSize_ = input.readInt32();
              bitField1_ |= 0x00000008;
              break;
            } // case 520
            case 529: {
              blockingRestartMultiplier_ = input.readDouble();
              bitField1_ |= 0x00000010;
              break;
            } // case 529
            case 537: {
              maxDeterministicTime_ = input.readDouble();
              bitField1_ |= 0x00000100;
              break;
            } // case 537
            case 544: {
              numConflictsBeforeStrategyChanges_ = input.readInt32();
              bitField1_ |= 0x00000020;
              break;
            } // case 544
            case 553: {
              strategyChangeIncreaseRatio_ = input.readDouble();
              bitField1_ |= 0x00000040;
              break;
            } // case 553
            case 562: {
              defaultRestartAlgorithms_ = input.readBytes();
              bitField0_ |= 0x20000000;
              break;
            } // case 562
            case 569: {
              restartLbdAverageRatio_ = input.readDouble();
              bitField1_ |= 0x00000002;
              break;
            } // case 569
            case 576: {
              presolveUseBva_ = input.readBool();
              bitField1_ |= 0x80000000;
              break;
            } // case 576
            case 584: {
              presolveBvaThreshold_ = input.readInt32();
              bitField2_ |= 0x00000001;
              break;
            } // case 584
            case 592: {
              usePrecedencesInDisjunctiveConstraint_ = input.readBool();
              bitField3_ |= 0x00080000;
              break;
            } // case 592
            case 600: {
              useErwaHeuristic_ = input.readBool();
              bitField0_ |= 0x00000080;
              break;
            } // case 600
            case 609: {
              initialVariablesActivity_ = input.readDouble();
              bitField0_ |= 0x00000100;
              break;
            } // case 609
            case 616: {
              alsoBumpVariablesInConflictReasons_ = input.readBool();
              bitField0_ |= 0x00000200;
              break;
            } // case 616
            case 624: {
              useOverloadCheckerInCumulative_ = input.readBool();
              bitField3_ |= 0x01000000;
              break;
            } // case 624
            case 632: {
              useTimetableEdgeFindingInCumulative_ = input.readBool();
              bitField3_ |= 0x04000000;
              break;
            } // case 632
            case 640: {
              useDisjunctiveConstraintInCumulative_ = input.readBool();
              bitField3_ |= 0x40000000;
              break;
            } // case 640
            case 656: {
              int tmpRaw = input.readEnum();
              com.google.ortools.sat.SatParameters.SearchBranching tmpValue =
                  com.google.ortools.sat.SatParameters.SearchBranching.forNumber(tmpRaw);
              if (tmpValue == null) {
                mergeUnknownVarintField(82, tmpRaw);
              } else {
                searchBranching_ = tmpRaw;
                bitField4_ |= 0x00000010;
              }
              break;
            } // case 656
            case 664: {
              optimizeWithCore_ = input.readBool();
              bitField4_ |= 0x00040000;
              break;
            } // case 664
            case 672: {
              findMultipleCores_ = input.readBool();
              bitField3_ |= 0x00002000;
              break;
            } // case 672
            case 680: {
              optimizeWithMaxHs_ = input.readBool();
              bitField4_ |= 0x00400000;
              break;
            } // case 680
            case 688: {
              cpModelPresolve_ = input.readBool();
              bitField2_ |= 0x00000004;
              break;
            } // case 688
            case 696: {
              enumerateAllSolutions_ = input.readBool();
              bitField5_ |= 0x00001000;
              break;
            } // case 696
            case 704: {
              presolveBlockedClause_ = input.readBool();
              bitField1_ |= 0x40000000;
              break;
            } // case 704
            case 712: {
              coverOptimization_ = input.readBool();
              bitField3_ |= 0x00004000;
              break;
            } // case 712
            case 720: {
              linearizationLevel_ = input.readInt32();
              bitField6_ |= 0x00002000;
              break;
            } // case 720
            case 728: {
              maxNumCuts_ = input.readInt32();
              bitField6_ |= 0x00010000;
              break;
            } // case 728
            case 736: {
              onlyAddCutsAtLevelZero_ = input.readBool();
              bitField6_ |= 0x00040000;
              break;
            } // case 736
            case 744: {
              cpModelUseSatPresolve_ = input.readBool();
              bitField2_ |= 0x00000010;
              break;
            } // case 744
            case 752: {
              exploitIntegerLpSolution_ = input.readBool();
              bitField7_ |= 0x00000020;
              break;
            } // case 752
            case 760: {
              autoDetectGreaterThanAtLeastOneOf_ = input.readBool();
              bitField5_ |= 0x00020000;
              break;
            } // case 760
            case 784: {
              stopAfterFirstSolution_ = input.readBool();
              bitField5_ |= 0x00040000;
              break;
            } // case 784
            case 792: {
              binarySearchNumConflicts_ = input.readInt32();
              bitField4_ |= 0x00200000;
              break;
            } // case 792
            case 800: {
              numSearchWorkers_ = input.readInt32();
              bitField2_ |= 0x08000000;
              break;
            } // case 800
            case 808: {
              useLnsOnly_ = input.readBool();
              bitField5_ |= 0x00400000;
              break;
            } // case 808
            case 824: {
              randomizeSearch_ = input.readBool();
              bitField5_ |= 0x20000000;
              break;
            } // case 824
            case 832: {
              searchRandomVariablePoolSize_ = input.readInt64();
              bitField5_ |= 0x40000000;
              break;
            } // case 832
            case 848: {
              instantiateAllVariables_ = input.readBool();
              bitField5_ |= 0x00010000;
              break;
            } // case 848
            case 856: {
              booleanEncodingLevel_ = input.readInt32();
              bitField6_ |= 0x00004000;
              break;
            } // case 856
            case 864: {
              useOptionalVariables_ = input.readBool();
              bitField6_ |= 0x00000001;
              break;
            } // case 864
            case 872: {
              useExactLpReason_ = input.readBool();
              bitField6_ |= 0x00000002;
              break;
            } // case 872
            case 880: {
              cpModelProbingLevel_ = input.readInt32();
              bitField2_ |= 0x00000008;
              break;
            } // case 880
            case 896: {
              addLpConstraintsLazily_ = input.readBool();
              bitField6_ |= 0x10000000;
              break;
            } // case 896
            case 904: {
              shareObjectiveBounds_ = input.readBool();
              bitField3_ |= 0x00000010;
              break;
            } // case 904
            case 912: {
              shareLevelZeroBounds_ = input.readBool();
              bitField3_ |= 0x00000020;
              break;
            } // case 912
            case 921: {
              minOrthogonalityForLpConstraints_ = input.readDouble();
              bitField6_ |= 0x40000000;
              break;
            } // case 921
            case 928: {
              exploitAllLpSolution_ = input.readBool();
              bitField7_ |= 0x00000040;
              break;
            } // case 928
            case 936: {
              addCgCuts_ = input.readBool();
              bitField6_ |= 0x00100000;
              break;
            } // case 936
            case 952: {
              maxIntegerRoundingScaling_ = input.readInt32();
              bitField6_ |= 0x08000000;
              break;
            } // case 952
            case 960: {
              addMirCuts_ = input.readBool();
              bitField6_ |= 0x00200000;
              break;
            } // case 960
            case 968: {
              maxConsecutiveInactiveCount_ = input.readInt32();
              bitField7_ |= 0x00000001;
              break;
            } // case 968
            case 976: {
              newConstraintsBatchSize_ = input.readInt32();
              bitField7_ |= 0x00000010;
              break;
            } // case 976
            case 984: {
              pseudoCostReliabilityThreshold_ = input.readInt64();
              bitField4_ |= 0x00020000;
              break;
            } // case 984
            case 993: {
              mipMaxBound_ = input.readDouble();
              bitField7_ |= 0x00000800;
              break;
            } // case 993
            case 1001: {
              mipVarScaling_ = input.readDouble();
              bitField7_ |= 0x00001000;
              break;
            } // case 1001
            case 1009: {
              mipWantedPrecision_ = input.readDouble();
              bitField7_ |= 0x00010000;
              break;
            } // case 1009
            case 1016: {
              mipMaxActivityExponent_ = input.readInt32();
              bitField7_ |= 0x00020000;
              break;
            } // case 1016
            case 1025: {
              mipCheckPrecision_ = input.readDouble();
              bitField7_ |= 0x00040000;
              break;
            } // case 1025
            case 1032: {
              useRinsLns_ = input.readBool();
              bitField5_ |= 0x01000000;
              break;
            } // case 1032
            case 1040: {
              exploitBestSolution_ = input.readBool();
              bitField7_ |= 0x00000080;
              break;
            } // case 1040
            case 1048: {
              exploitObjective_ = input.readBool();
              bitField7_ |= 0x00000200;
              break;
            } // case 1048
            case 1056: {
              fillTightenedDomainsInResponse_ = input.readBool();
              bitField5_ |= 0x00004000;
              break;
            } // case 1056
            case 1064: {
              useCombinedNoOverlap_ = input.readBool();
              bitField6_ |= 0x00000004;
              break;
            } // case 1064
            case 1072: {
              interleaveBatchSize_ = input.readInt32();
              bitField3_ |= 0x00000008;
              break;
            } // case 1072
            case 1080: {
              catchSigintSignal_ = input.readBool();
              bitField6_ |= 0x00000010;
              break;
            } // case 1080
            case 1088: {
              interleaveSearch_ = input.readBool();
              bitField3_ |= 0x00000004;
              break;
            } // case 1088
            case 1096: {
              diversifyLnsParams_ = input.readBool();
              bitField5_ |= 0x10000000;
              break;
            } // case 1096
            case 1104: {
              maxPresolveIterations_ = input.readInt32();
              bitField2_ |= 0x00000002;
              break;
            } // case 1104
            case 1152: {
              useImpliedBounds_ = input.readBool();
              bitField6_ |= 0x00000020;
              break;
            } // case 1152
            case 1161: {
              mergeNoOverlapWorkLimit_ = input.readDouble();
              bitField2_ |= 0x00004000;
              break;
            } // case 1161
            case 1169: {
              mergeAtMostOneWorkLimit_ = input.readDouble();
              bitField2_ |= 0x00008000;
              break;
            } // case 1169
            case 1176: {
              presolveSubstitutionLevel_ = input.readInt32();
              bitField2_ |= 0x00010000;
              break;
            } // case 1176
            case 1184: {
              maxAllDiffCutSize_ = input.readInt32();
              bitField6_ |= 0x02000000;
              break;
            } // case 1184
            case 1192: {
              stopAfterPresolve_ = input.readBool();
              bitField5_ |= 0x00080000;
              break;
            } // case 1192
            case 1208: {
              debugMaxNumPresolveOperations_ = input.readInt32();
              bitField3_ |= 0x00000200;
              break;
            } // case 1208
            case 1216: {
              addLinMaxCuts_ = input.readBool();
              bitField6_ |= 0x04000000;
              break;
            } // case 1216
            case 1224: {
              hintConflictLimit_ = input.readInt32();
              bitField4_ |= 0x00000020;
              break;
            } // case 1224
            case 1232: {
              maxCutRoundsAtLevelZero_ = input.readInt32();
              bitField6_ |= 0x80000000;
              break;
            } // case 1232
            case 1241: {
              cutMaxActiveCountValue_ = input.readDouble();
              bitField7_ |= 0x00000002;
              break;
            } // case 1241
            case 1249: {
              cutActiveCountDecay_ = input.readDouble();
              bitField7_ |= 0x00000004;
              break;
            } // case 1249
            case 1256: {
              cutCleanupTarget_ = input.readInt32();
              bitField7_ |= 0x00000008;
              break;
            } // case 1256
            case 1273: {
              absoluteGapLimit_ = input.readDouble();
              bitField1_ |= 0x00001000;
              break;
            } // case 1273
            case 1281: {
              relativeGapLimit_ = input.readDouble();
              bitField1_ |= 0x00002000;
              break;
            } // case 1281
            case 1288: {
              exploitRelaxationSolution_ = input.readBool();
              bitField7_ |= 0x00000100;
              break;
            } // case 1288
            case 1296: {
              debugPostsolveWithFullSolver_ = input.readBool();
              bitField3_ |= 0x00000100;
              break;
            } // case 1296
            case 1304: {
              useSatInprocessing_ = input.readBool();
              bitField2_ |= 0x00400000;
              break;
            } // case 1304
            case 1312: {
              useFeasibilityPump_ = input.readBool();
              bitField5_ |= 0x02000000;
              break;
            } // case 1312
            case 1320: {
              int tmpRaw = input.readEnum();
              com.google.ortools.sat.SatParameters.FPRoundingMethod tmpValue =
                  com.google.ortools.sat.SatParameters.FPRoundingMethod.forNumber(tmpRaw);
              if (tmpValue == null) {
                mergeUnknownVarintField(165, tmpRaw);
              } else {
                fpRounding_ = tmpRaw;
                bitField5_ |= 0x08000000;
              }
              break;
            } // case 1320
            case 1328: {
              mipAutomaticallyScaleVariables_ = input.readBool();
              bitField7_ |= 0x00004000;
              break;
            } // case 1328
            case 1336: {
              repairHint_ = input.readBool();
              bitField4_ |= 0x00000040;
              break;
            } // case 1336
            case 1344: {
              polarityRephaseIncrement_ = input.readInt32();
              bitField0_ |= 0x00000010;
              break;
            } // case 1344
            case 1352: {
              addZeroHalfCuts_ = input.readBool();
              bitField6_ |= 0x00400000;
              break;
            } // case 1352
            case 1360: {
              expandAlldiffConstraints_ = input.readBool();
              bitField2_ |= 0x00000080;
              break;
            } // case 1360
            case 1370: {
              name_ = input.readBytes();
              bitField0_ |= 0x00000001;
              break;
            } // case 1370
            case 1376: {
              addCliqueCuts_ = input.readBool();
              bitField6_ |= 0x00800000;
              break;
            } // case 1376
            case 1384: {
              keepAllFeasibleSolutionsInPresolve_ = input.readBool();
              bitField5_ |= 0x00002000;
              break;
            } // case 1384
            case 1392: {
              presolveExtractIntegerEnforcement_ = input.readBool();
              bitField2_ |= 0x00020000;
              break;
            } // case 1392
            case 1400: {
              polishLpSolution_ = input.readBool();
              bitField6_ |= 0x00000040;
              break;
            } // case 1400
            case 1408: {
              useProbingSearch_ = input.readBool();
              bitField4_ |= 0x00000100;
              break;
            } // case 1408
            case 1416: {
              convertIntervals_ = input.readBool();
              bitField6_ |= 0x00000200;
              break;
            } // case 1416
            case 1424: {
              permuteVariableRandomly_ = input.readBool();
              bitField1_ |= 0x00008000;
              break;
            } // case 1424
            case 1432: {
              permutePresolveConstraintOrder_ = input.readBool();
              bitField1_ |= 0x00010000;
              break;
            } // case 1432
            case 1440: {
              useAbslRandom_ = input.readBool();
              bitField1_ |= 0x00020000;
              break;
            } // case 1440
            case 1448: {
              disableConstraintExpansion_ = input.readBool();
              bitField2_ |= 0x00001000;
              break;
            } // case 1448
            case 1456: {
              expandReservoirConstraints_ = input.readBool();
              bitField2_ |= 0x00000100;
              break;
            } // case 1456
            case 1464: {
              symmetryLevel_ = input.readInt32();
              bitField6_ |= 0x00000400;
              break;
            } // case 1464
            case 1482: {
              logPrefix_ = input.readBytes();
              bitField1_ |= 0x00100000;
              break;
            } // case 1482
            case 1488: {
              logToStdout_ = input.readBool();
              bitField1_ |= 0x00200000;
              break;
            } // case 1488
            case 1496: {
              logToResponse_ = input.readBool();
              bitField1_ |= 0x00400000;
              break;
            } // case 1496
            case 1504: {
              optimizeWithLbTreeSearch_ = input.readBool();
              bitField4_ |= 0x00080000;
              break;
            } // case 1504
            case 1512: {
              logSubsolverStatistics_ = input.readBool();
              bitField1_ |= 0x00080000;
              break;
            } // case 1512
            case 1521: {
              clauseCleanupRatio_ = input.readDouble();
              bitField0_ |= 0x00008000;
              break;
            } // case 1521
            case 1528: {
              maxDomainSizeWhenEncodingEqNeqConstraints_ = input.readInt32();
              bitField6_ |= 0x00008000;
              break;
            } // case 1528
            case 1536: {
              fixVariablesToTheirHintedValue_ = input.readBool();
              bitField4_ |= 0x00000080;
              break;
            } // case 1536
            case 1544: {
              solutionPoolSize_ = input.readInt32();
              bitField5_ |= 0x00800000;
              break;
            } // case 1544
            case 1552: {
              fillAdditionalSolutionsInResponse_ = input.readBool();
              bitField5_ |= 0x00008000;
              break;
            } // case 1552
            case 1560: {
              debugCrashOnBadHint_ = input.readBool();
              bitField3_ |= 0x00000400;
              break;
            } // case 1560
            case 1568: {
              cutLevel_ = input.readInt32();
              bitField6_ |= 0x00020000;
              break;
            } // case 1568
            case 1576: {
              addObjectiveCut_ = input.readBool();
              bitField6_ |= 0x00080000;
              break;
            } // case 1576
            case 1584: {
              mipComputeTrueObjectiveBound_ = input.readBool();
              bitField7_ |= 0x00080000;
              break;
            } // case 1584
            case 1593: {
              mipMaxValidMagnitude_ = input.readDouble();
              bitField7_ |= 0x00100000;
              break;
            } // case 1593
            case 1600: {
              useTimetablingInNoOverlap2D_ = input.readBool();
              bitField3_ |= 0x80000000;
              break;
            } // case 1600
            case 1608: {
              presolveInclusionWorkLimit_ = input.readInt64();
              bitField2_ |= 0x00040000;
              break;
            } // case 1608
            case 1616: {
              ignoreNames_ = input.readBool();
              bitField2_ |= 0x00080000;
              break;
            } // case 1616
            case 1624: {
              shareBinaryClauses_ = input.readBool();
              bitField3_ |= 0x00000040;
              break;
            } // case 1624
            case 1632: {
              useShavingInProbingSearch_ = input.readBool();
              bitField4_ |= 0x00000800;
              break;
            } // case 1632
            case 1641: {
              shavingSearchDeterministicTime_ = input.readDouble();
              bitField4_ |= 0x00001000;
              break;
            } // case 1641
            case 1648: {
              numWorkers_ = input.readInt32();
              bitField2_ |= 0x04000000;
              break;
            } // case 1648
            case 1658: {
              com.google.protobuf.ByteString bs = input.readBytes();
              ensureSubsolversIsMutable();
              subsolvers_.add(bs);
              break;
            } // case 1658
            case 1674: {
              com.google.protobuf.ByteString bs = input.readBytes();
              ensureIgnoreSubsolversIsMutable();
              ignoreSubsolvers_.add(bs);
              break;
            } // case 1674
            case 1682: {
              com.google.ortools.sat.SatParameters m =
                  input.readMessage(
                      com.google.ortools.sat.SatParameters.parser(),
                      extensionRegistry);
              if (subsolverParamsBuilder_ == null) {
                ensureSubsolverParamsIsMutable();
                subsolverParams_.add(m);
              } else {
                subsolverParamsBuilder_.addMessage(m);
              }
              break;
            } // case 1682
            case 1704: {
              useEnergeticReasoningInNoOverlap2D_ = input.readBool();
              bitField4_ |= 0x00000001;
              break;
            } // case 1704
            case 1712: {
              useDualSchedulingHeuristics_ = input.readBool();
              bitField4_ |= 0x00000008;
              break;
            } // case 1712
            case 1720: {
              useHardPrecedencesInCumulative_ = input.readBool();
              bitField3_ |= 0x10000000;
              break;
            } // case 1720
            case 1728: {
              detectTableWithCost_ = input.readBool();
              bitField2_ |= 0x00000020;
              break;
            } // case 1728
            case 1736: {
              tableCompressionLevel_ = input.readInt32();
              bitField2_ |= 0x00000040;
              break;
            } // case 1736
            case 1754: {
              com.google.protobuf.ByteString bs = input.readBytes();
              ensureExtraSubsolversIsMutable();
              extraSubsolvers_.add(bs);
              break;
            } // case 1754
            case 1760: {
              exploitAllPrecedences_ = input.readBool();
              bitField3_ |= 0x20000000;
              break;
            } // case 1760
            case 1769: {
              propagationLoopDetectionFactor_ = input.readDouble();
              bitField3_ |= 0x00040000;
              break;
            } // case 1769
            case 1776: {
              onlySolveIp_ = input.readBool();
              bitField7_ |= 0x00008000;
              break;
            } // case 1776
            case 1784: {
              encodeComplexLinearConstraintWithInteger_ = input.readBool();
              bitField2_ |= 0x00002000;
              break;
            } // case 1784
            case 1792: {
              newLinearPropagation_ = input.readBool();
              bitField6_ |= 0x00000800;
              break;
            } // case 1792
            case 1800: {
              mipScaleLargeDomain_ = input.readBool();
              bitField7_ |= 0x00002000;
              break;
            } // case 1800
            case 1809: {
              probingDeterministicTimeLimit_ = input.readDouble();
              bitField1_ |= 0x10000000;
              break;
            } // case 1809
            case 1816: {
              rootLpIterations_ = input.readInt32();
              bitField6_ |= 0x20000000;
              break;
            } // case 1816
            case 1824: {
              useObjectiveLbSearch_ = input.readBool();
              bitField4_ |= 0x00004000;
              break;
            } // case 1824
            case 1832: {
              maxSizeToCreatePrecedenceLiteralsInDisjunctive_ = input.readInt32();
              bitField3_ |= 0x00100000;
              break;
            } // case 1832
            case 1840: {
              useStrongPropagationInDisjunctive_ = input.readBool();
              bitField3_ |= 0x00200000;
              break;
            } // case 1840
            case 1857: {
              mipDropTolerance_ = input.readDouble();
              bitField7_ |= 0x00400000;
              break;
            } // case 1857
            case 1864: {
              inferAllDiffs_ = input.readBool();
              bitField2_ |= 0x00100000;
              break;
            } // case 1864
            case 1872: {
              findBigLinearOverlap_ = input.readBool();
              bitField2_ |= 0x00200000;
              break;
            } // case 1872
            case 1880: {
              sharedTreeNumWorkers_ = input.readInt32();
              bitField5_ |= 0x00000010;
              break;
            } // case 1880
            case 1888: {
              useSharedTreeSearch_ = input.readBool();
              bitField5_ |= 0x00000020;
              break;
            } // case 1888
            case 1897: {
              sharedTreeWorkerObjectiveSplitProbability_ = input.readDouble();
              bitField5_ |= 0x00000040;
              break;
            } // case 1897
            case 1904: {
              sharedTreeMaxNodesPerWorker_ = input.readInt32();
              bitField5_ |= 0x00000400;
              break;
            } // case 1904
            case 1912: {
              int tmpRaw = input.readEnum();
              com.google.ortools.sat.SatParameters.SharedTreeSplitStrategy tmpValue =
                  com.google.ortools.sat.SatParameters.SharedTreeSplitStrategy.forNumber(tmpRaw);
              if (tmpValue == null) {
                mergeUnknownVarintField(239, tmpRaw);
              } else {
                sharedTreeSplitStrategy_ = tmpRaw;
                bitField5_ |= 0x00000800;
              }
              break;
            } // case 1912
            case 1920: {
              useLsOnly_ = input.readBool();
              bitField4_ |= 0x01000000;
              break;
            } // case 1920
            case 1937: {
              feasibilityJumpDecay_ = input.readDouble();
              bitField4_ |= 0x02000000;
              break;
            } // case 1937
            case 1952: {
              numViolationLs_ = input.readInt32();
              bitField5_ |= 0x00000002;
              break;
            } // case 1952
            case 1977: {
              feasibilityJumpVarRandomizationProbability_ = input.readDouble();
              bitField4_ |= 0x20000000;
              break;
            } // case 1977
            case 1985: {
              feasibilityJumpVarPerburbationRangeRatio_ = input.readDouble();
              bitField4_ |= 0x40000000;
              break;
            } // case 1985
            case 1992: {
              violationLsPerturbationPeriod_ = input.readInt32();
              bitField5_ |= 0x00000004;
              break;
            } // case 1992
            case 2000: {
              feasibilityJumpEnableRestarts_ = input.readBool();
              bitField4_ |= 0x80000000;
              break;
            } // case 2000
            case 2016: {
              stopAfterRootPropagation_ = input.readBool();
              bitField5_ |= 0x00100000;
              break;
            } // case 2016
            case 2024: {
              useObjectiveShavingSearch_ = input.readBool();
              bitField4_ |= 0x00008000;
              break;
            } // case 2024
            case 2040: {
              useLbRelaxLns_ = input.readBool();
              bitField5_ |= 0x04000000;
              break;
            } // case 2040
            case 2048: {
              linearSplitSize_ = input.readInt32();
              bitField6_ |= 0x00001000;
              break;
            } // case 2048
            case 2056: {
              feasibilityJumpLinearizationLevel_ = input.readInt32();
              bitField4_ |= 0x04000000;
              break;
            } // case 2056
            case 2064: {
              feasibilityJumpRestartFactor_ = input.readInt32();
              bitField4_ |= 0x08000000;
              break;
            } // case 2064
            case 2073: {
              violationLsCompoundMoveProbability_ = input.readDouble();
              bitField5_ |= 0x00000008;
              break;
            } // case 2073
            case 2080: {
              maxNumIntervalsForTimetableEdgeFinding_ = input.readInt32();
              bitField3_ |= 0x08000000;
              break;
            } // case 2080
            case 2088: {
              mipPresolveLevel_ = input.readInt32();
              bitField7_ |= 0x00800000;
              break;
            } // case 2088
            case 2096: {
              pushAllTasksTowardStart_ = input.readBool();
              bitField5_ |= 0x80000000;
              break;
            } // case 2096
            case 2104: {
              useDynamicPrecedenceInDisjunctive_ = input.readBool();
              bitField3_ |= 0x00400000;
              break;
            } // case 2104
            case 2112: {
              feasibilityJumpMaxExpandedConstraintSize_ = input.readInt32();
              bitField5_ |= 0x00000001;
              break;
            } // case 2112
            case 2120: {
              useFeasibilityJump_ = input.readBool();
              bitField4_ |= 0x00800000;
              break;
            } // case 2120
            case 2129: {
              lpPrimalTolerance_ = input.readDouble();
              bitField6_ |= 0x00000080;
              break;
            } // case 2129
            case 2137: {
              lpDualTolerance_ = input.readDouble();
              bitField6_ |= 0x00000100;
              break;
            } // case 2137
            case 2144: {
              useDynamicPrecedenceInCumulative_ = input.readBool();
              bitField3_ |= 0x00800000;
              break;
            } // case 2144
            case 2152: {
              useExtendedProbing_ = input.readBool();
              bitField4_ |= 0x00000200;
              break;
            } // case 2152
            case 2160: {
              atMostOneMaxExpansionSize_ = input.readInt32();
              bitField6_ |= 0x00000008;
              break;
            } // case 2160
            case 2168: {
              useAreaEnergeticReasoningInNoOverlap2D_ = input.readBool();
              bitField4_ |= 0x00000002;
              break;
            } // case 2168
            case 2176: {
              probingNumCombinationsLimit_ = input.readInt32();
              bitField4_ |= 0x00000400;
              break;
            } // case 2176
            case 2185: {
              inprocessingDtimeRatio_ = input.readDouble();
              bitField2_ |= 0x00800000;
              break;
            } // case 2185
            case 2193: {
              inprocessingProbingDtime_ = input.readDouble();
              bitField2_ |= 0x01000000;
              break;
            } // case 2193
            case 2201: {
              inprocessingMinimizationDtime_ = input.readDouble();
              bitField2_ |= 0x02000000;
              break;
            } // case 2201
            case 2208: {
              maxPairsPairwiseReasoningInNoOverlap2D_ = input.readInt32();
              bitField4_ |= 0x00000004;
              break;
            } // case 2208
            case 2216: {
              detectLinearizedProduct_ = input.readBool();
              bitField7_ |= 0x00000400;
              break;
            } // case 2216
            case 2224: {
              mipTreatHighMagnitudeBoundsAsInfinity_ = input.readBool();
              bitField7_ |= 0x00200000;
              break;
            } // case 2224
            case 2232: {
              addRltCuts_ = input.readBool();
              bitField6_ |= 0x01000000;
              break;
            } // case 2232
            case 2240: {
              maxLinMaxSizeForExpansion_ = input.readInt32();
              bitField2_ |= 0x00000800;
              break;
            } // case 2240
            case 2249: {
              sharedTreeOpenLeavesPerWorker_ = input.readDouble();
              bitField5_ |= 0x00000200;
              break;
            } // case 2249
            case 2256: {
              sharedTreeWorkerMinRestartsPerSubtree_ = input.readInt32();
              bitField5_ |= 0x00000080;
              break;
            } // case 2256
            case 2264: {
              useLns_ = input.readBool();
              bitField5_ |= 0x00200000;
              break;
            } // case 2264
            case 2272: {
              saveLpBasisInLbTreeSearch_ = input.readBool();
              bitField4_ |= 0x00100000;
              break;
            } // case 2272
            case 2280: {
              shareGlueClauses_ = input.readBool();
              bitField3_ |= 0x00000080;
              break;
            } // case 2280
            case 2288: {
              useConservativeScaleOverloadChecker_ = input.readBool();
              bitField3_ |= 0x02000000;
              break;
            } // case 2288
            case 2296: {
              encodeCumulativeAsReservoir_ = input.readBool();
              bitField2_ |= 0x00000400;
              break;
            } // case 2296
            case 2304: {
              expandReservoirUsingCircuit_ = input.readBool();
              bitField2_ |= 0x00000200;
              break;
            } // case 2304
            case 2312: {
              useVariablesShavingSearch_ = input.readBool();
              bitField4_ |= 0x00010000;
              break;
            } // case 2312
            case 2320: {
              shavingSearchThreshold_ = input.readInt64();
              bitField4_ |= 0x00002000;
              break;
            } // case 2320
            case 2328: {
              maxNumDeterministicBatches_ = input.readInt32();
              bitField1_ |= 0x00000200;
              break;
            } // case 2328
            case 2337: {
              feasibilityJumpBatchDtime_ = input.readDouble();
              bitField4_ |= 0x10000000;
              break;
            } // case 2337
            case 2346: {
              com.google.protobuf.ByteString bs = input.readBytes();
              ensureFilterSubsolversIsMutable();
              filterSubsolvers_.add(bs);
              break;
            } // case 2346
            case 2352: {
              numFullSubsolvers_ = input.readInt32();
              bitField2_ |= 0x10000000;
              break;
            } // case 2352
            case 2360: {
              sharedTreeWorkerEnableTrailSharing_ = input.readBool();
              bitField5_ |= 0x00000100;
              break;
            } // case 2360
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;
    private int bitField1_;
    private int bitField2_;
    private int bitField3_;
    private int bitField4_;
    private int bitField5_;
    private int bitField6_;
    private int bitField7_;

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * In some context, like in a portfolio of search, it makes sense to name a
     * given parameters set for logging purpose.
     * </pre>
     *
     * <code>optional string name = 171 [default = ""];</code>
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * In some context, like in a portfolio of search, it makes sense to name a
     * given parameters set for logging purpose.
     * </pre>
     *
     * <code>optional string name = 171 [default = ""];</code>
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * In some context, like in a portfolio of search, it makes sense to name a
     * given parameters set for logging purpose.
     * </pre>
     *
     * <code>optional string name = 171 [default = ""];</code>
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * In some context, like in a portfolio of search, it makes sense to name a
     * given parameters set for logging purpose.
     * </pre>
     *
     * <code>optional string name = 171 [default = ""];</code>
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * In some context, like in a portfolio of search, it makes sense to name a
     * given parameters set for logging purpose.
     * </pre>
     *
     * <code>optional string name = 171 [default = ""];</code>
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * In some context, like in a portfolio of search, it makes sense to name a
     * given parameters set for logging purpose.
     * </pre>
     *
     * <code>optional string name = 171 [default = ""];</code>
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int preferredVariableOrder_ = 0;
    /**
     * <code>optional .operations_research.sat.SatParameters.VariableOrder preferred_variable_order = 1 [default = IN_ORDER];</code>
     * @return Whether the preferredVariableOrder field is set.
     */
    @java.lang.Override public boolean hasPreferredVariableOrder() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.VariableOrder preferred_variable_order = 1 [default = IN_ORDER];</code>
     * @return The preferredVariableOrder.
     */
    @java.lang.Override
    public com.google.ortools.sat.SatParameters.VariableOrder getPreferredVariableOrder() {
      com.google.ortools.sat.SatParameters.VariableOrder result = com.google.ortools.sat.SatParameters.VariableOrder.forNumber(preferredVariableOrder_);
      return result == null ? com.google.ortools.sat.SatParameters.VariableOrder.IN_ORDER : result;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.VariableOrder preferred_variable_order = 1 [default = IN_ORDER];</code>
     * @param value The preferredVariableOrder to set.
     * @return This builder for chaining.
     */
    public Builder setPreferredVariableOrder(com.google.ortools.sat.SatParameters.VariableOrder value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      preferredVariableOrder_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.VariableOrder preferred_variable_order = 1 [default = IN_ORDER];</code>
     * @return This builder for chaining.
     */
    public Builder clearPreferredVariableOrder() {
      bitField0_ = (bitField0_ & ~0x00000002);
      preferredVariableOrder_ = 0;
      onChanged();
      return this;
    }

    private int initialPolarity_ = 1;
    /**
     * <code>optional .operations_research.sat.SatParameters.Polarity initial_polarity = 2 [default = POLARITY_FALSE];</code>
     * @return Whether the initialPolarity field is set.
     */
    @java.lang.Override public boolean hasInitialPolarity() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.Polarity initial_polarity = 2 [default = POLARITY_FALSE];</code>
     * @return The initialPolarity.
     */
    @java.lang.Override
    public com.google.ortools.sat.SatParameters.Polarity getInitialPolarity() {
      com.google.ortools.sat.SatParameters.Polarity result = com.google.ortools.sat.SatParameters.Polarity.forNumber(initialPolarity_);
      return result == null ? com.google.ortools.sat.SatParameters.Polarity.POLARITY_FALSE : result;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.Polarity initial_polarity = 2 [default = POLARITY_FALSE];</code>
     * @param value The initialPolarity to set.
     * @return This builder for chaining.
     */
    public Builder setInitialPolarity(com.google.ortools.sat.SatParameters.Polarity value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      initialPolarity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.Polarity initial_polarity = 2 [default = POLARITY_FALSE];</code>
     * @return This builder for chaining.
     */
    public Builder clearInitialPolarity() {
      bitField0_ = (bitField0_ & ~0x00000004);
      initialPolarity_ = 1;
      onChanged();
      return this;
    }

    private boolean usePhaseSaving_ = true;
    /**
     * <pre>
     * If this is true, then the polarity of a variable will be the last value it
     * was assigned to, or its default polarity if it was never assigned since the
     * call to ResetDecisionHeuristic().
     *
     * Actually, we use a newer version where we follow the last value in the
     * longest non-conflicting partial assignment in the current phase.
     *
     * This is called 'literal phase saving'. For details see 'A Lightweight
     * Component Caching Scheme for Satisfiability Solvers' K. Pipatsrisawat and
     * A.Darwiche, In 10th International Conference on Theory and Applications of
     * Satisfiability Testing, 2007.
     * </pre>
     *
     * <code>optional bool use_phase_saving = 44 [default = true];</code>
     * @return Whether the usePhaseSaving field is set.
     */
    @java.lang.Override
    public boolean hasUsePhaseSaving() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * If this is true, then the polarity of a variable will be the last value it
     * was assigned to, or its default polarity if it was never assigned since the
     * call to ResetDecisionHeuristic().
     *
     * Actually, we use a newer version where we follow the last value in the
     * longest non-conflicting partial assignment in the current phase.
     *
     * This is called 'literal phase saving'. For details see 'A Lightweight
     * Component Caching Scheme for Satisfiability Solvers' K. Pipatsrisawat and
     * A.Darwiche, In 10th International Conference on Theory and Applications of
     * Satisfiability Testing, 2007.
     * </pre>
     *
     * <code>optional bool use_phase_saving = 44 [default = true];</code>
     * @return The usePhaseSaving.
     */
    @java.lang.Override
    public boolean getUsePhaseSaving() {
      return usePhaseSaving_;
    }
    /**
     * <pre>
     * If this is true, then the polarity of a variable will be the last value it
     * was assigned to, or its default polarity if it was never assigned since the
     * call to ResetDecisionHeuristic().
     *
     * Actually, we use a newer version where we follow the last value in the
     * longest non-conflicting partial assignment in the current phase.
     *
     * This is called 'literal phase saving'. For details see 'A Lightweight
     * Component Caching Scheme for Satisfiability Solvers' K. Pipatsrisawat and
     * A.Darwiche, In 10th International Conference on Theory and Applications of
     * Satisfiability Testing, 2007.
     * </pre>
     *
     * <code>optional bool use_phase_saving = 44 [default = true];</code>
     * @param value The usePhaseSaving to set.
     * @return This builder for chaining.
     */
    public Builder setUsePhaseSaving(boolean value) {

      usePhaseSaving_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If this is true, then the polarity of a variable will be the last value it
     * was assigned to, or its default polarity if it was never assigned since the
     * call to ResetDecisionHeuristic().
     *
     * Actually, we use a newer version where we follow the last value in the
     * longest non-conflicting partial assignment in the current phase.
     *
     * This is called 'literal phase saving'. For details see 'A Lightweight
     * Component Caching Scheme for Satisfiability Solvers' K. Pipatsrisawat and
     * A.Darwiche, In 10th International Conference on Theory and Applications of
     * Satisfiability Testing, 2007.
     * </pre>
     *
     * <code>optional bool use_phase_saving = 44 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearUsePhaseSaving() {
      bitField0_ = (bitField0_ & ~0x00000008);
      usePhaseSaving_ = true;
      onChanged();
      return this;
    }

    private int polarityRephaseIncrement_ = 1000;
    /**
     * <pre>
     * If non-zero, then we change the polarity heuristic after that many number
     * of conflicts in an arithmetically increasing fashion. So x the first time,
     * 2 * x the second time, etc...
     * </pre>
     *
     * <code>optional int32 polarity_rephase_increment = 168 [default = 1000];</code>
     * @return Whether the polarityRephaseIncrement field is set.
     */
    @java.lang.Override
    public boolean hasPolarityRephaseIncrement() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * If non-zero, then we change the polarity heuristic after that many number
     * of conflicts in an arithmetically increasing fashion. So x the first time,
     * 2 * x the second time, etc...
     * </pre>
     *
     * <code>optional int32 polarity_rephase_increment = 168 [default = 1000];</code>
     * @return The polarityRephaseIncrement.
     */
    @java.lang.Override
    public int getPolarityRephaseIncrement() {
      return polarityRephaseIncrement_;
    }
    /**
     * <pre>
     * If non-zero, then we change the polarity heuristic after that many number
     * of conflicts in an arithmetically increasing fashion. So x the first time,
     * 2 * x the second time, etc...
     * </pre>
     *
     * <code>optional int32 polarity_rephase_increment = 168 [default = 1000];</code>
     * @param value The polarityRephaseIncrement to set.
     * @return This builder for chaining.
     */
    public Builder setPolarityRephaseIncrement(int value) {

      polarityRephaseIncrement_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-zero, then we change the polarity heuristic after that many number
     * of conflicts in an arithmetically increasing fashion. So x the first time,
     * 2 * x the second time, etc...
     * </pre>
     *
     * <code>optional int32 polarity_rephase_increment = 168 [default = 1000];</code>
     * @return This builder for chaining.
     */
    public Builder clearPolarityRephaseIncrement() {
      bitField0_ = (bitField0_ & ~0x00000010);
      polarityRephaseIncrement_ = 1000;
      onChanged();
      return this;
    }

    private double randomPolarityRatio_ ;
    /**
     * <pre>
     * The proportion of polarity chosen at random. Note that this take
     * precedence over the phase saving heuristic. This is different from
     * initial_polarity:POLARITY_RANDOM because it will select a new random
     * polarity each time the variable is branched upon instead of selecting one
     * initially and then always taking this choice.
     * </pre>
     *
     * <code>optional double random_polarity_ratio = 45 [default = 0];</code>
     * @return Whether the randomPolarityRatio field is set.
     */
    @java.lang.Override
    public boolean hasRandomPolarityRatio() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * The proportion of polarity chosen at random. Note that this take
     * precedence over the phase saving heuristic. This is different from
     * initial_polarity:POLARITY_RANDOM because it will select a new random
     * polarity each time the variable is branched upon instead of selecting one
     * initially and then always taking this choice.
     * </pre>
     *
     * <code>optional double random_polarity_ratio = 45 [default = 0];</code>
     * @return The randomPolarityRatio.
     */
    @java.lang.Override
    public double getRandomPolarityRatio() {
      return randomPolarityRatio_;
    }
    /**
     * <pre>
     * The proportion of polarity chosen at random. Note that this take
     * precedence over the phase saving heuristic. This is different from
     * initial_polarity:POLARITY_RANDOM because it will select a new random
     * polarity each time the variable is branched upon instead of selecting one
     * initially and then always taking this choice.
     * </pre>
     *
     * <code>optional double random_polarity_ratio = 45 [default = 0];</code>
     * @param value The randomPolarityRatio to set.
     * @return This builder for chaining.
     */
    public Builder setRandomPolarityRatio(double value) {

      randomPolarityRatio_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The proportion of polarity chosen at random. Note that this take
     * precedence over the phase saving heuristic. This is different from
     * initial_polarity:POLARITY_RANDOM because it will select a new random
     * polarity each time the variable is branched upon instead of selecting one
     * initially and then always taking this choice.
     * </pre>
     *
     * <code>optional double random_polarity_ratio = 45 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearRandomPolarityRatio() {
      bitField0_ = (bitField0_ & ~0x00000020);
      randomPolarityRatio_ = 0D;
      onChanged();
      return this;
    }

    private double randomBranchesRatio_ ;
    /**
     * <pre>
     * A number between 0 and 1 that indicates the proportion of branching
     * variables that are selected randomly instead of choosing the first variable
     * from the given variable_ordering strategy.
     * </pre>
     *
     * <code>optional double random_branches_ratio = 32 [default = 0];</code>
     * @return Whether the randomBranchesRatio field is set.
     */
    @java.lang.Override
    public boolean hasRandomBranchesRatio() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * A number between 0 and 1 that indicates the proportion of branching
     * variables that are selected randomly instead of choosing the first variable
     * from the given variable_ordering strategy.
     * </pre>
     *
     * <code>optional double random_branches_ratio = 32 [default = 0];</code>
     * @return The randomBranchesRatio.
     */
    @java.lang.Override
    public double getRandomBranchesRatio() {
      return randomBranchesRatio_;
    }
    /**
     * <pre>
     * A number between 0 and 1 that indicates the proportion of branching
     * variables that are selected randomly instead of choosing the first variable
     * from the given variable_ordering strategy.
     * </pre>
     *
     * <code>optional double random_branches_ratio = 32 [default = 0];</code>
     * @param value The randomBranchesRatio to set.
     * @return This builder for chaining.
     */
    public Builder setRandomBranchesRatio(double value) {

      randomBranchesRatio_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A number between 0 and 1 that indicates the proportion of branching
     * variables that are selected randomly instead of choosing the first variable
     * from the given variable_ordering strategy.
     * </pre>
     *
     * <code>optional double random_branches_ratio = 32 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearRandomBranchesRatio() {
      bitField0_ = (bitField0_ & ~0x00000040);
      randomBranchesRatio_ = 0D;
      onChanged();
      return this;
    }

    private boolean useErwaHeuristic_ ;
    /**
     * <pre>
     * Whether we use the ERWA (Exponential Recency Weighted Average) heuristic as
     * described in "Learning Rate Based Branching Heuristic for SAT solvers",
     * J.H.Liang, V. Ganesh, P. Poupart, K.Czarnecki, SAT 2016.
     * </pre>
     *
     * <code>optional bool use_erwa_heuristic = 75 [default = false];</code>
     * @return Whether the useErwaHeuristic field is set.
     */
    @java.lang.Override
    public boolean hasUseErwaHeuristic() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     * <pre>
     * Whether we use the ERWA (Exponential Recency Weighted Average) heuristic as
     * described in "Learning Rate Based Branching Heuristic for SAT solvers",
     * J.H.Liang, V. Ganesh, P. Poupart, K.Czarnecki, SAT 2016.
     * </pre>
     *
     * <code>optional bool use_erwa_heuristic = 75 [default = false];</code>
     * @return The useErwaHeuristic.
     */
    @java.lang.Override
    public boolean getUseErwaHeuristic() {
      return useErwaHeuristic_;
    }
    /**
     * <pre>
     * Whether we use the ERWA (Exponential Recency Weighted Average) heuristic as
     * described in "Learning Rate Based Branching Heuristic for SAT solvers",
     * J.H.Liang, V. Ganesh, P. Poupart, K.Czarnecki, SAT 2016.
     * </pre>
     *
     * <code>optional bool use_erwa_heuristic = 75 [default = false];</code>
     * @param value The useErwaHeuristic to set.
     * @return This builder for chaining.
     */
    public Builder setUseErwaHeuristic(boolean value) {

      useErwaHeuristic_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we use the ERWA (Exponential Recency Weighted Average) heuristic as
     * described in "Learning Rate Based Branching Heuristic for SAT solvers",
     * J.H.Liang, V. Ganesh, P. Poupart, K.Czarnecki, SAT 2016.
     * </pre>
     *
     * <code>optional bool use_erwa_heuristic = 75 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseErwaHeuristic() {
      bitField0_ = (bitField0_ & ~0x00000080);
      useErwaHeuristic_ = false;
      onChanged();
      return this;
    }

    private double initialVariablesActivity_ ;
    /**
     * <pre>
     * The initial value of the variables activity. A non-zero value only make
     * sense when use_erwa_heuristic is true. Experiments with a value of 1e-2
     * together with the ERWA heuristic showed slighthly better result than simply
     * using zero. The idea is that when the "learning rate" of a variable becomes
     * lower than this value, then we prefer to branch on never explored before
     * variables. This is not in the ERWA paper.
     * </pre>
     *
     * <code>optional double initial_variables_activity = 76 [default = 0];</code>
     * @return Whether the initialVariablesActivity field is set.
     */
    @java.lang.Override
    public boolean hasInitialVariablesActivity() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     * <pre>
     * The initial value of the variables activity. A non-zero value only make
     * sense when use_erwa_heuristic is true. Experiments with a value of 1e-2
     * together with the ERWA heuristic showed slighthly better result than simply
     * using zero. The idea is that when the "learning rate" of a variable becomes
     * lower than this value, then we prefer to branch on never explored before
     * variables. This is not in the ERWA paper.
     * </pre>
     *
     * <code>optional double initial_variables_activity = 76 [default = 0];</code>
     * @return The initialVariablesActivity.
     */
    @java.lang.Override
    public double getInitialVariablesActivity() {
      return initialVariablesActivity_;
    }
    /**
     * <pre>
     * The initial value of the variables activity. A non-zero value only make
     * sense when use_erwa_heuristic is true. Experiments with a value of 1e-2
     * together with the ERWA heuristic showed slighthly better result than simply
     * using zero. The idea is that when the "learning rate" of a variable becomes
     * lower than this value, then we prefer to branch on never explored before
     * variables. This is not in the ERWA paper.
     * </pre>
     *
     * <code>optional double initial_variables_activity = 76 [default = 0];</code>
     * @param value The initialVariablesActivity to set.
     * @return This builder for chaining.
     */
    public Builder setInitialVariablesActivity(double value) {

      initialVariablesActivity_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The initial value of the variables activity. A non-zero value only make
     * sense when use_erwa_heuristic is true. Experiments with a value of 1e-2
     * together with the ERWA heuristic showed slighthly better result than simply
     * using zero. The idea is that when the "learning rate" of a variable becomes
     * lower than this value, then we prefer to branch on never explored before
     * variables. This is not in the ERWA paper.
     * </pre>
     *
     * <code>optional double initial_variables_activity = 76 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearInitialVariablesActivity() {
      bitField0_ = (bitField0_ & ~0x00000100);
      initialVariablesActivity_ = 0D;
      onChanged();
      return this;
    }

    private boolean alsoBumpVariablesInConflictReasons_ ;
    /**
     * <pre>
     * When this is true, then the variables that appear in any of the reason of
     * the variables in a conflict have their activity bumped. This is addition to
     * the variables in the conflict, and the one that were used during conflict
     * resolution.
     * </pre>
     *
     * <code>optional bool also_bump_variables_in_conflict_reasons = 77 [default = false];</code>
     * @return Whether the alsoBumpVariablesInConflictReasons field is set.
     */
    @java.lang.Override
    public boolean hasAlsoBumpVariablesInConflictReasons() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     * <pre>
     * When this is true, then the variables that appear in any of the reason of
     * the variables in a conflict have their activity bumped. This is addition to
     * the variables in the conflict, and the one that were used during conflict
     * resolution.
     * </pre>
     *
     * <code>optional bool also_bump_variables_in_conflict_reasons = 77 [default = false];</code>
     * @return The alsoBumpVariablesInConflictReasons.
     */
    @java.lang.Override
    public boolean getAlsoBumpVariablesInConflictReasons() {
      return alsoBumpVariablesInConflictReasons_;
    }
    /**
     * <pre>
     * When this is true, then the variables that appear in any of the reason of
     * the variables in a conflict have their activity bumped. This is addition to
     * the variables in the conflict, and the one that were used during conflict
     * resolution.
     * </pre>
     *
     * <code>optional bool also_bump_variables_in_conflict_reasons = 77 [default = false];</code>
     * @param value The alsoBumpVariablesInConflictReasons to set.
     * @return This builder for chaining.
     */
    public Builder setAlsoBumpVariablesInConflictReasons(boolean value) {

      alsoBumpVariablesInConflictReasons_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * When this is true, then the variables that appear in any of the reason of
     * the variables in a conflict have their activity bumped. This is addition to
     * the variables in the conflict, and the one that were used during conflict
     * resolution.
     * </pre>
     *
     * <code>optional bool also_bump_variables_in_conflict_reasons = 77 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearAlsoBumpVariablesInConflictReasons() {
      bitField0_ = (bitField0_ & ~0x00000200);
      alsoBumpVariablesInConflictReasons_ = false;
      onChanged();
      return this;
    }

    private int minimizationAlgorithm_ = 2;
    /**
     * <code>optional .operations_research.sat.SatParameters.ConflictMinimizationAlgorithm minimization_algorithm = 4 [default = RECURSIVE];</code>
     * @return Whether the minimizationAlgorithm field is set.
     */
    @java.lang.Override public boolean hasMinimizationAlgorithm() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.ConflictMinimizationAlgorithm minimization_algorithm = 4 [default = RECURSIVE];</code>
     * @return The minimizationAlgorithm.
     */
    @java.lang.Override
    public com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm getMinimizationAlgorithm() {
      com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm result = com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm.forNumber(minimizationAlgorithm_);
      return result == null ? com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm.RECURSIVE : result;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.ConflictMinimizationAlgorithm minimization_algorithm = 4 [default = RECURSIVE];</code>
     * @param value The minimizationAlgorithm to set.
     * @return This builder for chaining.
     */
    public Builder setMinimizationAlgorithm(com.google.ortools.sat.SatParameters.ConflictMinimizationAlgorithm value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000400;
      minimizationAlgorithm_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.ConflictMinimizationAlgorithm minimization_algorithm = 4 [default = RECURSIVE];</code>
     * @return This builder for chaining.
     */
    public Builder clearMinimizationAlgorithm() {
      bitField0_ = (bitField0_ & ~0x00000400);
      minimizationAlgorithm_ = 2;
      onChanged();
      return this;
    }

    private int binaryMinimizationAlgorithm_ = 1;
    /**
     * <code>optional .operations_research.sat.SatParameters.BinaryMinizationAlgorithm binary_minimization_algorithm = 34 [default = BINARY_MINIMIZATION_FIRST];</code>
     * @return Whether the binaryMinimizationAlgorithm field is set.
     */
    @java.lang.Override public boolean hasBinaryMinimizationAlgorithm() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.BinaryMinizationAlgorithm binary_minimization_algorithm = 34 [default = BINARY_MINIMIZATION_FIRST];</code>
     * @return The binaryMinimizationAlgorithm.
     */
    @java.lang.Override
    public com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm getBinaryMinimizationAlgorithm() {
      com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm result = com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm.forNumber(binaryMinimizationAlgorithm_);
      return result == null ? com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm.BINARY_MINIMIZATION_FIRST : result;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.BinaryMinizationAlgorithm binary_minimization_algorithm = 34 [default = BINARY_MINIMIZATION_FIRST];</code>
     * @param value The binaryMinimizationAlgorithm to set.
     * @return This builder for chaining.
     */
    public Builder setBinaryMinimizationAlgorithm(com.google.ortools.sat.SatParameters.BinaryMinizationAlgorithm value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      binaryMinimizationAlgorithm_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.BinaryMinizationAlgorithm binary_minimization_algorithm = 34 [default = BINARY_MINIMIZATION_FIRST];</code>
     * @return This builder for chaining.
     */
    public Builder clearBinaryMinimizationAlgorithm() {
      bitField0_ = (bitField0_ & ~0x00000800);
      binaryMinimizationAlgorithm_ = 1;
      onChanged();
      return this;
    }

    private boolean subsumptionDuringConflictAnalysis_ = true;
    /**
     * <pre>
     * At a really low cost, during the 1-UIP conflict computation, it is easy to
     * detect if some of the involved reasons are subsumed by the current
     * conflict. When this is true, such clauses are detached and later removed
     * from the problem.
     * </pre>
     *
     * <code>optional bool subsumption_during_conflict_analysis = 56 [default = true];</code>
     * @return Whether the subsumptionDuringConflictAnalysis field is set.
     */
    @java.lang.Override
    public boolean hasSubsumptionDuringConflictAnalysis() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     * <pre>
     * At a really low cost, during the 1-UIP conflict computation, it is easy to
     * detect if some of the involved reasons are subsumed by the current
     * conflict. When this is true, such clauses are detached and later removed
     * from the problem.
     * </pre>
     *
     * <code>optional bool subsumption_during_conflict_analysis = 56 [default = true];</code>
     * @return The subsumptionDuringConflictAnalysis.
     */
    @java.lang.Override
    public boolean getSubsumptionDuringConflictAnalysis() {
      return subsumptionDuringConflictAnalysis_;
    }
    /**
     * <pre>
     * At a really low cost, during the 1-UIP conflict computation, it is easy to
     * detect if some of the involved reasons are subsumed by the current
     * conflict. When this is true, such clauses are detached and later removed
     * from the problem.
     * </pre>
     *
     * <code>optional bool subsumption_during_conflict_analysis = 56 [default = true];</code>
     * @param value The subsumptionDuringConflictAnalysis to set.
     * @return This builder for chaining.
     */
    public Builder setSubsumptionDuringConflictAnalysis(boolean value) {

      subsumptionDuringConflictAnalysis_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * At a really low cost, during the 1-UIP conflict computation, it is easy to
     * detect if some of the involved reasons are subsumed by the current
     * conflict. When this is true, such clauses are detached and later removed
     * from the problem.
     * </pre>
     *
     * <code>optional bool subsumption_during_conflict_analysis = 56 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearSubsumptionDuringConflictAnalysis() {
      bitField0_ = (bitField0_ & ~0x00001000);
      subsumptionDuringConflictAnalysis_ = true;
      onChanged();
      return this;
    }

    private int clauseCleanupPeriod_ = 10000;
    /**
     * <pre>
     * Trigger a cleanup when this number of "deletable" clauses is learned.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_period = 11 [default = 10000];</code>
     * @return Whether the clauseCleanupPeriod field is set.
     */
    @java.lang.Override
    public boolean hasClauseCleanupPeriod() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     * <pre>
     * Trigger a cleanup when this number of "deletable" clauses is learned.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_period = 11 [default = 10000];</code>
     * @return The clauseCleanupPeriod.
     */
    @java.lang.Override
    public int getClauseCleanupPeriod() {
      return clauseCleanupPeriod_;
    }
    /**
     * <pre>
     * Trigger a cleanup when this number of "deletable" clauses is learned.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_period = 11 [default = 10000];</code>
     * @param value The clauseCleanupPeriod to set.
     * @return This builder for chaining.
     */
    public Builder setClauseCleanupPeriod(int value) {

      clauseCleanupPeriod_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Trigger a cleanup when this number of "deletable" clauses is learned.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_period = 11 [default = 10000];</code>
     * @return This builder for chaining.
     */
    public Builder clearClauseCleanupPeriod() {
      bitField0_ = (bitField0_ & ~0x00002000);
      clauseCleanupPeriod_ = 10000;
      onChanged();
      return this;
    }

    private int clauseCleanupTarget_ ;
    /**
     * <pre>
     * During a cleanup, we will always keep that number of "deletable" clauses.
     * Note that this doesn't include the "protected" clauses.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_target = 13 [default = 0];</code>
     * @return Whether the clauseCleanupTarget field is set.
     */
    @java.lang.Override
    public boolean hasClauseCleanupTarget() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     * <pre>
     * During a cleanup, we will always keep that number of "deletable" clauses.
     * Note that this doesn't include the "protected" clauses.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_target = 13 [default = 0];</code>
     * @return The clauseCleanupTarget.
     */
    @java.lang.Override
    public int getClauseCleanupTarget() {
      return clauseCleanupTarget_;
    }
    /**
     * <pre>
     * During a cleanup, we will always keep that number of "deletable" clauses.
     * Note that this doesn't include the "protected" clauses.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_target = 13 [default = 0];</code>
     * @param value The clauseCleanupTarget to set.
     * @return This builder for chaining.
     */
    public Builder setClauseCleanupTarget(int value) {

      clauseCleanupTarget_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * During a cleanup, we will always keep that number of "deletable" clauses.
     * Note that this doesn't include the "protected" clauses.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_target = 13 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearClauseCleanupTarget() {
      bitField0_ = (bitField0_ & ~0x00004000);
      clauseCleanupTarget_ = 0;
      onChanged();
      return this;
    }

    private double clauseCleanupRatio_ = 0.5D;
    /**
     * <pre>
     * During a cleanup, if clause_cleanup_target is 0, we will delete the
     * clause_cleanup_ratio of "deletable" clauses instead of aiming for a fixed
     * target of clauses to keep.
     * </pre>
     *
     * <code>optional double clause_cleanup_ratio = 190 [default = 0.5];</code>
     * @return Whether the clauseCleanupRatio field is set.
     */
    @java.lang.Override
    public boolean hasClauseCleanupRatio() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     * <pre>
     * During a cleanup, if clause_cleanup_target is 0, we will delete the
     * clause_cleanup_ratio of "deletable" clauses instead of aiming for a fixed
     * target of clauses to keep.
     * </pre>
     *
     * <code>optional double clause_cleanup_ratio = 190 [default = 0.5];</code>
     * @return The clauseCleanupRatio.
     */
    @java.lang.Override
    public double getClauseCleanupRatio() {
      return clauseCleanupRatio_;
    }
    /**
     * <pre>
     * During a cleanup, if clause_cleanup_target is 0, we will delete the
     * clause_cleanup_ratio of "deletable" clauses instead of aiming for a fixed
     * target of clauses to keep.
     * </pre>
     *
     * <code>optional double clause_cleanup_ratio = 190 [default = 0.5];</code>
     * @param value The clauseCleanupRatio to set.
     * @return This builder for chaining.
     */
    public Builder setClauseCleanupRatio(double value) {

      clauseCleanupRatio_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * During a cleanup, if clause_cleanup_target is 0, we will delete the
     * clause_cleanup_ratio of "deletable" clauses instead of aiming for a fixed
     * target of clauses to keep.
     * </pre>
     *
     * <code>optional double clause_cleanup_ratio = 190 [default = 0.5];</code>
     * @return This builder for chaining.
     */
    public Builder clearClauseCleanupRatio() {
      bitField0_ = (bitField0_ & ~0x00008000);
      clauseCleanupRatio_ = 0.5D;
      onChanged();
      return this;
    }

    private int clauseCleanupProtection_ = 0;
    /**
     * <code>optional .operations_research.sat.SatParameters.ClauseProtection clause_cleanup_protection = 58 [default = PROTECTION_NONE];</code>
     * @return Whether the clauseCleanupProtection field is set.
     */
    @java.lang.Override public boolean hasClauseCleanupProtection() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.ClauseProtection clause_cleanup_protection = 58 [default = PROTECTION_NONE];</code>
     * @return The clauseCleanupProtection.
     */
    @java.lang.Override
    public com.google.ortools.sat.SatParameters.ClauseProtection getClauseCleanupProtection() {
      com.google.ortools.sat.SatParameters.ClauseProtection result = com.google.ortools.sat.SatParameters.ClauseProtection.forNumber(clauseCleanupProtection_);
      return result == null ? com.google.ortools.sat.SatParameters.ClauseProtection.PROTECTION_NONE : result;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.ClauseProtection clause_cleanup_protection = 58 [default = PROTECTION_NONE];</code>
     * @param value The clauseCleanupProtection to set.
     * @return This builder for chaining.
     */
    public Builder setClauseCleanupProtection(com.google.ortools.sat.SatParameters.ClauseProtection value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00010000;
      clauseCleanupProtection_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.ClauseProtection clause_cleanup_protection = 58 [default = PROTECTION_NONE];</code>
     * @return This builder for chaining.
     */
    public Builder clearClauseCleanupProtection() {
      bitField0_ = (bitField0_ & ~0x00010000);
      clauseCleanupProtection_ = 0;
      onChanged();
      return this;
    }

    private int clauseCleanupLbdBound_ = 5;
    /**
     * <pre>
     * All the clauses with a LBD (literal blocks distance) lower or equal to this
     * parameters will always be kept.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_lbd_bound = 59 [default = 5];</code>
     * @return Whether the clauseCleanupLbdBound field is set.
     */
    @java.lang.Override
    public boolean hasClauseCleanupLbdBound() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     * <pre>
     * All the clauses with a LBD (literal blocks distance) lower or equal to this
     * parameters will always be kept.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_lbd_bound = 59 [default = 5];</code>
     * @return The clauseCleanupLbdBound.
     */
    @java.lang.Override
    public int getClauseCleanupLbdBound() {
      return clauseCleanupLbdBound_;
    }
    /**
     * <pre>
     * All the clauses with a LBD (literal blocks distance) lower or equal to this
     * parameters will always be kept.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_lbd_bound = 59 [default = 5];</code>
     * @param value The clauseCleanupLbdBound to set.
     * @return This builder for chaining.
     */
    public Builder setClauseCleanupLbdBound(int value) {

      clauseCleanupLbdBound_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * All the clauses with a LBD (literal blocks distance) lower or equal to this
     * parameters will always be kept.
     * </pre>
     *
     * <code>optional int32 clause_cleanup_lbd_bound = 59 [default = 5];</code>
     * @return This builder for chaining.
     */
    public Builder clearClauseCleanupLbdBound() {
      bitField0_ = (bitField0_ & ~0x00020000);
      clauseCleanupLbdBound_ = 5;
      onChanged();
      return this;
    }

    private int clauseCleanupOrdering_ = 0;
    /**
     * <code>optional .operations_research.sat.SatParameters.ClauseOrdering clause_cleanup_ordering = 60 [default = CLAUSE_ACTIVITY];</code>
     * @return Whether the clauseCleanupOrdering field is set.
     */
    @java.lang.Override public boolean hasClauseCleanupOrdering() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.ClauseOrdering clause_cleanup_ordering = 60 [default = CLAUSE_ACTIVITY];</code>
     * @return The clauseCleanupOrdering.
     */
    @java.lang.Override
    public com.google.ortools.sat.SatParameters.ClauseOrdering getClauseCleanupOrdering() {
      com.google.ortools.sat.SatParameters.ClauseOrdering result = com.google.ortools.sat.SatParameters.ClauseOrdering.forNumber(clauseCleanupOrdering_);
      return result == null ? com.google.ortools.sat.SatParameters.ClauseOrdering.CLAUSE_ACTIVITY : result;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.ClauseOrdering clause_cleanup_ordering = 60 [default = CLAUSE_ACTIVITY];</code>
     * @param value The clauseCleanupOrdering to set.
     * @return This builder for chaining.
     */
    public Builder setClauseCleanupOrdering(com.google.ortools.sat.SatParameters.ClauseOrdering value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00040000;
      clauseCleanupOrdering_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.ClauseOrdering clause_cleanup_ordering = 60 [default = CLAUSE_ACTIVITY];</code>
     * @return This builder for chaining.
     */
    public Builder clearClauseCleanupOrdering() {
      bitField0_ = (bitField0_ & ~0x00040000);
      clauseCleanupOrdering_ = 0;
      onChanged();
      return this;
    }

    private int pbCleanupIncrement_ = 200;
    /**
     * <pre>
     * Same as for the clauses, but for the learned pseudo-Boolean constraints.
     * </pre>
     *
     * <code>optional int32 pb_cleanup_increment = 46 [default = 200];</code>
     * @return Whether the pbCleanupIncrement field is set.
     */
    @java.lang.Override
    public boolean hasPbCleanupIncrement() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     * <pre>
     * Same as for the clauses, but for the learned pseudo-Boolean constraints.
     * </pre>
     *
     * <code>optional int32 pb_cleanup_increment = 46 [default = 200];</code>
     * @return The pbCleanupIncrement.
     */
    @java.lang.Override
    public int getPbCleanupIncrement() {
      return pbCleanupIncrement_;
    }
    /**
     * <pre>
     * Same as for the clauses, but for the learned pseudo-Boolean constraints.
     * </pre>
     *
     * <code>optional int32 pb_cleanup_increment = 46 [default = 200];</code>
     * @param value The pbCleanupIncrement to set.
     * @return This builder for chaining.
     */
    public Builder setPbCleanupIncrement(int value) {

      pbCleanupIncrement_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Same as for the clauses, but for the learned pseudo-Boolean constraints.
     * </pre>
     *
     * <code>optional int32 pb_cleanup_increment = 46 [default = 200];</code>
     * @return This builder for chaining.
     */
    public Builder clearPbCleanupIncrement() {
      bitField0_ = (bitField0_ & ~0x00080000);
      pbCleanupIncrement_ = 200;
      onChanged();
      return this;
    }

    private double pbCleanupRatio_ = 0.5D;
    /**
     * <code>optional double pb_cleanup_ratio = 47 [default = 0.5];</code>
     * @return Whether the pbCleanupRatio field is set.
     */
    @java.lang.Override
    public boolean hasPbCleanupRatio() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     * <code>optional double pb_cleanup_ratio = 47 [default = 0.5];</code>
     * @return The pbCleanupRatio.
     */
    @java.lang.Override
    public double getPbCleanupRatio() {
      return pbCleanupRatio_;
    }
    /**
     * <code>optional double pb_cleanup_ratio = 47 [default = 0.5];</code>
     * @param value The pbCleanupRatio to set.
     * @return This builder for chaining.
     */
    public Builder setPbCleanupRatio(double value) {

      pbCleanupRatio_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     * <code>optional double pb_cleanup_ratio = 47 [default = 0.5];</code>
     * @return This builder for chaining.
     */
    public Builder clearPbCleanupRatio() {
      bitField0_ = (bitField0_ & ~0x00100000);
      pbCleanupRatio_ = 0.5D;
      onChanged();
      return this;
    }

    private double variableActivityDecay_ = 0.8D;
    /**
     * <pre>
     * Each time a conflict is found, the activities of some variables are
     * increased by one. Then, the activity of all variables are multiplied by
     * variable_activity_decay.
     *
     * To implement this efficiently, the activity of all the variables is not
     * decayed at each conflict. Instead, the activity increment is multiplied by
     * 1 / decay. When an activity reach max_variable_activity_value, all the
     * activity are multiplied by 1 / max_variable_activity_value.
     * </pre>
     *
     * <code>optional double variable_activity_decay = 15 [default = 0.8];</code>
     * @return Whether the variableActivityDecay field is set.
     */
    @java.lang.Override
    public boolean hasVariableActivityDecay() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     * <pre>
     * Each time a conflict is found, the activities of some variables are
     * increased by one. Then, the activity of all variables are multiplied by
     * variable_activity_decay.
     *
     * To implement this efficiently, the activity of all the variables is not
     * decayed at each conflict. Instead, the activity increment is multiplied by
     * 1 / decay. When an activity reach max_variable_activity_value, all the
     * activity are multiplied by 1 / max_variable_activity_value.
     * </pre>
     *
     * <code>optional double variable_activity_decay = 15 [default = 0.8];</code>
     * @return The variableActivityDecay.
     */
    @java.lang.Override
    public double getVariableActivityDecay() {
      return variableActivityDecay_;
    }
    /**
     * <pre>
     * Each time a conflict is found, the activities of some variables are
     * increased by one. Then, the activity of all variables are multiplied by
     * variable_activity_decay.
     *
     * To implement this efficiently, the activity of all the variables is not
     * decayed at each conflict. Instead, the activity increment is multiplied by
     * 1 / decay. When an activity reach max_variable_activity_value, all the
     * activity are multiplied by 1 / max_variable_activity_value.
     * </pre>
     *
     * <code>optional double variable_activity_decay = 15 [default = 0.8];</code>
     * @param value The variableActivityDecay to set.
     * @return This builder for chaining.
     */
    public Builder setVariableActivityDecay(double value) {

      variableActivityDecay_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Each time a conflict is found, the activities of some variables are
     * increased by one. Then, the activity of all variables are multiplied by
     * variable_activity_decay.
     *
     * To implement this efficiently, the activity of all the variables is not
     * decayed at each conflict. Instead, the activity increment is multiplied by
     * 1 / decay. When an activity reach max_variable_activity_value, all the
     * activity are multiplied by 1 / max_variable_activity_value.
     * </pre>
     *
     * <code>optional double variable_activity_decay = 15 [default = 0.8];</code>
     * @return This builder for chaining.
     */
    public Builder clearVariableActivityDecay() {
      bitField0_ = (bitField0_ & ~0x00200000);
      variableActivityDecay_ = 0.8D;
      onChanged();
      return this;
    }

    private double maxVariableActivityValue_ = 1e+100D;
    /**
     * <code>optional double max_variable_activity_value = 16 [default = 1e+100];</code>
     * @return Whether the maxVariableActivityValue field is set.
     */
    @java.lang.Override
    public boolean hasMaxVariableActivityValue() {
      return ((bitField0_ & 0x00400000) != 0);
    }
    /**
     * <code>optional double max_variable_activity_value = 16 [default = 1e+100];</code>
     * @return The maxVariableActivityValue.
     */
    @java.lang.Override
    public double getMaxVariableActivityValue() {
      return maxVariableActivityValue_;
    }
    /**
     * <code>optional double max_variable_activity_value = 16 [default = 1e+100];</code>
     * @param value The maxVariableActivityValue to set.
     * @return This builder for chaining.
     */
    public Builder setMaxVariableActivityValue(double value) {

      maxVariableActivityValue_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     * <code>optional double max_variable_activity_value = 16 [default = 1e+100];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxVariableActivityValue() {
      bitField0_ = (bitField0_ & ~0x00400000);
      maxVariableActivityValue_ = 1e+100D;
      onChanged();
      return this;
    }

    private double glucoseMaxDecay_ = 0.95D;
    /**
     * <pre>
     * The activity starts at 0.8 and increment by 0.01 every 5000 conflicts until
     * 0.95. This "hack" seems to work well and comes from:
     *
     * Glucose 2.3 in the SAT 2013 Competition - SAT Competition 2013
     * http://edacc4.informatik.uni-ulm.de/SC13/solver-description-download/136
     * </pre>
     *
     * <code>optional double glucose_max_decay = 22 [default = 0.95];</code>
     * @return Whether the glucoseMaxDecay field is set.
     */
    @java.lang.Override
    public boolean hasGlucoseMaxDecay() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     * <pre>
     * The activity starts at 0.8 and increment by 0.01 every 5000 conflicts until
     * 0.95. This "hack" seems to work well and comes from:
     *
     * Glucose 2.3 in the SAT 2013 Competition - SAT Competition 2013
     * http://edacc4.informatik.uni-ulm.de/SC13/solver-description-download/136
     * </pre>
     *
     * <code>optional double glucose_max_decay = 22 [default = 0.95];</code>
     * @return The glucoseMaxDecay.
     */
    @java.lang.Override
    public double getGlucoseMaxDecay() {
      return glucoseMaxDecay_;
    }
    /**
     * <pre>
     * The activity starts at 0.8 and increment by 0.01 every 5000 conflicts until
     * 0.95. This "hack" seems to work well and comes from:
     *
     * Glucose 2.3 in the SAT 2013 Competition - SAT Competition 2013
     * http://edacc4.informatik.uni-ulm.de/SC13/solver-description-download/136
     * </pre>
     *
     * <code>optional double glucose_max_decay = 22 [default = 0.95];</code>
     * @param value The glucoseMaxDecay to set.
     * @return This builder for chaining.
     */
    public Builder setGlucoseMaxDecay(double value) {

      glucoseMaxDecay_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The activity starts at 0.8 and increment by 0.01 every 5000 conflicts until
     * 0.95. This "hack" seems to work well and comes from:
     *
     * Glucose 2.3 in the SAT 2013 Competition - SAT Competition 2013
     * http://edacc4.informatik.uni-ulm.de/SC13/solver-description-download/136
     * </pre>
     *
     * <code>optional double glucose_max_decay = 22 [default = 0.95];</code>
     * @return This builder for chaining.
     */
    public Builder clearGlucoseMaxDecay() {
      bitField0_ = (bitField0_ & ~0x00800000);
      glucoseMaxDecay_ = 0.95D;
      onChanged();
      return this;
    }

    private double glucoseDecayIncrement_ = 0.01D;
    /**
     * <code>optional double glucose_decay_increment = 23 [default = 0.01];</code>
     * @return Whether the glucoseDecayIncrement field is set.
     */
    @java.lang.Override
    public boolean hasGlucoseDecayIncrement() {
      return ((bitField0_ & 0x01000000) != 0);
    }
    /**
     * <code>optional double glucose_decay_increment = 23 [default = 0.01];</code>
     * @return The glucoseDecayIncrement.
     */
    @java.lang.Override
    public double getGlucoseDecayIncrement() {
      return glucoseDecayIncrement_;
    }
    /**
     * <code>optional double glucose_decay_increment = 23 [default = 0.01];</code>
     * @param value The glucoseDecayIncrement to set.
     * @return This builder for chaining.
     */
    public Builder setGlucoseDecayIncrement(double value) {

      glucoseDecayIncrement_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     * <code>optional double glucose_decay_increment = 23 [default = 0.01];</code>
     * @return This builder for chaining.
     */
    public Builder clearGlucoseDecayIncrement() {
      bitField0_ = (bitField0_ & ~0x01000000);
      glucoseDecayIncrement_ = 0.01D;
      onChanged();
      return this;
    }

    private int glucoseDecayIncrementPeriod_ = 5000;
    /**
     * <code>optional int32 glucose_decay_increment_period = 24 [default = 5000];</code>
     * @return Whether the glucoseDecayIncrementPeriod field is set.
     */
    @java.lang.Override
    public boolean hasGlucoseDecayIncrementPeriod() {
      return ((bitField0_ & 0x02000000) != 0);
    }
    /**
     * <code>optional int32 glucose_decay_increment_period = 24 [default = 5000];</code>
     * @return The glucoseDecayIncrementPeriod.
     */
    @java.lang.Override
    public int getGlucoseDecayIncrementPeriod() {
      return glucoseDecayIncrementPeriod_;
    }
    /**
     * <code>optional int32 glucose_decay_increment_period = 24 [default = 5000];</code>
     * @param value The glucoseDecayIncrementPeriod to set.
     * @return This builder for chaining.
     */
    public Builder setGlucoseDecayIncrementPeriod(int value) {

      glucoseDecayIncrementPeriod_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     * <code>optional int32 glucose_decay_increment_period = 24 [default = 5000];</code>
     * @return This builder for chaining.
     */
    public Builder clearGlucoseDecayIncrementPeriod() {
      bitField0_ = (bitField0_ & ~0x02000000);
      glucoseDecayIncrementPeriod_ = 5000;
      onChanged();
      return this;
    }

    private double clauseActivityDecay_ = 0.999D;
    /**
     * <pre>
     * Clause activity parameters (same effect as the one on the variables).
     * </pre>
     *
     * <code>optional double clause_activity_decay = 17 [default = 0.999];</code>
     * @return Whether the clauseActivityDecay field is set.
     */
    @java.lang.Override
    public boolean hasClauseActivityDecay() {
      return ((bitField0_ & 0x04000000) != 0);
    }
    /**
     * <pre>
     * Clause activity parameters (same effect as the one on the variables).
     * </pre>
     *
     * <code>optional double clause_activity_decay = 17 [default = 0.999];</code>
     * @return The clauseActivityDecay.
     */
    @java.lang.Override
    public double getClauseActivityDecay() {
      return clauseActivityDecay_;
    }
    /**
     * <pre>
     * Clause activity parameters (same effect as the one on the variables).
     * </pre>
     *
     * <code>optional double clause_activity_decay = 17 [default = 0.999];</code>
     * @param value The clauseActivityDecay to set.
     * @return This builder for chaining.
     */
    public Builder setClauseActivityDecay(double value) {

      clauseActivityDecay_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Clause activity parameters (same effect as the one on the variables).
     * </pre>
     *
     * <code>optional double clause_activity_decay = 17 [default = 0.999];</code>
     * @return This builder for chaining.
     */
    public Builder clearClauseActivityDecay() {
      bitField0_ = (bitField0_ & ~0x04000000);
      clauseActivityDecay_ = 0.999D;
      onChanged();
      return this;
    }

    private double maxClauseActivityValue_ = 1e+20D;
    /**
     * <code>optional double max_clause_activity_value = 18 [default = 1e+20];</code>
     * @return Whether the maxClauseActivityValue field is set.
     */
    @java.lang.Override
    public boolean hasMaxClauseActivityValue() {
      return ((bitField0_ & 0x08000000) != 0);
    }
    /**
     * <code>optional double max_clause_activity_value = 18 [default = 1e+20];</code>
     * @return The maxClauseActivityValue.
     */
    @java.lang.Override
    public double getMaxClauseActivityValue() {
      return maxClauseActivityValue_;
    }
    /**
     * <code>optional double max_clause_activity_value = 18 [default = 1e+20];</code>
     * @param value The maxClauseActivityValue to set.
     * @return This builder for chaining.
     */
    public Builder setMaxClauseActivityValue(double value) {

      maxClauseActivityValue_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     * <code>optional double max_clause_activity_value = 18 [default = 1e+20];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxClauseActivityValue() {
      bitField0_ = (bitField0_ & ~0x08000000);
      maxClauseActivityValue_ = 1e+20D;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> restartAlgorithms_ =
      java.util.Collections.emptyList();
    private void ensureRestartAlgorithmsIsMutable() {
      if (!((bitField0_ & 0x10000000) != 0)) {
        restartAlgorithms_ = new java.util.ArrayList<java.lang.Integer>(restartAlgorithms_);
        bitField0_ |= 0x10000000;
      }
    }
    /**
     * <pre>
     * The restart strategies will change each time the strategy_counter is
     * increased. The current strategy will simply be the one at index
     * strategy_counter modulo the number of strategy. Note that if this list
     * includes a NO_RESTART, nothing will change when it is reached because the
     * strategy_counter will only increment after a restart.
     *
     * The idea of switching of search strategy tailored for SAT/UNSAT comes from
     * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
     * But more generally, it seems REALLY beneficial to try different strategy.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
     * @return A list containing the restartAlgorithms.
     */
    public java.util.List<com.google.ortools.sat.SatParameters.RestartAlgorithm> getRestartAlgorithmsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.ortools.sat.SatParameters.RestartAlgorithm>(restartAlgorithms_, restartAlgorithms_converter_);
    }
    /**
     * <pre>
     * The restart strategies will change each time the strategy_counter is
     * increased. The current strategy will simply be the one at index
     * strategy_counter modulo the number of strategy. Note that if this list
     * includes a NO_RESTART, nothing will change when it is reached because the
     * strategy_counter will only increment after a restart.
     *
     * The idea of switching of search strategy tailored for SAT/UNSAT comes from
     * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
     * But more generally, it seems REALLY beneficial to try different strategy.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
     * @return The count of restartAlgorithms.
     */
    public int getRestartAlgorithmsCount() {
      return restartAlgorithms_.size();
    }
    /**
     * <pre>
     * The restart strategies will change each time the strategy_counter is
     * increased. The current strategy will simply be the one at index
     * strategy_counter modulo the number of strategy. Note that if this list
     * includes a NO_RESTART, nothing will change when it is reached because the
     * strategy_counter will only increment after a restart.
     *
     * The idea of switching of search strategy tailored for SAT/UNSAT comes from
     * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
     * But more generally, it seems REALLY beneficial to try different strategy.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
     * @param index The index of the element to return.
     * @return The restartAlgorithms at the given index.
     */
    public com.google.ortools.sat.SatParameters.RestartAlgorithm getRestartAlgorithms(int index) {
      return restartAlgorithms_converter_.convert(restartAlgorithms_.get(index));
    }
    /**
     * <pre>
     * The restart strategies will change each time the strategy_counter is
     * increased. The current strategy will simply be the one at index
     * strategy_counter modulo the number of strategy. Note that if this list
     * includes a NO_RESTART, nothing will change when it is reached because the
     * strategy_counter will only increment after a restart.
     *
     * The idea of switching of search strategy tailored for SAT/UNSAT comes from
     * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
     * But more generally, it seems REALLY beneficial to try different strategy.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
     * @param index The index to set the value at.
     * @param value The restartAlgorithms to set.
     * @return This builder for chaining.
     */
    public Builder setRestartAlgorithms(
        int index, com.google.ortools.sat.SatParameters.RestartAlgorithm value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRestartAlgorithmsIsMutable();
      restartAlgorithms_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The restart strategies will change each time the strategy_counter is
     * increased. The current strategy will simply be the one at index
     * strategy_counter modulo the number of strategy. Note that if this list
     * includes a NO_RESTART, nothing will change when it is reached because the
     * strategy_counter will only increment after a restart.
     *
     * The idea of switching of search strategy tailored for SAT/UNSAT comes from
     * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
     * But more generally, it seems REALLY beneficial to try different strategy.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
     * @param value The restartAlgorithms to add.
     * @return This builder for chaining.
     */
    public Builder addRestartAlgorithms(com.google.ortools.sat.SatParameters.RestartAlgorithm value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRestartAlgorithmsIsMutable();
      restartAlgorithms_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The restart strategies will change each time the strategy_counter is
     * increased. The current strategy will simply be the one at index
     * strategy_counter modulo the number of strategy. Note that if this list
     * includes a NO_RESTART, nothing will change when it is reached because the
     * strategy_counter will only increment after a restart.
     *
     * The idea of switching of search strategy tailored for SAT/UNSAT comes from
     * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
     * But more generally, it seems REALLY beneficial to try different strategy.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
     * @param values The restartAlgorithms to add.
     * @return This builder for chaining.
     */
    public Builder addAllRestartAlgorithms(
        java.lang.Iterable<? extends com.google.ortools.sat.SatParameters.RestartAlgorithm> values) {
      ensureRestartAlgorithmsIsMutable();
      for (com.google.ortools.sat.SatParameters.RestartAlgorithm value : values) {
        restartAlgorithms_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The restart strategies will change each time the strategy_counter is
     * increased. The current strategy will simply be the one at index
     * strategy_counter modulo the number of strategy. Note that if this list
     * includes a NO_RESTART, nothing will change when it is reached because the
     * strategy_counter will only increment after a restart.
     *
     * The idea of switching of search strategy tailored for SAT/UNSAT comes from
     * Chanseok Oh with his COMiniSatPS solver, see http://cs.nyu.edu/~chanseok/.
     * But more generally, it seems REALLY beneficial to try different strategy.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters.RestartAlgorithm restart_algorithms = 61;</code>
     * @return This builder for chaining.
     */
    public Builder clearRestartAlgorithms() {
      restartAlgorithms_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x10000000);
      onChanged();
      return this;
    }

    private java.lang.Object defaultRestartAlgorithms_ = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART";
    /**
     * <code>optional string default_restart_algorithms = 70 [default = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART"];</code>
     * @return Whether the defaultRestartAlgorithms field is set.
     */
    public boolean hasDefaultRestartAlgorithms() {
      return ((bitField0_ & 0x20000000) != 0);
    }
    /**
     * <code>optional string default_restart_algorithms = 70 [default = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART"];</code>
     * @return The defaultRestartAlgorithms.
     */
    public java.lang.String getDefaultRestartAlgorithms() {
      java.lang.Object ref = defaultRestartAlgorithms_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          defaultRestartAlgorithms_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <code>optional string default_restart_algorithms = 70 [default = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART"];</code>
     * @return The bytes for defaultRestartAlgorithms.
     */
    public com.google.protobuf.ByteString
        getDefaultRestartAlgorithmsBytes() {
      java.lang.Object ref = defaultRestartAlgorithms_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        defaultRestartAlgorithms_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <code>optional string default_restart_algorithms = 70 [default = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART"];</code>
     * @param value The defaultRestartAlgorithms to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultRestartAlgorithms(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      defaultRestartAlgorithms_ = value;
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     * <code>optional string default_restart_algorithms = 70 [default = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART"];</code>
     * @return This builder for chaining.
     */
    public Builder clearDefaultRestartAlgorithms() {
      defaultRestartAlgorithms_ = getDefaultInstance().getDefaultRestartAlgorithms();
      bitField0_ = (bitField0_ & ~0x20000000);
      onChanged();
      return this;
    }
    /**
     * <code>optional string default_restart_algorithms = 70 [default = "LUBY_RESTART,LBD_MOVING_AVERAGE_RESTART,DL_MOVING_AVERAGE_RESTART"];</code>
     * @param value The bytes for defaultRestartAlgorithms to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultRestartAlgorithmsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      defaultRestartAlgorithms_ = value;
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }

    private int restartPeriod_ = 50;
    /**
     * <pre>
     * Restart period for the FIXED_RESTART strategy. This is also the multiplier
     * used by the LUBY_RESTART strategy.
     * </pre>
     *
     * <code>optional int32 restart_period = 30 [default = 50];</code>
     * @return Whether the restartPeriod field is set.
     */
    @java.lang.Override
    public boolean hasRestartPeriod() {
      return ((bitField0_ & 0x40000000) != 0);
    }
    /**
     * <pre>
     * Restart period for the FIXED_RESTART strategy. This is also the multiplier
     * used by the LUBY_RESTART strategy.
     * </pre>
     *
     * <code>optional int32 restart_period = 30 [default = 50];</code>
     * @return The restartPeriod.
     */
    @java.lang.Override
    public int getRestartPeriod() {
      return restartPeriod_;
    }
    /**
     * <pre>
     * Restart period for the FIXED_RESTART strategy. This is also the multiplier
     * used by the LUBY_RESTART strategy.
     * </pre>
     *
     * <code>optional int32 restart_period = 30 [default = 50];</code>
     * @param value The restartPeriod to set.
     * @return This builder for chaining.
     */
    public Builder setRestartPeriod(int value) {

      restartPeriod_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Restart period for the FIXED_RESTART strategy. This is also the multiplier
     * used by the LUBY_RESTART strategy.
     * </pre>
     *
     * <code>optional int32 restart_period = 30 [default = 50];</code>
     * @return This builder for chaining.
     */
    public Builder clearRestartPeriod() {
      bitField0_ = (bitField0_ & ~0x40000000);
      restartPeriod_ = 50;
      onChanged();
      return this;
    }

    private int restartRunningWindowSize_ = 50;
    /**
     * <pre>
     * Size of the window for the moving average restarts.
     * </pre>
     *
     * <code>optional int32 restart_running_window_size = 62 [default = 50];</code>
     * @return Whether the restartRunningWindowSize field is set.
     */
    @java.lang.Override
    public boolean hasRestartRunningWindowSize() {
      return ((bitField0_ & 0x80000000) != 0);
    }
    /**
     * <pre>
     * Size of the window for the moving average restarts.
     * </pre>
     *
     * <code>optional int32 restart_running_window_size = 62 [default = 50];</code>
     * @return The restartRunningWindowSize.
     */
    @java.lang.Override
    public int getRestartRunningWindowSize() {
      return restartRunningWindowSize_;
    }
    /**
     * <pre>
     * Size of the window for the moving average restarts.
     * </pre>
     *
     * <code>optional int32 restart_running_window_size = 62 [default = 50];</code>
     * @param value The restartRunningWindowSize to set.
     * @return This builder for chaining.
     */
    public Builder setRestartRunningWindowSize(int value) {

      restartRunningWindowSize_ = value;
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Size of the window for the moving average restarts.
     * </pre>
     *
     * <code>optional int32 restart_running_window_size = 62 [default = 50];</code>
     * @return This builder for chaining.
     */
    public Builder clearRestartRunningWindowSize() {
      bitField0_ = (bitField0_ & ~0x80000000);
      restartRunningWindowSize_ = 50;
      onChanged();
      return this;
    }

    private double restartDlAverageRatio_ = 1D;
    /**
     * <pre>
     * In the moving average restart algorithms, a restart is triggered if the
     * window average times this ratio is greater that the global average.
     * </pre>
     *
     * <code>optional double restart_dl_average_ratio = 63 [default = 1];</code>
     * @return Whether the restartDlAverageRatio field is set.
     */
    @java.lang.Override
    public boolean hasRestartDlAverageRatio() {
      return ((bitField1_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * In the moving average restart algorithms, a restart is triggered if the
     * window average times this ratio is greater that the global average.
     * </pre>
     *
     * <code>optional double restart_dl_average_ratio = 63 [default = 1];</code>
     * @return The restartDlAverageRatio.
     */
    @java.lang.Override
    public double getRestartDlAverageRatio() {
      return restartDlAverageRatio_;
    }
    /**
     * <pre>
     * In the moving average restart algorithms, a restart is triggered if the
     * window average times this ratio is greater that the global average.
     * </pre>
     *
     * <code>optional double restart_dl_average_ratio = 63 [default = 1];</code>
     * @param value The restartDlAverageRatio to set.
     * @return This builder for chaining.
     */
    public Builder setRestartDlAverageRatio(double value) {

      restartDlAverageRatio_ = value;
      bitField1_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * In the moving average restart algorithms, a restart is triggered if the
     * window average times this ratio is greater that the global average.
     * </pre>
     *
     * <code>optional double restart_dl_average_ratio = 63 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearRestartDlAverageRatio() {
      bitField1_ = (bitField1_ & ~0x00000001);
      restartDlAverageRatio_ = 1D;
      onChanged();
      return this;
    }

    private double restartLbdAverageRatio_ = 1D;
    /**
     * <code>optional double restart_lbd_average_ratio = 71 [default = 1];</code>
     * @return Whether the restartLbdAverageRatio field is set.
     */
    @java.lang.Override
    public boolean hasRestartLbdAverageRatio() {
      return ((bitField1_ & 0x00000002) != 0);
    }
    /**
     * <code>optional double restart_lbd_average_ratio = 71 [default = 1];</code>
     * @return The restartLbdAverageRatio.
     */
    @java.lang.Override
    public double getRestartLbdAverageRatio() {
      return restartLbdAverageRatio_;
    }
    /**
     * <code>optional double restart_lbd_average_ratio = 71 [default = 1];</code>
     * @param value The restartLbdAverageRatio to set.
     * @return This builder for chaining.
     */
    public Builder setRestartLbdAverageRatio(double value) {

      restartLbdAverageRatio_ = value;
      bitField1_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <code>optional double restart_lbd_average_ratio = 71 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearRestartLbdAverageRatio() {
      bitField1_ = (bitField1_ & ~0x00000002);
      restartLbdAverageRatio_ = 1D;
      onChanged();
      return this;
    }

    private boolean useBlockingRestart_ ;
    /**
     * <pre>
     * Block a moving restart algorithm if the trail size of the current conflict
     * is greater than the multiplier times the moving average of the trail size
     * at the previous conflicts.
     * </pre>
     *
     * <code>optional bool use_blocking_restart = 64 [default = false];</code>
     * @return Whether the useBlockingRestart field is set.
     */
    @java.lang.Override
    public boolean hasUseBlockingRestart() {
      return ((bitField1_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * Block a moving restart algorithm if the trail size of the current conflict
     * is greater than the multiplier times the moving average of the trail size
     * at the previous conflicts.
     * </pre>
     *
     * <code>optional bool use_blocking_restart = 64 [default = false];</code>
     * @return The useBlockingRestart.
     */
    @java.lang.Override
    public boolean getUseBlockingRestart() {
      return useBlockingRestart_;
    }
    /**
     * <pre>
     * Block a moving restart algorithm if the trail size of the current conflict
     * is greater than the multiplier times the moving average of the trail size
     * at the previous conflicts.
     * </pre>
     *
     * <code>optional bool use_blocking_restart = 64 [default = false];</code>
     * @param value The useBlockingRestart to set.
     * @return This builder for chaining.
     */
    public Builder setUseBlockingRestart(boolean value) {

      useBlockingRestart_ = value;
      bitField1_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Block a moving restart algorithm if the trail size of the current conflict
     * is greater than the multiplier times the moving average of the trail size
     * at the previous conflicts.
     * </pre>
     *
     * <code>optional bool use_blocking_restart = 64 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseBlockingRestart() {
      bitField1_ = (bitField1_ & ~0x00000004);
      useBlockingRestart_ = false;
      onChanged();
      return this;
    }

    private int blockingRestartWindowSize_ = 5000;
    /**
     * <code>optional int32 blocking_restart_window_size = 65 [default = 5000];</code>
     * @return Whether the blockingRestartWindowSize field is set.
     */
    @java.lang.Override
    public boolean hasBlockingRestartWindowSize() {
      return ((bitField1_ & 0x00000008) != 0);
    }
    /**
     * <code>optional int32 blocking_restart_window_size = 65 [default = 5000];</code>
     * @return The blockingRestartWindowSize.
     */
    @java.lang.Override
    public int getBlockingRestartWindowSize() {
      return blockingRestartWindowSize_;
    }
    /**
     * <code>optional int32 blocking_restart_window_size = 65 [default = 5000];</code>
     * @param value The blockingRestartWindowSize to set.
     * @return This builder for chaining.
     */
    public Builder setBlockingRestartWindowSize(int value) {

      blockingRestartWindowSize_ = value;
      bitField1_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <code>optional int32 blocking_restart_window_size = 65 [default = 5000];</code>
     * @return This builder for chaining.
     */
    public Builder clearBlockingRestartWindowSize() {
      bitField1_ = (bitField1_ & ~0x00000008);
      blockingRestartWindowSize_ = 5000;
      onChanged();
      return this;
    }

    private double blockingRestartMultiplier_ = 1.4D;
    /**
     * <code>optional double blocking_restart_multiplier = 66 [default = 1.4];</code>
     * @return Whether the blockingRestartMultiplier field is set.
     */
    @java.lang.Override
    public boolean hasBlockingRestartMultiplier() {
      return ((bitField1_ & 0x00000010) != 0);
    }
    /**
     * <code>optional double blocking_restart_multiplier = 66 [default = 1.4];</code>
     * @return The blockingRestartMultiplier.
     */
    @java.lang.Override
    public double getBlockingRestartMultiplier() {
      return blockingRestartMultiplier_;
    }
    /**
     * <code>optional double blocking_restart_multiplier = 66 [default = 1.4];</code>
     * @param value The blockingRestartMultiplier to set.
     * @return This builder for chaining.
     */
    public Builder setBlockingRestartMultiplier(double value) {

      blockingRestartMultiplier_ = value;
      bitField1_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <code>optional double blocking_restart_multiplier = 66 [default = 1.4];</code>
     * @return This builder for chaining.
     */
    public Builder clearBlockingRestartMultiplier() {
      bitField1_ = (bitField1_ & ~0x00000010);
      blockingRestartMultiplier_ = 1.4D;
      onChanged();
      return this;
    }

    private int numConflictsBeforeStrategyChanges_ ;
    /**
     * <pre>
     * After each restart, if the number of conflict since the last strategy
     * change is greater that this, then we increment a "strategy_counter" that
     * can be use to change the search strategy used by the following restarts.
     * </pre>
     *
     * <code>optional int32 num_conflicts_before_strategy_changes = 68 [default = 0];</code>
     * @return Whether the numConflictsBeforeStrategyChanges field is set.
     */
    @java.lang.Override
    public boolean hasNumConflictsBeforeStrategyChanges() {
      return ((bitField1_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * After each restart, if the number of conflict since the last strategy
     * change is greater that this, then we increment a "strategy_counter" that
     * can be use to change the search strategy used by the following restarts.
     * </pre>
     *
     * <code>optional int32 num_conflicts_before_strategy_changes = 68 [default = 0];</code>
     * @return The numConflictsBeforeStrategyChanges.
     */
    @java.lang.Override
    public int getNumConflictsBeforeStrategyChanges() {
      return numConflictsBeforeStrategyChanges_;
    }
    /**
     * <pre>
     * After each restart, if the number of conflict since the last strategy
     * change is greater that this, then we increment a "strategy_counter" that
     * can be use to change the search strategy used by the following restarts.
     * </pre>
     *
     * <code>optional int32 num_conflicts_before_strategy_changes = 68 [default = 0];</code>
     * @param value The numConflictsBeforeStrategyChanges to set.
     * @return This builder for chaining.
     */
    public Builder setNumConflictsBeforeStrategyChanges(int value) {

      numConflictsBeforeStrategyChanges_ = value;
      bitField1_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * After each restart, if the number of conflict since the last strategy
     * change is greater that this, then we increment a "strategy_counter" that
     * can be use to change the search strategy used by the following restarts.
     * </pre>
     *
     * <code>optional int32 num_conflicts_before_strategy_changes = 68 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearNumConflictsBeforeStrategyChanges() {
      bitField1_ = (bitField1_ & ~0x00000020);
      numConflictsBeforeStrategyChanges_ = 0;
      onChanged();
      return this;
    }

    private double strategyChangeIncreaseRatio_ ;
    /**
     * <pre>
     * The parameter num_conflicts_before_strategy_changes is increased by that
     * much after each strategy change.
     * </pre>
     *
     * <code>optional double strategy_change_increase_ratio = 69 [default = 0];</code>
     * @return Whether the strategyChangeIncreaseRatio field is set.
     */
    @java.lang.Override
    public boolean hasStrategyChangeIncreaseRatio() {
      return ((bitField1_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * The parameter num_conflicts_before_strategy_changes is increased by that
     * much after each strategy change.
     * </pre>
     *
     * <code>optional double strategy_change_increase_ratio = 69 [default = 0];</code>
     * @return The strategyChangeIncreaseRatio.
     */
    @java.lang.Override
    public double getStrategyChangeIncreaseRatio() {
      return strategyChangeIncreaseRatio_;
    }
    /**
     * <pre>
     * The parameter num_conflicts_before_strategy_changes is increased by that
     * much after each strategy change.
     * </pre>
     *
     * <code>optional double strategy_change_increase_ratio = 69 [default = 0];</code>
     * @param value The strategyChangeIncreaseRatio to set.
     * @return This builder for chaining.
     */
    public Builder setStrategyChangeIncreaseRatio(double value) {

      strategyChangeIncreaseRatio_ = value;
      bitField1_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The parameter num_conflicts_before_strategy_changes is increased by that
     * much after each strategy change.
     * </pre>
     *
     * <code>optional double strategy_change_increase_ratio = 69 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearStrategyChangeIncreaseRatio() {
      bitField1_ = (bitField1_ & ~0x00000040);
      strategyChangeIncreaseRatio_ = 0D;
      onChanged();
      return this;
    }

    private double maxTimeInSeconds_ = Double.POSITIVE_INFINITY;
    /**
     * <pre>
     * Maximum time allowed in seconds to solve a problem.
     * The counter will starts at the beginning of the Solve() call.
     * </pre>
     *
     * <code>optional double max_time_in_seconds = 36 [default = inf];</code>
     * @return Whether the maxTimeInSeconds field is set.
     */
    @java.lang.Override
    public boolean hasMaxTimeInSeconds() {
      return ((bitField1_ & 0x00000080) != 0);
    }
    /**
     * <pre>
     * Maximum time allowed in seconds to solve a problem.
     * The counter will starts at the beginning of the Solve() call.
     * </pre>
     *
     * <code>optional double max_time_in_seconds = 36 [default = inf];</code>
     * @return The maxTimeInSeconds.
     */
    @java.lang.Override
    public double getMaxTimeInSeconds() {
      return maxTimeInSeconds_;
    }
    /**
     * <pre>
     * Maximum time allowed in seconds to solve a problem.
     * The counter will starts at the beginning of the Solve() call.
     * </pre>
     *
     * <code>optional double max_time_in_seconds = 36 [default = inf];</code>
     * @param value The maxTimeInSeconds to set.
     * @return This builder for chaining.
     */
    public Builder setMaxTimeInSeconds(double value) {

      maxTimeInSeconds_ = value;
      bitField1_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Maximum time allowed in seconds to solve a problem.
     * The counter will starts at the beginning of the Solve() call.
     * </pre>
     *
     * <code>optional double max_time_in_seconds = 36 [default = inf];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxTimeInSeconds() {
      bitField1_ = (bitField1_ & ~0x00000080);
      maxTimeInSeconds_ = Double.POSITIVE_INFINITY;
      onChanged();
      return this;
    }

    private double maxDeterministicTime_ = Double.POSITIVE_INFINITY;
    /**
     * <pre>
     * Maximum time allowed in deterministic time to solve a problem.
     * The deterministic time should be correlated with the real time used by the
     * solver, the time unit being as close as possible to a second.
     * </pre>
     *
     * <code>optional double max_deterministic_time = 67 [default = inf];</code>
     * @return Whether the maxDeterministicTime field is set.
     */
    @java.lang.Override
    public boolean hasMaxDeterministicTime() {
      return ((bitField1_ & 0x00000100) != 0);
    }
    /**
     * <pre>
     * Maximum time allowed in deterministic time to solve a problem.
     * The deterministic time should be correlated with the real time used by the
     * solver, the time unit being as close as possible to a second.
     * </pre>
     *
     * <code>optional double max_deterministic_time = 67 [default = inf];</code>
     * @return The maxDeterministicTime.
     */
    @java.lang.Override
    public double getMaxDeterministicTime() {
      return maxDeterministicTime_;
    }
    /**
     * <pre>
     * Maximum time allowed in deterministic time to solve a problem.
     * The deterministic time should be correlated with the real time used by the
     * solver, the time unit being as close as possible to a second.
     * </pre>
     *
     * <code>optional double max_deterministic_time = 67 [default = inf];</code>
     * @param value The maxDeterministicTime to set.
     * @return This builder for chaining.
     */
    public Builder setMaxDeterministicTime(double value) {

      maxDeterministicTime_ = value;
      bitField1_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Maximum time allowed in deterministic time to solve a problem.
     * The deterministic time should be correlated with the real time used by the
     * solver, the time unit being as close as possible to a second.
     * </pre>
     *
     * <code>optional double max_deterministic_time = 67 [default = inf];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxDeterministicTime() {
      bitField1_ = (bitField1_ & ~0x00000100);
      maxDeterministicTime_ = Double.POSITIVE_INFINITY;
      onChanged();
      return this;
    }

    private int maxNumDeterministicBatches_ ;
    /**
     * <pre>
     * Stops after that number of batches has been scheduled. This only make sense
     * when interleave_search is true.
     * </pre>
     *
     * <code>optional int32 max_num_deterministic_batches = 291 [default = 0];</code>
     * @return Whether the maxNumDeterministicBatches field is set.
     */
    @java.lang.Override
    public boolean hasMaxNumDeterministicBatches() {
      return ((bitField1_ & 0x00000200) != 0);
    }
    /**
     * <pre>
     * Stops after that number of batches has been scheduled. This only make sense
     * when interleave_search is true.
     * </pre>
     *
     * <code>optional int32 max_num_deterministic_batches = 291 [default = 0];</code>
     * @return The maxNumDeterministicBatches.
     */
    @java.lang.Override
    public int getMaxNumDeterministicBatches() {
      return maxNumDeterministicBatches_;
    }
    /**
     * <pre>
     * Stops after that number of batches has been scheduled. This only make sense
     * when interleave_search is true.
     * </pre>
     *
     * <code>optional int32 max_num_deterministic_batches = 291 [default = 0];</code>
     * @param value The maxNumDeterministicBatches to set.
     * @return This builder for chaining.
     */
    public Builder setMaxNumDeterministicBatches(int value) {

      maxNumDeterministicBatches_ = value;
      bitField1_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Stops after that number of batches has been scheduled. This only make sense
     * when interleave_search is true.
     * </pre>
     *
     * <code>optional int32 max_num_deterministic_batches = 291 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxNumDeterministicBatches() {
      bitField1_ = (bitField1_ & ~0x00000200);
      maxNumDeterministicBatches_ = 0;
      onChanged();
      return this;
    }

    private long maxNumberOfConflicts_ = 9223372036854775807L;
    /**
     * <pre>
     * Maximum number of conflicts allowed to solve a problem.
     *
     * TODO(user): Maybe change the way the conflict limit is enforced?
     * currently it is enforced on each independent internal SAT solve, rather
     * than on the overall number of conflicts across all solves. So in the
     * context of an optimization problem, this is not really usable directly by a
     * client.
     * </pre>
     *
     * <code>optional int64 max_number_of_conflicts = 37 [default = 9223372036854775807];</code>
     * @return Whether the maxNumberOfConflicts field is set.
     */
    @java.lang.Override
    public boolean hasMaxNumberOfConflicts() {
      return ((bitField1_ & 0x00000400) != 0);
    }
    /**
     * <pre>
     * Maximum number of conflicts allowed to solve a problem.
     *
     * TODO(user): Maybe change the way the conflict limit is enforced?
     * currently it is enforced on each independent internal SAT solve, rather
     * than on the overall number of conflicts across all solves. So in the
     * context of an optimization problem, this is not really usable directly by a
     * client.
     * </pre>
     *
     * <code>optional int64 max_number_of_conflicts = 37 [default = 9223372036854775807];</code>
     * @return The maxNumberOfConflicts.
     */
    @java.lang.Override
    public long getMaxNumberOfConflicts() {
      return maxNumberOfConflicts_;
    }
    /**
     * <pre>
     * Maximum number of conflicts allowed to solve a problem.
     *
     * TODO(user): Maybe change the way the conflict limit is enforced?
     * currently it is enforced on each independent internal SAT solve, rather
     * than on the overall number of conflicts across all solves. So in the
     * context of an optimization problem, this is not really usable directly by a
     * client.
     * </pre>
     *
     * <code>optional int64 max_number_of_conflicts = 37 [default = 9223372036854775807];</code>
     * @param value The maxNumberOfConflicts to set.
     * @return This builder for chaining.
     */
    public Builder setMaxNumberOfConflicts(long value) {

      maxNumberOfConflicts_ = value;
      bitField1_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Maximum number of conflicts allowed to solve a problem.
     *
     * TODO(user): Maybe change the way the conflict limit is enforced?
     * currently it is enforced on each independent internal SAT solve, rather
     * than on the overall number of conflicts across all solves. So in the
     * context of an optimization problem, this is not really usable directly by a
     * client.
     * </pre>
     *
     * <code>optional int64 max_number_of_conflicts = 37 [default = 9223372036854775807];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxNumberOfConflicts() {
      bitField1_ = (bitField1_ & ~0x00000400);
      maxNumberOfConflicts_ = 9223372036854775807L;
      onChanged();
      return this;
    }

    private long maxMemoryInMb_ = 10000L;
    /**
     * <pre>
     * Maximum memory allowed for the whole thread containing the solver. The
     * solver will abort as soon as it detects that this limit is crossed. As a
     * result, this limit is approximative, but usually the solver will not go too
     * much over.
     *
     * TODO(user): This is only used by the pure SAT solver, generalize to CP-SAT.
     * </pre>
     *
     * <code>optional int64 max_memory_in_mb = 40 [default = 10000];</code>
     * @return Whether the maxMemoryInMb field is set.
     */
    @java.lang.Override
    public boolean hasMaxMemoryInMb() {
      return ((bitField1_ & 0x00000800) != 0);
    }
    /**
     * <pre>
     * Maximum memory allowed for the whole thread containing the solver. The
     * solver will abort as soon as it detects that this limit is crossed. As a
     * result, this limit is approximative, but usually the solver will not go too
     * much over.
     *
     * TODO(user): This is only used by the pure SAT solver, generalize to CP-SAT.
     * </pre>
     *
     * <code>optional int64 max_memory_in_mb = 40 [default = 10000];</code>
     * @return The maxMemoryInMb.
     */
    @java.lang.Override
    public long getMaxMemoryInMb() {
      return maxMemoryInMb_;
    }
    /**
     * <pre>
     * Maximum memory allowed for the whole thread containing the solver. The
     * solver will abort as soon as it detects that this limit is crossed. As a
     * result, this limit is approximative, but usually the solver will not go too
     * much over.
     *
     * TODO(user): This is only used by the pure SAT solver, generalize to CP-SAT.
     * </pre>
     *
     * <code>optional int64 max_memory_in_mb = 40 [default = 10000];</code>
     * @param value The maxMemoryInMb to set.
     * @return This builder for chaining.
     */
    public Builder setMaxMemoryInMb(long value) {

      maxMemoryInMb_ = value;
      bitField1_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Maximum memory allowed for the whole thread containing the solver. The
     * solver will abort as soon as it detects that this limit is crossed. As a
     * result, this limit is approximative, but usually the solver will not go too
     * much over.
     *
     * TODO(user): This is only used by the pure SAT solver, generalize to CP-SAT.
     * </pre>
     *
     * <code>optional int64 max_memory_in_mb = 40 [default = 10000];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxMemoryInMb() {
      bitField1_ = (bitField1_ & ~0x00000800);
      maxMemoryInMb_ = 10000L;
      onChanged();
      return this;
    }

    private double absoluteGapLimit_ = 0.0001D;
    /**
     * <pre>
     * Stop the search when the gap between the best feasible objective (O) and
     * our best objective bound (B) is smaller than a limit.
     * The exact definition is:
     * - Absolute: abs(O - B)
     * - Relative: abs(O - B) / max(1, abs(O)).
     *
     * Important: The relative gap depends on the objective offset! If you
     * artificially shift the objective, you will get widely different value of
     * the relative gap.
     *
     * Note that if the gap is reached, the search status will be OPTIMAL. But
     * one can check the best objective bound to see the actual gap.
     *
     * If the objective is integer, then any absolute gap &lt; 1 will lead to a true
     * optimal. If the objective is floating point, a gap of zero make little
     * sense so is is why we use a non-zero default value. At the end of the
     * search, we will display a warning if OPTIMAL is reported yet the gap is
     * greater than this absolute gap.
     * </pre>
     *
     * <code>optional double absolute_gap_limit = 159 [default = 0.0001];</code>
     * @return Whether the absoluteGapLimit field is set.
     */
    @java.lang.Override
    public boolean hasAbsoluteGapLimit() {
      return ((bitField1_ & 0x00001000) != 0);
    }
    /**
     * <pre>
     * Stop the search when the gap between the best feasible objective (O) and
     * our best objective bound (B) is smaller than a limit.
     * The exact definition is:
     * - Absolute: abs(O - B)
     * - Relative: abs(O - B) / max(1, abs(O)).
     *
     * Important: The relative gap depends on the objective offset! If you
     * artificially shift the objective, you will get widely different value of
     * the relative gap.
     *
     * Note that if the gap is reached, the search status will be OPTIMAL. But
     * one can check the best objective bound to see the actual gap.
     *
     * If the objective is integer, then any absolute gap &lt; 1 will lead to a true
     * optimal. If the objective is floating point, a gap of zero make little
     * sense so is is why we use a non-zero default value. At the end of the
     * search, we will display a warning if OPTIMAL is reported yet the gap is
     * greater than this absolute gap.
     * </pre>
     *
     * <code>optional double absolute_gap_limit = 159 [default = 0.0001];</code>
     * @return The absoluteGapLimit.
     */
    @java.lang.Override
    public double getAbsoluteGapLimit() {
      return absoluteGapLimit_;
    }
    /**
     * <pre>
     * Stop the search when the gap between the best feasible objective (O) and
     * our best objective bound (B) is smaller than a limit.
     * The exact definition is:
     * - Absolute: abs(O - B)
     * - Relative: abs(O - B) / max(1, abs(O)).
     *
     * Important: The relative gap depends on the objective offset! If you
     * artificially shift the objective, you will get widely different value of
     * the relative gap.
     *
     * Note that if the gap is reached, the search status will be OPTIMAL. But
     * one can check the best objective bound to see the actual gap.
     *
     * If the objective is integer, then any absolute gap &lt; 1 will lead to a true
     * optimal. If the objective is floating point, a gap of zero make little
     * sense so is is why we use a non-zero default value. At the end of the
     * search, we will display a warning if OPTIMAL is reported yet the gap is
     * greater than this absolute gap.
     * </pre>
     *
     * <code>optional double absolute_gap_limit = 159 [default = 0.0001];</code>
     * @param value The absoluteGapLimit to set.
     * @return This builder for chaining.
     */
    public Builder setAbsoluteGapLimit(double value) {

      absoluteGapLimit_ = value;
      bitField1_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Stop the search when the gap between the best feasible objective (O) and
     * our best objective bound (B) is smaller than a limit.
     * The exact definition is:
     * - Absolute: abs(O - B)
     * - Relative: abs(O - B) / max(1, abs(O)).
     *
     * Important: The relative gap depends on the objective offset! If you
     * artificially shift the objective, you will get widely different value of
     * the relative gap.
     *
     * Note that if the gap is reached, the search status will be OPTIMAL. But
     * one can check the best objective bound to see the actual gap.
     *
     * If the objective is integer, then any absolute gap &lt; 1 will lead to a true
     * optimal. If the objective is floating point, a gap of zero make little
     * sense so is is why we use a non-zero default value. At the end of the
     * search, we will display a warning if OPTIMAL is reported yet the gap is
     * greater than this absolute gap.
     * </pre>
     *
     * <code>optional double absolute_gap_limit = 159 [default = 0.0001];</code>
     * @return This builder for chaining.
     */
    public Builder clearAbsoluteGapLimit() {
      bitField1_ = (bitField1_ & ~0x00001000);
      absoluteGapLimit_ = 0.0001D;
      onChanged();
      return this;
    }

    private double relativeGapLimit_ ;
    /**
     * <code>optional double relative_gap_limit = 160 [default = 0];</code>
     * @return Whether the relativeGapLimit field is set.
     */
    @java.lang.Override
    public boolean hasRelativeGapLimit() {
      return ((bitField1_ & 0x00002000) != 0);
    }
    /**
     * <code>optional double relative_gap_limit = 160 [default = 0];</code>
     * @return The relativeGapLimit.
     */
    @java.lang.Override
    public double getRelativeGapLimit() {
      return relativeGapLimit_;
    }
    /**
     * <code>optional double relative_gap_limit = 160 [default = 0];</code>
     * @param value The relativeGapLimit to set.
     * @return This builder for chaining.
     */
    public Builder setRelativeGapLimit(double value) {

      relativeGapLimit_ = value;
      bitField1_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     * <code>optional double relative_gap_limit = 160 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearRelativeGapLimit() {
      bitField1_ = (bitField1_ & ~0x00002000);
      relativeGapLimit_ = 0D;
      onChanged();
      return this;
    }

    private int randomSeed_ = 1;
    /**
     * <pre>
     * At the beginning of each solve, the random number generator used in some
     * part of the solver is reinitialized to this seed. If you change the random
     * seed, the solver may make different choices during the solving process.
     *
     * For some problems, the running time may vary a lot depending on small
     * change in the solving algorithm. Running the solver with different seeds
     * enables to have more robust benchmarks when evaluating new features.
     * </pre>
     *
     * <code>optional int32 random_seed = 31 [default = 1];</code>
     * @return Whether the randomSeed field is set.
     */
    @java.lang.Override
    public boolean hasRandomSeed() {
      return ((bitField1_ & 0x00004000) != 0);
    }
    /**
     * <pre>
     * At the beginning of each solve, the random number generator used in some
     * part of the solver is reinitialized to this seed. If you change the random
     * seed, the solver may make different choices during the solving process.
     *
     * For some problems, the running time may vary a lot depending on small
     * change in the solving algorithm. Running the solver with different seeds
     * enables to have more robust benchmarks when evaluating new features.
     * </pre>
     *
     * <code>optional int32 random_seed = 31 [default = 1];</code>
     * @return The randomSeed.
     */
    @java.lang.Override
    public int getRandomSeed() {
      return randomSeed_;
    }
    /**
     * <pre>
     * At the beginning of each solve, the random number generator used in some
     * part of the solver is reinitialized to this seed. If you change the random
     * seed, the solver may make different choices during the solving process.
     *
     * For some problems, the running time may vary a lot depending on small
     * change in the solving algorithm. Running the solver with different seeds
     * enables to have more robust benchmarks when evaluating new features.
     * </pre>
     *
     * <code>optional int32 random_seed = 31 [default = 1];</code>
     * @param value The randomSeed to set.
     * @return This builder for chaining.
     */
    public Builder setRandomSeed(int value) {

      randomSeed_ = value;
      bitField1_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * At the beginning of each solve, the random number generator used in some
     * part of the solver is reinitialized to this seed. If you change the random
     * seed, the solver may make different choices during the solving process.
     *
     * For some problems, the running time may vary a lot depending on small
     * change in the solving algorithm. Running the solver with different seeds
     * enables to have more robust benchmarks when evaluating new features.
     * </pre>
     *
     * <code>optional int32 random_seed = 31 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearRandomSeed() {
      bitField1_ = (bitField1_ & ~0x00004000);
      randomSeed_ = 1;
      onChanged();
      return this;
    }

    private boolean permuteVariableRandomly_ ;
    /**
     * <pre>
     * This is mainly here to test the solver variability. Note that in tests, if
     * not explicitly set to false, all 3 options will be set to true so that
     * clients do not rely on the solver returning a specific solution if they are
     * many equivalent optimal solutions.
     * </pre>
     *
     * <code>optional bool permute_variable_randomly = 178 [default = false];</code>
     * @return Whether the permuteVariableRandomly field is set.
     */
    @java.lang.Override
    public boolean hasPermuteVariableRandomly() {
      return ((bitField1_ & 0x00008000) != 0);
    }
    /**
     * <pre>
     * This is mainly here to test the solver variability. Note that in tests, if
     * not explicitly set to false, all 3 options will be set to true so that
     * clients do not rely on the solver returning a specific solution if they are
     * many equivalent optimal solutions.
     * </pre>
     *
     * <code>optional bool permute_variable_randomly = 178 [default = false];</code>
     * @return The permuteVariableRandomly.
     */
    @java.lang.Override
    public boolean getPermuteVariableRandomly() {
      return permuteVariableRandomly_;
    }
    /**
     * <pre>
     * This is mainly here to test the solver variability. Note that in tests, if
     * not explicitly set to false, all 3 options will be set to true so that
     * clients do not rely on the solver returning a specific solution if they are
     * many equivalent optimal solutions.
     * </pre>
     *
     * <code>optional bool permute_variable_randomly = 178 [default = false];</code>
     * @param value The permuteVariableRandomly to set.
     * @return This builder for chaining.
     */
    public Builder setPermuteVariableRandomly(boolean value) {

      permuteVariableRandomly_ = value;
      bitField1_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * This is mainly here to test the solver variability. Note that in tests, if
     * not explicitly set to false, all 3 options will be set to true so that
     * clients do not rely on the solver returning a specific solution if they are
     * many equivalent optimal solutions.
     * </pre>
     *
     * <code>optional bool permute_variable_randomly = 178 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearPermuteVariableRandomly() {
      bitField1_ = (bitField1_ & ~0x00008000);
      permuteVariableRandomly_ = false;
      onChanged();
      return this;
    }

    private boolean permutePresolveConstraintOrder_ ;
    /**
     * <code>optional bool permute_presolve_constraint_order = 179 [default = false];</code>
     * @return Whether the permutePresolveConstraintOrder field is set.
     */
    @java.lang.Override
    public boolean hasPermutePresolveConstraintOrder() {
      return ((bitField1_ & 0x00010000) != 0);
    }
    /**
     * <code>optional bool permute_presolve_constraint_order = 179 [default = false];</code>
     * @return The permutePresolveConstraintOrder.
     */
    @java.lang.Override
    public boolean getPermutePresolveConstraintOrder() {
      return permutePresolveConstraintOrder_;
    }
    /**
     * <code>optional bool permute_presolve_constraint_order = 179 [default = false];</code>
     * @param value The permutePresolveConstraintOrder to set.
     * @return This builder for chaining.
     */
    public Builder setPermutePresolveConstraintOrder(boolean value) {

      permutePresolveConstraintOrder_ = value;
      bitField1_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     * <code>optional bool permute_presolve_constraint_order = 179 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearPermutePresolveConstraintOrder() {
      bitField1_ = (bitField1_ & ~0x00010000);
      permutePresolveConstraintOrder_ = false;
      onChanged();
      return this;
    }

    private boolean useAbslRandom_ ;
    /**
     * <code>optional bool use_absl_random = 180 [default = false];</code>
     * @return Whether the useAbslRandom field is set.
     */
    @java.lang.Override
    public boolean hasUseAbslRandom() {
      return ((bitField1_ & 0x00020000) != 0);
    }
    /**
     * <code>optional bool use_absl_random = 180 [default = false];</code>
     * @return The useAbslRandom.
     */
    @java.lang.Override
    public boolean getUseAbslRandom() {
      return useAbslRandom_;
    }
    /**
     * <code>optional bool use_absl_random = 180 [default = false];</code>
     * @param value The useAbslRandom to set.
     * @return This builder for chaining.
     */
    public Builder setUseAbslRandom(boolean value) {

      useAbslRandom_ = value;
      bitField1_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     * <code>optional bool use_absl_random = 180 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseAbslRandom() {
      bitField1_ = (bitField1_ & ~0x00020000);
      useAbslRandom_ = false;
      onChanged();
      return this;
    }

    private boolean logSearchProgress_ ;
    /**
     * <pre>
     * Whether the solver should log the search progress. This is the maing
     * logging parameter and if this is false, none of the logging (callbacks,
     * log_to_stdout, log_to_response, ...) will do anything.
     * </pre>
     *
     * <code>optional bool log_search_progress = 41 [default = false];</code>
     * @return Whether the logSearchProgress field is set.
     */
    @java.lang.Override
    public boolean hasLogSearchProgress() {
      return ((bitField1_ & 0x00040000) != 0);
    }
    /**
     * <pre>
     * Whether the solver should log the search progress. This is the maing
     * logging parameter and if this is false, none of the logging (callbacks,
     * log_to_stdout, log_to_response, ...) will do anything.
     * </pre>
     *
     * <code>optional bool log_search_progress = 41 [default = false];</code>
     * @return The logSearchProgress.
     */
    @java.lang.Override
    public boolean getLogSearchProgress() {
      return logSearchProgress_;
    }
    /**
     * <pre>
     * Whether the solver should log the search progress. This is the maing
     * logging parameter and if this is false, none of the logging (callbacks,
     * log_to_stdout, log_to_response, ...) will do anything.
     * </pre>
     *
     * <code>optional bool log_search_progress = 41 [default = false];</code>
     * @param value The logSearchProgress to set.
     * @return This builder for chaining.
     */
    public Builder setLogSearchProgress(boolean value) {

      logSearchProgress_ = value;
      bitField1_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether the solver should log the search progress. This is the maing
     * logging parameter and if this is false, none of the logging (callbacks,
     * log_to_stdout, log_to_response, ...) will do anything.
     * </pre>
     *
     * <code>optional bool log_search_progress = 41 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearLogSearchProgress() {
      bitField1_ = (bitField1_ & ~0x00040000);
      logSearchProgress_ = false;
      onChanged();
      return this;
    }

    private boolean logSubsolverStatistics_ ;
    /**
     * <pre>
     * Whether the solver should display per sub-solver search statistics.
     * This is only useful is log_search_progress is set to true, and if the
     * number of search workers is &gt; 1. Note that in all case we display a bit
     * of stats with one line per subsolver.
     * </pre>
     *
     * <code>optional bool log_subsolver_statistics = 189 [default = false];</code>
     * @return Whether the logSubsolverStatistics field is set.
     */
    @java.lang.Override
    public boolean hasLogSubsolverStatistics() {
      return ((bitField1_ & 0x00080000) != 0);
    }
    /**
     * <pre>
     * Whether the solver should display per sub-solver search statistics.
     * This is only useful is log_search_progress is set to true, and if the
     * number of search workers is &gt; 1. Note that in all case we display a bit
     * of stats with one line per subsolver.
     * </pre>
     *
     * <code>optional bool log_subsolver_statistics = 189 [default = false];</code>
     * @return The logSubsolverStatistics.
     */
    @java.lang.Override
    public boolean getLogSubsolverStatistics() {
      return logSubsolverStatistics_;
    }
    /**
     * <pre>
     * Whether the solver should display per sub-solver search statistics.
     * This is only useful is log_search_progress is set to true, and if the
     * number of search workers is &gt; 1. Note that in all case we display a bit
     * of stats with one line per subsolver.
     * </pre>
     *
     * <code>optional bool log_subsolver_statistics = 189 [default = false];</code>
     * @param value The logSubsolverStatistics to set.
     * @return This builder for chaining.
     */
    public Builder setLogSubsolverStatistics(boolean value) {

      logSubsolverStatistics_ = value;
      bitField1_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether the solver should display per sub-solver search statistics.
     * This is only useful is log_search_progress is set to true, and if the
     * number of search workers is &gt; 1. Note that in all case we display a bit
     * of stats with one line per subsolver.
     * </pre>
     *
     * <code>optional bool log_subsolver_statistics = 189 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearLogSubsolverStatistics() {
      bitField1_ = (bitField1_ & ~0x00080000);
      logSubsolverStatistics_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object logPrefix_ = "";
    /**
     * <pre>
     * Add a prefix to all logs.
     * </pre>
     *
     * <code>optional string log_prefix = 185 [default = ""];</code>
     * @return Whether the logPrefix field is set.
     */
    public boolean hasLogPrefix() {
      return ((bitField1_ & 0x00100000) != 0);
    }
    /**
     * <pre>
     * Add a prefix to all logs.
     * </pre>
     *
     * <code>optional string log_prefix = 185 [default = ""];</code>
     * @return The logPrefix.
     */
    public java.lang.String getLogPrefix() {
      java.lang.Object ref = logPrefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          logPrefix_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Add a prefix to all logs.
     * </pre>
     *
     * <code>optional string log_prefix = 185 [default = ""];</code>
     * @return The bytes for logPrefix.
     */
    public com.google.protobuf.ByteString
        getLogPrefixBytes() {
      java.lang.Object ref = logPrefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        logPrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Add a prefix to all logs.
     * </pre>
     *
     * <code>optional string log_prefix = 185 [default = ""];</code>
     * @param value The logPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setLogPrefix(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      logPrefix_ = value;
      bitField1_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Add a prefix to all logs.
     * </pre>
     *
     * <code>optional string log_prefix = 185 [default = ""];</code>
     * @return This builder for chaining.
     */
    public Builder clearLogPrefix() {
      logPrefix_ = getDefaultInstance().getLogPrefix();
      bitField1_ = (bitField1_ & ~0x00100000);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Add a prefix to all logs.
     * </pre>
     *
     * <code>optional string log_prefix = 185 [default = ""];</code>
     * @param value The bytes for logPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setLogPrefixBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      logPrefix_ = value;
      bitField1_ |= 0x00100000;
      onChanged();
      return this;
    }

    private boolean logToStdout_ = true;
    /**
     * <pre>
     * Log to stdout.
     * </pre>
     *
     * <code>optional bool log_to_stdout = 186 [default = true];</code>
     * @return Whether the logToStdout field is set.
     */
    @java.lang.Override
    public boolean hasLogToStdout() {
      return ((bitField1_ & 0x00200000) != 0);
    }
    /**
     * <pre>
     * Log to stdout.
     * </pre>
     *
     * <code>optional bool log_to_stdout = 186 [default = true];</code>
     * @return The logToStdout.
     */
    @java.lang.Override
    public boolean getLogToStdout() {
      return logToStdout_;
    }
    /**
     * <pre>
     * Log to stdout.
     * </pre>
     *
     * <code>optional bool log_to_stdout = 186 [default = true];</code>
     * @param value The logToStdout to set.
     * @return This builder for chaining.
     */
    public Builder setLogToStdout(boolean value) {

      logToStdout_ = value;
      bitField1_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Log to stdout.
     * </pre>
     *
     * <code>optional bool log_to_stdout = 186 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearLogToStdout() {
      bitField1_ = (bitField1_ & ~0x00200000);
      logToStdout_ = true;
      onChanged();
      return this;
    }

    private boolean logToResponse_ ;
    /**
     * <pre>
     * Log to response proto.
     * </pre>
     *
     * <code>optional bool log_to_response = 187 [default = false];</code>
     * @return Whether the logToResponse field is set.
     */
    @java.lang.Override
    public boolean hasLogToResponse() {
      return ((bitField1_ & 0x00400000) != 0);
    }
    /**
     * <pre>
     * Log to response proto.
     * </pre>
     *
     * <code>optional bool log_to_response = 187 [default = false];</code>
     * @return The logToResponse.
     */
    @java.lang.Override
    public boolean getLogToResponse() {
      return logToResponse_;
    }
    /**
     * <pre>
     * Log to response proto.
     * </pre>
     *
     * <code>optional bool log_to_response = 187 [default = false];</code>
     * @param value The logToResponse to set.
     * @return This builder for chaining.
     */
    public Builder setLogToResponse(boolean value) {

      logToResponse_ = value;
      bitField1_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Log to response proto.
     * </pre>
     *
     * <code>optional bool log_to_response = 187 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearLogToResponse() {
      bitField1_ = (bitField1_ & ~0x00400000);
      logToResponse_ = false;
      onChanged();
      return this;
    }

    private boolean usePbResolution_ ;
    /**
     * <pre>
     * Whether to use pseudo-Boolean resolution to analyze a conflict. Note that
     * this option only make sense if your problem is modelized using
     * pseudo-Boolean constraints. If you only have clauses, this shouldn't change
     * anything (except slow the solver down).
     * </pre>
     *
     * <code>optional bool use_pb_resolution = 43 [default = false];</code>
     * @return Whether the usePbResolution field is set.
     */
    @java.lang.Override
    public boolean hasUsePbResolution() {
      return ((bitField1_ & 0x00800000) != 0);
    }
    /**
     * <pre>
     * Whether to use pseudo-Boolean resolution to analyze a conflict. Note that
     * this option only make sense if your problem is modelized using
     * pseudo-Boolean constraints. If you only have clauses, this shouldn't change
     * anything (except slow the solver down).
     * </pre>
     *
     * <code>optional bool use_pb_resolution = 43 [default = false];</code>
     * @return The usePbResolution.
     */
    @java.lang.Override
    public boolean getUsePbResolution() {
      return usePbResolution_;
    }
    /**
     * <pre>
     * Whether to use pseudo-Boolean resolution to analyze a conflict. Note that
     * this option only make sense if your problem is modelized using
     * pseudo-Boolean constraints. If you only have clauses, this shouldn't change
     * anything (except slow the solver down).
     * </pre>
     *
     * <code>optional bool use_pb_resolution = 43 [default = false];</code>
     * @param value The usePbResolution to set.
     * @return This builder for chaining.
     */
    public Builder setUsePbResolution(boolean value) {

      usePbResolution_ = value;
      bitField1_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether to use pseudo-Boolean resolution to analyze a conflict. Note that
     * this option only make sense if your problem is modelized using
     * pseudo-Boolean constraints. If you only have clauses, this shouldn't change
     * anything (except slow the solver down).
     * </pre>
     *
     * <code>optional bool use_pb_resolution = 43 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUsePbResolution() {
      bitField1_ = (bitField1_ & ~0x00800000);
      usePbResolution_ = false;
      onChanged();
      return this;
    }

    private boolean minimizeReductionDuringPbResolution_ ;
    /**
     * <pre>
     * A different algorithm during PB resolution. It minimizes the number of
     * calls to ReduceCoefficients() which can be time consuming. However, the
     * search space will be different and if the coefficients are large, this may
     * lead to integer overflows that could otherwise be prevented.
     * </pre>
     *
     * <code>optional bool minimize_reduction_during_pb_resolution = 48 [default = false];</code>
     * @return Whether the minimizeReductionDuringPbResolution field is set.
     */
    @java.lang.Override
    public boolean hasMinimizeReductionDuringPbResolution() {
      return ((bitField1_ & 0x01000000) != 0);
    }
    /**
     * <pre>
     * A different algorithm during PB resolution. It minimizes the number of
     * calls to ReduceCoefficients() which can be time consuming. However, the
     * search space will be different and if the coefficients are large, this may
     * lead to integer overflows that could otherwise be prevented.
     * </pre>
     *
     * <code>optional bool minimize_reduction_during_pb_resolution = 48 [default = false];</code>
     * @return The minimizeReductionDuringPbResolution.
     */
    @java.lang.Override
    public boolean getMinimizeReductionDuringPbResolution() {
      return minimizeReductionDuringPbResolution_;
    }
    /**
     * <pre>
     * A different algorithm during PB resolution. It minimizes the number of
     * calls to ReduceCoefficients() which can be time consuming. However, the
     * search space will be different and if the coefficients are large, this may
     * lead to integer overflows that could otherwise be prevented.
     * </pre>
     *
     * <code>optional bool minimize_reduction_during_pb_resolution = 48 [default = false];</code>
     * @param value The minimizeReductionDuringPbResolution to set.
     * @return This builder for chaining.
     */
    public Builder setMinimizeReductionDuringPbResolution(boolean value) {

      minimizeReductionDuringPbResolution_ = value;
      bitField1_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A different algorithm during PB resolution. It minimizes the number of
     * calls to ReduceCoefficients() which can be time consuming. However, the
     * search space will be different and if the coefficients are large, this may
     * lead to integer overflows that could otherwise be prevented.
     * </pre>
     *
     * <code>optional bool minimize_reduction_during_pb_resolution = 48 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearMinimizeReductionDuringPbResolution() {
      bitField1_ = (bitField1_ & ~0x01000000);
      minimizeReductionDuringPbResolution_ = false;
      onChanged();
      return this;
    }

    private boolean countAssumptionLevelsInLbd_ = true;
    /**
     * <pre>
     * Whether or not the assumption levels are taken into account during the LBD
     * computation. According to the reference below, not counting them improves
     * the solver in some situation. Note that this only impact solves under
     * assumptions.
     *
     * Gilles Audemard, Jean-Marie Lagniez, Laurent Simon, "Improving Glucose for
     * Incremental SAT Solving with Assumptions: Application to MUS Extraction"
     * Theory and Applications of Satisfiability Testing - SAT 2013, Lecture Notes
     * in Computer Science Volume 7962, 2013, pp 309-317.
     * </pre>
     *
     * <code>optional bool count_assumption_levels_in_lbd = 49 [default = true];</code>
     * @return Whether the countAssumptionLevelsInLbd field is set.
     */
    @java.lang.Override
    public boolean hasCountAssumptionLevelsInLbd() {
      return ((bitField1_ & 0x02000000) != 0);
    }
    /**
     * <pre>
     * Whether or not the assumption levels are taken into account during the LBD
     * computation. According to the reference below, not counting them improves
     * the solver in some situation. Note that this only impact solves under
     * assumptions.
     *
     * Gilles Audemard, Jean-Marie Lagniez, Laurent Simon, "Improving Glucose for
     * Incremental SAT Solving with Assumptions: Application to MUS Extraction"
     * Theory and Applications of Satisfiability Testing - SAT 2013, Lecture Notes
     * in Computer Science Volume 7962, 2013, pp 309-317.
     * </pre>
     *
     * <code>optional bool count_assumption_levels_in_lbd = 49 [default = true];</code>
     * @return The countAssumptionLevelsInLbd.
     */
    @java.lang.Override
    public boolean getCountAssumptionLevelsInLbd() {
      return countAssumptionLevelsInLbd_;
    }
    /**
     * <pre>
     * Whether or not the assumption levels are taken into account during the LBD
     * computation. According to the reference below, not counting them improves
     * the solver in some situation. Note that this only impact solves under
     * assumptions.
     *
     * Gilles Audemard, Jean-Marie Lagniez, Laurent Simon, "Improving Glucose for
     * Incremental SAT Solving with Assumptions: Application to MUS Extraction"
     * Theory and Applications of Satisfiability Testing - SAT 2013, Lecture Notes
     * in Computer Science Volume 7962, 2013, pp 309-317.
     * </pre>
     *
     * <code>optional bool count_assumption_levels_in_lbd = 49 [default = true];</code>
     * @param value The countAssumptionLevelsInLbd to set.
     * @return This builder for chaining.
     */
    public Builder setCountAssumptionLevelsInLbd(boolean value) {

      countAssumptionLevelsInLbd_ = value;
      bitField1_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether or not the assumption levels are taken into account during the LBD
     * computation. According to the reference below, not counting them improves
     * the solver in some situation. Note that this only impact solves under
     * assumptions.
     *
     * Gilles Audemard, Jean-Marie Lagniez, Laurent Simon, "Improving Glucose for
     * Incremental SAT Solving with Assumptions: Application to MUS Extraction"
     * Theory and Applications of Satisfiability Testing - SAT 2013, Lecture Notes
     * in Computer Science Volume 7962, 2013, pp 309-317.
     * </pre>
     *
     * <code>optional bool count_assumption_levels_in_lbd = 49 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearCountAssumptionLevelsInLbd() {
      bitField1_ = (bitField1_ & ~0x02000000);
      countAssumptionLevelsInLbd_ = true;
      onChanged();
      return this;
    }

    private int presolveBveThreshold_ = 500;
    /**
     * <pre>
     * During presolve, only try to perform the bounded variable elimination (BVE)
     * of a variable x if the number of occurrences of x times the number of
     * occurrences of not(x) is not greater than this parameter.
     * </pre>
     *
     * <code>optional int32 presolve_bve_threshold = 54 [default = 500];</code>
     * @return Whether the presolveBveThreshold field is set.
     */
    @java.lang.Override
    public boolean hasPresolveBveThreshold() {
      return ((bitField1_ & 0x04000000) != 0);
    }
    /**
     * <pre>
     * During presolve, only try to perform the bounded variable elimination (BVE)
     * of a variable x if the number of occurrences of x times the number of
     * occurrences of not(x) is not greater than this parameter.
     * </pre>
     *
     * <code>optional int32 presolve_bve_threshold = 54 [default = 500];</code>
     * @return The presolveBveThreshold.
     */
    @java.lang.Override
    public int getPresolveBveThreshold() {
      return presolveBveThreshold_;
    }
    /**
     * <pre>
     * During presolve, only try to perform the bounded variable elimination (BVE)
     * of a variable x if the number of occurrences of x times the number of
     * occurrences of not(x) is not greater than this parameter.
     * </pre>
     *
     * <code>optional int32 presolve_bve_threshold = 54 [default = 500];</code>
     * @param value The presolveBveThreshold to set.
     * @return This builder for chaining.
     */
    public Builder setPresolveBveThreshold(int value) {

      presolveBveThreshold_ = value;
      bitField1_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * During presolve, only try to perform the bounded variable elimination (BVE)
     * of a variable x if the number of occurrences of x times the number of
     * occurrences of not(x) is not greater than this parameter.
     * </pre>
     *
     * <code>optional int32 presolve_bve_threshold = 54 [default = 500];</code>
     * @return This builder for chaining.
     */
    public Builder clearPresolveBveThreshold() {
      bitField1_ = (bitField1_ & ~0x04000000);
      presolveBveThreshold_ = 500;
      onChanged();
      return this;
    }

    private int presolveBveClauseWeight_ = 3;
    /**
     * <pre>
     * During presolve, we apply BVE only if this weight times the number of
     * clauses plus the number of clause literals is not increased.
     * </pre>
     *
     * <code>optional int32 presolve_bve_clause_weight = 55 [default = 3];</code>
     * @return Whether the presolveBveClauseWeight field is set.
     */
    @java.lang.Override
    public boolean hasPresolveBveClauseWeight() {
      return ((bitField1_ & 0x08000000) != 0);
    }
    /**
     * <pre>
     * During presolve, we apply BVE only if this weight times the number of
     * clauses plus the number of clause literals is not increased.
     * </pre>
     *
     * <code>optional int32 presolve_bve_clause_weight = 55 [default = 3];</code>
     * @return The presolveBveClauseWeight.
     */
    @java.lang.Override
    public int getPresolveBveClauseWeight() {
      return presolveBveClauseWeight_;
    }
    /**
     * <pre>
     * During presolve, we apply BVE only if this weight times the number of
     * clauses plus the number of clause literals is not increased.
     * </pre>
     *
     * <code>optional int32 presolve_bve_clause_weight = 55 [default = 3];</code>
     * @param value The presolveBveClauseWeight to set.
     * @return This builder for chaining.
     */
    public Builder setPresolveBveClauseWeight(int value) {

      presolveBveClauseWeight_ = value;
      bitField1_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * During presolve, we apply BVE only if this weight times the number of
     * clauses plus the number of clause literals is not increased.
     * </pre>
     *
     * <code>optional int32 presolve_bve_clause_weight = 55 [default = 3];</code>
     * @return This builder for chaining.
     */
    public Builder clearPresolveBveClauseWeight() {
      bitField1_ = (bitField1_ & ~0x08000000);
      presolveBveClauseWeight_ = 3;
      onChanged();
      return this;
    }

    private double probingDeterministicTimeLimit_ = 1D;
    /**
     * <pre>
     * The maximum "deterministic" time limit to spend in probing. A value of
     * zero will disable the probing.
     *
     * TODO(user): Clean up. The first one is used in CP-SAT, the other in pure
     * SAT presolve.
     * </pre>
     *
     * <code>optional double probing_deterministic_time_limit = 226 [default = 1];</code>
     * @return Whether the probingDeterministicTimeLimit field is set.
     */
    @java.lang.Override
    public boolean hasProbingDeterministicTimeLimit() {
      return ((bitField1_ & 0x10000000) != 0);
    }
    /**
     * <pre>
     * The maximum "deterministic" time limit to spend in probing. A value of
     * zero will disable the probing.
     *
     * TODO(user): Clean up. The first one is used in CP-SAT, the other in pure
     * SAT presolve.
     * </pre>
     *
     * <code>optional double probing_deterministic_time_limit = 226 [default = 1];</code>
     * @return The probingDeterministicTimeLimit.
     */
    @java.lang.Override
    public double getProbingDeterministicTimeLimit() {
      return probingDeterministicTimeLimit_;
    }
    /**
     * <pre>
     * The maximum "deterministic" time limit to spend in probing. A value of
     * zero will disable the probing.
     *
     * TODO(user): Clean up. The first one is used in CP-SAT, the other in pure
     * SAT presolve.
     * </pre>
     *
     * <code>optional double probing_deterministic_time_limit = 226 [default = 1];</code>
     * @param value The probingDeterministicTimeLimit to set.
     * @return This builder for chaining.
     */
    public Builder setProbingDeterministicTimeLimit(double value) {

      probingDeterministicTimeLimit_ = value;
      bitField1_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The maximum "deterministic" time limit to spend in probing. A value of
     * zero will disable the probing.
     *
     * TODO(user): Clean up. The first one is used in CP-SAT, the other in pure
     * SAT presolve.
     * </pre>
     *
     * <code>optional double probing_deterministic_time_limit = 226 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearProbingDeterministicTimeLimit() {
      bitField1_ = (bitField1_ & ~0x10000000);
      probingDeterministicTimeLimit_ = 1D;
      onChanged();
      return this;
    }

    private double presolveProbingDeterministicTimeLimit_ = 30D;
    /**
     * <code>optional double presolve_probing_deterministic_time_limit = 57 [default = 30];</code>
     * @return Whether the presolveProbingDeterministicTimeLimit field is set.
     */
    @java.lang.Override
    public boolean hasPresolveProbingDeterministicTimeLimit() {
      return ((bitField1_ & 0x20000000) != 0);
    }
    /**
     * <code>optional double presolve_probing_deterministic_time_limit = 57 [default = 30];</code>
     * @return The presolveProbingDeterministicTimeLimit.
     */
    @java.lang.Override
    public double getPresolveProbingDeterministicTimeLimit() {
      return presolveProbingDeterministicTimeLimit_;
    }
    /**
     * <code>optional double presolve_probing_deterministic_time_limit = 57 [default = 30];</code>
     * @param value The presolveProbingDeterministicTimeLimit to set.
     * @return This builder for chaining.
     */
    public Builder setPresolveProbingDeterministicTimeLimit(double value) {

      presolveProbingDeterministicTimeLimit_ = value;
      bitField1_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     * <code>optional double presolve_probing_deterministic_time_limit = 57 [default = 30];</code>
     * @return This builder for chaining.
     */
    public Builder clearPresolveProbingDeterministicTimeLimit() {
      bitField1_ = (bitField1_ & ~0x20000000);
      presolveProbingDeterministicTimeLimit_ = 30D;
      onChanged();
      return this;
    }

    private boolean presolveBlockedClause_ = true;
    /**
     * <pre>
     * Whether we use an heuristic to detect some basic case of blocked clause
     * in the SAT presolve.
     * </pre>
     *
     * <code>optional bool presolve_blocked_clause = 88 [default = true];</code>
     * @return Whether the presolveBlockedClause field is set.
     */
    @java.lang.Override
    public boolean hasPresolveBlockedClause() {
      return ((bitField1_ & 0x40000000) != 0);
    }
    /**
     * <pre>
     * Whether we use an heuristic to detect some basic case of blocked clause
     * in the SAT presolve.
     * </pre>
     *
     * <code>optional bool presolve_blocked_clause = 88 [default = true];</code>
     * @return The presolveBlockedClause.
     */
    @java.lang.Override
    public boolean getPresolveBlockedClause() {
      return presolveBlockedClause_;
    }
    /**
     * <pre>
     * Whether we use an heuristic to detect some basic case of blocked clause
     * in the SAT presolve.
     * </pre>
     *
     * <code>optional bool presolve_blocked_clause = 88 [default = true];</code>
     * @param value The presolveBlockedClause to set.
     * @return This builder for chaining.
     */
    public Builder setPresolveBlockedClause(boolean value) {

      presolveBlockedClause_ = value;
      bitField1_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we use an heuristic to detect some basic case of blocked clause
     * in the SAT presolve.
     * </pre>
     *
     * <code>optional bool presolve_blocked_clause = 88 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearPresolveBlockedClause() {
      bitField1_ = (bitField1_ & ~0x40000000);
      presolveBlockedClause_ = true;
      onChanged();
      return this;
    }

    private boolean presolveUseBva_ = true;
    /**
     * <pre>
     * Whether or not we use Bounded Variable Addition (BVA) in the presolve.
     * </pre>
     *
     * <code>optional bool presolve_use_bva = 72 [default = true];</code>
     * @return Whether the presolveUseBva field is set.
     */
    @java.lang.Override
    public boolean hasPresolveUseBva() {
      return ((bitField1_ & 0x80000000) != 0);
    }
    /**
     * <pre>
     * Whether or not we use Bounded Variable Addition (BVA) in the presolve.
     * </pre>
     *
     * <code>optional bool presolve_use_bva = 72 [default = true];</code>
     * @return The presolveUseBva.
     */
    @java.lang.Override
    public boolean getPresolveUseBva() {
      return presolveUseBva_;
    }
    /**
     * <pre>
     * Whether or not we use Bounded Variable Addition (BVA) in the presolve.
     * </pre>
     *
     * <code>optional bool presolve_use_bva = 72 [default = true];</code>
     * @param value The presolveUseBva to set.
     * @return This builder for chaining.
     */
    public Builder setPresolveUseBva(boolean value) {

      presolveUseBva_ = value;
      bitField1_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether or not we use Bounded Variable Addition (BVA) in the presolve.
     * </pre>
     *
     * <code>optional bool presolve_use_bva = 72 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearPresolveUseBva() {
      bitField1_ = (bitField1_ & ~0x80000000);
      presolveUseBva_ = true;
      onChanged();
      return this;
    }

    private int presolveBvaThreshold_ = 1;
    /**
     * <pre>
     * Apply Bounded Variable Addition (BVA) if the number of clauses is reduced
     * by stricly more than this threshold. The algorithm described in the paper
     * uses 0, but quick experiments showed that 1 is a good value. It may not be
     * worth it to add a new variable just to remove one clause.
     * </pre>
     *
     * <code>optional int32 presolve_bva_threshold = 73 [default = 1];</code>
     * @return Whether the presolveBvaThreshold field is set.
     */
    @java.lang.Override
    public boolean hasPresolveBvaThreshold() {
      return ((bitField2_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Apply Bounded Variable Addition (BVA) if the number of clauses is reduced
     * by stricly more than this threshold. The algorithm described in the paper
     * uses 0, but quick experiments showed that 1 is a good value. It may not be
     * worth it to add a new variable just to remove one clause.
     * </pre>
     *
     * <code>optional int32 presolve_bva_threshold = 73 [default = 1];</code>
     * @return The presolveBvaThreshold.
     */
    @java.lang.Override
    public int getPresolveBvaThreshold() {
      return presolveBvaThreshold_;
    }
    /**
     * <pre>
     * Apply Bounded Variable Addition (BVA) if the number of clauses is reduced
     * by stricly more than this threshold. The algorithm described in the paper
     * uses 0, but quick experiments showed that 1 is a good value. It may not be
     * worth it to add a new variable just to remove one clause.
     * </pre>
     *
     * <code>optional int32 presolve_bva_threshold = 73 [default = 1];</code>
     * @param value The presolveBvaThreshold to set.
     * @return This builder for chaining.
     */
    public Builder setPresolveBvaThreshold(int value) {

      presolveBvaThreshold_ = value;
      bitField2_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Apply Bounded Variable Addition (BVA) if the number of clauses is reduced
     * by stricly more than this threshold. The algorithm described in the paper
     * uses 0, but quick experiments showed that 1 is a good value. It may not be
     * worth it to add a new variable just to remove one clause.
     * </pre>
     *
     * <code>optional int32 presolve_bva_threshold = 73 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearPresolveBvaThreshold() {
      bitField2_ = (bitField2_ & ~0x00000001);
      presolveBvaThreshold_ = 1;
      onChanged();
      return this;
    }

    private int maxPresolveIterations_ = 3;
    /**
     * <pre>
     * In case of large reduction in a presolve iteration, we perform multiple
     * presolve iterations. This parameter controls the maximum number of such
     * presolve iterations.
     * </pre>
     *
     * <code>optional int32 max_presolve_iterations = 138 [default = 3];</code>
     * @return Whether the maxPresolveIterations field is set.
     */
    @java.lang.Override
    public boolean hasMaxPresolveIterations() {
      return ((bitField2_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * In case of large reduction in a presolve iteration, we perform multiple
     * presolve iterations. This parameter controls the maximum number of such
     * presolve iterations.
     * </pre>
     *
     * <code>optional int32 max_presolve_iterations = 138 [default = 3];</code>
     * @return The maxPresolveIterations.
     */
    @java.lang.Override
    public int getMaxPresolveIterations() {
      return maxPresolveIterations_;
    }
    /**
     * <pre>
     * In case of large reduction in a presolve iteration, we perform multiple
     * presolve iterations. This parameter controls the maximum number of such
     * presolve iterations.
     * </pre>
     *
     * <code>optional int32 max_presolve_iterations = 138 [default = 3];</code>
     * @param value The maxPresolveIterations to set.
     * @return This builder for chaining.
     */
    public Builder setMaxPresolveIterations(int value) {

      maxPresolveIterations_ = value;
      bitField2_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * In case of large reduction in a presolve iteration, we perform multiple
     * presolve iterations. This parameter controls the maximum number of such
     * presolve iterations.
     * </pre>
     *
     * <code>optional int32 max_presolve_iterations = 138 [default = 3];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxPresolveIterations() {
      bitField2_ = (bitField2_ & ~0x00000002);
      maxPresolveIterations_ = 3;
      onChanged();
      return this;
    }

    private boolean cpModelPresolve_ = true;
    /**
     * <pre>
     * Whether we presolve the cp_model before solving it.
     * </pre>
     *
     * <code>optional bool cp_model_presolve = 86 [default = true];</code>
     * @return Whether the cpModelPresolve field is set.
     */
    @java.lang.Override
    public boolean hasCpModelPresolve() {
      return ((bitField2_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * Whether we presolve the cp_model before solving it.
     * </pre>
     *
     * <code>optional bool cp_model_presolve = 86 [default = true];</code>
     * @return The cpModelPresolve.
     */
    @java.lang.Override
    public boolean getCpModelPresolve() {
      return cpModelPresolve_;
    }
    /**
     * <pre>
     * Whether we presolve the cp_model before solving it.
     * </pre>
     *
     * <code>optional bool cp_model_presolve = 86 [default = true];</code>
     * @param value The cpModelPresolve to set.
     * @return This builder for chaining.
     */
    public Builder setCpModelPresolve(boolean value) {

      cpModelPresolve_ = value;
      bitField2_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we presolve the cp_model before solving it.
     * </pre>
     *
     * <code>optional bool cp_model_presolve = 86 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearCpModelPresolve() {
      bitField2_ = (bitField2_ & ~0x00000004);
      cpModelPresolve_ = true;
      onChanged();
      return this;
    }

    private int cpModelProbingLevel_ = 2;
    /**
     * <pre>
     * How much effort do we spend on probing. 0 disables it completely.
     * </pre>
     *
     * <code>optional int32 cp_model_probing_level = 110 [default = 2];</code>
     * @return Whether the cpModelProbingLevel field is set.
     */
    @java.lang.Override
    public boolean hasCpModelProbingLevel() {
      return ((bitField2_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * How much effort do we spend on probing. 0 disables it completely.
     * </pre>
     *
     * <code>optional int32 cp_model_probing_level = 110 [default = 2];</code>
     * @return The cpModelProbingLevel.
     */
    @java.lang.Override
    public int getCpModelProbingLevel() {
      return cpModelProbingLevel_;
    }
    /**
     * <pre>
     * How much effort do we spend on probing. 0 disables it completely.
     * </pre>
     *
     * <code>optional int32 cp_model_probing_level = 110 [default = 2];</code>
     * @param value The cpModelProbingLevel to set.
     * @return This builder for chaining.
     */
    public Builder setCpModelProbingLevel(int value) {

      cpModelProbingLevel_ = value;
      bitField2_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * How much effort do we spend on probing. 0 disables it completely.
     * </pre>
     *
     * <code>optional int32 cp_model_probing_level = 110 [default = 2];</code>
     * @return This builder for chaining.
     */
    public Builder clearCpModelProbingLevel() {
      bitField2_ = (bitField2_ & ~0x00000008);
      cpModelProbingLevel_ = 2;
      onChanged();
      return this;
    }

    private boolean cpModelUseSatPresolve_ = true;
    /**
     * <pre>
     * Whether we also use the sat presolve when cp_model_presolve is true.
     * </pre>
     *
     * <code>optional bool cp_model_use_sat_presolve = 93 [default = true];</code>
     * @return Whether the cpModelUseSatPresolve field is set.
     */
    @java.lang.Override
    public boolean hasCpModelUseSatPresolve() {
      return ((bitField2_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * Whether we also use the sat presolve when cp_model_presolve is true.
     * </pre>
     *
     * <code>optional bool cp_model_use_sat_presolve = 93 [default = true];</code>
     * @return The cpModelUseSatPresolve.
     */
    @java.lang.Override
    public boolean getCpModelUseSatPresolve() {
      return cpModelUseSatPresolve_;
    }
    /**
     * <pre>
     * Whether we also use the sat presolve when cp_model_presolve is true.
     * </pre>
     *
     * <code>optional bool cp_model_use_sat_presolve = 93 [default = true];</code>
     * @param value The cpModelUseSatPresolve to set.
     * @return This builder for chaining.
     */
    public Builder setCpModelUseSatPresolve(boolean value) {

      cpModelUseSatPresolve_ = value;
      bitField2_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we also use the sat presolve when cp_model_presolve is true.
     * </pre>
     *
     * <code>optional bool cp_model_use_sat_presolve = 93 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearCpModelUseSatPresolve() {
      bitField2_ = (bitField2_ & ~0x00000010);
      cpModelUseSatPresolve_ = true;
      onChanged();
      return this;
    }

    private boolean detectTableWithCost_ ;
    /**
     * <pre>
     * If true, we detect variable that are unique to a table constraint and only
     * there to encode a cost on each tuple. This is usually the case when a WCSP
     * (weighted constraint program) is encoded into CP-SAT format.
     *
     * This can lead to a dramatic speed-up for such problems but is still
     * experimental at this point.
     * </pre>
     *
     * <code>optional bool detect_table_with_cost = 216 [default = false];</code>
     * @return Whether the detectTableWithCost field is set.
     */
    @java.lang.Override
    public boolean hasDetectTableWithCost() {
      return ((bitField2_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * If true, we detect variable that are unique to a table constraint and only
     * there to encode a cost on each tuple. This is usually the case when a WCSP
     * (weighted constraint program) is encoded into CP-SAT format.
     *
     * This can lead to a dramatic speed-up for such problems but is still
     * experimental at this point.
     * </pre>
     *
     * <code>optional bool detect_table_with_cost = 216 [default = false];</code>
     * @return The detectTableWithCost.
     */
    @java.lang.Override
    public boolean getDetectTableWithCost() {
      return detectTableWithCost_;
    }
    /**
     * <pre>
     * If true, we detect variable that are unique to a table constraint and only
     * there to encode a cost on each tuple. This is usually the case when a WCSP
     * (weighted constraint program) is encoded into CP-SAT format.
     *
     * This can lead to a dramatic speed-up for such problems but is still
     * experimental at this point.
     * </pre>
     *
     * <code>optional bool detect_table_with_cost = 216 [default = false];</code>
     * @param value The detectTableWithCost to set.
     * @return This builder for chaining.
     */
    public Builder setDetectTableWithCost(boolean value) {

      detectTableWithCost_ = value;
      bitField2_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, we detect variable that are unique to a table constraint and only
     * there to encode a cost on each tuple. This is usually the case when a WCSP
     * (weighted constraint program) is encoded into CP-SAT format.
     *
     * This can lead to a dramatic speed-up for such problems but is still
     * experimental at this point.
     * </pre>
     *
     * <code>optional bool detect_table_with_cost = 216 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearDetectTableWithCost() {
      bitField2_ = (bitField2_ & ~0x00000020);
      detectTableWithCost_ = false;
      onChanged();
      return this;
    }

    private int tableCompressionLevel_ = 2;
    /**
     * <pre>
     * How much we try to "compress" a table constraint. Compressing more leads to
     * less Booleans and faster propagation but can reduced the quality of the lp
     * relaxation. Values goes from 0 to 3 where we always try to fully compress a
     * table. At 2, we try to automatically decide if it is worth it.
     * </pre>
     *
     * <code>optional int32 table_compression_level = 217 [default = 2];</code>
     * @return Whether the tableCompressionLevel field is set.
     */
    @java.lang.Override
    public boolean hasTableCompressionLevel() {
      return ((bitField2_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * How much we try to "compress" a table constraint. Compressing more leads to
     * less Booleans and faster propagation but can reduced the quality of the lp
     * relaxation. Values goes from 0 to 3 where we always try to fully compress a
     * table. At 2, we try to automatically decide if it is worth it.
     * </pre>
     *
     * <code>optional int32 table_compression_level = 217 [default = 2];</code>
     * @return The tableCompressionLevel.
     */
    @java.lang.Override
    public int getTableCompressionLevel() {
      return tableCompressionLevel_;
    }
    /**
     * <pre>
     * How much we try to "compress" a table constraint. Compressing more leads to
     * less Booleans and faster propagation but can reduced the quality of the lp
     * relaxation. Values goes from 0 to 3 where we always try to fully compress a
     * table. At 2, we try to automatically decide if it is worth it.
     * </pre>
     *
     * <code>optional int32 table_compression_level = 217 [default = 2];</code>
     * @param value The tableCompressionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setTableCompressionLevel(int value) {

      tableCompressionLevel_ = value;
      bitField2_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * How much we try to "compress" a table constraint. Compressing more leads to
     * less Booleans and faster propagation but can reduced the quality of the lp
     * relaxation. Values goes from 0 to 3 where we always try to fully compress a
     * table. At 2, we try to automatically decide if it is worth it.
     * </pre>
     *
     * <code>optional int32 table_compression_level = 217 [default = 2];</code>
     * @return This builder for chaining.
     */
    public Builder clearTableCompressionLevel() {
      bitField2_ = (bitField2_ & ~0x00000040);
      tableCompressionLevel_ = 2;
      onChanged();
      return this;
    }

    private boolean expandAlldiffConstraints_ ;
    /**
     * <pre>
     * If true, expand all_different constraints that are not permutations.
     * Permutations (#Variables = #Values) are always expanded.
     * </pre>
     *
     * <code>optional bool expand_alldiff_constraints = 170 [default = false];</code>
     * @return Whether the expandAlldiffConstraints field is set.
     */
    @java.lang.Override
    public boolean hasExpandAlldiffConstraints() {
      return ((bitField2_ & 0x00000080) != 0);
    }
    /**
     * <pre>
     * If true, expand all_different constraints that are not permutations.
     * Permutations (#Variables = #Values) are always expanded.
     * </pre>
     *
     * <code>optional bool expand_alldiff_constraints = 170 [default = false];</code>
     * @return The expandAlldiffConstraints.
     */
    @java.lang.Override
    public boolean getExpandAlldiffConstraints() {
      return expandAlldiffConstraints_;
    }
    /**
     * <pre>
     * If true, expand all_different constraints that are not permutations.
     * Permutations (#Variables = #Values) are always expanded.
     * </pre>
     *
     * <code>optional bool expand_alldiff_constraints = 170 [default = false];</code>
     * @param value The expandAlldiffConstraints to set.
     * @return This builder for chaining.
     */
    public Builder setExpandAlldiffConstraints(boolean value) {

      expandAlldiffConstraints_ = value;
      bitField2_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, expand all_different constraints that are not permutations.
     * Permutations (#Variables = #Values) are always expanded.
     * </pre>
     *
     * <code>optional bool expand_alldiff_constraints = 170 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearExpandAlldiffConstraints() {
      bitField2_ = (bitField2_ & ~0x00000080);
      expandAlldiffConstraints_ = false;
      onChanged();
      return this;
    }

    private boolean expandReservoirConstraints_ = true;
    /**
     * <pre>
     * If true, expand the reservoir constraints by creating booleans for all
     * possible precedences between event and encoding the constraint.
     * </pre>
     *
     * <code>optional bool expand_reservoir_constraints = 182 [default = true];</code>
     * @return Whether the expandReservoirConstraints field is set.
     */
    @java.lang.Override
    public boolean hasExpandReservoirConstraints() {
      return ((bitField2_ & 0x00000100) != 0);
    }
    /**
     * <pre>
     * If true, expand the reservoir constraints by creating booleans for all
     * possible precedences between event and encoding the constraint.
     * </pre>
     *
     * <code>optional bool expand_reservoir_constraints = 182 [default = true];</code>
     * @return The expandReservoirConstraints.
     */
    @java.lang.Override
    public boolean getExpandReservoirConstraints() {
      return expandReservoirConstraints_;
    }
    /**
     * <pre>
     * If true, expand the reservoir constraints by creating booleans for all
     * possible precedences between event and encoding the constraint.
     * </pre>
     *
     * <code>optional bool expand_reservoir_constraints = 182 [default = true];</code>
     * @param value The expandReservoirConstraints to set.
     * @return This builder for chaining.
     */
    public Builder setExpandReservoirConstraints(boolean value) {

      expandReservoirConstraints_ = value;
      bitField2_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, expand the reservoir constraints by creating booleans for all
     * possible precedences between event and encoding the constraint.
     * </pre>
     *
     * <code>optional bool expand_reservoir_constraints = 182 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearExpandReservoirConstraints() {
      bitField2_ = (bitField2_ & ~0x00000100);
      expandReservoirConstraints_ = true;
      onChanged();
      return this;
    }

    private boolean expandReservoirUsingCircuit_ ;
    /**
     * <pre>
     * Mainly useful for testing.
     *
     * If this and expand_reservoir_constraints is true, we use a different
     * encoding of the reservoir constraint using circuit instead of precedences.
     * Note that this is usually slower, but can exercise different part of the
     * solver. Note that contrary to the precedence encoding, this easily support
     * variable demands.
     *
     * WARNING: with this encoding, the constraint take a slighlty different
     * meaning. The level must be within the reservoir for any permutation of the
     * events. So we cannot have +100 and -100 at the same time if the maximum
     * level is 10 (as autorized by the reservoir constraint).
     * </pre>
     *
     * <code>optional bool expand_reservoir_using_circuit = 288 [default = false];</code>
     * @return Whether the expandReservoirUsingCircuit field is set.
     */
    @java.lang.Override
    public boolean hasExpandReservoirUsingCircuit() {
      return ((bitField2_ & 0x00000200) != 0);
    }
    /**
     * <pre>
     * Mainly useful for testing.
     *
     * If this and expand_reservoir_constraints is true, we use a different
     * encoding of the reservoir constraint using circuit instead of precedences.
     * Note that this is usually slower, but can exercise different part of the
     * solver. Note that contrary to the precedence encoding, this easily support
     * variable demands.
     *
     * WARNING: with this encoding, the constraint take a slighlty different
     * meaning. The level must be within the reservoir for any permutation of the
     * events. So we cannot have +100 and -100 at the same time if the maximum
     * level is 10 (as autorized by the reservoir constraint).
     * </pre>
     *
     * <code>optional bool expand_reservoir_using_circuit = 288 [default = false];</code>
     * @return The expandReservoirUsingCircuit.
     */
    @java.lang.Override
    public boolean getExpandReservoirUsingCircuit() {
      return expandReservoirUsingCircuit_;
    }
    /**
     * <pre>
     * Mainly useful for testing.
     *
     * If this and expand_reservoir_constraints is true, we use a different
     * encoding of the reservoir constraint using circuit instead of precedences.
     * Note that this is usually slower, but can exercise different part of the
     * solver. Note that contrary to the precedence encoding, this easily support
     * variable demands.
     *
     * WARNING: with this encoding, the constraint take a slighlty different
     * meaning. The level must be within the reservoir for any permutation of the
     * events. So we cannot have +100 and -100 at the same time if the maximum
     * level is 10 (as autorized by the reservoir constraint).
     * </pre>
     *
     * <code>optional bool expand_reservoir_using_circuit = 288 [default = false];</code>
     * @param value The expandReservoirUsingCircuit to set.
     * @return This builder for chaining.
     */
    public Builder setExpandReservoirUsingCircuit(boolean value) {

      expandReservoirUsingCircuit_ = value;
      bitField2_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Mainly useful for testing.
     *
     * If this and expand_reservoir_constraints is true, we use a different
     * encoding of the reservoir constraint using circuit instead of precedences.
     * Note that this is usually slower, but can exercise different part of the
     * solver. Note that contrary to the precedence encoding, this easily support
     * variable demands.
     *
     * WARNING: with this encoding, the constraint take a slighlty different
     * meaning. The level must be within the reservoir for any permutation of the
     * events. So we cannot have +100 and -100 at the same time if the maximum
     * level is 10 (as autorized by the reservoir constraint).
     * </pre>
     *
     * <code>optional bool expand_reservoir_using_circuit = 288 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearExpandReservoirUsingCircuit() {
      bitField2_ = (bitField2_ & ~0x00000200);
      expandReservoirUsingCircuit_ = false;
      onChanged();
      return this;
    }

    private boolean encodeCumulativeAsReservoir_ ;
    /**
     * <pre>
     * Encore cumulative with fixed demands and capacity as a reservoir
     * constraint. The only reason you might want to do that is to test the
     * reservoir propagation code!
     * </pre>
     *
     * <code>optional bool encode_cumulative_as_reservoir = 287 [default = false];</code>
     * @return Whether the encodeCumulativeAsReservoir field is set.
     */
    @java.lang.Override
    public boolean hasEncodeCumulativeAsReservoir() {
      return ((bitField2_ & 0x00000400) != 0);
    }
    /**
     * <pre>
     * Encore cumulative with fixed demands and capacity as a reservoir
     * constraint. The only reason you might want to do that is to test the
     * reservoir propagation code!
     * </pre>
     *
     * <code>optional bool encode_cumulative_as_reservoir = 287 [default = false];</code>
     * @return The encodeCumulativeAsReservoir.
     */
    @java.lang.Override
    public boolean getEncodeCumulativeAsReservoir() {
      return encodeCumulativeAsReservoir_;
    }
    /**
     * <pre>
     * Encore cumulative with fixed demands and capacity as a reservoir
     * constraint. The only reason you might want to do that is to test the
     * reservoir propagation code!
     * </pre>
     *
     * <code>optional bool encode_cumulative_as_reservoir = 287 [default = false];</code>
     * @param value The encodeCumulativeAsReservoir to set.
     * @return This builder for chaining.
     */
    public Builder setEncodeCumulativeAsReservoir(boolean value) {

      encodeCumulativeAsReservoir_ = value;
      bitField2_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Encore cumulative with fixed demands and capacity as a reservoir
     * constraint. The only reason you might want to do that is to test the
     * reservoir propagation code!
     * </pre>
     *
     * <code>optional bool encode_cumulative_as_reservoir = 287 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearEncodeCumulativeAsReservoir() {
      bitField2_ = (bitField2_ & ~0x00000400);
      encodeCumulativeAsReservoir_ = false;
      onChanged();
      return this;
    }

    private int maxLinMaxSizeForExpansion_ ;
    /**
     * <pre>
     * If the number of expressions in the lin_max is less that the max size
     * parameter, model expansion replaces target = max(xi) by linear constraint
     * with the introduction of new booleans bi such that bi =&gt; target == xi.
     *
     * This is mainly for experimenting compared to a custom lin_max propagator.
     * </pre>
     *
     * <code>optional int32 max_lin_max_size_for_expansion = 280 [default = 0];</code>
     * @return Whether the maxLinMaxSizeForExpansion field is set.
     */
    @java.lang.Override
    public boolean hasMaxLinMaxSizeForExpansion() {
      return ((bitField2_ & 0x00000800) != 0);
    }
    /**
     * <pre>
     * If the number of expressions in the lin_max is less that the max size
     * parameter, model expansion replaces target = max(xi) by linear constraint
     * with the introduction of new booleans bi such that bi =&gt; target == xi.
     *
     * This is mainly for experimenting compared to a custom lin_max propagator.
     * </pre>
     *
     * <code>optional int32 max_lin_max_size_for_expansion = 280 [default = 0];</code>
     * @return The maxLinMaxSizeForExpansion.
     */
    @java.lang.Override
    public int getMaxLinMaxSizeForExpansion() {
      return maxLinMaxSizeForExpansion_;
    }
    /**
     * <pre>
     * If the number of expressions in the lin_max is less that the max size
     * parameter, model expansion replaces target = max(xi) by linear constraint
     * with the introduction of new booleans bi such that bi =&gt; target == xi.
     *
     * This is mainly for experimenting compared to a custom lin_max propagator.
     * </pre>
     *
     * <code>optional int32 max_lin_max_size_for_expansion = 280 [default = 0];</code>
     * @param value The maxLinMaxSizeForExpansion to set.
     * @return This builder for chaining.
     */
    public Builder setMaxLinMaxSizeForExpansion(int value) {

      maxLinMaxSizeForExpansion_ = value;
      bitField2_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If the number of expressions in the lin_max is less that the max size
     * parameter, model expansion replaces target = max(xi) by linear constraint
     * with the introduction of new booleans bi such that bi =&gt; target == xi.
     *
     * This is mainly for experimenting compared to a custom lin_max propagator.
     * </pre>
     *
     * <code>optional int32 max_lin_max_size_for_expansion = 280 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxLinMaxSizeForExpansion() {
      bitField2_ = (bitField2_ & ~0x00000800);
      maxLinMaxSizeForExpansion_ = 0;
      onChanged();
      return this;
    }

    private boolean disableConstraintExpansion_ ;
    /**
     * <pre>
     * If true, it disable all constraint expansion.
     * This should only be used to test the presolve of expanded constraints.
     * </pre>
     *
     * <code>optional bool disable_constraint_expansion = 181 [default = false];</code>
     * @return Whether the disableConstraintExpansion field is set.
     */
    @java.lang.Override
    public boolean hasDisableConstraintExpansion() {
      return ((bitField2_ & 0x00001000) != 0);
    }
    /**
     * <pre>
     * If true, it disable all constraint expansion.
     * This should only be used to test the presolve of expanded constraints.
     * </pre>
     *
     * <code>optional bool disable_constraint_expansion = 181 [default = false];</code>
     * @return The disableConstraintExpansion.
     */
    @java.lang.Override
    public boolean getDisableConstraintExpansion() {
      return disableConstraintExpansion_;
    }
    /**
     * <pre>
     * If true, it disable all constraint expansion.
     * This should only be used to test the presolve of expanded constraints.
     * </pre>
     *
     * <code>optional bool disable_constraint_expansion = 181 [default = false];</code>
     * @param value The disableConstraintExpansion to set.
     * @return This builder for chaining.
     */
    public Builder setDisableConstraintExpansion(boolean value) {

      disableConstraintExpansion_ = value;
      bitField2_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, it disable all constraint expansion.
     * This should only be used to test the presolve of expanded constraints.
     * </pre>
     *
     * <code>optional bool disable_constraint_expansion = 181 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearDisableConstraintExpansion() {
      bitField2_ = (bitField2_ & ~0x00001000);
      disableConstraintExpansion_ = false;
      onChanged();
      return this;
    }

    private boolean encodeComplexLinearConstraintWithInteger_ ;
    /**
     * <pre>
     * Linear constraint with a complex right hand side (more than a single
     * interval) need to be expanded, there is a couple of way to do that.
     * </pre>
     *
     * <code>optional bool encode_complex_linear_constraint_with_integer = 223 [default = false];</code>
     * @return Whether the encodeComplexLinearConstraintWithInteger field is set.
     */
    @java.lang.Override
    public boolean hasEncodeComplexLinearConstraintWithInteger() {
      return ((bitField2_ & 0x00002000) != 0);
    }
    /**
     * <pre>
     * Linear constraint with a complex right hand side (more than a single
     * interval) need to be expanded, there is a couple of way to do that.
     * </pre>
     *
     * <code>optional bool encode_complex_linear_constraint_with_integer = 223 [default = false];</code>
     * @return The encodeComplexLinearConstraintWithInteger.
     */
    @java.lang.Override
    public boolean getEncodeComplexLinearConstraintWithInteger() {
      return encodeComplexLinearConstraintWithInteger_;
    }
    /**
     * <pre>
     * Linear constraint with a complex right hand side (more than a single
     * interval) need to be expanded, there is a couple of way to do that.
     * </pre>
     *
     * <code>optional bool encode_complex_linear_constraint_with_integer = 223 [default = false];</code>
     * @param value The encodeComplexLinearConstraintWithInteger to set.
     * @return This builder for chaining.
     */
    public Builder setEncodeComplexLinearConstraintWithInteger(boolean value) {

      encodeComplexLinearConstraintWithInteger_ = value;
      bitField2_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Linear constraint with a complex right hand side (more than a single
     * interval) need to be expanded, there is a couple of way to do that.
     * </pre>
     *
     * <code>optional bool encode_complex_linear_constraint_with_integer = 223 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearEncodeComplexLinearConstraintWithInteger() {
      bitField2_ = (bitField2_ & ~0x00002000);
      encodeComplexLinearConstraintWithInteger_ = false;
      onChanged();
      return this;
    }

    private double mergeNoOverlapWorkLimit_ = 1000000000000D;
    /**
     * <pre>
     * During presolve, we use a maximum clique heuristic to merge together
     * no-overlap constraints or at most one constraints. This code can be slow,
     * so we have a limit in place on the number of explored nodes in the
     * underlying graph. The internal limit is an int64, but we use double here to
     * simplify manual input.
     * </pre>
     *
     * <code>optional double merge_no_overlap_work_limit = 145 [default = 1000000000000];</code>
     * @return Whether the mergeNoOverlapWorkLimit field is set.
     */
    @java.lang.Override
    public boolean hasMergeNoOverlapWorkLimit() {
      return ((bitField2_ & 0x00004000) != 0);
    }
    /**
     * <pre>
     * During presolve, we use a maximum clique heuristic to merge together
     * no-overlap constraints or at most one constraints. This code can be slow,
     * so we have a limit in place on the number of explored nodes in the
     * underlying graph. The internal limit is an int64, but we use double here to
     * simplify manual input.
     * </pre>
     *
     * <code>optional double merge_no_overlap_work_limit = 145 [default = 1000000000000];</code>
     * @return The mergeNoOverlapWorkLimit.
     */
    @java.lang.Override
    public double getMergeNoOverlapWorkLimit() {
      return mergeNoOverlapWorkLimit_;
    }
    /**
     * <pre>
     * During presolve, we use a maximum clique heuristic to merge together
     * no-overlap constraints or at most one constraints. This code can be slow,
     * so we have a limit in place on the number of explored nodes in the
     * underlying graph. The internal limit is an int64, but we use double here to
     * simplify manual input.
     * </pre>
     *
     * <code>optional double merge_no_overlap_work_limit = 145 [default = 1000000000000];</code>
     * @param value The mergeNoOverlapWorkLimit to set.
     * @return This builder for chaining.
     */
    public Builder setMergeNoOverlapWorkLimit(double value) {

      mergeNoOverlapWorkLimit_ = value;
      bitField2_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * During presolve, we use a maximum clique heuristic to merge together
     * no-overlap constraints or at most one constraints. This code can be slow,
     * so we have a limit in place on the number of explored nodes in the
     * underlying graph. The internal limit is an int64, but we use double here to
     * simplify manual input.
     * </pre>
     *
     * <code>optional double merge_no_overlap_work_limit = 145 [default = 1000000000000];</code>
     * @return This builder for chaining.
     */
    public Builder clearMergeNoOverlapWorkLimit() {
      bitField2_ = (bitField2_ & ~0x00004000);
      mergeNoOverlapWorkLimit_ = 1000000000000D;
      onChanged();
      return this;
    }

    private double mergeAtMostOneWorkLimit_ = 100000000D;
    /**
     * <code>optional double merge_at_most_one_work_limit = 146 [default = 100000000];</code>
     * @return Whether the mergeAtMostOneWorkLimit field is set.
     */
    @java.lang.Override
    public boolean hasMergeAtMostOneWorkLimit() {
      return ((bitField2_ & 0x00008000) != 0);
    }
    /**
     * <code>optional double merge_at_most_one_work_limit = 146 [default = 100000000];</code>
     * @return The mergeAtMostOneWorkLimit.
     */
    @java.lang.Override
    public double getMergeAtMostOneWorkLimit() {
      return mergeAtMostOneWorkLimit_;
    }
    /**
     * <code>optional double merge_at_most_one_work_limit = 146 [default = 100000000];</code>
     * @param value The mergeAtMostOneWorkLimit to set.
     * @return This builder for chaining.
     */
    public Builder setMergeAtMostOneWorkLimit(double value) {

      mergeAtMostOneWorkLimit_ = value;
      bitField2_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     * <code>optional double merge_at_most_one_work_limit = 146 [default = 100000000];</code>
     * @return This builder for chaining.
     */
    public Builder clearMergeAtMostOneWorkLimit() {
      bitField2_ = (bitField2_ & ~0x00008000);
      mergeAtMostOneWorkLimit_ = 100000000D;
      onChanged();
      return this;
    }

    private int presolveSubstitutionLevel_ = 1;
    /**
     * <pre>
     * How much substitution (also called free variable aggregation in MIP
     * litterature) should we perform at presolve. This currently only concerns
     * variable appearing only in linear constraints. For now the value 0 turns it
     * off and any positive value performs substitution.
     * </pre>
     *
     * <code>optional int32 presolve_substitution_level = 147 [default = 1];</code>
     * @return Whether the presolveSubstitutionLevel field is set.
     */
    @java.lang.Override
    public boolean hasPresolveSubstitutionLevel() {
      return ((bitField2_ & 0x00010000) != 0);
    }
    /**
     * <pre>
     * How much substitution (also called free variable aggregation in MIP
     * litterature) should we perform at presolve. This currently only concerns
     * variable appearing only in linear constraints. For now the value 0 turns it
     * off and any positive value performs substitution.
     * </pre>
     *
     * <code>optional int32 presolve_substitution_level = 147 [default = 1];</code>
     * @return The presolveSubstitutionLevel.
     */
    @java.lang.Override
    public int getPresolveSubstitutionLevel() {
      return presolveSubstitutionLevel_;
    }
    /**
     * <pre>
     * How much substitution (also called free variable aggregation in MIP
     * litterature) should we perform at presolve. This currently only concerns
     * variable appearing only in linear constraints. For now the value 0 turns it
     * off and any positive value performs substitution.
     * </pre>
     *
     * <code>optional int32 presolve_substitution_level = 147 [default = 1];</code>
     * @param value The presolveSubstitutionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setPresolveSubstitutionLevel(int value) {

      presolveSubstitutionLevel_ = value;
      bitField2_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * How much substitution (also called free variable aggregation in MIP
     * litterature) should we perform at presolve. This currently only concerns
     * variable appearing only in linear constraints. For now the value 0 turns it
     * off and any positive value performs substitution.
     * </pre>
     *
     * <code>optional int32 presolve_substitution_level = 147 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearPresolveSubstitutionLevel() {
      bitField2_ = (bitField2_ & ~0x00010000);
      presolveSubstitutionLevel_ = 1;
      onChanged();
      return this;
    }

    private boolean presolveExtractIntegerEnforcement_ ;
    /**
     * <pre>
     * If true, we will extract from linear constraints, enforcement literals of
     * the form "integer variable at bound =&gt; simplified constraint". This should
     * always be beneficial except that we don't always handle them as efficiently
     * as we could for now. This causes problem on manna81.mps (LP relaxation not
     * as tight it seems) and on neos-3354841-apure.mps.gz (too many literals
     * created this way).
     * </pre>
     *
     * <code>optional bool presolve_extract_integer_enforcement = 174 [default = false];</code>
     * @return Whether the presolveExtractIntegerEnforcement field is set.
     */
    @java.lang.Override
    public boolean hasPresolveExtractIntegerEnforcement() {
      return ((bitField2_ & 0x00020000) != 0);
    }
    /**
     * <pre>
     * If true, we will extract from linear constraints, enforcement literals of
     * the form "integer variable at bound =&gt; simplified constraint". This should
     * always be beneficial except that we don't always handle them as efficiently
     * as we could for now. This causes problem on manna81.mps (LP relaxation not
     * as tight it seems) and on neos-3354841-apure.mps.gz (too many literals
     * created this way).
     * </pre>
     *
     * <code>optional bool presolve_extract_integer_enforcement = 174 [default = false];</code>
     * @return The presolveExtractIntegerEnforcement.
     */
    @java.lang.Override
    public boolean getPresolveExtractIntegerEnforcement() {
      return presolveExtractIntegerEnforcement_;
    }
    /**
     * <pre>
     * If true, we will extract from linear constraints, enforcement literals of
     * the form "integer variable at bound =&gt; simplified constraint". This should
     * always be beneficial except that we don't always handle them as efficiently
     * as we could for now. This causes problem on manna81.mps (LP relaxation not
     * as tight it seems) and on neos-3354841-apure.mps.gz (too many literals
     * created this way).
     * </pre>
     *
     * <code>optional bool presolve_extract_integer_enforcement = 174 [default = false];</code>
     * @param value The presolveExtractIntegerEnforcement to set.
     * @return This builder for chaining.
     */
    public Builder setPresolveExtractIntegerEnforcement(boolean value) {

      presolveExtractIntegerEnforcement_ = value;
      bitField2_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, we will extract from linear constraints, enforcement literals of
     * the form "integer variable at bound =&gt; simplified constraint". This should
     * always be beneficial except that we don't always handle them as efficiently
     * as we could for now. This causes problem on manna81.mps (LP relaxation not
     * as tight it seems) and on neos-3354841-apure.mps.gz (too many literals
     * created this way).
     * </pre>
     *
     * <code>optional bool presolve_extract_integer_enforcement = 174 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearPresolveExtractIntegerEnforcement() {
      bitField2_ = (bitField2_ & ~0x00020000);
      presolveExtractIntegerEnforcement_ = false;
      onChanged();
      return this;
    }

    private long presolveInclusionWorkLimit_ = 100000000L;
    /**
     * <pre>
     * A few presolve operations involve detecting constraints included in other
     * constraint. Since there can be a quadratic number of such pairs, and
     * processing them usually involve scanning them, the complexity of these
     * operations can be big. This enforce a local deterministic limit on the
     * number of entries scanned. Default is 1e8.
     *
     * A value of zero will disable these presolve rules completely.
     * </pre>
     *
     * <code>optional int64 presolve_inclusion_work_limit = 201 [default = 100000000];</code>
     * @return Whether the presolveInclusionWorkLimit field is set.
     */
    @java.lang.Override
    public boolean hasPresolveInclusionWorkLimit() {
      return ((bitField2_ & 0x00040000) != 0);
    }
    /**
     * <pre>
     * A few presolve operations involve detecting constraints included in other
     * constraint. Since there can be a quadratic number of such pairs, and
     * processing them usually involve scanning them, the complexity of these
     * operations can be big. This enforce a local deterministic limit on the
     * number of entries scanned. Default is 1e8.
     *
     * A value of zero will disable these presolve rules completely.
     * </pre>
     *
     * <code>optional int64 presolve_inclusion_work_limit = 201 [default = 100000000];</code>
     * @return The presolveInclusionWorkLimit.
     */
    @java.lang.Override
    public long getPresolveInclusionWorkLimit() {
      return presolveInclusionWorkLimit_;
    }
    /**
     * <pre>
     * A few presolve operations involve detecting constraints included in other
     * constraint. Since there can be a quadratic number of such pairs, and
     * processing them usually involve scanning them, the complexity of these
     * operations can be big. This enforce a local deterministic limit on the
     * number of entries scanned. Default is 1e8.
     *
     * A value of zero will disable these presolve rules completely.
     * </pre>
     *
     * <code>optional int64 presolve_inclusion_work_limit = 201 [default = 100000000];</code>
     * @param value The presolveInclusionWorkLimit to set.
     * @return This builder for chaining.
     */
    public Builder setPresolveInclusionWorkLimit(long value) {

      presolveInclusionWorkLimit_ = value;
      bitField2_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A few presolve operations involve detecting constraints included in other
     * constraint. Since there can be a quadratic number of such pairs, and
     * processing them usually involve scanning them, the complexity of these
     * operations can be big. This enforce a local deterministic limit on the
     * number of entries scanned. Default is 1e8.
     *
     * A value of zero will disable these presolve rules completely.
     * </pre>
     *
     * <code>optional int64 presolve_inclusion_work_limit = 201 [default = 100000000];</code>
     * @return This builder for chaining.
     */
    public Builder clearPresolveInclusionWorkLimit() {
      bitField2_ = (bitField2_ & ~0x00040000);
      presolveInclusionWorkLimit_ = 100000000L;
      onChanged();
      return this;
    }

    private boolean ignoreNames_ = true;
    /**
     * <pre>
     * If true, we don't keep names in our internal copy of the user given model.
     * </pre>
     *
     * <code>optional bool ignore_names = 202 [default = true];</code>
     * @return Whether the ignoreNames field is set.
     */
    @java.lang.Override
    public boolean hasIgnoreNames() {
      return ((bitField2_ & 0x00080000) != 0);
    }
    /**
     * <pre>
     * If true, we don't keep names in our internal copy of the user given model.
     * </pre>
     *
     * <code>optional bool ignore_names = 202 [default = true];</code>
     * @return The ignoreNames.
     */
    @java.lang.Override
    public boolean getIgnoreNames() {
      return ignoreNames_;
    }
    /**
     * <pre>
     * If true, we don't keep names in our internal copy of the user given model.
     * </pre>
     *
     * <code>optional bool ignore_names = 202 [default = true];</code>
     * @param value The ignoreNames to set.
     * @return This builder for chaining.
     */
    public Builder setIgnoreNames(boolean value) {

      ignoreNames_ = value;
      bitField2_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, we don't keep names in our internal copy of the user given model.
     * </pre>
     *
     * <code>optional bool ignore_names = 202 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearIgnoreNames() {
      bitField2_ = (bitField2_ & ~0x00080000);
      ignoreNames_ = true;
      onChanged();
      return this;
    }

    private boolean inferAllDiffs_ = true;
    /**
     * <pre>
     * Run a max-clique code amongst all the x != y we can find and try to infer
     * set of variables that are all different. This allows to close neos16.mps
     * for instance. Note that we only run this code if there is no all_diff
     * already in the model so that if a user want to add some all_diff, we assume
     * it is well done and do not try to add more.
     *
     * This will also detect and add no_overlap constraints, if all the relations
     * x != y have "offsets" between them. I.e. x &gt; y + offset.
     * </pre>
     *
     * <code>optional bool infer_all_diffs = 233 [default = true];</code>
     * @return Whether the inferAllDiffs field is set.
     */
    @java.lang.Override
    public boolean hasInferAllDiffs() {
      return ((bitField2_ & 0x00100000) != 0);
    }
    /**
     * <pre>
     * Run a max-clique code amongst all the x != y we can find and try to infer
     * set of variables that are all different. This allows to close neos16.mps
     * for instance. Note that we only run this code if there is no all_diff
     * already in the model so that if a user want to add some all_diff, we assume
     * it is well done and do not try to add more.
     *
     * This will also detect and add no_overlap constraints, if all the relations
     * x != y have "offsets" between them. I.e. x &gt; y + offset.
     * </pre>
     *
     * <code>optional bool infer_all_diffs = 233 [default = true];</code>
     * @return The inferAllDiffs.
     */
    @java.lang.Override
    public boolean getInferAllDiffs() {
      return inferAllDiffs_;
    }
    /**
     * <pre>
     * Run a max-clique code amongst all the x != y we can find and try to infer
     * set of variables that are all different. This allows to close neos16.mps
     * for instance. Note that we only run this code if there is no all_diff
     * already in the model so that if a user want to add some all_diff, we assume
     * it is well done and do not try to add more.
     *
     * This will also detect and add no_overlap constraints, if all the relations
     * x != y have "offsets" between them. I.e. x &gt; y + offset.
     * </pre>
     *
     * <code>optional bool infer_all_diffs = 233 [default = true];</code>
     * @param value The inferAllDiffs to set.
     * @return This builder for chaining.
     */
    public Builder setInferAllDiffs(boolean value) {

      inferAllDiffs_ = value;
      bitField2_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Run a max-clique code amongst all the x != y we can find and try to infer
     * set of variables that are all different. This allows to close neos16.mps
     * for instance. Note that we only run this code if there is no all_diff
     * already in the model so that if a user want to add some all_diff, we assume
     * it is well done and do not try to add more.
     *
     * This will also detect and add no_overlap constraints, if all the relations
     * x != y have "offsets" between them. I.e. x &gt; y + offset.
     * </pre>
     *
     * <code>optional bool infer_all_diffs = 233 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearInferAllDiffs() {
      bitField2_ = (bitField2_ & ~0x00100000);
      inferAllDiffs_ = true;
      onChanged();
      return this;
    }

    private boolean findBigLinearOverlap_ = true;
    /**
     * <pre>
     * Try to find large "rectangle" in the linear constraint matrix with
     * identical lines. If such rectangle is big enough, we can introduce a new
     * integer variable corresponding to the common expression and greatly reduce
     * the number of non-zero.
     * </pre>
     *
     * <code>optional bool find_big_linear_overlap = 234 [default = true];</code>
     * @return Whether the findBigLinearOverlap field is set.
     */
    @java.lang.Override
    public boolean hasFindBigLinearOverlap() {
      return ((bitField2_ & 0x00200000) != 0);
    }
    /**
     * <pre>
     * Try to find large "rectangle" in the linear constraint matrix with
     * identical lines. If such rectangle is big enough, we can introduce a new
     * integer variable corresponding to the common expression and greatly reduce
     * the number of non-zero.
     * </pre>
     *
     * <code>optional bool find_big_linear_overlap = 234 [default = true];</code>
     * @return The findBigLinearOverlap.
     */
    @java.lang.Override
    public boolean getFindBigLinearOverlap() {
      return findBigLinearOverlap_;
    }
    /**
     * <pre>
     * Try to find large "rectangle" in the linear constraint matrix with
     * identical lines. If such rectangle is big enough, we can introduce a new
     * integer variable corresponding to the common expression and greatly reduce
     * the number of non-zero.
     * </pre>
     *
     * <code>optional bool find_big_linear_overlap = 234 [default = true];</code>
     * @param value The findBigLinearOverlap to set.
     * @return This builder for chaining.
     */
    public Builder setFindBigLinearOverlap(boolean value) {

      findBigLinearOverlap_ = value;
      bitField2_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Try to find large "rectangle" in the linear constraint matrix with
     * identical lines. If such rectangle is big enough, we can introduce a new
     * integer variable corresponding to the common expression and greatly reduce
     * the number of non-zero.
     * </pre>
     *
     * <code>optional bool find_big_linear_overlap = 234 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearFindBigLinearOverlap() {
      bitField2_ = (bitField2_ & ~0x00200000);
      findBigLinearOverlap_ = true;
      onChanged();
      return this;
    }

    private boolean useSatInprocessing_ = true;
    /**
     * <pre>
     * Enable or disable "inprocessing" which is some SAT presolving done at
     * each restart to the root level.
     * </pre>
     *
     * <code>optional bool use_sat_inprocessing = 163 [default = true];</code>
     * @return Whether the useSatInprocessing field is set.
     */
    @java.lang.Override
    public boolean hasUseSatInprocessing() {
      return ((bitField2_ & 0x00400000) != 0);
    }
    /**
     * <pre>
     * Enable or disable "inprocessing" which is some SAT presolving done at
     * each restart to the root level.
     * </pre>
     *
     * <code>optional bool use_sat_inprocessing = 163 [default = true];</code>
     * @return The useSatInprocessing.
     */
    @java.lang.Override
    public boolean getUseSatInprocessing() {
      return useSatInprocessing_;
    }
    /**
     * <pre>
     * Enable or disable "inprocessing" which is some SAT presolving done at
     * each restart to the root level.
     * </pre>
     *
     * <code>optional bool use_sat_inprocessing = 163 [default = true];</code>
     * @param value The useSatInprocessing to set.
     * @return This builder for chaining.
     */
    public Builder setUseSatInprocessing(boolean value) {

      useSatInprocessing_ = value;
      bitField2_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Enable or disable "inprocessing" which is some SAT presolving done at
     * each restart to the root level.
     * </pre>
     *
     * <code>optional bool use_sat_inprocessing = 163 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseSatInprocessing() {
      bitField2_ = (bitField2_ & ~0x00400000);
      useSatInprocessing_ = true;
      onChanged();
      return this;
    }

    private double inprocessingDtimeRatio_ = 0.2D;
    /**
     * <pre>
     * Proportion of deterministic time we should spend on inprocessing.
     * At each "restart", if the proportion is below this ratio, we will do some
     * inprocessing, otherwise, we skip it for this restart.
     * </pre>
     *
     * <code>optional double inprocessing_dtime_ratio = 273 [default = 0.2];</code>
     * @return Whether the inprocessingDtimeRatio field is set.
     */
    @java.lang.Override
    public boolean hasInprocessingDtimeRatio() {
      return ((bitField2_ & 0x00800000) != 0);
    }
    /**
     * <pre>
     * Proportion of deterministic time we should spend on inprocessing.
     * At each "restart", if the proportion is below this ratio, we will do some
     * inprocessing, otherwise, we skip it for this restart.
     * </pre>
     *
     * <code>optional double inprocessing_dtime_ratio = 273 [default = 0.2];</code>
     * @return The inprocessingDtimeRatio.
     */
    @java.lang.Override
    public double getInprocessingDtimeRatio() {
      return inprocessingDtimeRatio_;
    }
    /**
     * <pre>
     * Proportion of deterministic time we should spend on inprocessing.
     * At each "restart", if the proportion is below this ratio, we will do some
     * inprocessing, otherwise, we skip it for this restart.
     * </pre>
     *
     * <code>optional double inprocessing_dtime_ratio = 273 [default = 0.2];</code>
     * @param value The inprocessingDtimeRatio to set.
     * @return This builder for chaining.
     */
    public Builder setInprocessingDtimeRatio(double value) {

      inprocessingDtimeRatio_ = value;
      bitField2_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Proportion of deterministic time we should spend on inprocessing.
     * At each "restart", if the proportion is below this ratio, we will do some
     * inprocessing, otherwise, we skip it for this restart.
     * </pre>
     *
     * <code>optional double inprocessing_dtime_ratio = 273 [default = 0.2];</code>
     * @return This builder for chaining.
     */
    public Builder clearInprocessingDtimeRatio() {
      bitField2_ = (bitField2_ & ~0x00800000);
      inprocessingDtimeRatio_ = 0.2D;
      onChanged();
      return this;
    }

    private double inprocessingProbingDtime_ = 1D;
    /**
     * <pre>
     * The amount of dtime we should spend on probing for each inprocessing round.
     * </pre>
     *
     * <code>optional double inprocessing_probing_dtime = 274 [default = 1];</code>
     * @return Whether the inprocessingProbingDtime field is set.
     */
    @java.lang.Override
    public boolean hasInprocessingProbingDtime() {
      return ((bitField2_ & 0x01000000) != 0);
    }
    /**
     * <pre>
     * The amount of dtime we should spend on probing for each inprocessing round.
     * </pre>
     *
     * <code>optional double inprocessing_probing_dtime = 274 [default = 1];</code>
     * @return The inprocessingProbingDtime.
     */
    @java.lang.Override
    public double getInprocessingProbingDtime() {
      return inprocessingProbingDtime_;
    }
    /**
     * <pre>
     * The amount of dtime we should spend on probing for each inprocessing round.
     * </pre>
     *
     * <code>optional double inprocessing_probing_dtime = 274 [default = 1];</code>
     * @param value The inprocessingProbingDtime to set.
     * @return This builder for chaining.
     */
    public Builder setInprocessingProbingDtime(double value) {

      inprocessingProbingDtime_ = value;
      bitField2_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The amount of dtime we should spend on probing for each inprocessing round.
     * </pre>
     *
     * <code>optional double inprocessing_probing_dtime = 274 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearInprocessingProbingDtime() {
      bitField2_ = (bitField2_ & ~0x01000000);
      inprocessingProbingDtime_ = 1D;
      onChanged();
      return this;
    }

    private double inprocessingMinimizationDtime_ = 1D;
    /**
     * <pre>
     * Parameters for an heuristic similar to the one described in "An effective
     * learnt clause minimization approach for CDCL Sat Solvers",
     * https://www.ijcai.org/proceedings/2017/0098.pdf
     *
     * This is the amount of dtime we should spend on this technique during each
     * inprocessing phase.
     *
     * The minimization technique is the same as the one used to minimize core in
     * max-sat. We also minimize problem clauses and not just the learned clause
     * that we keep forever like in the paper.
     * </pre>
     *
     * <code>optional double inprocessing_minimization_dtime = 275 [default = 1];</code>
     * @return Whether the inprocessingMinimizationDtime field is set.
     */
    @java.lang.Override
    public boolean hasInprocessingMinimizationDtime() {
      return ((bitField2_ & 0x02000000) != 0);
    }
    /**
     * <pre>
     * Parameters for an heuristic similar to the one described in "An effective
     * learnt clause minimization approach for CDCL Sat Solvers",
     * https://www.ijcai.org/proceedings/2017/0098.pdf
     *
     * This is the amount of dtime we should spend on this technique during each
     * inprocessing phase.
     *
     * The minimization technique is the same as the one used to minimize core in
     * max-sat. We also minimize problem clauses and not just the learned clause
     * that we keep forever like in the paper.
     * </pre>
     *
     * <code>optional double inprocessing_minimization_dtime = 275 [default = 1];</code>
     * @return The inprocessingMinimizationDtime.
     */
    @java.lang.Override
    public double getInprocessingMinimizationDtime() {
      return inprocessingMinimizationDtime_;
    }
    /**
     * <pre>
     * Parameters for an heuristic similar to the one described in "An effective
     * learnt clause minimization approach for CDCL Sat Solvers",
     * https://www.ijcai.org/proceedings/2017/0098.pdf
     *
     * This is the amount of dtime we should spend on this technique during each
     * inprocessing phase.
     *
     * The minimization technique is the same as the one used to minimize core in
     * max-sat. We also minimize problem clauses and not just the learned clause
     * that we keep forever like in the paper.
     * </pre>
     *
     * <code>optional double inprocessing_minimization_dtime = 275 [default = 1];</code>
     * @param value The inprocessingMinimizationDtime to set.
     * @return This builder for chaining.
     */
    public Builder setInprocessingMinimizationDtime(double value) {

      inprocessingMinimizationDtime_ = value;
      bitField2_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Parameters for an heuristic similar to the one described in "An effective
     * learnt clause minimization approach for CDCL Sat Solvers",
     * https://www.ijcai.org/proceedings/2017/0098.pdf
     *
     * This is the amount of dtime we should spend on this technique during each
     * inprocessing phase.
     *
     * The minimization technique is the same as the one used to minimize core in
     * max-sat. We also minimize problem clauses and not just the learned clause
     * that we keep forever like in the paper.
     * </pre>
     *
     * <code>optional double inprocessing_minimization_dtime = 275 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearInprocessingMinimizationDtime() {
      bitField2_ = (bitField2_ & ~0x02000000);
      inprocessingMinimizationDtime_ = 1D;
      onChanged();
      return this;
    }

    private int numWorkers_ ;
    /**
     * <pre>
     * Specify the number of parallel workers (i.e. threads) to use during search.
     * This should usually be lower than your number of available cpus +
     * hyperthread in your machine.
     *
     * A value of 0 means the solver will try to use all cores on the machine.
     * A number of 1 means no parallelism.
     *
     * Note that 'num_workers' is the preferred name, but if it is set to zero,
     * we will still read the deprecated 'num_search_workers'.
     *
     * As of 2020-04-10, if you're using SAT via MPSolver (to solve integer
     * programs) this field is overridden with a value of 8, if the field is not
     * set *explicitly*. Thus, always set this field explicitly or via
     * MPSolver::SetNumThreads().
     * </pre>
     *
     * <code>optional int32 num_workers = 206 [default = 0];</code>
     * @return Whether the numWorkers field is set.
     */
    @java.lang.Override
    public boolean hasNumWorkers() {
      return ((bitField2_ & 0x04000000) != 0);
    }
    /**
     * <pre>
     * Specify the number of parallel workers (i.e. threads) to use during search.
     * This should usually be lower than your number of available cpus +
     * hyperthread in your machine.
     *
     * A value of 0 means the solver will try to use all cores on the machine.
     * A number of 1 means no parallelism.
     *
     * Note that 'num_workers' is the preferred name, but if it is set to zero,
     * we will still read the deprecated 'num_search_workers'.
     *
     * As of 2020-04-10, if you're using SAT via MPSolver (to solve integer
     * programs) this field is overridden with a value of 8, if the field is not
     * set *explicitly*. Thus, always set this field explicitly or via
     * MPSolver::SetNumThreads().
     * </pre>
     *
     * <code>optional int32 num_workers = 206 [default = 0];</code>
     * @return The numWorkers.
     */
    @java.lang.Override
    public int getNumWorkers() {
      return numWorkers_;
    }
    /**
     * <pre>
     * Specify the number of parallel workers (i.e. threads) to use during search.
     * This should usually be lower than your number of available cpus +
     * hyperthread in your machine.
     *
     * A value of 0 means the solver will try to use all cores on the machine.
     * A number of 1 means no parallelism.
     *
     * Note that 'num_workers' is the preferred name, but if it is set to zero,
     * we will still read the deprecated 'num_search_workers'.
     *
     * As of 2020-04-10, if you're using SAT via MPSolver (to solve integer
     * programs) this field is overridden with a value of 8, if the field is not
     * set *explicitly*. Thus, always set this field explicitly or via
     * MPSolver::SetNumThreads().
     * </pre>
     *
     * <code>optional int32 num_workers = 206 [default = 0];</code>
     * @param value The numWorkers to set.
     * @return This builder for chaining.
     */
    public Builder setNumWorkers(int value) {

      numWorkers_ = value;
      bitField2_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specify the number of parallel workers (i.e. threads) to use during search.
     * This should usually be lower than your number of available cpus +
     * hyperthread in your machine.
     *
     * A value of 0 means the solver will try to use all cores on the machine.
     * A number of 1 means no parallelism.
     *
     * Note that 'num_workers' is the preferred name, but if it is set to zero,
     * we will still read the deprecated 'num_search_workers'.
     *
     * As of 2020-04-10, if you're using SAT via MPSolver (to solve integer
     * programs) this field is overridden with a value of 8, if the field is not
     * set *explicitly*. Thus, always set this field explicitly or via
     * MPSolver::SetNumThreads().
     * </pre>
     *
     * <code>optional int32 num_workers = 206 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearNumWorkers() {
      bitField2_ = (bitField2_ & ~0x04000000);
      numWorkers_ = 0;
      onChanged();
      return this;
    }

    private int numSearchWorkers_ ;
    /**
     * <code>optional int32 num_search_workers = 100 [default = 0];</code>
     * @return Whether the numSearchWorkers field is set.
     */
    @java.lang.Override
    public boolean hasNumSearchWorkers() {
      return ((bitField2_ & 0x08000000) != 0);
    }
    /**
     * <code>optional int32 num_search_workers = 100 [default = 0];</code>
     * @return The numSearchWorkers.
     */
    @java.lang.Override
    public int getNumSearchWorkers() {
      return numSearchWorkers_;
    }
    /**
     * <code>optional int32 num_search_workers = 100 [default = 0];</code>
     * @param value The numSearchWorkers to set.
     * @return This builder for chaining.
     */
    public Builder setNumSearchWorkers(int value) {

      numSearchWorkers_ = value;
      bitField2_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     * <code>optional int32 num_search_workers = 100 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearNumSearchWorkers() {
      bitField2_ = (bitField2_ & ~0x08000000);
      numSearchWorkers_ = 0;
      onChanged();
      return this;
    }

    private int numFullSubsolvers_ ;
    /**
     * <pre>
     * We distinguish subsolvers that consume a full thread, and the ones that are
     * always interleaved. If left at zero, we will fix this with a default
     * formula that depends on num_workers. But if you start modifying what runs,
     * you might want to fix that to a given value depending on the num_workers
     * you use.
     * </pre>
     *
     * <code>optional int32 num_full_subsolvers = 294 [default = 0];</code>
     * @return Whether the numFullSubsolvers field is set.
     */
    @java.lang.Override
    public boolean hasNumFullSubsolvers() {
      return ((bitField2_ & 0x10000000) != 0);
    }
    /**
     * <pre>
     * We distinguish subsolvers that consume a full thread, and the ones that are
     * always interleaved. If left at zero, we will fix this with a default
     * formula that depends on num_workers. But if you start modifying what runs,
     * you might want to fix that to a given value depending on the num_workers
     * you use.
     * </pre>
     *
     * <code>optional int32 num_full_subsolvers = 294 [default = 0];</code>
     * @return The numFullSubsolvers.
     */
    @java.lang.Override
    public int getNumFullSubsolvers() {
      return numFullSubsolvers_;
    }
    /**
     * <pre>
     * We distinguish subsolvers that consume a full thread, and the ones that are
     * always interleaved. If left at zero, we will fix this with a default
     * formula that depends on num_workers. But if you start modifying what runs,
     * you might want to fix that to a given value depending on the num_workers
     * you use.
     * </pre>
     *
     * <code>optional int32 num_full_subsolvers = 294 [default = 0];</code>
     * @param value The numFullSubsolvers to set.
     * @return This builder for chaining.
     */
    public Builder setNumFullSubsolvers(int value) {

      numFullSubsolvers_ = value;
      bitField2_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * We distinguish subsolvers that consume a full thread, and the ones that are
     * always interleaved. If left at zero, we will fix this with a default
     * formula that depends on num_workers. But if you start modifying what runs,
     * you might want to fix that to a given value depending on the num_workers
     * you use.
     * </pre>
     *
     * <code>optional int32 num_full_subsolvers = 294 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearNumFullSubsolvers() {
      bitField2_ = (bitField2_ & ~0x10000000);
      numFullSubsolvers_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList subsolvers_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureSubsolversIsMutable() {
      if (!subsolvers_.isModifiable()) {
        subsolvers_ = new com.google.protobuf.LazyStringArrayList(subsolvers_);
      }
      bitField2_ |= 0x20000000;
    }
    /**
     * <pre>
     * In multi-thread, the solver can be mainly seen as a portfolio of solvers
     * with different parameters. This field indicates the names of the parameters
     * that are used in multithread. This only applies to "full" subsolvers.
     *
     * See cp_model_search.cc to see a list of the names and the default value (if
     * left empty) that looks like:
     * - default_lp           (linearization_level:1)
     * - fixed                (only if fixed search specified or scheduling)
     * - no_lp                (linearization_level:0)
     * - max_lp               (linearization_level:2)
     * - pseudo_costs         (only if objective, change search heuristic)
     * - reduced_costs        (only if objective, change search heuristic)
     * - quick_restart        (kind of probing)
     * - quick_restart_no_lp  (kind of probing with linearization_level:0)
     * - lb_tree_search       (to improve lower bound, MIP like tree search)
     * - probing              (continuous probing and shaving)
     *
     * Also, note that some set of parameters will be ignored if they do not make
     * sense. For instance if there is no objective, pseudo_cost or reduced_cost
     * search will be ignored. Core based search will only work if the objective
     * has many terms. If there is no fixed strategy fixed will be ignored. And so
     * on.
     *
     * The order is important, as only the first num_full_subsolvers will be
     * scheduled. You can see in the log which one are selected for a given run.
     * </pre>
     *
     * <code>repeated string subsolvers = 207;</code>
     * @return A list containing the subsolvers.
     */
    public com.google.protobuf.ProtocolStringList
        getSubsolversList() {
      subsolvers_.makeImmutable();
      return subsolvers_;
    }
    /**
     * <pre>
     * In multi-thread, the solver can be mainly seen as a portfolio of solvers
     * with different parameters. This field indicates the names of the parameters
     * that are used in multithread. This only applies to "full" subsolvers.
     *
     * See cp_model_search.cc to see a list of the names and the default value (if
     * left empty) that looks like:
     * - default_lp           (linearization_level:1)
     * - fixed                (only if fixed search specified or scheduling)
     * - no_lp                (linearization_level:0)
     * - max_lp               (linearization_level:2)
     * - pseudo_costs         (only if objective, change search heuristic)
     * - reduced_costs        (only if objective, change search heuristic)
     * - quick_restart        (kind of probing)
     * - quick_restart_no_lp  (kind of probing with linearization_level:0)
     * - lb_tree_search       (to improve lower bound, MIP like tree search)
     * - probing              (continuous probing and shaving)
     *
     * Also, note that some set of parameters will be ignored if they do not make
     * sense. For instance if there is no objective, pseudo_cost or reduced_cost
     * search will be ignored. Core based search will only work if the objective
     * has many terms. If there is no fixed strategy fixed will be ignored. And so
     * on.
     *
     * The order is important, as only the first num_full_subsolvers will be
     * scheduled. You can see in the log which one are selected for a given run.
     * </pre>
     *
     * <code>repeated string subsolvers = 207;</code>
     * @return The count of subsolvers.
     */
    public int getSubsolversCount() {
      return subsolvers_.size();
    }
    /**
     * <pre>
     * In multi-thread, the solver can be mainly seen as a portfolio of solvers
     * with different parameters. This field indicates the names of the parameters
     * that are used in multithread. This only applies to "full" subsolvers.
     *
     * See cp_model_search.cc to see a list of the names and the default value (if
     * left empty) that looks like:
     * - default_lp           (linearization_level:1)
     * - fixed                (only if fixed search specified or scheduling)
     * - no_lp                (linearization_level:0)
     * - max_lp               (linearization_level:2)
     * - pseudo_costs         (only if objective, change search heuristic)
     * - reduced_costs        (only if objective, change search heuristic)
     * - quick_restart        (kind of probing)
     * - quick_restart_no_lp  (kind of probing with linearization_level:0)
     * - lb_tree_search       (to improve lower bound, MIP like tree search)
     * - probing              (continuous probing and shaving)
     *
     * Also, note that some set of parameters will be ignored if they do not make
     * sense. For instance if there is no objective, pseudo_cost or reduced_cost
     * search will be ignored. Core based search will only work if the objective
     * has many terms. If there is no fixed strategy fixed will be ignored. And so
     * on.
     *
     * The order is important, as only the first num_full_subsolvers will be
     * scheduled. You can see in the log which one are selected for a given run.
     * </pre>
     *
     * <code>repeated string subsolvers = 207;</code>
     * @param index The index of the element to return.
     * @return The subsolvers at the given index.
     */
    public java.lang.String getSubsolvers(int index) {
      return subsolvers_.get(index);
    }
    /**
     * <pre>
     * In multi-thread, the solver can be mainly seen as a portfolio of solvers
     * with different parameters. This field indicates the names of the parameters
     * that are used in multithread. This only applies to "full" subsolvers.
     *
     * See cp_model_search.cc to see a list of the names and the default value (if
     * left empty) that looks like:
     * - default_lp           (linearization_level:1)
     * - fixed                (only if fixed search specified or scheduling)
     * - no_lp                (linearization_level:0)
     * - max_lp               (linearization_level:2)
     * - pseudo_costs         (only if objective, change search heuristic)
     * - reduced_costs        (only if objective, change search heuristic)
     * - quick_restart        (kind of probing)
     * - quick_restart_no_lp  (kind of probing with linearization_level:0)
     * - lb_tree_search       (to improve lower bound, MIP like tree search)
     * - probing              (continuous probing and shaving)
     *
     * Also, note that some set of parameters will be ignored if they do not make
     * sense. For instance if there is no objective, pseudo_cost or reduced_cost
     * search will be ignored. Core based search will only work if the objective
     * has many terms. If there is no fixed strategy fixed will be ignored. And so
     * on.
     *
     * The order is important, as only the first num_full_subsolvers will be
     * scheduled. You can see in the log which one are selected for a given run.
     * </pre>
     *
     * <code>repeated string subsolvers = 207;</code>
     * @param index The index of the value to return.
     * @return The bytes of the subsolvers at the given index.
     */
    public com.google.protobuf.ByteString
        getSubsolversBytes(int index) {
      return subsolvers_.getByteString(index);
    }
    /**
     * <pre>
     * In multi-thread, the solver can be mainly seen as a portfolio of solvers
     * with different parameters. This field indicates the names of the parameters
     * that are used in multithread. This only applies to "full" subsolvers.
     *
     * See cp_model_search.cc to see a list of the names and the default value (if
     * left empty) that looks like:
     * - default_lp           (linearization_level:1)
     * - fixed                (only if fixed search specified or scheduling)
     * - no_lp                (linearization_level:0)
     * - max_lp               (linearization_level:2)
     * - pseudo_costs         (only if objective, change search heuristic)
     * - reduced_costs        (only if objective, change search heuristic)
     * - quick_restart        (kind of probing)
     * - quick_restart_no_lp  (kind of probing with linearization_level:0)
     * - lb_tree_search       (to improve lower bound, MIP like tree search)
     * - probing              (continuous probing and shaving)
     *
     * Also, note that some set of parameters will be ignored if they do not make
     * sense. For instance if there is no objective, pseudo_cost or reduced_cost
     * search will be ignored. Core based search will only work if the objective
     * has many terms. If there is no fixed strategy fixed will be ignored. And so
     * on.
     *
     * The order is important, as only the first num_full_subsolvers will be
     * scheduled. You can see in the log which one are selected for a given run.
     * </pre>
     *
     * <code>repeated string subsolvers = 207;</code>
     * @param index The index to set the value at.
     * @param value The subsolvers to set.
     * @return This builder for chaining.
     */
    public Builder setSubsolvers(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureSubsolversIsMutable();
      subsolvers_.set(index, value);
      bitField2_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * In multi-thread, the solver can be mainly seen as a portfolio of solvers
     * with different parameters. This field indicates the names of the parameters
     * that are used in multithread. This only applies to "full" subsolvers.
     *
     * See cp_model_search.cc to see a list of the names and the default value (if
     * left empty) that looks like:
     * - default_lp           (linearization_level:1)
     * - fixed                (only if fixed search specified or scheduling)
     * - no_lp                (linearization_level:0)
     * - max_lp               (linearization_level:2)
     * - pseudo_costs         (only if objective, change search heuristic)
     * - reduced_costs        (only if objective, change search heuristic)
     * - quick_restart        (kind of probing)
     * - quick_restart_no_lp  (kind of probing with linearization_level:0)
     * - lb_tree_search       (to improve lower bound, MIP like tree search)
     * - probing              (continuous probing and shaving)
     *
     * Also, note that some set of parameters will be ignored if they do not make
     * sense. For instance if there is no objective, pseudo_cost or reduced_cost
     * search will be ignored. Core based search will only work if the objective
     * has many terms. If there is no fixed strategy fixed will be ignored. And so
     * on.
     *
     * The order is important, as only the first num_full_subsolvers will be
     * scheduled. You can see in the log which one are selected for a given run.
     * </pre>
     *
     * <code>repeated string subsolvers = 207;</code>
     * @param value The subsolvers to add.
     * @return This builder for chaining.
     */
    public Builder addSubsolvers(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureSubsolversIsMutable();
      subsolvers_.add(value);
      bitField2_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * In multi-thread, the solver can be mainly seen as a portfolio of solvers
     * with different parameters. This field indicates the names of the parameters
     * that are used in multithread. This only applies to "full" subsolvers.
     *
     * See cp_model_search.cc to see a list of the names and the default value (if
     * left empty) that looks like:
     * - default_lp           (linearization_level:1)
     * - fixed                (only if fixed search specified or scheduling)
     * - no_lp                (linearization_level:0)
     * - max_lp               (linearization_level:2)
     * - pseudo_costs         (only if objective, change search heuristic)
     * - reduced_costs        (only if objective, change search heuristic)
     * - quick_restart        (kind of probing)
     * - quick_restart_no_lp  (kind of probing with linearization_level:0)
     * - lb_tree_search       (to improve lower bound, MIP like tree search)
     * - probing              (continuous probing and shaving)
     *
     * Also, note that some set of parameters will be ignored if they do not make
     * sense. For instance if there is no objective, pseudo_cost or reduced_cost
     * search will be ignored. Core based search will only work if the objective
     * has many terms. If there is no fixed strategy fixed will be ignored. And so
     * on.
     *
     * The order is important, as only the first num_full_subsolvers will be
     * scheduled. You can see in the log which one are selected for a given run.
     * </pre>
     *
     * <code>repeated string subsolvers = 207;</code>
     * @param values The subsolvers to add.
     * @return This builder for chaining.
     */
    public Builder addAllSubsolvers(
        java.lang.Iterable<java.lang.String> values) {
      ensureSubsolversIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, subsolvers_);
      bitField2_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * In multi-thread, the solver can be mainly seen as a portfolio of solvers
     * with different parameters. This field indicates the names of the parameters
     * that are used in multithread. This only applies to "full" subsolvers.
     *
     * See cp_model_search.cc to see a list of the names and the default value (if
     * left empty) that looks like:
     * - default_lp           (linearization_level:1)
     * - fixed                (only if fixed search specified or scheduling)
     * - no_lp                (linearization_level:0)
     * - max_lp               (linearization_level:2)
     * - pseudo_costs         (only if objective, change search heuristic)
     * - reduced_costs        (only if objective, change search heuristic)
     * - quick_restart        (kind of probing)
     * - quick_restart_no_lp  (kind of probing with linearization_level:0)
     * - lb_tree_search       (to improve lower bound, MIP like tree search)
     * - probing              (continuous probing and shaving)
     *
     * Also, note that some set of parameters will be ignored if they do not make
     * sense. For instance if there is no objective, pseudo_cost or reduced_cost
     * search will be ignored. Core based search will only work if the objective
     * has many terms. If there is no fixed strategy fixed will be ignored. And so
     * on.
     *
     * The order is important, as only the first num_full_subsolvers will be
     * scheduled. You can see in the log which one are selected for a given run.
     * </pre>
     *
     * <code>repeated string subsolvers = 207;</code>
     * @return This builder for chaining.
     */
    public Builder clearSubsolvers() {
      subsolvers_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField2_ = (bitField2_ & ~0x20000000);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * In multi-thread, the solver can be mainly seen as a portfolio of solvers
     * with different parameters. This field indicates the names of the parameters
     * that are used in multithread. This only applies to "full" subsolvers.
     *
     * See cp_model_search.cc to see a list of the names and the default value (if
     * left empty) that looks like:
     * - default_lp           (linearization_level:1)
     * - fixed                (only if fixed search specified or scheduling)
     * - no_lp                (linearization_level:0)
     * - max_lp               (linearization_level:2)
     * - pseudo_costs         (only if objective, change search heuristic)
     * - reduced_costs        (only if objective, change search heuristic)
     * - quick_restart        (kind of probing)
     * - quick_restart_no_lp  (kind of probing with linearization_level:0)
     * - lb_tree_search       (to improve lower bound, MIP like tree search)
     * - probing              (continuous probing and shaving)
     *
     * Also, note that some set of parameters will be ignored if they do not make
     * sense. For instance if there is no objective, pseudo_cost or reduced_cost
     * search will be ignored. Core based search will only work if the objective
     * has many terms. If there is no fixed strategy fixed will be ignored. And so
     * on.
     *
     * The order is important, as only the first num_full_subsolvers will be
     * scheduled. You can see in the log which one are selected for a given run.
     * </pre>
     *
     * <code>repeated string subsolvers = 207;</code>
     * @param value The bytes of the subsolvers to add.
     * @return This builder for chaining.
     */
    public Builder addSubsolversBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      ensureSubsolversIsMutable();
      subsolvers_.add(value);
      bitField2_ |= 0x20000000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList extraSubsolvers_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureExtraSubsolversIsMutable() {
      if (!extraSubsolvers_.isModifiable()) {
        extraSubsolvers_ = new com.google.protobuf.LazyStringArrayList(extraSubsolvers_);
      }
      bitField2_ |= 0x40000000;
    }
    /**
     * <pre>
     * A convenient way to add more workers types.
     * These will be added at the beginning of the list.
     * </pre>
     *
     * <code>repeated string extra_subsolvers = 219;</code>
     * @return A list containing the extraSubsolvers.
     */
    public com.google.protobuf.ProtocolStringList
        getExtraSubsolversList() {
      extraSubsolvers_.makeImmutable();
      return extraSubsolvers_;
    }
    /**
     * <pre>
     * A convenient way to add more workers types.
     * These will be added at the beginning of the list.
     * </pre>
     *
     * <code>repeated string extra_subsolvers = 219;</code>
     * @return The count of extraSubsolvers.
     */
    public int getExtraSubsolversCount() {
      return extraSubsolvers_.size();
    }
    /**
     * <pre>
     * A convenient way to add more workers types.
     * These will be added at the beginning of the list.
     * </pre>
     *
     * <code>repeated string extra_subsolvers = 219;</code>
     * @param index The index of the element to return.
     * @return The extraSubsolvers at the given index.
     */
    public java.lang.String getExtraSubsolvers(int index) {
      return extraSubsolvers_.get(index);
    }
    /**
     * <pre>
     * A convenient way to add more workers types.
     * These will be added at the beginning of the list.
     * </pre>
     *
     * <code>repeated string extra_subsolvers = 219;</code>
     * @param index The index of the value to return.
     * @return The bytes of the extraSubsolvers at the given index.
     */
    public com.google.protobuf.ByteString
        getExtraSubsolversBytes(int index) {
      return extraSubsolvers_.getByteString(index);
    }
    /**
     * <pre>
     * A convenient way to add more workers types.
     * These will be added at the beginning of the list.
     * </pre>
     *
     * <code>repeated string extra_subsolvers = 219;</code>
     * @param index The index to set the value at.
     * @param value The extraSubsolvers to set.
     * @return This builder for chaining.
     */
    public Builder setExtraSubsolvers(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureExtraSubsolversIsMutable();
      extraSubsolvers_.set(index, value);
      bitField2_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A convenient way to add more workers types.
     * These will be added at the beginning of the list.
     * </pre>
     *
     * <code>repeated string extra_subsolvers = 219;</code>
     * @param value The extraSubsolvers to add.
     * @return This builder for chaining.
     */
    public Builder addExtraSubsolvers(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureExtraSubsolversIsMutable();
      extraSubsolvers_.add(value);
      bitField2_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A convenient way to add more workers types.
     * These will be added at the beginning of the list.
     * </pre>
     *
     * <code>repeated string extra_subsolvers = 219;</code>
     * @param values The extraSubsolvers to add.
     * @return This builder for chaining.
     */
    public Builder addAllExtraSubsolvers(
        java.lang.Iterable<java.lang.String> values) {
      ensureExtraSubsolversIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, extraSubsolvers_);
      bitField2_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A convenient way to add more workers types.
     * These will be added at the beginning of the list.
     * </pre>
     *
     * <code>repeated string extra_subsolvers = 219;</code>
     * @return This builder for chaining.
     */
    public Builder clearExtraSubsolvers() {
      extraSubsolvers_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField2_ = (bitField2_ & ~0x40000000);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A convenient way to add more workers types.
     * These will be added at the beginning of the list.
     * </pre>
     *
     * <code>repeated string extra_subsolvers = 219;</code>
     * @param value The bytes of the extraSubsolvers to add.
     * @return This builder for chaining.
     */
    public Builder addExtraSubsolversBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      ensureExtraSubsolversIsMutable();
      extraSubsolvers_.add(value);
      bitField2_ |= 0x40000000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList ignoreSubsolvers_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureIgnoreSubsolversIsMutable() {
      if (!ignoreSubsolvers_.isModifiable()) {
        ignoreSubsolvers_ = new com.google.protobuf.LazyStringArrayList(ignoreSubsolvers_);
      }
      bitField2_ |= 0x80000000;
    }
    /**
     * <pre>
     * Rather than fully specifying subsolvers, it is often convenient to just
     * remove the ones that are not useful on a given problem or only keep
     * specific ones for testing. Each string is interpreted as a "glob", so we
     * support '*' and '?'.
     *
     * The way this work is that we will only accept a name that match a filter
     * pattern (if non-empty) and do not match an ignore pattern. Note also that
     * these fields work on LNS or LS names even if these are currently not
     * specified via the subsolvers field.
     * </pre>
     *
     * <code>repeated string ignore_subsolvers = 209;</code>
     * @return A list containing the ignoreSubsolvers.
     */
    public com.google.protobuf.ProtocolStringList
        getIgnoreSubsolversList() {
      ignoreSubsolvers_.makeImmutable();
      return ignoreSubsolvers_;
    }
    /**
     * <pre>
     * Rather than fully specifying subsolvers, it is often convenient to just
     * remove the ones that are not useful on a given problem or only keep
     * specific ones for testing. Each string is interpreted as a "glob", so we
     * support '*' and '?'.
     *
     * The way this work is that we will only accept a name that match a filter
     * pattern (if non-empty) and do not match an ignore pattern. Note also that
     * these fields work on LNS or LS names even if these are currently not
     * specified via the subsolvers field.
     * </pre>
     *
     * <code>repeated string ignore_subsolvers = 209;</code>
     * @return The count of ignoreSubsolvers.
     */
    public int getIgnoreSubsolversCount() {
      return ignoreSubsolvers_.size();
    }
    /**
     * <pre>
     * Rather than fully specifying subsolvers, it is often convenient to just
     * remove the ones that are not useful on a given problem or only keep
     * specific ones for testing. Each string is interpreted as a "glob", so we
     * support '*' and '?'.
     *
     * The way this work is that we will only accept a name that match a filter
     * pattern (if non-empty) and do not match an ignore pattern. Note also that
     * these fields work on LNS or LS names even if these are currently not
     * specified via the subsolvers field.
     * </pre>
     *
     * <code>repeated string ignore_subsolvers = 209;</code>
     * @param index The index of the element to return.
     * @return The ignoreSubsolvers at the given index.
     */
    public java.lang.String getIgnoreSubsolvers(int index) {
      return ignoreSubsolvers_.get(index);
    }
    /**
     * <pre>
     * Rather than fully specifying subsolvers, it is often convenient to just
     * remove the ones that are not useful on a given problem or only keep
     * specific ones for testing. Each string is interpreted as a "glob", so we
     * support '*' and '?'.
     *
     * The way this work is that we will only accept a name that match a filter
     * pattern (if non-empty) and do not match an ignore pattern. Note also that
     * these fields work on LNS or LS names even if these are currently not
     * specified via the subsolvers field.
     * </pre>
     *
     * <code>repeated string ignore_subsolvers = 209;</code>
     * @param index The index of the value to return.
     * @return The bytes of the ignoreSubsolvers at the given index.
     */
    public com.google.protobuf.ByteString
        getIgnoreSubsolversBytes(int index) {
      return ignoreSubsolvers_.getByteString(index);
    }
    /**
     * <pre>
     * Rather than fully specifying subsolvers, it is often convenient to just
     * remove the ones that are not useful on a given problem or only keep
     * specific ones for testing. Each string is interpreted as a "glob", so we
     * support '*' and '?'.
     *
     * The way this work is that we will only accept a name that match a filter
     * pattern (if non-empty) and do not match an ignore pattern. Note also that
     * these fields work on LNS or LS names even if these are currently not
     * specified via the subsolvers field.
     * </pre>
     *
     * <code>repeated string ignore_subsolvers = 209;</code>
     * @param index The index to set the value at.
     * @param value The ignoreSubsolvers to set.
     * @return This builder for chaining.
     */
    public Builder setIgnoreSubsolvers(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureIgnoreSubsolversIsMutable();
      ignoreSubsolvers_.set(index, value);
      bitField2_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Rather than fully specifying subsolvers, it is often convenient to just
     * remove the ones that are not useful on a given problem or only keep
     * specific ones for testing. Each string is interpreted as a "glob", so we
     * support '*' and '?'.
     *
     * The way this work is that we will only accept a name that match a filter
     * pattern (if non-empty) and do not match an ignore pattern. Note also that
     * these fields work on LNS or LS names even if these are currently not
     * specified via the subsolvers field.
     * </pre>
     *
     * <code>repeated string ignore_subsolvers = 209;</code>
     * @param value The ignoreSubsolvers to add.
     * @return This builder for chaining.
     */
    public Builder addIgnoreSubsolvers(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureIgnoreSubsolversIsMutable();
      ignoreSubsolvers_.add(value);
      bitField2_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Rather than fully specifying subsolvers, it is often convenient to just
     * remove the ones that are not useful on a given problem or only keep
     * specific ones for testing. Each string is interpreted as a "glob", so we
     * support '*' and '?'.
     *
     * The way this work is that we will only accept a name that match a filter
     * pattern (if non-empty) and do not match an ignore pattern. Note also that
     * these fields work on LNS or LS names even if these are currently not
     * specified via the subsolvers field.
     * </pre>
     *
     * <code>repeated string ignore_subsolvers = 209;</code>
     * @param values The ignoreSubsolvers to add.
     * @return This builder for chaining.
     */
    public Builder addAllIgnoreSubsolvers(
        java.lang.Iterable<java.lang.String> values) {
      ensureIgnoreSubsolversIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, ignoreSubsolvers_);
      bitField2_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Rather than fully specifying subsolvers, it is often convenient to just
     * remove the ones that are not useful on a given problem or only keep
     * specific ones for testing. Each string is interpreted as a "glob", so we
     * support '*' and '?'.
     *
     * The way this work is that we will only accept a name that match a filter
     * pattern (if non-empty) and do not match an ignore pattern. Note also that
     * these fields work on LNS or LS names even if these are currently not
     * specified via the subsolvers field.
     * </pre>
     *
     * <code>repeated string ignore_subsolvers = 209;</code>
     * @return This builder for chaining.
     */
    public Builder clearIgnoreSubsolvers() {
      ignoreSubsolvers_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField2_ = (bitField2_ & ~0x80000000);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Rather than fully specifying subsolvers, it is often convenient to just
     * remove the ones that are not useful on a given problem or only keep
     * specific ones for testing. Each string is interpreted as a "glob", so we
     * support '*' and '?'.
     *
     * The way this work is that we will only accept a name that match a filter
     * pattern (if non-empty) and do not match an ignore pattern. Note also that
     * these fields work on LNS or LS names even if these are currently not
     * specified via the subsolvers field.
     * </pre>
     *
     * <code>repeated string ignore_subsolvers = 209;</code>
     * @param value The bytes of the ignoreSubsolvers to add.
     * @return This builder for chaining.
     */
    public Builder addIgnoreSubsolversBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      ensureIgnoreSubsolversIsMutable();
      ignoreSubsolvers_.add(value);
      bitField2_ |= 0x80000000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList filterSubsolvers_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureFilterSubsolversIsMutable() {
      if (!filterSubsolvers_.isModifiable()) {
        filterSubsolvers_ = new com.google.protobuf.LazyStringArrayList(filterSubsolvers_);
      }
      bitField3_ |= 0x00000001;
    }
    /**
     * <code>repeated string filter_subsolvers = 293;</code>
     * @return A list containing the filterSubsolvers.
     */
    public com.google.protobuf.ProtocolStringList
        getFilterSubsolversList() {
      filterSubsolvers_.makeImmutable();
      return filterSubsolvers_;
    }
    /**
     * <code>repeated string filter_subsolvers = 293;</code>
     * @return The count of filterSubsolvers.
     */
    public int getFilterSubsolversCount() {
      return filterSubsolvers_.size();
    }
    /**
     * <code>repeated string filter_subsolvers = 293;</code>
     * @param index The index of the element to return.
     * @return The filterSubsolvers at the given index.
     */
    public java.lang.String getFilterSubsolvers(int index) {
      return filterSubsolvers_.get(index);
    }
    /**
     * <code>repeated string filter_subsolvers = 293;</code>
     * @param index The index of the value to return.
     * @return The bytes of the filterSubsolvers at the given index.
     */
    public com.google.protobuf.ByteString
        getFilterSubsolversBytes(int index) {
      return filterSubsolvers_.getByteString(index);
    }
    /**
     * <code>repeated string filter_subsolvers = 293;</code>
     * @param index The index to set the value at.
     * @param value The filterSubsolvers to set.
     * @return This builder for chaining.
     */
    public Builder setFilterSubsolvers(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureFilterSubsolversIsMutable();
      filterSubsolvers_.set(index, value);
      bitField3_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <code>repeated string filter_subsolvers = 293;</code>
     * @param value The filterSubsolvers to add.
     * @return This builder for chaining.
     */
    public Builder addFilterSubsolvers(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureFilterSubsolversIsMutable();
      filterSubsolvers_.add(value);
      bitField3_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <code>repeated string filter_subsolvers = 293;</code>
     * @param values The filterSubsolvers to add.
     * @return This builder for chaining.
     */
    public Builder addAllFilterSubsolvers(
        java.lang.Iterable<java.lang.String> values) {
      ensureFilterSubsolversIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, filterSubsolvers_);
      bitField3_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <code>repeated string filter_subsolvers = 293;</code>
     * @return This builder for chaining.
     */
    public Builder clearFilterSubsolvers() {
      filterSubsolvers_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField3_ = (bitField3_ & ~0x00000001);;
      onChanged();
      return this;
    }
    /**
     * <code>repeated string filter_subsolvers = 293;</code>
     * @param value The bytes of the filterSubsolvers to add.
     * @return This builder for chaining.
     */
    public Builder addFilterSubsolversBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      ensureFilterSubsolversIsMutable();
      filterSubsolvers_.add(value);
      bitField3_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.ortools.sat.SatParameters> subsolverParams_ =
      java.util.Collections.emptyList();
    private void ensureSubsolverParamsIsMutable() {
      if (!((bitField3_ & 0x00000002) != 0)) {
        subsolverParams_ = new java.util.ArrayList<com.google.ortools.sat.SatParameters>(subsolverParams_);
        bitField3_ |= 0x00000002;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilder<
        com.google.ortools.sat.SatParameters, com.google.ortools.sat.SatParameters.Builder, com.google.ortools.sat.SatParametersOrBuilder> subsolverParamsBuilder_;

    /**
     * <pre>
     * It is possible to specify additional subsolver configuration. These can be
     * referred by their params.name() in the fields above. Note that only the
     * specified field will "overwrite" the ones of the base parameter. If a
     * subsolver_params has the name of an existing subsolver configuration, the
     * named parameters will be merged into the subsolver configuration.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
     */
    public java.util.List<com.google.ortools.sat.SatParameters> getSubsolverParamsList() {
      if (subsolverParamsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(subsolverParams_);
      } else {
        return subsolverParamsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * It is possible to specify additional subsolver configuration. These can be
     * referred by their params.name() in the fields above. Note that only the
     * specified field will "overwrite" the ones of the base parameter. If a
     * subsolver_params has the name of an existing subsolver configuration, the
     * named parameters will be merged into the subsolver configuration.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
     */
    public int getSubsolverParamsCount() {
      if (subsolverParamsBuilder_ == null) {
        return subsolverParams_.size();
      } else {
        return subsolverParamsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * It is possible to specify additional subsolver configuration. These can be
     * referred by their params.name() in the fields above. Note that only the
     * specified field will "overwrite" the ones of the base parameter. If a
     * subsolver_params has the name of an existing subsolver configuration, the
     * named parameters will be merged into the subsolver configuration.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
     */
    public com.google.ortools.sat.SatParameters getSubsolverParams(int index) {
      if (subsolverParamsBuilder_ == null) {
        return subsolverParams_.get(index);
      } else {
        return subsolverParamsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * It is possible to specify additional subsolver configuration. These can be
     * referred by their params.name() in the fields above. Note that only the
     * specified field will "overwrite" the ones of the base parameter. If a
     * subsolver_params has the name of an existing subsolver configuration, the
     * named parameters will be merged into the subsolver configuration.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
     */
    public Builder setSubsolverParams(
        int index, com.google.ortools.sat.SatParameters value) {
      if (subsolverParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSubsolverParamsIsMutable();
        subsolverParams_.set(index, value);
        onChanged();
      } else {
        subsolverParamsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * It is possible to specify additional subsolver configuration. These can be
     * referred by their params.name() in the fields above. Note that only the
     * specified field will "overwrite" the ones of the base parameter. If a
     * subsolver_params has the name of an existing subsolver configuration, the
     * named parameters will be merged into the subsolver configuration.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
     */
    public Builder setSubsolverParams(
        int index, com.google.ortools.sat.SatParameters.Builder builderForValue) {
      if (subsolverParamsBuilder_ == null) {
        ensureSubsolverParamsIsMutable();
        subsolverParams_.set(index, builderForValue.build());
        onChanged();
      } else {
        subsolverParamsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * It is possible to specify additional subsolver configuration. These can be
     * referred by their params.name() in the fields above. Note that only the
     * specified field will "overwrite" the ones of the base parameter. If a
     * subsolver_params has the name of an existing subsolver configuration, the
     * named parameters will be merged into the subsolver configuration.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
     */
    public Builder addSubsolverParams(com.google.ortools.sat.SatParameters value) {
      if (subsolverParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSubsolverParamsIsMutable();
        subsolverParams_.add(value);
        onChanged();
      } else {
        subsolverParamsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * It is possible to specify additional subsolver configuration. These can be
     * referred by their params.name() in the fields above. Note that only the
     * specified field will "overwrite" the ones of the base parameter. If a
     * subsolver_params has the name of an existing subsolver configuration, the
     * named parameters will be merged into the subsolver configuration.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
     */
    public Builder addSubsolverParams(
        int index, com.google.ortools.sat.SatParameters value) {
      if (subsolverParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSubsolverParamsIsMutable();
        subsolverParams_.add(index, value);
        onChanged();
      } else {
        subsolverParamsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * It is possible to specify additional subsolver configuration. These can be
     * referred by their params.name() in the fields above. Note that only the
     * specified field will "overwrite" the ones of the base parameter. If a
     * subsolver_params has the name of an existing subsolver configuration, the
     * named parameters will be merged into the subsolver configuration.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
     */
    public Builder addSubsolverParams(
        com.google.ortools.sat.SatParameters.Builder builderForValue) {
      if (subsolverParamsBuilder_ == null) {
        ensureSubsolverParamsIsMutable();
        subsolverParams_.add(builderForValue.build());
        onChanged();
      } else {
        subsolverParamsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * It is possible to specify additional subsolver configuration. These can be
     * referred by their params.name() in the fields above. Note that only the
     * specified field will "overwrite" the ones of the base parameter. If a
     * subsolver_params has the name of an existing subsolver configuration, the
     * named parameters will be merged into the subsolver configuration.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
     */
    public Builder addSubsolverParams(
        int index, com.google.ortools.sat.SatParameters.Builder builderForValue) {
      if (subsolverParamsBuilder_ == null) {
        ensureSubsolverParamsIsMutable();
        subsolverParams_.add(index, builderForValue.build());
        onChanged();
      } else {
        subsolverParamsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * It is possible to specify additional subsolver configuration. These can be
     * referred by their params.name() in the fields above. Note that only the
     * specified field will "overwrite" the ones of the base parameter. If a
     * subsolver_params has the name of an existing subsolver configuration, the
     * named parameters will be merged into the subsolver configuration.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
     */
    public Builder addAllSubsolverParams(
        java.lang.Iterable<? extends com.google.ortools.sat.SatParameters> values) {
      if (subsolverParamsBuilder_ == null) {
        ensureSubsolverParamsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, subsolverParams_);
        onChanged();
      } else {
        subsolverParamsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * It is possible to specify additional subsolver configuration. These can be
     * referred by their params.name() in the fields above. Note that only the
     * specified field will "overwrite" the ones of the base parameter. If a
     * subsolver_params has the name of an existing subsolver configuration, the
     * named parameters will be merged into the subsolver configuration.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
     */
    public Builder clearSubsolverParams() {
      if (subsolverParamsBuilder_ == null) {
        subsolverParams_ = java.util.Collections.emptyList();
        bitField3_ = (bitField3_ & ~0x00000002);
        onChanged();
      } else {
        subsolverParamsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * It is possible to specify additional subsolver configuration. These can be
     * referred by their params.name() in the fields above. Note that only the
     * specified field will "overwrite" the ones of the base parameter. If a
     * subsolver_params has the name of an existing subsolver configuration, the
     * named parameters will be merged into the subsolver configuration.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
     */
    public Builder removeSubsolverParams(int index) {
      if (subsolverParamsBuilder_ == null) {
        ensureSubsolverParamsIsMutable();
        subsolverParams_.remove(index);
        onChanged();
      } else {
        subsolverParamsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * It is possible to specify additional subsolver configuration. These can be
     * referred by their params.name() in the fields above. Note that only the
     * specified field will "overwrite" the ones of the base parameter. If a
     * subsolver_params has the name of an existing subsolver configuration, the
     * named parameters will be merged into the subsolver configuration.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
     */
    public com.google.ortools.sat.SatParameters.Builder getSubsolverParamsBuilder(
        int index) {
      return getSubsolverParamsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * It is possible to specify additional subsolver configuration. These can be
     * referred by their params.name() in the fields above. Note that only the
     * specified field will "overwrite" the ones of the base parameter. If a
     * subsolver_params has the name of an existing subsolver configuration, the
     * named parameters will be merged into the subsolver configuration.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
     */
    public com.google.ortools.sat.SatParametersOrBuilder getSubsolverParamsOrBuilder(
        int index) {
      if (subsolverParamsBuilder_ == null) {
        return subsolverParams_.get(index);  } else {
        return subsolverParamsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * It is possible to specify additional subsolver configuration. These can be
     * referred by their params.name() in the fields above. Note that only the
     * specified field will "overwrite" the ones of the base parameter. If a
     * subsolver_params has the name of an existing subsolver configuration, the
     * named parameters will be merged into the subsolver configuration.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
     */
    public java.util.List<? extends com.google.ortools.sat.SatParametersOrBuilder> 
         getSubsolverParamsOrBuilderList() {
      if (subsolverParamsBuilder_ != null) {
        return subsolverParamsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(subsolverParams_);
      }
    }
    /**
     * <pre>
     * It is possible to specify additional subsolver configuration. These can be
     * referred by their params.name() in the fields above. Note that only the
     * specified field will "overwrite" the ones of the base parameter. If a
     * subsolver_params has the name of an existing subsolver configuration, the
     * named parameters will be merged into the subsolver configuration.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
     */
    public com.google.ortools.sat.SatParameters.Builder addSubsolverParamsBuilder() {
      return getSubsolverParamsFieldBuilder().addBuilder(
          com.google.ortools.sat.SatParameters.getDefaultInstance());
    }
    /**
     * <pre>
     * It is possible to specify additional subsolver configuration. These can be
     * referred by their params.name() in the fields above. Note that only the
     * specified field will "overwrite" the ones of the base parameter. If a
     * subsolver_params has the name of an existing subsolver configuration, the
     * named parameters will be merged into the subsolver configuration.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
     */
    public com.google.ortools.sat.SatParameters.Builder addSubsolverParamsBuilder(
        int index) {
      return getSubsolverParamsFieldBuilder().addBuilder(
          index, com.google.ortools.sat.SatParameters.getDefaultInstance());
    }
    /**
     * <pre>
     * It is possible to specify additional subsolver configuration. These can be
     * referred by their params.name() in the fields above. Note that only the
     * specified field will "overwrite" the ones of the base parameter. If a
     * subsolver_params has the name of an existing subsolver configuration, the
     * named parameters will be merged into the subsolver configuration.
     * </pre>
     *
     * <code>repeated .operations_research.sat.SatParameters subsolver_params = 210;</code>
     */
    public java.util.List<com.google.ortools.sat.SatParameters.Builder> 
         getSubsolverParamsBuilderList() {
      return getSubsolverParamsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilder<
        com.google.ortools.sat.SatParameters, com.google.ortools.sat.SatParameters.Builder, com.google.ortools.sat.SatParametersOrBuilder> 
        getSubsolverParamsFieldBuilder() {
      if (subsolverParamsBuilder_ == null) {
        subsolverParamsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
            com.google.ortools.sat.SatParameters, com.google.ortools.sat.SatParameters.Builder, com.google.ortools.sat.SatParametersOrBuilder>(
                subsolverParams_,
                ((bitField3_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        subsolverParams_ = null;
      }
      return subsolverParamsBuilder_;
    }

    private boolean interleaveSearch_ ;
    /**
     * <pre>
     * Experimental. If this is true, then we interleave all our major search
     * strategy and distribute the work amongst num_workers.
     *
     * The search is deterministic (independently of num_workers!), and we
     * schedule and wait for interleave_batch_size task to be completed before
     * synchronizing and scheduling the next batch of tasks.
     * </pre>
     *
     * <code>optional bool interleave_search = 136 [default = false];</code>
     * @return Whether the interleaveSearch field is set.
     */
    @java.lang.Override
    public boolean hasInterleaveSearch() {
      return ((bitField3_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * Experimental. If this is true, then we interleave all our major search
     * strategy and distribute the work amongst num_workers.
     *
     * The search is deterministic (independently of num_workers!), and we
     * schedule and wait for interleave_batch_size task to be completed before
     * synchronizing and scheduling the next batch of tasks.
     * </pre>
     *
     * <code>optional bool interleave_search = 136 [default = false];</code>
     * @return The interleaveSearch.
     */
    @java.lang.Override
    public boolean getInterleaveSearch() {
      return interleaveSearch_;
    }
    /**
     * <pre>
     * Experimental. If this is true, then we interleave all our major search
     * strategy and distribute the work amongst num_workers.
     *
     * The search is deterministic (independently of num_workers!), and we
     * schedule and wait for interleave_batch_size task to be completed before
     * synchronizing and scheduling the next batch of tasks.
     * </pre>
     *
     * <code>optional bool interleave_search = 136 [default = false];</code>
     * @param value The interleaveSearch to set.
     * @return This builder for chaining.
     */
    public Builder setInterleaveSearch(boolean value) {

      interleaveSearch_ = value;
      bitField3_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Experimental. If this is true, then we interleave all our major search
     * strategy and distribute the work amongst num_workers.
     *
     * The search is deterministic (independently of num_workers!), and we
     * schedule and wait for interleave_batch_size task to be completed before
     * synchronizing and scheduling the next batch of tasks.
     * </pre>
     *
     * <code>optional bool interleave_search = 136 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearInterleaveSearch() {
      bitField3_ = (bitField3_ & ~0x00000004);
      interleaveSearch_ = false;
      onChanged();
      return this;
    }

    private int interleaveBatchSize_ ;
    /**
     * <code>optional int32 interleave_batch_size = 134 [default = 0];</code>
     * @return Whether the interleaveBatchSize field is set.
     */
    @java.lang.Override
    public boolean hasInterleaveBatchSize() {
      return ((bitField3_ & 0x00000008) != 0);
    }
    /**
     * <code>optional int32 interleave_batch_size = 134 [default = 0];</code>
     * @return The interleaveBatchSize.
     */
    @java.lang.Override
    public int getInterleaveBatchSize() {
      return interleaveBatchSize_;
    }
    /**
     * <code>optional int32 interleave_batch_size = 134 [default = 0];</code>
     * @param value The interleaveBatchSize to set.
     * @return This builder for chaining.
     */
    public Builder setInterleaveBatchSize(int value) {

      interleaveBatchSize_ = value;
      bitField3_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <code>optional int32 interleave_batch_size = 134 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearInterleaveBatchSize() {
      bitField3_ = (bitField3_ & ~0x00000008);
      interleaveBatchSize_ = 0;
      onChanged();
      return this;
    }

    private boolean shareObjectiveBounds_ = true;
    /**
     * <pre>
     * Allows objective sharing between workers.
     * </pre>
     *
     * <code>optional bool share_objective_bounds = 113 [default = true];</code>
     * @return Whether the shareObjectiveBounds field is set.
     */
    @java.lang.Override
    public boolean hasShareObjectiveBounds() {
      return ((bitField3_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * Allows objective sharing between workers.
     * </pre>
     *
     * <code>optional bool share_objective_bounds = 113 [default = true];</code>
     * @return The shareObjectiveBounds.
     */
    @java.lang.Override
    public boolean getShareObjectiveBounds() {
      return shareObjectiveBounds_;
    }
    /**
     * <pre>
     * Allows objective sharing between workers.
     * </pre>
     *
     * <code>optional bool share_objective_bounds = 113 [default = true];</code>
     * @param value The shareObjectiveBounds to set.
     * @return This builder for chaining.
     */
    public Builder setShareObjectiveBounds(boolean value) {

      shareObjectiveBounds_ = value;
      bitField3_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Allows objective sharing between workers.
     * </pre>
     *
     * <code>optional bool share_objective_bounds = 113 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearShareObjectiveBounds() {
      bitField3_ = (bitField3_ & ~0x00000010);
      shareObjectiveBounds_ = true;
      onChanged();
      return this;
    }

    private boolean shareLevelZeroBounds_ = true;
    /**
     * <pre>
     * Allows sharing of the bounds of modified variables at level 0.
     * </pre>
     *
     * <code>optional bool share_level_zero_bounds = 114 [default = true];</code>
     * @return Whether the shareLevelZeroBounds field is set.
     */
    @java.lang.Override
    public boolean hasShareLevelZeroBounds() {
      return ((bitField3_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * Allows sharing of the bounds of modified variables at level 0.
     * </pre>
     *
     * <code>optional bool share_level_zero_bounds = 114 [default = true];</code>
     * @return The shareLevelZeroBounds.
     */
    @java.lang.Override
    public boolean getShareLevelZeroBounds() {
      return shareLevelZeroBounds_;
    }
    /**
     * <pre>
     * Allows sharing of the bounds of modified variables at level 0.
     * </pre>
     *
     * <code>optional bool share_level_zero_bounds = 114 [default = true];</code>
     * @param value The shareLevelZeroBounds to set.
     * @return This builder for chaining.
     */
    public Builder setShareLevelZeroBounds(boolean value) {

      shareLevelZeroBounds_ = value;
      bitField3_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Allows sharing of the bounds of modified variables at level 0.
     * </pre>
     *
     * <code>optional bool share_level_zero_bounds = 114 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearShareLevelZeroBounds() {
      bitField3_ = (bitField3_ & ~0x00000020);
      shareLevelZeroBounds_ = true;
      onChanged();
      return this;
    }

    private boolean shareBinaryClauses_ = true;
    /**
     * <pre>
     * Allows sharing of new learned binary clause between workers.
     * </pre>
     *
     * <code>optional bool share_binary_clauses = 203 [default = true];</code>
     * @return Whether the shareBinaryClauses field is set.
     */
    @java.lang.Override
    public boolean hasShareBinaryClauses() {
      return ((bitField3_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * Allows sharing of new learned binary clause between workers.
     * </pre>
     *
     * <code>optional bool share_binary_clauses = 203 [default = true];</code>
     * @return The shareBinaryClauses.
     */
    @java.lang.Override
    public boolean getShareBinaryClauses() {
      return shareBinaryClauses_;
    }
    /**
     * <pre>
     * Allows sharing of new learned binary clause between workers.
     * </pre>
     *
     * <code>optional bool share_binary_clauses = 203 [default = true];</code>
     * @param value The shareBinaryClauses to set.
     * @return This builder for chaining.
     */
    public Builder setShareBinaryClauses(boolean value) {

      shareBinaryClauses_ = value;
      bitField3_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Allows sharing of new learned binary clause between workers.
     * </pre>
     *
     * <code>optional bool share_binary_clauses = 203 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearShareBinaryClauses() {
      bitField3_ = (bitField3_ & ~0x00000040);
      shareBinaryClauses_ = true;
      onChanged();
      return this;
    }

    private boolean shareGlueClauses_ ;
    /**
     * <pre>
     * Allows sharing of short glue clauses between workers.
     * Implicitly disabled if share_binary_clauses is false.
     * </pre>
     *
     * <code>optional bool share_glue_clauses = 285 [default = false];</code>
     * @return Whether the shareGlueClauses field is set.
     */
    @java.lang.Override
    public boolean hasShareGlueClauses() {
      return ((bitField3_ & 0x00000080) != 0);
    }
    /**
     * <pre>
     * Allows sharing of short glue clauses between workers.
     * Implicitly disabled if share_binary_clauses is false.
     * </pre>
     *
     * <code>optional bool share_glue_clauses = 285 [default = false];</code>
     * @return The shareGlueClauses.
     */
    @java.lang.Override
    public boolean getShareGlueClauses() {
      return shareGlueClauses_;
    }
    /**
     * <pre>
     * Allows sharing of short glue clauses between workers.
     * Implicitly disabled if share_binary_clauses is false.
     * </pre>
     *
     * <code>optional bool share_glue_clauses = 285 [default = false];</code>
     * @param value The shareGlueClauses to set.
     * @return This builder for chaining.
     */
    public Builder setShareGlueClauses(boolean value) {

      shareGlueClauses_ = value;
      bitField3_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Allows sharing of short glue clauses between workers.
     * Implicitly disabled if share_binary_clauses is false.
     * </pre>
     *
     * <code>optional bool share_glue_clauses = 285 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearShareGlueClauses() {
      bitField3_ = (bitField3_ & ~0x00000080);
      shareGlueClauses_ = false;
      onChanged();
      return this;
    }

    private boolean debugPostsolveWithFullSolver_ ;
    /**
     * <pre>
     * We have two different postsolve code. The default one should be better and
     * it allows for a more powerful presolve, but it can be useful to postsolve
     * using the full solver instead.
     * </pre>
     *
     * <code>optional bool debug_postsolve_with_full_solver = 162 [default = false];</code>
     * @return Whether the debugPostsolveWithFullSolver field is set.
     */
    @java.lang.Override
    public boolean hasDebugPostsolveWithFullSolver() {
      return ((bitField3_ & 0x00000100) != 0);
    }
    /**
     * <pre>
     * We have two different postsolve code. The default one should be better and
     * it allows for a more powerful presolve, but it can be useful to postsolve
     * using the full solver instead.
     * </pre>
     *
     * <code>optional bool debug_postsolve_with_full_solver = 162 [default = false];</code>
     * @return The debugPostsolveWithFullSolver.
     */
    @java.lang.Override
    public boolean getDebugPostsolveWithFullSolver() {
      return debugPostsolveWithFullSolver_;
    }
    /**
     * <pre>
     * We have two different postsolve code. The default one should be better and
     * it allows for a more powerful presolve, but it can be useful to postsolve
     * using the full solver instead.
     * </pre>
     *
     * <code>optional bool debug_postsolve_with_full_solver = 162 [default = false];</code>
     * @param value The debugPostsolveWithFullSolver to set.
     * @return This builder for chaining.
     */
    public Builder setDebugPostsolveWithFullSolver(boolean value) {

      debugPostsolveWithFullSolver_ = value;
      bitField3_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * We have two different postsolve code. The default one should be better and
     * it allows for a more powerful presolve, but it can be useful to postsolve
     * using the full solver instead.
     * </pre>
     *
     * <code>optional bool debug_postsolve_with_full_solver = 162 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearDebugPostsolveWithFullSolver() {
      bitField3_ = (bitField3_ & ~0x00000100);
      debugPostsolveWithFullSolver_ = false;
      onChanged();
      return this;
    }

    private int debugMaxNumPresolveOperations_ ;
    /**
     * <pre>
     * If positive, try to stop just after that many presolve rules have been
     * applied. This is mainly useful for debugging presolve.
     * </pre>
     *
     * <code>optional int32 debug_max_num_presolve_operations = 151 [default = 0];</code>
     * @return Whether the debugMaxNumPresolveOperations field is set.
     */
    @java.lang.Override
    public boolean hasDebugMaxNumPresolveOperations() {
      return ((bitField3_ & 0x00000200) != 0);
    }
    /**
     * <pre>
     * If positive, try to stop just after that many presolve rules have been
     * applied. This is mainly useful for debugging presolve.
     * </pre>
     *
     * <code>optional int32 debug_max_num_presolve_operations = 151 [default = 0];</code>
     * @return The debugMaxNumPresolveOperations.
     */
    @java.lang.Override
    public int getDebugMaxNumPresolveOperations() {
      return debugMaxNumPresolveOperations_;
    }
    /**
     * <pre>
     * If positive, try to stop just after that many presolve rules have been
     * applied. This is mainly useful for debugging presolve.
     * </pre>
     *
     * <code>optional int32 debug_max_num_presolve_operations = 151 [default = 0];</code>
     * @param value The debugMaxNumPresolveOperations to set.
     * @return This builder for chaining.
     */
    public Builder setDebugMaxNumPresolveOperations(int value) {

      debugMaxNumPresolveOperations_ = value;
      bitField3_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If positive, try to stop just after that many presolve rules have been
     * applied. This is mainly useful for debugging presolve.
     * </pre>
     *
     * <code>optional int32 debug_max_num_presolve_operations = 151 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearDebugMaxNumPresolveOperations() {
      bitField3_ = (bitField3_ & ~0x00000200);
      debugMaxNumPresolveOperations_ = 0;
      onChanged();
      return this;
    }

    private boolean debugCrashOnBadHint_ ;
    /**
     * <pre>
     * Crash if we do not manage to complete the hint into a full solution.
     * </pre>
     *
     * <code>optional bool debug_crash_on_bad_hint = 195 [default = false];</code>
     * @return Whether the debugCrashOnBadHint field is set.
     */
    @java.lang.Override
    public boolean hasDebugCrashOnBadHint() {
      return ((bitField3_ & 0x00000400) != 0);
    }
    /**
     * <pre>
     * Crash if we do not manage to complete the hint into a full solution.
     * </pre>
     *
     * <code>optional bool debug_crash_on_bad_hint = 195 [default = false];</code>
     * @return The debugCrashOnBadHint.
     */
    @java.lang.Override
    public boolean getDebugCrashOnBadHint() {
      return debugCrashOnBadHint_;
    }
    /**
     * <pre>
     * Crash if we do not manage to complete the hint into a full solution.
     * </pre>
     *
     * <code>optional bool debug_crash_on_bad_hint = 195 [default = false];</code>
     * @param value The debugCrashOnBadHint to set.
     * @return This builder for chaining.
     */
    public Builder setDebugCrashOnBadHint(boolean value) {

      debugCrashOnBadHint_ = value;
      bitField3_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Crash if we do not manage to complete the hint into a full solution.
     * </pre>
     *
     * <code>optional bool debug_crash_on_bad_hint = 195 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearDebugCrashOnBadHint() {
      bitField3_ = (bitField3_ & ~0x00000400);
      debugCrashOnBadHint_ = false;
      onChanged();
      return this;
    }

    private boolean useOptimizationHints_ = true;
    /**
     * <pre>
     * For an optimization problem, whether we follow some hints in order to find
     * a better first solution. For a variable with hint, the solver will always
     * try to follow the hint. It will revert to the variable_branching default
     * otherwise.
     * </pre>
     *
     * <code>optional bool use_optimization_hints = 35 [default = true];</code>
     * @return Whether the useOptimizationHints field is set.
     */
    @java.lang.Override
    public boolean hasUseOptimizationHints() {
      return ((bitField3_ & 0x00000800) != 0);
    }
    /**
     * <pre>
     * For an optimization problem, whether we follow some hints in order to find
     * a better first solution. For a variable with hint, the solver will always
     * try to follow the hint. It will revert to the variable_branching default
     * otherwise.
     * </pre>
     *
     * <code>optional bool use_optimization_hints = 35 [default = true];</code>
     * @return The useOptimizationHints.
     */
    @java.lang.Override
    public boolean getUseOptimizationHints() {
      return useOptimizationHints_;
    }
    /**
     * <pre>
     * For an optimization problem, whether we follow some hints in order to find
     * a better first solution. For a variable with hint, the solver will always
     * try to follow the hint. It will revert to the variable_branching default
     * otherwise.
     * </pre>
     *
     * <code>optional bool use_optimization_hints = 35 [default = true];</code>
     * @param value The useOptimizationHints to set.
     * @return This builder for chaining.
     */
    public Builder setUseOptimizationHints(boolean value) {

      useOptimizationHints_ = value;
      bitField3_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * For an optimization problem, whether we follow some hints in order to find
     * a better first solution. For a variable with hint, the solver will always
     * try to follow the hint. It will revert to the variable_branching default
     * otherwise.
     * </pre>
     *
     * <code>optional bool use_optimization_hints = 35 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseOptimizationHints() {
      bitField3_ = (bitField3_ & ~0x00000800);
      useOptimizationHints_ = true;
      onChanged();
      return this;
    }

    private int coreMinimizationLevel_ = 2;
    /**
     * <pre>
     * If positive, we spend some effort on each core:
     * - At level 1, we use a simple heuristic to try to minimize an UNSAT core.
     * - At level 2, we use propagation to minimize the core but also identify
     * literal in at most one relationship in this core.
     * </pre>
     *
     * <code>optional int32 core_minimization_level = 50 [default = 2];</code>
     * @return Whether the coreMinimizationLevel field is set.
     */
    @java.lang.Override
    public boolean hasCoreMinimizationLevel() {
      return ((bitField3_ & 0x00001000) != 0);
    }
    /**
     * <pre>
     * If positive, we spend some effort on each core:
     * - At level 1, we use a simple heuristic to try to minimize an UNSAT core.
     * - At level 2, we use propagation to minimize the core but also identify
     * literal in at most one relationship in this core.
     * </pre>
     *
     * <code>optional int32 core_minimization_level = 50 [default = 2];</code>
     * @return The coreMinimizationLevel.
     */
    @java.lang.Override
    public int getCoreMinimizationLevel() {
      return coreMinimizationLevel_;
    }
    /**
     * <pre>
     * If positive, we spend some effort on each core:
     * - At level 1, we use a simple heuristic to try to minimize an UNSAT core.
     * - At level 2, we use propagation to minimize the core but also identify
     * literal in at most one relationship in this core.
     * </pre>
     *
     * <code>optional int32 core_minimization_level = 50 [default = 2];</code>
     * @param value The coreMinimizationLevel to set.
     * @return This builder for chaining.
     */
    public Builder setCoreMinimizationLevel(int value) {

      coreMinimizationLevel_ = value;
      bitField3_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If positive, we spend some effort on each core:
     * - At level 1, we use a simple heuristic to try to minimize an UNSAT core.
     * - At level 2, we use propagation to minimize the core but also identify
     * literal in at most one relationship in this core.
     * </pre>
     *
     * <code>optional int32 core_minimization_level = 50 [default = 2];</code>
     * @return This builder for chaining.
     */
    public Builder clearCoreMinimizationLevel() {
      bitField3_ = (bitField3_ & ~0x00001000);
      coreMinimizationLevel_ = 2;
      onChanged();
      return this;
    }

    private boolean findMultipleCores_ = true;
    /**
     * <pre>
     * Whether we try to find more independent cores for a given set of
     * assumptions in the core based max-SAT algorithms.
     * </pre>
     *
     * <code>optional bool find_multiple_cores = 84 [default = true];</code>
     * @return Whether the findMultipleCores field is set.
     */
    @java.lang.Override
    public boolean hasFindMultipleCores() {
      return ((bitField3_ & 0x00002000) != 0);
    }
    /**
     * <pre>
     * Whether we try to find more independent cores for a given set of
     * assumptions in the core based max-SAT algorithms.
     * </pre>
     *
     * <code>optional bool find_multiple_cores = 84 [default = true];</code>
     * @return The findMultipleCores.
     */
    @java.lang.Override
    public boolean getFindMultipleCores() {
      return findMultipleCores_;
    }
    /**
     * <pre>
     * Whether we try to find more independent cores for a given set of
     * assumptions in the core based max-SAT algorithms.
     * </pre>
     *
     * <code>optional bool find_multiple_cores = 84 [default = true];</code>
     * @param value The findMultipleCores to set.
     * @return This builder for chaining.
     */
    public Builder setFindMultipleCores(boolean value) {

      findMultipleCores_ = value;
      bitField3_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we try to find more independent cores for a given set of
     * assumptions in the core based max-SAT algorithms.
     * </pre>
     *
     * <code>optional bool find_multiple_cores = 84 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearFindMultipleCores() {
      bitField3_ = (bitField3_ & ~0x00002000);
      findMultipleCores_ = true;
      onChanged();
      return this;
    }

    private boolean coverOptimization_ = true;
    /**
     * <pre>
     * If true, when the max-sat algo find a core, we compute the minimal number
     * of literals in the core that needs to be true to have a feasible solution.
     * This is also called core exhaustion in more recent max-SAT papers.
     * </pre>
     *
     * <code>optional bool cover_optimization = 89 [default = true];</code>
     * @return Whether the coverOptimization field is set.
     */
    @java.lang.Override
    public boolean hasCoverOptimization() {
      return ((bitField3_ & 0x00004000) != 0);
    }
    /**
     * <pre>
     * If true, when the max-sat algo find a core, we compute the minimal number
     * of literals in the core that needs to be true to have a feasible solution.
     * This is also called core exhaustion in more recent max-SAT papers.
     * </pre>
     *
     * <code>optional bool cover_optimization = 89 [default = true];</code>
     * @return The coverOptimization.
     */
    @java.lang.Override
    public boolean getCoverOptimization() {
      return coverOptimization_;
    }
    /**
     * <pre>
     * If true, when the max-sat algo find a core, we compute the minimal number
     * of literals in the core that needs to be true to have a feasible solution.
     * This is also called core exhaustion in more recent max-SAT papers.
     * </pre>
     *
     * <code>optional bool cover_optimization = 89 [default = true];</code>
     * @param value The coverOptimization to set.
     * @return This builder for chaining.
     */
    public Builder setCoverOptimization(boolean value) {

      coverOptimization_ = value;
      bitField3_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, when the max-sat algo find a core, we compute the minimal number
     * of literals in the core that needs to be true to have a feasible solution.
     * This is also called core exhaustion in more recent max-SAT papers.
     * </pre>
     *
     * <code>optional bool cover_optimization = 89 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearCoverOptimization() {
      bitField3_ = (bitField3_ & ~0x00004000);
      coverOptimization_ = true;
      onChanged();
      return this;
    }

    private int maxSatAssumptionOrder_ = 0;
    /**
     * <code>optional .operations_research.sat.SatParameters.MaxSatAssumptionOrder max_sat_assumption_order = 51 [default = DEFAULT_ASSUMPTION_ORDER];</code>
     * @return Whether the maxSatAssumptionOrder field is set.
     */
    @java.lang.Override public boolean hasMaxSatAssumptionOrder() {
      return ((bitField3_ & 0x00008000) != 0);
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.MaxSatAssumptionOrder max_sat_assumption_order = 51 [default = DEFAULT_ASSUMPTION_ORDER];</code>
     * @return The maxSatAssumptionOrder.
     */
    @java.lang.Override
    public com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder getMaxSatAssumptionOrder() {
      com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder result = com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder.forNumber(maxSatAssumptionOrder_);
      return result == null ? com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder.DEFAULT_ASSUMPTION_ORDER : result;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.MaxSatAssumptionOrder max_sat_assumption_order = 51 [default = DEFAULT_ASSUMPTION_ORDER];</code>
     * @param value The maxSatAssumptionOrder to set.
     * @return This builder for chaining.
     */
    public Builder setMaxSatAssumptionOrder(com.google.ortools.sat.SatParameters.MaxSatAssumptionOrder value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField3_ |= 0x00008000;
      maxSatAssumptionOrder_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.MaxSatAssumptionOrder max_sat_assumption_order = 51 [default = DEFAULT_ASSUMPTION_ORDER];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxSatAssumptionOrder() {
      bitField3_ = (bitField3_ & ~0x00008000);
      maxSatAssumptionOrder_ = 0;
      onChanged();
      return this;
    }

    private boolean maxSatReverseAssumptionOrder_ ;
    /**
     * <pre>
     * If true, adds the assumption in the reverse order of the one defined by
     * max_sat_assumption_order.
     * </pre>
     *
     * <code>optional bool max_sat_reverse_assumption_order = 52 [default = false];</code>
     * @return Whether the maxSatReverseAssumptionOrder field is set.
     */
    @java.lang.Override
    public boolean hasMaxSatReverseAssumptionOrder() {
      return ((bitField3_ & 0x00010000) != 0);
    }
    /**
     * <pre>
     * If true, adds the assumption in the reverse order of the one defined by
     * max_sat_assumption_order.
     * </pre>
     *
     * <code>optional bool max_sat_reverse_assumption_order = 52 [default = false];</code>
     * @return The maxSatReverseAssumptionOrder.
     */
    @java.lang.Override
    public boolean getMaxSatReverseAssumptionOrder() {
      return maxSatReverseAssumptionOrder_;
    }
    /**
     * <pre>
     * If true, adds the assumption in the reverse order of the one defined by
     * max_sat_assumption_order.
     * </pre>
     *
     * <code>optional bool max_sat_reverse_assumption_order = 52 [default = false];</code>
     * @param value The maxSatReverseAssumptionOrder to set.
     * @return This builder for chaining.
     */
    public Builder setMaxSatReverseAssumptionOrder(boolean value) {

      maxSatReverseAssumptionOrder_ = value;
      bitField3_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, adds the assumption in the reverse order of the one defined by
     * max_sat_assumption_order.
     * </pre>
     *
     * <code>optional bool max_sat_reverse_assumption_order = 52 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxSatReverseAssumptionOrder() {
      bitField3_ = (bitField3_ & ~0x00010000);
      maxSatReverseAssumptionOrder_ = false;
      onChanged();
      return this;
    }

    private int maxSatStratification_ = 1;
    /**
     * <code>optional .operations_research.sat.SatParameters.MaxSatStratificationAlgorithm max_sat_stratification = 53 [default = STRATIFICATION_DESCENT];</code>
     * @return Whether the maxSatStratification field is set.
     */
    @java.lang.Override public boolean hasMaxSatStratification() {
      return ((bitField3_ & 0x00020000) != 0);
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.MaxSatStratificationAlgorithm max_sat_stratification = 53 [default = STRATIFICATION_DESCENT];</code>
     * @return The maxSatStratification.
     */
    @java.lang.Override
    public com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm getMaxSatStratification() {
      com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm result = com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm.forNumber(maxSatStratification_);
      return result == null ? com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm.STRATIFICATION_DESCENT : result;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.MaxSatStratificationAlgorithm max_sat_stratification = 53 [default = STRATIFICATION_DESCENT];</code>
     * @param value The maxSatStratification to set.
     * @return This builder for chaining.
     */
    public Builder setMaxSatStratification(com.google.ortools.sat.SatParameters.MaxSatStratificationAlgorithm value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField3_ |= 0x00020000;
      maxSatStratification_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.sat.SatParameters.MaxSatStratificationAlgorithm max_sat_stratification = 53 [default = STRATIFICATION_DESCENT];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxSatStratification() {
      bitField3_ = (bitField3_ & ~0x00020000);
      maxSatStratification_ = 1;
      onChanged();
      return this;
    }

    private double propagationLoopDetectionFactor_ = 10D;
    /**
     * <pre>
     * Some search decisions might cause a really large number of propagations to
     * happen when integer variables with large domains are only reduced by 1 at
     * each step. If we propagate more than the number of variable times this
     * parameters we try to take counter-measure. Setting this to 0.0 disable this
     * feature.
     *
     * TODO(user): Setting this to something like 10 helps in most cases, but the
     * code is currently buggy and can cause the solve to enter a bad state where
     * no progress is made.
     * </pre>
     *
     * <code>optional double propagation_loop_detection_factor = 221 [default = 10];</code>
     * @return Whether the propagationLoopDetectionFactor field is set.
     */
    @java.lang.Override
    public boolean hasPropagationLoopDetectionFactor() {
      return ((bitField3_ & 0x00040000) != 0);
    }
    /**
     * <pre>
     * Some search decisions might cause a really large number of propagations to
     * happen when integer variables with large domains are only reduced by 1 at
     * each step. If we propagate more than the number of variable times this
     * parameters we try to take counter-measure. Setting this to 0.0 disable this
     * feature.
     *
     * TODO(user): Setting this to something like 10 helps in most cases, but the
     * code is currently buggy and can cause the solve to enter a bad state where
     * no progress is made.
     * </pre>
     *
     * <code>optional double propagation_loop_detection_factor = 221 [default = 10];</code>
     * @return The propagationLoopDetectionFactor.
     */
    @java.lang.Override
    public double getPropagationLoopDetectionFactor() {
      return propagationLoopDetectionFactor_;
    }
    /**
     * <pre>
     * Some search decisions might cause a really large number of propagations to
     * happen when integer variables with large domains are only reduced by 1 at
     * each step. If we propagate more than the number of variable times this
     * parameters we try to take counter-measure. Setting this to 0.0 disable this
     * feature.
     *
     * TODO(user): Setting this to something like 10 helps in most cases, but the
     * code is currently buggy and can cause the solve to enter a bad state where
     * no progress is made.
     * </pre>
     *
     * <code>optional double propagation_loop_detection_factor = 221 [default = 10];</code>
     * @param value The propagationLoopDetectionFactor to set.
     * @return This builder for chaining.
     */
    public Builder setPropagationLoopDetectionFactor(double value) {

      propagationLoopDetectionFactor_ = value;
      bitField3_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Some search decisions might cause a really large number of propagations to
     * happen when integer variables with large domains are only reduced by 1 at
     * each step. If we propagate more than the number of variable times this
     * parameters we try to take counter-measure. Setting this to 0.0 disable this
     * feature.
     *
     * TODO(user): Setting this to something like 10 helps in most cases, but the
     * code is currently buggy and can cause the solve to enter a bad state where
     * no progress is made.
     * </pre>
     *
     * <code>optional double propagation_loop_detection_factor = 221 [default = 10];</code>
     * @return This builder for chaining.
     */
    public Builder clearPropagationLoopDetectionFactor() {
      bitField3_ = (bitField3_ & ~0x00040000);
      propagationLoopDetectionFactor_ = 10D;
      onChanged();
      return this;
    }

    private boolean usePrecedencesInDisjunctiveConstraint_ = true;
    /**
     * <pre>
     * When this is true, then a disjunctive constraint will try to use the
     * precedence relations between time intervals to propagate their bounds
     * further. For instance if task A and B are both before C and task A and B
     * are in disjunction, then we can deduce that task C must start after
     * duration(A) + duration(B) instead of simply max(duration(A), duration(B)),
     * provided that the start time for all task was currently zero.
     *
     * This always result in better propagation, but it is usually slow, so
     * depending on the problem, turning this off may lead to a faster solution.
     * </pre>
     *
     * <code>optional bool use_precedences_in_disjunctive_constraint = 74 [default = true];</code>
     * @return Whether the usePrecedencesInDisjunctiveConstraint field is set.
     */
    @java.lang.Override
    public boolean hasUsePrecedencesInDisjunctiveConstraint() {
      return ((bitField3_ & 0x00080000) != 0);
    }
    /**
     * <pre>
     * When this is true, then a disjunctive constraint will try to use the
     * precedence relations between time intervals to propagate their bounds
     * further. For instance if task A and B are both before C and task A and B
     * are in disjunction, then we can deduce that task C must start after
     * duration(A) + duration(B) instead of simply max(duration(A), duration(B)),
     * provided that the start time for all task was currently zero.
     *
     * This always result in better propagation, but it is usually slow, so
     * depending on the problem, turning this off may lead to a faster solution.
     * </pre>
     *
     * <code>optional bool use_precedences_in_disjunctive_constraint = 74 [default = true];</code>
     * @return The usePrecedencesInDisjunctiveConstraint.
     */
    @java.lang.Override
    public boolean getUsePrecedencesInDisjunctiveConstraint() {
      return usePrecedencesInDisjunctiveConstraint_;
    }
    /**
     * <pre>
     * When this is true, then a disjunctive constraint will try to use the
     * precedence relations between time intervals to propagate their bounds
     * further. For instance if task A and B are both before C and task A and B
     * are in disjunction, then we can deduce that task C must start after
     * duration(A) + duration(B) instead of simply max(duration(A), duration(B)),
     * provided that the start time for all task was currently zero.
     *
     * This always result in better propagation, but it is usually slow, so
     * depending on the problem, turning this off may lead to a faster solution.
     * </pre>
     *
     * <code>optional bool use_precedences_in_disjunctive_constraint = 74 [default = true];</code>
     * @param value The usePrecedencesInDisjunctiveConstraint to set.
     * @return This builder for chaining.
     */
    public Builder setUsePrecedencesInDisjunctiveConstraint(boolean value) {

      usePrecedencesInDisjunctiveConstraint_ = value;
      bitField3_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * When this is true, then a disjunctive constraint will try to use the
     * precedence relations between time intervals to propagate their bounds
     * further. For instance if task A and B are both before C and task A and B
     * are in disjunction, then we can deduce that task C must start after
     * duration(A) + duration(B) instead of simply max(duration(A), duration(B)),
     * provided that the start time for all task was currently zero.
     *
     * This always result in better propagation, but it is usually slow, so
     * depending on the problem, turning this off may lead to a faster solution.
     * </pre>
     *
     * <code>optional bool use_precedences_in_disjunctive_constraint = 74 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearUsePrecedencesInDisjunctiveConstraint() {
      bitField3_ = (bitField3_ & ~0x00080000);
      usePrecedencesInDisjunctiveConstraint_ = true;
      onChanged();
      return this;
    }

    private int maxSizeToCreatePrecedenceLiteralsInDisjunctive_ = 60;
    /**
     * <pre>
     * Create one literal for each disjunction of two pairs of tasks. This slows
     * down the solve time, but improves the lower bound of the objective in the
     * makespan case. This will be triggered if the number of intervals is less or
     * equal than the parameter and if use_strong_propagation_in_disjunctive is
     * true.
     * </pre>
     *
     * <code>optional int32 max_size_to_create_precedence_literals_in_disjunctive = 229 [default = 60];</code>
     * @return Whether the maxSizeToCreatePrecedenceLiteralsInDisjunctive field is set.
     */
    @java.lang.Override
    public boolean hasMaxSizeToCreatePrecedenceLiteralsInDisjunctive() {
      return ((bitField3_ & 0x00100000) != 0);
    }
    /**
     * <pre>
     * Create one literal for each disjunction of two pairs of tasks. This slows
     * down the solve time, but improves the lower bound of the objective in the
     * makespan case. This will be triggered if the number of intervals is less or
     * equal than the parameter and if use_strong_propagation_in_disjunctive is
     * true.
     * </pre>
     *
     * <code>optional int32 max_size_to_create_precedence_literals_in_disjunctive = 229 [default = 60];</code>
     * @return The maxSizeToCreatePrecedenceLiteralsInDisjunctive.
     */
    @java.lang.Override
    public int getMaxSizeToCreatePrecedenceLiteralsInDisjunctive() {
      return maxSizeToCreatePrecedenceLiteralsInDisjunctive_;
    }
    /**
     * <pre>
     * Create one literal for each disjunction of two pairs of tasks. This slows
     * down the solve time, but improves the lower bound of the objective in the
     * makespan case. This will be triggered if the number of intervals is less or
     * equal than the parameter and if use_strong_propagation_in_disjunctive is
     * true.
     * </pre>
     *
     * <code>optional int32 max_size_to_create_precedence_literals_in_disjunctive = 229 [default = 60];</code>
     * @param value The maxSizeToCreatePrecedenceLiteralsInDisjunctive to set.
     * @return This builder for chaining.
     */
    public Builder setMaxSizeToCreatePrecedenceLiteralsInDisjunctive(int value) {

      maxSizeToCreatePrecedenceLiteralsInDisjunctive_ = value;
      bitField3_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Create one literal for each disjunction of two pairs of tasks. This slows
     * down the solve time, but improves the lower bound of the objective in the
     * makespan case. This will be triggered if the number of intervals is less or
     * equal than the parameter and if use_strong_propagation_in_disjunctive is
     * true.
     * </pre>
     *
     * <code>optional int32 max_size_to_create_precedence_literals_in_disjunctive = 229 [default = 60];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxSizeToCreatePrecedenceLiteralsInDisjunctive() {
      bitField3_ = (bitField3_ & ~0x00100000);
      maxSizeToCreatePrecedenceLiteralsInDisjunctive_ = 60;
      onChanged();
      return this;
    }

    private boolean useStrongPropagationInDisjunctive_ ;
    /**
     * <pre>
     * Enable stronger and more expensive propagation on no_overlap constraint.
     * </pre>
     *
     * <code>optional bool use_strong_propagation_in_disjunctive = 230 [default = false];</code>
     * @return Whether the useStrongPropagationInDisjunctive field is set.
     */
    @java.lang.Override
    public boolean hasUseStrongPropagationInDisjunctive() {
      return ((bitField3_ & 0x00200000) != 0);
    }
    /**
     * <pre>
     * Enable stronger and more expensive propagation on no_overlap constraint.
     * </pre>
     *
     * <code>optional bool use_strong_propagation_in_disjunctive = 230 [default = false];</code>
     * @return The useStrongPropagationInDisjunctive.
     */
    @java.lang.Override
    public boolean getUseStrongPropagationInDisjunctive() {
      return useStrongPropagationInDisjunctive_;
    }
    /**
     * <pre>
     * Enable stronger and more expensive propagation on no_overlap constraint.
     * </pre>
     *
     * <code>optional bool use_strong_propagation_in_disjunctive = 230 [default = false];</code>
     * @param value The useStrongPropagationInDisjunctive to set.
     * @return This builder for chaining.
     */
    public Builder setUseStrongPropagationInDisjunctive(boolean value) {

      useStrongPropagationInDisjunctive_ = value;
      bitField3_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Enable stronger and more expensive propagation on no_overlap constraint.
     * </pre>
     *
     * <code>optional bool use_strong_propagation_in_disjunctive = 230 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseStrongPropagationInDisjunctive() {
      bitField3_ = (bitField3_ & ~0x00200000);
      useStrongPropagationInDisjunctive_ = false;
      onChanged();
      return this;
    }

    private boolean useDynamicPrecedenceInDisjunctive_ ;
    /**
     * <pre>
     * Whether we try to branch on decision "interval A before interval B" rather
     * than on intervals bounds. This usually works better, but slow down a bit
     * the time to find the first solution.
     *
     * These parameters are still EXPERIMENTAL, the result should be correct, but
     * it some corner cases, they can cause some failing CHECK in the solver.
     * </pre>
     *
     * <code>optional bool use_dynamic_precedence_in_disjunctive = 263 [default = false];</code>
     * @return Whether the useDynamicPrecedenceInDisjunctive field is set.
     */
    @java.lang.Override
    public boolean hasUseDynamicPrecedenceInDisjunctive() {
      return ((bitField3_ & 0x00400000) != 0);
    }
    /**
     * <pre>
     * Whether we try to branch on decision "interval A before interval B" rather
     * than on intervals bounds. This usually works better, but slow down a bit
     * the time to find the first solution.
     *
     * These parameters are still EXPERIMENTAL, the result should be correct, but
     * it some corner cases, they can cause some failing CHECK in the solver.
     * </pre>
     *
     * <code>optional bool use_dynamic_precedence_in_disjunctive = 263 [default = false];</code>
     * @return The useDynamicPrecedenceInDisjunctive.
     */
    @java.lang.Override
    public boolean getUseDynamicPrecedenceInDisjunctive() {
      return useDynamicPrecedenceInDisjunctive_;
    }
    /**
     * <pre>
     * Whether we try to branch on decision "interval A before interval B" rather
     * than on intervals bounds. This usually works better, but slow down a bit
     * the time to find the first solution.
     *
     * These parameters are still EXPERIMENTAL, the result should be correct, but
     * it some corner cases, they can cause some failing CHECK in the solver.
     * </pre>
     *
     * <code>optional bool use_dynamic_precedence_in_disjunctive = 263 [default = false];</code>
     * @param value The useDynamicPrecedenceInDisjunctive to set.
     * @return This builder for chaining.
     */
    public Builder setUseDynamicPrecedenceInDisjunctive(boolean value) {

      useDynamicPrecedenceInDisjunctive_ = value;
      bitField3_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we try to branch on decision "interval A before interval B" rather
     * than on intervals bounds. This usually works better, but slow down a bit
     * the time to find the first solution.
     *
     * These parameters are still EXPERIMENTAL, the result should be correct, but
     * it some corner cases, they can cause some failing CHECK in the solver.
     * </pre>
     *
     * <code>optional bool use_dynamic_precedence_in_disjunctive = 263 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseDynamicPrecedenceInDisjunctive() {
      bitField3_ = (bitField3_ & ~0x00400000);
      useDynamicPrecedenceInDisjunctive_ = false;
      onChanged();
      return this;
    }

    private boolean useDynamicPrecedenceInCumulative_ ;
    /**
     * <code>optional bool use_dynamic_precedence_in_cumulative = 268 [default = false];</code>
     * @return Whether the useDynamicPrecedenceInCumulative field is set.
     */
    @java.lang.Override
    public boolean hasUseDynamicPrecedenceInCumulative() {
      return ((bitField3_ & 0x00800000) != 0);
    }
    /**
     * <code>optional bool use_dynamic_precedence_in_cumulative = 268 [default = false];</code>
     * @return The useDynamicPrecedenceInCumulative.
     */
    @java.lang.Override
    public boolean getUseDynamicPrecedenceInCumulative() {
      return useDynamicPrecedenceInCumulative_;
    }
    /**
     * <code>optional bool use_dynamic_precedence_in_cumulative = 268 [default = false];</code>
     * @param value The useDynamicPrecedenceInCumulative to set.
     * @return This builder for chaining.
     */
    public Builder setUseDynamicPrecedenceInCumulative(boolean value) {

      useDynamicPrecedenceInCumulative_ = value;
      bitField3_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     * <code>optional bool use_dynamic_precedence_in_cumulative = 268 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseDynamicPrecedenceInCumulative()