/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.sat;

import com.google.ortools.sat.CpModelProto;
import com.google.ortools.sat.CpSolverResponse;
import com.google.ortools.sat.SatParameters;
import com.google.ortools.sat.SolutionCallback;
import com.google.ortools.sat.mainJNI;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.function.Consumer;

public class SolveWrapper {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    public SolveWrapper(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(SolveWrapper obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public static long swigRelease(SolveWrapper obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_SolveWrapper(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setParameters(SatParameters parameters) {
        mainJNI.SolveWrapper_setParameters(this.swigCPtr, this, parameters.toByteArray());
    }

    public void addSolutionCallback(SolutionCallback callback) {
        mainJNI.SolveWrapper_addSolutionCallback(this.swigCPtr, this, SolutionCallback.getCPtr(callback), callback);
    }

    public void clearSolutionCallback(SolutionCallback callback) {
        mainJNI.SolveWrapper_clearSolutionCallback(this.swigCPtr, this, SolutionCallback.getCPtr(callback), callback);
    }

    public void addLogCallback(Consumer<String> log_callback) {
        mainJNI.SolveWrapper_addLogCallback(this.swigCPtr, this, log_callback);
    }

    public void addBestBoundCallback(Consumer<Double> best_bound_callback) {
        mainJNI.SolveWrapper_addBestBoundCallback(this.swigCPtr, this, best_bound_callback);
    }

    public CpSolverResponse solve(CpModelProto model_proto) {
        byte[] buf = mainJNI.SolveWrapper_solve(this.swigCPtr, this, model_proto.toByteArray());
        if (buf == null || buf.length == 0) {
            return null;
        }
        try {
            return CpSolverResponse.parseFrom(buf);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Unable to parse com.google.ortools.sat.CpSolverResponse protocol message.");
        }
    }

    public void stopSearch() {
        mainJNI.SolveWrapper_stopSearch(this.swigCPtr, this);
    }

    public SolveWrapper() {
        this(mainJNI.new_SolveWrapper(), true);
    }
}

