// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: ortools/bop/bop_parameters.proto
// Protobuf Java Version: 4.29.3

package com.google.ortools.bop;

/**
 * <pre>
 * Contains the definitions for all the bop algorithm parameters and their
 * default values.
 *
 * NEXT TAG: 42
 * </pre>
 *
 * Protobuf type {@code operations_research.bop.BopParameters}
 */
public final class BopParameters extends
    com.google.protobuf.GeneratedMessage implements
    // @@protoc_insertion_point(message_implements:operations_research.bop.BopParameters)
    BopParametersOrBuilder {
private static final long serialVersionUID = 0L;
  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
      com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
      /* major= */ 4,
      /* minor= */ 29,
      /* patch= */ 3,
      /* suffix= */ "",
      BopParameters.class.getName());
  }
  // Use BopParameters.newBuilder() to construct.
  private BopParameters(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }
  private BopParameters() {
    maxTimeInSeconds_ = Double.POSITIVE_INFINITY;
    maxDeterministicTime_ = Double.POSITIVE_INFINITY;
    lpMaxDeterministicTime_ = 1D;
    relativeGapLimit_ = 0.0001D;
    maxNumDecisionsInLs_ = 4;
    maxNumBrokenConstraintsInLs_ = 2147483647;
    computeEstimatedImpact_ = true;
    useRandomLns_ = true;
    randomSeed_ = 8;
    numRelaxedVars_ = 10;
    maxNumberOfConflictsInRandomLns_ = 2500;
    numRandomLnsTries_ = 1;
    maxNumberOfBacktracksInLs_ = 100000000L;
    useLpLns_ = true;
    useSatToChooseLnsNeighbourhood_ = true;
    maxNumberOfConflictsForQuickCheck_ = 10;
    maxNumberOfConflictsInRandomSolutionGeneration_ = 500;
    maxNumberOfExploredAssignmentsPerTryInLs_ = 10000L;
    useTranspositionTableInLs_ = true;
    useLearnedBinaryClausesInLp_ = true;
    numberOfSolvers_ = 1;
    synchronizationType_ = 0;
    solverOptimizerSets_ = java.util.Collections.emptyList();
    defaultSolverOptimizerSets_ = "methods:{type:LOCAL_SEARCH }                       methods:{type:RANDOM_FIRST_SOLUTION }              methods:{type:LINEAR_RELAXATION }                  methods:{type:LP_FIRST_SOLUTION }                  methods:{type:OBJECTIVE_FIRST_SOLUTION }           methods:{type:USER_GUIDED_FIRST_SOLUTION }         methods:{type:RANDOM_CONSTRAINT_LNS_GUIDED_BY_LP } methods:{type:RANDOM_VARIABLE_LNS_GUIDED_BY_LP }   methods:{type:RELATION_GRAPH_LNS }                 methods:{type:RELATION_GRAPH_LNS_GUIDED_BY_LP }    methods:{type:RANDOM_CONSTRAINT_LNS }              methods:{type:RANDOM_VARIABLE_LNS }                methods:{type:SAT_CORE_BASED }                     methods:{type:COMPLETE_LNS }                       ";
    decomposerNumVariablesThreshold_ = 50;
    numBopSolversUsedByDecomposition_ = 1;
    guidedSatConflictsChunk_ = 1000;
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ortools.bop.BopParametersOuterClass.internal_static_operations_research_bop_BopParameters_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ortools.bop.BopParametersOuterClass.internal_static_operations_research_bop_BopParameters_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ortools.bop.BopParameters.class, com.google.ortools.bop.BopParameters.Builder.class);
  }

  /**
   * <pre>
   * Defines how the different solvers are synchronized during the search.
   * Note that the synchronization (if any) occurs before each call to an
   * optimizer (the smallest granularity of the solver in a parallel context).
   * </pre>
   *
   * Protobuf enum {@code operations_research.bop.BopParameters.ThreadSynchronizationType}
   */
  public enum ThreadSynchronizationType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * No synchronization. The solvers run independently until the time limit
     * is reached; Then learned information from each solver are aggregated.
     * The final solution is the best of all found solutions.
     * Pros: - No need to wait for another solver to complete its task,
     * - Adding a new solver always improves the final solution (In the
     * current implementation it still depends on the machine load and
     * the time limit).
     * Cons: - No learning between solvers.
     * </pre>
     *
     * <code>NO_SYNCHRONIZATION = 0;</code>
     */
    NO_SYNCHRONIZATION(0),
    /**
     * <pre>
     * Synchronize all solvers. Each solver waits for all other solvers to
     * complete the previous optimizer run, before running again.
     * The final solution is the best of all found solutions.
     * Pros: - Full learning between solvers.
     * Cons: - A lot of waiting time when solvers don't run at the exact same
     * speed,
     * - The quality of the final solution depends on the number of
     * solvers, adding one more solver might lead to poorer results
     * because the search goes on a different path.
     * </pre>
     *
     * <code>SYNCHRONIZE_ALL = 1;</code>
     */
    SYNCHRONIZE_ALL(1),
    /**
     * <pre>
     * Solver i synchronizes with solvers 0..i-1.
     * This is a good tradeoff between NO_SYNCHRONIZATION and SYNCHRONIZE_ALL:
     * communication while keeping a relative determinism on the result even
     * when the number of solvers increases.
     * The final solution is the best of all found solutions.
     * Pros: - Solver i learns from i different solvers,
     * - Adding a new solver always improves the final solution (In the
     * current implementation it still depends on the machine load and
     * the time limit).
     * Cons: - No full learning,
     * - Some solvers need to wait for synchronization.
     * </pre>
     *
     * <code>SYNCHRONIZE_ON_RIGHT = 2;</code>
     */
    SYNCHRONIZE_ON_RIGHT(2),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 3,
        /* suffix= */ "",
        ThreadSynchronizationType.class.getName());
    }
    /**
     * <pre>
     * No synchronization. The solvers run independently until the time limit
     * is reached; Then learned information from each solver are aggregated.
     * The final solution is the best of all found solutions.
     * Pros: - No need to wait for another solver to complete its task,
     * - Adding a new solver always improves the final solution (In the
     * current implementation it still depends on the machine load and
     * the time limit).
     * Cons: - No learning between solvers.
     * </pre>
     *
     * <code>NO_SYNCHRONIZATION = 0;</code>
     */
    public static final int NO_SYNCHRONIZATION_VALUE = 0;
    /**
     * <pre>
     * Synchronize all solvers. Each solver waits for all other solvers to
     * complete the previous optimizer run, before running again.
     * The final solution is the best of all found solutions.
     * Pros: - Full learning between solvers.
     * Cons: - A lot of waiting time when solvers don't run at the exact same
     * speed,
     * - The quality of the final solution depends on the number of
     * solvers, adding one more solver might lead to poorer results
     * because the search goes on a different path.
     * </pre>
     *
     * <code>SYNCHRONIZE_ALL = 1;</code>
     */
    public static final int SYNCHRONIZE_ALL_VALUE = 1;
    /**
     * <pre>
     * Solver i synchronizes with solvers 0..i-1.
     * This is a good tradeoff between NO_SYNCHRONIZATION and SYNCHRONIZE_ALL:
     * communication while keeping a relative determinism on the result even
     * when the number of solvers increases.
     * The final solution is the best of all found solutions.
     * Pros: - Solver i learns from i different solvers,
     * - Adding a new solver always improves the final solution (In the
     * current implementation it still depends on the machine load and
     * the time limit).
     * Cons: - No full learning,
     * - Some solvers need to wait for synchronization.
     * </pre>
     *
     * <code>SYNCHRONIZE_ON_RIGHT = 2;</code>
     */
    public static final int SYNCHRONIZE_ON_RIGHT_VALUE = 2;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ThreadSynchronizationType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ThreadSynchronizationType forNumber(int value) {
      switch (value) {
        case 0: return NO_SYNCHRONIZATION;
        case 1: return SYNCHRONIZE_ALL;
        case 2: return SYNCHRONIZE_ON_RIGHT;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ThreadSynchronizationType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ThreadSynchronizationType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ThreadSynchronizationType>() {
            public ThreadSynchronizationType findValueByNumber(int number) {
              return ThreadSynchronizationType.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.bop.BopParameters.getDescriptor().getEnumTypes().get(0);
    }

    private static final ThreadSynchronizationType[] VALUES = values();

    public static ThreadSynchronizationType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ThreadSynchronizationType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.bop.BopParameters.ThreadSynchronizationType)
  }

  private int bitField0_;
  private int bitField1_;
  public static final int MAX_TIME_IN_SECONDS_FIELD_NUMBER = 1;
  private double maxTimeInSeconds_ = Double.POSITIVE_INFINITY;
  /**
   * <pre>
   * Maximum time allowed in seconds to solve a problem.
   * The counter will starts as soon as Solve() is called.
   * </pre>
   *
   * <code>optional double max_time_in_seconds = 1 [default = inf];</code>
   * @return Whether the maxTimeInSeconds field is set.
   */
  @java.lang.Override
  public boolean hasMaxTimeInSeconds() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Maximum time allowed in seconds to solve a problem.
   * The counter will starts as soon as Solve() is called.
   * </pre>
   *
   * <code>optional double max_time_in_seconds = 1 [default = inf];</code>
   * @return The maxTimeInSeconds.
   */
  @java.lang.Override
  public double getMaxTimeInSeconds() {
    return maxTimeInSeconds_;
  }

  public static final int MAX_DETERMINISTIC_TIME_FIELD_NUMBER = 27;
  private double maxDeterministicTime_ = Double.POSITIVE_INFINITY;
  /**
   * <pre>
   * Maximum time allowed in deterministic time to solve a problem.
   * The deterministic time should be correlated with the real time used by the
   * solver, the time unit being roughly the order of magnitude of a second.
   * The counter will starts as soon as SetParameters() or SolveWithTimeLimit()
   * is called.
   * </pre>
   *
   * <code>optional double max_deterministic_time = 27 [default = inf];</code>
   * @return Whether the maxDeterministicTime field is set.
   */
  @java.lang.Override
  public boolean hasMaxDeterministicTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * Maximum time allowed in deterministic time to solve a problem.
   * The deterministic time should be correlated with the real time used by the
   * solver, the time unit being roughly the order of magnitude of a second.
   * The counter will starts as soon as SetParameters() or SolveWithTimeLimit()
   * is called.
   * </pre>
   *
   * <code>optional double max_deterministic_time = 27 [default = inf];</code>
   * @return The maxDeterministicTime.
   */
  @java.lang.Override
  public double getMaxDeterministicTime() {
    return maxDeterministicTime_;
  }

  public static final int LP_MAX_DETERMINISTIC_TIME_FIELD_NUMBER = 37;
  private double lpMaxDeterministicTime_ = 1D;
  /**
   * <pre>
   * The max deterministic time given to the LP solver each time it is called.
   * If this is not enough to solve the LP at hand, it will simply be called
   * again later (and the solve will resume from where it stopped).
   * </pre>
   *
   * <code>optional double lp_max_deterministic_time = 37 [default = 1];</code>
   * @return Whether the lpMaxDeterministicTime field is set.
   */
  @java.lang.Override
  public boolean hasLpMaxDeterministicTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * The max deterministic time given to the LP solver each time it is called.
   * If this is not enough to solve the LP at hand, it will simply be called
   * again later (and the solve will resume from where it stopped).
   * </pre>
   *
   * <code>optional double lp_max_deterministic_time = 37 [default = 1];</code>
   * @return The lpMaxDeterministicTime.
   */
  @java.lang.Override
  public double getLpMaxDeterministicTime() {
    return lpMaxDeterministicTime_;
  }

  public static final int MAX_NUMBER_OF_CONSECUTIVE_FAILING_OPTIMIZER_CALLS_FIELD_NUMBER = 35;
  private int maxNumberOfConsecutiveFailingOptimizerCalls_ = 0;
  /**
   * <pre>
   * Maximum number of consecutive optimizer calls without improving the
   * current solution. If this number is reached, the search will be aborted.
   * Note that this parameter only applies when an initial solution has been
   * found or is provided. Also note that there is no limit to the number of
   * calls, when the parameter is not set.
   * </pre>
   *
   * <code>optional int32 max_number_of_consecutive_failing_optimizer_calls = 35;</code>
   * @return Whether the maxNumberOfConsecutiveFailingOptimizerCalls field is set.
   */
  @java.lang.Override
  public boolean hasMaxNumberOfConsecutiveFailingOptimizerCalls() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * Maximum number of consecutive optimizer calls without improving the
   * current solution. If this number is reached, the search will be aborted.
   * Note that this parameter only applies when an initial solution has been
   * found or is provided. Also note that there is no limit to the number of
   * calls, when the parameter is not set.
   * </pre>
   *
   * <code>optional int32 max_number_of_consecutive_failing_optimizer_calls = 35;</code>
   * @return The maxNumberOfConsecutiveFailingOptimizerCalls.
   */
  @java.lang.Override
  public int getMaxNumberOfConsecutiveFailingOptimizerCalls() {
    return maxNumberOfConsecutiveFailingOptimizerCalls_;
  }

  public static final int RELATIVE_GAP_LIMIT_FIELD_NUMBER = 28;
  private double relativeGapLimit_ = 0.0001D;
  /**
   * <pre>
   * Limit used to stop the optimization as soon as the relative gap is smaller
   * than the given value.
   * The relative gap is defined as:
   * abs(solution_cost - best_bound)
   * / max(abs(solution_cost), abs(best_bound)).
   * </pre>
   *
   * <code>optional double relative_gap_limit = 28 [default = 0.0001];</code>
   * @return Whether the relativeGapLimit field is set.
   */
  @java.lang.Override
  public boolean hasRelativeGapLimit() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * Limit used to stop the optimization as soon as the relative gap is smaller
   * than the given value.
   * The relative gap is defined as:
   * abs(solution_cost - best_bound)
   * / max(abs(solution_cost), abs(best_bound)).
   * </pre>
   *
   * <code>optional double relative_gap_limit = 28 [default = 0.0001];</code>
   * @return The relativeGapLimit.
   */
  @java.lang.Override
  public double getRelativeGapLimit() {
    return relativeGapLimit_;
  }

  public static final int MAX_NUM_DECISIONS_IN_LS_FIELD_NUMBER = 2;
  private int maxNumDecisionsInLs_ = 4;
  /**
   * <pre>
   * Maximum number of cascading decisions the solver might use to repair the
   * current solution in the LS.
   * </pre>
   *
   * <code>optional int32 max_num_decisions_in_ls = 2 [default = 4];</code>
   * @return Whether the maxNumDecisionsInLs field is set.
   */
  @java.lang.Override
  public boolean hasMaxNumDecisionsInLs() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   * <pre>
   * Maximum number of cascading decisions the solver might use to repair the
   * current solution in the LS.
   * </pre>
   *
   * <code>optional int32 max_num_decisions_in_ls = 2 [default = 4];</code>
   * @return The maxNumDecisionsInLs.
   */
  @java.lang.Override
  public int getMaxNumDecisionsInLs() {
    return maxNumDecisionsInLs_;
  }

  public static final int MAX_NUM_BROKEN_CONSTRAINTS_IN_LS_FIELD_NUMBER = 38;
  private int maxNumBrokenConstraintsInLs_ = 2147483647;
  /**
   * <pre>
   * Abort the LS search tree as soon as strictly more than this number of
   * constraints are broken. The default is a large value which basically
   * disable this heuristic.
   * </pre>
   *
   * <code>optional int32 max_num_broken_constraints_in_ls = 38 [default = 2147483647];</code>
   * @return Whether the maxNumBrokenConstraintsInLs field is set.
   */
  @java.lang.Override
  public boolean hasMaxNumBrokenConstraintsInLs() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   * <pre>
   * Abort the LS search tree as soon as strictly more than this number of
   * constraints are broken. The default is a large value which basically
   * disable this heuristic.
   * </pre>
   *
   * <code>optional int32 max_num_broken_constraints_in_ls = 38 [default = 2147483647];</code>
   * @return The maxNumBrokenConstraintsInLs.
   */
  @java.lang.Override
  public int getMaxNumBrokenConstraintsInLs() {
    return maxNumBrokenConstraintsInLs_;
  }

  public static final int LOG_SEARCH_PROGRESS_FIELD_NUMBER = 14;
  private boolean logSearchProgress_ = false;
  /**
   * <pre>
   * Whether the solver should log the search progress to LOG(INFO).
   * </pre>
   *
   * <code>optional bool log_search_progress = 14 [default = false];</code>
   * @return Whether the logSearchProgress field is set.
   */
  @java.lang.Override
  public boolean hasLogSearchProgress() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   * <pre>
   * Whether the solver should log the search progress to LOG(INFO).
   * </pre>
   *
   * <code>optional bool log_search_progress = 14 [default = false];</code>
   * @return The logSearchProgress.
   */
  @java.lang.Override
  public boolean getLogSearchProgress() {
    return logSearchProgress_;
  }

  public static final int COMPUTE_ESTIMATED_IMPACT_FIELD_NUMBER = 3;
  private boolean computeEstimatedImpact_ = true;
  /**
   * <pre>
   * Compute estimated impact at each iteration when true; only once when false.
   * </pre>
   *
   * <code>optional bool compute_estimated_impact = 3 [default = true];</code>
   * @return Whether the computeEstimatedImpact field is set.
   */
  @java.lang.Override
  public boolean hasComputeEstimatedImpact() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   * <pre>
   * Compute estimated impact at each iteration when true; only once when false.
   * </pre>
   *
   * <code>optional bool compute_estimated_impact = 3 [default = true];</code>
   * @return The computeEstimatedImpact.
   */
  @java.lang.Override
  public boolean getComputeEstimatedImpact() {
    return computeEstimatedImpact_;
  }

  public static final int PRUNE_SEARCH_TREE_FIELD_NUMBER = 4;
  private boolean pruneSearchTree_ = false;
  /**
   * <pre>
   * Avoid exploring both branches (b, a, ...) and (a, b, ...).
   * </pre>
   *
   * <code>optional bool prune_search_tree = 4 [default = false];</code>
   * @return Whether the pruneSearchTree field is set.
   */
  @java.lang.Override
  public boolean hasPruneSearchTree() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   * <pre>
   * Avoid exploring both branches (b, a, ...) and (a, b, ...).
   * </pre>
   *
   * <code>optional bool prune_search_tree = 4 [default = false];</code>
   * @return The pruneSearchTree.
   */
  @java.lang.Override
  public boolean getPruneSearchTree() {
    return pruneSearchTree_;
  }

  public static final int SORT_CONSTRAINTS_BY_NUM_TERMS_FIELD_NUMBER = 5;
  private boolean sortConstraintsByNumTerms_ = false;
  /**
   * <pre>
   * Sort constraints by increasing total number of terms instead of number of
   * contributing terms.
   * </pre>
   *
   * <code>optional bool sort_constraints_by_num_terms = 5 [default = false];</code>
   * @return Whether the sortConstraintsByNumTerms field is set.
   */
  @java.lang.Override
  public boolean hasSortConstraintsByNumTerms() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   * <pre>
   * Sort constraints by increasing total number of terms instead of number of
   * contributing terms.
   * </pre>
   *
   * <code>optional bool sort_constraints_by_num_terms = 5 [default = false];</code>
   * @return The sortConstraintsByNumTerms.
   */
  @java.lang.Override
  public boolean getSortConstraintsByNumTerms() {
    return sortConstraintsByNumTerms_;
  }

  public static final int USE_RANDOM_LNS_FIELD_NUMBER = 6;
  private boolean useRandomLns_ = true;
  /**
   * <pre>
   * Use the random Large Neighborhood Search instead of the exhaustive one.
   * </pre>
   *
   * <code>optional bool use_random_lns = 6 [default = true];</code>
   * @return Whether the useRandomLns field is set.
   */
  @java.lang.Override
  public boolean hasUseRandomLns() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   * <pre>
   * Use the random Large Neighborhood Search instead of the exhaustive one.
   * </pre>
   *
   * <code>optional bool use_random_lns = 6 [default = true];</code>
   * @return The useRandomLns.
   */
  @java.lang.Override
  public boolean getUseRandomLns() {
    return useRandomLns_;
  }

  public static final int RANDOM_SEED_FIELD_NUMBER = 7;
  private int randomSeed_ = 8;
  /**
   * <pre>
   * The seed used to initialize the random generator.
   *
   * TODO(user): Some of our client test fail depending on this value! we need
   * to fix them and ideally randomize our behavior from on test to the next so
   * that this doesn't happen in the future.
   * </pre>
   *
   * <code>optional int32 random_seed = 7 [default = 8];</code>
   * @return Whether the randomSeed field is set.
   */
  @java.lang.Override
  public boolean hasRandomSeed() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   * <pre>
   * The seed used to initialize the random generator.
   *
   * TODO(user): Some of our client test fail depending on this value! we need
   * to fix them and ideally randomize our behavior from on test to the next so
   * that this doesn't happen in the future.
   * </pre>
   *
   * <code>optional int32 random_seed = 7 [default = 8];</code>
   * @return The randomSeed.
   */
  @java.lang.Override
  public int getRandomSeed() {
    return randomSeed_;
  }

  public static final int NUM_RELAXED_VARS_FIELD_NUMBER = 8;
  private int numRelaxedVars_ = 10;
  /**
   * <pre>
   * Number of variables to relax in the exhaustive Large Neighborhood Search.
   * </pre>
   *
   * <code>optional int32 num_relaxed_vars = 8 [default = 10];</code>
   * @return Whether the numRelaxedVars field is set.
   */
  @java.lang.Override
  public boolean hasNumRelaxedVars() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   * <pre>
   * Number of variables to relax in the exhaustive Large Neighborhood Search.
   * </pre>
   *
   * <code>optional int32 num_relaxed_vars = 8 [default = 10];</code>
   * @return The numRelaxedVars.
   */
  @java.lang.Override
  public int getNumRelaxedVars() {
    return numRelaxedVars_;
  }

  public static final int MAX_NUMBER_OF_CONFLICTS_IN_RANDOM_LNS_FIELD_NUMBER = 9;
  private int maxNumberOfConflictsInRandomLns_ = 2500;
  /**
   * <pre>
   * The number of conflicts the SAT solver has to solve a random LNS
   * subproblem.
   * </pre>
   *
   * <code>optional int32 max_number_of_conflicts_in_random_lns = 9 [default = 2500];</code>
   * @return Whether the maxNumberOfConflictsInRandomLns field is set.
   */
  @java.lang.Override
  public boolean hasMaxNumberOfConflictsInRandomLns() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   * <pre>
   * The number of conflicts the SAT solver has to solve a random LNS
   * subproblem.
   * </pre>
   *
   * <code>optional int32 max_number_of_conflicts_in_random_lns = 9 [default = 2500];</code>
   * @return The maxNumberOfConflictsInRandomLns.
   */
  @java.lang.Override
  public int getMaxNumberOfConflictsInRandomLns() {
    return maxNumberOfConflictsInRandomLns_;
  }

  public static final int NUM_RANDOM_LNS_TRIES_FIELD_NUMBER = 10;
  private int numRandomLnsTries_ = 1;
  /**
   * <pre>
   * Number of tries in the random lns.
   * </pre>
   *
   * <code>optional int32 num_random_lns_tries = 10 [default = 1];</code>
   * @return Whether the numRandomLnsTries field is set.
   */
  @java.lang.Override
  public boolean hasNumRandomLnsTries() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   * <pre>
   * Number of tries in the random lns.
   * </pre>
   *
   * <code>optional int32 num_random_lns_tries = 10 [default = 1];</code>
   * @return The numRandomLnsTries.
   */
  @java.lang.Override
  public int getNumRandomLnsTries() {
    return numRandomLnsTries_;
  }

  public static final int MAX_NUMBER_OF_BACKTRACKS_IN_LS_FIELD_NUMBER = 11;
  private long maxNumberOfBacktracksInLs_ = 100000000L;
  /**
   * <pre>
   * Maximum number of backtracks times the number of variables in Local Search,
   * ie. max num backtracks == max_number_of_backtracks_in_ls / num variables.
   * </pre>
   *
   * <code>optional int64 max_number_of_backtracks_in_ls = 11 [default = 100000000];</code>
   * @return Whether the maxNumberOfBacktracksInLs field is set.
   */
  @java.lang.Override
  public boolean hasMaxNumberOfBacktracksInLs() {
    return ((bitField0_ & 0x00010000) != 0);
  }
  /**
   * <pre>
   * Maximum number of backtracks times the number of variables in Local Search,
   * ie. max num backtracks == max_number_of_backtracks_in_ls / num variables.
   * </pre>
   *
   * <code>optional int64 max_number_of_backtracks_in_ls = 11 [default = 100000000];</code>
   * @return The maxNumberOfBacktracksInLs.
   */
  @java.lang.Override
  public long getMaxNumberOfBacktracksInLs() {
    return maxNumberOfBacktracksInLs_;
  }

  public static final int USE_LP_LNS_FIELD_NUMBER = 12;
  private boolean useLpLns_ = true;
  /**
   * <pre>
   * Use Large Neighborhood Search based on the LP relaxation.
   * </pre>
   *
   * <code>optional bool use_lp_lns = 12 [default = true];</code>
   * @return Whether the useLpLns field is set.
   */
  @java.lang.Override
  public boolean hasUseLpLns() {
    return ((bitField0_ & 0x00020000) != 0);
  }
  /**
   * <pre>
   * Use Large Neighborhood Search based on the LP relaxation.
   * </pre>
   *
   * <code>optional bool use_lp_lns = 12 [default = true];</code>
   * @return The useLpLns.
   */
  @java.lang.Override
  public boolean getUseLpLns() {
    return useLpLns_;
  }

  public static final int USE_SAT_TO_CHOOSE_LNS_NEIGHBOURHOOD_FIELD_NUMBER = 15;
  private boolean useSatToChooseLnsNeighbourhood_ = true;
  /**
   * <pre>
   * Whether we use sat propagation to choose the lns neighbourhood.
   * </pre>
   *
   * <code>optional bool use_sat_to_choose_lns_neighbourhood = 15 [default = true];</code>
   * @return Whether the useSatToChooseLnsNeighbourhood field is set.
   */
  @java.lang.Override
  public boolean hasUseSatToChooseLnsNeighbourhood() {
    return ((bitField0_ & 0x00040000) != 0);
  }
  /**
   * <pre>
   * Whether we use sat propagation to choose the lns neighbourhood.
   * </pre>
   *
   * <code>optional bool use_sat_to_choose_lns_neighbourhood = 15 [default = true];</code>
   * @return The useSatToChooseLnsNeighbourhood.
   */
  @java.lang.Override
  public boolean getUseSatToChooseLnsNeighbourhood() {
    return useSatToChooseLnsNeighbourhood_;
  }

  public static final int MAX_NUMBER_OF_CONFLICTS_FOR_QUICK_CHECK_FIELD_NUMBER = 16;
  private int maxNumberOfConflictsForQuickCheck_ = 10;
  /**
   * <pre>
   * The number of conflicts the SAT solver has to solve a random LNS
   * subproblem for the quick check of infeasibility.
   * </pre>
   *
   * <code>optional int32 max_number_of_conflicts_for_quick_check = 16 [default = 10];</code>
   * @return Whether the maxNumberOfConflictsForQuickCheck field is set.
   */
  @java.lang.Override
  public boolean hasMaxNumberOfConflictsForQuickCheck() {
    return ((bitField0_ & 0x00080000) != 0);
  }
  /**
   * <pre>
   * The number of conflicts the SAT solver has to solve a random LNS
   * subproblem for the quick check of infeasibility.
   * </pre>
   *
   * <code>optional int32 max_number_of_conflicts_for_quick_check = 16 [default = 10];</code>
   * @return The maxNumberOfConflictsForQuickCheck.
   */
  @java.lang.Override
  public int getMaxNumberOfConflictsForQuickCheck() {
    return maxNumberOfConflictsForQuickCheck_;
  }

  public static final int USE_SYMMETRY_FIELD_NUMBER = 17;
  private boolean useSymmetry_ = false;
  /**
   * <pre>
   * If true, find and exploit the eventual symmetries of the problem.
   *
   * TODO(user): turn this on by default once the symmetry finder becomes fast
   * enough to be negligeable for most problem. Or at least support a time
   * limit.
   * </pre>
   *
   * <code>optional bool use_symmetry = 17 [default = false];</code>
   * @return Whether the useSymmetry field is set.
   */
  @java.lang.Override
  public boolean hasUseSymmetry() {
    return ((bitField0_ & 0x00100000) != 0);
  }
  /**
   * <pre>
   * If true, find and exploit the eventual symmetries of the problem.
   *
   * TODO(user): turn this on by default once the symmetry finder becomes fast
   * enough to be negligeable for most problem. Or at least support a time
   * limit.
   * </pre>
   *
   * <code>optional bool use_symmetry = 17 [default = false];</code>
   * @return The useSymmetry.
   */
  @java.lang.Override
  public boolean getUseSymmetry() {
    return useSymmetry_;
  }

  public static final int EXPLOIT_SYMMETRY_IN_SAT_FIRST_SOLUTION_FIELD_NUMBER = 40;
  private boolean exploitSymmetryInSatFirstSolution_ = false;
  /**
   * <pre>
   * If true, find and exploit symmetries in proving satisfiability in the first
   * problem.
   * This feature is experimental. On some problems, computing symmetries may
   * run forever. You may also run into unforseen problems as this feature was
   * not extensively tested.
   * </pre>
   *
   * <code>optional bool exploit_symmetry_in_sat_first_solution = 40 [default = false];</code>
   * @return Whether the exploitSymmetryInSatFirstSolution field is set.
   */
  @java.lang.Override
  public boolean hasExploitSymmetryInSatFirstSolution() {
    return ((bitField0_ & 0x00200000) != 0);
  }
  /**
   * <pre>
   * If true, find and exploit symmetries in proving satisfiability in the first
   * problem.
   * This feature is experimental. On some problems, computing symmetries may
   * run forever. You may also run into unforseen problems as this feature was
   * not extensively tested.
   * </pre>
   *
   * <code>optional bool exploit_symmetry_in_sat_first_solution = 40 [default = false];</code>
   * @return The exploitSymmetryInSatFirstSolution.
   */
  @java.lang.Override
  public boolean getExploitSymmetryInSatFirstSolution() {
    return exploitSymmetryInSatFirstSolution_;
  }

  public static final int MAX_NUMBER_OF_CONFLICTS_IN_RANDOM_SOLUTION_GENERATION_FIELD_NUMBER = 20;
  private int maxNumberOfConflictsInRandomSolutionGeneration_ = 500;
  /**
   * <pre>
   * The number of conflicts the SAT solver has to generate a random solution.
   * </pre>
   *
   * <code>optional int32 max_number_of_conflicts_in_random_solution_generation = 20 [default = 500];</code>
   * @return Whether the maxNumberOfConflictsInRandomSolutionGeneration field is set.
   */
  @java.lang.Override
  public boolean hasMaxNumberOfConflictsInRandomSolutionGeneration() {
    return ((bitField0_ & 0x00400000) != 0);
  }
  /**
   * <pre>
   * The number of conflicts the SAT solver has to generate a random solution.
   * </pre>
   *
   * <code>optional int32 max_number_of_conflicts_in_random_solution_generation = 20 [default = 500];</code>
   * @return The maxNumberOfConflictsInRandomSolutionGeneration.
   */
  @java.lang.Override
  public int getMaxNumberOfConflictsInRandomSolutionGeneration() {
    return maxNumberOfConflictsInRandomSolutionGeneration_;
  }

  public static final int MAX_NUMBER_OF_EXPLORED_ASSIGNMENTS_PER_TRY_IN_LS_FIELD_NUMBER = 21;
  private long maxNumberOfExploredAssignmentsPerTryInLs_ = 10000L;
  /**
   * <pre>
   * The maximum number of assignments the Local Search iterates on during one
   * try. Note that if the Local Search is called again on the same solution
   * it will not restart from scratch but will iterate on the next
   * max_number_of_explored_assignments_per_try_in_ls assignments.
   * </pre>
   *
   * <code>optional int64 max_number_of_explored_assignments_per_try_in_ls = 21 [default = 10000];</code>
   * @return Whether the maxNumberOfExploredAssignmentsPerTryInLs field is set.
   */
  @java.lang.Override
  public boolean hasMaxNumberOfExploredAssignmentsPerTryInLs() {
    return ((bitField0_ & 0x00800000) != 0);
  }
  /**
   * <pre>
   * The maximum number of assignments the Local Search iterates on during one
   * try. Note that if the Local Search is called again on the same solution
   * it will not restart from scratch but will iterate on the next
   * max_number_of_explored_assignments_per_try_in_ls assignments.
   * </pre>
   *
   * <code>optional int64 max_number_of_explored_assignments_per_try_in_ls = 21 [default = 10000];</code>
   * @return The maxNumberOfExploredAssignmentsPerTryInLs.
   */
  @java.lang.Override
  public long getMaxNumberOfExploredAssignmentsPerTryInLs() {
    return maxNumberOfExploredAssignmentsPerTryInLs_;
  }

  public static final int USE_TRANSPOSITION_TABLE_IN_LS_FIELD_NUMBER = 22;
  private boolean useTranspositionTableInLs_ = true;
  /**
   * <pre>
   * Whether we use an hash set during the LS to avoid exploring more than once
   * the "same" state. Note that because the underlying SAT solver may learn
   * information in the middle of the LS, this may make the LS slightly less
   * "complete", but it should be faster.
   * </pre>
   *
   * <code>optional bool use_transposition_table_in_ls = 22 [default = true];</code>
   * @return Whether the useTranspositionTableInLs field is set.
   */
  @java.lang.Override
  public boolean hasUseTranspositionTableInLs() {
    return ((bitField0_ & 0x01000000) != 0);
  }
  /**
   * <pre>
   * Whether we use an hash set during the LS to avoid exploring more than once
   * the "same" state. Note that because the underlying SAT solver may learn
   * information in the middle of the LS, this may make the LS slightly less
   * "complete", but it should be faster.
   * </pre>
   *
   * <code>optional bool use_transposition_table_in_ls = 22 [default = true];</code>
   * @return The useTranspositionTableInLs.
   */
  @java.lang.Override
  public boolean getUseTranspositionTableInLs() {
    return useTranspositionTableInLs_;
  }

  public static final int USE_POTENTIAL_ONE_FLIP_REPAIRS_IN_LS_FIELD_NUMBER = 39;
  private boolean usePotentialOneFlipRepairsInLs_ = false;
  /**
   * <pre>
   * Whether we keep a list of variable that can potentially repair in one flip
   * all the current infeasible constraints (such variable must at least appear
   * in all the infeasible constraints for this to happen).
   * </pre>
   *
   * <code>optional bool use_potential_one_flip_repairs_in_ls = 39 [default = false];</code>
   * @return Whether the usePotentialOneFlipRepairsInLs field is set.
   */
  @java.lang.Override
  public boolean hasUsePotentialOneFlipRepairsInLs() {
    return ((bitField0_ & 0x02000000) != 0);
  }
  /**
   * <pre>
   * Whether we keep a list of variable that can potentially repair in one flip
   * all the current infeasible constraints (such variable must at least appear
   * in all the infeasible constraints for this to happen).
   * </pre>
   *
   * <code>optional bool use_potential_one_flip_repairs_in_ls = 39 [default = false];</code>
   * @return The usePotentialOneFlipRepairsInLs.
   */
  @java.lang.Override
  public boolean getUsePotentialOneFlipRepairsInLs() {
    return usePotentialOneFlipRepairsInLs_;
  }

  public static final int USE_LEARNED_BINARY_CLAUSES_IN_LP_FIELD_NUMBER = 23;
  private boolean useLearnedBinaryClausesInLp_ = true;
  /**
   * <pre>
   * Whether we use the learned binary clauses in the Linear Relaxation.
   * </pre>
   *
   * <code>optional bool use_learned_binary_clauses_in_lp = 23 [default = true];</code>
   * @return Whether the useLearnedBinaryClausesInLp field is set.
   */
  @java.lang.Override
  public boolean hasUseLearnedBinaryClausesInLp() {
    return ((bitField0_ & 0x04000000) != 0);
  }
  /**
   * <pre>
   * Whether we use the learned binary clauses in the Linear Relaxation.
   * </pre>
   *
   * <code>optional bool use_learned_binary_clauses_in_lp = 23 [default = true];</code>
   * @return The useLearnedBinaryClausesInLp.
   */
  @java.lang.Override
  public boolean getUseLearnedBinaryClausesInLp() {
    return useLearnedBinaryClausesInLp_;
  }

  public static final int NUMBER_OF_SOLVERS_FIELD_NUMBER = 24;
  private int numberOfSolvers_ = 1;
  /**
   * <pre>
   * The number of solvers used to run Bop. Note that one thread will be created
   * per solver. The type of communication between solvers is specified by the
   * synchronization_type parameter.
   * </pre>
   *
   * <code>optional int32 number_of_solvers = 24 [default = 1];</code>
   * @return Whether the numberOfSolvers field is set.
   */
  @java.lang.Override
  public boolean hasNumberOfSolvers() {
    return ((bitField0_ & 0x08000000) != 0);
  }
  /**
   * <pre>
   * The number of solvers used to run Bop. Note that one thread will be created
   * per solver. The type of communication between solvers is specified by the
   * synchronization_type parameter.
   * </pre>
   *
   * <code>optional int32 number_of_solvers = 24 [default = 1];</code>
   * @return The numberOfSolvers.
   */
  @java.lang.Override
  public int getNumberOfSolvers() {
    return numberOfSolvers_;
  }

  public static final int SYNCHRONIZATION_TYPE_FIELD_NUMBER = 25;
  private int synchronizationType_ = 0;
  /**
   * <code>optional .operations_research.bop.BopParameters.ThreadSynchronizationType synchronization_type = 25 [default = NO_SYNCHRONIZATION];</code>
   * @return Whether the synchronizationType field is set.
   */
  @java.lang.Override public boolean hasSynchronizationType() {
    return ((bitField0_ & 0x10000000) != 0);
  }
  /**
   * <code>optional .operations_research.bop.BopParameters.ThreadSynchronizationType synchronization_type = 25 [default = NO_SYNCHRONIZATION];</code>
   * @return The synchronizationType.
   */
  @java.lang.Override public com.google.ortools.bop.BopParameters.ThreadSynchronizationType getSynchronizationType() {
    com.google.ortools.bop.BopParameters.ThreadSynchronizationType result = com.google.ortools.bop.BopParameters.ThreadSynchronizationType.forNumber(synchronizationType_);
    return result == null ? com.google.ortools.bop.BopParameters.ThreadSynchronizationType.NO_SYNCHRONIZATION : result;
  }

  public static final int SOLVER_OPTIMIZER_SETS_FIELD_NUMBER = 26;
  @SuppressWarnings("serial")
  private java.util.List<com.google.ortools.bop.BopSolverOptimizerSet> solverOptimizerSets_;
  /**
   * <pre>
   * List of set of optimizers to be run by the solvers.
   * Note that the i_th solver will run the
   * min(i, solver_optimizer_sets_size())_th optimizer set.
   * The default is defined by default_solver_optimizer_sets (only one set).
   * </pre>
   *
   * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.ortools.bop.BopSolverOptimizerSet> getSolverOptimizerSetsList() {
    return solverOptimizerSets_;
  }
  /**
   * <pre>
   * List of set of optimizers to be run by the solvers.
   * Note that the i_th solver will run the
   * min(i, solver_optimizer_sets_size())_th optimizer set.
   * The default is defined by default_solver_optimizer_sets (only one set).
   * </pre>
   *
   * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.ortools.bop.BopSolverOptimizerSetOrBuilder> 
      getSolverOptimizerSetsOrBuilderList() {
    return solverOptimizerSets_;
  }
  /**
   * <pre>
   * List of set of optimizers to be run by the solvers.
   * Note that the i_th solver will run the
   * min(i, solver_optimizer_sets_size())_th optimizer set.
   * The default is defined by default_solver_optimizer_sets (only one set).
   * </pre>
   *
   * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
   */
  @java.lang.Override
  public int getSolverOptimizerSetsCount() {
    return solverOptimizerSets_.size();
  }
  /**
   * <pre>
   * List of set of optimizers to be run by the solvers.
   * Note that the i_th solver will run the
   * min(i, solver_optimizer_sets_size())_th optimizer set.
   * The default is defined by default_solver_optimizer_sets (only one set).
   * </pre>
   *
   * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
   */
  @java.lang.Override
  public com.google.ortools.bop.BopSolverOptimizerSet getSolverOptimizerSets(int index) {
    return solverOptimizerSets_.get(index);
  }
  /**
   * <pre>
   * List of set of optimizers to be run by the solvers.
   * Note that the i_th solver will run the
   * min(i, solver_optimizer_sets_size())_th optimizer set.
   * The default is defined by default_solver_optimizer_sets (only one set).
   * </pre>
   *
   * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
   */
  @java.lang.Override
  public com.google.ortools.bop.BopSolverOptimizerSetOrBuilder getSolverOptimizerSetsOrBuilder(
      int index) {
    return solverOptimizerSets_.get(index);
  }

  public static final int DEFAULT_SOLVER_OPTIMIZER_SETS_FIELD_NUMBER = 33;
  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultSolverOptimizerSets_ = "methods:{type:LOCAL_SEARCH }                       methods:{type:RANDOM_FIRST_SOLUTION }              methods:{type:LINEAR_RELAXATION }                  methods:{type:LP_FIRST_SOLUTION }                  methods:{type:OBJECTIVE_FIRST_SOLUTION }           methods:{type:USER_GUIDED_FIRST_SOLUTION }         methods:{type:RANDOM_CONSTRAINT_LNS_GUIDED_BY_LP } methods:{type:RANDOM_VARIABLE_LNS_GUIDED_BY_LP }   methods:{type:RELATION_GRAPH_LNS }                 methods:{type:RELATION_GRAPH_LNS_GUIDED_BY_LP }    methods:{type:RANDOM_CONSTRAINT_LNS }              methods:{type:RANDOM_VARIABLE_LNS }                methods:{type:SAT_CORE_BASED }                     methods:{type:COMPLETE_LNS }                       ";
  /**
   * <code>optional string default_solver_optimizer_sets = 33 [default = "methods:{type:LOCAL_SEARCH }                       methods:{type:RANDOM_FIRST_SOLUTION }              methods:{type:LINEAR_RELAXATION }                  methods:{type:LP_FIRST_SOLUTION }                  methods:{type:OBJECTIVE_FIRST_SOLUTION }           methods:{type:USER_GUIDED_FIRST_SOLUTION }         methods:{type:RANDOM_CONSTRAINT_LNS_GUIDED_BY_LP } methods:{type:RANDOM_VARIABLE_LNS_GUIDED_BY_LP }   methods:{type:RELATION_GRAPH_LNS }                 methods:{type:RELATION_GRAPH_LNS_GUIDED_BY_LP }    methods:{type:RANDOM_CONSTRAINT_LNS }              methods:{type:RANDOM_VARIABLE_LNS }                methods:{type:SAT_CORE_BASED }                     methods:{type:COMPLETE_LNS }                       "];</code>
   * @return Whether the defaultSolverOptimizerSets field is set.
   */
  @java.lang.Override
  public boolean hasDefaultSolverOptimizerSets() {
    return ((bitField0_ & 0x20000000) != 0);
  }
  /**
   * <code>optional string default_solver_optimizer_sets = 33 [default = "methods:{type:LOCAL_SEARCH }                       methods:{type:RANDOM_FIRST_SOLUTION }              methods:{type:LINEAR_RELAXATION }                  methods:{type:LP_FIRST_SOLUTION }                  methods:{type:OBJECTIVE_FIRST_SOLUTION }           methods:{type:USER_GUIDED_FIRST_SOLUTION }         methods:{type:RANDOM_CONSTRAINT_LNS_GUIDED_BY_LP } methods:{type:RANDOM_VARIABLE_LNS_GUIDED_BY_LP }   methods:{type:RELATION_GRAPH_LNS }                 methods:{type:RELATION_GRAPH_LNS_GUIDED_BY_LP }    methods:{type:RANDOM_CONSTRAINT_LNS }              methods:{type:RANDOM_VARIABLE_LNS }                methods:{type:SAT_CORE_BASED }                     methods:{type:COMPLETE_LNS }                       "];</code>
   * @return The defaultSolverOptimizerSets.
   */
  @java.lang.Override
  public java.lang.String getDefaultSolverOptimizerSets() {
    java.lang.Object ref = defaultSolverOptimizerSets_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (bs.isValidUtf8()) {
        defaultSolverOptimizerSets_ = s;
      }
      return s;
    }
  }
  /**
   * <code>optional string default_solver_optimizer_sets = 33 [default = "methods:{type:LOCAL_SEARCH }                       methods:{type:RANDOM_FIRST_SOLUTION }              methods:{type:LINEAR_RELAXATION }                  methods:{type:LP_FIRST_SOLUTION }                  methods:{type:OBJECTIVE_FIRST_SOLUTION }           methods:{type:USER_GUIDED_FIRST_SOLUTION }         methods:{type:RANDOM_CONSTRAINT_LNS_GUIDED_BY_LP } methods:{type:RANDOM_VARIABLE_LNS_GUIDED_BY_LP }   methods:{type:RELATION_GRAPH_LNS }                 methods:{type:RELATION_GRAPH_LNS_GUIDED_BY_LP }    methods:{type:RANDOM_CONSTRAINT_LNS }              methods:{type:RANDOM_VARIABLE_LNS }                methods:{type:SAT_CORE_BASED }                     methods:{type:COMPLETE_LNS }                       "];</code>
   * @return The bytes for defaultSolverOptimizerSets.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getDefaultSolverOptimizerSetsBytes() {
    java.lang.Object ref = defaultSolverOptimizerSets_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      defaultSolverOptimizerSets_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USE_LP_STRONG_BRANCHING_FIELD_NUMBER = 29;
  private boolean useLpStrongBranching_ = false;
  /**
   * <pre>
   * Use strong branching in the linear relaxation optimizer.
   * The strong branching is a what-if analysis on each variable v, i.e.
   * compute the best bound when v is assigned to true, compute the best bound
   * when v is assigned to false, and then use those best bounds to improve the
   * overall best bound.
   * This is useful to improve the best_bound, but also to fix some variables
   * during search.
   * Note that using probing might be time consuming as it runs the LP solver
   * 2 * num_variables times.
   * </pre>
   *
   * <code>optional bool use_lp_strong_branching = 29 [default = false];</code>
   * @return Whether the useLpStrongBranching field is set.
   */
  @java.lang.Override
  public boolean hasUseLpStrongBranching() {
    return ((bitField0_ & 0x40000000) != 0);
  }
  /**
   * <pre>
   * Use strong branching in the linear relaxation optimizer.
   * The strong branching is a what-if analysis on each variable v, i.e.
   * compute the best bound when v is assigned to true, compute the best bound
   * when v is assigned to false, and then use those best bounds to improve the
   * overall best bound.
   * This is useful to improve the best_bound, but also to fix some variables
   * during search.
   * Note that using probing might be time consuming as it runs the LP solver
   * 2 * num_variables times.
   * </pre>
   *
   * <code>optional bool use_lp_strong_branching = 29 [default = false];</code>
   * @return The useLpStrongBranching.
   */
  @java.lang.Override
  public boolean getUseLpStrongBranching() {
    return useLpStrongBranching_;
  }

  public static final int DECOMPOSER_NUM_VARIABLES_THRESHOLD_FIELD_NUMBER = 30;
  private int decomposerNumVariablesThreshold_ = 50;
  /**
   * <pre>
   * Only try to decompose the problem when the number of variables is greater
   * than the threshold.
   * </pre>
   *
   * <code>optional int32 decomposer_num_variables_threshold = 30 [default = 50];</code>
   * @return Whether the decomposerNumVariablesThreshold field is set.
   */
  @java.lang.Override
  public boolean hasDecomposerNumVariablesThreshold() {
    return ((bitField0_ & 0x80000000) != 0);
  }
  /**
   * <pre>
   * Only try to decompose the problem when the number of variables is greater
   * than the threshold.
   * </pre>
   *
   * <code>optional int32 decomposer_num_variables_threshold = 30 [default = 50];</code>
   * @return The decomposerNumVariablesThreshold.
   */
  @java.lang.Override
  public int getDecomposerNumVariablesThreshold() {
    return decomposerNumVariablesThreshold_;
  }

  public static final int NUM_BOP_SOLVERS_USED_BY_DECOMPOSITION_FIELD_NUMBER = 31;
  private int numBopSolversUsedByDecomposition_ = 1;
  /**
   * <pre>
   * The number of BopSolver created (thread pool workers) used by the integral
   * solver to solve a decomposed problem.
   * TODO(user): Merge this with the number_of_solvers parameter.
   * </pre>
   *
   * <code>optional int32 num_bop_solvers_used_by_decomposition = 31 [default = 1];</code>
   * @return Whether the numBopSolversUsedByDecomposition field is set.
   */
  @java.lang.Override
  public boolean hasNumBopSolversUsedByDecomposition() {
    return ((bitField1_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * The number of BopSolver created (thread pool workers) used by the integral
   * solver to solve a decomposed problem.
   * TODO(user): Merge this with the number_of_solvers parameter.
   * </pre>
   *
   * <code>optional int32 num_bop_solvers_used_by_decomposition = 31 [default = 1];</code>
   * @return The numBopSolversUsedByDecomposition.
   */
  @java.lang.Override
  public int getNumBopSolversUsedByDecomposition() {
    return numBopSolversUsedByDecomposition_;
  }

  public static final int DECOMPOSED_PROBLEM_MIN_TIME_IN_SECONDS_FIELD_NUMBER = 36;
  private double decomposedProblemMinTimeInSeconds_ = 0D;
  /**
   * <pre>
   * HACK. To avoid spending too little time on small problems, spend at least
   * this time solving each of the decomposed sub-problem. This only make sense
   * if num_bop_solvers_used_by_decomposition is greater than 1 so that the
   * overhead can be "absorbed" by the other threads.
   * </pre>
   *
   * <code>optional double decomposed_problem_min_time_in_seconds = 36 [default = 0];</code>
   * @return Whether the decomposedProblemMinTimeInSeconds field is set.
   */
  @java.lang.Override
  public boolean hasDecomposedProblemMinTimeInSeconds() {
    return ((bitField1_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * HACK. To avoid spending too little time on small problems, spend at least
   * this time solving each of the decomposed sub-problem. This only make sense
   * if num_bop_solvers_used_by_decomposition is greater than 1 so that the
   * overhead can be "absorbed" by the other threads.
   * </pre>
   *
   * <code>optional double decomposed_problem_min_time_in_seconds = 36 [default = 0];</code>
   * @return The decomposedProblemMinTimeInSeconds.
   */
  @java.lang.Override
  public double getDecomposedProblemMinTimeInSeconds() {
    return decomposedProblemMinTimeInSeconds_;
  }

  public static final int GUIDED_SAT_CONFLICTS_CHUNK_FIELD_NUMBER = 34;
  private int guidedSatConflictsChunk_ = 1000;
  /**
   * <pre>
   * The first solutions based on guided SAT will work in chunk of that many
   * conflicts at the time. This allows to simulate parallelism between the
   * different guiding strategy on a single core.
   * </pre>
   *
   * <code>optional int32 guided_sat_conflicts_chunk = 34 [default = 1000];</code>
   * @return Whether the guidedSatConflictsChunk field is set.
   */
  @java.lang.Override
  public boolean hasGuidedSatConflictsChunk() {
    return ((bitField1_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * The first solutions based on guided SAT will work in chunk of that many
   * conflicts at the time. This allows to simulate parallelism between the
   * different guiding strategy on a single core.
   * </pre>
   *
   * <code>optional int32 guided_sat_conflicts_chunk = 34 [default = 1000];</code>
   * @return The guidedSatConflictsChunk.
   */
  @java.lang.Override
  public int getGuidedSatConflictsChunk() {
    return guidedSatConflictsChunk_;
  }

  public static final int MAX_LP_SOLVE_FOR_FEASIBILITY_PROBLEMS_FIELD_NUMBER = 41;
  private int maxLpSolveForFeasibilityProblems_ = 0;
  /**
   * <pre>
   * The maximum number of time the LP solver will run to feasibility for pure
   * feasibility problems (with a constant-valued objective function). Set this
   * to a small value, e.g., 1, if fractional solutions offer useful guidance to
   * other solvers in the portfolio. A negative value means no limit.
   * </pre>
   *
   * <code>optional int32 max_lp_solve_for_feasibility_problems = 41 [default = 0];</code>
   * @return Whether the maxLpSolveForFeasibilityProblems field is set.
   */
  @java.lang.Override
  public boolean hasMaxLpSolveForFeasibilityProblems() {
    return ((bitField1_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * The maximum number of time the LP solver will run to feasibility for pure
   * feasibility problems (with a constant-valued objective function). Set this
   * to a small value, e.g., 1, if fractional solutions offer useful guidance to
   * other solvers in the portfolio. A negative value means no limit.
   * </pre>
   *
   * <code>optional int32 max_lp_solve_for_feasibility_problems = 41 [default = 0];</code>
   * @return The maxLpSolveForFeasibilityProblems.
   */
  @java.lang.Override
  public int getMaxLpSolveForFeasibilityProblems() {
    return maxLpSolveForFeasibilityProblems_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeDouble(1, maxTimeInSeconds_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeInt32(2, maxNumDecisionsInLs_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeBool(3, computeEstimatedImpact_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeBool(4, pruneSearchTree_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeBool(5, sortConstraintsByNumTerms_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeBool(6, useRandomLns_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeInt32(7, randomSeed_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeInt32(8, numRelaxedVars_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeInt32(9, maxNumberOfConflictsInRandomLns_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeInt32(10, numRandomLnsTries_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      output.writeInt64(11, maxNumberOfBacktracksInLs_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      output.writeBool(12, useLpLns_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeBool(14, logSearchProgress_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      output.writeBool(15, useSatToChooseLnsNeighbourhood_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      output.writeInt32(16, maxNumberOfConflictsForQuickCheck_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      output.writeBool(17, useSymmetry_);
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      output.writeInt32(20, maxNumberOfConflictsInRandomSolutionGeneration_);
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      output.writeInt64(21, maxNumberOfExploredAssignmentsPerTryInLs_);
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      output.writeBool(22, useTranspositionTableInLs_);
    }
    if (((bitField0_ & 0x04000000) != 0)) {
      output.writeBool(23, useLearnedBinaryClausesInLp_);
    }
    if (((bitField0_ & 0x08000000) != 0)) {
      output.writeInt32(24, numberOfSolvers_);
    }
    if (((bitField0_ & 0x10000000) != 0)) {
      output.writeEnum(25, synchronizationType_);
    }
    for (int i = 0; i < solverOptimizerSets_.size(); i++) {
      output.writeMessage(26, solverOptimizerSets_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeDouble(27, maxDeterministicTime_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeDouble(28, relativeGapLimit_);
    }
    if (((bitField0_ & 0x40000000) != 0)) {
      output.writeBool(29, useLpStrongBranching_);
    }
    if (((bitField0_ & 0x80000000) != 0)) {
      output.writeInt32(30, decomposerNumVariablesThreshold_);
    }
    if (((bitField1_ & 0x00000001) != 0)) {
      output.writeInt32(31, numBopSolversUsedByDecomposition_);
    }
    if (((bitField0_ & 0x20000000) != 0)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 33, defaultSolverOptimizerSets_);
    }
    if (((bitField1_ & 0x00000004) != 0)) {
      output.writeInt32(34, guidedSatConflictsChunk_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt32(35, maxNumberOfConsecutiveFailingOptimizerCalls_);
    }
    if (((bitField1_ & 0x00000002) != 0)) {
      output.writeDouble(36, decomposedProblemMinTimeInSeconds_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeDouble(37, lpMaxDeterministicTime_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeInt32(38, maxNumBrokenConstraintsInLs_);
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      output.writeBool(39, usePotentialOneFlipRepairsInLs_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      output.writeBool(40, exploitSymmetryInSatFirstSolution_);
    }
    if (((bitField1_ & 0x00000008) != 0)) {
      output.writeInt32(41, maxLpSolveForFeasibilityProblems_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(1, maxTimeInSeconds_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(2, maxNumDecisionsInLs_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(3, computeEstimatedImpact_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(4, pruneSearchTree_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(5, sortConstraintsByNumTerms_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(6, useRandomLns_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(7, randomSeed_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(8, numRelaxedVars_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(9, maxNumberOfConflictsInRandomLns_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(10, numRandomLnsTries_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(11, maxNumberOfBacktracksInLs_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(12, useLpLns_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(14, logSearchProgress_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(15, useSatToChooseLnsNeighbourhood_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(16, maxNumberOfConflictsForQuickCheck_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(17, useSymmetry_);
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(20, maxNumberOfConflictsInRandomSolutionGeneration_);
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(21, maxNumberOfExploredAssignmentsPerTryInLs_);
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(22, useTranspositionTableInLs_);
    }
    if (((bitField0_ & 0x04000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(23, useLearnedBinaryClausesInLp_);
    }
    if (((bitField0_ & 0x08000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(24, numberOfSolvers_);
    }
    if (((bitField0_ & 0x10000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(25, synchronizationType_);
    }
    for (int i = 0; i < solverOptimizerSets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(26, solverOptimizerSets_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(27, maxDeterministicTime_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(28, relativeGapLimit_);
    }
    if (((bitField0_ & 0x40000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(29, useLpStrongBranching_);
    }
    if (((bitField0_ & 0x80000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(30, decomposerNumVariablesThreshold_);
    }
    if (((bitField1_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(31, numBopSolversUsedByDecomposition_);
    }
    if (((bitField0_ & 0x20000000) != 0)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(33, defaultSolverOptimizerSets_);
    }
    if (((bitField1_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(34, guidedSatConflictsChunk_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(35, maxNumberOfConsecutiveFailingOptimizerCalls_);
    }
    if (((bitField1_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(36, decomposedProblemMinTimeInSeconds_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(37, lpMaxDeterministicTime_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(38, maxNumBrokenConstraintsInLs_);
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(39, usePotentialOneFlipRepairsInLs_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(40, exploitSymmetryInSatFirstSolution_);
    }
    if (((bitField1_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(41, maxLpSolveForFeasibilityProblems_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ortools.bop.BopParameters)) {
      return super.equals(obj);
    }
    com.google.ortools.bop.BopParameters other = (com.google.ortools.bop.BopParameters) obj;

    if (hasMaxTimeInSeconds() != other.hasMaxTimeInSeconds()) return false;
    if (hasMaxTimeInSeconds()) {
      if (java.lang.Double.doubleToLongBits(getMaxTimeInSeconds())
          != java.lang.Double.doubleToLongBits(
              other.getMaxTimeInSeconds())) return false;
    }
    if (hasMaxDeterministicTime() != other.hasMaxDeterministicTime()) return false;
    if (hasMaxDeterministicTime()) {
      if (java.lang.Double.doubleToLongBits(getMaxDeterministicTime())
          != java.lang.Double.doubleToLongBits(
              other.getMaxDeterministicTime())) return false;
    }
    if (hasLpMaxDeterministicTime() != other.hasLpMaxDeterministicTime()) return false;
    if (hasLpMaxDeterministicTime()) {
      if (java.lang.Double.doubleToLongBits(getLpMaxDeterministicTime())
          != java.lang.Double.doubleToLongBits(
              other.getLpMaxDeterministicTime())) return false;
    }
    if (hasMaxNumberOfConsecutiveFailingOptimizerCalls() != other.hasMaxNumberOfConsecutiveFailingOptimizerCalls()) return false;
    if (hasMaxNumberOfConsecutiveFailingOptimizerCalls()) {
      if (getMaxNumberOfConsecutiveFailingOptimizerCalls()
          != other.getMaxNumberOfConsecutiveFailingOptimizerCalls()) return false;
    }
    if (hasRelativeGapLimit() != other.hasRelativeGapLimit()) return false;
    if (hasRelativeGapLimit()) {
      if (java.lang.Double.doubleToLongBits(getRelativeGapLimit())
          != java.lang.Double.doubleToLongBits(
              other.getRelativeGapLimit())) return false;
    }
    if (hasMaxNumDecisionsInLs() != other.hasMaxNumDecisionsInLs()) return false;
    if (hasMaxNumDecisionsInLs()) {
      if (getMaxNumDecisionsInLs()
          != other.getMaxNumDecisionsInLs()) return false;
    }
    if (hasMaxNumBrokenConstraintsInLs() != other.hasMaxNumBrokenConstraintsInLs()) return false;
    if (hasMaxNumBrokenConstraintsInLs()) {
      if (getMaxNumBrokenConstraintsInLs()
          != other.getMaxNumBrokenConstraintsInLs()) return false;
    }
    if (hasLogSearchProgress() != other.hasLogSearchProgress()) return false;
    if (hasLogSearchProgress()) {
      if (getLogSearchProgress()
          != other.getLogSearchProgress()) return false;
    }
    if (hasComputeEstimatedImpact() != other.hasComputeEstimatedImpact()) return false;
    if (hasComputeEstimatedImpact()) {
      if (getComputeEstimatedImpact()
          != other.getComputeEstimatedImpact()) return false;
    }
    if (hasPruneSearchTree() != other.hasPruneSearchTree()) return false;
    if (hasPruneSearchTree()) {
      if (getPruneSearchTree()
          != other.getPruneSearchTree()) return false;
    }
    if (hasSortConstraintsByNumTerms() != other.hasSortConstraintsByNumTerms()) return false;
    if (hasSortConstraintsByNumTerms()) {
      if (getSortConstraintsByNumTerms()
          != other.getSortConstraintsByNumTerms()) return false;
    }
    if (hasUseRandomLns() != other.hasUseRandomLns()) return false;
    if (hasUseRandomLns()) {
      if (getUseRandomLns()
          != other.getUseRandomLns()) return false;
    }
    if (hasRandomSeed() != other.hasRandomSeed()) return false;
    if (hasRandomSeed()) {
      if (getRandomSeed()
          != other.getRandomSeed()) return false;
    }
    if (hasNumRelaxedVars() != other.hasNumRelaxedVars()) return false;
    if (hasNumRelaxedVars()) {
      if (getNumRelaxedVars()
          != other.getNumRelaxedVars()) return false;
    }
    if (hasMaxNumberOfConflictsInRandomLns() != other.hasMaxNumberOfConflictsInRandomLns()) return false;
    if (hasMaxNumberOfConflictsInRandomLns()) {
      if (getMaxNumberOfConflictsInRandomLns()
          != other.getMaxNumberOfConflictsInRandomLns()) return false;
    }
    if (hasNumRandomLnsTries() != other.hasNumRandomLnsTries()) return false;
    if (hasNumRandomLnsTries()) {
      if (getNumRandomLnsTries()
          != other.getNumRandomLnsTries()) return false;
    }
    if (hasMaxNumberOfBacktracksInLs() != other.hasMaxNumberOfBacktracksInLs()) return false;
    if (hasMaxNumberOfBacktracksInLs()) {
      if (getMaxNumberOfBacktracksInLs()
          != other.getMaxNumberOfBacktracksInLs()) return false;
    }
    if (hasUseLpLns() != other.hasUseLpLns()) return false;
    if (hasUseLpLns()) {
      if (getUseLpLns()
          != other.getUseLpLns()) return false;
    }
    if (hasUseSatToChooseLnsNeighbourhood() != other.hasUseSatToChooseLnsNeighbourhood()) return false;
    if (hasUseSatToChooseLnsNeighbourhood()) {
      if (getUseSatToChooseLnsNeighbourhood()
          != other.getUseSatToChooseLnsNeighbourhood()) return false;
    }
    if (hasMaxNumberOfConflictsForQuickCheck() != other.hasMaxNumberOfConflictsForQuickCheck()) return false;
    if (hasMaxNumberOfConflictsForQuickCheck()) {
      if (getMaxNumberOfConflictsForQuickCheck()
          != other.getMaxNumberOfConflictsForQuickCheck()) return false;
    }
    if (hasUseSymmetry() != other.hasUseSymmetry()) return false;
    if (hasUseSymmetry()) {
      if (getUseSymmetry()
          != other.getUseSymmetry()) return false;
    }
    if (hasExploitSymmetryInSatFirstSolution() != other.hasExploitSymmetryInSatFirstSolution()) return false;
    if (hasExploitSymmetryInSatFirstSolution()) {
      if (getExploitSymmetryInSatFirstSolution()
          != other.getExploitSymmetryInSatFirstSolution()) return false;
    }
    if (hasMaxNumberOfConflictsInRandomSolutionGeneration() != other.hasMaxNumberOfConflictsInRandomSolutionGeneration()) return false;
    if (hasMaxNumberOfConflictsInRandomSolutionGeneration()) {
      if (getMaxNumberOfConflictsInRandomSolutionGeneration()
          != other.getMaxNumberOfConflictsInRandomSolutionGeneration()) return false;
    }
    if (hasMaxNumberOfExploredAssignmentsPerTryInLs() != other.hasMaxNumberOfExploredAssignmentsPerTryInLs()) return false;
    if (hasMaxNumberOfExploredAssignmentsPerTryInLs()) {
      if (getMaxNumberOfExploredAssignmentsPerTryInLs()
          != other.getMaxNumberOfExploredAssignmentsPerTryInLs()) return false;
    }
    if (hasUseTranspositionTableInLs() != other.hasUseTranspositionTableInLs()) return false;
    if (hasUseTranspositionTableInLs()) {
      if (getUseTranspositionTableInLs()
          != other.getUseTranspositionTableInLs()) return false;
    }
    if (hasUsePotentialOneFlipRepairsInLs() != other.hasUsePotentialOneFlipRepairsInLs()) return false;
    if (hasUsePotentialOneFlipRepairsInLs()) {
      if (getUsePotentialOneFlipRepairsInLs()
          != other.getUsePotentialOneFlipRepairsInLs()) return false;
    }
    if (hasUseLearnedBinaryClausesInLp() != other.hasUseLearnedBinaryClausesInLp()) return false;
    if (hasUseLearnedBinaryClausesInLp()) {
      if (getUseLearnedBinaryClausesInLp()
          != other.getUseLearnedBinaryClausesInLp()) return false;
    }
    if (hasNumberOfSolvers() != other.hasNumberOfSolvers()) return false;
    if (hasNumberOfSolvers()) {
      if (getNumberOfSolvers()
          != other.getNumberOfSolvers()) return false;
    }
    if (hasSynchronizationType() != other.hasSynchronizationType()) return false;
    if (hasSynchronizationType()) {
      if (synchronizationType_ != other.synchronizationType_) return false;
    }
    if (!getSolverOptimizerSetsList()
        .equals(other.getSolverOptimizerSetsList())) return false;
    if (hasDefaultSolverOptimizerSets() != other.hasDefaultSolverOptimizerSets()) return false;
    if (hasDefaultSolverOptimizerSets()) {
      if (!getDefaultSolverOptimizerSets()
          .equals(other.getDefaultSolverOptimizerSets())) return false;
    }
    if (hasUseLpStrongBranching() != other.hasUseLpStrongBranching()) return false;
    if (hasUseLpStrongBranching()) {
      if (getUseLpStrongBranching()
          != other.getUseLpStrongBranching()) return false;
    }
    if (hasDecomposerNumVariablesThreshold() != other.hasDecomposerNumVariablesThreshold()) return false;
    if (hasDecomposerNumVariablesThreshold()) {
      if (getDecomposerNumVariablesThreshold()
          != other.getDecomposerNumVariablesThreshold()) return false;
    }
    if (hasNumBopSolversUsedByDecomposition() != other.hasNumBopSolversUsedByDecomposition()) return false;
    if (hasNumBopSolversUsedByDecomposition()) {
      if (getNumBopSolversUsedByDecomposition()
          != other.getNumBopSolversUsedByDecomposition()) return false;
    }
    if (hasDecomposedProblemMinTimeInSeconds() != other.hasDecomposedProblemMinTimeInSeconds()) return false;
    if (hasDecomposedProblemMinTimeInSeconds()) {
      if (java.lang.Double.doubleToLongBits(getDecomposedProblemMinTimeInSeconds())
          != java.lang.Double.doubleToLongBits(
              other.getDecomposedProblemMinTimeInSeconds())) return false;
    }
    if (hasGuidedSatConflictsChunk() != other.hasGuidedSatConflictsChunk()) return false;
    if (hasGuidedSatConflictsChunk()) {
      if (getGuidedSatConflictsChunk()
          != other.getGuidedSatConflictsChunk()) return false;
    }
    if (hasMaxLpSolveForFeasibilityProblems() != other.hasMaxLpSolveForFeasibilityProblems()) return false;
    if (hasMaxLpSolveForFeasibilityProblems()) {
      if (getMaxLpSolveForFeasibilityProblems()
          != other.getMaxLpSolveForFeasibilityProblems()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasMaxTimeInSeconds()) {
      hash = (37 * hash) + MAX_TIME_IN_SECONDS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMaxTimeInSeconds()));
    }
    if (hasMaxDeterministicTime()) {
      hash = (37 * hash) + MAX_DETERMINISTIC_TIME_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMaxDeterministicTime()));
    }
    if (hasLpMaxDeterministicTime()) {
      hash = (37 * hash) + LP_MAX_DETERMINISTIC_TIME_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getLpMaxDeterministicTime()));
    }
    if (hasMaxNumberOfConsecutiveFailingOptimizerCalls()) {
      hash = (37 * hash) + MAX_NUMBER_OF_CONSECUTIVE_FAILING_OPTIMIZER_CALLS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxNumberOfConsecutiveFailingOptimizerCalls();
    }
    if (hasRelativeGapLimit()) {
      hash = (37 * hash) + RELATIVE_GAP_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getRelativeGapLimit()));
    }
    if (hasMaxNumDecisionsInLs()) {
      hash = (37 * hash) + MAX_NUM_DECISIONS_IN_LS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxNumDecisionsInLs();
    }
    if (hasMaxNumBrokenConstraintsInLs()) {
      hash = (37 * hash) + MAX_NUM_BROKEN_CONSTRAINTS_IN_LS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxNumBrokenConstraintsInLs();
    }
    if (hasLogSearchProgress()) {
      hash = (37 * hash) + LOG_SEARCH_PROGRESS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getLogSearchProgress());
    }
    if (hasComputeEstimatedImpact()) {
      hash = (37 * hash) + COMPUTE_ESTIMATED_IMPACT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getComputeEstimatedImpact());
    }
    if (hasPruneSearchTree()) {
      hash = (37 * hash) + PRUNE_SEARCH_TREE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getPruneSearchTree());
    }
    if (hasSortConstraintsByNumTerms()) {
      hash = (37 * hash) + SORT_CONSTRAINTS_BY_NUM_TERMS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getSortConstraintsByNumTerms());
    }
    if (hasUseRandomLns()) {
      hash = (37 * hash) + USE_RANDOM_LNS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseRandomLns());
    }
    if (hasRandomSeed()) {
      hash = (37 * hash) + RANDOM_SEED_FIELD_NUMBER;
      hash = (53 * hash) + getRandomSeed();
    }
    if (hasNumRelaxedVars()) {
      hash = (37 * hash) + NUM_RELAXED_VARS_FIELD_NUMBER;
      hash = (53 * hash) + getNumRelaxedVars();
    }
    if (hasMaxNumberOfConflictsInRandomLns()) {
      hash = (37 * hash) + MAX_NUMBER_OF_CONFLICTS_IN_RANDOM_LNS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxNumberOfConflictsInRandomLns();
    }
    if (hasNumRandomLnsTries()) {
      hash = (37 * hash) + NUM_RANDOM_LNS_TRIES_FIELD_NUMBER;
      hash = (53 * hash) + getNumRandomLnsTries();
    }
    if (hasMaxNumberOfBacktracksInLs()) {
      hash = (37 * hash) + MAX_NUMBER_OF_BACKTRACKS_IN_LS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getMaxNumberOfBacktracksInLs());
    }
    if (hasUseLpLns()) {
      hash = (37 * hash) + USE_LP_LNS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseLpLns());
    }
    if (hasUseSatToChooseLnsNeighbourhood()) {
      hash = (37 * hash) + USE_SAT_TO_CHOOSE_LNS_NEIGHBOURHOOD_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseSatToChooseLnsNeighbourhood());
    }
    if (hasMaxNumberOfConflictsForQuickCheck()) {
      hash = (37 * hash) + MAX_NUMBER_OF_CONFLICTS_FOR_QUICK_CHECK_FIELD_NUMBER;
      hash = (53 * hash) + getMaxNumberOfConflictsForQuickCheck();
    }
    if (hasUseSymmetry()) {
      hash = (37 * hash) + USE_SYMMETRY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseSymmetry());
    }
    if (hasExploitSymmetryInSatFirstSolution()) {
      hash = (37 * hash) + EXPLOIT_SYMMETRY_IN_SAT_FIRST_SOLUTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getExploitSymmetryInSatFirstSolution());
    }
    if (hasMaxNumberOfConflictsInRandomSolutionGeneration()) {
      hash = (37 * hash) + MAX_NUMBER_OF_CONFLICTS_IN_RANDOM_SOLUTION_GENERATION_FIELD_NUMBER;
      hash = (53 * hash) + getMaxNumberOfConflictsInRandomSolutionGeneration();
    }
    if (hasMaxNumberOfExploredAssignmentsPerTryInLs()) {
      hash = (37 * hash) + MAX_NUMBER_OF_EXPLORED_ASSIGNMENTS_PER_TRY_IN_LS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getMaxNumberOfExploredAssignmentsPerTryInLs());
    }
    if (hasUseTranspositionTableInLs()) {
      hash = (37 * hash) + USE_TRANSPOSITION_TABLE_IN_LS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseTranspositionTableInLs());
    }
    if (hasUsePotentialOneFlipRepairsInLs()) {
      hash = (37 * hash) + USE_POTENTIAL_ONE_FLIP_REPAIRS_IN_LS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUsePotentialOneFlipRepairsInLs());
    }
    if (hasUseLearnedBinaryClausesInLp()) {
      hash = (37 * hash) + USE_LEARNED_BINARY_CLAUSES_IN_LP_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseLearnedBinaryClausesInLp());
    }
    if (hasNumberOfSolvers()) {
      hash = (37 * hash) + NUMBER_OF_SOLVERS_FIELD_NUMBER;
      hash = (53 * hash) + getNumberOfSolvers();
    }
    if (hasSynchronizationType()) {
      hash = (37 * hash) + SYNCHRONIZATION_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + synchronizationType_;
    }
    if (getSolverOptimizerSetsCount() > 0) {
      hash = (37 * hash) + SOLVER_OPTIMIZER_SETS_FIELD_NUMBER;
      hash = (53 * hash) + getSolverOptimizerSetsList().hashCode();
    }
    if (hasDefaultSolverOptimizerSets()) {
      hash = (37 * hash) + DEFAULT_SOLVER_OPTIMIZER_SETS_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultSolverOptimizerSets().hashCode();
    }
    if (hasUseLpStrongBranching()) {
      hash = (37 * hash) + USE_LP_STRONG_BRANCHING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseLpStrongBranching());
    }
    if (hasDecomposerNumVariablesThreshold()) {
      hash = (37 * hash) + DECOMPOSER_NUM_VARIABLES_THRESHOLD_FIELD_NUMBER;
      hash = (53 * hash) + getDecomposerNumVariablesThreshold();
    }
    if (hasNumBopSolversUsedByDecomposition()) {
      hash = (37 * hash) + NUM_BOP_SOLVERS_USED_BY_DECOMPOSITION_FIELD_NUMBER;
      hash = (53 * hash) + getNumBopSolversUsedByDecomposition();
    }
    if (hasDecomposedProblemMinTimeInSeconds()) {
      hash = (37 * hash) + DECOMPOSED_PROBLEM_MIN_TIME_IN_SECONDS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getDecomposedProblemMinTimeInSeconds()));
    }
    if (hasGuidedSatConflictsChunk()) {
      hash = (37 * hash) + GUIDED_SAT_CONFLICTS_CHUNK_FIELD_NUMBER;
      hash = (53 * hash) + getGuidedSatConflictsChunk();
    }
    if (hasMaxLpSolveForFeasibilityProblems()) {
      hash = (37 * hash) + MAX_LP_SOLVE_FOR_FEASIBILITY_PROBLEMS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxLpSolveForFeasibilityProblems();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ortools.bop.BopParameters parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.bop.BopParameters parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.bop.BopParameters parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.bop.BopParameters parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.bop.BopParameters parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.bop.BopParameters parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.bop.BopParameters parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.bop.BopParameters parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ortools.bop.BopParameters parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ortools.bop.BopParameters parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ortools.bop.BopParameters parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.bop.BopParameters parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ortools.bop.BopParameters prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Contains the definitions for all the bop algorithm parameters and their
   * default values.
   *
   * NEXT TAG: 42
   * </pre>
   *
   * Protobuf type {@code operations_research.bop.BopParameters}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessage.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:operations_research.bop.BopParameters)
      com.google.ortools.bop.BopParametersOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ortools.bop.BopParametersOuterClass.internal_static_operations_research_bop_BopParameters_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ortools.bop.BopParametersOuterClass.internal_static_operations_research_bop_BopParameters_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ortools.bop.BopParameters.class, com.google.ortools.bop.BopParameters.Builder.class);
    }

    // Construct using com.google.ortools.bop.BopParameters.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bitField1_ = 0;
      maxTimeInSeconds_ = Double.POSITIVE_INFINITY;
      maxDeterministicTime_ = Double.POSITIVE_INFINITY;
      lpMaxDeterministicTime_ = 1D;
      maxNumberOfConsecutiveFailingOptimizerCalls_ = 0;
      relativeGapLimit_ = 0.0001D;
      maxNumDecisionsInLs_ = 4;
      maxNumBrokenConstraintsInLs_ = 2147483647;
      logSearchProgress_ = false;
      computeEstimatedImpact_ = true;
      pruneSearchTree_ = false;
      sortConstraintsByNumTerms_ = false;
      useRandomLns_ = true;
      randomSeed_ = 8;
      numRelaxedVars_ = 10;
      maxNumberOfConflictsInRandomLns_ = 2500;
      numRandomLnsTries_ = 1;
      maxNumberOfBacktracksInLs_ = 100000000L;
      useLpLns_ = true;
      useSatToChooseLnsNeighbourhood_ = true;
      maxNumberOfConflictsForQuickCheck_ = 10;
      useSymmetry_ = false;
      exploitSymmetryInSatFirstSolution_ = false;
      maxNumberOfConflictsInRandomSolutionGeneration_ = 500;
      maxNumberOfExploredAssignmentsPerTryInLs_ = 10000L;
      useTranspositionTableInLs_ = true;
      usePotentialOneFlipRepairsInLs_ = false;
      useLearnedBinaryClausesInLp_ = true;
      numberOfSolvers_ = 1;
      synchronizationType_ = 0;
      if (solverOptimizerSetsBuilder_ == null) {
        solverOptimizerSets_ = java.util.Collections.emptyList();
      } else {
        solverOptimizerSets_ = null;
        solverOptimizerSetsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x20000000);
      defaultSolverOptimizerSets_ = "methods:{type:LOCAL_SEARCH }                       methods:{type:RANDOM_FIRST_SOLUTION }              methods:{type:LINEAR_RELAXATION }                  methods:{type:LP_FIRST_SOLUTION }                  methods:{type:OBJECTIVE_FIRST_SOLUTION }           methods:{type:USER_GUIDED_FIRST_SOLUTION }         methods:{type:RANDOM_CONSTRAINT_LNS_GUIDED_BY_LP } methods:{type:RANDOM_VARIABLE_LNS_GUIDED_BY_LP }   methods:{type:RELATION_GRAPH_LNS }                 methods:{type:RELATION_GRAPH_LNS_GUIDED_BY_LP }    methods:{type:RANDOM_CONSTRAINT_LNS }              methods:{type:RANDOM_VARIABLE_LNS }                methods:{type:SAT_CORE_BASED }                     methods:{type:COMPLETE_LNS }                       ";
      useLpStrongBranching_ = false;
      decomposerNumVariablesThreshold_ = 50;
      numBopSolversUsedByDecomposition_ = 1;
      decomposedProblemMinTimeInSeconds_ = 0D;
      guidedSatConflictsChunk_ = 1000;
      maxLpSolveForFeasibilityProblems_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ortools.bop.BopParametersOuterClass.internal_static_operations_research_bop_BopParameters_descriptor;
    }

    @java.lang.Override
    public com.google.ortools.bop.BopParameters getDefaultInstanceForType() {
      return com.google.ortools.bop.BopParameters.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ortools.bop.BopParameters build() {
      com.google.ortools.bop.BopParameters result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ortools.bop.BopParameters buildPartial() {
      com.google.ortools.bop.BopParameters result = new com.google.ortools.bop.BopParameters(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      if (bitField1_ != 0) { buildPartial1(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.ortools.bop.BopParameters result) {
      if (solverOptimizerSetsBuilder_ == null) {
        if (((bitField0_ & 0x20000000) != 0)) {
          solverOptimizerSets_ = java.util.Collections.unmodifiableList(solverOptimizerSets_);
          bitField0_ = (bitField0_ & ~0x20000000);
        }
        result.solverOptimizerSets_ = solverOptimizerSets_;
      } else {
        result.solverOptimizerSets_ = solverOptimizerSetsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.ortools.bop.BopParameters result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.maxTimeInSeconds_ = maxTimeInSeconds_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.maxDeterministicTime_ = maxDeterministicTime_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.lpMaxDeterministicTime_ = lpMaxDeterministicTime_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.maxNumberOfConsecutiveFailingOptimizerCalls_ = maxNumberOfConsecutiveFailingOptimizerCalls_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.relativeGapLimit_ = relativeGapLimit_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.maxNumDecisionsInLs_ = maxNumDecisionsInLs_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.maxNumBrokenConstraintsInLs_ = maxNumBrokenConstraintsInLs_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.logSearchProgress_ = logSearchProgress_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.computeEstimatedImpact_ = computeEstimatedImpact_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.pruneSearchTree_ = pruneSearchTree_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.sortConstraintsByNumTerms_ = sortConstraintsByNumTerms_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.useRandomLns_ = useRandomLns_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.randomSeed_ = randomSeed_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.numRelaxedVars_ = numRelaxedVars_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.maxNumberOfConflictsInRandomLns_ = maxNumberOfConflictsInRandomLns_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.numRandomLnsTries_ = numRandomLnsTries_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.maxNumberOfBacktracksInLs_ = maxNumberOfBacktracksInLs_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.useLpLns_ = useLpLns_;
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.useSatToChooseLnsNeighbourhood_ = useSatToChooseLnsNeighbourhood_;
        to_bitField0_ |= 0x00040000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.maxNumberOfConflictsForQuickCheck_ = maxNumberOfConflictsForQuickCheck_;
        to_bitField0_ |= 0x00080000;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.useSymmetry_ = useSymmetry_;
        to_bitField0_ |= 0x00100000;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.exploitSymmetryInSatFirstSolution_ = exploitSymmetryInSatFirstSolution_;
        to_bitField0_ |= 0x00200000;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.maxNumberOfConflictsInRandomSolutionGeneration_ = maxNumberOfConflictsInRandomSolutionGeneration_;
        to_bitField0_ |= 0x00400000;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.maxNumberOfExploredAssignmentsPerTryInLs_ = maxNumberOfExploredAssignmentsPerTryInLs_;
        to_bitField0_ |= 0x00800000;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.useTranspositionTableInLs_ = useTranspositionTableInLs_;
        to_bitField0_ |= 0x01000000;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.usePotentialOneFlipRepairsInLs_ = usePotentialOneFlipRepairsInLs_;
        to_bitField0_ |= 0x02000000;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.useLearnedBinaryClausesInLp_ = useLearnedBinaryClausesInLp_;
        to_bitField0_ |= 0x04000000;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.numberOfSolvers_ = numberOfSolvers_;
        to_bitField0_ |= 0x08000000;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        result.synchronizationType_ = synchronizationType_;
        to_bitField0_ |= 0x10000000;
      }
      if (((from_bitField0_ & 0x40000000) != 0)) {
        result.defaultSolverOptimizerSets_ = defaultSolverOptimizerSets_;
        to_bitField0_ |= 0x20000000;
      }
      if (((from_bitField0_ & 0x80000000) != 0)) {
        result.useLpStrongBranching_ = useLpStrongBranching_;
        to_bitField0_ |= 0x40000000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartial1(com.google.ortools.bop.BopParameters result) {
      int from_bitField1_ = bitField1_;
      int to_bitField0_ = 0;
      if (((from_bitField1_ & 0x00000001) != 0)) {
        result.decomposerNumVariablesThreshold_ = decomposerNumVariablesThreshold_;
        to_bitField0_ |= 0x80000000;
      }
      int to_bitField1_ = 0;
      if (((from_bitField1_ & 0x00000002) != 0)) {
        result.numBopSolversUsedByDecomposition_ = numBopSolversUsedByDecomposition_;
        to_bitField1_ |= 0x00000001;
      }
      if (((from_bitField1_ & 0x00000004) != 0)) {
        result.decomposedProblemMinTimeInSeconds_ = decomposedProblemMinTimeInSeconds_;
        to_bitField1_ |= 0x00000002;
      }
      if (((from_bitField1_ & 0x00000008) != 0)) {
        result.guidedSatConflictsChunk_ = guidedSatConflictsChunk_;
        to_bitField1_ |= 0x00000004;
      }
      if (((from_bitField1_ & 0x00000010) != 0)) {
        result.maxLpSolveForFeasibilityProblems_ = maxLpSolveForFeasibilityProblems_;
        to_bitField1_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
      result.bitField1_ |= to_bitField1_;
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ortools.bop.BopParameters) {
        return mergeFrom((com.google.ortools.bop.BopParameters)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ortools.bop.BopParameters other) {
      if (other == com.google.ortools.bop.BopParameters.getDefaultInstance()) return this;
      if (other.hasMaxTimeInSeconds()) {
        setMaxTimeInSeconds(other.getMaxTimeInSeconds());
      }
      if (other.hasMaxDeterministicTime()) {
        setMaxDeterministicTime(other.getMaxDeterministicTime());
      }
      if (other.hasLpMaxDeterministicTime()) {
        setLpMaxDeterministicTime(other.getLpMaxDeterministicTime());
      }
      if (other.hasMaxNumberOfConsecutiveFailingOptimizerCalls()) {
        setMaxNumberOfConsecutiveFailingOptimizerCalls(other.getMaxNumberOfConsecutiveFailingOptimizerCalls());
      }
      if (other.hasRelativeGapLimit()) {
        setRelativeGapLimit(other.getRelativeGapLimit());
      }
      if (other.hasMaxNumDecisionsInLs()) {
        setMaxNumDecisionsInLs(other.getMaxNumDecisionsInLs());
      }
      if (other.hasMaxNumBrokenConstraintsInLs()) {
        setMaxNumBrokenConstraintsInLs(other.getMaxNumBrokenConstraintsInLs());
      }
      if (other.hasLogSearchProgress()) {
        setLogSearchProgress(other.getLogSearchProgress());
      }
      if (other.hasComputeEstimatedImpact()) {
        setComputeEstimatedImpact(other.getComputeEstimatedImpact());
      }
      if (other.hasPruneSearchTree()) {
        setPruneSearchTree(other.getPruneSearchTree());
      }
      if (other.hasSortConstraintsByNumTerms()) {
        setSortConstraintsByNumTerms(other.getSortConstraintsByNumTerms());
      }
      if (other.hasUseRandomLns()) {
        setUseRandomLns(other.getUseRandomLns());
      }
      if (other.hasRandomSeed()) {
        setRandomSeed(other.getRandomSeed());
      }
      if (other.hasNumRelaxedVars()) {
        setNumRelaxedVars(other.getNumRelaxedVars());
      }
      if (other.hasMaxNumberOfConflictsInRandomLns()) {
        setMaxNumberOfConflictsInRandomLns(other.getMaxNumberOfConflictsInRandomLns());
      }
      if (other.hasNumRandomLnsTries()) {
        setNumRandomLnsTries(other.getNumRandomLnsTries());
      }
      if (other.hasMaxNumberOfBacktracksInLs()) {
        setMaxNumberOfBacktracksInLs(other.getMaxNumberOfBacktracksInLs());
      }
      if (other.hasUseLpLns()) {
        setUseLpLns(other.getUseLpLns());
      }
      if (other.hasUseSatToChooseLnsNeighbourhood()) {
        setUseSatToChooseLnsNeighbourhood(other.getUseSatToChooseLnsNeighbourhood());
      }
      if (other.hasMaxNumberOfConflictsForQuickCheck()) {
        setMaxNumberOfConflictsForQuickCheck(other.getMaxNumberOfConflictsForQuickCheck());
      }
      if (other.hasUseSymmetry()) {
        setUseSymmetry(other.getUseSymmetry());
      }
      if (other.hasExploitSymmetryInSatFirstSolution()) {
        setExploitSymmetryInSatFirstSolution(other.getExploitSymmetryInSatFirstSolution());
      }
      if (other.hasMaxNumberOfConflictsInRandomSolutionGeneration()) {
        setMaxNumberOfConflictsInRandomSolutionGeneration(other.getMaxNumberOfConflictsInRandomSolutionGeneration());
      }
      if (other.hasMaxNumberOfExploredAssignmentsPerTryInLs()) {
        setMaxNumberOfExploredAssignmentsPerTryInLs(other.getMaxNumberOfExploredAssignmentsPerTryInLs());
      }
      if (other.hasUseTranspositionTableInLs()) {
        setUseTranspositionTableInLs(other.getUseTranspositionTableInLs());
      }
      if (other.hasUsePotentialOneFlipRepairsInLs()) {
        setUsePotentialOneFlipRepairsInLs(other.getUsePotentialOneFlipRepairsInLs());
      }
      if (other.hasUseLearnedBinaryClausesInLp()) {
        setUseLearnedBinaryClausesInLp(other.getUseLearnedBinaryClausesInLp());
      }
      if (other.hasNumberOfSolvers()) {
        setNumberOfSolvers(other.getNumberOfSolvers());
      }
      if (other.hasSynchronizationType()) {
        setSynchronizationType(other.getSynchronizationType());
      }
      if (solverOptimizerSetsBuilder_ == null) {
        if (!other.solverOptimizerSets_.isEmpty()) {
          if (solverOptimizerSets_.isEmpty()) {
            solverOptimizerSets_ = other.solverOptimizerSets_;
            bitField0_ = (bitField0_ & ~0x20000000);
          } else {
            ensureSolverOptimizerSetsIsMutable();
            solverOptimizerSets_.addAll(other.solverOptimizerSets_);
          }
          onChanged();
        }
      } else {
        if (!other.solverOptimizerSets_.isEmpty()) {
          if (solverOptimizerSetsBuilder_.isEmpty()) {
            solverOptimizerSetsBuilder_.dispose();
            solverOptimizerSetsBuilder_ = null;
            solverOptimizerSets_ = other.solverOptimizerSets_;
            bitField0_ = (bitField0_ & ~0x20000000);
            solverOptimizerSetsBuilder_ = 
              com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                 getSolverOptimizerSetsFieldBuilder() : null;
          } else {
            solverOptimizerSetsBuilder_.addAllMessages(other.solverOptimizerSets_);
          }
        }
      }
      if (other.hasDefaultSolverOptimizerSets()) {
        defaultSolverOptimizerSets_ = other.defaultSolverOptimizerSets_;
        bitField0_ |= 0x40000000;
        onChanged();
      }
      if (other.hasUseLpStrongBranching()) {
        setUseLpStrongBranching(other.getUseLpStrongBranching());
      }
      if (other.hasDecomposerNumVariablesThreshold()) {
        setDecomposerNumVariablesThreshold(other.getDecomposerNumVariablesThreshold());
      }
      if (other.hasNumBopSolversUsedByDecomposition()) {
        setNumBopSolversUsedByDecomposition(other.getNumBopSolversUsedByDecomposition());
      }
      if (other.hasDecomposedProblemMinTimeInSeconds()) {
        setDecomposedProblemMinTimeInSeconds(other.getDecomposedProblemMinTimeInSeconds());
      }
      if (other.hasGuidedSatConflictsChunk()) {
        setGuidedSatConflictsChunk(other.getGuidedSatConflictsChunk());
      }
      if (other.hasMaxLpSolveForFeasibilityProblems()) {
        setMaxLpSolveForFeasibilityProblems(other.getMaxLpSolveForFeasibilityProblems());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 9: {
              maxTimeInSeconds_ = input.readDouble();
              bitField0_ |= 0x00000001;
              break;
            } // case 9
            case 16: {
              maxNumDecisionsInLs_ = input.readInt32();
              bitField0_ |= 0x00000020;
              break;
            } // case 16
            case 24: {
              computeEstimatedImpact_ = input.readBool();
              bitField0_ |= 0x00000100;
              break;
            } // case 24
            case 32: {
              pruneSearchTree_ = input.readBool();
              bitField0_ |= 0x00000200;
              break;
            } // case 32
            case 40: {
              sortConstraintsByNumTerms_ = input.readBool();
              bitField0_ |= 0x00000400;
              break;
            } // case 40
            case 48: {
              useRandomLns_ = input.readBool();
              bitField0_ |= 0x00000800;
              break;
            } // case 48
            case 56: {
              randomSeed_ = input.readInt32();
              bitField0_ |= 0x00001000;
              break;
            } // case 56
            case 64: {
              numRelaxedVars_ = input.readInt32();
              bitField0_ |= 0x00002000;
              break;
            } // case 64
            case 72: {
              maxNumberOfConflictsInRandomLns_ = input.readInt32();
              bitField0_ |= 0x00004000;
              break;
            } // case 72
            case 80: {
              numRandomLnsTries_ = input.readInt32();
              bitField0_ |= 0x00008000;
              break;
            } // case 80
            case 88: {
              maxNumberOfBacktracksInLs_ = input.readInt64();
              bitField0_ |= 0x00010000;
              break;
            } // case 88
            case 96: {
              useLpLns_ = input.readBool();
              bitField0_ |= 0x00020000;
              break;
            } // case 96
            case 112: {
              logSearchProgress_ = input.readBool();
              bitField0_ |= 0x00000080;
              break;
            } // case 112
            case 120: {
              useSatToChooseLnsNeighbourhood_ = input.readBool();
              bitField0_ |= 0x00040000;
              break;
            } // case 120
            case 128: {
              maxNumberOfConflictsForQuickCheck_ = input.readInt32();
              bitField0_ |= 0x00080000;
              break;
            } // case 128
            case 136: {
              useSymmetry_ = input.readBool();
              bitField0_ |= 0x00100000;
              break;
            } // case 136
            case 160: {
              maxNumberOfConflictsInRandomSolutionGeneration_ = input.readInt32();
              bitField0_ |= 0x00400000;
              break;
            } // case 160
            case 168: {
              maxNumberOfExploredAssignmentsPerTryInLs_ = input.readInt64();
              bitField0_ |= 0x00800000;
              break;
            } // case 168
            case 176: {
              useTranspositionTableInLs_ = input.readBool();
              bitField0_ |= 0x01000000;
              break;
            } // case 176
            case 184: {
              useLearnedBinaryClausesInLp_ = input.readBool();
              bitField0_ |= 0x04000000;
              break;
            } // case 184
            case 192: {
              numberOfSolvers_ = input.readInt32();
              bitField0_ |= 0x08000000;
              break;
            } // case 192
            case 200: {
              int tmpRaw = input.readEnum();
              com.google.ortools.bop.BopParameters.ThreadSynchronizationType tmpValue =
                  com.google.ortools.bop.BopParameters.ThreadSynchronizationType.forNumber(tmpRaw);
              if (tmpValue == null) {
                mergeUnknownVarintField(25, tmpRaw);
              } else {
                synchronizationType_ = tmpRaw;
                bitField0_ |= 0x10000000;
              }
              break;
            } // case 200
            case 210: {
              com.google.ortools.bop.BopSolverOptimizerSet m =
                  input.readMessage(
                      com.google.ortools.bop.BopSolverOptimizerSet.parser(),
                      extensionRegistry);
              if (solverOptimizerSetsBuilder_ == null) {
                ensureSolverOptimizerSetsIsMutable();
                solverOptimizerSets_.add(m);
              } else {
                solverOptimizerSetsBuilder_.addMessage(m);
              }
              break;
            } // case 210
            case 217: {
              maxDeterministicTime_ = input.readDouble();
              bitField0_ |= 0x00000002;
              break;
            } // case 217
            case 225: {
              relativeGapLimit_ = input.readDouble();
              bitField0_ |= 0x00000010;
              break;
            } // case 225
            case 232: {
              useLpStrongBranching_ = input.readBool();
              bitField0_ |= 0x80000000;
              break;
            } // case 232
            case 240: {
              decomposerNumVariablesThreshold_ = input.readInt32();
              bitField1_ |= 0x00000001;
              break;
            } // case 240
            case 248: {
              numBopSolversUsedByDecomposition_ = input.readInt32();
              bitField1_ |= 0x00000002;
              break;
            } // case 248
            case 266: {
              defaultSolverOptimizerSets_ = input.readBytes();
              bitField0_ |= 0x40000000;
              break;
            } // case 266
            case 272: {
              guidedSatConflictsChunk_ = input.readInt32();
              bitField1_ |= 0x00000008;
              break;
            } // case 272
            case 280: {
              maxNumberOfConsecutiveFailingOptimizerCalls_ = input.readInt32();
              bitField0_ |= 0x00000008;
              break;
            } // case 280
            case 289: {
              decomposedProblemMinTimeInSeconds_ = input.readDouble();
              bitField1_ |= 0x00000004;
              break;
            } // case 289
            case 297: {
              lpMaxDeterministicTime_ = input.readDouble();
              bitField0_ |= 0x00000004;
              break;
            } // case 297
            case 304: {
              maxNumBrokenConstraintsInLs_ = input.readInt32();
              bitField0_ |= 0x00000040;
              break;
            } // case 304
            case 312: {
              usePotentialOneFlipRepairsInLs_ = input.readBool();
              bitField0_ |= 0x02000000;
              break;
            } // case 312
            case 320: {
              exploitSymmetryInSatFirstSolution_ = input.readBool();
              bitField0_ |= 0x00200000;
              break;
            } // case 320
            case 328: {
              maxLpSolveForFeasibilityProblems_ = input.readInt32();
              bitField1_ |= 0x00000010;
              break;
            } // case 328
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;
    private int bitField1_;

    private double maxTimeInSeconds_ = Double.POSITIVE_INFINITY;
    /**
     * <pre>
     * Maximum time allowed in seconds to solve a problem.
     * The counter will starts as soon as Solve() is called.
     * </pre>
     *
     * <code>optional double max_time_in_seconds = 1 [default = inf];</code>
     * @return Whether the maxTimeInSeconds field is set.
     */
    @java.lang.Override
    public boolean hasMaxTimeInSeconds() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Maximum time allowed in seconds to solve a problem.
     * The counter will starts as soon as Solve() is called.
     * </pre>
     *
     * <code>optional double max_time_in_seconds = 1 [default = inf];</code>
     * @return The maxTimeInSeconds.
     */
    @java.lang.Override
    public double getMaxTimeInSeconds() {
      return maxTimeInSeconds_;
    }
    /**
     * <pre>
     * Maximum time allowed in seconds to solve a problem.
     * The counter will starts as soon as Solve() is called.
     * </pre>
     *
     * <code>optional double max_time_in_seconds = 1 [default = inf];</code>
     * @param value The maxTimeInSeconds to set.
     * @return This builder for chaining.
     */
    public Builder setMaxTimeInSeconds(double value) {

      maxTimeInSeconds_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Maximum time allowed in seconds to solve a problem.
     * The counter will starts as soon as Solve() is called.
     * </pre>
     *
     * <code>optional double max_time_in_seconds = 1 [default = inf];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxTimeInSeconds() {
      bitField0_ = (bitField0_ & ~0x00000001);
      maxTimeInSeconds_ = Double.POSITIVE_INFINITY;
      onChanged();
      return this;
    }

    private double maxDeterministicTime_ = Double.POSITIVE_INFINITY;
    /**
     * <pre>
     * Maximum time allowed in deterministic time to solve a problem.
     * The deterministic time should be correlated with the real time used by the
     * solver, the time unit being roughly the order of magnitude of a second.
     * The counter will starts as soon as SetParameters() or SolveWithTimeLimit()
     * is called.
     * </pre>
     *
     * <code>optional double max_deterministic_time = 27 [default = inf];</code>
     * @return Whether the maxDeterministicTime field is set.
     */
    @java.lang.Override
    public boolean hasMaxDeterministicTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Maximum time allowed in deterministic time to solve a problem.
     * The deterministic time should be correlated with the real time used by the
     * solver, the time unit being roughly the order of magnitude of a second.
     * The counter will starts as soon as SetParameters() or SolveWithTimeLimit()
     * is called.
     * </pre>
     *
     * <code>optional double max_deterministic_time = 27 [default = inf];</code>
     * @return The maxDeterministicTime.
     */
    @java.lang.Override
    public double getMaxDeterministicTime() {
      return maxDeterministicTime_;
    }
    /**
     * <pre>
     * Maximum time allowed in deterministic time to solve a problem.
     * The deterministic time should be correlated with the real time used by the
     * solver, the time unit being roughly the order of magnitude of a second.
     * The counter will starts as soon as SetParameters() or SolveWithTimeLimit()
     * is called.
     * </pre>
     *
     * <code>optional double max_deterministic_time = 27 [default = inf];</code>
     * @param value The maxDeterministicTime to set.
     * @return This builder for chaining.
     */
    public Builder setMaxDeterministicTime(double value) {

      maxDeterministicTime_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Maximum time allowed in deterministic time to solve a problem.
     * The deterministic time should be correlated with the real time used by the
     * solver, the time unit being roughly the order of magnitude of a second.
     * The counter will starts as soon as SetParameters() or SolveWithTimeLimit()
     * is called.
     * </pre>
     *
     * <code>optional double max_deterministic_time = 27 [default = inf];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxDeterministicTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      maxDeterministicTime_ = Double.POSITIVE_INFINITY;
      onChanged();
      return this;
    }

    private double lpMaxDeterministicTime_ = 1D;
    /**
     * <pre>
     * The max deterministic time given to the LP solver each time it is called.
     * If this is not enough to solve the LP at hand, it will simply be called
     * again later (and the solve will resume from where it stopped).
     * </pre>
     *
     * <code>optional double lp_max_deterministic_time = 37 [default = 1];</code>
     * @return Whether the lpMaxDeterministicTime field is set.
     */
    @java.lang.Override
    public boolean hasLpMaxDeterministicTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * The max deterministic time given to the LP solver each time it is called.
     * If this is not enough to solve the LP at hand, it will simply be called
     * again later (and the solve will resume from where it stopped).
     * </pre>
     *
     * <code>optional double lp_max_deterministic_time = 37 [default = 1];</code>
     * @return The lpMaxDeterministicTime.
     */
    @java.lang.Override
    public double getLpMaxDeterministicTime() {
      return lpMaxDeterministicTime_;
    }
    /**
     * <pre>
     * The max deterministic time given to the LP solver each time it is called.
     * If this is not enough to solve the LP at hand, it will simply be called
     * again later (and the solve will resume from where it stopped).
     * </pre>
     *
     * <code>optional double lp_max_deterministic_time = 37 [default = 1];</code>
     * @param value The lpMaxDeterministicTime to set.
     * @return This builder for chaining.
     */
    public Builder setLpMaxDeterministicTime(double value) {

      lpMaxDeterministicTime_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The max deterministic time given to the LP solver each time it is called.
     * If this is not enough to solve the LP at hand, it will simply be called
     * again later (and the solve will resume from where it stopped).
     * </pre>
     *
     * <code>optional double lp_max_deterministic_time = 37 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearLpMaxDeterministicTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      lpMaxDeterministicTime_ = 1D;
      onChanged();
      return this;
    }

    private int maxNumberOfConsecutiveFailingOptimizerCalls_ ;
    /**
     * <pre>
     * Maximum number of consecutive optimizer calls without improving the
     * current solution. If this number is reached, the search will be aborted.
     * Note that this parameter only applies when an initial solution has been
     * found or is provided. Also note that there is no limit to the number of
     * calls, when the parameter is not set.
     * </pre>
     *
     * <code>optional int32 max_number_of_consecutive_failing_optimizer_calls = 35;</code>
     * @return Whether the maxNumberOfConsecutiveFailingOptimizerCalls field is set.
     */
    @java.lang.Override
    public boolean hasMaxNumberOfConsecutiveFailingOptimizerCalls() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * Maximum number of consecutive optimizer calls without improving the
     * current solution. If this number is reached, the search will be aborted.
     * Note that this parameter only applies when an initial solution has been
     * found or is provided. Also note that there is no limit to the number of
     * calls, when the parameter is not set.
     * </pre>
     *
     * <code>optional int32 max_number_of_consecutive_failing_optimizer_calls = 35;</code>
     * @return The maxNumberOfConsecutiveFailingOptimizerCalls.
     */
    @java.lang.Override
    public int getMaxNumberOfConsecutiveFailingOptimizerCalls() {
      return maxNumberOfConsecutiveFailingOptimizerCalls_;
    }
    /**
     * <pre>
     * Maximum number of consecutive optimizer calls without improving the
     * current solution. If this number is reached, the search will be aborted.
     * Note that this parameter only applies when an initial solution has been
     * found or is provided. Also note that there is no limit to the number of
     * calls, when the parameter is not set.
     * </pre>
     *
     * <code>optional int32 max_number_of_consecutive_failing_optimizer_calls = 35;</code>
     * @param value The maxNumberOfConsecutiveFailingOptimizerCalls to set.
     * @return This builder for chaining.
     */
    public Builder setMaxNumberOfConsecutiveFailingOptimizerCalls(int value) {

      maxNumberOfConsecutiveFailingOptimizerCalls_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Maximum number of consecutive optimizer calls without improving the
     * current solution. If this number is reached, the search will be aborted.
     * Note that this parameter only applies when an initial solution has been
     * found or is provided. Also note that there is no limit to the number of
     * calls, when the parameter is not set.
     * </pre>
     *
     * <code>optional int32 max_number_of_consecutive_failing_optimizer_calls = 35;</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxNumberOfConsecutiveFailingOptimizerCalls() {
      bitField0_ = (bitField0_ & ~0x00000008);
      maxNumberOfConsecutiveFailingOptimizerCalls_ = 0;
      onChanged();
      return this;
    }

    private double relativeGapLimit_ = 0.0001D;
    /**
     * <pre>
     * Limit used to stop the optimization as soon as the relative gap is smaller
     * than the given value.
     * The relative gap is defined as:
     * abs(solution_cost - best_bound)
     * / max(abs(solution_cost), abs(best_bound)).
     * </pre>
     *
     * <code>optional double relative_gap_limit = 28 [default = 0.0001];</code>
     * @return Whether the relativeGapLimit field is set.
     */
    @java.lang.Override
    public boolean hasRelativeGapLimit() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * Limit used to stop the optimization as soon as the relative gap is smaller
     * than the given value.
     * The relative gap is defined as:
     * abs(solution_cost - best_bound)
     * / max(abs(solution_cost), abs(best_bound)).
     * </pre>
     *
     * <code>optional double relative_gap_limit = 28 [default = 0.0001];</code>
     * @return The relativeGapLimit.
     */
    @java.lang.Override
    public double getRelativeGapLimit() {
      return relativeGapLimit_;
    }
    /**
     * <pre>
     * Limit used to stop the optimization as soon as the relative gap is smaller
     * than the given value.
     * The relative gap is defined as:
     * abs(solution_cost - best_bound)
     * / max(abs(solution_cost), abs(best_bound)).
     * </pre>
     *
     * <code>optional double relative_gap_limit = 28 [default = 0.0001];</code>
     * @param value The relativeGapLimit to set.
     * @return This builder for chaining.
     */
    public Builder setRelativeGapLimit(double value) {

      relativeGapLimit_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Limit used to stop the optimization as soon as the relative gap is smaller
     * than the given value.
     * The relative gap is defined as:
     * abs(solution_cost - best_bound)
     * / max(abs(solution_cost), abs(best_bound)).
     * </pre>
     *
     * <code>optional double relative_gap_limit = 28 [default = 0.0001];</code>
     * @return This builder for chaining.
     */
    public Builder clearRelativeGapLimit() {
      bitField0_ = (bitField0_ & ~0x00000010);
      relativeGapLimit_ = 0.0001D;
      onChanged();
      return this;
    }

    private int maxNumDecisionsInLs_ = 4;
    /**
     * <pre>
     * Maximum number of cascading decisions the solver might use to repair the
     * current solution in the LS.
     * </pre>
     *
     * <code>optional int32 max_num_decisions_in_ls = 2 [default = 4];</code>
     * @return Whether the maxNumDecisionsInLs field is set.
     */
    @java.lang.Override
    public boolean hasMaxNumDecisionsInLs() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * Maximum number of cascading decisions the solver might use to repair the
     * current solution in the LS.
     * </pre>
     *
     * <code>optional int32 max_num_decisions_in_ls = 2 [default = 4];</code>
     * @return The maxNumDecisionsInLs.
     */
    @java.lang.Override
    public int getMaxNumDecisionsInLs() {
      return maxNumDecisionsInLs_;
    }
    /**
     * <pre>
     * Maximum number of cascading decisions the solver might use to repair the
     * current solution in the LS.
     * </pre>
     *
     * <code>optional int32 max_num_decisions_in_ls = 2 [default = 4];</code>
     * @param value The maxNumDecisionsInLs to set.
     * @return This builder for chaining.
     */
    public Builder setMaxNumDecisionsInLs(int value) {

      maxNumDecisionsInLs_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Maximum number of cascading decisions the solver might use to repair the
     * current solution in the LS.
     * </pre>
     *
     * <code>optional int32 max_num_decisions_in_ls = 2 [default = 4];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxNumDecisionsInLs() {
      bitField0_ = (bitField0_ & ~0x00000020);
      maxNumDecisionsInLs_ = 4;
      onChanged();
      return this;
    }

    private int maxNumBrokenConstraintsInLs_ = 2147483647;
    /**
     * <pre>
     * Abort the LS search tree as soon as strictly more than this number of
     * constraints are broken. The default is a large value which basically
     * disable this heuristic.
     * </pre>
     *
     * <code>optional int32 max_num_broken_constraints_in_ls = 38 [default = 2147483647];</code>
     * @return Whether the maxNumBrokenConstraintsInLs field is set.
     */
    @java.lang.Override
    public boolean hasMaxNumBrokenConstraintsInLs() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * Abort the LS search tree as soon as strictly more than this number of
     * constraints are broken. The default is a large value which basically
     * disable this heuristic.
     * </pre>
     *
     * <code>optional int32 max_num_broken_constraints_in_ls = 38 [default = 2147483647];</code>
     * @return The maxNumBrokenConstraintsInLs.
     */
    @java.lang.Override
    public int getMaxNumBrokenConstraintsInLs() {
      return maxNumBrokenConstraintsInLs_;
    }
    /**
     * <pre>
     * Abort the LS search tree as soon as strictly more than this number of
     * constraints are broken. The default is a large value which basically
     * disable this heuristic.
     * </pre>
     *
     * <code>optional int32 max_num_broken_constraints_in_ls = 38 [default = 2147483647];</code>
     * @param value The maxNumBrokenConstraintsInLs to set.
     * @return This builder for chaining.
     */
    public Builder setMaxNumBrokenConstraintsInLs(int value) {

      maxNumBrokenConstraintsInLs_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Abort the LS search tree as soon as strictly more than this number of
     * constraints are broken. The default is a large value which basically
     * disable this heuristic.
     * </pre>
     *
     * <code>optional int32 max_num_broken_constraints_in_ls = 38 [default = 2147483647];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxNumBrokenConstraintsInLs() {
      bitField0_ = (bitField0_ & ~0x00000040);
      maxNumBrokenConstraintsInLs_ = 2147483647;
      onChanged();
      return this;
    }

    private boolean logSearchProgress_ ;
    /**
     * <pre>
     * Whether the solver should log the search progress to LOG(INFO).
     * </pre>
     *
     * <code>optional bool log_search_progress = 14 [default = false];</code>
     * @return Whether the logSearchProgress field is set.
     */
    @java.lang.Override
    public boolean hasLogSearchProgress() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     * <pre>
     * Whether the solver should log the search progress to LOG(INFO).
     * </pre>
     *
     * <code>optional bool log_search_progress = 14 [default = false];</code>
     * @return The logSearchProgress.
     */
    @java.lang.Override
    public boolean getLogSearchProgress() {
      return logSearchProgress_;
    }
    /**
     * <pre>
     * Whether the solver should log the search progress to LOG(INFO).
     * </pre>
     *
     * <code>optional bool log_search_progress = 14 [default = false];</code>
     * @param value The logSearchProgress to set.
     * @return This builder for chaining.
     */
    public Builder setLogSearchProgress(boolean value) {

      logSearchProgress_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether the solver should log the search progress to LOG(INFO).
     * </pre>
     *
     * <code>optional bool log_search_progress = 14 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearLogSearchProgress() {
      bitField0_ = (bitField0_ & ~0x00000080);
      logSearchProgress_ = false;
      onChanged();
      return this;
    }

    private boolean computeEstimatedImpact_ = true;
    /**
     * <pre>
     * Compute estimated impact at each iteration when true; only once when false.
     * </pre>
     *
     * <code>optional bool compute_estimated_impact = 3 [default = true];</code>
     * @return Whether the computeEstimatedImpact field is set.
     */
    @java.lang.Override
    public boolean hasComputeEstimatedImpact() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     * <pre>
     * Compute estimated impact at each iteration when true; only once when false.
     * </pre>
     *
     * <code>optional bool compute_estimated_impact = 3 [default = true];</code>
     * @return The computeEstimatedImpact.
     */
    @java.lang.Override
    public boolean getComputeEstimatedImpact() {
      return computeEstimatedImpact_;
    }
    /**
     * <pre>
     * Compute estimated impact at each iteration when true; only once when false.
     * </pre>
     *
     * <code>optional bool compute_estimated_impact = 3 [default = true];</code>
     * @param value The computeEstimatedImpact to set.
     * @return This builder for chaining.
     */
    public Builder setComputeEstimatedImpact(boolean value) {

      computeEstimatedImpact_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Compute estimated impact at each iteration when true; only once when false.
     * </pre>
     *
     * <code>optional bool compute_estimated_impact = 3 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearComputeEstimatedImpact() {
      bitField0_ = (bitField0_ & ~0x00000100);
      computeEstimatedImpact_ = true;
      onChanged();
      return this;
    }

    private boolean pruneSearchTree_ ;
    /**
     * <pre>
     * Avoid exploring both branches (b, a, ...) and (a, b, ...).
     * </pre>
     *
     * <code>optional bool prune_search_tree = 4 [default = false];</code>
     * @return Whether the pruneSearchTree field is set.
     */
    @java.lang.Override
    public boolean hasPruneSearchTree() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     * <pre>
     * Avoid exploring both branches (b, a, ...) and (a, b, ...).
     * </pre>
     *
     * <code>optional bool prune_search_tree = 4 [default = false];</code>
     * @return The pruneSearchTree.
     */
    @java.lang.Override
    public boolean getPruneSearchTree() {
      return pruneSearchTree_;
    }
    /**
     * <pre>
     * Avoid exploring both branches (b, a, ...) and (a, b, ...).
     * </pre>
     *
     * <code>optional bool prune_search_tree = 4 [default = false];</code>
     * @param value The pruneSearchTree to set.
     * @return This builder for chaining.
     */
    public Builder setPruneSearchTree(boolean value) {

      pruneSearchTree_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Avoid exploring both branches (b, a, ...) and (a, b, ...).
     * </pre>
     *
     * <code>optional bool prune_search_tree = 4 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearPruneSearchTree() {
      bitField0_ = (bitField0_ & ~0x00000200);
      pruneSearchTree_ = false;
      onChanged();
      return this;
    }

    private boolean sortConstraintsByNumTerms_ ;
    /**
     * <pre>
     * Sort constraints by increasing total number of terms instead of number of
     * contributing terms.
     * </pre>
     *
     * <code>optional bool sort_constraints_by_num_terms = 5 [default = false];</code>
     * @return Whether the sortConstraintsByNumTerms field is set.
     */
    @java.lang.Override
    public boolean hasSortConstraintsByNumTerms() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     * <pre>
     * Sort constraints by increasing total number of terms instead of number of
     * contributing terms.
     * </pre>
     *
     * <code>optional bool sort_constraints_by_num_terms = 5 [default = false];</code>
     * @return The sortConstraintsByNumTerms.
     */
    @java.lang.Override
    public boolean getSortConstraintsByNumTerms() {
      return sortConstraintsByNumTerms_;
    }
    /**
     * <pre>
     * Sort constraints by increasing total number of terms instead of number of
     * contributing terms.
     * </pre>
     *
     * <code>optional bool sort_constraints_by_num_terms = 5 [default = false];</code>
     * @param value The sortConstraintsByNumTerms to set.
     * @return This builder for chaining.
     */
    public Builder setSortConstraintsByNumTerms(boolean value) {

      sortConstraintsByNumTerms_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Sort constraints by increasing total number of terms instead of number of
     * contributing terms.
     * </pre>
     *
     * <code>optional bool sort_constraints_by_num_terms = 5 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearSortConstraintsByNumTerms() {
      bitField0_ = (bitField0_ & ~0x00000400);
      sortConstraintsByNumTerms_ = false;
      onChanged();
      return this;
    }

    private boolean useRandomLns_ = true;
    /**
     * <pre>
     * Use the random Large Neighborhood Search instead of the exhaustive one.
     * </pre>
     *
     * <code>optional bool use_random_lns = 6 [default = true];</code>
     * @return Whether the useRandomLns field is set.
     */
    @java.lang.Override
    public boolean hasUseRandomLns() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     * <pre>
     * Use the random Large Neighborhood Search instead of the exhaustive one.
     * </pre>
     *
     * <code>optional bool use_random_lns = 6 [default = true];</code>
     * @return The useRandomLns.
     */
    @java.lang.Override
    public boolean getUseRandomLns() {
      return useRandomLns_;
    }
    /**
     * <pre>
     * Use the random Large Neighborhood Search instead of the exhaustive one.
     * </pre>
     *
     * <code>optional bool use_random_lns = 6 [default = true];</code>
     * @param value The useRandomLns to set.
     * @return This builder for chaining.
     */
    public Builder setUseRandomLns(boolean value) {

      useRandomLns_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Use the random Large Neighborhood Search instead of the exhaustive one.
     * </pre>
     *
     * <code>optional bool use_random_lns = 6 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseRandomLns() {
      bitField0_ = (bitField0_ & ~0x00000800);
      useRandomLns_ = true;
      onChanged();
      return this;
    }

    private int randomSeed_ = 8;
    /**
     * <pre>
     * The seed used to initialize the random generator.
     *
     * TODO(user): Some of our client test fail depending on this value! we need
     * to fix them and ideally randomize our behavior from on test to the next so
     * that this doesn't happen in the future.
     * </pre>
     *
     * <code>optional int32 random_seed = 7 [default = 8];</code>
     * @return Whether the randomSeed field is set.
     */
    @java.lang.Override
    public boolean hasRandomSeed() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     * <pre>
     * The seed used to initialize the random generator.
     *
     * TODO(user): Some of our client test fail depending on this value! we need
     * to fix them and ideally randomize our behavior from on test to the next so
     * that this doesn't happen in the future.
     * </pre>
     *
     * <code>optional int32 random_seed = 7 [default = 8];</code>
     * @return The randomSeed.
     */
    @java.lang.Override
    public int getRandomSeed() {
      return randomSeed_;
    }
    /**
     * <pre>
     * The seed used to initialize the random generator.
     *
     * TODO(user): Some of our client test fail depending on this value! we need
     * to fix them and ideally randomize our behavior from on test to the next so
     * that this doesn't happen in the future.
     * </pre>
     *
     * <code>optional int32 random_seed = 7 [default = 8];</code>
     * @param value The randomSeed to set.
     * @return This builder for chaining.
     */
    public Builder setRandomSeed(int value) {

      randomSeed_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The seed used to initialize the random generator.
     *
     * TODO(user): Some of our client test fail depending on this value! we need
     * to fix them and ideally randomize our behavior from on test to the next so
     * that this doesn't happen in the future.
     * </pre>
     *
     * <code>optional int32 random_seed = 7 [default = 8];</code>
     * @return This builder for chaining.
     */
    public Builder clearRandomSeed() {
      bitField0_ = (bitField0_ & ~0x00001000);
      randomSeed_ = 8;
      onChanged();
      return this;
    }

    private int numRelaxedVars_ = 10;
    /**
     * <pre>
     * Number of variables to relax in the exhaustive Large Neighborhood Search.
     * </pre>
     *
     * <code>optional int32 num_relaxed_vars = 8 [default = 10];</code>
     * @return Whether the numRelaxedVars field is set.
     */
    @java.lang.Override
    public boolean hasNumRelaxedVars() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     * <pre>
     * Number of variables to relax in the exhaustive Large Neighborhood Search.
     * </pre>
     *
     * <code>optional int32 num_relaxed_vars = 8 [default = 10];</code>
     * @return The numRelaxedVars.
     */
    @java.lang.Override
    public int getNumRelaxedVars() {
      return numRelaxedVars_;
    }
    /**
     * <pre>
     * Number of variables to relax in the exhaustive Large Neighborhood Search.
     * </pre>
     *
     * <code>optional int32 num_relaxed_vars = 8 [default = 10];</code>
     * @param value The numRelaxedVars to set.
     * @return This builder for chaining.
     */
    public Builder setNumRelaxedVars(int value) {

      numRelaxedVars_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Number of variables to relax in the exhaustive Large Neighborhood Search.
     * </pre>
     *
     * <code>optional int32 num_relaxed_vars = 8 [default = 10];</code>
     * @return This builder for chaining.
     */
    public Builder clearNumRelaxedVars() {
      bitField0_ = (bitField0_ & ~0x00002000);
      numRelaxedVars_ = 10;
      onChanged();
      return this;
    }

    private int maxNumberOfConflictsInRandomLns_ = 2500;
    /**
     * <pre>
     * The number of conflicts the SAT solver has to solve a random LNS
     * subproblem.
     * </pre>
     *
     * <code>optional int32 max_number_of_conflicts_in_random_lns = 9 [default = 2500];</code>
     * @return Whether the maxNumberOfConflictsInRandomLns field is set.
     */
    @java.lang.Override
    public boolean hasMaxNumberOfConflictsInRandomLns() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     * <pre>
     * The number of conflicts the SAT solver has to solve a random LNS
     * subproblem.
     * </pre>
     *
     * <code>optional int32 max_number_of_conflicts_in_random_lns = 9 [default = 2500];</code>
     * @return The maxNumberOfConflictsInRandomLns.
     */
    @java.lang.Override
    public int getMaxNumberOfConflictsInRandomLns() {
      return maxNumberOfConflictsInRandomLns_;
    }
    /**
     * <pre>
     * The number of conflicts the SAT solver has to solve a random LNS
     * subproblem.
     * </pre>
     *
     * <code>optional int32 max_number_of_conflicts_in_random_lns = 9 [default = 2500];</code>
     * @param value The maxNumberOfConflictsInRandomLns to set.
     * @return This builder for chaining.
     */
    public Builder setMaxNumberOfConflictsInRandomLns(int value) {

      maxNumberOfConflictsInRandomLns_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The number of conflicts the SAT solver has to solve a random LNS
     * subproblem.
     * </pre>
     *
     * <code>optional int32 max_number_of_conflicts_in_random_lns = 9 [default = 2500];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxNumberOfConflictsInRandomLns() {
      bitField0_ = (bitField0_ & ~0x00004000);
      maxNumberOfConflictsInRandomLns_ = 2500;
      onChanged();
      return this;
    }

    private int numRandomLnsTries_ = 1;
    /**
     * <pre>
     * Number of tries in the random lns.
     * </pre>
     *
     * <code>optional int32 num_random_lns_tries = 10 [default = 1];</code>
     * @return Whether the numRandomLnsTries field is set.
     */
    @java.lang.Override
    public boolean hasNumRandomLnsTries() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     * <pre>
     * Number of tries in the random lns.
     * </pre>
     *
     * <code>optional int32 num_random_lns_tries = 10 [default = 1];</code>
     * @return The numRandomLnsTries.
     */
    @java.lang.Override
    public int getNumRandomLnsTries() {
      return numRandomLnsTries_;
    }
    /**
     * <pre>
     * Number of tries in the random lns.
     * </pre>
     *
     * <code>optional int32 num_random_lns_tries = 10 [default = 1];</code>
     * @param value The numRandomLnsTries to set.
     * @return This builder for chaining.
     */
    public Builder setNumRandomLnsTries(int value) {

      numRandomLnsTries_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Number of tries in the random lns.
     * </pre>
     *
     * <code>optional int32 num_random_lns_tries = 10 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearNumRandomLnsTries() {
      bitField0_ = (bitField0_ & ~0x00008000);
      numRandomLnsTries_ = 1;
      onChanged();
      return this;
    }

    private long maxNumberOfBacktracksInLs_ = 100000000L;
    /**
     * <pre>
     * Maximum number of backtracks times the number of variables in Local Search,
     * ie. max num backtracks == max_number_of_backtracks_in_ls / num variables.
     * </pre>
     *
     * <code>optional int64 max_number_of_backtracks_in_ls = 11 [default = 100000000];</code>
     * @return Whether the maxNumberOfBacktracksInLs field is set.
     */
    @java.lang.Override
    public boolean hasMaxNumberOfBacktracksInLs() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     * <pre>
     * Maximum number of backtracks times the number of variables in Local Search,
     * ie. max num backtracks == max_number_of_backtracks_in_ls / num variables.
     * </pre>
     *
     * <code>optional int64 max_number_of_backtracks_in_ls = 11 [default = 100000000];</code>
     * @return The maxNumberOfBacktracksInLs.
     */
    @java.lang.Override
    public long getMaxNumberOfBacktracksInLs() {
      return maxNumberOfBacktracksInLs_;
    }
    /**
     * <pre>
     * Maximum number of backtracks times the number of variables in Local Search,
     * ie. max num backtracks == max_number_of_backtracks_in_ls / num variables.
     * </pre>
     *
     * <code>optional int64 max_number_of_backtracks_in_ls = 11 [default = 100000000];</code>
     * @param value The maxNumberOfBacktracksInLs to set.
     * @return This builder for chaining.
     */
    public Builder setMaxNumberOfBacktracksInLs(long value) {

      maxNumberOfBacktracksInLs_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Maximum number of backtracks times the number of variables in Local Search,
     * ie. max num backtracks == max_number_of_backtracks_in_ls / num variables.
     * </pre>
     *
     * <code>optional int64 max_number_of_backtracks_in_ls = 11 [default = 100000000];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxNumberOfBacktracksInLs() {
      bitField0_ = (bitField0_ & ~0x00010000);
      maxNumberOfBacktracksInLs_ = 100000000L;
      onChanged();
      return this;
    }

    private boolean useLpLns_ = true;
    /**
     * <pre>
     * Use Large Neighborhood Search based on the LP relaxation.
     * </pre>
     *
     * <code>optional bool use_lp_lns = 12 [default = true];</code>
     * @return Whether the useLpLns field is set.
     */
    @java.lang.Override
    public boolean hasUseLpLns() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     * <pre>
     * Use Large Neighborhood Search based on the LP relaxation.
     * </pre>
     *
     * <code>optional bool use_lp_lns = 12 [default = true];</code>
     * @return The useLpLns.
     */
    @java.lang.Override
    public boolean getUseLpLns() {
      return useLpLns_;
    }
    /**
     * <pre>
     * Use Large Neighborhood Search based on the LP relaxation.
     * </pre>
     *
     * <code>optional bool use_lp_lns = 12 [default = true];</code>
     * @param value The useLpLns to set.
     * @return This builder for chaining.
     */
    public Builder setUseLpLns(boolean value) {

      useLpLns_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Use Large Neighborhood Search based on the LP relaxation.
     * </pre>
     *
     * <code>optional bool use_lp_lns = 12 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseLpLns() {
      bitField0_ = (bitField0_ & ~0x00020000);
      useLpLns_ = true;
      onChanged();
      return this;
    }

    private boolean useSatToChooseLnsNeighbourhood_ = true;
    /**
     * <pre>
     * Whether we use sat propagation to choose the lns neighbourhood.
     * </pre>
     *
     * <code>optional bool use_sat_to_choose_lns_neighbourhood = 15 [default = true];</code>
     * @return Whether the useSatToChooseLnsNeighbourhood field is set.
     */
    @java.lang.Override
    public boolean hasUseSatToChooseLnsNeighbourhood() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     * <pre>
     * Whether we use sat propagation to choose the lns neighbourhood.
     * </pre>
     *
     * <code>optional bool use_sat_to_choose_lns_neighbourhood = 15 [default = true];</code>
     * @return The useSatToChooseLnsNeighbourhood.
     */
    @java.lang.Override
    public boolean getUseSatToChooseLnsNeighbourhood() {
      return useSatToChooseLnsNeighbourhood_;
    }
    /**
     * <pre>
     * Whether we use sat propagation to choose the lns neighbourhood.
     * </pre>
     *
     * <code>optional bool use_sat_to_choose_lns_neighbourhood = 15 [default = true];</code>
     * @param value The useSatToChooseLnsNeighbourhood to set.
     * @return This builder for chaining.
     */
    public Builder setUseSatToChooseLnsNeighbourhood(boolean value) {

      useSatToChooseLnsNeighbourhood_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we use sat propagation to choose the lns neighbourhood.
     * </pre>
     *
     * <code>optional bool use_sat_to_choose_lns_neighbourhood = 15 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseSatToChooseLnsNeighbourhood() {
      bitField0_ = (bitField0_ & ~0x00040000);
      useSatToChooseLnsNeighbourhood_ = true;
      onChanged();
      return this;
    }

    private int maxNumberOfConflictsForQuickCheck_ = 10;
    /**
     * <pre>
     * The number of conflicts the SAT solver has to solve a random LNS
     * subproblem for the quick check of infeasibility.
     * </pre>
     *
     * <code>optional int32 max_number_of_conflicts_for_quick_check = 16 [default = 10];</code>
     * @return Whether the maxNumberOfConflictsForQuickCheck field is set.
     */
    @java.lang.Override
    public boolean hasMaxNumberOfConflictsForQuickCheck() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     * <pre>
     * The number of conflicts the SAT solver has to solve a random LNS
     * subproblem for the quick check of infeasibility.
     * </pre>
     *
     * <code>optional int32 max_number_of_conflicts_for_quick_check = 16 [default = 10];</code>
     * @return The maxNumberOfConflictsForQuickCheck.
     */
    @java.lang.Override
    public int getMaxNumberOfConflictsForQuickCheck() {
      return maxNumberOfConflictsForQuickCheck_;
    }
    /**
     * <pre>
     * The number of conflicts the SAT solver has to solve a random LNS
     * subproblem for the quick check of infeasibility.
     * </pre>
     *
     * <code>optional int32 max_number_of_conflicts_for_quick_check = 16 [default = 10];</code>
     * @param value The maxNumberOfConflictsForQuickCheck to set.
     * @return This builder for chaining.
     */
    public Builder setMaxNumberOfConflictsForQuickCheck(int value) {

      maxNumberOfConflictsForQuickCheck_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The number of conflicts the SAT solver has to solve a random LNS
     * subproblem for the quick check of infeasibility.
     * </pre>
     *
     * <code>optional int32 max_number_of_conflicts_for_quick_check = 16 [default = 10];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxNumberOfConflictsForQuickCheck() {
      bitField0_ = (bitField0_ & ~0x00080000);
      maxNumberOfConflictsForQuickCheck_ = 10;
      onChanged();
      return this;
    }

    private boolean useSymmetry_ ;
    /**
     * <pre>
     * If true, find and exploit the eventual symmetries of the problem.
     *
     * TODO(user): turn this on by default once the symmetry finder becomes fast
     * enough to be negligeable for most problem. Or at least support a time
     * limit.
     * </pre>
     *
     * <code>optional bool use_symmetry = 17 [default = false];</code>
     * @return Whether the useSymmetry field is set.
     */
    @java.lang.Override
    public boolean hasUseSymmetry() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     * <pre>
     * If true, find and exploit the eventual symmetries of the problem.
     *
     * TODO(user): turn this on by default once the symmetry finder becomes fast
     * enough to be negligeable for most problem. Or at least support a time
     * limit.
     * </pre>
     *
     * <code>optional bool use_symmetry = 17 [default = false];</code>
     * @return The useSymmetry.
     */
    @java.lang.Override
    public boolean getUseSymmetry() {
      return useSymmetry_;
    }
    /**
     * <pre>
     * If true, find and exploit the eventual symmetries of the problem.
     *
     * TODO(user): turn this on by default once the symmetry finder becomes fast
     * enough to be negligeable for most problem. Or at least support a time
     * limit.
     * </pre>
     *
     * <code>optional bool use_symmetry = 17 [default = false];</code>
     * @param value The useSymmetry to set.
     * @return This builder for chaining.
     */
    public Builder setUseSymmetry(boolean value) {

      useSymmetry_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, find and exploit the eventual symmetries of the problem.
     *
     * TODO(user): turn this on by default once the symmetry finder becomes fast
     * enough to be negligeable for most problem. Or at least support a time
     * limit.
     * </pre>
     *
     * <code>optional bool use_symmetry = 17 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseSymmetry() {
      bitField0_ = (bitField0_ & ~0x00100000);
      useSymmetry_ = false;
      onChanged();
      return this;
    }

    private boolean exploitSymmetryInSatFirstSolution_ ;
    /**
     * <pre>
     * If true, find and exploit symmetries in proving satisfiability in the first
     * problem.
     * This feature is experimental. On some problems, computing symmetries may
     * run forever. You may also run into unforseen problems as this feature was
     * not extensively tested.
     * </pre>
     *
     * <code>optional bool exploit_symmetry_in_sat_first_solution = 40 [default = false];</code>
     * @return Whether the exploitSymmetryInSatFirstSolution field is set.
     */
    @java.lang.Override
    public boolean hasExploitSymmetryInSatFirstSolution() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     * <pre>
     * If true, find and exploit symmetries in proving satisfiability in the first
     * problem.
     * This feature is experimental. On some problems, computing symmetries may
     * run forever. You may also run into unforseen problems as this feature was
     * not extensively tested.
     * </pre>
     *
     * <code>optional bool exploit_symmetry_in_sat_first_solution = 40 [default = false];</code>
     * @return The exploitSymmetryInSatFirstSolution.
     */
    @java.lang.Override
    public boolean getExploitSymmetryInSatFirstSolution() {
      return exploitSymmetryInSatFirstSolution_;
    }
    /**
     * <pre>
     * If true, find and exploit symmetries in proving satisfiability in the first
     * problem.
     * This feature is experimental. On some problems, computing symmetries may
     * run forever. You may also run into unforseen problems as this feature was
     * not extensively tested.
     * </pre>
     *
     * <code>optional bool exploit_symmetry_in_sat_first_solution = 40 [default = false];</code>
     * @param value The exploitSymmetryInSatFirstSolution to set.
     * @return This builder for chaining.
     */
    public Builder setExploitSymmetryInSatFirstSolution(boolean value) {

      exploitSymmetryInSatFirstSolution_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, find and exploit symmetries in proving satisfiability in the first
     * problem.
     * This feature is experimental. On some problems, computing symmetries may
     * run forever. You may also run into unforseen problems as this feature was
     * not extensively tested.
     * </pre>
     *
     * <code>optional bool exploit_symmetry_in_sat_first_solution = 40 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearExploitSymmetryInSatFirstSolution() {
      bitField0_ = (bitField0_ & ~0x00200000);
      exploitSymmetryInSatFirstSolution_ = false;
      onChanged();
      return this;
    }

    private int maxNumberOfConflictsInRandomSolutionGeneration_ = 500;
    /**
     * <pre>
     * The number of conflicts the SAT solver has to generate a random solution.
     * </pre>
     *
     * <code>optional int32 max_number_of_conflicts_in_random_solution_generation = 20 [default = 500];</code>
     * @return Whether the maxNumberOfConflictsInRandomSolutionGeneration field is set.
     */
    @java.lang.Override
    public boolean hasMaxNumberOfConflictsInRandomSolutionGeneration() {
      return ((bitField0_ & 0x00400000) != 0);
    }
    /**
     * <pre>
     * The number of conflicts the SAT solver has to generate a random solution.
     * </pre>
     *
     * <code>optional int32 max_number_of_conflicts_in_random_solution_generation = 20 [default = 500];</code>
     * @return The maxNumberOfConflictsInRandomSolutionGeneration.
     */
    @java.lang.Override
    public int getMaxNumberOfConflictsInRandomSolutionGeneration() {
      return maxNumberOfConflictsInRandomSolutionGeneration_;
    }
    /**
     * <pre>
     * The number of conflicts the SAT solver has to generate a random solution.
     * </pre>
     *
     * <code>optional int32 max_number_of_conflicts_in_random_solution_generation = 20 [default = 500];</code>
     * @param value The maxNumberOfConflictsInRandomSolutionGeneration to set.
     * @return This builder for chaining.
     */
    public Builder setMaxNumberOfConflictsInRandomSolutionGeneration(int value) {

      maxNumberOfConflictsInRandomSolutionGeneration_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The number of conflicts the SAT solver has to generate a random solution.
     * </pre>
     *
     * <code>optional int32 max_number_of_conflicts_in_random_solution_generation = 20 [default = 500];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxNumberOfConflictsInRandomSolutionGeneration() {
      bitField0_ = (bitField0_ & ~0x00400000);
      maxNumberOfConflictsInRandomSolutionGeneration_ = 500;
      onChanged();
      return this;
    }

    private long maxNumberOfExploredAssignmentsPerTryInLs_ = 10000L;
    /**
     * <pre>
     * The maximum number of assignments the Local Search iterates on during one
     * try. Note that if the Local Search is called again on the same solution
     * it will not restart from scratch but will iterate on the next
     * max_number_of_explored_assignments_per_try_in_ls assignments.
     * </pre>
     *
     * <code>optional int64 max_number_of_explored_assignments_per_try_in_ls = 21 [default = 10000];</code>
     * @return Whether the maxNumberOfExploredAssignmentsPerTryInLs field is set.
     */
    @java.lang.Override
    public boolean hasMaxNumberOfExploredAssignmentsPerTryInLs() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     * <pre>
     * The maximum number of assignments the Local Search iterates on during one
     * try. Note that if the Local Search is called again on the same solution
     * it will not restart from scratch but will iterate on the next
     * max_number_of_explored_assignments_per_try_in_ls assignments.
     * </pre>
     *
     * <code>optional int64 max_number_of_explored_assignments_per_try_in_ls = 21 [default = 10000];</code>
     * @return The maxNumberOfExploredAssignmentsPerTryInLs.
     */
    @java.lang.Override
    public long getMaxNumberOfExploredAssignmentsPerTryInLs() {
      return maxNumberOfExploredAssignmentsPerTryInLs_;
    }
    /**
     * <pre>
     * The maximum number of assignments the Local Search iterates on during one
     * try. Note that if the Local Search is called again on the same solution
     * it will not restart from scratch but will iterate on the next
     * max_number_of_explored_assignments_per_try_in_ls assignments.
     * </pre>
     *
     * <code>optional int64 max_number_of_explored_assignments_per_try_in_ls = 21 [default = 10000];</code>
     * @param value The maxNumberOfExploredAssignmentsPerTryInLs to set.
     * @return This builder for chaining.
     */
    public Builder setMaxNumberOfExploredAssignmentsPerTryInLs(long value) {

      maxNumberOfExploredAssignmentsPerTryInLs_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The maximum number of assignments the Local Search iterates on during one
     * try. Note that if the Local Search is called again on the same solution
     * it will not restart from scratch but will iterate on the next
     * max_number_of_explored_assignments_per_try_in_ls assignments.
     * </pre>
     *
     * <code>optional int64 max_number_of_explored_assignments_per_try_in_ls = 21 [default = 10000];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxNumberOfExploredAssignmentsPerTryInLs() {
      bitField0_ = (bitField0_ & ~0x00800000);
      maxNumberOfExploredAssignmentsPerTryInLs_ = 10000L;
      onChanged();
      return this;
    }

    private boolean useTranspositionTableInLs_ = true;
    /**
     * <pre>
     * Whether we use an hash set during the LS to avoid exploring more than once
     * the "same" state. Note that because the underlying SAT solver may learn
     * information in the middle of the LS, this may make the LS slightly less
     * "complete", but it should be faster.
     * </pre>
     *
     * <code>optional bool use_transposition_table_in_ls = 22 [default = true];</code>
     * @return Whether the useTranspositionTableInLs field is set.
     */
    @java.lang.Override
    public boolean hasUseTranspositionTableInLs() {
      return ((bitField0_ & 0x01000000) != 0);
    }
    /**
     * <pre>
     * Whether we use an hash set during the LS to avoid exploring more than once
     * the "same" state. Note that because the underlying SAT solver may learn
     * information in the middle of the LS, this may make the LS slightly less
     * "complete", but it should be faster.
     * </pre>
     *
     * <code>optional bool use_transposition_table_in_ls = 22 [default = true];</code>
     * @return The useTranspositionTableInLs.
     */
    @java.lang.Override
    public boolean getUseTranspositionTableInLs() {
      return useTranspositionTableInLs_;
    }
    /**
     * <pre>
     * Whether we use an hash set during the LS to avoid exploring more than once
     * the "same" state. Note that because the underlying SAT solver may learn
     * information in the middle of the LS, this may make the LS slightly less
     * "complete", but it should be faster.
     * </pre>
     *
     * <code>optional bool use_transposition_table_in_ls = 22 [default = true];</code>
     * @param value The useTranspositionTableInLs to set.
     * @return This builder for chaining.
     */
    public Builder setUseTranspositionTableInLs(boolean value) {

      useTranspositionTableInLs_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we use an hash set during the LS to avoid exploring more than once
     * the "same" state. Note that because the underlying SAT solver may learn
     * information in the middle of the LS, this may make the LS slightly less
     * "complete", but it should be faster.
     * </pre>
     *
     * <code>optional bool use_transposition_table_in_ls = 22 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseTranspositionTableInLs() {
      bitField0_ = (bitField0_ & ~0x01000000);
      useTranspositionTableInLs_ = true;
      onChanged();
      return this;
    }

    private boolean usePotentialOneFlipRepairsInLs_ ;
    /**
     * <pre>
     * Whether we keep a list of variable that can potentially repair in one flip
     * all the current infeasible constraints (such variable must at least appear
     * in all the infeasible constraints for this to happen).
     * </pre>
     *
     * <code>optional bool use_potential_one_flip_repairs_in_ls = 39 [default = false];</code>
     * @return Whether the usePotentialOneFlipRepairsInLs field is set.
     */
    @java.lang.Override
    public boolean hasUsePotentialOneFlipRepairsInLs() {
      return ((bitField0_ & 0x02000000) != 0);
    }
    /**
     * <pre>
     * Whether we keep a list of variable that can potentially repair in one flip
     * all the current infeasible constraints (such variable must at least appear
     * in all the infeasible constraints for this to happen).
     * </pre>
     *
     * <code>optional bool use_potential_one_flip_repairs_in_ls = 39 [default = false];</code>
     * @return The usePotentialOneFlipRepairsInLs.
     */
    @java.lang.Override
    public boolean getUsePotentialOneFlipRepairsInLs() {
      return usePotentialOneFlipRepairsInLs_;
    }
    /**
     * <pre>
     * Whether we keep a list of variable that can potentially repair in one flip
     * all the current infeasible constraints (such variable must at least appear
     * in all the infeasible constraints for this to happen).
     * </pre>
     *
     * <code>optional bool use_potential_one_flip_repairs_in_ls = 39 [default = false];</code>
     * @param value The usePotentialOneFlipRepairsInLs to set.
     * @return This builder for chaining.
     */
    public Builder setUsePotentialOneFlipRepairsInLs(boolean value) {

      usePotentialOneFlipRepairsInLs_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we keep a list of variable that can potentially repair in one flip
     * all the current infeasible constraints (such variable must at least appear
     * in all the infeasible constraints for this to happen).
     * </pre>
     *
     * <code>optional bool use_potential_one_flip_repairs_in_ls = 39 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUsePotentialOneFlipRepairsInLs() {
      bitField0_ = (bitField0_ & ~0x02000000);
      usePotentialOneFlipRepairsInLs_ = false;
      onChanged();
      return this;
    }

    private boolean useLearnedBinaryClausesInLp_ = true;
    /**
     * <pre>
     * Whether we use the learned binary clauses in the Linear Relaxation.
     * </pre>
     *
     * <code>optional bool use_learned_binary_clauses_in_lp = 23 [default = true];</code>
     * @return Whether the useLearnedBinaryClausesInLp field is set.
     */
    @java.lang.Override
    public boolean hasUseLearnedBinaryClausesInLp() {
      return ((bitField0_ & 0x04000000) != 0);
    }
    /**
     * <pre>
     * Whether we use the learned binary clauses in the Linear Relaxation.
     * </pre>
     *
     * <code>optional bool use_learned_binary_clauses_in_lp = 23 [default = true];</code>
     * @return The useLearnedBinaryClausesInLp.
     */
    @java.lang.Override
    public boolean getUseLearnedBinaryClausesInLp() {
      return useLearnedBinaryClausesInLp_;
    }
    /**
     * <pre>
     * Whether we use the learned binary clauses in the Linear Relaxation.
     * </pre>
     *
     * <code>optional bool use_learned_binary_clauses_in_lp = 23 [default = true];</code>
     * @param value The useLearnedBinaryClausesInLp to set.
     * @return This builder for chaining.
     */
    public Builder setUseLearnedBinaryClausesInLp(boolean value) {

      useLearnedBinaryClausesInLp_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether we use the learned binary clauses in the Linear Relaxation.
     * </pre>
     *
     * <code>optional bool use_learned_binary_clauses_in_lp = 23 [default = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseLearnedBinaryClausesInLp() {
      bitField0_ = (bitField0_ & ~0x04000000);
      useLearnedBinaryClausesInLp_ = true;
      onChanged();
      return this;
    }

    private int numberOfSolvers_ = 1;
    /**
     * <pre>
     * The number of solvers used to run Bop. Note that one thread will be created
     * per solver. The type of communication between solvers is specified by the
     * synchronization_type parameter.
     * </pre>
     *
     * <code>optional int32 number_of_solvers = 24 [default = 1];</code>
     * @return Whether the numberOfSolvers field is set.
     */
    @java.lang.Override
    public boolean hasNumberOfSolvers() {
      return ((bitField0_ & 0x08000000) != 0);
    }
    /**
     * <pre>
     * The number of solvers used to run Bop. Note that one thread will be created
     * per solver. The type of communication between solvers is specified by the
     * synchronization_type parameter.
     * </pre>
     *
     * <code>optional int32 number_of_solvers = 24 [default = 1];</code>
     * @return The numberOfSolvers.
     */
    @java.lang.Override
    public int getNumberOfSolvers() {
      return numberOfSolvers_;
    }
    /**
     * <pre>
     * The number of solvers used to run Bop. Note that one thread will be created
     * per solver. The type of communication between solvers is specified by the
     * synchronization_type parameter.
     * </pre>
     *
     * <code>optional int32 number_of_solvers = 24 [default = 1];</code>
     * @param value The numberOfSolvers to set.
     * @return This builder for chaining.
     */
    public Builder setNumberOfSolvers(int value) {

      numberOfSolvers_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The number of solvers used to run Bop. Note that one thread will be created
     * per solver. The type of communication between solvers is specified by the
     * synchronization_type parameter.
     * </pre>
     *
     * <code>optional int32 number_of_solvers = 24 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearNumberOfSolvers() {
      bitField0_ = (bitField0_ & ~0x08000000);
      numberOfSolvers_ = 1;
      onChanged();
      return this;
    }

    private int synchronizationType_ = 0;
    /**
     * <code>optional .operations_research.bop.BopParameters.ThreadSynchronizationType synchronization_type = 25 [default = NO_SYNCHRONIZATION];</code>
     * @return Whether the synchronizationType field is set.
     */
    @java.lang.Override public boolean hasSynchronizationType() {
      return ((bitField0_ & 0x10000000) != 0);
    }
    /**
     * <code>optional .operations_research.bop.BopParameters.ThreadSynchronizationType synchronization_type = 25 [default = NO_SYNCHRONIZATION];</code>
     * @return The synchronizationType.
     */
    @java.lang.Override
    public com.google.ortools.bop.BopParameters.ThreadSynchronizationType getSynchronizationType() {
      com.google.ortools.bop.BopParameters.ThreadSynchronizationType result = com.google.ortools.bop.BopParameters.ThreadSynchronizationType.forNumber(synchronizationType_);
      return result == null ? com.google.ortools.bop.BopParameters.ThreadSynchronizationType.NO_SYNCHRONIZATION : result;
    }
    /**
     * <code>optional .operations_research.bop.BopParameters.ThreadSynchronizationType synchronization_type = 25 [default = NO_SYNCHRONIZATION];</code>
     * @param value The synchronizationType to set.
     * @return This builder for chaining.
     */
    public Builder setSynchronizationType(com.google.ortools.bop.BopParameters.ThreadSynchronizationType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x10000000;
      synchronizationType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .operations_research.bop.BopParameters.ThreadSynchronizationType synchronization_type = 25 [default = NO_SYNCHRONIZATION];</code>
     * @return This builder for chaining.
     */
    public Builder clearSynchronizationType() {
      bitField0_ = (bitField0_ & ~0x10000000);
      synchronizationType_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.ortools.bop.BopSolverOptimizerSet> solverOptimizerSets_ =
      java.util.Collections.emptyList();
    private void ensureSolverOptimizerSetsIsMutable() {
      if (!((bitField0_ & 0x20000000) != 0)) {
        solverOptimizerSets_ = new java.util.ArrayList<com.google.ortools.bop.BopSolverOptimizerSet>(solverOptimizerSets_);
        bitField0_ |= 0x20000000;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilder<
        com.google.ortools.bop.BopSolverOptimizerSet, com.google.ortools.bop.BopSolverOptimizerSet.Builder, com.google.ortools.bop.BopSolverOptimizerSetOrBuilder> solverOptimizerSetsBuilder_;

    /**
     * <pre>
     * List of set of optimizers to be run by the solvers.
     * Note that the i_th solver will run the
     * min(i, solver_optimizer_sets_size())_th optimizer set.
     * The default is defined by default_solver_optimizer_sets (only one set).
     * </pre>
     *
     * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
     */
    public java.util.List<com.google.ortools.bop.BopSolverOptimizerSet> getSolverOptimizerSetsList() {
      if (solverOptimizerSetsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(solverOptimizerSets_);
      } else {
        return solverOptimizerSetsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * List of set of optimizers to be run by the solvers.
     * Note that the i_th solver will run the
     * min(i, solver_optimizer_sets_size())_th optimizer set.
     * The default is defined by default_solver_optimizer_sets (only one set).
     * </pre>
     *
     * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
     */
    public int getSolverOptimizerSetsCount() {
      if (solverOptimizerSetsBuilder_ == null) {
        return solverOptimizerSets_.size();
      } else {
        return solverOptimizerSetsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * List of set of optimizers to be run by the solvers.
     * Note that the i_th solver will run the
     * min(i, solver_optimizer_sets_size())_th optimizer set.
     * The default is defined by default_solver_optimizer_sets (only one set).
     * </pre>
     *
     * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
     */
    public com.google.ortools.bop.BopSolverOptimizerSet getSolverOptimizerSets(int index) {
      if (solverOptimizerSetsBuilder_ == null) {
        return solverOptimizerSets_.get(index);
      } else {
        return solverOptimizerSetsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * List of set of optimizers to be run by the solvers.
     * Note that the i_th solver will run the
     * min(i, solver_optimizer_sets_size())_th optimizer set.
     * The default is defined by default_solver_optimizer_sets (only one set).
     * </pre>
     *
     * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
     */
    public Builder setSolverOptimizerSets(
        int index, com.google.ortools.bop.BopSolverOptimizerSet value) {
      if (solverOptimizerSetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSolverOptimizerSetsIsMutable();
        solverOptimizerSets_.set(index, value);
        onChanged();
      } else {
        solverOptimizerSetsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * List of set of optimizers to be run by the solvers.
     * Note that the i_th solver will run the
     * min(i, solver_optimizer_sets_size())_th optimizer set.
     * The default is defined by default_solver_optimizer_sets (only one set).
     * </pre>
     *
     * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
     */
    public Builder setSolverOptimizerSets(
        int index, com.google.ortools.bop.BopSolverOptimizerSet.Builder builderForValue) {
      if (solverOptimizerSetsBuilder_ == null) {
        ensureSolverOptimizerSetsIsMutable();
        solverOptimizerSets_.set(index, builderForValue.build());
        onChanged();
      } else {
        solverOptimizerSetsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * List of set of optimizers to be run by the solvers.
     * Note that the i_th solver will run the
     * min(i, solver_optimizer_sets_size())_th optimizer set.
     * The default is defined by default_solver_optimizer_sets (only one set).
     * </pre>
     *
     * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
     */
    public Builder addSolverOptimizerSets(com.google.ortools.bop.BopSolverOptimizerSet value) {
      if (solverOptimizerSetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSolverOptimizerSetsIsMutable();
        solverOptimizerSets_.add(value);
        onChanged();
      } else {
        solverOptimizerSetsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * List of set of optimizers to be run by the solvers.
     * Note that the i_th solver will run the
     * min(i, solver_optimizer_sets_size())_th optimizer set.
     * The default is defined by default_solver_optimizer_sets (only one set).
     * </pre>
     *
     * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
     */
    public Builder addSolverOptimizerSets(
        int index, com.google.ortools.bop.BopSolverOptimizerSet value) {
      if (solverOptimizerSetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSolverOptimizerSetsIsMutable();
        solverOptimizerSets_.add(index, value);
        onChanged();
      } else {
        solverOptimizerSetsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * List of set of optimizers to be run by the solvers.
     * Note that the i_th solver will run the
     * min(i, solver_optimizer_sets_size())_th optimizer set.
     * The default is defined by default_solver_optimizer_sets (only one set).
     * </pre>
     *
     * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
     */
    public Builder addSolverOptimizerSets(
        com.google.ortools.bop.BopSolverOptimizerSet.Builder builderForValue) {
      if (solverOptimizerSetsBuilder_ == null) {
        ensureSolverOptimizerSetsIsMutable();
        solverOptimizerSets_.add(builderForValue.build());
        onChanged();
      } else {
        solverOptimizerSetsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * List of set of optimizers to be run by the solvers.
     * Note that the i_th solver will run the
     * min(i, solver_optimizer_sets_size())_th optimizer set.
     * The default is defined by default_solver_optimizer_sets (only one set).
     * </pre>
     *
     * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
     */
    public Builder addSolverOptimizerSets(
        int index, com.google.ortools.bop.BopSolverOptimizerSet.Builder builderForValue) {
      if (solverOptimizerSetsBuilder_ == null) {
        ensureSolverOptimizerSetsIsMutable();
        solverOptimizerSets_.add(index, builderForValue.build());
        onChanged();
      } else {
        solverOptimizerSetsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * List of set of optimizers to be run by the solvers.
     * Note that the i_th solver will run the
     * min(i, solver_optimizer_sets_size())_th optimizer set.
     * The default is defined by default_solver_optimizer_sets (only one set).
     * </pre>
     *
     * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
     */
    public Builder addAllSolverOptimizerSets(
        java.lang.Iterable<? extends com.google.ortools.bop.BopSolverOptimizerSet> values) {
      if (solverOptimizerSetsBuilder_ == null) {
        ensureSolverOptimizerSetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, solverOptimizerSets_);
        onChanged();
      } else {
        solverOptimizerSetsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * List of set of optimizers to be run by the solvers.
     * Note that the i_th solver will run the
     * min(i, solver_optimizer_sets_size())_th optimizer set.
     * The default is defined by default_solver_optimizer_sets (only one set).
     * </pre>
     *
     * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
     */
    public Builder clearSolverOptimizerSets() {
      if (solverOptimizerSetsBuilder_ == null) {
        solverOptimizerSets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x20000000);
        onChanged();
      } else {
        solverOptimizerSetsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * List of set of optimizers to be run by the solvers.
     * Note that the i_th solver will run the
     * min(i, solver_optimizer_sets_size())_th optimizer set.
     * The default is defined by default_solver_optimizer_sets (only one set).
     * </pre>
     *
     * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
     */
    public Builder removeSolverOptimizerSets(int index) {
      if (solverOptimizerSetsBuilder_ == null) {
        ensureSolverOptimizerSetsIsMutable();
        solverOptimizerSets_.remove(index);
        onChanged();
      } else {
        solverOptimizerSetsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * List of set of optimizers to be run by the solvers.
     * Note that the i_th solver will run the
     * min(i, solver_optimizer_sets_size())_th optimizer set.
     * The default is defined by default_solver_optimizer_sets (only one set).
     * </pre>
     *
     * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
     */
    public com.google.ortools.bop.BopSolverOptimizerSet.Builder getSolverOptimizerSetsBuilder(
        int index) {
      return getSolverOptimizerSetsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * List of set of optimizers to be run by the solvers.
     * Note that the i_th solver will run the
     * min(i, solver_optimizer_sets_size())_th optimizer set.
     * The default is defined by default_solver_optimizer_sets (only one set).
     * </pre>
     *
     * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
     */
    public com.google.ortools.bop.BopSolverOptimizerSetOrBuilder getSolverOptimizerSetsOrBuilder(
        int index) {
      if (solverOptimizerSetsBuilder_ == null) {
        return solverOptimizerSets_.get(index);  } else {
        return solverOptimizerSetsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * List of set of optimizers to be run by the solvers.
     * Note that the i_th solver will run the
     * min(i, solver_optimizer_sets_size())_th optimizer set.
     * The default is defined by default_solver_optimizer_sets (only one set).
     * </pre>
     *
     * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
     */
    public java.util.List<? extends com.google.ortools.bop.BopSolverOptimizerSetOrBuilder> 
         getSolverOptimizerSetsOrBuilderList() {
      if (solverOptimizerSetsBuilder_ != null) {
        return solverOptimizerSetsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(solverOptimizerSets_);
      }
    }
    /**
     * <pre>
     * List of set of optimizers to be run by the solvers.
     * Note that the i_th solver will run the
     * min(i, solver_optimizer_sets_size())_th optimizer set.
     * The default is defined by default_solver_optimizer_sets (only one set).
     * </pre>
     *
     * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
     */
    public com.google.ortools.bop.BopSolverOptimizerSet.Builder addSolverOptimizerSetsBuilder() {
      return getSolverOptimizerSetsFieldBuilder().addBuilder(
          com.google.ortools.bop.BopSolverOptimizerSet.getDefaultInstance());
    }
    /**
     * <pre>
     * List of set of optimizers to be run by the solvers.
     * Note that the i_th solver will run the
     * min(i, solver_optimizer_sets_size())_th optimizer set.
     * The default is defined by default_solver_optimizer_sets (only one set).
     * </pre>
     *
     * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
     */
    public com.google.ortools.bop.BopSolverOptimizerSet.Builder addSolverOptimizerSetsBuilder(
        int index) {
      return getSolverOptimizerSetsFieldBuilder().addBuilder(
          index, com.google.ortools.bop.BopSolverOptimizerSet.getDefaultInstance());
    }
    /**
     * <pre>
     * List of set of optimizers to be run by the solvers.
     * Note that the i_th solver will run the
     * min(i, solver_optimizer_sets_size())_th optimizer set.
     * The default is defined by default_solver_optimizer_sets (only one set).
     * </pre>
     *
     * <code>repeated .operations_research.bop.BopSolverOptimizerSet solver_optimizer_sets = 26;</code>
     */
    public java.util.List<com.google.ortools.bop.BopSolverOptimizerSet.Builder> 
         getSolverOptimizerSetsBuilderList() {
      return getSolverOptimizerSetsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilder<
        com.google.ortools.bop.BopSolverOptimizerSet, com.google.ortools.bop.BopSolverOptimizerSet.Builder, com.google.ortools.bop.BopSolverOptimizerSetOrBuilder> 
        getSolverOptimizerSetsFieldBuilder() {
      if (solverOptimizerSetsBuilder_ == null) {
        solverOptimizerSetsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
            com.google.ortools.bop.BopSolverOptimizerSet, com.google.ortools.bop.BopSolverOptimizerSet.Builder, com.google.ortools.bop.BopSolverOptimizerSetOrBuilder>(
                solverOptimizerSets_,
                ((bitField0_ & 0x20000000) != 0),
                getParentForChildren(),
                isClean());
        solverOptimizerSets_ = null;
      }
      return solverOptimizerSetsBuilder_;
    }

    private java.lang.Object defaultSolverOptimizerSets_ = "methods:{type:LOCAL_SEARCH }                       methods:{type:RANDOM_FIRST_SOLUTION }              methods:{type:LINEAR_RELAXATION }                  methods:{type:LP_FIRST_SOLUTION }                  methods:{type:OBJECTIVE_FIRST_SOLUTION }           methods:{type:USER_GUIDED_FIRST_SOLUTION }         methods:{type:RANDOM_CONSTRAINT_LNS_GUIDED_BY_LP } methods:{type:RANDOM_VARIABLE_LNS_GUIDED_BY_LP }   methods:{type:RELATION_GRAPH_LNS }                 methods:{type:RELATION_GRAPH_LNS_GUIDED_BY_LP }    methods:{type:RANDOM_CONSTRAINT_LNS }              methods:{type:RANDOM_VARIABLE_LNS }                methods:{type:SAT_CORE_BASED }                     methods:{type:COMPLETE_LNS }                       ";
    /**
     * <code>optional string default_solver_optimizer_sets = 33 [default = "methods:{type:LOCAL_SEARCH }                       methods:{type:RANDOM_FIRST_SOLUTION }              methods:{type:LINEAR_RELAXATION }                  methods:{type:LP_FIRST_SOLUTION }                  methods:{type:OBJECTIVE_FIRST_SOLUTION }           methods:{type:USER_GUIDED_FIRST_SOLUTION }         methods:{type:RANDOM_CONSTRAINT_LNS_GUIDED_BY_LP } methods:{type:RANDOM_VARIABLE_LNS_GUIDED_BY_LP }   methods:{type:RELATION_GRAPH_LNS }                 methods:{type:RELATION_GRAPH_LNS_GUIDED_BY_LP }    methods:{type:RANDOM_CONSTRAINT_LNS }              methods:{type:RANDOM_VARIABLE_LNS }                methods:{type:SAT_CORE_BASED }                     methods:{type:COMPLETE_LNS }                       "];</code>
     * @return Whether the defaultSolverOptimizerSets field is set.
     */
    public boolean hasDefaultSolverOptimizerSets() {
      return ((bitField0_ & 0x40000000) != 0);
    }
    /**
     * <code>optional string default_solver_optimizer_sets = 33 [default = "methods:{type:LOCAL_SEARCH }                       methods:{type:RANDOM_FIRST_SOLUTION }              methods:{type:LINEAR_RELAXATION }                  methods:{type:LP_FIRST_SOLUTION }                  methods:{type:OBJECTIVE_FIRST_SOLUTION }           methods:{type:USER_GUIDED_FIRST_SOLUTION }         methods:{type:RANDOM_CONSTRAINT_LNS_GUIDED_BY_LP } methods:{type:RANDOM_VARIABLE_LNS_GUIDED_BY_LP }   methods:{type:RELATION_GRAPH_LNS }                 methods:{type:RELATION_GRAPH_LNS_GUIDED_BY_LP }    methods:{type:RANDOM_CONSTRAINT_LNS }              methods:{type:RANDOM_VARIABLE_LNS }                methods:{type:SAT_CORE_BASED }                     methods:{type:COMPLETE_LNS }                       "];</code>
     * @return The defaultSolverOptimizerSets.
     */
    public java.lang.String getDefaultSolverOptimizerSets() {
      java.lang.Object ref = defaultSolverOptimizerSets_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          defaultSolverOptimizerSets_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <code>optional string default_solver_optimizer_sets = 33 [default = "methods:{type:LOCAL_SEARCH }                       methods:{type:RANDOM_FIRST_SOLUTION }              methods:{type:LINEAR_RELAXATION }                  methods:{type:LP_FIRST_SOLUTION }                  methods:{type:OBJECTIVE_FIRST_SOLUTION }           methods:{type:USER_GUIDED_FIRST_SOLUTION }         methods:{type:RANDOM_CONSTRAINT_LNS_GUIDED_BY_LP } methods:{type:RANDOM_VARIABLE_LNS_GUIDED_BY_LP }   methods:{type:RELATION_GRAPH_LNS }                 methods:{type:RELATION_GRAPH_LNS_GUIDED_BY_LP }    methods:{type:RANDOM_CONSTRAINT_LNS }              methods:{type:RANDOM_VARIABLE_LNS }                methods:{type:SAT_CORE_BASED }                     methods:{type:COMPLETE_LNS }                       "];</code>
     * @return The bytes for defaultSolverOptimizerSets.
     */
    public com.google.protobuf.ByteString
        getDefaultSolverOptimizerSetsBytes() {
      java.lang.Object ref = defaultSolverOptimizerSets_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        defaultSolverOptimizerSets_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <code>optional string default_solver_optimizer_sets = 33 [default = "methods:{type:LOCAL_SEARCH }                       methods:{type:RANDOM_FIRST_SOLUTION }              methods:{type:LINEAR_RELAXATION }                  methods:{type:LP_FIRST_SOLUTION }                  methods:{type:OBJECTIVE_FIRST_SOLUTION }           methods:{type:USER_GUIDED_FIRST_SOLUTION }         methods:{type:RANDOM_CONSTRAINT_LNS_GUIDED_BY_LP } methods:{type:RANDOM_VARIABLE_LNS_GUIDED_BY_LP }   methods:{type:RELATION_GRAPH_LNS }                 methods:{type:RELATION_GRAPH_LNS_GUIDED_BY_LP }    methods:{type:RANDOM_CONSTRAINT_LNS }              methods:{type:RANDOM_VARIABLE_LNS }                methods:{type:SAT_CORE_BASED }                     methods:{type:COMPLETE_LNS }                       "];</code>
     * @param value The defaultSolverOptimizerSets to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultSolverOptimizerSets(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      defaultSolverOptimizerSets_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     * <code>optional string default_solver_optimizer_sets = 33 [default = "methods:{type:LOCAL_SEARCH }                       methods:{type:RANDOM_FIRST_SOLUTION }              methods:{type:LINEAR_RELAXATION }                  methods:{type:LP_FIRST_SOLUTION }                  methods:{type:OBJECTIVE_FIRST_SOLUTION }           methods:{type:USER_GUIDED_FIRST_SOLUTION }         methods:{type:RANDOM_CONSTRAINT_LNS_GUIDED_BY_LP } methods:{type:RANDOM_VARIABLE_LNS_GUIDED_BY_LP }   methods:{type:RELATION_GRAPH_LNS }                 methods:{type:RELATION_GRAPH_LNS_GUIDED_BY_LP }    methods:{type:RANDOM_CONSTRAINT_LNS }              methods:{type:RANDOM_VARIABLE_LNS }                methods:{type:SAT_CORE_BASED }                     methods:{type:COMPLETE_LNS }                       "];</code>
     * @return This builder for chaining.
     */
    public Builder clearDefaultSolverOptimizerSets() {
      defaultSolverOptimizerSets_ = getDefaultInstance().getDefaultSolverOptimizerSets();
      bitField0_ = (bitField0_ & ~0x40000000);
      onChanged();
      return this;
    }
    /**
     * <code>optional string default_solver_optimizer_sets = 33 [default = "methods:{type:LOCAL_SEARCH }                       methods:{type:RANDOM_FIRST_SOLUTION }              methods:{type:LINEAR_RELAXATION }                  methods:{type:LP_FIRST_SOLUTION }                  methods:{type:OBJECTIVE_FIRST_SOLUTION }           methods:{type:USER_GUIDED_FIRST_SOLUTION }         methods:{type:RANDOM_CONSTRAINT_LNS_GUIDED_BY_LP } methods:{type:RANDOM_VARIABLE_LNS_GUIDED_BY_LP }   methods:{type:RELATION_GRAPH_LNS }                 methods:{type:RELATION_GRAPH_LNS_GUIDED_BY_LP }    methods:{type:RANDOM_CONSTRAINT_LNS }              methods:{type:RANDOM_VARIABLE_LNS }                methods:{type:SAT_CORE_BASED }                     methods:{type:COMPLETE_LNS }                       "];</code>
     * @param value The bytes for defaultSolverOptimizerSets to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultSolverOptimizerSetsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      defaultSolverOptimizerSets_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }

    private boolean useLpStrongBranching_ ;
    /**
     * <pre>
     * Use strong branching in the linear relaxation optimizer.
     * The strong branching is a what-if analysis on each variable v, i.e.
     * compute the best bound when v is assigned to true, compute the best bound
     * when v is assigned to false, and then use those best bounds to improve the
     * overall best bound.
     * This is useful to improve the best_bound, but also to fix some variables
     * during search.
     * Note that using probing might be time consuming as it runs the LP solver
     * 2 * num_variables times.
     * </pre>
     *
     * <code>optional bool use_lp_strong_branching = 29 [default = false];</code>
     * @return Whether the useLpStrongBranching field is set.
     */
    @java.lang.Override
    public boolean hasUseLpStrongBranching() {
      return ((bitField0_ & 0x80000000) != 0);
    }
    /**
     * <pre>
     * Use strong branching in the linear relaxation optimizer.
     * The strong branching is a what-if analysis on each variable v, i.e.
     * compute the best bound when v is assigned to true, compute the best bound
     * when v is assigned to false, and then use those best bounds to improve the
     * overall best bound.
     * This is useful to improve the best_bound, but also to fix some variables
     * during search.
     * Note that using probing might be time consuming as it runs the LP solver
     * 2 * num_variables times.
     * </pre>
     *
     * <code>optional bool use_lp_strong_branching = 29 [default = false];</code>
     * @return The useLpStrongBranching.
     */
    @java.lang.Override
    public boolean getUseLpStrongBranching() {
      return useLpStrongBranching_;
    }
    /**
     * <pre>
     * Use strong branching in the linear relaxation optimizer.
     * The strong branching is a what-if analysis on each variable v, i.e.
     * compute the best bound when v is assigned to true, compute the best bound
     * when v is assigned to false, and then use those best bounds to improve the
     * overall best bound.
     * This is useful to improve the best_bound, but also to fix some variables
     * during search.
     * Note that using probing might be time consuming as it runs the LP solver
     * 2 * num_variables times.
     * </pre>
     *
     * <code>optional bool use_lp_strong_branching = 29 [default = false];</code>
     * @param value The useLpStrongBranching to set.
     * @return This builder for chaining.
     */
    public Builder setUseLpStrongBranching(boolean value) {

      useLpStrongBranching_ = value;
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Use strong branching in the linear relaxation optimizer.
     * The strong branching is a what-if analysis on each variable v, i.e.
     * compute the best bound when v is assigned to true, compute the best bound
     * when v is assigned to false, and then use those best bounds to improve the
     * overall best bound.
     * This is useful to improve the best_bound, but also to fix some variables
     * during search.
     * Note that using probing might be time consuming as it runs the LP solver
     * 2 * num_variables times.
     * </pre>
     *
     * <code>optional bool use_lp_strong_branching = 29 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearUseLpStrongBranching() {
      bitField0_ = (bitField0_ & ~0x80000000);
      useLpStrongBranching_ = false;
      onChanged();
      return this;
    }

    private int decomposerNumVariablesThreshold_ = 50;
    /**
     * <pre>
     * Only try to decompose the problem when the number of variables is greater
     * than the threshold.
     * </pre>
     *
     * <code>optional int32 decomposer_num_variables_threshold = 30 [default = 50];</code>
     * @return Whether the decomposerNumVariablesThreshold field is set.
     */
    @java.lang.Override
    public boolean hasDecomposerNumVariablesThreshold() {
      return ((bitField1_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Only try to decompose the problem when the number of variables is greater
     * than the threshold.
     * </pre>
     *
     * <code>optional int32 decomposer_num_variables_threshold = 30 [default = 50];</code>
     * @return The decomposerNumVariablesThreshold.
     */
    @java.lang.Override
    public int getDecomposerNumVariablesThreshold() {
      return decomposerNumVariablesThreshold_;
    }
    /**
     * <pre>
     * Only try to decompose the problem when the number of variables is greater
     * than the threshold.
     * </pre>
     *
     * <code>optional int32 decomposer_num_variables_threshold = 30 [default = 50];</code>
     * @param value The decomposerNumVariablesThreshold to set.
     * @return This builder for chaining.
     */
    public Builder setDecomposerNumVariablesThreshold(int value) {

      decomposerNumVariablesThreshold_ = value;
      bitField1_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Only try to decompose the problem when the number of variables is greater
     * than the threshold.
     * </pre>
     *
     * <code>optional int32 decomposer_num_variables_threshold = 30 [default = 50];</code>
     * @return This builder for chaining.
     */
    public Builder clearDecomposerNumVariablesThreshold() {
      bitField1_ = (bitField1_ & ~0x00000001);
      decomposerNumVariablesThreshold_ = 50;
      onChanged();
      return this;
    }

    private int numBopSolversUsedByDecomposition_ = 1;
    /**
     * <pre>
     * The number of BopSolver created (thread pool workers) used by the integral
     * solver to solve a decomposed problem.
     * TODO(user): Merge this with the number_of_solvers parameter.
     * </pre>
     *
     * <code>optional int32 num_bop_solvers_used_by_decomposition = 31 [default = 1];</code>
     * @return Whether the numBopSolversUsedByDecomposition field is set.
     */
    @java.lang.Override
    public boolean hasNumBopSolversUsedByDecomposition() {
      return ((bitField1_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * The number of BopSolver created (thread pool workers) used by the integral
     * solver to solve a decomposed problem.
     * TODO(user): Merge this with the number_of_solvers parameter.
     * </pre>
     *
     * <code>optional int32 num_bop_solvers_used_by_decomposition = 31 [default = 1];</code>
     * @return The numBopSolversUsedByDecomposition.
     */
    @java.lang.Override
    public int getNumBopSolversUsedByDecomposition() {
      return numBopSolversUsedByDecomposition_;
    }
    /**
     * <pre>
     * The number of BopSolver created (thread pool workers) used by the integral
     * solver to solve a decomposed problem.
     * TODO(user): Merge this with the number_of_solvers parameter.
     * </pre>
     *
     * <code>optional int32 num_bop_solvers_used_by_decomposition = 31 [default = 1];</code>
     * @param value The numBopSolversUsedByDecomposition to set.
     * @return This builder for chaining.
     */
    public Builder setNumBopSolversUsedByDecomposition(int value) {

      numBopSolversUsedByDecomposition_ = value;
      bitField1_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The number of BopSolver created (thread pool workers) used by the integral
     * solver to solve a decomposed problem.
     * TODO(user): Merge this with the number_of_solvers parameter.
     * </pre>
     *
     * <code>optional int32 num_bop_solvers_used_by_decomposition = 31 [default = 1];</code>
     * @return This builder for chaining.
     */
    public Builder clearNumBopSolversUsedByDecomposition() {
      bitField1_ = (bitField1_ & ~0x00000002);
      numBopSolversUsedByDecomposition_ = 1;
      onChanged();
      return this;
    }

    private double decomposedProblemMinTimeInSeconds_ ;
    /**
     * <pre>
     * HACK. To avoid spending too little time on small problems, spend at least
     * this time solving each of the decomposed sub-problem. This only make sense
     * if num_bop_solvers_used_by_decomposition is greater than 1 so that the
     * overhead can be "absorbed" by the other threads.
     * </pre>
     *
     * <code>optional double decomposed_problem_min_time_in_seconds = 36 [default = 0];</code>
     * @return Whether the decomposedProblemMinTimeInSeconds field is set.
     */
    @java.lang.Override
    public boolean hasDecomposedProblemMinTimeInSeconds() {
      return ((bitField1_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * HACK. To avoid spending too little time on small problems, spend at least
     * this time solving each of the decomposed sub-problem. This only make sense
     * if num_bop_solvers_used_by_decomposition is greater than 1 so that the
     * overhead can be "absorbed" by the other threads.
     * </pre>
     *
     * <code>optional double decomposed_problem_min_time_in_seconds = 36 [default = 0];</code>
     * @return The decomposedProblemMinTimeInSeconds.
     */
    @java.lang.Override
    public double getDecomposedProblemMinTimeInSeconds() {
      return decomposedProblemMinTimeInSeconds_;
    }
    /**
     * <pre>
     * HACK. To avoid spending too little time on small problems, spend at least
     * this time solving each of the decomposed sub-problem. This only make sense
     * if num_bop_solvers_used_by_decomposition is greater than 1 so that the
     * overhead can be "absorbed" by the other threads.
     * </pre>
     *
     * <code>optional double decomposed_problem_min_time_in_seconds = 36 [default = 0];</code>
     * @param value The decomposedProblemMinTimeInSeconds to set.
     * @return This builder for chaining.
     */
    public Builder setDecomposedProblemMinTimeInSeconds(double value) {

      decomposedProblemMinTimeInSeconds_ = value;
      bitField1_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * HACK. To avoid spending too little time on small problems, spend at least
     * this time solving each of the decomposed sub-problem. This only make sense
     * if num_bop_solvers_used_by_decomposition is greater than 1 so that the
     * overhead can be "absorbed" by the other threads.
     * </pre>
     *
     * <code>optional double decomposed_problem_min_time_in_seconds = 36 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearDecomposedProblemMinTimeInSeconds() {
      bitField1_ = (bitField1_ & ~0x00000004);
      decomposedProblemMinTimeInSeconds_ = 0D;
      onChanged();
      return this;
    }

    private int guidedSatConflictsChunk_ = 1000;
    /**
     * <pre>
     * The first solutions based on guided SAT will work in chunk of that many
     * conflicts at the time. This allows to simulate parallelism between the
     * different guiding strategy on a single core.
     * </pre>
     *
     * <code>optional int32 guided_sat_conflicts_chunk = 34 [default = 1000];</code>
     * @return Whether the guidedSatConflictsChunk field is set.
     */
    @java.lang.Override
    public boolean hasGuidedSatConflictsChunk() {
      return ((bitField1_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * The first solutions based on guided SAT will work in chunk of that many
     * conflicts at the time. This allows to simulate parallelism between the
     * different guiding strategy on a single core.
     * </pre>
     *
     * <code>optional int32 guided_sat_conflicts_chunk = 34 [default = 1000];</code>
     * @return The guidedSatConflictsChunk.
     */
    @java.lang.Override
    public int getGuidedSatConflictsChunk() {
      return guidedSatConflictsChunk_;
    }
    /**
     * <pre>
     * The first solutions based on guided SAT will work in chunk of that many
     * conflicts at the time. This allows to simulate parallelism between the
     * different guiding strategy on a single core.
     * </pre>
     *
     * <code>optional int32 guided_sat_conflicts_chunk = 34 [default = 1000];</code>
     * @param value The guidedSatConflictsChunk to set.
     * @return This builder for chaining.
     */
    public Builder setGuidedSatConflictsChunk(int value) {

      guidedSatConflictsChunk_ = value;
      bitField1_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The first solutions based on guided SAT will work in chunk of that many
     * conflicts at the time. This allows to simulate parallelism between the
     * different guiding strategy on a single core.
     * </pre>
     *
     * <code>optional int32 guided_sat_conflicts_chunk = 34 [default = 1000];</code>
     * @return This builder for chaining.
     */
    public Builder clearGuidedSatConflictsChunk() {
      bitField1_ = (bitField1_ & ~0x00000008);
      guidedSatConflictsChunk_ = 1000;
      onChanged();
      return this;
    }

    private int maxLpSolveForFeasibilityProblems_ ;
    /**
     * <pre>
     * The maximum number of time the LP solver will run to feasibility for pure
     * feasibility problems (with a constant-valued objective function). Set this
     * to a small value, e.g., 1, if fractional solutions offer useful guidance to
     * other solvers in the portfolio. A negative value means no limit.
     * </pre>
     *
     * <code>optional int32 max_lp_solve_for_feasibility_problems = 41 [default = 0];</code>
     * @return Whether the maxLpSolveForFeasibilityProblems field is set.
     */
    @java.lang.Override
    public boolean hasMaxLpSolveForFeasibilityProblems() {
      return ((bitField1_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * The maximum number of time the LP solver will run to feasibility for pure
     * feasibility problems (with a constant-valued objective function). Set this
     * to a small value, e.g., 1, if fractional solutions offer useful guidance to
     * other solvers in the portfolio. A negative value means no limit.
     * </pre>
     *
     * <code>optional int32 max_lp_solve_for_feasibility_problems = 41 [default = 0];</code>
     * @return The maxLpSolveForFeasibilityProblems.
     */
    @java.lang.Override
    public int getMaxLpSolveForFeasibilityProblems() {
      return maxLpSolveForFeasibilityProblems_;
    }
    /**
     * <pre>
     * The maximum number of time the LP solver will run to feasibility for pure
     * feasibility problems (with a constant-valued objective function). Set this
     * to a small value, e.g., 1, if fractional solutions offer useful guidance to
     * other solvers in the portfolio. A negative value means no limit.
     * </pre>
     *
     * <code>optional int32 max_lp_solve_for_feasibility_problems = 41 [default = 0];</code>
     * @param value The maxLpSolveForFeasibilityProblems to set.
     * @return This builder for chaining.
     */
    public Builder setMaxLpSolveForFeasibilityProblems(int value) {

      maxLpSolveForFeasibilityProblems_ = value;
      bitField1_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The maximum number of time the LP solver will run to feasibility for pure
     * feasibility problems (with a constant-valued objective function). Set this
     * to a small value, e.g., 1, if fractional solutions offer useful guidance to
     * other solvers in the portfolio. A negative value means no limit.
     * </pre>
     *
     * <code>optional int32 max_lp_solve_for_feasibility_problems = 41 [default = 0];</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxLpSolveForFeasibilityProblems() {
      bitField1_ = (bitField1_ & ~0x00000010);
      maxLpSolveForFeasibilityProblems_ = 0;
      onChanged();
      return this;
    }

    // @@protoc_insertion_point(builder_scope:operations_research.bop.BopParameters)
  }

  // @@protoc_insertion_point(class_scope:operations_research.bop.BopParameters)
  private static final com.google.ortools.bop.BopParameters DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ortools.bop.BopParameters();
  }

  public static com.google.ortools.bop.BopParameters getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BopParameters>
      PARSER = new com.google.protobuf.AbstractParser<BopParameters>() {
    @java.lang.Override
    public BopParameters parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<BopParameters> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BopParameters> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ortools.bop.BopParameters getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

