/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.2.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.google.ortools.constraintsolver;

/**
 *  The class IntExpr is the base of all integer expressions in<br>
 *  constraint programming.<br>
 *  It contains the basic protocol for an expression:<br>
 *    - setting and modifying its bound<br>
 *    - querying if it is bound<br>
 *    - listening to events modifying its bounds<br>
 *    - casting it into a variable (instance of IntVar)
 */
public class IntExpr extends PropagationBaseObject {
  private transient long swigCPtr;

  public IntExpr(long cPtr, boolean cMemoryOwn) {
    super(mainJNI.IntExpr_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  public static long getCPtr(IntExpr obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  public static long swigRelease(IntExpr obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        mainJNI.delete_IntExpr(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  public long min() {
    return mainJNI.IntExpr_min(swigCPtr, this);
  }

  public void setMin(long m) {
    mainJNI.IntExpr_setMin(swigCPtr, this, m);
  }

  public long max() {
    return mainJNI.IntExpr_max(swigCPtr, this);
  }

  public void setMax(long m) {
    mainJNI.IntExpr_setMax(swigCPtr, this, m);
  }

  /**
   *  By default calls Min() and Max(), but can be redefined when Min and Max<br>
   *  code can be factorized.
   */
  public void range(long[] l, long[] u) {
    mainJNI.IntExpr_range(swigCPtr, this, l, u);
  }

  /**
   *  This method sets both the min and the max of the expression.
   */
  public void setRange(long l, long u) {
    mainJNI.IntExpr_setRange(swigCPtr, this, l, u);
  }

  /**
   *  This method sets the value of the expression.
   */
  public void setValue(long v) {
    mainJNI.IntExpr_setValue(swigCPtr, this, v);
  }

  /**
   *  Returns true if the min and the max of the expression are equal.
   */
  public boolean bound() {
    return mainJNI.IntExpr_bound(swigCPtr, this);
  }

  /**
   *  Returns true if the expression is indeed a variable.
   */
  public boolean isVar() {
    return mainJNI.IntExpr_isVar(swigCPtr, this);
  }

  /**
   *  Creates a variable from the expression.
   */
  public IntVar var() {
    long cPtr = mainJNI.IntExpr_var(swigCPtr, this);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  Creates a variable from the expression and set the name of the<br>
   *  resulting var. If the expression is already a variable, then it<br>
   *  will set the name of the expression, possibly overwriting it.<br>
   *  This is just a shortcut to Var() followed by set_name().
   */
  public IntVar varWithName(String name) {
    long cPtr = mainJNI.IntExpr_varWithName(swigCPtr, this, name);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  Attach a demon that will watch the min or the max of the expression.
   */
  public void whenRange(Demon d) {
    mainJNI.IntExpr_whenRange__SWIG_0(swigCPtr, this, Demon.getCPtr(d), d);
  }

  /**
   *  Attach a demon that will watch the min or the max of the expression.
   */
  public void whenRange(Runnable closure) {
    mainJNI.IntExpr_whenRange__SWIG_1(swigCPtr, this, closure);
  }

  /**
   *  Accepts the given visitor.
   */
  public void accept(ModelVisitor visitor) {
    mainJNI.IntExpr_accept(swigCPtr, this, ModelVisitor.getCPtr(visitor), visitor);
  }

}
