/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.2.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.google.ortools.linearsolver;

import java.lang.reflect.*;

/**
 * The class for constraints of a Mathematical Programming (MP) model.<br>
 * <br>
 * A constraint is represented as a linear equation or inequality.
 */
public class MPConstraint {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected MPConstraint(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(MPConstraint obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(MPConstraint obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        mainJNI.delete_MPConstraint(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
   *  Returns the name of the constraint.
   */
  public String name() {
    return mainJNI.MPConstraint_name(swigCPtr, this);
  }

  /**
   * Sets the coefficient of the variable on the constraint.<br>
   * <br>
   * If the variable does not belong to the solver, the function just returns,<br>
   * or crashes in non-opt mode.
   */
  public void setCoefficient(MPVariable var, double coeff) {
    mainJNI.MPConstraint_setCoefficient(swigCPtr, this, MPVariable.getCPtr(var), var, coeff);
  }

  /**
   * Gets the coefficient of a given variable on the constraint (which is 0 if<br>
   * the variable does not appear in the constraint).
   */
  public double getCoefficient(MPVariable var) {
    return mainJNI.MPConstraint_getCoefficient(swigCPtr, this, MPVariable.getCPtr(var), var);
  }

  /**
   *  Returns the lower bound.
   */
  public double lb() {
    return mainJNI.MPConstraint_lb(swigCPtr, this);
  }

  /**
   *  Returns the upper bound.
   */
  public double ub() {
    return mainJNI.MPConstraint_ub(swigCPtr, this);
  }

  /**
   *  Sets the lower bound.
   */
  public void setLb(double lb) {
    mainJNI.MPConstraint_setLb(swigCPtr, this, lb);
  }

  /**
   *  Sets the upper bound.
   */
  public void setUb(double ub) {
    mainJNI.MPConstraint_setUb(swigCPtr, this, ub);
  }

  /**
   *  Sets both the lower and upper bounds.
   */
  public void setBounds(double lb, double ub) {
    mainJNI.MPConstraint_setBounds(swigCPtr, this, lb, ub);
  }

  /**
   *  Advanced usage: returns true if the constraint is "lazy" (see below).
   */
  public boolean isLazy() {
    return mainJNI.MPConstraint_isLazy(swigCPtr, this);
  }

  /**
   * Advanced usage: sets the constraint "laziness".<br>
   * <br>
   * <em>This is only supported for SCIP and has no effect on other<br>
   * solvers.</em><br>
   * <br>
   * When <b>laziness</b> is true, the constraint is only considered by the Linear<br>
   * Programming solver if its current solution violates the constraint. In this<br>
   * case, the constraint is definitively added to the problem. This may be<br>
   * useful in some MIP problems, and may have a dramatic impact on performance.<br>
   * <br>
   * For more info see: http://tinyurl.com/lazy-constraints.
   */
  public void setIsLazy(boolean laziness) {
    mainJNI.MPConstraint_setIsLazy(swigCPtr, this, laziness);
  }

  /**
   *  Returns the index of the constraint in the MPSolver::constraints_.
   */
  public int index() {
    return mainJNI.MPConstraint_index(swigCPtr, this);
  }

  /**
   * Advanced usage: returns the dual value of the constraint in the current<br>
   * solution (only available for continuous problems).
   */
  public double dualValue() {
    return mainJNI.MPConstraint_dualValue(swigCPtr, this);
  }

  /**
   * Advanced usage: returns the basis status of the constraint.<br>
   * <br>
   * It is only available for continuous problems).<br>
   * <br>
   * Note that if a constraint "linear_expression in [lb, ub]" is transformed<br>
   * into "linear_expression + slack = 0" with slack in [-ub, -lb], then this<br>
   * status is the same as the status of the slack variable with AT_UPPER_BOUND<br>
   * and AT_LOWER_BOUND swapped.<br>
   * <br>
   * @see MPSolver#BasisStatus.
   */
  public MPSolver.BasisStatus basisStatus() {
    return MPSolver.BasisStatus.swigToEnum(mainJNI.MPConstraint_basisStatus(swigCPtr, this));
  }

}
