// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: ortools/linear_solver/linear_solver.proto
// Protobuf Java Version: 4.29.3

package com.google.ortools.linearsolver;

/**
 * <pre>
 * A linear constraint is always of the form:
 * lower_bound &lt;= sum of linear term elements &lt;= upper_bound,
 * where lower_bound and upper_bound:
 * - Can form a singleton: lower_bound == upper_bound. The constraint is an
 * equation.
 * - Can form a finite interval [lower_bound, upper_bound]. The constraint is
 * both lower- and upper-bounded, i.e. "boxed".
 * - Can form a semi-infinite interval. lower_bound = -infinity: the constraint
 * is upper-bounded. upper_bound = +infinity: the constraint is lower-bounded.
 * - Can form the infinite interval: lower_bound = -infinity and
 * upper_bound = +infinity. The constraint is free.
 * </pre>
 *
 * Protobuf type {@code operations_research.MPConstraintProto}
 */
public final class MPConstraintProto extends
    com.google.protobuf.GeneratedMessage implements
    // @@protoc_insertion_point(message_implements:operations_research.MPConstraintProto)
    MPConstraintProtoOrBuilder {
private static final long serialVersionUID = 0L;
  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
      com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
      /* major= */ 4,
      /* minor= */ 29,
      /* patch= */ 3,
      /* suffix= */ "",
      MPConstraintProto.class.getName());
  }
  // Use MPConstraintProto.newBuilder() to construct.
  private MPConstraintProto(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }
  private MPConstraintProto() {
    varIndex_ = emptyIntList();
    coefficient_ = emptyDoubleList();
    lowerBound_ = Double.NEGATIVE_INFINITY;
    upperBound_ = Double.POSITIVE_INFINITY;
    name_ = "";
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ortools.linearsolver.LinearSolver.internal_static_operations_research_MPConstraintProto_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ortools.linearsolver.LinearSolver.internal_static_operations_research_MPConstraintProto_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ortools.linearsolver.MPConstraintProto.class, com.google.ortools.linearsolver.MPConstraintProto.Builder.class);
  }

  private int bitField0_;
  public static final int VAR_INDEX_FIELD_NUMBER = 6;
  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.IntList varIndex_ =
      emptyIntList();
  /**
   * <pre>
   * var_index[i] is the variable index (w.r.t. to "variable" field of
   * MPModelProto) of the i-th linear term involved in this constraint, and
   * coefficient[i] is its coefficient. Only the terms with non-zero
   * coefficients need to appear. var_index may not contain duplicates.
   * </pre>
   *
   * <code>repeated int32 var_index = 6 [packed = true];</code>
   * @return A list containing the varIndex.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer>
      getVarIndexList() {
    return varIndex_;
  }
  /**
   * <pre>
   * var_index[i] is the variable index (w.r.t. to "variable" field of
   * MPModelProto) of the i-th linear term involved in this constraint, and
   * coefficient[i] is its coefficient. Only the terms with non-zero
   * coefficients need to appear. var_index may not contain duplicates.
   * </pre>
   *
   * <code>repeated int32 var_index = 6 [packed = true];</code>
   * @return The count of varIndex.
   */
  public int getVarIndexCount() {
    return varIndex_.size();
  }
  /**
   * <pre>
   * var_index[i] is the variable index (w.r.t. to "variable" field of
   * MPModelProto) of the i-th linear term involved in this constraint, and
   * coefficient[i] is its coefficient. Only the terms with non-zero
   * coefficients need to appear. var_index may not contain duplicates.
   * </pre>
   *
   * <code>repeated int32 var_index = 6 [packed = true];</code>
   * @param index The index of the element to return.
   * @return The varIndex at the given index.
   */
  public int getVarIndex(int index) {
    return varIndex_.getInt(index);
  }
  private int varIndexMemoizedSerializedSize = -1;

  public static final int COEFFICIENT_FIELD_NUMBER = 7;
  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.DoubleList coefficient_ =
      emptyDoubleList();
  /**
   * <pre>
   * Must be finite.
   * </pre>
   *
   * <code>repeated double coefficient = 7 [packed = true];</code>
   * @return A list containing the coefficient.
   */
  @java.lang.Override
  public java.util.List<java.lang.Double>
      getCoefficientList() {
    return coefficient_;
  }
  /**
   * <pre>
   * Must be finite.
   * </pre>
   *
   * <code>repeated double coefficient = 7 [packed = true];</code>
   * @return The count of coefficient.
   */
  public int getCoefficientCount() {
    return coefficient_.size();
  }
  /**
   * <pre>
   * Must be finite.
   * </pre>
   *
   * <code>repeated double coefficient = 7 [packed = true];</code>
   * @param index The index of the element to return.
   * @return The coefficient at the given index.
   */
  public double getCoefficient(int index) {
    return coefficient_.getDouble(index);
  }
  private int coefficientMemoizedSerializedSize = -1;

  public static final int LOWER_BOUND_FIELD_NUMBER = 2;
  private double lowerBound_ = Double.NEGATIVE_INFINITY;
  /**
   * <pre>
   * lower_bound must be &lt;= upper_bound.
   * </pre>
   *
   * <code>optional double lower_bound = 2 [default = -inf];</code>
   * @return Whether the lowerBound field is set.
   */
  @java.lang.Override
  public boolean hasLowerBound() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * lower_bound must be &lt;= upper_bound.
   * </pre>
   *
   * <code>optional double lower_bound = 2 [default = -inf];</code>
   * @return The lowerBound.
   */
  @java.lang.Override
  public double getLowerBound() {
    return lowerBound_;
  }

  public static final int UPPER_BOUND_FIELD_NUMBER = 3;
  private double upperBound_ = Double.POSITIVE_INFINITY;
  /**
   * <code>optional double upper_bound = 3 [default = inf];</code>
   * @return Whether the upperBound field is set.
   */
  @java.lang.Override
  public boolean hasUpperBound() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <code>optional double upper_bound = 3 [default = inf];</code>
   * @return The upperBound.
   */
  @java.lang.Override
  public double getUpperBound() {
    return upperBound_;
  }

  public static final int NAME_FIELD_NUMBER = 4;
  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   * <pre>
   * The name of the constraint.
   * </pre>
   *
   * <code>optional string name = 4 [default = ""];</code>
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * The name of the constraint.
   * </pre>
   *
   * <code>optional string name = 4 [default = ""];</code>
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (bs.isValidUtf8()) {
        name_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * The name of the constraint.
   * </pre>
   *
   * <code>optional string name = 4 [default = ""];</code>
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IS_LAZY_FIELD_NUMBER = 5;
  private boolean isLazy_ = false;
  /**
   * <pre>
   * [Advanced usage: do not use this if you don't know what you're doing.]
   * A lazy constraint is handled differently by the core solving engine, but
   * it does not change the result. It may or may not impact the performance.
   * For more info see: http://tinyurl.com/lazy-constraints.
   * </pre>
   *
   * <code>optional bool is_lazy = 5 [default = false];</code>
   * @return Whether the isLazy field is set.
   */
  @java.lang.Override
  public boolean hasIsLazy() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * [Advanced usage: do not use this if you don't know what you're doing.]
   * A lazy constraint is handled differently by the core solving engine, but
   * it does not change the result. It may or may not impact the performance.
   * For more info see: http://tinyurl.com/lazy-constraints.
   * </pre>
   *
   * <code>optional bool is_lazy = 5 [default = false];</code>
   * @return The isLazy.
   */
  @java.lang.Override
  public boolean getIsLazy() {
    return isLazy_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeDouble(2, lowerBound_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeDouble(3, upperBound_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 4, name_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeBool(5, isLazy_);
    }
    if (getVarIndexList().size() > 0) {
      output.writeUInt32NoTag(50);
      output.writeUInt32NoTag(varIndexMemoizedSerializedSize);
    }
    for (int i = 0; i < varIndex_.size(); i++) {
      output.writeInt32NoTag(varIndex_.getInt(i));
    }
    if (getCoefficientList().size() > 0) {
      output.writeUInt32NoTag(58);
      output.writeUInt32NoTag(coefficientMemoizedSerializedSize);
    }
    for (int i = 0; i < coefficient_.size(); i++) {
      output.writeDoubleNoTag(coefficient_.getDouble(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(2, lowerBound_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(3, upperBound_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(4, name_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(5, isLazy_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < varIndex_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeInt32SizeNoTag(varIndex_.getInt(i));
      }
      size += dataSize;
      if (!getVarIndexList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(dataSize);
      }
      varIndexMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      dataSize = 8 * getCoefficientList().size();
      size += dataSize;
      if (!getCoefficientList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(dataSize);
      }
      coefficientMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ortools.linearsolver.MPConstraintProto)) {
      return super.equals(obj);
    }
    com.google.ortools.linearsolver.MPConstraintProto other = (com.google.ortools.linearsolver.MPConstraintProto) obj;

    if (!getVarIndexList()
        .equals(other.getVarIndexList())) return false;
    if (!getCoefficientList()
        .equals(other.getCoefficientList())) return false;
    if (hasLowerBound() != other.hasLowerBound()) return false;
    if (hasLowerBound()) {
      if (java.lang.Double.doubleToLongBits(getLowerBound())
          != java.lang.Double.doubleToLongBits(
              other.getLowerBound())) return false;
    }
    if (hasUpperBound() != other.hasUpperBound()) return false;
    if (hasUpperBound()) {
      if (java.lang.Double.doubleToLongBits(getUpperBound())
          != java.lang.Double.doubleToLongBits(
              other.getUpperBound())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName()
          .equals(other.getName())) return false;
    }
    if (hasIsLazy() != other.hasIsLazy()) return false;
    if (hasIsLazy()) {
      if (getIsLazy()
          != other.getIsLazy()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getVarIndexCount() > 0) {
      hash = (37 * hash) + VAR_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getVarIndexList().hashCode();
    }
    if (getCoefficientCount() > 0) {
      hash = (37 * hash) + COEFFICIENT_FIELD_NUMBER;
      hash = (53 * hash) + getCoefficientList().hashCode();
    }
    if (hasLowerBound()) {
      hash = (37 * hash) + LOWER_BOUND_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getLowerBound()));
    }
    if (hasUpperBound()) {
      hash = (37 * hash) + UPPER_BOUND_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getUpperBound()));
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasIsLazy()) {
      hash = (37 * hash) + IS_LAZY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getIsLazy());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ortools.linearsolver.MPConstraintProto parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.linearsolver.MPConstraintProto parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.linearsolver.MPConstraintProto parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.linearsolver.MPConstraintProto parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.linearsolver.MPConstraintProto parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.linearsolver.MPConstraintProto parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.linearsolver.MPConstraintProto parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.linearsolver.MPConstraintProto parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ortools.linearsolver.MPConstraintProto parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ortools.linearsolver.MPConstraintProto parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ortools.linearsolver.MPConstraintProto parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.linearsolver.MPConstraintProto parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ortools.linearsolver.MPConstraintProto prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A linear constraint is always of the form:
   * lower_bound &lt;= sum of linear term elements &lt;= upper_bound,
   * where lower_bound and upper_bound:
   * - Can form a singleton: lower_bound == upper_bound. The constraint is an
   * equation.
   * - Can form a finite interval [lower_bound, upper_bound]. The constraint is
   * both lower- and upper-bounded, i.e. "boxed".
   * - Can form a semi-infinite interval. lower_bound = -infinity: the constraint
   * is upper-bounded. upper_bound = +infinity: the constraint is lower-bounded.
   * - Can form the infinite interval: lower_bound = -infinity and
   * upper_bound = +infinity. The constraint is free.
   * </pre>
   *
   * Protobuf type {@code operations_research.MPConstraintProto}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessage.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:operations_research.MPConstraintProto)
      com.google.ortools.linearsolver.MPConstraintProtoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ortools.linearsolver.LinearSolver.internal_static_operations_research_MPConstraintProto_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ortools.linearsolver.LinearSolver.internal_static_operations_research_MPConstraintProto_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ortools.linearsolver.MPConstraintProto.class, com.google.ortools.linearsolver.MPConstraintProto.Builder.class);
    }

    // Construct using com.google.ortools.linearsolver.MPConstraintProto.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      varIndex_ = emptyIntList();
      coefficient_ = emptyDoubleList();
      lowerBound_ = Double.NEGATIVE_INFINITY;
      upperBound_ = Double.POSITIVE_INFINITY;
      name_ = "";
      isLazy_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ortools.linearsolver.LinearSolver.internal_static_operations_research_MPConstraintProto_descriptor;
    }

    @java.lang.Override
    public com.google.ortools.linearsolver.MPConstraintProto getDefaultInstanceForType() {
      return com.google.ortools.linearsolver.MPConstraintProto.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ortools.linearsolver.MPConstraintProto build() {
      com.google.ortools.linearsolver.MPConstraintProto result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ortools.linearsolver.MPConstraintProto buildPartial() {
      com.google.ortools.linearsolver.MPConstraintProto result = new com.google.ortools.linearsolver.MPConstraintProto(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.ortools.linearsolver.MPConstraintProto result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        varIndex_.makeImmutable();
        result.varIndex_ = varIndex_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        coefficient_.makeImmutable();
        result.coefficient_ = coefficient_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.lowerBound_ = lowerBound_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.upperBound_ = upperBound_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.isLazy_ = isLazy_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ortools.linearsolver.MPConstraintProto) {
        return mergeFrom((com.google.ortools.linearsolver.MPConstraintProto)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ortools.linearsolver.MPConstraintProto other) {
      if (other == com.google.ortools.linearsolver.MPConstraintProto.getDefaultInstance()) return this;
      if (!other.varIndex_.isEmpty()) {
        if (varIndex_.isEmpty()) {
          varIndex_ = other.varIndex_;
          varIndex_.makeImmutable();
          bitField0_ |= 0x00000001;
        } else {
          ensureVarIndexIsMutable();
          varIndex_.addAll(other.varIndex_);
        }
        onChanged();
      }
      if (!other.coefficient_.isEmpty()) {
        if (coefficient_.isEmpty()) {
          coefficient_ = other.coefficient_;
          coefficient_.makeImmutable();
          bitField0_ |= 0x00000002;
        } else {
          ensureCoefficientIsMutable();
          coefficient_.addAll(other.coefficient_);
        }
        onChanged();
      }
      if (other.hasLowerBound()) {
        setLowerBound(other.getLowerBound());
      }
      if (other.hasUpperBound()) {
        setUpperBound(other.getUpperBound());
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasIsLazy()) {
        setIsLazy(other.getIsLazy());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 17: {
              lowerBound_ = input.readDouble();
              bitField0_ |= 0x00000004;
              break;
            } // case 17
            case 25: {
              upperBound_ = input.readDouble();
              bitField0_ |= 0x00000008;
              break;
            } // case 25
            case 34: {
              name_ = input.readBytes();
              bitField0_ |= 0x00000010;
              break;
            } // case 34
            case 40: {
              isLazy_ = input.readBool();
              bitField0_ |= 0x00000020;
              break;
            } // case 40
            case 48: {
              int v = input.readInt32();
              ensureVarIndexIsMutable();
              varIndex_.addInt(v);
              break;
            } // case 48
            case 50: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              ensureVarIndexIsMutable();
              while (input.getBytesUntilLimit() > 0) {
                varIndex_.addInt(input.readInt32());
              }
              input.popLimit(limit);
              break;
            } // case 50
            case 57: {
              double v = input.readDouble();
              ensureCoefficientIsMutable();
              coefficient_.addDouble(v);
              break;
            } // case 57
            case 58: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              int alloc = length > 4096 ? 4096 : length;
              ensureCoefficientIsMutable(alloc / 8);
              while (input.getBytesUntilLimit() > 0) {
                coefficient_.addDouble(input.readDouble());
              }
              input.popLimit(limit);
              break;
            } // case 58
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private com.google.protobuf.Internal.IntList varIndex_ = emptyIntList();
    private void ensureVarIndexIsMutable() {
      if (!varIndex_.isModifiable()) {
        varIndex_ = makeMutableCopy(varIndex_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     * <pre>
     * var_index[i] is the variable index (w.r.t. to "variable" field of
     * MPModelProto) of the i-th linear term involved in this constraint, and
     * coefficient[i] is its coefficient. Only the terms with non-zero
     * coefficients need to appear. var_index may not contain duplicates.
     * </pre>
     *
     * <code>repeated int32 var_index = 6 [packed = true];</code>
     * @return A list containing the varIndex.
     */
    public java.util.List<java.lang.Integer>
        getVarIndexList() {
      varIndex_.makeImmutable();
      return varIndex_;
    }
    /**
     * <pre>
     * var_index[i] is the variable index (w.r.t. to "variable" field of
     * MPModelProto) of the i-th linear term involved in this constraint, and
     * coefficient[i] is its coefficient. Only the terms with non-zero
     * coefficients need to appear. var_index may not contain duplicates.
     * </pre>
     *
     * <code>repeated int32 var_index = 6 [packed = true];</code>
     * @return The count of varIndex.
     */
    public int getVarIndexCount() {
      return varIndex_.size();
    }
    /**
     * <pre>
     * var_index[i] is the variable index (w.r.t. to "variable" field of
     * MPModelProto) of the i-th linear term involved in this constraint, and
     * coefficient[i] is its coefficient. Only the terms with non-zero
     * coefficients need to appear. var_index may not contain duplicates.
     * </pre>
     *
     * <code>repeated int32 var_index = 6 [packed = true];</code>
     * @param index The index of the element to return.
     * @return The varIndex at the given index.
     */
    public int getVarIndex(int index) {
      return varIndex_.getInt(index);
    }
    /**
     * <pre>
     * var_index[i] is the variable index (w.r.t. to "variable" field of
     * MPModelProto) of the i-th linear term involved in this constraint, and
     * coefficient[i] is its coefficient. Only the terms with non-zero
     * coefficients need to appear. var_index may not contain duplicates.
     * </pre>
     *
     * <code>repeated int32 var_index = 6 [packed = true];</code>
     * @param index The index to set the value at.
     * @param value The varIndex to set.
     * @return This builder for chaining.
     */
    public Builder setVarIndex(
        int index, int value) {

      ensureVarIndexIsMutable();
      varIndex_.setInt(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * var_index[i] is the variable index (w.r.t. to "variable" field of
     * MPModelProto) of the i-th linear term involved in this constraint, and
     * coefficient[i] is its coefficient. Only the terms with non-zero
     * coefficients need to appear. var_index may not contain duplicates.
     * </pre>
     *
     * <code>repeated int32 var_index = 6 [packed = true];</code>
     * @param value The varIndex to add.
     * @return This builder for chaining.
     */
    public Builder addVarIndex(int value) {

      ensureVarIndexIsMutable();
      varIndex_.addInt(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * var_index[i] is the variable index (w.r.t. to "variable" field of
     * MPModelProto) of the i-th linear term involved in this constraint, and
     * coefficient[i] is its coefficient. Only the terms with non-zero
     * coefficients need to appear. var_index may not contain duplicates.
     * </pre>
     *
     * <code>repeated int32 var_index = 6 [packed = true];</code>
     * @param values The varIndex to add.
     * @return This builder for chaining.
     */
    public Builder addAllVarIndex(
        java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureVarIndexIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, varIndex_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * var_index[i] is the variable index (w.r.t. to "variable" field of
     * MPModelProto) of the i-th linear term involved in this constraint, and
     * coefficient[i] is its coefficient. Only the terms with non-zero
     * coefficients need to appear. var_index may not contain duplicates.
     * </pre>
     *
     * <code>repeated int32 var_index = 6 [packed = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearVarIndex() {
      varIndex_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.DoubleList coefficient_ = emptyDoubleList();
    private void ensureCoefficientIsMutable() {
      if (!coefficient_.isModifiable()) {
        coefficient_ = makeMutableCopy(coefficient_);
      }
      bitField0_ |= 0x00000002;
    }
    private void ensureCoefficientIsMutable(int capacity) {
      if (!coefficient_.isModifiable()) {
        coefficient_ = makeMutableCopy(coefficient_, capacity);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     * <pre>
     * Must be finite.
     * </pre>
     *
     * <code>repeated double coefficient = 7 [packed = true];</code>
     * @return A list containing the coefficient.
     */
    public java.util.List<java.lang.Double>
        getCoefficientList() {
      coefficient_.makeImmutable();
      return coefficient_;
    }
    /**
     * <pre>
     * Must be finite.
     * </pre>
     *
     * <code>repeated double coefficient = 7 [packed = true];</code>
     * @return The count of coefficient.
     */
    public int getCoefficientCount() {
      return coefficient_.size();
    }
    /**
     * <pre>
     * Must be finite.
     * </pre>
     *
     * <code>repeated double coefficient = 7 [packed = true];</code>
     * @param index The index of the element to return.
     * @return The coefficient at the given index.
     */
    public double getCoefficient(int index) {
      return coefficient_.getDouble(index);
    }
    /**
     * <pre>
     * Must be finite.
     * </pre>
     *
     * <code>repeated double coefficient = 7 [packed = true];</code>
     * @param index The index to set the value at.
     * @param value The coefficient to set.
     * @return This builder for chaining.
     */
    public Builder setCoefficient(
        int index, double value) {

      ensureCoefficientIsMutable();
      coefficient_.setDouble(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Must be finite.
     * </pre>
     *
     * <code>repeated double coefficient = 7 [packed = true];</code>
     * @param value The coefficient to add.
     * @return This builder for chaining.
     */
    public Builder addCoefficient(double value) {

      ensureCoefficientIsMutable();
      coefficient_.addDouble(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Must be finite.
     * </pre>
     *
     * <code>repeated double coefficient = 7 [packed = true];</code>
     * @param values The coefficient to add.
     * @return This builder for chaining.
     */
    public Builder addAllCoefficient(
        java.lang.Iterable<? extends java.lang.Double> values) {
      ensureCoefficientIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, coefficient_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Must be finite.
     * </pre>
     *
     * <code>repeated double coefficient = 7 [packed = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearCoefficient() {
      coefficient_ = emptyDoubleList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    private double lowerBound_ = Double.NEGATIVE_INFINITY;
    /**
     * <pre>
     * lower_bound must be &lt;= upper_bound.
     * </pre>
     *
     * <code>optional double lower_bound = 2 [default = -inf];</code>
     * @return Whether the lowerBound field is set.
     */
    @java.lang.Override
    public boolean hasLowerBound() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * lower_bound must be &lt;= upper_bound.
     * </pre>
     *
     * <code>optional double lower_bound = 2 [default = -inf];</code>
     * @return The lowerBound.
     */
    @java.lang.Override
    public double getLowerBound() {
      return lowerBound_;
    }
    /**
     * <pre>
     * lower_bound must be &lt;= upper_bound.
     * </pre>
     *
     * <code>optional double lower_bound = 2 [default = -inf];</code>
     * @param value The lowerBound to set.
     * @return This builder for chaining.
     */
    public Builder setLowerBound(double value) {

      lowerBound_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * lower_bound must be &lt;= upper_bound.
     * </pre>
     *
     * <code>optional double lower_bound = 2 [default = -inf];</code>
     * @return This builder for chaining.
     */
    public Builder clearLowerBound() {
      bitField0_ = (bitField0_ & ~0x00000004);
      lowerBound_ = Double.NEGATIVE_INFINITY;
      onChanged();
      return this;
    }

    private double upperBound_ = Double.POSITIVE_INFINITY;
    /**
     * <code>optional double upper_bound = 3 [default = inf];</code>
     * @return Whether the upperBound field is set.
     */
    @java.lang.Override
    public boolean hasUpperBound() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <code>optional double upper_bound = 3 [default = inf];</code>
     * @return The upperBound.
     */
    @java.lang.Override
    public double getUpperBound() {
      return upperBound_;
    }
    /**
     * <code>optional double upper_bound = 3 [default = inf];</code>
     * @param value The upperBound to set.
     * @return This builder for chaining.
     */
    public Builder setUpperBound(double value) {

      upperBound_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <code>optional double upper_bound = 3 [default = inf];</code>
     * @return This builder for chaining.
     */
    public Builder clearUpperBound() {
      bitField0_ = (bitField0_ & ~0x00000008);
      upperBound_ = Double.POSITIVE_INFINITY;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * The name of the constraint.
     * </pre>
     *
     * <code>optional string name = 4 [default = ""];</code>
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * The name of the constraint.
     * </pre>
     *
     * <code>optional string name = 4 [default = ""];</code>
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The name of the constraint.
     * </pre>
     *
     * <code>optional string name = 4 [default = ""];</code>
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The name of the constraint.
     * </pre>
     *
     * <code>optional string name = 4 [default = ""];</code>
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The name of the constraint.
     * </pre>
     *
     * <code>optional string name = 4 [default = ""];</code>
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The name of the constraint.
     * </pre>
     *
     * <code>optional string name = 4 [default = ""];</code>
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private boolean isLazy_ ;
    /**
     * <pre>
     * [Advanced usage: do not use this if you don't know what you're doing.]
     * A lazy constraint is handled differently by the core solving engine, but
     * it does not change the result. It may or may not impact the performance.
     * For more info see: http://tinyurl.com/lazy-constraints.
     * </pre>
     *
     * <code>optional bool is_lazy = 5 [default = false];</code>
     * @return Whether the isLazy field is set.
     */
    @java.lang.Override
    public boolean hasIsLazy() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * [Advanced usage: do not use this if you don't know what you're doing.]
     * A lazy constraint is handled differently by the core solving engine, but
     * it does not change the result. It may or may not impact the performance.
     * For more info see: http://tinyurl.com/lazy-constraints.
     * </pre>
     *
     * <code>optional bool is_lazy = 5 [default = false];</code>
     * @return The isLazy.
     */
    @java.lang.Override
    public boolean getIsLazy() {
      return isLazy_;
    }
    /**
     * <pre>
     * [Advanced usage: do not use this if you don't know what you're doing.]
     * A lazy constraint is handled differently by the core solving engine, but
     * it does not change the result. It may or may not impact the performance.
     * For more info see: http://tinyurl.com/lazy-constraints.
     * </pre>
     *
     * <code>optional bool is_lazy = 5 [default = false];</code>
     * @param value The isLazy to set.
     * @return This builder for chaining.
     */
    public Builder setIsLazy(boolean value) {

      isLazy_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [Advanced usage: do not use this if you don't know what you're doing.]
     * A lazy constraint is handled differently by the core solving engine, but
     * it does not change the result. It may or may not impact the performance.
     * For more info see: http://tinyurl.com/lazy-constraints.
     * </pre>
     *
     * <code>optional bool is_lazy = 5 [default = false];</code>
     * @return This builder for chaining.
     */
    public Builder clearIsLazy() {
      bitField0_ = (bitField0_ & ~0x00000020);
      isLazy_ = false;
      onChanged();
      return this;
    }

    // @@protoc_insertion_point(builder_scope:operations_research.MPConstraintProto)
  }

  // @@protoc_insertion_point(class_scope:operations_research.MPConstraintProto)
  private static final com.google.ortools.linearsolver.MPConstraintProto DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ortools.linearsolver.MPConstraintProto();
  }

  public static com.google.ortools.linearsolver.MPConstraintProto getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MPConstraintProto>
      PARSER = new com.google.protobuf.AbstractParser<MPConstraintProto>() {
    @java.lang.Override
    public MPConstraintProto parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<MPConstraintProto> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MPConstraintProto> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ortools.linearsolver.MPConstraintProto getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

