/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.2.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.google.ortools.linearsolver;

import java.lang.reflect.*;

/**
 * This mathematical programming (MP) solver class is the main class<br>
 * though which users build and solve problems.
 */
public class MPSolver {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected MPSolver(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(MPSolver obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(MPSolver obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        mainJNI.delete_MPSolver(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
   * Creates and returns an array of variables.
   */
  public MPVariable[] makeVarArray(int count, double lb, double ub, boolean integer) {
    MPVariable[] array = new MPVariable[count];
    for (int i = 0; i < count; ++i) {
      array[i] = makeVar(lb, ub, integer, "");
    }
    return array;
  }

  /**
   * Creates and returns an array of named variables.
   */
  public MPVariable[] makeVarArray(int count, double lb, double ub, boolean integer,
                                   String var_name) {
    MPVariable[] array = new MPVariable[count];
    for (int i = 0; i < count; ++i) {
      array[i] = makeVar(lb, ub, integer, var_name + i);
    }
    return array;
  }

  public MPVariable[] makeNumVarArray(int count, double lb, double ub) {
    return makeVarArray(count, lb, ub, false);
  }

  public MPVariable[] makeNumVarArray(int count, double lb, double ub, String var_name) {
    return makeVarArray(count, lb, ub, false, var_name);
  }

  public MPVariable[] makeIntVarArray(int count, double lb, double ub) {
    return makeVarArray(count, lb, ub, true);
  }

  public MPVariable[] makeIntVarArray(int count, double lb, double ub, String var_name) {
    return makeVarArray(count, lb, ub, true, var_name);
  }

  public MPVariable[] makeBoolVarArray(int count) {
    return makeVarArray(count, 0.0, 1.0, true);
  }

  public MPVariable[] makeBoolVarArray(int count, String var_name) {
    return makeVarArray(count, 0.0, 1.0, true, var_name);
  }

  /**
   *  Create a solver with the given name and underlying solver backend.
   */
  public MPSolver(String name, MPSolver.OptimizationProblemType problem_type) {
    this(mainJNI.new_MPSolver(name, problem_type.swigValue()), true);
  }

  /**
   * Recommended factory method to create a MPSolver instance, especially in<br>
   * non C++ languages.<br>
   * <br>
   * It returns a newly created solver instance if successful, or a nullptr<br>
   * otherwise. This can occur if the relevant interface is not linked in, or if<br>
   * a needed license is not accessible for commercial solvers.<br>
   * <br>
   * Ownership of the solver is passed on to the caller of this method.<br>
   * It will accept both string names of the OptimizationProblemType enum, as<br>
   * well as a short version (i.e. "SCIP_MIXED_INTEGER_PROGRAMMING" or "SCIP").<br>
   * <br>
   * solver_id is case insensitive, and the following names are supported:<br>
   *   - CLP_LINEAR_PROGRAMMING or CLP<br>
   *   - CBC_MIXED_INTEGER_PROGRAMMING or CBC<br>
   *   - GLOP_LINEAR_PROGRAMMING or GLOP<br>
   *   - BOP_INTEGER_PROGRAMMING or BOP<br>
   *   - SAT_INTEGER_PROGRAMMING or SAT or CP_SAT<br>
   *   - SCIP_MIXED_INTEGER_PROGRAMMING or SCIP<br>
   *   - GUROBI_LINEAR_PROGRAMMING or GUROBI_LP<br>
   *   - GUROBI_MIXED_INTEGER_PROGRAMMING or GUROBI or GUROBI_MIP<br>
   *   - CPLEX_LINEAR_PROGRAMMING or CPLEX_LP<br>
   *   - CPLEX_MIXED_INTEGER_PROGRAMMING or CPLEX or CPLEX_MIP<br>
   *   - XPRESS_LINEAR_PROGRAMMING or XPRESS_LP<br>
   *   - XPRESS_MIXED_INTEGER_PROGRAMMING or XPRESS or XPRESS_MIP<br>
   *   - GLPK_LINEAR_PROGRAMMING or GLPK_LP<br>
   *   - GLPK_MIXED_INTEGER_PROGRAMMING or GLPK or GLPK_MIP
   */
  public static MPSolver createSolver(String solver_id) {
    long cPtr = mainJNI.MPSolver_createSolver(solver_id);
    return (cPtr == 0) ? null : new MPSolver(cPtr, true);
  }

  /**
   * Whether the given problem type is supported (this will depend on the<br>
   * targets that you linked).
   */
  public static boolean supportsProblemType(MPSolver.OptimizationProblemType problem_type) {
    return mainJNI.MPSolver_supportsProblemType(problem_type.swigValue());
  }

  public boolean isMip() {
    return mainJNI.MPSolver_isMip(swigCPtr, this);
  }

  /**
   *  Returns the optimization problem type set at construction.
   */
  public MPSolver.OptimizationProblemType problemType() {
    return MPSolver.OptimizationProblemType.swigToEnum(mainJNI.MPSolver_problemType(swigCPtr, this));
  }

  /**
   * Clears the objective (including the optimization direction), all variables<br>
   * and constraints. All the other properties of the MPSolver (like the time<br>
   * limit) are kept untouched.
   */
  public void clear() {
    mainJNI.MPSolver_clear(swigCPtr, this);
  }

  /**
   *  Returns the number of variables.
   */
  public int numVariables() {
    return mainJNI.MPSolver_numVariables(swigCPtr, this);
  }

  /**
   * Returns the array of variables handled by the MPSolver. (They are listed in<br>
   * the order in which they were created.)
   */
  public MPVariable[] variables() {
  return mainJNI.MPSolver_variables(swigCPtr, this);
}

  /**
   * Returns the variable at position index.
   */
  public MPVariable variable(int index) {
    long cPtr = mainJNI.MPSolver_variable(swigCPtr, this, index);
    return (cPtr == 0) ? null : new MPVariable(cPtr, false);
  }

  /**
   * Looks up a variable by name, and returns nullptr if it does not exist. The<br>
   * first call has a O(n) complexity, as the variable name index is lazily<br>
   * created upon first use. Will crash if variable names are not unique.
   */
  public MPVariable lookupVariableOrNull(String var_name) {
    long cPtr = mainJNI.MPSolver_lookupVariableOrNull(swigCPtr, this, var_name);
    return (cPtr == 0) ? null : new MPVariable(cPtr, false);
  }

  /**
   * Creates a variable with the given bounds, integrality requirement and<br>
   * name. Bounds can be finite or +/- MPSolver::infinity(). The MPSolver owns<br>
   * the variable (i.e. the returned pointer is borrowed). Variable names are<br>
   * optional. If you give an empty name, name() will auto-generate one for you<br>
   * upon request.
   */
  public MPVariable makeVar(double lb, double ub, boolean integer, String name) {
    long cPtr = mainJNI.MPSolver_makeVar(swigCPtr, this, lb, ub, integer, name);
    return (cPtr == 0) ? null : new MPVariable(cPtr, false);
  }

  /**
   *  Creates a continuous variable.
   */
  public MPVariable makeNumVar(double lb, double ub, String name) {
    long cPtr = mainJNI.MPSolver_makeNumVar(swigCPtr, this, lb, ub, name);
    return (cPtr == 0) ? null : new MPVariable(cPtr, false);
  }

  /**
   *  Creates an integer variable.
   */
  public MPVariable makeIntVar(double lb, double ub, String name) {
    long cPtr = mainJNI.MPSolver_makeIntVar(swigCPtr, this, lb, ub, name);
    return (cPtr == 0) ? null : new MPVariable(cPtr, false);
  }

  /**
   *  Creates a boolean variable.
   */
  public MPVariable makeBoolVar(String name) {
    long cPtr = mainJNI.MPSolver_makeBoolVar(swigCPtr, this, name);
    return (cPtr == 0) ? null : new MPVariable(cPtr, false);
  }

  /**
   *  Returns the number of constraints.
   */
  public int numConstraints() {
    return mainJNI.MPSolver_numConstraints(swigCPtr, this);
  }

  /**
   * Returns the array of constraints handled by the MPSolver.<br>
   * <br>
   * They are listed in the order in which they were created.
   */
  public MPConstraint[] constraints() {
  return mainJNI.MPSolver_constraints(swigCPtr, this);
}

  /**
   *  Returns the constraint at the given index. 
   */
  public MPConstraint constraint(int index) {
    long cPtr = mainJNI.MPSolver_constraint(swigCPtr, this, index);
    return (cPtr == 0) ? null : new MPConstraint(cPtr, false);
  }

  /**
   *  Looks up a constraint by name, and returns nullptr if it does not exist.<br>
   * <br>
   * The first call has a O(n) complexity, as the constraint name index is<br>
   * lazily created upon first use. Will crash if constraint names are not<br>
   * unique.
   */
  public MPConstraint lookupConstraintOrNull(String constraint_name) {
    long cPtr = mainJNI.MPSolver_lookupConstraintOrNull(swigCPtr, this, constraint_name);
    return (cPtr == 0) ? null : new MPConstraint(cPtr, false);
  }

  /**
   * Creates a linear constraint with given bounds.<br>
   * <br>
   * Bounds can be finite or +/- MPSolver::infinity(). The MPSolver class<br>
   * assumes ownership of the constraint.<br>
   * <br>
   * @return a pointer to the newly created constraint.
   */
  public MPConstraint makeConstraint(double lb, double ub) {
    long cPtr = mainJNI.MPSolver_makeConstraint__SWIG_0(swigCPtr, this, lb, ub);
    return (cPtr == 0) ? null : new MPConstraint(cPtr, false);
  }

  /**
   *  Creates a constraint with -infinity and +infinity bounds.
   */
  public MPConstraint makeConstraint() {
    long cPtr = mainJNI.MPSolver_makeConstraint__SWIG_1(swigCPtr, this);
    return (cPtr == 0) ? null : new MPConstraint(cPtr, false);
  }

  /**
   *  Creates a named constraint with given bounds.
   */
  public MPConstraint makeConstraint(double lb, double ub, String name) {
    long cPtr = mainJNI.MPSolver_makeConstraint__SWIG_2(swigCPtr, this, lb, ub, name);
    return (cPtr == 0) ? null : new MPConstraint(cPtr, false);
  }

  /**
   *  Creates a named constraint with -infinity and +infinity bounds.
   */
  public MPConstraint makeConstraint(String name) {
    long cPtr = mainJNI.MPSolver_makeConstraint__SWIG_3(swigCPtr, this, name);
    return (cPtr == 0) ? null : new MPConstraint(cPtr, false);
  }

  /**
   *  Returns the mutable objective object.
   */
  public MPObjective objective() {
    long cPtr = mainJNI.MPSolver_objective(swigCPtr, this);
    return (cPtr == 0) ? null : new MPObjective(cPtr, false);
  }

  /**
   *  Solves the problem using the default parameter values.
   */
  public MPSolver.ResultStatus solve() {
    return MPSolver.ResultStatus.swigToEnum(mainJNI.MPSolver_solve__SWIG_0(swigCPtr, this));
  }

  /**
   *  Solves the problem using the specified parameter values.
   */
  public MPSolver.ResultStatus solve(MPSolverParameters param) {
    return MPSolver.ResultStatus.swigToEnum(mainJNI.MPSolver_solve__SWIG_1(swigCPtr, this, MPSolverParameters.getCPtr(param), param));
  }

  /**
   * Writes the model using the solver internal write function.  Currently only<br>
   * available for Gurobi.
   */
  public void write(String file_name) {
    mainJNI.MPSolver_write(swigCPtr, this, file_name);
  }

  /**
   * Advanced usage: compute the "activities" of all constraints, which are the<br>
   * sums of their linear terms. The activities are returned in the same order<br>
   * as constraints(), which is the order in which constraints were added; but<br>
   * you can also use MPConstraint::index() to get a constraint's index.
   */
  public double[] computeConstraintActivities() {
  return mainJNI.MPSolver_computeConstraintActivities(swigCPtr, this);
}

  /**
   * Advanced usage: Verifies the *correctness* of the solution.<br>
   * <br>
   * It verifies that all variables must be within their domains, all<br>
   * constraints must be satisfied, and the reported objective value must be<br>
   * accurate.<br>
   * <br>
   * Usage:<br>
   * - This can only be called after Solve() was called.<br>
   * - "tolerance" is interpreted as an absolute error threshold.<br>
   * - For the objective value only, if the absolute error is too large,<br>
   *   the tolerance is interpreted as a relative error threshold instead.<br>
   * - If "log_errors" is true, every single violation will be logged.<br>
   * - If "tolerance" is negative, it will be set to infinity().<br>
   * <br>
   * Most users should just set the --verify_solution flag and not bother using<br>
   * this method directly.
   */
  public boolean verifySolution(double tolerance, boolean log_errors) {
    return mainJNI.MPSolver_verifySolution(swigCPtr, this, tolerance, log_errors);
  }

  /**
   * Advanced usage: resets extracted model to solve from scratch.<br>
   * <br>
   * This won't reset the parameters that were set with<br>
   * SetSolverSpecificParametersAsString() or set_time_limit() or even clear the<br>
   * linear program. It will just make sure that next Solve() will be as if<br>
   * everything was reconstructed from scratch.
   */
  public void reset() {
    mainJNI.MPSolver_reset(swigCPtr, this);
  }

  /**
   *  Interrupts the Solve() execution to terminate processing if possible.<br>
   * <br>
   * If the underlying interface supports interruption; it does that and returns<br>
   * true regardless of whether there's an ongoing Solve() or not. The Solve()<br>
   * call may still linger for a while depending on the conditions.  If<br>
   * interruption is not supported; returns false and does nothing.<br>
   * MPSolver::SolverTypeSupportsInterruption can be used to check if<br>
   * interruption is supported for a given solver type.
   */
  public boolean interruptSolve() {
    return mainJNI.MPSolver_interruptSolve(swigCPtr, this);
  }

  /**
   * Advanced usage: pass solver specific parameters in text format.<br>
   * <br>
   * The format is solver-specific and is the same as the corresponding solver<br>
   * configuration file format. Returns true if the operation was successful.
   */
  public boolean setSolverSpecificParametersAsString(String parameters) {
    return mainJNI.MPSolver_setSolverSpecificParametersAsString(swigCPtr, this, parameters);
  }

  /**
   * Infinity.<br>
   * <br>
   * You can use -MPSolver::infinity() for negative infinity.
   */
  public static double infinity() {
    return mainJNI.MPSolver_infinity();
  }

  /**
   *  Enables solver logging.
   */
  public void enableOutput() {
    mainJNI.MPSolver_enableOutput(swigCPtr, this);
  }

  /**
   *  Suppresses solver logging.
   */
  public void suppressOutput() {
    mainJNI.MPSolver_suppressOutput(swigCPtr, this);
  }

  /**
   *  Returns the number of simplex iterations.
   */
  public long iterations() {
    return mainJNI.MPSolver_iterations(swigCPtr, this);
  }

  /**
   * Returns the number of branch-and-bound nodes evaluated during the solve.<br>
   * <br>
   * Only available for discrete problems.
   */
  public long nodes() {
    return mainJNI.MPSolver_nodes(swigCPtr, this);
  }

  /**
   *  Returns a string describing the underlying solver and its version.
   */
  public String solverVersion() {
    return mainJNI.MPSolver_solverVersion(swigCPtr, this);
  }

  /**
   *  Advanced usage: computes the exact condition number of the current scaled<br>
   * basis: L1norm(B) * L1norm(inverse(B)), where B is the scaled basis.<br>
   * <br>
   * This method requires that a basis exists: it should be called after Solve.<br>
   * It is only available for continuous problems. It is implemented for GLPK<br>
   * but not CLP because CLP does not provide the API for doing it.<br>
   * <br>
   * The condition number measures how well the constraint matrix is conditioned<br>
   * and can be used to predict whether numerical issues will arise during the<br>
   * solve: the model is declared infeasible whereas it is feasible (or<br>
   * vice-versa), the solution obtained is not optimal or violates some<br>
   * constraints, the resolution is slow because of repeated singularities.<br>
   * <br>
   * The rule of thumb to interpret the condition number kappa is:<br>
   *   - o kappa &lt;= 1e7: virtually no chance of numerical issues<br>
   *   - o 1e7 &lt; kappa &lt;= 1e10: small chance of numerical issues<br>
   *   - o 1e10 &lt; kappa &lt;= 1e13: medium chance of numerical issues<br>
   *   - o kappa &gt; 1e13: high chance of numerical issues<br>
   * <br>
   * The computation of the condition number depends on the quality of the LU<br>
   * decomposition, so it is not very accurate when the matrix is ill<br>
   * conditioned.
   */
  public double computeExactConditionNumber() {
    return mainJNI.MPSolver_computeExactConditionNumber(swigCPtr, this);
  }

  public void setTimeLimit(long time_limit_milliseconds) {
    mainJNI.MPSolver_setTimeLimit(swigCPtr, this, time_limit_milliseconds);
  }

  public long wallTime() {
    return mainJNI.MPSolver_wallTime(swigCPtr, this);
  }

  /**
   * Loads a model and returns the error message, which will be empty iff the<br>
   * model is valid. Clears all names (see also loadModelFromProtoKeepNames()).
   */
  public String loadModelFromProto(com.google.ortools.linearsolver.MPModelProto input_model) {
    return mainJNI.MPSolver_loadModelFromProto(swigCPtr, this, input_model.toByteArray());
  }

  /**
   * Like loadModelFromProto(), but keeps the names and returns an error if<br>
   * there are duplicate names.
   */
  public String loadModelFromProtoKeepNames(com.google.ortools.linearsolver.MPModelProto input_model) {
    return mainJNI.MPSolver_loadModelFromProtoKeepNames(swigCPtr, this, input_model.toByteArray());
  }

  public String loadModelFromProtoWithUniqueNamesOrDie(com.google.ortools.linearsolver.MPModelProto input_model) {
    return mainJNI.MPSolver_loadModelFromProtoWithUniqueNamesOrDie(swigCPtr, this, input_model.toByteArray());
  }

  /**
   * Export the loaded model to proto and returns it.
   */
  public com.google.ortools.linearsolver.MPModelProto exportModelToProto() {
  byte[] buf = mainJNI.MPSolver_exportModelToProto(swigCPtr, this);
  if (buf == null || buf.length == 0) {
    return null;
  }
  try {
    return com.google.ortools.linearsolver.MPModelProto.parseFrom(buf);
  } catch (com.google.protobuf.InvalidProtocolBufferException e) {
    throw new RuntimeException(
        "Unable to parse com.google.ortools.linearsolver.MPModelProto protocol message.");
  }
}

  /**
   * Fills the solution found to a response proto and returns it.
   */
  public com.google.ortools.linearsolver.MPSolutionResponse createSolutionResponseProto() {
  byte[] buf = mainJNI.MPSolver_createSolutionResponseProto(swigCPtr, this);
  if (buf == null || buf.length == 0) {
    return null;
  }
  try {
    return com.google.ortools.linearsolver.MPSolutionResponse.parseFrom(buf);
  } catch (com.google.protobuf.InvalidProtocolBufferException e) {
    throw new RuntimeException(
        "Unable to parse com.google.ortools.linearsolver.MPSolutionResponse protocol message.");
  }
}

  /**
   * Load a solution encoded in a protocol buffer onto this solver for easy<br>
   *   access via the MPSolver interface.<br>
   * <br>
   * IMPORTANT: This may only be used in conjunction with ExportModel(),<br>
   *   following this example:<br>
   * <br>
   *    {@code 
       MPSolver my_solver;
       ... add variables and constraints ...
       MPModelProto model_proto;
       my_solver.ExportModelToProto(&model_proto);
       MPSolutionResponse solver_response;
       MPSolver::SolveWithProto(model_proto, &solver_response);
       if (solver_response.result_status() == MPSolutionResponse::OPTIMAL) {
         CHECK_OK(my_solver.LoadSolutionFromProto(solver_response));
         ... inspect the solution using the usual API: solution_value(), etc...
       }
    }<br>
   * <br>
   * The response must be in OPTIMAL or FEASIBLE status.<br>
   * <br>
   * Returns a false if a problem arised (typically, if it wasn't used<br>
   *     like it should be):<br>
   * - loading a solution whose variables don't correspond to the solver's<br>
   *   current variables<br>
   * - loading a solution with a status other than OPTIMAL / FEASIBLE.<br>
   * <br>
   * Note: the objective value isn't checked. You can use VerifySolution() for<br>
   *       that.
   */
  public boolean loadSolutionFromProto(com.google.ortools.linearsolver.MPSolutionResponse response) {
    return mainJNI.MPSolver_loadSolutionFromProto(swigCPtr, this, response.toByteArray());
  }

  /**
   * Solves the given model proto and returns a response proto.
   */
  public static com.google.ortools.linearsolver.MPSolutionResponse solveWithProto(com.google.ortools.linearsolver.MPModelRequest model_request) {
  byte[] buf = mainJNI.MPSolver_solveWithProto(model_request.toByteArray());
  if (buf == null || buf.length == 0) {
    return null;
  }
  try {
    return com.google.ortools.linearsolver.MPSolutionResponse.parseFrom(buf);
  } catch (com.google.protobuf.InvalidProtocolBufferException e) {
    throw new RuntimeException(
        "Unable to parse com.google.ortools.linearsolver.MPSolutionResponse protocol message.");
  }
}

  /**
   * Export the loaded model in LP format.
   */
  public String exportModelAsLpFormat(boolean obfuscate) {
    return mainJNI.MPSolver_exportModelAsLpFormat__SWIG_0(swigCPtr, this, obfuscate);
  }

  /**
   * Export the loaded model in LP format.
   */
  public String exportModelAsLpFormat() {
    return mainJNI.MPSolver_exportModelAsLpFormat__SWIG_1(swigCPtr, this);
  }

  /**
   * Export the loaded model in MPS format.
   */
  public String exportModelAsMpsFormat(boolean fixed_format, boolean obfuscate) {
    return mainJNI.MPSolver_exportModelAsMpsFormat(swigCPtr, this, fixed_format, obfuscate);
  }

  /**
   * Write the loaded model to file in MPS format.
   */
  public boolean writeModelToMpsFile(String filename, boolean fixed_format, boolean obfuscate) {
    return mainJNI.MPSolver_writeModelToMpsFile(swigCPtr, this, filename, fixed_format, obfuscate);
  }

  /**
   * Sets a hint for solution.<br>
   * <br>
   * If a feasible or almost-feasible solution to the problem is already known,<br>
   * it may be helpful to pass it to the solver so that it can be used. A<br>
   * solver that supports this feature will try to use this information to<br>
   * create its initial feasible solution.<br>
   * <br>
   * Note that it may not always be faster to give a hint like this to the<br>
   * solver. There is also no guarantee that the solver will use this hint or<br>
   * try to return a solution "close" to this assignment in case of multiple<br>
   * optimal solutions.
   */
  public void setHint(MPVariable[] variables, double[] values) {
    mainJNI.MPSolver_setHint(swigCPtr, this, variables, values);
  }

  /**
   * Sets the number of threads to be used by the solver.
   */
  public boolean setNumThreads(int num_theads) {
    return mainJNI.MPSolver_setNumThreads(swigCPtr, this, num_theads);
  }

  /**
   * The type of problems (LP or MIP) that will be solved and the underlying<br>
   *  solver (GLOP, GLPK, CLP, CBC or SCIP) that will solve them. This must<br>
   * remain consistent with MPModelRequest::OptimizationProblemType<br>
   *  (take particular care of the open-source version).
   */
  public enum OptimizationProblemType {
    CLP_LINEAR_PROGRAMMING(mainJNI.MPSolver_CLP_LINEAR_PROGRAMMING_get()),
    GLPK_LINEAR_PROGRAMMING(mainJNI.MPSolver_GLPK_LINEAR_PROGRAMMING_get()),
    GLOP_LINEAR_PROGRAMMING(mainJNI.MPSolver_GLOP_LINEAR_PROGRAMMING_get()),
    PDLP_LINEAR_PROGRAMMING(mainJNI.MPSolver_PDLP_LINEAR_PROGRAMMING_get()),
    SCIP_MIXED_INTEGER_PROGRAMMING(mainJNI.MPSolver_SCIP_MIXED_INTEGER_PROGRAMMING_get()),
    GLPK_MIXED_INTEGER_PROGRAMMING(mainJNI.MPSolver_GLPK_MIXED_INTEGER_PROGRAMMING_get()),
    CBC_MIXED_INTEGER_PROGRAMMING(mainJNI.MPSolver_CBC_MIXED_INTEGER_PROGRAMMING_get()),
    BOP_INTEGER_PROGRAMMING(mainJNI.MPSolver_BOP_INTEGER_PROGRAMMING_get()),
    SAT_INTEGER_PROGRAMMING(mainJNI.MPSolver_SAT_INTEGER_PROGRAMMING_get()),
    GUROBI_LINEAR_PROGRAMMING(mainJNI.MPSolver_GUROBI_LINEAR_PROGRAMMING_get()),
    GUROBI_MIXED_INTEGER_PROGRAMMING(mainJNI.MPSolver_GUROBI_MIXED_INTEGER_PROGRAMMING_get()),
    CPLEX_LINEAR_PROGRAMMING(mainJNI.MPSolver_CPLEX_LINEAR_PROGRAMMING_get()),
    CPLEX_MIXED_INTEGER_PROGRAMMING(mainJNI.MPSolver_CPLEX_MIXED_INTEGER_PROGRAMMING_get()),
    XPRESS_LINEAR_PROGRAMMING(mainJNI.MPSolver_XPRESS_LINEAR_PROGRAMMING_get()),
    XPRESS_MIXED_INTEGER_PROGRAMMING(mainJNI.MPSolver_XPRESS_MIXED_INTEGER_PROGRAMMING_get());

    public final int swigValue() {
      return swigValue;
    }

    public static OptimizationProblemType swigToEnum(int swigValue) {
      OptimizationProblemType[] swigValues = OptimizationProblemType.class.getEnumConstants();
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (OptimizationProblemType swigEnum : swigValues)
        if (swigEnum.swigValue == swigValue)
          return swigEnum;
      throw new IllegalArgumentException("No enum " + OptimizationProblemType.class + " with value " + swigValue);
    }

    @SuppressWarnings("unused")
    private OptimizationProblemType() {
      this.swigValue = SwigNext.next++;
    }

    @SuppressWarnings("unused")
    private OptimizationProblemType(int swigValue) {
      this.swigValue = swigValue;
      SwigNext.next = swigValue+1;
    }

    @SuppressWarnings("unused")
    private OptimizationProblemType(OptimizationProblemType swigEnum) {
      this.swigValue = swigEnum.swigValue;
      SwigNext.next = this.swigValue+1;
    }

    private final int swigValue;

    private static class SwigNext {
      private static int next = 0;
    }
  }

  /**
   * The status of solving the problem. The straightforward translation to<br>
   * homonymous enum values of MPSolverResponseStatus (see<br>
   * ./linear_solver.proto) is guaranteed by ./enum_consistency_test.cc, you may<br>
   * rely on it.
   */
  public enum ResultStatus {
    /**
     *  optimal.
     */
    OPTIMAL,
    /**
     *  feasible, or stopped by limit.
     */
    FEASIBLE,
    /**
     *  proven infeasible.
     */
    INFEASIBLE,
    /**
     *  proven unbounded.
     */
    UNBOUNDED,
    /**
     *  abnormal, i.e., error of some kind.
     */
    ABNORMAL,
    /**
     *  the model is trivially invalid (NaN coefficients, etc).
     */
    MODEL_INVALID,
    /**
     *  not been solved yet.
     */
    NOT_SOLVED(mainJNI.MPSolver_NOT_SOLVED_get());

    public final int swigValue() {
      return swigValue;
    }

    public static ResultStatus swigToEnum(int swigValue) {
      ResultStatus[] swigValues = ResultStatus.class.getEnumConstants();
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (ResultStatus swigEnum : swigValues)
        if (swigEnum.swigValue == swigValue)
          return swigEnum;
      throw new IllegalArgumentException("No enum " + ResultStatus.class + " with value " + swigValue);
    }

    @SuppressWarnings("unused")
    private ResultStatus() {
      this.swigValue = SwigNext.next++;
    }

    @SuppressWarnings("unused")
    private ResultStatus(int swigValue) {
      this.swigValue = swigValue;
      SwigNext.next = swigValue+1;
    }

    @SuppressWarnings("unused")
    private ResultStatus(ResultStatus swigEnum) {
      this.swigValue = swigEnum.swigValue;
      SwigNext.next = this.swigValue+1;
    }

    private final int swigValue;

    private static class SwigNext {
      private static int next = 0;
    }
  }

  /**
   * Advanced usage: possible basis status values for a variable and the slack<br>
   * variable of a linear constraint.
   */
  public enum BasisStatus {
    FREE(mainJNI.MPSolver_FREE_get()),
    AT_LOWER_BOUND,
    AT_UPPER_BOUND,
    FIXED_VALUE,
    BASIC;

    public final int swigValue() {
      return swigValue;
    }

    public static BasisStatus swigToEnum(int swigValue) {
      BasisStatus[] swigValues = BasisStatus.class.getEnumConstants();
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (BasisStatus swigEnum : swigValues)
        if (swigEnum.swigValue == swigValue)
          return swigEnum;
      throw new IllegalArgumentException("No enum " + BasisStatus.class + " with value " + swigValue);
    }

    @SuppressWarnings("unused")
    private BasisStatus() {
      this.swigValue = SwigNext.next++;
    }

    @SuppressWarnings("unused")
    private BasisStatus(int swigValue) {
      this.swigValue = swigValue;
      SwigNext.next = swigValue+1;
    }

    @SuppressWarnings("unused")
    private BasisStatus(BasisStatus swigEnum) {
      this.swigValue = swigEnum.swigValue;
      SwigNext.next = this.swigValue+1;
    }

    private final int swigValue;

    private static class SwigNext {
      private static int next = 0;
    }
  }

}
