/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.2.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.google.ortools.util;

/**
 * We call <i>domain</i> any subset of Int64 = [kint64min, kint64max].<br>
 * <br>
 * This class can be used to represent such set efficiently as a sorted and<br>
 * non-adjacent list of intervals. This is efficient as long as the size of such<br>
 * list stays reasonable.<br>
 * <br>
 * In the comments below, the domain of *this will always be written 'D'.<br>
 * Note that all the functions are safe with respect to integer overflow.
 */
public class Domain {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  public Domain(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  public static long getCPtr(Domain obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  public static long swigRelease(Domain obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        mainJNI.delete_Domain(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
   *  By default, Domain will be empty.
   */
  public Domain() {
    this(mainJNI.new_Domain__SWIG_0(), true);
  }

  /**
   *  Constructor for the common case of a singleton domain.
   */
  public Domain(long value) {
    this(mainJNI.new_Domain__SWIG_1(value), true);
  }

  /**
   * Constructor for the common case of a single interval [left, right].<br>
   * If left &gt; right, this will result in the empty domain.
   */
  public Domain(long left, long right) {
    this(mainJNI.new_Domain__SWIG_2(left, right), true);
  }

  /**
   * Returns the full domain Int64.
   */
  public static Domain allValues() {
    return new Domain(mainJNI.Domain_allValues(), true);
  }

  /**
   * Creates a domain from the union of an unsorted list of integer values.<br>
   * Input values may be repeated, with no consequence on the output
   */
  public static Domain fromValues(long[] values) {
    return new Domain(mainJNI.Domain_fromValues(values), true);
  }

  /**
   * This method is available in Python, Java and .NET. It allows<br>
   * building a Domain object from a list of intervals (long[][] in Java and<br>
   * .NET, [[0, 2], [5], [8, 10]] in python).<br>
   * <br>
   * Note that the intervals can be defined with a single value (i.e. [5]), or<br>
   * two increasing values (i.e. [8, 10]).<br>
   * <br>
   * Invalid intervals (start &gt; end) will log a DFATAL error and will be<br>
   * ignored.
   */
  public static Domain fromIntervals(long[][] intervals) {
    return new Domain(mainJNI.Domain_fromIntervals(intervals), true);
  }

  /**
   * This method is available in Python, Java and .NET. It allows<br>
   * building a Domain object from a flattened list of intervals<br>
   * (long[] in Java and .NET, [0, 2, 5, 5, 8, 10] in python).<br>
   * <br>
   * Note that invalid intervals (start &gt; end) will log a DFATAL error and will<br>
   * be ignored.
   */
  public static Domain fromFlatIntervals(long[] flat_intervals) {
    return new Domain(mainJNI.Domain_fromFlatIntervals(flat_intervals), true);
  }

  /**
   * This method returns the flattened list of interval bounds of the domain.<br>
   * <br>
   * Thus the domain {0, 1, 2, 5, 8, 9, 10} will return [0, 2, 5, 5,<br>
   * 8, 10] (as a C++ std::vector&lt;int64_t&gt;, as a java or C# long[], as<br>
   * a python list of integers).
   */
  public long[] flattenedIntervals() {
  return mainJNI.Domain_flattenedIntervals(swigCPtr, this);
}

  /**
   * Returns true if this is the empty set.
   */
  public boolean isEmpty() {
    return mainJNI.Domain_isEmpty(swigCPtr, this);
  }

  /**
   * Returns the number of elements in the domain. It is capped at kint64max
   */
  public long size() {
    return mainJNI.Domain_size(swigCPtr, this);
  }

  /**
   * Returns the min value of the domain.<br>
   * The domain must not be empty.
   */
  public long min() {
    return mainJNI.Domain_min(swigCPtr, this);
  }

  /**
   * Returns the max value of the domain.<br>
   * The domain must not be empty.
   */
  public long max() {
    return mainJNI.Domain_max(swigCPtr, this);
  }

  /**
   * Returns true iff value is in Domain.
   */
  public boolean contains(long value) {
    return mainJNI.Domain_contains(swigCPtr, this, value);
  }

  /**
   * Returns the set Int64 ∖ D.
   */
  public Domain complement() {
    return new Domain(mainJNI.Domain_complement(swigCPtr, this), true);
  }

  /**
   * Returns {x ∈ Int64, ∃ e ∈ D, x = -e}.<br>
   * <br>
   * Note in particular that if the negation of Int64 is not Int64 but<br>
   * Int64 \ {kint64min} !!
   */
  public Domain negation() {
    return new Domain(mainJNI.Domain_negation(swigCPtr, this), true);
  }

  /**
   * Returns the intersection of D and domain.
   */
  public Domain intersectionWith(Domain domain) {
    return new Domain(mainJNI.Domain_intersectionWith(swigCPtr, this, Domain.getCPtr(domain), domain), true);
  }

  /**
   * Returns the union of D and domain.
   */
  public Domain unionWith(Domain domain) {
    return new Domain(mainJNI.Domain_unionWith(swigCPtr, this, Domain.getCPtr(domain), domain), true);
  }

  /**
   * Returns {x ∈ Int64, ∃ a ∈ D, ∃ b ∈ domain, x = a + b}.
   */
  public Domain additionWith(Domain domain) {
    return new Domain(mainJNI.Domain_additionWith(swigCPtr, this, Domain.getCPtr(domain), domain), true);
  }

  /**
   * Returns a compact string of a vector of intervals like "[1,4][6][10,20]".
   */
  public String toString() {
    return mainJNI.Domain_toString(swigCPtr, this);
  }

}
