/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools;

import com.sun.jna.Platform;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Loader {
    private static final String RESOURCE_PATH = "ortools-" + Platform.RESOURCE_PREFIX + "/";
    private static boolean loaded = false;

    private static URI getNativeResourceURI() throws IOException {
        URI resourceURI;
        ClassLoader loader = Loader.class.getClassLoader();
        URL resourceURL = loader.getResource(RESOURCE_PATH);
        Objects.requireNonNull(resourceURL, String.format("Resource %s was not found in ClassLoader %s", RESOURCE_PATH, loader));
        try {
            resourceURI = resourceURL.toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        return resourceURI;
    }

    private static Path unpackNativeResources(URI resourceURI) throws IOException {
        FileSystem fs;
        PathConsumer visitor;
        Path tempPath;
        block2: {
            tempPath = Files.createTempDirectory("ortools-java", new FileAttribute[0]);
            tempPath.toFile().deleteOnExit();
            visitor = sourcePath -> Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path newPath = tempPath.resolve(sourcePath.getParent().relativize(file).toString());
                    Files.copy(file, newPath, new CopyOption[0]);
                    newPath.toFile().deleteOnExit();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path newPath = tempPath.resolve(sourcePath.getParent().relativize(dir).toString());
                    Files.copy(dir, newPath, new CopyOption[0]);
                    newPath.toFile().deleteOnExit();
                    return FileVisitResult.CONTINUE;
                }
            });
            try {
                fs = FileSystems.newFileSystem(resourceURI, Collections.emptyMap());
            }
            catch (FileSystemAlreadyExistsException e) {
                fs = FileSystems.getFileSystem(resourceURI);
                if (fs != null) break block2;
                throw new IllegalArgumentException();
            }
        }
        Path p = fs.provider().getPath(resourceURI);
        visitor.accept(p);
        return tempPath;
    }

    public static synchronized void loadNativeLibraries() {
        if (loaded) {
            return;
        }
        try {
            System.loadLibrary("jniortools");
            loaded = true;
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                URI resourceURI = Loader.getNativeResourceURI();
                Path tempPath = Loader.unpackNativeResources(resourceURI);
                System.load(tempPath.resolve(RESOURCE_PATH).resolve(System.mapLibraryName("jniortools")).toAbsolutePath().toString());
                loaded = true;
                return;
            }
            catch (IOException | UnsatisfiedLinkError resourceURI) {
                if (Platform.RESOURCE_PREFIX.equals("win32-x86-64")) {
                    try {
                        URI resourceURI2 = Loader.getNativeResourceURI();
                        Path tempPath = Loader.unpackNativeResources(resourceURI2);
                        List<Map.Entry> dlls = Arrays.asList(new AbstractMap.SimpleEntry<String, Boolean>("zlib1", true), new AbstractMap.SimpleEntry<String, Boolean>("bz2", true), new AbstractMap.SimpleEntry<String, Boolean>("abseil_dll", true), new AbstractMap.SimpleEntry<String, Boolean>("re2", true), new AbstractMap.SimpleEntry<String, Boolean>("libutf8_validity", true), new AbstractMap.SimpleEntry<String, Boolean>("libprotobuf", true), new AbstractMap.SimpleEntry<String, Boolean>("highs", false), new AbstractMap.SimpleEntry<String, Boolean>("libscip", false), new AbstractMap.SimpleEntry<String, Boolean>("ortools", true), new AbstractMap.SimpleEntry<String, Boolean>("jniortools", true));
                        for (Map.Entry dll : dlls) {
                            try {
                                System.load(tempPath.resolve(RESOURCE_PATH).resolve(System.mapLibraryName((String)dll.getKey())).toAbsolutePath().toString());
                            }
                            catch (UnsatisfiedLinkError e) {
                                System.out.println("System.load(" + (String)dll.getKey() + ") failed!");
                                if (!((Boolean)dll.getValue()).booleanValue()) continue;
                                throw new RuntimeException(e);
                            }
                        }
                        loaded = true;
                        return;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
        }
    }

    @FunctionalInterface
    private static interface PathConsumer<T extends IOException> {
        public void accept(Path var1) throws T;
    }
}

