/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.modelbuilder;

import com.google.ortools.modelbuilder.ModelBuilderHelper;
import com.google.ortools.modelbuilder.Variable;

public class LinearConstraint {
    private final ModelBuilderHelper helper;
    private final int index;

    public LinearConstraint(ModelBuilderHelper helper) {
        this.helper = helper;
        this.index = helper.addLinearConstraint();
    }

    LinearConstraint(ModelBuilderHelper helper, int index) {
        this.helper = helper;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public ModelBuilderHelper getHelper() {
        return this.helper;
    }

    public double getLowerBound() {
        return this.helper.getConstraintLowerBound(this.index);
    }

    public void setLowerBound(double lb) {
        this.helper.setConstraintLowerBound(this.index, lb);
    }

    public double getUpperBound() {
        return this.helper.getConstraintUpperBound(this.index);
    }

    public void setUpperBound(double ub) {
        this.helper.setConstraintUpperBound(this.index, ub);
    }

    public String getName() {
        return this.helper.getConstraintName(this.index);
    }

    public void setName(String name) {
        this.helper.setConstraintName(this.index, name);
    }

    public void addTerm(Variable v, double coeff) {
        this.helper.addConstraintTerm(this.index, v.getIndex(), coeff);
    }

    public void setCoefficient(Variable v, double coeff) {
        this.helper.setConstraintCoefficient(this.index, v.getIndex(), coeff);
    }

    public void clearTerms() {
        this.helper.clearConstraintTerms(this.index);
    }

    public LinearConstraint withName(String name) {
        this.setName(name);
        return this;
    }
}

