/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.sat;

import com.google.ortools.sat.Constraint;
import com.google.ortools.sat.CpModel;
import com.google.ortools.sat.CpModelProto;
import com.google.ortools.sat.TableConstraintProto;

public class TableConstraint
extends Constraint {
    public TableConstraint(CpModelProto.Builder builder) {
        super(builder);
    }

    public TableConstraint addTuple(int[] tuple) {
        TableConstraintProto.Builder table = this.getBuilder().getTableBuilder();
        if (tuple.length != table.getExprsCount()) {
            throw new CpModel.WrongLength("addTuple", "tuple does not have the same length as the expressions");
        }
        for (int value : tuple) {
            table.addValues(value);
        }
        return this;
    }

    public TableConstraint addTuple(long[] tuple) {
        TableConstraintProto.Builder table = this.getBuilder().getTableBuilder();
        if (tuple.length != table.getExprsCount()) {
            throw new CpModel.WrongLength("addTuple", "tuple does not have the same length as the expressions");
        }
        for (long value : tuple) {
            table.addValues(value);
        }
        return this;
    }

    public TableConstraint addTuples(int[][] tuples) {
        TableConstraintProto.Builder table = this.getBuilder().getTableBuilder();
        for (int[] tuple : tuples) {
            if (tuple.length != table.getExprsCount()) {
                throw new CpModel.WrongLength("addTuples", "a tuple does not have the same length as the expressions");
            }
            for (int value : tuple) {
                table.addValues(value);
            }
        }
        return this;
    }

    public TableConstraint addTuples(long[][] tuples) {
        TableConstraintProto.Builder table = this.getBuilder().getTableBuilder();
        for (long[] tuple : tuples) {
            if (tuple.length != table.getExprsCount()) {
                throw new CpModel.WrongLength("addTuples", "a tuple does not have the same length as the variables");
            }
            for (long value : tuple) {
                table.addValues(value);
            }
        }
        return this;
    }
}

