/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.util;

import com.google.ortools.util.mainJNI;

public class Domain {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    public Domain(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(Domain obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public static long swigRelease(Domain obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_Domain(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public Domain() {
        this(mainJNI.new_Domain__SWIG_0(), true);
    }

    public Domain(long value) {
        this(mainJNI.new_Domain__SWIG_1(value), true);
    }

    public Domain(long left, long right) {
        this(mainJNI.new_Domain__SWIG_2(left, right), true);
    }

    public static Domain allValues() {
        return new Domain(mainJNI.Domain_allValues(), true);
    }

    public static Domain fromValues(long[] values) {
        return new Domain(mainJNI.Domain_fromValues(values), true);
    }

    public static Domain fromIntervals(long[][] intervals) {
        return new Domain(mainJNI.Domain_fromIntervals(intervals), true);
    }

    public static Domain fromFlatIntervals(long[] flat_intervals) {
        return new Domain(mainJNI.Domain_fromFlatIntervals(flat_intervals), true);
    }

    public long[] flattenedIntervals() {
        return mainJNI.Domain_flattenedIntervals(this.swigCPtr, this);
    }

    public boolean isEmpty() {
        return mainJNI.Domain_isEmpty(this.swigCPtr, this);
    }

    public long size() {
        return mainJNI.Domain_size(this.swigCPtr, this);
    }

    public long min() {
        return mainJNI.Domain_min(this.swigCPtr, this);
    }

    public long max() {
        return mainJNI.Domain_max(this.swigCPtr, this);
    }

    public boolean contains(long value) {
        return mainJNI.Domain_contains(this.swigCPtr, this, value);
    }

    public Domain complement() {
        return new Domain(mainJNI.Domain_complement(this.swigCPtr, this), true);
    }

    public Domain negation() {
        return new Domain(mainJNI.Domain_negation(this.swigCPtr, this), true);
    }

    public Domain intersectionWith(Domain domain) {
        return new Domain(mainJNI.Domain_intersectionWith(this.swigCPtr, this, Domain.getCPtr(domain), domain), true);
    }

    public Domain unionWith(Domain domain) {
        return new Domain(mainJNI.Domain_unionWith(this.swigCPtr, this, Domain.getCPtr(domain), domain), true);
    }

    public Domain additionWith(Domain domain) {
        return new Domain(mainJNI.Domain_additionWith(this.swigCPtr, this, Domain.getCPtr(domain), domain), true);
    }

    public String toString() {
        return mainJNI.Domain_toString(this.swigCPtr, this);
    }
}

