/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.constraintsolver;

import com.google.ortools.constraintsolver.mainJNI;

public class BaseObject {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected BaseObject(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(BaseObject obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(BaseObject obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_BaseObject(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public BaseObject() {
        this(mainJNI.new_BaseObject(), true);
    }

    public String toString() {
        return mainJNI.BaseObject_toString(this.swigCPtr, this);
    }
}

