/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.1.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.google.ortools.algorithms;

/**
 *  This library solves knapsack problems.<br>
 * <br>
 *  Problems the library solves include:<br>
 *   - 0-1 knapsack problems,<br>
 *   - Multi-dimensional knapsack problems,<br>
 * <br>
 * Given n items, each with a profit and a weight, given a knapsack of<br>
 * capacity c, the goal is to find a subset of items which fits inside c<br>
 * and maximizes the total profit.<br>
 * The knapsack problem can easily be extended from 1 to d dimensions.<br>
 * As an example, this can be useful to constrain the maximum number of<br>
 * items inside the knapsack.<br>
 * Without loss of generality, profits and weights are assumed to be positive.<br>
 * <br>
 * From a mathematical point of view, the multi-dimensional knapsack problem<br>
 * can be modeled by d linear constraints:<br>
 * <br>
 *     ForEach(j:1..d)(Sum(i:1..n)(weight_ij * item_i) &lt;= c_j<br>
 *         where item_i is a 0-1 integer variable.<br>
 * <br>
 * Then the goal is to maximize:<br>
 * <br>
 *     Sum(i:1..n)(profit_i * item_i).<br>
 * <br>
 * There are several ways to solve knapsack problems. One of the most<br>
 * efficient is based on dynamic programming (mainly when weights, profits<br>
 * and dimensions are small, and the algorithm runs in pseudo polynomial time).<br>
 * Unfortunately, when adding conflict constraints the problem becomes strongly<br>
 * NP-hard, i.e. there is no pseudo-polynomial algorithm to solve it.<br>
 * That's the reason why the most of the following code is based on branch and<br>
 * bound search.<br>
 * <br>
 * For instance to solve a 2-dimensional knapsack problem with 9 items,<br>
 * one just has to feed a profit vector with the 9 profits, a vector of 2<br>
 * vectors for weights, and a vector of capacities.<br>
 * E.g.:<br>
 * <br>
 *   <b>Python</b>:<br>
 *   {@code 
      profits = [ 1, 2, 3, 4, 5, 6, 7, 8, 9 ]
      weights = [ [ 1, 2, 3, 4, 5, 6, 7, 8, 9 ],
                  [ 1, 1, 1, 1, 1, 1, 1, 1, 1 ]
                ]
      capacities = [ 34, 4 ]

      solver = knapsack_solver.KnapsackSolver(
          knapsack_solver.SolverType
              .KNAPSACK_MULTIDIMENSION_BRANCH_AND_BOUND_SOLVER,
          'Multi-dimensional solver')
      solver.init(profits, weights, capacities)
      profit = solver.solve()
  }<br>
 * <br>
 *   <b>C++</b>:<br>
 *   {@code 
     const std::vector<int64_t> profits = { 1, 2, 3, 4, 5, 6, 7, 8, 9 };
     const std::vector<std::vector<int64_t>> weights =
         { { 1, 2, 3, 4, 5, 6, 7, 8, 9 },
           { 1, 1, 1, 1, 1, 1, 1, 1, 1 } };
     const std::vector<int64_t> capacities = { 34, 4 };

     KnapsackSolver solver(
         KnapsackSolver::KNAPSACK_MULTIDIMENSION_BRANCH_AND_BOUND_SOLVER,
         "Multi-dimensional solver");
     solver.Init(profits, weights, capacities);
     const int64_t profit = solver.Solve();
  }<br>
 * <br>
 *   <b>Java</b>:<br>
 *   {@code 
    final long[] profits = { 1, 2, 3, 4, 5, 6, 7, 8, 9 };
    final long[][] weights = { { 1, 2, 3, 4, 5, 6, 7, 8, 9 },
           { 1, 1, 1, 1, 1, 1, 1, 1, 1 } };
    final long[] capacities = { 34, 4 };

    KnapsackSolver solver = new KnapsackSolver(
        KnapsackSolver.SolverType.KNAPSACK_MULTIDIMENSION_BRANCH_AND_BOUND_SOLVER,
        "Multi-dimensional solver");
    solver.init(profits, weights, capacities);
    final long profit = solver.solve();
  }
 */
public class KnapsackSolver {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected KnapsackSolver(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(KnapsackSolver obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(KnapsackSolver obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        mainJNI.delete_KnapsackSolver(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  public KnapsackSolver(String solver_name) {
    this(mainJNI.new_KnapsackSolver__SWIG_0(solver_name), true);
  }

  public KnapsackSolver(KnapsackSolver.SolverType solver_type, String solver_name) {
    this(mainJNI.new_KnapsackSolver__SWIG_1(solver_type.swigValue(), solver_name), true);
  }

  /**
   * Initializes the solver and enters the problem to be solved.
   */
  public void init(long[] profits, long[][] weights, long[] capacities) {
    mainJNI.KnapsackSolver_init(swigCPtr, this, profits, weights, capacities);
  }

  /**
   * Solves the problem and returns the profit of the optimal solution.
   */
  public long solve() {
    return mainJNI.KnapsackSolver_solve(swigCPtr, this);
  }

  /**
   * Returns true if the item 'item_id' is packed in the optimal knapsack.
   */
  public boolean bestSolutionContains(int item_id) {
    return mainJNI.KnapsackSolver_bestSolutionContains(swigCPtr, this, item_id);
  }

  /**
   * Returns true if the solution was proven optimal.
   */
  public boolean isSolutionOptimal() {
    return mainJNI.KnapsackSolver_isSolutionOptimal(swigCPtr, this);
  }

  public String getName() {
    return mainJNI.KnapsackSolver_getName(swigCPtr, this);
  }

  public boolean useReduction() {
    return mainJNI.KnapsackSolver_useReduction(swigCPtr, this);
  }

  public void setUseReduction(boolean use_reduction) {
    mainJNI.KnapsackSolver_setUseReduction(swigCPtr, this, use_reduction);
  }

  /**
   *  Time limit in seconds.<br>
   * <br>
   * When a finite time limit is set the solution obtained might not be optimal<br>
   * if the limit is reached.
   */
  public void setTimeLimit(double time_limit_seconds) {
    mainJNI.KnapsackSolver_setTimeLimit(swigCPtr, this, time_limit_seconds);
  }

  /**
   *  Enum controlling which underlying algorithm is used.<br>
   * <br>
   * This enum is passed to the constructor of the KnapsackSolver object.<br>
   * It selects which solving method will be used.
   */
  public enum SolverType {
    /**
     *  Brute force method.<br>
     * <br>
     * Limited to 30 items and one dimension, this<br>
     * solver uses a brute force algorithm, ie. explores all possible states.<br>
     * Experiments show competitive performance for instances with less than<br>
     * 15 items. 
     */
    KNAPSACK_BRUTE_FORCE_SOLVER(mainJNI.KnapsackSolver_KNAPSACK_BRUTE_FORCE_SOLVER_get()),
    /**
     *  Optimized method for single dimension small problems<br>
     * <br>
     * Limited to 64 items and one dimension, this<br>
     * solver uses a branch &amp; bound algorithm. This solver is about 4 times<br>
     * faster than KNAPSACK_MULTIDIMENSION_BRANCH_AND_BOUND_SOLVER.
     */
    KNAPSACK_64ITEMS_SOLVER(mainJNI.KnapsackSolver_KNAPSACK_64ITEMS_SOLVER_get()),
    /**
     *  Dynamic Programming approach for single dimension problems<br>
     * <br>
     * Limited to one dimension, this solver is based on a dynamic programming<br>
     * algorithm. The time and space complexity is O(capacity *<br>
     * number_of_items).
     */
    KNAPSACK_DYNAMIC_PROGRAMMING_SOLVER(mainJNI.KnapsackSolver_KNAPSACK_DYNAMIC_PROGRAMMING_SOLVER_get()),
    /**
     *  CBC Based Solver<br>
     * <br>
     *  This solver can deal with both large number of items and several<br>
     * dimensions. This solver is based on Integer Programming solver CBC.
     */
    KNAPSACK_MULTIDIMENSION_CBC_MIP_SOLVER(mainJNI.KnapsackSolver_KNAPSACK_MULTIDIMENSION_CBC_MIP_SOLVER_get()),
    /**
     *  Generic Solver.<br>
     * <br>
     * This solver can deal with both large number of items and several<br>
     * dimensions. This solver is based on branch and bound.
     */
    KNAPSACK_MULTIDIMENSION_BRANCH_AND_BOUND_SOLVER(mainJNI.KnapsackSolver_KNAPSACK_MULTIDIMENSION_BRANCH_AND_BOUND_SOLVER_get()),
    /**
     *  Divide and Conquer approach for single dimension problems<br>
     * <br>
     * Limited to one dimension, this solver is based on a divide and conquer<br>
     * technique and is suitable for larger problems than Dynamic Programming<br>
     * Solver. The time complexity is O(capacity * number_of_items) and the<br>
     * space complexity is O(capacity + number_of_items).
     */
    KNAPSACK_DIVIDE_AND_CONQUER_SOLVER(mainJNI.KnapsackSolver_KNAPSACK_DIVIDE_AND_CONQUER_SOLVER_get());

    public final int swigValue() {
      return swigValue;
    }

    public static SolverType swigToEnum(int swigValue) {
      SolverType[] swigValues = SolverType.class.getEnumConstants();
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (SolverType swigEnum : swigValues)
        if (swigEnum.swigValue == swigValue)
          return swigEnum;
      throw new IllegalArgumentException("No enum " + SolverType.class + " with value " + swigValue);
    }

    @SuppressWarnings("unused")
    private SolverType() {
      this.swigValue = SwigNext.next++;
    }

    @SuppressWarnings("unused")
    private SolverType(int swigValue) {
      this.swigValue = swigValue;
      SwigNext.next = swigValue+1;
    }

    @SuppressWarnings("unused")
    private SolverType(SolverType swigEnum) {
      this.swigValue = swigEnum.swigValue;
      SwigNext.next = this.swigValue+1;
    }

    private final int swigValue;

    private static class SwigNext {
      private static int next = 0;
    }
  }

}
